# Format Tables and Format Emulation

## Overrides and Fallbacks

The [required Vulkan format support][VulkanRequiredSupport] tables do not implement the full set of
formats needed for OpenGL conformance with extensions. ANGLE emulates missing formats using *format
overrides* and *format fallbacks*.

An *override* implements a missing GL format with a required format in all cases. For example, the
luminance texture format `L8_UNORM` does not exist in Vulkan. We override `L8_UNORM` with the
required image format `R8_UNORM`.

A *fallback* is one or more non-required formats ANGLE checks for support at runtime. For example,
`R8_UNORM` is not a required vertex buffer format. Some drivers do support `R8_UNORM` for vertex
buffers. So at runtime we check for sampled image support and fall back to `R32_FLOAT` if `R8_UNORM`
is not supported.

## The Vulkan Format Table

Overrides and fallbacks are implemented in ANGLE's [Vulkan format table][../vk_format_table_autogen.cpp].
The table is auto-generated by [`gen_vk_format_table.py`](../gen_vk_format_table.py). We store the mapping from
[`angle::Format::ID`](../../FormatID_autogen.h) to [VkFormat][VkFormat] in
[`vk_format_map.json`](../vk_format_map.json). The format map also lists the overrides and fallbacks.
To update the tables please modify the format map JSON and then run
[`scripts/run_code_generation.py`][RunCodeGeneration].

The [`vk::Format`](../vk_format_utils.h) class describes the information ANGLE needs for a particular
`VkFormat`. The 'intended' format ID is a reference to the front-end format. The 'actual Image' and
'actual Buffer' formats are the native Vulkan formats that implement a particular front-end format
for `VkImages` and `VkBuffers`. For the above example of `R8_UNORM` overriding `L8_UNORM`,
`L8_UNORM` is the intended format and `R8_UNORM` is the actual Image format.

For more information please see the source files.

[VulkanRequiredSupport]: https://renderdoc.org/vkspec_chunked/chap37.html#features-required-format-support
[VkFormat]: https://renderdoc.org/vkspec_chunked/chap37.html#VkFormat
[RunCodeGeneration]: ../../../../scripts/run_code_generation.py
