Contributing to psutil project
==============================

Issues
------

* The issue tracker is for reporting problems or proposing enhancements related
  to the **program code**.
* Please do not open issues **asking for support**. Instead, use the forum at:
  https://groups.google.com/g/psutil.
* Before submitting a new issue, **search** if there are existing issues for
  the same topic.
* **Be clear** in describing what the problem is and try to be accurate in
  editing the default issue **template**. There is a bot which automatically
  assigns **labels** based on issue's title and body format. Labels help
  keeping the issues properly organized and searchable (by OS, issue type, etc.).
* When reporting a malfunction, consider enabling
  [debug mode](https://psutil.readthedocs.io/en/latest/#debug-mode) first.
* To report a **security vulnerability**, use the
  [Tidelift security contact](https://tidelift.com/security).
  Tidelift will coordinate the fix and the disclosure of the reported problem.

Pull Requests
-------------

* The PR system is for fixing bugs or make enhancements related to the
  **program code**.
* If you wish to implement a new feature or add support for a new platform it's
  better to **discuss it first**, either on the issue tracker, the forum or via
  private email.
* In order to get acquainted with the code base and tooling, take a look at the
  **[Development Guide](https://github.com/giampaolo/psutil/blob/master/docs/DEVGUIDE.rst)**.
* If you can, remember to update
  [HISTORY.rst](https://github.com/giampaolo/psutil/blob/master/HISTORY.rst)
  and [CREDITS](https://github.com/giampaolo/psutil/blob/master/CREDITS) file.
