/*
 * Authentication tests for the pam-krb5 module with an incorrect AUTHTOK.
 *
 * This test case includes tests that require Kerberos to be configured and a
 * username and password available and that run with an incorrect AUTHTOK
 * already set.  They test various prompting fallback cases.  They don't write
 * a ticket cache (which requires additional work to test the cache
 * ownership).
 *
 * Written by Russ Allbery <rra@stanford.edu>
 * Copyright 2011, 2012
 *     The Board of Trustees of the Leland Stanford Junior University
 *
 * See LICENSE for licensing terms.
 */

#include <config.h>
#include <portable/system.h>

#include <tests/fakepam/script.h>
#include <tests/tap/kerberos.h>
#include <tests/tap/process.h>
#include <tests/tap/string.h>


int
main(void)
{
    struct script_config config;
    struct kerberos_config *krbconf;

    /* Load the Kerberos principal and password from a file. */
    krbconf = kerberos_setup(TAP_KRB_NEEDS_PASSWORD);
    memset(&config, 0, sizeof(config));
    config.user = krbconf->userprinc;
    config.password = krbconf->password;

    /* Set the authtok to something bogus. */
    config.authtok = "BAD PASSWORD THAT WILL NOT WORK";

    /*
     * Generate a testing krb5.conf file with a nonexistent default realm so
     * that we can be sure that our principals will stay fully-qualified in
     * the logs.
     */
    kerberos_generate_conf("bogus.example.com");

    plan_lazy();
    run_script_dir("data/scripts/bad-authtok", &config);

    return 0;
}
