
/* autogenerated from gstadderorc.orc */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <glib.h>

#ifndef _ORC_INTEGER_TYPEDEFS_
#define _ORC_INTEGER_TYPEDEFS_
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#include <stdint.h>
typedef int8_t orc_int8;
typedef int16_t orc_int16;
typedef int32_t orc_int32;
typedef int64_t orc_int64;
typedef uint8_t orc_uint8;
typedef uint16_t orc_uint16;
typedef uint32_t orc_uint32;
typedef uint64_t orc_uint64;
#define ORC_UINT64_C(x) UINT64_C(x)
#elif defined(_MSC_VER)
typedef signed __int8 orc_int8;
typedef signed __int16 orc_int16;
typedef signed __int32 orc_int32;
typedef signed __int64 orc_int64;
typedef unsigned __int8 orc_uint8;
typedef unsigned __int16 orc_uint16;
typedef unsigned __int32 orc_uint32;
typedef unsigned __int64 orc_uint64;
#define ORC_UINT64_C(x) (x##Ui64)
#define inline __inline
#else
#include <limits.h>
typedef signed char orc_int8;
typedef short orc_int16;
typedef int orc_int32;
typedef unsigned char orc_uint8;
typedef unsigned short orc_uint16;
typedef unsigned int orc_uint32;
#if INT_MAX == LONG_MAX
typedef long long orc_int64;
typedef unsigned long long orc_uint64;
#define ORC_UINT64_C(x) (x##ULL)
#else
typedef long orc_int64;
typedef unsigned long orc_uint64;
#define ORC_UINT64_C(x) (x##UL)
#endif
#endif
typedef union
{
  orc_int16 i;
  orc_int8 x2[2];
} orc_union16;
typedef union
{
  orc_int32 i;
  float f;
  orc_int16 x2[2];
  orc_int8 x4[4];
} orc_union32;
typedef union
{
  orc_int64 i;
  double f;
  orc_int32 x2[2];
  float x2f[2];
  orc_int16 x4[4];
} orc_union64;
#endif
#ifndef ORC_RESTRICT
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#define ORC_RESTRICT restrict
#elif defined(__GNUC__) && __GNUC__ >= 4
#define ORC_RESTRICT __restrict__
#else
#define ORC_RESTRICT
#endif
#endif

#ifndef ORC_INTERNAL
#if defined(__SUNPRO_C) && (__SUNPRO_C >= 0x590)
#define ORC_INTERNAL __attribute__((visibility("hidden")))
#elif defined(__SUNPRO_C) && (__SUNPRO_C >= 0x550)
#define ORC_INTERNAL __hidden
#elif defined (__GNUC__)
#define ORC_INTERNAL __attribute__((visibility("hidden")))
#else
#define ORC_INTERNAL
#endif
#endif


#ifndef DISABLE_ORC
#include <orc/orc.h>
#endif
void adder_orc_add_s32 (gint32 * ORC_RESTRICT d1,
    const gint32 * ORC_RESTRICT s1, int n);
void adder_orc_add_s16 (gint16 * ORC_RESTRICT d1,
    const gint16 * ORC_RESTRICT s1, int n);
void adder_orc_add_s8 (gint8 * ORC_RESTRICT d1, const gint8 * ORC_RESTRICT s1,
    int n);
void adder_orc_add_u32 (guint32 * ORC_RESTRICT d1,
    const guint32 * ORC_RESTRICT s1, int n);
void adder_orc_add_u16 (guint16 * ORC_RESTRICT d1,
    const guint16 * ORC_RESTRICT s1, int n);
void adder_orc_add_u8 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n);
void adder_orc_add_f32 (float *ORC_RESTRICT d1, const float *ORC_RESTRICT s1,
    int n);
void adder_orc_add_f64 (double *ORC_RESTRICT d1, const double *ORC_RESTRICT s1,
    int n);
void adder_orc_volume_u8 (guint8 * ORC_RESTRICT d1, int p1, int n);
void adder_orc_volume_s8 (gint8 * ORC_RESTRICT d1, int p1, int n);
void adder_orc_volume_u16 (guint16 * ORC_RESTRICT d1, int p1, int n);
void adder_orc_volume_s16 (gint16 * ORC_RESTRICT d1, int p1, int n);
void adder_orc_volume_u32 (guint32 * ORC_RESTRICT d1, int p1, int n);
void adder_orc_volume_s32 (gint32 * ORC_RESTRICT d1, int p1, int n);
void adder_orc_volume_f32 (float *ORC_RESTRICT d1, float p1, int n);
void adder_orc_volume_f64 (double *ORC_RESTRICT d1, double p1, int n);
void adder_orc_add_volume_u8 (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int p1, int n);
void adder_orc_add_volume_s8 (gint8 * ORC_RESTRICT d1,
    const gint8 * ORC_RESTRICT s1, int p1, int n);
void adder_orc_add_volume_u16 (guint16 * ORC_RESTRICT d1,
    const guint16 * ORC_RESTRICT s1, int p1, int n);
void adder_orc_add_volume_s16 (gint16 * ORC_RESTRICT d1,
    const gint16 * ORC_RESTRICT s1, int p1, int n);
void adder_orc_add_volume_u32 (guint32 * ORC_RESTRICT d1,
    const guint32 * ORC_RESTRICT s1, int p1, int n);
void adder_orc_add_volume_s32 (gint32 * ORC_RESTRICT d1,
    const gint32 * ORC_RESTRICT s1, int p1, int n);
void adder_orc_add_volume_f32 (float *ORC_RESTRICT d1,
    const float *ORC_RESTRICT s1, float p1, int n);
void adder_orc_add_volume_f64 (double *ORC_RESTRICT d1,
    const double *ORC_RESTRICT s1, double p1, int n);


/* begin Orc C target preamble */
#define ORC_CLAMP(x,a,b) ((x)<(a) ? (a) : ((x)>(b) ? (b) : (x)))
#define ORC_ABS(a) ((a)<0 ? -(a) : (a))
#define ORC_MIN(a,b) ((a)<(b) ? (a) : (b))
#define ORC_MAX(a,b) ((a)>(b) ? (a) : (b))
#define ORC_SB_MAX 127
#define ORC_SB_MIN (-1-ORC_SB_MAX)
#define ORC_UB_MAX 255
#define ORC_UB_MIN 0
#define ORC_SW_MAX 32767
#define ORC_SW_MIN (-1-ORC_SW_MAX)
#define ORC_UW_MAX 65535
#define ORC_UW_MIN 0
#define ORC_SL_MAX 2147483647
#define ORC_SL_MIN (-1-ORC_SL_MAX)
#define ORC_UL_MAX 4294967295U
#define ORC_UL_MIN 0
#define ORC_CLAMP_SB(x) ORC_CLAMP(x,ORC_SB_MIN,ORC_SB_MAX)
#define ORC_CLAMP_UB(x) ORC_CLAMP(x,ORC_UB_MIN,ORC_UB_MAX)
#define ORC_CLAMP_SW(x) ORC_CLAMP(x,ORC_SW_MIN,ORC_SW_MAX)
#define ORC_CLAMP_UW(x) ORC_CLAMP(x,ORC_UW_MIN,ORC_UW_MAX)
#define ORC_CLAMP_SL(x) ORC_CLAMP(x,ORC_SL_MIN,ORC_SL_MAX)
#define ORC_CLAMP_UL(x) ORC_CLAMP(x,ORC_UL_MIN,ORC_UL_MAX)
#define ORC_SWAP_W(x) ((((x)&0xff)<<8) | (((x)&0xff00)>>8))
#define ORC_SWAP_L(x) ((((x)&0xff)<<24) | (((x)&0xff00)<<8) | (((x)&0xff0000)>>8) | (((x)&0xff000000)>>24))
#define ORC_SWAP_Q(x) ((((x)&ORC_UINT64_C(0xff))<<56) | (((x)&ORC_UINT64_C(0xff00))<<40) | (((x)&ORC_UINT64_C(0xff0000))<<24) | (((x)&ORC_UINT64_C(0xff000000))<<8) | (((x)&ORC_UINT64_C(0xff00000000))>>8) | (((x)&ORC_UINT64_C(0xff0000000000))>>24) | (((x)&ORC_UINT64_C(0xff000000000000))>>40) | (((x)&ORC_UINT64_C(0xff00000000000000))>>56))
#define ORC_PTR_OFFSET(ptr,offset) ((void *)(((unsigned char *)(ptr)) + (offset)))
#define ORC_DENORMAL(x) ((x) & ((((x)&0x7f800000) == 0) ? 0xff800000 : 0xffffffff))
#define ORC_ISNAN(x) ((((x)&0x7f800000) == 0x7f800000) && (((x)&0x007fffff) != 0))
#define ORC_DENORMAL_DOUBLE(x) ((x) & ((((x)&ORC_UINT64_C(0x7ff0000000000000)) == 0) ? ORC_UINT64_C(0xfff0000000000000) : ORC_UINT64_C(0xffffffffffffffff)))
#define ORC_ISNAN_DOUBLE(x) ((((x)&ORC_UINT64_C(0x7ff0000000000000)) == ORC_UINT64_C(0x7ff0000000000000)) && (((x)&ORC_UINT64_C(0x000fffffffffffff)) != 0))
#ifndef ORC_RESTRICT
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#define ORC_RESTRICT restrict
#elif defined(__GNUC__) && __GNUC__ >= 4
#define ORC_RESTRICT __restrict__
#else
#define ORC_RESTRICT
#endif
#endif
/* end Orc C target preamble */



/* adder_orc_add_s32 */
#ifdef DISABLE_ORC
void
adder_orc_add_s32 (gint32 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union32 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr0[i];
    /* 1: loadl */
    var33 = ptr4[i];
    /* 2: addssl */
    var34.i = ORC_CLAMP_SL ((orc_int64) var32.i + (orc_int64) var33.i);
    /* 3: storel */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_adder_orc_add_s32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr0[i];
    /* 1: loadl */
    var33 = ptr4[i];
    /* 2: addssl */
    var34.i = ORC_CLAMP_SL ((orc_int64) var32.i + (orc_int64) var33.i);
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
adder_orc_add_s32 (gint32 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 17, 97, 100, 100, 101, 114, 95, 111, 114, 99, 95, 97, 100, 100,
        95, 115, 51, 50, 11, 4, 4, 12, 4, 4, 104, 0, 0, 4, 2, 0,

      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_adder_orc_add_s32);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "adder_orc_add_s32");
      orc_program_set_backup_function (p, _backup_adder_orc_add_s32);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");

      orc_program_append_2 (p, "addssl", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_S1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* adder_orc_add_s16 */
#ifdef DISABLE_ORC
void
adder_orc_add_s16 (gint16 * ORC_RESTRICT d1, const gint16 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union16 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *) d1;
  ptr4 = (orc_union16 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr0[i];
    /* 1: loadw */
    var33 = ptr4[i];
    /* 2: addssw */
    var34.i = ORC_CLAMP_SW (var32.i + var33.i);
    /* 3: storew */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_adder_orc_add_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *) ex->arrays[0];
  ptr4 = (orc_union16 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr0[i];
    /* 1: loadw */
    var33 = ptr4[i];
    /* 2: addssw */
    var34.i = ORC_CLAMP_SW (var32.i + var33.i);
    /* 3: storew */
    ptr0[i] = var34;
  }

}

void
adder_orc_add_s16 (gint16 * ORC_RESTRICT d1, const gint16 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 17, 97, 100, 100, 101, 114, 95, 111, 114, 99, 95, 97, 100, 100,
        95, 115, 49, 54, 11, 2, 2, 12, 2, 2, 71, 0, 0, 4, 2, 0,

      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_adder_orc_add_s16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "adder_orc_add_s16");
      orc_program_set_backup_function (p, _backup_adder_orc_add_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");

      orc_program_append_2 (p, "addssw", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_S1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* adder_orc_add_s8 */
#ifdef DISABLE_ORC
void
adder_orc_add_s8 (gint8 * ORC_RESTRICT d1, const gint8 * ORC_RESTRICT s1, int n)
{
  int i;
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  ptr0 = (orc_int8 *) d1;
  ptr4 = (orc_int8 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr0[i];
    /* 1: loadb */
    var33 = ptr4[i];
    /* 2: addssb */
    var34 = ORC_CLAMP_SB (var32 + var33);
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_adder_orc_add_s8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  ptr0 = (orc_int8 *) ex->arrays[0];
  ptr4 = (orc_int8 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr0[i];
    /* 1: loadb */
    var33 = ptr4[i];
    /* 2: addssb */
    var34 = ORC_CLAMP_SB (var32 + var33);
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

void
adder_orc_add_s8 (gint8 * ORC_RESTRICT d1, const gint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 16, 97, 100, 100, 101, 114, 95, 111, 114, 99, 95, 97, 100, 100,
        95, 115, 56, 11, 1, 1, 12, 1, 1, 34, 0, 0, 4, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_adder_orc_add_s8);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "adder_orc_add_s8");
      orc_program_set_backup_function (p, _backup_adder_orc_add_s8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");

      orc_program_append_2 (p, "addssb", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_S1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* adder_orc_add_u32 */
#ifdef DISABLE_ORC
void
adder_orc_add_u32 (guint32 * ORC_RESTRICT d1, const guint32 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union32 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr0[i];
    /* 1: loadl */
    var33 = ptr4[i];
    /* 2: addusl */
    var34.i =
        ORC_CLAMP_UL ((orc_int64) (orc_uint32) var32.i +
        (orc_int64) (orc_uint32) var33.i);
    /* 3: storel */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_adder_orc_add_u32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr0[i];
    /* 1: loadl */
    var33 = ptr4[i];
    /* 2: addusl */
    var34.i =
        ORC_CLAMP_UL ((orc_int64) (orc_uint32) var32.i +
        (orc_int64) (orc_uint32) var33.i);
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
adder_orc_add_u32 (guint32 * ORC_RESTRICT d1, const guint32 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 17, 97, 100, 100, 101, 114, 95, 111, 114, 99, 95, 97, 100, 100,
        95, 117, 51, 50, 11, 4, 4, 12, 4, 4, 105, 0, 0, 4, 2, 0,

      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_adder_orc_add_u32);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "adder_orc_add_u32");
      orc_program_set_backup_function (p, _backup_adder_orc_add_u32);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");

      orc_program_append_2 (p, "addusl", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_S1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* adder_orc_add_u16 */
#ifdef DISABLE_ORC
void
adder_orc_add_u16 (guint16 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union16 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *) d1;
  ptr4 = (orc_union16 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr0[i];
    /* 1: loadw */
    var33 = ptr4[i];
    /* 2: addusw */
    var34.i = ORC_CLAMP_UW ((orc_uint16) var32.i + (orc_uint16) var33.i);
    /* 3: storew */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_adder_orc_add_u16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *) ex->arrays[0];
  ptr4 = (orc_union16 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr0[i];
    /* 1: loadw */
    var33 = ptr4[i];
    /* 2: addusw */
    var34.i = ORC_CLAMP_UW ((orc_uint16) var32.i + (orc_uint16) var33.i);
    /* 3: storew */
    ptr0[i] = var34;
  }

}

void
adder_orc_add_u16 (guint16 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 17, 97, 100, 100, 101, 114, 95, 111, 114, 99, 95, 97, 100, 100,
        95, 117, 49, 54, 11, 2, 2, 12, 2, 2, 72, 0, 0, 4, 2, 0,

      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_adder_orc_add_u16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "adder_orc_add_u16");
      orc_program_set_backup_function (p, _backup_adder_orc_add_u16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");

      orc_program_append_2 (p, "addusw", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_S1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* adder_orc_add_u8 */
#ifdef DISABLE_ORC
void
adder_orc_add_u8 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  ptr0 = (orc_int8 *) d1;
  ptr4 = (orc_int8 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr0[i];
    /* 1: loadb */
    var33 = ptr4[i];
    /* 2: addusb */
    var34 = ORC_CLAMP_UB ((orc_uint8) var32 + (orc_uint8) var33);
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_adder_orc_add_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  ptr0 = (orc_int8 *) ex->arrays[0];
  ptr4 = (orc_int8 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr0[i];
    /* 1: loadb */
    var33 = ptr4[i];
    /* 2: addusb */
    var34 = ORC_CLAMP_UB ((orc_uint8) var32 + (orc_uint8) var33);
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

void
adder_orc_add_u8 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 16, 97, 100, 100, 101, 114, 95, 111, 114, 99, 95, 97, 100, 100,
        95, 117, 56, 11, 1, 1, 12, 1, 1, 35, 0, 0, 4, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_adder_orc_add_u8);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "adder_orc_add_u8");
      orc_program_set_backup_function (p, _backup_adder_orc_add_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");

      orc_program_append_2 (p, "addusb", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_S1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* adder_orc_add_f32 */
#ifdef DISABLE_ORC
void
adder_orc_add_f32 (float *ORC_RESTRICT d1, const float *ORC_RESTRICT s1, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union32 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr0[i];
    /* 1: loadl */
    var33 = ptr4[i];
    /* 2: addf */
    {
      orc_union32 _src1;
      orc_union32 _src2;
      orc_union32 _dest1;
      _src1.i = ORC_DENORMAL (var32.i);
      _src2.i = ORC_DENORMAL (var33.i);
      _dest1.f = _src1.f + _src2.f;
      var34.i = ORC_DENORMAL (_dest1.i);
    }
    /* 3: storel */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_adder_orc_add_f32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr0[i];
    /* 1: loadl */
    var33 = ptr4[i];
    /* 2: addf */
    {
      orc_union32 _src1;
      orc_union32 _src2;
      orc_union32 _dest1;
      _src1.i = ORC_DENORMAL (var32.i);
      _src2.i = ORC_DENORMAL (var33.i);
      _dest1.f = _src1.f + _src2.f;
      var34.i = ORC_DENORMAL (_dest1.i);
    }
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
adder_orc_add_f32 (float *ORC_RESTRICT d1, const float *ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 17, 97, 100, 100, 101, 114, 95, 111, 114, 99, 95, 97, 100, 100,
        95, 102, 51, 50, 11, 4, 4, 12, 4, 4, 200, 0, 0, 4, 2, 0,

      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_adder_orc_add_f32);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "adder_orc_add_f32");
      orc_program_set_backup_function (p, _backup_adder_orc_add_f32);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");

      orc_program_append_2 (p, "addf", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_S1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* adder_orc_add_f64 */
#ifdef DISABLE_ORC
void
adder_orc_add_f64 (double *ORC_RESTRICT d1, const double *ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union64 var33;
  orc_union64 var34;

  ptr0 = (orc_union64 *) d1;
  ptr4 = (orc_union64 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr0[i];
    /* 1: loadq */
    var33 = ptr4[i];
    /* 2: addd */
    {
      orc_union64 _src1;
      orc_union64 _src2;
      orc_union64 _dest1;
      _src1.i = ORC_DENORMAL_DOUBLE (var32.i);
      _src2.i = ORC_DENORMAL_DOUBLE (var33.i);
      _dest1.f = _src1.f + _src2.f;
      var34.i = ORC_DENORMAL_DOUBLE (_dest1.i);
    }
    /* 3: storeq */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_adder_orc_add_f64 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union64 var33;
  orc_union64 var34;

  ptr0 = (orc_union64 *) ex->arrays[0];
  ptr4 = (orc_union64 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr0[i];
    /* 1: loadq */
    var33 = ptr4[i];
    /* 2: addd */
    {
      orc_union64 _src1;
      orc_union64 _src2;
      orc_union64 _dest1;
      _src1.i = ORC_DENORMAL_DOUBLE (var32.i);
      _src2.i = ORC_DENORMAL_DOUBLE (var33.i);
      _dest1.f = _src1.f + _src2.f;
      var34.i = ORC_DENORMAL_DOUBLE (_dest1.i);
    }
    /* 3: storeq */
    ptr0[i] = var34;
  }

}

void
adder_orc_add_f64 (double *ORC_RESTRICT d1, const double *ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 17, 97, 100, 100, 101, 114, 95, 111, 114, 99, 95, 97, 100, 100,
        95, 102, 54, 52, 11, 8, 8, 12, 8, 8, 212, 0, 0, 4, 2, 0,

      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_adder_orc_add_f64);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "adder_orc_add_f64");
      orc_program_set_backup_function (p, _backup_adder_orc_add_f64);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 8, "s1");

      orc_program_append_2 (p, "addd", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_S1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* adder_orc_volume_u8 */
#ifdef DISABLE_ORC
void
adder_orc_volume_u8 (guint8 * ORC_RESTRICT d1, int p1, int n)
{
  int i;
  orc_int8 *ORC_RESTRICT ptr0;
  orc_int8 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_int8 var35;
#else
  orc_int8 var35;
#endif
  orc_int8 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_int8 var37;
#else
  orc_int8 var37;
#endif
  orc_int8 var38;
  orc_int8 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_int8 var42;

  ptr0 = (orc_int8 *) d1;

  /* 1: loadpb */
  var35 = (int) 0x00000080;     /* 128 or 6.32404e-322f */
  /* 3: loadpb */
  var36 = p1;
  /* 7: loadpb */
  var37 = (int) 0x00000080;     /* 128 or 6.32404e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr0[i];
    /* 2: xorb */
    var39 = var34 ^ var35;
    /* 4: mulsbw */
    var40.i = var39 * var36;
    /* 5: shrsw */
    var41.i = var40.i >> 3;
    /* 6: convssswb */
    var42 = ORC_CLAMP_SB (var41.i);
    /* 8: xorb */
    var38 = var42 ^ var37;
    /* 9: storeb */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_adder_orc_volume_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 *ORC_RESTRICT ptr0;
  orc_int8 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_int8 var35;
#else
  orc_int8 var35;
#endif
  orc_int8 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_int8 var37;
#else
  orc_int8 var37;
#endif
  orc_int8 var38;
  orc_int8 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_int8 var42;

  ptr0 = (orc_int8 *) ex->arrays[0];

  /* 1: loadpb */
  var35 = (int) 0x00000080;     /* 128 or 6.32404e-322f */
  /* 3: loadpb */
  var36 = ex->params[24];
  /* 7: loadpb */
  var37 = (int) 0x00000080;     /* 128 or 6.32404e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr0[i];
    /* 2: xorb */
    var39 = var34 ^ var35;
    /* 4: mulsbw */
    var40.i = var39 * var36;
    /* 5: shrsw */
    var41.i = var40.i >> 3;
    /* 6: convssswb */
    var42 = ORC_CLAMP_SB (var41.i);
    /* 8: xorb */
    var38 = var42 ^ var37;
    /* 9: storeb */
    ptr0[i] = var38;
  }

}

void
adder_orc_volume_u8 (guint8 * ORC_RESTRICT d1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 19, 97, 100, 100, 101, 114, 95, 111, 114, 99, 95, 118, 111, 108,
        117, 109, 101, 95, 117, 56, 11, 1, 1, 14, 1, 128, 0, 0, 0, 14,
        4, 3, 0, 0, 0, 16, 1, 20, 2, 20, 1, 68, 33, 0, 16, 174,
        32, 33, 24, 94, 32, 32, 17, 159, 33, 32, 68, 0, 33, 16, 2, 0,

      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_adder_orc_volume_u8);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "adder_orc_volume_u8");
      orc_program_set_backup_function (p, _backup_adder_orc_volume_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_constant (p, 1, 0x00000080, "c1");
      orc_program_add_constant (p, 4, 0x00000003, "c2");
      orc_program_add_parameter (p, 1, "p1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 1, "t2");

      orc_program_append_2 (p, "xorb", 0, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mulsbw", 0, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_P1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T2, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "xorb", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_C1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* adder_orc_volume_s8 */
#ifdef DISABLE_ORC
void
adder_orc_volume_s8 (gint8 * ORC_RESTRICT d1, int p1, int n)
{
  int i;
  orc_int8 *ORC_RESTRICT ptr0;
  orc_int8 var33;
  orc_int8 var34;
  orc_int8 var35;
  orc_union16 var36;
  orc_union16 var37;

  ptr0 = (orc_int8 *) d1;

  /* 1: loadpb */
  var34 = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr0[i];
    /* 2: mulsbw */
    var36.i = var33 * var34;
    /* 3: shrsw */
    var37.i = var36.i >> 3;
    /* 4: convssswb */
    var35 = ORC_CLAMP_SB (var37.i);
    /* 5: storeb */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_adder_orc_volume_s8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 *ORC_RESTRICT ptr0;
  orc_int8 var33;
  orc_int8 var34;
  orc_int8 var35;
  orc_union16 var36;
  orc_union16 var37;

  ptr0 = (orc_int8 *) ex->arrays[0];

  /* 1: loadpb */
  var34 = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr0[i];
    /* 2: mulsbw */
    var36.i = var33 * var34;
    /* 3: shrsw */
    var37.i = var36.i >> 3;
    /* 4: convssswb */
    var35 = ORC_CLAMP_SB (var37.i);
    /* 5: storeb */
    ptr0[i] = var35;
  }

}

void
adder_orc_volume_s8 (gint8 * ORC_RESTRICT d1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 19, 97, 100, 100, 101, 114, 95, 111, 114, 99, 95, 118, 111, 108,
        117, 109, 101, 95, 115, 56, 11, 1, 1, 14, 4, 3, 0, 0, 0, 16,
        1, 20, 2, 174, 32, 0, 24, 94, 32, 32, 16, 159, 0, 32, 2, 0,

      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_adder_orc_volume_s8);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "adder_orc_volume_s8");
      orc_program_set_backup_function (p, _backup_adder_orc_volume_s8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_constant (p, 4, 0x00000003, "c1");
      orc_program_add_parameter (p, 1, "p1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "mulsbw", 0, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_P1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_D1, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* adder_orc_volume_u16 */
#ifdef DISABLE_ORC
void
adder_orc_volume_u16 (guint16 * ORC_RESTRICT d1, int p1, int n)
{
  int i;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var35;
#else
  orc_union16 var35;
#endif
  orc_union16 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_union16 var38;
  orc_union16 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union16 var42;

  ptr0 = (orc_union16 *) d1;

  /* 1: loadpw */
  var35.i = (int) 0x00008000;   /* 32768 or 1.61895e-319f */
  /* 3: loadpw */
  var36.i = p1;
  /* 7: loadpw */
  var37.i = (int) 0x00008000;   /* 32768 or 1.61895e-319f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr0[i];
    /* 2: xorw */
    var39.i = var34.i ^ var35.i;
    /* 4: mulswl */
    var40.i = var39.i * var36.i;
    /* 5: shrsl */
    var41.i = var40.i >> 11;
    /* 6: convssslw */
    var42.i = ORC_CLAMP_SW (var41.i);
    /* 8: xorw */
    var38.i = var42.i ^ var37.i;
    /* 9: storew */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_adder_orc_volume_u16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var35;
#else
  orc_union16 var35;
#endif
  orc_union16 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_union16 var38;
  orc_union16 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union16 var42;

  ptr0 = (orc_union16 *) ex->arrays[0];

  /* 1: loadpw */
  var35.i = (int) 0x00008000;   /* 32768 or 1.61895e-319f */
  /* 3: loadpw */
  var36.i = ex->params[24];
  /* 7: loadpw */
  var37.i = (int) 0x00008000;   /* 32768 or 1.61895e-319f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr0[i];
    /* 2: xorw */
    var39.i = var34.i ^ var35.i;
    /* 4: mulswl */
    var40.i = var39.i * var36.i;
    /* 5: shrsl */
    var41.i = var40.i >> 11;
    /* 6: convssslw */
    var42.i = ORC_CLAMP_SW (var41.i);
    /* 8: xorw */
    var38.i = var42.i ^ var37.i;
    /* 9: storew */
    ptr0[i] = var38;
  }

}

void
adder_orc_volume_u16 (guint16 * ORC_RESTRICT d1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 20, 97, 100, 100, 101, 114, 95, 111, 114, 99, 95, 118, 111, 108,
        117, 109, 101, 95, 117, 49, 54, 11, 2, 2, 14, 2, 0, 128, 0, 0,
        14, 4, 11, 0, 0, 0, 16, 2, 20, 4, 20, 2, 101, 33, 0, 16,
        176, 32, 33, 24, 125, 32, 32, 17, 165, 33, 32, 101, 0, 33, 16, 2,
        0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_adder_orc_volume_u16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "adder_orc_volume_u16");
      orc_program_set_backup_function (p, _backup_adder_orc_volume_u16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_constant (p, 2, 0x00008000, "c1");
      orc_program_add_constant (p, 4, 0x0000000b, "c2");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "xorw", 0, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mulswl", 0, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_P1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convssslw", 0, ORC_VAR_T2, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "xorw", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_C1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* adder_orc_volume_s16 */
#ifdef DISABLE_ORC
void
adder_orc_volume_s16 (gint16 * ORC_RESTRICT d1, int p1, int n)
{
  int i;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 var33;
  orc_union16 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union16 *) d1;

  /* 1: loadpw */
  var34.i = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr0[i];
    /* 2: mulswl */
    var36.i = var33.i * var34.i;
    /* 3: shrsl */
    var37.i = var36.i >> 11;
    /* 4: convssslw */
    var35.i = ORC_CLAMP_SW (var37.i);
    /* 5: storew */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_adder_orc_volume_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 var33;
  orc_union16 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union16 *) ex->arrays[0];

  /* 1: loadpw */
  var34.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr0[i];
    /* 2: mulswl */
    var36.i = var33.i * var34.i;
    /* 3: shrsl */
    var37.i = var36.i >> 11;
    /* 4: convssslw */
    var35.i = ORC_CLAMP_SW (var37.i);
    /* 5: storew */
    ptr0[i] = var35;
  }

}

void
adder_orc_volume_s16 (gint16 * ORC_RESTRICT d1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 20, 97, 100, 100, 101, 114, 95, 111, 114, 99, 95, 118, 111, 108,
        117, 109, 101, 95, 115, 49, 54, 11, 2, 2, 14, 4, 11, 0, 0, 0,
        16, 2, 20, 4, 176, 32, 0, 24, 125, 32, 32, 16, 165, 0, 32, 2,
        0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_adder_orc_volume_s16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "adder_orc_volume_s16");
      orc_program_set_backup_function (p, _backup_adder_orc_volume_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_constant (p, 4, 0x0000000b, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_temporary (p, 4, "t1");

      orc_program_append_2 (p, "mulswl", 0, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_P1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convssslw", 0, ORC_VAR_D1, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* adder_orc_volume_u32 */
#ifdef DISABLE_ORC
void
adder_orc_volume_u32 (guint32 * ORC_RESTRICT d1, int p1, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  orc_union32 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_union32 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union32 var37;
#else
  orc_union32 var37;
#endif
  orc_union32 var38;
  orc_union32 var39;
  orc_union64 var40;
  orc_union64 var41;
  orc_union32 var42;

  ptr0 = (orc_union32 *) d1;

  /* 1: loadpl */
  var35.i = (int) 0x80000000;   /* -2147483648 or 1.061e-314f */
  /* 3: loadpl */
  var36.i = p1;
  /* 7: loadpl */
  var37.i = (int) 0x80000000;   /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr0[i];
    /* 2: xorl */
    var39.i = var34.i ^ var35.i;
    /* 4: mulslq */
    var40.i = ((orc_int64) var39.i) * ((orc_int64) var36.i);
    /* 5: shrsq */
    var41.i = var40.i >> 27;
    /* 6: convsssql */
    var42.i = ORC_CLAMP_SL (var41.i);
    /* 8: xorl */
    var38.i = var42.i ^ var37.i;
    /* 9: storel */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_adder_orc_volume_u32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  orc_union32 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_union32 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union32 var37;
#else
  orc_union32 var37;
#endif
  orc_union32 var38;
  orc_union32 var39;
  orc_union64 var40;
  orc_union64 var41;
  orc_union32 var42;

  ptr0 = (orc_union32 *) ex->arrays[0];

  /* 1: loadpl */
  var35.i = (int) 0x80000000;   /* -2147483648 or 1.061e-314f */
  /* 3: loadpl */
  var36.i = ex->params[24];
  /* 7: loadpl */
  var37.i = (int) 0x80000000;   /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr0[i];
    /* 2: xorl */
    var39.i = var34.i ^ var35.i;
    /* 4: mulslq */
    var40.i = ((orc_int64) var39.i) * ((orc_int64) var36.i);
    /* 5: shrsq */
    var41.i = var40.i >> 27;
    /* 6: convsssql */
    var42.i = ORC_CLAMP_SL (var41.i);
    /* 8: xorl */
    var38.i = var42.i ^ var37.i;
    /* 9: storel */
    ptr0[i] = var38;
  }

}

void
adder_orc_volume_u32 (guint32 * ORC_RESTRICT d1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 20, 97, 100, 100, 101, 114, 95, 111, 114, 99, 95, 118, 111, 108,
        117, 109, 101, 95, 117, 51, 50, 11, 4, 4, 14, 4, 0, 0, 0, 128,
        14, 4, 27, 0, 0, 0, 16, 4, 20, 8, 20, 4, 132, 33, 0, 16,
        178, 32, 33, 24, 147, 32, 32, 17, 170, 33, 32, 132, 0, 33, 16, 2,
        0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_adder_orc_volume_u32);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "adder_orc_volume_u32");
      orc_program_set_backup_function (p, _backup_adder_orc_volume_u32);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_constant (p, 4, 0x80000000, "c1");
      orc_program_add_constant (p, 4, 0x0000001b, "c2");
      orc_program_add_parameter (p, 4, "p1");
      orc_program_add_temporary (p, 8, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "xorl", 0, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mulslq", 0, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_P1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsq", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convsssql", 0, ORC_VAR_T2, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "xorl", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_C1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* adder_orc_volume_s32 */
#ifdef DISABLE_ORC
void
adder_orc_volume_s32 (gint32 * ORC_RESTRICT d1, int p1, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union64 var36;
  orc_union64 var37;

  ptr0 = (orc_union32 *) d1;

  /* 1: loadpl */
  var34.i = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr0[i];
    /* 2: mulslq */
    var36.i = ((orc_int64) var33.i) * ((orc_int64) var34.i);
    /* 3: shrsq */
    var37.i = var36.i >> 27;
    /* 4: convsssql */
    var35.i = ORC_CLAMP_SL (var37.i);
    /* 5: storel */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_adder_orc_volume_s32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union64 var36;
  orc_union64 var37;

  ptr0 = (orc_union32 *) ex->arrays[0];

  /* 1: loadpl */
  var34.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr0[i];
    /* 2: mulslq */
    var36.i = ((orc_int64) var33.i) * ((orc_int64) var34.i);
    /* 3: shrsq */
    var37.i = var36.i >> 27;
    /* 4: convsssql */
    var35.i = ORC_CLAMP_SL (var37.i);
    /* 5: storel */
    ptr0[i] = var35;
  }

}

void
adder_orc_volume_s32 (gint32 * ORC_RESTRICT d1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 20, 97, 100, 100, 101, 114, 95, 111, 114, 99, 95, 118, 111, 108,
        117, 109, 101, 95, 115, 51, 50, 11, 4, 4, 14, 4, 27, 0, 0, 0,
        16, 4, 20, 8, 178, 32, 0, 24, 147, 32, 32, 16, 170, 0, 32, 2,
        0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_adder_orc_volume_s32);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "adder_orc_volume_s32");
      orc_program_set_backup_function (p, _backup_adder_orc_volume_s32);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_constant (p, 4, 0x0000001b, "c1");
      orc_program_add_parameter (p, 4, "p1");
      orc_program_add_temporary (p, 8, "t1");

      orc_program_append_2 (p, "mulslq", 0, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_P1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsq", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convsssql", 0, ORC_VAR_D1, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* adder_orc_volume_f32 */
#ifdef DISABLE_ORC
void
adder_orc_volume_f32 (float *ORC_RESTRICT d1, float p1, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *) d1;

  /* 1: loadpl */
  var33.f = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr0[i];
    /* 2: mulf */
    {
      orc_union32 _src1;
      orc_union32 _src2;
      orc_union32 _dest1;
      _src1.i = ORC_DENORMAL (var32.i);
      _src2.i = ORC_DENORMAL (var33.i);
      _dest1.f = _src1.f * _src2.f;
      var34.i = ORC_DENORMAL (_dest1.i);
    }
    /* 3: storel */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_adder_orc_volume_f32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *) ex->arrays[0];

  /* 1: loadpl */
  var33.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr0[i];
    /* 2: mulf */
    {
      orc_union32 _src1;
      orc_union32 _src2;
      orc_union32 _dest1;
      _src1.i = ORC_DENORMAL (var32.i);
      _src2.i = ORC_DENORMAL (var33.i);
      _dest1.f = _src1.f * _src2.f;
      var34.i = ORC_DENORMAL (_dest1.i);
    }
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
adder_orc_volume_f32 (float *ORC_RESTRICT d1, float p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 20, 97, 100, 100, 101, 114, 95, 111, 114, 99, 95, 118, 111, 108,
        117, 109, 101, 95, 102, 51, 50, 11, 4, 4, 17, 4, 202, 0, 0, 24,
        2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_adder_orc_volume_f32);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "adder_orc_volume_f32");
      orc_program_set_backup_function (p, _backup_adder_orc_volume_f32);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_parameter_float (p, 4, "p1");

      orc_program_append_2 (p, "mulf", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_P1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  {
    orc_union32 tmp;
    tmp.f = p1;
    ex->params[ORC_VAR_P1] = tmp.i;
  }

  func = c->exec;
  func (ex);
}
#endif


/* adder_orc_volume_f64 */
#ifdef DISABLE_ORC
void
adder_orc_volume_f64 (double *ORC_RESTRICT d1, double p1, int n)
{
  int i;
  orc_union64 *ORC_RESTRICT ptr0;
  orc_union64 var32;
  orc_union64 var33;
  orc_union64 var34;

  ptr0 = (orc_union64 *) d1;

  /* 1: loadpq */
  var33.f = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr0[i];
    /* 2: muld */
    {
      orc_union64 _src1;
      orc_union64 _src2;
      orc_union64 _dest1;
      _src1.i = ORC_DENORMAL_DOUBLE (var32.i);
      _src2.i = ORC_DENORMAL_DOUBLE (var33.i);
      _dest1.f = _src1.f * _src2.f;
      var34.i = ORC_DENORMAL_DOUBLE (_dest1.i);
    }
    /* 3: storeq */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_adder_orc_volume_f64 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 *ORC_RESTRICT ptr0;
  orc_union64 var32;
  orc_union64 var33;
  orc_union64 var34;

  ptr0 = (orc_union64 *) ex->arrays[0];

  /* 1: loadpq */
  var33.i =
      (ex->params[24] & 0xffffffff) | ((orc_uint64) (ex->params[24 +
              (ORC_VAR_T1 - ORC_VAR_P1)]) << 32);

  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr0[i];
    /* 2: muld */
    {
      orc_union64 _src1;
      orc_union64 _src2;
      orc_union64 _dest1;
      _src1.i = ORC_DENORMAL_DOUBLE (var32.i);
      _src2.i = ORC_DENORMAL_DOUBLE (var33.i);
      _dest1.f = _src1.f * _src2.f;
      var34.i = ORC_DENORMAL_DOUBLE (_dest1.i);
    }
    /* 3: storeq */
    ptr0[i] = var34;
  }

}

void
adder_orc_volume_f64 (double *ORC_RESTRICT d1, double p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 20, 97, 100, 100, 101, 114, 95, 111, 114, 99, 95, 118, 111, 108,
        117, 109, 101, 95, 102, 54, 52, 11, 8, 8, 18, 8, 214, 0, 0, 24,
        2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_adder_orc_volume_f64);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "adder_orc_volume_f64");
      orc_program_set_backup_function (p, _backup_adder_orc_volume_f64);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_parameter_double (p, 8, "p1");

      orc_program_append_2 (p, "muld", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_P1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  {
    orc_union64 tmp;
    tmp.f = p1;
    ex->params[ORC_VAR_P1] = tmp.x2[0];
    ex->params[ORC_VAR_T1] = tmp.x2[1];
  }

  func = c->exec;
  func (ex);
}
#endif


/* adder_orc_add_volume_u8 */
#ifdef DISABLE_ORC
void
adder_orc_add_volume_u8 (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int p1, int n)
{
  int i;
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  orc_int8 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_int8 var35;
#else
  orc_int8 var35;
#endif
  orc_int8 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_int8 var37;
#else
  orc_int8 var37;
#endif
  orc_int8 var38;
  orc_int8 var39;
  orc_int8 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_int8 var43;
  orc_int8 var44;

  ptr0 = (orc_int8 *) d1;
  ptr4 = (orc_int8 *) s1;

  /* 1: loadpb */
  var35 = (int) 0x00000080;     /* 128 or 6.32404e-322f */
  /* 3: loadpb */
  var36 = p1;
  /* 7: loadpb */
  var37 = (int) 0x00000080;     /* 128 or 6.32404e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr4[i];
    /* 2: xorb */
    var40 = var34 ^ var35;
    /* 4: mulsbw */
    var41.i = var40 * var36;
    /* 5: shrsw */
    var42.i = var41.i >> 3;
    /* 6: convssswb */
    var43 = ORC_CLAMP_SB (var42.i);
    /* 8: xorb */
    var44 = var43 ^ var37;
    /* 9: loadb */
    var38 = ptr0[i];
    /* 10: addusb */
    var39 = ORC_CLAMP_UB ((orc_uint8) var38 + (orc_uint8) var44);
    /* 11: storeb */
    ptr0[i] = var39;
  }

}

#else
static void
_backup_adder_orc_add_volume_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  orc_int8 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_int8 var35;
#else
  orc_int8 var35;
#endif
  orc_int8 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_int8 var37;
#else
  orc_int8 var37;
#endif
  orc_int8 var38;
  orc_int8 var39;
  orc_int8 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_int8 var43;
  orc_int8 var44;

  ptr0 = (orc_int8 *) ex->arrays[0];
  ptr4 = (orc_int8 *) ex->arrays[4];

  /* 1: loadpb */
  var35 = (int) 0x00000080;     /* 128 or 6.32404e-322f */
  /* 3: loadpb */
  var36 = ex->params[24];
  /* 7: loadpb */
  var37 = (int) 0x00000080;     /* 128 or 6.32404e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr4[i];
    /* 2: xorb */
    var40 = var34 ^ var35;
    /* 4: mulsbw */
    var41.i = var40 * var36;
    /* 5: shrsw */
    var42.i = var41.i >> 3;
    /* 6: convssswb */
    var43 = ORC_CLAMP_SB (var42.i);
    /* 8: xorb */
    var44 = var43 ^ var37;
    /* 9: loadb */
    var38 = ptr0[i];
    /* 10: addusb */
    var39 = ORC_CLAMP_UB ((orc_uint8) var38 + (orc_uint8) var44);
    /* 11: storeb */
    ptr0[i] = var39;
  }

}

void
adder_orc_add_volume_u8 (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 23, 97, 100, 100, 101, 114, 95, 111, 114, 99, 95, 97, 100, 100,
        95, 118, 111, 108, 117, 109, 101, 95, 117, 56, 11, 1, 1, 12, 1, 1,
        14, 1, 128, 0, 0, 0, 14, 4, 3, 0, 0, 0, 16, 1, 20, 2,
        20, 1, 68, 33, 4, 16, 174, 32, 33, 24, 94, 32, 32, 17, 159, 33,
        32, 68, 33, 33, 16, 35, 0, 0, 33, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_adder_orc_add_volume_u8);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "adder_orc_add_volume_u8");
      orc_program_set_backup_function (p, _backup_adder_orc_add_volume_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_constant (p, 1, 0x00000080, "c1");
      orc_program_add_constant (p, 4, 0x00000003, "c2");
      orc_program_add_parameter (p, 1, "p1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 1, "t2");

      orc_program_append_2 (p, "xorb", 0, ORC_VAR_T2, ORC_VAR_S1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mulsbw", 0, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_P1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T2, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "xorb", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addusb", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T2,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* adder_orc_add_volume_s8 */
#ifdef DISABLE_ORC
void
adder_orc_add_volume_s8 (gint8 * ORC_RESTRICT d1, const gint8 * ORC_RESTRICT s1,
    int p1, int n)
{
  int i;
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  orc_int8 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_int8 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_int8 var40;

  ptr0 = (orc_int8 *) d1;
  ptr4 = (orc_int8 *) s1;

  /* 1: loadpb */
  var35 = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr4[i];
    /* 2: mulsbw */
    var38.i = var34 * var35;
    /* 3: shrsw */
    var39.i = var38.i >> 3;
    /* 4: convssswb */
    var40 = ORC_CLAMP_SB (var39.i);
    /* 5: loadb */
    var36 = ptr0[i];
    /* 6: addssb */
    var37 = ORC_CLAMP_SB (var36 + var40);
    /* 7: storeb */
    ptr0[i] = var37;
  }

}

#else
static void
_backup_adder_orc_add_volume_s8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  orc_int8 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_int8 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_int8 var40;

  ptr0 = (orc_int8 *) ex->arrays[0];
  ptr4 = (orc_int8 *) ex->arrays[4];

  /* 1: loadpb */
  var35 = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr4[i];
    /* 2: mulsbw */
    var38.i = var34 * var35;
    /* 3: shrsw */
    var39.i = var38.i >> 3;
    /* 4: convssswb */
    var40 = ORC_CLAMP_SB (var39.i);
    /* 5: loadb */
    var36 = ptr0[i];
    /* 6: addssb */
    var37 = ORC_CLAMP_SB (var36 + var40);
    /* 7: storeb */
    ptr0[i] = var37;
  }

}

void
adder_orc_add_volume_s8 (gint8 * ORC_RESTRICT d1, const gint8 * ORC_RESTRICT s1,
    int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 23, 97, 100, 100, 101, 114, 95, 111, 114, 99, 95, 97, 100, 100,
        95, 118, 111, 108, 117, 109, 101, 95, 115, 56, 11, 1, 1, 12, 1, 1,
        14, 4, 3, 0, 0, 0, 16, 1, 20, 2, 20, 1, 174, 32, 4, 24,
        94, 32, 32, 16, 159, 33, 32, 34, 0, 0, 33, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_adder_orc_add_volume_s8);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "adder_orc_add_volume_s8");
      orc_program_set_backup_function (p, _backup_adder_orc_add_volume_s8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_constant (p, 4, 0x00000003, "c1");
      orc_program_add_parameter (p, 1, "p1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 1, "t2");

      orc_program_append_2 (p, "mulsbw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_P1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T2, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "addssb", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T2,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* adder_orc_add_volume_u16 */
#ifdef DISABLE_ORC
void
adder_orc_add_volume_u16 (guint16 * ORC_RESTRICT d1,
    const guint16 * ORC_RESTRICT s1, int p1, int n)
{
  int i;
  orc_union16 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  orc_union16 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var35;
#else
  orc_union16 var35;
#endif
  orc_union16 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union16 var43;
  orc_union16 var44;

  ptr0 = (orc_union16 *) d1;
  ptr4 = (orc_union16 *) s1;

  /* 1: loadpw */
  var35.i = (int) 0x00008000;   /* 32768 or 1.61895e-319f */
  /* 3: loadpw */
  var36.i = p1;
  /* 7: loadpw */
  var37.i = (int) 0x00008000;   /* 32768 or 1.61895e-319f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr4[i];
    /* 2: xorw */
    var40.i = var34.i ^ var35.i;
    /* 4: mulswl */
    var41.i = var40.i * var36.i;
    /* 5: shrsl */
    var42.i = var41.i >> 11;
    /* 6: convssslw */
    var43.i = ORC_CLAMP_SW (var42.i);
    /* 8: xorw */
    var44.i = var43.i ^ var37.i;
    /* 9: loadw */
    var38 = ptr0[i];
    /* 10: addusw */
    var39.i = ORC_CLAMP_UW ((orc_uint16) var38.i + (orc_uint16) var44.i);
    /* 11: storew */
    ptr0[i] = var39;
  }

}

#else
static void
_backup_adder_orc_add_volume_u16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  orc_union16 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var35;
#else
  orc_union16 var35;
#endif
  orc_union16 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union16 var43;
  orc_union16 var44;

  ptr0 = (orc_union16 *) ex->arrays[0];
  ptr4 = (orc_union16 *) ex->arrays[4];

  /* 1: loadpw */
  var35.i = (int) 0x00008000;   /* 32768 or 1.61895e-319f */
  /* 3: loadpw */
  var36.i = ex->params[24];
  /* 7: loadpw */
  var37.i = (int) 0x00008000;   /* 32768 or 1.61895e-319f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr4[i];
    /* 2: xorw */
    var40.i = var34.i ^ var35.i;
    /* 4: mulswl */
    var41.i = var40.i * var36.i;
    /* 5: shrsl */
    var42.i = var41.i >> 11;
    /* 6: convssslw */
    var43.i = ORC_CLAMP_SW (var42.i);
    /* 8: xorw */
    var44.i = var43.i ^ var37.i;
    /* 9: loadw */
    var38 = ptr0[i];
    /* 10: addusw */
    var39.i = ORC_CLAMP_UW ((orc_uint16) var38.i + (orc_uint16) var44.i);
    /* 11: storew */
    ptr0[i] = var39;
  }

}

void
adder_orc_add_volume_u16 (guint16 * ORC_RESTRICT d1,
    const guint16 * ORC_RESTRICT s1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 24, 97, 100, 100, 101, 114, 95, 111, 114, 99, 95, 97, 100, 100,
        95, 118, 111, 108, 117, 109, 101, 95, 117, 49, 54, 11, 2, 2, 12, 2,
        2, 14, 2, 0, 128, 0, 0, 14, 4, 11, 0, 0, 0, 16, 2, 20,
        4, 20, 2, 101, 33, 4, 16, 176, 32, 33, 24, 125, 32, 32, 17, 165,
        33, 32, 101, 33, 33, 16, 72, 0, 0, 33, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_adder_orc_add_volume_u16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "adder_orc_add_volume_u16");
      orc_program_set_backup_function (p, _backup_adder_orc_add_volume_u16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 2, 0x00008000, "c1");
      orc_program_add_constant (p, 4, 0x0000000b, "c2");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "xorw", 0, ORC_VAR_T2, ORC_VAR_S1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mulswl", 0, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_P1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convssslw", 0, ORC_VAR_T2, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "xorw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addusw", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T2,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* adder_orc_add_volume_s16 */
#ifdef DISABLE_ORC
void
adder_orc_add_volume_s16 (gint16 * ORC_RESTRICT d1,
    const gint16 * ORC_RESTRICT s1, int p1, int n)
{
  int i;
  orc_union16 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union16 var40;

  ptr0 = (orc_union16 *) d1;
  ptr4 = (orc_union16 *) s1;

  /* 1: loadpw */
  var35.i = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr4[i];
    /* 2: mulswl */
    var38.i = var34.i * var35.i;
    /* 3: shrsl */
    var39.i = var38.i >> 11;
    /* 4: convssslw */
    var40.i = ORC_CLAMP_SW (var39.i);
    /* 5: loadw */
    var36 = ptr0[i];
    /* 6: addssw */
    var37.i = ORC_CLAMP_SW (var36.i + var40.i);
    /* 7: storew */
    ptr0[i] = var37;
  }

}

#else
static void
_backup_adder_orc_add_volume_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union16 var40;

  ptr0 = (orc_union16 *) ex->arrays[0];
  ptr4 = (orc_union16 *) ex->arrays[4];

  /* 1: loadpw */
  var35.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr4[i];
    /* 2: mulswl */
    var38.i = var34.i * var35.i;
    /* 3: shrsl */
    var39.i = var38.i >> 11;
    /* 4: convssslw */
    var40.i = ORC_CLAMP_SW (var39.i);
    /* 5: loadw */
    var36 = ptr0[i];
    /* 6: addssw */
    var37.i = ORC_CLAMP_SW (var36.i + var40.i);
    /* 7: storew */
    ptr0[i] = var37;
  }

}

void
adder_orc_add_volume_s16 (gint16 * ORC_RESTRICT d1,
    const gint16 * ORC_RESTRICT s1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 24, 97, 100, 100, 101, 114, 95, 111, 114, 99, 95, 97, 100, 100,
        95, 118, 111, 108, 117, 109, 101, 95, 115, 49, 54, 11, 2, 2, 12, 2,
        2, 14, 4, 11, 0, 0, 0, 16, 2, 20, 4, 20, 2, 176, 32, 4,
        24, 125, 32, 32, 16, 165, 33, 32, 71, 0, 0, 33, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_adder_orc_add_volume_s16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "adder_orc_add_volume_s16");
      orc_program_set_backup_function (p, _backup_adder_orc_add_volume_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 4, 0x0000000b, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "mulswl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_P1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convssslw", 0, ORC_VAR_T2, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T2,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* adder_orc_add_volume_u32 */
#ifdef DISABLE_ORC
void
adder_orc_add_volume_u32 (guint32 * ORC_RESTRICT d1,
    const guint32 * ORC_RESTRICT s1, int p1, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_union32 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union32 var37;
#else
  orc_union32 var37;
#endif
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union64 var41;
  orc_union64 var42;
  orc_union32 var43;
  orc_union32 var44;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union32 *) s1;

  /* 1: loadpl */
  var35.i = (int) 0x80000000;   /* -2147483648 or 1.061e-314f */
  /* 3: loadpl */
  var36.i = p1;
  /* 7: loadpl */
  var37.i = (int) 0x80000000;   /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 2: xorl */
    var40.i = var34.i ^ var35.i;
    /* 4: mulslq */
    var41.i = ((orc_int64) var40.i) * ((orc_int64) var36.i);
    /* 5: shrsq */
    var42.i = var41.i >> 27;
    /* 6: convsssql */
    var43.i = ORC_CLAMP_SL (var42.i);
    /* 8: xorl */
    var44.i = var43.i ^ var37.i;
    /* 9: loadl */
    var38 = ptr0[i];
    /* 10: addusl */
    var39.i =
        ORC_CLAMP_UL ((orc_int64) (orc_uint32) var38.i +
        (orc_int64) (orc_uint32) var44.i);
    /* 11: storel */
    ptr0[i] = var39;
  }

}

#else
static void
_backup_adder_orc_add_volume_u32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_union32 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union32 var37;
#else
  orc_union32 var37;
#endif
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union64 var41;
  orc_union64 var42;
  orc_union32 var43;
  orc_union32 var44;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];

  /* 1: loadpl */
  var35.i = (int) 0x80000000;   /* -2147483648 or 1.061e-314f */
  /* 3: loadpl */
  var36.i = ex->params[24];
  /* 7: loadpl */
  var37.i = (int) 0x80000000;   /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 2: xorl */
    var40.i = var34.i ^ var35.i;
    /* 4: mulslq */
    var41.i = ((orc_int64) var40.i) * ((orc_int64) var36.i);
    /* 5: shrsq */
    var42.i = var41.i >> 27;
    /* 6: convsssql */
    var43.i = ORC_CLAMP_SL (var42.i);
    /* 8: xorl */
    var44.i = var43.i ^ var37.i;
    /* 9: loadl */
    var38 = ptr0[i];
    /* 10: addusl */
    var39.i =
        ORC_CLAMP_UL ((orc_int64) (orc_uint32) var38.i +
        (orc_int64) (orc_uint32) var44.i);
    /* 11: storel */
    ptr0[i] = var39;
  }

}

void
adder_orc_add_volume_u32 (guint32 * ORC_RESTRICT d1,
    const guint32 * ORC_RESTRICT s1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 24, 97, 100, 100, 101, 114, 95, 111, 114, 99, 95, 97, 100, 100,
        95, 118, 111, 108, 117, 109, 101, 95, 117, 51, 50, 11, 4, 4, 12, 4,
        4, 14, 4, 0, 0, 0, 128, 14, 4, 27, 0, 0, 0, 16, 4, 20,
        8, 20, 4, 132, 33, 4, 16, 178, 32, 33, 24, 147, 32, 32, 17, 170,
        33, 32, 132, 33, 33, 16, 105, 0, 0, 33, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_adder_orc_add_volume_u32);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "adder_orc_add_volume_u32");
      orc_program_set_backup_function (p, _backup_adder_orc_add_volume_u32);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x80000000, "c1");
      orc_program_add_constant (p, 4, 0x0000001b, "c2");
      orc_program_add_parameter (p, 4, "p1");
      orc_program_add_temporary (p, 8, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "xorl", 0, ORC_VAR_T2, ORC_VAR_S1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mulslq", 0, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_P1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsq", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convsssql", 0, ORC_VAR_T2, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "xorl", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addusl", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T2,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* adder_orc_add_volume_s32 */
#ifdef DISABLE_ORC
void
adder_orc_add_volume_s32 (gint32 * ORC_RESTRICT d1,
    const gint32 * ORC_RESTRICT s1, int p1, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;
  orc_union64 var38;
  orc_union64 var39;
  orc_union32 var40;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union32 *) s1;

  /* 1: loadpl */
  var35.i = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 2: mulslq */
    var38.i = ((orc_int64) var34.i) * ((orc_int64) var35.i);
    /* 3: shrsq */
    var39.i = var38.i >> 27;
    /* 4: convsssql */
    var40.i = ORC_CLAMP_SL (var39.i);
    /* 5: loadl */
    var36 = ptr0[i];
    /* 6: addssl */
    var37.i = ORC_CLAMP_SL ((orc_int64) var36.i + (orc_int64) var40.i);
    /* 7: storel */
    ptr0[i] = var37;
  }

}

#else
static void
_backup_adder_orc_add_volume_s32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;
  orc_union64 var38;
  orc_union64 var39;
  orc_union32 var40;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];

  /* 1: loadpl */
  var35.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 2: mulslq */
    var38.i = ((orc_int64) var34.i) * ((orc_int64) var35.i);
    /* 3: shrsq */
    var39.i = var38.i >> 27;
    /* 4: convsssql */
    var40.i = ORC_CLAMP_SL (var39.i);
    /* 5: loadl */
    var36 = ptr0[i];
    /* 6: addssl */
    var37.i = ORC_CLAMP_SL ((orc_int64) var36.i + (orc_int64) var40.i);
    /* 7: storel */
    ptr0[i] = var37;
  }

}

void
adder_orc_add_volume_s32 (gint32 * ORC_RESTRICT d1,
    const gint32 * ORC_RESTRICT s1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 24, 97, 100, 100, 101, 114, 95, 111, 114, 99, 95, 97, 100, 100,
        95, 118, 111, 108, 117, 109, 101, 95, 115, 51, 50, 11, 4, 4, 12, 4,
        4, 14, 4, 27, 0, 0, 0, 16, 4, 20, 8, 20, 4, 178, 32, 4,
        24, 147, 32, 32, 16, 170, 33, 32, 104, 0, 0, 33, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_adder_orc_add_volume_s32);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "adder_orc_add_volume_s32");
      orc_program_set_backup_function (p, _backup_adder_orc_add_volume_s32);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x0000001b, "c1");
      orc_program_add_parameter (p, 4, "p1");
      orc_program_add_temporary (p, 8, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "mulslq", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_P1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsq", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convsssql", 0, ORC_VAR_T2, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "addssl", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T2,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* adder_orc_add_volume_f32 */
#ifdef DISABLE_ORC
void
adder_orc_add_volume_f32 (float *ORC_RESTRICT d1, const float *ORC_RESTRICT s1,
    float p1, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union32 *) s1;

  /* 1: loadpl */
  var34.f = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 2: mulf */
    {
      orc_union32 _src1;
      orc_union32 _src2;
      orc_union32 _dest1;
      _src1.i = ORC_DENORMAL (var33.i);
      _src2.i = ORC_DENORMAL (var34.i);
      _dest1.f = _src1.f * _src2.f;
      var37.i = ORC_DENORMAL (_dest1.i);
    }
    /* 3: loadl */
    var35 = ptr0[i];
    /* 4: addf */
    {
      orc_union32 _src1;
      orc_union32 _src2;
      orc_union32 _dest1;
      _src1.i = ORC_DENORMAL (var35.i);
      _src2.i = ORC_DENORMAL (var37.i);
      _dest1.f = _src1.f + _src2.f;
      var36.i = ORC_DENORMAL (_dest1.i);
    }
    /* 5: storel */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_adder_orc_add_volume_f32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];

  /* 1: loadpl */
  var34.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 2: mulf */
    {
      orc_union32 _src1;
      orc_union32 _src2;
      orc_union32 _dest1;
      _src1.i = ORC_DENORMAL (var33.i);
      _src2.i = ORC_DENORMAL (var34.i);
      _dest1.f = _src1.f * _src2.f;
      var37.i = ORC_DENORMAL (_dest1.i);
    }
    /* 3: loadl */
    var35 = ptr0[i];
    /* 4: addf */
    {
      orc_union32 _src1;
      orc_union32 _src2;
      orc_union32 _dest1;
      _src1.i = ORC_DENORMAL (var35.i);
      _src2.i = ORC_DENORMAL (var37.i);
      _dest1.f = _src1.f + _src2.f;
      var36.i = ORC_DENORMAL (_dest1.i);
    }
    /* 5: storel */
    ptr0[i] = var36;
  }

}

void
adder_orc_add_volume_f32 (float *ORC_RESTRICT d1, const float *ORC_RESTRICT s1,
    float p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 24, 97, 100, 100, 101, 114, 95, 111, 114, 99, 95, 97, 100, 100,
        95, 118, 111, 108, 117, 109, 101, 95, 102, 51, 50, 11, 4, 4, 12, 4,
        4, 17, 4, 20, 4, 202, 32, 4, 24, 200, 0, 0, 32, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_adder_orc_add_volume_f32);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "adder_orc_add_volume_f32");
      orc_program_set_backup_function (p, _backup_adder_orc_add_volume_f32);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_parameter_float (p, 4, "p1");
      orc_program_add_temporary (p, 4, "t1");

      orc_program_append_2 (p, "mulf", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_P1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addf", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  {
    orc_union32 tmp;
    tmp.f = p1;
    ex->params[ORC_VAR_P1] = tmp.i;
  }

  func = c->exec;
  func (ex);
}
#endif


/* adder_orc_add_volume_f64 */
#ifdef DISABLE_ORC
void
adder_orc_add_volume_f64 (double *ORC_RESTRICT d1,
    const double *ORC_RESTRICT s1, double p1, int n)
{
  int i;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var33;
  orc_union64 var34;
  orc_union64 var35;
  orc_union64 var36;
  orc_union64 var37;

  ptr0 = (orc_union64 *) d1;
  ptr4 = (orc_union64 *) s1;

  /* 1: loadpq */
  var34.f = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var33 = ptr4[i];
    /* 2: muld */
    {
      orc_union64 _src1;
      orc_union64 _src2;
      orc_union64 _dest1;
      _src1.i = ORC_DENORMAL_DOUBLE (var33.i);
      _src2.i = ORC_DENORMAL_DOUBLE (var34.i);
      _dest1.f = _src1.f * _src2.f;
      var37.i = ORC_DENORMAL_DOUBLE (_dest1.i);
    }
    /* 3: loadq */
    var35 = ptr0[i];
    /* 4: addd */
    {
      orc_union64 _src1;
      orc_union64 _src2;
      orc_union64 _dest1;
      _src1.i = ORC_DENORMAL_DOUBLE (var35.i);
      _src2.i = ORC_DENORMAL_DOUBLE (var37.i);
      _dest1.f = _src1.f + _src2.f;
      var36.i = ORC_DENORMAL_DOUBLE (_dest1.i);
    }
    /* 5: storeq */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_adder_orc_add_volume_f64 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var33;
  orc_union64 var34;
  orc_union64 var35;
  orc_union64 var36;
  orc_union64 var37;

  ptr0 = (orc_union64 *) ex->arrays[0];
  ptr4 = (orc_union64 *) ex->arrays[4];

  /* 1: loadpq */
  var34.i =
      (ex->params[24] & 0xffffffff) | ((orc_uint64) (ex->params[24 +
              (ORC_VAR_T1 - ORC_VAR_P1)]) << 32);

  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var33 = ptr4[i];
    /* 2: muld */
    {
      orc_union64 _src1;
      orc_union64 _src2;
      orc_union64 _dest1;
      _src1.i = ORC_DENORMAL_DOUBLE (var33.i);
      _src2.i = ORC_DENORMAL_DOUBLE (var34.i);
      _dest1.f = _src1.f * _src2.f;
      var37.i = ORC_DENORMAL_DOUBLE (_dest1.i);
    }
    /* 3: loadq */
    var35 = ptr0[i];
    /* 4: addd */
    {
      orc_union64 _src1;
      orc_union64 _src2;
      orc_union64 _dest1;
      _src1.i = ORC_DENORMAL_DOUBLE (var35.i);
      _src2.i = ORC_DENORMAL_DOUBLE (var37.i);
      _dest1.f = _src1.f + _src2.f;
      var36.i = ORC_DENORMAL_DOUBLE (_dest1.i);
    }
    /* 5: storeq */
    ptr0[i] = var36;
  }

}

void
adder_orc_add_volume_f64 (double *ORC_RESTRICT d1,
    const double *ORC_RESTRICT s1, double p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 24, 97, 100, 100, 101, 114, 95, 111, 114, 99, 95, 97, 100, 100,
        95, 118, 111, 108, 117, 109, 101, 95, 102, 54, 52, 11, 8, 8, 12, 8,
        8, 18, 8, 20, 8, 214, 32, 4, 24, 212, 0, 0, 32, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_adder_orc_add_volume_f64);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "adder_orc_add_volume_f64");
      orc_program_set_backup_function (p, _backup_adder_orc_add_volume_f64);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_parameter_double (p, 8, "p1");
      orc_program_add_temporary (p, 8, "t1");

      orc_program_append_2 (p, "muld", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_P1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addd", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  {
    orc_union64 tmp;
    tmp.f = p1;
    ex->params[ORC_VAR_P1] = tmp.x2[0];
    ex->params[ORC_VAR_T1] = tmp.x2[1];
  }

  func = c->exec;
  func (ex);
}
#endif
