/* math-variables.c generated by valac 0.40.6, the Vala compiler
 * generated from math-variables.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>


#define TYPE_MATH_VARIABLES (math_variables_get_type ())
#define MATH_VARIABLES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_VARIABLES, MathVariables))
#define MATH_VARIABLES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_VARIABLES, MathVariablesClass))
#define IS_MATH_VARIABLES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_VARIABLES))
#define IS_MATH_VARIABLES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_VARIABLES))
#define MATH_VARIABLES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_VARIABLES, MathVariablesClass))

typedef struct _MathVariables MathVariables;
typedef struct _MathVariablesClass MathVariablesClass;
typedef struct _MathVariablesPrivate MathVariablesPrivate;

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;

#define TYPE_SERIALIZER (serializer_get_type ())
#define SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SERIALIZER, Serializer))
#define SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SERIALIZER, SerializerClass))
#define IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SERIALIZER))
#define IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SERIALIZER))
#define SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SERIALIZER, SerializerClass))

typedef struct _Serializer Serializer;
typedef struct _SerializerClass SerializerClass;
enum  {
	MATH_VARIABLES_0_PROPERTY,
	MATH_VARIABLES_NUM_PROPERTIES
};
static GParamSpec* math_variables_properties[MATH_VARIABLES_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DISPLAY_FORMAT (display_format_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	MATH_VARIABLES_VARIABLE_ADDED_SIGNAL,
	MATH_VARIABLES_VARIABLE_EDITED_SIGNAL,
	MATH_VARIABLES_VARIABLE_DELETED_SIGNAL,
	MATH_VARIABLES_NUM_SIGNALS
};
static guint math_variables_signals[MATH_VARIABLES_NUM_SIGNALS] = {0};

struct _MathVariables {
	GObject parent_instance;
	MathVariablesPrivate * priv;
};

struct _MathVariablesClass {
	GObjectClass parent_class;
};

struct _MathVariablesPrivate {
	gchar* file_name;
	GHashTable* registers;
	Serializer* serializer;
};

typedef enum  {
	DISPLAY_FORMAT_AUTOMATIC,
	DISPLAY_FORMAT_FIXED,
	DISPLAY_FORMAT_SCIENTIFIC,
	DISPLAY_FORMAT_ENGINEERING
} DisplayFormat;


static gpointer math_variables_parent_class = NULL;

GType math_variables_get_type (void) G_GNUC_CONST;
GType number_get_type (void) G_GNUC_CONST;
GType serializer_get_type (void) G_GNUC_CONST;
#define MATH_VARIABLES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MATH_VARIABLES, MathVariablesPrivate))
MathVariables* math_variables_new (void);
MathVariables* math_variables_construct (GType object_type);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
GType display_format_get_type (void) G_GNUC_CONST;
Serializer* serializer_new (DisplayFormat format,
                            gint number_base,
                            gint trailing_digits);
Serializer* serializer_construct (GType object_type,
                                  DisplayFormat format,
                                  gint number_base,
                                  gint trailing_digits);
void serializer_set_radix (Serializer* self,
                           gunichar radix);
static void math_variables_registers_load (MathVariables* self);
Number* mp_set_from_string (const gchar* str,
                            gint default_base);
static void math_variables_save (MathVariables* self);
gchar* serializer_to_string (Serializer* self,
                             Number* x);
static gchar** math_variables_array_sort_string (MathVariables* self,
                                          gchar** array,
                                          int array_length1,
                                          int* result_length1);
static gchar** _vala_array_dup9 (gchar** self,
                          int length);
gchar** math_variables_get_names (MathVariables* self,
                                  int* result_length1);
gchar** math_variables_variables_eligible_for_autocompletion (MathVariables* self,
                                                              const gchar* text,
                                                              int* result_length1);
static void _vala_array_add5 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
void math_variables_set (MathVariables* self,
                         const gchar* name,
                         Number* value);
Number* math_variables_get (MathVariables* self,
                            const gchar* name);
void math_variables_delete (MathVariables* self,
                            const gchar* name);
static void g_cclosure_user_marshal_VOID__STRING_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void math_variables_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}


static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


MathVariables*
math_variables_construct (GType object_type)
{
	MathVariables * self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	Serializer* _tmp5_;
	Serializer* _tmp6_;
	self = (MathVariables*) g_object_new (object_type, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->registers);
	self->priv->registers = _tmp2_;
	_tmp3_ = g_get_user_data_dir ();
	_tmp4_ = g_build_filename (_tmp3_, "gnome-calculator", "registers", NULL);
	_g_free0 (self->priv->file_name);
	self->priv->file_name = _tmp4_;
	_tmp5_ = serializer_new (DISPLAY_FORMAT_SCIENTIFIC, 10, 50);
	_g_object_unref0 (self->priv->serializer);
	self->priv->serializer = _tmp5_;
	_tmp6_ = self->priv->serializer;
	serializer_set_radix (_tmp6_, (gunichar) '.');
	math_variables_registers_load (self);
	return self;
}


MathVariables*
math_variables_new (void)
{
	return math_variables_construct (TYPE_MATH_VARIABLES);
}


static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static gchar*
string_strip (const gchar* self)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static void
math_variables_registers_load (MathVariables* self)
{
	gchar* data = NULL;
	GHashTable* _tmp2_;
	gchar** lines = NULL;
	const gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint lines_length1;
	gint _lines_size_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		_tmp0_ = self->priv->file_name;
		g_file_get_contents (_tmp0_, &_tmp1_, NULL, &_inner_error_);
		_g_free0 (data);
		data = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch7_g_file_error;
			}
			_g_free0 (data);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally7;
	__catch7_g_file_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
		_g_free0 (data);
		return;
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp2_ = self->priv->registers;
	g_hash_table_remove_all (_tmp2_);
	_tmp3_ = data;
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, "\n", 0);
	lines = _tmp5_;
	lines_length1 = _vala_array_length (_tmp4_);
	_lines_size_ = lines_length1;
	_tmp6_ = lines;
	_tmp6__length1 = lines_length1;
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp6_;
		line_collection_length1 = _tmp6__length1;
		for (line_it = 0; line_it < _tmp6__length1; line_it = line_it + 1) {
			gchar* _tmp7_;
			gchar* line = NULL;
			_tmp7_ = g_strdup (line_collection[line_it]);
			line = _tmp7_;
			{
				gint i = 0;
				const gchar* _tmp8_;
				gint _tmp9_;
				gchar* name = NULL;
				const gchar* _tmp10_;
				gint _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* value = NULL;
				const gchar* _tmp16_;
				gint _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				Number* t = NULL;
				const gchar* _tmp22_;
				Number* _tmp23_;
				Number* _tmp24_;
				_tmp8_ = line;
				i = string_index_of_char (_tmp8_, (gunichar) '=', 0);
				_tmp9_ = i;
				if (_tmp9_ < 0) {
					_g_free0 (line);
					continue;
				}
				_tmp10_ = line;
				_tmp11_ = i;
				_tmp12_ = string_substring (_tmp10_, (glong) 0, (glong) _tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = string_strip (_tmp13_);
				_tmp15_ = _tmp14_;
				_g_free0 (_tmp13_);
				name = _tmp15_;
				_tmp16_ = line;
				_tmp17_ = i;
				_tmp18_ = string_substring (_tmp16_, (glong) (_tmp17_ + 1), (glong) -1);
				_tmp19_ = _tmp18_;
				_tmp20_ = string_strip (_tmp19_);
				_tmp21_ = _tmp20_;
				_g_free0 (_tmp19_);
				value = _tmp21_;
				_tmp22_ = value;
				_tmp23_ = mp_set_from_string (_tmp22_, 10);
				t = _tmp23_;
				_tmp24_ = t;
				if (_tmp24_ != NULL) {
					GHashTable* _tmp25_;
					const gchar* _tmp26_;
					gchar* _tmp27_;
					Number* _tmp28_;
					Number* _tmp29_;
					_tmp25_ = self->priv->registers;
					_tmp26_ = name;
					_tmp27_ = g_strdup (_tmp26_);
					_tmp28_ = t;
					_tmp29_ = _g_object_ref0 (_tmp28_);
					g_hash_table_insert (_tmp25_, _tmp27_, _tmp29_);
				}
				_g_object_unref0 (t);
				_g_free0 (value);
				_g_free0 (name);
				_g_free0 (line);
			}
		}
	}
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (data);
}


static void
math_variables_save (MathVariables* self)
{
	gchar* data = NULL;
	gchar* _tmp0_;
	GHashTableIter iter = {0};
	GHashTable* _tmp1_;
	gchar* name = NULL;
	Number* value = NULL;
	gchar* dir = NULL;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	data = _tmp0_;
	_tmp1_ = self->priv->registers;
	g_hash_table_iter_init (&iter, _tmp1_);
	while (TRUE) {
		gconstpointer _tmp2_ = NULL;
		gconstpointer _tmp3_ = NULL;
		gboolean _tmp4_;
		gchar* _tmp5_;
		Number* _tmp6_;
		gchar* number = NULL;
		Serializer* _tmp7_;
		Number* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp4_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp2_), (gpointer*) (&_tmp3_));
		_g_free0 (name);
		_tmp5_ = g_strdup (_tmp2_);
		name = _tmp5_;
		_g_object_unref0 (value);
		_tmp6_ = _g_object_ref0 (_tmp3_);
		value = _tmp6_;
		if (!_tmp4_) {
			break;
		}
		_tmp7_ = self->priv->serializer;
		_tmp8_ = value;
		_tmp9_ = serializer_to_string (_tmp7_, _tmp8_);
		number = _tmp9_;
		_tmp10_ = data;
		_tmp11_ = name;
		_tmp12_ = number;
		_tmp13_ = g_strdup_printf ("%s=%s\n", _tmp11_, _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat (_tmp10_, _tmp14_, NULL);
		_g_free0 (data);
		data = _tmp15_;
		_g_free0 (_tmp14_);
		_g_free0 (number);
	}
	_tmp16_ = self->priv->file_name;
	_tmp17_ = g_path_get_dirname (_tmp16_);
	dir = _tmp17_;
	g_mkdir_with_parents (dir, 0700);
	{
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		_tmp18_ = self->priv->file_name;
		_tmp19_ = data;
		g_file_set_contents (_tmp18_, _tmp19_, (gssize) -1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch8_g_file_error;
			}
			_g_free0 (dir);
			_g_object_unref0 (value);
			_g_free0 (name);
			_g_free0 (data);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally8;
	__catch8_g_file_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally8:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (dir);
		_g_object_unref0 (value);
		_g_free0 (name);
		_g_free0 (data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (dir);
	_g_object_unref0 (value);
	_g_free0 (name);
	_g_free0 (data);
}


static gchar**
_vala_array_dup9 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar**
math_variables_array_sort_string (MathVariables* self,
                                  gchar** array,
                                  int array_length1,
                                  int* result_length1)
{
	gchar** result = NULL;
	gboolean swapped = FALSE;
	gint _tmp0_ = 0;
	const gchar* _tmp1_;
	gint j = 0;
	gchar* tmp = NULL;
	gchar** _tmp24_;
	gint _tmp24__length1;
	gchar** _tmp25_;
	gint _tmp25__length1;
	g_return_val_if_fail (self != NULL, NULL);
	swapped = TRUE;
	_tmp1_ = array[array_length1 - 1];
	if (_tmp1_ == NULL) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	j = _tmp0_;
	while (TRUE) {
		gboolean _tmp2_;
		gint _tmp3_;
		_tmp2_ = swapped;
		if (!_tmp2_) {
			break;
		}
		swapped = FALSE;
		_tmp3_ = j;
		j = _tmp3_ + 1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp4_ = FALSE;
				_tmp4_ = TRUE;
				while (TRUE) {
					gint _tmp6_;
					gint _tmp7_;
					gint _tmp8_;
					const gchar* _tmp9_;
					gint _tmp10_;
					const gchar* _tmp11_;
					if (!_tmp4_) {
						gint _tmp5_;
						_tmp5_ = i;
						i = _tmp5_ + 1;
					}
					_tmp4_ = FALSE;
					_tmp6_ = i;
					_tmp7_ = j;
					if (!(_tmp6_ < (array_length1 - _tmp7_))) {
						break;
					}
					_tmp8_ = i;
					_tmp9_ = array[_tmp8_];
					_tmp10_ = i;
					_tmp11_ = array[_tmp10_ + 1];
					if (g_strcmp0 (_tmp9_, _tmp11_) < 0) {
						gint _tmp12_;
						const gchar* _tmp13_;
						gchar* _tmp14_;
						gint _tmp15_;
						gint _tmp16_;
						const gchar* _tmp17_;
						gchar* _tmp18_;
						gchar* _tmp19_;
						gint _tmp20_;
						const gchar* _tmp21_;
						gchar* _tmp22_;
						gchar* _tmp23_;
						_tmp12_ = i;
						_tmp13_ = array[_tmp12_];
						_tmp14_ = g_strdup (_tmp13_);
						_g_free0 (tmp);
						tmp = _tmp14_;
						_tmp15_ = i;
						_tmp16_ = i;
						_tmp17_ = array[_tmp16_ + 1];
						_tmp18_ = g_strdup (_tmp17_);
						_g_free0 (array[_tmp15_]);
						array[_tmp15_] = _tmp18_;
						_tmp19_ = array[_tmp15_];
						_tmp20_ = i;
						_tmp21_ = tmp;
						_tmp22_ = g_strdup (_tmp21_);
						_g_free0 (array[_tmp20_ + 1]);
						array[_tmp20_ + 1] = _tmp22_;
						_tmp23_ = array[_tmp20_ + 1];
						swapped = TRUE;
					}
				}
			}
		}
	}
	_tmp24_ = (array != NULL) ? _vala_array_dup9 (array, array_length1) : ((gpointer) array);
	_tmp24__length1 = array_length1;
	_tmp25_ = _tmp24_;
	_tmp25__length1 = _tmp24__length1;
	if (result_length1) {
		*result_length1 = _tmp25__length1;
	}
	result = _tmp25_;
	_g_free0 (tmp);
	return result;
}


gchar**
math_variables_get_names (MathVariables* self,
                          int* result_length1)
{
	gchar** result = NULL;
	gchar** names = NULL;
	GHashTable* _tmp0_;
	gchar** _tmp1_;
	gint names_length1;
	gint _names_size_;
	GHashTableIter iter = {0};
	GHashTable* _tmp2_;
	gint i = 0;
	gchar* name = NULL;
	Number* value = NULL;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gint _tmp15_;
	gchar* _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	gint _tmp18_;
	gchar** _tmp19_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->registers;
	_tmp1_ = g_new0 (gchar*, (g_hash_table_size (_tmp0_) + 1) + 1);
	names = _tmp1_;
	names_length1 = g_hash_table_size (_tmp0_) + 1;
	_names_size_ = names_length1;
	_tmp2_ = self->priv->registers;
	g_hash_table_iter_init (&iter, _tmp2_);
	i = 0;
	while (TRUE) {
		gconstpointer _tmp3_ = NULL;
		gconstpointer _tmp4_ = NULL;
		gboolean _tmp5_;
		gchar* _tmp6_;
		Number* _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		gint _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gint _tmp13_;
		_tmp5_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp3_), (gpointer*) (&_tmp4_));
		_g_free0 (name);
		_tmp6_ = g_strdup (_tmp3_);
		name = _tmp6_;
		_g_object_unref0 (value);
		_tmp7_ = _g_object_ref0 (_tmp4_);
		value = _tmp7_;
		if (!_tmp5_) {
			break;
		}
		_tmp8_ = names;
		_tmp8__length1 = names_length1;
		_tmp9_ = i;
		_tmp10_ = name;
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (_tmp8_[_tmp9_]);
		_tmp8_[_tmp9_] = _tmp11_;
		_tmp12_ = _tmp8_[_tmp9_];
		_tmp13_ = i;
		i = _tmp13_ + 1;
	}
	_tmp14_ = names;
	_tmp14__length1 = names_length1;
	_tmp15_ = i;
	_g_free0 (_tmp14_[_tmp15_]);
	_tmp14_[_tmp15_] = NULL;
	_tmp16_ = _tmp14_[_tmp15_];
	_tmp17_ = names;
	_tmp17__length1 = names_length1;
	_tmp19_ = math_variables_array_sort_string (self, _tmp17_, _tmp17__length1, &_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp20__length1 = _tmp18_;
	if (result_length1) {
		*result_length1 = _tmp20__length1;
	}
	result = _tmp20_;
	_g_object_unref0 (value);
	_g_free0 (name);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void
_vala_array_add5 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gchar**
math_variables_variables_eligible_for_autocompletion (MathVariables* self,
                                                      const gchar* text,
                                                      int* result_length1)
{
	gchar** result = NULL;
	gchar** eligible_variables = NULL;
	gchar** _tmp0_;
	gint eligible_variables_length1;
	gint _eligible_variables_size_;
	gint _tmp1_;
	gint _tmp2_;
	gchar** variables = NULL;
	gint _tmp4_;
	gchar** _tmp5_;
	gint variables_length1;
	gint _variables_size_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp13_;
	gint _tmp13__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	eligible_variables = _tmp0_;
	eligible_variables_length1 = 0;
	_eligible_variables_size_ = eligible_variables_length1;
	_tmp1_ = strlen (text);
	_tmp2_ = _tmp1_;
	if (_tmp2_ <= 1) {
		gchar** _tmp3_;
		gint _tmp3__length1;
		_tmp3_ = eligible_variables;
		_tmp3__length1 = eligible_variables_length1;
		if (result_length1) {
			*result_length1 = _tmp3__length1;
		}
		result = _tmp3_;
		return result;
	}
	_tmp5_ = math_variables_get_names (self, &_tmp4_);
	variables = _tmp5_;
	variables_length1 = _tmp4_;
	_variables_size_ = variables_length1;
	_tmp6_ = variables;
	_tmp6__length1 = variables_length1;
	{
		gchar** variable_collection = NULL;
		gint variable_collection_length1 = 0;
		gint _variable_collection_size_ = 0;
		gint variable_it = 0;
		variable_collection = _tmp6_;
		variable_collection_length1 = _tmp6__length1;
		for (variable_it = 0; variable_it < _tmp6__length1; variable_it = variable_it + 1) {
			gchar* _tmp7_;
			gchar* variable = NULL;
			_tmp7_ = g_strdup (variable_collection[variable_it]);
			variable = _tmp7_;
			{
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				_tmp8_ = variable;
				if (_tmp8_ == NULL) {
					_g_free0 (variable);
					break;
				}
				_tmp9_ = variable;
				if (g_str_has_prefix (_tmp9_, text)) {
					gchar** _tmp10_;
					gint _tmp10__length1;
					const gchar* _tmp11_;
					gchar* _tmp12_;
					_tmp10_ = eligible_variables;
					_tmp10__length1 = eligible_variables_length1;
					_tmp11_ = variable;
					_tmp12_ = g_strdup (_tmp11_);
					_vala_array_add5 (&eligible_variables, &eligible_variables_length1, &_eligible_variables_size_, _tmp12_);
				}
				_g_free0 (variable);
			}
		}
	}
	_tmp13_ = eligible_variables;
	_tmp13__length1 = eligible_variables_length1;
	if (result_length1) {
		*result_length1 = _tmp13__length1;
	}
	result = _tmp13_;
	variables = (_vala_array_free (variables, variables_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


void
math_variables_set (MathVariables* self,
                    const gchar* name,
                    Number* value)
{
	gboolean editing = FALSE;
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	gchar* _tmp2_;
	Number* _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = self->priv->registers;
	editing = g_hash_table_contains (_tmp0_, name);
	_tmp1_ = self->priv->registers;
	_tmp2_ = g_strdup (name);
	_tmp3_ = _g_object_ref0 (value);
	g_hash_table_insert (_tmp1_, _tmp2_, _tmp3_);
	math_variables_save (self);
	_tmp4_ = editing;
	if (_tmp4_) {
		g_signal_emit (self, math_variables_signals[MATH_VARIABLES_VARIABLE_EDITED_SIGNAL], 0, name, value);
	} else {
		g_signal_emit (self, math_variables_signals[MATH_VARIABLES_VARIABLE_ADDED_SIGNAL], 0, name, value);
	}
}


Number*
math_variables_get (MathVariables* self,
                    const gchar* name)
{
	Number* result = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	Number* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->registers;
	_tmp1_ = g_hash_table_lookup (_tmp0_, name);
	_tmp2_ = _g_object_ref0 ((Number*) _tmp1_);
	result = _tmp2_;
	return result;
}


void
math_variables_delete (MathVariables* self,
                       const gchar* name)
{
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->registers;
	g_hash_table_remove (_tmp0_, name);
	math_variables_save (self);
	g_signal_emit (self, math_variables_signals[MATH_VARIABLES_VARIABLE_DELETED_SIGNAL], 0, name);
}


static void
g_cclosure_user_marshal_VOID__STRING_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_OBJECT) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_object (param_values + 2), data2);
}


static void
math_variables_class_init (MathVariablesClass * klass)
{
	math_variables_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MathVariablesPrivate));
	G_OBJECT_CLASS (klass)->finalize = math_variables_finalize;
	math_variables_signals[MATH_VARIABLES_VARIABLE_ADDED_SIGNAL] = g_signal_new ("variable-added", TYPE_MATH_VARIABLES, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_OBJECT, G_TYPE_NONE, 2, G_TYPE_STRING, TYPE_NUMBER);
	math_variables_signals[MATH_VARIABLES_VARIABLE_EDITED_SIGNAL] = g_signal_new ("variable-edited", TYPE_MATH_VARIABLES, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_OBJECT, G_TYPE_NONE, 2, G_TYPE_STRING, TYPE_NUMBER);
	math_variables_signals[MATH_VARIABLES_VARIABLE_DELETED_SIGNAL] = g_signal_new ("variable-deleted", TYPE_MATH_VARIABLES, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void
math_variables_instance_init (MathVariables * self)
{
	self->priv = MATH_VARIABLES_GET_PRIVATE (self);
}


static void
math_variables_finalize (GObject * obj)
{
	MathVariables * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_VARIABLES, MathVariables);
	_g_free0 (self->priv->file_name);
	_g_hash_table_unref0 (self->priv->registers);
	_g_object_unref0 (self->priv->serializer);
	G_OBJECT_CLASS (math_variables_parent_class)->finalize (obj);
}


GType
math_variables_get_type (void)
{
	static volatile gsize math_variables_type_id__volatile = 0;
	if (g_once_init_enter (&math_variables_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MathVariablesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_variables_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathVariables), 0, (GInstanceInitFunc) math_variables_instance_init, NULL };
		GType math_variables_type_id;
		math_variables_type_id = g_type_register_static (G_TYPE_OBJECT, "MathVariables", &g_define_type_info, 0);
		g_once_init_leave (&math_variables_type_id__volatile, math_variables_type_id);
	}
	return math_variables_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



