/*
 * Copyright (c) 2003, 2007-14 Matteo Frigo
 * Copyright (c) 2003, 2007-14 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Thu May 24 08:06:36 EDT 2018 */

#include "rdft/codelet-rdft.h"

#if defined(ARCH_PREFERS_FMA) || defined(ISA_EXTENSION_PREFERS_FMA)

/* Generated by: ../../../genfft/gen_hc2hc.native -fma -compact -variables 4 -pipeline-latency 4 -twiddle-log3 -precompute-twiddles -n 32 -dit -name hf2_32 -include rdft/scalar/hf.h */

/*
 * This function contains 488 FP additions, 350 FP multiplications,
 * (or, 236 additions, 98 multiplications, 252 fused multiply/add),
 * 164 stack variables, 7 constants, and 128 memory accesses
 */
#include "rdft/scalar/hf.h"

static void hf2_32(R *cr, R *ci, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP198912367, +0.198912367379658006911597622644676228597850501);
     DK(KP668178637, +0.668178637919298919997757686523080761552472251);
     DK(KP414213562, +0.414213562373095048801688724209698078569671875);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * 8); m < me; m = m + 1, cr = cr + ms, ci = ci - ms, W = W + 8, MAKE_VOLATILE_STRIDE(64, rs)) {
	       E T2, T8, T3, T6, Te, Ti, T5, T7, TJ, Tb, TM, Tc, Ts, T23, T1w;
	       E T19, TA, TE, T1s, T1N, T1o, T1C, T1F, T1K, T15, T11, T2F, T31, T2J, T34;
	       E T3f, T3z, T3j, T3C, Tw, T3M, T3Q, T1z, T2s, T2w, T1d, T3n, T3r, T26, T2T;
	       E T2X, Th, TR, TP, Td, Tj, TW, Tn, TS, T1U, T2b, T29, T1R, T1V, T2g;
	       E T1Z, T2c;
	       {
		    E Tz, T1n, T10, TD, T1r, T14, T9, T1Q, Tv, T1c;
		    {
			 E T4, T18, Ta, Tr;
			 T2 = W[0];
			 T8 = W[4];
			 T3 = W[2];
			 T6 = W[3];
			 T4 = T2 * T3;
			 T18 = T3 * T8;
			 Ta = T2 * T6;
			 Tr = T2 * T8;
			 Te = W[6];
			 Tz = T3 * Te;
			 T1n = T8 * Te;
			 T10 = T2 * Te;
			 Ti = W[7];
			 TD = T3 * Ti;
			 T1r = T8 * Ti;
			 T14 = T2 * Ti;
			 T5 = W[1];
			 T7 = FMA(T5, T6, T4);
			 TJ = FNMS(T5, T6, T4);
			 T9 = T7 * T8;
			 T1Q = TJ * T8;
			 Tb = FNMS(T5, T3, Ta);
			 TM = FMA(T5, T3, Ta);
			 Tc = W[5];
			 Tv = T2 * Tc;
			 T1c = T3 * Tc;
			 Ts = FMA(T5, Tc, Tr);
			 T23 = FMA(T6, Tc, T18);
			 T1w = FNMS(T5, Tc, Tr);
			 T19 = FNMS(T6, Tc, T18);
		    }
		    TA = FMA(T6, Ti, Tz);
		    TE = FNMS(T6, Te, TD);
		    T1s = FNMS(Tc, Te, T1r);
		    T1N = FMA(T6, Te, TD);
		    T1o = FMA(Tc, Ti, T1n);
		    T1C = FMA(T5, Ti, T10);
		    T1F = FNMS(T5, Te, T14);
		    T1K = FNMS(T6, Ti, Tz);
		    T15 = FMA(T5, Te, T14);
		    T11 = FNMS(T5, Ti, T10);
		    {
			 E T2E, T2I, T2S, T2W;
			 T2E = T7 * Te;
			 T2F = FMA(Tb, Ti, T2E);
			 T31 = FNMS(Tb, Ti, T2E);
			 T2I = T7 * Ti;
			 T2J = FNMS(Tb, Te, T2I);
			 T34 = FMA(Tb, Te, T2I);
			 {
			      E T3e, T3i, T3L, T3P;
			      T3e = TJ * Te;
			      T3f = FNMS(TM, Ti, T3e);
			      T3z = FMA(TM, Ti, T3e);
			      T3i = TJ * Ti;
			      T3j = FMA(TM, Te, T3i);
			      T3C = FNMS(TM, Te, T3i);
			      T3L = Ts * Te;
			      T3P = Ts * Ti;
			      Tw = FNMS(T5, T8, Tv);
			      T3M = FMA(Tw, Ti, T3L);
			      T3Q = FNMS(Tw, Te, T3P);
			 }
			 {
			      E T2r, T2v, T3m, T3q;
			      T2r = T1w * Te;
			      T2v = T1w * Ti;
			      T1z = FMA(T5, T8, Tv);
			      T2s = FMA(T1z, Ti, T2r);
			      T2w = FNMS(T1z, Te, T2v);
			      T3m = T19 * Te;
			      T3q = T19 * Ti;
			      T1d = FMA(T6, T8, T1c);
			      T3n = FMA(T1d, Ti, T3m);
			      T3r = FNMS(T1d, Te, T3q);
			 }
			 T2S = T23 * Te;
			 T2W = T23 * Ti;
			 T26 = FNMS(T6, T8, T1c);
			 T2T = FMA(T26, Ti, T2S);
			 T2X = FNMS(T26, Te, T2W);
			 {
			      E TQ, TV, Tf, Tm, Tg;
			      Tg = T7 * Tc;
			      Th = FMA(Tb, T8, Tg);
			      TR = FNMS(Tb, T8, Tg);
			      TP = FMA(Tb, Tc, T9);
			      TQ = TP * Te;
			      TV = TP * Ti;
			      Td = FNMS(Tb, Tc, T9);
			      Tf = Td * Te;
			      Tm = Td * Ti;
			      Tj = FMA(Th, Ti, Tf);
			      TW = FNMS(TR, Te, TV);
			      Tn = FNMS(Th, Te, Tm);
			      TS = FMA(TR, Ti, TQ);
			 }
			 {
			      E T2a, T2f, T1S, T1Y, T1T;
			      T1T = TJ * Tc;
			      T1U = FMA(TM, T8, T1T);
			      T2b = FNMS(TM, T8, T1T);
			      T29 = FMA(TM, Tc, T1Q);
			      T2a = T29 * Te;
			      T2f = T29 * Ti;
			      T1R = FNMS(TM, Tc, T1Q);
			      T1S = T1R * Te;
			      T1Y = T1R * Ti;
			      T1V = FMA(T1U, Ti, T1S);
			      T2g = FNMS(T2b, Te, T2f);
			      T1Z = FNMS(T1U, Te, T1Y);
			      T2c = FMA(T2b, Ti, T2a);
			 }
		    }
	       }
	       {
		    E Tq, T46, T8H, T98, TH, T97, T4b, T8D, TZ, T7g, T4j, T6t, T1g, T7f, T4q;
		    E T6u, T1v, T1I, T7j, T7k, T7l, T7m, T4z, T6y, T4G, T6x, T22, T2j, T7o, T7p;
		    E T7q, T7r, T4O, T6B, T4V, T6A, T3G, T7G, T7N, T8n, T5E, T6M, T61, T6P, T2N;
		    E T7v, T7C, T8i, T55, T6F, T5s, T6I, T43, T7O, T7J, T8o, T5L, T63, T5S, T62;
		    E T3c, T7D, T7y, T8j, T5c, T5t, T5j, T5u;
		    {
			 E T1, T8G, Tk, Tl, To, T8E, Tp, T8F;
			 T1 = cr[0];
			 T8G = ci[0];
			 Tk = cr[WS(rs, 16)];
			 Tl = Tj * Tk;
			 To = ci[WS(rs, 16)];
			 T8E = Tj * To;
			 Tp = FMA(Tn, To, Tl);
			 Tq = T1 + Tp;
			 T46 = T1 - Tp;
			 T8F = FNMS(Tn, Tk, T8E);
			 T8H = T8F + T8G;
			 T98 = T8G - T8F;
		    }
		    {
			 E Tt, Tu, Tx, T47, TB, TC, TF, T49;
			 Tt = cr[WS(rs, 8)];
			 Tu = Ts * Tt;
			 Tx = ci[WS(rs, 8)];
			 T47 = Ts * Tx;
			 TB = cr[WS(rs, 24)];
			 TC = TA * TB;
			 TF = ci[WS(rs, 24)];
			 T49 = TA * TF;
			 {
			      E Ty, TG, T48, T4a;
			      Ty = FMA(Tw, Tx, Tu);
			      TG = FMA(TE, TF, TC);
			      TH = Ty + TG;
			      T97 = Ty - TG;
			      T48 = FNMS(Tw, Tt, T47);
			      T4a = FNMS(TE, TB, T49);
			      T4b = T48 - T4a;
			      T8D = T48 + T4a;
			 }
		    }
		    {
			 E TO, T4f, TY, T4h, T4d, T4i;
			 {
			      E TK, TL, TN, T4e;
			      TK = cr[WS(rs, 4)];
			      TL = TJ * TK;
			      TN = ci[WS(rs, 4)];
			      T4e = TJ * TN;
			      TO = FMA(TM, TN, TL);
			      T4f = FNMS(TM, TK, T4e);
			 }
			 {
			      E TT, TU, TX, T4g;
			      TT = cr[WS(rs, 20)];
			      TU = TS * TT;
			      TX = ci[WS(rs, 20)];
			      T4g = TS * TX;
			      TY = FMA(TW, TX, TU);
			      T4h = FNMS(TW, TT, T4g);
			 }
			 TZ = TO + TY;
			 T7g = T4f + T4h;
			 T4d = TO - TY;
			 T4i = T4f - T4h;
			 T4j = T4d - T4i;
			 T6t = T4d + T4i;
		    }
		    {
			 E T17, T4m, T1f, T4o, T4k, T4p;
			 {
			      E T12, T13, T16, T4l;
			      T12 = cr[WS(rs, 28)];
			      T13 = T11 * T12;
			      T16 = ci[WS(rs, 28)];
			      T4l = T11 * T16;
			      T17 = FMA(T15, T16, T13);
			      T4m = FNMS(T15, T12, T4l);
			 }
			 {
			      E T1a, T1b, T1e, T4n;
			      T1a = cr[WS(rs, 12)];
			      T1b = T19 * T1a;
			      T1e = ci[WS(rs, 12)];
			      T4n = T19 * T1e;
			      T1f = FMA(T1d, T1e, T1b);
			      T4o = FNMS(T1d, T1a, T4n);
			 }
			 T1g = T17 + T1f;
			 T7f = T4m + T4o;
			 T4k = T17 - T1f;
			 T4p = T4m - T4o;
			 T4q = T4k + T4p;
			 T6u = T4k - T4p;
		    }
		    {
			 E T1m, T4u, T1H, T4E, T1u, T4w, T1B, T4C;
			 {
			      E T1j, T1k, T1l, T4t;
			      T1j = cr[WS(rs, 2)];
			      T1k = T7 * T1j;
			      T1l = ci[WS(rs, 2)];
			      T4t = T7 * T1l;
			      T1m = FMA(Tb, T1l, T1k);
			      T4u = FNMS(Tb, T1j, T4t);
			 }
			 {
			      E T1D, T1E, T1G, T4D;
			      T1D = cr[WS(rs, 26)];
			      T1E = T1C * T1D;
			      T1G = ci[WS(rs, 26)];
			      T4D = T1C * T1G;
			      T1H = FMA(T1F, T1G, T1E);
			      T4E = FNMS(T1F, T1D, T4D);
			 }
			 {
			      E T1p, T1q, T1t, T4v;
			      T1p = cr[WS(rs, 18)];
			      T1q = T1o * T1p;
			      T1t = ci[WS(rs, 18)];
			      T4v = T1o * T1t;
			      T1u = FMA(T1s, T1t, T1q);
			      T4w = FNMS(T1s, T1p, T4v);
			 }
			 {
			      E T1x, T1y, T1A, T4B;
			      T1x = cr[WS(rs, 10)];
			      T1y = T1w * T1x;
			      T1A = ci[WS(rs, 10)];
			      T4B = T1w * T1A;
			      T1B = FMA(T1z, T1A, T1y);
			      T4C = FNMS(T1z, T1x, T4B);
			 }
			 T1v = T1m + T1u;
			 T1I = T1B + T1H;
			 T7j = T1v - T1I;
			 T7k = T4u + T4w;
			 T7l = T4C + T4E;
			 T7m = T7k - T7l;
			 {
			      E T4x, T4y, T4A, T4F;
			      T4x = T4u - T4w;
			      T4y = T1B - T1H;
			      T4z = T4x + T4y;
			      T6y = T4x - T4y;
			      T4A = T1m - T1u;
			      T4F = T4C - T4E;
			      T4G = T4A - T4F;
			      T6x = T4A + T4F;
			 }
		    }
		    {
			 E T1P, T4J, T2i, T4T, T21, T4L, T28, T4R;
			 {
			      E T1L, T1M, T1O, T4I;
			      T1L = cr[WS(rs, 30)];
			      T1M = T1K * T1L;
			      T1O = ci[WS(rs, 30)];
			      T4I = T1K * T1O;
			      T1P = FMA(T1N, T1O, T1M);
			      T4J = FNMS(T1N, T1L, T4I);
			 }
			 {
			      E T2d, T2e, T2h, T4S;
			      T2d = cr[WS(rs, 22)];
			      T2e = T2c * T2d;
			      T2h = ci[WS(rs, 22)];
			      T4S = T2c * T2h;
			      T2i = FMA(T2g, T2h, T2e);
			      T4T = FNMS(T2g, T2d, T4S);
			 }
			 {
			      E T1W, T1X, T20, T4K;
			      T1W = cr[WS(rs, 14)];
			      T1X = T1V * T1W;
			      T20 = ci[WS(rs, 14)];
			      T4K = T1V * T20;
			      T21 = FMA(T1Z, T20, T1X);
			      T4L = FNMS(T1Z, T1W, T4K);
			 }
			 {
			      E T24, T25, T27, T4Q;
			      T24 = cr[WS(rs, 6)];
			      T25 = T23 * T24;
			      T27 = ci[WS(rs, 6)];
			      T4Q = T23 * T27;
			      T28 = FMA(T26, T27, T25);
			      T4R = FNMS(T26, T24, T4Q);
			 }
			 T22 = T1P + T21;
			 T2j = T28 + T2i;
			 T7o = T22 - T2j;
			 T7p = T4J + T4L;
			 T7q = T4R + T4T;
			 T7r = T7p - T7q;
			 {
			      E T4M, T4N, T4P, T4U;
			      T4M = T4J - T4L;
			      T4N = T28 - T2i;
			      T4O = T4M + T4N;
			      T6B = T4M - T4N;
			      T4P = T1P - T21;
			      T4U = T4R - T4T;
			      T4V = T4P - T4U;
			      T6A = T4P + T4U;
			 }
		    }
		    {
			 E T3l, T5X, T3E, T5C, T3t, T5Z, T3y, T5A;
			 {
			      E T3g, T3h, T3k, T5W;
			      T3g = cr[WS(rs, 31)];
			      T3h = T3f * T3g;
			      T3k = ci[WS(rs, 31)];
			      T5W = T3f * T3k;
			      T3l = FMA(T3j, T3k, T3h);
			      T5X = FNMS(T3j, T3g, T5W);
			 }
			 {
			      E T3A, T3B, T3D, T5B;
			      T3A = cr[WS(rs, 23)];
			      T3B = T3z * T3A;
			      T3D = ci[WS(rs, 23)];
			      T5B = T3z * T3D;
			      T3E = FMA(T3C, T3D, T3B);
			      T5C = FNMS(T3C, T3A, T5B);
			 }
			 {
			      E T3o, T3p, T3s, T5Y;
			      T3o = cr[WS(rs, 15)];
			      T3p = T3n * T3o;
			      T3s = ci[WS(rs, 15)];
			      T5Y = T3n * T3s;
			      T3t = FMA(T3r, T3s, T3p);
			      T5Z = FNMS(T3r, T3o, T5Y);
			 }
			 {
			      E T3v, T3w, T3x, T5z;
			      T3v = cr[WS(rs, 7)];
			      T3w = TP * T3v;
			      T3x = ci[WS(rs, 7)];
			      T5z = TP * T3x;
			      T3y = FMA(TR, T3x, T3w);
			      T5A = FNMS(TR, T3v, T5z);
			 }
			 {
			      E T3u, T3F, T7L, T7M;
			      T3u = T3l + T3t;
			      T3F = T3y + T3E;
			      T3G = T3u + T3F;
			      T7G = T3u - T3F;
			      T7L = T5X + T5Z;
			      T7M = T5A + T5C;
			      T7N = T7L - T7M;
			      T8n = T7L + T7M;
			 }
			 {
			      E T5y, T5D, T5V, T60;
			      T5y = T3l - T3t;
			      T5D = T5A - T5C;
			      T5E = T5y - T5D;
			      T6M = T5y + T5D;
			      T5V = T3E - T3y;
			      T60 = T5X - T5Z;
			      T61 = T5V - T60;
			      T6P = T60 + T5V;
			 }
		    }
		    {
			 E T2q, T5n, T2L, T53, T2y, T5p, T2D, T51;
			 {
			      E T2n, T2o, T2p, T5m;
			      T2n = cr[WS(rs, 1)];
			      T2o = T2 * T2n;
			      T2p = ci[WS(rs, 1)];
			      T5m = T2 * T2p;
			      T2q = FMA(T5, T2p, T2o);
			      T5n = FNMS(T5, T2n, T5m);
			 }
			 {
			      E T2G, T2H, T2K, T52;
			      T2G = cr[WS(rs, 25)];
			      T2H = T2F * T2G;
			      T2K = ci[WS(rs, 25)];
			      T52 = T2F * T2K;
			      T2L = FMA(T2J, T2K, T2H);
			      T53 = FNMS(T2J, T2G, T52);
			 }
			 {
			      E T2t, T2u, T2x, T5o;
			      T2t = cr[WS(rs, 17)];
			      T2u = T2s * T2t;
			      T2x = ci[WS(rs, 17)];
			      T5o = T2s * T2x;
			      T2y = FMA(T2w, T2x, T2u);
			      T5p = FNMS(T2w, T2t, T5o);
			 }
			 {
			      E T2A, T2B, T2C, T50;
			      T2A = cr[WS(rs, 9)];
			      T2B = T8 * T2A;
			      T2C = ci[WS(rs, 9)];
			      T50 = T8 * T2C;
			      T2D = FMA(Tc, T2C, T2B);
			      T51 = FNMS(Tc, T2A, T50);
			 }
			 {
			      E T2z, T2M, T7A, T7B;
			      T2z = T2q + T2y;
			      T2M = T2D + T2L;
			      T2N = T2z + T2M;
			      T7v = T2z - T2M;
			      T7A = T5n + T5p;
			      T7B = T51 + T53;
			      T7C = T7A - T7B;
			      T8i = T7A + T7B;
			 }
			 {
			      E T4Z, T54, T5q, T5r;
			      T4Z = T2q - T2y;
			      T54 = T51 - T53;
			      T55 = T4Z - T54;
			      T6F = T4Z + T54;
			      T5q = T5n - T5p;
			      T5r = T2D - T2L;
			      T5s = T5q + T5r;
			      T6I = T5q - T5r;
			 }
		    }
		    {
			 E T3K, T5H, T41, T5Q, T3S, T5J, T3X, T5O;
			 {
			      E T3H, T3I, T3J, T5G;
			      T3H = cr[WS(rs, 3)];
			      T3I = T3 * T3H;
			      T3J = ci[WS(rs, 3)];
			      T5G = T3 * T3J;
			      T3K = FMA(T6, T3J, T3I);
			      T5H = FNMS(T6, T3H, T5G);
			 }
			 {
			      E T3Y, T3Z, T40, T5P;
			      T3Y = cr[WS(rs, 11)];
			      T3Z = Td * T3Y;
			      T40 = ci[WS(rs, 11)];
			      T5P = Td * T40;
			      T41 = FMA(Th, T40, T3Z);
			      T5Q = FNMS(Th, T3Y, T5P);
			 }
			 {
			      E T3N, T3O, T3R, T5I;
			      T3N = cr[WS(rs, 19)];
			      T3O = T3M * T3N;
			      T3R = ci[WS(rs, 19)];
			      T5I = T3M * T3R;
			      T3S = FMA(T3Q, T3R, T3O);
			      T5J = FNMS(T3Q, T3N, T5I);
			 }
			 {
			      E T3U, T3V, T3W, T5N;
			      T3U = cr[WS(rs, 27)];
			      T3V = Te * T3U;
			      T3W = ci[WS(rs, 27)];
			      T5N = Te * T3W;
			      T3X = FMA(Ti, T3W, T3V);
			      T5O = FNMS(Ti, T3U, T5N);
			 }
			 {
			      E T3T, T42, T7H, T7I;
			      T3T = T3K + T3S;
			      T42 = T3X + T41;
			      T43 = T3T + T42;
			      T7O = T42 - T3T;
			      T7H = T5O + T5Q;
			      T7I = T5H + T5J;
			      T7J = T7H - T7I;
			      T8o = T7I + T7H;
			 }
			 {
			      E T5F, T5K, T5M, T5R;
			      T5F = T3K - T3S;
			      T5K = T5H - T5J;
			      T5L = T5F - T5K;
			      T63 = T5F + T5K;
			      T5M = T3X - T41;
			      T5R = T5O - T5Q;
			      T5S = T5M + T5R;
			      T62 = T5M - T5R;
			 }
		    }
		    {
			 E T2R, T58, T3a, T5h, T2Z, T5a, T36, T5f;
			 {
			      E T2O, T2P, T2Q, T57;
			      T2O = cr[WS(rs, 5)];
			      T2P = T29 * T2O;
			      T2Q = ci[WS(rs, 5)];
			      T57 = T29 * T2Q;
			      T2R = FMA(T2b, T2Q, T2P);
			      T58 = FNMS(T2b, T2O, T57);
			 }
			 {
			      E T37, T38, T39, T5g;
			      T37 = cr[WS(rs, 13)];
			      T38 = T1R * T37;
			      T39 = ci[WS(rs, 13)];
			      T5g = T1R * T39;
			      T3a = FMA(T1U, T39, T38);
			      T5h = FNMS(T1U, T37, T5g);
			 }
			 {
			      E T2U, T2V, T2Y, T59;
			      T2U = cr[WS(rs, 21)];
			      T2V = T2T * T2U;
			      T2Y = ci[WS(rs, 21)];
			      T59 = T2T * T2Y;
			      T2Z = FMA(T2X, T2Y, T2V);
			      T5a = FNMS(T2X, T2U, T59);
			 }
			 {
			      E T32, T33, T35, T5e;
			      T32 = cr[WS(rs, 29)];
			      T33 = T31 * T32;
			      T35 = ci[WS(rs, 29)];
			      T5e = T31 * T35;
			      T36 = FMA(T34, T35, T33);
			      T5f = FNMS(T34, T32, T5e);
			 }
			 {
			      E T30, T3b, T7w, T7x;
			      T30 = T2R + T2Z;
			      T3b = T36 + T3a;
			      T3c = T30 + T3b;
			      T7D = T30 - T3b;
			      T7w = T5f + T5h;
			      T7x = T58 + T5a;
			      T7y = T7w - T7x;
			      T8j = T7x + T7w;
			 }
			 {
			      E T56, T5b, T5d, T5i;
			      T56 = T2R - T2Z;
			      T5b = T58 - T5a;
			      T5c = T56 - T5b;
			      T5t = T56 + T5b;
			      T5d = T36 - T3a;
			      T5i = T5f - T5h;
			      T5j = T5d + T5i;
			      T5u = T5i - T5d;
			 }
		    }
		    {
			 E T1i, T8c, T8z, T8A, T8J, T8O, T2l, T8N, T45, T8L, T8l, T8t, T8q, T8u, T8f;
			 E T8B;
			 {
			      E TI, T1h, T8x, T8y;
			      TI = Tq + TH;
			      T1h = TZ + T1g;
			      T1i = TI + T1h;
			      T8c = TI - T1h;
			      T8x = T8n + T8o;
			      T8y = T8i + T8j;
			      T8z = T8x - T8y;
			      T8A = T8y + T8x;
			 }
			 {
			      E T8C, T8I, T1J, T2k;
			      T8C = T7g + T7f;
			      T8I = T8D + T8H;
			      T8J = T8C + T8I;
			      T8O = T8I - T8C;
			      T1J = T1v + T1I;
			      T2k = T22 + T2j;
			      T2l = T1J + T2k;
			      T8N = T1J - T2k;
			 }
			 {
			      E T3d, T44, T8h, T8k;
			      T3d = T2N + T3c;
			      T44 = T3G + T43;
			      T45 = T3d + T44;
			      T8L = T44 - T3d;
			      T8h = T2N - T3c;
			      T8k = T8i - T8j;
			      T8l = T8h + T8k;
			      T8t = T8h - T8k;
			 }
			 {
			      E T8m, T8p, T8d, T8e;
			      T8m = T3G - T43;
			      T8p = T8n - T8o;
			      T8q = T8m - T8p;
			      T8u = T8m + T8p;
			      T8d = T7p + T7q;
			      T8e = T7k + T7l;
			      T8f = T8d - T8e;
			      T8B = T8e + T8d;
			 }
			 {
			      E T2m, T8K, T8M, T8w;
			      T2m = T1i + T2l;
			      ci[WS(rs, 15)] = T2m - T45;
			      cr[0] = T2m + T45;
			      T8K = T8B + T8J;
			      cr[WS(rs, 16)] = T8A - T8K;
			      ci[WS(rs, 31)] = T8A + T8K;
			      T8M = T8J - T8B;
			      cr[WS(rs, 24)] = T8L - T8M;
			      ci[WS(rs, 23)] = T8L + T8M;
			      T8w = T1i - T2l;
			      cr[WS(rs, 8)] = T8w - T8z;
			      ci[WS(rs, 7)] = T8w + T8z;
			 }
			 {
			      E T8g, T8r, T8P, T8Q;
			      T8g = T8c - T8f;
			      T8r = T8l + T8q;
			      ci[WS(rs, 11)] = FNMS(KP707106781, T8r, T8g);
			      cr[WS(rs, 4)] = FMA(KP707106781, T8r, T8g);
			      T8P = T8N + T8O;
			      T8Q = T8q - T8l;
			      cr[WS(rs, 28)] = FMS(KP707106781, T8Q, T8P);
			      ci[WS(rs, 19)] = FMA(KP707106781, T8Q, T8P);
			 }
			 {
			      E T8R, T8S, T8s, T8v;
			      T8R = T8O - T8N;
			      T8S = T8u - T8t;
			      cr[WS(rs, 20)] = FMS(KP707106781, T8S, T8R);
			      ci[WS(rs, 27)] = FMA(KP707106781, T8S, T8R);
			      T8s = T8c + T8f;
			      T8v = T8t + T8u;
			      cr[WS(rs, 12)] = FNMS(KP707106781, T8v, T8s);
			      ci[WS(rs, 3)] = FMA(KP707106781, T8v, T8s);
			 }
		    }
		    {
			 E T4s, T6c, T4X, T9c, T9b, T9h, T6f, T9i, T66, T6q, T6a, T6m, T5x, T6p, T69;
			 E T6j;
			 {
			      E T4c, T4r, T6d, T6e;
			      T4c = T46 - T4b;
			      T4r = T4j + T4q;
			      T4s = FNMS(KP707106781, T4r, T4c);
			      T6c = FMA(KP707106781, T4r, T4c);
			      {
				   E T4H, T4W, T99, T9a;
				   T4H = FMA(KP414213562, T4G, T4z);
				   T4W = FNMS(KP414213562, T4V, T4O);
				   T4X = T4H - T4W;
				   T9c = T4H + T4W;
				   T99 = T97 + T98;
				   T9a = T6t - T6u;
				   T9b = FMA(KP707106781, T9a, T99);
				   T9h = FNMS(KP707106781, T9a, T99);
			      }
			      T6d = FNMS(KP414213562, T4z, T4G);
			      T6e = FMA(KP414213562, T4O, T4V);
			      T6f = T6d + T6e;
			      T9i = T6e - T6d;
			      {
				   E T5U, T6k, T65, T6l, T5T, T64;
				   T5T = T5L + T5S;
				   T5U = FNMS(KP707106781, T5T, T5E);
				   T6k = FMA(KP707106781, T5T, T5E);
				   T64 = T62 - T63;
				   T65 = FNMS(KP707106781, T64, T61);
				   T6l = FMA(KP707106781, T64, T61);
				   T66 = FMA(KP668178637, T65, T5U);
				   T6q = FMA(KP198912367, T6k, T6l);
				   T6a = FNMS(KP668178637, T5U, T65);
				   T6m = FNMS(KP198912367, T6l, T6k);
			      }
			      {
				   E T5l, T6h, T5w, T6i, T5k, T5v;
				   T5k = T5c + T5j;
				   T5l = FNMS(KP707106781, T5k, T55);
				   T6h = FMA(KP707106781, T5k, T55);
				   T5v = T5t + T5u;
				   T5w = FNMS(KP707106781, T5v, T5s);
				   T6i = FMA(KP707106781, T5v, T5s);
				   T5x = FMA(KP668178637, T5w, T5l);
				   T6p = FMA(KP198912367, T6h, T6i);
				   T69 = FNMS(KP668178637, T5l, T5w);
				   T6j = FNMS(KP198912367, T6i, T6h);
			      }
			 }
			 {
			      E T4Y, T67, T9j, T9k;
			      T4Y = FMA(KP923879532, T4X, T4s);
			      T67 = T5x + T66;
			      ci[WS(rs, 12)] = FNMS(KP831469612, T67, T4Y);
			      cr[WS(rs, 3)] = FMA(KP831469612, T67, T4Y);
			      T9j = FMA(KP923879532, T9i, T9h);
			      T9k = T69 - T6a;
			      cr[WS(rs, 19)] = FMS(KP831469612, T9k, T9j);
			      ci[WS(rs, 28)] = FMA(KP831469612, T9k, T9j);
			 }
			 {
			      E T9l, T9m, T68, T6b;
			      T9l = FNMS(KP923879532, T9i, T9h);
			      T9m = T66 - T5x;
			      cr[WS(rs, 27)] = FMS(KP831469612, T9m, T9l);
			      ci[WS(rs, 20)] = FMA(KP831469612, T9m, T9l);
			      T68 = FNMS(KP923879532, T4X, T4s);
			      T6b = T69 + T6a;
			      cr[WS(rs, 11)] = FMA(KP831469612, T6b, T68);
			      ci[WS(rs, 4)] = FNMS(KP831469612, T6b, T68);
			 }
			 {
			      E T6g, T6n, T9d, T9e;
			      T6g = FMA(KP923879532, T6f, T6c);
			      T6n = T6j + T6m;
			      cr[WS(rs, 15)] = FNMS(KP980785280, T6n, T6g);
			      ci[0] = FMA(KP980785280, T6n, T6g);
			      T9d = FMA(KP923879532, T9c, T9b);
			      T9e = T6q - T6p;
			      cr[WS(rs, 31)] = FMS(KP980785280, T9e, T9d);
			      ci[WS(rs, 16)] = FMA(KP980785280, T9e, T9d);
			 }
			 {
			      E T9f, T9g, T6o, T6r;
			      T9f = FNMS(KP923879532, T9c, T9b);
			      T9g = T6m - T6j;
			      cr[WS(rs, 23)] = FMS(KP980785280, T9g, T9f);
			      ci[WS(rs, 24)] = FMA(KP980785280, T9g, T9f);
			      T6o = FNMS(KP923879532, T6f, T6c);
			      T6r = T6p + T6q;
			      ci[WS(rs, 8)] = FNMS(KP980785280, T6r, T6o);
			      cr[WS(rs, 7)] = FMA(KP980785280, T6r, T6o);
			 }
		    }
		    {
			 E T7i, T7W, T86, T8a, T8V, T91, T7t, T8W, T7F, T7U, T7Z, T92, T83, T89, T7Q;
			 E T7T;
			 {
			      E T7e, T7h, T84, T85;
			      T7e = Tq - TH;
			      T7h = T7f - T7g;
			      T7i = T7e - T7h;
			      T7W = T7e + T7h;
			      T84 = T7G + T7J;
			      T85 = T7O - T7N;
			      T86 = FNMS(KP414213562, T85, T84);
			      T8a = FMA(KP414213562, T84, T85);
			 }
			 {
			      E T8T, T8U, T7n, T7s;
			      T8T = TZ - T1g;
			      T8U = T8H - T8D;
			      T8V = T8T + T8U;
			      T91 = T8U - T8T;
			      T7n = T7j + T7m;
			      T7s = T7o - T7r;
			      T7t = T7n + T7s;
			      T8W = T7n - T7s;
			 }
			 {
			      E T7z, T7E, T7X, T7Y;
			      T7z = T7v - T7y;
			      T7E = T7C - T7D;
			      T7F = FMA(KP414213562, T7E, T7z);
			      T7U = FNMS(KP414213562, T7z, T7E);
			      T7X = T7j - T7m;
			      T7Y = T7o + T7r;
			      T7Z = T7X + T7Y;
			      T92 = T7Y - T7X;
			 }
			 {
			      E T81, T82, T7K, T7P;
			      T81 = T7v + T7y;
			      T82 = T7C + T7D;
			      T83 = FNMS(KP414213562, T82, T81);
			      T89 = FMA(KP414213562, T81, T82);
			      T7K = T7G - T7J;
			      T7P = T7N + T7O;
			      T7Q = FNMS(KP414213562, T7P, T7K);
			      T7T = FMA(KP414213562, T7K, T7P);
			 }
			 {
			      E T7u, T7R, T93, T94;
			      T7u = FMA(KP707106781, T7t, T7i);
			      T7R = T7F + T7Q;
			      ci[WS(rs, 13)] = FNMS(KP923879532, T7R, T7u);
			      cr[WS(rs, 2)] = FMA(KP923879532, T7R, T7u);
			      T93 = FMA(KP707106781, T92, T91);
			      T94 = T7U + T7T;
			      cr[WS(rs, 18)] = FMS(KP923879532, T94, T93);
			      ci[WS(rs, 29)] = FMA(KP923879532, T94, T93);
			 }
			 {
			      E T95, T96, T7S, T7V;
			      T95 = FNMS(KP707106781, T92, T91);
			      T96 = T7Q - T7F;
			      cr[WS(rs, 26)] = FMS(KP923879532, T96, T95);
			      ci[WS(rs, 21)] = FMA(KP923879532, T96, T95);
			      T7S = FNMS(KP707106781, T7t, T7i);
			      T7V = T7T - T7U;
			      cr[WS(rs, 10)] = FNMS(KP923879532, T7V, T7S);
			      ci[WS(rs, 5)] = FMA(KP923879532, T7V, T7S);
			 }
			 {
			      E T80, T87, T8X, T8Y;
			      T80 = FMA(KP707106781, T7Z, T7W);
			      T87 = T83 + T86;
			      cr[WS(rs, 14)] = FNMS(KP923879532, T87, T80);
			      ci[WS(rs, 1)] = FMA(KP923879532, T87, T80);
			      T8X = FMA(KP707106781, T8W, T8V);
			      T8Y = T8a - T89;
			      cr[WS(rs, 30)] = FMS(KP923879532, T8Y, T8X);
			      ci[WS(rs, 17)] = FMA(KP923879532, T8Y, T8X);
			 }
			 {
			      E T8Z, T90, T88, T8b;
			      T8Z = FNMS(KP707106781, T8W, T8V);
			      T90 = T86 - T83;
			      cr[WS(rs, 22)] = FMS(KP923879532, T90, T8Z);
			      ci[WS(rs, 25)] = FMA(KP923879532, T90, T8Z);
			      T88 = FNMS(KP707106781, T7Z, T7W);
			      T8b = T89 + T8a;
			      ci[WS(rs, 9)] = FNMS(KP923879532, T8b, T88);
			      cr[WS(rs, 6)] = FMA(KP923879532, T8b, T88);
			 }
		    }
		    {
			 E T6w, T6Y, T6D, T9w, T9p, T9v, T71, T9q, T6S, T7c, T6V, T78, T6L, T7b, T6W;
			 E T75;
			 {
			      E T6s, T6v, T6Z, T70;
			      T6s = T46 + T4b;
			      T6v = T6t + T6u;
			      T6w = FMA(KP707106781, T6v, T6s);
			      T6Y = FNMS(KP707106781, T6v, T6s);
			      {
				   E T6z, T6C, T9n, T9o;
				   T6z = FMA(KP414213562, T6y, T6x);
				   T6C = FNMS(KP414213562, T6B, T6A);
				   T6D = T6z + T6C;
				   T9w = T6z - T6C;
				   T9n = T98 - T97;
				   T9o = T4q - T4j;
				   T9p = FMA(KP707106781, T9o, T9n);
				   T9v = FNMS(KP707106781, T9o, T9n);
			      }
			      T6Z = FMA(KP414213562, T6A, T6B);
			      T70 = FNMS(KP414213562, T6x, T6y);
			      T71 = T6Z - T70;
			      T9q = T70 + T6Z;
			      {
				   E T6O, T76, T6R, T77, T6N, T6Q;
				   T6N = T63 + T62;
				   T6O = FMA(KP707106781, T6N, T6M);
				   T76 = FNMS(KP707106781, T6N, T6M);
				   T6Q = T5S - T5L;
				   T6R = FMA(KP707106781, T6Q, T6P);
				   T77 = FNMS(KP707106781, T6Q, T6P);
				   T6S = FNMS(KP198912367, T6R, T6O);
				   T7c = FNMS(KP668178637, T76, T77);
				   T6V = FMA(KP198912367, T6O, T6R);
				   T78 = FMA(KP668178637, T77, T76);
			      }
			      {
				   E T6H, T73, T6K, T74, T6G, T6J;
				   T6G = T5t - T5u;
				   T6H = FMA(KP707106781, T6G, T6F);
				   T73 = FNMS(KP707106781, T6G, T6F);
				   T6J = T5j - T5c;
				   T6K = FMA(KP707106781, T6J, T6I);
				   T74 = FNMS(KP707106781, T6J, T6I);
				   T6L = FMA(KP198912367, T6K, T6H);
				   T7b = FMA(KP668178637, T73, T74);
				   T6W = FNMS(KP198912367, T6H, T6K);
				   T75 = FNMS(KP668178637, T74, T73);
			      }
			 }
			 {
			      E T6E, T6T, T9x, T9y;
			      T6E = FMA(KP923879532, T6D, T6w);
			      T6T = T6L + T6S;
			      ci[WS(rs, 14)] = FNMS(KP980785280, T6T, T6E);
			      cr[WS(rs, 1)] = FMA(KP980785280, T6T, T6E);
			      T9x = FMA(KP923879532, T9w, T9v);
			      T9y = T7b + T7c;
			      cr[WS(rs, 29)] = -(FMA(KP831469612, T9y, T9x));
			      ci[WS(rs, 18)] = FNMS(KP831469612, T9y, T9x);
			 }
			 {
			      E T9z, T9A, T6U, T6X;
			      T9z = FNMS(KP923879532, T9w, T9v);
			      T9A = T78 - T75;
			      cr[WS(rs, 21)] = FMS(KP831469612, T9A, T9z);
			      ci[WS(rs, 26)] = FMA(KP831469612, T9A, T9z);
			      T6U = FNMS(KP923879532, T6D, T6w);
			      T6X = T6V - T6W;
			      cr[WS(rs, 9)] = FNMS(KP980785280, T6X, T6U);
			      ci[WS(rs, 6)] = FMA(KP980785280, T6X, T6U);
			 }
			 {
			      E T72, T79, T9r, T9s;
			      T72 = FMA(KP923879532, T71, T6Y);
			      T79 = T75 + T78;
			      cr[WS(rs, 13)] = FNMS(KP831469612, T79, T72);
			      ci[WS(rs, 2)] = FMA(KP831469612, T79, T72);
			      T9r = FMA(KP923879532, T9q, T9p);
			      T9s = T6W + T6V;
			      cr[WS(rs, 17)] = FMS(KP980785280, T9s, T9r);
			      ci[WS(rs, 30)] = FMA(KP980785280, T9s, T9r);
			 }
			 {
			      E T9t, T9u, T7a, T7d;
			      T9t = FNMS(KP923879532, T9q, T9p);
			      T9u = T6S - T6L;
			      cr[WS(rs, 25)] = FMS(KP980785280, T9u, T9t);
			      ci[WS(rs, 22)] = FMA(KP980785280, T9u, T9t);
			      T7a = FNMS(KP923879532, T71, T6Y);
			      T7d = T7b - T7c;
			      ci[WS(rs, 10)] = FNMS(KP831469612, T7d, T7a);
			      cr[WS(rs, 5)] = FMA(KP831469612, T7d, T7a);
			 }
		    }
	       }
	  }
     }
}

static const tw_instr twinstr[] = {
     {TW_CEXP, 1, 1},
     {TW_CEXP, 1, 3},
     {TW_CEXP, 1, 9},
     {TW_CEXP, 1, 27},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 32, "hf2_32", twinstr, &GENUS, {236, 98, 252, 0} };

void X(codelet_hf2_32) (planner *p) {
     X(khc2hc_register) (p, hf2_32, &desc);
}
#else

/* Generated by: ../../../genfft/gen_hc2hc.native -compact -variables 4 -pipeline-latency 4 -twiddle-log3 -precompute-twiddles -n 32 -dit -name hf2_32 -include rdft/scalar/hf.h */

/*
 * This function contains 488 FP additions, 280 FP multiplications,
 * (or, 376 additions, 168 multiplications, 112 fused multiply/add),
 * 158 stack variables, 7 constants, and 128 memory accesses
 */
#include "rdft/scalar/hf.h"

static void hf2_32(R *cr, R *ci, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP555570233, +0.555570233019602224742830813948532874374937191);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP195090322, +0.195090322016128267848284868477022240927691618);
     DK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * 8); m < me; m = m + 1, cr = cr + ms, ci = ci - ms, W = W + 8, MAKE_VOLATILE_STRIDE(64, rs)) {
	       E T2, T5, T3, T6, T8, TM, TO, Td, T9, Te, Th, Tl, TD, TH, T1y;
	       E T1H, T15, T1A, T11, T1F, T1n, T1p, T2q, T2I, T2u, T2K, T2V, T3b, T2Z, T3d;
	       E Tu, Ty, T3l, T3n, T1t, T1v, T2f, T2h, T1a, T1e, T32, T34, T1W, T1Y, T2C;
	       E T2E, Tg, TR, Tk, TS, Tm, TV, To, TT, T1M, T21, T1P, T22, T1Q, T25;
	       E T1S, T23;
	       {
		    E Ts, T1d, Tx, T18, Tt, T1c, Tw, T19, TB, T14, TG, TZ, TC, T13, TF;
		    E T10;
		    {
			 E T4, Tc, T7, Tb;
			 T2 = W[0];
			 T5 = W[1];
			 T3 = W[2];
			 T6 = W[3];
			 T4 = T2 * T3;
			 Tc = T5 * T3;
			 T7 = T5 * T6;
			 Tb = T2 * T6;
			 T8 = T4 + T7;
			 TM = T4 - T7;
			 TO = Tb + Tc;
			 Td = Tb - Tc;
			 T9 = W[4];
			 Ts = T2 * T9;
			 T1d = T6 * T9;
			 Tx = T5 * T9;
			 T18 = T3 * T9;
			 Te = W[5];
			 Tt = T5 * Te;
			 T1c = T3 * Te;
			 Tw = T2 * Te;
			 T19 = T6 * Te;
			 Th = W[6];
			 TB = T3 * Th;
			 T14 = T5 * Th;
			 TG = T6 * Th;
			 TZ = T2 * Th;
			 Tl = W[7];
			 TC = T6 * Tl;
			 T13 = T2 * Tl;
			 TF = T3 * Tl;
			 T10 = T5 * Tl;
		    }
		    TD = TB + TC;
		    TH = TF - TG;
		    T1y = TZ + T10;
		    T1H = TF + TG;
		    T15 = T13 + T14;
		    T1A = T13 - T14;
		    T11 = TZ - T10;
		    T1F = TB - TC;
		    T1n = FMA(T9, Th, Te * Tl);
		    T1p = FNMS(Te, Th, T9 * Tl);
		    {
			 E T2o, T2p, T2s, T2t;
			 T2o = T8 * Th;
			 T2p = Td * Tl;
			 T2q = T2o + T2p;
			 T2I = T2o - T2p;
			 T2s = T8 * Tl;
			 T2t = Td * Th;
			 T2u = T2s - T2t;
			 T2K = T2s + T2t;
		    }
		    {
			 E T2T, T2U, T2X, T2Y;
			 T2T = TM * Th;
			 T2U = TO * Tl;
			 T2V = T2T - T2U;
			 T3b = T2T + T2U;
			 T2X = TM * Tl;
			 T2Y = TO * Th;
			 T2Z = T2X + T2Y;
			 T3d = T2X - T2Y;
			 Tu = Ts + Tt;
			 Ty = Tw - Tx;
			 T3l = FMA(Tu, Th, Ty * Tl);
			 T3n = FNMS(Ty, Th, Tu * Tl);
		    }
		    T1t = Ts - Tt;
		    T1v = Tw + Tx;
		    T2f = FMA(T1t, Th, T1v * Tl);
		    T2h = FNMS(T1v, Th, T1t * Tl);
		    T1a = T18 - T19;
		    T1e = T1c + T1d;
		    T32 = FMA(T1a, Th, T1e * Tl);
		    T34 = FNMS(T1e, Th, T1a * Tl);
		    T1W = T18 + T19;
		    T1Y = T1c - T1d;
		    T2C = FMA(T1W, Th, T1Y * Tl);
		    T2E = FNMS(T1Y, Th, T1W * Tl);
		    {
			 E Ta, Tf, Ti, Tj;
			 Ta = T8 * T9;
			 Tf = Td * Te;
			 Tg = Ta - Tf;
			 TR = Ta + Tf;
			 Ti = T8 * Te;
			 Tj = Td * T9;
			 Tk = Ti + Tj;
			 TS = Ti - Tj;
		    }
		    Tm = FMA(Tg, Th, Tk * Tl);
		    TV = FNMS(TS, Th, TR * Tl);
		    To = FNMS(Tk, Th, Tg * Tl);
		    TT = FMA(TR, Th, TS * Tl);
		    {
			 E T1K, T1L, T1N, T1O;
			 T1K = TM * T9;
			 T1L = TO * Te;
			 T1M = T1K - T1L;
			 T21 = T1K + T1L;
			 T1N = TM * Te;
			 T1O = TO * T9;
			 T1P = T1N + T1O;
			 T22 = T1N - T1O;
		    }
		    T1Q = FMA(T1M, Th, T1P * Tl);
		    T25 = FNMS(T22, Th, T21 * Tl);
		    T1S = FNMS(T1P, Th, T1M * Tl);
		    T23 = FMA(T21, Th, T22 * Tl);
	       }
	       {
		    E TL, T6f, T8c, T8q, T3F, T5t, T7I, T7W, T2y, T6B, T6y, T7j, T4k, T5G, T4B;
		    E T5J, T3h, T6H, T6O, T7o, T4L, T5Q, T52, T5N, T1i, T7V, T6i, T7D, T3K, T5u;
		    E T3P, T5v, T1E, T6k, T6n, T7f, T3W, T5z, T41, T5y, T29, T6p, T6s, T7e, T47;
		    E T5C, T4c, T5B, T2R, T6z, T6E, T7k, T4v, T5K, T4E, T5H, T3y, T6P, T6K, T7p;
		    E T4W, T5O, T55, T5R;
		    {
			 E T1, T7G, Tq, T7F, TA, T3C, TJ, T3D, Tn, Tp;
			 T1 = cr[0];
			 T7G = ci[0];
			 Tn = cr[WS(rs, 16)];
			 Tp = ci[WS(rs, 16)];
			 Tq = FMA(Tm, Tn, To * Tp);
			 T7F = FNMS(To, Tn, Tm * Tp);
			 {
			      E Tv, Tz, TE, TI;
			      Tv = cr[WS(rs, 8)];
			      Tz = ci[WS(rs, 8)];
			      TA = FMA(Tu, Tv, Ty * Tz);
			      T3C = FNMS(Ty, Tv, Tu * Tz);
			      TE = cr[WS(rs, 24)];
			      TI = ci[WS(rs, 24)];
			      TJ = FMA(TD, TE, TH * TI);
			      T3D = FNMS(TH, TE, TD * TI);
			 }
			 {
			      E Tr, TK, T8a, T8b;
			      Tr = T1 + Tq;
			      TK = TA + TJ;
			      TL = Tr + TK;
			      T6f = Tr - TK;
			      T8a = TA - TJ;
			      T8b = T7G - T7F;
			      T8c = T8a + T8b;
			      T8q = T8b - T8a;
			 }
			 {
			      E T3B, T3E, T7E, T7H;
			      T3B = T1 - Tq;
			      T3E = T3C - T3D;
			      T3F = T3B + T3E;
			      T5t = T3B - T3E;
			      T7E = T3C + T3D;
			      T7H = T7F + T7G;
			      T7I = T7E + T7H;
			      T7W = T7H - T7E;
			 }
		    }
		    {
			 E T2e, T4x, T2w, T4i, T2j, T4y, T2n, T4h;
			 {
			      E T2c, T2d, T2r, T2v;
			      T2c = cr[WS(rs, 1)];
			      T2d = ci[WS(rs, 1)];
			      T2e = FMA(T2, T2c, T5 * T2d);
			      T4x = FNMS(T5, T2c, T2 * T2d);
			      T2r = cr[WS(rs, 25)];
			      T2v = ci[WS(rs, 25)];
			      T2w = FMA(T2q, T2r, T2u * T2v);
			      T4i = FNMS(T2u, T2r, T2q * T2v);
			 }
			 {
			      E T2g, T2i, T2l, T2m;
			      T2g = cr[WS(rs, 17)];
			      T2i = ci[WS(rs, 17)];
			      T2j = FMA(T2f, T2g, T2h * T2i);
			      T4y = FNMS(T2h, T2g, T2f * T2i);
			      T2l = cr[WS(rs, 9)];
			      T2m = ci[WS(rs, 9)];
			      T2n = FMA(T9, T2l, Te * T2m);
			      T4h = FNMS(Te, T2l, T9 * T2m);
			 }
			 {
			      E T2k, T2x, T6w, T6x;
			      T2k = T2e + T2j;
			      T2x = T2n + T2w;
			      T2y = T2k + T2x;
			      T6B = T2k - T2x;
			      T6w = T4x + T4y;
			      T6x = T4h + T4i;
			      T6y = T6w - T6x;
			      T7j = T6w + T6x;
			 }
			 {
			      E T4g, T4j, T4z, T4A;
			      T4g = T2e - T2j;
			      T4j = T4h - T4i;
			      T4k = T4g + T4j;
			      T5G = T4g - T4j;
			      T4z = T4x - T4y;
			      T4A = T2n - T2w;
			      T4B = T4z - T4A;
			      T5J = T4z + T4A;
			 }
		    }
		    {
			 E T31, T4H, T3f, T50, T36, T4I, T3a, T4Z;
			 {
			      E T2W, T30, T3c, T3e;
			      T2W = cr[WS(rs, 31)];
			      T30 = ci[WS(rs, 31)];
			      T31 = FMA(T2V, T2W, T2Z * T30);
			      T4H = FNMS(T2Z, T2W, T2V * T30);
			      T3c = cr[WS(rs, 23)];
			      T3e = ci[WS(rs, 23)];
			      T3f = FMA(T3b, T3c, T3d * T3e);
			      T50 = FNMS(T3d, T3c, T3b * T3e);
			 }
			 {
			      E T33, T35, T38, T39;
			      T33 = cr[WS(rs, 15)];
			      T35 = ci[WS(rs, 15)];
			      T36 = FMA(T32, T33, T34 * T35);
			      T4I = FNMS(T34, T33, T32 * T35);
			      T38 = cr[WS(rs, 7)];
			      T39 = ci[WS(rs, 7)];
			      T3a = FMA(TR, T38, TS * T39);
			      T4Z = FNMS(TS, T38, TR * T39);
			 }
			 {
			      E T37, T3g, T6M, T6N;
			      T37 = T31 + T36;
			      T3g = T3a + T3f;
			      T3h = T37 + T3g;
			      T6H = T37 - T3g;
			      T6M = T4H + T4I;
			      T6N = T4Z + T50;
			      T6O = T6M - T6N;
			      T7o = T6M + T6N;
			 }
			 {
			      E T4J, T4K, T4Y, T51;
			      T4J = T4H - T4I;
			      T4K = T3a - T3f;
			      T4L = T4J - T4K;
			      T5Q = T4J + T4K;
			      T4Y = T31 - T36;
			      T51 = T4Z - T50;
			      T52 = T4Y + T51;
			      T5N = T4Y - T51;
			 }
		    }
		    {
			 E TQ, T3H, T1g, T3N, TX, T3I, T17, T3M;
			 {
			      E TN, TP, T1b, T1f;
			      TN = cr[WS(rs, 4)];
			      TP = ci[WS(rs, 4)];
			      TQ = FMA(TM, TN, TO * TP);
			      T3H = FNMS(TO, TN, TM * TP);
			      T1b = cr[WS(rs, 12)];
			      T1f = ci[WS(rs, 12)];
			      T1g = FMA(T1a, T1b, T1e * T1f);
			      T3N = FNMS(T1e, T1b, T1a * T1f);
			 }
			 {
			      E TU, TW, T12, T16;
			      TU = cr[WS(rs, 20)];
			      TW = ci[WS(rs, 20)];
			      TX = FMA(TT, TU, TV * TW);
			      T3I = FNMS(TV, TU, TT * TW);
			      T12 = cr[WS(rs, 28)];
			      T16 = ci[WS(rs, 28)];
			      T17 = FMA(T11, T12, T15 * T16);
			      T3M = FNMS(T15, T12, T11 * T16);
			 }
			 {
			      E TY, T1h, T6g, T6h;
			      TY = TQ + TX;
			      T1h = T17 + T1g;
			      T1i = TY + T1h;
			      T7V = TY - T1h;
			      T6g = T3M + T3N;
			      T6h = T3H + T3I;
			      T6i = T6g - T6h;
			      T7D = T6h + T6g;
			 }
			 {
			      E T3G, T3J, T3L, T3O;
			      T3G = TQ - TX;
			      T3J = T3H - T3I;
			      T3K = T3G + T3J;
			      T5u = T3G - T3J;
			      T3L = T17 - T1g;
			      T3O = T3M - T3N;
			      T3P = T3L - T3O;
			      T5v = T3L + T3O;
			 }
		    }
		    {
			 E T1m, T3X, T1C, T3U, T1r, T3Y, T1x, T3T;
			 {
			      E T1k, T1l, T1z, T1B;
			      T1k = cr[WS(rs, 2)];
			      T1l = ci[WS(rs, 2)];
			      T1m = FMA(T8, T1k, Td * T1l);
			      T3X = FNMS(Td, T1k, T8 * T1l);
			      T1z = cr[WS(rs, 26)];
			      T1B = ci[WS(rs, 26)];
			      T1C = FMA(T1y, T1z, T1A * T1B);
			      T3U = FNMS(T1A, T1z, T1y * T1B);
			 }
			 {
			      E T1o, T1q, T1u, T1w;
			      T1o = cr[WS(rs, 18)];
			      T1q = ci[WS(rs, 18)];
			      T1r = FMA(T1n, T1o, T1p * T1q);
			      T3Y = FNMS(T1p, T1o, T1n * T1q);
			      T1u = cr[WS(rs, 10)];
			      T1w = ci[WS(rs, 10)];
			      T1x = FMA(T1t, T1u, T1v * T1w);
			      T3T = FNMS(T1v, T1u, T1t * T1w);
			 }
			 {
			      E T1s, T1D, T6l, T6m;
			      T1s = T1m + T1r;
			      T1D = T1x + T1C;
			      T1E = T1s + T1D;
			      T6k = T1s - T1D;
			      T6l = T3X + T3Y;
			      T6m = T3T + T3U;
			      T6n = T6l - T6m;
			      T7f = T6l + T6m;
			 }
			 {
			      E T3S, T3V, T3Z, T40;
			      T3S = T1m - T1r;
			      T3V = T3T - T3U;
			      T3W = T3S + T3V;
			      T5z = T3S - T3V;
			      T3Z = T3X - T3Y;
			      T40 = T1x - T1C;
			      T41 = T3Z - T40;
			      T5y = T3Z + T40;
			 }
		    }
		    {
			 E T1J, T43, T27, T4a, T1U, T44, T20, T49;
			 {
			      E T1G, T1I, T24, T26;
			      T1G = cr[WS(rs, 30)];
			      T1I = ci[WS(rs, 30)];
			      T1J = FMA(T1F, T1G, T1H * T1I);
			      T43 = FNMS(T1H, T1G, T1F * T1I);
			      T24 = cr[WS(rs, 22)];
			      T26 = ci[WS(rs, 22)];
			      T27 = FMA(T23, T24, T25 * T26);
			      T4a = FNMS(T25, T24, T23 * T26);
			 }
			 {
			      E T1R, T1T, T1X, T1Z;
			      T1R = cr[WS(rs, 14)];
			      T1T = ci[WS(rs, 14)];
			      T1U = FMA(T1Q, T1R, T1S * T1T);
			      T44 = FNMS(T1S, T1R, T1Q * T1T);
			      T1X = cr[WS(rs, 6)];
			      T1Z = ci[WS(rs, 6)];
			      T20 = FMA(T1W, T1X, T1Y * T1Z);
			      T49 = FNMS(T1Y, T1X, T1W * T1Z);
			 }
			 {
			      E T1V, T28, T6q, T6r;
			      T1V = T1J + T1U;
			      T28 = T20 + T27;
			      T29 = T1V + T28;
			      T6p = T1V - T28;
			      T6q = T43 + T44;
			      T6r = T49 + T4a;
			      T6s = T6q - T6r;
			      T7e = T6q + T6r;
			 }
			 {
			      E T45, T46, T48, T4b;
			      T45 = T43 - T44;
			      T46 = T20 - T27;
			      T47 = T45 - T46;
			      T5C = T45 + T46;
			      T48 = T1J - T1U;
			      T4b = T49 - T4a;
			      T4c = T48 + T4b;
			      T5B = T48 - T4b;
			 }
		    }
		    {
			 E T2B, T4m, T2G, T4n, T4l, T4o, T2M, T4q, T2P, T4r, T4s, T4t;
			 {
			      E T2z, T2A, T2D, T2F;
			      T2z = cr[WS(rs, 5)];
			      T2A = ci[WS(rs, 5)];
			      T2B = FMA(T21, T2z, T22 * T2A);
			      T4m = FNMS(T22, T2z, T21 * T2A);
			      T2D = cr[WS(rs, 21)];
			      T2F = ci[WS(rs, 21)];
			      T2G = FMA(T2C, T2D, T2E * T2F);
			      T4n = FNMS(T2E, T2D, T2C * T2F);
			 }
			 T4l = T2B - T2G;
			 T4o = T4m - T4n;
			 {
			      E T2J, T2L, T2N, T2O;
			      T2J = cr[WS(rs, 29)];
			      T2L = ci[WS(rs, 29)];
			      T2M = FMA(T2I, T2J, T2K * T2L);
			      T4q = FNMS(T2K, T2J, T2I * T2L);
			      T2N = cr[WS(rs, 13)];
			      T2O = ci[WS(rs, 13)];
			      T2P = FMA(T1M, T2N, T1P * T2O);
			      T4r = FNMS(T1P, T2N, T1M * T2O);
			 }
			 T4s = T4q - T4r;
			 T4t = T2M - T2P;
			 {
			      E T2H, T2Q, T6C, T6D;
			      T2H = T2B + T2G;
			      T2Q = T2M + T2P;
			      T2R = T2H + T2Q;
			      T6z = T2H - T2Q;
			      T6C = T4q + T4r;
			      T6D = T4m + T4n;
			      T6E = T6C - T6D;
			      T7k = T6D + T6C;
			 }
			 {
			      E T4p, T4u, T4C, T4D;
			      T4p = T4l + T4o;
			      T4u = T4s - T4t;
			      T4v = KP707106781 * (T4p - T4u);
			      T5K = KP707106781 * (T4p + T4u);
			      T4C = T4t + T4s;
			      T4D = T4l - T4o;
			      T4E = KP707106781 * (T4C - T4D);
			      T5H = KP707106781 * (T4D + T4C);
			 }
		    }
		    {
			 E T3k, T4S, T3p, T4T, T4R, T4U, T3t, T4N, T3w, T4O, T4M, T4P;
			 {
			      E T3i, T3j, T3m, T3o;
			      T3i = cr[WS(rs, 3)];
			      T3j = ci[WS(rs, 3)];
			      T3k = FMA(T3, T3i, T6 * T3j);
			      T4S = FNMS(T6, T3i, T3 * T3j);
			      T3m = cr[WS(rs, 19)];
			      T3o = ci[WS(rs, 19)];
			      T3p = FMA(T3l, T3m, T3n * T3o);
			      T4T = FNMS(T3n, T3m, T3l * T3o);
			 }
			 T4R = T3k - T3p;
			 T4U = T4S - T4T;
			 {
			      E T3r, T3s, T3u, T3v;
			      T3r = cr[WS(rs, 27)];
			      T3s = ci[WS(rs, 27)];
			      T3t = FMA(Th, T3r, Tl * T3s);
			      T4N = FNMS(Tl, T3r, Th * T3s);
			      T3u = cr[WS(rs, 11)];
			      T3v = ci[WS(rs, 11)];
			      T3w = FMA(Tg, T3u, Tk * T3v);
			      T4O = FNMS(Tk, T3u, Tg * T3v);
			 }
			 T4M = T3t - T3w;
			 T4P = T4N - T4O;
			 {
			      E T3q, T3x, T6I, T6J;
			      T3q = T3k + T3p;
			      T3x = T3t + T3w;
			      T3y = T3q + T3x;
			      T6P = T3q - T3x;
			      T6I = T4N + T4O;
			      T6J = T4S + T4T;
			      T6K = T6I - T6J;
			      T7p = T6J + T6I;
			 }
			 {
			      E T4Q, T4V, T53, T54;
			      T4Q = T4M + T4P;
			      T4V = T4R - T4U;
			      T4W = KP707106781 * (T4Q - T4V);
			      T5O = KP707106781 * (T4V + T4Q);
			      T53 = T4R + T4U;
			      T54 = T4P - T4M;
			      T55 = KP707106781 * (T53 - T54);
			      T5R = KP707106781 * (T53 + T54);
			 }
		    }
		    {
			 E T2b, T7x, T7K, T7M, T3A, T7L, T7A, T7B;
			 {
			      E T1j, T2a, T7C, T7J;
			      T1j = TL + T1i;
			      T2a = T1E + T29;
			      T2b = T1j + T2a;
			      T7x = T1j - T2a;
			      T7C = T7f + T7e;
			      T7J = T7D + T7I;
			      T7K = T7C + T7J;
			      T7M = T7J - T7C;
			 }
			 {
			      E T2S, T3z, T7y, T7z;
			      T2S = T2y + T2R;
			      T3z = T3h + T3y;
			      T3A = T2S + T3z;
			      T7L = T3z - T2S;
			      T7y = T7o + T7p;
			      T7z = T7j + T7k;
			      T7A = T7y - T7z;
			      T7B = T7z + T7y;
			 }
			 ci[WS(rs, 15)] = T2b - T3A;
			 cr[WS(rs, 24)] = T7L - T7M;
			 ci[WS(rs, 23)] = T7L + T7M;
			 cr[0] = T2b + T3A;
			 cr[WS(rs, 8)] = T7x - T7A;
			 cr[WS(rs, 16)] = T7B - T7K;
			 ci[WS(rs, 31)] = T7B + T7K;
			 ci[WS(rs, 7)] = T7x + T7A;
		    }
		    {
			 E T5x, T5Z, T8d, T8j, T5E, T88, T69, T6d, T5M, T5W, T62, T8i, T66, T6c, T5T;
			 E T5X, T5w, T89;
			 T5w = KP707106781 * (T5u + T5v);
			 T5x = T5t - T5w;
			 T5Z = T5t + T5w;
			 T89 = KP707106781 * (T3K - T3P);
			 T8d = T89 + T8c;
			 T8j = T8c - T89;
			 {
			      E T5A, T5D, T67, T68;
			      T5A = FMA(KP923879532, T5y, KP382683432 * T5z);
			      T5D = FNMS(KP923879532, T5C, KP382683432 * T5B);
			      T5E = T5A + T5D;
			      T88 = T5A - T5D;
			      T67 = T5N + T5O;
			      T68 = T5Q + T5R;
			      T69 = FNMS(KP980785280, T68, KP195090322 * T67);
			      T6d = FMA(KP980785280, T67, KP195090322 * T68);
			 }
			 {
			      E T5I, T5L, T60, T61;
			      T5I = T5G - T5H;
			      T5L = T5J - T5K;
			      T5M = FMA(KP831469612, T5I, KP555570233 * T5L);
			      T5W = FNMS(KP831469612, T5L, KP555570233 * T5I);
			      T60 = FNMS(KP382683432, T5y, KP923879532 * T5z);
			      T61 = FMA(KP382683432, T5C, KP923879532 * T5B);
			      T62 = T60 + T61;
			      T8i = T61 - T60;
			 }
			 {
			      E T64, T65, T5P, T5S;
			      T64 = T5G + T5H;
			      T65 = T5J + T5K;
			      T66 = FMA(KP195090322, T64, KP980785280 * T65);
			      T6c = FNMS(KP195090322, T65, KP980785280 * T64);
			      T5P = T5N - T5O;
			      T5S = T5Q - T5R;
			      T5T = FNMS(KP555570233, T5S, KP831469612 * T5P);
			      T5X = FMA(KP555570233, T5P, KP831469612 * T5S);
			 }
			 {
			      E T5F, T5U, T8h, T8k;
			      T5F = T5x + T5E;
			      T5U = T5M + T5T;
			      ci[WS(rs, 12)] = T5F - T5U;
			      cr[WS(rs, 3)] = T5F + T5U;
			      T8h = T5X - T5W;
			      T8k = T8i + T8j;
			      cr[WS(rs, 19)] = T8h - T8k;
			      ci[WS(rs, 28)] = T8h + T8k;
			 }
			 {
			      E T8l, T8m, T5V, T5Y;
			      T8l = T5T - T5M;
			      T8m = T8j - T8i;
			      cr[WS(rs, 27)] = T8l - T8m;
			      ci[WS(rs, 20)] = T8l + T8m;
			      T5V = T5x - T5E;
			      T5Y = T5W + T5X;
			      cr[WS(rs, 11)] = T5V - T5Y;
			      ci[WS(rs, 4)] = T5V + T5Y;
			 }
			 {
			      E T63, T6a, T87, T8e;
			      T63 = T5Z - T62;
			      T6a = T66 + T69;
			      ci[WS(rs, 8)] = T63 - T6a;
			      cr[WS(rs, 7)] = T63 + T6a;
			      T87 = T69 - T66;
			      T8e = T88 + T8d;
			      cr[WS(rs, 31)] = T87 - T8e;
			      ci[WS(rs, 16)] = T87 + T8e;
			 }
			 {
			      E T8f, T8g, T6b, T6e;
			      T8f = T6d - T6c;
			      T8g = T8d - T88;
			      cr[WS(rs, 23)] = T8f - T8g;
			      ci[WS(rs, 24)] = T8f + T8g;
			      T6b = T5Z + T62;
			      T6e = T6c + T6d;
			      cr[WS(rs, 15)] = T6b - T6e;
			      ci[0] = T6b + T6e;
			 }
		    }
		    {
			 E T7h, T7t, T7Q, T7S, T7m, T7u, T7r, T7v;
			 {
			      E T7d, T7g, T7O, T7P;
			      T7d = TL - T1i;
			      T7g = T7e - T7f;
			      T7h = T7d - T7g;
			      T7t = T7d + T7g;
			      T7O = T1E - T29;
			      T7P = T7I - T7D;
			      T7Q = T7O + T7P;
			      T7S = T7P - T7O;
			 }
			 {
			      E T7i, T7l, T7n, T7q;
			      T7i = T2y - T2R;
			      T7l = T7j - T7k;
			      T7m = T7i + T7l;
			      T7u = T7i - T7l;
			      T7n = T3h - T3y;
			      T7q = T7o - T7p;
			      T7r = T7n - T7q;
			      T7v = T7n + T7q;
			 }
			 {
			      E T7s, T7R, T7w, T7N;
			      T7s = KP707106781 * (T7m + T7r);
			      ci[WS(rs, 11)] = T7h - T7s;
			      cr[WS(rs, 4)] = T7h + T7s;
			      T7R = KP707106781 * (T7v - T7u);
			      cr[WS(rs, 20)] = T7R - T7S;
			      ci[WS(rs, 27)] = T7R + T7S;
			      T7w = KP707106781 * (T7u + T7v);
			      cr[WS(rs, 12)] = T7t - T7w;
			      ci[WS(rs, 3)] = T7t + T7w;
			      T7N = KP707106781 * (T7r - T7m);
			      cr[WS(rs, 28)] = T7N - T7Q;
			      ci[WS(rs, 19)] = T7N + T7Q;
			 }
		    }
		    {
			 E T6j, T7X, T83, T6X, T6u, T7U, T77, T7b, T70, T82, T6G, T6U, T74, T7a, T6R;
			 E T6V;
			 {
			      E T6o, T6t, T6A, T6F;
			      T6j = T6f - T6i;
			      T7X = T7V + T7W;
			      T83 = T7W - T7V;
			      T6X = T6f + T6i;
			      T6o = T6k + T6n;
			      T6t = T6p - T6s;
			      T6u = KP707106781 * (T6o + T6t);
			      T7U = KP707106781 * (T6o - T6t);
			      {
				   E T75, T76, T6Y, T6Z;
				   T75 = T6O + T6P;
				   T76 = T6H + T6K;
				   T77 = FMA(KP382683432, T75, KP923879532 * T76);
				   T7b = FNMS(KP923879532, T75, KP382683432 * T76);
				   T6Y = T6k - T6n;
				   T6Z = T6p + T6s;
				   T70 = KP707106781 * (T6Y + T6Z);
				   T82 = KP707106781 * (T6Z - T6Y);
			      }
			      T6A = T6y - T6z;
			      T6F = T6B - T6E;
			      T6G = FMA(KP382683432, T6A, KP923879532 * T6F);
			      T6U = FNMS(KP923879532, T6A, KP382683432 * T6F);
			      {
				   E T72, T73, T6L, T6Q;
				   T72 = T6B + T6E;
				   T73 = T6y + T6z;
				   T74 = FNMS(KP382683432, T73, KP923879532 * T72);
				   T7a = FMA(KP923879532, T73, KP382683432 * T72);
				   T6L = T6H - T6K;
				   T6Q = T6O - T6P;
				   T6R = FNMS(KP382683432, T6Q, KP923879532 * T6L);
				   T6V = FMA(KP923879532, T6Q, KP382683432 * T6L);
			      }
			 }
			 {
			      E T6v, T6S, T81, T84;
			      T6v = T6j + T6u;
			      T6S = T6G + T6R;
			      ci[WS(rs, 13)] = T6v - T6S;
			      cr[WS(rs, 2)] = T6v + T6S;
			      T81 = T6V - T6U;
			      T84 = T82 + T83;
			      cr[WS(rs, 18)] = T81 - T84;
			      ci[WS(rs, 29)] = T81 + T84;
			 }
			 {
			      E T85, T86, T6T, T6W;
			      T85 = T6R - T6G;
			      T86 = T83 - T82;
			      cr[WS(rs, 26)] = T85 - T86;
			      ci[WS(rs, 21)] = T85 + T86;
			      T6T = T6j - T6u;
			      T6W = T6U + T6V;
			      cr[WS(rs, 10)] = T6T - T6W;
			      ci[WS(rs, 5)] = T6T + T6W;
			 }
			 {
			      E T71, T78, T7T, T7Y;
			      T71 = T6X + T70;
			      T78 = T74 + T77;
			      cr[WS(rs, 14)] = T71 - T78;
			      ci[WS(rs, 1)] = T71 + T78;
			      T7T = T7b - T7a;
			      T7Y = T7U + T7X;
			      cr[WS(rs, 30)] = T7T - T7Y;
			      ci[WS(rs, 17)] = T7T + T7Y;
			 }
			 {
			      E T7Z, T80, T79, T7c;
			      T7Z = T77 - T74;
			      T80 = T7X - T7U;
			      cr[WS(rs, 22)] = T7Z - T80;
			      ci[WS(rs, 25)] = T7Z + T80;
			      T79 = T6X - T70;
			      T7c = T7a + T7b;
			      ci[WS(rs, 9)] = T79 - T7c;
			      cr[WS(rs, 6)] = T79 + T7c;
			 }
		    }
		    {
			 E T3R, T5d, T8r, T8x, T4e, T8o, T5n, T5r, T4G, T5a, T5g, T8w, T5k, T5q, T57;
			 E T5b, T3Q, T8p;
			 T3Q = KP707106781 * (T3K + T3P);
			 T3R = T3F - T3Q;
			 T5d = T3F + T3Q;
			 T8p = KP707106781 * (T5v - T5u);
			 T8r = T8p + T8q;
			 T8x = T8q - T8p;
			 {
			      E T42, T4d, T5l, T5m;
			      T42 = FNMS(KP923879532, T41, KP382683432 * T3W);
			      T4d = FMA(KP923879532, T47, KP382683432 * T4c);
			      T4e = T42 + T4d;
			      T8o = T4d - T42;
			      T5l = T52 + T55;
			      T5m = T4L + T4W;
			      T5n = FNMS(KP195090322, T5m, KP980785280 * T5l);
			      T5r = FMA(KP980785280, T5m, KP195090322 * T5l);
			 }
			 {
			      E T4w, T4F, T5e, T5f;
			      T4w = T4k - T4v;
			      T4F = T4B - T4E;
			      T4G = FNMS(KP555570233, T4F, KP831469612 * T4w);
			      T5a = FMA(KP831469612, T4F, KP555570233 * T4w);
			      T5e = FMA(KP382683432, T41, KP923879532 * T3W);
			      T5f = FNMS(KP382683432, T47, KP923879532 * T4c);
			      T5g = T5e + T5f;
			      T8w = T5e - T5f;
			 }
			 {
			      E T5i, T5j, T4X, T56;
			      T5i = T4B + T4E;
			      T5j = T4k + T4v;
			      T5k = FMA(KP195090322, T5i, KP980785280 * T5j);
			      T5q = FNMS(KP980785280, T5i, KP195090322 * T5j);
			      T4X = T4L - T4W;
			      T56 = T52 - T55;
			      T57 = FMA(KP555570233, T4X, KP831469612 * T56);
			      T5b = FNMS(KP831469612, T4X, KP555570233 * T56);
			 }
			 {
			      E T4f, T58, T8v, T8y;
			      T4f = T3R + T4e;
			      T58 = T4G + T57;
			      cr[WS(rs, 13)] = T4f - T58;
			      ci[WS(rs, 2)] = T4f + T58;
			      T8v = T5b - T5a;
			      T8y = T8w + T8x;
			      cr[WS(rs, 29)] = T8v - T8y;
			      ci[WS(rs, 18)] = T8v + T8y;
			 }
			 {
			      E T8z, T8A, T59, T5c;
			      T8z = T57 - T4G;
			      T8A = T8x - T8w;
			      cr[WS(rs, 21)] = T8z - T8A;
			      ci[WS(rs, 26)] = T8z + T8A;
			      T59 = T3R - T4e;
			      T5c = T5a + T5b;
			      ci[WS(rs, 10)] = T59 - T5c;
			      cr[WS(rs, 5)] = T59 + T5c;
			 }
			 {
			      E T5h, T5o, T8n, T8s;
			      T5h = T5d + T5g;
			      T5o = T5k + T5n;
			      ci[WS(rs, 14)] = T5h - T5o;
			      cr[WS(rs, 1)] = T5h + T5o;
			      T8n = T5r - T5q;
			      T8s = T8o + T8r;
			      cr[WS(rs, 17)] = T8n - T8s;
			      ci[WS(rs, 30)] = T8n + T8s;
			 }
			 {
			      E T8t, T8u, T5p, T5s;
			      T8t = T5n - T5k;
			      T8u = T8r - T8o;
			      cr[WS(rs, 25)] = T8t - T8u;
			      ci[WS(rs, 22)] = T8t + T8u;
			      T5p = T5d - T5g;
			      T5s = T5q + T5r;
			      cr[WS(rs, 9)] = T5p - T5s;
			      ci[WS(rs, 6)] = T5p + T5s;
			 }
		    }
	       }
	  }
     }
}

static const tw_instr twinstr[] = {
     {TW_CEXP, 1, 1},
     {TW_CEXP, 1, 3},
     {TW_CEXP, 1, 9},
     {TW_CEXP, 1, 27},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 32, "hf2_32", twinstr, &GENUS, {376, 168, 112, 0} };

void X(codelet_hf2_32) (planner *p) {
     X(khc2hc_register) (p, hf2_32, &desc);
}
#endif
