/*
 *  Some stress testing of case insensitive regexp normalization.
 */

/*@include util-regexp.js@*/

/*---
{
    "slow": true
}
---*/

/*===
256 [\u0000-\u0100] T258 F118 T1 F547 T1 F31 T1 F64579
257 [\u0001-\u0101] F1 T257 F118 T1 F547 T1 F31 T1 F64579
258 [\u0002-\u0102] F2 T258 F116 T1 F547 T1 F31 T1 F64579
259 [\u0003-\u0103] F3 T257 F116 T1 F547 T1 F31 T1 F64579
260 [\u0004-\u0104] F4 T258 F114 T1 F547 T1 F31 T1 F64579
261 [\u0005-\u0105] F5 T257 F114 T1 F547 T1 F31 T1 F64579
262 [\u0006-\u0106] F6 T258 F112 T1 F547 T1 F31 T1 F64579
263 [\u0007-\u0107] F7 T257 F112 T1 F547 T1 F31 T1 F64579
264 [\u0008-\u0108] F8 T258 F110 T1 F547 T1 F31 T1 F64579
265 [\u0009-\u0109] F9 T257 F110 T1 F547 T1 F31 T1 F64579
266 [\u000a-\u010a] F10 T258 F108 T1 F547 T1 F31 T1 F64579
267 [\u000b-\u010b] F11 T257 F108 T1 F547 T1 F31 T1 F64579
268 [\u000c-\u010c] F12 T258 F106 T1 F547 T1 F31 T1 F64579
269 [\u000d-\u010d] F13 T257 F106 T1 F547 T1 F31 T1 F64579
270 [\u000e-\u010e] F14 T258 F104 T1 F547 T1 F31 T1 F64579
271 [\u000f-\u010f] F15 T257 F104 T1 F547 T1 F31 T1 F64579
191 191 [\u00bf-\u00bf] F191 T1 F65344
191 192 [\u00bf-\u00c0] F191 T2 F31 T1 F65311
191 193 [\u00bf-\u00c1] F191 T3 F30 T2 F65310
191 222 [\u00bf-\u00de] F191 T32 F1 T23 F1 T7 F65281
191 223 [\u00bf-\u00df] F191 T56 F1 T7 F65281
191 224 [\u00bf-\u00e0] F191 T56 F1 T7 F65281
191 43935 [\u00bf-\uab9f] F181 T1 F9 T43777 F21568
191 43936 [\u00bf-\uaba0] F181 T1 F9 T43777 F21568
191 43937 [\u00bf-\uaba1] F181 T1 F9 T43777 F21568
191 43966 [\u00bf-\uabbe] F181 T1 F9 T43777 F21568
191 43967 [\u00bf-\uabbf] F181 T1 F9 T43777 F21568
191 43978 [\u00bf-\uabca] F181 T1 F9 T43788 F21557
191 43969 [\u00bf-\uabc1] F181 T1 F9 T43779 F21566
191 43998 [\u00bf-\uabde] F181 T1 F9 T43808 F21537
191 43999 [\u00bf-\uabdf] F181 T1 F9 T43809 F21536
191 44000 [\u00bf-\uabe0] F181 T1 F9 T43810 F21535
191 44001 [\u00bf-\uabe1] F181 T1 F9 T43811 F21534
192 192 [\u00c0-\u00c0] F192 T1 F31 T1 F65311
192 193 [\u00c0-\u00c1] F192 T2 F30 T2 F65310
192 222 [\u00c0-\u00de] F192 T31 F1 T23 F1 T7 F65281
192 223 [\u00c0-\u00df] F192 T55 F1 T7 F65281
192 224 [\u00c0-\u00e0] F192 T55 F1 T7 F65281
192 43935 [\u00c0-\uab9f] F181 T1 F10 T43776 F21568
192 43936 [\u00c0-\uaba0] F181 T1 F10 T43776 F21568
192 43937 [\u00c0-\uaba1] F181 T1 F10 T43776 F21568
192 43966 [\u00c0-\uabbe] F181 T1 F10 T43776 F21568
192 43967 [\u00c0-\uabbf] F181 T1 F10 T43776 F21568
192 43978 [\u00c0-\uabca] F181 T1 F10 T43787 F21557
192 43969 [\u00c0-\uabc1] F181 T1 F10 T43778 F21566
192 43998 [\u00c0-\uabde] F181 T1 F10 T43807 F21537
192 43999 [\u00c0-\uabdf] F181 T1 F10 T43808 F21536
192 44000 [\u00c0-\uabe0] F181 T1 F10 T43809 F21535
192 44001 [\u00c0-\uabe1] F181 T1 F10 T43810 F21534
193 193 [\u00c1-\u00c1] F193 T1 F31 T1 F65310
193 222 [\u00c1-\u00de] F193 T30 F2 T22 F1 T7 F65281
193 223 [\u00c1-\u00df] F193 T31 F1 T22 F1 T7 F65281
193 224 [\u00c1-\u00e0] F192 T55 F1 T7 F65281
193 43935 [\u00c1-\uab9f] F181 T1 F10 T43776 F21568
193 43936 [\u00c1-\uaba0] F181 T1 F10 T43776 F21568
193 43937 [\u00c1-\uaba1] F181 T1 F10 T43776 F21568
193 43966 [\u00c1-\uabbe] F181 T1 F10 T43776 F21568
193 43967 [\u00c1-\uabbf] F181 T1 F10 T43776 F21568
193 43978 [\u00c1-\uabca] F181 T1 F10 T43787 F21557
193 43969 [\u00c1-\uabc1] F181 T1 F10 T43778 F21566
193 43998 [\u00c1-\uabde] F181 T1 F10 T43807 F21537
193 43999 [\u00c1-\uabdf] F181 T1 F10 T43808 F21536
193 44000 [\u00c1-\uabe0] F181 T1 F10 T43809 F21535
193 44001 [\u00c1-\uabe1] F181 T1 F10 T43810 F21534
222 222 [\u00de-\u00de] F222 T1 F31 T1 F65281
222 223 [\u00de-\u00df] F222 T2 F30 T1 F65281
222 224 [\u00de-\u00e0] F192 T1 F29 T3 F29 T1 F65281
222 43935 [\u00de-\uab9f] F181 T1 F10 T23 F1 T43752 F21568
222 43936 [\u00de-\uaba0] F181 T1 F10 T23 F1 T43752 F21568
222 43937 [\u00de-\uaba1] F181 T1 F10 T23 F1 T43752 F21568
222 43966 [\u00de-\uabbe] F181 T1 F10 T23 F1 T43752 F21568
222 43967 [\u00de-\uabbf] F181 T1 F10 T23 F1 T43752 F21568
222 43978 [\u00de-\uabca] F181 T1 F10 T23 F1 T43763 F21557
222 43969 [\u00de-\uabc1] F181 T1 F10 T23 F1 T43754 F21566
222 43998 [\u00de-\uabde] F181 T1 F10 T23 F1 T43783 F21537
222 43999 [\u00de-\uabdf] F181 T1 F10 T23 F1 T43784 F21536
222 44000 [\u00de-\uabe0] F181 T1 F10 T23 F1 T43785 F21535
222 44001 [\u00de-\uabe1] F181 T1 F10 T23 F1 T43786 F21534
223 223 [\u00df-\u00df] F223 T1 F65312
223 224 [\u00df-\u00e0] F192 T1 F30 T2 F65311
223 43935 [\u00df-\uab9f] F181 T1 F10 T23 F1 T43752 F21568
223 43936 [\u00df-\uaba0] F181 T1 F10 T23 F1 T43752 F21568
223 43937 [\u00df-\uaba1] F181 T1 F10 T23 F1 T43752 F21568
223 43966 [\u00df-\uabbe] F181 T1 F10 T23 F1 T43752 F21568
223 43967 [\u00df-\uabbf] F181 T1 F10 T23 F1 T43752 F21568
223 43978 [\u00df-\uabca] F181 T1 F10 T23 F1 T43763 F21557
223 43969 [\u00df-\uabc1] F181 T1 F10 T23 F1 T43754 F21566
223 43998 [\u00df-\uabde] F181 T1 F10 T23 F1 T43783 F21537
223 43999 [\u00df-\uabdf] F181 T1 F10 T23 F1 T43784 F21536
223 44000 [\u00df-\uabe0] F181 T1 F10 T23 F1 T43785 F21535
223 44001 [\u00df-\uabe1] F181 T1 F10 T23 F1 T43786 F21534
224 224 [\u00e0-\u00e0] F192 T1 F31 T1 F65311
224 43935 [\u00e0-\uab9f] F181 T1 F10 T23 F1 T7 F1 T43744 F21568
224 43936 [\u00e0-\uaba0] F181 T1 F10 T23 F1 T7 F1 T43744 F21568
224 43937 [\u00e0-\uaba1] F181 T1 F10 T23 F1 T7 F1 T43744 F21568
224 43966 [\u00e0-\uabbe] F181 T1 F10 T23 F1 T7 F1 T43744 F21568
224 43967 [\u00e0-\uabbf] F181 T1 F10 T23 F1 T7 F1 T43744 F21568
224 43978 [\u00e0-\uabca] F181 T1 F10 T23 F1 T7 F1 T43755 F21557
224 43969 [\u00e0-\uabc1] F181 T1 F10 T23 F1 T7 F1 T43746 F21566
224 43998 [\u00e0-\uabde] F181 T1 F10 T23 F1 T7 F1 T43775 F21537
224 43999 [\u00e0-\uabdf] F181 T1 F10 T23 F1 T7 F1 T43776 F21536
224 44000 [\u00e0-\uabe0] F181 T1 F10 T23 F1 T7 F1 T43777 F21535
224 44001 [\u00e0-\uabe1] F181 T1 F10 T23 F1 T7 F1 T43778 F21534
43935 43935 [\uab9f-\uab9f] F5071 T1 F38863 T1 F21600
43935 43936 [\uab9f-\uaba0] F5071 T2 F38862 T2 F21599
43935 43937 [\uab9f-\uaba1] F5071 T3 F38861 T3 F21598
43935 43966 [\uab9f-\uabbe] F5071 T32 F38832 T32 F21569
43935 43967 [\uab9f-\uabbf] F5071 T33 F38831 T33 F21568
43935 43978 [\uab9f-\uabca] F5071 T33 F38831 T44 F21557
43935 43969 [\uab9f-\uabc1] F5071 T33 F38831 T35 F21566
43935 43998 [\uab9f-\uabde] F5071 T33 F38831 T64 F21537
43935 43999 [\uab9f-\uabdf] F5071 T33 F38831 T65 F21536
43935 44000 [\uab9f-\uabe0] F5071 T33 F38831 T66 F21535
43935 44001 [\uab9f-\uabe1] F5071 T33 F38831 T67 F21534
43936 43936 [\uaba0-\uaba0] F5072 T1 F38863 T1 F21599
43936 43937 [\uaba0-\uaba1] F5072 T2 F38862 T2 F21598
43936 43966 [\uaba0-\uabbe] F5072 T31 F38833 T31 F21569
43936 43967 [\uaba0-\uabbf] F5072 T32 F38832 T32 F21568
43936 43978 [\uaba0-\uabca] F5072 T32 F38832 T43 F21557
43936 43969 [\uaba0-\uabc1] F5072 T32 F38832 T34 F21566
43936 43998 [\uaba0-\uabde] F5072 T32 F38832 T63 F21537
43936 43999 [\uaba0-\uabdf] F5072 T32 F38832 T64 F21536
43936 44000 [\uaba0-\uabe0] F5072 T32 F38832 T65 F21535
43936 44001 [\uaba0-\uabe1] F5072 T32 F38832 T66 F21534
43937 43937 [\uaba1-\uaba1] F5073 T1 F38863 T1 F21598
43937 43966 [\uaba1-\uabbe] F5073 T30 F38834 T30 F21569
43937 43967 [\uaba1-\uabbf] F5073 T31 F38833 T31 F21568
43937 43978 [\uaba1-\uabca] F5073 T31 F38833 T42 F21557
43937 43969 [\uaba1-\uabc1] F5073 T31 F38833 T33 F21566
43937 43998 [\uaba1-\uabde] F5073 T31 F38833 T62 F21537
43937 43999 [\uaba1-\uabdf] F5073 T31 F38833 T63 F21536
43937 44000 [\uaba1-\uabe0] F5073 T31 F38833 T64 F21535
43937 44001 [\uaba1-\uabe1] F5073 T31 F38833 T65 F21534
43966 43966 [\uabbe-\uabbe] F5102 T1 F38863 T1 F21569
43966 43967 [\uabbe-\uabbf] F5102 T2 F38862 T2 F21568
43966 43978 [\uabbe-\uabca] F5102 T2 F38862 T13 F21557
43966 43969 [\uabbe-\uabc1] F5102 T2 F38862 T4 F21566
43966 43998 [\uabbe-\uabde] F5102 T2 F38862 T33 F21537
43966 43999 [\uabbe-\uabdf] F5102 T2 F38862 T34 F21536
43966 44000 [\uabbe-\uabe0] F5102 T2 F38862 T35 F21535
43966 44001 [\uabbe-\uabe1] F5102 T2 F38862 T36 F21534
43967 43967 [\uabbf-\uabbf] F5103 T1 F38863 T1 F21568
43967 43978 [\uabbf-\uabca] F5103 T1 F38863 T12 F21557
43967 43969 [\uabbf-\uabc1] F5103 T1 F38863 T3 F21566
43967 43998 [\uabbf-\uabde] F5103 T1 F38863 T32 F21537
43967 43999 [\uabbf-\uabdf] F5103 T1 F38863 T33 F21536
43967 44000 [\uabbf-\uabe0] F5103 T1 F38863 T34 F21535
43967 44001 [\uabbf-\uabe1] F5103 T1 F38863 T35 F21534
43978 43978 [\uabca-\uabca] F43978 T1 F21557
43978 43998 [\uabca-\uabde] F43978 T21 F21537
43978 43999 [\uabca-\uabdf] F43978 T22 F21536
43978 44000 [\uabca-\uabe0] F43978 T23 F21535
43978 44001 [\uabca-\uabe1] F43978 T24 F21534
43969 43978 [\uabc1-\uabca] F43969 T10 F21557
43969 43969 [\uabc1-\uabc1] F43969 T1 F21566
43969 43998 [\uabc1-\uabde] F43969 T30 F21537
43969 43999 [\uabc1-\uabdf] F43969 T31 F21536
43969 44000 [\uabc1-\uabe0] F43969 T32 F21535
43969 44001 [\uabc1-\uabe1] F43969 T33 F21534
43998 43998 [\uabde-\uabde] F43998 T1 F21537
43998 43999 [\uabde-\uabdf] F43998 T2 F21536
43998 44000 [\uabde-\uabe0] F43998 T3 F21535
43998 44001 [\uabde-\uabe1] F43998 T4 F21534
43999 43999 [\uabdf-\uabdf] F43999 T1 F21536
43999 44000 [\uabdf-\uabe0] F43999 T2 F21535
43999 44001 [\uabdf-\uabe1] F43999 T3 F21534
44000 44000 [\uabe0-\uabe0] F44000 T1 F21535
44000 44001 [\uabe0-\uabe1] F44000 T2 F21534
44001 44001 [\uabe1-\uabe1] F44001 T1 F21534
===*/

function test() {
    var re;
    var i;

    for (i = 0x100; i <= 0x10f; i++) {
        re = RegExpUtil.makeCaseInsensitiveCharClassRegExp(i - 0x100, i);
        print(i, re.source, RegExpUtil.getRegExpSingleCharMatches(re));
    }

    // The current canonicalization blocks that are different when continuity
    // across block edges are taken into account (or not):
    //
    // block 6 ([192,223]) differs
    // block 227 ([7264,7295]) differs
    // block 360 ([11520,11551]) differs
    // block 1373 ([43936,43967]) differs
    // block 1374 ([43968,43999]) differs

    var values = [
        191, 192, 193, 222, 223, 224,
        43935, 43936, 43937, 43966, 43967, 43978,
        43969, 43998, 43999, 44000, 44001
    ];
    values.forEach(function (v1) {
        values.forEach(function (v2) {
            if (v2 < v1) { return; }
            var re = RegExpUtil.makeCaseInsensitiveCharClassRegExp(v1, v2);
            print(v1, v2, re.source, RegExpUtil.getRegExpSingleCharMatches(re));
        });
    });
}

try {
    test();
} catch (e) {
    print(e.stack || e);
}
