.\" dpkg manual page - start-stop-daemon(8)
.\"
.\" Copyright © 1999 Klee Dienes <klee@mit.edu>
.\" Copyright © 1999 Ben Collins <bcollins@debian.org>
.\" Copyright © 2000-2001 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2002-2003 Adam Heath <doogie@debian.org>
.\" Copyright © 2004 Scott James Remnant <keybuk@debian.org>
.\" Copyright © 2008-2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH start\-stop\-daemon 8 %RELEASE_DATE% %VERSION% "suite dpkg"
.nh
.SH NOME
start\-stop\-daemon \- avvia e ferma i programmi demone di sistema
.
.SH SINTASSI
\fBstart\-stop\-daemon\fP [\fIopzione\fP...] \fIcomando\fP
.
.SH DESCRIZIONE
\fBstart\-stop\-daemon\fP viene usato per controllare la creazione e la
terminazione dei processi a livello di sistema. Usando una delle opzioni
corrispondenti, \fBstart\-stop\-daemon\fP può essere configurato per trovare le
istanze esistenti di un processo in esecuzione.
.PP
Nota: a meno che non venga specificata l'opzione \fB\-\-pid\fP o \fB\-\-pidfile\fP,
\fBstart\-stop\-daemon\fP si comporta in modo simile a
\fBkillall\fP(1). \fBstart\-stop\-daemon\fP analizza la tabella dei processi
cercando qualsiasi processo che corrisponde al nome, PID del genitore, UID o
GID (se specificati) di processo. Ogni processo che corrisponde impedirà a
\fB\-\-start\fP di avviare il demone. Se viene specificata l'opzione \fB\-\-stop\fP a
tutti i processi che corrispondono verrà inviato il segnale TERM (o quello
specificato con \fB\-\-signal\fP o \fB\-\-retry\fP). Per i demoni che hanno processi
figli di lunga vita che devono sopravvivere ad uno \fB\-\-stop\fP è necessario
specificare un file PID.
.
.SH COMANDI
.TP 
\fB\-S\fP, \fB\-\-start\fP [\fB\-\-\fP] \fIargomenti\fP
Controlla l'esistenza di un processo specifico. Se tale processo esiste,
\fBstart\-stop\-daemon\fP non fa nulla ed esce con lo stato di errore 1 (0 se
viene specificato \fB\-\-oknodo\fP). Se tale processo non esiste, viene avviata
un'istanza usando l'eseguibile specificato da \fB\-\-exec\fP oppure, se presente,
da \fB\-\-startas\fP. Tutti gli argomenti specificati dopo \fB\-\-\fP sulla riga di
comando vengono passati immutati al programma che viene avviato.
.TP 
\fB\-K\fP, \fB\-\-stop\fP
Controlla l'esistenza di un processo specificato. Se un tale processo
esiste, \fBstart\-stop\-daemon\fP gli invia il segnale specificato da \fB\-\-signal\fP
ed esce con lo stato di errore 0. Se tale processo non esiste,
\fBstart\-stop\-daemon\fP esce con stato di errore 1 (0 se viene specificato
\fB\-\-oknodo\fP). Se viene usata l'opzione \fB\-\-retry\fP, allora
\fBstart\-stop\-daemon\fP controllerà che i processi siano stati terminati.
.TP 
\fB\-T\fP, \fB\-\-status\fP
Check for the existence of a specified process, and returns an exit status
code, according to the LSB Init Script Actions (since version 1.16.1).
.TP 
\fB\-H\fP, \fB\-\-help\fP
Visualizza informazioni sull'uso ed esce.
.TP 
\fB\-V\fP, \fB\-\-version\fP
Visualizza la versione del programma ed esce.
.
.SH OPZIONI
.SS "Opzioni per corrispondenze"
.TP 
\fB\-\-pid\fP \fIpid\fP
Check for a process with the specified \fIpid\fP (since version 1.17.6).  The
\fIpid\fP must be a number greater than 0.
.TP 
\fB\-\-ppid\fP \fIppid\fP
Check for a process with the specified parent pid \fIppid\fP (since version
1.17.7).  The \fIppid\fP must be a number greater than 0.
.TP 
\fB\-p\fP, \fB\-\-pidfile\fP \fIfile\-pid\fP
Controlla se un processo ha creato il file \fIfile\-pid\fP. Nota: usare questa
opzione di corrispondenza da sola può causare effetti su processi non
desiderati, se il vecchio processo è stato terminato senza aver potuto
rimuovere il \fIfile\-pid\fP.
.TP 
\fB\-x\fP, \fB\-\-exec\fP \fIeseguibile\fP
Cerca i processi che sono istanze di questo \fIeseguibile\fP. L'argomento
\fIeseguibile\fP dovrebbe essere un nome di percorso assoluto. Nota: questo
potrebbe non funzionare come atteso con gli script interpretati, dato che
l'eseguibile punterà all'interprete. Tenere in considerazione che faranno
corrispondenza anche i processi in esecuzione in una chroot, perciò
potrebbero essere necessarie altre restrizioni della corrispondenza.
.TP 
\fB\-n\fP, \fB\-\-name\fP \fInome\-processo\fP
Cerca i processi con nome \fInome\-processo\fP. Questo è solitamente il nome del
file del processo, ma potrebbe essere stato cambiato dal processo
stesso. Nota: nella maggior parte dei sistemi questa informazione viene
recuperata del nome comm del processo nel kernel, che tende ad avere limiti
di lunghezza piuttosto limitati (nell'assunzione che più di 15 caratteri non
siano portabili).
.TP 
\fB\-u\fP, \fB\-\-user\fP \fInomeutente\fP|\fIuid\fP
Cerca i processi di proprietà dell'utente specificato da \fInomeutente\fP o
\fIuid\fP. Nota: l'uso di questa opzione di corrispondenza da sola farà sì che
l'azione abbia effetto su tutti i processi corrispondenti all'utente.
.
.SS "Opzioni generiche"
.TP 
\fB\-g\fP, \fB\-\-group\fP \fIgruppo\fP|\fIgid\fP
Modifica in \fIgroup\fP o \fIgid\fP quando avvia il processo.
.TP 
\fB\-s\fP, \fB\-\-signal\fP \fIsegnale\fP
Con \fB\-\-stop\fP specifica il segnale da inviare ai processi che vengono
fermati (quello predefinito è TERM).
.TP 
\fB\-R\fP, \fB\-\-retry\fP \fIscadenza\fP|\fIpianificazione\fP
Con \fB\-\-stop\fP specifica che \fBstart\-stop\-daemon\fP deve controllare se i
processi terminano effettivamente. Controlla ripetutamente se qualsiasi
processo corrispondente è in esecuzione fino a che nessuno lo è più. Se i
processi non terminano, effettua altre azioni in base alla pianificazione.

Se viene specificata una \fIscadenza\fP invece di una \fIpianificazione\fP, allora
viene usata la pianificazione \fIsegnale\fP\fB/\fP\fIscadenza\fP\fB/KILL/\fP\fIscadenza\fP,
dove \fIsegnale\fP è il segnale specificato da \fB\-\-signal\fP.

\fIpianificazione\fP è un elenco di almeno due elementi separati da barre
(\fB/\fP); ciascun elemento può essere \fB\-\fP\fInumero\-segnale\fP o
[\fB\-\fP]\fInome\-segnale\fP, che significa inviare quel segnale, o \fIscadenza\fP,
che significa aspettare che il processo termini per quel numero di secondi,
oppure \fBforever\fP, che significa ripetere il resto della pianificazione
all'infinito, se necessario.

Se viene raggiunta la fine della pianificazione e non viene specificato
\fBforever\fP, allora \fBstart\-stop\-daemon\fP esce con stato di errore 2. Se viene
specificata una pianificazione, allora viene ignorato qualsiasi segnale
specificato con \fB\-\-signal\fP.
.TP 
\fB\-a\fP, \fB\-\-startas\fP \fInomepercorso\fP
Con \fB\-\-start\fP, avvia il processo specificato da \fInomepercorso\fP. Se non
specificato, viene usato in modo predefinito l'argomento fornito a
\fB\-\-exec\fP.
.TP 
\fB\-t\fP, \fB\-\-test\fP
Visualizza le azioni che sarebbero effettuate e imposta il valore restituito
appropriato, ma non fa alcuna azione.
.TP 
\fB\-o\fP, \fB\-\-oknodo\fP
Restituisce lo stato di uscita 0 invece di 1 se non viene (o non verrebbe)
fatta alcuna azione.
.TP 
\fB\-q\fP, \fB\-\-quiet\fP
Non visualizza messaggi informativi; mostra solo i messaggi di errore.
.TP 
\fB\-c\fP, \fB\-\-chuid\fP \fInomeutente\fP|\fIuid\fP[\fB:\fP\fIgruppo\fP|\fIgid\fP]
Change to this username/uid before starting the process. You can also
specify a group by appending a \fB:\fP, then the group or gid in the same way
as you would for the \fBchown\fP(1) command (\fIuser\fP\fB:\fP\fIgroup\fP).  If a user
is specified without a group, the primary GID for that user is used.  When
using this option you must realize that the primary and supplemental groups
are set as well, even if the \fB\-\-group\fP option is not specified. The
\fB\-\-group\fP option is only for groups that the user isn't normally a member
of (like adding per process group membership for generic users like
\fBnobody\fP).
.TP 
\fB\-r\fP, \fB\-\-chroot\fP \fIroot\fP
Cambia la directory e la chroot a \fIroot\fP prima di avviare il
processo. Notare che anche il filepid viene scritto dopo chroot.
.TP 
\fB\-d\fP, \fB\-\-chdir\fP \fIpercorso\fP
Cambia la directory a \fIpercorso\fP prima di avviare il processo. Questo viene
fatto dopo chroot, se viene usata l'opzione \fB\-r\fP|\fB\-\-chroot\fP. Quando non
specificato, \fBstart\-stop\-daemon\fP cambia la directory in quella root prima
di avviare il processo.
.TP 
\fB\-b\fP, \fB\-\-background\fP
Typically used with programs that don't detach on their own. This option
will force \fBstart\-stop\-daemon\fP to fork before starting the process, and
force it into the background.  \fBWarning: start\-stop\-daemon\fP cannot check
the exit status if the process fails to execute for \fBany\fP reason. This is a
last resort, and is only meant for programs that either make no sense
forking on their own, or where it's not feasible to add the code for them to
do this themselves.
.TP 
\fB\-C\fP, \fB\-\-no\-close\fP
Do not close any file descriptor when forcing the daemon into the background
(since version 1.16.5).  Used for debugging purposes to see the process
output, or to redirect file descriptors to log the process output.  Only
relevant when using \fB\-\-background\fP.
.TP 
\fB\-N\fP, \fB\-\-nicelevel\fP \fIint\fP
Modifica la priorità del processo prima di avviarlo.
.TP 
\fB\-P\fP, \fB\-\-procsched\fP \fIpolitica\fP\fB:\fP\fIpriorità\fP
This alters the process scheduler policy and priority of the process before
starting it (since version 1.15.0).  The priority can be optionally
specified by appending a \fB:\fP followed by the value. The default \fIpriority\fP
is 0. The currently supported policy values are \fBother\fP, \fBfifo\fP and \fBrr\fP.
.TP 
\fB\-I\fP, \fB\-\-iosched\fP \fIclasse\fP\fB:\fP\fIpriorità\fP
This alters the IO scheduler class and priority of the process before
starting it (since version 1.15.0).  The priority can be optionally
specified by appending a \fB:\fP followed by the value. The default \fIpriority\fP
is 4, unless \fIclass\fP is \fBidle\fP, then \fIpriority\fP will always be 7. The
currently supported values for \fIclass\fP are \fBidle\fP, \fBbest\-effort\fP and
\fBreal\-time\fP.
.TP 
\fB\-k\fP, \fB\-\-umask\fP \fImaschera\fP
This sets the umask of the process before starting it (since version
1.13.22).
.TP 
\fB\-m\fP, \fB\-\-make\-pidfile\fP
Used when starting a program that does not create its own pid file. This
option will make \fBstart\-stop\-daemon\fP create the file referenced with
\fB\-\-pidfile\fP and place the pid into it just before executing the
process. Note, the file will only be removed when stopping the program if
\fB\-\-remove\-pidfile\fP is used.  \fBNote:\fP This feature may not work in all
cases. Most notably when the program being executed forks from its main
process. Because of this, it is usually only useful when combined with the
\fB\-\-background\fP option.
.TP 
\fB\-\-remove\-pidfile\fP
Used when stopping a program that does not remove its own pid file (since
version 1.17.19).  This option will make \fBstart\-stop\-daemon\fP remove the
file referenced with \fB\-\-pidfile\fP after terminating the process.
.TP 
\fB\-v\fP, \fB\-\-verbose\fP
Visualizza messaggi informativi dettagliati.
.
.SH "STATO D'USCITA"
.TP 
\fB0\fP
L'azione richiesta è stata effettuata. Se è stata specificata \fB\-\-oknodo\fP, è
anche possibile che non sia stato necessario fare nulla. Ciò può avvenire
quando viene specificata l'opzione \fB\-\-start\fP e un processo corrispondente è
già in esecuzione, oppure quando viene specificata \fB\-\-stop\fP e non c'è alcun
processo corrispondente.
.TP 
\fB1\fP
Se non è stata specificata \fB\-\-oknodo\fP e non è stato fatto nulla.
.TP 
\fB2\fP
Se sono state specificate \fB\-\-stop\fP e \fB\-\-retry\fP, ma è stata raggiunta la
fine della pianificazione e il processo era ancora in esecuzione.
.TP 
\fB3\fP
Qualsiasi altro errore.
.PP
Quando si usa il comando \fB\-\-status\fP, vengono restituiti i seguenti codici
di stato:
.TP 
\fB0\fP
Il programma è in esecuzione.
.TP 
\fB1\fP
Il programma non è in esecuzione e il file PID esiste.
.TP 
\fB3\fP
Il programma non è in esecuzione.
.TP 
\fB4\fP
Non è stato possibile determinare lo stato del programma.
.
.SH ESEMPIO
Avvia il demone \fBpippod\fP, a meno che uno non sia già in esecuzione (un
processo chiamato pippod, in esecuzione come utente pippod, con PID in
pippod.pid):
.IP
.nf
start\-stop\-daemon \-\-start \-\-oknodo \-\-user pippod \-\-name pippod \e
	\-\-pidfile /run/pippod.pid \-\-startas /usr/sbin/pippod \e
	\-\-chuid pippod \-\- \-\-daemon
.fi
.PP
Invia \fBSIGTERM\fP a \fBpippod\fP e attende fino a 5 secondi che esso si fermi:
.IP
.nf
start\-stop\-daemon \-\-stop \-\-oknodo \-\-user pippod \-\-name pippod \e
	\-\-pidfile /run/pippod.pid \-\-retry 5
.fi
.PP
Dimostrazione di una pianificazione personalizzata per fermare \fBpippod\fP:
.IP
.nf
start\-stop\-daemon \-\-stop \-\-oknodo \-\-user pippod \-\-name pippod \e
	\-\-pidfile /run/pippod.pid \-\-retry=TERM/30/KILL/5
.fi
