# Copyright 2012 Managed I.T.
#
# Author: Kiall Mac Innes <kiall@managedit.ie>
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.
from designate import context


# Decorators for actions
def args(*args, **kwargs):
    def _decorator(func):
        func.__dict__.setdefault('args', []).insert(0, (args, kwargs))
        return func
    return _decorator


def name(name):
    """
    Give a command a alternate name
    """
    def _decorator(func):
        func.__dict__['_cmd_name'] = name
        return func
    return _decorator


class Commands:
    def __init__(self):
        self.context = context.DesignateContext.get_admin_context(
            request_id='designate-manage'
        )
        self.output_message = ['']

    def _print_result(self):
        for message in self.output_message:
            print(message)
