//Original:/testcases/core/c_dsp32mac_a1a0_iuw32/c_dsp32mac_a1a0_iuw32.dsp
// Spec Reference: dsp32mac a1 a0 iuw32 MNOP
# mach: bfin

.include "testutils.inc"
	start


INIT_R_REGS 0;

imm32 r0, 0x00000000;
A0 = 0;
A1 = 0;
ASTAT = r0;


// test the (signed integer: no ) I=1
imm32 r0, 0x22345628;
imm32 r1, 0x23456729;
imm32 r2, 0x3456782a;
imm32 r3, 0x45678922;
imm32 r4, 0x56789123;
imm32 r5, 0x67891224;
imm32 r6, 0xa1234527;
imm32 r7, 0xc1234567;
A1 = R0.L * R7.L, A0 = R0.L * R7.L (IS);
R0 = A0.w;
R7 = A1.w;
A1 = R6.L * R1.L, A0 += R6.L * R1.H (IS);
R6 = A0.w;
R1 = A1.w;
A1 += R2.L * R3.L, A0 = R2.H * R3.L (IS);
R2 = A0.w;
R3 = A1.w;
A1 += R5.L * R4.L, A0 += R5.H * R4.H (IS);
R5 = A0.w;
R4 = A1.w;
CHECKREG r0, 0x175B7218;
CHECKREG r1, 0x1BDDC43F;
CHECKREG r2, 0xE7B2F96C;
CHECKREG r3, 0xE41233D3;
CHECKREG r4, 0xDC3712BF;
CHECKREG r5, 0x0AAB87A4;
CHECKREG r6, 0x20E26A9B;
CHECKREG r7, 0x175B7218;

imm32 r0, 0x13335678;
imm32 r1, 0x23436789;
imm32 r2, 0x3353789a;
imm32 r3, 0xa3638912;
imm32 r4, 0x53739123;
imm32 r5, 0x63831234;
imm32 r6, 0xa1234567;
imm32 r7, 0xc1234567;
A1 = R2.L * R7.H, A0 += R2.L * R7.L (IS);
R2 = A0.w;
R7 = A1.w;
A1 = R6.L * R1.H, A0 += R6.L * R1.H (IS);
R6 = A0.w;
R1 = A1.w;
A1 += R0.L * R5.H, A0 = R0.H * R5.L (IS);
R0 = A0.w;
R5 = A1.w;
A1 += R4.L * R3.H, A0 = R4.H * R3.H (IS);
R4 = A0.w;
R3 = A1.w;
CHECKREG r0, 0x015D7C5C;
CHECKREG r1, 0x098F3EF5;
CHECKREG r2, 0x2B5D8F9A;
CHECKREG r3, 0x53474FE6;
CHECKREG r4, 0xE1CF7E79;
CHECKREG r5, 0x2B2BE65D;
CHECKREG r6, 0x34ECCE8F;
CHECKREG r7, 0xE262970E;

imm32 r0, 0x14345678;
imm32 r1, 0x24456789;
imm32 r2, 0x3456789a;
imm32 r3, 0x44678912;
imm32 r4, 0x54789123;
imm32 r5, 0x67891244;
imm32 r6, 0xa1234547;
imm32 r7, 0xc1234547;
A1 += R4.H * R0.L, A0 = R4.L * R0.L (IS);
R4 = A0.w;
R0 = A1.w;
A1 = R3.H * R1.L, A0 += R3.L * R1.H (IS);
R3 = A0.w;
R1 = A1.w;
A1 = R2.H * R6.L, A0 = R2.H * R6.L (IS);
R2 = A0.w;
R6 = A1.w;
A1 += R7.H * R5.L, A0 += R7.H * R5.H (IS);
R7 = A0.w;
R5 = A1.w;
CHECKREG r0, 0x6FCF3826;
CHECKREG r1, 0x1BAA0C1F;
CHECKREG r2, 0x0E29B1DA;
CHECKREG r3, 0xC9B44442;
CHECKREG r4, 0xDA8DCA68;
CHECKREG r5, 0x09AD7526;
CHECKREG r6, 0x0E29B1DA;
CHECKREG r7, 0xF4BD2295;

imm32 r0, 0x15345678;
imm32 r1, 0x23556789;
imm32 r2, 0x3455789a;
imm32 r3, 0x45675912;
imm32 r4, 0x56789523;
imm32 r5, 0x67891234;
imm32 r6, 0xa1234557;
imm32 r7, 0xc1234565;
A1 += R0.H * R1.H, A0 = R0.L * R1.L (IS);
R0 = A0.w;
R1 = A1.w;
A1 = R5.H * R6.H, A0 = R5.L * R6.H (IS);
R5 = A0.w;
R6 = A1.w;
A1 = R4.H * R3.H, A0 += R4.H * R3.L (IS);
R4 = A0.w;
R3 = A1.w;
A1 = R2.H * R7.H, A0 = R2.H * R7.H (IS);
R2 = A0.w;
R7 = A1.w;
CHECKREG r0, 0x22F88E38;
CHECKREG r1, 0x0C9A9B6A;
CHECKREG r2, 0xF3263C9F;
CHECKREG r3, 0x17712248;
CHECKREG r4, 0x1756FD8C;
CHECKREG r5, 0xF941311C;
CHECKREG r6, 0xD9A250BB;
CHECKREG r7, 0xF3263C9F;

// test the (unsigned or integer :no ) U=1
imm32 r0, 0x62345678;
imm32 r1, 0x26456789;
imm32 r2, 0x3466789a;
imm32 r3, 0x45668912;
imm32 r4, 0x56786123;
imm32 r5, 0x67891634;
imm32 r6, 0xa1234567;
imm32 r7, 0xc1234566;
A1 = R0.L * R2.L, A0 = R0.L * R2.L (FU);
R0 = A0.w;
R2 = A1.w;
A1 = R1.L * R3.L, A0 += R1.L * R3.H (FU);
R1 = A0.w;
R3 = A1.w;
A1 += R4.L * R6.L, A0 = R4.H * R6.L (FU);
R4 = A0.w;
R6 = A1.w;
A1 += R5.L * R7.L, A0 += R5.H * R7.H (FU);
R5 = A0.w;
R7 = A1.w;
CHECKREG r0, 0x28BC4430;
CHECKREG r1, 0x44CD71C6;
CHECKREG r2, 0x28BC4430;
CHECKREG r3, 0x376F98A2;
CHECKREG r4, 0x17712248;
CHECKREG r5, 0x658D9303;
CHECKREG r6, 0x51C51CB7;
CHECKREG r7, 0x57C9F96F;

imm32 r0, 0x12345678;
imm32 r1, 0x73456789;
imm32 r2, 0x8456789a;
imm32 r3, 0x49998912;
imm32 r4, 0x56782123;
imm32 r5, 0x67891234;
imm32 r6, 0xa1234577;
imm32 r7, 0xc1234567;
A1 = R2.L * R3.H, A0 = R2.L * R3.L (FU);
R2 = A0.w;
R3 = A1.w;
A1 = R0.L * R1.H, A0 = R0.L * R1.H (FU);
R0 = A0.w;
R1 = A1.w;
A1 += R4.L * R5.H, A0 = R4.H * R5.L (FU);
R4 = A0.w;
R5 = A1.w;
A1 = R7.L * R6.H, A0 += R7.H * R6.H (FU);
R6 = A0.w;
R7 = A1.w;
CHECKREG r0, 0x26EF3658;
CHECKREG r1, 0x26EF3658;
CHECKREG r2, 0x4092E4D4;
CHECKREG r3, 0x22ABFE0A;
CHECKREG r4, 0x06260060;
CHECKREG r5, 0x34560713;
CHECKREG r6, 0x7FB76B29;
CHECKREG r7, 0x2BAF4415;

imm32 r0, 0x1234567a;
imm32 r1, 0x2345678a;
imm32 r2, 0x3456a89a;
imm32 r3, 0x4a678912;
imm32 r4, 0xa6789123;
imm32 r5, 0xc7891234;
imm32 r6, 0xa1234567;
imm32 r7, 0xc1234567;
A1 = R5.H * R4.L, A0 = R5.L * R4.L (FU);
R4 = A0.w;
R5 = A1.w;
A1 = R3.H * R2.L, A0 = R3.L * R2.H (FU);
R2 = A0.w;
R3 = A1.w;
A1 = R1.H * R0.L, A0 = R1.H * R0.L (FU);
R0 = A0.w;
R1 = A1.w;
A1 = R7.H * R6.L, A0 = R7.H * R6.H (FU);
R6 = A0.w;
R7 = A1.w;
CHECKREG r0, 0x0BE9FCE2;
CHECKREG r1, 0x0BE9FCE2;
CHECKREG r2, 0x1C05B40C;
CHECKREG r3, 0x310059F6;
CHECKREG r4, 0x0A51F11C;
CHECKREG r5, 0x711FE0BB;
CHECKREG r6, 0x79916AC9;
CHECKREG r7, 0x345C2415;

imm32 r0, 0xb2345678;
imm32 r1, 0x2b456789;
imm32 r2, 0x34b6789a;
imm32 r3, 0xc56b8912;
imm32 r4, 0x5c78b123;
imm32 r5, 0x67c91b34;
imm32 r6, 0xa12345b7;
imm32 r7, 0xc123456b;
A1 = R6.H * R7.H, A0 = R6.L * R7.L (FU);
R6 = A0.w;
R7 = A1.w;
A1 = R5.H * R4.H, A0 = R5.L * R4.H (FU);
R4 = A0.w;
R5 = A1.w;
A1 = R2.H * R3.H, A0 = R2.H * R3.L (FU);
R2 = A0.w;
R3 = A1.w;
A1 = R0.H * R1.H, A0 = R0.H * R1.H (FU);
R0 = A0.w;
R1 = A1.w;
CHECKREG r0, 0x1E1EC404;
CHECKREG r1, 0x1E1EC404;
CHECKREG r2, 0x1C391ACC;
CHECKREG r3, 0x28A61612;
CHECKREG r4, 0x09D37060;
CHECKREG r5, 0x257CE238;
CHECKREG r6, 0x12E7767D;
CHECKREG r7, 0x79916AC9;

// Test w32
imm32 r0, 0x123df178;
imm32 r1, 0x2245e189;
imm32 r2, 0x3256719a;
imm32 r3, 0x42678112;
imm32 r4, 0xa2789123;
imm32 r5, 0x62891134;
imm32 r6, 0xa2b34167;
imm32 r7, 0xc22d4167;
A1 = R0.L * R4.L, A0 += R0.L * R4.L (W32);
R0 = A0.w;
R4 = A1.w;
A1 = R1.L * R5.L, A0 += R1.L * R5.H (W32);
R1 = A0.w;
R5 = A1.w;
A1 = R2.L * R6.L, A0 += R2.H * R6.L (W32);
R2 = A0.w;
R6 = A1.w;
A1 = R3.L * R4.L, A0 += R3.H * R4.H (W32);
R3 = A0.w;
R4 = A1.w;
CHECKREG r0, 0x2AB4BAD4;
CHECKREG r1, 0x13410376;
CHECKREG r2, 0x2CF930AA;
CHECKREG r3, 0x33802490;
CHECKREG r4, 0x091C5540;
CHECKREG r5, 0xFBE7D1A8;
CHECKREG r6, 0x3A0B9DEC;
CHECKREG r7, 0xC22D4167;

imm32 r0, 0x553df344;
imm32 r1, 0x2525e349;
imm32 r2, 0x3252734a;
imm32 r3, 0x42658342;
imm32 r4, 0xa5789343;
imm32 r5, 0x63591344;
imm32 r6, 0xa3b54347;
imm32 r7, 0xc32d4347;
A1 += R0.L * R4.H, A0 = R0.L * R4.L (W32);
R0 = A0.w;
R4 = A1.w;
A1 += R1.L * R5.H, A0 = R1.L * R5.H (W32);
R1 = A0.w;
R5 = A1.w;
A1 += R2.L * R6.H, A0 = R2.H * R6.L (W32);
R2 = A0.w;
R6 = A1.w;
A1 += R3.L * R4.H, A0 = R3.H * R4.H (W32);
R3 = A0.w;
R4 = A1.w;
CHECKREG r0, 0x0AD16D98;
CHECKREG r1, 0xE9B67EC2;
CHECKREG r2, 0x1A72D57C;
CHECKREG r3, 0x0965C3AC;
CHECKREG r4, 0x970BD9DE;
CHECKREG r5, 0xFBD48BC2;
CHECKREG r6, 0xA8B3CE66;
CHECKREG r7, 0xC32D4347;

imm32 r0, 0x163df678;
imm32 r1, 0x2625e689;
imm32 r2, 0x3652769a;
imm32 r3, 0x46628612;
imm32 r4, 0xa6789623;
imm32 r5, 0x63691634;
imm32 r6, 0xa3634367;
imm32 r7, 0xc3264667;
A1 += R0.H * R4.L, A0 = R0.L * R4.L (W32);
R0 = A0.w;
R4 = A1.w;
A1 = R1.H * R5.L, A0 += R1.L * R5.H (W32);
R1 = A0.w;
R5 = A1.w;
A1 += R2.H * R6.L, A0 = R2.H * R6.L (W32);
R2 = A0.w;
R6 = A1.w;
A1 += R3.H * R4.L, A0 += R3.H * R4.H (W32);
R3 = A0.w;
R4 = A1.w;
CHECKREG r0, 0x07E204D0;
CHECKREG r1, 0xF41B1732;
CHECKREG r2, 0x1C9AA1FC;
CHECKREG r3, 0xD8C785D8;
CHECKREG r4, 0x5DCEA034;
CHECKREG r5, 0x069DDB08;
CHECKREG r6, 0x23387D04;
CHECKREG r7, 0xC3264667;

imm32 r0, 0x123df378;
imm32 r1, 0x2225e389;
imm32 r2, 0x3252739a;
imm32 r3, 0x42628312;
imm32 r4, 0xa3789323;
imm32 r5, 0x63891334;
imm32 r6, 0xa3b34367;
imm32 r7, 0xc32d4367;
A1 += R0.H * R4.H, A0 = R0.L * R4.L (W32);
R0 = A0.w;
R4 = A1.w;
A1 = R1.H * R5.H, A0 = R1.L * R5.H (W32);
R1 = A0.w;
R5 = A1.w;
A1 += R2.H * R6.H, A0 = R2.H * R6.L (W32);
R2 = A0.w;
R6 = A1.w;
A1 = R3.H * R4.H, A0 = R3.H * R4.H (W32);
R3 = A0.w;
R4 = A1.w;
CHECKREG r0, 0x0AA862D0;
CHECKREG r1, 0xE9DD7EA2;
CHECKREG r2, 0x1A7F69FC;
CHECKREG r3, 0x29CFB5BC;
CHECKREG r4, 0x29CFB5BC;
CHECKREG r5, 0x1A8D299A;
CHECKREG r6, 0xF643F446;
CHECKREG r7, 0xC32D4367;

imm32 r0, 0x123df678;
imm32 r1, 0x2345e789;
imm32 r2, 0x34567b9a;
imm32 r3, 0x45678c12;
imm32 r4, 0xa6789123;
imm32 r5, 0x6c891234;
imm32 r6, 0xa1b34567;
imm32 r7, 0xc12d4567;
A1 = R0.H * R4.L, A0 = R0.H * R4.L (W32);
R0 = A0.w;
R4 = A1.w;
A1 = R1.H * R5.L, A0 = R1.H * R5.H (W32);
R1 = A0.w;
R5 = A1.w;
A1 = R2.H * R6.H, A0 = R2.L * R6.L (W32);
R2 = A0.w;
R6 = A1.w;
A1 = R3.H * R4.H, A0 = R3.L * R4.H (W32);
R3 = A0.w;
R4 = A1.w;
CHECKREG r0, 0xF03416AE;
CHECKREG r1, 0x1DE7F7DA;
CHECKREG r2, 0x430479EC;
CHECKREG r3, 0x0E4EA750;
CHECKREG r4, 0xF76F51D8;
CHECKREG r5, 0x05040808;
CHECKREG r6, 0xD9715C44;
CHECKREG r7, 0xC12D4567;

// MNOP & w32
imm32 r0, 0x623df17a;
imm32 r1, 0x7245e18b;
imm32 r2, 0x8256719a;
imm32 r3, 0x92678112;
imm32 r4, 0xa2789123;
imm32 r5, 0xb2891134;
imm32 r6, 0xc2b34167;
imm32 r7, 0xd22d4167;
A0 += R0.L * R4.L (W32);
R0 = A0.w;
R4 = A1.w;
A0 = R1.L * R5.H (W32);
R1 = A0.w;
R5 = A1.w;
A0 += R2.H * R6.L (W32);
R2 = A0.w;
R6 = A1.w;
A0 = R3.H * R7.H (W32);
R3 = A0.w;
R7 = A1.w;
CHECKREG r0, 0x1AE2E2AC;
CHECKREG r1, 0x126EB2C6;
CHECKREG r2, 0xD2393FFA;
CHECKREG r3, 0x273C7436;
CHECKREG r4, 0xF76F51D8;
CHECKREG r5, 0xF76F51D8;
CHECKREG r6, 0xF76F51D8;
CHECKREG r7, 0xF76F51D8;

imm32 r0, 0xa23df17a;
imm32 r1, 0x7b45e18b;
imm32 r2, 0x82c6719a;
imm32 r3, 0x126d8112;
imm32 r4, 0xc278e123;
imm32 r5, 0xb2491f34;
imm32 r6, 0x89b54167;
imm32 r7, 0xd25d6767;
A1 += R0.L * R4.L (W32);
R0 = A0.w;
R4 = A1.w;
A1 = R1.L * R5.H (W32);
R1 = A0.w;
R5 = A1.w;
A1 += R2.H * R6.L (W32);
R2 = A0.w;
R6 = A1.w;
A1 = R3.H * R7.H (W32);
R3 = A0.w;
R7 = A1.w;
CHECKREG r0, 0x273C7436;
CHECKREG r1, 0x273C7436;
CHECKREG r2, 0x273C7436;
CHECKREG r3, 0x273C7436;
CHECKREG r4, 0xFAEFCD34;
CHECKREG r5, 0x127DED46;
CHECKREG r6, 0xD281B49A;
CHECKREG r7, 0xF96E3732;

// test MM=1(Mix mode), MAC1 executes a mixed mode multiplication: (one input is
// signed, the other input is unsigned
imm32 r0, 0x22345628;
imm32 r1, 0x23456729;
imm32 r2, 0x3456782a;
imm32 r3, 0x45678922;
imm32 r4, 0x56789123;
imm32 r5, 0x67891224;
imm32 r6, 0xa1234527;
imm32 r7, 0xc1234567;
A1 += R0.L * R7.L (M), A0 = R0.L * R7.L (IS);
R0 = A0.w;
R7 = A1.w;
A1 = R6.L * R1.L (M), A0 += R6.L * R1.H (IS);
R6 = A0.w;
R1 = A1.w;
A1 = R2.L * R3.L (M), A0 = R2.H * R3.L (IS);
R2 = A0.w;
R3 = A1.w;
A1 += R5.L * R4.L (M), A0 += R5.H * R4.H (IS);
R5 = A0.w;
R4 = A1.w;
CHECKREG r0, 0x175B7218;
CHECKREG r1, 0x1BDDC43F;
CHECKREG r2, 0xE7B2F96C;
CHECKREG r3, 0x405E6F94;
CHECKREG r4, 0x4AA74E80;
CHECKREG r5, 0x0AAB87A4;
CHECKREG r6, 0x20E26A9B;
CHECKREG r7, 0x10C9A94A;

imm32 r0, 0x13335678;
imm32 r1, 0x23436789;
imm32 r2, 0x3353789a;
imm32 r3, 0xa3638912;
imm32 r4, 0x53739123;
imm32 r5, 0x63831234;
imm32 r6, 0xa1234567;
imm32 r7, 0xc1234567;
A1 += R2.L * R7.H (M), A0 = R2.L * R7.L (IS);
R2 = A0.w;
R7 = A1.w;
A1 = R6.L * R1.H (M), A0 = R6.L * R1.H (IS);
R6 = A0.w;
R1 = A1.w;
A1 += R0.L * R5.H (M), A0 = R0.H * R5.L (IS);
R0 = A0.w;
R5 = A1.w;
A1 = R4.L * R3.H (M), A0 += R4.H * R3.H (IS);
R4 = A0.w;
R3 = A1.w;
CHECKREG r0, 0x015D7C5C;
CHECKREG r1, 0x098F3EF5;
CHECKREG r2, 0x20B207F6;
CHECKREG r3, 0xB93E6989;
CHECKREG r4, 0xE32CFAD5;
CHECKREG r5, 0x2B2BE65D;
CHECKREG r6, 0x098F3EF5;
CHECKREG r7, 0xA5A3E58E;

imm32 r0, 0x14345678;
imm32 r1, 0x24456789;
imm32 r2, 0x3456789a;
imm32 r3, 0x44678912;
imm32 r4, 0x54789123;
imm32 r5, 0x67891244;
imm32 r6, 0xa1234547;
imm32 r7, 0xc1234547;
A1 = R4.H * R0.L (M), A0 = R4.L * R0.L (IS);
R4 = A0.w;
R0 = A1.w;
A1 = R3.H * R1.L (M), A0 = R3.L * R1.H (IS);
R3 = A0.w;
R1 = A1.w;
A1 = R2.H * R6.L (M), A0 = R2.H * R6.L (IS);
R2 = A0.w;
R6 = A1.w;
A1 = R7.H * R5.L (M), A0 = R7.H * R5.H (IS);
R7 = A0.w;
R5 = A1.w;
CHECKREG r0, 0x1C87E840;
CHECKREG r1, 0x1BAA0C1F;
CHECKREG r2, 0x0E29B1DA;
CHECKREG r3, 0xEF2679DA;
CHECKREG r4, 0xDA8DCA68;
CHECKREG r5, 0xFB83C34C;
CHECKREG r6, 0x0E29B1DA;
CHECKREG r7, 0xE69370BB;

imm32 r0, 0x15345678;
imm32 r1, 0x23556789;
imm32 r2, 0x3455789a;
imm32 r3, 0x45675912;
imm32 r4, 0x56789523;
imm32 r5, 0x67891234;
imm32 r6, 0xa1234557;
imm32 r7, 0xc1234565;
A1 = R0.H * R1.H (M), A0 = R0.L * R1.L (IS);
R0 = A0.w;
R1 = A1.w;
A1 = R5.H * R6.H (M), A0 = R5.L * R6.H (IS);
R5 = A0.w;
R6 = A1.w;
A1 += R4.H * R3.H (M), A0 = R4.H * R3.L (IS);
R4 = A0.w;
R3 = A1.w;
A1 += R2.H * R7.H (M), A0 = R2.H * R7.H (IS);
R2 = A0.w;
R7 = A1.w;
CHECKREG r0, 0x22F88E38;
CHECKREG r1, 0x02ED2644;
CHECKREG r2, 0xF3263C9F;
CHECKREG r3, 0x589C7303;
CHECKREG r4, 0x1E15CC70;
CHECKREG r5, 0xF941311C;
CHECKREG r6, 0x412B50BB;
CHECKREG r7, 0x8017AFA2;

// test the (unsigned or integer :no ) U=1
imm32 r0, 0x62345678;
imm32 r1, 0x26456789;
imm32 r2, 0x3466789a;
imm32 r3, 0x45668912;
imm32 r4, 0x56786123;
imm32 r5, 0x67891634;
imm32 r6, 0xa1234567;
imm32 r7, 0xc1234566;
A1 = R0.L * R2.L (M), A0 = R0.L * R2.L (FU);
R0 = A0.w;
R2 = A1.w;
A1 += R1.L * R3.L (M), A0 = R1.L * R3.H (FU);
R1 = A0.w;
R3 = A1.w;
A1 = R4.L * R6.L (M), A0 = R4.H * R6.L (FU);
R4 = A0.w;
R6 = A1.w;
A1 += R5.L * R7.L (M), A0 = R5.H * R7.H (FU);
R5 = A0.w;
R7 = A1.w;
CHECKREG r0, 0x28BC4430;
CHECKREG r1, 0x1C112D96;
CHECKREG r2, 0x28BC4430;
CHECKREG r3, 0x602BDCD2;
CHECKREG r4, 0x17712248;
CHECKREG r5, 0x4E1C70BB;
CHECKREG r6, 0x1A558415;
CHECKREG r7, 0x205A60CD;

imm32 r0, 0x12345678;
imm32 r1, 0x73456789;
imm32 r2, 0x8456789a;
imm32 r3, 0x49998912;
imm32 r4, 0x56782123;
imm32 r5, 0x67891234;
imm32 r6, 0xa1234577;
imm32 r7, 0xc1234567;
A1 = R2.L * R3.H (M), A0 = R2.L * R3.L (FU);
R2 = A0.w;
R3 = A1.w;
A1 = R0.L * R1.H (M), A0 = R0.L * R1.H (FU);
R0 = A0.w;
R1 = A1.w;
A1 = R4.L * R5.H (M), A0 = R4.H * R5.L (FU);
R4 = A0.w;
R5 = A1.w;
A1 = R7.L * R6.H (M), A0 = R7.H * R6.H (FU);
R6 = A0.w;
R7 = A1.w;
CHECKREG r0, 0x26EF3658;
CHECKREG r1, 0x26EF3658;
CHECKREG r2, 0x4092E4D4;
CHECKREG r3, 0x22ABFE0A;
CHECKREG r4, 0x06260060;
CHECKREG r5, 0x0D66D0BB;
CHECKREG r6, 0x79916AC9;
CHECKREG r7, 0x2BAF4415;

imm32 r0, 0x1234567a;
imm32 r1, 0x2345678a;
imm32 r2, 0x3456a89a;
imm32 r3, 0x4a678912;
imm32 r4, 0xa6789123;
imm32 r5, 0xc7891234;
imm32 r6, 0xa1234567;
imm32 r7, 0xc1234567;
A1 = R5.H * R4.L (M), A0 += R5.L * R4.L (FU);
R4 = A0.w;
R5 = A1.w;
A1 = R3.H * R2.L (M), A0 = R3.L * R2.H (FU);
R2 = A0.w;
R3 = A1.w;
A1 = R1.H * R0.L (M), A0 += R1.H * R0.L (FU);
R0 = A0.w;
R1 = A1.w;
A1 = R7.H * R6.L (M), A0 = R7.H * R6.H (FU);
R6 = A0.w;
R7 = A1.w;
CHECKREG r0, 0x27EFB0EE;
CHECKREG r1, 0x0BE9FCE2;
CHECKREG r2, 0x1C05B40C;
CHECKREG r3, 0x310059F6;
CHECKREG r4, 0x83E35BE5;
CHECKREG r5, 0xDFFCE0BB;
CHECKREG r6, 0x79916AC9;
CHECKREG r7, 0xEEF52415;

imm32 r0, 0xb2345678;
imm32 r1, 0x2b456789;
imm32 r2, 0x34b6789a;
imm32 r3, 0xc56b8912;
imm32 r4, 0x5c78b123;
imm32 r5, 0x67c91b34;
imm32 r6, 0xa12345b7;
imm32 r7, 0xc123456b;
A1 += R6.H * R7.H (M), A0 = R6.L * R7.L (FU);
R6 = A0.w;
R7 = A1.w;
A1 += R5.H * R4.H (M), A0 = R5.L * R4.H (FU);
R4 = A0.w;
R5 = A1.w;
A1 = R2.H * R3.H (M), A0 += R2.H * R3.L (FU);
R2 = A0.w;
R3 = A1.w;
A1 = R0.H * R1.H (M), A0 += R0.H * R1.H (FU);
R0 = A0.w;
R1 = A1.w;
CHECKREG r0, 0x442B4F30;
CHECKREG r1, 0xF2D9C404;
CHECKREG r2, 0x260C8B2C;
CHECKREG r3, 0x28A61612;
CHECKREG r4, 0x09D37060;
CHECKREG r5, 0xCCE07116;
CHECKREG r6, 0x12E7767D;
CHECKREG r7, 0xA7638EDE;

// Test w32
imm32 r0, 0x123df178;
imm32 r1, 0x2245e189;
imm32 r2, 0x3256719a;
imm32 r3, 0x42678112;
imm32 r4, 0xa2789123;
imm32 r5, 0x62891134;
imm32 r6, 0xa2b34167;
imm32 r7, 0xc22d4167;
A1 = R0.L * R7.L (M), A0 = R0.L * R7.L (W32);
R0 = A0.w;
R7 = A1.w;
A1 += R1.L * R5.L (M), A0 = R1.L * R5.H (W32);
R1 = A0.w;
R5 = A1.w;
A1 = R2.L * R6.L (M), A0 = R2.H * R6.L (W32);
R2 = A0.w;
R6 = A1.w;
A1 += R3.L * R4.L (M), A0 = R3.H * R4.H (W32);
R3 = A0.w;
R4 = A1.w;
CHECKREG r0, 0xF8933E90;
CHECKREG r1, 0xE88C48A2;
CHECKREG r2, 0x19B82D34;
CHECKREG r3, 0xCF7A9C90;
CHECKREG r4, 0xD50FA66C;
CHECKREG r5, 0xFA3D881C;
CHECKREG r6, 0x1D05CEF6;
CHECKREG r7, 0xFC499F48;

imm32 r0, 0x553df344;
imm32 r1, 0x2525e349;
imm32 r2, 0x3252734a;
imm32 r3, 0x42658342;
imm32 r4, 0xa5789343;
imm32 r5, 0x63591344;
imm32 r6, 0xa3b54347;
imm32 r7, 0xc32d4347;
A1 = R0.L * R7.H (M), A0 = R0.L * R7.L (W32);
R0 = A0.w;
R7 = A1.w;
A1 = R1.L * R5.H (M), A0 += R1.L * R5.H (W32);
R1 = A0.w;
R5 = A1.w;
A1 = R2.L * R6.H (M), A0 = R2.H * R6.L (W32);
R2 = A0.w;
R6 = A1.w;
A1 = R3.L * R4.H (M), A0 += R3.H * R4.H (W32);
R3 = A0.w;
R4 = A1.w;
CHECKREG r0, 0xF94E87B8;
CHECKREG r1, 0xE305067A;
CHECKREG r2, 0x1A72D57C;
CHECKREG r3, 0xEB7D462C;
CHECKREG r4, 0xAF5F10F0;
CHECKREG r5, 0xF4DB3F61;
CHECKREG r6, 0x49B9A152;
CHECKREG r7, 0xF64A8EF4;

imm32 r0, 0x163df678;
imm32 r1, 0x2625e689;
imm32 r2, 0x3652769a;
imm32 r3, 0x46628612;
imm32 r4, 0xa6789623;
imm32 r5, 0x63691634;
imm32 r6, 0xa3634367;
imm32 r7, 0xc3264667;
A1 = R0.H * R7.L (M), A0 = R0.L * R7.L (W32);
R0 = A0.w;
R7 = A1.w;
A1 = R1.H * R5.L (M), A0 = R1.L * R5.H (W32);
R1 = A0.w;
R5 = A1.w;
A1 += R2.H * R6.L (M), A0 = R2.H * R6.L (W32);
R2 = A0.w;
R6 = A1.w;
A1 = R3.H * R4.L (M), A0 = R3.H * R4.H (W32);
R3 = A0.w;
R4 = A1.w;
CHECKREG r0, 0xFAC1F490;
CHECKREG r1, 0xEC391262;
CHECKREG r2, 0x1C9AA1FC;
CHECKREG r3, 0xCEC513E0;
CHECKREG r4, 0x29470B66;
CHECKREG r5, 0x034EED84;
CHECKREG r6, 0x119C3E82;
CHECKREG r7, 0x061DA08B;

imm32 r0, 0x123df378;
imm32 r1, 0x2225e389;
imm32 r2, 0x3252739a;
imm32 r3, 0x42628312;
imm32 r4, 0xa3789323;
imm32 r5, 0x63891334;
imm32 r6, 0xa3b34367;
imm32 r7, 0xc32d4367;
A1 = R0.H * R7.H (M), A0 = R0.L * R7.L (W32);
R0 = A0.w;
R7 = A1.w;
A1 = R1.H * R5.H (M), A0 = R1.L * R5.H (W32);
R1 = A0.w;
R5 = A1.w;
A1 += R2.H * R6.H (M), A0 += R2.H * R6.L (W32);
R2 = A0.w;
R6 = A1.w;
A1 += R3.H * R4.H (M), A0 += R3.H * R4.H (W32);
R3 = A0.w;
R4 = A1.w;
CHECKREG r0, 0xF966BA90;
CHECKREG r1, 0xE9DD7EA2;
CHECKREG r2, 0x045CE89E;
CHECKREG r3, 0xD45FF07E;
CHECKREG r4, 0x57D77E13;
CHECKREG r5, 0x0D4694CD;
CHECKREG r6, 0x2D73FA23;
CHECKREG r7, 0x0DE7ABB9;

imm32 r0, 0x123df678;
imm32 r1, 0x2345e789;
imm32 r2, 0x34567b9a;
imm32 r3, 0x45678c12;
imm32 r4, 0xa6789123;
imm32 r5, 0x6c891234;
imm32 r6, 0xa1b34567;
imm32 r7, 0xc12d4567;
A1 = R0.H * R4.L (M), A0 = R0.H * R4.L (W32);
R0 = A0.w;
R4 = A1.w;
A1 = R1.H * R5.L (M), A0 = R1.H * R5.H (W32);
R1 = A0.w;
R5 = A1.w;
A1 = R2.H * R6.H (M), A0 = R2.L * R6.L (W32);
R2 = A0.w;
R6 = A1.w;
A1 = R3.H * R4.H (M), A0 = R3.L * R4.H (W32);
R3 = A0.w;
R4 = A1.w;
CHECKREG r0, 0xF03416AE;
CHECKREG r1, 0x1DE7F7DA;
CHECKREG r2, 0x430479EC;
CHECKREG r3, 0xF6A29C3C;
CHECKREG r4, 0x02CD9C01;
CHECKREG r5, 0x02820404;
CHECKREG r6, 0x210EAE22;
CHECKREG r7, 0xC12D4567;

// MNOP & w32
imm32 r0, 0x623df17a;
imm32 r1, 0x7245e18b;
imm32 r2, 0x8256719a;
imm32 r3, 0x92678112;
imm32 r4, 0xa2789123;
imm32 r5, 0xb2891134;
imm32 r6, 0xc2b34167;
imm32 r7, 0xd22d4167;
A0 = R0.L * R4.L (W32);
R0 = A0.w;
R4 = A1.w;
A0 += R1.L * R5.H (W32);
R1 = A0.w;
R5 = A1.w;
A0 = R2.H * R6.L (W32);
R2 = A0.w;
R6 = A1.w;
A0 += R3.H * R7.H (W32);
R3 = A0.w;
R7 = A1.w;
CHECKREG r0, 0x0C943B5C;
CHECKREG r1, 0x1F02EE22;
CHECKREG r2, 0xBFCA8D34;
CHECKREG r3, 0xE707016A;
CHECKREG r4, 0x02CD9C01;
CHECKREG r5, 0x02CD9C01;
CHECKREG r6, 0x02CD9C01;
CHECKREG r7, 0x02CD9C01;

imm32 r0, 0xa23df17a;
imm32 r1, 0x7b45e18b;
imm32 r2, 0x82c6719a;
imm32 r3, 0x126d8112;
imm32 r4, 0xc278e123;
imm32 r5, 0xb2491f34;
imm32 r6, 0x89b54167;
imm32 r7, 0xd25d6767;
A1 += R0.L * R4.L (M,W32);
R0 = A0.w;
R4 = A1.w;
A1 = R1.L * R5.H (M,W32);
R1 = A0.w;
R5 = A1.w;
A1 += R2.H * R6.L (M,W32);
R2 = A0.w;
R6 = A1.w;
A1 = R3.H * R7.H (M,W32);
R3 = A0.w;
R7 = A1.w;
CHECKREG r0, 0xE707016A;
CHECKREG r1, 0xE707016A;
CHECKREG r2, 0xE707016A;
CHECKREG r3, 0xE707016A;
CHECKREG r4, 0xF607D9AF;
CHECKREG r5, 0xEAC9F6A3;
CHECKREG r6, 0xCACBDA4D;
CHECKREG r7, 0x0F241B99;

imm32 r0, 0x123df678;
imm32 r1, 0x2345e789;
imm32 r2, 0x34567b9a;
imm32 r3, 0x45678c12;
imm32 r4, 0xa6789123;
imm32 r5, 0x6c891234;
imm32 r6, 0xa1b34567;
imm32 r7, 0xc12d4567;
A1 -= R0.H * R4.L (M), A0 += R0.H * R4.L (IS);
R0 = A0.w;
R4 = A1.w;
A1 -= R1.H * R5.L (M), A0 -= R1.H * R5.H (FU);
R1 = A0.w;
R5 = A1.w;
A1 += R2.H * R6.H (M), A0 -= R2.L * R6.L (W32);
R2 = A0.w;
R6 = A1.w;
A1 -= R3.H * R4.H (M), A0 -= R3.L * R4.H (W32);
R3 = A0.w;
R4 = A1.w;
CHECKREG r0, 0xDF210CC1;
CHECKREG r1, 0xD02D10D4;
CHECKREG r2, 0x8D2896E8;
CHECKREG r3, 0x9181B214;
CHECKREG r4, 0x220C8AE5;
CHECKREG r5, 0x024B0C3E;
CHECKREG r6, 0x2359BA60;
CHECKREG r7, 0xC12D4567;

imm32 r0, 0x123df678;
imm32 r1, 0x2345e789;
imm32 r2, 0x34567b9a;
imm32 r3, 0x45678c12;
imm32 r4, 0xa6789123;
imm32 r5, 0x6c891234;
imm32 r6, 0xa1b34567;
imm32 r7, 0xc12d4567;
A1 -= R0.H * R4.L (M), A0 = R0.H * R4.L (IS);
R0 = A0.w;
R4 = A1.w;
A1 -= R1.H * R5.L (M), A0 = R1.H * R5.H (FU);
R1 = A0.w;
R5 = A1.w;
A1 -= R2.H * R6.H (M), A0 = R2.L * R6.L (W32);
R2 = A0.w;
R6 = A1.w;
A1 -= R3.H * R4.H (M), A0 = R3.L * R4.H (W32);
R3 = A0.w;
R4 = A1.w;
CHECKREG r0, 0xF81A0B57;
CHECKREG r1, 0x0EF3FBED;
CHECKREG r2, 0x430479EC;
CHECKREG r3, 0xEA874D74;
CHECKREG r4, 0xEDB77A95;
CHECKREG r5, 0x15337B8A;
CHECKREG r6, 0xF424CD68;
CHECKREG r7, 0xC12D4567;

// MNOP & w32
imm32 r0, 0x623df17a;
imm32 r1, 0x7245e18b;
imm32 r2, 0x8256719a;
imm32 r3, 0x92678112;
imm32 r4, 0xa2789123;
imm32 r5, 0xb2891134;
imm32 r6, 0xc2b34167;
imm32 r7, 0xd22d4167;
A0 -= R0.L * R4.L (IS);
R0 = A0.w;
R4 = A1.w;
A0 -= R1.L * R5.H (FU);
R1 = A0.w;
R5 = A1.w;
A0 -= R2.H * R6.L (W32);
R2 = A0.w;
R6 = A1.w;
A0 -= R3.H * R7.H (W32);
R3 = A0.w;
R7 = A1.w;
CHECKREG r0, 0xE43D2FC6;
CHECKREG r1, 0x46F1D663;
CHECKREG r2, 0x8727492F;
CHECKREG r3, 0x80000000;
CHECKREG r4, 0xEDB77A95;
CHECKREG r5, 0xEDB77A95;
CHECKREG r6, 0xEDB77A95;
CHECKREG r7, 0xEDB77A95;

imm32 r0, 0xa23df17a;
imm32 r1, 0x7b45e18b;
imm32 r2, 0x82c6719a;
imm32 r3, 0x126d8112;
imm32 r4, 0xc278e123;
imm32 r5, 0xb2491f34;
imm32 r6, 0x89b54167;
imm32 r7, 0xd25d6767;
A1 -= R0.L * R4.L (M,IS);
R0 = A0.w;
R4 = A1.w;
A1 -= R1.L * R5.H (M,FU);
R1 = A0.w;
R5 = A1.w;
A1 -= R2.H * R6.L (M,W32);
R2 = A0.w;
R6 = A1.w;
A1 -= R3.H * R7.H (M,FU);
R3 = A0.w;
R7 = A1.w;
CHECKREG r0, 0x80000000;
CHECKREG r1, 0x80000000;
CHECKREG r2, 0x80000000;
CHECKREG r3, 0x80000000;
CHECKREG r4, 0xFA7D3CE7;
CHECKREG r5, 0x0FB34644;
CHECKREG r6, 0x2FB1629A;
CHECKREG r7, 0x208D4701;


pass
