import { MultisitePageHelper } from './multisite.po';

describe('Multisite page', () => {
  const multisite = new MultisitePageHelper();

  beforeEach(() => {
    cy.login();
  });

  describe('table tests', () => {
    it('should show table on sync-policy page', () => {
      multisite.navigateTo();
      multisite.tableExist();
    });
  });

  describe('create, edit & delete sync group policy', () => {
    it('should create policy', () => {
      multisite.navigateTo('create');
      multisite.create('test', 'Enabled');
      multisite.getFirstTableCell('test').should('exist');
    });

    it('should edit policy status', () => {
      multisite.navigateTo();
      multisite.edit('test', 'Forbidden');
    });

    it('should delete policy', () => {
      multisite.navigateTo();
      multisite.delete('test');
    });
  });

  // @TODO: <skipping tests as need to setup multisite configuration to test flow and pipe>
  describe.skip('create, edit & delete symmetrical sync Flow', () => {
    it('Preparing...(creating sync group policy)', () => {
      multisite.navigateTo('create');
      multisite.create('test', 'Enabled');
      multisite.getFirstTableCell('test').should('exist');
    });
    describe('symmetrical Flow creation started', () => {
      beforeEach(() => {
        multisite.navigateTo();
        multisite.getExpandCollapseElement().click();
      });

      it('should create flow', () => {
        multisite.createSymmetricalFlow('new-sym-flow', ['zone1-zg1-realm1']);
      });

      it('should modify flow zones', () => {
        multisite.editSymFlow('new-sym-flow', 'zone2-zg1-realm1');
      });

      it('should delete flow', () => {
        multisite.deleteSymFlow('new-sym-flow');
      });
    });
  });

  describe.skip('create, edit & delete directional sync Flow', () => {
    beforeEach(() => {
      multisite.navigateTo();
      multisite.getExpandCollapseElement().click();
    });

    it('should create flow', () => {
      multisite.createDirectionalFlow(
        'new-dir-flow',
        ['zone1-zg1-realm1', 'zone2-zg1-realm1'],
        ['new-zone']
      );
    });
  });

  describe.skip('create, edit, delete pipe', () => {
    beforeEach(() => {
      multisite.navigateTo();
      multisite.getExpandCollapseElement().click();
    });

    it('should create pipe', () => {
      multisite.createPipe('new-pipe', ['zone1-zg1-realm1'], ['zone3-zg2-realm1']);
    });

    it('should modify pipe zones', () => {
      multisite.editPipe('new-pipe', 'zone2-zg1-realm1');
    });

    it('should delete pipe', () => {
      multisite.deletePipe('new-pipe');
    });
  });
});
