// Copyright John Maddock 2019.

// Use, modification and distribution are subject to the
// Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt
// or copy at http://www.boost.org/LICENSE_1_0.txt)

#ifndef SC_
#  define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
#endif
   static const boost::array<boost::array<T, 6>, 225> hypergeometric_2F2 = {{
      { SC_(-4.6568273925781250000000000000000000000000e+02), SC_(2.7491040039062500000000000000000000000000e+02), SC_(4.7700195312500000000000000000000000000000e+02), SC_(3.1730322265625000000000000000000000000000e+02), SC_(-1.3681353759765625000000000000000000000000e+02), SC_(1.8090668841695962735121297629318499805194e+42) }, 
      { SC_(-4.4878356933593750000000000000000000000000e+02), SC_(2.9519995117187500000000000000000000000000e+02), SC_(-4.6355883789062500000000000000000000000000e+02), SC_(-3.1312744140625000000000000000000000000000e+02), SC_(-9.1268829345703125000000000000000000000000e+01), SC_(-6.8305703866855163475715684044172076664493e+186) }, 
      { SC_(-4.2414575195312500000000000000000000000000e+02), SC_(-9.5791503906250000000000000000000000000000e+01), SC_(-4.4604992675781250000000000000000000000000e+02), SC_(-1.4723760986328125000000000000000000000000e+02), SC_(3.0797546386718750000000000000000000000000e+01), SC_(9.2516788163653291402462434856492902332269e+07) }, 
      { SC_(-4.0245959472656250000000000000000000000000e+02), SC_(4.7220581054687500000000000000000000000000e+01), SC_(-2.2150177001953125000000000000000000000000e+02), SC_(-3.1161804199218750000000000000000000000000e+02), SC_(4.6881469726562500000000000000000000000000e+01), SC_(1.5352181353921602046709701790928284442327e+88) }, 
      { SC_(-3.9334729003906250000000000000000000000000e+02), SC_(-1.4558105468750000000000000000000000000000e+00), SC_(4.6189807128906250000000000000000000000000e+02), SC_(4.7992565917968750000000000000000000000000e+02), SC_(-4.9536584472656250000000000000000000000000e+02), SC_(4.1127664690960577724128168628565875268818e-02) }, 
      { SC_(-3.9013830566406250000000000000000000000000e+02), SC_(-1.4624359130859375000000000000000000000000e+01), SC_(2.9810583496093750000000000000000000000000e+02), SC_(3.0028039550781250000000000000000000000000e+02), SC_(-2.0297058105468750000000000000000000000000e+02), SC_(-3.2405423559105211621315714057367775071572e-10) }, 
      { SC_(-3.8258239746093750000000000000000000000000e+02), SC_(-1.7503649902343750000000000000000000000000e+02), SC_(-2.0332415771484375000000000000000000000000e+02), SC_(1.5577990722656250000000000000000000000000e+02), SC_(-1.8122167968750000000000000000000000000000e+02), SC_(3.8354909652295819833106476659021099079105e+82) }, 
      { SC_(-3.7009387207031250000000000000000000000000e+02), SC_(-3.4556164550781250000000000000000000000000e+02), SC_(6.8823608398437500000000000000000000000000e+01), SC_(-1.0509176635742187500000000000000000000000e+02), SC_(-3.0609375000000000000000000000000000000000e+01), SC_(3.1341617923636314523220451439038061044124e+103) }, 
      { SC_(-3.6802673339843750000000000000000000000000e+02), SC_(-9.6985168457031250000000000000000000000000e+00), SC_(4.4205053710937500000000000000000000000000e+02), SC_(4.5494335937500000000000000000000000000000e+02), SC_(4.5613452148437500000000000000000000000000e+02), SC_(3.3844509595908982340003058676574433591601e+02) }, 
      { SC_(-3.6393151855468750000000000000000000000000e+02), SC_(3.0211145019531250000000000000000000000000e+02), SC_(3.6929211425781250000000000000000000000000e+02), SC_(-4.2244299316406250000000000000000000000000e+02), SC_(7.9704589843750000000000000000000000000000e+01), SC_(2.9973712146869363588906408000435531769989e+24) }, 
      { SC_(-3.4238696289062500000000000000000000000000e+02), SC_(2.2583898925781250000000000000000000000000e+02), SC_(4.7059277343750000000000000000000000000000e+02), SC_(4.8110961914062500000000000000000000000000e+02), SC_(4.5716699218750000000000000000000000000000e+02), SC_(3.5349925140498271067901257770469369222422e-75) }, 
      { SC_(-3.3781774902343750000000000000000000000000e+02), SC_(4.2749279785156250000000000000000000000000e+02), SC_(2.9428454589843750000000000000000000000000e+02), SC_(-6.3882446289062500000000000000000000000000e+01), SC_(-1.8878497314453125000000000000000000000000e+02), SC_(6.5059718319095428358961211161563226511058e+261) }, 
      { SC_(-3.3101000976562500000000000000000000000000e+02), SC_(3.0913720703125000000000000000000000000000e+02), SC_(1.4911547851562500000000000000000000000000e+02), SC_(-2.4170410156250000000000000000000000000000e+02), SC_(2.3172241210937500000000000000000000000000e+02), SC_(-1.9036391377806637778714360115412330090828e+199) }, 
      { SC_(-3.1648889160156250000000000000000000000000e+02), SC_(-1.1428948974609375000000000000000000000000e+02), SC_(-1.3151544189453125000000000000000000000000e+02), SC_(-1.5607025146484375000000000000000000000000e+02), SC_(1.2561859130859375000000000000000000000000e+02), SC_(-2.2647803812666968435830709155055083167865e+102) }, 
      { SC_(-3.0523571777343750000000000000000000000000e+02), SC_(-5.8776519775390625000000000000000000000000e+01), SC_(-2.7407824707031250000000000000000000000000e+02), SC_(-3.5217102050781250000000000000000000000000e+02), SC_(-3.2929199218750000000000000000000000000000e+02), SC_(4.9263998797519049365001615903230659768340e+57) }, 
      { SC_(-3.0044885253906250000000000000000000000000e+02), SC_(1.3249511718750000000000000000000000000000e+01), SC_(-3.6199865722656250000000000000000000000000e+02), SC_(-9.8191986083984375000000000000000000000000e+01), SC_(-1.1766705322265625000000000000000000000000e+02), SC_(-1.1402440428266599406329845908011742949449e+16) }, 
      { SC_(-3.0012719726562500000000000000000000000000e+02), SC_(3.2825561523437500000000000000000000000000e+01), SC_(4.4892504882812500000000000000000000000000e+02), SC_(-1.4927288818359375000000000000000000000000e+02), SC_(4.9010998535156250000000000000000000000000e+02), SC_(-8.2802792883592327098743193151793189562668e+51) }, 
      { SC_(-2.9225769042968750000000000000000000000000e+02), SC_(4.0138000488281250000000000000000000000000e+01), SC_(-1.9875366210937500000000000000000000000000e+02), SC_(-4.8154919433593750000000000000000000000000e+02), SC_(-2.9076660156250000000000000000000000000000e+01), SC_(4.3023564115466799741161627232928714247688e+01) }, 
      { SC_(-2.8807568359375000000000000000000000000000e+02), SC_(4.3399316406250000000000000000000000000000e+02), SC_(1.8135955810546875000000000000000000000000e+02), SC_(1.7873510742187500000000000000000000000000e+02), SC_(-1.0126147460937500000000000000000000000000e+02), SC_(7.6335788596686159020335593785181427594248e+78) }, 
      { SC_(-2.6522009277343750000000000000000000000000e+02), SC_(5.2881164550781250000000000000000000000000e+01), SC_(-1.4684143066406250000000000000000000000000e+02), SC_(-4.4684753417968750000000000000000000000000e+02), SC_(3.2119396972656250000000000000000000000000e+02), SC_(2.8099938553256444419794417735331437931667e+303) }, 
      { SC_(-2.6049755859375000000000000000000000000000e+02), SC_(-2.7233569335937500000000000000000000000000e+02), SC_(2.9965319824218750000000000000000000000000e+02), SC_(-6.4301300048828125000000000000000000000000e+01), SC_(-2.6984924316406250000000000000000000000000e+01), SC_(-8.0107317185818721255825742655375983959701e+38) }, 
      { SC_(-2.4704406738281250000000000000000000000000e+02), SC_(-3.1609228515625000000000000000000000000000e+02), SC_(4.7709960937500000000000000000000000000000e+00), SC_(-2.6004748535156250000000000000000000000000e+02), SC_(3.2260498046875000000000000000000000000000e+02), SC_(-1.1836297998213733058326723098984475672672e+166) }, 
      { SC_(-2.2724700927734375000000000000000000000000e+02), SC_(-9.6087860107421875000000000000000000000000e+01), SC_(-7.5580139160156250000000000000000000000000e+00), SC_(-4.0354553222656250000000000000000000000000e+02), SC_(-2.7658007812500000000000000000000000000000e+02), SC_(2.3408505139066532271316459421630307869796e+87) }, 
      { SC_(-2.2397491455078125000000000000000000000000e+02), SC_(2.0577423095703125000000000000000000000000e+02), SC_(1.7970269775390625000000000000000000000000e+02), SC_(-4.9718164062500000000000000000000000000000e+02), SC_(1.5509802246093750000000000000000000000000e+02), SC_(8.6822023586943617781984796912183537053591e+30) }, 
      { SC_(-2.1837268066406250000000000000000000000000e+02), SC_(-2.6271643066406250000000000000000000000000e+02), SC_(4.6864038085937500000000000000000000000000e+02), SC_(-4.1151153564453125000000000000000000000000e+01), SC_(-2.8622729492187500000000000000000000000000e+02), SC_(3.7567873848946006245925120666711493927607e+88) }, 
      { SC_(-2.1416101074218750000000000000000000000000e+02), SC_(1.7981976318359375000000000000000000000000e+02), SC_(2.5720019531250000000000000000000000000000e+02), SC_(-1.0767953491210937500000000000000000000000e+02), SC_(2.5372912597656250000000000000000000000000e+02), SC_(1.3561316373323201227118432798149688806052e+109) }, 
      { SC_(-2.0016827392578125000000000000000000000000e+02), SC_(-2.5647509765625000000000000000000000000000e+02), SC_(-4.8646093750000000000000000000000000000000e+02), SC_(4.2926367187500000000000000000000000000000e+02), SC_(-2.8276220703125000000000000000000000000000e+02), SC_(6.1626294987323710336471221352110848444241e+23) }, 
      { SC_(-1.9817272949218750000000000000000000000000e+02), SC_(4.4478723144531250000000000000000000000000e+02), SC_(-4.5205578613281250000000000000000000000000e+02), SC_(-9.1358947753906250000000000000000000000000e+00), SC_(-2.5215240478515625000000000000000000000000e+02), SC_(-7.3551112059747611758081912144782250496691e+132) }, 
      { SC_(-1.9365051269531250000000000000000000000000e+02), SC_(-3.9193811035156250000000000000000000000000e+02), SC_(8.5086669921875000000000000000000000000000e+00), SC_(-1.0641015625000000000000000000000000000000e+02), SC_(1.0771575927734375000000000000000000000000e+01), SC_(-4.1384279327506017243647033872337149714861e+91) }, 
      { SC_(-1.8889770507812500000000000000000000000000e+02), SC_(-4.1017687988281250000000000000000000000000e+02), SC_(4.2337963867187500000000000000000000000000e+02), SC_(1.4455053710937500000000000000000000000000e+02), SC_(-6.9792602539062500000000000000000000000000e+01), SC_(-2.2787574128602828267604156433544903254627e-33) }, 
      { SC_(-1.7748925781250000000000000000000000000000e+02), SC_(-4.8459655761718750000000000000000000000000e+02), SC_(-9.5018615722656250000000000000000000000000e+01), SC_(-4.5697619628906250000000000000000000000000e+02), SC_(4.0843359375000000000000000000000000000000e+02), SC_(-6.1309429675639581275953700138582019374755e+177) }, 
      { SC_(-1.5616046142578125000000000000000000000000e+02), SC_(-1.3075323486328125000000000000000000000000e+02), SC_(-4.6673144531250000000000000000000000000000e+02), SC_(-3.8879724121093750000000000000000000000000e+02), SC_(-3.3712792968750000000000000000000000000000e+02), SC_(5.0771533571105395112507671158341657849078e-21) }, 
      { SC_(-1.5001623535156250000000000000000000000000e+02), SC_(4.0736474609375000000000000000000000000000e+02), SC_(-3.0340478515625000000000000000000000000000e+02), SC_(3.4846777343750000000000000000000000000000e+02), SC_(-2.4891619873046875000000000000000000000000e+02), SC_(2.4661963280733500827838102392456694588594e-19) }, 
      { SC_(-1.4834051513671875000000000000000000000000e+02), SC_(-4.3240466308593750000000000000000000000000e+02), SC_(3.3082861328125000000000000000000000000000e+02), SC_(2.9359753417968750000000000000000000000000e+02), SC_(8.5264099121093750000000000000000000000000e+01), SC_(1.7801276690066621389763062605734642527988e+18) }, 
      { SC_(-1.1270410156250000000000000000000000000000e+02), SC_(-4.8809802246093750000000000000000000000000e+02), SC_(2.2695471191406250000000000000000000000000e+02), SC_(-1.6287738037109375000000000000000000000000e+02), SC_(-1.1143020629882812500000000000000000000000e+02), SC_(2.5407237979811772888083637388715258370934e+45) }, 
      { SC_(-1.1138482666015625000000000000000000000000e+02), SC_(1.2247509765625000000000000000000000000000e+02), SC_(2.7968933105468750000000000000000000000000e+02), SC_(8.7044738769531250000000000000000000000000e+01), SC_(-2.3361907958984375000000000000000000000000e+01), SC_(1.5591866626930230847619035616477113126324e+05) }, 
      { SC_(-7.9810058593750000000000000000000000000000e+01), SC_(-7.5833221435546875000000000000000000000000e+01), SC_(2.8190917968750000000000000000000000000000e+02), SC_(7.8582763671875000000000000000000000000000e+00), SC_(-3.8680749511718750000000000000000000000000e+02), SC_(3.1682075946920874259619218678195880254105e+18) }, 
      { SC_(-6.8586181640625000000000000000000000000000e+01), SC_(2.4994097900390625000000000000000000000000e+02), SC_(4.1064758300781250000000000000000000000000e+02), SC_(-3.6700402832031250000000000000000000000000e+02), SC_(-3.1815307617187500000000000000000000000000e+02), SC_(1.4636978438673048081222495699492837883393e-19) }, 
      { SC_(-6.1255645751953125000000000000000000000000e+01), SC_(-3.7410339355468750000000000000000000000000e+02), SC_(-1.1844155883789062500000000000000000000000e+02), SC_(-2.8979101562500000000000000000000000000000e+02), SC_(2.6551684570312500000000000000000000000000e+02), SC_(-7.8230935989066580429653289617001765644549e+183) }, 
      { SC_(-5.2415618896484375000000000000000000000000e+01), SC_(-4.2182446289062500000000000000000000000000e+02), SC_(3.5445092773437500000000000000000000000000e+02), SC_(-5.7321716308593750000000000000000000000000e+01), SC_(1.0423150634765625000000000000000000000000e+02), SC_(-8.5059667452233162170710384161543101987392e+29) }, 
      { SC_(-4.9458404541015625000000000000000000000000e+01), SC_(2.2049340820312500000000000000000000000000e+02), SC_(-4.1617871093750000000000000000000000000000e+02), SC_(4.1257751464843750000000000000000000000000e+02), SC_(-2.7102307128906250000000000000000000000000e+02), SC_(2.4834063262581430275237945230018644021825e-09) }, 
      { SC_(-1.8627311706542968750000000000000000000000e+01), SC_(1.0996417999267578125000000000000000000000e+01), SC_(1.9080078125000000000000000000000000000000e+01), SC_(1.2692131042480468750000000000000000000000e+01), SC_(-1.3681354522705078125000000000000000000000e+01), SC_(3.6751390679881780406349329643661305621334e+03) }, 
      { SC_(-1.7951347351074218750000000000000000000000e+01), SC_(1.1807994842529296875000000000000000000000e+01), SC_(-1.8542350769042968750000000000000000000000e+01), SC_(-1.2525096893310546875000000000000000000000e+01), SC_(-9.1268844604492187500000000000000000000000e+00), SC_(-1.7687038523433296094129998013347882530319e+13) }, 
      { SC_(-1.6965827941894531250000000000000000000000e+01), SC_(-3.8316593170166015625000000000000000000000e+00), SC_(-1.7841995239257812500000000000000000000000e+01), SC_(-5.8895034790039062500000000000000000000000e+00), SC_(3.0797538757324218750000000000000000000000e+00), SC_(5.5236210164786761723805549200949098478720e+00) }, 
      { SC_(-1.6098388671875000000000000000000000000000e+01), SC_(1.8888244628906250000000000000000000000000e+00), SC_(-8.8600730895996093750000000000000000000000e+00), SC_(-1.2464721679687500000000000000000000000000e+01), SC_(4.6881484985351562500000000000000000000000e+00), SC_(-1.8910581975528168923461492534054131746917e+07) }, 
      { SC_(-1.5733890533447265625000000000000000000000e+01), SC_(-5.8233261108398437500000000000000000000000e-02), SC_(1.8475921630859375000000000000000000000000e+01), SC_(1.9197021484375000000000000000000000000000e+01), SC_(-4.9536590576171875000000000000000000000000e+01), SC_(2.6685174882546217381592108253547251888832e-01) }, 
      { SC_(-1.5605529785156250000000000000000000000000e+01), SC_(-5.8497428894042968750000000000000000000000e-01), SC_(1.1924232482910156250000000000000000000000e+01), SC_(1.2011219024658203125000000000000000000000e+01), SC_(-2.0297058105468750000000000000000000000000e+01), SC_(-1.5687855528156399379254986039503382258811e+00) }, 
      { SC_(-1.4803752899169921875000000000000000000000e+01), SC_(-1.3822463989257812500000000000000000000000e+01), SC_(2.7529449462890625000000000000000000000000e+00), SC_(-4.2036724090576171875000000000000000000000e+00), SC_(-3.0609359741210937500000000000000000000000e+00), SC_(2.8280017990266024953860806250565586782993e+06) }, 
      { SC_(-1.4324546813964843750000000000000000000000e+01), SC_(-1.9808662414550781250000000000000000000000e+01), SC_(-3.1295490264892578125000000000000000000000e+00), SC_(-1.5501419067382812500000000000000000000000e+01), SC_(4.1573547363281250000000000000000000000000e+01), SC_(5.3507698277232744612911246975329367495926e+18) }, 
      { SC_(-1.3695476531982421875000000000000000000000e+01), SC_(9.0335578918457031250000000000000000000000e+00), SC_(1.8823707580566406250000000000000000000000e+01), SC_(1.9244384765625000000000000000000000000000e+01), SC_(4.5716690063476562500000000000000000000000e+01), SC_(8.9653602774702110550509642806029311195812e-07) }, 
      { SC_(-1.3512710571289062500000000000000000000000e+01), SC_(1.7099716186523437500000000000000000000000e+01), SC_(1.1771381378173828125000000000000000000000e+01), SC_(-2.5552978515625000000000000000000000000000e+00), SC_(-1.8878501892089843750000000000000000000000e+01), SC_(-1.1425936735999661759491083140643484242620e+14) }, 
      { SC_(-1.1523029327392578125000000000000000000000e+01), SC_(1.7359725952148437500000000000000000000000e+01), SC_(7.2543811798095703125000000000000000000000e+00), SC_(7.1494064331054687500000000000000000000000e+00), SC_(-1.0126148223876953125000000000000000000000e+01), SC_(3.1188254333031303283939625268251776375286e+05) }, 
      { SC_(-1.0747375488281250000000000000000000000000e+01), SC_(4.4056091308593750000000000000000000000000e+01), SC_(-1.6228057861328125000000000000000000000000e+02), SC_(3.8772607421875000000000000000000000000000e+02), SC_(4.0005383300781250000000000000000000000000e+02), SC_(1.2928438043146538099417152984039596095350e+94) }, 
      { SC_(-1.0235595703125000000000000000000000000000e+01), SC_(-4.2010833740234375000000000000000000000000e+01), SC_(-5.4413787841796875000000000000000000000000e+01), SC_(-1.2431091308593750000000000000000000000000e+01), SC_(1.4631298828125000000000000000000000000000e+02), SC_(3.4701354908999115590091902750783186033780e+68) }, 
      { SC_(-8.9589996337890625000000000000000000000000e+00), SC_(8.2309684753417968750000000000000000000000e+00), SC_(7.1881084442138671875000000000000000000000e+00), SC_(-1.9887268066406250000000000000000000000000e+01), SC_(1.5509803771972656250000000000000000000000e+01), SC_(-4.3237352986882628804839936405647982127470e+04) }, 
      { SC_(-8.5664405822753906250000000000000000000000e+00), SC_(7.1927909851074218750000000000000000000000e+00), SC_(1.0288009643554687500000000000000000000000e+01), SC_(-4.3071823120117187500000000000000000000000e+00), SC_(2.5372909545898437500000000000000000000000e+01), SC_(1.8684547238250746358774439736622029267924e+08) }, 
      { SC_(-8.0067329406738281250000000000000000000000e+00), SC_(-1.0259002685546875000000000000000000000000e+01), SC_(-1.9458435058593750000000000000000000000000e+01), SC_(1.7170547485351562500000000000000000000000e+01), SC_(-2.8276214599609375000000000000000000000000e+01), SC_(8.5293208391086791535872539297835549903288e+01) }, 
      { SC_(-6.0006504058837890625000000000000000000000e+00), SC_(1.6294586181640625000000000000000000000000e+01), SC_(-1.2136192321777343750000000000000000000000e+01), SC_(1.3938709259033203125000000000000000000000e+01), SC_(-2.4891616821289062500000000000000000000000e+01), SC_(1.5312214555852661612440960675897860485169e+02) }, 
      { SC_(-5.9336204528808593750000000000000000000000e+00), SC_(-1.7296188354492187500000000000000000000000e+01), SC_(1.3233142852783203125000000000000000000000e+01), SC_(1.1743904113769531250000000000000000000000e+01), SC_(8.5264091491699218750000000000000000000000e+00), SC_(2.9760479244064796094934430105832493400564e+01) }, 
      { SC_(-4.5081634521484375000000000000000000000000e+00), SC_(-1.9523918151855468750000000000000000000000e+01), SC_(9.0781860351562500000000000000000000000000e+00), SC_(-6.5150947570800781250000000000000000000000e+00), SC_(-1.1143020629882812500000000000000000000000e+01), SC_(4.0670429339531525395929371251704582212935e+04) }, 
      { SC_(-3.1164932250976562500000000000000000000000e+00), SC_(6.2191162109375000000000000000000000000000e+00), SC_(-1.3045394897460937500000000000000000000000e+01), SC_(-1.3152534484863281250000000000000000000000e+01), SC_(-1.9808692932128906250000000000000000000000e+01), SC_(5.3035735025576786340005623500769959948500e+05) }, 
      { SC_(-2.4502258300781250000000000000000000000000e+00), SC_(-1.4964134216308593750000000000000000000000e+01), SC_(-4.7376632690429687500000000000000000000000e+00), SC_(-1.1591636657714843750000000000000000000000e+01), SC_(2.6551681518554687500000000000000000000000e+01), SC_(-4.2267107042550304858879273150056080555563e+13) }, 
      { SC_(-2.0966243743896484375000000000000000000000e+00), SC_(-1.6872978210449218750000000000000000000000e+01), SC_(1.4178039550781250000000000000000000000000e+01), SC_(-2.2928695678710937500000000000000000000000e+00), SC_(1.0423149108886718750000000000000000000000e+01), SC_(3.3500282992446554994223940920628157504773e+01) }, 
      { SC_(-1.9783363342285156250000000000000000000000e+00), SC_(8.8197364807128906250000000000000000000000e+00), SC_(-1.6647148132324218750000000000000000000000e+01), SC_(1.6503097534179687500000000000000000000000e+01), SC_(-2.7102302551269531250000000000000000000000e+01), SC_(1.0605054745952214282121151533673558253193e-01) }, 
      { SC_(-1.6359252929687500000000000000000000000000e+00), SC_(2.7391711425781250000000000000000000000000e+02), SC_(4.5974389648437500000000000000000000000000e+02), SC_(7.3754638671875000000000000000000000000000e+01), SC_(-1.5961425781250000000000000000000000000000e+02), SC_(3.8691717471683061389976482214803886946213e+00) }, 
      { SC_(-9.3136548995971679687500000000000000000000e-01), SC_(5.4982089996337890625000000000000000000000e-01), SC_(9.5400404930114746093750000000000000000000e-01), SC_(6.3460636138916015625000000000000000000000e-01), SC_(-1.3681354522705078125000000000000000000000e+01), SC_(1.1461726634218317297868975292903954960479e+01) }, 
      { SC_(-8.9756727218627929687500000000000000000000e-01), SC_(5.9039974212646484375000000000000000000000e-01), SC_(-9.2711758613586425781250000000000000000000e-01), SC_(-6.2625479698181152343750000000000000000000e-01), SC_(-9.1268844604492187500000000000000000000000e+00), SC_(-2.7258451762138305965592779905347155524576e+00) }, 
      { SC_(-8.4829139709472656250000000000000000000000e-01), SC_(-1.9158297777175903320312500000000000000000e-01), SC_(-8.9209985733032226562500000000000000000000e-01), SC_(-2.9447519779205322265625000000000000000000e-01), SC_(3.0797538757324218750000000000000000000000e+00), SC_(2.2696956134240428561388378116507904391016e+01) }, 
      { SC_(-8.0491924285888671875000000000000000000000e-01), SC_(9.4441175460815429687500000000000000000000e-02), SC_(-4.4300353527069091796875000000000000000000e-01), SC_(-6.2323617935180664062500000000000000000000e-01), SC_(4.6881484985351562500000000000000000000000e+00), SC_(-4.0116084542469079963453756522064860502245e+01) }, 
      { SC_(-7.8669452667236328125000000000000000000000e-01), SC_(-2.9116272926330566406250000000000000000000e-03), SC_(9.2379617691040039062500000000000000000000e-01), SC_(9.5985126495361328125000000000000000000000e-01), SC_(-4.9536590576171875000000000000000000000000e+01), SC_(9.1303007378573122790173122093940027975556e-01) }, 
      { SC_(-7.8027653694152832031250000000000000000000e-01), SC_(-2.9248714447021484375000000000000000000000e-02), SC_(5.9621167182922363281250000000000000000000e-01), SC_(6.0056090354919433593750000000000000000000e-01), SC_(-2.0297058105468750000000000000000000000000e+01), SC_(6.7823776149999273321657180349427558768159e-02) }, 
      { SC_(-7.4018764495849609375000000000000000000000e-01), SC_(-6.9112324714660644531250000000000000000000e-01), SC_(1.3764727115631103515625000000000000000000e-01), SC_(-2.1018356084823608398437500000000000000000e-01), SC_(-3.0609359741210937500000000000000000000000e+00), SC_(4.9943693939619128028844124935155836981406e+01) }, 
      { SC_(-7.1622729301452636718750000000000000000000e-01), SC_(-9.9043321609497070312500000000000000000000e-01), SC_(-1.5647745132446289062500000000000000000000e-01), SC_(-7.7507114410400390625000000000000000000000e-01), SC_(4.1573547363281250000000000000000000000000e+01), SC_(5.2782159916475518113273916456247182256805e+15) }, 
      { SC_(-6.8477392196655273437500000000000000000000e-01), SC_(4.5167791843414306640625000000000000000000e-01), SC_(9.4118547439575195312500000000000000000000e-01), SC_(9.6221923828125000000000000000000000000000e-01), SC_(4.5716690063476562500000000000000000000000e+01), SC_(-2.8991479579435805628697873502012889307467e+15) }, 
      { SC_(-6.7563557624816894531250000000000000000000e-01), SC_(8.5498571395874023437500000000000000000000e-01), SC_(5.8856892585754394531250000000000000000000e-01), SC_(-1.2776488065719604492187500000000000000000e-01), SC_(-1.8878501892089843750000000000000000000000e+01), SC_(-5.1137804262374702747253547765150727203619e+01) }, 
      { SC_(-5.7615137100219726562500000000000000000000e-01), SC_(8.6798644065856933593750000000000000000000e-01), SC_(3.6271905899047851562500000000000000000000e-01), SC_(3.5747027397155761718750000000000000000000e-01), SC_(-1.0126148223876953125000000000000000000000e+01), SC_(1.7258766836089160717507131101097334110732e+01) }, 
      { SC_(-4.4794988632202148437500000000000000000000e-01), SC_(4.1154849529266357421875000000000000000000e-01), SC_(3.5940539836883544921875000000000000000000e-01), SC_(-9.9436330795288085937500000000000000000000e-01), SC_(1.5509803771972656250000000000000000000000e+01), SC_(1.5125252511730889731343823119684555041315e+09) }, 
      { SC_(-4.2832195758819580078125000000000000000000e-01), SC_(3.5963952541351318359375000000000000000000e-01), SC_(5.1440048217773437500000000000000000000000e-01), SC_(-2.1535909175872802734375000000000000000000e-01), SC_(2.5372909545898437500000000000000000000000e+01), SC_(3.4067177777882065811650636926814082389298e+10) }, 
      { SC_(-4.0942382812500000000000000000000000000000e-01), SC_(-1.6804332733154296875000000000000000000000e+00), SC_(-2.1765518188476562500000000000000000000000e+00), SC_(-4.9724388122558593750000000000000000000000e-01), SC_(1.4631301879882812500000000000000000000000e+01), SC_(-9.6078410082524146425792899790513835300962e+06) }, 
      { SC_(-4.0033662319183349609375000000000000000000e-01), SC_(-5.1295018196105957031250000000000000000000e-01), SC_(-9.7292184829711914062500000000000000000000e-01), SC_(8.5852718353271484375000000000000000000000e-01), SC_(-2.8276214599609375000000000000000000000000e+01), SC_(-3.4151585550568397475069652393470241202916e+01) }, 
      { SC_(-3.0003249645233154296875000000000000000000e-01), SC_(8.1472945213317871093750000000000000000000e-01), SC_(-6.0680961608886718750000000000000000000000e-01), SC_(6.9693541526794433593750000000000000000000e-01), SC_(-2.4891616821289062500000000000000000000000e+01), SC_(2.4209604261412190910158534025390434639425e+00) }, 
      { SC_(-2.9668104648590087890625000000000000000000e-01), SC_(-8.6480927467346191406250000000000000000000e-01), SC_(6.6165709495544433593750000000000000000000e-01), SC_(5.8719515800476074218750000000000000000000e-01), SC_(8.5264091491699218750000000000000000000000e+00), SC_(1.1266023439561064694217677874080968632512e+01) }, 
      { SC_(-2.2540819644927978515625000000000000000000e-01), SC_(-9.7619605064392089843750000000000000000000e-01), SC_(4.5390939712524414062500000000000000000000e-01), SC_(-3.2575476169586181640625000000000000000000e-01), SC_(-1.1143020629882812500000000000000000000000e+01), SC_(1.6879608353765298965114329807351754051698e+01) }, 
      { SC_(-1.5582466125488281250000000000000000000000e-01), SC_(3.1095576286315917968750000000000000000000e-01), SC_(-6.5226984024047851562500000000000000000000e-01), SC_(-6.5762662887573242187500000000000000000000e-01), SC_(-1.9808692932128906250000000000000000000000e+01), SC_(1.2551974771576260300419976046720836348802e+00) }, 
      { SC_(-1.2251126766204833984375000000000000000000e-01), SC_(-7.4820685386657714843750000000000000000000e-01), SC_(-2.3688310384750366210937500000000000000000e-01), SC_(-5.7958197593688964843750000000000000000000e-01), SC_(2.6551681518554687500000000000000000000000e+01), SC_(1.2436390918839404235278182201323415179077e+11) }, 
      { SC_(-1.0483121871948242187500000000000000000000e-01), SC_(-8.4364891052246093750000000000000000000000e-01), SC_(7.0890188217163085937500000000000000000000e-01), SC_(-1.1464345455169677734375000000000000000000e-01), SC_(1.0423149108886718750000000000000000000000e+01), SC_(-2.2987899082702757017611582333805187282473e+02) }, 
      { SC_(-9.8916828632354736328125000000000000000000e-02), SC_(4.4098687171936035156250000000000000000000e-01), SC_(-8.3235740661621093750000000000000000000000e-01), SC_(8.2515501976013183593750000000000000000000e-01), SC_(-2.7102302551269531250000000000000000000000e+01), SC_(1.6959269949904755169246761405353038517885e+00) }, 
      { SC_(-6.5437316894531250000000000000000000000000e-02), SC_(1.0956684112548828125000000000000000000000e+01), SC_(1.8389755249023437500000000000000000000000e+01), SC_(2.9501876831054687500000000000000000000000e+00), SC_(-1.5961425781250000000000000000000000000000e+01), SC_(1.1049682327848995795202142301861055908750e+00) }, 
      { SC_(-2.0471215248107910156250000000000000000000e-02), SC_(-8.4021687507629394531250000000000000000000e-02), SC_(-1.0882759094238281250000000000000000000000e-01), SC_(-2.4862170219421386718750000000000000000000e-02), SC_(1.4631301879882812500000000000000000000000e+01), SC_(1.5841708347213321866489698087221716459791e+06) }, 
      { SC_(-3.2718777656555175781250000000000000000000e-03), SC_(5.4783415794372558593750000000000000000000e-01), SC_(9.1948795318603515625000000000000000000000e-01), SC_(1.4750933647155761718750000000000000000000e-01), SC_(-1.5961425781250000000000000000000000000000e+01), SC_(1.0272440248224009436091313853650039966863e+00) }, 
      { SC_(-9.3136554824013728648424148559570312500000e-07), SC_(5.4982092478894628584384918212890625000000e-07), SC_(9.5400400823564268648624420166015625000000e-07), SC_(6.3460652199864853173494338989257812500000e-07), SC_(-1.3681354522705078125000000000000000000000e+01), SC_(1.8458412677363208067608043148411355136515e+00) }, 
      { SC_(-8.9756713350652717053890228271484375000000e-07), SC_(5.9039984989794902503490447998046875000000e-07), SC_(-9.2711752586183138191699981689453125000000e-07), SC_(-6.2625485952594317495822906494140625000000e-07), SC_(-9.1268844604492187500000000000000000000000e+00), SC_(1.9125961386145437429767013992287445983548e+00) }, 
      { SC_(-8.4829139268549624830484390258789062500000e-07), SC_(-1.9158295572196948342025279998779296875000e-07), SC_(-8.9209993348049465566873550415039062500000e-07), SC_(-2.9447517135849921032786369323730468750000e-07), SC_(3.0797538757324218750000000000000000000000e+00), SC_(1.3838719573654405589676735340194924931023e+01) }, 
      { SC_(-8.0491918197367340326309204101562500000000e-07), SC_(9.4441134024236816912889480590820312500000e-08), SC_(-4.4300361423665890470147132873535156250000e-07), SC_(-6.2323601923708338290452957153320312500000e-07), SC_(4.6881484985351562500000000000000000000000e+00), SC_(-2.8639804785244653083984253569879996816515e+01) }, 
      { SC_(-7.8669449976587202399969100952148437500000e-07), SC_(-2.9116336008883081376552581787109375000000e-09), SC_(9.2379605121095664799213409423828125000000e-07), SC_(9.5985114967334084212779998779296875000000e-07), SC_(-4.9536590576171875000000000000000000000000e+01), SC_(9.9741674057491206344972164307418990882303e-01) }, 
      { SC_(-7.8027665040281135588884353637695312500000e-07), SC_(-2.9248667487991042435169219970703125000000e-08), SC_(5.9621152104227803647518157958984375000000e-07), SC_(6.0056095207983162254095077514648437500000e-07), SC_(-2.0297058105468750000000000000000000000000e+01), SC_(9.3626172275111972523181247779172924528274e-01) }, 
      { SC_(-7.4018771556438878178596496582031250000000e-07), SC_(-6.9112320488784462213516235351562500000000e-07), SC_(1.3764724826614838093519210815429687500000e-07), SC_(-2.1018354345869738608598709106445312500000e-07), SC_(-3.0609359741210937500000000000000000000000e+00), SC_(1.7853727770995420701470792120039754677920e+01) }, 
      { SC_(-7.1622730501985643059015274047851562500000e-07), SC_(-9.9043336376780644059181213378906250000000e-07), SC_(-1.5647742657165508717298507690429687500000e-07), SC_(-7.7507093010353855788707733154296875000000e-07), SC_(4.1573547363281250000000000000000000000000e+01), SC_(6.6411572557989122954210475869239440414113e+18) }, 
      { SC_(-6.8477379500109236687421798706054687500000e-07), SC_(4.5167791995481820777058601379394531250000e-07), SC_(9.4118558990885503590106964111328125000000e-07), SC_(9.6221901912940666079521179199218750000000e-07), SC_(4.5716690063476562500000000000000000000000e+01), SC_(-2.4430308485765092169225922543978952364312e+19) }, 
      { SC_(-6.7563541961135342717170715332031250000000e-07), SC_(8.5498572843789588660001754760742187500000e-07), SC_(5.8856903706328012049198150634765625000000e-07), SC_(-1.2776490621035918593406677246093750000000e-07), SC_(-1.8878501892089843750000000000000000000000e+01), SC_(-6.6817948143631546813551869357016396870783e+00) }, 
      { SC_(-5.7615147852629888802766799926757812500000e-07), SC_(8.6798627307871356606483459472656250000000e-07), SC_(3.6271910630603088065981864929199218750000e-07), SC_(3.5747029869526159018278121948242187500000e-07), SC_(-1.0126148223876953125000000000000000000000e+01), SC_(4.8567570194209774622482576011303888814382e+00) }, 
      { SC_(-4.4794990117225097492337226867675781250000e-07), SC_(4.1154851260216673836112022399902343750000e-07), SC_(3.5940536236012121662497520446777343750000e-07), SC_(-9.9436329037416726350784301757812500000000e-07), SC_(1.5509803771972656250000000000000000000000e+01), SC_(2.8076564094579117449730829319686704511930e+06) }, 
      { SC_(-4.2832198232645168900489807128906250000000e-07), SC_(3.5963955724582774564623832702636718750000e-07), SC_(5.1440042625472415238618850708007812500000e-07), SC_(-2.1535907990255509503185749053955078125000e-07), SC_(2.5372909545898437500000000000000000000000e+01), SC_(1.4537419231903566905321063445734100531465e+11) }, 
      { SC_(-4.0033660297922324389219284057617187500000e-07), SC_(-5.1295023695274721831083297729492187500000e-07), SC_(-9.7292195277987048029899597167968750000000e-07), SC_(8.5852730080659966915845870971679687500000e-07), SC_(-2.8276214599609375000000000000000000000000e+01), SC_(1.2458497486363269324125667309082365637985e+00) }, 
      { SC_(-3.0003252504684496670961380004882812500000e-07), SC_(8.1472944657434709370136260986328125000000e-07), SC_(-6.0680963542836252599954605102539062500000e-07), SC_(6.9693555815319996327161788940429687500000e-07), SC_(-2.4891616821289062500000000000000000000000e+01), SC_(4.2198918108478418620708219025219124722121e-01) }, 
      { SC_(-2.9668103707081172615289688110351562500000e-07), SC_(-8.6480940808542072772979736328125000000000e-07), SC_(6.6165716816612984985113143920898437500000e-07), SC_(5.8719501794257666915655136108398437500000e-07), SC_(8.5264091491699218750000000000000000000000e+00), SC_(3.3327965763792833847111207316269065545484e+03) }, 
      { SC_(-2.2540820054928190074861049652099609375000e-07), SC_(-9.7619613370625302195549011230468750000000e-07), SC_(4.5390936520561808720231056213378906250000e-07), SC_(-3.2575474051554920151829719543457031250000e-07), SC_(-1.1143020629882812500000000000000000000000e+01), SC_(2.4881348540742683525223565559630362958243e+00) }, 
      { SC_(-1.5582463674945756793022155761718750000000e-07), SC_(3.1095578378881327807903289794921875000000e-07), SC_(-6.5226981860178057104349136352539062500000e-07), SC_(-6.5762674239522311836481094360351562500000e-07), SC_(-1.9808692932128906250000000000000000000000e+01), SC_(1.1129602848498859250036053774429249608808e+00) }, 
      { SC_(-1.2251126690898672677576541900634765625000e-07), SC_(-7.4820673034992069005966186523437500000000e-07), SC_(-2.3688312467129435390233993530273437500000e-07), SC_(-5.7958186516771093010902404785156250000000e-07), SC_(2.6551681518554687500000000000000000000000e+01), SC_(2.2688062457483146892330229786129229886441e+11) }, 
      { SC_(-1.0483120149729074910283088684082031250000e-07), SC_(-8.4364910435397177934646606445312500000000e-07), SC_(7.0890200731810182332992553710937500000000e-07), SC_(-1.1464345561762456782162189483642578125000e-07), SC_(1.0423149108886718750000000000000000000000e+01), SC_(-3.6593707599487658143323493330962303599499e+04) }, 
      { SC_(-9.8916814295080257579684257507324218750000e-08), SC_(4.4098692342231515794992446899414062500000e-07), SC_(-8.3235727288410998880863189697265625000000e-07), SC_(8.2515498434077017009258270263671875000000e-07), SC_(-2.7102302551269531250000000000000000000000e+01), SC_(9.3648885471407990727265617322659462953921e-01) }, 
      { SC_(-2.0471247808018233627080917358398437500000e-08), SC_(-8.4021678503631846979260444641113281250000e-08), SC_(-1.0882757806029985658824443817138671875000e-07), SC_(-2.4862174541340209543704986572265625000000e-08), SC_(1.4631301879882812500000000000000000000000e+01), SC_(1.4373131982665214774217787317847218954427e+06) }, 
      { SC_(-3.2719071896281093358993530273437500000000e-09), SC_(5.4783413361292332410812377929687500000000e-07), SC_(9.1948777480865828692913055419921875000000e-07), SC_(1.4750935406482312828302383422851562500000e-07), SC_(-1.5961425781250000000000000000000000000000e+01), SC_(1.0132155498422309503614099673159061586479e+00) }, 
      { SC_(1.0997041499649640172719955444335937500000e-08), SC_(8.2667474998743273317813873291015625000000e-07), SC_(1.1653753517748555168509483337402343750000e-07), SC_(-6.9524412538157775998115539550781250000000e-07), SC_(3.1900405883789062500000000000000000000000e-01), SC_(9.5783865539088907079603086555109422346186e-01) }, 
      { SC_(5.9683884501282591372728347778320312500000e-08), SC_(3.7842903566343011334538459777832031250000e-07), SC_(4.3220143197686411440372467041015625000000e-07), SC_(4.9630307330517098307609558105468750000000e-07), SC_(4.8837936401367187500000000000000000000000e+01), SC_(1.7078656602976246876142703011632105970485e+20) }, 
      { SC_(1.2311488717386964708566665649414062500000e-07), SC_(-2.3910831714601954445242881774902343750000e-07), SC_(-5.8386399359733331948518753051757812500000e-07), SC_(1.3564329037762945517897605895996093750000e-07), SC_(2.7371482849121093750000000000000000000000e+00), SC_(6.3684552081145031813405754464241294074718e+00) }, 
      { SC_(1.8564776382845593616366386413574218750000e-07), SC_(5.5833447731856722384691238403320312500000e-07), SC_(-2.8730971735058119520545005798339843750000e-07), SC_(8.6802128862473182380199432373046875000000e-07), SC_(4.6496627807617187500000000000000000000000e+01), SC_(-6.4853388604785581167513584895642667608886e+19) }, 
      { SC_(1.8900720988312968984246253967285156250000e-07), SC_(9.9447220236470457166433334350585937500000e-08), SC_(4.6559739530493970960378646850585937500000e-07), SC_(8.3438726505846716463565826416015625000000e-07), SC_(1.9523284912109375000000000000000000000000e+01), SC_(1.4572907535267130609541292463234912636546e+07) }, 
      { SC_(2.0396385025378549471497535705566406250000e-07), SC_(-5.6086435051838634535670280456542968750000e-08), SC_(-4.7405751502083148807287216186523437500000e-07), SC_(-3.1956062684912467375397682189941406250000e-07), SC_(1.5407905578613281250000000000000000000000e+01), SC_(-3.7118906681652055108727684222578765229067e+05) }, 
      { SC_(2.7952671644015936180949211120605468750000e-07), SC_(5.8441446526558138430118560791015625000000e-07), SC_(7.5686125455831643193960189819335937500000e-07), SC_(9.1898482423857785761356353759765625000000e-07), SC_(3.6627197265625000000000000000000000000000e-01), SC_(1.1038922491973991127785082690528735921245e+00) }, 
      { SC_(3.1148135803960030898451805114746093750000e-07), SC_(5.9585727285593748092651367187500000000000e-07), SC_(-9.2857681011082604527473449707031250000000e-07), SC_(-2.7741202757169958204030990600585937500000e-07), SC_(3.4912933349609375000000000000000000000000e+01), SC_(1.0474402252753394292771754104481060072272e+15) }, 
      { SC_(4.1209216306015150621533393859863281250000e-07), SC_(5.9455965129018295556306838989257812500000e-07), SC_(-9.3633434516959823668003082275390625000000e-07), SC_(-3.6689914395537925884127616882324218750000e-07), SC_(-2.2307708740234375000000000000000000000000e+01), SC_(2.8680467172025664645004317411758072349709e-01) }, 
      { SC_(4.2140766254306072369217872619628906250000e-07), SC_(-6.7477662923920433968305587768554687500000e-07), SC_(2.8792192097171209752559661865234375000000e-07), SC_(-7.6200467447051778435707092285156250000000e-07), SC_(-4.3967170715332031250000000000000000000000e+00), SC_(-2.8010969974184550812885483508204403279970e-01) }, 
      { SC_(5.0253402150701731443405151367187500000000e-07), SC_(6.4249184106301981955766677856445312500000e-07), SC_(-4.8980973588186316192150115966796875000000e-07), SC_(6.4168148128374014049768447875976562500000e-07), SC_(5.9570693969726562500000000000000000000000e-01), SC_(1.6347732655859280663916681238694784874580e-01) }, 
      { SC_(5.1548022383940406143665313720703125000000e-07), SC_(4.8129436436283867806196212768554687500000e-07), SC_(4.8626498028170317411422729492187500000000e-07), SC_(-5.0482640290283598005771636962890625000000e-08), SC_(-1.0777297973632812500000000000000000000000e+01), SC_(1.1106434663640753006012955436367983803014e+01) }, 
      { SC_(5.2346240408951416611671447753906250000000e-07), SC_(-7.0141209107532631605863571166992187500000e-07), SC_(-5.3968801694281864911317825317382812500000e-07), SC_(-4.8498350224690511822700500488281250000000e-07), SC_(3.0973449707031250000000000000000000000000e+01), SC_(-3.9681561947035579269678394807028062820923e+13) }, 
      { SC_(5.2749987844435963779687881469726562500000e-07), SC_(9.0044409262191038578748703002929687500000e-07), SC_(-1.8821879166353028267621994018554687500000e-08), SC_(-9.3110793386586010456085205078125000000000e-07), SC_(1.6360549926757812500000000000000000000000e+01), SC_(3.4539499888000137057062731709546485240318e+08) }, 
      { SC_(5.8794989854504819959402084350585937500000e-07), SC_(4.1872965539369033649563789367675781250000e-07), SC_(8.4174939729564357548952102661132812500000e-07), SC_(5.0937319429067429155111312866210937500000e-07), SC_(3.0753097534179687500000000000000000000000e+01), SC_(1.3030320728282024769122208046773597121977e+13) }, 
      { SC_(6.2944718592916615307331085205078125000000e-07), SC_(-7.2904595072031952440738677978515625000000e-07), SC_(8.1158373177458997815847396850585937500000e-07), SC_(6.7001701609115116298198699951171875000000e-07), SC_(-3.7301330566406250000000000000000000000000e+01), SC_(1.8439134249199753859018932537945488281275e+00) }, 
      { SC_(6.4691562329244334250688552856445312500000e-07), SC_(6.4380651565443258732557296752929687500000e-07), SC_(3.8965720250416779890656471252441406250000e-07), SC_(-7.4963463703170418739318847656250000000000e-07), SC_(-1.8290054321289062500000000000000000000000e+01), SC_(2.4258314616673475337362175593090336931067e+00) }, 
      { SC_(6.5163385443156585097312927246093750000000e-07), SC_(-7.5051616477139759808778762817382812500000e-08), SC_(7.6684841587848495692014694213867187500000e-08), SC_(9.3183871285873465240001678466796875000000e-08), SC_(4.9613464355468750000000000000000000000000e+01), SC_(-2.4108378518646741153956851171749013643853e+22) }, 
      { SC_(6.8143435782985761761665344238281250000000e-07), SC_(9.7704287327360361814498901367187500000000e-07), SC_(-4.9143568503495771437883377075195312500000e-07), SC_(-3.3510343655507313087582588195800781250000e-07), SC_(3.1428482055664062500000000000000000000000e+01), SC_(1.8026554133299335617971267086285402305995e+14) }, 
      { SC_(7.2535635808890219777822494506835937500000e-07), SC_(5.7066358749580103904008865356445312500000e-08), SC_(2.4072005544439889490604400634765625000000e-07), SC_(-6.6870256887341383844614028930664062500000e-07), SC_(-3.8045288085937500000000000000000000000000e+01), SC_(1.2571485715026903432521871946447902139684e+00) }, 
      { SC_(7.3738942774070892482995986938476562500000e-07), SC_(3.5903940442949533462524414062500000000000e-07), SC_(-8.3112831816833931952714920043945312500000e-07), SC_(-3.0753324153920402750372886657714843750000e-07), SC_(-1.0021736145019531250000000000000000000000e+01), SC_(-3.5754655716766093213947965359532026020232e-02) }, 
      { SC_(7.4485751611064188182353973388671875000000e-07), SC_(-9.0765729510167147964239120483398437500000e-07), SC_(-7.0177202360355295240879058837890625000000e-07), SC_(-8.0573659033689182251691818237304687500000e-07), SC_(4.9406845092773437500000000000000000000000e+01), SC_(-3.4255378014265271091932817936441718796118e+21) }, 
      { SC_(7.5351476880314294248819351196289062500000e-07), SC_(1.7053548617695923894643783569335937500000e-07), SC_(6.1635091697098687291145324707031250000000e-07), SC_(-5.5237615015357732772827148437500000000000e-07), SC_(-4.8222610473632812500000000000000000000000e+01), SC_(1.3774347753159480695102537426418944948815e+00) }, 
      { SC_(8.8014803623082116246223449707031250000000e-07), SC_(3.9815347463445505127310752868652343750000e-07), SC_(-1.7466692270318162627518177032470703125000e-07), SC_(7.8180642049119342118501663208007812500000e-07), SC_(-7.6834869384765625000000000000000000000000e+00), SC_(3.5650488120718216113949836791170886647514e+00) }, 
      { SC_(9.1003494162578135728836059570312500000000e-07), SC_(2.3208940547192469239234924316406250000000e-07), SC_(5.5779537433409132063388824462890625000000e-07), SC_(-5.3422354540089145302772521972656250000000e-08), SC_(4.8745956420898437500000000000000000000000e+01), SC_(-1.0486162158441313568620476569174961357320e+22) }, 
      { SC_(9.1858260020671878010034561157226562500000e-07), SC_(1.6191336271731415763497352600097656250000e-07), SC_(9.4431015895679593086242675781250000000000e-08), SC_(-6.8388499130378477275371551513671875000000e-07), SC_(-3.6137557983398437500000000000000000000000e+01), SC_(3.3030330639736674266843042334691972211938e+00) }, 
      { SC_(9.3773542175767943263053894042968750000000e-07), SC_(8.2675160228973254561424255371093750000000e-07), SC_(-5.5793202591303270310163497924804687500000e-07), SC_(2.6471855107956798747181892395019531250000e-07), SC_(-1.9183296203613281250000000000000000000000e+01), SC_(6.2491210713189805980093110531796289403889e+00) }, 
      { SC_(9.8576219897950068116188049316406250000000e-07), SC_(9.1501351562328636646270751953125000000000e-07), SC_(9.9292265076655894517898559570312500000000e-07), SC_(9.2977688836981542408466339111328125000000e-07), SC_(4.6769485473632812500000000000000000000000e+01), SC_(2.0027877453968743151108534797410529454092e+20) }, 
      { SC_(1.0997056961059570312500000000000000000000e-02), SC_(8.2667469978332519531250000000000000000000e-01), SC_(1.1653757095336914062500000000000000000000e-01), SC_(-6.9524407386779785156250000000000000000000e-01), SC_(3.1900405883789062500000000000000000000000e-01), SC_(9.2548682401648616853356963537905141626817e-01) }, 
      { SC_(5.9683918952941894531250000000000000000000e-02), SC_(3.7842905521392822265625000000000000000000e-01), SC_(4.3220138549804687500000000000000000000000e-01), SC_(4.9630320072174072265625000000000000000000e-01), SC_(4.8837936401367187500000000000000000000000e+01), SC_(2.3360029807438370118209671449489491031780e+19) }, 
      { SC_(1.2311494350433349609375000000000000000000e-01), SC_(-2.3910832405090332031250000000000000000000e-01), SC_(-5.8386397361755371093750000000000000000000e-01), SC_(1.3564324378967285156250000000000000000000e-01), SC_(2.7371482849121093750000000000000000000000e+00), SC_(1.1978111292135351506707188690100870479425e+01) }, 
      { SC_(1.8564772605895996093750000000000000000000e-01), SC_(5.5833435058593750000000000000000000000000e-01), SC_(-2.8730976581573486328125000000000000000000e-01), SC_(8.6802124977111816406250000000000000000000e-01), SC_(4.6496627807617187500000000000000000000000e+01), SC_(-1.7840996037684430750712033617196753135378e+20) }, 
      { SC_(1.8900716304779052734375000000000000000000e-01), SC_(9.9447250366210937500000000000000000000000e-02), SC_(4.6559739112854003906250000000000000000000e-01), SC_(8.3438730239868164062500000000000000000000e-01), SC_(1.9523284912109375000000000000000000000000e+01), SC_(7.2886115396534163383445593847149053138031e+05) }, 
      { SC_(2.0396387577056884765625000000000000000000e-01), SC_(-5.6086421012878417968750000000000000000000e-02), SC_(-4.7405743598937988281250000000000000000000e-01), SC_(-3.1956064701080322265625000000000000000000e-01), SC_(1.5407905578613281250000000000000000000000e+01), SC_(-1.1036499957987892555082977085972657265225e+07) }, 
      { SC_(2.1994018554687500000000000000000000000000e-01), SC_(1.6533493041992187500000000000000000000000e+01), SC_(2.3307514190673828125000000000000000000000e+00), SC_(-1.3904880523681640625000000000000000000000e+01), SC_(3.1900405883789062500000000000000000000000e-01), SC_(9.6682575460251035755034047049922495381787e-01) }, 
      { SC_(2.7952671051025390625000000000000000000000e-01), SC_(5.8441448211669921875000000000000000000000e-01), SC_(7.5686120986938476562500000000000000000000e-01), SC_(9.1898488998413085937500000000000000000000e-01), SC_(3.6627197265625000000000000000000000000000e-01), SC_(1.0964107984836058157877164860148214084725e+00) }, 
      { SC_(3.1148135662078857421875000000000000000000e-01), SC_(5.9585714340209960937500000000000000000000e-01), SC_(-9.2857670783996582031250000000000000000000e-01), SC_(-2.7741205692291259765625000000000000000000e-01), SC_(3.4912933349609375000000000000000000000000e+01), SC_(4.0559154452708809711914414382955973854936e+19) }, 
      { SC_(4.1209220886230468750000000000000000000000e-01), SC_(5.9455966949462890625000000000000000000000e-01), SC_(-9.3633437156677246093750000000000000000000e-01), SC_(-3.6689913272857666015625000000000000000000e-01), SC_(-2.2307708740234375000000000000000000000000e+01), SC_(-3.6618911882233667355216533124295718471566e+00) }, 
      { SC_(4.2140769958496093750000000000000000000000e-01), SC_(-6.7477655410766601562500000000000000000000e-01), SC_(2.8792190551757812500000000000000000000000e-01), SC_(-7.6200461387634277343750000000000000000000e-01), SC_(-4.3967170715332031250000000000000000000000e+00), SC_(1.1232182589632404612139526458451140842291e+00) }, 
      { SC_(5.0253415107727050781250000000000000000000e-01), SC_(6.4249181747436523437500000000000000000000e-01), SC_(-4.8980975151062011718750000000000000000000e-01), SC_(6.4168143272399902343750000000000000000000e-01), SC_(5.9570693969726562500000000000000000000000e-01), SC_(-3.6890928504032295647550377931854423686688e-01) }, 
      { SC_(5.1548027992248535156250000000000000000000e-01), SC_(4.8129451274871826171875000000000000000000e-01), SC_(4.8626494407653808593750000000000000000000e-01), SC_(-5.0482630729675292968750000000000000000000e-02), SC_(-1.0777297973632812500000000000000000000000e+01), SC_(1.8478252734935622983875264733627125110476e+00) }, 
      { SC_(5.2346229553222656250000000000000000000000e-01), SC_(-7.0141196250915527343750000000000000000000e-01), SC_(-5.3968787193298339843750000000000000000000e-01), SC_(-4.8498356342315673828125000000000000000000e-01), SC_(3.0973449707031250000000000000000000000000e+01), SC_(-8.9114666865028226483832469523356535631424e+14) }, 
      { SC_(5.2749991416931152343750000000000000000000e-01), SC_(9.0044403076171875000000000000000000000000e-01), SC_(-1.8821895122528076171875000000000000000000e-02), SC_(-9.3110799789428710937500000000000000000000e-01), SC_(1.6360549926757812500000000000000000000000e+01), SC_(4.5597719881817093241734400468576025226844e+12) }, 
      { SC_(5.8794999122619628906250000000000000000000e-01), SC_(4.1872966289520263671875000000000000000000e-01), SC_(8.4174942970275878906250000000000000000000e-01), SC_(5.0937318801879882812500000000000000000000e-01), SC_(3.0753097534179687500000000000000000000000e+01), SC_(4.2586796461733229713504448740147996766154e+12) }, 
      { SC_(6.2944722175598144531250000000000000000000e-01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-3.7301330566406250000000000000000000000000e+01), SC_(1.7416341132204465667912373187867771824751e+01) }, 
      { SC_(6.4691567420959472656250000000000000000000e-01), SC_(6.4380645751953125000000000000000000000000e-01), SC_(3.8965725898742675781250000000000000000000e-01), SC_(-7.4963450431823730468750000000000000000000e-01), SC_(-1.8290054321289062500000000000000000000000e+01), SC_(-1.5830252144380605751602939624584236354406e-01) }, 
      { SC_(6.5163397789001464843750000000000000000000e-01), SC_(-7.5051605701446533203125000000000000000000e-02), SC_(7.6684832572937011718750000000000000000000e-02), SC_(9.3183875083923339843750000000000000000000e-02), SC_(4.9613464355468750000000000000000000000000e+01), SC_(-1.1425004886732573964646957895325942024436e+23) }, 
      { SC_(6.8143439292907714843750000000000000000000e-01), SC_(9.7704315185546875000000000000000000000000e-01), SC_(-4.9143564701080322265625000000000000000000e-01), SC_(-3.3510351181030273437500000000000000000000e-01), SC_(3.1428482055664062500000000000000000000000e+01), SC_(2.5917168836014621167088740854172249116835e+18) }, 
      { SC_(7.2535634040832519531250000000000000000000e-01), SC_(5.7066321372985839843750000000000000000000e-02), SC_(2.4072003364562988281250000000000000000000e-01), SC_(-6.6870260238647460937500000000000000000000e-01), SC_(-3.8045288085937500000000000000000000000000e+01), SC_(5.5830678089101446244909503258355414120455e-01) }, 
      { SC_(7.3738932609558105468750000000000000000000e-01), SC_(3.5903942584991455078125000000000000000000e-01), SC_(-8.3112835884094238281250000000000000000000e-01), SC_(-3.0753326416015625000000000000000000000000e-01), SC_(-1.0021736145019531250000000000000000000000e+01), SC_(-1.7454076579037614669848446526977275161848e+00) }, 
      { SC_(7.4485754966735839843750000000000000000000e-01), SC_(-9.0765738487243652343750000000000000000000e-01), SC_(-7.0177221298217773437500000000000000000000e-01), SC_(-8.0573654174804687500000000000000000000000e-01), SC_(4.9406845092773437500000000000000000000000e+01), SC_(-9.6884151551490811391689010129399488787879e+23) }, 
      { SC_(7.5351476669311523437500000000000000000000e-01), SC_(1.7053544521331787109375000000000000000000e-01), SC_(6.1635088920593261718750000000000000000000e-01), SC_(-5.5237627029418945312500000000000000000000e-01), SC_(-4.8222610473632812500000000000000000000000e+01), SC_(3.7247872529512665657869843025394053451408e-01) }, 
      { SC_(8.8014793395996093750000000000000000000000e-01), SC_(3.9815342426300048828125000000000000000000e-01), SC_(-1.7466694116592407226562500000000000000000e-01), SC_(7.8180646896362304687500000000000000000000e-01), SC_(-7.6834869384765625000000000000000000000000e+00), SC_(7.7953316363742166939953290011475460274949e-01) }, 
      { SC_(9.1003513336181640625000000000000000000000e-01), SC_(2.3208940029144287109375000000000000000000e-01), SC_(5.5779528617858886718750000000000000000000e-01), SC_(-5.3422331809997558593750000000000000000000e-02), SC_(4.8745956420898437500000000000000000000000e+01), SC_(-1.3046798994231795963160231594358316067244e+23) }, 
      { SC_(9.1858267784118652343750000000000000000000e-01), SC_(1.6191339492797851562500000000000000000000e-01), SC_(9.4431042671203613281250000000000000000000e-02), SC_(-6.8388485908508300781250000000000000000000e-01), SC_(-3.6137557983398437500000000000000000000000e+01), SC_(-3.5110626991996604613108589341046876705748e-01) }, 
      { SC_(9.3773555755615234375000000000000000000000e-01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(2.6471853256225585937500000000000000000000e-01), SC_(-1.9183296203613281250000000000000000000000e+01), SC_(2.5246966386780909529006406563554171335629e-01) }, 
      { SC_(9.8576259613037109375000000000000000000000e-01), SC_(9.1501355171203613281250000000000000000000e-01), SC_(9.9292254447937011718750000000000000000000e-01), SC_(9.2977690696716308593750000000000000000000e-01), SC_(4.6769485473632812500000000000000000000000e+01), SC_(1.8565763433722927949245355864321800360146e+20) }, 
      { SC_(1.1936779022216796875000000000000000000000e+00), SC_(7.5685806274414062500000000000000000000000e+00), SC_(8.6440277099609375000000000000000000000000e+00), SC_(9.9260635375976562500000000000000000000000e+00), SC_(4.8837936401367187500000000000000000000000e+01), SC_(1.3271193766483616932974176558689361451522e+11) }, 
      { SC_(2.4622993469238281250000000000000000000000e+00), SC_(-4.7821674346923828125000000000000000000000e+00), SC_(-1.1677280426025390625000000000000000000000e+01), SC_(2.7128639221191406250000000000000000000000e+00), SC_(2.7371482849121093750000000000000000000000e+00), SC_(2.6077349439202448031943534843104811780929e+00) }, 
      { SC_(3.7129554748535156250000000000000000000000e+00), SC_(1.1166687011718750000000000000000000000000e+01), SC_(-5.7461948394775390625000000000000000000000e+00), SC_(1.7360427856445312500000000000000000000000e+01), SC_(4.6496627807617187500000000000000000000000e+01), SC_(1.8757859643893081348088692150460593809314e+29) }, 
      { SC_(3.7801437377929687500000000000000000000000e+00), SC_(1.9889450073242187500000000000000000000000e+00), SC_(9.3119468688964843750000000000000000000000e+00), SC_(1.6687744140625000000000000000000000000000e+01), SC_(1.9523284912109375000000000000000000000000e+01), SC_(4.1363729867437335411880026687935004278846e+00) }, 
      { SC_(4.0792770385742187500000000000000000000000e+00), SC_(-1.1217288970947265625000000000000000000000e+00), SC_(-9.4811515808105468750000000000000000000000e+00), SC_(-6.3912124633789062500000000000000000000000e+00), SC_(1.5407905578613281250000000000000000000000e+01), SC_(-1.1015351537212423543068232243675390297483e+21) }, 
      { SC_(5.4985351562500000000000000000000000000000e+00), SC_(4.1333728027343750000000000000000000000000e+02), SC_(5.8268798828125000000000000000000000000000e+01), SC_(-3.4762207031250000000000000000000000000000e+02), SC_(3.1900329589843750000000000000000000000000e+00), SC_(7.0641620692870283423309468681437896822651e-01) }, 
      { SC_(5.5905342102050781250000000000000000000000e+00), SC_(1.1688289642333984375000000000000000000000e+01), SC_(1.5137226104736328125000000000000000000000e+01), SC_(1.8379699707031250000000000000000000000000e+01), SC_(3.6627197265625000000000000000000000000000e-01), SC_(1.0903949493756432894914997387063010509170e+00) }, 
      { SC_(6.2296276092529296875000000000000000000000e+00), SC_(1.1917144775390625000000000000000000000000e+01), SC_(-1.8571533203125000000000000000000000000000e+01), SC_(-5.5482406616210937500000000000000000000000e+00), SC_(3.4912933349609375000000000000000000000000e+01), SC_(-3.0452671322061282725381645571599564184368e+58) }, 
      { SC_(8.2418441772460937500000000000000000000000e+00), SC_(1.1891193389892578125000000000000000000000e+01), SC_(-1.8726692199707031250000000000000000000000e+01), SC_(-7.3379821777343750000000000000000000000000e+00), SC_(-2.2307708740234375000000000000000000000000e+01), SC_(-1.2289091561745909342127302946539020611711e+17) }, 
      { SC_(8.4281539916992187500000000000000000000000e+00), SC_(-1.3495532989501953125000000000000000000000e+01), SC_(5.7584381103515625000000000000000000000000e+00), SC_(-1.5240093231201171875000000000000000000000e+01), SC_(-4.3967170715332031250000000000000000000000e+00), SC_(-8.4457471810243159993997923317595883314031e-04) }, 
      { SC_(1.0050682067871093750000000000000000000000e+01), SC_(1.2849838256835937500000000000000000000000e+01), SC_(-9.7961959838867187500000000000000000000000e+00), SC_(1.2833629608154296875000000000000000000000e+01), SC_(5.9570693969726562500000000000000000000000e-01), SC_(5.6639158480937048267577742903863425719244e-01) }, 
      { SC_(1.0309604644775390625000000000000000000000e+01), SC_(9.6258888244628906250000000000000000000000e+00), SC_(9.7252998352050781250000000000000000000000e+00), SC_(-1.0096530914306640625000000000000000000000e+00), SC_(-1.0777297973632812500000000000000000000000e+01), SC_(-5.4727991260600594818622693500786843572669e+00) }, 
      { SC_(1.0469245910644531250000000000000000000000e+01), SC_(-1.4028240203857421875000000000000000000000e+01), SC_(-1.0793758392333984375000000000000000000000e+01), SC_(-9.6996726989746093750000000000000000000000e+00), SC_(3.0973449707031250000000000000000000000000e+01), SC_(4.2053633464978874215146276066756456822620e+31) }, 
      { SC_(1.0549999237060546875000000000000000000000e+01), SC_(1.8008880615234375000000000000000000000000e+01), SC_(-3.7643814086914062500000000000000000000000e-01), SC_(-1.8622161865234375000000000000000000000000e+01), SC_(1.6360549926757812500000000000000000000000e+01), SC_(6.1730386523387868549145902183216998125762e+41) }, 
      { SC_(1.1758998870849609375000000000000000000000e+01), SC_(8.3745918273925781250000000000000000000000e+00), SC_(1.6834991455078125000000000000000000000000e+01), SC_(1.0187465667724609375000000000000000000000e+01), SC_(3.0753097534179687500000000000000000000000e+01), SC_(6.1192819294685935939514571900373511125331e+09) }, 
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-3.7301330566406250000000000000000000000000e+01), SC_(2.6610626120927005151151193991881863075756e+06) }, 
      { SC_(1.2938312530517578125000000000000000000000e+01), SC_(1.2876132965087890625000000000000000000000e+01), SC_(7.7931442260742187500000000000000000000000e+00), SC_(-1.4992691040039062500000000000000000000000e+01), SC_(-1.8290054321289062500000000000000000000000e+01), SC_(-8.1798659794806390896341908977435271892929e+06) }, 
      { SC_(1.3032680511474609375000000000000000000000e+01), SC_(-1.5010318756103515625000000000000000000000e+00), SC_(1.5336971282958984375000000000000000000000e+00), SC_(1.8636779785156250000000000000000000000000e+00), SC_(4.9613464355468750000000000000000000000000e+01), SC_(9.6240419641050879480209931027942787358191e+26) }, 
      { SC_(1.3628688812255859375000000000000000000000e+01), SC_(1.9540863037109375000000000000000000000000e+01), SC_(-9.8287124633789062500000000000000000000000e+00), SC_(-6.7020702362060546875000000000000000000000e+00), SC_(3.1428482055664062500000000000000000000000e+01), SC_(-2.9533080314394465178416446450559211163004e+64) }, 
      { SC_(1.4507125854492187500000000000000000000000e+01), SC_(1.1413269042968750000000000000000000000000e+00), SC_(4.8143997192382812500000000000000000000000e+00), SC_(-1.3374053955078125000000000000000000000000e+01), SC_(-3.8045288085937500000000000000000000000000e+01), SC_(-8.9270957135964855777864231951497515160700e-02) }, 
      { SC_(1.4747787475585937500000000000000000000000e+01), SC_(7.1807880401611328125000000000000000000000e+00), SC_(-1.6622566223144531250000000000000000000000e+01), SC_(-6.1506652832031250000000000000000000000000e+00), SC_(-1.0021736145019531250000000000000000000000e+01), SC_(-7.8142849034366732539572238729342407894153e+14) }, 
      { SC_(1.4897151947021484375000000000000000000000e+01), SC_(-1.8153144836425781250000000000000000000000e+01), SC_(-1.4035442352294921875000000000000000000000e+01), SC_(-1.6114730834960937500000000000000000000000e+01), SC_(4.9406845092773437500000000000000000000000e+01), SC_(-6.8326571052989051410923776720682169004023e+51) }, 
      { SC_(1.5070297241210937500000000000000000000000e+01), SC_(3.4107093811035156250000000000000000000000e+00), SC_(1.2327018737792968750000000000000000000000e+01), SC_(-1.1047523498535156250000000000000000000000e+01), SC_(-4.8222610473632812500000000000000000000000e+01), SC_(-9.0819742729695319553008618079011493034431e-02) }, 
      { SC_(1.7602958679199218750000000000000000000000e+01), SC_(7.9630680084228515625000000000000000000000e+00), SC_(-3.4933395385742187500000000000000000000000e+00), SC_(1.5636131286621093750000000000000000000000e+01), SC_(-7.6834869384765625000000000000000000000000e+00), SC_(1.4819504760088829624306068109981132052918e+01) }, 
      { SC_(1.8200698852539062500000000000000000000000e+01), SC_(4.6417884826660156250000000000000000000000e+00), SC_(1.1155906677246093750000000000000000000000e+01), SC_(-1.0684471130371093750000000000000000000000e+00), SC_(4.8745956420898437500000000000000000000000e+01), SC_(8.2333014766683380658500736752922662913969e+35) }, 
      { SC_(1.8371650695800781250000000000000000000000e+01), SC_(3.2382678985595703125000000000000000000000e+00), SC_(1.8886203765869140625000000000000000000000e+00), SC_(-1.3677696228027343750000000000000000000000e+01), SC_(-3.6137557983398437500000000000000000000000e+01), SC_(8.7300051886749816455465127014758220630644e+03) }, 
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(5.2943706512451171875000000000000000000000e+00), SC_(-1.9183296203613281250000000000000000000000e+01), SC_(1.7429133108056441106447473558858049597528e+08) }, 
      { SC_(1.9715248107910156250000000000000000000000e+01), SC_(1.8300270080566406250000000000000000000000e+01), SC_(1.9858451843261718750000000000000000000000e+01), SC_(1.8595535278320312500000000000000000000000e+01), SC_(4.6769485473632812500000000000000000000000e+01), SC_(1.1809819624735874941138601211320937112985e+20) }, 
      { SC_(2.9841979980468750000000000000000000000000e+01), SC_(1.8921453857421875000000000000000000000000e+02), SC_(2.1610070800781250000000000000000000000000e+02), SC_(2.4815161132812500000000000000000000000000e+02), SC_(4.8837939453125000000000000000000000000000e+02), SC_(1.1234842046645656478399433357722102843208e+63) }, 
      { SC_(6.1557495117187500000000000000000000000000e+01), SC_(-1.1955416870117187500000000000000000000000e+02), SC_(-2.9193200683593750000000000000000000000000e+02), SC_(6.7821594238281250000000000000000000000000e+01), SC_(2.7371459960937500000000000000000000000000e+01), SC_(2.1674477111723030285923492008898849878320e+04) }, 
      { SC_(9.4503601074218750000000000000000000000000e+01), SC_(4.9723632812500000000000000000000000000000e+01), SC_(2.3279870605468750000000000000000000000000e+02), SC_(4.1719360351562500000000000000000000000000e+02), SC_(1.9523284912109375000000000000000000000000e+02), SC_(4.5853070760608922987397680746647819058985e+04) }, 
      { SC_(9.4896057128906250000000000000000000000000e+01), SC_(-5.0443908691406250000000000000000000000000e+01), SC_(-2.3778826904296875000000000000000000000000e+02), SC_(-4.5794592285156250000000000000000000000000e+02), SC_(1.0284307861328125000000000000000000000000e+02), SC_(-4.1286224390518503050086482630597284841834e+164) }, 
      { SC_(1.2343554687500000000000000000000000000000e+02), SC_(-3.1104504394531250000000000000000000000000e+02), SC_(3.1187390136718750000000000000000000000000e+02), SC_(1.8677545166015625000000000000000000000000e+02), SC_(-1.8749200439453125000000000000000000000000e+02), SC_(4.9969504891988273564692350858428032034076e+43) }, 
      { SC_(1.3306365966796875000000000000000000000000e+02), SC_(-3.1518371582031250000000000000000000000000e+02), SC_(8.4382263183593750000000000000000000000000e+01), SC_(4.0488085937500000000000000000000000000000e+02), SC_(2.2665441894531250000000000000000000000000e+02), SC_(-4.8867065198344074982296348271251953749483e-78) }, 
      { SC_(1.3976336669921875000000000000000000000000e+02), SC_(2.9220727539062500000000000000000000000000e+02), SC_(3.7843066406250000000000000000000000000000e+02), SC_(4.5949243164062500000000000000000000000000e+02), SC_(3.6627197265625000000000000000000000000000e+00), SC_(2.3687914145194196830239194979923629978246e+00) }, 
      { SC_(1.5196862792968750000000000000000000000000e+02), SC_(7.5208618164062500000000000000000000000000e+01), SC_(2.5750354003906250000000000000000000000000e+02), SC_(-4.4022045898437500000000000000000000000000e+02), SC_(-6.4754302978515625000000000000000000000000e+01), SC_(1.0561036580393381996970837387609820091821e+03) }, 
      { SC_(2.0732153320312500000000000000000000000000e+02), SC_(-2.4193530273437500000000000000000000000000e+02), SC_(-3.3767150878906250000000000000000000000000e+02), SC_(-9.1280151367187500000000000000000000000000e+01), SC_(-3.6626367187500000000000000000000000000000e+02), SC_(8.0908024626992620813895438253149816247800e+255) }, 
      { SC_(2.1070385742187500000000000000000000000000e+02), SC_(-3.3738830566406250000000000000000000000000e+02), SC_(1.4396093750000000000000000000000000000000e+02), SC_(-3.8100231933593750000000000000000000000000e+02), SC_(-4.3967193603515625000000000000000000000000e+01), SC_(1.5431372244833444989774945930181751954140e-28) }, 
      { SC_(2.3033087158203125000000000000000000000000e+02), SC_(-3.9926159667968750000000000000000000000000e+02), SC_(-1.1391021728515625000000000000000000000000e+01), SC_(-1.5567205810546875000000000000000000000000e+02), SC_(7.8525085449218750000000000000000000000000e+01), SC_(5.9363148120112755714166978250790490055026e+231) }, 
      { SC_(2.5126708984375000000000000000000000000000e+02), SC_(3.2124597167968750000000000000000000000000e+02), SC_(-2.4490490722656250000000000000000000000000e+02), SC_(3.2084069824218750000000000000000000000000e+02), SC_(5.9570617675781250000000000000000000000000e+00), SC_(2.5412476580675151610198476612848155687784e-03) }, 
      { SC_(2.5774011230468750000000000000000000000000e+02), SC_(2.4064727783203125000000000000000000000000e+02), SC_(2.4313244628906250000000000000000000000000e+02), SC_(-2.5241302490234375000000000000000000000000e+01), SC_(-1.0777297973632812500000000000000000000000e+02), SC_(-5.5482592911765229670127582592804835964237e+07) }, 
      { SC_(2.6293139648437500000000000000000000000000e+02), SC_(-4.7077978515625000000000000000000000000000e+02), SC_(-2.3407934570312500000000000000000000000000e+02), SC_(4.2885412597656250000000000000000000000000e+02), SC_(-2.5586175537109375000000000000000000000000e+02), SC_(-1.5934527454871155849403111121808288778568e+269) }, 
      { SC_(2.9397497558593750000000000000000000000000e+02), SC_(2.0936480712890625000000000000000000000000e+02), SC_(4.2087475585937500000000000000000000000000e+02), SC_(2.5468664550781250000000000000000000000000e+02), SC_(3.0753100585937500000000000000000000000000e+02), SC_(5.9304523939573133871694979988794115377472e+87) }, 
      { SC_(3.1472363281250000000000000000000000000000e+02), SC_(-3.6452307128906250000000000000000000000000e+02), SC_(4.0579187011718750000000000000000000000000e+02), SC_(3.3500854492187500000000000000000000000000e+02), SC_(-3.7301318359375000000000000000000000000000e+02), SC_(5.9267564106025601167440826043367866028487e+87) }, 
      { SC_(3.1576904296875000000000000000000000000000e+02), SC_(2.8022741699218750000000000000000000000000e+02), SC_(1.6928509521484375000000000000000000000000e+02), SC_(-4.1887426757812500000000000000000000000000e+02), SC_(-1.2058114624023437500000000000000000000000e+02), SC_(-5.0454599088085062279202352416045361107404e+89) }, 
      { SC_(3.2581701660156250000000000000000000000000e+02), SC_(-3.7525817871093750000000000000000000000000e+01), SC_(3.8342407226562500000000000000000000000000e+01), SC_(4.6591918945312500000000000000000000000000e+01), SC_(4.9613464355468750000000000000000000000000e+02), SC_(1.1393652562647513959661812709276943653070e+276) }, 
      { SC_(3.5303112792968750000000000000000000000000e+02), SC_(3.3933105468750000000000000000000000000000e+01), SC_(1.2205511474609375000000000000000000000000e+02), SC_(-6.1333190917968750000000000000000000000000e+01), SC_(-1.4904760742187500000000000000000000000000e+02), SC_(1.2828144126059547362039134142446288034034e-10) }, 
      { SC_(3.5587512207031250000000000000000000000000e+02), SC_(-2.4012957763671875000000000000000000000000e+02), SC_(-4.5494055175781250000000000000000000000000e+02), SC_(3.0006848144531250000000000000000000000000e+02), SC_(1.6011944580078125000000000000000000000000e+02), SC_(4.3428388682870413894831054141491862458551e+38) }, 
      { SC_(4.0018322753906250000000000000000000000000e+02), SC_(-2.6951184082031250000000000000000000000000e+02), SC_(-3.0550463867187500000000000000000000000000e+02), SC_(3.4430871582031250000000000000000000000000e+02), SC_(3.8599804687500000000000000000000000000000e+02), SC_(6.5613961348691474586046824924000243590375e+176) }, 
      { SC_(4.2938598632812500000000000000000000000000e+02), SC_(-4.1503112792968750000000000000000000000000e+01), SC_(2.7571264648437500000000000000000000000000e+02), SC_(-1.9638604736328125000000000000000000000000e+02), SC_(-1.3208374023437500000000000000000000000000e+01), SC_(1.0571107981734581663978880846581759853793e-02) }, 
      { SC_(4.3900158691406250000000000000000000000000e+02), SC_(-2.5992407226562500000000000000000000000000e+02), SC_(3.7594274902343750000000000000000000000000e+02), SC_(-4.8347949218750000000000000000000000000000e+02), SC_(5.0156372070312500000000000000000000000000e+01), SC_(1.6617273173940173749692119011363235352267e+13) }, 
      { SC_(4.4007397460937500000000000000000000000000e+02), SC_(1.9907672119140625000000000000000000000000e+02), SC_(-8.7333465576171875000000000000000000000000e+01), SC_(3.9090319824218750000000000000000000000000e+02), SC_(-7.6834899902343750000000000000000000000000e+01), SC_(-1.3494188431073248493790028245922157972036e+39) }, 
      { SC_(4.6308850097656250000000000000000000000000e+02), SC_(1.0592816162109375000000000000000000000000e+02), SC_(4.6805725097656250000000000000000000000000e+01), SC_(-2.7344873046875000000000000000000000000000e+02), SC_(2.1135803222656250000000000000000000000000e+01), SC_(3.6785304966163030487123076706740434930886e+91) }, 
      { SC_(4.7974829101562500000000000000000000000000e+02), SC_(-1.4536187744140625000000000000000000000000e+02), SC_(-6.1130004882812500000000000000000000000000e+01), SC_(1.8040661621093750000000000000000000000000e+02), SC_(-3.8888085937500000000000000000000000000000e+02), SC_(3.5538673162086016498889909145538731312179e+224) }, 
      { SC_(4.9288122558593750000000000000000000000000e+02), SC_(4.5750683593750000000000000000000000000000e+02), SC_(4.9646130371093750000000000000000000000000e+02), SC_(4.6488842773437500000000000000000000000000e+02), SC_(4.6769494628906250000000000000000000000000e+02), SC_(7.0894449011388970455969152120597029644315e+199) }
   }};
//#undef SC_

