/*
 * Decompiled with CFR 0.152.
 */
package gr.zeus.tests;

import gr.zeus.tests.JDesktopTester;
import gr.zeus.tests.JMessageTester;
import gr.zeus.tests.JTableTester;
import gr.zeus.tests.JToolBarTester;
import gr.zeus.tests.JTypeSafeTester;
import gr.zeus.ui.SingleAppInstance;
import gr.zeus.util.SimpleTimerMillis;
import gr.zeus.util.SimpleTimerNanos;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class JTester
extends JFrame {
    private static SingleAppInstance m_inst = null;
    private SimpleTimerMillis m_timerMillis = new SimpleTimerMillis();
    private SimpleTimerNanos m_timerNanos = new SimpleTimerNanos();
    private JButton jconsoleButton2;
    private JButton jmessageButton;
    private JButton typesafeButton;

    public JTester() {
        this.m_timerMillis.start();
        this.m_timerNanos.start();
        this.init_lnf();
        this.initComponents();
        long nanos = this.m_timerNanos.elapsedNanos();
        double millis2 = this.m_timerNanos.elapsedMillis();
        double secs2 = this.m_timerNanos.elapsedSeconds();
        long millis = this.m_timerMillis.elapsedMillis();
        double secs = this.m_timerMillis.elapsedSeconds();
        System.out.println("gui startup time: " + nanos + " nanos, " + millis2 + " milliseconds, " + secs2 + " seconds.");
        System.out.println("gui startup time: " + millis + " milliseconds, " + secs + " seconds.");
        this.m_timerMillis.reset();
        this.m_timerNanos.reset();
        this.m_timerMillis.start();
        this.m_timerNanos.start();
    }

    private void initComponents() {
        JTextArea infoTextArea = new JTextArea();
        JPanel buttonsPanel = new JPanel();
        JButton windowManagerButton = new JButton();
        JButton outlookToolbarButton = new JButton();
        JButton tableButton = new JButton();
        JButton jsplashButton = new JButton();
        JButton jconsoleButton = new JButton();
        this.jconsoleButton2 = new JButton();
        this.typesafeButton = new JButton();
        this.jmessageButton = new JButton();
        JMenuBar jMenuBar1 = new JMenuBar();
        JMenu jMenu1 = new JMenu();
        JMenuItem abnormalExit = new JMenuItem();
        JMenuItem normalExit = new JMenuItem();
        this.setTitle("Main Test/Demo Application");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                JTester.this.formWindowClosing(evt);
            }
        });
        infoTextArea.setEditable(false);
        infoTextArea.setLineWrap(true);
        infoTextArea.setText("In order to test the SingleAppInstance functionality\ntry to start again this program (JTester).\n\nAlso you can try the \"Abnormal Exit\" from the menu\nand then try to start again this program.\n");
        infoTextArea.setWrapStyleWord(true);
        this.getContentPane().add((Component)infoTextArea, "Center");
        buttonsPanel.setLayout(new FlowLayout(0));
        windowManagerButton.setText("WindowManager");
        windowManagerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTester.this.windowManagerButtonActionPerformed(evt);
            }
        });
        buttonsPanel.add(windowManagerButton);
        outlookToolbarButton.setText("OutLookToolBar");
        outlookToolbarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTester.this.outlookToolbarButtonActionPerformed(evt);
            }
        });
        buttonsPanel.add(outlookToolbarButton);
        tableButton.setText("JTable");
        tableButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTester.this.tableButtonActionPerformed(evt);
            }
        });
        buttonsPanel.add(tableButton);
        jsplashButton.setText("JSplash");
        jsplashButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTester.this.jsplashButtonActionPerformed(evt);
            }
        });
        buttonsPanel.add(jsplashButton);
        jconsoleButton.setText("JConsole");
        jconsoleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTester.this.jconsoleButtonActionPerformed(evt);
            }
        });
        buttonsPanel.add(jconsoleButton);
        this.jconsoleButton2.setText("JConsole2");
        this.jconsoleButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTester.this.jconsoleButton2ActionPerformed(evt);
            }
        });
        buttonsPanel.add(this.jconsoleButton2);
        this.typesafeButton.setText("TypeSafe");
        this.typesafeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTester.this.typesafeButtonActionPerformed(evt);
            }
        });
        buttonsPanel.add(this.typesafeButton);
        this.jmessageButton.setText("JMessage");
        this.jmessageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTester.this.jmessageButtonActionPerformed(evt);
            }
        });
        buttonsPanel.add(this.jmessageButton);
        this.getContentPane().add((Component)buttonsPanel, "South");
        jMenu1.setText("Menu");
        abnormalExit.setText("Abnormal Exit");
        abnormalExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTester.this.abnormalExitActionPerformed(evt);
            }
        });
        jMenu1.add(abnormalExit);
        normalExit.setText("Normal Exit");
        normalExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTester.this.normalExitActionPerformed(evt);
            }
        });
        jMenu1.add(normalExit);
        jMenuBar1.add(jMenu1);
        this.setJMenuBar(jMenuBar1);
        this.pack();
    }

    private void jconsoleButton2ActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "Please use the console_panel.bat to check out the JConsolePane functionality.", "Info", 1);
    }

    private void jmessageButtonActionPerformed(ActionEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JMessageTester t = new JMessageTester();
                t.setVisible(true);
                t.setDefaultCloseOperation(1);
            }
        });
    }

    private void typesafeButtonActionPerformed(ActionEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JTypeSafeTester t = new JTypeSafeTester();
                t.setVisible(true);
                t.setDefaultCloseOperation(1);
            }
        });
    }

    private void normalExitActionPerformed(ActionEvent evt) {
        this.normal_exit();
    }

    private void abnormalExitActionPerformed(ActionEvent evt) {
        this.abnormal_exit();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.normal_exit();
    }

    private void windowManagerButtonActionPerformed(ActionEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JDesktopTester t = new JDesktopTester();
                t.setVisible(true);
                t.setDefaultCloseOperation(1);
            }
        });
    }

    private void outlookToolbarButtonActionPerformed(ActionEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JToolBarTester t = new JToolBarTester();
                t.setVisible(true);
                t.setDefaultCloseOperation(1);
            }
        });
    }

    private void tableButtonActionPerformed(ActionEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JTableTester t = new JTableTester();
                t.setVisible(true);
                t.setDefaultCloseOperation(1);
            }
        });
    }

    private void jsplashButtonActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "Please use the splash.bat to check out the splash screen demo.", "Info", 1);
    }

    private void jconsoleButtonActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "Please use the console.bat to check out the JConsolePane functionality.", "Info", 1);
    }

    private void init_lnf() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.err.println("Cannot initialize the look & feel");
            e.printStackTrace();
        }
    }

    private void abnormal_exit() {
        System.exit(0);
    }

    private void normal_exit() {
        m_inst.onExit();
        long nanos = this.m_timerNanos.elapsedNanos();
        double millis2 = this.m_timerNanos.elapsedMillis();
        double secs2 = this.m_timerNanos.elapsedSeconds();
        long millis = this.m_timerMillis.elapsedMillis();
        double secs = this.m_timerMillis.elapsedSeconds();
        System.out.println("user time: " + nanos + " nanoseconds, " + millis2 + " milliseconds, " + secs2 + " seconds.");
        System.out.println("user time: " + millis + " milliseconds, " + secs + " seconds.");
        System.exit(0);
    }

    public static void main(String[] args) {
        m_inst = SingleAppInstance.getInstance();
        m_inst.onInit();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new JTester().setVisible(true);
            }
        });
    }
}

