---
relatedlinks: https://www.youtube.com/watch?v=pqV0Z1qwbkg
---

% Include content from [../CONTRIBUTING.md](../CONTRIBUTING.md)
```{include} ../CONTRIBUTING.md
    :end-before: <!-- Include end contributing -->
```

## Getting Started Developing

Follow the steps below to set up your development environment to get started working on new features for LXD.

### Building Dependencies

To build the dependencies, follow the instructions in {ref}`installing_from_source`.

### Adding Your Fork Remote

After building your dependencies, you can now add your GitHub fork as a remote:

    git remote add myfork git@github.com:<your_username>/lxd.git
    git remote update

Then switch to it:

<!-- wokeignore:rule=master -->
    git checkout myfork/master

### Building LXD

Finally, you should be able to `make` inside the repository and build your fork of the project.

At this point, you would most likely want to create a new branch for your changes on your fork:

```bash
git checkout -b [name_of_your_new_branch]
git push myfork [name_of_your_new_branch]
```

### Important Notes for New LXD Contributors

- Persistent data is stored in the `LXD_DIR` directory which is generated by `lxd init`. The `LXD_DIR` defaults to `/var/lib/lxd` or `/var/snap/lxd/common/lxd` for snap users.
- As you develop, you may want to change the `LXD_DIR` for your fork of LXD so as to avoid version conflicts.
- Binaries compiled from your source will be generated in the `$(go env GOPATH)/bin` directory by default.
   - You will need to explicitly invoke these binaries (not the global `lxd` you may have installed) when testing your changes.
   - You may choose to create an alias in your `~/.bashrc` to call these binaries with the appropriate flags more conveniently.
- If you have a `systemd` service configured to run the LXD daemon from a previous installation of LXD, you may want to disable it to avoid version conflicts.
