// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/gaming/v1beta/game_server_deployments.proto

package gaming

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for GameServerDeploymentsService.ListGameServerDeployments.
type ListGameServerDeploymentsRequest struct {
	// Required. The parent resource name. Uses the form:
	// `projects/{project}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return.  If unspecified, server
	// will pick an appropriate default. Server may return fewer items than
	// requested. A caller should only rely on response's
	// [next_page_token][google.cloud.gaming.v1beta.ListGameServerDeploymentsResponse.next_page_token] to
	// determine if there are more GameServerDeployments left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous List request,
	// if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The filter to apply to list results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Specifies the ordering of results following syntax at
	// https://cloud.google.com/apis/design/design_patterns#sorting_order.
	OrderBy              string   `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListGameServerDeploymentsRequest) Reset()         { *m = ListGameServerDeploymentsRequest{} }
func (m *ListGameServerDeploymentsRequest) String() string { return proto.CompactTextString(m) }
func (*ListGameServerDeploymentsRequest) ProtoMessage()    {}
func (*ListGameServerDeploymentsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7a002952c0fe6cad, []int{0}
}

func (m *ListGameServerDeploymentsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListGameServerDeploymentsRequest.Unmarshal(m, b)
}
func (m *ListGameServerDeploymentsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListGameServerDeploymentsRequest.Marshal(b, m, deterministic)
}
func (m *ListGameServerDeploymentsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListGameServerDeploymentsRequest.Merge(m, src)
}
func (m *ListGameServerDeploymentsRequest) XXX_Size() int {
	return xxx_messageInfo_ListGameServerDeploymentsRequest.Size(m)
}
func (m *ListGameServerDeploymentsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListGameServerDeploymentsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListGameServerDeploymentsRequest proto.InternalMessageInfo

func (m *ListGameServerDeploymentsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListGameServerDeploymentsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListGameServerDeploymentsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListGameServerDeploymentsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListGameServerDeploymentsRequest) GetOrderBy() string {
	if m != nil {
		return m.OrderBy
	}
	return ""
}

// Response message for GameServerDeploymentsService.ListGameServerDeployments.
type ListGameServerDeploymentsResponse struct {
	// The list of Game Server Delpoyments.
	GameServerDeployments []*GameServerDeployment `protobuf:"bytes,1,rep,name=game_server_deployments,json=gameServerDeployments,proto3" json:"game_server_deployments,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// List of Locations that could not be reached.
	Unreachable          []string `protobuf:"bytes,4,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListGameServerDeploymentsResponse) Reset()         { *m = ListGameServerDeploymentsResponse{} }
func (m *ListGameServerDeploymentsResponse) String() string { return proto.CompactTextString(m) }
func (*ListGameServerDeploymentsResponse) ProtoMessage()    {}
func (*ListGameServerDeploymentsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_7a002952c0fe6cad, []int{1}
}

func (m *ListGameServerDeploymentsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListGameServerDeploymentsResponse.Unmarshal(m, b)
}
func (m *ListGameServerDeploymentsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListGameServerDeploymentsResponse.Marshal(b, m, deterministic)
}
func (m *ListGameServerDeploymentsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListGameServerDeploymentsResponse.Merge(m, src)
}
func (m *ListGameServerDeploymentsResponse) XXX_Size() int {
	return xxx_messageInfo_ListGameServerDeploymentsResponse.Size(m)
}
func (m *ListGameServerDeploymentsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListGameServerDeploymentsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListGameServerDeploymentsResponse proto.InternalMessageInfo

func (m *ListGameServerDeploymentsResponse) GetGameServerDeployments() []*GameServerDeployment {
	if m != nil {
		return m.GameServerDeployments
	}
	return nil
}

func (m *ListGameServerDeploymentsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListGameServerDeploymentsResponse) GetUnreachable() []string {
	if m != nil {
		return m.Unreachable
	}
	return nil
}

// Request message for GameServerDeploymentsService.GetGameServerDeployment.
type GetGameServerDeploymentRequest struct {
	// Required. The name of the Game Server Deployment to retrieve. Uses the form:
	//
	// `projects/{project}/locations/{location}/gameServerDeployments/{deployment}`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetGameServerDeploymentRequest) Reset()         { *m = GetGameServerDeploymentRequest{} }
func (m *GetGameServerDeploymentRequest) String() string { return proto.CompactTextString(m) }
func (*GetGameServerDeploymentRequest) ProtoMessage()    {}
func (*GetGameServerDeploymentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7a002952c0fe6cad, []int{2}
}

func (m *GetGameServerDeploymentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetGameServerDeploymentRequest.Unmarshal(m, b)
}
func (m *GetGameServerDeploymentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetGameServerDeploymentRequest.Marshal(b, m, deterministic)
}
func (m *GetGameServerDeploymentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetGameServerDeploymentRequest.Merge(m, src)
}
func (m *GetGameServerDeploymentRequest) XXX_Size() int {
	return xxx_messageInfo_GetGameServerDeploymentRequest.Size(m)
}
func (m *GetGameServerDeploymentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetGameServerDeploymentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetGameServerDeploymentRequest proto.InternalMessageInfo

func (m *GetGameServerDeploymentRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for
// GameServerDeploymentsService.GetGameServerDeploymentRollout.
type GetGameServerDeploymentRolloutRequest struct {
	// Required. The name of the Game Server Deployment to retrieve. Uses the form:
	//
	// `projects/{project}/locations/{location}/gameServerDeployments/{deployment}/rollout`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetGameServerDeploymentRolloutRequest) Reset()         { *m = GetGameServerDeploymentRolloutRequest{} }
func (m *GetGameServerDeploymentRolloutRequest) String() string { return proto.CompactTextString(m) }
func (*GetGameServerDeploymentRolloutRequest) ProtoMessage()    {}
func (*GetGameServerDeploymentRolloutRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7a002952c0fe6cad, []int{3}
}

func (m *GetGameServerDeploymentRolloutRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetGameServerDeploymentRolloutRequest.Unmarshal(m, b)
}
func (m *GetGameServerDeploymentRolloutRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetGameServerDeploymentRolloutRequest.Marshal(b, m, deterministic)
}
func (m *GetGameServerDeploymentRolloutRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetGameServerDeploymentRolloutRequest.Merge(m, src)
}
func (m *GetGameServerDeploymentRolloutRequest) XXX_Size() int {
	return xxx_messageInfo_GetGameServerDeploymentRolloutRequest.Size(m)
}
func (m *GetGameServerDeploymentRolloutRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetGameServerDeploymentRolloutRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetGameServerDeploymentRolloutRequest proto.InternalMessageInfo

func (m *GetGameServerDeploymentRolloutRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for GameServerDeploymentsService.CreateGameServerDeployment.
type CreateGameServerDeploymentRequest struct {
	// Required. The parent resource name. Uses the form:
	// `projects/{project}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID of the Game Server Deployment resource to be created.
	DeploymentId string `protobuf:"bytes,2,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	// Required. The Game Server Deployment resource to be created.
	GameServerDeployment *GameServerDeployment `protobuf:"bytes,3,opt,name=game_server_deployment,json=gameServerDeployment,proto3" json:"game_server_deployment,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *CreateGameServerDeploymentRequest) Reset()         { *m = CreateGameServerDeploymentRequest{} }
func (m *CreateGameServerDeploymentRequest) String() string { return proto.CompactTextString(m) }
func (*CreateGameServerDeploymentRequest) ProtoMessage()    {}
func (*CreateGameServerDeploymentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7a002952c0fe6cad, []int{4}
}

func (m *CreateGameServerDeploymentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateGameServerDeploymentRequest.Unmarshal(m, b)
}
func (m *CreateGameServerDeploymentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateGameServerDeploymentRequest.Marshal(b, m, deterministic)
}
func (m *CreateGameServerDeploymentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateGameServerDeploymentRequest.Merge(m, src)
}
func (m *CreateGameServerDeploymentRequest) XXX_Size() int {
	return xxx_messageInfo_CreateGameServerDeploymentRequest.Size(m)
}
func (m *CreateGameServerDeploymentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateGameServerDeploymentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateGameServerDeploymentRequest proto.InternalMessageInfo

func (m *CreateGameServerDeploymentRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateGameServerDeploymentRequest) GetDeploymentId() string {
	if m != nil {
		return m.DeploymentId
	}
	return ""
}

func (m *CreateGameServerDeploymentRequest) GetGameServerDeployment() *GameServerDeployment {
	if m != nil {
		return m.GameServerDeployment
	}
	return nil
}

// Request message for GameServerDeploymentsService.DeleteGameServerDeployment.
type DeleteGameServerDeploymentRequest struct {
	// Required. The name of the Game Server Deployment to delete. Uses the form:
	//
	// `projects/{project}/locations/{location}/gameServerDeployments/{deployment}`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteGameServerDeploymentRequest) Reset()         { *m = DeleteGameServerDeploymentRequest{} }
func (m *DeleteGameServerDeploymentRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteGameServerDeploymentRequest) ProtoMessage()    {}
func (*DeleteGameServerDeploymentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7a002952c0fe6cad, []int{5}
}

func (m *DeleteGameServerDeploymentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteGameServerDeploymentRequest.Unmarshal(m, b)
}
func (m *DeleteGameServerDeploymentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteGameServerDeploymentRequest.Marshal(b, m, deterministic)
}
func (m *DeleteGameServerDeploymentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteGameServerDeploymentRequest.Merge(m, src)
}
func (m *DeleteGameServerDeploymentRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteGameServerDeploymentRequest.Size(m)
}
func (m *DeleteGameServerDeploymentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteGameServerDeploymentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteGameServerDeploymentRequest proto.InternalMessageInfo

func (m *DeleteGameServerDeploymentRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for GameServerDeploymentsService.UpdateGameServerDeployment.
// Only allows updates for labels.
type UpdateGameServerDeploymentRequest struct {
	// Required. The Game Server Deployment to be updated.
	// Only fields specified in update_mask are updated.
	GameServerDeployment *GameServerDeployment `protobuf:"bytes,1,opt,name=game_server_deployment,json=gameServerDeployment,proto3" json:"game_server_deployment,omitempty"`
	// Required. Mask of fields to update. At least one path must be supplied in
	// this field. For the `FieldMask` definition, see
	//
	// https:
	// //developers.google.com/protocol-buffers
	// // /docs/reference/google.protobuf#fieldmask
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateGameServerDeploymentRequest) Reset()         { *m = UpdateGameServerDeploymentRequest{} }
func (m *UpdateGameServerDeploymentRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateGameServerDeploymentRequest) ProtoMessage()    {}
func (*UpdateGameServerDeploymentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7a002952c0fe6cad, []int{6}
}

func (m *UpdateGameServerDeploymentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateGameServerDeploymentRequest.Unmarshal(m, b)
}
func (m *UpdateGameServerDeploymentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateGameServerDeploymentRequest.Marshal(b, m, deterministic)
}
func (m *UpdateGameServerDeploymentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateGameServerDeploymentRequest.Merge(m, src)
}
func (m *UpdateGameServerDeploymentRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateGameServerDeploymentRequest.Size(m)
}
func (m *UpdateGameServerDeploymentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateGameServerDeploymentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateGameServerDeploymentRequest proto.InternalMessageInfo

func (m *UpdateGameServerDeploymentRequest) GetGameServerDeployment() *GameServerDeployment {
	if m != nil {
		return m.GameServerDeployment
	}
	return nil
}

func (m *UpdateGameServerDeploymentRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for
// GameServerDeploymentsService.UpdateGameServerRolloutDeployment.
type UpdateGameServerDeploymentRolloutRequest struct {
	// Required. The Game Server Deployment Rollout to be updated.
	// Only fields specified in update_mask are updated.
	Rollout *GameServerDeploymentRollout `protobuf:"bytes,1,opt,name=rollout,proto3" json:"rollout,omitempty"`
	// Required. Mask of fields to update. At least one path must be supplied in
	// this field. For the `FieldMask` definition, see
	//
	// https:
	// //developers.google.com/protocol-buffers
	// // /docs/reference/google.protobuf#fieldmask
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateGameServerDeploymentRolloutRequest) Reset() {
	*m = UpdateGameServerDeploymentRolloutRequest{}
}
func (m *UpdateGameServerDeploymentRolloutRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateGameServerDeploymentRolloutRequest) ProtoMessage()    {}
func (*UpdateGameServerDeploymentRolloutRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7a002952c0fe6cad, []int{7}
}

func (m *UpdateGameServerDeploymentRolloutRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateGameServerDeploymentRolloutRequest.Unmarshal(m, b)
}
func (m *UpdateGameServerDeploymentRolloutRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateGameServerDeploymentRolloutRequest.Marshal(b, m, deterministic)
}
func (m *UpdateGameServerDeploymentRolloutRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateGameServerDeploymentRolloutRequest.Merge(m, src)
}
func (m *UpdateGameServerDeploymentRolloutRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateGameServerDeploymentRolloutRequest.Size(m)
}
func (m *UpdateGameServerDeploymentRolloutRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateGameServerDeploymentRolloutRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateGameServerDeploymentRolloutRequest proto.InternalMessageInfo

func (m *UpdateGameServerDeploymentRolloutRequest) GetRollout() *GameServerDeploymentRollout {
	if m != nil {
		return m.Rollout
	}
	return nil
}

func (m *UpdateGameServerDeploymentRolloutRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for GameServerDeploymentsService.FetchDeploymentState.
type FetchDeploymentStateRequest struct {
	// Required. The name of the Game Server Deployment. Uses the form:
	//
	// `projects/{project}/locations/{location}/gameServerDeployments/{deployment}`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FetchDeploymentStateRequest) Reset()         { *m = FetchDeploymentStateRequest{} }
func (m *FetchDeploymentStateRequest) String() string { return proto.CompactTextString(m) }
func (*FetchDeploymentStateRequest) ProtoMessage()    {}
func (*FetchDeploymentStateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7a002952c0fe6cad, []int{8}
}

func (m *FetchDeploymentStateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FetchDeploymentStateRequest.Unmarshal(m, b)
}
func (m *FetchDeploymentStateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FetchDeploymentStateRequest.Marshal(b, m, deterministic)
}
func (m *FetchDeploymentStateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FetchDeploymentStateRequest.Merge(m, src)
}
func (m *FetchDeploymentStateRequest) XXX_Size() int {
	return xxx_messageInfo_FetchDeploymentStateRequest.Size(m)
}
func (m *FetchDeploymentStateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_FetchDeploymentStateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_FetchDeploymentStateRequest proto.InternalMessageInfo

func (m *FetchDeploymentStateRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Response message for GameServerDeploymentsService.FetchDeploymentState.
type FetchDeploymentStateResponse struct {
	// The state of the Game Server Deployment in each Game Server Cluster.
	ClusterState []*FetchDeploymentStateResponse_DeployedClusterState `protobuf:"bytes,1,rep,name=cluster_state,json=clusterState,proto3" json:"cluster_state,omitempty"`
	// List of Locations that could not be reached.
	Unavailable          []string `protobuf:"bytes,2,rep,name=unavailable,proto3" json:"unavailable,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FetchDeploymentStateResponse) Reset()         { *m = FetchDeploymentStateResponse{} }
func (m *FetchDeploymentStateResponse) String() string { return proto.CompactTextString(m) }
func (*FetchDeploymentStateResponse) ProtoMessage()    {}
func (*FetchDeploymentStateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_7a002952c0fe6cad, []int{9}
}

func (m *FetchDeploymentStateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FetchDeploymentStateResponse.Unmarshal(m, b)
}
func (m *FetchDeploymentStateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FetchDeploymentStateResponse.Marshal(b, m, deterministic)
}
func (m *FetchDeploymentStateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FetchDeploymentStateResponse.Merge(m, src)
}
func (m *FetchDeploymentStateResponse) XXX_Size() int {
	return xxx_messageInfo_FetchDeploymentStateResponse.Size(m)
}
func (m *FetchDeploymentStateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_FetchDeploymentStateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_FetchDeploymentStateResponse proto.InternalMessageInfo

func (m *FetchDeploymentStateResponse) GetClusterState() []*FetchDeploymentStateResponse_DeployedClusterState {
	if m != nil {
		return m.ClusterState
	}
	return nil
}

func (m *FetchDeploymentStateResponse) GetUnavailable() []string {
	if m != nil {
		return m.Unavailable
	}
	return nil
}

// The Game Server Cluster changes made by the Game Server Deployment.
type FetchDeploymentStateResponse_DeployedClusterState struct {
	// The name of the cluster.
	Cluster string `protobuf:"bytes,1,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// The details about the Agones fleets and autoscalers created in the
	// Game Server Cluster.
	FleetDetails         []*DeployedFleetDetails `protobuf:"bytes,2,rep,name=fleet_details,json=fleetDetails,proto3" json:"fleet_details,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *FetchDeploymentStateResponse_DeployedClusterState) Reset() {
	*m = FetchDeploymentStateResponse_DeployedClusterState{}
}
func (m *FetchDeploymentStateResponse_DeployedClusterState) String() string {
	return proto.CompactTextString(m)
}
func (*FetchDeploymentStateResponse_DeployedClusterState) ProtoMessage() {}
func (*FetchDeploymentStateResponse_DeployedClusterState) Descriptor() ([]byte, []int) {
	return fileDescriptor_7a002952c0fe6cad, []int{9, 0}
}

func (m *FetchDeploymentStateResponse_DeployedClusterState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FetchDeploymentStateResponse_DeployedClusterState.Unmarshal(m, b)
}
func (m *FetchDeploymentStateResponse_DeployedClusterState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FetchDeploymentStateResponse_DeployedClusterState.Marshal(b, m, deterministic)
}
func (m *FetchDeploymentStateResponse_DeployedClusterState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FetchDeploymentStateResponse_DeployedClusterState.Merge(m, src)
}
func (m *FetchDeploymentStateResponse_DeployedClusterState) XXX_Size() int {
	return xxx_messageInfo_FetchDeploymentStateResponse_DeployedClusterState.Size(m)
}
func (m *FetchDeploymentStateResponse_DeployedClusterState) XXX_DiscardUnknown() {
	xxx_messageInfo_FetchDeploymentStateResponse_DeployedClusterState.DiscardUnknown(m)
}

var xxx_messageInfo_FetchDeploymentStateResponse_DeployedClusterState proto.InternalMessageInfo

func (m *FetchDeploymentStateResponse_DeployedClusterState) GetCluster() string {
	if m != nil {
		return m.Cluster
	}
	return ""
}

func (m *FetchDeploymentStateResponse_DeployedClusterState) GetFleetDetails() []*DeployedFleetDetails {
	if m != nil {
		return m.FleetDetails
	}
	return nil
}

// A Game Server Deployment resource.
type GameServerDeployment struct {
	// The resource name of the Game Server Deployment. Uses the form:
	//
	// `projects/{project}/locations/{location}/gameServerDeployments/{deployment}`.
	// For example,
	//
	// `projects/my-project/locations/{location}/gameServerDeployments/my-deployment`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The creation time.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last-modified time.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The labels associated with this Game Server Deployment. Each label is a
	// key-value pair.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// ETag of the resource.
	Etag string `protobuf:"bytes,7,opt,name=etag,proto3" json:"etag,omitempty"`
	// Human readable description of the Game Server Deployment.
	Description          string   `protobuf:"bytes,8,opt,name=description,proto3" json:"description,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GameServerDeployment) Reset()         { *m = GameServerDeployment{} }
func (m *GameServerDeployment) String() string { return proto.CompactTextString(m) }
func (*GameServerDeployment) ProtoMessage()    {}
func (*GameServerDeployment) Descriptor() ([]byte, []int) {
	return fileDescriptor_7a002952c0fe6cad, []int{10}
}

func (m *GameServerDeployment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GameServerDeployment.Unmarshal(m, b)
}
func (m *GameServerDeployment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GameServerDeployment.Marshal(b, m, deterministic)
}
func (m *GameServerDeployment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GameServerDeployment.Merge(m, src)
}
func (m *GameServerDeployment) XXX_Size() int {
	return xxx_messageInfo_GameServerDeployment.Size(m)
}
func (m *GameServerDeployment) XXX_DiscardUnknown() {
	xxx_messageInfo_GameServerDeployment.DiscardUnknown(m)
}

var xxx_messageInfo_GameServerDeployment proto.InternalMessageInfo

func (m *GameServerDeployment) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GameServerDeployment) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *GameServerDeployment) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *GameServerDeployment) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *GameServerDeployment) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

func (m *GameServerDeployment) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

// A Game Server Config override.
type GameServerConfigOverride struct {
	// Selector chooses the Game Server Config targets.
	//
	// Types that are valid to be assigned to Selector:
	//	*GameServerConfigOverride_RealmsSelector
	Selector isGameServerConfigOverride_Selector `protobuf_oneof:"selector"`
	// Selects the Game Server Config and how it should be applied.
	//
	// Types that are valid to be assigned to Change:
	//	*GameServerConfigOverride_ConfigVersion
	Change               isGameServerConfigOverride_Change `protobuf_oneof:"change"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *GameServerConfigOverride) Reset()         { *m = GameServerConfigOverride{} }
func (m *GameServerConfigOverride) String() string { return proto.CompactTextString(m) }
func (*GameServerConfigOverride) ProtoMessage()    {}
func (*GameServerConfigOverride) Descriptor() ([]byte, []int) {
	return fileDescriptor_7a002952c0fe6cad, []int{11}
}

func (m *GameServerConfigOverride) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GameServerConfigOverride.Unmarshal(m, b)
}
func (m *GameServerConfigOverride) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GameServerConfigOverride.Marshal(b, m, deterministic)
}
func (m *GameServerConfigOverride) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GameServerConfigOverride.Merge(m, src)
}
func (m *GameServerConfigOverride) XXX_Size() int {
	return xxx_messageInfo_GameServerConfigOverride.Size(m)
}
func (m *GameServerConfigOverride) XXX_DiscardUnknown() {
	xxx_messageInfo_GameServerConfigOverride.DiscardUnknown(m)
}

var xxx_messageInfo_GameServerConfigOverride proto.InternalMessageInfo

type isGameServerConfigOverride_Selector interface {
	isGameServerConfigOverride_Selector()
}

type GameServerConfigOverride_RealmsSelector struct {
	RealmsSelector *RealmSelector `protobuf:"bytes,1,opt,name=realms_selector,json=realmsSelector,proto3,oneof"`
}

func (*GameServerConfigOverride_RealmsSelector) isGameServerConfigOverride_Selector() {}

func (m *GameServerConfigOverride) GetSelector() isGameServerConfigOverride_Selector {
	if m != nil {
		return m.Selector
	}
	return nil
}

func (m *GameServerConfigOverride) GetRealmsSelector() *RealmSelector {
	if x, ok := m.GetSelector().(*GameServerConfigOverride_RealmsSelector); ok {
		return x.RealmsSelector
	}
	return nil
}

type isGameServerConfigOverride_Change interface {
	isGameServerConfigOverride_Change()
}

type GameServerConfigOverride_ConfigVersion struct {
	ConfigVersion string `protobuf:"bytes,100,opt,name=config_version,json=configVersion,proto3,oneof"`
}

func (*GameServerConfigOverride_ConfigVersion) isGameServerConfigOverride_Change() {}

func (m *GameServerConfigOverride) GetChange() isGameServerConfigOverride_Change {
	if m != nil {
		return m.Change
	}
	return nil
}

func (m *GameServerConfigOverride) GetConfigVersion() string {
	if x, ok := m.GetChange().(*GameServerConfigOverride_ConfigVersion); ok {
		return x.ConfigVersion
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*GameServerConfigOverride) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*GameServerConfigOverride_RealmsSelector)(nil),
		(*GameServerConfigOverride_ConfigVersion)(nil),
	}
}

// The Game Server Deployment Rollout which represents the desired rollout
// state.
type GameServerDeploymentRollout struct {
	// The resource name of the Game Server Deployment Rollout. Uses the form:
	//
	// `projects/{project}/locations/{location}/gameServerDeployments/{deployment}/rollout`.
	// For example,
	//
	// `projects/my-project/locations/{location}/gameServerDeployments/my-deployment/rollout`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The creation time.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last-modified time.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The default Game Server Config is applied to all Realms unless overridden
	// in the Rollout. For example,
	//
	// `projects/my-project/locations/global/gameServerDeployments/my-game/configs/my-config`.
	DefaultGameServerConfig string `protobuf:"bytes,4,opt,name=default_game_server_config,json=defaultGameServerConfig,proto3" json:"default_game_server_config,omitempty"`
	// Contains the Game Server Config Rollout overrides. Overrides are processed
	// in the order they are listed. Once a match is found for a Realm, the rest
	// of the list is not processed.
	GameServerConfigOverrides []*GameServerConfigOverride `protobuf:"bytes,5,rep,name=game_server_config_overrides,json=gameServerConfigOverrides,proto3" json:"game_server_config_overrides,omitempty"`
	// ETag of the resource.
	Etag                 string   `protobuf:"bytes,6,opt,name=etag,proto3" json:"etag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GameServerDeploymentRollout) Reset()         { *m = GameServerDeploymentRollout{} }
func (m *GameServerDeploymentRollout) String() string { return proto.CompactTextString(m) }
func (*GameServerDeploymentRollout) ProtoMessage()    {}
func (*GameServerDeploymentRollout) Descriptor() ([]byte, []int) {
	return fileDescriptor_7a002952c0fe6cad, []int{12}
}

func (m *GameServerDeploymentRollout) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GameServerDeploymentRollout.Unmarshal(m, b)
}
func (m *GameServerDeploymentRollout) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GameServerDeploymentRollout.Marshal(b, m, deterministic)
}
func (m *GameServerDeploymentRollout) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GameServerDeploymentRollout.Merge(m, src)
}
func (m *GameServerDeploymentRollout) XXX_Size() int {
	return xxx_messageInfo_GameServerDeploymentRollout.Size(m)
}
func (m *GameServerDeploymentRollout) XXX_DiscardUnknown() {
	xxx_messageInfo_GameServerDeploymentRollout.DiscardUnknown(m)
}

var xxx_messageInfo_GameServerDeploymentRollout proto.InternalMessageInfo

func (m *GameServerDeploymentRollout) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GameServerDeploymentRollout) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *GameServerDeploymentRollout) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *GameServerDeploymentRollout) GetDefaultGameServerConfig() string {
	if m != nil {
		return m.DefaultGameServerConfig
	}
	return ""
}

func (m *GameServerDeploymentRollout) GetGameServerConfigOverrides() []*GameServerConfigOverride {
	if m != nil {
		return m.GameServerConfigOverrides
	}
	return nil
}

func (m *GameServerDeploymentRollout) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

// Request message for PreviewGameServerDeploymentRollout.
type PreviewGameServerDeploymentRolloutRequest struct {
	// Required. The Game Server Deployment Rollout to be updated.
	// Only fields specified in update_mask are updated.
	Rollout *GameServerDeploymentRollout `protobuf:"bytes,1,opt,name=rollout,proto3" json:"rollout,omitempty"`
	// Optional. Mask of fields to update. At least one path must be supplied in
	// this field. For the `FieldMask` definition, see
	//
	// https:
	// //developers.google.com/protocol-buffers
	// // /docs/reference/google.protobuf#fieldmask
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional. The target timestamp to compute the preview. Defaults to the immediately
	// after the proposed Rollout completes.
	PreviewTime          *timestamp.Timestamp `protobuf:"bytes,3,opt,name=preview_time,json=previewTime,proto3" json:"preview_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *PreviewGameServerDeploymentRolloutRequest) Reset() {
	*m = PreviewGameServerDeploymentRolloutRequest{}
}
func (m *PreviewGameServerDeploymentRolloutRequest) String() string { return proto.CompactTextString(m) }
func (*PreviewGameServerDeploymentRolloutRequest) ProtoMessage()    {}
func (*PreviewGameServerDeploymentRolloutRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7a002952c0fe6cad, []int{13}
}

func (m *PreviewGameServerDeploymentRolloutRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PreviewGameServerDeploymentRolloutRequest.Unmarshal(m, b)
}
func (m *PreviewGameServerDeploymentRolloutRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PreviewGameServerDeploymentRolloutRequest.Marshal(b, m, deterministic)
}
func (m *PreviewGameServerDeploymentRolloutRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PreviewGameServerDeploymentRolloutRequest.Merge(m, src)
}
func (m *PreviewGameServerDeploymentRolloutRequest) XXX_Size() int {
	return xxx_messageInfo_PreviewGameServerDeploymentRolloutRequest.Size(m)
}
func (m *PreviewGameServerDeploymentRolloutRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PreviewGameServerDeploymentRolloutRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PreviewGameServerDeploymentRolloutRequest proto.InternalMessageInfo

func (m *PreviewGameServerDeploymentRolloutRequest) GetRollout() *GameServerDeploymentRollout {
	if m != nil {
		return m.Rollout
	}
	return nil
}

func (m *PreviewGameServerDeploymentRolloutRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *PreviewGameServerDeploymentRolloutRequest) GetPreviewTime() *timestamp.Timestamp {
	if m != nil {
		return m.PreviewTime
	}
	return nil
}

// Response message for PreviewGameServerDeploymentRollout.
// This has details about the Agones fleet and autoscaler to be actuated.
type PreviewGameServerDeploymentRolloutResponse struct {
	// Locations that could not be reached on this request.
	Unavailable []string `protobuf:"bytes,2,rep,name=unavailable,proto3" json:"unavailable,omitempty"`
	// ETag of the Game Server Deployment.
	Etag string `protobuf:"bytes,3,opt,name=etag,proto3" json:"etag,omitempty"`
	// The target state.
	TargetState          *TargetState `protobuf:"bytes,4,opt,name=target_state,json=targetState,proto3" json:"target_state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *PreviewGameServerDeploymentRolloutResponse) Reset() {
	*m = PreviewGameServerDeploymentRolloutResponse{}
}
func (m *PreviewGameServerDeploymentRolloutResponse) String() string {
	return proto.CompactTextString(m)
}
func (*PreviewGameServerDeploymentRolloutResponse) ProtoMessage() {}
func (*PreviewGameServerDeploymentRolloutResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_7a002952c0fe6cad, []int{14}
}

func (m *PreviewGameServerDeploymentRolloutResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PreviewGameServerDeploymentRolloutResponse.Unmarshal(m, b)
}
func (m *PreviewGameServerDeploymentRolloutResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PreviewGameServerDeploymentRolloutResponse.Marshal(b, m, deterministic)
}
func (m *PreviewGameServerDeploymentRolloutResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PreviewGameServerDeploymentRolloutResponse.Merge(m, src)
}
func (m *PreviewGameServerDeploymentRolloutResponse) XXX_Size() int {
	return xxx_messageInfo_PreviewGameServerDeploymentRolloutResponse.Size(m)
}
func (m *PreviewGameServerDeploymentRolloutResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PreviewGameServerDeploymentRolloutResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PreviewGameServerDeploymentRolloutResponse proto.InternalMessageInfo

func (m *PreviewGameServerDeploymentRolloutResponse) GetUnavailable() []string {
	if m != nil {
		return m.Unavailable
	}
	return nil
}

func (m *PreviewGameServerDeploymentRolloutResponse) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

func (m *PreviewGameServerDeploymentRolloutResponse) GetTargetState() *TargetState {
	if m != nil {
		return m.TargetState
	}
	return nil
}

func init() {
	proto.RegisterType((*ListGameServerDeploymentsRequest)(nil), "google.cloud.gaming.v1beta.ListGameServerDeploymentsRequest")
	proto.RegisterType((*ListGameServerDeploymentsResponse)(nil), "google.cloud.gaming.v1beta.ListGameServerDeploymentsResponse")
	proto.RegisterType((*GetGameServerDeploymentRequest)(nil), "google.cloud.gaming.v1beta.GetGameServerDeploymentRequest")
	proto.RegisterType((*GetGameServerDeploymentRolloutRequest)(nil), "google.cloud.gaming.v1beta.GetGameServerDeploymentRolloutRequest")
	proto.RegisterType((*CreateGameServerDeploymentRequest)(nil), "google.cloud.gaming.v1beta.CreateGameServerDeploymentRequest")
	proto.RegisterType((*DeleteGameServerDeploymentRequest)(nil), "google.cloud.gaming.v1beta.DeleteGameServerDeploymentRequest")
	proto.RegisterType((*UpdateGameServerDeploymentRequest)(nil), "google.cloud.gaming.v1beta.UpdateGameServerDeploymentRequest")
	proto.RegisterType((*UpdateGameServerDeploymentRolloutRequest)(nil), "google.cloud.gaming.v1beta.UpdateGameServerDeploymentRolloutRequest")
	proto.RegisterType((*FetchDeploymentStateRequest)(nil), "google.cloud.gaming.v1beta.FetchDeploymentStateRequest")
	proto.RegisterType((*FetchDeploymentStateResponse)(nil), "google.cloud.gaming.v1beta.FetchDeploymentStateResponse")
	proto.RegisterType((*FetchDeploymentStateResponse_DeployedClusterState)(nil), "google.cloud.gaming.v1beta.FetchDeploymentStateResponse.DeployedClusterState")
	proto.RegisterType((*GameServerDeployment)(nil), "google.cloud.gaming.v1beta.GameServerDeployment")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.gaming.v1beta.GameServerDeployment.LabelsEntry")
	proto.RegisterType((*GameServerConfigOverride)(nil), "google.cloud.gaming.v1beta.GameServerConfigOverride")
	proto.RegisterType((*GameServerDeploymentRollout)(nil), "google.cloud.gaming.v1beta.GameServerDeploymentRollout")
	proto.RegisterType((*PreviewGameServerDeploymentRolloutRequest)(nil), "google.cloud.gaming.v1beta.PreviewGameServerDeploymentRolloutRequest")
	proto.RegisterType((*PreviewGameServerDeploymentRolloutResponse)(nil), "google.cloud.gaming.v1beta.PreviewGameServerDeploymentRolloutResponse")
}

func init() {
	proto.RegisterFile("google/cloud/gaming/v1beta/game_server_deployments.proto", fileDescriptor_7a002952c0fe6cad)
}

var fileDescriptor_7a002952c0fe6cad = []byte{
	// 1171 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x57, 0xcf, 0x6e, 0xdc, 0xd4,
	0x17, 0xfe, 0x79, 0x26, 0x7f, 0xcf, 0x24, 0xed, 0x4f, 0x56, 0xa0, 0xee, 0xb4, 0x6a, 0x27, 0x96,
	0xa0, 0x29, 0x0b, 0xbb, 0x04, 0x44, 0x4b, 0xcb, 0xa2, 0x99, 0x96, 0xb6, 0x54, 0xad, 0x88, 0x9c,
	0xb4, 0x0b, 0x36, 0xd6, 0x1d, 0xfb, 0x8c, 0x63, 0x62, 0xfb, 0xba, 0xd7, 0xd7, 0x03, 0x69, 0x55,
	0x24, 0x56, 0x08, 0x09, 0x16, 0x7d, 0x11, 0x78, 0x03, 0x56, 0x3c, 0x01, 0x1b, 0xb6, 0x5d, 0xf7,
	0x05, 0x10, 0xac, 0xd0, 0xfd, 0xe3, 0xda, 0x29, 0x33, 0xd3, 0x0c, 0x0a, 0x12, 0xec, 0x7c, 0xcf,
	0x3d, 0xdf, 0x39, 0x3e, 0xdf, 0xf9, 0x7c, 0xce, 0x0c, 0x5c, 0x89, 0x28, 0x8d, 0x12, 0x74, 0x83,
	0x84, 0x96, 0xa1, 0x1b, 0x91, 0x34, 0xce, 0x22, 0x77, 0xf4, 0xee, 0x00, 0x39, 0x11, 0x27, 0xf4,
	0x0b, 0x64, 0x23, 0x64, 0x7e, 0x88, 0x79, 0x42, 0x0f, 0x52, 0xcc, 0x78, 0xe1, 0xe4, 0x8c, 0x72,
	0x6a, 0x76, 0x15, 0xd2, 0x91, 0x48, 0x47, 0x21, 0x1d, 0x85, 0xec, 0x9e, 0xd7, 0x51, 0x49, 0x1e,
	0xbb, 0xc3, 0x18, 0x93, 0xd0, 0x1f, 0xe0, 0x1e, 0x19, 0xc5, 0x94, 0x29, 0x70, 0xf7, 0x74, 0xc3,
	0x81, 0x61, 0x41, 0x4b, 0x16, 0xa0, 0xbe, 0xba, 0x30, 0xe5, 0x8d, 0x02, 0x9a, 0xa6, 0x34, 0xd3,
	0x8e, 0x3d, 0xed, 0x28, 0x4f, 0x83, 0x72, 0xa8, 0x33, 0xa5, 0xa4, 0xd8, 0xd7, 0x1e, 0xe7, 0x5f,
	0xf5, 0xe0, 0x71, 0x8a, 0x05, 0x27, 0x69, 0xae, 0x1d, 0xce, 0x36, 0x5e, 0x83, 0x64, 0x19, 0xe5,
	0x84, 0xc7, 0x34, 0xd3, 0x15, 0xda, 0xbf, 0x19, 0xd0, 0xbb, 0x17, 0x17, 0xfc, 0x36, 0x49, 0x71,
	0x47, 0xd2, 0x70, 0xb3, 0x66, 0xc1, 0xc3, 0x47, 0x25, 0x16, 0xdc, 0xdc, 0x86, 0x85, 0x9c, 0x30,
	0xcc, 0xb8, 0x65, 0xf4, 0x8c, 0x8d, 0xe5, 0xfe, 0x95, 0xe7, 0x5b, 0xad, 0x3f, 0xb6, 0x36, 0xcd,
	0x4b, 0x82, 0x3d, 0x41, 0x5e, 0x1c, 0x60, 0xe1, 0xa8, 0x3c, 0x24, 0x8f, 0x0b, 0x27, 0xa0, 0xa9,
	0x3b, 0x2e, 0xa2, 0xa7, 0xe3, 0x98, 0x3d, 0x58, 0xce, 0x49, 0x84, 0x7e, 0x11, 0x3f, 0x46, 0xab,
	0xd5, 0x33, 0x36, 0xe6, 0xfb, 0xed, 0xe7, 0x5b, 0x86, 0xb7, 0x24, 0xac, 0x3b, 0xf1, 0x63, 0x34,
	0x6d, 0x00, 0xe9, 0xc1, 0xe9, 0x3e, 0x66, 0x56, 0x5b, 0xe6, 0x95, 0x2e, 0x12, 0xb8, 0x2b, 0xac,
	0xe6, 0x19, 0x58, 0x18, 0xc6, 0x09, 0x47, 0x66, 0xcd, 0xd5, 0xf7, 0xda, 0x64, 0x9e, 0x83, 0x25,
	0xca, 0x42, 0x64, 0xfe, 0xe0, 0xc0, 0x9a, 0xaf, 0xaf, 0x17, 0xa5, 0xb1, 0x7f, 0x60, 0xff, 0x6a,
	0xc0, 0xfa, 0x94, 0xca, 0x8b, 0x9c, 0x66, 0x05, 0x9a, 0x7b, 0x70, 0x6a, 0x82, 0x44, 0x2c, 0xa3,
	0xd7, 0xde, 0xe8, 0x6c, 0x5e, 0x72, 0x26, 0x6b, 0xc4, 0x19, 0xcb, 0xc1, 0x1b, 0xd1, 0xb8, 0x8c,
	0xe6, 0xdb, 0x70, 0x32, 0xc3, 0x2f, 0xb9, 0xdf, 0xa8, 0x5a, 0x10, 0xb3, 0xec, 0xad, 0x0a, 0xf3,
	0xf6, 0xcb, 0xa2, 0x7b, 0xd0, 0x29, 0x33, 0x86, 0x24, 0xd8, 0x23, 0x83, 0x04, 0xad, 0xb9, 0x5e,
	0x7b, 0x63, 0xd9, 0x6b, 0x9a, 0xec, 0x0c, 0xce, 0xdd, 0xc6, 0xb1, 0x75, 0x55, 0x0d, 0xbd, 0x07,
	0x73, 0x19, 0x49, 0xf1, 0x70, 0x3b, 0x61, 0xf6, 0x76, 0xca, 0x28, 0x76, 0x09, 0x6f, 0x4d, 0xca,
	0x47, 0x93, 0x84, 0x96, 0xff, 0x50, 0xda, 0xef, 0x5a, 0xb0, 0x7e, 0x83, 0x21, 0xe1, 0x38, 0xad,
	0xd4, 0xe3, 0xd7, 0xee, 0x06, 0xac, 0xd6, 0x32, 0xf0, 0xe3, 0x50, 0xb5, 0x49, 0xa8, 0xab, 0xe5,
	0xad, 0xd4, 0x37, 0x9f, 0x84, 0xe6, 0x3e, 0xbc, 0x39, 0x5e, 0x3c, 0x52, 0xcf, 0x7f, 0x43, 0x3b,
	0x2a, 0xc9, 0xda, 0x38, 0x01, 0xd9, 0x8f, 0x60, 0xfd, 0x26, 0x26, 0x38, 0x9d, 0x8d, 0xe3, 0xed,
	0xc0, 0x2f, 0x06, 0xac, 0x3f, 0xc8, 0xc3, 0xd7, 0x74, 0x60, 0x32, 0x0b, 0xc6, 0xb1, 0xb3, 0x60,
	0x5e, 0x87, 0x4e, 0x29, 0xdf, 0x48, 0xce, 0x48, 0xd9, 0x9a, 0xce, 0x66, 0xb7, 0xca, 0x50, 0x0d,
	0x49, 0xe7, 0x96, 0x18, 0xa3, 0xf7, 0x49, 0xb1, 0xaf, 0x62, 0x81, 0xc2, 0x08, 0x83, 0xfd, 0xb3,
	0x01, 0x1b, 0x53, 0x8a, 0x3a, 0xac, 0xe8, 0x87, 0xb0, 0xc8, 0x94, 0x45, 0x17, 0x73, 0x79, 0xe6,
	0x71, 0xa0, 0xe0, 0xea, 0x3d, 0xaa, 0x60, 0xc7, 0x50, 0xc6, 0x07, 0x70, 0xe6, 0x16, 0xf2, 0x60,
	0xaf, 0xce, 0xb4, 0xc3, 0x09, 0xc7, 0xea, 0xc5, 0x4f, 0x1d, 0x12, 0x82, 0x44, 0xab, 0x9e, 0xfe,
	0xd4, 0x82, 0xb3, 0xe3, 0x81, 0x7a, 0x22, 0x32, 0x58, 0x0d, 0x92, 0xb2, 0xe0, 0xc8, 0xfc, 0x42,
	0x5c, 0xe8, 0x39, 0x78, 0x7f, 0x5a, 0xe1, 0xd3, 0x02, 0x3a, 0xca, 0x8e, 0xe1, 0x0d, 0x15, 0x55,
	0x5d, 0xae, 0x04, 0x8d, 0x93, 0x9a, 0x79, 0x64, 0x44, 0xe2, 0x44, 0xce, 0xbc, 0x56, 0x35, 0xf3,
	0x5e, 0x9a, 0xba, 0xdf, 0x18, 0xb0, 0x36, 0x2e, 0x90, 0x69, 0xc1, 0xa2, 0x0e, 0xa5, 0x6a, 0xf5,
	0xaa, 0xa3, 0xf9, 0x00, 0x56, 0x87, 0x09, 0x22, 0xf7, 0x43, 0xe4, 0x24, 0x4e, 0x0a, 0x19, 0xf6,
	0x35, 0x72, 0xac, 0x52, 0xdc, 0x12, 0xc0, 0x9b, 0x0a, 0xe7, 0xad, 0x0c, 0x1b, 0x27, 0xfb, 0xf7,
	0x36, 0xac, 0x8d, 0x6b, 0xb4, 0x69, 0x36, 0x29, 0x57, 0x6c, 0x8b, 0x3e, 0x07, 0x72, 0x84, 0xf9,
	0x62, 0x6d, 0x4f, 0xec, 0xf3, 0x6e, 0xb5, 0xd3, 0x45, 0xa7, 0xda, 0x1e, 0x28, 0x8c, 0xb0, 0x36,
	0x94, 0x22, 0x23, 0xb4, 0x8f, 0x18, 0x41, 0x61, 0x64, 0x84, 0x5d, 0x58, 0x48, 0xc8, 0x00, 0x93,
	0x42, 0xee, 0x92, 0xce, 0xe6, 0x47, 0xb3, 0x4a, 0xd8, 0xb9, 0x27, 0xe1, 0x1f, 0x67, 0x9c, 0x1d,
	0x78, 0x3a, 0x96, 0xa8, 0x16, 0x39, 0x89, 0xac, 0x45, 0x55, 0xad, 0x78, 0x16, 0x6d, 0x0c, 0xb1,
	0x08, 0x58, 0x9c, 0x8b, 0x9f, 0x20, 0xd6, 0x92, 0xbc, 0x6a, 0x9a, 0xba, 0x1f, 0x42, 0xa7, 0x11,
	0xcc, 0xfc, 0x3f, 0xb4, 0xf7, 0xf1, 0x40, 0x33, 0x26, 0x1e, 0xcd, 0x35, 0x98, 0x1f, 0x91, 0xa4,
	0x44, 0xbd, 0x1b, 0xd5, 0xe1, 0x6a, 0xeb, 0x8a, 0x71, 0xf5, 0x6b, 0xe3, 0xc5, 0xd6, 0x57, 0xb3,
	0x8f, 0x32, 0xf3, 0x6e, 0xce, 0xe8, 0xe7, 0x18, 0xf0, 0xc2, 0x7d, 0xa2, 0x9f, 0x9e, 0xba, 0x09,
	0x0d, 0xd4, 0xaf, 0x24, 0xf7, 0x49, 0xf5, 0xf8, 0xd4, 0x1d, 0xbb, 0xb6, 0xdd, 0x27, 0xf5, 0x3c,
	0x7b, 0x6a, 0xff, 0x68, 0x80, 0x55, 0x27, 0xb9, 0x41, 0xb3, 0x61, 0x1c, 0x7d, 0x3a, 0x42, 0xc6,
	0xe2, 0x50, 0xf0, 0x7c, 0x92, 0x21, 0x49, 0xd2, 0xc2, 0x2f, 0x30, 0xc1, 0x80, 0x53, 0xa6, 0x67,
	0xc6, 0xc5, 0x69, 0x84, 0x7b, 0x02, 0xb2, 0xa3, 0x01, 0x77, 0xfe, 0xe7, 0x9d, 0x50, 0x31, 0x2a,
	0x8b, 0x79, 0x01, 0x4e, 0x04, 0x32, 0x8f, 0x3f, 0x42, 0x56, 0x08, 0x5a, 0x43, 0xc1, 0xcc, 0x1d,
	0xc3, 0x5b, 0x55, 0xf6, 0x87, 0xca, 0xdc, 0x07, 0x58, 0xaa, 0xf2, 0xf6, 0x97, 0x60, 0x21, 0xd8,
	0x23, 0x59, 0x84, 0xf6, 0xb3, 0x39, 0x38, 0x33, 0x65, 0x2c, 0xfd, 0x6b, 0x45, 0x7b, 0x0d, 0xba,
	0x21, 0x0e, 0x49, 0x99, 0x70, 0xbf, 0xb9, 0x5c, 0x54, 0xc9, 0xea, 0xe7, 0xa0, 0x77, 0x4a, 0x7b,
	0xbc, 0xda, 0x11, 0xb3, 0x84, 0xb3, 0x7f, 0x05, 0xf9, 0x54, 0x37, 0xaa, 0xb0, 0xe6, 0xe5, 0x77,
	0xf0, 0xfe, 0xd1, 0xbe, 0x83, 0xc3, 0x5d, 0xf6, 0x4e, 0x47, 0x13, 0x6e, 0xea, 0x4f, 0x62, 0xa1,
	0xfe, 0x24, 0xae, 0x3e, 0x33, 0x5e, 0x6c, 0x7d, 0x6f, 0xc0, 0xe5, 0x99, 0x37, 0xb0, 0xee, 0x8f,
	0x77, 0x7c, 0xea, 0x75, 0xf5, 0xf2, 0xb1, 0xbf, 0x6d, 0xc1, 0xc5, 0x6d, 0x86, 0xa3, 0x18, 0xbf,
	0xf8, 0x8f, 0xad, 0x40, 0xa3, 0xb9, 0x02, 0xcd, 0x3e, 0xac, 0xe4, 0xaa, 0x8c, 0x19, 0x64, 0x66,
	0x78, 0x1d, 0x0d, 0x12, 0x66, 0xfb, 0x07, 0x03, 0xde, 0x39, 0x0a, 0x17, 0x7a, 0x39, 0xbe, 0x76,
	0x51, 0xbd, 0x14, 0x41, 0xbb, 0x31, 0x17, 0xef, 0xc2, 0x0a, 0x27, 0x2c, 0x42, 0xae, 0x37, 0xea,
	0x9c, 0x7c, 0xd1, 0x0b, 0xd3, 0x78, 0xdc, 0x95, 0xfe, 0x6a, 0x57, 0x76, 0x78, 0x7d, 0xe8, 0x87,
	0x70, 0x2e, 0xa0, 0xe9, 0x14, 0xe8, 0xb6, 0xf1, 0xd9, 0x75, 0x7d, 0x1b, 0xd1, 0x84, 0x64, 0x91,
	0x43, 0x59, 0xe4, 0x46, 0x98, 0x49, 0x3e, 0xdc, 0x5a, 0x7b, 0xe3, 0xfe, 0x9d, 0x5e, 0x53, 0xa7,
	0xc1, 0x82, 0x74, 0x7e, 0xef, 0xcf, 0x00, 0x00, 0x00, 0xff, 0xff, 0xbe, 0x9c, 0x98, 0xd2, 0x5b,
	0x0f, 0x00, 0x00,
}
