// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v0/resources/ad_group.proto

package resources // import "google.golang.org/genproto/googleapis/ads/googleads/v0/resources"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import common "google.golang.org/genproto/googleapis/ads/googleads/v0/common"
import enums "google.golang.org/genproto/googleapis/ads/googleads/v0/enums"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// An ad group.
type AdGroup struct {
	// The resource name of the ad group.
	// Ad group resource names have the form:
	//
	// `customers/{customer_id}/adGroups/{ad_group_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The ID of the ad group.
	Id *wrappers.Int64Value `protobuf:"bytes,3,opt,name=id,proto3" json:"id,omitempty"`
	// The name of the ad group.
	//
	// This field is required and should not be empty when creating new ad
	// groups.
	//
	// It must contain fewer than 255 UTF-8 full-width characters.
	//
	// It must not contain any null (code point 0x0), NL line feed
	// (code point 0xA) or carriage return (code point 0xD) characters.
	Name *wrappers.StringValue `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// The status of the ad group.
	Status enums.AdGroupStatusEnum_AdGroupStatus `protobuf:"varint,5,opt,name=status,proto3,enum=google.ads.googleads.v0.enums.AdGroupStatusEnum_AdGroupStatus" json:"status,omitempty"`
	// The type of the ad group.
	Type enums.AdGroupTypeEnum_AdGroupType `protobuf:"varint,12,opt,name=type,proto3,enum=google.ads.googleads.v0.enums.AdGroupTypeEnum_AdGroupType" json:"type,omitempty"`
	// The ad rotation mode of the ad group.
	AdRotationMode enums.AdGroupAdRotationModeEnum_AdGroupAdRotationMode `protobuf:"varint,22,opt,name=ad_rotation_mode,json=adRotationMode,proto3,enum=google.ads.googleads.v0.enums.AdGroupAdRotationModeEnum_AdGroupAdRotationMode" json:"ad_rotation_mode,omitempty"`
	// The URL template for constructing a tracking URL.
	TrackingUrlTemplate *wrappers.StringValue `protobuf:"bytes,13,opt,name=tracking_url_template,json=trackingUrlTemplate,proto3" json:"tracking_url_template,omitempty"`
	// The list of mappings used to substitute custom parameter tags in a
	// `tracking_url_template`, `final_urls`, or `mobile_final_urls`.
	UrlCustomParameters []*common.CustomParameter `protobuf:"bytes,6,rep,name=url_custom_parameters,json=urlCustomParameters,proto3" json:"url_custom_parameters,omitempty"`
	// The campaign to which the ad group belongs.
	Campaign *wrappers.StringValue `protobuf:"bytes,10,opt,name=campaign,proto3" json:"campaign,omitempty"`
	// The maximum CPC (cost-per-click) bid.
	CpcBidMicros *wrappers.Int64Value `protobuf:"bytes,14,opt,name=cpc_bid_micros,json=cpcBidMicros,proto3" json:"cpc_bid_micros,omitempty"`
	// The maximum CPM (cost-per-thousand viewable impressions) bid.
	CpmBidMicros *wrappers.Int64Value `protobuf:"bytes,15,opt,name=cpm_bid_micros,json=cpmBidMicros,proto3" json:"cpm_bid_micros,omitempty"`
	// The target cost-per-acquisition (conversion) bid.
	CpaBidMicros *wrappers.Int64Value `protobuf:"bytes,16,opt,name=cpa_bid_micros,json=cpaBidMicros,proto3" json:"cpa_bid_micros,omitempty"`
	// The CPV (cost-per-view) bid.
	CpvBidMicros *wrappers.Int64Value `protobuf:"bytes,17,opt,name=cpv_bid_micros,json=cpvBidMicros,proto3" json:"cpv_bid_micros,omitempty"`
	// The target return on ad spend (ROAS) override. If the ad group's campaign
	// bidding strategy is a standard Target ROAS strategy, then this field
	// overrides the target ROAS specified in the campaign's bidding strategy.
	// Otherwise, this value is ignored.
	TargetRoasOverride *wrappers.DoubleValue `protobuf:"bytes,19,opt,name=target_roas_override,json=targetRoasOverride,proto3" json:"target_roas_override,omitempty"`
	// The percent cpc bid amount, expressed as a fraction of the advertised price
	// for some good or service. The valid range for the fraction is [0,1) and the
	// value stored here is 1,000,000 * [fraction].
	PercentCpcBidMicros *wrappers.Int64Value `protobuf:"bytes,20,opt,name=percent_cpc_bid_micros,json=percentCpcBidMicros,proto3" json:"percent_cpc_bid_micros,omitempty"`
	// Settings for the Display Campaign Optimizer, initially termed "Explorer".
	ExplorerAutoOptimizerSetting *common.ExplorerAutoOptimizerSetting `protobuf:"bytes,21,opt,name=explorer_auto_optimizer_setting,json=explorerAutoOptimizerSetting,proto3" json:"explorer_auto_optimizer_setting,omitempty"`
	// Allows advertisers to specify a targeting dimension on which to place
	// absolute bids. This is only applicable for campaigns that target only the
	// display network and not search.
	DisplayCustomBidDimension enums.TargetingDimensionEnum_TargetingDimension `protobuf:"varint,23,opt,name=display_custom_bid_dimension,json=displayCustomBidDimension,proto3,enum=google.ads.googleads.v0.enums.TargetingDimensionEnum_TargetingDimension" json:"display_custom_bid_dimension,omitempty"`
	// URL template for appending params to Final URL.
	FinalUrlSuffix       *wrappers.StringValue `protobuf:"bytes,24,opt,name=final_url_suffix,json=finalUrlSuffix,proto3" json:"final_url_suffix,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *AdGroup) Reset()         { *m = AdGroup{} }
func (m *AdGroup) String() string { return proto.CompactTextString(m) }
func (*AdGroup) ProtoMessage()    {}
func (*AdGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_group_35a993e3f6807d38, []int{0}
}
func (m *AdGroup) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdGroup.Unmarshal(m, b)
}
func (m *AdGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdGroup.Marshal(b, m, deterministic)
}
func (dst *AdGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdGroup.Merge(dst, src)
}
func (m *AdGroup) XXX_Size() int {
	return xxx_messageInfo_AdGroup.Size(m)
}
func (m *AdGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_AdGroup.DiscardUnknown(m)
}

var xxx_messageInfo_AdGroup proto.InternalMessageInfo

func (m *AdGroup) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *AdGroup) GetId() *wrappers.Int64Value {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *AdGroup) GetName() *wrappers.StringValue {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *AdGroup) GetStatus() enums.AdGroupStatusEnum_AdGroupStatus {
	if m != nil {
		return m.Status
	}
	return enums.AdGroupStatusEnum_UNSPECIFIED
}

func (m *AdGroup) GetType() enums.AdGroupTypeEnum_AdGroupType {
	if m != nil {
		return m.Type
	}
	return enums.AdGroupTypeEnum_UNSPECIFIED
}

func (m *AdGroup) GetAdRotationMode() enums.AdGroupAdRotationModeEnum_AdGroupAdRotationMode {
	if m != nil {
		return m.AdRotationMode
	}
	return enums.AdGroupAdRotationModeEnum_UNSPECIFIED
}

func (m *AdGroup) GetTrackingUrlTemplate() *wrappers.StringValue {
	if m != nil {
		return m.TrackingUrlTemplate
	}
	return nil
}

func (m *AdGroup) GetUrlCustomParameters() []*common.CustomParameter {
	if m != nil {
		return m.UrlCustomParameters
	}
	return nil
}

func (m *AdGroup) GetCampaign() *wrappers.StringValue {
	if m != nil {
		return m.Campaign
	}
	return nil
}

func (m *AdGroup) GetCpcBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CpcBidMicros
	}
	return nil
}

func (m *AdGroup) GetCpmBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CpmBidMicros
	}
	return nil
}

func (m *AdGroup) GetCpaBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CpaBidMicros
	}
	return nil
}

func (m *AdGroup) GetCpvBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CpvBidMicros
	}
	return nil
}

func (m *AdGroup) GetTargetRoasOverride() *wrappers.DoubleValue {
	if m != nil {
		return m.TargetRoasOverride
	}
	return nil
}

func (m *AdGroup) GetPercentCpcBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.PercentCpcBidMicros
	}
	return nil
}

func (m *AdGroup) GetExplorerAutoOptimizerSetting() *common.ExplorerAutoOptimizerSetting {
	if m != nil {
		return m.ExplorerAutoOptimizerSetting
	}
	return nil
}

func (m *AdGroup) GetDisplayCustomBidDimension() enums.TargetingDimensionEnum_TargetingDimension {
	if m != nil {
		return m.DisplayCustomBidDimension
	}
	return enums.TargetingDimensionEnum_UNSPECIFIED
}

func (m *AdGroup) GetFinalUrlSuffix() *wrappers.StringValue {
	if m != nil {
		return m.FinalUrlSuffix
	}
	return nil
}

func init() {
	proto.RegisterType((*AdGroup)(nil), "google.ads.googleads.v0.resources.AdGroup")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v0/resources/ad_group.proto", fileDescriptor_ad_group_35a993e3f6807d38)
}

var fileDescriptor_ad_group_35a993e3f6807d38 = []byte{
	// 780 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x95, 0x5f, 0x6f, 0xeb, 0x34,
	0x14, 0xc0, 0x95, 0x6e, 0x0c, 0xf0, 0x7a, 0xcb, 0x48, 0xef, 0x2e, 0xe1, 0x32, 0x41, 0x2f, 0x08,
	0xa9, 0x12, 0x52, 0x52, 0x76, 0xf9, 0x27, 0xfe, 0x49, 0xe9, 0xdd, 0x18, 0x20, 0xad, 0xab, 0xd2,
	0xad, 0x0f, 0xa8, 0x92, 0xe5, 0xc6, 0x6e, 0x64, 0x11, 0xc7, 0x96, 0xed, 0x94, 0x8d, 0x57, 0x9e,
	0xf8, 0x1a, 0x3c, 0x21, 0x3e, 0x0a, 0x6f, 0x7c, 0x23, 0x14, 0xc7, 0xc9, 0xda, 0x4e, 0x5d, 0xf3,
	0xe6, 0x38, 0xe7, 0xf7, 0xb3, 0x7d, 0x72, 0x8e, 0x03, 0x06, 0x09, 0xe7, 0x49, 0x4a, 0x02, 0x84,
	0x55, 0x50, 0x0e, 0x8b, 0xd1, 0x72, 0x10, 0x48, 0xa2, 0x78, 0x2e, 0x63, 0xa2, 0x02, 0x84, 0x61,
	0x22, 0x79, 0x2e, 0x7c, 0x21, 0xb9, 0xe6, 0xee, 0x8b, 0x32, 0xcc, 0x47, 0x58, 0xf9, 0x35, 0xe1,
	0x2f, 0x07, 0x7e, 0x4d, 0x3c, 0xff, 0x7c, 0x9b, 0x34, 0xe6, 0x8c, 0xf1, 0x2c, 0x88, 0x73, 0xa5,
	0x39, 0x83, 0x02, 0x49, 0xc4, 0x88, 0x26, 0xb2, 0x34, 0x3f, 0x3f, 0xdb, 0x81, 0x91, 0x5b, 0x91,
	0x72, 0x49, 0x24, 0x44, 0xb9, 0xe6, 0x90, 0x0b, 0x4d, 0x19, 0xfd, 0x9d, 0x48, 0xa8, 0x88, 0xd6,
	0x34, 0x4b, 0xac, 0xe5, 0xbb, 0x6d, 0x16, 0x92, 0xe5, 0xec, 0xfe, 0x34, 0x10, 0x61, 0x28, 0xb9,
	0x46, 0x9a, 0xf2, 0x0c, 0x32, 0x8e, 0x89, 0xc5, 0x5f, 0x36, 0xc4, 0x95, 0x46, 0x3a, 0x57, 0x16,
	0xfa, 0xb4, 0x21, 0xa4, 0xef, 0x44, 0xb5, 0xce, 0x97, 0x8f, 0x23, 0x1a, 0xc9, 0x84, 0x14, 0xa7,
	0x82, 0x98, 0x32, 0x92, 0x29, 0xca, 0x33, 0x0b, 0xbe, 0x6f, 0x41, 0xf3, 0x34, 0xcf, 0x17, 0xc1,
	0x6f, 0x12, 0x09, 0x41, 0xa4, 0xdd, 0xcb, 0x87, 0x7f, 0x1f, 0x82, 0xd7, 0x43, 0x7c, 0x51, 0xac,
	0xe7, 0x7e, 0x04, 0x9e, 0x54, 0x5f, 0x05, 0x66, 0x88, 0x11, 0xcf, 0xe9, 0x39, 0xfd, 0x37, 0xa3,
	0x76, 0x35, 0x39, 0x42, 0x8c, 0xb8, 0x9f, 0x80, 0x16, 0xc5, 0xde, 0x5e, 0xcf, 0xe9, 0x1f, 0x9e,
	0xbe, 0x67, 0x3f, 0xa9, 0x5f, 0xd9, 0xfd, 0x9f, 0x32, 0xfd, 0xc5, 0x67, 0x53, 0x94, 0xe6, 0x24,
	0x6a, 0x51, 0xec, 0x0e, 0xc0, 0xbe, 0x11, 0xed, 0x9b, 0xf0, 0x93, 0x07, 0xe1, 0x13, 0x2d, 0x69,
	0x96, 0x94, 0xf1, 0x26, 0xd2, 0x9d, 0x82, 0x83, 0x32, 0x57, 0xde, 0x6b, 0x3d, 0xa7, 0xdf, 0x39,
	0xfd, 0xde, 0xdf, 0x56, 0x40, 0xe6, 0xe4, 0xbe, 0xdd, 0xfb, 0xc4, 0x30, 0xe7, 0x59, 0xce, 0xd6,
	0x67, 0x22, 0x6b, 0x73, 0x47, 0x60, 0xbf, 0x48, 0xa7, 0xd7, 0x36, 0xd6, 0xaf, 0x9b, 0x59, 0xaf,
	0xef, 0x04, 0x59, 0x75, 0x16, 0xcf, 0x91, 0xf1, 0xb8, 0xb7, 0xe0, 0x68, 0xb3, 0x24, 0xbc, 0x67,
	0xc6, 0x3d, 0x6a, 0xe6, 0x0e, 0x71, 0x64, 0xe1, 0x4b, 0x8e, 0xd7, 0x56, 0x59, 0x7f, 0x13, 0x75,
	0xd0, 0xda, 0xb3, 0x3b, 0x06, 0xc7, 0x5a, 0xa2, 0xf8, 0xd7, 0xe2, 0x6b, 0xe7, 0x32, 0x85, 0x9a,
	0x30, 0x91, 0x22, 0x4d, 0xbc, 0x27, 0x0d, 0x92, 0xdc, 0xad, 0xd0, 0x1b, 0x99, 0x5e, 0x5b, 0xd0,
	0x8d, 0xc1, 0x71, 0x21, 0xda, 0xec, 0x33, 0xe5, 0x1d, 0xf4, 0xf6, 0xfa, 0x87, 0xa7, 0xc1, 0xd6,
	0x03, 0x95, 0x9d, 0xe6, 0xbf, 0x32, 0xe0, 0xb8, 0xe2, 0xa2, 0x6e, 0x2e, 0xd3, 0x8d, 0x39, 0xe5,
	0x7e, 0x05, 0xde, 0x88, 0x11, 0x13, 0x88, 0x26, 0x99, 0x07, 0x1a, 0xec, 0xb4, 0x8e, 0x76, 0x43,
	0xd0, 0x89, 0x45, 0x0c, 0xe7, 0x14, 0x43, 0x46, 0x63, 0xc9, 0x95, 0xd7, 0xd9, 0x5d, 0x7d, 0xed,
	0x58, 0xc4, 0x43, 0x8a, 0x2f, 0x0d, 0x50, 0x2a, 0xd8, 0xaa, 0xe2, 0xad, 0x46, 0x0a, 0xb6, 0xa1,
	0x40, 0xab, 0x8a, 0xa3, 0x46, 0x0a, 0xb4, 0xa1, 0x58, 0xae, 0x2a, 0xde, 0x6e, 0xa4, 0x58, 0xde,
	0x2b, 0x46, 0xe0, 0x69, 0xd9, 0xeb, 0x50, 0x72, 0xa4, 0x20, 0x5f, 0x12, 0x29, 0x29, 0x26, 0x5e,
	0x77, 0x4b, 0x46, 0xcf, 0x78, 0x3e, 0x4f, 0x49, 0x69, 0x72, 0x4b, 0x32, 0xe2, 0x48, 0x5d, 0x59,
	0xce, 0x1d, 0x83, 0x67, 0x82, 0xc8, 0x98, 0x64, 0x1a, 0x6e, 0xe4, 0xf8, 0xe9, 0xee, 0xad, 0x75,
	0x2d, 0xfa, 0x6a, 0x35, 0xd5, 0x7f, 0x38, 0xe0, 0x83, 0x1d, 0x57, 0xaf, 0x77, 0x6c, 0xdc, 0xdf,
	0xee, 0xaa, 0xab, 0x73, 0xab, 0x09, 0x73, 0xcd, 0xaf, 0x2a, 0xc9, 0xa4, 0x74, 0x44, 0x27, 0xe4,
	0x91, 0xb7, 0xee, 0x9f, 0x0e, 0x38, 0xc1, 0x54, 0x89, 0x14, 0xdd, 0x55, 0x75, 0x5d, 0x9c, 0xad,
	0xbe, 0x1d, 0xbd, 0x77, 0x4c, 0xaf, 0xfe, 0xb8, 0xa3, 0x57, 0xaf, 0xab, 0x7b, 0xf5, 0xac, 0x02,
	0x4d, 0xa3, 0x3e, 0x9c, 0x8e, 0xde, 0xb5, 0xab, 0x95, 0x75, 0x3f, 0xa4, 0xb8, 0x7e, 0xe5, 0xfe,
	0x00, 0x8e, 0x16, 0x34, 0x43, 0xa9, 0xe9, 0x56, 0x95, 0x2f, 0x16, 0xf4, 0xd6, 0xf3, 0x1a, 0x74,
	0x40, 0xc7, 0x50, 0x37, 0x32, 0x9d, 0x18, 0x66, 0xf8, 0x9f, 0x03, 0x3e, 0x8e, 0x39, 0xf3, 0x77,
	0xfe, 0x51, 0x87, 0x6d, 0x7b, 0x93, 0x8c, 0x0b, 0xed, 0xd8, 0xf9, 0xe5, 0x67, 0x8b, 0x24, 0x3c,
	0x45, 0x59, 0xe2, 0x73, 0x99, 0x04, 0x09, 0xc9, 0xcc, 0xa2, 0xd5, 0xdf, 0x44, 0x50, 0xf5, 0xc8,
	0x5f, 0xfd, 0x9b, 0x7a, 0xf4, 0x57, 0x6b, 0xef, 0x22, 0x0c, 0xff, 0x69, 0xbd, 0xb8, 0x28, 0x95,
	0x21, 0x56, 0x7e, 0x39, 0x2c, 0x46, 0xd3, 0x81, 0x1f, 0x55, 0x91, 0xff, 0x56, 0x31, 0xb3, 0x10,
	0xab, 0x59, 0x1d, 0x33, 0x9b, 0x0e, 0x66, 0x75, 0xcc, 0xfc, 0xc0, 0x6c, 0xe2, 0xe5, 0xff, 0x01,
	0x00, 0x00, 0xff, 0xff, 0x2e, 0x2f, 0x7c, 0xf6, 0x59, 0x08, 0x00, 0x00,
}
