// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package appconfigiface provides an interface to enable mocking the Amazon AppConfig service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package appconfigiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/appconfig"
)

// AppConfigAPI provides an interface to enable mocking the
// appconfig.AppConfig service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon AppConfig.
//    func myFunc(svc appconfigiface.AppConfigAPI) bool {
//        // Make svc.CreateApplication request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := appconfig.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockAppConfigClient struct {
//        appconfigiface.AppConfigAPI
//    }
//    func (m *mockAppConfigClient) CreateApplication(input *appconfig.CreateApplicationInput) (*appconfig.CreateApplicationOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockAppConfigClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type AppConfigAPI interface {
	CreateApplication(*appconfig.CreateApplicationInput) (*appconfig.CreateApplicationOutput, error)
	CreateApplicationWithContext(aws.Context, *appconfig.CreateApplicationInput, ...request.Option) (*appconfig.CreateApplicationOutput, error)
	CreateApplicationRequest(*appconfig.CreateApplicationInput) (*request.Request, *appconfig.CreateApplicationOutput)

	CreateConfigurationProfile(*appconfig.CreateConfigurationProfileInput) (*appconfig.CreateConfigurationProfileOutput, error)
	CreateConfigurationProfileWithContext(aws.Context, *appconfig.CreateConfigurationProfileInput, ...request.Option) (*appconfig.CreateConfigurationProfileOutput, error)
	CreateConfigurationProfileRequest(*appconfig.CreateConfigurationProfileInput) (*request.Request, *appconfig.CreateConfigurationProfileOutput)

	CreateDeploymentStrategy(*appconfig.CreateDeploymentStrategyInput) (*appconfig.CreateDeploymentStrategyOutput, error)
	CreateDeploymentStrategyWithContext(aws.Context, *appconfig.CreateDeploymentStrategyInput, ...request.Option) (*appconfig.CreateDeploymentStrategyOutput, error)
	CreateDeploymentStrategyRequest(*appconfig.CreateDeploymentStrategyInput) (*request.Request, *appconfig.CreateDeploymentStrategyOutput)

	CreateEnvironment(*appconfig.CreateEnvironmentInput) (*appconfig.CreateEnvironmentOutput, error)
	CreateEnvironmentWithContext(aws.Context, *appconfig.CreateEnvironmentInput, ...request.Option) (*appconfig.CreateEnvironmentOutput, error)
	CreateEnvironmentRequest(*appconfig.CreateEnvironmentInput) (*request.Request, *appconfig.CreateEnvironmentOutput)

	CreateHostedConfigurationVersion(*appconfig.CreateHostedConfigurationVersionInput) (*appconfig.CreateHostedConfigurationVersionOutput, error)
	CreateHostedConfigurationVersionWithContext(aws.Context, *appconfig.CreateHostedConfigurationVersionInput, ...request.Option) (*appconfig.CreateHostedConfigurationVersionOutput, error)
	CreateHostedConfigurationVersionRequest(*appconfig.CreateHostedConfigurationVersionInput) (*request.Request, *appconfig.CreateHostedConfigurationVersionOutput)

	DeleteApplication(*appconfig.DeleteApplicationInput) (*appconfig.DeleteApplicationOutput, error)
	DeleteApplicationWithContext(aws.Context, *appconfig.DeleteApplicationInput, ...request.Option) (*appconfig.DeleteApplicationOutput, error)
	DeleteApplicationRequest(*appconfig.DeleteApplicationInput) (*request.Request, *appconfig.DeleteApplicationOutput)

	DeleteConfigurationProfile(*appconfig.DeleteConfigurationProfileInput) (*appconfig.DeleteConfigurationProfileOutput, error)
	DeleteConfigurationProfileWithContext(aws.Context, *appconfig.DeleteConfigurationProfileInput, ...request.Option) (*appconfig.DeleteConfigurationProfileOutput, error)
	DeleteConfigurationProfileRequest(*appconfig.DeleteConfigurationProfileInput) (*request.Request, *appconfig.DeleteConfigurationProfileOutput)

	DeleteDeploymentStrategy(*appconfig.DeleteDeploymentStrategyInput) (*appconfig.DeleteDeploymentStrategyOutput, error)
	DeleteDeploymentStrategyWithContext(aws.Context, *appconfig.DeleteDeploymentStrategyInput, ...request.Option) (*appconfig.DeleteDeploymentStrategyOutput, error)
	DeleteDeploymentStrategyRequest(*appconfig.DeleteDeploymentStrategyInput) (*request.Request, *appconfig.DeleteDeploymentStrategyOutput)

	DeleteEnvironment(*appconfig.DeleteEnvironmentInput) (*appconfig.DeleteEnvironmentOutput, error)
	DeleteEnvironmentWithContext(aws.Context, *appconfig.DeleteEnvironmentInput, ...request.Option) (*appconfig.DeleteEnvironmentOutput, error)
	DeleteEnvironmentRequest(*appconfig.DeleteEnvironmentInput) (*request.Request, *appconfig.DeleteEnvironmentOutput)

	DeleteHostedConfigurationVersion(*appconfig.DeleteHostedConfigurationVersionInput) (*appconfig.DeleteHostedConfigurationVersionOutput, error)
	DeleteHostedConfigurationVersionWithContext(aws.Context, *appconfig.DeleteHostedConfigurationVersionInput, ...request.Option) (*appconfig.DeleteHostedConfigurationVersionOutput, error)
	DeleteHostedConfigurationVersionRequest(*appconfig.DeleteHostedConfigurationVersionInput) (*request.Request, *appconfig.DeleteHostedConfigurationVersionOutput)

	GetApplication(*appconfig.GetApplicationInput) (*appconfig.GetApplicationOutput, error)
	GetApplicationWithContext(aws.Context, *appconfig.GetApplicationInput, ...request.Option) (*appconfig.GetApplicationOutput, error)
	GetApplicationRequest(*appconfig.GetApplicationInput) (*request.Request, *appconfig.GetApplicationOutput)

	GetConfiguration(*appconfig.GetConfigurationInput) (*appconfig.GetConfigurationOutput, error)
	GetConfigurationWithContext(aws.Context, *appconfig.GetConfigurationInput, ...request.Option) (*appconfig.GetConfigurationOutput, error)
	GetConfigurationRequest(*appconfig.GetConfigurationInput) (*request.Request, *appconfig.GetConfigurationOutput)

	GetConfigurationProfile(*appconfig.GetConfigurationProfileInput) (*appconfig.GetConfigurationProfileOutput, error)
	GetConfigurationProfileWithContext(aws.Context, *appconfig.GetConfigurationProfileInput, ...request.Option) (*appconfig.GetConfigurationProfileOutput, error)
	GetConfigurationProfileRequest(*appconfig.GetConfigurationProfileInput) (*request.Request, *appconfig.GetConfigurationProfileOutput)

	GetDeployment(*appconfig.GetDeploymentInput) (*appconfig.GetDeploymentOutput, error)
	GetDeploymentWithContext(aws.Context, *appconfig.GetDeploymentInput, ...request.Option) (*appconfig.GetDeploymentOutput, error)
	GetDeploymentRequest(*appconfig.GetDeploymentInput) (*request.Request, *appconfig.GetDeploymentOutput)

	GetDeploymentStrategy(*appconfig.GetDeploymentStrategyInput) (*appconfig.GetDeploymentStrategyOutput, error)
	GetDeploymentStrategyWithContext(aws.Context, *appconfig.GetDeploymentStrategyInput, ...request.Option) (*appconfig.GetDeploymentStrategyOutput, error)
	GetDeploymentStrategyRequest(*appconfig.GetDeploymentStrategyInput) (*request.Request, *appconfig.GetDeploymentStrategyOutput)

	GetEnvironment(*appconfig.GetEnvironmentInput) (*appconfig.GetEnvironmentOutput, error)
	GetEnvironmentWithContext(aws.Context, *appconfig.GetEnvironmentInput, ...request.Option) (*appconfig.GetEnvironmentOutput, error)
	GetEnvironmentRequest(*appconfig.GetEnvironmentInput) (*request.Request, *appconfig.GetEnvironmentOutput)

	GetHostedConfigurationVersion(*appconfig.GetHostedConfigurationVersionInput) (*appconfig.GetHostedConfigurationVersionOutput, error)
	GetHostedConfigurationVersionWithContext(aws.Context, *appconfig.GetHostedConfigurationVersionInput, ...request.Option) (*appconfig.GetHostedConfigurationVersionOutput, error)
	GetHostedConfigurationVersionRequest(*appconfig.GetHostedConfigurationVersionInput) (*request.Request, *appconfig.GetHostedConfigurationVersionOutput)

	ListApplications(*appconfig.ListApplicationsInput) (*appconfig.ListApplicationsOutput, error)
	ListApplicationsWithContext(aws.Context, *appconfig.ListApplicationsInput, ...request.Option) (*appconfig.ListApplicationsOutput, error)
	ListApplicationsRequest(*appconfig.ListApplicationsInput) (*request.Request, *appconfig.ListApplicationsOutput)

	ListApplicationsPages(*appconfig.ListApplicationsInput, func(*appconfig.ListApplicationsOutput, bool) bool) error
	ListApplicationsPagesWithContext(aws.Context, *appconfig.ListApplicationsInput, func(*appconfig.ListApplicationsOutput, bool) bool, ...request.Option) error

	ListConfigurationProfiles(*appconfig.ListConfigurationProfilesInput) (*appconfig.ListConfigurationProfilesOutput, error)
	ListConfigurationProfilesWithContext(aws.Context, *appconfig.ListConfigurationProfilesInput, ...request.Option) (*appconfig.ListConfigurationProfilesOutput, error)
	ListConfigurationProfilesRequest(*appconfig.ListConfigurationProfilesInput) (*request.Request, *appconfig.ListConfigurationProfilesOutput)

	ListConfigurationProfilesPages(*appconfig.ListConfigurationProfilesInput, func(*appconfig.ListConfigurationProfilesOutput, bool) bool) error
	ListConfigurationProfilesPagesWithContext(aws.Context, *appconfig.ListConfigurationProfilesInput, func(*appconfig.ListConfigurationProfilesOutput, bool) bool, ...request.Option) error

	ListDeploymentStrategies(*appconfig.ListDeploymentStrategiesInput) (*appconfig.ListDeploymentStrategiesOutput, error)
	ListDeploymentStrategiesWithContext(aws.Context, *appconfig.ListDeploymentStrategiesInput, ...request.Option) (*appconfig.ListDeploymentStrategiesOutput, error)
	ListDeploymentStrategiesRequest(*appconfig.ListDeploymentStrategiesInput) (*request.Request, *appconfig.ListDeploymentStrategiesOutput)

	ListDeploymentStrategiesPages(*appconfig.ListDeploymentStrategiesInput, func(*appconfig.ListDeploymentStrategiesOutput, bool) bool) error
	ListDeploymentStrategiesPagesWithContext(aws.Context, *appconfig.ListDeploymentStrategiesInput, func(*appconfig.ListDeploymentStrategiesOutput, bool) bool, ...request.Option) error

	ListDeployments(*appconfig.ListDeploymentsInput) (*appconfig.ListDeploymentsOutput, error)
	ListDeploymentsWithContext(aws.Context, *appconfig.ListDeploymentsInput, ...request.Option) (*appconfig.ListDeploymentsOutput, error)
	ListDeploymentsRequest(*appconfig.ListDeploymentsInput) (*request.Request, *appconfig.ListDeploymentsOutput)

	ListDeploymentsPages(*appconfig.ListDeploymentsInput, func(*appconfig.ListDeploymentsOutput, bool) bool) error
	ListDeploymentsPagesWithContext(aws.Context, *appconfig.ListDeploymentsInput, func(*appconfig.ListDeploymentsOutput, bool) bool, ...request.Option) error

	ListEnvironments(*appconfig.ListEnvironmentsInput) (*appconfig.ListEnvironmentsOutput, error)
	ListEnvironmentsWithContext(aws.Context, *appconfig.ListEnvironmentsInput, ...request.Option) (*appconfig.ListEnvironmentsOutput, error)
	ListEnvironmentsRequest(*appconfig.ListEnvironmentsInput) (*request.Request, *appconfig.ListEnvironmentsOutput)

	ListEnvironmentsPages(*appconfig.ListEnvironmentsInput, func(*appconfig.ListEnvironmentsOutput, bool) bool) error
	ListEnvironmentsPagesWithContext(aws.Context, *appconfig.ListEnvironmentsInput, func(*appconfig.ListEnvironmentsOutput, bool) bool, ...request.Option) error

	ListHostedConfigurationVersions(*appconfig.ListHostedConfigurationVersionsInput) (*appconfig.ListHostedConfigurationVersionsOutput, error)
	ListHostedConfigurationVersionsWithContext(aws.Context, *appconfig.ListHostedConfigurationVersionsInput, ...request.Option) (*appconfig.ListHostedConfigurationVersionsOutput, error)
	ListHostedConfigurationVersionsRequest(*appconfig.ListHostedConfigurationVersionsInput) (*request.Request, *appconfig.ListHostedConfigurationVersionsOutput)

	ListHostedConfigurationVersionsPages(*appconfig.ListHostedConfigurationVersionsInput, func(*appconfig.ListHostedConfigurationVersionsOutput, bool) bool) error
	ListHostedConfigurationVersionsPagesWithContext(aws.Context, *appconfig.ListHostedConfigurationVersionsInput, func(*appconfig.ListHostedConfigurationVersionsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*appconfig.ListTagsForResourceInput) (*appconfig.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *appconfig.ListTagsForResourceInput, ...request.Option) (*appconfig.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*appconfig.ListTagsForResourceInput) (*request.Request, *appconfig.ListTagsForResourceOutput)

	StartDeployment(*appconfig.StartDeploymentInput) (*appconfig.StartDeploymentOutput, error)
	StartDeploymentWithContext(aws.Context, *appconfig.StartDeploymentInput, ...request.Option) (*appconfig.StartDeploymentOutput, error)
	StartDeploymentRequest(*appconfig.StartDeploymentInput) (*request.Request, *appconfig.StartDeploymentOutput)

	StopDeployment(*appconfig.StopDeploymentInput) (*appconfig.StopDeploymentOutput, error)
	StopDeploymentWithContext(aws.Context, *appconfig.StopDeploymentInput, ...request.Option) (*appconfig.StopDeploymentOutput, error)
	StopDeploymentRequest(*appconfig.StopDeploymentInput) (*request.Request, *appconfig.StopDeploymentOutput)

	TagResource(*appconfig.TagResourceInput) (*appconfig.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *appconfig.TagResourceInput, ...request.Option) (*appconfig.TagResourceOutput, error)
	TagResourceRequest(*appconfig.TagResourceInput) (*request.Request, *appconfig.TagResourceOutput)

	UntagResource(*appconfig.UntagResourceInput) (*appconfig.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *appconfig.UntagResourceInput, ...request.Option) (*appconfig.UntagResourceOutput, error)
	UntagResourceRequest(*appconfig.UntagResourceInput) (*request.Request, *appconfig.UntagResourceOutput)

	UpdateApplication(*appconfig.UpdateApplicationInput) (*appconfig.UpdateApplicationOutput, error)
	UpdateApplicationWithContext(aws.Context, *appconfig.UpdateApplicationInput, ...request.Option) (*appconfig.UpdateApplicationOutput, error)
	UpdateApplicationRequest(*appconfig.UpdateApplicationInput) (*request.Request, *appconfig.UpdateApplicationOutput)

	UpdateConfigurationProfile(*appconfig.UpdateConfigurationProfileInput) (*appconfig.UpdateConfigurationProfileOutput, error)
	UpdateConfigurationProfileWithContext(aws.Context, *appconfig.UpdateConfigurationProfileInput, ...request.Option) (*appconfig.UpdateConfigurationProfileOutput, error)
	UpdateConfigurationProfileRequest(*appconfig.UpdateConfigurationProfileInput) (*request.Request, *appconfig.UpdateConfigurationProfileOutput)

	UpdateDeploymentStrategy(*appconfig.UpdateDeploymentStrategyInput) (*appconfig.UpdateDeploymentStrategyOutput, error)
	UpdateDeploymentStrategyWithContext(aws.Context, *appconfig.UpdateDeploymentStrategyInput, ...request.Option) (*appconfig.UpdateDeploymentStrategyOutput, error)
	UpdateDeploymentStrategyRequest(*appconfig.UpdateDeploymentStrategyInput) (*request.Request, *appconfig.UpdateDeploymentStrategyOutput)

	UpdateEnvironment(*appconfig.UpdateEnvironmentInput) (*appconfig.UpdateEnvironmentOutput, error)
	UpdateEnvironmentWithContext(aws.Context, *appconfig.UpdateEnvironmentInput, ...request.Option) (*appconfig.UpdateEnvironmentOutput, error)
	UpdateEnvironmentRequest(*appconfig.UpdateEnvironmentInput) (*request.Request, *appconfig.UpdateEnvironmentOutput)

	ValidateConfiguration(*appconfig.ValidateConfigurationInput) (*appconfig.ValidateConfigurationOutput, error)
	ValidateConfigurationWithContext(aws.Context, *appconfig.ValidateConfigurationInput, ...request.Option) (*appconfig.ValidateConfigurationOutput, error)
	ValidateConfigurationRequest(*appconfig.ValidateConfigurationInput) (*request.Request, *appconfig.ValidateConfigurationOutput)
}

var _ AppConfigAPI = (*appconfig.AppConfig)(nil)
