/* ----------------------------------------------------------------

SmillaEnlarger  -  resize, especially magnify bitmaps in high quality
    ColorEnlargerClass.h: the enlarging algorithm

Copyright (C) 2009 Mischa Lusteck

This program is free software;
you can redistribute it and/or modify it under the terms of the
GNU General Public License as published by the Free Software Foundation;
either version 3 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, see <http://www.gnu.org/licenses/>.

---------------------------------------------------------------------- */

#ifndef COLOR_ENLARGER_CLASS_H
#define COLOR_ENLARGER_CLASS_H

#include <iostream>
#include "ConstDefs.h"
#include "Array.h"
#include "Array4D.h"
#include "EnlargerTemplate.h"
#include "PointClass.h"
#include "timing.h"

using namespace std;

class ColorEnlarger : public BasicEnlarger<Point4> {

   ArrayARGB *src, *dst;

   Timer t1,t2,tTotal;

public:
   ColorEnlarger( ArrayARGB *srcArray, float scaleF );
   ~ColorEnlarger(void) { }
   void Enlarge( int x0, int y0, ArrayARGB *dstArr );
   void Enlarge(  ArrayARGB *dstArr) { Enlarge( 0, 0, dstArr ); }
   void ReadSrcBlock( void );
   void WriteDstBlock( void );
};

//
//-----------------------------------------------------------------------
//

#endif
