/* ----------------------------------------------------------------

SmillaEnlarger  -  resize, especially magnify bitmaps in high quality
    Array_IO_Qt.cpp: conversion between QImage and MyArray4D

Copyright (C) 2009 Mischa Lusteck

This program is free software;
you can redistribute it and/or modify it under the terms of the
GNU General Public License as published by the Free Software Foundation;
either version 3 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, see <http://www.gnu.org/licenses/>.

---------------------------------------------------------------------- */

#include "Array_IO_Qt.h"
#include <QImage>
#include "ImageEnlargerCode/Array4D.h"
#include "ImageEnlargerCode/PointClass.h"


void ImageToArray4D( const QImage & image, MyArray4D *myArray ) {
   Point4 *dst;
   int x,y;

   int sx = image.width();
   int sy = image.height();
   myArray->ChangeSize(sx,sy);

   dst=myArray->Buffer();
   for (y=0; y<sy; y++ )   {
       QRgb *src;
       src = (QRgb *)image.scanLine ( y );
       for (x=0; x<sx; x++ )   {
         Point4 p;
         p.x = float( qRed  ( *src ) )*(1.0/255.0);
         p.y = float( qGreen( *src ) )*(1.0/255.0);
         p.z = float( qBlue ( *src ) )*(1.0/255.0);
         p.w = float( qAlpha( *src ) )*(1.0/255.0);
         *(dst++) = p;
         src++;
      }
   }
}

void Array4DToImage( MyArray4D *myArray,  QImage & image ) {
   int x,y;
   Point4 *src;
   int sizeX = myArray->SizeX(), sizeY = myArray->SizeY();

   image =  QImage( sizeX,sizeY, QImage::Format_ARGB32 );

   src = myArray->Buffer();
   for (y=0; y<sizeY; y++ )   {
      QRgb *dst;
      dst = (QRgb *)image.scanLine ( y );
      for (x=0; x<sizeX; x++ )   {
         *dst = qRgba( int(src->x*255.0), int(src->y*255.0),  int(src->z*255.0), int(src->w*255.0) );
         src++;
         dst++;
      }
   }
}

ArrayARGB *ImageToArrayARGB( QImage & srcImg ) {
    uint32 **scanL;
    scanL = new uint32*[ srcImg.height() ];
    for (int y=0; y<srcImg.height(); y++ )   {
        scanL[y] = (uint32 *)srcImg.scanLine ( y );
    }
    ArrayARGB *dst = new ArrayARGB( srcImg.width(), srcImg.height(), scanL );

    delete[] scanL;
    return dst;
}
