/* ----------------------------------------------------------------

SmillaEnlarger  -  resize, especially magnify bitmaps in high quality
    Array4D.cpp: 2-dim. vector4-array

Copyright (C) 2009 Mischa Lusteck

This program is free software;
you can redistribute it and/or modify it under the terms of the
GNU General Public License as published by the Free Software Foundation;
either version 3 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, see <http://www.gnu.org/licenses/>.

---------------------------------------------------------------------- */

#include <string>
#include <iostream>
#include <math.h>

#include "Array4D.h"
#include "ArraysTemplateDefs.h"

template class BasicArray<Point4>;  // explicit instantiation
/*
// Copy (sizeX,sizeY)-Array out of srcArray beginning at (srcX,srcY)
// if parts of dst are outside, fill them with border-values of srcArray
void MyArray4D::CopyFromArray(ArrayARGB *srcArr, int srcX,int srcY) {
   int x,y,sx,sy;
   Point4 *dst;
   int srcSizeX = srcArr->SizeX();
   int srcSizeY = srcArr->SizeY();

   y=0;sy=srcY;
   dst = Buffer();
   // while dst outside: copy pixels of src-line 0
   while(sy<=0 && y < SizeY()) {
      x=0;sx=srcX;
      // while dst outside: write src-edge-pixel
      while( sx<0 && x < SizeX() ) {
         *(dst++) = srcArr->Get( 0, 0);      x++; sx++;
      }
      // copy pixels of src-line 0
      while( sx < srcSizeX- 1 && x < SizeX() ) {
         *(dst++) = srcArr->Get( sx, 0 );  x++; sx++;
      }
      // while dst outside: write src-edge-pixel
      while( x < SizeX() ) {
         *(dst++) = srcArr->Get( srcSizeX-1, 0 );      x++; sx++;
      }
      y++;sy++;
   }

   while(sy < srcSizeY - 1 && y < SizeY() ) {
      x=0;sx=srcX;
      // while dst outside: write src-border-pixel
      while( sx<0 && x < SizeX() ) {
         *(dst++) = srcArr->Get( 0, sy);      x++; sx++;
      }
      // copy pixels normally 
      while( sx < srcSizeX - 1 && x < SizeX() ) {
         *(dst++) = srcArr->Get( sx, sy );  x++; sx++;
      }
      // while dst outside: write src-border-pixel
      while( x < SizeX() ) {
         *(dst++) = srcArr->Get( srcSizeX-1, sy );      x++; sx++;
      }
      y++;sy++;
   }

   // for outside-parts: copy pixels of last src-line
   while( y < SizeY() ) {
      x=0;sx=srcX;
      // while dst outside: write src-edge-pixel
      while( sx<0 && x < SizeX() ) {
         *(dst++) = srcArr->Get( 0, srcSizeY-1 );      x++; sx++;
      }
      // copy pixels of last src-line
      while( sx < srcSizeX - 1 && x < SizeX() ) {
         *(dst++) = srcArr->Get( sx, srcSizeY-1 );  x++; sx++;
      }
      // while dst outside: write src-edge-pixel
      while( x < SizeX() ) {
         *(dst++) = srcArr->Get( srcSizeX-1, srcSizeY-1 );      x++; sx++;
      }
      y++;sy++;
   }
}
*/
//----------------------------------------------------------------------
//----------------------------------------------------------------------
/*
 ArrayARGB::ArrayARGB(int sx,int sy, uint32 *buf) : sizeX(sx), sizeY(sy) {
     rowBuf = new uint32*[ sizeY ];
     for( int y=0; y<sizeY; y++ ) {
         rowBuf[y] = buf;
         buf += sizeX;
     }
 }

 ArrayARGB::ArrayARGB(int sx,int sy, uint32 **bufList) : sizeX(sx), sizeY(sy) {
     rowBuf = new uint32*[ sizeY ];
     for( int y=0; y<sizeY; y++ ) {
         rowBuf[y] = bufList[y];
     }
 }

 ArrayARGB::ArrayARGB( ArrayARGB  & aSrc) : sizeX( aSrc.sizeX ), sizeY( aSrc.sizeY )  {
     rowBuf = new uint32*[ sizeY ];
     for( int y=0; y<sizeY; y++ ) {
         rowBuf[y] = aSrc.rowBuf[y];
     }
}

void ArrayARGB::CopyFromArray(const ArrayARGB & srcArr, int px,int py) {
    int srcX0,srcY0,srcX1,srcY1;
    int dstX0 = px, dstY0 = py;
    srcX0 = 0; srcY0 = 0;
    srcX1 = srcArr.SizeX();
    srcY1 = srcArr.SizeY();
    if( px<0 ) {
        srcX0 = -px;
        dstX0 = 0;
    }
    if( py<0 ) {
        srcY0 = -py;
        dstY0 = 0;
    }
    if( px + srcArr.SizeX() > sizeX )
        srcX1 =  sizeX - px;
    if( py + srcArr.SizeY() > sizeY )
        srcY1 =  sizeY - py;

    for(int y=0; y < srcY1-srcY0; y++ ) {
        uint32 *src,*dst;
        src = srcArr.rowBuf[ y + srcY0 ] + srcX0;
        dst =        rowBuf[ y + dstY0 ] + dstX0;
        for(int x=0; x < srcX1-srcX0; x++ ) {
            *(dst++) = *(src++);
        }
    }
}

void ArrayARGB::CopyFromArray(const MyArray4D & srcArr, int px,int py ) {
    int srcX0,srcY0,srcX1,srcY1;
    int dstX0 = px, dstY0 = py;
    srcX0 = 0; srcY0 = 0;
    srcX1 = srcArr.SizeX();
    srcY1 = srcArr.SizeY();
    if( px<0 ) {
        srcX0 = -px;
        dstX0 = 0;
    }
    if( py<0 ) {
        srcY0 = -py;
        dstY0 = 0;
    }
    if( px + srcArr.SizeX() > sizeX )
        srcX1 =  sizeX - px;
    if( py + srcArr.SizeY() > sizeY )
        srcY1 =  sizeY - py;

    for(int y=0; y < srcY1-srcY0; y++ ) {
        uint32 *dst;
        dst =        rowBuf[ y + dstY0 ] + dstX0;
        for(int x=0; x < srcX1-srcX0; x++ ) {
            *(dst++) = toARGB( srcArr.Get( x + srcX0, y + srcY0 ) );
        }
    }
}

void ArrayARGB::ShrinkClip(int sizeXNew, int sizeYNew, int dstX0, int dstY0, ArrayARGB *dst ) {
   int dstX1, dstY1;
   Point4 *line, *dstLine;
   int y,srcY0,srcY1;
   int xBig,yBig;
   float floorY,ff;

   if(sizeXNew<=0)sizeXNew = 1;
   if(sizeYNew<=0)sizeYNew = 1;

   float scaleX = float(sizeXNew)/float(sizeX);
   float scaleY = float(sizeYNew)/float(sizeY);

   dstX1 = dstX0 + dst->SizeX();
   if( dstX1>sizeXNew )
       dstX1 = sizeXNew;
   dstY1 = dstY0 + dst->SizeY();
   if( dstX1>sizeXNew )
       dstX1 = sizeXNew;

   line =    new Point4[sizeXNew];
   dstLine = new Point4[sizeXNew];
   for( xBig=0; xBig<sizeXNew; xBig++ )
       dstLine[ xBig ].SetZero();

   if( dstY0>0 ) {
       srcY0  = int( float(dstY0-1)/scaleY + 0.5);
       floorY = float( srcY0 )*scaleY;
       yBig = int(floorY);
       floorY -= float( yBig );
   }
   else {
       srcY0 = 0;
       yBig = 0;
       floorY = 0.0;
   }
   srcY1  = int( float(dstY1+1)/scaleY + 0.5 );
   if( srcY1>sizeY )
       srcY1 = sizeY;

   for( y=srcY0; y<srcY1; y++) {
      ShrinkLineClip( y, scaleX, dstX0, dstX1, line);
      ff = floorY + scaleY - 1.0;
      if(ff>0) {  // stepping into new bigPixel reached
         for( xBig=dstX0; xBig<dstX1; xBig++ ) {
            dstLine[ xBig ] += ( scaleY - ff )*line[xBig];
            if( yBig >= dstY0 && yBig < dstY1 )
               dst->Set( xBig-dstX0, yBig-dstY0, dstLine[ xBig ] );
            dstLine[ xBig ] = ff*line[xBig];
         }
         floorY-=1.0;
         ++yBig;
      }
      else
         for( xBig=dstX0; xBig<dstX1; xBig++ )
             dstLine[ xBig ] += scaleY*line[xBig];
      floorY += scaleY;
   }

   delete[] line;
   delete[] dstLine;
}

void ArrayARGB::ShrinkLineClip(int y, float scaleX, int dstX0, int dstX1, Point4 *line) {
   int x,xBig,srcX0,srcX1;
   float floorX = 0.0;  // left border of current smallPixel

   for( xBig=dstX0; xBig<dstX1; xBig++)
      line[xBig].SetZero();;

   if( dstX0>0 ) {
       srcX0  = int( float(dstX0-1)/scaleX + 0.5 );
       floorX = float( srcX0 )*scaleX;
       xBig = int(floorX);
       floorX -= float( xBig );
   }
   else {
       srcX0 = 0;
       xBig = 0;
       floorX = 0.0;
   }
   srcX1  = int( float( dstX1+1 )/scaleX + 0.5 );
   if( srcX1 > sizeX )
       srcX1 = sizeX;

   for( x=srcX0; x<srcX1; x++ ) {
      float ff = floorX + scaleX - 1.0;
      if(ff>0) {  // stepping into new bigPixel reached
         line[xBig] += ( scaleX - ff )*Get(x,y);
         ++xBig;
         floorX-=1.0;
         line[xBig] += ff*Get(x,y);
      }
      else
         line[xBig] += scaleX*Get(x,y);
      floorX += scaleX;
   }
}

// Copy (sizeX,sizeY)-Array out of *this beginning at (srcX,srcY)
// if parts of dstArray are outside, fill them with border-values of *this
void ArrayARGB::CopyToArray(BasicArray< Point4 > *dstArr, int srcX,int srcY) {
   int x,y,sx,sy;
   Point4 *dst;
   int srcSizeX = SizeX();
   int srcSizeY = SizeY();

   y=0;sy=srcY;
   dst = dstArr->Buffer();
   // while dst outside: copy pixels of src-line 0
   while(sy<=0 && y < dstArr->SizeY()) {
      x=0;sx=srcX;
      // while dst outside: write src-edge-pixel
      while( sx<0 && x < dstArr->SizeX() ) {
         *(dst++) = Get( 0, 0);      x++; sx++;
      }
      // copy pixels of src-line 0
      while( sx < srcSizeX- 1 && x < dstArr->SizeX() ) {
         *(dst++) = Get( sx, 0 );  x++; sx++;
      }
      // while dst outside: write src-edge-pixel
      while( x < dstArr->SizeX() ) {
         *(dst++) = Get( srcSizeX-1, 0 );      x++; sx++;
      }
      y++;sy++;
   }

   while(sy < srcSizeY - 1 && y < dstArr->SizeY() ) {
      x=0;sx=srcX;
      // while dst outside: write src-border-pixel
      while( sx<0 && x < dstArr->SizeX() ) {
         *(dst++) = Get( 0, sy);      x++; sx++;
      }
      // copy pixels normally
      while( sx < srcSizeX - 1 && x < dstArr->SizeX() ) {
         *(dst++) = Get( sx, sy );  x++; sx++;
      }
      // while dst outside: write src-border-pixel
      while( x < dstArr->SizeX() ) {
         *(dst++) = Get( srcSizeX-1, sy );      x++; sx++;
      }
      y++;sy++;
   }

   // for outside-parts: copy pixels of last src-line
   while( y < dstArr->SizeY() ) {
      x=0;sx=srcX;
      // while dst outside: write src-edge-pixel
      while( sx<0 && x < dstArr->SizeX() ) {
         *(dst++) = Get( 0, srcSizeY-1 );      x++; sx++;
      }
      // copy pixels of last src-line
      while( sx < srcSizeX - 1 && x < dstArr->SizeX() ) {
         *(dst++) = Get( sx, srcSizeY-1 );  x++; sx++;
      }
      // while dst outside: write src-edge-pixel
      while( x < dstArr->SizeX() ) {
         *(dst++) = Get( srcSizeX-1, srcSizeY-1 );      x++; sx++;
      }
      y++;sy++;
   }
}
*/
