/*
Software License :

Copyright (c) 2007-2009, The Open Effects Association Ltd. All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.
* Neither the name The Open Effects Association Ltd, nor the names of its 
contributors may be used to endorse or promote products derived from this
software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

// ofx host

// ofx
#include "ofxCore.h"
#include "ofxImageEffect.h"

// ofx host
#include "ofxhMemory.h"

namespace OFX {

  namespace Host {

    namespace Memory {

      Instance::Instance() : _ptr(NULL), _locked(0) {}

      Instance::~Instance() {
        delete [] _ptr;
      }

      bool Instance::alloc(size_t nBytes) {
        if(!_locked){
          if(_ptr)
            freeMem(); // ignore return value
          _ptr = new char[nBytes];
          return true;
        }
        else
          return false;
      }

      OfxImageMemoryHandle Instance::getHandle(){
        return (OfxImageMemoryHandle)this;
      }

      bool Instance::freeMem(){
        delete [] _ptr;
        _ptr = 0;
        _locked = 0;
        return true;
      }

      void* Instance::getPtr() {
        return _ptr;
      }

      void Instance::lock() {
        ++_locked;
      }

      void Instance::unlock() {
        if (_locked > 0) {
          --_locked;
        }
      }

    } // Memory

  } // Host

} // OFX

