/* SPDX-License-Identifier: MIT */
/**
	@file		ntv2devicefeatures.hpp
	@brief		Contains implementations of NTV2DeviceCanDo... and NTV2DeviceGetNum... functions.
				This module is included at compile time from 'ntv2devicefeatures.cpp'.
	@copyright	(C) 2004-2021 AJA Video Systems, Inc.
	@note		Generated by './ajalibraries/ajantv2/sdkgen/ntv2sdkgen.py' on Tue Dec 21 15:45:39 2021.
**/

#include "ntv2publicinterface.h"
#include "ntv2enums.h"


/**
	NTV2DeviceCanChangeEmbeddedAudioClock
**/
bool NTV2DeviceCanChangeEmbeddedAudioClock (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_NOTFOUND:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanChangeEmbeddedAudioClock (auto-generated)


/**
	NTV2DeviceCanChangeFrameBufferSize
	True if the device having the given ID does not have fixed frame buffer sizes.
**/
bool NTV2DeviceCanChangeFrameBufferSize (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_NOTFOUND:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanChangeFrameBufferSize (auto-generated)


/**
	NTV2DeviceCanDisableUFC
	True if the device having the given ID has at least one UFC, and it can be disabled.
**/
bool NTV2DeviceCanDisableUFC (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_KONA3G:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDisableUFC (auto-generated)


/**
	NTV2DeviceCanDo12gRouting
	True if the device having the given ID supports 12g routing crosspoints.
**/
bool NTV2DeviceCanDo12gRouting (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDo12gRouting (auto-generated)


/**
	NTV2DeviceCanDo12GSDI
	True if the device supports 12G SDI
**/
bool NTV2DeviceCanDo12GSDI (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDo12GSDI (auto-generated)


/**
	NTV2DeviceCanDo2110
	True if the device supports SMPTE 2110
**/
bool NTV2DeviceCanDo2110 (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDo2110 (auto-generated)


/**
	NTV2DeviceCanDo2KVideo
	True if the device having the given ID is capable of handling 2Kx1556 video.
**/
bool NTV2DeviceCanDo2KVideo (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDo2KVideo (auto-generated)


/**
	NTV2DeviceCanDo3GLevelConversion
	True if the device having the given ID can perform 3G level B to 3G level A conversion.
**/
bool NTV2DeviceCanDo3GLevelConversion (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDo3GLevelConversion (auto-generated)


/**
	NTV2DeviceCanDo425Mux
	True if the device having the given ID supports SMPTE 425 mux control.
**/
bool NTV2DeviceCanDo425Mux (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDo425Mux (auto-generated)


/**
	NTV2DeviceCanDo4KVideo
	True if the device having the given ID can handle 4K/UHD video.
**/
bool NTV2DeviceCanDo4KVideo (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDo4KVideo (auto-generated)


/**
	NTV2DeviceCanDo8KVideo
	True if the device having the given ID can handle 8K/UHD2 video.
**/
bool NTV2DeviceCanDo8KVideo (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDo8KVideo (auto-generated)


/**
	NTV2DeviceCanDoAESAudioIn
	True if the device having the given ID has at least one AES/EBU audio input.
**/
bool NTV2DeviceCanDoAESAudioIn (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoAESAudioIn (auto-generated)


/**
	NTV2DeviceCanDoAnalogAudio
	True if the device having the given ID has at least one analog audio input or output.
**/
bool NTV2DeviceCanDoAnalogAudio (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoAnalogAudio (auto-generated)


/**
	NTV2DeviceCanDoAnalogVideoIn
	True if the device having the given ID has at least one analog video input.
**/
bool NTV2DeviceCanDoAnalogVideoIn (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoAnalogVideoIn (auto-generated)


/**
	NTV2DeviceCanDoAnalogVideoOut
	True if the device having the given ID has at least one analog video output.
**/
bool NTV2DeviceCanDoAnalogVideoOut (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoAnalogVideoOut (auto-generated)


/**
	NTV2DeviceCanDoAudio192K
	True if audio system(s) on the device having the given ID can be set to a 192kHz sample rate.
**/
bool NTV2DeviceCanDoAudio192K (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoAudio192K (auto-generated)


/**
	NTV2DeviceCanDoAudio2Channels
	True if the audio system(s) on the device having the given ID can be configured to embed/de-embed only 2 audio channels.
**/
bool NTV2DeviceCanDoAudio2Channels (const NTV2DeviceID inDeviceID)
{
	(void) inDeviceID;

	return false;

}	//  NTV2DeviceCanDoAudio2Channels (auto-generated)


/**
	NTV2DeviceCanDoAudio6Channels
	True if the audio system(s) on the device having the given ID can be configured to embed/de-embed only 6 audio channels.
**/
bool NTV2DeviceCanDoAudio6Channels (const NTV2DeviceID inDeviceID)
{
	(void) inDeviceID;

	return false;

}	//  NTV2DeviceCanDoAudio6Channels (auto-generated)


/**
	NTV2DeviceCanDoAudio8Channels
	True if the audio system(s) on the device having the given ID can be configured to embed/de-embed only 8 audio channels.
**/
bool NTV2DeviceCanDoAudio8Channels (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_NOTFOUND:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoAudio8Channels (auto-generated)


/**
	NTV2DeviceCanDoAudio96K
	True if audio system(s) on the device having the given ID can be set to a 96kHz sample rate.
**/
bool NTV2DeviceCanDoAudio96K (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_TTAP:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoAudio96K (auto-generated)


/**
	NTV2DeviceCanDoAudioDelay
	True if audio system(s) on the device having the given ID have an adjustable delay.
**/
bool NTV2DeviceCanDoAudioDelay (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoAudioDelay (auto-generated)


/**
	NTV2DeviceCanDoAudioMixer
	True if the device supports an audio mixer (firmware dependent).
**/
bool NTV2DeviceCanDoAudioMixer (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA5:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoAudioMixer (auto-generated)


/**
	NTV2DeviceCanDoBreakoutBox
	True if the device having the given ID can be connected to an AJA breakout box.
**/
bool NTV2DeviceCanDoBreakoutBox (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoBreakoutBox (auto-generated)


/**
	NTV2DeviceCanDoCapture
	True if the device having the given ID can capture (ingest) video.
**/
bool NTV2DeviceCanDoCapture (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoCapture (auto-generated)


/**
	NTV2DeviceCanDoCustomAnc
	True if the device having the given ID supports ANC insertion/extraction.
**/
bool NTV2DeviceCanDoCustomAnc (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoCustomAnc (auto-generated)


/**
	NTV2DeviceCanDoDSKOpacity
	True if the device having the given ID has a mixer/keyer whose opacity is adjustable.
**/
bool NTV2DeviceCanDoDSKOpacity (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoDSKOpacity (auto-generated)


/**
	NTV2DeviceCanDoDualLink
	True if the device having the given ID can input/output 10-bit RGB over 2-wire SDI.
**/
bool NTV2DeviceCanDoDualLink (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoDualLink (auto-generated)


/**
	NTV2DeviceCanDoDVCProHD
	True if the device having the given ID can squeeze/stretch between 1920x1080/1280x1080 and 1280x720/960x720.
**/
bool NTV2DeviceCanDoDVCProHD (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_TTAP:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoDVCProHD (auto-generated)


/**
	NTV2DeviceCanDoEnhancedCSC
	True if the device having the given ID has enhanced color space converter capability.
**/
bool NTV2DeviceCanDoEnhancedCSC (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoEnhancedCSC (auto-generated)


/**
	NTV2DeviceCanDoFramePulseSelect
	True if the device supports frame pulse source independent of reference source
**/
bool NTV2DeviceCanDoFramePulseSelect (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_IO4KPLUS:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoFramePulseSelect (auto-generated)


/**
	NTV2DeviceCanDoFrameStore1Display
**/
bool NTV2DeviceCanDoFrameStore1Display (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_NOTFOUND:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoFrameStore1Display (auto-generated)


/**
	NTV2DeviceCanDoHDMIHDROut
	True if the device having the given ID supports HDMI HDR output.
**/
bool NTV2DeviceCanDoHDMIHDROut (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoHDMIHDROut (auto-generated)


/**
	NTV2DeviceCanDoHDMIMultiView
	True if the device can rasterize 4 HD signals into a single HDMI output
**/
bool NTV2DeviceCanDoHDMIMultiView (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_IOX3:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_SOJI_3DLUT:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoHDMIMultiView (auto-generated)


/**
	NTV2DeviceCanDoHDMIOutStereo
	True if the device having the given ID can handle 3D-stereo video output over HDMI.
**/
bool NTV2DeviceCanDoHDMIOutStereo (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoHDMIOutStereo (auto-generated)


/**
	NTV2DeviceCanDoHDV
	True if the device having the given ID can squeeze/stretch between 1920x1080 and 1440x1080.
**/
bool NTV2DeviceCanDoHDV (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_TTAP:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoHDV (auto-generated)


/**
	NTV2DeviceCanDoHDVideo
	True if the device having the given ID can handle HD (High Definition) video.
**/
bool NTV2DeviceCanDoHDVideo (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_NOTFOUND:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoHDVideo (auto-generated)


/**
	NTV2DeviceCanDoHFRRGB
	True if the device supports 1080p > 50 RGB rates
**/
bool NTV2DeviceCanDoHFRRGB (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoHFRRGB (auto-generated)


/**
	NTV2DeviceCanDoIP
	True if the device having the given ID ingests and/or plays video via TCP/IP (instead of SDI/HDMI/etc).
**/
bool NTV2DeviceCanDoIP (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoIP (auto-generated)


/**
	NTV2DeviceCanDoIsoConvert
**/
bool NTV2DeviceCanDoIsoConvert (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoIsoConvert (auto-generated)


/**
	NTV2DeviceCanDoJ2K
	True if the device supports the JPEG 2000 codec
**/
bool NTV2DeviceCanDoJ2K (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoJ2K (auto-generated)


/**
	NTV2DeviceCanDoLTC
	True if the device having the given ID can take in LTC (Linear TimeCode) from one of its inputs.
**/
bool NTV2DeviceCanDoLTC (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoLTC (auto-generated)


/**
	NTV2DeviceCanDoLTCInOnRefPort
	True if the device having the given ID can read LTC (Linear TimeCode) from its reference input.
**/
bool NTV2DeviceCanDoLTCInOnRefPort (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoLTCInOnRefPort (auto-generated)


/**
	NTV2DeviceCanDoMSI
	True if the DMA hardware on the device having the given ID supports MSI (Message Signaled Interrupts).
**/
bool NTV2DeviceCanDoMSI (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoMSI (auto-generated)


/**
	NTV2DeviceCanDoMultiFormat
	True if the device having the given ID can simultaneously handle different video formats on more than one SDI input or output.
**/
bool NTV2DeviceCanDoMultiFormat (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoMultiFormat (auto-generated)


/**
	NTV2DeviceCanDoMultiLinkAudio
	True if the device supports grouped audio system control
**/
bool NTV2DeviceCanDoMultiLinkAudio (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_SOJI_3DLUT:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoMultiLinkAudio (auto-generated)


/**
	NTV2DeviceCanDoPCMControl
	True if the audio system(s) on the device having the given ID can set the per-audio-channel-pair non-PCM (Pulse Code Modulation) bits in outgoing embedded audio.
**/
bool NTV2DeviceCanDoPCMControl (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoPCMControl (auto-generated)


/**
	NTV2DeviceCanDoPCMDetection
	True if the device having the given ID has per-audio-channel-pair PCM detection capabilities.
**/
bool NTV2DeviceCanDoPCMDetection (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoPCMDetection (auto-generated)


/**
	NTV2DeviceCanDoPIO
	True if the device having the given ID supports Programmed I/O.
**/
bool NTV2DeviceCanDoPIO (const NTV2DeviceID inDeviceID)
{
	(void) inDeviceID;

	return false;

}	//  NTV2DeviceCanDoPIO (auto-generated)


/**
	NTV2DeviceCanDoPlayback
	True if the device having the given ID can output (play) video.
**/
bool NTV2DeviceCanDoPlayback (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_NOTFOUND:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoPlayback (auto-generated)


/**
	NTV2DeviceCanDoProgrammableRS422
	True if the device having the given ID has at least one RS-422 serial port, and it (they) can be programmed (for baud rate, parity, etc.).
**/
bool NTV2DeviceCanDoProgrammableRS422 (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoProgrammableRS422 (auto-generated)


/**
	NTV2DeviceCanDoProRes
	True if the device having the given ID can can accommodate Apple ProRes-compressed video in its frame buffers.
**/
bool NTV2DeviceCanDoProRes (const NTV2DeviceID inDeviceID)
{
	(void) inDeviceID;

	return false;

}	//  NTV2DeviceCanDoProRes (auto-generated)


/**
	NTV2DeviceCanDoQREZ
**/
bool NTV2DeviceCanDoQREZ (const NTV2DeviceID inDeviceID)
{
	(void) inDeviceID;

	return false;

}	//  NTV2DeviceCanDoQREZ (auto-generated)


/**
	NTV2DeviceCanDoQuarterExpand
	True if the device having the given ID can handle quarter-sized frames (pixel-halving and line-halving during input, pixel-double and line-double during output).
**/
bool NTV2DeviceCanDoQuarterExpand (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_NOTFOUND:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoQuarterExpand (auto-generated)


/**
	NTV2DeviceCanDoRateConvert
	True if the device having the given ID can do frame rate conversion.
**/
bool NTV2DeviceCanDoRateConvert (const NTV2DeviceID inDeviceID)
{
	(void) inDeviceID;

	return false;

}	//  NTV2DeviceCanDoRateConvert (auto-generated)


/**
	NTV2DeviceCanDoRGBLevelAConversion
	True if the device having the given ID can do RGB over 3G Level A.
**/
bool NTV2DeviceCanDoRGBLevelAConversion (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoRGBLevelAConversion (auto-generated)


/**
	NTV2DeviceCanDoRGBPlusAlphaOut
	True if the device with the given ID has CSCs capable of splitting the key (alpha) and YCbCr (fill) from RGB frame buffers that include alpha. Has nothing to do with RGB wire formats.
**/
bool NTV2DeviceCanDoRGBPlusAlphaOut (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoRGBPlusAlphaOut (auto-generated)


/**
	NTV2DeviceCanDoRP188
	True if the device having the given ID can insert and/or extract RP-188/VITC.
**/
bool NTV2DeviceCanDoRP188 (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_NOTFOUND:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoRP188 (auto-generated)


/**
	NTV2DeviceCanDoSDIErrorChecks
	True if the device having the given ID can perform SDI error checking.
**/
bool NTV2DeviceCanDoSDIErrorChecks (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8K_MV_TX:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoSDIErrorChecks (auto-generated)


/**
	NTV2DeviceCanDoSDVideo
	True if the device having the given ID can handle SD (Standard Definition) video.
**/
bool NTV2DeviceCanDoSDVideo (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_NOTFOUND:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoSDVideo (auto-generated)


/**
	NTV2DeviceCanDoStackedAudio
	True if the device having the given ID uses a 'stacked' arrangement of its audio buffers.
**/
bool NTV2DeviceCanDoStackedAudio (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoStackedAudio (auto-generated)


/**
	NTV2DeviceCanDoStereoIn
	True if the device having the given ID supports 3D video input over dual-stream SDI.
**/
bool NTV2DeviceCanDoStereoIn (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_4CH_2SFP:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoStereoIn (auto-generated)


/**
	NTV2DeviceCanDoStereoOut
	True if the device having the given ID supports 3D video output over dual-stream SDI.
**/
bool NTV2DeviceCanDoStereoOut (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_4CH_2SFP:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoStereoOut (auto-generated)


/**
	NTV2DeviceCanDoThunderbolt
	True if the device having the given ID connects to the host using a Thunderbolt cable.
**/
bool NTV2DeviceCanDoThunderbolt (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_TTAP:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoThunderbolt (auto-generated)


/**
	NTV2DeviceCanDoVideoProcessing
**/
bool NTV2DeviceCanDoVideoProcessing (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoVideoProcessing (auto-generated)


/**
	NTV2DeviceCanDoVITC2
	True if the device having the given ID can insert and/or extract RP-188/VITC2.
**/
bool NTV2DeviceCanDoVITC2 (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoVITC2 (auto-generated)


/**
	NTV2DeviceCanDoWarmBootFPGA
	True if the device is capable of doing a warm boot rather than power cycling after firmware update.
**/
bool NTV2DeviceCanDoWarmBootFPGA (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanDoWarmBootFPGA (auto-generated)


/**
	NTV2DeviceCanMeasureTemperature
	True if the device having the given ID can measure its temperature.
**/
bool NTV2DeviceCanMeasureTemperature (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanMeasureTemperature (auto-generated)


/**
	NTV2DeviceCanReportFailSafeLoaded
	True if the device having the given ID can report if its "fail-safe" firmware is loaded and running.
**/
bool NTV2DeviceCanReportFailSafeLoaded (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanReportFailSafeLoaded (auto-generated)


/**
	NTV2DeviceCanReportFrameSize
**/
bool NTV2DeviceCanReportFrameSize (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanReportFrameSize (auto-generated)


/**
	NTV2DeviceCanReportRunningFirmwareDate
	True if the device having the given ID can report its running (and not necessarily installed) firmware date.
**/
bool NTV2DeviceCanReportRunningFirmwareDate (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanReportRunningFirmwareDate (auto-generated)


/**
	NTV2DeviceCanThermostat
	True if the fan on the device having the given ID can be thermostatically controlled.
**/
bool NTV2DeviceCanThermostat (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_KONA1:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceCanThermostat (auto-generated)


/**
	NTV2DeviceHasAudioMonitorRCAJacks
	True if the device having the given ID has a pair of unbalanced RCA audio monitor output jacks.
**/
bool NTV2DeviceHasAudioMonitorRCAJacks (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_KONA5:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceHasAudioMonitorRCAJacks (auto-generated)


/**
	NTV2DeviceHasBiDirectionalAnalogAudio
	True if the device having the given ID has a bi-directional analog audio connector.
**/
bool NTV2DeviceHasBiDirectionalAnalogAudio (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOX3:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceHasBiDirectionalAnalogAudio (auto-generated)


/**
	NTV2DeviceHasBiDirectionalSDI
	True if the SDI connectors on the device having the given ID are bi-directional.
**/
bool NTV2DeviceHasBiDirectionalSDI (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceHasBiDirectionalSDI (auto-generated)


/**
	NTV2DeviceHasColorSpaceConverterOnChannel2
**/
bool NTV2DeviceHasColorSpaceConverterOnChannel2 (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceHasColorSpaceConverterOnChannel2 (auto-generated)


/**
	NTV2DeviceHasGenlockv2
**/
bool NTV2DeviceHasGenlockv2 (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceHasGenlockv2 (auto-generated)


/**
	NTV2DeviceHasGenlockv3
**/
bool NTV2DeviceHasGenlockv3 (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceHasGenlockv3 (auto-generated)


/**
	NTV2DeviceHasHeadphoneJack
	True if the device having the given ID has a headphone jack.
**/
bool NTV2DeviceHasHeadphoneJack (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceHasHeadphoneJack (auto-generated)


/**
	NTV2DeviceHasHEVCM30
	True if the device having the given ID has an HEVC M30 encoder/decoder.
**/
bool NTV2DeviceHasHEVCM30 (const NTV2DeviceID inDeviceID)
{
	(void) inDeviceID;

	return false;

}	//  NTV2DeviceHasHEVCM30 (auto-generated)


/**
	NTV2DeviceHasHEVCM31
	True if the device having the given ID has an HEVC M31 encoder.
**/
bool NTV2DeviceHasHEVCM31 (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVIDHEVC:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceHasHEVCM31 (auto-generated)


/**
	NTV2DeviceHasLEDAudioMeters
	True if the device having the given ID has LED audio meters.
**/
bool NTV2DeviceHasLEDAudioMeters (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceHasLEDAudioMeters (auto-generated)


/**
	NTV2DeviceHasNWL
	True if the device having the given ID has NorthWest Logic DMA hardware.
**/
bool NTV2DeviceHasNWL (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_TTAP:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceHasNWL (auto-generated)


/**
	NTV2DeviceHasPCIeGen2
	True if the device having the given ID supports 2nd-generation PCIe.
**/
bool NTV2DeviceHasPCIeGen2 (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_TTAP:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceHasPCIeGen2 (auto-generated)


/**
	NTV2DeviceHasRetailSupport
	True if the device can be configured and controlled by the retail services and AJA Control Panel.
**/
bool NTV2DeviceHasRetailSupport (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceHasRetailSupport (auto-generated)


/**
	NTV2DeviceHasRotaryEncoder
	True if the device having the given ID supports rotary encoder volume control
**/
bool NTV2DeviceHasRotaryEncoder (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceHasRotaryEncoder (auto-generated)


/**
	NTV2DeviceHasSDIRelays
	True if the device having the given ID has bypass relays on its SDI connectors.
**/
bool NTV2DeviceHasSDIRelays (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID24:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceHasSDIRelays (auto-generated)


/**
	NTV2DeviceHasSPIFlash
**/
bool NTV2DeviceHasSPIFlash (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_NOTFOUND:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceHasSPIFlash (auto-generated)


/**
	NTV2DeviceHasSPIFlashSerial
**/
bool NTV2DeviceHasSPIFlashSerial (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceHasSPIFlashSerial (auto-generated)


/**
	NTV2DeviceHasSPIv2
	True if the device having the given ID uses version 2 SPI hardware.
**/
bool NTV2DeviceHasSPIv2 (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_TTAP:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceHasSPIv2 (auto-generated)


/**
	NTV2DeviceHasSPIv3
	True if the device having the given ID uses version 3 SPI hardware.
**/
bool NTV2DeviceHasSPIv3 (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceHasSPIv3 (auto-generated)


/**
	NTV2DeviceHasSPIv4
	True if the device having the given ID uses version 4 SPI hardware.
**/
bool NTV2DeviceHasSPIv4 (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceHasSPIv4 (auto-generated)


/**
	NTV2DeviceHasSPIv5
	True if the device having the given ID uses version 5 SPI hardware.
**/
bool NTV2DeviceHasSPIv5 (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceHasSPIv5 (auto-generated)


/**
	NTV2DeviceHasXilinxDMA
	True if the device has Xilinx DMA engine
**/
bool NTV2DeviceHasXilinxDMA (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceHasXilinxDMA (auto-generated)


/**
	NTV2DeviceIs64Bit
**/
bool NTV2DeviceIs64Bit (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_NOTFOUND:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceIs64Bit (auto-generated)


/**
	NTV2DeviceIsDirectAddressable
**/
bool NTV2DeviceIsDirectAddressable (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_NOTFOUND:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceIsDirectAddressable (auto-generated)


/**
	NTV2DeviceIsExternalToHost
	True if the device having the given ID connects to the host with a cable.
**/
bool NTV2DeviceIsExternalToHost (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_TTAP:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceIsExternalToHost (auto-generated)


/**
	NTV2DeviceIsSupported
	True if the device having the given ID is supported by this SDK.
**/
bool NTV2DeviceIsSupported (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_NOTFOUND:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceIsSupported (auto-generated)


/**
	NTV2DeviceNeedsRoutingSetup
	True if the routing for the device having the given ID can be queried and/or changed.
**/
bool NTV2DeviceNeedsRoutingSetup (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_NOTFOUND:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceNeedsRoutingSetup (auto-generated)


/**
	NTV2DeviceSoftwareCanChangeFrameBufferSize
**/
bool NTV2DeviceSoftwareCanChangeFrameBufferSize (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP_PRO:
			return true;
	#if defined(_DEBUG)
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
	#else
		default:
	#endif
			break;
	}	//	switch on inDeviceID

	return false;

}	//  NTV2DeviceSoftwareCanChangeFrameBufferSize (auto-generated)


/**
	NTV2DeviceGetActiveMemorySize
	Returns the size, in bytes, of the device's active RAM available for video and audio.
**/
ULWord NTV2DeviceGetActiveMemorySize (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID1:		return 0x10000000;
		case DEVICE_ID_CORVID22:	return 0x20000000;
		case DEVICE_ID_CORVID24:	return 0x20000000;
		case DEVICE_ID_CORVID3G:	return 0x10000000;
		case DEVICE_ID_CORVID44:	return 0x40000000;
		case DEVICE_ID_CORVID44_2X4K:	return 0xF8000000;
		case DEVICE_ID_CORVID44_8K:	return 0xF8000000;
		case DEVICE_ID_CORVID44_8KMK:	return 0xF8000000;
		case DEVICE_ID_CORVID44_PLNR:	return 0xF8000000;
		case DEVICE_ID_CORVID88:	return 0x40000000;
		case DEVICE_ID_CORVIDHBR:	return 0x20000000;
		case DEVICE_ID_CORVIDHEVC:	return 0x40000000;
		case DEVICE_ID_IO4K:		return 0x37800000;
		case DEVICE_ID_IO4KPLUS:	return 0x80000000;
		case DEVICE_ID_IO4KUFC:		return 0x37800000;
		case DEVICE_ID_IOEXPRESS:	return 0x10000000;
		case DEVICE_ID_IOIP_2022:	return 0x80000000;
		case DEVICE_ID_IOIP_2110:	return 0x80000000;
		case DEVICE_ID_IOIP_2110_RGB12:	return 0x80000000;
		case DEVICE_ID_IOX3:		return 0x40000000;
		case DEVICE_ID_IOXT:		return 0xC000000;
		case DEVICE_ID_KONA1:		return 0x40000000;
		case DEVICE_ID_KONA3G:		return 0x20000000;
		case DEVICE_ID_KONA3GQUAD:	return 0x20000000;
		case DEVICE_ID_KONA4:		return 0x37800000;
		case DEVICE_ID_KONA4UFC:	return 0x37800000;
		case DEVICE_ID_KONA5:		return 0x80000000;
		case DEVICE_ID_KONA5_2X4K:	return 0xF8000000;
		case DEVICE_ID_KONA5_3DLUT:	return 0xF8000000;
		case DEVICE_ID_KONA5_8K:	return 0xF8000000;
		case DEVICE_ID_KONA5_8KMK:	return 0xF8000000;
		case DEVICE_ID_KONA5_8K_MV_TX:	return 0xF8000000;
		case DEVICE_ID_KONA5_OE1:	return 0xF8000000;
		case DEVICE_ID_KONA5_OE10:	return 0xF8000000;
		case DEVICE_ID_KONA5_OE11:	return 0xF8000000;
		case DEVICE_ID_KONA5_OE12:	return 0xF8000000;
		case DEVICE_ID_KONA5_OE2:	return 0xF8000000;
		case DEVICE_ID_KONA5_OE3:	return 0xF8000000;
		case DEVICE_ID_KONA5_OE4:	return 0xF8000000;
		case DEVICE_ID_KONA5_OE5:	return 0xF8000000;
		case DEVICE_ID_KONA5_OE6:	return 0xF8000000;
		case DEVICE_ID_KONA5_OE7:	return 0xF8000000;
		case DEVICE_ID_KONA5_OE8:	return 0xF8000000;
		case DEVICE_ID_KONA5_OE9:	return 0xF8000000;
		case DEVICE_ID_KONAHDMI:	return 0x80000000;
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:	return 0x37800000;
		case DEVICE_ID_KONAIP_1RX_1TX_2110:	return 0x37800000;
		case DEVICE_ID_KONAIP_2022:	return 0x37800000;
		case DEVICE_ID_KONAIP_2110:	return 0x37800000;
		case DEVICE_ID_KONAIP_2110_RGB12:	return 0x37800000;
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:	return 0x37800000;
		case DEVICE_ID_KONAIP_4CH_2SFP:	return 0x37800000;
		case DEVICE_ID_KONALHEPLUS:	return 0x10000000;
		case DEVICE_ID_KONALHI:		return 0x10000000;
		case DEVICE_ID_KONALHIDVI:	return 0x10000000;
		case DEVICE_ID_SOJI_3DLUT:	return 0xF8000000;
		case DEVICE_ID_SOJI_OE1:	return 0xF8000000;
		case DEVICE_ID_SOJI_OE2:	return 0xF8000000;
		case DEVICE_ID_SOJI_OE3:	return 0xF8000000;
		case DEVICE_ID_SOJI_OE4:	return 0xF8000000;
		case DEVICE_ID_SOJI_OE5:	return 0xF8000000;
		case DEVICE_ID_SOJI_OE6:	return 0xF8000000;
		case DEVICE_ID_SOJI_OE7:	return 0xF8000000;
		case DEVICE_ID_TTAP:		return 0x08000000;
		case DEVICE_ID_TTAP_PRO:	return 0x40000000;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_NOTFOUND:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetActiveMemorySize (auto-generated)


/**
	NTV2DeviceGetDACVersion
	Returns the version number of the DAC on the device having the given ID.
**/
UWord NTV2DeviceGetDACVersion (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_IOEXPRESS:	return 2;
		case DEVICE_ID_IOXT:		return 2;
		case DEVICE_ID_KONA3G:		return 2;
		case DEVICE_ID_KONA3GQUAD:	return 2;
		case DEVICE_ID_KONA4:		return 2;
		case DEVICE_ID_KONA4UFC:	return 2;
		case DEVICE_ID_KONALHEPLUS:	return 2;
		case DEVICE_ID_KONALHI:		return 2;
		case DEVICE_ID_KONALHIDVI:	return 2;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetDACVersion (auto-generated)


/**
	NTV2DeviceGetDownConverterDelay
	Returns the down-converter delay on the device having the given ID.
**/
UWord NTV2DeviceGetDownConverterDelay (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_IO4KUFC:		return 1;
		case DEVICE_ID_IOXT:		return 1;
		case DEVICE_ID_KONA3G:		return 1;
		case DEVICE_ID_KONA4UFC:	return 1;
		case DEVICE_ID_KONALHEPLUS:	return 1;
		case DEVICE_ID_KONALHI:		return 1;
		case DEVICE_ID_KONALHIDVI:	return 1;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetDownConverterDelay (auto-generated)


/**
	NTV2DeviceGetHDMIVersion
	Returns the version number of the HDMI input or output hardware on the device having the given ID.
**/
ULWord NTV2DeviceGetHDMIVersion (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID44_2X4K:	return 0;
		case DEVICE_ID_CORVIDHBR:	return 2;
		case DEVICE_ID_IO4K:		return 2;
		case DEVICE_ID_IO4KPLUS:	return 4;
		case DEVICE_ID_IO4KUFC:		return 3;
		case DEVICE_ID_IOEXPRESS:	return 1;
		case DEVICE_ID_IOIP_2022:	return 4;
		case DEVICE_ID_IOIP_2110:	return 4;
		case DEVICE_ID_IOIP_2110_RGB12:	return 4;
		case DEVICE_ID_IOX3:		return 2;
		case DEVICE_ID_IOXT:		return 1;
		case DEVICE_ID_KONA3G:		return 1;
		case DEVICE_ID_KONA3GQUAD:	return 1;
		case DEVICE_ID_KONA4:		return 2;
		case DEVICE_ID_KONA4UFC:	return 3;
		case DEVICE_ID_KONA5:		return 4;
		case DEVICE_ID_KONA5_2X4K:	return 4;
		case DEVICE_ID_KONA5_3DLUT:	return 4;
		case DEVICE_ID_KONA5_8K:	return 4;
		case DEVICE_ID_KONA5_8KMK:	return 4;
		case DEVICE_ID_KONA5_8K_MV_TX:	return 4;
		case DEVICE_ID_KONA5_OE1:	return 4;
		case DEVICE_ID_KONA5_OE10:	return 4;
		case DEVICE_ID_KONA5_OE11:	return 4;
		case DEVICE_ID_KONA5_OE12:	return 4;
		case DEVICE_ID_KONA5_OE2:	return 4;
		case DEVICE_ID_KONA5_OE3:	return 4;
		case DEVICE_ID_KONA5_OE4:	return 4;
		case DEVICE_ID_KONA5_OE5:	return 4;
		case DEVICE_ID_KONA5_OE6:	return 4;
		case DEVICE_ID_KONA5_OE7:	return 4;
		case DEVICE_ID_KONA5_OE8:	return 4;
		case DEVICE_ID_KONA5_OE9:	return 4;
		case DEVICE_ID_KONAHDMI:	return 4;
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:	return 3;
		case DEVICE_ID_KONAIP_1RX_1TX_2110:	return 3;
		case DEVICE_ID_KONAIP_2022:	return 3;
		case DEVICE_ID_KONAIP_2110:	return 2;
		case DEVICE_ID_KONAIP_2110_RGB12:	return 2;
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:	return 3;
		case DEVICE_ID_KONAIP_4CH_2SFP:	return 2;
		case DEVICE_ID_KONALHI:		return 1;
		case DEVICE_ID_KONALHIDVI:	return 1;
		case DEVICE_ID_SOJI_3DLUT:	return 4;
		case DEVICE_ID_SOJI_OE1:	return 4;
		case DEVICE_ID_SOJI_OE2:	return 4;
		case DEVICE_ID_SOJI_OE3:	return 4;
		case DEVICE_ID_SOJI_OE4:	return 4;
		case DEVICE_ID_SOJI_OE5:	return 4;
		case DEVICE_ID_SOJI_OE6:	return 4;
		case DEVICE_ID_SOJI_OE7:	return 4;
		case DEVICE_ID_TTAP:		return 1;
		case DEVICE_ID_TTAP_PRO:	return 4;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_NOTFOUND:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetHDMIVersion (auto-generated)


/**
	NTV2DeviceGetLUTVersion
	Returns the version number of the LUT(s) on the device having the given ID.
**/
ULWord NTV2DeviceGetLUTVersion (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID1:		return 1;
		case DEVICE_ID_CORVID22:	return 1;
		case DEVICE_ID_CORVID24:	return 1;
		case DEVICE_ID_CORVID3G:	return 1;
		case DEVICE_ID_CORVID44:	return 2;
		case DEVICE_ID_CORVID44_2X4K:	return 2;
		case DEVICE_ID_CORVID44_8K:	return 0;
		case DEVICE_ID_CORVID44_8KMK:	return 0;
		case DEVICE_ID_CORVID44_PLNR:	return 0;
		case DEVICE_ID_CORVID88:	return 2;
		case DEVICE_ID_CORVIDHBR:	return 1;
		case DEVICE_ID_IO4K:		return 1;
		case DEVICE_ID_IO4KPLUS:	return 2;
		case DEVICE_ID_IO4KUFC:		return 1;
		case DEVICE_ID_IOEXPRESS:	return 1;
		case DEVICE_ID_IOIP_2022:	return 2;
		case DEVICE_ID_IOIP_2110:	return 2;
		case DEVICE_ID_IOIP_2110_RGB12:	return 2;
		case DEVICE_ID_IOX3:		return 1;
		case DEVICE_ID_IOXT:		return 1;
		case DEVICE_ID_KONA1:		return 2;
		case DEVICE_ID_KONA3G:		return 1;
		case DEVICE_ID_KONA3GQUAD:	return 1;
		case DEVICE_ID_KONA4:		return 1;
		case DEVICE_ID_KONA4UFC:	return 1;
		case DEVICE_ID_KONA5:		return 2;
		case DEVICE_ID_KONA5_2X4K:	return 2;
		case DEVICE_ID_KONA5_3DLUT:	return 2;
		case DEVICE_ID_KONA5_8K:	return 2;
		case DEVICE_ID_KONA5_8KMK:	return 2;
		case DEVICE_ID_KONA5_8K_MV_TX:	return 2;
		case DEVICE_ID_KONA5_OE1:	return 2;
		case DEVICE_ID_KONA5_OE10:	return 2;
		case DEVICE_ID_KONA5_OE11:	return 2;
		case DEVICE_ID_KONA5_OE12:	return 2;
		case DEVICE_ID_KONA5_OE2:	return 2;
		case DEVICE_ID_KONA5_OE3:	return 2;
		case DEVICE_ID_KONA5_OE4:	return 2;
		case DEVICE_ID_KONA5_OE5:	return 2;
		case DEVICE_ID_KONA5_OE6:	return 2;
		case DEVICE_ID_KONA5_OE7:	return 2;
		case DEVICE_ID_KONA5_OE8:	return 2;
		case DEVICE_ID_KONA5_OE9:	return 2;
		case DEVICE_ID_KONAHDMI:	return 2;
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:	return 1;
		case DEVICE_ID_KONAIP_1RX_1TX_2110:	return 1;
		case DEVICE_ID_KONAIP_2022:	return 1;
		case DEVICE_ID_KONAIP_2110:	return 1;
		case DEVICE_ID_KONAIP_2110_RGB12:	return 2;
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:	return 1;
		case DEVICE_ID_KONAIP_4CH_2SFP:	return 1;
		case DEVICE_ID_KONALHEPLUS:	return 1;
		case DEVICE_ID_KONALHI:		return 1;
		case DEVICE_ID_KONALHIDVI:	return 1;
		case DEVICE_ID_SOJI_3DLUT:	return 2;
		case DEVICE_ID_SOJI_OE1:	return 2;
		case DEVICE_ID_SOJI_OE2:	return 2;
		case DEVICE_ID_SOJI_OE3:	return 2;
		case DEVICE_ID_SOJI_OE4:	return 2;
		case DEVICE_ID_SOJI_OE5:	return 2;
		case DEVICE_ID_SOJI_OE6:	return 2;
		case DEVICE_ID_SOJI_OE7:	return 2;
		case DEVICE_ID_TTAP:		return 1;
		case DEVICE_ID_TTAP_PRO:	return 2;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_NOTFOUND:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetLUTVersion (auto-generated)


/**
	NTV2DeviceGetMaxAudioChannels
	Returns the maximum number of audio channels that a single audio system can support on the device having the given ID.
**/
UWord NTV2DeviceGetMaxAudioChannels (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID1:		return 16;
		case DEVICE_ID_CORVID22:	return 16;
		case DEVICE_ID_CORVID24:	return 16;
		case DEVICE_ID_CORVID3G:	return 16;
		case DEVICE_ID_CORVID44:	return 16;
		case DEVICE_ID_CORVID44_2X4K:	return 16;
		case DEVICE_ID_CORVID44_8K:	return 16;
		case DEVICE_ID_CORVID44_8KMK:	return 16;
		case DEVICE_ID_CORVID44_PLNR:	return 16;
		case DEVICE_ID_CORVID88:	return 16;
		case DEVICE_ID_CORVIDHBR:	return 16;
		case DEVICE_ID_CORVIDHEVC:	return 16;
		case DEVICE_ID_IO4K:		return 16;
		case DEVICE_ID_IO4KPLUS:	return 16;
		case DEVICE_ID_IO4KUFC:		return 16;
		case DEVICE_ID_IOEXPRESS:	return 8;
		case DEVICE_ID_IOIP_2022:	return 16;
		case DEVICE_ID_IOIP_2110:	return 16;
		case DEVICE_ID_IOIP_2110_RGB12:	return 16;
		case DEVICE_ID_IOX3:		return 16;
		case DEVICE_ID_IOXT:		return 16;
		case DEVICE_ID_KONA1:		return 16;
		case DEVICE_ID_KONA3G:		return 16;
		case DEVICE_ID_KONA3GQUAD:	return 16;
		case DEVICE_ID_KONA4:		return 16;
		case DEVICE_ID_KONA4UFC:	return 16;
		case DEVICE_ID_KONA5:		return 16;
		case DEVICE_ID_KONA5_2X4K:	return 16;
		case DEVICE_ID_KONA5_3DLUT:	return 16;
		case DEVICE_ID_KONA5_8K:	return 16;
		case DEVICE_ID_KONA5_8KMK:	return 16;
		case DEVICE_ID_KONA5_8K_MV_TX:	return 16;
		case DEVICE_ID_KONA5_OE1:	return 16;
		case DEVICE_ID_KONA5_OE10:	return 16;
		case DEVICE_ID_KONA5_OE11:	return 16;
		case DEVICE_ID_KONA5_OE12:	return 16;
		case DEVICE_ID_KONA5_OE2:	return 16;
		case DEVICE_ID_KONA5_OE3:	return 16;
		case DEVICE_ID_KONA5_OE4:	return 16;
		case DEVICE_ID_KONA5_OE5:	return 16;
		case DEVICE_ID_KONA5_OE6:	return 16;
		case DEVICE_ID_KONA5_OE7:	return 16;
		case DEVICE_ID_KONA5_OE8:	return 16;
		case DEVICE_ID_KONA5_OE9:	return 16;
		case DEVICE_ID_KONAHDMI:	return 16;
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:	return 16;
		case DEVICE_ID_KONAIP_1RX_1TX_2110:	return 16;
		case DEVICE_ID_KONAIP_2022:	return 16;
		case DEVICE_ID_KONAIP_2110:	return 16;
		case DEVICE_ID_KONAIP_2110_RGB12:	return 16;
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:	return 16;
		case DEVICE_ID_KONAIP_4CH_2SFP:	return 16;
		case DEVICE_ID_KONALHEPLUS:	return 8;
		case DEVICE_ID_KONALHI:		return 8;
		case DEVICE_ID_KONALHIDVI:	return 8;
		case DEVICE_ID_SOJI_3DLUT:	return 16;
		case DEVICE_ID_SOJI_OE1:	return 16;
		case DEVICE_ID_SOJI_OE2:	return 16;
		case DEVICE_ID_SOJI_OE3:	return 16;
		case DEVICE_ID_SOJI_OE4:	return 16;
		case DEVICE_ID_SOJI_OE5:	return 16;
		case DEVICE_ID_SOJI_OE6:	return 16;
		case DEVICE_ID_SOJI_OE7:	return 16;
		case DEVICE_ID_TTAP:		return 8;
		case DEVICE_ID_TTAP_PRO:	return 16;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_NOTFOUND:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetMaxAudioChannels (auto-generated)


/**
	NTV2DeviceGetMaxRegisterNumber
	Returns the highest register number for the device having the given ID.
**/
ULWord NTV2DeviceGetMaxRegisterNumber (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID1:		return kRegCS2Coefficients9_10;
		case DEVICE_ID_CORVID22:	return kRegLTC2AnalogBits32_63;
		case DEVICE_ID_CORVID24:	return kRegSDIWatchdogKick2;
		case DEVICE_ID_CORVID3G:	return kRegXptSelectGroup10;
		case DEVICE_ID_CORVID44:	return kRegReserved511;
		case DEVICE_ID_CORVID44_2X4K:	return kRegReserved511;
		case DEVICE_ID_CORVID44_8K:	return kRegReserved511;
		case DEVICE_ID_CORVID44_8KMK:	return kRegReserved511;
		case DEVICE_ID_CORVID44_PLNR:	return kRegReserved511;
		case DEVICE_ID_CORVID88:	return kRegReserved511;
		case DEVICE_ID_CORVIDHBR:	return kRegReserved511;
		case DEVICE_ID_CORVIDHEVC:	return kRegReserved511;
		case DEVICE_ID_IO4K:		return kRegReserved511;
		case DEVICE_ID_IO4KPLUS:	return kRegReserved511;
		case DEVICE_ID_IO4KUFC:		return kRegHDMIV2i2c2Data;
		case DEVICE_ID_IOEXPRESS:	return kRegSDIOut1VPIDB;
		case DEVICE_ID_IOIP_2022:	return kRegReserved511;
		case DEVICE_ID_IOIP_2110:	return kRegReserved511;
		case DEVICE_ID_IOIP_2110_RGB12:	return kRegReserved511;
		case DEVICE_ID_IOX3:		return kRegReserved511;
		case DEVICE_ID_IOXT:		return kRegLTC2AnalogBits32_63;
		case DEVICE_ID_KONA1:		return kRegReserved511;
		case DEVICE_ID_KONA3G:		return kRegLTC2AnalogBits32_63;
		case DEVICE_ID_KONA3GQUAD:	return kRegLTC4EmbeddedBits32_63;
		case DEVICE_ID_KONA4:		return kRegReserved511;
		case DEVICE_ID_KONA4UFC:	return kRegRasterizerControl;
		case DEVICE_ID_KONA5:		return kRegReserved511;
		case DEVICE_ID_KONA5_2X4K:	return kRegReserved511;
		case DEVICE_ID_KONA5_3DLUT:	return kRegReserved511;
		case DEVICE_ID_KONA5_8K:	return kRegReserved511;
		case DEVICE_ID_KONA5_8KMK:	return kRegReserved511;
		case DEVICE_ID_KONA5_8K_MV_TX:	return kRegReserved511;
		case DEVICE_ID_KONA5_OE1:	return kRegReserved511;
		case DEVICE_ID_KONA5_OE10:	return kRegReserved511;
		case DEVICE_ID_KONA5_OE11:	return kRegReserved511;
		case DEVICE_ID_KONA5_OE12:	return kRegReserved511;
		case DEVICE_ID_KONA5_OE2:	return kRegReserved511;
		case DEVICE_ID_KONA5_OE3:	return kRegReserved511;
		case DEVICE_ID_KONA5_OE4:	return kRegReserved511;
		case DEVICE_ID_KONA5_OE5:	return kRegReserved511;
		case DEVICE_ID_KONA5_OE6:	return kRegReserved511;
		case DEVICE_ID_KONA5_OE7:	return kRegReserved511;
		case DEVICE_ID_KONA5_OE8:	return kRegReserved511;
		case DEVICE_ID_KONA5_OE9:	return kRegReserved511;
		case DEVICE_ID_KONAHDMI:	return kRegReserved511;
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:	return kRegReserved511;
		case DEVICE_ID_KONAIP_1RX_1TX_2110:	return kRegReserved511;
		case DEVICE_ID_KONAIP_2022:	return kRegReserved511;
		case DEVICE_ID_KONAIP_2110:	return kRegReserved511;
		case DEVICE_ID_KONAIP_2110_RGB12:	return kRegReserved511;
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:	return kRegReserved511;
		case DEVICE_ID_KONAIP_4CH_2SFP:	return kRegReserved511;
		case DEVICE_ID_KONALHEPLUS:	return kRegSDIIn2VPIDB;
		case DEVICE_ID_KONALHI:		return kRegSDIOut1VPIDB;
		case DEVICE_ID_KONALHIDVI:	return kRegSDIOut1VPIDB;
		case DEVICE_ID_SOJI_3DLUT:	return kRegReserved511;
		case DEVICE_ID_SOJI_OE1:	return kRegReserved511;
		case DEVICE_ID_SOJI_OE2:	return kRegReserved511;
		case DEVICE_ID_SOJI_OE3:	return kRegReserved511;
		case DEVICE_ID_SOJI_OE4:	return kRegReserved511;
		case DEVICE_ID_SOJI_OE5:	return kRegReserved511;
		case DEVICE_ID_SOJI_OE6:	return kRegReserved511;
		case DEVICE_ID_SOJI_OE7:	return kRegReserved511;
		case DEVICE_ID_TTAP:		return kRegSDIOut1VPIDB;
		case DEVICE_ID_TTAP_PRO:	return kRegReserved511;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_NOTFOUND:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetMaxRegisterNumber (auto-generated)


/**
	NTV2DeviceGetMaxTransferCount
	Returns the maximum number of 32-bit words that the DMA engine can move at a time on the device having the given ID.
**/
ULWord NTV2DeviceGetMaxTransferCount (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID1:		return BIT(21)-1;
		case DEVICE_ID_CORVID22:	return BIT(21)-1;
		case DEVICE_ID_CORVID24:	return BIT(21)-1;
		case DEVICE_ID_CORVID3G:	return BIT(21)-1;
		case DEVICE_ID_CORVID44:	return BIT(21)-1;
		case DEVICE_ID_CORVID44_2X4K:	return BIT(21)-1;
		case DEVICE_ID_CORVID44_8K:	return BIT(21)-1;
		case DEVICE_ID_CORVID44_8KMK:	return BIT(21)-1;
		case DEVICE_ID_CORVID44_PLNR:	return BIT(21)-1;
		case DEVICE_ID_CORVID88:	return BIT(21)-1;
		case DEVICE_ID_CORVIDHBR:	return BIT(21)-1;
		case DEVICE_ID_CORVIDHEVC:	return BIT(21)-1;
		case DEVICE_ID_IO4K:		return BIT(21)-1;
		case DEVICE_ID_IO4KPLUS:	return BIT(21)-1;
		case DEVICE_ID_IO4KUFC:		return BIT(21)-1;
		case DEVICE_ID_IOEXPRESS:	return BIT(21)-1;
		case DEVICE_ID_IOIP_2022:	return BIT(21)-1;
		case DEVICE_ID_IOIP_2110:	return BIT(21)-1;
		case DEVICE_ID_IOIP_2110_RGB12:	return BIT(21)-1;
		case DEVICE_ID_IOX3:		return BIT(21)-1;
		case DEVICE_ID_IOXT:		return BIT(21)-1;
		case DEVICE_ID_KONA1:		return BIT(21)-1;
		case DEVICE_ID_KONA3G:		return BIT(21)-1;
		case DEVICE_ID_KONA3GQUAD:	return BIT(21)-1;
		case DEVICE_ID_KONA4:		return BIT(21)-1;
		case DEVICE_ID_KONA4UFC:	return BIT(21)-1;
		case DEVICE_ID_KONA5:		return BIT(21)-1;
		case DEVICE_ID_KONA5_2X4K:	return BIT(21)-1;
		case DEVICE_ID_KONA5_3DLUT:	return BIT(21)-1;
		case DEVICE_ID_KONA5_8K:	return BIT(21)-1;
		case DEVICE_ID_KONA5_8KMK:	return BIT(21)-1;
		case DEVICE_ID_KONA5_8K_MV_TX:	return BIT(21)-1;
		case DEVICE_ID_KONA5_OE1:	return BIT(21)-1;
		case DEVICE_ID_KONA5_OE10:	return BIT(21)-1;
		case DEVICE_ID_KONA5_OE11:	return BIT(21)-1;
		case DEVICE_ID_KONA5_OE12:	return BIT(21)-1;
		case DEVICE_ID_KONA5_OE2:	return BIT(21)-1;
		case DEVICE_ID_KONA5_OE3:	return BIT(21)-1;
		case DEVICE_ID_KONA5_OE4:	return BIT(21)-1;
		case DEVICE_ID_KONA5_OE5:	return BIT(21)-1;
		case DEVICE_ID_KONA5_OE6:	return BIT(21)-1;
		case DEVICE_ID_KONA5_OE7:	return BIT(21)-1;
		case DEVICE_ID_KONA5_OE8:	return BIT(21)-1;
		case DEVICE_ID_KONA5_OE9:	return BIT(21)-1;
		case DEVICE_ID_KONAHDMI:	return BIT(21)-1;
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:	return BIT(21)-1;
		case DEVICE_ID_KONAIP_1RX_1TX_2110:	return BIT(21)-1;
		case DEVICE_ID_KONAIP_2022:	return BIT(21)-1;
		case DEVICE_ID_KONAIP_2110:	return BIT(21)-1;
		case DEVICE_ID_KONAIP_2110_RGB12:	return BIT(21)-1;
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:	return BIT(21)-1;
		case DEVICE_ID_KONAIP_4CH_2SFP:	return BIT(21)-1;
		case DEVICE_ID_KONALHEPLUS:	return BIT(21)-1;
		case DEVICE_ID_KONALHI:		return BIT(21)-1;
		case DEVICE_ID_KONALHIDVI:	return BIT(21)-1;
		case DEVICE_ID_SOJI_3DLUT:	return BIT(21)-1;
		case DEVICE_ID_SOJI_OE1:	return BIT(21)-1;
		case DEVICE_ID_SOJI_OE2:	return BIT(21)-1;
		case DEVICE_ID_SOJI_OE3:	return BIT(21)-1;
		case DEVICE_ID_SOJI_OE4:	return BIT(21)-1;
		case DEVICE_ID_SOJI_OE5:	return BIT(21)-1;
		case DEVICE_ID_SOJI_OE6:	return BIT(21)-1;
		case DEVICE_ID_SOJI_OE7:	return BIT(21)-1;
		case DEVICE_ID_TTAP:		return BIT(21)-1;
		case DEVICE_ID_TTAP_PRO:	return BIT(21)-1;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_NOTFOUND:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetMaxTransferCount (auto-generated)


/**
	NTV2DeviceGetNum2022ChannelsSFP1
	Returns the number of 2022 channels configured on SFP 1 on the device having the given ID.
**/
UWord NTV2DeviceGetNum2022ChannelsSFP1 (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_IOIP_2022:	return 4;
		case DEVICE_ID_IOIP_2110:	return 4;
		case DEVICE_ID_IOIP_2110_RGB12:	return 4;
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:	return 2;
		case DEVICE_ID_KONAIP_1RX_1TX_2110:	return 4;
		case DEVICE_ID_KONAIP_2022:	return 4;
		case DEVICE_ID_KONAIP_2110:	return 4;
		case DEVICE_ID_KONAIP_2110_RGB12:	return 4;
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:	return 2;
		case DEVICE_ID_KONAIP_4CH_2SFP:	return 2;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetNum2022ChannelsSFP1 (auto-generated)


/**
	NTV2DeviceGetNum2022ChannelsSFP2
	Returns the number of 2022 channels configured on SFP 2 on the device having the given ID.
**/
UWord NTV2DeviceGetNum2022ChannelsSFP2 (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_KONAIP_4CH_2SFP:	return 2;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetNum2022ChannelsSFP2 (auto-generated)


/**
	NTV2DeviceGetNum4kQuarterSizeConverters
	Returns the number of quarter-size 4K/UHD down-converters on the device having the given ID.
**/
UWord NTV2DeviceGetNum4kQuarterSizeConverters (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID44_2X4K:	return 1;
		case DEVICE_ID_CORVIDHBR:	return 1;
		case DEVICE_ID_IO4K:		return 1;
		case DEVICE_ID_IO4KPLUS:	return 1;
		case DEVICE_ID_IOIP_2022:	return 1;
		case DEVICE_ID_IOIP_2110:	return 1;
		case DEVICE_ID_IOIP_2110_RGB12:	return 1;
		case DEVICE_ID_KONA4:		return 1;
		case DEVICE_ID_KONA5:		return 1;
		case DEVICE_ID_KONA5_2X4K:	return 1;
		case DEVICE_ID_KONA5_3DLUT:	return 1;
		case DEVICE_ID_KONA5_8K:	return 1;
		case DEVICE_ID_KONA5_8KMK:	return 1;
		case DEVICE_ID_KONA5_8K_MV_TX:	return 1;
		case DEVICE_ID_KONA5_OE1:	return 1;
		case DEVICE_ID_KONA5_OE10:	return 1;
		case DEVICE_ID_KONA5_OE11:	return 1;
		case DEVICE_ID_KONA5_OE12:	return 1;
		case DEVICE_ID_KONA5_OE2:	return 1;
		case DEVICE_ID_KONA5_OE3:	return 1;
		case DEVICE_ID_KONA5_OE4:	return 1;
		case DEVICE_ID_KONA5_OE5:	return 1;
		case DEVICE_ID_KONA5_OE6:	return 1;
		case DEVICE_ID_KONA5_OE7:	return 1;
		case DEVICE_ID_KONA5_OE8:	return 1;
		case DEVICE_ID_KONA5_OE9:	return 1;
		case DEVICE_ID_KONAIP_4CH_2SFP:	return 1;
		case DEVICE_ID_SOJI_3DLUT:	return 1;
		case DEVICE_ID_SOJI_OE1:	return 1;
		case DEVICE_ID_SOJI_OE2:	return 1;
		case DEVICE_ID_SOJI_OE3:	return 1;
		case DEVICE_ID_SOJI_OE4:	return 1;
		case DEVICE_ID_SOJI_OE5:	return 1;
		case DEVICE_ID_SOJI_OE6:	return 1;
		case DEVICE_ID_SOJI_OE7:	return 1;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_KONALHI:
		case DEVICE_ID_KONALHIDVI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetNum4kQuarterSizeConverters (auto-generated)


/**
	NTV2DeviceGetNumAESAudioInputChannels
	Returns the number of AES/EBU audio input channels on the device having the given ID.
**/
UWord NTV2DeviceGetNumAESAudioInputChannels (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID44_2X4K:	return 8;
		case DEVICE_ID_CORVIDHBR:	return 2;
		case DEVICE_ID_IOEXPRESS:	return 2;
		case DEVICE_ID_KONA3G:		return 16;
		case DEVICE_ID_KONA3GQUAD:	return 16;
		case DEVICE_ID_KONA4:		return 16;
		case DEVICE_ID_KONA4UFC:	return 16;
		case DEVICE_ID_KONA5:		return 8;
		case DEVICE_ID_KONA5_2X4K:	return 8;
		case DEVICE_ID_KONA5_3DLUT:	return 8;
		case DEVICE_ID_KONA5_8K:	return 8;
		case DEVICE_ID_KONA5_8KMK:	return 8;
		case DEVICE_ID_KONA5_8K_MV_TX:	return 8;
		case DEVICE_ID_KONA5_OE1:	return 8;
		case DEVICE_ID_KONA5_OE10:	return 8;
		case DEVICE_ID_KONA5_OE11:	return 8;
		case DEVICE_ID_KONA5_OE12:	return 8;
		case DEVICE_ID_KONA5_OE2:	return 8;
		case DEVICE_ID_KONA5_OE3:	return 8;
		case DEVICE_ID_KONA5_OE4:	return 8;
		case DEVICE_ID_KONA5_OE5:	return 8;
		case DEVICE_ID_KONA5_OE6:	return 8;
		case DEVICE_ID_KONA5_OE7:	return 8;
		case DEVICE_ID_KONA5_OE8:	return 8;
		case DEVICE_ID_KONA5_OE9:	return 8;
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:	return 16;
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:	return 16;
		case DEVICE_ID_KONALHEPLUS:	return 2;
		case DEVICE_ID_KONALHI:		return 2;
		case DEVICE_ID_KONALHIDVI:	return 2;
		case DEVICE_ID_SOJI_3DLUT:	return 8;
		case DEVICE_ID_SOJI_OE1:	return 8;
		case DEVICE_ID_SOJI_OE2:	return 8;
		case DEVICE_ID_SOJI_OE3:	return 8;
		case DEVICE_ID_SOJI_OE4:	return 8;
		case DEVICE_ID_SOJI_OE5:	return 8;
		case DEVICE_ID_SOJI_OE6:	return 8;
		case DEVICE_ID_SOJI_OE7:	return 8;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetNumAESAudioInputChannels (auto-generated)


/**
	NTV2DeviceGetNumAESAudioOutputChannels
	Returns the number of AES/EBU audio output channels on the device having the given ID.
**/
UWord NTV2DeviceGetNumAESAudioOutputChannels (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID44_2X4K:	return 8;
		case DEVICE_ID_IO4KUFC:		return 16;
		case DEVICE_ID_IOEXPRESS:	return 2;
		case DEVICE_ID_KONA3G:		return 16;
		case DEVICE_ID_KONA3GQUAD:	return 16;
		case DEVICE_ID_KONA4:		return 16;
		case DEVICE_ID_KONA4UFC:	return 16;
		case DEVICE_ID_KONA5:		return 8;
		case DEVICE_ID_KONA5_2X4K:	return 8;
		case DEVICE_ID_KONA5_3DLUT:	return 8;
		case DEVICE_ID_KONA5_8K:	return 8;
		case DEVICE_ID_KONA5_8KMK:	return 8;
		case DEVICE_ID_KONA5_8K_MV_TX:	return 8;
		case DEVICE_ID_KONA5_OE1:	return 8;
		case DEVICE_ID_KONA5_OE10:	return 8;
		case DEVICE_ID_KONA5_OE11:	return 8;
		case DEVICE_ID_KONA5_OE12:	return 8;
		case DEVICE_ID_KONA5_OE2:	return 8;
		case DEVICE_ID_KONA5_OE3:	return 8;
		case DEVICE_ID_KONA5_OE4:	return 8;
		case DEVICE_ID_KONA5_OE5:	return 8;
		case DEVICE_ID_KONA5_OE6:	return 8;
		case DEVICE_ID_KONA5_OE7:	return 8;
		case DEVICE_ID_KONA5_OE8:	return 8;
		case DEVICE_ID_KONA5_OE9:	return 8;
		case DEVICE_ID_KONALHEPLUS:	return 2;
		case DEVICE_ID_KONALHI:		return 2;
		case DEVICE_ID_KONALHIDVI:	return 2;
		case DEVICE_ID_SOJI_3DLUT:	return 8;
		case DEVICE_ID_SOJI_OE1:	return 8;
		case DEVICE_ID_SOJI_OE2:	return 8;
		case DEVICE_ID_SOJI_OE3:	return 8;
		case DEVICE_ID_SOJI_OE4:	return 8;
		case DEVICE_ID_SOJI_OE5:	return 8;
		case DEVICE_ID_SOJI_OE6:	return 8;
		case DEVICE_ID_SOJI_OE7:	return 8;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetNumAESAudioOutputChannels (auto-generated)


/**
	NTV2DeviceGetNumAnalogAudioInputChannels
	Returns the number of analog audio input channels on the device having the given ID.
**/
UWord NTV2DeviceGetNumAnalogAudioInputChannels (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_IO4KPLUS:	return 8;
		case DEVICE_ID_IOIP_2022:	return 8;
		case DEVICE_ID_IOIP_2110:	return 8;
		case DEVICE_ID_IOIP_2110_RGB12:	return 0;
		case DEVICE_ID_IOX3:		return 8;
		case DEVICE_ID_KONALHEPLUS:	return 2;
		case DEVICE_ID_KONALHI:		return 2;
		case DEVICE_ID_KONALHIDVI:	return 2;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetNumAnalogAudioInputChannels (auto-generated)


/**
	NTV2DeviceGetNumAnalogAudioOutputChannels
	Returns the number of analog audio output channels on the device having the given ID.
**/
UWord NTV2DeviceGetNumAnalogAudioOutputChannels (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVIDHBR:	return 8;
		case DEVICE_ID_IO4K:		return 8;
		case DEVICE_ID_IO4KPLUS:	return 8;
		case DEVICE_ID_IO4KUFC:		return 8;
		case DEVICE_ID_IOEXPRESS:	return 2;
		case DEVICE_ID_IOIP_2022:	return 8;
		case DEVICE_ID_IOIP_2110:	return 8;
		case DEVICE_ID_IOIP_2110_RGB12:	return 8;
		case DEVICE_ID_IOX3:		return 8;
		case DEVICE_ID_IOXT:		return 8;
		case DEVICE_ID_KONALHEPLUS:	return 2;
		case DEVICE_ID_KONALHI:		return 2;
		case DEVICE_ID_KONALHIDVI:	return 2;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetNumAnalogAudioOutputChannels (auto-generated)


/**
	NTV2DeviceGetNumAnalogVideoInputs
	Returns the number of analog video inputs on the device having the given ID.
**/
UWord NTV2DeviceGetNumAnalogVideoInputs (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_KONALHEPLUS:	return 1;
		case DEVICE_ID_KONALHI:		return 1;
		case DEVICE_ID_KONALHIDVI:	return 1;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_IOXT:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetNumAnalogVideoInputs (auto-generated)


/**
	NTV2DeviceGetNumAnalogVideoOutputs
	Returns the number of analog video outputs on the device having the given ID.
**/
UWord NTV2DeviceGetNumAnalogVideoOutputs (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_IOEXPRESS:	return 1;
		case DEVICE_ID_IOXT:		return 1;
		case DEVICE_ID_KONA3G:		return 1;
		case DEVICE_ID_KONA3GQUAD:	return 1;
		case DEVICE_ID_KONA4:		return 1;
		case DEVICE_ID_KONA4UFC:	return 1;
		case DEVICE_ID_KONALHEPLUS:	return 1;
		case DEVICE_ID_KONALHI:		return 1;
		case DEVICE_ID_KONALHIDVI:	return 1;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IO4KUFC:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetNumAnalogVideoOutputs (auto-generated)


/**
	NTV2DeviceGetNumAudioSystems
	Returns the number of independent audio systems on the device having the given ID.
**/
UWord NTV2DeviceGetNumAudioSystems (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID1:		return 1;
		case DEVICE_ID_CORVID22:	return 2;
		case DEVICE_ID_CORVID24:	return 4;
		case DEVICE_ID_CORVID3G:	return 1;
		case DEVICE_ID_CORVID44:	return 4;
		case DEVICE_ID_CORVID44_2X4K:	return 2;
		case DEVICE_ID_CORVID44_8K:	return 4;
		case DEVICE_ID_CORVID44_8KMK:	return 4;
		case DEVICE_ID_CORVID44_PLNR:	return 4;
		case DEVICE_ID_CORVID88:	return 8;
		case DEVICE_ID_CORVIDHBR:	return 1;
		case DEVICE_ID_CORVIDHEVC:	return 4;
		case DEVICE_ID_IO4K:		return 4;
		case DEVICE_ID_IO4KPLUS:	return 4;
		case DEVICE_ID_IO4KUFC:		return 2;
		case DEVICE_ID_IOEXPRESS:	return 1;
		case DEVICE_ID_IOIP_2022:	return 4;
		case DEVICE_ID_IOIP_2110:	return 4;
		case DEVICE_ID_IOIP_2110_RGB12:	return 4;
		case DEVICE_ID_IOX3:		return 4;
		case DEVICE_ID_IOXT:		return 2;
		case DEVICE_ID_KONA1:		return 2;
		case DEVICE_ID_KONA3G:		return 2;
		case DEVICE_ID_KONA3GQUAD:	return 4;
		case DEVICE_ID_KONA4:		return 4;
		case DEVICE_ID_KONA4UFC:	return 2;
		case DEVICE_ID_KONA5:		return 4;
		case DEVICE_ID_KONA5_2X4K:	return 2;
		case DEVICE_ID_KONA5_3DLUT:	return 1;
		case DEVICE_ID_KONA5_8K:	return 4;
		case DEVICE_ID_KONA5_8KMK:	return 4;
		case DEVICE_ID_KONA5_8K_MV_TX:	return 4;
		case DEVICE_ID_KONA5_OE1:	return 1;
		case DEVICE_ID_KONA5_OE10:	return 1;
		case DEVICE_ID_KONA5_OE11:	return 1;
		case DEVICE_ID_KONA5_OE12:	return 1;
		case DEVICE_ID_KONA5_OE2:	return 1;
		case DEVICE_ID_KONA5_OE3:	return 1;
		case DEVICE_ID_KONA5_OE4:	return 1;
		case DEVICE_ID_KONA5_OE5:	return 1;
		case DEVICE_ID_KONA5_OE6:	return 1;
		case DEVICE_ID_KONA5_OE7:	return 1;
		case DEVICE_ID_KONA5_OE8:	return 1;
		case DEVICE_ID_KONA5_OE9:	return 1;
		case DEVICE_ID_KONAHDMI:	return 4;
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:	return 4;
		case DEVICE_ID_KONAIP_1RX_1TX_2110:	return 4;
		case DEVICE_ID_KONAIP_2022:	return 4;
		case DEVICE_ID_KONAIP_2110:	return 4;
		case DEVICE_ID_KONAIP_2110_RGB12:	return 4;
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:	return 4;
		case DEVICE_ID_KONAIP_4CH_2SFP:	return 4;
		case DEVICE_ID_KONALHEPLUS:	return 1;
		case DEVICE_ID_KONALHI:		return 1;
		case DEVICE_ID_KONALHIDVI:	return 1;
		case DEVICE_ID_SOJI_3DLUT:	return 1;
		case DEVICE_ID_SOJI_OE1:	return 1;
		case DEVICE_ID_SOJI_OE2:	return 1;
		case DEVICE_ID_SOJI_OE3:	return 1;
		case DEVICE_ID_SOJI_OE4:	return 1;
		case DEVICE_ID_SOJI_OE5:	return 1;
		case DEVICE_ID_SOJI_OE6:	return 1;
		case DEVICE_ID_SOJI_OE7:	return 1;
		case DEVICE_ID_TTAP:		return 1;
		case DEVICE_ID_TTAP_PRO:	return 1;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_NOTFOUND:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetNumAudioSystems (auto-generated)


/**
	NTV2DeviceGetNumCrossConverters
	Returns the number of cross-converters on the device having the given ID.
**/
UWord NTV2DeviceGetNumCrossConverters (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_IO4KUFC:		return 1;
		case DEVICE_ID_IOXT:		return 1;
		case DEVICE_ID_KONA3G:		return 1;
		case DEVICE_ID_KONA4UFC:	return 1;
		case DEVICE_ID_KONALHI:		return 1;
		case DEVICE_ID_KONALHIDVI:	return 1;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetNumCrossConverters (auto-generated)


/**
	NTV2DeviceGetNumCSCs
	Returns the number of colorspace converter widgets on the device having the given ID.
**/
UWord NTV2DeviceGetNumCSCs (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID22:	return 2;
		case DEVICE_ID_CORVID24:	return 4;
		case DEVICE_ID_CORVID3G:	return 2;
		case DEVICE_ID_CORVID44:	return 4;
		case DEVICE_ID_CORVID44_2X4K:	return 2;
		case DEVICE_ID_CORVID44_8K:	return 0;
		case DEVICE_ID_CORVID44_8KMK:	return 2;
		case DEVICE_ID_CORVID44_PLNR:	return 0;
		case DEVICE_ID_CORVID88:	return 8;
		case DEVICE_ID_CORVIDHBR:	return 4;
		case DEVICE_ID_CORVIDHEVC:	return 4;
		case DEVICE_ID_IO4K:		return 5;
		case DEVICE_ID_IO4KPLUS:	return 5;
		case DEVICE_ID_IO4KUFC:		return 3;
		case DEVICE_ID_IOIP_2022:	return 5;
		case DEVICE_ID_IOIP_2110:	return 5;
		case DEVICE_ID_IOIP_2110_RGB12:	return 5;
		case DEVICE_ID_IOX3:		return 4;
		case DEVICE_ID_IOXT:		return 2;
		case DEVICE_ID_KONA1:		return 2;
		case DEVICE_ID_KONA3G:		return 2;
		case DEVICE_ID_KONA3GQUAD:	return 4;
		case DEVICE_ID_KONA4:		return 5;
		case DEVICE_ID_KONA4UFC:	return 2;
		case DEVICE_ID_KONA5:		return 5;
		case DEVICE_ID_KONA5_2X4K:	return 2;
		case DEVICE_ID_KONA5_3DLUT:	return 4;
		case DEVICE_ID_KONA5_8K:	return 0;
		case DEVICE_ID_KONA5_8KMK:	return 2;
		case DEVICE_ID_KONA5_8K_MV_TX:	return 0;
		case DEVICE_ID_KONA5_OE1:	return 4;
		case DEVICE_ID_KONA5_OE10:	return 4;
		case DEVICE_ID_KONA5_OE11:	return 4;
		case DEVICE_ID_KONA5_OE12:	return 4;
		case DEVICE_ID_KONA5_OE2:	return 4;
		case DEVICE_ID_KONA5_OE3:	return 4;
		case DEVICE_ID_KONA5_OE4:	return 4;
		case DEVICE_ID_KONA5_OE5:	return 4;
		case DEVICE_ID_KONA5_OE6:	return 4;
		case DEVICE_ID_KONA5_OE7:	return 4;
		case DEVICE_ID_KONA5_OE8:	return 4;
		case DEVICE_ID_KONA5_OE9:	return 4;
		case DEVICE_ID_KONAHDMI:	return 8;
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:	return 2;
		case DEVICE_ID_KONAIP_1RX_1TX_2110:	return 4;
		case DEVICE_ID_KONAIP_2022:	return 5;
		case DEVICE_ID_KONAIP_2110:	return 4;
		case DEVICE_ID_KONAIP_2110_RGB12:	return 4;
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:	return 2;
		case DEVICE_ID_KONAIP_4CH_2SFP:	return 5;
		case DEVICE_ID_KONALHEPLUS:	return 1;
		case DEVICE_ID_KONALHI:		return 2;
		case DEVICE_ID_KONALHIDVI:	return 2;
		case DEVICE_ID_SOJI_3DLUT:	return 4;
		case DEVICE_ID_SOJI_OE1:	return 4;
		case DEVICE_ID_SOJI_OE2:	return 4;
		case DEVICE_ID_SOJI_OE3:	return 4;
		case DEVICE_ID_SOJI_OE4:	return 4;
		case DEVICE_ID_SOJI_OE5:	return 4;
		case DEVICE_ID_SOJI_OE6:	return 4;
		case DEVICE_ID_SOJI_OE7:	return 4;
		case DEVICE_ID_TTAP_PRO:	return 1;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetNumCSCs (auto-generated)


/**
	NTV2DeviceGetNumDMAEngines
	Returns the number of DMA engines on the device having the given ID.
**/
ULWord NTV2DeviceGetNumDMAEngines (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID1:		return 2;
		case DEVICE_ID_CORVID22:	return 3;
		case DEVICE_ID_CORVID24:	return 2;
		case DEVICE_ID_CORVID3G:	return 2;
		case DEVICE_ID_CORVID44:	return 2;
		case DEVICE_ID_CORVID44_2X4K:	return 2;
		case DEVICE_ID_CORVID44_8K:	return 2;
		case DEVICE_ID_CORVID44_8KMK:	return 2;
		case DEVICE_ID_CORVID44_PLNR:	return 2;
		case DEVICE_ID_CORVID88:	return 2;
		case DEVICE_ID_CORVIDHBR:	return 2;
		case DEVICE_ID_CORVIDHEVC:	return 2;
		case DEVICE_ID_IO4K:		return 2;
		case DEVICE_ID_IO4KPLUS:	return 2;
		case DEVICE_ID_IO4KUFC:		return 2;
		case DEVICE_ID_IOEXPRESS:	return 2;
		case DEVICE_ID_IOIP_2022:	return 2;
		case DEVICE_ID_IOIP_2110:	return 2;
		case DEVICE_ID_IOIP_2110_RGB12:	return 2;
		case DEVICE_ID_IOX3:		return 2;
		case DEVICE_ID_IOXT:		return 2;
		case DEVICE_ID_KONA1:		return 2;
		case DEVICE_ID_KONA3G:		return 2;
		case DEVICE_ID_KONA3GQUAD:	return 2;
		case DEVICE_ID_KONA4:		return 2;
		case DEVICE_ID_KONA4UFC:	return 2;
		case DEVICE_ID_KONA5:		return 2;
		case DEVICE_ID_KONA5_2X4K:	return 2;
		case DEVICE_ID_KONA5_3DLUT:	return 2;
		case DEVICE_ID_KONA5_8K:	return 2;
		case DEVICE_ID_KONA5_8KMK:	return 2;
		case DEVICE_ID_KONA5_8K_MV_TX:	return 2;
		case DEVICE_ID_KONA5_OE1:	return 2;
		case DEVICE_ID_KONA5_OE10:	return 2;
		case DEVICE_ID_KONA5_OE11:	return 2;
		case DEVICE_ID_KONA5_OE12:	return 2;
		case DEVICE_ID_KONA5_OE2:	return 2;
		case DEVICE_ID_KONA5_OE3:	return 2;
		case DEVICE_ID_KONA5_OE4:	return 2;
		case DEVICE_ID_KONA5_OE5:	return 2;
		case DEVICE_ID_KONA5_OE6:	return 2;
		case DEVICE_ID_KONA5_OE7:	return 2;
		case DEVICE_ID_KONA5_OE8:	return 2;
		case DEVICE_ID_KONA5_OE9:	return 2;
		case DEVICE_ID_KONAHDMI:	return 2;
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:	return 2;
		case DEVICE_ID_KONAIP_1RX_1TX_2110:	return 2;
		case DEVICE_ID_KONAIP_2022:	return 2;
		case DEVICE_ID_KONAIP_2110:	return 2;
		case DEVICE_ID_KONAIP_2110_RGB12:	return 2;
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:	return 2;
		case DEVICE_ID_KONAIP_4CH_2SFP:	return 2;
		case DEVICE_ID_KONALHEPLUS:	return 2;
		case DEVICE_ID_KONALHI:		return 3;
		case DEVICE_ID_KONALHIDVI:	return 3;
		case DEVICE_ID_SOJI_3DLUT:	return 2;
		case DEVICE_ID_SOJI_OE1:	return 2;
		case DEVICE_ID_SOJI_OE2:	return 2;
		case DEVICE_ID_SOJI_OE3:	return 2;
		case DEVICE_ID_SOJI_OE4:	return 2;
		case DEVICE_ID_SOJI_OE5:	return 2;
		case DEVICE_ID_SOJI_OE6:	return 2;
		case DEVICE_ID_SOJI_OE7:	return 2;
		case DEVICE_ID_TTAP:		return 2;
		case DEVICE_ID_TTAP_PRO:	return 2;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_NOTFOUND:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetNumDMAEngines (auto-generated)


/**
	NTV2DeviceGetNumDownConverters
	Returns the number of down-converters on the device having the given ID.
**/
UWord NTV2DeviceGetNumDownConverters (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_IO4KUFC:		return 1;
		case DEVICE_ID_IOEXPRESS:	return 1;
		case DEVICE_ID_IOXT:		return 1;
		case DEVICE_ID_KONA3G:		return 1;
		case DEVICE_ID_KONA4UFC:	return 1;
		case DEVICE_ID_KONALHEPLUS:	return 1;
		case DEVICE_ID_KONALHI:		return 1;
		case DEVICE_ID_KONALHIDVI:	return 1;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetNumDownConverters (auto-generated)


/**
	NTV2DeviceGetNumEmbeddedAudioInputChannels
	Returns the number of SDI-embedded input audio channels supported by the device having the given ID.
**/
UWord NTV2DeviceGetNumEmbeddedAudioInputChannels (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID1:		return 16;
		case DEVICE_ID_CORVID22:	return 16;
		case DEVICE_ID_CORVID24:	return 16;
		case DEVICE_ID_CORVID3G:	return 16;
		case DEVICE_ID_CORVID44:	return 16;
		case DEVICE_ID_CORVID44_2X4K:	return 16;
		case DEVICE_ID_CORVID44_8K:	return 16;
		case DEVICE_ID_CORVID44_8KMK:	return 16;
		case DEVICE_ID_CORVID44_PLNR:	return 16;
		case DEVICE_ID_CORVID88:	return 16;
		case DEVICE_ID_CORVIDHEVC:	return 16;
		case DEVICE_ID_IO4K:		return 16;
		case DEVICE_ID_IO4KPLUS:	return 16;
		case DEVICE_ID_IO4KUFC:		return 16;
		case DEVICE_ID_IOEXPRESS:	return 8;
		case DEVICE_ID_IOIP_2022:	return 16;
		case DEVICE_ID_IOIP_2110:	return 16;
		case DEVICE_ID_IOIP_2110_RGB12:	return 0;
		case DEVICE_ID_IOX3:		return 16;
		case DEVICE_ID_IOXT:		return 16;
		case DEVICE_ID_KONA1:		return 16;
		case DEVICE_ID_KONA3G:		return 16;
		case DEVICE_ID_KONA3GQUAD:	return 16;
		case DEVICE_ID_KONA4:		return 16;
		case DEVICE_ID_KONA4UFC:	return 16;
		case DEVICE_ID_KONA5:		return 16;
		case DEVICE_ID_KONA5_2X4K:	return 16;
		case DEVICE_ID_KONA5_3DLUT:	return 16;
		case DEVICE_ID_KONA5_8K:	return 16;
		case DEVICE_ID_KONA5_8KMK:	return 16;
		case DEVICE_ID_KONA5_8K_MV_TX:	return 16;
		case DEVICE_ID_KONA5_OE1:	return 16;
		case DEVICE_ID_KONA5_OE10:	return 16;
		case DEVICE_ID_KONA5_OE11:	return 16;
		case DEVICE_ID_KONA5_OE12:	return 16;
		case DEVICE_ID_KONA5_OE2:	return 16;
		case DEVICE_ID_KONA5_OE3:	return 16;
		case DEVICE_ID_KONA5_OE4:	return 16;
		case DEVICE_ID_KONA5_OE5:	return 16;
		case DEVICE_ID_KONA5_OE6:	return 16;
		case DEVICE_ID_KONA5_OE7:	return 16;
		case DEVICE_ID_KONA5_OE8:	return 16;
		case DEVICE_ID_KONA5_OE9:	return 16;
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:	return 16;
		case DEVICE_ID_KONAIP_1RX_1TX_2110:	return 16;
		case DEVICE_ID_KONAIP_2022:	return 16;
		case DEVICE_ID_KONAIP_2110:	return 16;
		case DEVICE_ID_KONAIP_2110_RGB12:	return 0;
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:	return 16;
		case DEVICE_ID_KONAIP_4CH_2SFP:	return 16;
		case DEVICE_ID_KONALHEPLUS:	return 8;
		case DEVICE_ID_KONALHI:		return 8;
		case DEVICE_ID_KONALHIDVI:	return 8;
		case DEVICE_ID_SOJI_3DLUT:	return 16;
		case DEVICE_ID_SOJI_OE1:	return 16;
		case DEVICE_ID_SOJI_OE2:	return 16;
		case DEVICE_ID_SOJI_OE3:	return 16;
		case DEVICE_ID_SOJI_OE4:	return 16;
		case DEVICE_ID_SOJI_OE5:	return 16;
		case DEVICE_ID_SOJI_OE6:	return 16;
		case DEVICE_ID_SOJI_OE7:	return 16;
		case DEVICE_ID_TTAP_PRO:	return 16;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetNumEmbeddedAudioInputChannels (auto-generated)


/**
	NTV2DeviceGetNumEmbeddedAudioOutputChannels
	Returns the number of SDI-embedded output audio channels supported by the device having the given ID.
**/
UWord NTV2DeviceGetNumEmbeddedAudioOutputChannels (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID1:		return 16;
		case DEVICE_ID_CORVID22:	return 16;
		case DEVICE_ID_CORVID24:	return 16;
		case DEVICE_ID_CORVID3G:	return 16;
		case DEVICE_ID_CORVID44:	return 16;
		case DEVICE_ID_CORVID44_2X4K:	return 16;
		case DEVICE_ID_CORVID44_8K:	return 16;
		case DEVICE_ID_CORVID44_8KMK:	return 16;
		case DEVICE_ID_CORVID44_PLNR:	return 16;
		case DEVICE_ID_CORVID88:	return 16;
		case DEVICE_ID_IO4K:		return 16;
		case DEVICE_ID_IO4KPLUS:	return 16;
		case DEVICE_ID_IO4KUFC:		return 16;
		case DEVICE_ID_IOEXPRESS:	return 8;
		case DEVICE_ID_IOIP_2022:	return 16;
		case DEVICE_ID_IOIP_2110:	return 16;
		case DEVICE_ID_IOIP_2110_RGB12:	return 16;
		case DEVICE_ID_IOX3:		return 16;
		case DEVICE_ID_IOXT:		return 16;
		case DEVICE_ID_KONA1:		return 16;
		case DEVICE_ID_KONA3G:		return 16;
		case DEVICE_ID_KONA3GQUAD:	return 16;
		case DEVICE_ID_KONA4:		return 16;
		case DEVICE_ID_KONA4UFC:	return 16;
		case DEVICE_ID_KONA5:		return 16;
		case DEVICE_ID_KONA5_2X4K:	return 16;
		case DEVICE_ID_KONA5_3DLUT:	return 16;
		case DEVICE_ID_KONA5_8K:	return 16;
		case DEVICE_ID_KONA5_8KMK:	return 16;
		case DEVICE_ID_KONA5_8K_MV_TX:	return 16;
		case DEVICE_ID_KONA5_OE1:	return 16;
		case DEVICE_ID_KONA5_OE10:	return 16;
		case DEVICE_ID_KONA5_OE11:	return 16;
		case DEVICE_ID_KONA5_OE12:	return 16;
		case DEVICE_ID_KONA5_OE2:	return 16;
		case DEVICE_ID_KONA5_OE3:	return 16;
		case DEVICE_ID_KONA5_OE4:	return 16;
		case DEVICE_ID_KONA5_OE5:	return 16;
		case DEVICE_ID_KONA5_OE6:	return 16;
		case DEVICE_ID_KONA5_OE7:	return 16;
		case DEVICE_ID_KONA5_OE8:	return 16;
		case DEVICE_ID_KONA5_OE9:	return 16;
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:	return 16;
		case DEVICE_ID_KONAIP_1RX_1TX_2110:	return 16;
		case DEVICE_ID_KONAIP_2022:	return 16;
		case DEVICE_ID_KONAIP_2110:	return 16;
		case DEVICE_ID_KONAIP_2110_RGB12:	return 16;
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:	return 16;
		case DEVICE_ID_KONAIP_4CH_2SFP:	return 16;
		case DEVICE_ID_KONALHEPLUS:	return 8;
		case DEVICE_ID_KONALHI:		return 8;
		case DEVICE_ID_KONALHIDVI:	return 8;
		case DEVICE_ID_SOJI_3DLUT:	return 16;
		case DEVICE_ID_SOJI_OE1:	return 16;
		case DEVICE_ID_SOJI_OE2:	return 16;
		case DEVICE_ID_SOJI_OE3:	return 16;
		case DEVICE_ID_SOJI_OE4:	return 16;
		case DEVICE_ID_SOJI_OE5:	return 16;
		case DEVICE_ID_SOJI_OE6:	return 16;
		case DEVICE_ID_SOJI_OE7:	return 16;
		case DEVICE_ID_TTAP:		return 8;
		case DEVICE_ID_TTAP_PRO:	return 16;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_NOTFOUND:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetNumEmbeddedAudioOutputChannels (auto-generated)


/**
	NTV2DeviceGetNumFrameStores
	Returns the number of frame stores on the device having the given ID.
**/
UWord NTV2DeviceGetNumFrameStores (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID1:		return 2;
		case DEVICE_ID_CORVID22:	return 2;
		case DEVICE_ID_CORVID24:	return 4;
		case DEVICE_ID_CORVID3G:	return 2;
		case DEVICE_ID_CORVID44:	return 4;
		case DEVICE_ID_CORVID44_2X4K:	return 2;
		case DEVICE_ID_CORVID44_8K:	return 4;
		case DEVICE_ID_CORVID44_8KMK:	return 4;
		case DEVICE_ID_CORVID44_PLNR:	return 4;
		case DEVICE_ID_CORVID88:	return 8;
		case DEVICE_ID_CORVIDHBR:	return 4;
		case DEVICE_ID_CORVIDHEVC:	return 8;
		case DEVICE_ID_IO4K:		return 4;
		case DEVICE_ID_IO4KPLUS:	return 4;
		case DEVICE_ID_IO4KUFC:		return 2;
		case DEVICE_ID_IOEXPRESS:	return 1;
		case DEVICE_ID_IOIP_2022:	return 4;
		case DEVICE_ID_IOIP_2110:	return 4;
		case DEVICE_ID_IOIP_2110_RGB12:	return 2;
		case DEVICE_ID_IOX3:		return 4;
		case DEVICE_ID_IOXT:		return 2;
		case DEVICE_ID_KONA1:		return 2;
		case DEVICE_ID_KONA3G:		return 2;
		case DEVICE_ID_KONA3GQUAD:	return 4;
		case DEVICE_ID_KONA4:		return 4;
		case DEVICE_ID_KONA4UFC:	return 2;
		case DEVICE_ID_KONA5:		return 4;
		case DEVICE_ID_KONA5_2X4K:	return 2;
		case DEVICE_ID_KONA5_3DLUT:	return 2;
		case DEVICE_ID_KONA5_8K:	return 4;
		case DEVICE_ID_KONA5_8KMK:	return 4;
		case DEVICE_ID_KONA5_8K_MV_TX:	return 4;
		case DEVICE_ID_KONA5_OE1:	return 2;
		case DEVICE_ID_KONA5_OE10:	return 2;
		case DEVICE_ID_KONA5_OE11:	return 2;
		case DEVICE_ID_KONA5_OE12:	return 2;
		case DEVICE_ID_KONA5_OE2:	return 2;
		case DEVICE_ID_KONA5_OE3:	return 2;
		case DEVICE_ID_KONA5_OE4:	return 2;
		case DEVICE_ID_KONA5_OE5:	return 2;
		case DEVICE_ID_KONA5_OE6:	return 2;
		case DEVICE_ID_KONA5_OE7:	return 2;
		case DEVICE_ID_KONA5_OE8:	return 2;
		case DEVICE_ID_KONA5_OE9:	return 2;
		case DEVICE_ID_KONAHDMI:	return 4;
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:	return 4;
		case DEVICE_ID_KONAIP_1RX_1TX_2110:	return 4;
		case DEVICE_ID_KONAIP_2022:	return 4;
		case DEVICE_ID_KONAIP_2110:	return 4;
		case DEVICE_ID_KONAIP_2110_RGB12:	return 2;
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:	return 4;
		case DEVICE_ID_KONAIP_4CH_2SFP:	return 4;
		case DEVICE_ID_KONALHEPLUS:	return 2;
		case DEVICE_ID_KONALHI:		return 2;
		case DEVICE_ID_KONALHIDVI:	return 2;
		case DEVICE_ID_SOJI_3DLUT:	return 2;
		case DEVICE_ID_SOJI_OE1:	return 2;
		case DEVICE_ID_SOJI_OE2:	return 2;
		case DEVICE_ID_SOJI_OE3:	return 2;
		case DEVICE_ID_SOJI_OE4:	return 2;
		case DEVICE_ID_SOJI_OE5:	return 2;
		case DEVICE_ID_SOJI_OE6:	return 2;
		case DEVICE_ID_SOJI_OE7:	return 2;
		case DEVICE_ID_TTAP:		return 1;
		case DEVICE_ID_TTAP_PRO:	return 1;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_NOTFOUND:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetNumFrameStores (auto-generated)


/**
	NTV2DeviceGetNumFrameSyncs
	Returns the number of frame sync widgets on the device having the given ID.
**/
UWord NTV2DeviceGetNumFrameSyncs (const NTV2DeviceID inDeviceID)
{
	(void) inDeviceID;		// No devices support this function
	return 0;

}	//  NTV2DeviceGetNumFrameSyncs (auto-generated)


/**
	NTV2DeviceGetNumHDMIAudioInputChannels
	Returns the number of HDMI audio input channels on the device having the given ID.
**/
UWord NTV2DeviceGetNumHDMIAudioInputChannels (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVIDHBR:	return 8;
		case DEVICE_ID_IO4K:		return 8;
		case DEVICE_ID_IO4KPLUS:	return 8;
		case DEVICE_ID_IO4KUFC:		return 8;
		case DEVICE_ID_IOEXPRESS:	return 8;
		case DEVICE_ID_IOX3:		return 8;
		case DEVICE_ID_IOXT:		return 8;
		case DEVICE_ID_KONAHDMI:	return 8;
		case DEVICE_ID_KONALHI:		return 8;
		case DEVICE_ID_KONALHIDVI:	return 8;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetNumHDMIAudioInputChannels (auto-generated)


/**
	NTV2DeviceGetNumHDMIAudioOutputChannels
	Returns the number of HDMI audio output channels on the device having the given ID.
**/
UWord NTV2DeviceGetNumHDMIAudioOutputChannels (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_IO4K:		return 8;
		case DEVICE_ID_IO4KPLUS:	return 8;
		case DEVICE_ID_IO4KUFC:		return 8;
		case DEVICE_ID_IOEXPRESS:	return 8;
		case DEVICE_ID_IOIP_2022:	return 8;
		case DEVICE_ID_IOIP_2110:	return 8;
		case DEVICE_ID_IOIP_2110_RGB12:	return 8;
		case DEVICE_ID_IOX3:		return 8;
		case DEVICE_ID_IOXT:		return 8;
		case DEVICE_ID_KONA3G:		return 8;
		case DEVICE_ID_KONA3GQUAD:	return 8;
		case DEVICE_ID_KONA4:		return 8;
		case DEVICE_ID_KONA4UFC:	return 8;
		case DEVICE_ID_KONA5:		return 8;
		case DEVICE_ID_KONA5_2X4K:	return 8;
		case DEVICE_ID_KONA5_3DLUT:	return 8;
		case DEVICE_ID_KONA5_8K:	return 8;
		case DEVICE_ID_KONA5_8KMK:	return 8;
		case DEVICE_ID_KONA5_8K_MV_TX:	return 8;
		case DEVICE_ID_KONA5_OE1:	return 8;
		case DEVICE_ID_KONA5_OE10:	return 8;
		case DEVICE_ID_KONA5_OE11:	return 8;
		case DEVICE_ID_KONA5_OE12:	return 8;
		case DEVICE_ID_KONA5_OE2:	return 8;
		case DEVICE_ID_KONA5_OE3:	return 8;
		case DEVICE_ID_KONA5_OE4:	return 8;
		case DEVICE_ID_KONA5_OE5:	return 8;
		case DEVICE_ID_KONA5_OE6:	return 8;
		case DEVICE_ID_KONA5_OE7:	return 8;
		case DEVICE_ID_KONA5_OE8:	return 8;
		case DEVICE_ID_KONA5_OE9:	return 8;
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:	return 8;
		case DEVICE_ID_KONAIP_1RX_1TX_2110:	return 8;
		case DEVICE_ID_KONAIP_2022:	return 8;
		case DEVICE_ID_KONAIP_2110:	return 8;
		case DEVICE_ID_KONAIP_2110_RGB12:	return 8;
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:	return 8;
		case DEVICE_ID_KONAIP_4CH_2SFP:	return 8;
		case DEVICE_ID_KONALHI:		return 8;
		case DEVICE_ID_KONALHIDVI:	return 8;
		case DEVICE_ID_SOJI_3DLUT:	return 8;
		case DEVICE_ID_SOJI_OE1:	return 8;
		case DEVICE_ID_SOJI_OE2:	return 8;
		case DEVICE_ID_SOJI_OE3:	return 8;
		case DEVICE_ID_SOJI_OE4:	return 8;
		case DEVICE_ID_SOJI_OE5:	return 8;
		case DEVICE_ID_SOJI_OE6:	return 8;
		case DEVICE_ID_SOJI_OE7:	return 8;
		case DEVICE_ID_TTAP:		return 8;
		case DEVICE_ID_TTAP_PRO:	return 8;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_NOTFOUND:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetNumHDMIAudioOutputChannels (auto-generated)


/**
	NTV2DeviceGetNumHDMIVideoInputs
	Returns the number of HDMI video inputs on the device having the given ID.
**/
UWord NTV2DeviceGetNumHDMIVideoInputs (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVIDHBR:	return 1;
		case DEVICE_ID_IO4K:		return 1;
		case DEVICE_ID_IO4KPLUS:	return 1;
		case DEVICE_ID_IO4KUFC:		return 1;
		case DEVICE_ID_IOEXPRESS:	return 1;
		case DEVICE_ID_IOX3:		return 1;
		case DEVICE_ID_IOXT:		return 1;
		case DEVICE_ID_KONAHDMI:	return 4;
		case DEVICE_ID_KONALHI:		return 1;
		case DEVICE_ID_KONALHIDVI:	return 1;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3G:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA4UFC:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetNumHDMIVideoInputs (auto-generated)


/**
	NTV2DeviceGetNumHDMIVideoOutputs
	Returns the number of HDMI video outputs on the device having the given ID.
**/
UWord NTV2DeviceGetNumHDMIVideoOutputs (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_IO4K:		return 1;
		case DEVICE_ID_IO4KPLUS:	return 1;
		case DEVICE_ID_IO4KUFC:		return 1;
		case DEVICE_ID_IOEXPRESS:	return 1;
		case DEVICE_ID_IOIP_2022:	return 1;
		case DEVICE_ID_IOIP_2110:	return 1;
		case DEVICE_ID_IOIP_2110_RGB12:	return 1;
		case DEVICE_ID_IOX3:		return 1;
		case DEVICE_ID_IOXT:		return 1;
		case DEVICE_ID_KONA3G:		return 1;
		case DEVICE_ID_KONA3GQUAD:	return 1;
		case DEVICE_ID_KONA4:		return 1;
		case DEVICE_ID_KONA4UFC:	return 1;
		case DEVICE_ID_KONA5:		return 1;
		case DEVICE_ID_KONA5_2X4K:	return 1;
		case DEVICE_ID_KONA5_3DLUT:	return 1;
		case DEVICE_ID_KONA5_8K:	return 1;
		case DEVICE_ID_KONA5_8KMK:	return 1;
		case DEVICE_ID_KONA5_8K_MV_TX:	return 1;
		case DEVICE_ID_KONA5_OE1:	return 1;
		case DEVICE_ID_KONA5_OE10:	return 1;
		case DEVICE_ID_KONA5_OE11:	return 1;
		case DEVICE_ID_KONA5_OE12:	return 1;
		case DEVICE_ID_KONA5_OE2:	return 1;
		case DEVICE_ID_KONA5_OE3:	return 1;
		case DEVICE_ID_KONA5_OE4:	return 1;
		case DEVICE_ID_KONA5_OE5:	return 1;
		case DEVICE_ID_KONA5_OE6:	return 1;
		case DEVICE_ID_KONA5_OE7:	return 1;
		case DEVICE_ID_KONA5_OE8:	return 1;
		case DEVICE_ID_KONA5_OE9:	return 1;
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:	return 1;
		case DEVICE_ID_KONAIP_1RX_1TX_2110:	return 1;
		case DEVICE_ID_KONAIP_2022:	return 1;
		case DEVICE_ID_KONAIP_2110:	return 1;
		case DEVICE_ID_KONAIP_2110_RGB12:	return 1;
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:	return 1;
		case DEVICE_ID_KONAIP_4CH_2SFP:	return 1;
		case DEVICE_ID_KONALHI:		return 1;
		case DEVICE_ID_KONALHIDVI:	return 1;
		case DEVICE_ID_SOJI_3DLUT:	return 1;
		case DEVICE_ID_SOJI_OE1:	return 1;
		case DEVICE_ID_SOJI_OE2:	return 1;
		case DEVICE_ID_SOJI_OE3:	return 1;
		case DEVICE_ID_SOJI_OE4:	return 1;
		case DEVICE_ID_SOJI_OE5:	return 1;
		case DEVICE_ID_SOJI_OE6:	return 1;
		case DEVICE_ID_SOJI_OE7:	return 1;
		case DEVICE_ID_TTAP:		return 1;
		case DEVICE_ID_TTAP_PRO:	return 1;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_NOTFOUND:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetNumHDMIVideoOutputs (auto-generated)


/**
	NTV2DeviceGetNumInputConverters
	Returns the number of input converter widgets on the device having the given ID.
**/
UWord NTV2DeviceGetNumInputConverters (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_IO4KUFC:		return 1;
		case DEVICE_ID_IOEXPRESS:	return 1;
		case DEVICE_ID_IOXT:		return 1;
		case DEVICE_ID_KONA3G:		return 1;
		case DEVICE_ID_KONA4UFC:	return 1;
		case DEVICE_ID_KONALHEPLUS:	return 1;
		case DEVICE_ID_KONALHI:		return 1;
		case DEVICE_ID_KONALHIDVI:	return 1;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetNumInputConverters (auto-generated)


/**
	NTV2DeviceGetNumLTCInputs
	Returns the number of analog LTC inputs on the device having the given ID.
**/
UWord NTV2DeviceGetNumLTCInputs (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID1:		return 1;
		case DEVICE_ID_CORVID22:	return 2;
		case DEVICE_ID_CORVID24:	return 2;
		case DEVICE_ID_CORVID3G:	return 1;
		case DEVICE_ID_CORVID44:	return 2;
		case DEVICE_ID_CORVID44_2X4K:	return 2;
		case DEVICE_ID_CORVID44_8K:	return 2;
		case DEVICE_ID_CORVID44_8KMK:	return 2;
		case DEVICE_ID_CORVID44_PLNR:	return 2;
		case DEVICE_ID_CORVID88:	return 2;
		case DEVICE_ID_CORVIDHEVC:	return 1;
		case DEVICE_ID_IO4K:		return 1;
		case DEVICE_ID_IO4KPLUS:	return 1;
		case DEVICE_ID_IO4KUFC:		return 1;
		case DEVICE_ID_IOEXPRESS:	return 1;
		case DEVICE_ID_IOIP_2022:	return 1;
		case DEVICE_ID_IOIP_2110:	return 1;
		case DEVICE_ID_IOIP_2110_RGB12:	return 1;
		case DEVICE_ID_IOX3:		return 1;
		case DEVICE_ID_IOXT:		return 1;
		case DEVICE_ID_KONA1:		return 1;
		case DEVICE_ID_KONA3G:		return 2;
		case DEVICE_ID_KONA3GQUAD:	return 2;
		case DEVICE_ID_KONA4:		return 2;
		case DEVICE_ID_KONA4UFC:	return 2;
		case DEVICE_ID_KONA5:		return 2;
		case DEVICE_ID_KONA5_2X4K:	return 2;
		case DEVICE_ID_KONA5_3DLUT:	return 0;
		case DEVICE_ID_KONA5_8K:	return 2;
		case DEVICE_ID_KONA5_8KMK:	return 2;
		case DEVICE_ID_KONA5_8K_MV_TX:	return 2;
		case DEVICE_ID_KONA5_OE1:	return 0;
		case DEVICE_ID_KONA5_OE10:	return 0;
		case DEVICE_ID_KONA5_OE11:	return 0;
		case DEVICE_ID_KONA5_OE12:	return 0;
		case DEVICE_ID_KONA5_OE2:	return 0;
		case DEVICE_ID_KONA5_OE3:	return 0;
		case DEVICE_ID_KONA5_OE4:	return 0;
		case DEVICE_ID_KONA5_OE5:	return 0;
		case DEVICE_ID_KONA5_OE6:	return 0;
		case DEVICE_ID_KONA5_OE7:	return 0;
		case DEVICE_ID_KONA5_OE8:	return 0;
		case DEVICE_ID_KONA5_OE9:	return 0;
		case DEVICE_ID_KONALHI:		return 1;
		case DEVICE_ID_KONALHIDVI:	return 1;
		case DEVICE_ID_SOJI_3DLUT:	return 0;
		case DEVICE_ID_SOJI_OE1:	return 0;
		case DEVICE_ID_SOJI_OE2:	return 0;
		case DEVICE_ID_SOJI_OE3:	return 0;
		case DEVICE_ID_SOJI_OE4:	return 0;
		case DEVICE_ID_SOJI_OE5:	return 0;
		case DEVICE_ID_SOJI_OE6:	return 0;
		case DEVICE_ID_SOJI_OE7:	return 0;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetNumLTCInputs (auto-generated)


/**
	NTV2DeviceGetNumLTCOutputs
	Returns the number of analog LTC outputs on the device having the given ID.
**/
UWord NTV2DeviceGetNumLTCOutputs (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID22:	return 2;
		case DEVICE_ID_CORVID24:	return 2;
		case DEVICE_ID_CORVID44:	return 1;
		case DEVICE_ID_CORVID44_2X4K:	return 2;
		case DEVICE_ID_CORVID88:	return 1;
		case DEVICE_ID_IO4K:		return 1;
		case DEVICE_ID_IO4KPLUS:	return 1;
		case DEVICE_ID_IO4KUFC:		return 1;
		case DEVICE_ID_IOEXPRESS:	return 1;
		case DEVICE_ID_IOX3:		return 1;
		case DEVICE_ID_IOXT:		return 1;
		case DEVICE_ID_KONA3G:		return 2;
		case DEVICE_ID_KONA3GQUAD:	return 2;
		case DEVICE_ID_KONA4:		return 2;
		case DEVICE_ID_KONA4UFC:	return 2;
		case DEVICE_ID_KONA5:		return 2;
		case DEVICE_ID_KONA5_2X4K:	return 2;
		case DEVICE_ID_KONA5_3DLUT:	return 0;
		case DEVICE_ID_KONA5_8K:	return 2;
		case DEVICE_ID_KONA5_8KMK:	return 2;
		case DEVICE_ID_KONA5_8K_MV_TX:	return 2;
		case DEVICE_ID_KONA5_OE1:	return 0;
		case DEVICE_ID_KONA5_OE10:	return 0;
		case DEVICE_ID_KONA5_OE11:	return 0;
		case DEVICE_ID_KONA5_OE12:	return 0;
		case DEVICE_ID_KONA5_OE2:	return 0;
		case DEVICE_ID_KONA5_OE3:	return 0;
		case DEVICE_ID_KONA5_OE4:	return 0;
		case DEVICE_ID_KONA5_OE5:	return 0;
		case DEVICE_ID_KONA5_OE6:	return 0;
		case DEVICE_ID_KONA5_OE7:	return 0;
		case DEVICE_ID_KONA5_OE8:	return 0;
		case DEVICE_ID_KONA5_OE9:	return 0;
		case DEVICE_ID_KONALHI:		return 1;
		case DEVICE_ID_KONALHIDVI:	return 1;
		case DEVICE_ID_SOJI_3DLUT:	return 0;
		case DEVICE_ID_SOJI_OE1:	return 0;
		case DEVICE_ID_SOJI_OE2:	return 0;
		case DEVICE_ID_SOJI_OE3:	return 0;
		case DEVICE_ID_SOJI_OE4:	return 0;
		case DEVICE_ID_SOJI_OE5:	return 0;
		case DEVICE_ID_SOJI_OE6:	return 0;
		case DEVICE_ID_SOJI_OE7:	return 0;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetNumLTCOutputs (auto-generated)


/**
	NTV2DeviceGetNumLUTBanks
	Returns the number of LUT banks on the device having the given ID.
**/
UWord NTV2DeviceGetNumLUTBanks (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID24:	return 2;
		case DEVICE_ID_CORVID44:	return 2;
		case DEVICE_ID_CORVID44_2X4K:	return 1;
		case DEVICE_ID_CORVID88:	return 2;
		case DEVICE_ID_CORVIDHBR:	return 2;
		case DEVICE_ID_IO4K:		return 2;
		case DEVICE_ID_IO4KPLUS:	return 2;
		case DEVICE_ID_IO4KUFC:		return 2;
		case DEVICE_ID_IOIP_2022:	return 2;
		case DEVICE_ID_IOIP_2110:	return 2;
		case DEVICE_ID_IOIP_2110_RGB12:	return 2;
		case DEVICE_ID_IOX3:		return 2;
		case DEVICE_ID_IOXT:		return 2;
		case DEVICE_ID_KONA1:		return 2;
		case DEVICE_ID_KONA3G:		return 2;
		case DEVICE_ID_KONA3GQUAD:	return 2;
		case DEVICE_ID_KONA4:		return 2;
		case DEVICE_ID_KONA4UFC:	return 2;
		case DEVICE_ID_KONA5:		return 1;
		case DEVICE_ID_KONA5_2X4K:	return 1;
		case DEVICE_ID_KONA5_3DLUT:	return 1;
		case DEVICE_ID_KONAHDMI:	return 2;
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:	return 2;
		case DEVICE_ID_KONAIP_1RX_1TX_2110:	return 2;
		case DEVICE_ID_KONAIP_2022:	return 2;
		case DEVICE_ID_KONAIP_2110:	return 2;
		case DEVICE_ID_KONAIP_2110_RGB12:	return 2;
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:	return 2;
		case DEVICE_ID_KONAIP_4CH_2SFP:	return 2;
		case DEVICE_ID_KONALHEPLUS:	return 2;
		case DEVICE_ID_KONALHI:		return 2;
		case DEVICE_ID_KONALHIDVI:	return 2;
		case DEVICE_ID_SOJI_3DLUT:	return 2;
		case DEVICE_ID_TTAP_PRO:	return 2;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetNumLUTBanks (auto-generated)


/**
	NTV2DeviceGetNumLUTs
	Returns the number of LUT widgets on the device having the given ID.
**/
UWord NTV2DeviceGetNumLUTs (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID24:	return 4;
		case DEVICE_ID_CORVID44:	return 4;
		case DEVICE_ID_CORVID44_2X4K:	return 2;
		case DEVICE_ID_CORVID44_8K:	return 0;
		case DEVICE_ID_CORVID44_8KMK:	return 0;
		case DEVICE_ID_CORVID44_PLNR:	return 0;
		case DEVICE_ID_CORVID88:	return 8;
		case DEVICE_ID_CORVIDHBR:	return 4;
		case DEVICE_ID_IO4K:		return 5;
		case DEVICE_ID_IO4KPLUS:	return 5;
		case DEVICE_ID_IO4KUFC:		return 3;
		case DEVICE_ID_IOIP_2022:	return 5;
		case DEVICE_ID_IOIP_2110:	return 5;
		case DEVICE_ID_IOIP_2110_RGB12:	return 5;
		case DEVICE_ID_IOX3:		return 4;
		case DEVICE_ID_IOXT:		return 2;
		case DEVICE_ID_KONA1:		return 2;
		case DEVICE_ID_KONA3G:		return 2;
		case DEVICE_ID_KONA3GQUAD:	return 4;
		case DEVICE_ID_KONA4:		return 5;
		case DEVICE_ID_KONA4UFC:	return 2;
		case DEVICE_ID_KONA5:		return 5;
		case DEVICE_ID_KONA5_2X4K:	return 2;
		case DEVICE_ID_KONA5_3DLUT:	return 4;
		case DEVICE_ID_KONA5_8K:	return 0;
		case DEVICE_ID_KONA5_8KMK:	return 0;
		case DEVICE_ID_KONA5_8K_MV_TX:	return 0;
		case DEVICE_ID_KONA5_OE1:	return 0;
		case DEVICE_ID_KONA5_OE10:	return 0;
		case DEVICE_ID_KONA5_OE11:	return 0;
		case DEVICE_ID_KONA5_OE12:	return 0;
		case DEVICE_ID_KONA5_OE2:	return 0;
		case DEVICE_ID_KONA5_OE3:	return 0;
		case DEVICE_ID_KONA5_OE4:	return 0;
		case DEVICE_ID_KONA5_OE5:	return 0;
		case DEVICE_ID_KONA5_OE6:	return 0;
		case DEVICE_ID_KONA5_OE7:	return 0;
		case DEVICE_ID_KONA5_OE8:	return 0;
		case DEVICE_ID_KONA5_OE9:	return 0;
		case DEVICE_ID_KONAHDMI:	return 8;
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:	return 2;
		case DEVICE_ID_KONAIP_1RX_1TX_2110:	return 4;
		case DEVICE_ID_KONAIP_2022:	return 5;
		case DEVICE_ID_KONAIP_2110:	return 4;
		case DEVICE_ID_KONAIP_2110_RGB12:	return 4;
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:	return 2;
		case DEVICE_ID_KONAIP_4CH_2SFP:	return 5;
		case DEVICE_ID_KONALHEPLUS:	return 1;
		case DEVICE_ID_KONALHI:		return 2;
		case DEVICE_ID_KONALHIDVI:	return 2;
		case DEVICE_ID_SOJI_3DLUT:	return 4;
		case DEVICE_ID_SOJI_OE1:	return 0;
		case DEVICE_ID_SOJI_OE2:	return 0;
		case DEVICE_ID_SOJI_OE3:	return 0;
		case DEVICE_ID_SOJI_OE4:	return 0;
		case DEVICE_ID_SOJI_OE5:	return 0;
		case DEVICE_ID_SOJI_OE6:	return 0;
		case DEVICE_ID_SOJI_OE7:	return 0;
		case DEVICE_ID_TTAP_PRO:	return 1;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetNumLUTs (auto-generated)


/**
	NTV2DeviceGetNumMixers
	Returns the number of mixer/keyer widgets on the device having the given ID.
**/
UWord NTV2DeviceGetNumMixers (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID22:	return 2;
		case DEVICE_ID_CORVID24:	return 2;
		case DEVICE_ID_CORVID3G:	return 1;
		case DEVICE_ID_CORVID44:	return 2;
		case DEVICE_ID_CORVID44_2X4K:	return 1;
		case DEVICE_ID_CORVID44_8K:	return 0;
		case DEVICE_ID_CORVID44_8KMK:	return 1;
		case DEVICE_ID_CORVID44_PLNR:	return 0;
		case DEVICE_ID_CORVID88:	return 4;
		case DEVICE_ID_CORVIDHEVC:	return 4;
		case DEVICE_ID_IO4K:		return 2;
		case DEVICE_ID_IO4KPLUS:	return 2;
		case DEVICE_ID_IO4KUFC:		return 2;
		case DEVICE_ID_IOIP_2022:	return 2;
		case DEVICE_ID_IOIP_2110:	return 2;
		case DEVICE_ID_IOIP_2110_RGB12:	return 0;
		case DEVICE_ID_IOX3:		return 2;
		case DEVICE_ID_IOXT:		return 1;
		case DEVICE_ID_KONA1:		return 1;
		case DEVICE_ID_KONA3G:		return 2;
		case DEVICE_ID_KONA3GQUAD:	return 2;
		case DEVICE_ID_KONA4:		return 2;
		case DEVICE_ID_KONA4UFC:	return 2;
		case DEVICE_ID_KONA5:		return 2;
		case DEVICE_ID_KONA5_2X4K:	return 1;
		case DEVICE_ID_KONA5_3DLUT:	return 1;
		case DEVICE_ID_KONA5_8K:	return 0;
		case DEVICE_ID_KONA5_8KMK:	return 1;
		case DEVICE_ID_KONA5_8K_MV_TX:	return 0;
		case DEVICE_ID_KONA5_OE1:	return 1;
		case DEVICE_ID_KONA5_OE10:	return 1;
		case DEVICE_ID_KONA5_OE11:	return 1;
		case DEVICE_ID_KONA5_OE12:	return 1;
		case DEVICE_ID_KONA5_OE2:	return 1;
		case DEVICE_ID_KONA5_OE3:	return 1;
		case DEVICE_ID_KONA5_OE4:	return 1;
		case DEVICE_ID_KONA5_OE5:	return 1;
		case DEVICE_ID_KONA5_OE6:	return 1;
		case DEVICE_ID_KONA5_OE7:	return 1;
		case DEVICE_ID_KONA5_OE8:	return 1;
		case DEVICE_ID_KONA5_OE9:	return 1;
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:	return 2;
		case DEVICE_ID_KONAIP_1RX_1TX_2110:	return 2;
		case DEVICE_ID_KONAIP_2022:	return 2;
		case DEVICE_ID_KONAIP_2110:	return 2;
		case DEVICE_ID_KONAIP_2110_RGB12:	return 0;
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:	return 2;
		case DEVICE_ID_KONAIP_4CH_2SFP:	return 2;
		case DEVICE_ID_KONALHEPLUS:	return 1;
		case DEVICE_ID_KONALHI:		return 1;
		case DEVICE_ID_KONALHIDVI:	return 1;
		case DEVICE_ID_SOJI_3DLUT:	return 1;
		case DEVICE_ID_SOJI_OE1:	return 1;
		case DEVICE_ID_SOJI_OE2:	return 1;
		case DEVICE_ID_SOJI_OE3:	return 1;
		case DEVICE_ID_SOJI_OE4:	return 1;
		case DEVICE_ID_SOJI_OE5:	return 1;
		case DEVICE_ID_SOJI_OE6:	return 1;
		case DEVICE_ID_SOJI_OE7:	return 1;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetNumMixers (auto-generated)


/**
	NTV2DeviceGetNumOutputConverters
	Returns the number of output converter widgets on the device having the given ID.
**/
UWord NTV2DeviceGetNumOutputConverters (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_IO4KUFC:		return 1;
		case DEVICE_ID_IOEXPRESS:	return 1;
		case DEVICE_ID_IOXT:		return 1;
		case DEVICE_ID_KONA3G:		return 1;
		case DEVICE_ID_KONA4:		return 1;
		case DEVICE_ID_KONA4UFC:	return 1;
		case DEVICE_ID_KONALHEPLUS:	return 1;
		case DEVICE_ID_KONALHI:		return 1;
		case DEVICE_ID_KONALHIDVI:	return 1;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetNumOutputConverters (auto-generated)


/**
	NTV2DeviceGetNumReferenceVideoInputs
	Returns the number of reference video inputs on the device having the given ID.
**/
UWord NTV2DeviceGetNumReferenceVideoInputs (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID1:		return 1;
		case DEVICE_ID_CORVID22:	return 1;
		case DEVICE_ID_CORVID24:	return 1;
		case DEVICE_ID_CORVID3G:	return 1;
		case DEVICE_ID_CORVID44:	return 1;
		case DEVICE_ID_CORVID44_2X4K:	return 1;
		case DEVICE_ID_CORVID44_8K:	return 1;
		case DEVICE_ID_CORVID44_8KMK:	return 1;
		case DEVICE_ID_CORVID44_PLNR:	return 1;
		case DEVICE_ID_CORVID88:	return 1;
		case DEVICE_ID_CORVIDHEVC:	return 1;
		case DEVICE_ID_IO4K:		return 1;
		case DEVICE_ID_IO4KPLUS:	return 1;
		case DEVICE_ID_IO4KUFC:		return 1;
		case DEVICE_ID_IOEXPRESS:	return 1;
		case DEVICE_ID_IOIP_2022:	return 1;
		case DEVICE_ID_IOIP_2110:	return 1;
		case DEVICE_ID_IOIP_2110_RGB12:	return 0;
		case DEVICE_ID_IOX3:		return 1;
		case DEVICE_ID_IOXT:		return 1;
		case DEVICE_ID_KONA1:		return 1;
		case DEVICE_ID_KONA3G:		return 1;
		case DEVICE_ID_KONA3GQUAD:	return 1;
		case DEVICE_ID_KONA4:		return 1;
		case DEVICE_ID_KONA4UFC:	return 1;
		case DEVICE_ID_KONA5:		return 1;
		case DEVICE_ID_KONA5_2X4K:	return 1;
		case DEVICE_ID_KONA5_3DLUT:	return 0;
		case DEVICE_ID_KONA5_8K:	return 1;
		case DEVICE_ID_KONA5_8KMK:	return 1;
		case DEVICE_ID_KONA5_8K_MV_TX:	return 1;
		case DEVICE_ID_KONA5_OE1:	return 0;
		case DEVICE_ID_KONA5_OE10:	return 0;
		case DEVICE_ID_KONA5_OE11:	return 0;
		case DEVICE_ID_KONA5_OE12:	return 0;
		case DEVICE_ID_KONA5_OE2:	return 0;
		case DEVICE_ID_KONA5_OE3:	return 0;
		case DEVICE_ID_KONA5_OE4:	return 0;
		case DEVICE_ID_KONA5_OE5:	return 0;
		case DEVICE_ID_KONA5_OE6:	return 0;
		case DEVICE_ID_KONA5_OE7:	return 0;
		case DEVICE_ID_KONA5_OE8:	return 0;
		case DEVICE_ID_KONA5_OE9:	return 0;
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:	return 1;
		case DEVICE_ID_KONAIP_1RX_1TX_2110:	return 1;
		case DEVICE_ID_KONAIP_2022:	return 1;
		case DEVICE_ID_KONAIP_2110:	return 1;
		case DEVICE_ID_KONAIP_2110_RGB12:	return 0;
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:	return 1;
		case DEVICE_ID_KONAIP_4CH_2SFP:	return 1;
		case DEVICE_ID_KONALHEPLUS:	return 1;
		case DEVICE_ID_KONALHI:		return 1;
		case DEVICE_ID_KONALHIDVI:	return 1;
		case DEVICE_ID_SOJI_3DLUT:	return 0;
		case DEVICE_ID_SOJI_OE1:	return 0;
		case DEVICE_ID_SOJI_OE2:	return 0;
		case DEVICE_ID_SOJI_OE3:	return 0;
		case DEVICE_ID_SOJI_OE4:	return 0;
		case DEVICE_ID_SOJI_OE5:	return 0;
		case DEVICE_ID_SOJI_OE6:	return 0;
		case DEVICE_ID_SOJI_OE7:	return 0;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetNumReferenceVideoInputs (auto-generated)


/**
	NTV2DeviceGetNumSerialPorts
	Returns the number of RS-422 serial ports on the device having the given ID.
**/
UWord NTV2DeviceGetNumSerialPorts (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID1:		return 1;
		case DEVICE_ID_CORVID22:	return 2;
		case DEVICE_ID_CORVID24:	return 2;
		case DEVICE_ID_CORVID3G:	return 1;
		case DEVICE_ID_CORVID44:	return 1;
		case DEVICE_ID_CORVID44_2X4K:	return 1;
		case DEVICE_ID_CORVID44_8K:	return 1;
		case DEVICE_ID_CORVID44_8KMK:	return 1;
		case DEVICE_ID_CORVID44_PLNR:	return 1;
		case DEVICE_ID_CORVID88:	return 1;
		case DEVICE_ID_IO4K:		return 1;
		case DEVICE_ID_IO4KPLUS:	return 1;
		case DEVICE_ID_IO4KUFC:		return 1;
		case DEVICE_ID_IOEXPRESS:	return 1;
		case DEVICE_ID_IOX3:		return 1;
		case DEVICE_ID_IOXT:		return 1;
		case DEVICE_ID_KONA1:		return 1;
		case DEVICE_ID_KONA3G:		return 2;
		case DEVICE_ID_KONA3GQUAD:	return 2;
		case DEVICE_ID_KONA4:		return 1;
		case DEVICE_ID_KONA4UFC:	return 1;
		case DEVICE_ID_KONA5:		return 1;
		case DEVICE_ID_KONA5_2X4K:	return 1;
		case DEVICE_ID_KONA5_3DLUT:	return 0;
		case DEVICE_ID_KONA5_8K:	return 1;
		case DEVICE_ID_KONA5_8KMK:	return 1;
		case DEVICE_ID_KONA5_8K_MV_TX:	return 1;
		case DEVICE_ID_KONA5_OE1:	return 0;
		case DEVICE_ID_KONA5_OE10:	return 0;
		case DEVICE_ID_KONA5_OE11:	return 0;
		case DEVICE_ID_KONA5_OE12:	return 0;
		case DEVICE_ID_KONA5_OE2:	return 0;
		case DEVICE_ID_KONA5_OE3:	return 0;
		case DEVICE_ID_KONA5_OE4:	return 0;
		case DEVICE_ID_KONA5_OE5:	return 0;
		case DEVICE_ID_KONA5_OE6:	return 0;
		case DEVICE_ID_KONA5_OE7:	return 0;
		case DEVICE_ID_KONA5_OE8:	return 0;
		case DEVICE_ID_KONA5_OE9:	return 0;
		case DEVICE_ID_KONALHEPLUS:	return 1;
		case DEVICE_ID_KONALHI:		return 1;
		case DEVICE_ID_KONALHIDVI:	return 1;
		case DEVICE_ID_SOJI_3DLUT:	return 0;
		case DEVICE_ID_SOJI_OE1:	return 0;
		case DEVICE_ID_SOJI_OE2:	return 0;
		case DEVICE_ID_SOJI_OE3:	return 0;
		case DEVICE_ID_SOJI_OE4:	return 0;
		case DEVICE_ID_SOJI_OE5:	return 0;
		case DEVICE_ID_SOJI_OE6:	return 0;
		case DEVICE_ID_SOJI_OE7:	return 0;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetNumSerialPorts (auto-generated)


/**
	NTV2DeviceGetNumUpConverters
	Returns the number of up-converters on the device having the given ID.
**/
UWord NTV2DeviceGetNumUpConverters (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_IO4KUFC:		return 1;
		case DEVICE_ID_IOXT:		return 1;
		case DEVICE_ID_KONA3G:		return 1;
		case DEVICE_ID_KONA4UFC:	return 1;
		case DEVICE_ID_KONALHI:		return 1;
		case DEVICE_ID_KONALHIDVI:	return 1;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IOEXPRESS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_KONALHEPLUS:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetNumUpConverters (auto-generated)


/**
	NTV2DeviceGetNumVideoChannels
	Returns the number of video channels supported on the device having the given ID.
**/
ULWord NTV2DeviceGetNumVideoChannels (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID1:		return 2;
		case DEVICE_ID_CORVID22:	return 2;
		case DEVICE_ID_CORVID24:	return 4;
		case DEVICE_ID_CORVID3G:	return 2;
		case DEVICE_ID_CORVID44:	return 4;
		case DEVICE_ID_CORVID44_2X4K:	return 4;
		case DEVICE_ID_CORVID44_8K:	return 4;
		case DEVICE_ID_CORVID44_8KMK:	return 4;
		case DEVICE_ID_CORVID44_PLNR:	return 4;
		case DEVICE_ID_CORVID88:	return 8;
		case DEVICE_ID_CORVIDHBR:	return 4;
		case DEVICE_ID_CORVIDHEVC:	return 8;
		case DEVICE_ID_IO4K:		return 4;
		case DEVICE_ID_IO4KPLUS:	return 4;
		case DEVICE_ID_IO4KUFC:		return 2;
		case DEVICE_ID_IOEXPRESS:	return 1;
		case DEVICE_ID_IOIP_2022:	return 8;
		case DEVICE_ID_IOIP_2110:	return 8;
		case DEVICE_ID_IOIP_2110_RGB12:	return 4;
		case DEVICE_ID_IOX3:		return 4;
		case DEVICE_ID_IOXT:		return 2;
		case DEVICE_ID_KONA1:		return 2;
		case DEVICE_ID_KONA3G:		return 2;
		case DEVICE_ID_KONA3GQUAD:	return 4;
		case DEVICE_ID_KONA4:		return 4;
		case DEVICE_ID_KONA4UFC:	return 2;
		case DEVICE_ID_KONA5:		return 4;
		case DEVICE_ID_KONA5_2X4K:	return 4;
		case DEVICE_ID_KONA5_3DLUT:	return 2;
		case DEVICE_ID_KONA5_8K:	return 4;
		case DEVICE_ID_KONA5_8KMK:	return 4;
		case DEVICE_ID_KONA5_8K_MV_TX:	return 4;
		case DEVICE_ID_KONA5_OE1:	return 2;
		case DEVICE_ID_KONA5_OE10:	return 2;
		case DEVICE_ID_KONA5_OE11:	return 2;
		case DEVICE_ID_KONA5_OE12:	return 2;
		case DEVICE_ID_KONA5_OE2:	return 2;
		case DEVICE_ID_KONA5_OE3:	return 2;
		case DEVICE_ID_KONA5_OE4:	return 2;
		case DEVICE_ID_KONA5_OE5:	return 2;
		case DEVICE_ID_KONA5_OE6:	return 2;
		case DEVICE_ID_KONA5_OE7:	return 2;
		case DEVICE_ID_KONA5_OE8:	return 2;
		case DEVICE_ID_KONA5_OE9:	return 2;
		case DEVICE_ID_KONAHDMI:	return 4;
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:	return 2;
		case DEVICE_ID_KONAIP_1RX_1TX_2110:	return 4;
		case DEVICE_ID_KONAIP_2022:	return 4;
		case DEVICE_ID_KONAIP_2110:	return 4;
		case DEVICE_ID_KONAIP_2110_RGB12:	return 4;
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:	return 2;
		case DEVICE_ID_KONAIP_4CH_2SFP:	return 4;
		case DEVICE_ID_KONALHEPLUS:	return 2;
		case DEVICE_ID_KONALHI:		return 2;
		case DEVICE_ID_KONALHIDVI:	return 2;
		case DEVICE_ID_SOJI_3DLUT:	return 2;
		case DEVICE_ID_SOJI_OE1:	return 2;
		case DEVICE_ID_SOJI_OE2:	return 2;
		case DEVICE_ID_SOJI_OE3:	return 2;
		case DEVICE_ID_SOJI_OE4:	return 2;
		case DEVICE_ID_SOJI_OE5:	return 2;
		case DEVICE_ID_SOJI_OE6:	return 2;
		case DEVICE_ID_SOJI_OE7:	return 2;
		case DEVICE_ID_TTAP:		return 1;
		case DEVICE_ID_TTAP_PRO:	return 1;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_NOTFOUND:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetNumVideoChannels (auto-generated)


/**
	NTV2DeviceGetNumVideoInputs
	Returns the number of SDI video inputs on the device having the given ID.
**/
UWord NTV2DeviceGetNumVideoInputs (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID1:		return 1;
		case DEVICE_ID_CORVID22:	return 2;
		case DEVICE_ID_CORVID24:	return 4;
		case DEVICE_ID_CORVID3G:	return 1;
		case DEVICE_ID_CORVID44:	return 4;
		case DEVICE_ID_CORVID44_2X4K:	return 4;
		case DEVICE_ID_CORVID44_8K:	return 4;
		case DEVICE_ID_CORVID44_8KMK:	return 4;
		case DEVICE_ID_CORVID44_PLNR:	return 4;
		case DEVICE_ID_CORVID88:	return 8;
		case DEVICE_ID_CORVIDHEVC:	return 4;
		case DEVICE_ID_IO4K:		return 4;
		case DEVICE_ID_IO4KPLUS:	return 4;
		case DEVICE_ID_IO4KUFC:		return 2;
		case DEVICE_ID_IOEXPRESS:	return 1;
		case DEVICE_ID_IOIP_2022:	return 4;
		case DEVICE_ID_IOIP_2110:	return 4;
		case DEVICE_ID_IOIP_2110_RGB12:	return 0;
		case DEVICE_ID_IOX3:		return 4;
		case DEVICE_ID_IOXT:		return 2;
		case DEVICE_ID_KONA1:		return 1;
		case DEVICE_ID_KONA3G:		return 2;
		case DEVICE_ID_KONA3GQUAD:	return 4;
		case DEVICE_ID_KONA4:		return 4;
		case DEVICE_ID_KONA4UFC:	return 2;
		case DEVICE_ID_KONA5:		return 4;
		case DEVICE_ID_KONA5_2X4K:	return 4;
		case DEVICE_ID_KONA5_3DLUT:	return 2;
		case DEVICE_ID_KONA5_8K:	return 4;
		case DEVICE_ID_KONA5_8KMK:	return 4;
		case DEVICE_ID_KONA5_8K_MV_TX:	return 1;
		case DEVICE_ID_KONA5_OE1:	return 2;
		case DEVICE_ID_KONA5_OE10:	return 2;
		case DEVICE_ID_KONA5_OE11:	return 2;
		case DEVICE_ID_KONA5_OE12:	return 2;
		case DEVICE_ID_KONA5_OE2:	return 2;
		case DEVICE_ID_KONA5_OE3:	return 2;
		case DEVICE_ID_KONA5_OE4:	return 2;
		case DEVICE_ID_KONA5_OE5:	return 2;
		case DEVICE_ID_KONA5_OE6:	return 2;
		case DEVICE_ID_KONA5_OE7:	return 2;
		case DEVICE_ID_KONA5_OE8:	return 2;
		case DEVICE_ID_KONA5_OE9:	return 2;
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:	return 1;
		case DEVICE_ID_KONAIP_1RX_1TX_2110:	return 4;
		case DEVICE_ID_KONAIP_2022:	return 4;
		case DEVICE_ID_KONAIP_2110:	return 4;
		case DEVICE_ID_KONAIP_2110_RGB12:	return 0;
		case DEVICE_ID_KONAIP_4CH_2SFP:	return 4;
		case DEVICE_ID_KONALHEPLUS:	return 1;
		case DEVICE_ID_KONALHI:		return 1;
		case DEVICE_ID_KONALHIDVI:	return 1;
		case DEVICE_ID_SOJI_3DLUT:	return 2;
		case DEVICE_ID_SOJI_OE1:	return 2;
		case DEVICE_ID_SOJI_OE2:	return 2;
		case DEVICE_ID_SOJI_OE3:	return 2;
		case DEVICE_ID_SOJI_OE4:	return 2;
		case DEVICE_ID_SOJI_OE5:	return 2;
		case DEVICE_ID_SOJI_OE6:	return 2;
		case DEVICE_ID_SOJI_OE7:	return 2;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetNumVideoInputs (auto-generated)


/**
	NTV2DeviceGetNumVideoOutputs
	Returns the number of SDI video outputs on the device having the given ID.
**/
UWord NTV2DeviceGetNumVideoOutputs (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID1:		return 1;
		case DEVICE_ID_CORVID22:	return 2;
		case DEVICE_ID_CORVID24:	return 4;
		case DEVICE_ID_CORVID3G:	return 1;
		case DEVICE_ID_CORVID44:	return 4;
		case DEVICE_ID_CORVID44_2X4K:	return 4;
		case DEVICE_ID_CORVID44_8K:	return 4;
		case DEVICE_ID_CORVID44_8KMK:	return 4;
		case DEVICE_ID_CORVID44_PLNR:	return 1;
		case DEVICE_ID_CORVID88:	return 8;
		case DEVICE_ID_CORVIDHEVC:	return 8;
		case DEVICE_ID_IO4K:		return 5;
		case DEVICE_ID_IO4KPLUS:	return 5;
		case DEVICE_ID_IO4KUFC:		return 3;
		case DEVICE_ID_IOEXPRESS:	return 1;
		case DEVICE_ID_IOIP_2022:	return 5;
		case DEVICE_ID_IOIP_2110:	return 5;
		case DEVICE_ID_IOIP_2110_RGB12:	return 5;
		case DEVICE_ID_IOX3:		return 4;
		case DEVICE_ID_IOXT:		return 2;
		case DEVICE_ID_KONA1:		return 1;
		case DEVICE_ID_KONA3G:		return 2;
		case DEVICE_ID_KONA3GQUAD:	return 4;
		case DEVICE_ID_KONA4:		return 4;
		case DEVICE_ID_KONA4UFC:	return 2;
		case DEVICE_ID_KONA5:		return 4;
		case DEVICE_ID_KONA5_2X4K:	return 4;
		case DEVICE_ID_KONA5_3DLUT:	return 2;
		case DEVICE_ID_KONA5_8K:	return 4;
		case DEVICE_ID_KONA5_8KMK:	return 4;
		case DEVICE_ID_KONA5_8K_MV_TX:	return 4;
		case DEVICE_ID_KONA5_OE1:	return 2;
		case DEVICE_ID_KONA5_OE10:	return 2;
		case DEVICE_ID_KONA5_OE11:	return 2;
		case DEVICE_ID_KONA5_OE12:	return 2;
		case DEVICE_ID_KONA5_OE2:	return 2;
		case DEVICE_ID_KONA5_OE3:	return 2;
		case DEVICE_ID_KONA5_OE4:	return 2;
		case DEVICE_ID_KONA5_OE5:	return 2;
		case DEVICE_ID_KONA5_OE6:	return 2;
		case DEVICE_ID_KONA5_OE7:	return 2;
		case DEVICE_ID_KONA5_OE8:	return 2;
		case DEVICE_ID_KONA5_OE9:	return 2;
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:	return 1;
		case DEVICE_ID_KONAIP_1RX_1TX_2110:	return 4;
		case DEVICE_ID_KONAIP_2022:	return 4;
		case DEVICE_ID_KONAIP_2110:	return 4;
		case DEVICE_ID_KONAIP_2110_RGB12:	return 4;
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:	return 2;
		case DEVICE_ID_KONAIP_4CH_2SFP:	return 4;
		case DEVICE_ID_KONALHEPLUS:	return 2;
		case DEVICE_ID_KONALHI:		return 1;
		case DEVICE_ID_KONALHIDVI:	return 1;
		case DEVICE_ID_SOJI_3DLUT:	return 2;
		case DEVICE_ID_SOJI_OE1:	return 2;
		case DEVICE_ID_SOJI_OE2:	return 2;
		case DEVICE_ID_SOJI_OE3:	return 2;
		case DEVICE_ID_SOJI_OE4:	return 2;
		case DEVICE_ID_SOJI_OE5:	return 2;
		case DEVICE_ID_SOJI_OE6:	return 2;
		case DEVICE_ID_SOJI_OE7:	return 2;
		case DEVICE_ID_TTAP:		return 1;
		case DEVICE_ID_TTAP_PRO:	return 1;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_NOTFOUND:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetNumVideoOutputs (auto-generated)


/**
	NTV2DeviceGetPingLED
	Returns the highest bit number of the LED bits in the Global Control Register on the device having the given ID.
**/
ULWord NTV2DeviceGetPingLED (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID1:		return BIT(19);
		case DEVICE_ID_CORVID22:	return BIT(19);
		case DEVICE_ID_CORVID24:	return BIT(16);
		case DEVICE_ID_CORVID3G:	return BIT(19);
		case DEVICE_ID_CORVID44:	return BIT(16);
		case DEVICE_ID_CORVID44_2X4K:	return BIT(16);
		case DEVICE_ID_CORVID44_8K:	return BIT(16);
		case DEVICE_ID_CORVID44_8KMK:	return BIT(16);
		case DEVICE_ID_CORVID44_PLNR:	return BIT(16);
		case DEVICE_ID_CORVID88:	return BIT(16);
		case DEVICE_ID_CORVIDHBR:	return BIT(16);
		case DEVICE_ID_CORVIDHEVC:	return BIT(16);
		case DEVICE_ID_IO4K:		return BIT(16);
		case DEVICE_ID_IO4KPLUS:	return BIT(16);
		case DEVICE_ID_IO4KUFC:		return BIT(16);
		case DEVICE_ID_IOEXPRESS:	return BIT(16);
		case DEVICE_ID_IOIP_2022:	return BIT(16);
		case DEVICE_ID_IOIP_2110:	return BIT(16);
		case DEVICE_ID_IOIP_2110_RGB12:	return BIT(16);
		case DEVICE_ID_IOX3:		return BIT(16);
		case DEVICE_ID_IOXT:		return BIT(16);
		case DEVICE_ID_KONA1:		return BIT(19);
		case DEVICE_ID_KONA3G:		return BIT(16);
		case DEVICE_ID_KONA3GQUAD:	return BIT(16);
		case DEVICE_ID_KONA4:		return BIT(16);
		case DEVICE_ID_KONA4UFC:	return BIT(16);
		case DEVICE_ID_KONA5:		return BIT(16);
		case DEVICE_ID_KONA5_2X4K:	return BIT(16);
		case DEVICE_ID_KONA5_3DLUT:	return BIT(16);
		case DEVICE_ID_KONA5_8K:	return BIT(16);
		case DEVICE_ID_KONA5_8KMK:	return BIT(16);
		case DEVICE_ID_KONA5_8K_MV_TX:	return BIT(16);
		case DEVICE_ID_KONA5_OE1:	return BIT(16);
		case DEVICE_ID_KONA5_OE10:	return BIT(16);
		case DEVICE_ID_KONA5_OE11:	return BIT(16);
		case DEVICE_ID_KONA5_OE12:	return BIT(16);
		case DEVICE_ID_KONA5_OE2:	return BIT(16);
		case DEVICE_ID_KONA5_OE3:	return BIT(16);
		case DEVICE_ID_KONA5_OE4:	return BIT(16);
		case DEVICE_ID_KONA5_OE5:	return BIT(16);
		case DEVICE_ID_KONA5_OE6:	return BIT(16);
		case DEVICE_ID_KONA5_OE7:	return BIT(16);
		case DEVICE_ID_KONA5_OE8:	return BIT(16);
		case DEVICE_ID_KONA5_OE9:	return BIT(16);
		case DEVICE_ID_KONAHDMI:	return BIT(16);
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:	return BIT(16);
		case DEVICE_ID_KONAIP_1RX_1TX_2110:	return BIT(16);
		case DEVICE_ID_KONAIP_2022:	return BIT(16);
		case DEVICE_ID_KONAIP_2110:	return BIT(16);
		case DEVICE_ID_KONAIP_2110_RGB12:	return BIT(16);
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:	return BIT(16);
		case DEVICE_ID_KONAIP_4CH_2SFP:	return BIT(16);
		case DEVICE_ID_KONALHEPLUS:	return BIT(16);
		case DEVICE_ID_KONALHI:		return BIT(16);
		case DEVICE_ID_KONALHIDVI:	return BIT(16);
		case DEVICE_ID_SOJI_3DLUT:	return BIT(16);
		case DEVICE_ID_SOJI_OE1:	return BIT(16);
		case DEVICE_ID_SOJI_OE2:	return BIT(16);
		case DEVICE_ID_SOJI_OE3:	return BIT(16);
		case DEVICE_ID_SOJI_OE4:	return BIT(16);
		case DEVICE_ID_SOJI_OE5:	return BIT(16);
		case DEVICE_ID_SOJI_OE6:	return BIT(16);
		case DEVICE_ID_SOJI_OE7:	return BIT(16);
		case DEVICE_ID_TTAP:		return BIT(16);
		case DEVICE_ID_TTAP_PRO:	return BIT(16);
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_NOTFOUND:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetPingLED (auto-generated)


/**
	NTV2DeviceGetUFCVersion
	Returns the version number of the UFC on the device having the given ID.
**/
ULWord NTV2DeviceGetUFCVersion (const NTV2DeviceID inDeviceID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_IO4KUFC:		return 2;
		case DEVICE_ID_IOEXPRESS:	return 1;
		case DEVICE_ID_IOXT:		return 1;
		case DEVICE_ID_KONA3G:		return 1;
		case DEVICE_ID_KONA4UFC:	return 2;
		case DEVICE_ID_KONALHEPLUS:	return 1;
		case DEVICE_ID_KONALHI:		return 1;
		case DEVICE_ID_KONALHIDVI:	return 1;
	#if defined(_DEBUG)		// These devices all return zero:
		case DEVICE_ID_CORVID1:
		case DEVICE_ID_CORVID22:
		case DEVICE_ID_CORVID24:
		case DEVICE_ID_CORVID3G:
		case DEVICE_ID_CORVID44:
		case DEVICE_ID_CORVID44_2X4K:
		case DEVICE_ID_CORVID44_8K:
		case DEVICE_ID_CORVID44_8KMK:
		case DEVICE_ID_CORVID44_PLNR:
		case DEVICE_ID_CORVID88:
		case DEVICE_ID_CORVIDHBR:
		case DEVICE_ID_CORVIDHEVC:
		case DEVICE_ID_IO4K:
		case DEVICE_ID_IO4KPLUS:
		case DEVICE_ID_IOIP_2022:
		case DEVICE_ID_IOIP_2110:
		case DEVICE_ID_IOIP_2110_RGB12:
		case DEVICE_ID_IOX3:
		case DEVICE_ID_KONA1:
		case DEVICE_ID_KONA3GQUAD:
		case DEVICE_ID_KONA4:
		case DEVICE_ID_KONA5:
		case DEVICE_ID_KONA5_2X4K:
		case DEVICE_ID_KONA5_3DLUT:
		case DEVICE_ID_KONA5_8K:
		case DEVICE_ID_KONA5_8KMK:
		case DEVICE_ID_KONA5_8K_MV_TX:
		case DEVICE_ID_KONA5_OE1:
		case DEVICE_ID_KONA5_OE10:
		case DEVICE_ID_KONA5_OE11:
		case DEVICE_ID_KONA5_OE12:
		case DEVICE_ID_KONA5_OE2:
		case DEVICE_ID_KONA5_OE3:
		case DEVICE_ID_KONA5_OE4:
		case DEVICE_ID_KONA5_OE5:
		case DEVICE_ID_KONA5_OE6:
		case DEVICE_ID_KONA5_OE7:
		case DEVICE_ID_KONA5_OE8:
		case DEVICE_ID_KONA5_OE9:
		case DEVICE_ID_KONAHDMI:
		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_1RX_1TX_2110:
		case DEVICE_ID_KONAIP_2022:
		case DEVICE_ID_KONAIP_2110:
		case DEVICE_ID_KONAIP_2110_RGB12:
		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
		case DEVICE_ID_KONAIP_4CH_2SFP:
		case DEVICE_ID_NOTFOUND:
		case DEVICE_ID_SOJI_3DLUT:
		case DEVICE_ID_SOJI_OE1:
		case DEVICE_ID_SOJI_OE2:
		case DEVICE_ID_SOJI_OE3:
		case DEVICE_ID_SOJI_OE4:
		case DEVICE_ID_SOJI_OE5:
		case DEVICE_ID_SOJI_OE6:
		case DEVICE_ID_SOJI_OE7:
		case DEVICE_ID_TTAP:
		case DEVICE_ID_TTAP_PRO:
	#else
		default:
	#endif	//	defined(_DEBUG)
			break;
	}	//	switch on inDeviceID

	return 0;

}	//  NTV2DeviceGetUFCVersion (auto-generated)


/**
	NTV2DeviceCanDoConversionMode
**/
bool NTV2DeviceCanDoConversionMode (const NTV2DeviceID inDeviceID, const NTV2ConversionMode inConversionMode)
{
	switch (inConversionMode)
	{
		case NTV2_1080i2398to525_2398:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_1080i2398to525_2398:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_1080i2398to525_2398
			break;	//  NTV2_1080i2398to525_2398

		case NTV2_1080i2398to525_2997:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_1080i2398to525_2997:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_1080i2398to525_2997
			break;	//  NTV2_1080i2398to525_2997

		case NTV2_1080i2400to525_2400:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_1080i2400to525_2400:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_1080i2400to525_2400
			break;	//  NTV2_1080i2400to525_2400

		case NTV2_1080i_2398to720p_2398:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_1080i_2398to720p_2398:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_1080i_2398to720p_2398
			break;	//  NTV2_1080i_2398to720p_2398

		case NTV2_1080i_2500to625_2500:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_1080i_2500to625_2500:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_1080i_2500to625_2500
			break;	//  NTV2_1080i_2500to625_2500

		case NTV2_1080i_2500to720p_5000:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_1080i_2500to720p_5000:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_1080i_2500to720p_5000
			break;	//  NTV2_1080i_2500to720p_5000

		case NTV2_1080i_3000to720p_6000:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_1080i_3000to720p_6000:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_1080i_3000to720p_6000
			break;	//  NTV2_1080i_3000to720p_6000

		case NTV2_1080i_5000to1080psf_2500:
			switch (inDeviceID)
			{
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA4UFC:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_1080i_5000to1080psf_2500:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
				case DEVICE_ID_KONALHIDVI:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_1080i_5000to1080psf_2500
			break;	//  NTV2_1080i_5000to1080psf_2500

		case NTV2_1080i_5994to1080psf_2997:
			switch (inDeviceID)
			{
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA4UFC:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_1080i_5994to1080psf_2997:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
				case DEVICE_ID_KONALHIDVI:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_1080i_5994to1080psf_2997
			break;	//  NTV2_1080i_5994to1080psf_2997

		case NTV2_1080i_5994to525_5994:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_1080i_5994to525_5994:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_1080i_5994to525_5994
			break;	//  NTV2_1080i_5994to525_5994

		case NTV2_1080i_5994to720p_5994:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_1080i_5994to720p_5994:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_1080i_5994to720p_5994
			break;	//  NTV2_1080i_5994to720p_5994

		case NTV2_1080i_6000to1080psf_3000:
			switch (inDeviceID)
			{
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA4UFC:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_1080i_6000to1080psf_3000:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
				case DEVICE_ID_KONALHIDVI:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_1080i_6000to1080psf_3000
			break;	//  NTV2_1080i_6000to1080psf_3000

		case NTV2_1080p2398to525_2398:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_1080p2398to525_2398:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_1080p2398to525_2398
			break;	//  NTV2_1080p2398to525_2398

		case NTV2_1080p2398to525_2997:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_1080p2398to525_2997:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_1080p2398to525_2997
			break;	//  NTV2_1080p2398to525_2997

		case NTV2_1080p2400to525_2400:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_1080p2400to525_2400:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_1080p2400to525_2400
			break;	//  NTV2_1080p2400to525_2400

		case NTV2_525_2398to1080i_2398:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_525_2398to1080i_2398:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_525_2398to1080i_2398
			break;	//  NTV2_525_2398to1080i_2398

		case NTV2_525_5994to1080i_5994:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_525_5994to1080i_5994:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_525_5994to1080i_5994
			break;	//  NTV2_525_5994to1080i_5994

		case NTV2_525_5994to525_5994:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_525_5994to525_5994:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_525_5994to525_5994
			break;	//  NTV2_525_5994to525_5994

		case NTV2_525_5994to525psf_2997:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_525_5994to525psf_2997:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_525_5994to525psf_2997
			break;	//  NTV2_525_5994to525psf_2997

		case NTV2_525_5994to720p_5994:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_525_5994to720p_5994:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_525_5994to720p_5994
			break;	//  NTV2_525_5994to720p_5994

		case NTV2_625_2500to1080i_2500:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_625_2500to1080i_2500:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_625_2500to1080i_2500
			break;	//  NTV2_625_2500to1080i_2500

		case NTV2_625_2500to625_2500:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_625_2500to625_2500:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_625_2500to625_2500
			break;	//  NTV2_625_2500to625_2500

		case NTV2_625_2500to720p_5000:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_625_2500to720p_5000:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_625_2500to720p_5000
			break;	//  NTV2_625_2500to720p_5000

		case NTV2_625_5000to625psf_2500:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_625_5000to625psf_2500:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_625_5000to625psf_2500
			break;	//  NTV2_625_5000to625psf_2500

		case NTV2_720p_2398to1080i_2398:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_720p_2398to1080i_2398:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_720p_2398to1080i_2398
			break;	//  NTV2_720p_2398to1080i_2398

		case NTV2_720p_5000to1080i_2500:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_720p_5000to1080i_2500:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_720p_5000to1080i_2500
			break;	//  NTV2_720p_5000to1080i_2500

		case NTV2_720p_5000to625_2500:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_720p_5000to625_2500:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_720p_5000to625_2500
			break;	//  NTV2_720p_5000to625_2500

		case NTV2_720p_5994to1080i_5994:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_720p_5994to1080i_5994:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_720p_5994to1080i_5994
			break;	//  NTV2_720p_5994to1080i_5994

		case NTV2_720p_5994to525_5994:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_720p_5994to525_5994:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_720p_5994to525_5994
			break;	//  NTV2_720p_5994to525_5994

		case NTV2_720p_6000to1080i_3000:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_720p_6000to1080i_3000:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_720p_6000to1080i_3000
			break;	//  NTV2_720p_6000to1080i_3000

	#if defined(_DEBUG)		// These are unreferenced:
		case NTV2_1080p_2398to1080i_5994:
		case NTV2_1080p_2400to1080i_3000:
		case NTV2_1080p_2500to1080i_2500:
		case NTV2_1080p_3000to720p_6000:
		case NTV2_1080psf_2398to1080i_5994:
		case NTV2_1080psf_2400to1080i_3000:
		case NTV2_1080psf_2500to1080i_2500:
		case NTV2_CONVERSIONMODE_INVALID:
	#else
		default:
	#endif
			break;
	}	//  switch on inConversionMode

	return false;

}	//  NTV2DeviceCanDoConversionMode (auto-generated)


/**
	NTV2DeviceCanDoDSKMode
**/
bool NTV2DeviceCanDoDSKMode (const NTV2DeviceID inDeviceID, const NTV2DSKMode inDSKMode)
{
	switch (inDSKMode)
	{
		case NTV2_DSKModeFBOverMatte:
			switch (inDeviceID)
			{
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_DSKModeFBOverMatte:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_SOJI_OE4:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_DSKModeFBOverMatte
			break;	//  NTV2_DSKModeFBOverMatte

		case NTV2_DSKModeFBOverVideoIn:
			switch (inDeviceID)
			{
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_DSKModeFBOverVideoIn:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_SOJI_OE4:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_DSKModeFBOverVideoIn
			break;	//  NTV2_DSKModeFBOverVideoIn

		case NTV2_DSKModeGraphicOverFB:
			switch (inDeviceID)
			{
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_DSKModeGraphicOverFB:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_SOJI_OE4:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_DSKModeGraphicOverFB
			break;	//  NTV2_DSKModeGraphicOverFB

		case NTV2_DSKModeGraphicOverMatte:
			switch (inDeviceID)
			{
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_DSKModeGraphicOverMatte:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_SOJI_OE4:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_DSKModeGraphicOverMatte
			break;	//  NTV2_DSKModeGraphicOverMatte

		case NTV2_DSKModeGraphicOverVideoIn:
			switch (inDeviceID)
			{
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_DSKModeGraphicOverVideoIn:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_SOJI_OE4:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_DSKModeGraphicOverVideoIn
			break;	//  NTV2_DSKModeGraphicOverVideoIn

		case NTV2_DSKModeOff:
			switch (inDeviceID)
			{
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_DSKModeOff:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_SOJI_OE4:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_DSKModeOff
			break;	//  NTV2_DSKModeOff

	#if defined(_DEBUG)		// These are unreferenced:
		case NTV2_DSKMODE_INVALID:
	#else
		default:
	#endif
			break;
	}	//  switch on inDSKMode

	return false;

}	//  NTV2DeviceCanDoDSKMode (auto-generated)


/**
	NTV2DeviceCanDoFrameBufferFormat
**/
bool NTV2DeviceCanDoFrameBufferFormat (const NTV2DeviceID inDeviceID, const NTV2FrameBufferFormat inFBFormat)
{
	switch (inFBFormat)
	{
		case NTV2_FBF_10BIT_DPX:
			switch (inDeviceID)
			{
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_FBF_10BIT_DPX:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_CORVIDHEVC:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_FBF_10BIT_DPX
			break;	//  NTV2_FBF_10BIT_DPX

		case NTV2_FBF_10BIT_DPX_LE:
			switch (inDeviceID)
			{
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_FBF_10BIT_DPX_LE:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_CORVIDHEVC:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_FBF_10BIT_DPX_LE
			break;	//  NTV2_FBF_10BIT_DPX_LE

		case NTV2_FBF_10BIT_RAW_RGB:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_KONAIP_2110_RGB12:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_FBF_10BIT_RAW_RGB:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
				case DEVICE_ID_KONALHIDVI:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_FBF_10BIT_RAW_RGB
			break;	//  NTV2_FBF_10BIT_RAW_RGB

		case NTV2_FBF_10BIT_RAW_YCBCR:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_KONAIP_2110_RGB12:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_FBF_10BIT_RAW_YCBCR:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
				case DEVICE_ID_KONALHIDVI:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_FBF_10BIT_RAW_YCBCR
			break;	//  NTV2_FBF_10BIT_RAW_YCBCR

		case NTV2_FBF_10BIT_RGB:
			switch (inDeviceID)
			{
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_FBF_10BIT_RGB:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_CORVIDHEVC:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_FBF_10BIT_RGB
			break;	//  NTV2_FBF_10BIT_RGB

		case NTV2_FBF_10BIT_YCBCR:
			switch (inDeviceID)
			{
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_FBF_10BIT_YCBCR:
				case DEVICE_ID_NOTFOUND:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_FBF_10BIT_YCBCR
			break;	//  NTV2_FBF_10BIT_YCBCR

		case NTV2_FBF_10BIT_YCBCR_420PL2:
			switch (inDeviceID)
			{
				case DEVICE_ID_CORVIDHEVC:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_FBF_10BIT_YCBCR_420PL2:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
				case DEVICE_ID_KONALHIDVI:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_FBF_10BIT_YCBCR_420PL2
			break;	//  NTV2_FBF_10BIT_YCBCR_420PL2

		case NTV2_FBF_10BIT_YCBCR_420PL3_LE:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_CORVID44:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_FBF_10BIT_YCBCR_420PL3_LE:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_SOJI_OE4:
				case DEVICE_ID_KONALHIDVI:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_FBF_10BIT_YCBCR_420PL3_LE
			break;	//  NTV2_FBF_10BIT_YCBCR_420PL3_LE

		case NTV2_FBF_10BIT_YCBCR_422PL2:
			switch (inDeviceID)
			{
				case DEVICE_ID_CORVIDHEVC:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_FBF_10BIT_YCBCR_422PL2:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
				case DEVICE_ID_KONALHIDVI:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_FBF_10BIT_YCBCR_422PL2
			break;	//  NTV2_FBF_10BIT_YCBCR_422PL2

		case NTV2_FBF_10BIT_YCBCR_422PL3_LE:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_CORVID44:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_FBF_10BIT_YCBCR_422PL3_LE:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_SOJI_OE4:
				case DEVICE_ID_KONALHIDVI:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_FBF_10BIT_YCBCR_422PL3_LE
			break;	//  NTV2_FBF_10BIT_YCBCR_422PL3_LE

		case NTV2_FBF_10BIT_YCBCR_DPX:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONA1:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_FBF_10BIT_YCBCR_DPX:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
				case DEVICE_ID_KONALHIDVI:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_FBF_10BIT_YCBCR_DPX
			break;	//  NTV2_FBF_10BIT_YCBCR_DPX

		case NTV2_FBF_12BIT_RGB_PACKED:
			switch (inDeviceID)
			{
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE4:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_FBF_12BIT_RGB_PACKED:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_KONALHIDVI:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_FBF_12BIT_RGB_PACKED
			break;	//  NTV2_FBF_12BIT_RGB_PACKED

		case NTV2_FBF_24BIT_BGR:
			switch (inDeviceID)
			{
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_FBF_24BIT_BGR:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_CORVIDHEVC:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_FBF_24BIT_BGR
			break;	//  NTV2_FBF_24BIT_BGR

		case NTV2_FBF_24BIT_RGB:
			switch (inDeviceID)
			{
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_FBF_24BIT_RGB:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_CORVIDHEVC:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_FBF_24BIT_RGB
			break;	//  NTV2_FBF_24BIT_RGB

		case NTV2_FBF_48BIT_RGB:
			switch (inDeviceID)
			{
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_FBF_48BIT_RGB:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_CORVIDHEVC:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_FBF_48BIT_RGB
			break;	//  NTV2_FBF_48BIT_RGB

		case NTV2_FBF_8BIT_DVCPRO:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_FBF_8BIT_DVCPRO:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_FBF_8BIT_DVCPRO
			break;	//  NTV2_FBF_8BIT_DVCPRO

		case NTV2_FBF_8BIT_HDV:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_FBF_8BIT_HDV:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_FBF_8BIT_HDV
			break;	//  NTV2_FBF_8BIT_HDV

		case NTV2_FBF_8BIT_YCBCR:
			switch (inDeviceID)
			{
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_FBF_8BIT_YCBCR:
				case DEVICE_ID_NOTFOUND:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_FBF_8BIT_YCBCR
			break;	//  NTV2_FBF_8BIT_YCBCR

		case NTV2_FBF_8BIT_YCBCR_420PL2:
			switch (inDeviceID)
			{
				case DEVICE_ID_CORVIDHEVC:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_FBF_8BIT_YCBCR_420PL2:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
				case DEVICE_ID_KONALHIDVI:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_FBF_8BIT_YCBCR_420PL2
			break;	//  NTV2_FBF_8BIT_YCBCR_420PL2

		case NTV2_FBF_8BIT_YCBCR_420PL3:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_CORVID44:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_FBF_8BIT_YCBCR_420PL3:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_SOJI_OE4:
				case DEVICE_ID_KONALHIDVI:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_FBF_8BIT_YCBCR_420PL3
			break;	//  NTV2_FBF_8BIT_YCBCR_420PL3

		case NTV2_FBF_8BIT_YCBCR_422PL2:
			switch (inDeviceID)
			{
				case DEVICE_ID_CORVIDHEVC:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_FBF_8BIT_YCBCR_422PL2:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
				case DEVICE_ID_KONALHIDVI:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_FBF_8BIT_YCBCR_422PL2
			break;	//  NTV2_FBF_8BIT_YCBCR_422PL2

		case NTV2_FBF_8BIT_YCBCR_422PL3:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_CORVID44:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_FBF_8BIT_YCBCR_422PL3:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_SOJI_OE4:
				case DEVICE_ID_KONALHIDVI:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_FBF_8BIT_YCBCR_422PL3
			break;	//  NTV2_FBF_8BIT_YCBCR_422PL3

		case NTV2_FBF_8BIT_YCBCR_YUY2:
			switch (inDeviceID)
			{
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_FBF_8BIT_YCBCR_YUY2:
				case DEVICE_ID_NOTFOUND:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_FBF_8BIT_YCBCR_YUY2
			break;	//  NTV2_FBF_8BIT_YCBCR_YUY2

		case NTV2_FBF_ABGR:
			switch (inDeviceID)
			{
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_FBF_ABGR:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_CORVIDHEVC:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_FBF_ABGR
			break;	//  NTV2_FBF_ABGR

		case NTV2_FBF_ARGB:
			switch (inDeviceID)
			{
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_FBF_ARGB:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_CORVIDHEVC:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_FBF_ARGB
			break;	//  NTV2_FBF_ARGB

		case NTV2_FBF_RGBA:
			switch (inDeviceID)
			{
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_FBF_RGBA:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_CORVIDHEVC:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_FBF_RGBA
			break;	//  NTV2_FBF_RGBA

	#if defined(_DEBUG)		// These are unreferenced:
		case NTV2_FBF_10BIT_ARGB:
		case NTV2_FBF_10BIT_RGB_PACKED:
		case NTV2_FBF_10BIT_YCBCRA:
		case NTV2_FBF_16BIT_ARGB:
		case NTV2_FBF_INVALID:
		case NTV2_FBF_PRORES_DVCPRO:
		case NTV2_FBF_PRORES_HDV:
	#else
		default:
	#endif
			break;
	}	//  switch on inFBFormat

	return false;

}	//  NTV2DeviceCanDoFrameBufferFormat (auto-generated)


/**
	NTV2DeviceCanDoInputSource
**/
bool NTV2DeviceCanDoInputSource (const NTV2DeviceID inDeviceID, const NTV2InputSource inInputSource)
{
	switch (inInputSource)
	{
		case NTV2_INPUTSOURCE_ANALOG1:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_INPUTSOURCE_ANALOG1:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_INPUTSOURCE_ANALOG1
			break;	//  NTV2_INPUTSOURCE_ANALOG1

		case NTV2_INPUTSOURCE_HDMI1:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_INPUTSOURCE_HDMI1:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_INPUTSOURCE_HDMI1
			break;	//  NTV2_INPUTSOURCE_HDMI1

		case NTV2_INPUTSOURCE_HDMI2:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONAHDMI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_INPUTSOURCE_HDMI2:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
				case DEVICE_ID_KONALHIDVI:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_INPUTSOURCE_HDMI2
			break;	//  NTV2_INPUTSOURCE_HDMI2

		case NTV2_INPUTSOURCE_HDMI3:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONAHDMI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_INPUTSOURCE_HDMI3:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
				case DEVICE_ID_KONALHIDVI:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_INPUTSOURCE_HDMI3
			break;	//  NTV2_INPUTSOURCE_HDMI3

		case NTV2_INPUTSOURCE_HDMI4:
			switch (inDeviceID)
			{
				case DEVICE_ID_KONAHDMI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_INPUTSOURCE_HDMI4:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
				case DEVICE_ID_KONALHIDVI:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_INPUTSOURCE_HDMI4
			break;	//  NTV2_INPUTSOURCE_HDMI4

		case NTV2_INPUTSOURCE_SDI1:
			switch (inDeviceID)
			{
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
				case DEVICE_ID_KONALHIDVI:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_INPUTSOURCE_SDI1:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_KONAIP_2110_RGB12:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_INPUTSOURCE_SDI1
			break;	//  NTV2_INPUTSOURCE_SDI1

		case NTV2_INPUTSOURCE_SDI2:
			switch (inDeviceID)
			{
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_INPUTSOURCE_SDI2:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_KONALHIDVI:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_INPUTSOURCE_SDI2
			break;	//  NTV2_INPUTSOURCE_SDI2

		case NTV2_INPUTSOURCE_SDI3:
			switch (inDeviceID)
			{
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_CORVID44:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_INPUTSOURCE_SDI3:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_SOJI_OE4:
				case DEVICE_ID_KONALHIDVI:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_INPUTSOURCE_SDI3
			break;	//  NTV2_INPUTSOURCE_SDI3

		case NTV2_INPUTSOURCE_SDI4:
			switch (inDeviceID)
			{
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_CORVID88:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_CORVID44:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_INPUTSOURCE_SDI4:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_SOJI_OE4:
				case DEVICE_ID_KONALHIDVI:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_INPUTSOURCE_SDI4
			break;	//  NTV2_INPUTSOURCE_SDI4

		case NTV2_INPUTSOURCE_SDI5:
			switch (inDeviceID)
			{
				case DEVICE_ID_CORVID88:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_INPUTSOURCE_SDI5:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
				case DEVICE_ID_KONALHIDVI:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_INPUTSOURCE_SDI5
			break;	//  NTV2_INPUTSOURCE_SDI5

		case NTV2_INPUTSOURCE_SDI6:
			switch (inDeviceID)
			{
				case DEVICE_ID_CORVID88:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_INPUTSOURCE_SDI6:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
				case DEVICE_ID_KONALHIDVI:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_INPUTSOURCE_SDI6
			break;	//  NTV2_INPUTSOURCE_SDI6

		case NTV2_INPUTSOURCE_SDI7:
			switch (inDeviceID)
			{
				case DEVICE_ID_CORVID88:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_INPUTSOURCE_SDI7:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
				case DEVICE_ID_KONALHIDVI:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_INPUTSOURCE_SDI7
			break;	//  NTV2_INPUTSOURCE_SDI7

		case NTV2_INPUTSOURCE_SDI8:
			switch (inDeviceID)
			{
				case DEVICE_ID_CORVID88:
					return true;
			#if defined(_DEBUG)		// These devices don't support NTV2_INPUTSOURCE_SDI8:
				case DEVICE_ID_SOJI_OE6:
				case DEVICE_ID_KONALHI:
				case DEVICE_ID_CORVID44_8KMK:
				case DEVICE_ID_SOJI_OE2:
				case DEVICE_ID_IOEXPRESS:
				case DEVICE_ID_IO4KPLUS:
				case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case DEVICE_ID_TTAP_PRO:
				case DEVICE_ID_IOIP_2022:
				case DEVICE_ID_KONAIP_1RX_1TX_2110:
				case DEVICE_ID_KONA4:
				case DEVICE_ID_TTAP:
				case DEVICE_ID_SOJI_OE5:
				case DEVICE_ID_CORVID24:
				case DEVICE_ID_IO4K:
				case DEVICE_ID_CORVID44_2X4K:
				case DEVICE_ID_KONAIP_4CH_2SFP:
				case DEVICE_ID_KONA1:
				case DEVICE_ID_IO4KUFC:
				case DEVICE_ID_KONAHDMI:
				case DEVICE_ID_KONAIP_2022:
				case DEVICE_ID_KONA5:
				case DEVICE_ID_IOXT:
				case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case DEVICE_ID_SOJI_3DLUT:
				case DEVICE_ID_KONA5_OE9:
				case DEVICE_ID_KONA5_OE8:
				case DEVICE_ID_KONA5_OE7:
				case DEVICE_ID_KONA5_OE6:
				case DEVICE_ID_KONA5_OE5:
				case DEVICE_ID_KONA5_OE4:
				case DEVICE_ID_KONA5_OE3:
				case DEVICE_ID_KONA5_8K:
				case DEVICE_ID_KONA5_OE1:
				case DEVICE_ID_KONA5_8K_MV_TX:
				case DEVICE_ID_NOTFOUND:
				case DEVICE_ID_KONA5_2X4K:
				case DEVICE_ID_IOX3:
				case DEVICE_ID_CORVID3G:
				case DEVICE_ID_KONA5_OE11:
				case DEVICE_ID_CORVIDHBR:
				case DEVICE_ID_SOJI_OE3:
				case DEVICE_ID_KONA3GQUAD:
				case DEVICE_ID_CORVID44_8K:
				case DEVICE_ID_KONAIP_2110:
				case DEVICE_ID_KONA4UFC:
				case DEVICE_ID_SOJI_OE1:
				case DEVICE_ID_KONA5_8KMK:
				case DEVICE_ID_CORVID1:
				case DEVICE_ID_KONA5_OE12:
				case DEVICE_ID_KONA3G:
				case DEVICE_ID_KONA5_OE10:
				case DEVICE_ID_KONA5_3DLUT:
				case DEVICE_ID_SOJI_OE7:
				case DEVICE_ID_IOIP_2110:
				case DEVICE_ID_KONA5_OE2:
				case DEVICE_ID_CORVID44_PLNR:
				case DEVICE_ID_KONALHEPLUS:
				case DEVICE_ID_IOIP_2110_RGB12:
				case DEVICE_ID_CORVID22:
				case DEVICE_ID_KONAIP_2110_RGB12:
				case DEVICE_ID_CORVIDHEVC:
				case DEVICE_ID_CORVID44:
				case DEVICE_ID_SOJI_OE4:
				case DEVICE_ID_KONALHIDVI:
			#else
				default:
			#endif
					break;
			}	//  switch on inDeviceID for NTV2_INPUTSOURCE_SDI8
			break;	//  NTV2_INPUTSOURCE_SDI8

	#if defined(_DEBUG)		// These are unreferenced:
		case NTV2_INPUTSOURCE_INVALID:
	#else
		default:
	#endif
			break;
	}	//  switch on inInputSource

	return false;

}	//  NTV2DeviceCanDoInputSource (auto-generated)


/**
	NTV2DeviceCanDoVideoFormat
**/
bool NTV2DeviceCanDoVideoFormat (const NTV2DeviceID inDeviceID, const NTV2VideoFormat inVideoFormat)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID1:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_CORVID1:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_CORVID1

		case DEVICE_ID_CORVID22:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_CORVID22:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_CORVID22

		case DEVICE_ID_CORVID24:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_CORVID24:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_CORVID24

		case DEVICE_ID_CORVID3G:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_CORVID3G:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_CORVID3G

		case DEVICE_ID_CORVID44:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_CORVID44:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_CORVID44

		case DEVICE_ID_CORVID44_2X4K:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_CORVID44_2X4K:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_CORVID44_2X4K

		case DEVICE_ID_CORVID44_8K:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_CORVID44_8K:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_CORVID44_8K

		case DEVICE_ID_CORVID44_8KMK:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_CORVID44_8KMK:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_CORVID44_8KMK

		case DEVICE_ID_CORVID44_PLNR:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_CORVID44_PLNR:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_CORVID44_PLNR

		case DEVICE_ID_CORVID88:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_CORVID88:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_CORVID88

		case DEVICE_ID_CORVIDHBR:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_CORVIDHBR:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_CORVIDHBR

		case DEVICE_ID_CORVIDHEVC:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_CORVIDHEVC:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_CORVIDHEVC

		case DEVICE_ID_IO4K:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_IO4K:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_IO4K

		case DEVICE_ID_IO4KPLUS:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_IO4KPLUS:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_IO4KPLUS

		case DEVICE_ID_IO4KUFC:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_IO4KUFC:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_IO4KUFC

		case DEVICE_ID_IOEXPRESS:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_IOEXPRESS:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_IOEXPRESS

		case DEVICE_ID_IOIP_2022:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_IOIP_2022:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_IOIP_2022

		case DEVICE_ID_IOIP_2110:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_IOIP_2110:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_IOIP_2110

		case DEVICE_ID_IOIP_2110_RGB12:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_IOIP_2110_RGB12:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_IOIP_2110_RGB12

		case DEVICE_ID_IOX3:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_IOX3:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_IOX3

		case DEVICE_ID_IOXT:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_IOXT:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_IOXT

		case DEVICE_ID_KONA1:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_KONA1:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_KONA1

		case DEVICE_ID_KONA3G:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_KONA3G:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_KONA3G

		case DEVICE_ID_KONA3GQUAD:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_KONA3GQUAD:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_KONA3GQUAD

		case DEVICE_ID_KONA4:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_KONA4:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_KONA4

		case DEVICE_ID_KONA4UFC:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_KONA4UFC:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_KONA4UFC

		case DEVICE_ID_KONA5:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_KONA5:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_KONA5

		case DEVICE_ID_KONA5_2X4K:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_KONA5_2X4K:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_KONA5_2X4K

		case DEVICE_ID_KONA5_3DLUT:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_KONA5_3DLUT:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_KONA5_3DLUT

		case DEVICE_ID_KONA5_8K:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_KONA5_8K:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_KONA5_8K

		case DEVICE_ID_KONA5_8K_MV_TX:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_KONA5_8K_MV_TX:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_KONA5_8K_MV_TX

		case DEVICE_ID_KONA5_8KMK:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_KONA5_8KMK:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_KONA5_8KMK

		case DEVICE_ID_KONA5_OE1:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_KONA5_OE1:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_KONA5_OE1

		case DEVICE_ID_KONA5_OE10:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_KONA5_OE10:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_KONA5_OE10

		case DEVICE_ID_KONA5_OE11:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_KONA5_OE11:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_KONA5_OE11

		case DEVICE_ID_KONA5_OE12:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_KONA5_OE12:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_KONA5_OE12

		case DEVICE_ID_KONA5_OE2:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_KONA5_OE2:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_KONA5_OE2

		case DEVICE_ID_KONA5_OE3:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_KONA5_OE3:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_KONA5_OE3

		case DEVICE_ID_KONA5_OE4:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_KONA5_OE4:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_KONA5_OE4

		case DEVICE_ID_KONA5_OE5:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_KONA5_OE5:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_KONA5_OE5

		case DEVICE_ID_KONA5_OE6:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_KONA5_OE6:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_KONA5_OE6

		case DEVICE_ID_KONA5_OE7:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_KONA5_OE7:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_KONA5_OE7

		case DEVICE_ID_KONA5_OE8:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_KONA5_OE8:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_KONA5_OE8

		case DEVICE_ID_KONA5_OE9:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_KONA5_OE9:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_KONA5_OE9

		case DEVICE_ID_KONAHDMI:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_KONAHDMI:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_KONAHDMI

		case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_KONAIP_1RX_1TX_1SFP_J2K

		case DEVICE_ID_KONAIP_1RX_1TX_2110:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_KONAIP_1RX_1TX_2110:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_KONAIP_1RX_1TX_2110

		case DEVICE_ID_KONAIP_2022:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_KONAIP_2022:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_KONAIP_2022

		case DEVICE_ID_KONAIP_2110:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_KONAIP_2110:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_KONAIP_2110

		case DEVICE_ID_KONAIP_2110_RGB12:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_KONAIP_2110_RGB12:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_KONAIP_2110_RGB12

		case DEVICE_ID_KONAIP_2TX_1SFP_J2K:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_KONAIP_2TX_1SFP_J2K:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_KONAIP_2TX_1SFP_J2K

		case DEVICE_ID_KONAIP_4CH_2SFP:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_KONAIP_4CH_2SFP:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_KONAIP_4CH_2SFP

		case DEVICE_ID_KONALHEPLUS:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_KONALHEPLUS:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_KONALHEPLUS

		case DEVICE_ID_KONALHI:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_KONALHI:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_KONALHI

		case DEVICE_ID_KONALHIDVI:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_KONALHIDVI:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_KONALHIDVI

		case DEVICE_ID_SOJI_3DLUT:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_SOJI_3DLUT:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_SOJI_3DLUT

		case DEVICE_ID_SOJI_OE1:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_SOJI_OE1:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_SOJI_OE1

		case DEVICE_ID_SOJI_OE2:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_SOJI_OE2:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_SOJI_OE2

		case DEVICE_ID_SOJI_OE3:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_SOJI_OE3:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_SOJI_OE3

		case DEVICE_ID_SOJI_OE4:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_SOJI_OE4:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_SOJI_OE4

		case DEVICE_ID_SOJI_OE5:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_SOJI_OE5:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_SOJI_OE5

		case DEVICE_ID_SOJI_OE6:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_SOJI_OE6:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_SOJI_OE6

		case DEVICE_ID_SOJI_OE7:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_SOJI_OE7:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_SOJI_OE7

		case DEVICE_ID_TTAP:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_TTAP:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_TTAP

		case DEVICE_ID_TTAP_PRO:
			switch (inVideoFormat)
			{
				case NTV2_FORMAT_1080i_5000:
				case NTV2_FORMAT_1080i_5994:
				case NTV2_FORMAT_1080i_6000:
				case NTV2_FORMAT_1080p_2398:
				case NTV2_FORMAT_1080p_2400:
				case NTV2_FORMAT_1080p_2500:
				case NTV2_FORMAT_1080p_2997:
				case NTV2_FORMAT_1080p_2K_2398:
				case NTV2_FORMAT_1080p_2K_2400:
				case NTV2_FORMAT_1080p_2K_2500:
				case NTV2_FORMAT_1080p_2K_2997:
				case NTV2_FORMAT_1080p_2K_3000:
				case NTV2_FORMAT_1080p_2K_4795_A:
				case NTV2_FORMAT_1080p_2K_4800_A:
				case NTV2_FORMAT_1080p_2K_5000_A:
				case NTV2_FORMAT_1080p_2K_5994_A:
				case NTV2_FORMAT_1080p_2K_6000_A:
				case NTV2_FORMAT_1080p_3000:
				case NTV2_FORMAT_1080p_5000_A:
				case NTV2_FORMAT_1080p_5994_A:
				case NTV2_FORMAT_1080p_6000_A:
				case NTV2_FORMAT_1080psf_2398:
				case NTV2_FORMAT_1080psf_2400:
				case NTV2_FORMAT_1080psf_2500_2:
				case NTV2_FORMAT_1080psf_2997_2:
				case NTV2_FORMAT_1080psf_2K_2398:
				case NTV2_FORMAT_1080psf_2K_2400:
				case NTV2_FORMAT_1080psf_2K_2500:
				case NTV2_FORMAT_1080psf_3000_2:
				case NTV2_FORMAT_3840x2160p_2398:
				case NTV2_FORMAT_3840x2160p_2400:
				case NTV2_FORMAT_3840x2160p_2500:
				case NTV2_FORMAT_3840x2160p_2997:
				case NTV2_FORMAT_3840x2160p_3000:
				case NTV2_FORMAT_3840x2160p_5000:
				case NTV2_FORMAT_3840x2160p_5994:
				case NTV2_FORMAT_3840x2160p_6000:
				case NTV2_FORMAT_4096x2160p_2398:
				case NTV2_FORMAT_4096x2160p_2400:
				case NTV2_FORMAT_4096x2160p_2500:
				case NTV2_FORMAT_4096x2160p_2997:
				case NTV2_FORMAT_4096x2160p_3000:
				case NTV2_FORMAT_4096x2160p_4795:
				case NTV2_FORMAT_4096x2160p_4800:
				case NTV2_FORMAT_4096x2160p_5000:
				case NTV2_FORMAT_4096x2160p_5994:
				case NTV2_FORMAT_4096x2160p_6000:
				case NTV2_FORMAT_525_5994:
				case NTV2_FORMAT_525psf_2997:
				case NTV2_FORMAT_625_5000:
				case NTV2_FORMAT_625psf_2500:
				case NTV2_FORMAT_720p_5000:
				case NTV2_FORMAT_720p_5994:
				case NTV2_FORMAT_720p_6000:
					return true;
			#if defined(_DEBUG)		// NTV2VideoFormats not supported by DEVICE_ID_TTAP_PRO:
				case NTV2_FORMAT_1080p_2K_4795_B:
				case NTV2_FORMAT_1080p_2K_4800_B:
				case NTV2_FORMAT_1080p_2K_5000_B:
				case NTV2_FORMAT_1080p_2K_5994_B:
				case NTV2_FORMAT_1080p_2K_6000_B:
				case NTV2_FORMAT_1080p_5000_B:
				case NTV2_FORMAT_1080p_5994_B:
				case NTV2_FORMAT_1080p_6000_B:
				case NTV2_FORMAT_2K_1498:
				case NTV2_FORMAT_2K_1500:
				case NTV2_FORMAT_2K_2398:
				case NTV2_FORMAT_2K_2400:
				case NTV2_FORMAT_2K_2500:
				case NTV2_FORMAT_3840x2160p_5000_B:
				case NTV2_FORMAT_3840x2160p_5994_B:
				case NTV2_FORMAT_3840x2160p_6000_B:
				case NTV2_FORMAT_3840x2160psf_2398:
				case NTV2_FORMAT_3840x2160psf_2400:
				case NTV2_FORMAT_3840x2160psf_2500:
				case NTV2_FORMAT_3840x2160psf_2997:
				case NTV2_FORMAT_3840x2160psf_3000:
				case NTV2_FORMAT_4096x2160p_11988:
				case NTV2_FORMAT_4096x2160p_12000:
				case NTV2_FORMAT_4096x2160p_4795_B:
				case NTV2_FORMAT_4096x2160p_4800_B:
				case NTV2_FORMAT_4096x2160p_5000_B:
				case NTV2_FORMAT_4096x2160p_5994_B:
				case NTV2_FORMAT_4096x2160p_6000_B:
				case NTV2_FORMAT_4096x2160psf_2398:
				case NTV2_FORMAT_4096x2160psf_2400:
				case NTV2_FORMAT_4096x2160psf_2500:
				case NTV2_FORMAT_4096x2160psf_2997:
				case NTV2_FORMAT_4096x2160psf_3000:
				case NTV2_FORMAT_4x1920x1080p_2398:
				case NTV2_FORMAT_4x1920x1080p_2400:
				case NTV2_FORMAT_4x1920x1080p_2500:
				case NTV2_FORMAT_4x1920x1080p_2997:
				case NTV2_FORMAT_4x1920x1080p_3000:
				case NTV2_FORMAT_4x1920x1080p_5000:
				case NTV2_FORMAT_4x1920x1080p_5000_B:
				case NTV2_FORMAT_4x1920x1080p_5994:
				case NTV2_FORMAT_4x1920x1080p_5994_B:
				case NTV2_FORMAT_4x1920x1080p_6000:
				case NTV2_FORMAT_4x1920x1080p_6000_B:
				case NTV2_FORMAT_4x1920x1080psf_2398:
				case NTV2_FORMAT_4x1920x1080psf_2400:
				case NTV2_FORMAT_4x1920x1080psf_2500:
				case NTV2_FORMAT_4x1920x1080psf_2997:
				case NTV2_FORMAT_4x1920x1080psf_3000:
				case NTV2_FORMAT_4x2048x1080p_11988:
				case NTV2_FORMAT_4x2048x1080p_12000:
				case NTV2_FORMAT_4x2048x1080p_2398:
				case NTV2_FORMAT_4x2048x1080p_2400:
				case NTV2_FORMAT_4x2048x1080p_2500:
				case NTV2_FORMAT_4x2048x1080p_2997:
				case NTV2_FORMAT_4x2048x1080p_3000:
				case NTV2_FORMAT_4x2048x1080p_4795:
				case NTV2_FORMAT_4x2048x1080p_4795_B:
				case NTV2_FORMAT_4x2048x1080p_4800:
				case NTV2_FORMAT_4x2048x1080p_4800_B:
				case NTV2_FORMAT_4x2048x1080p_5000:
				case NTV2_FORMAT_4x2048x1080p_5000_B:
				case NTV2_FORMAT_4x2048x1080p_5994:
				case NTV2_FORMAT_4x2048x1080p_5994_B:
				case NTV2_FORMAT_4x2048x1080p_6000:
				case NTV2_FORMAT_4x2048x1080p_6000_B:
				case NTV2_FORMAT_4x2048x1080psf_2398:
				case NTV2_FORMAT_4x2048x1080psf_2400:
				case NTV2_FORMAT_4x2048x1080psf_2500:
				case NTV2_FORMAT_4x2048x1080psf_2997:
				case NTV2_FORMAT_4x2048x1080psf_3000:
				case NTV2_FORMAT_4x3840x2160p_2398:
				case NTV2_FORMAT_4x3840x2160p_2400:
				case NTV2_FORMAT_4x3840x2160p_2500:
				case NTV2_FORMAT_4x3840x2160p_2997:
				case NTV2_FORMAT_4x3840x2160p_3000:
				case NTV2_FORMAT_4x3840x2160p_5000:
				case NTV2_FORMAT_4x3840x2160p_5000_B:
				case NTV2_FORMAT_4x3840x2160p_5994:
				case NTV2_FORMAT_4x3840x2160p_5994_B:
				case NTV2_FORMAT_4x3840x2160p_6000:
				case NTV2_FORMAT_4x3840x2160p_6000_B:
				case NTV2_FORMAT_4x4096x2160p_2398:
				case NTV2_FORMAT_4x4096x2160p_2400:
				case NTV2_FORMAT_4x4096x2160p_2500:
				case NTV2_FORMAT_4x4096x2160p_2997:
				case NTV2_FORMAT_4x4096x2160p_3000:
				case NTV2_FORMAT_4x4096x2160p_4795:
				case NTV2_FORMAT_4x4096x2160p_4795_B:
				case NTV2_FORMAT_4x4096x2160p_4800:
				case NTV2_FORMAT_4x4096x2160p_4800_B:
				case NTV2_FORMAT_4x4096x2160p_5000:
				case NTV2_FORMAT_4x4096x2160p_5000_B:
				case NTV2_FORMAT_4x4096x2160p_5994:
				case NTV2_FORMAT_4x4096x2160p_5994_B:
				case NTV2_FORMAT_4x4096x2160p_6000:
				case NTV2_FORMAT_4x4096x2160p_6000_B:
				case NTV2_FORMAT_525_2398:
				case NTV2_FORMAT_525_2400:
				case NTV2_FORMAT_720p_2398:
				case NTV2_FORMAT_720p_2500:
				case NTV2_FORMAT_END_2K_DEF_FORMATS:
				case NTV2_FORMAT_END_4K_DEF_FORMATS2:
				case NTV2_FORMAT_END_4K_TSI_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS:
				case NTV2_FORMAT_END_HIGH_DEF_FORMATS2:
				case NTV2_FORMAT_END_STANDARD_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_DEF_FORMATS:
				case NTV2_FORMAT_END_UHD2_FULL_DEF_FORMATS:
				case NTV2_FORMAT_UNKNOWN:
			#else
				default:
			#endif
					break;
			}	//	switch on inVideoFormat
			break;	//	case DEVICE_ID_TTAP_PRO

		case DEVICE_ID_NOTFOUND:
			break;	//	case DEVICE_ID_NOTFOUND
	}	//  switch on device ID

	return false;

}	//  NTV2DeviceCanDoVideoFormat (auto-generated)


/**
	NTV2DeviceCanDoWidget
**/
bool NTV2DeviceCanDoWidget (const NTV2DeviceID inDeviceID, const NTV2WidgetID inWidgetID)
{
	switch (inDeviceID)
	{
		case DEVICE_ID_CORVID1:
			switch (inWidgetID)
			{
				case NTV2_WgtFrameBuffer1:
				case NTV2_WgtFrameBuffer2:
				case NTV2_WgtGenLock:
				case NTV2_WgtSDIIn1:
				case NTV2_WgtSDIOut1:
					return true;
			#if defined(_DEBUG)		// NTV2WidgetIDs not supported by DEVICE_ID_CORVID1:
				case NTV2_Wgt12GSDIIn1:
				case NTV2_Wgt12GSDIIn2:
				case NTV2_Wgt12GSDIIn3:
				case NTV2_Wgt12GSDIIn4:
				case NTV2_Wgt12GSDIOut1:
				case NTV2_Wgt12GSDIOut2:
				case NTV2_Wgt12GSDIOut3:
				case NTV2_Wgt12GSDIOut4:
				case NTV2_Wgt3DLUT1:
				case NTV2_Wgt3GSDIIn1:
				case NTV2_Wgt3GSDIIn2:
				case NTV2_Wgt3GSDIIn3:
				case NTV2_Wgt3GSDIIn4:
				case NTV2_Wgt3GSDIIn5:
				case NTV2_Wgt3GSDIIn6:
				case NTV2_Wgt3GSDIIn7:
				case NTV2_Wgt3GSDIIn8:
				case NTV2_Wgt3GSDIOut1:
				case NTV2_Wgt3GSDIOut2:
				case NTV2_Wgt3GSDIOut3:
				case NTV2_Wgt3GSDIOut4:
				case NTV2_Wgt3GSDIOut5:
				case NTV2_Wgt3GSDIOut6:
				case NTV2_Wgt3GSDIOut7:
				case NTV2_Wgt3GSDIOut8:
				case NTV2_Wgt425Mux1:
				case NTV2_Wgt425Mux2:
				case NTV2_Wgt425Mux3:
				case NTV2_Wgt425Mux4:
				case NTV2_Wgt4KDownConverter:
				case NTV2_WgtAnalogCompositeOut1:
				case NTV2_WgtAnalogIn1:
				case NTV2_WgtAnalogOut1:
				case NTV2_WgtCompression1:
				case NTV2_WgtCSC1:
				case NTV2_WgtCSC2:
				case NTV2_WgtCSC3:
				case NTV2_WgtCSC4:
				case NTV2_WgtCSC5:
				case NTV2_WgtCSC6:
				case NTV2_WgtCSC7:
				case NTV2_WgtCSC8:
				case NTV2_WgtDCIMixer1:
				case NTV2_WgtDualLinkIn1:
				case NTV2_WgtDualLinkOut1:
				case NTV2_WgtDualLinkOut2:
				case NTV2_WgtDualLinkV2In1:
				case NTV2_WgtDualLinkV2In2:
				case NTV2_WgtDualLinkV2In3:
				case NTV2_WgtDualLinkV2In4:
				case NTV2_WgtDualLinkV2In5:
				case NTV2_WgtDualLinkV2In6:
				case NTV2_WgtDualLinkV2In7:
				case NTV2_WgtDualLinkV2In8:
				case NTV2_WgtDualLinkV2Out1:
				case NTV2_WgtDualLinkV2Out2:
				case NTV2_WgtDualLinkV2Out3:
				case NTV2_WgtDualLinkV2Out4:
				case NTV2_WgtDualLinkV2Out5:
				case NTV2_WgtDualLinkV2Out6:
				case NTV2_WgtDualLinkV2Out7:
				case NTV2_WgtDualLinkV2Out8:
				case NTV2_WgtFrameBuffer3:
				case NTV2_WgtFrameBuffer4:
				case NTV2_WgtFrameBuffer5:
				case NTV2_WgtFrameBuffer6:
				case NTV2_WgtFrameBuffer7:
				case NTV2_WgtFrameBuffer8:
				case NTV2_WgtFrameSync1:
				case NTV2_WgtFrameSync2:
				case NTV2_WgtHDMIIn1:
				case NTV2_WgtHDMIIn1v2:
				case NTV2_WgtHDMIIn1v3:
				case NTV2_WgtHDMIIn1v4:
				case NTV2_WgtHDMIIn2v4:
				case NTV2_WgtHDMIIn3v4:
				case NTV2_WgtHDMIIn4v4:
				case NTV2_WgtHDMIOut1:
				case NTV2_WgtHDMIOut1v2:
				case NTV2_WgtHDMIOut1v3:
				case NTV2_WgtHDMIOut1v4:
				case NTV2_WgtHDMIOut1v5:
				case NTV2_WgtIICT1:
				case NTV2_WgtIICT2:
				case NTV2_WgtLUT1:
				case NTV2_WgtLUT2:
				case NTV2_WgtLUT3:
				case NTV2_WgtLUT4:
				case NTV2_WgtLUT5:
				case NTV2_WgtLUT6:
				case NTV2_WgtLUT7:
				case NTV2_WgtLUT8:
				case NTV2_WgtMixer1:
				case NTV2_WgtMixer2:
				case NTV2_WgtMixer3:
				case NTV2_WgtMixer4:
				case NTV2_WgtMultiLinkOut1:
				case NTV2_WgtMultiLinkOut2:
				case NTV2_WgtOE1:
				case NTV2_WgtProcAmp1:
				case NTV2_WgtSDIIn2:
				case NTV2_WgtSDIMonOut1:
				case NTV2_WgtSDIOut2:
				case NTV2_WgtSDIOut3:
				case NTV2_WgtSDIOut4:
				case NTV2_WgtStereoCompressor:
				case NTV2_WgtTestPattern1:
				case NTV2_WgtUpDownConverter1:
				case NTV2_WgtUpDownConverter2:
				case NTV2_WgtWaterMarker1:
				case NTV2_WgtWaterMarker2:
				case NTV2_WIDGET_INVALID:
			#else
				default:
			#endif
					break;
			}	//	switch on inWidgetID
			break;	//	case DEVICE_ID_CORVID1

		case DEVICE_ID_CORVID22:
			switch (inWidgetID)
			{
				case NTV2_Wgt3GSDIIn1:
				case NTV2_Wgt3GSDIIn2:
				case NTV2_Wgt3GSDIOut1:
				case NTV2_Wgt3GSDIOut2:
				case NTV2_WgtCSC1:
				case NTV2_WgtCSC2:
				case NTV2_WgtFrameBuffer1:
				case NTV2_WgtFrameBuffer2:
				case NTV2_WgtGenLock:
				case NTV2_WgtMixer1:
				case NTV2_WgtMixer2:
					return true;
			#if defined(_DEBUG)		// NTV2WidgetIDs not supported by DEVICE_ID_CORVID22:
				case NTV2_Wgt12GSDIIn1:
				case NTV2_Wgt12GSDIIn2:
				case NTV2_Wgt12GSDIIn3:
				case NTV2_Wgt12GSDIIn4:
				case NTV2_Wgt12GSDIOut1:
				case NTV2_Wgt12GSDIOut2:
				case NTV2_Wgt12GSDIOut3:
				case NTV2_Wgt12GSDIOut4:
				case NTV2_Wgt3DLUT1:
				case NTV2_Wgt3GSDIIn3:
				case NTV2_Wgt3GSDIIn4:
				case NTV2_Wgt3GSDIIn5:
				case NTV2_Wgt3GSDIIn6:
				case NTV2_Wgt3GSDIIn7:
				case NTV2_Wgt3GSDIIn8:
				case NTV2_Wgt3GSDIOut3:
				case NTV2_Wgt3GSDIOut4:
				case NTV2_Wgt3GSDIOut5:
				case NTV2_Wgt3GSDIOut6:
				case NTV2_Wgt3GSDIOut7:
				case NTV2_Wgt3GSDIOut8:
				case NTV2_Wgt425Mux1:
				case NTV2_Wgt425Mux2:
				case NTV2_Wgt425Mux3:
				case NTV2_Wgt425Mux4:
				case NTV2_Wgt4KDownConverter:
				case NTV2_WgtAnalogCompositeOut1:
				case NTV2_WgtAnalogIn1:
				case NTV2_WgtAnalogOut1:
				case NTV2_WgtCompression1:
				case NTV2_WgtCSC3:
				case NTV2_WgtCSC4:
				case NTV2_WgtCSC5:
				case NTV2_WgtCSC6:
				case NTV2_WgtCSC7:
				case NTV2_WgtCSC8:
				case NTV2_WgtDCIMixer1:
				case NTV2_WgtDualLinkIn1:
				case NTV2_WgtDualLinkOut1:
				case NTV2_WgtDualLinkOut2:
				case NTV2_WgtDualLinkV2In1:
				case NTV2_WgtDualLinkV2In2:
				case NTV2_WgtDualLinkV2In3:
				case NTV2_WgtDualLinkV2In4:
				case NTV2_WgtDualLinkV2In5:
				case NTV2_WgtDualLinkV2In6:
				case NTV2_WgtDualLinkV2In7:
				case NTV2_WgtDualLinkV2In8:
				case NTV2_WgtDualLinkV2Out1:
				case NTV2_WgtDualLinkV2Out2:
				case NTV2_WgtDualLinkV2Out3:
				case NTV2_WgtDualLinkV2Out4:
				case NTV2_WgtDualLinkV2Out5:
				case NTV2_WgtDualLinkV2Out6:
				case NTV2_WgtDualLinkV2Out7:
				case NTV2_WgtDualLinkV2Out8:
				case NTV2_WgtFrameBuffer3:
				case NTV2_WgtFrameBuffer4:
				case NTV2_WgtFrameBuffer5:
				case NTV2_WgtFrameBuffer6:
				case NTV2_WgtFrameBuffer7:
				case NTV2_WgtFrameBuffer8:
				case NTV2_WgtFrameSync1:
				case NTV2_WgtFrameSync2:
				case NTV2_WgtHDMIIn1:
				case NTV2_WgtHDMIIn1v2:
				case NTV2_WgtHDMIIn1v3:
				case NTV2_WgtHDMIIn1v4:
				case NTV2_WgtHDMIIn2v4:
				case NTV2_WgtHDMIIn3v4:
				case NTV2_WgtHDMIIn4v4:
				case NTV2_WgtHDMIOut1:
				case NTV2_WgtHDMIOut1v2:
				case NTV2_WgtHDMIOut1v3:
				case NTV2_WgtHDMIOut1v4:
				case NTV2_WgtHDMIOut1v5:
				case NTV2_WgtIICT1:
				case NTV2_WgtIICT2:
				case NTV2_WgtLUT1:
				case NTV2_WgtLUT2:
				case NTV2_WgtLUT3:
				case NTV2_WgtLUT4:
				case NTV2_WgtLUT5:
				case NTV2_WgtLUT6:
				case NTV2_WgtLUT7:
				case NTV2_WgtLUT8:
				case NTV2_WgtMixer3:
				case NTV2_WgtMixer4:
				case NTV2_WgtMultiLinkOut1:
				case NTV2_WgtMultiLinkOut2:
				case NTV2_WgtOE1:
				case NTV2_WgtProcAmp1:
				case NTV2_WgtSDIIn1:
				case NTV2_WgtSDIIn2:
				case NTV2_WgtSDIMonOut1:
				case NTV2_WgtSDIOut1:
				case NTV2_WgtSDIOut2:
				case NTV2_WgtSDIOut3:
				case NTV2_WgtSDIOut4:
				case NTV2_WgtStereoCompressor:
				case NTV2_WgtTestPattern1:
				case NTV2_WgtUpDownConverter1:
				case NTV2_WgtUpDownConverter2:
				case NTV2_WgtWaterMarker1:
				case NTV2_WgtWaterMarker2:
				case NTV2_WIDGET_INVALID:
			#else
				default:
			#endif
					break;
			}	//	switch on inWidgetID
			break;	//	case DEVICE_ID_CORVID22

		case DEVICE_ID_CORVID24:
			switch (inWidgetID)
			{
				case NTV2_Wgt3GSDIIn1:
				case NTV2_Wgt3GSDIIn2:
				case NTV2_Wgt3GSDIIn3:
				case NTV2_Wgt3GSDIIn4:
				case NTV2_Wgt3GSDIOut1:
				case NTV2_Wgt3GSDIOut2:
				case NTV2_Wgt3GSDIOut3:
				case NTV2_Wgt3GSDIOut4:
				case NTV2_WgtCSC1:
				case NTV2_WgtCSC2:
				case NTV2_WgtCSC3:
				case NTV2_WgtCSC4:
				case NTV2_WgtDualLinkV2In1:
				case NTV2_WgtDualLinkV2In2:
				case NTV2_WgtDualLinkV2In3:
				case NTV2_WgtDualLinkV2In4:
				case NTV2_WgtDualLinkV2Out1:
				case NTV2_WgtDualLinkV2Out2:
				case NTV2_WgtDualLinkV2Out3:
				case NTV2_WgtDualLinkV2Out4:
				case NTV2_WgtFrameBuffer1:
				case NTV2_WgtFrameBuffer2:
				case NTV2_WgtFrameBuffer3:
				case NTV2_WgtFrameBuffer4:
				case NTV2_WgtGenLock:
				case NTV2_WgtLUT1:
				case NTV2_WgtLUT2:
				case NTV2_WgtLUT3:
				case NTV2_WgtLUT4:
				case NTV2_WgtMixer1:
				case NTV2_WgtMixer2:
					return true;
			#if defined(_DEBUG)		// NTV2WidgetIDs not supported by DEVICE_ID_CORVID24:
				case NTV2_Wgt12GSDIIn1:
				case NTV2_Wgt12GSDIIn2:
				case NTV2_Wgt12GSDIIn3:
				case NTV2_Wgt12GSDIIn4:
				case NTV2_Wgt12GSDIOut1:
				case NTV2_Wgt12GSDIOut2:
				case NTV2_Wgt12GSDIOut3:
				case NTV2_Wgt12GSDIOut4:
				case NTV2_Wgt3DLUT1:
				case NTV2_Wgt3GSDIIn5:
				case NTV2_Wgt3GSDIIn6:
				case NTV2_Wgt3GSDIIn7:
				case NTV2_Wgt3GSDIIn8:
				case NTV2_Wgt3GSDIOut5:
				case NTV2_Wgt3GSDIOut6:
				case NTV2_Wgt3GSDIOut7:
				case NTV2_Wgt3GSDIOut8:
				case NTV2_Wgt425Mux1:
				case NTV2_Wgt425Mux2:
				case NTV2_Wgt425Mux3:
				case NTV2_Wgt425Mux4:
				case NTV2_Wgt4KDownConverter:
				case NTV2_WgtAnalogCompositeOut1:
				case NTV2_WgtAnalogIn1:
				case NTV2_WgtAnalogOut1:
				case NTV2_WgtCompression1:
				case NTV2_WgtCSC5:
				case NTV2_WgtCSC6:
				case NTV2_WgtCSC7:
				case NTV2_WgtCSC8:
				case NTV2_WgtDCIMixer1:
				case NTV2_WgtDualLinkIn1:
				case NTV2_WgtDualLinkOut1:
				case NTV2_WgtDualLinkOut2:
				case NTV2_WgtDualLinkV2In5:
				case NTV2_WgtDualLinkV2In6:
				case NTV2_WgtDualLinkV2In7:
				case NTV2_WgtDualLinkV2In8:
				case NTV2_WgtDualLinkV2Out5:
				case NTV2_WgtDualLinkV2Out6:
				case NTV2_WgtDualLinkV2Out7:
				case NTV2_WgtDualLinkV2Out8:
				case NTV2_WgtFrameBuffer5:
				case NTV2_WgtFrameBuffer6:
				case NTV2_WgtFrameBuffer7:
				case NTV2_WgtFrameBuffer8:
				case NTV2_WgtFrameSync1:
				case NTV2_WgtFrameSync2:
				case NTV2_WgtHDMIIn1:
				case NTV2_WgtHDMIIn1v2:
				case NTV2_WgtHDMIIn1v3:
				case NTV2_WgtHDMIIn1v4:
				case NTV2_WgtHDMIIn2v4:
				case NTV2_WgtHDMIIn3v4:
				case NTV2_WgtHDMIIn4v4:
				case NTV2_WgtHDMIOut1:
				case NTV2_WgtHDMIOut1v2:
				case NTV2_WgtHDMIOut1v3:
				case NTV2_WgtHDMIOut1v4:
				case NTV2_WgtHDMIOut1v5:
				case NTV2_WgtIICT1:
				case NTV2_WgtIICT2:
				case NTV2_WgtLUT5:
				case NTV2_WgtLUT6:
				case NTV2_WgtLUT7:
				case NTV2_WgtLUT8:
				case NTV2_WgtMixer3:
				case NTV2_WgtMixer4:
				case NTV2_WgtMultiLinkOut1:
				case NTV2_WgtMultiLinkOut2:
				case NTV2_WgtOE1:
				case NTV2_WgtProcAmp1:
				case NTV2_WgtSDIIn1:
				case NTV2_WgtSDIIn2:
				case NTV2_WgtSDIMonOut1:
				case NTV2_WgtSDIOut1:
				case NTV2_WgtSDIOut2:
				case NTV2_WgtSDIOut3:
				case NTV2_WgtSDIOut4:
				case NTV2_WgtStereoCompressor:
				case NTV2_WgtTestPattern1:
				case NTV2_WgtUpDownConverter1:
				case NTV2_WgtUpDownConverter2:
				case NTV2_WgtWaterMarker1:
				case NTV2_WgtWaterMarker2:
				case NTV2_WIDGET_INVALID:
			#else
				default:
			#endif
					break;
			}	//	switch on inWidgetID
			break;	//	case DEVICE_ID_CORVID24

		case DEVICE_ID_CORVID3G:
			switch (inWidgetID)
			{
				case NTV2_Wgt3GSDIIn1:
				case NTV2_Wgt3GSDIOut1:
				case NTV2_WgtCSC1:
				case NTV2_WgtCSC2:
				case NTV2_WgtFrameBuffer1:
				case NTV2_WgtFrameBuffer2:
				case NTV2_WgtGenLock:
				case NTV2_WgtMixer1:
					return true;
			#if defined(_DEBUG)		// NTV2WidgetIDs not supported by DEVICE_ID_CORVID3G:
				case NTV2_Wgt12GSDIIn1:
				case NTV2_Wgt12GSDIIn2:
				case NTV2_Wgt12GSDIIn3:
				case NTV2_Wgt12GSDIIn4:
				case NTV2_Wgt12GSDIOut1:
				case NTV2_Wgt12GSDIOut2:
				case NTV2_Wgt12GSDIOut3:
				case NTV2_Wgt12GSDIOut4:
				case NTV2_Wgt3DLUT1:
				case NTV2_Wgt3GSDIIn2:
				case NTV2_Wgt3GSDIIn3:
				case NTV2_Wgt3GSDIIn4:
				case NTV2_Wgt3GSDIIn5:
				case NTV2_Wgt3GSDIIn6:
				case NTV2_Wgt3GSDIIn7:
				case NTV2_Wgt3GSDIIn8:
				case NTV2_Wgt3GSDIOut2:
				case NTV2_Wgt3GSDIOut3:
				case NTV2_Wgt3GSDIOut4:
				case NTV2_Wgt3GSDIOut5:
				case NTV2_Wgt3GSDIOut6:
				case NTV2_Wgt3GSDIOut7:
				case NTV2_Wgt3GSDIOut8:
				case NTV2_Wgt425Mux1:
				case NTV2_Wgt425Mux2:
				case NTV2_Wgt425Mux3:
				case NTV2_Wgt425Mux4:
				case NTV2_Wgt4KDownConverter:
				case NTV2_WgtAnalogCompositeOut1:
				case NTV2_WgtAnalogIn1:
				case NTV2_WgtAnalogOut1:
				case NTV2_WgtCompression1:
				case NTV2_WgtCSC3:
				case NTV2_WgtCSC4:
				case NTV2_WgtCSC5:
				case NTV2_WgtCSC6:
				case NTV2_WgtCSC7:
				case NTV2_WgtCSC8:
				case NTV2_WgtDCIMixer1:
				case NTV2_WgtDualLinkIn1:
				case NTV2_WgtDualLinkOut1:
				case NTV2_WgtDualLinkOut2:
				case NTV2_WgtDualLinkV2In1:
				case NTV2_WgtDualLinkV2In2:
				case NTV2_WgtDualLinkV2In3:
				case NTV2_WgtDualLinkV2In4:
				case NTV2_WgtDualLinkV2In5:
				case NTV2_WgtDualLinkV2In6:
				case NTV2_WgtDualLinkV2In7:
				case NTV2_WgtDualLinkV2In8:
				case NTV2_WgtDualLinkV2Out1:
				case NTV2_WgtDualLinkV2Out2:
				case NTV2_WgtDualLinkV2Out3:
				case NTV2_WgtDualLinkV2Out4:
				case NTV2_WgtDualLinkV2Out5:
				case NTV2_WgtDualLinkV2Out6:
				case NTV2_WgtDualLinkV2Out7:
				case NTV2_WgtDualLinkV2Out8:
				case NTV2_WgtFrameBuffer3:
				case NTV2_WgtFrameBuffer4:
				case NTV2_WgtFrameBuffer5:
				case NTV2_WgtFrameBuffer6:
				case NTV2_WgtFrameBuffer7:
				case NTV2_WgtFrameBuffer8:
				case NTV2_WgtFrameSync1:
				case NTV2_WgtFrameSync2:
				case NTV2_WgtHDMIIn1:
				case NTV2_WgtHDMIIn1v2:
				case NTV2_WgtHDMIIn1v3:
				case NTV2_WgtHDMIIn1v4:
				case NTV2_WgtHDMIIn2v4:
				case NTV2_WgtHDMIIn3v4:
				case NTV2_WgtHDMIIn4v4:
				case NTV2_WgtHDMIOut1:
				case NTV2_WgtHDMIOut1v2:
				case NTV2_WgtHDMIOut1v3:
				case NTV2_WgtHDMIOut1v4:
				case NTV2_WgtHDMIOut1v5:
				case NTV2_WgtIICT1:
				case NTV2_WgtIICT2:
				case NTV2_WgtLUT1:
				case NTV2_WgtLUT2:
				case NTV2_WgtLUT3:
				case NTV2_WgtLUT4:
				case NTV2_WgtLUT5:
				case NTV2_WgtLUT6:
				case NTV2_WgtLUT7:
				case NTV2_WgtLUT8:
				case NTV2_WgtMixer2:
				case NTV2_WgtMixer3:
				case NTV2_WgtMixer4:
				case NTV2_WgtMultiLinkOut1:
				case NTV2_WgtMultiLinkOut2:
				case NTV2_WgtOE1:
				case NTV2_WgtProcAmp1:
				case NTV2_WgtSDIIn1:
				case NTV2_WgtSDIIn2:
				case NTV2_WgtSDIMonOut1:
				case NTV2_WgtSDIOut1:
				case NTV2_WgtSDIOut2:
				case NTV2_WgtSDIOut3:
				case NTV2_WgtSDIOut4:
				case NTV2_WgtStereoCompressor:
				case NTV2_WgtTestPattern1:
				case NTV2_WgtUpDownConverter1:
				case NTV2_WgtUpDownConverter2:
				case NTV2_WgtWaterMarker1:
				case NTV2_WgtWaterMarker2:
				case NTV2_WIDGET_INVALID:
			#else
				default:
			#endif
					break;
			}	//	switch on inWidgetID
			break;	//	case DEVICE_ID_CORVID3G

		case DEVICE_ID_CORVID44:
			switch (inWidgetID)
			{
				case NTV2_Wgt3GSDIIn1:
				case NTV2_Wgt3GSDIIn2:
				case NTV2_Wgt3GSDIIn3:
				case NTV2_Wgt3GSDIIn4:
				case NTV2_Wgt3GSDIOut1:
				case NTV2_Wgt3GSDIOut2:
				case NTV2_Wgt3GSDIOut3:
				case NTV2_Wgt3GSDIOut4:
				case NTV2_Wgt425Mux1:
				case NTV2_Wgt425Mux2:
				case NTV2_Wgt425Mux3:
				case NTV2_Wgt425Mux4:
				case NTV2_WgtCSC1:
				case NTV2_WgtCSC2:
				case NTV2_WgtCSC3:
				case NTV2_WgtCSC4:
				case NTV2_WgtDualLinkV2In1:
				case NTV2_WgtDualLinkV2In2:
				case NTV2_WgtDualLinkV2In3:
				case NTV2_WgtDualLinkV2In4:
				case NTV2_WgtDualLinkV2Out1:
				case NTV2_WgtDualLinkV2Out2:
				case NTV2_WgtDualLinkV2Out3:
				case NTV2_WgtDualLinkV2Out4:
				case NTV2_WgtFrameBuffer1:
				case NTV2_WgtFrameBuffer2:
				case NTV2_WgtFrameBuffer3:
				case NTV2_WgtFrameBuffer4:
				case NTV2_WgtGenLock:
				case NTV2_WgtLUT1:
				case NTV2_WgtLUT2:
				case NTV2_WgtLUT3:
				case NTV2_WgtLUT4:
				case NTV2_WgtMixer1:
				case NTV2_WgtMixer2:
					return true;
			#if defined(_DEBUG)		// NTV2WidgetIDs not supported by DEVICE_ID_CORVID44:
				case NTV2_Wgt12GSDIIn1:
				case NTV2_Wgt12GSDIIn2:
				case NTV2_Wgt12GSDIIn3:
				case NTV2_Wgt12GSDIIn4:
				case NTV2_Wgt12GSDIOut1:
				case NTV2_Wgt12GSDIOut2:
				case NTV2_Wgt12GSDIOut3:
				case NTV2_Wgt12GSDIOut4:
				case NTV2_Wgt3DLUT1:
				case NTV2_Wgt3GSDIIn5:
				case NTV2_Wgt3GSDIIn6:
				case NTV2_Wgt3GSDIIn7:
				case NTV2_Wgt3GSDIIn8:
				case NTV2_Wgt3GSDIOut5:
				case NTV2_Wgt3GSDIOut6:
				case NTV2_Wgt3GSDIOut7:
				case NTV2_Wgt3GSDIOut8:
				case NTV2_Wgt4KDownConverter:
				case NTV2_WgtAnalogCompositeOut1:
				case NTV2_WgtAnalogIn1:
				case NTV2_WgtAnalogOut1:
				case NTV2_WgtCompression1:
				case NTV2_WgtCSC5:
				case NTV2_WgtCSC6:
				case NTV2_WgtCSC7:
				case NTV2_WgtCSC8:
				case NTV2_WgtDCIMixer1:
				case NTV2_WgtDualLinkIn1:
				case NTV2_WgtDualLinkOut1:
				case NTV2_WgtDualLinkOut2:
				case NTV2_WgtDualLinkV2In5:
				case NTV2_WgtDualLinkV2In6:
				case NTV2_WgtDualLinkV2In7:
				case NTV2_WgtDualLinkV2In8:
				case NTV2_WgtDualLinkV2Out5:
				case NTV2_WgtDualLinkV2Out6:
				case NTV2_WgtDualLinkV2Out7:
				case NTV2_WgtDualLinkV2Out8:
				case NTV2_WgtFrameBuffer5:
				case NTV2_WgtFrameBuffer6:
				case NTV2_WgtFrameBuffer7:
				case NTV2_WgtFrameBuffer8:
				case NTV2_WgtFrameSync1:
				case NTV2_WgtFrameSync2:
				case NTV2_WgtHDMIIn1:
				case NTV2_WgtHDMIIn1v2:
				case NTV2_WgtHDMIIn1v3:
				case NTV2_WgtHDMIIn1v4:
				case NTV2_WgtHDMIIn2v4:
				case NTV2_WgtHDMIIn3v4:
				case NTV2_WgtHDMIIn4v4:
				case NTV2_WgtHDMIOut1:
				case NTV2_WgtHDMIOut1v2:
				case NTV2_WgtHDMIOut1v3:
				case NTV2_WgtHDMIOut1v4:
				case NTV2_WgtHDMIOut1v5:
				case NTV2_WgtIICT1:
				case NTV2_WgtIICT2:
				case NTV2_WgtLUT5:
				case NTV2_WgtLUT6:
				case NTV2_WgtLUT7:
				case NTV2_WgtLUT8:
				case NTV2_WgtMixer3:
				case NTV2_WgtMixer4:
				case NTV2_WgtMultiLinkOut1:
				case NTV2_WgtMultiLinkOut2:
				case NTV2_WgtOE1:
				case NTV2_WgtProcAmp1:
				case NTV2_WgtSDIIn1:
				case NTV2_WgtSDIIn2:
				case NTV2_WgtSDIMonOut1:
				case NTV2_WgtSDIOut1:
				case NTV2_WgtSDIOut2:
				case NTV2_WgtSDIOut3:
				case NTV2_WgtSDIOut4:
				case NTV2_WgtStereoCompressor:
				case NTV2_WgtTestPattern1:
				case NTV2_WgtUpDownConverter1:
				case NTV2_WgtUpDownConverter2:
				case NTV2_WgtWaterMarker1:
				case NTV2_WgtWaterMarker2:
				case NTV2_WIDGET_INVALID:
			#else
				default:
			#endif
					break;
			}	//	switch on inWidgetID
			break;	//	case DEVICE_ID_CORVID44

		case DEVICE_ID_CORVID44_2X4K:
			switch (inWidgetID)
			{
				case NTV2_Wgt12GSDIIn1:
				case NTV2_Wgt12GSDIIn2:
				case NTV2_Wgt12GSDIIn3:
				case NTV2_Wgt12GSDIIn4:
				case NTV2_Wgt12GSDIOut1:
				case NTV2_Wgt12GSDIOut2:
				case NTV2_Wgt12GSDIOut3:
				case NTV2_Wgt12GSDIOut4:
				case NTV2_WgtCSC1:
				case NTV2_WgtCSC2:
				case NTV2_WgtDualLinkV2In1:
				case NTV2_WgtDualLinkV2In2:
				case NTV2_WgtDualLinkV2In3:
				case NTV2_WgtDualLinkV2In4:
				case NTV2_WgtDualLinkV2Out1:
				case NTV2_WgtDualLinkV2Out2:
				case NTV2_WgtDualLinkV2Out3:
				case NTV2_WgtDualLinkV2Out4:
				case NTV2_WgtFrameBuffer1:
				case NTV2_WgtFrameBuffer2:
				case NTV2_WgtGenLock:
				case NTV2_WgtLUT1:
				case NTV2_WgtLUT2:
				case NTV2_WgtMixer1:
				case NTV2_WgtMultiLinkOut1:
					return true;
			#if defined(_DEBUG)		// NTV2WidgetIDs not supported by DEVICE_ID_CORVID44_2X4K:
				case NTV2_Wgt3DLUT1:
				case NTV2_Wgt3GSDIIn1:
				case NTV2_Wgt3GSDIIn2:
				case NTV2_Wgt3GSDIIn3:
				case NTV2_Wgt3GSDIIn4:
				case NTV2_Wgt3GSDIIn5:
				case NTV2_Wgt3GSDIIn6:
				case NTV2_Wgt3GSDIIn7:
				case NTV2_Wgt3GSDIIn8:
				case NTV2_Wgt3GSDIOut1:
				case NTV2_Wgt3GSDIOut2:
				case NTV2_Wgt3GSDIOut3:
				case NTV2_Wgt3GSDIOut4:
				case NTV2_Wgt3GSDIOut5:
				case NTV2_Wgt3GSDIOut6:
				case NTV2_Wgt3GSDIOut7:
				case NTV2_Wgt3GSDIOut8:
				case NTV2_Wgt425Mux1:
				case NTV2_Wgt425Mux2:
				case NTV2_Wgt425Mux3:
				case NTV2_Wgt425Mux4:
				case NTV2_Wgt4KDownConverter:
				case NTV2_WgtAnalogCompositeOut1:
				case NTV2_WgtAnalogIn1:
				case NTV2_WgtAnalogOut1:
				case NTV2_WgtCompression1:
				case NTV2_WgtCSC3:
				case NTV2_WgtCSC4:
				case NTV2_WgtCSC5:
				case NTV2_WgtCSC6:
				case NTV2_WgtCSC7:
				case NTV2_WgtCSC8:
				case NTV2_WgtDCIMixer1:
				case NTV2_WgtDualLinkIn1:
				case NTV2_WgtDualLinkOut1:
				case NTV2_WgtDualLinkOut2:
				case NTV2_WgtDualLinkV2In5:
				case NTV2_WgtDualLinkV2In6:
				case NTV2_WgtDualLinkV2In7:
				case NTV2_WgtDualLinkV2In8:
				case NTV2_WgtDualLinkV2Out5:
				case NTV2_WgtDualLinkV2Out6:
				case NTV2_WgtDualLinkV2Out7:
				case NTV2_WgtDualLinkV2Out8:
				case NTV2_WgtFrameBuffer3:
				case NTV2_WgtFrameBuffer4:
				case NTV2_WgtFrameBuffer5:
				case NTV2_WgtFrameBuffer6:
				case NTV2_WgtFrameBuffer7:
				case NTV2_WgtFrameBuffer8:
				case NTV2_WgtFrameSync1:
				case NTV2_WgtFrameSync2:
				case NTV2_WgtHDMIIn1:
				case NTV2_WgtHDMIIn1v2:
				case NTV2_WgtHDMIIn1v3:
				case NTV2_WgtHDMIIn1v4:
				case NTV2_WgtHDMIIn2v4:
				case NTV2_WgtHDMIIn3v4:
				case NTV2_WgtHDMIIn4v4:
				case NTV2_WgtHDMIOut1:
				case NTV2_WgtHDMIOut1v2:
				case NTV2_WgtHDMIOut1v3:
				case NTV2_WgtHDMIOut1v4:
				case NTV2_WgtHDMIOut1v5:
				case NTV2_WgtIICT1:
				case NTV2_WgtIICT2:
				case NTV2_WgtLUT3:
				case NTV2_WgtLUT4:
				case NTV2_WgtLUT5:
				case NTV2_WgtLUT6:
				case NTV2_WgtLUT7:
				case NTV2_WgtLUT8:
				case NTV2_WgtMixer2:
				case NTV2_WgtMixer3:
				case NTV2_WgtMixer4:
				case NTV2_WgtMultiLinkOut2:
				case NTV2_WgtOE1:
				case NTV2_WgtProcAmp1:
				case NTV2_WgtSDIIn1:
				case NTV2_WgtSDIIn2:
				case NTV2_WgtSDIMonOut1:
				case NTV2_WgtSDIOut1:
				case NTV2_WgtSDIOut2:
				case NTV2_WgtSDIOut3:
				case NTV2_WgtSDIOut4:
				case NTV2_WgtStereoCompressor:
				case NTV2_WgtTestPattern1:
				case NTV2_WgtUpDownConverter1:
				case NTV2_WgtUpDownConverter2:
				case NTV2_WgtWaterMarker1:
				case NTV2_WgtWaterMarker2:
				case NTV2_WIDGET_INVALID:
			#else
				default:
			#endif
					break;
			}	//	switch on inWidgetID
			break;	//	case DEVICE_ID_CORVID44_2X4K

		case DEVICE_ID_CORVID44_8K:
			switch (inWidgetID)
			{
				case NTV2_Wgt12GSDIIn1:
				case NTV2_Wgt12GSDIIn2:
				case NTV2_Wgt12GSDIIn3:
				case NTV2_Wgt12GSDIIn4:
				case NTV2_Wgt12GSDIOut1:
				case NTV2_Wgt12GSDIOut2:
				case NTV2_Wgt12GSDIOut3:
				case NTV2_Wgt12GSDIOut4:
				case NTV2_WgtDualLinkV2In1:
				case NTV2_WgtDualLinkV2In2:
				case NTV2_WgtDualLinkV2In3:
				case NTV2_WgtDualLinkV2In4:
				case NTV2_WgtDualLinkV2Out1:
				case NTV2_WgtDualLinkV2Out2:
				case NTV2_WgtDualLinkV2Out3:
				case NTV2_WgtDualLinkV2Out4:
				case NTV2_WgtFrameBuffer1:
				case NTV2_WgtFrameBuffer2:
				case NTV2_WgtFrameBuffer3:
				case NTV2_WgtFrameBuffer4:
				case NTV2_WgtGenLock:
				case NTV2_WgtMultiLinkOut1:
					return true;
			#if defined(_DEBUG)		// NTV2WidgetIDs not supported by DEVICE_ID_CORVID44_8K:
				case NTV2_Wgt3DLUT1:
				case NTV2_Wgt3GSDIIn1:
				case NTV2_Wgt3GSDIIn2:
				case NTV2_Wgt3GSDIIn3:
				case NTV2_Wgt3GSDIIn4:
				case NTV2_Wgt3GSDIIn5:
				case NTV2_Wgt3GSDIIn6:
				case NTV2_Wgt3GSDIIn7:
				case NTV2_Wgt3GSDIIn8:
				case NTV2_Wgt3GSDIOut1:
				case NTV2_Wgt3GSDIOut2:
				case NTV2_Wgt3GSDIOut3:
				case NTV2_Wgt3GSDIOut4:
				case NTV2_Wgt3GSDIOut5:
				case NTV2_Wgt3GSDIOut6:
				case NTV2_Wgt3GSDIOut7:
				case NTV2_Wgt3GSDIOut8:
				case NTV2_Wgt425Mux1:
				case NTV2_Wgt425Mux2:
				case NTV2_Wgt425Mux3:
				case NTV2_Wgt425Mux4:
				case NTV2_Wgt4KDownConverter:
				case NTV2_WgtAnalogCompositeOut1:
				case NTV2_WgtAnalogIn1:
				case NTV2_WgtAnalogOut1:
				case NTV2_WgtCompression1:
				case NTV2_WgtCSC1:
				case NTV2_WgtCSC2:
				case NTV2_WgtCSC3:
				case NTV2_WgtCSC4:
				case NTV2_WgtCSC5:
				case NTV2_WgtCSC6:
				case NTV2_WgtCSC7:
				case NTV2_WgtCSC8:
				case NTV2_WgtDCIMixer1:
				case NTV2_WgtDualLinkIn1:
				case NTV2_WgtDualLinkOut1:
				case NTV2_WgtDualLinkOut2:
				case NTV2_WgtDualLinkV2In5:
				case NTV2_WgtDualLinkV2In6:
				case NTV2_WgtDualLinkV2In7:
				case NTV2_WgtDualLinkV2In8:
				case NTV2_WgtDualLinkV2Out5:
				case NTV2_WgtDualLinkV2Out6:
				case NTV2_WgtDualLinkV2Out7:
				case NTV2_WgtDualLinkV2Out8:
				case NTV2_WgtFrameBuffer5:
				case NTV2_WgtFrameBuffer6:
				case NTV2_WgtFrameBuffer7:
				case NTV2_WgtFrameBuffer8:
				case NTV2_WgtFrameSync1:
				case NTV2_WgtFrameSync2:
				case NTV2_WgtHDMIIn1:
				case NTV2_WgtHDMIIn1v2:
				case NTV2_WgtHDMIIn1v3:
				case NTV2_WgtHDMIIn1v4:
				case NTV2_WgtHDMIIn2v4:
				case NTV2_WgtHDMIIn3v4:
				case NTV2_WgtHDMIIn4v4:
				case NTV2_WgtHDMIOut1:
				case NTV2_WgtHDMIOut1v2:
				case NTV2_WgtHDMIOut1v3:
				case NTV2_WgtHDMIOut1v4:
				case NTV2_WgtHDMIOut1v5:
				case NTV2_WgtIICT1:
				case NTV2_WgtIICT2:
				case NTV2_WgtLUT1:
				case NTV2_WgtLUT2:
				case NTV2_WgtLUT3:
				case NTV2_WgtLUT4:
				case NTV2_WgtLUT5:
				case NTV2_WgtLUT6:
				case NTV2_WgtLUT7:
				case NTV2_WgtLUT8:
				case NTV2_WgtMixer1:
				case NTV2_WgtMixer2:
				case NTV2_WgtMixer3:
				case NTV2_WgtMixer4:
				case NTV2_WgtMultiLinkOut2:
				case NTV2_WgtOE1:
				case NTV2_WgtProcAmp1:
				case NTV2_WgtSDIIn1:
				case NTV2_WgtSDIIn2:
				case NTV2_WgtSDIMonOut1:
				case NTV2_WgtSDIOut1:
				case NTV2_WgtSDIOut2:
				case NTV2_WgtSDIOut3:
				case NTV2_WgtSDIOut4:
				case NTV2_WgtStereoCompressor:
				case NTV2_WgtTestPattern1:
				case NTV2_WgtUpDownConverter1:
				case NTV2_WgtUpDownConverter2:
				case NTV2_WgtWaterMarker1:
				case NTV2_WgtWaterMarker2:
				case NTV2_WIDGET_INVALID:
			#else
				default:
			#endif
					break;
			}	//	switch on inWidgetID
			break;	//	case DEVICE_ID_CORVID44_8K

		case DEVICE_ID_CORVID44_8KMK:
			switch (inWidgetID)
			{
				case NTV2_Wgt12GSDIIn1:
				case NTV2_Wgt12GSDIIn2:
				case NTV2_Wgt12GSDIIn3:
				case NTV2_Wgt12GSDIIn4:
				case NTV2_Wgt12GSDIOut1:
				case NTV2_Wgt12GSDIOut2:
				case NTV2_Wgt12GSDIOut3:
				case NTV2_Wgt12GSDIOut4:
				case NTV2_WgtCSC1:
				case NTV2_WgtCSC2:
				case NTV2_WgtFrameBuffer1:
				case NTV2_WgtFrameBuffer2:
				case NTV2_WgtFrameBuffer3:
				case NTV2_WgtFrameBuffer4:
				case NTV2_WgtGenLock:
				case NTV2_WgtMixer1:
				case NTV2_WgtMultiLinkOut1:
					return true;
			#if defined(_DEBUG)		// NTV2WidgetIDs not supported by DEVICE_ID_CORVID44_8KMK:
				case NTV2_Wgt3DLUT1:
				case NTV2_Wgt3GSDIIn1:
				case NTV2_Wgt3GSDIIn2:
				case NTV2_Wgt3GSDIIn3:
				case NTV2_Wgt3GSDIIn4:
				case NTV2_Wgt3GSDIIn5:
				case NTV2_Wgt3GSDIIn6:
				case NTV2_Wgt3GSDIIn7:
				case NTV2_Wgt3GSDIIn8:
				case NTV2_Wgt3GSDIOut1:
				case NTV2_Wgt3GSDIOut2:
				case NTV2_Wgt3GSDIOut3:
				case NTV2_Wgt3GSDIOut4:
				case NTV2_Wgt3GSDIOut5:
				case NTV2_Wgt3GSDIOut6:
				case NTV2_Wgt3GSDIOut7:
				case NTV2_Wgt3GSDIOut8:
				case NTV2_Wgt425Mux1:
				case NTV2_Wgt425Mux2:
				case NTV2_Wgt425Mux3:
				case NTV2_Wgt425Mux4:
				case NTV2_Wgt4KDownConverter:
				case NTV2_WgtAnalogCompositeOut1:
				case NTV2_WgtAnalogIn1:
				case NTV2_WgtAnalogOut1:
				case NTV2_WgtCompression1:
				case NTV2_WgtCSC3:
				case NTV2_WgtCSC4:
				case NTV2_WgtCSC5:
				case NTV2_WgtCSC6:
				case NTV2_WgtCSC7:
				case NTV2_WgtCSC8:
				case NTV2_WgtDCIMixer1:
				case NTV2_WgtDualLinkIn1:
				case NTV2_WgtDualLinkOut1:
				case NTV2_WgtDualLinkOut2:
				case NTV2_WgtDualLinkV2In1:
				case NTV2_WgtDualLinkV2In2:
				case NTV2_WgtDualLinkV2In3:
				case NTV2_WgtDualLinkV2In4:
				case NTV2_WgtDualLinkV2In5:
				case NTV2_WgtDualLinkV2In6:
				case NTV2_WgtDualLinkV2In7:
				case NTV2_WgtDualLinkV2In8:
				case NTV2_WgtDualLinkV2Out1:
				case NTV2_WgtDualLinkV2Out2:
				case NTV2_WgtDualLinkV2Out3:
				case NTV2_WgtDualLinkV2Out4:
				case NTV2_WgtDualLinkV2Out5:
				case NTV2_WgtDualLinkV2Out6:
				case NTV2_WgtDualLinkV2Out7:
				case NTV2_WgtDualLinkV2Out8:
				case NTV2_WgtFrameBuffer5:
				case NTV2_WgtFrameBuffer6:
				case NTV2_WgtFrameBuffer7:
				case NTV2_WgtFrameBuffer8:
				case NTV2_WgtFrameSync1:
				case NTV2_WgtFrameSync2:
				case NTV2_WgtHDMIIn1:
				case NTV2_WgtHDMIIn1v2:
				case NTV2_WgtHDMIIn1v3:
				case NTV2_WgtHDMIIn1v4:
				case NTV2_WgtHDMIIn2v4:
				case NTV2_WgtHDMIIn3v4:
				case NTV2_WgtHDMIIn4v4:
				case NTV2_WgtHDMIOut1:
				case NTV2_WgtHDMIOut1v2:
				case NTV2_WgtHDMIOut1v3:
				case NTV2_WgtHDMIOut1v4:
				case NTV2_WgtHDMIOut1v5:
				case NTV2_WgtIICT1:
				case NTV2_WgtIICT2:
				case NTV2_WgtLUT1:
				case NTV2_WgtLUT2:
				case NTV2_WgtLUT3:
				case NTV2_WgtLUT4:
				case NTV2_WgtLUT5:
				case NTV2_WgtLUT6:
				case NTV2_WgtLUT7:
				case NTV2_WgtLUT8:
				case NTV2_WgtMixer2:
				case NTV2_WgtMixer3:
				case NTV2_WgtMixer4:
				case NTV2_WgtMultiLinkOut2:
				case NTV2_WgtOE1:
				case NTV2_WgtProcAmp1:
				case NTV2_WgtSDIIn1:
				case NTV2_WgtSDIIn2:
				case NTV2_WgtSDIMonOut1:
				case NTV2_WgtSDIOut1:
				case NTV2_WgtSDIOut2:
				case NTV2_WgtSDIOut3:
				case NTV2_WgtSDIOut4:
				case NTV2_WgtStereoCompressor:
				case NTV2_WgtTestPattern1:
				case NTV2_WgtUpDownConverter1:
				case NTV2_WgtUpDownConverter2:
				case NTV2_WgtWaterMarker1:
				case NTV2_WgtWaterMarker2:
				case NTV2_WIDGET_INVALID:
			#else
				default:
			#endif
					break;
			}	//	switch on inWidgetID
			break;	//	case DEVICE_ID_CORVID44_8KMK

		case DEVICE_ID_CORVID44_PLNR:
			switch (inWidgetID)
			{
				case NTV2_Wgt12GSDIIn1:
				case NTV2_Wgt12GSDIIn2:
				case NTV2_Wgt12GSDIIn3:
				case NTV2_Wgt12GSDIIn4:
				case NTV2_Wgt12GSDIOut1:
				case NTV2_WgtFrameBuffer1:
				case NTV2_WgtFrameBuffer2:
				case NTV2_WgtFrameBuffer3:
				case NTV2_WgtFrameBuffer4:
				case NTV2_WgtGenLock:
					return true;
			#if defined(_DEBUG)		// NTV2WidgetIDs not supported by DEVICE_ID_CORVID44_PLNR:
				case NTV2_Wgt12GSDIOut2:
				case NTV2_Wgt12GSDIOut3:
				case NTV2_Wgt12GSDIOut4:
				case NTV2_Wgt3DLUT1:
				case NTV2_Wgt3GSDIIn1:
				case NTV2_Wgt3GSDIIn2:
				case NTV2_Wgt3GSDIIn3:
				case NTV2_Wgt3GSDIIn4:
				case NTV2_Wgt3GSDIIn5:
				case NTV2_Wgt3GSDIIn6:
				case NTV2_Wgt3GSDIIn7:
				case NTV2_Wgt3GSDIIn8:
				case NTV2_Wgt3GSDIOut1:
				case NTV2_Wgt3GSDIOut2:
				case NTV2_Wgt3GSDIOut3:
				case NTV2_Wgt3GSDIOut4:
				case NTV2_Wgt3GSDIOut5:
				case NTV2_Wgt3GSDIOut6:
				case NTV2_Wgt3GSDIOut7:
				case NTV2_Wgt3GSDIOut8:
				case NTV2_Wgt425Mux1:
				case NTV2_Wgt425Mux2:
				case NTV2_Wgt425Mux3:
				case NTV2_Wgt425Mux4:
				case NTV2_Wgt4KDownConverter:
				case NTV2_WgtAnalogCompositeOut1:
				case NTV2_WgtAnalogIn1:
				case NTV2_WgtAnalogOut1:
				case NTV2_WgtCompression1:
				case NTV2_WgtCSC1:
				case NTV2_WgtCSC2:
				case NTV2_WgtCSC3:
				case NTV2_WgtCSC4:
				case NTV2_WgtCSC5:
				case NTV2_WgtCSC6:
				case NTV2_WgtCSC7:
				case NTV2_WgtCSC8:
				case NTV2_WgtDCIMixer1:
				case NTV2_WgtDualLinkIn1:
				case NTV2_WgtDualLinkOut1:
				case NTV2_WgtDualLinkOut2:
				case NTV2_WgtDualLinkV2In1:
				case NTV2_WgtDualLinkV2In2:
				case NTV2_WgtDualLinkV2In3:
				case NTV2_WgtDualLinkV2In4:
				case NTV2_WgtDualLinkV2In5:
				case NTV2_WgtDualLinkV2In6:
				case NTV2_WgtDualLinkV2In7:
				case NTV2_WgtDualLinkV2In8:
				case NTV2_WgtDualLinkV2Out1:
				case NTV2_WgtDualLinkV2Out2:
				case NTV2_WgtDualLinkV2Out3:
				case NTV2_WgtDualLinkV2Out4:
				case NTV2_WgtDualLinkV2Out5:
				case NTV2_WgtDualLinkV2Out6:
				case NTV2_WgtDualLinkV2Out7:
				case NTV2_WgtDualLinkV2Out8:
				case NTV2_WgtFrameBuffer5:
				case NTV2_WgtFrameBuffer6:
				case NTV2_WgtFrameBuffer7:
				case NTV2_WgtFrameBuffer8:
				case NTV2_WgtFrameSync1:
				case NTV2_WgtFrameSync2:
				case NTV2_WgtHDMIIn1:
				case NTV2_WgtHDMIIn1v2:
				case NTV2_WgtHDMIIn1v3:
				case NTV2_WgtHDMIIn1v4:
				case NTV2_WgtHDMIIn2v4:
				case NTV2_WgtHDMIIn3v4:
				case NTV2_WgtHDMIIn4v4:
				case NTV2_WgtHDMIOut1:
				case NTV2_WgtHDMIOut1v2:
				case NTV2_WgtHDMIOut1v3:
				case NTV2_WgtHDMIOut1v4:
				case NTV2_WgtHDMIOut1v5:
				case NTV2_WgtIICT1:
				case NTV2_WgtIICT2:
				case NTV2_WgtLUT1:
				case NTV2_WgtLUT2:
				case NTV2_WgtLUT3:
				case NTV2_WgtLUT4:
				case NTV2_WgtLUT5:
				case NTV2_WgtLUT6:
				case NTV2_WgtLUT7:
				case NTV2_WgtLUT8:
				case NTV2_WgtMixer1:
				case NTV2_WgtMixer2:
				case NTV2_WgtMixer3:
				case NTV2_WgtMixer4:
				case NTV2_WgtMultiLinkOut1:
				case NTV2_WgtMultiLinkOut2:
				case NTV2_WgtOE1:
				case NTV2_WgtProcAmp1:
				case NTV2_WgtSDIIn1:
				case NTV2_WgtSDIIn2:
				case NTV2_WgtSDIMonOut1:
				case NTV2_WgtSDIOut1:
				case NTV2_WgtSDIOut2:
				case NTV2_WgtSDIOut3:
				case NTV2_WgtSDIOut4:
				case NTV2_WgtStereoCompressor:
				case NTV2_WgtTestPattern1:
				case NTV2_WgtUpDownConverter1:
				case NTV2_WgtUpDownConverter2:
				case NTV2_WgtWaterMarker1:
				case NTV2_WgtWaterMarker2:
				case NTV2_WIDGET_INVALID:
			#else
				default:
			#endif
					break;
			}	//	switch on inWidgetID
			break;	//	case DEVICE_ID_CORVID44_PLNR

		case DEVICE_ID_CORVID88:
			switch (inWidgetID)
			{
				case NTV2_Wgt3GSDIIn1:
				case NTV2_Wgt3GSDIIn2:
				case NTV2_Wgt3GSDIIn3:
				case NTV2_Wgt3GSDIIn4:
				case NTV2_Wgt3GSDIIn5:
				case NTV2_Wgt3GSDIIn6:
				case NTV2_Wgt3GSDIIn7:
				case NTV2_Wgt3GSDIIn8:
				case NTV2_Wgt3GSDIOut1:
				case NTV2_Wgt3GSDIOut2:
				case NTV2_Wgt3GSDIOut3:
				case NTV2_Wgt3GSDIOut4:
				case NTV2_Wgt3GSDIOut5:
				case NTV2_Wgt3GSDIOut6:
				case NTV2_Wgt3GSDIOut7:
				case NTV2_Wgt3GSDIOut8:
				case NTV2_Wgt425Mux1:
				case NTV2_Wgt425Mux2:
				case NTV2_Wgt425Mux3:
				case NTV2_Wgt425Mux4:
				case NTV2_WgtCSC1:
				case NTV2_WgtCSC2:
				case NTV2_WgtCSC3:
				case NTV2_WgtCSC4:
				case NTV2_WgtCSC5:
				case NTV2_WgtCSC6:
				case NTV2_WgtCSC7:
				case NTV2_WgtCSC8:
				case NTV2_WgtDualLinkV2In1:
				case NTV2_WgtDualLinkV2In2:
				case NTV2_WgtDualLinkV2In3:
				case NTV2_WgtDualLinkV2In4:
				case NTV2_WgtDualLinkV2In5:
				case NTV2_WgtDualLinkV2In6:
				case NTV2_WgtDualLinkV2In7:
				case NTV2_WgtDualLinkV2In8:
				case NTV2_WgtDualLinkV2Out1:
				case NTV2_WgtDualLinkV2Out2:
				case NTV2_WgtDualLinkV2Out3:
				case NTV2_WgtDualLinkV2Out4:
				case NTV2_WgtDualLinkV2Out5:
				case NTV2_WgtDualLinkV2Out6:
				case NTV2_WgtDualLinkV2Out7:
				case NTV2_WgtDualLinkV2Out8:
				case NTV2_WgtFrameBuffer1:
				case NTV2_WgtFrameBuffer2:
				case NTV2_WgtFrameBuffer3:
				case NTV2_WgtFrameBuffer4:
				case NTV2_WgtFrameBuffer5:
				case NTV2_WgtFrameBuffer6:
				case NTV2_WgtFrameBuffer7:
				case NTV2_WgtFrameBuffer8:
				case NTV2_WgtGenLock:
				case NTV2_WgtLUT1:
				case NTV2_WgtLUT2:
				case NTV2_WgtLUT3:
				case NTV2_WgtLUT4:
				case NTV2_WgtLUT5:
				case NTV2_WgtLUT6:
				case NTV2_WgtLUT7:
				case NTV2_WgtLUT8:
				case NTV2_WgtMixer1:
				case NTV2_WgtMixer2:
				case NTV2_WgtMixer3:
				case NTV2_WgtMixer4:
					return true;
			#if defined(_DEBUG)		// NTV2WidgetIDs not supported by DEVICE_ID_CORVID88:
				case NTV2_Wgt12GSDIIn1:
				case NTV2_Wgt12GSDIIn2:
				case NTV2_Wgt12GSDIIn3:
				case NTV2_Wgt12GSDIIn4:
				case NTV2_Wgt12GSDIOut1:
				case NTV2_Wgt12GSDIOut2:
				case NTV2_Wgt12GSDIOut3:
				case NTV2_Wgt12GSDIOut4:
				case NTV2_Wgt3DLUT1:
				case NTV2_Wgt4KDownConverter:
				case NTV2_WgtAnalogCompositeOut1:
				case NTV2_WgtAnalogIn1:
				case NTV2_WgtAnalogOut1:
				case NTV2_WgtCompression1:
				case NTV2_WgtDCIMixer1:
				case NTV2_WgtDualLinkIn1:
				case NTV2_WgtDualLinkOut1:
				case NTV2_WgtDualLinkOut2:
				case NTV2_WgtFrameSync1:
				case NTV2_WgtFrameSync2:
				case NTV2_WgtHDMIIn1:
				case NTV2_WgtHDMIIn1v2:
				case NTV2_WgtHDMIIn1v3:
				case NTV2_WgtHDMIIn1v4:
				case NTV2_WgtHDMIIn2v4:
				case NTV2_WgtHDMIIn3v4:
				case NTV2_WgtHDMIIn4v4:
				case NTV2_WgtHDMIOut1:
				case NTV2_WgtHDMIOut1v2:
				case NTV2_WgtHDMIOut1v3:
				case NTV2_WgtHDMIOut1v4:
				case NTV2_WgtHDMIOut1v5:
				case NTV2_WgtIICT1:
				case NTV2_WgtIICT2:
				case NTV2_WgtMultiLinkOut1:
				case NTV2_WgtMultiLinkOut2:
				case NTV2_WgtOE1:
				case NTV2_WgtProcAmp1:
				case NTV2_WgtSDIIn1:
				case NTV2_WgtSDIIn2:
				case NTV2_WgtSDIMonOut1:
				case NTV2_WgtSDIOut1:
				case NTV2_WgtSDIOut2:
				case NTV2_WgtSDIOut3:
				case NTV2_WgtSDIOut4:
				case NTV2_WgtStereoCompressor:
				case NTV2_WgtTestPattern1:
				case NTV2_WgtUpDownConverter1:
				case NTV2_WgtUpDownConverter2:
				case NTV2_WgtWaterMarker1:
				case NTV2_WgtWaterMarker2:
				case NTV2_WIDGET_INVALID:
			#else
				default:
			#endif
					break;
			}	//	switch on inWidgetID
			break;	//	case DEVICE_ID_CORVID88

		case DEVICE_ID_CORVIDHBR:
			switch (inWidgetID)
			{
				case NTV2_Wgt4KDownConverter:
				case NTV2_WgtCSC1:
				case NTV2_WgtCSC2:
				case NTV2_WgtCSC3:
				case NTV2_WgtCSC4:
				case NTV2_WgtFrameBuffer1:
				case NTV2_WgtFrameBuffer2:
				case NTV2_WgtFrameBuffer3:
				case NTV2_WgtFrameBuffer4:
				case NTV2_WgtHDMIIn1v2:
				case NTV2_WgtLUT1:
				case NTV2_WgtLUT2:
				case NTV2_WgtLUT3:
				case NTV2_WgtLUT4:
					return true;
			#if defined(_DEBUG)		// NTV2WidgetIDs not supported by DEVICE_ID_CORVIDHBR:
				case NTV2_Wgt12GSDIIn1:
				case NTV2_Wgt12GSDIIn2:
				case NTV2_Wgt12GSDIIn3:
				case NTV2_Wgt12GSDIIn4:
				case NTV2_Wgt12GSDIOut1:
				case NTV2_Wgt12GSDIOut2:
				case NTV2_Wgt12GSDIOut3:
				case NTV2_Wgt12GSDIOut4:
				case NTV2_Wgt3DLUT1:
				case NTV2_Wgt3GSDIIn1:
				case NTV2_Wgt3GSDIIn2:
				case NTV2_Wgt3GSDIIn3:
				case NTV2_Wgt3GSDIIn4:
				case NTV2_Wgt3GSDIIn5:
				case NTV2_Wgt3GSDIIn6:
				case NTV2_Wgt3GSDIIn7:
				case NTV2_Wgt3GSDIIn8:
				case NTV2_Wgt3GSDIOut1:
				case NTV2_Wgt3GSDIOut2:
				case NTV2_Wgt3GSDIOut3:
				case NTV2_Wgt3GSDIOut4:
				case NTV2_Wgt3GSDIOut5:
				case NTV2_Wgt3GSDIOut6:
				case NTV2_Wgt3GSDIOut7:
				case NTV2_Wgt3GSDIOut8:
				case NTV2_Wgt425Mux1:
				case NTV2_Wgt425Mux2:
				case NTV2_Wgt425Mux3:
				case NTV2_Wgt425Mux4:
				case NTV2_WgtAnalogCompositeOut1:
				case NTV2_WgtAnalogIn1:
				case NTV2_WgtAnalogOut1:
				case NTV2_WgtCompression1:
				case NTV2_WgtCSC5:
				case NTV2_WgtCSC6:
				case NTV2_WgtCSC7:
				case NTV2_WgtCSC8:
				case NTV2_WgtDCIMixer1:
				case NTV2_WgtDualLinkIn1:
				case NTV2_WgtDualLinkOut1:
				case NTV2_WgtDualLinkOut2:
				case NTV2_WgtDualLinkV2In1:
				case NTV2_WgtDualLinkV2In2:
				case NTV2_WgtDualLinkV2In3:
				case NTV2_WgtDualLinkV2In4:
				case NTV2_WgtDualLinkV2In5:
				case NTV2_WgtDualLinkV2In6:
				case NTV2_WgtDualLinkV2In7:
				case NTV2_WgtDualLinkV2In8:
				case NTV2_WgtDualLinkV2Out1:
				case NTV2_WgtDualLinkV2Out2:
				case NTV2_WgtDualLinkV2Out3:
				case NTV2_WgtDualLinkV2Out4:
				case NTV2_WgtDualLinkV2Out5:
				case NTV2_WgtDualLinkV2Out6:
				case NTV2_WgtDualLinkV2Out7:
				case NTV2_WgtDualLinkV2Out8:
				case NTV2_WgtFrameBuffer5:
				case NTV2_WgtFrameBuffer6:
				case NTV2_WgtFrameBuffer7:
				case NTV2_WgtFrameBuffer8:
				case NTV2_WgtFrameSync1:
				case NTV2_WgtFrameSync2:
				case NTV2_WgtGenLock:
				case NTV2_WgtHDMIIn1:
				case NTV2_WgtHDMIIn1v3:
				case NTV2_WgtHDMIIn1v4:
				case NTV2_WgtHDMIIn2v4:
				case NTV2_WgtHDMIIn3v4:
				case NTV2_WgtHDMIIn4v4:
				case NTV2_WgtHDMIOut1:
				case NTV2_WgtHDMIOut1v2:
				case NTV2_WgtHDMIOut1v3:
				case NTV2_WgtHDMIOut1v4:
				case NTV2_WgtHDMIOut1v5:
				case NTV2_WgtIICT1:
				case NTV2_WgtIICT2:
				case NTV2_WgtLUT5:
				case NTV2_WgtLUT6:
				case NTV2_WgtLUT7:
				case NTV2_WgtLUT8:
				case NTV2_WgtMixer1:
				case NTV2_WgtMixer2:
				case NTV2_WgtMixer3:
				case NTV2_WgtMixer4:
				case NTV2_WgtMultiLinkOut1:
				case NTV2_WgtMultiLinkOut2:
				case NTV2_WgtOE1:
				case NTV2_WgtProcAmp1:
				case NTV2_WgtSDIIn1:
				case NTV2_WgtSDIIn2:
				case NTV2_WgtSDIMonOut1:
				case NTV2_WgtSDIOut1:
				case NTV2_WgtSDIOut2:
				case NTV2_WgtSDIOut3:
				case NTV2_WgtSDIOut4:
				case NTV2_WgtStereoCompressor:
				case NTV2_WgtTestPattern1:
				case NTV2_WgtUpDownConverter1:
				case NTV2_WgtUpDownConverter2:
				case NTV2_WgtWaterMarker1:
				case NTV2_WgtWaterMarker2:
				case NTV2_WIDGET_INVALID:
			#else
				default:
			#endif
					break;
			}	//	switch on inWidgetID
			break;	//	case DEVICE_ID_CORVIDHBR

		case DEVICE_ID_CORVIDHEVC:
			switch (inWidgetID)
			{
				case NTV2_Wgt3GSDIIn1:
				case NTV2_Wgt3GSDIIn2:
				case NTV2_Wgt3GSDIIn3:
				case NTV2_Wgt3GSDIIn4:
				case NTV2_Wgt3GSDIOut5:
				case NTV2_Wgt3GSDIOut6:
				case NTV2_Wgt3GSDIOut7:
				case NTV2_Wgt3GSDIOut8:
				case NTV2_Wgt425Mux1:
				case NTV2_Wgt425Mux2:
				case NTV2_Wgt425Mux3:
				case NTV2_Wgt425Mux4:
				case NTV2_WgtCSC1:
				case NTV2_WgtCSC2:
				case NTV2_WgtCSC3:
				case NTV2_WgtCSC4:
				case NTV2_WgtFrameBuffer1:
				case NTV2_WgtFrameBuffer2:
				case NTV2_WgtFrameBuffer3:
				case NTV2_WgtFrameBuffer4:
				case NTV2_WgtFrameBuffer5:
				case NTV2_WgtFrameBuffer6:
				case NTV2_WgtFrameBuffer7:
				case NTV2_WgtFrameBuffer8:
				case NTV2_WgtGenLock:
				case NTV2_WgtMixer1:
				case NTV2_WgtMixer2:
				case NTV2_WgtMixer3:
				case NTV2_WgtMixer4:
					return true;
			#if defined(_DEBUG)		// NTV2WidgetIDs not supported by DEVICE_ID_CORVIDHEVC:
				case NTV2_Wgt12GSDIIn1:
				case NTV2_Wgt12GSDIIn2:
				case NTV2_Wgt12GSDIIn3:
				case NTV2_Wgt12GSDIIn4:
				case NTV2_Wgt12GSDIOut1:
				case NTV2_Wgt12GSDIOut2:
				case NTV2_Wgt12GSDIOut3:
				case NTV2_Wgt12GSDIOut4:
				case NTV2_Wgt3DLUT1:
				case NTV2_Wgt3GSDIIn5:
				case NTV2_Wgt3GSDIIn6:
				case NTV2_Wgt3GSDIIn7:
				case NTV2_Wgt3GSDIIn8:
				case NTV2_Wgt3GSDIOut1:
				case NTV2_Wgt3GSDIOut2:
				case NTV2_Wgt3GSDIOut3:
				case NTV2_Wgt3GSDIOut4:
				case NTV2_Wgt4KDownConverter:
				case NTV2_WgtAnalogCompositeOut1:
				case NTV2_WgtAnalogIn1:
				case NTV2_WgtAnalogOut1:
				case NTV2_WgtCompression1:
				case NTV2_WgtCSC5:
				case NTV2_WgtCSC6:
				case NTV2_WgtCSC7:
				case NTV2_WgtCSC8:
				case NTV2_WgtDCIMixer1:
				case NTV2_WgtDualLinkIn1:
				case NTV2_WgtDualLinkOut1:
				case NTV2_WgtDualLinkOut2:
				case NTV2_WgtDualLinkV2In1:
				case NTV2_WgtDualLinkV2In2:
				case NTV2_WgtDualLinkV2In3:
				case NTV2_WgtDualLinkV2In4:
				case NTV2_WgtDualLinkV2In5:
				case NTV2_WgtDualLinkV2In6:
				case NTV2_WgtDualLinkV2In7:
				case NTV2_WgtDualLinkV2In8:
				case NTV2_WgtDualLinkV2Out1:
				case NTV2_WgtDualLinkV2Out2:
				case NTV2_WgtDualLinkV2Out3:
				case NTV2_WgtDualLinkV2Out4:
				case NTV2_WgtDualLinkV2Out5:
				case NTV2_WgtDualLinkV2Out6:
				case NTV2_WgtDualLinkV2Out7:
				case NTV2_WgtDualLinkV2Out8:
				case NTV2_WgtFrameSync1:
				case NTV2_WgtFrameSync2:
				case NTV2_WgtHDMIIn1:
				case NTV2_WgtHDMIIn1v2:
				case NTV2_WgtHDMIIn1v3:
				case NTV2_WgtHDMIIn1v4:
				case NTV2_WgtHDMIIn2v4:
				case NTV2_WgtHDMIIn3v4:
				case NTV2_WgtHDMIIn4v4:
				case NTV2_WgtHDMIOut1:
				case NTV2_WgtHDMIOut1v2:
				case NTV2_WgtHDMIOut1v3:
				case NTV2_WgtHDMIOut1v4:
				case NTV2_WgtHDMIOut1v5:
				case NTV2_WgtIICT1:
				case NTV2_WgtIICT2:
				case NTV2_WgtLUT1:
				case NTV2_WgtLUT2:
				case NTV2_WgtLUT3:
				case NTV2_WgtLUT4:
				case NTV2_WgtLUT5:
				case NTV2_WgtLUT6:
				case NTV2_WgtLUT7:
				case NTV2_WgtLUT8:
				case NTV2_WgtMultiLinkOut1:
				case NTV2_WgtMultiLinkOut2:
				case NTV2_WgtOE1:
				case NTV2_WgtProcAmp1:
				case NTV2_WgtSDIIn1:
				case NTV2_WgtSDIIn2:
				case NTV2_WgtSDIMonOut1:
				case NTV2_WgtSDIOut1:
				case NTV2_WgtSDIOut2:
				case NTV2_WgtSDIOut3:
				case NTV2_WgtSDIOut4:
				case NTV2_WgtStereoCompressor:
				case NTV2_WgtTestPattern1:
				case NTV2_WgtUpDownConverter1:
				case NTV2_WgtUpDownConverter2:
				case NTV2_WgtWaterMarker1:
				case NTV2_WgtWaterMarker2:
				case NTV2_WIDGET_INVALID:
			#else
				default:
			#endif
					break;
			}	//	switch on inWidgetID
			break;	//	case DEVICE_ID_CORVIDHEVC

		case DEVICE_ID_IO4K:
			switch (inWidgetID)
			{
				case NTV2_Wgt3GSDIIn1:
				case NTV2_Wgt3GSDIIn2:
				case NTV2_Wgt3GSDIIn3:
				case NTV2_Wgt3GSDIIn4:
				case NTV2_Wgt3GSDIOut1:
				case NTV2_Wgt3GSDIOut2:
				case NTV2_Wgt3GSDIOut3:
				case NTV2_Wgt3GSDIOut4:
				case NTV2_Wgt425Mux1:
				case NTV2_Wgt425Mux2:
				case NTV2_Wgt425Mux3:
				case NTV2_Wgt425Mux4:
				case NTV2_Wgt4KDownConverter:
				case NTV2_WgtCSC1:
				case NTV2_WgtCSC2:
				case NTV2_WgtCSC3:
				case NTV2_WgtCSC4:
				case NTV2_WgtCSC5:
				case NTV2_WgtDualLinkV2In1:
				case NTV2_WgtDualLinkV2In2:
				case NTV2_WgtDualLinkV2In3:
				case NTV2_WgtDualLinkV2In4:
				case NTV2_WgtDualLinkV2Out1:
				case NTV2_WgtDualLinkV2Out2:
				case NTV2_WgtDualLinkV2Out3:
				case NTV2_WgtDualLinkV2Out4:
				case NTV2_WgtDualLinkV2Out5:
				case NTV2_WgtFrameBuffer1:
				case NTV2_WgtFrameBuffer2:
				case NTV2_WgtFrameBuffer3:
				case NTV2_WgtFrameBuffer4:
				case NTV2_WgtGenLock:
				case NTV2_WgtHDMIIn1v2:
				case NTV2_WgtHDMIOut1v2:
				case NTV2_WgtLUT1:
				case NTV2_WgtLUT2:
				case NTV2_WgtLUT3:
				case NTV2_WgtLUT4:
				case NTV2_WgtLUT5:
				case NTV2_WgtMixer1:
				case NTV2_WgtMixer2:
				case NTV2_WgtSDIMonOut1:
					return true;
			#if defined(_DEBUG)		// NTV2WidgetIDs not supported by DEVICE_ID_IO4K:
				case NTV2_Wgt12GSDIIn1:
				case NTV2_Wgt12GSDIIn2:
				case NTV2_Wgt12GSDIIn3:
				case NTV2_Wgt12GSDIIn4:
				case NTV2_Wgt12GSDIOut1:
				case NTV2_Wgt12GSDIOut2:
				case NTV2_Wgt12GSDIOut3:
				case NTV2_Wgt12GSDIOut4:
				case NTV2_Wgt3DLUT1:
				case NTV2_Wgt3GSDIIn5:
				case NTV2_Wgt3GSDIIn6:
				case NTV2_Wgt3GSDIIn7:
				case NTV2_Wgt3GSDIIn8:
				case NTV2_Wgt3GSDIOut5:
				case NTV2_Wgt3GSDIOut6:
				case NTV2_Wgt3GSDIOut7:
				case NTV2_Wgt3GSDIOut8:
				case NTV2_WgtAnalogCompositeOut1:
				case NTV2_WgtAnalogIn1:
				case NTV2_WgtAnalogOut1:
				case NTV2_WgtCompression1:
				case NTV2_WgtCSC6:
				case NTV2_WgtCSC7:
				case NTV2_WgtCSC8:
				case NTV2_WgtDCIMixer1:
				case NTV2_WgtDualLinkIn1:
				case NTV2_WgtDualLinkOut1:
				case NTV2_WgtDualLinkOut2:
				case NTV2_WgtDualLinkV2In5:
				case NTV2_WgtDualLinkV2In6:
				case NTV2_WgtDualLinkV2In7:
				case NTV2_WgtDualLinkV2In8:
				case NTV2_WgtDualLinkV2Out6:
				case NTV2_WgtDualLinkV2Out7:
				case NTV2_WgtDualLinkV2Out8:
				case NTV2_WgtFrameBuffer5:
				case NTV2_WgtFrameBuffer6:
				case NTV2_WgtFrameBuffer7:
				case NTV2_WgtFrameBuffer8:
				case NTV2_WgtFrameSync1:
				case NTV2_WgtFrameSync2:
				case NTV2_WgtHDMIIn1:
				case NTV2_WgtHDMIIn1v3:
				case NTV2_WgtHDMIIn1v4:
				case NTV2_WgtHDMIIn2v4:
				case NTV2_WgtHDMIIn3v4:
				case NTV2_WgtHDMIIn4v4:
				case NTV2_WgtHDMIOut1:
				case NTV2_WgtHDMIOut1v3:
				case NTV2_WgtHDMIOut1v4:
				case NTV2_WgtHDMIOut1v5:
				case NTV2_WgtIICT1:
				case NTV2_WgtIICT2:
				case NTV2_WgtLUT6:
				case NTV2_WgtLUT7:
				case NTV2_WgtLUT8:
				case NTV2_WgtMixer3:
				case NTV2_WgtMixer4:
				case NTV2_WgtMultiLinkOut1:
				case NTV2_WgtMultiLinkOut2:
				case NTV2_WgtOE1:
				case NTV2_WgtProcAmp1:
				case NTV2_WgtSDIIn1:
				case NTV2_WgtSDIIn2:
				case NTV2_WgtSDIOut1:
				case NTV2_WgtSDIOut2:
				case NTV2_WgtSDIOut3:
				case NTV2_WgtSDIOut4:
				case NTV2_WgtStereoCompressor:
				case NTV2_WgtTestPattern1:
				case NTV2_WgtUpDownConverter1:
				case NTV2_WgtUpDownConverter2:
				case NTV2_WgtWaterMarker1:
				case NTV2_WgtWaterMarker2:
				case NTV2_WIDGET_INVALID:
			#else
				default:
			#endif
					break;
			}	//	switch on inWidgetID
			break;	//	case DEVICE_ID_IO4K

		case DEVICE_ID_IO4KPLUS:
			switch (inWidgetID)
			{
				case NTV2_Wgt12GSDIIn1:
				case NTV2_Wgt12GSDIOut3:
				case NTV2_Wgt3GSDIIn2:
				case NTV2_Wgt3GSDIIn3:
				case NTV2_Wgt3GSDIIn4:
				case NTV2_Wgt3GSDIOut1:
				case NTV2_Wgt3GSDIOut2:
				case NTV2_Wgt3GSDIOut4:
				case NTV2_Wgt425Mux1:
				case NTV2_Wgt425Mux2:
				case NTV2_Wgt425Mux3:
				case NTV2_Wgt425Mux4:
				case NTV2_Wgt4KDownConverter:
				case NTV2_WgtCSC1:
				case NTV2_WgtCSC2:
				case NTV2_WgtCSC3:
				case NTV2_WgtCSC4:
				case NTV2_WgtCSC5:
				case NTV2_WgtDualLinkV2In1:
				case NTV2_WgtDualLinkV2In2:
				case NTV2_WgtDualLinkV2In3:
				case NTV2_WgtDualLinkV2In4:
				case NTV2_WgtDualLinkV2Out1:
				case NTV2_WgtDualLinkV2Out2:
				case NTV2_WgtDualLinkV2Out3:
				case NTV2_WgtDualLinkV2Out4:
				case NTV2_WgtDualLinkV2Out5:
				case NTV2_WgtFrameBuffer1:
				case NTV2_WgtFrameBuffer2:
				case NTV2_WgtFrameBuffer3:
				case NTV2_WgtFrameBuffer4:
				case NTV2_WgtGenLock:
				case NTV2_WgtHDMIIn1v4:
				case NTV2_WgtHDMIOut1v4:
				case NTV2_WgtLUT1:
				case NTV2_WgtLUT2:
				case NTV2_WgtLUT3:
				case NTV2_WgtLUT4:
				case NTV2_WgtLUT5:
				case NTV2_WgtMixer1:
				case NTV2_WgtMixer2:
				case NTV2_WgtSDIMonOut1:
					return true;
			#if defined(_DEBUG)		// NTV2WidgetIDs not supported by DEVICE_ID_IO4KPLUS:
				case NTV2_Wgt12GSDIIn2:
				case NTV2_Wgt12GSDIIn3:
				case NTV2_Wgt12GSDIIn4:
				case NTV2_Wgt12GSDIOut1:
				case NTV2_Wgt12GSDIOut2:
				case NTV2_Wgt12GSDIOut4:
				case NTV2_Wgt3DLUT1:
				case NTV2_Wgt3GSDIIn1:
				case NTV2_Wgt3GSDIIn5:
				case NTV2_Wgt3GSDIIn6:
				case NTV2_Wgt3GSDIIn7:
				case NTV2_Wgt3GSDIIn8:
				case NTV2_Wgt3GSDIOut3:
				case NTV2_Wgt3GSDIOut5:
				case NTV2_Wgt3GSDIOut6:
				case NTV2_Wgt3GSDIOut7:
				case NTV2_Wgt3GSDIOut8:
				case NTV2_WgtAnalogCompositeOut1:
				case NTV2_WgtAnalogIn1:
				case NTV2_WgtAnalogOut1:
				case NTV2_WgtCompression1:
				case NTV2_WgtCSC6:
				case NTV2_WgtCSC7:
				case NTV2_WgtCSC8:
				case NTV2_WgtDCIMixer1:
				case NTV2_WgtDualLinkIn1:
				case NTV2_WgtDualLinkOut1:
				case NTV2_WgtDualLinkOut2:
				case NTV2_WgtDualLinkV2In5:
				case NTV2_WgtDualLinkV2In6:
				case NTV2_WgtDualLinkV2In7:
				case NTV2_WgtDualLinkV2In8:
				case NTV2_WgtDualLinkV2Out6:
				case NTV2_WgtDualLinkV2Out7:
				case NTV2_WgtDualLinkV2Out8:
				case NTV2_WgtFrameBuffer5:
				case NTV2_WgtFrameBuffer6:
				case NTV2_WgtFrameBuffer7:
				case NTV2_WgtFrameBuffer8:
				case NTV2_WgtFrameSync1:
				case NTV2_WgtFrameSync2:
				case NTV2_WgtHDMIIn1:
				case NTV2_WgtHDMIIn1v2:
				case NTV2_WgtHDMIIn1v3:
				case NTV2_WgtHDMIIn2v4:
				case NTV2_WgtHDMIIn3v4:
				case NTV2_WgtHDMIIn4v4:
				case NTV2_WgtHDMIOut1:
				case NTV2_WgtHDMIOut1v2:
				case NTV2_WgtHDMIOut1v3:
				case NTV2_WgtHDMIOut1v5:
				case NTV2_WgtIICT1:
				case NTV2_WgtIICT2:
				case NTV2_WgtLUT6:
				case NTV2_WgtLUT7:
				case NTV2_WgtLUT8:
				case NTV2_WgtMixer3:
				case NTV2_WgtMixer4:
				case NTV2_WgtMultiLinkOut1:
				case NTV2_WgtMultiLinkOut2:
				case NTV2_WgtOE1:
				case NTV2_WgtProcAmp1:
				case NTV2_WgtSDIIn1:
				case NTV2_WgtSDIIn2:
				case NTV2_WgtSDIOut1:
				case NTV2_WgtSDIOut2:
				case NTV2_WgtSDIOut3:
				case NTV2_WgtSDIOut4:
				case NTV2_WgtStereoCompressor:
				case NTV2_WgtTestPattern1:
				case NTV2_WgtUpDownConverter1:
				case NTV2_WgtUpDownConverter2:
				case NTV2_WgtWaterMarker1:
				case NTV2_WgtWaterMarker2:
				case NTV2_WIDGET_INVALID:
			#else
				default:
			#endif
					break;
			}	//	switch on inWidgetID
			break;	//	case DEVICE_ID_IO4KPLUS

		case DEVICE_ID_IO4KUFC:
			switch (inWidgetID)
			{
				case NTV2_Wgt3GSDIIn1:
				case NTV2_Wgt3GSDIIn2:
				case NTV2_Wgt3GSDIOut1:
				case NTV2_Wgt3GSDIOut2:
				case NTV2_WgtCompression1:
				case NTV2_WgtCSC1:
				case NTV2_WgtCSC2:
				case NTV2_WgtCSC5:
				case NTV2_WgtDualLinkV2In1:
				case NTV2_WgtDualLinkV2In2:
				case NTV2_WgtDualLinkV2Out1:
				case NTV2_WgtDualLinkV2Out2:
				case NTV2_WgtDualLinkV2Out5:
				case NTV2_WgtFrameBuffer1:
				case NTV2_WgtFrameBuffer2:
				case NTV2_WgtGenLock:
				case NTV2_WgtHDMIIn1v3:
				case NTV2_WgtHDMIOut1v3:
				case NTV2_WgtLUT1:
				case NTV2_WgtLUT2:
				case NTV2_WgtLUT5:
				case NTV2_WgtMixer1:
				case NTV2_WgtMixer2:
				case NTV2_WgtSDIMonOut1:
				case NTV2_WgtUpDownConverter1:
					return true;
			#if defined(_DEBUG)		// NTV2WidgetIDs not supported by DEVICE_ID_IO4KUFC:
				case NTV2_Wgt12GSDIIn1:
				case NTV2_Wgt12GSDIIn2:
				case NTV2_Wgt12GSDIIn3:
				case NTV2_Wgt12GSDIIn4:
				case NTV2_Wgt12GSDIOut1:
				case NTV2_Wgt12GSDIOut2:
				case NTV2_Wgt12GSDIOut3:
				case NTV2_Wgt12GSDIOut4:
				case NTV2_Wgt3DLUT1:
				case NTV2_Wgt3GSDIIn3:
				case NTV2_Wgt3GSDIIn4:
				case NTV2_Wgt3GSDIIn5:
				case NTV2_Wgt3GSDIIn6:
				case NTV2_Wgt3GSDIIn7:
				case NTV2_Wgt3GSDIIn8:
				case NTV2_Wgt3GSDIOut3:
				case NTV2_Wgt3GSDIOut4:
				case NTV2_Wgt3GSDIOut5:
				case NTV2_Wgt3GSDIOut6:
				case NTV2_Wgt3GSDIOut7:
				case NTV2_Wgt3GSDIOut8:
				case NTV2_Wgt425Mux1:
				case NTV2_Wgt425Mux2:
				case NTV2_Wgt425Mux3:
				case NTV2_Wgt425Mux4:
				case NTV2_Wgt4KDownConverter:
				case NTV2_WgtAnalogCompositeOut1:
				case NTV2_WgtAnalogIn1:
				case NTV2_WgtAnalogOut1:
				case NTV2_WgtCSC3:
				case NTV2_WgtCSC4:
				case NTV2_WgtCSC6:
				case NTV2_WgtCSC7:
				case NTV2_WgtCSC8:
				case NTV2_WgtDCIMixer1:
				case NTV2_WgtDualLinkIn1:
				case NTV2_WgtDualLinkOut1:
				case NTV2_WgtDualLinkOut2:
				case NTV2_WgtDualLinkV2In3:
				case NTV2_WgtDualLinkV2In4:
				case NTV2_WgtDualLinkV2In5:
				case NTV2_WgtDualLinkV2In6:
				case NTV2_WgtDualLinkV2In7:
				case NTV2_WgtDualLinkV2In8:
				case NTV2_WgtDualLinkV2Out3:
				case NTV2_WgtDualLinkV2Out4:
				case NTV2_WgtDualLinkV2Out6:
				case NTV2_WgtDualLinkV2Out7:
				case NTV2_WgtDualLinkV2Out8:
				case NTV2_WgtFrameBuffer3:
				case NTV2_WgtFrameBuffer4:
				case NTV2_WgtFrameBuffer5:
				case NTV2_WgtFrameBuffer6:
				case NTV2_WgtFrameBuffer7:
				case NTV2_WgtFrameBuffer8:
				case NTV2_WgtFrameSync1:
				case NTV2_WgtFrameSync2:
				case NTV2_WgtHDMIIn1:
				case NTV2_WgtHDMIIn1v2:
				case NTV2_WgtHDMIIn1v4:
				case NTV2_WgtHDMIIn2v4:
				case NTV2_WgtHDMIIn3v4:
				case NTV2_WgtHDMIIn4v4:
				case NTV2_WgtHDMIOut1:
				case NTV2_WgtHDMIOut1v2:
				case NTV2_WgtHDMIOut1v4:
				case NTV2_WgtHDMIOut1v5:
				case NTV2_WgtIICT1:
				case NTV2_WgtIICT2:
				case NTV2_WgtLUT3:
				case NTV2_WgtLUT4:
				case NTV2_WgtLUT6:
				case NTV2_WgtLUT7:
				case NTV2_WgtLUT8:
				case NTV2_WgtMixer3:
				case NTV2_WgtMixer4:
				case NTV2_WgtMultiLinkOut1:
				case NTV2_WgtMultiLinkOut2:
				case NTV2_WgtOE1:
				case NTV2_WgtProcAmp1:
				case NTV2_WgtSDIIn1:
				case NTV2_WgtSDIIn2:
				case NTV2_WgtSDIOut1:
				case NTV2_WgtSDIOut2:
				case NTV2_WgtSDIOut3:
				case NTV2_WgtSDIOut4:
				case NTV2_WgtStereoCompressor:
				case NTV2_WgtTestPattern1:
				case NTV2_WgtUpDownConverter2:
				case NTV2_WgtWaterMarker1:
				case NTV2_WgtWaterMarker2:
				case NTV2_WIDGET_INVALID:
			#else
				default:
			#endif
					break;
			}	//	switch on inWidgetID
			break;	//	case DEVICE_ID_IO4KUFC

		case DEVICE_ID_IOEXPRESS:
			switch (inWidgetID)
			{
				case NTV2_WgtAnalogOut1:
				case NTV2_WgtCompression1:
				case NTV2_WgtFrameBuffer1:
				case NTV2_WgtFrameSync1:
				case NTV2_WgtFrameSync2:
				case NTV2_WgtGenLock:
				case NTV2_WgtHDMIIn1:
				case NTV2_WgtHDMIOut1:
				case NTV2_WgtSDIIn1:
				case NTV2_WgtSDIOut1:
				case NTV2_WgtUpDownConverter1:
					return true;
			#if defined(_DEBUG)		// NTV2WidgetIDs not supported by DEVICE_ID_IOEXPRESS:
				case NTV2_Wgt12GSDIIn1:
				case NTV2_Wgt12GSDIIn2:
				case NTV2_Wgt12GSDIIn3:
				case NTV2_Wgt12GSDIIn4:
				case NTV2_Wgt12GSDIOut1:
				case NTV2_Wgt12GSDIOut2:
				case NTV2_Wgt12GSDIOut3:
				case NTV2_Wgt12GSDIOut4:
				case NTV2_Wgt3DLUT1:
				case NTV2_Wgt3GSDIIn1:
				case NTV2_Wgt3GSDIIn2:
				case NTV2_Wgt3GSDIIn3:
				case NTV2_Wgt3GSDIIn4:
				case NTV2_Wgt3GSDIIn5:
				case NTV2_Wgt3GSDIIn6:
				case NTV2_Wgt3GSDIIn7:
				case NTV2_Wgt3GSDIIn8:
				case NTV2_Wgt3GSDIOut1:
				case NTV2_Wgt3GSDIOut2:
				case NTV2_Wgt3GSDIOut3:
				case NTV2_Wgt3GSDIOut4:
				case NTV2_Wgt3GSDIOut5:
				case NTV2_Wgt3GSDIOut6:
				case NTV2_Wgt3GSDIOut7:
				case NTV2_Wgt3GSDIOut8:
				case NTV2_Wgt425Mux1:
				case NTV2_Wgt425Mux2:
				case NTV2_Wgt425Mux3:
				case NTV2_Wgt425Mux4:
				case NTV2_Wgt4KDownConverter:
				case NTV2_WgtAnalogCompositeOut1:
				case NTV2_WgtAnalogIn1:
				case NTV2_WgtCSC1:
				case NTV2_WgtCSC2:
				case NTV2_WgtCSC3:
				case NTV2_WgtCSC4:
				case NTV2_WgtCSC5:
				case NTV2_WgtCSC6:
				case NTV2_WgtCSC7:
				case NTV2_WgtCSC8:
				case NTV2_WgtDCIMixer1:
				case NTV2_WgtDualLinkIn1:
				case NTV2_WgtDualLinkOut1:
				case NTV2_WgtDualLinkOut2:
				case NTV2_WgtDualLinkV2In1:
				case NTV2_WgtDualLinkV2In2:
				case NTV2_WgtDualLinkV2In3:
				case NTV2_WgtDualLinkV2In4:
				case NTV2_WgtDualLinkV2In5:
				case NTV2_WgtDualLinkV2In6:
				case NTV2_WgtDualLinkV2In7:
				case NTV2_WgtDualLinkV2In8:
				case NTV2_WgtDualLinkV2Out1:
				case NTV2_WgtDualLinkV2Out2:
				case NTV2_WgtDualLinkV2Out3:
				case NTV2_WgtDualLinkV2Out4:
				case NTV2_WgtDualLinkV2Out5:
				case NTV2_WgtDualLinkV2Out6:
				case NTV2_WgtDualLinkV2Out7:
				case NTV2_WgtDualLinkV2Out8:
				case NTV2_WgtFrameBuffer2:
				case NTV2_WgtFrameBuffer3:
				case NTV2_WgtFrameBuffer4:
				case NTV2_WgtFrameBuffer5:
				case NTV2_WgtFrameBuffer6:
				case NTV2_WgtFrameBuffer7:
				case NTV2_WgtFrameBuffer8:
				case NTV2_WgtHDMIIn1v2:
				case NTV2_WgtHDMIIn1v3:
				case NTV2_WgtHDMIIn1v4:
				case NTV2_WgtHDMIIn2v4:
				case NTV2_WgtHDMIIn3v4:
				case NTV2_WgtHDMIIn4v4:
				case NTV2_WgtHDMIOut1v2:
				case NTV2_WgtHDMIOut1v3:
				case NTV2_WgtHDMIOut1v4:
				case NTV2_WgtHDMIOut1v5:
				case NTV2_WgtIICT1:
				case NTV2_WgtIICT2:
				case NTV2_WgtLUT1:
				case NTV2_WgtLUT2:
				case NTV2_WgtLUT3:
				case NTV2_WgtLUT4:
				case NTV2_WgtLUT5:
				case NTV2_WgtLUT6:
				case NTV2_WgtLUT7:
				case NTV2_WgtLUT8:
				case NTV2_WgtMixer1:
				case NTV2_WgtMixer2:
				case NTV2_WgtMixer3:
				case NTV2_WgtMixer4:
				case NTV2_WgtMultiLinkOut1:
				case NTV2_WgtMultiLinkOut2:
				case NTV2_WgtOE1:
				case NTV2_WgtProcAmp1:
				case NTV2_WgtSDIIn2:
				case NTV2_WgtSDIMonOut1:
				case NTV2_WgtSDIOut2:
				case NTV2_WgtSDIOut3:
				case NTV2_WgtSDIOut4:
				case NTV2_WgtStereoCompressor:
				case NTV2_WgtTestPattern1:
				case NTV2_WgtUpDownConverter2:
				case NTV2_WgtWaterMarker1:
				case NTV2_WgtWaterMarker2:
				case NTV2_WIDGET_INVALID:
			#else
				default:
			#endif
					break;
			}	//	switch on inWidgetID
			break;	//	case DEVICE_ID_IOEXPRESS

		case DEVICE_ID_IOIP_2022:
			switch (inWidgetID)
			{
				case NTV2_Wgt3GSDIIn1:
				case NTV2_Wgt3GSDIIn2:
				case NTV2_Wgt3GSDIIn3:
				case NTV2_Wgt3GSDIIn4:
				case NTV2_Wgt3GSDIOut1:
				case NTV2_Wgt3GSDIOut2:
				case NTV2_Wgt3GSDIOut3:
				case NTV2_Wgt3GSDIOut4:
				case NTV2_Wgt425Mux1:
				case NTV2_Wgt425Mux2:
				case NTV2_Wgt425Mux3:
				case NTV2_Wgt425Mux4:
				case NTV2_Wgt4KDownConverter:
				case NTV2_WgtCSC1:
				case NTV2_WgtCSC2:
				case NTV2_WgtCSC3:
				case NTV2_WgtCSC4:
				case NTV2_WgtCSC5:
				case NTV2_WgtDualLinkV2In1:
				case NTV2_WgtDualLinkV2In2:
				case NTV2_WgtDualLinkV2In3:
				case NTV2_WgtDualLinkV2In4:
				case NTV2_WgtDualLinkV2Out1:
				case NTV2_WgtDualLinkV2Out2:
				case NTV2_WgtDualLinkV2Out3:
				case NTV2_WgtDualLinkV2Out4:
				case NTV2_WgtDualLinkV2Out5:
				case NTV2_WgtFrameBuffer1:
				case NTV2_WgtFrameBuffer2:
				case NTV2_WgtFrameBuffer3:
				case NTV2_WgtFrameBuffer4:
				case NTV2_WgtGenLock:
				case NTV2_WgtHDMIOut1v4:
				case NTV2_WgtLUT1:
				case NTV2_WgtLUT2:
				case NTV2_WgtLUT3:
				case NTV2_WgtLUT4:
				case NTV2_WgtLUT5:
				case NTV2_WgtMixer1:
				case NTV2_WgtMixer2:
				case NTV2_WgtSDIMonOut1:
					return true;
			#if defined(_DEBUG)		// NTV2WidgetIDs not supported by DEVICE_ID_IOIP_2022:
				case NTV2_Wgt12GSDIIn1:
				case NTV2_Wgt12GSDIIn2:
				case NTV2_Wgt12GSDIIn3:
				case NTV2_Wgt12GSDIIn4:
				case NTV2_Wgt12GSDIOut1:
				case NTV2_Wgt12GSDIOut2:
				case NTV2_Wgt12GSDIOut3:
				case NTV2_Wgt12GSDIOut4:
				case NTV2_Wgt3DLUT1:
				case NTV2_Wgt3GSDIIn5:
				case NTV2_Wgt3GSDIIn6:
				case NTV2_Wgt3GSDIIn7:
				case NTV2_Wgt3GSDIIn8:
				case NTV2_Wgt3GSDIOut5:
				case NTV2_Wgt3GSDIOut6:
				case NTV2_Wgt3GSDIOut7:
				case NTV2_Wgt3GSDIOut8:
				case NTV2_WgtAnalogCompositeOut1:
				case NTV2_WgtAnalogIn1:
				case NTV2_WgtAnalogOut1:
				case NTV2_WgtCompression1:
				case NTV2_WgtCSC6:
				case NTV2_WgtCSC7:
				case NTV2_WgtCSC8:
				case NTV2_WgtDCIMixer1:
				case NTV2_WgtDualLinkIn1:
				case NTV2_WgtDualLinkOut1:
				case NTV2_WgtDualLinkOut2:
				case NTV2_WgtDualLinkV2In5:
				case NTV2_WgtDualLinkV2In6:
				case NTV2_WgtDualLinkV2In7:
				case NTV2_WgtDualLinkV2In8:
				case NTV2_WgtDualLinkV2Out6:
				case NTV2_WgtDualLinkV2Out7:
				case NTV2_WgtDualLinkV2Out8:
				case NTV2_WgtFrameBuffer5:
				case NTV2_WgtFrameBuffer6:
				case NTV2_WgtFrameBuffer7:
				case NTV2_WgtFrameBuffer8:
				case NTV2_WgtFrameSync1:
				case NTV2_WgtFrameSync2:
				case NTV2_WgtHDMIIn1:
				case NTV2_WgtHDMIIn1v2:
				case NTV2_WgtHDMIIn1v3:
				case NTV2_WgtHDMIIn1v4:
				case NTV2_WgtHDMIIn2v4:
				case NTV2_WgtHDMIIn3v4:
				case NTV2_WgtHDMIIn4v4:
				case NTV2_WgtHDMIOut1:
				case NTV2_WgtHDMIOut1v2:
				case NTV2_WgtHDMIOut1v3:
				case NTV2_WgtHDMIOut1v5:
				case NTV2_WgtIICT1:
				case NTV2_WgtIICT2:
				case NTV2_WgtLUT6:
				case NTV2_WgtLUT7:
				case NTV2_WgtLUT8:
				case NTV2_WgtMixer3:
				case NTV2_WgtMixer4:
				case NTV2_WgtMultiLinkOut1:
				case NTV2_WgtMultiLinkOut2:
				case NTV2_WgtOE1:
				case NTV2_WgtProcAmp1:
				case NTV2_WgtSDIIn1:
				case NTV2_WgtSDIIn2:
				case NTV2_WgtSDIOut1:
				case NTV2_WgtSDIOut2:
				case NTV2_WgtSDIOut3:
				case NTV2_WgtSDIOut4:
				case NTV2_WgtStereoCompressor:
				case NTV2_WgtTestPattern1:
				case NTV2_WgtUpDownConverter1:
				case NTV2_WgtUpDownConverter2:
				case NTV2_WgtWaterMarker1:
				case NTV2_WgtWaterMarker2:
				case NTV2_WIDGET_INVALID:
			#else
				default:
			#endif
					break;
			}	//	switch on inWidgetID
			break;	//	case DEVICE_ID_IOIP_2022

		case DEVICE_ID_IOIP_2110:
			switch (inWidgetID)
			{
				case NTV2_Wgt3GSDIIn1:
				case NTV2_Wgt3GSDIIn2:
				case NTV2_Wgt3GSDIIn3:
				case NTV2_Wgt3GSDIIn4:
				case NTV2_Wgt3GSDIOut1:
				case NTV2_Wgt3GSDIOut2:
				case NTV2_Wgt3GSDIOut3:
				case NTV2_Wgt3GSDIOut4:
				case NTV2_Wgt425Mux1:
				case NTV2_Wgt425Mux2:
				case NTV2_Wgt425Mux3:
				case NTV2_Wgt425Mux4:
				case NTV2_Wgt4KDownConverter:
				case NTV2_WgtCSC1:
				case NTV2_WgtCSC2:
				case NTV2_WgtCSC3:
				case NTV2_WgtCSC4:
				case NTV2_WgtCSC5:
				case NTV2_WgtDualLinkV2In1:
				case NTV2_WgtDualLinkV2In2:
				case NTV2_WgtDualLinkV2In3:
				case NTV2_WgtDualLinkV2In4:
				case NTV2_WgtDualLinkV2Out1:
				case NTV2_WgtDualLinkV2Out2:
				case NTV2_WgtDualLinkV2Out3:
				case NTV2_WgtDualLinkV2Out4:
				case NTV2_WgtDualLinkV2Out5:
				case NTV2_WgtFrameBuffer1:
				case NTV2_WgtFrameBuffer2:
				case NTV2_WgtFrameBuffer3:
				case NTV2_WgtFrameBuffer4:
				case NTV2_WgtGenLock:
				case NTV2_WgtHDMIOut1v4:
				case NTV2_WgtLUT1:
				case NTV2_WgtLUT2:
				case NTV2_WgtLUT3:
				case NTV2_WgtLUT4:
				case NTV2_WgtLUT5:
				case NTV2_WgtMixer1:
				case NTV2_WgtMixer2:
				case NTV2_WgtSDIMonOut1:
					return true;
			#if defined(_DEBUG)		// NTV2WidgetIDs not supported by DEVICE_ID_IOIP_2110:
				case NTV2_Wgt12GSDIIn1:
				case NTV2_Wgt12GSDIIn2:
				case NTV2_Wgt12GSDIIn3:
				case NTV2_Wgt12GSDIIn4:
				case NTV2_Wgt12GSDIOut1:
				case NTV2_Wgt12GSDIOut2:
				case NTV2_Wgt12GSDIOut3:
				case NTV2_Wgt12GSDIOut4:
				case NTV2_Wgt3DLUT1:
				case NTV2_Wgt3GSDIIn5:
				case NTV2_Wgt3GSDIIn6:
				case NTV2_Wgt3GSDIIn7:
				case NTV2_Wgt3GSDIIn8:
				case NTV2_Wgt3GSDIOut5:
				case NTV2_Wgt3GSDIOut6:
				case NTV2_Wgt3GSDIOut7:
				case NTV2_Wgt3GSDIOut8:
				case NTV2_WgtAnalogCompositeOut1:
				case NTV2_WgtAnalogIn1:
				case NTV2_WgtAnalogOut1:
				case NTV2_WgtCompression1:
				case NTV2_WgtCSC6:
				case NTV2_WgtCSC7:
				case NTV2_WgtCSC8:
				case NTV2_WgtDCIMixer1:
				case NTV2_WgtDualLinkIn1:
				case NTV2_WgtDualLinkOut1:
				case NTV2_WgtDualLinkOut2:
				case NTV2_WgtDualLinkV2In5:
				case NTV2_WgtDualLinkV2In6:
				case NTV2_WgtDualLinkV2In7:
				case NTV2_WgtDualLinkV2In8:
				case NTV2_WgtDualLinkV2Out6:
				case NTV2_WgtDualLinkV2Out7:
				case NTV2_WgtDualLinkV2Out8:
				case NTV2_WgtFrameBuffer5:
				case NTV2_WgtFrameBuffer6:
				case NTV2_WgtFrameBuffer7:
				case NTV2_WgtFrameBuffer8:
				case NTV2_WgtFrameSync1:
				case NTV2_WgtFrameSync2:
				case NTV2_WgtHDMIIn1:
				case NTV2_WgtHDMIIn1v2:
				case NTV2_WgtHDMIIn1v3:
				case NTV2_WgtHDMIIn1v4:
				case NTV2_WgtHDMIIn2v4:
				case NTV2_WgtHDMIIn3v4:
				case NTV2_WgtHDMIIn4v4:
				case NTV2_WgtHDMIOut1:
				case NTV2_WgtHDMIOut1v2:
				case NTV2_WgtHDMIOut1v3:
				case NTV2_WgtHDMIOut1v5:
				case NTV2_WgtIICT1:
				case NTV2_WgtIICT2:
				case NTV2_WgtLUT6:
				case NTV2_WgtLUT7:
				case NTV2_WgtLUT8:
				case NTV2_WgtMixer3:
				case NTV2_WgtMixer4:
				case NTV2_WgtMultiLinkOut1:
				case NTV2_WgtMultiLinkOut2:
				case NTV2_WgtOE1:
				case NTV2_WgtProcAmp1:
				case NTV2_WgtSDIIn1:
				case NTV2_WgtSDIIn2:
				case NTV2_WgtSDIOut1:
				case NTV2_WgtSDIOut2:
				case NTV2_WgtSDIOut3:
				case NTV2_WgtSDIOut4:
				case NTV2_WgtStereoCompressor:
				case NTV2_WgtTestPattern1:
				case NTV2_WgtUpDownConverter1:
				case NTV2_WgtUpDownConverter2:
				case NTV2_WgtWaterMarker1:
				case NTV2_WgtWaterMarker2:
				case NTV2_WIDGET_INVALID:
			#else
				default:
			#endif
					break;
			}	//	switch on inWidgetID
			break;	//	case DEVICE_ID_IOIP_2110

		case DEVICE_ID_IOIP_2110_RGB12:
			switch (inWidgetID)
			{
				case NTV2_Wgt3GSDIOut1:
				case NTV2_Wgt3GSDIOut2:
				case NTV2_Wgt3GSDIOut3:
				case NTV2_Wgt3GSDIOut4:
				case NTV2_Wgt425Mux1:
				case NTV2_Wgt425Mux2:
				case NTV2_WgtCSC1:
				case NTV2_WgtCSC2:
				case NTV2_WgtCSC3:
				case NTV2_WgtCSC4:
				case NTV2_WgtCSC5:
				case NTV2_WgtDualLinkV2Out1:
				case NTV2_WgtDualLinkV2Out2:
				case NTV2_WgtDualLinkV2Out3:
				case NTV2_WgtDualLinkV2Out4:
				case NTV2_WgtDualLinkV2Out5:
				case NTV2_WgtFrameBuffer1:
				case NTV2_WgtFrameBuffer2:
				case NTV2_WgtGenLock:
				case NTV2_WgtHDMIOut1v4:
				case NTV2_WgtLUT1:
				case NTV2_WgtLUT2:
				case NTV2_WgtLUT3:
				case NTV2_WgtLUT4:
				case NTV2_WgtLUT5:
				case NTV2_WgtSDIMonOut1:
					return true;
			#if defined(_DEBUG)		// NTV2WidgetIDs not supported by DEVICE_ID_IOIP_2110_RGB12:
				case NTV2_Wgt12GSDIIn1:
				case NTV2_Wgt12GSDIIn2:
				case NTV2_Wgt12GSDIIn3:
				case NTV2_Wgt12GSDIIn4:
				case NTV2_Wgt12GSDIOut1:
				case NTV2_Wgt12GSDIOut2:
				case NTV2_Wgt12GSDIOut3:
				case NTV2_Wgt12GSDIOut4:
				case NTV2_Wgt3DLUT1:
				case NTV2_Wgt3GSDIIn1:
				case NTV2_Wgt3GSDIIn2:
				case NTV2_Wgt3GSDIIn3:
				case NTV2_Wgt3GSDIIn4:
				case NTV2_Wgt3GSDIIn5:
				case NTV2_Wgt3GSDIIn6:
				case NTV2_Wgt3GSDIIn7:
				case NTV2_Wgt3GSDIIn8:
				case NTV2_Wgt