/* SPDX-License-Identifier: MIT */
/**
	@file		testpatterngen.cpp
	@brief		Implements the AJATestPatternGen class.
	@copyright	(C) 2010-2021 AJA Video Systems, Inc.  All rights reserved.
**/
#if !defined(NTV2_DEPRECATE_15_0)
#include "types.h"
#include "videoutilities.h"
#include "testpatterngen.h"
#include "math.h"

#ifdef AJA_LINUX
#include <string.h> //for memcpy
#endif

typedef std::vector<const char *> TestPatternList;

typedef struct
{
	int startLine;
	int endLine;
	uint32_t *data;
}SegmentDescriptor;

const uint16_t NumTestPatternSegments = 8;
const uint16_t AJA_NUM_STANDARDS = 6;
typedef struct
{
	const char *name;
	SegmentDescriptor segmentDescriptor[AJA_NUM_STANDARDS][NumTestPatternSegments]; 
} SegmentTestPatternData;



static uint32_t ColarBars100_1080_0[] = 
{ //0
0x20010200, 0x4080040, 0x20010600, 0x1f6800cb, 0x200c8600, 0x3ac803ab, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 
0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 
0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 
0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 
0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 
0x200eb1ff, 0x3ac6e7ac, 0x120e8a07, 0x3778578c, 0x223db487, 0x36d1076d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 
0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 
0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 
0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 
0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 
0x211db45b, 0x3593bf6d, 0x1b8cbd8e, 0x2f236f05, 0x58bca4c, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 
0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 
0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 
0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 
0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x266bc840, 0x2f2102f2, 
0x47bca1f, 0x2d261ee8, 0xeeaf455, 0x2b218eb3, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 
0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 
0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 
0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 
0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xc8ac869, 0x2b2246b2, 
0x16b9dd82, 0x1759f9f6, 0x3384ea95, 0x13adbd3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 
0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 
0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 
0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 
0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3124eb97, 0x12fe7539, 
0x3ab46a79, 0xfa78504, 0x19a3ebb9, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 
0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 
0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 
0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 
0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa6d0fa, 0x2483eba8, 0xbdc94e7, 
0x27224f11, 0x7fe947f, 0x3c01fdef, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 
0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 
0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 
0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 
0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffbf, 0x7fde47f, 0x2e01d5dd, 0x4a7ac60, 
0x1f910247, 0x4080440, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 
0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 
0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 
0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 
0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 
};

static uint32_t ColorBars100_720_0[] = 
{ //0
0x20010200, 0x4080040, 0x20010600, 0x1f6800cb, 0x200c8600, 0x3ac803ab, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 
0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 
0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 
0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x1ffeb200, 0x3ac803ac, 0x207eb1b9, 0x38c483a2, 0x87dde15, 0x36d88f6d, 0x229db441, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 
0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 
0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 
0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x229db440, 0x36d1036d, 0x40db629, 0x36d8a76d, 0x228db441, 0x36d2636d, 0x153d65db, 0x3054d72f, 0x8ebca0f, 0x2f299af2, 0x267bc841, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 
0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 
0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 
0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x267bc840, 0x2f2102f2, 0x40bca67, 0x2f299ef2, 0x251bc840, 0x2f210af2, 
0x4dba1d9, 0x2bd4d6d2, 0xbdacc5c, 0x2b219eb2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 
0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 
0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 
0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x69ac8a7, 0x2b229eb2, 0xa7ac869, 0x2b21a6b2, 0x91ac8c8, 0x27760ab2, 0x27e7d96b, 0x13aa5575, 0x36f4eb38, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 
0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 
0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 
0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3594eb97, 0x13ae5d3a, 0x3974eb59, 0x13ad653a, 0x3124eb97, 0x12fe7539, 0x3ab46a79, 0xfa78504, 0x19a3ebb9, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 
0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 
0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 
0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x1993ebc0, 0xfaf00fa, 0x3c03e999, 0xfa664fa, 0x19a3ebc0, 0xfaefcfa, 0x3723e9f1, 0xbdab4e7, 0x36824ecb, 0x7f8947f, 
0x1d81ffbf, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 
0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 
0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 
0x1d71ffc0, 0x7ff007f, 0x3c01fdd7, 0x7f75c7f, 0x1d71ffc0, 0x7fea87f, 0x3321fdd9, 0x6079075, 0x1f312a8e, 0x4085840, 0x200101fe, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 
0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 
0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 
0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x3ffffc40, 0x0, 0x2749d000, 0x2009b26c, 0x1528a200, 0x65a4a, 0x40ffc40, 0x2e7103ff, 0x4082840, 0x15210218, 0x4080040, 
};

static uint32_t ColorBars100_486_0[] = 
{ //0
0x20010200, 0x4080040, 0x20014200, 0x1f6800dc, 0x200c4200, 0x3ac8039c, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 
0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x202eb1f1, 0x3a6667ac, 0x102e3e11, 0x3528a76d, 
0x23fd207c, 0x34811348, 0x40d2248, 0x34892748, 0x249d2040, 0x34810348, 0x40d2249, 0x34892748, 0x249d2040, 0x34810348, 0x40d2249, 0x34892748, 0x249d2040, 0x34810348, 0x40d2249, 0x34892748, 0x249d2040, 0x34810348, 0x40d2249, 0x34892748, 0x249d2040, 0x34810348, 0x40d2249, 0x34892748, 0x249d2040, 0x34810348, 0x40d2249, 0x34892748, 0x249d2040, 0x34810348, 0x40d2249, 0x34892748, 
0x249d2040, 0x34810348, 0x40d2249, 0x34892748, 0x249d2040, 0x34810348, 0x40d2249, 0x34892748, 0x249d2040, 0x34810348, 0x40d2249, 0x34892748, 0x249d2040, 0x34810348, 0x40d2249, 0x34892748, 0x249d2040, 0x34810348, 0x40d2249, 0x34892748, 0x249d2040, 0x34810348, 0x47d2249, 0x34890f48, 0x1fcd1c98, 0x30554735, 0x219b395c, 0x2a62baad, 0x4fa9a86, 0x2a6a5ea6, 0x297a9840, 0x2a6102a6, 
0x40a9a97, 0x2a6a5ea6, 0x297a9840, 0x2a6102a6, 0x40a9a97, 0x2a6a5ea6, 0x297a9840, 0x2a6102a6, 0x40a9a97, 0x2a6a5ea6, 0x297a9840, 0x2a6102a6, 0x40a9a97, 0x2a6a5ea6, 0x297a9840, 0x2a6102a6, 0x40a9a97, 0x2a6a5ea6, 0x297a9840, 0x2a6102a6, 0x40a9a97, 0x2a6a5ea6, 0x297a9840, 0x2a6102a6, 0x40a9a97, 0x2a6a5ea6, 0x297a9840, 0x2a6102a6, 0x40a9a97, 0x2a6a5ea6, 0x297a9840, 0x2a6102a6, 
0x40a9a97, 0x2a6a5ea6, 0x297a9840, 0x2a6102a6, 0x40a9a97, 0x2a6a5ea6, 0x297a9840, 0x2a6102a6, 0x40a9a97, 0x2a6a5ea6, 0x297a9840, 0x2a6102a6, 0x40a9a97, 0x2a6a5ea6, 0x297a9840, 0x2a6102a6, 0x40a9a97, 0x2a6a5aa6, 0x271a9840, 0x2a311aa6, 0x59a45fc, 0x25158270, 0xf490c73, 0x24221242, 0x89908d7, 0x24235e42, 0xd790889, 0x24222642, 0x89908d7, 0x24235e42, 0xd790889, 0x24222642, 
0x89908d7, 0x24235e42, 0xd790889, 0x24222642, 0x89908d7, 0x24235e42, 0xd790889, 0x24222642, 0x89908d7, 0x24235e42, 0xd790889, 0x24222642, 0x89908d7, 0x24235e42, 0xd790889, 0x24222642, 0x89908d7, 0x24235e42, 0xd790889, 0x24222642, 0x89908d7, 0x24235e42, 0xd790889, 0x24222642, 0x89908d7, 0x24235e42, 0xd790889, 0x24222642, 0x89908d7, 0x24235e42, 0xd790889, 0x24222642, 
0x89908d7, 0x24235e42, 0xd790889, 0x24222642, 0x89908d7, 0x24235e42, 0xd790889, 0x24222642, 0x89908d7, 0x24235e42, 0xd790889, 0x24222642, 0x89908d7, 0x2423be42, 0x16a908a7, 0x21150a37, 0x24376e35, 0x1aab89b5, 0x3256ab1d, 0x1aadcdaa, 0x3776ab29, 0x1aaca5aa, 0x3296ab77, 0x1aadddaa, 0x3776ab29, 0x1aaca5aa, 0x3296ab77, 0x1aadddaa, 0x3776ab29, 0x1aaca5aa, 0x3296ab77, 0x1aadddaa, 
0x3776ab29, 0x1aaca5aa, 0x3296ab77, 0x1aadddaa, 0x3776ab29, 0x1aaca5aa, 0x3296ab77, 0x1aadddaa, 0x3776ab29, 0x1aaca5aa, 0x3296ab77, 0x1aadddaa, 0x3776ab29, 0x1aaca5aa, 0x3296ab77, 0x1aadddaa, 0x3776ab29, 0x1aaca5aa, 0x3296ab77, 0x1aadddaa, 0x3776ab29, 0x1aaca5aa, 0x3296ab77, 0x1aadddaa, 0x3776ab29, 0x1aaca5aa, 0x3296ab77, 0x1aadddaa, 0x3776ab29, 0x1aaca5aa, 0x3296ab77, 0x1aadddaa, 
0x3776ab29, 0x1aaca5aa, 0x3296ab77, 0x1aadddaa, 0x3776ab29, 0x1aaca5aa, 0x3296ab77, 0x1aadddaa, 0x3786ab22, 0x1a9b81aa, 0x25366f83, 0x15be697c, 0x3b2525c0, 0x1465cd46, 0x16951bbe, 0x146f0146, 0x3c051969, 0x1465a546, 0x16951bc0, 0x146f0146, 0x3c051969, 0x1465a546, 0x16951bc0, 0x146f0146, 0x3c051969, 0x1465a546, 0x16951bc0, 0x146f0146, 0x3c051969, 0x1465a546, 0x16951bc0, 0x146f0146, 
0x3c051969, 0x1465a546, 0x16951bc0, 0x146f0146, 0x3c051969, 0x1465a546, 0x16951bc0, 0x146f0146, 0x3c051969, 0x1465a546, 0x16951bc0, 0x146f0146, 0x3c051969, 0x1465a546, 0x16951bc0, 0x146f0146, 0x3c051969, 0x1465a546, 0x16951bc0, 0x146f0146, 0x3c051969, 0x1465a546, 0x16951bc0, 0x146f0146, 0x3c051969, 0x1465a546, 0x16951bc0, 0x146f0146, 0x3c051969, 0x1465a546, 0x16951bc0, 0x146f0146, 
0x3c051969, 0x1465a546, 0x16b51bc0, 0x146efd46, 0x38e519a2, 0x11e9153f, 0x31539f00, 0xa5930b7, 0x1d42939f, 0xa4f00a4, 0x3c0291b7, 0xa46dca4, 0x1b7293c0, 0xa4f00a4, 0x3c0291b7, 0xa46dca4, 0x1b7293c0, 0xa4f00a4, 0x3c0291b7, 0xa46dca4, 0x1b7293c0, 0xa4f00a4, 0x3c0291b7, 0xa46dca4, 0x1b7293c0, 0xa4f00a4, 0x3c0291b7, 0xa46dca4, 0x1b7293c0, 0xa4f00a4, 0x3c0291b7, 0xa46dca4, 
0x1b7293c0, 0xa4f00a4, 0x3c0291b7, 0xa46dca4, 0x1b7293c0, 0xa4f00a4, 0x3c0291b7, 0xa46dca4, 0x1b7293c0, 0xa4f00a4, 0x3c0291b7, 0xa46dca4, 0x1b7293c0, 0xa4f00a4, 0x3c0291b7, 0xa46dca4, 0x1b7293c0, 0xa4f00a4, 0x3c0291b7, 0xa46dca4, 0x1b7293c0, 0xa4f00a4, 0x3c0291b7, 0xa46dca4, 0x1b7293c0, 0xa4f00a4, 0x3c0291b7, 0xa46dca4, 0x1b7293c0, 0xa4f00a4, 0x3ab291b7, 0xa46eca4, 
0x1cb26b49, 0x5dabc7f, 0x230119e4, 0x407e040, 0x20010202, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 
0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 
};

static uint32_t ColorBars100_576_0[] = 
{ //0
0x20010200, 0x4080040, 0x20014200, 0x1f6800dc, 0x200c4200, 0x3ac8039c, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 
0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x202eb1f1, 0x3a6667ac, 0x102e3e11, 0x3528a76d, 
0x23fd207c, 0x34811348, 0x40d2248, 0x34892748, 0x249d2040, 0x34810348, 0x40d2249, 0x34892748, 0x249d2040, 0x34810348, 0x40d2249, 0x34892748, 0x249d2040, 0x34810348, 0x40d2249, 0x34892748, 0x249d2040, 0x34810348, 0x40d2249, 0x34892748, 0x249d2040, 0x34810348, 0x40d2249, 0x34892748, 0x249d2040, 0x34810348, 0x40d2249, 0x34892748, 0x249d2040, 0x34810348, 0x40d2249, 0x34892748, 
0x249d2040, 0x34810348, 0x40d2249, 0x34892748, 0x249d2040, 0x34810348, 0x40d2249, 0x34892748, 0x249d2040, 0x34810348, 0x40d2249, 0x34892748, 0x249d2040, 0x34810348, 0x40d2249, 0x34892748, 0x249d2040, 0x34810348, 0x40d2249, 0x34892748, 0x249d2040, 0x34810348, 0x47d2249, 0x34890f48, 0x1fcd1c98, 0x30554735, 0x219b395c, 0x2a62baad, 0x4fa9a86, 0x2a6a5ea6, 0x297a9840, 0x2a6102a6, 
0x40a9a97, 0x2a6a5ea6, 0x297a9840, 0x2a6102a6, 0x40a9a97, 0x2a6a5ea6, 0x297a9840, 0x2a6102a6, 0x40a9a97, 0x2a6a5ea6, 0x297a9840, 0x2a6102a6, 0x40a9a97, 0x2a6a5ea6, 0x297a9840, 0x2a6102a6, 0x40a9a97, 0x2a6a5ea6, 0x297a9840, 0x2a6102a6, 0x40a9a97, 0x2a6a5ea6, 0x297a9840, 0x2a6102a6, 0x40a9a97, 0x2a6a5ea6, 0x297a9840, 0x2a6102a6, 0x40a9a97, 0x2a6a5ea6, 0x297a9840, 0x2a6102a6, 
0x40a9a97, 0x2a6a5ea6, 0x297a9840, 0x2a6102a6, 0x40a9a97, 0x2a6a5ea6, 0x297a9840, 0x2a6102a6, 0x40a9a97, 0x2a6a5ea6, 0x297a9840, 0x2a6102a6, 0x40a9a97, 0x2a6a5ea6, 0x297a9840, 0x2a6102a6, 0x40a9a97, 0x2a6a5aa6, 0x271a9840, 0x2a311aa6, 0x59a45fc, 0x25158270, 0xf490c73, 0x24221242, 0x89908d7, 0x24235e42, 0xd790889, 0x24222642, 0x89908d7, 0x24235e42, 0xd790889, 0x24222642, 
0x89908d7, 0x24235e42, 0xd790889, 0x24222642, 0x89908d7, 0x24235e42, 0xd790889, 0x24222642, 0x89908d7, 0x24235e42, 0xd790889, 0x24222642, 0x89908d7, 0x24235e42, 0xd790889, 0x24222642, 0x89908d7, 0x24235e42, 0xd790889, 0x24222642, 0x89908d7, 0x24235e42, 0xd790889, 0x24222642, 0x89908d7, 0x24235e42, 0xd790889, 0x24222642, 0x89908d7, 0x24235e42, 0xd790889, 0x24222642, 
0x89908d7, 0x24235e42, 0xd790889, 0x24222642, 0x89908d7, 0x24235e42, 0xd790889, 0x24222642, 0x89908d7, 0x24235e42, 0xd790889, 0x24222642, 0x89908d7, 0x2423be42, 0x16a908a7, 0x21150a37, 0x24376e35, 0x1aab89b5, 0x3256ab1d, 0x1aadcdaa, 0x3776ab29, 0x1aaca5aa, 0x3296ab77, 0x1aadddaa, 0x3776ab29, 0x1aaca5aa, 0x3296ab77, 0x1aadddaa, 0x3776ab29, 0x1aaca5aa, 0x3296ab77, 0x1aadddaa, 
0x3776ab29, 0x1aaca5aa, 0x3296ab77, 0x1aadddaa, 0x3776ab29, 0x1aaca5aa, 0x3296ab77, 0x1aadddaa, 0x3776ab29, 0x1aaca5aa, 0x3296ab77, 0x1aadddaa, 0x3776ab29, 0x1aaca5aa, 0x3296ab77, 0x1aadddaa, 0x3776ab29, 0x1aaca5aa, 0x3296ab77, 0x1aadddaa, 0x3776ab29, 0x1aaca5aa, 0x3296ab77, 0x1aadddaa, 0x3776ab29, 0x1aaca5aa, 0x3296ab77, 0x1aadddaa, 0x3776ab29, 0x1aaca5aa, 0x3296ab77, 0x1aadddaa, 
0x3776ab29, 0x1aaca5aa, 0x3296ab77, 0x1aadddaa, 0x3776ab29, 0x1aaca5aa, 0x3296ab77, 0x1aadddaa, 0x3786ab22, 0x1a9b81aa, 0x25366f83, 0x15be697c, 0x3b2525c0, 0x1465cd46, 0x16951bbe, 0x146f0146, 0x3c051969, 0x1465a546, 0x16951bc0, 0x146f0146, 0x3c051969, 0x1465a546, 0x16951bc0, 0x146f0146, 0x3c051969, 0x1465a546, 0x16951bc0, 0x146f0146, 0x3c051969, 0x1465a546, 0x16951bc0, 0x146f0146, 
0x3c051969, 0x1465a546, 0x16951bc0, 0x146f0146, 0x3c051969, 0x1465a546, 0x16951bc0, 0x146f0146, 0x3c051969, 0x1465a546, 0x16951bc0, 0x146f0146, 0x3c051969, 0x1465a546, 0x16951bc0, 0x146f0146, 0x3c051969, 0x1465a546, 0x16951bc0, 0x146f0146, 0x3c051969, 0x1465a546, 0x16951bc0, 0x146f0146, 0x3c051969, 0x1465a546, 0x16951bc0, 0x146f0146, 0x3c051969, 0x1465a546, 0x16951bc0, 0x146f0146, 
0x3c051969, 0x1465a546, 0x16b51bc0, 0x146efd46, 0x38e519a2, 0x11e9153f, 0x31539f00, 0xa5930b7, 0x1d42939f, 0xa4f00a4, 0x3c0291b7, 0xa46dca4, 0x1b7293c0, 0xa4f00a4, 0x3c0291b7, 0xa46dca4, 0x1b7293c0, 0xa4f00a4, 0x3c0291b7, 0xa46dca4, 0x1b7293c0, 0xa4f00a4, 0x3c0291b7, 0xa46dca4, 0x1b7293c0, 0xa4f00a4, 0x3c0291b7, 0xa46dca4, 0x1b7293c0, 0xa4f00a4, 0x3c0291b7, 0xa46dca4, 
0x1b7293c0, 0xa4f00a4, 0x3c0291b7, 0xa46dca4, 0x1b7293c0, 0xa4f00a4, 0x3c0291b7, 0xa46dca4, 0x1b7293c0, 0xa4f00a4, 0x3c0291b7, 0xa46dca4, 0x1b7293c0, 0xa4f00a4, 0x3c0291b7, 0xa46dca4, 0x1b7293c0, 0xa4f00a4, 0x3c0291b7, 0xa46dca4, 0x1b7293c0, 0xa4f00a4, 0x3c0291b7, 0xa46dca4, 0x1b7293c0, 0xa4f00a4, 0x3c0291b7, 0xa46dca4, 0x1b7293c0, 0xa4f00a4, 0x3ab291b7, 0xa46eca4, 
0x1cb26b49, 0x5dabc7f, 0x230119e4, 0x407e040, 0x20010202, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 
0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 
};



static uint32_t ColorBars75_1080_0[] = 
{ //0
0x20010200, 0x4080040, 0x20010600, 0x1f6800cb, 0x200c8600, 0x3ac803ab, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 
0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 
0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 
0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 
0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 
0x200eb200, 0x3ac72bac, 0x158e0a05, 0x2cc83f27, 0x21aa88e6, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 
0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 
0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 
0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 
0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 
0x20da88c4, 0x2934cea1, 0x1ca9cdab, 0x24549254, 0xc291639, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 
0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 
0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 
0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 
0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 
0xb591618, 0x22e6963e, 0x133874bf, 0x21632a16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 
0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 
0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 
0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 
0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0x116858cf, 0x2163b616, 
0x1907a5a1, 0x12897d89, 0x2ea3ee70, 0xfbc4cfb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 
0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 
0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 
0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 
0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x2cd3ef31, 0xf4cd8fb, 
0x34138e5b, 0xcc7a0d3, 0x1b33334b, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 
0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 
0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 
0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 
0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc71ccc, 0x2363333e, 0x9eb70bd, 
0x2551facd, 0x6fcf070, 0x3501bdf3, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 
0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 
0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 
0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 
0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fc686f, 0x2a81a1e6, 0x487c458, 
0x1fb10236, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 
0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 
0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 
0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 
0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 
};

static uint32_t ColorBars75_720_0[] = 
{ //0
0x20010200, 0x4080040, 0x20010600, 0x1f6800cb, 0x200c8600, 0x3ac803ab, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 
0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 
0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 
0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x205eb1ca, 0x32756382, 0xe6b320f, 0x2a286aa2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 
0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 
0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 
0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21fa88b0, 0x2a22c2a2, 0xb0a8a1f, 0x2a287ea2, 0x21ea88b1, 0x2a13caa2, 0x17fa4de4, 0x25459e73, 0xea9160b, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 
0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 
0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 
0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x24d914b0, 0x2452c245, 0xb09164d, 0x24593645, 0x23d914b0, 0x2452ca45, 
0xba8f9e3, 0x21d5a22e, 0x10e858c5, 0x21633616, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 
0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 
0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 
0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xcf858fd, 0x2163f616, 0xfd858cf, 0x21633e16, 0xed85916, 0x1e968616, 0x25f62590, 0xfb9c128, 0x3133eeea, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 
0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 
0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 
0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x3033ef31, 0xfbcc4fb, 0x3313ef03, 0xfbc0cfb, 0x2cd3ef31, 0xf4cd8fb, 0x34138e5b, 0xcc7a0d3, 0x1b33334b, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 
0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 
0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 
0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x350331b3, 0xcc6cccc, 0x1b333350, 0xccd40cc, 0x316331f5, 0x9ea04bd, 0x30e1fa99, 0x6f87070, 
0x1e21bf4f, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 
0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 
0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 
0x1e11bf50, 0x6fd406f, 0x3501bde1, 0x6f7846f, 0x1e11bf50, 0x6fd006f, 0x2e61bde3, 0x587ac68, 0x1f61226a, 0x4084040, 0x200101fe, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 
0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 
0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 
0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x3ffffc40, 0x0, 0x2749d000, 0x2009b26c, 0x2f4b7a00, 0x5a62f, 0x40ffc40, 0x2e7103ff, 0x4052440, 0x15210218, 0x4080040, 
};

static uint32_t ColorBars75_486_0[] = 
{ //0
0x20010200, 0x4080040, 0x20014200, 0x1f6800dc, 0x200c4200, 0x3ac8039c, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 
0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x201eb1fa, 0x3a7713ac, 0x158de20a, 0x2ba86f19, 
0x22da30ec, 0x2862da86, 0xb0a1a36, 0x2868de86, 0x237a18b0, 0x2862c286, 0xb0a1a37, 0x2868de86, 0x237a18b0, 0x2862c286, 0xb0a1a37, 0x2868de86, 0x237a18b0, 0x2862c286, 0xb0a1a37, 0x2868de86, 0x237a18b0, 0x2862c286, 0xb0a1a37, 0x2868de86, 0x237a18b0, 0x2862c286, 0xb0a1a37, 0x2868de86, 0x237a18b0, 0x2862c286, 0xb0a1a37, 0x2868de86, 0x237a18b0, 0x2862c286, 0xb0a1a37, 0x2868de86, 
0x237a18b0, 0x2862c286, 0xb0a1a37, 0x2868de86, 0x237a18b0, 0x2862c286, 0xb0a1a37, 0x2868de86, 0x237a18b0, 0x2862c286, 0xb0a1a37, 0x2868de86, 0x237a18b0, 0x2862c286, 0xb0a1a37, 0x2868de86, 0x237a18b0, 0x2862c286, 0xb0a1a37, 0x2868de86, 0x237a18b0, 0x2862c286, 0xb0a1a37, 0x2868da86, 0x21aa18d1, 0x27150e84, 0x1df925b7, 0x20f4be22, 0xcd83650, 0x20d9c60d, 0x271834b0, 0x20d2c20d, 
0xb083671, 0x20d9c60d, 0x271834b0, 0x20d2c20d, 0xb083671, 0x20d9c60d, 0x271834b0, 0x20d2c20d, 0xb083671, 0x20d9c60d, 0x271834b0, 0x20d2c20d, 0xb083671, 0x20d9c60d, 0x271834b0, 0x20d2c20d, 0xb083671, 0x20d9c60d, 0x271834b0, 0x20d2c20d, 0xb083671, 0x20d9c60d, 0x271834b0, 0x20d2c20d, 0xb083671, 0x20d9c60d, 0x271834b0, 0x20d2c20d, 0xb083671, 0x20d9c60d, 0x271834b0, 0x20d2c20d, 
0xb083671, 0x20d9c60d, 0x271834b0, 0x20d2c20d, 0xb083671, 0x20d9c60d, 0x271834b0, 0x20d2c20d, 0xb083671, 0x20d9c60d, 0x271834b0, 0x20d2c20d, 0xb083671, 0x20d9c60d, 0x271834b0, 0x20d2c20d, 0xb083671, 0x20d9c60d, 0x259834b0, 0x20b2d20d, 0xc27fe04, 0x1cf63de7, 0x13a70cd5, 0x1c238dc2, 0xe770922, 0x1c2485c2, 0x121708e7, 0x1c239dc2, 0xe770921, 0x1c2485c2, 0x121708e7, 0x1c239dc2, 
0xe770921, 0x1c2485c2, 0x121708e7, 0x1c239dc2, 0xe770921, 0x1c2485c2, 0x121708e7, 0x1c239dc2, 0xe770921, 0x1c2485c2, 0x121708e7, 0x1c239dc2, 0xe770921, 0x1c2485c2, 0x121708e7, 0x1c239dc2, 0xe770921, 0x1c2485c2, 0x121708e7, 0x1c239dc2, 0xe770921, 0x1c2485c2, 0x121708e7, 0x1c239dc2, 0xe770921, 0x1c2485c2, 0x121708e7, 0x1c239dc2, 0xe770921, 0x1c2485c2, 0x121708e7, 0x1c239dc2, 
0xe770921, 0x1c2485c2, 0x121708e7, 0x1c239dc2, 0xe770921, 0x1c2485c2, 0x121708e7, 0x1c239dc2, 0xe770921, 0x1c2485c2, 0x121708e7, 0x1c239dc2, 0xe770921, 0x1c24a9c2, 0x171708f1, 0x1ad52dc0, 0x20062200, 0x151a3d64, 0x2d653eb5, 0x14fc3d4f, 0x31953edf, 0x14fb7d4f, 0x2df53f19, 0x14fc654f, 0x31953edf, 0x14fb7d4f, 0x2df53f19, 0x14fc654f, 0x31953edf, 0x14fb7d4f, 0x2df53f19, 0x14fc654f, 
0x31953edf, 0x14fb7d4f, 0x2df53f19, 0x14fc654f, 0x31953edf, 0x14fb7d4f, 0x2df53f19, 0x14fc654f, 0x31953edf, 0x14fb7d4f, 0x2df53f19, 0x14fc654f, 0x31953edf, 0x14fb7d4f, 0x2df53f19, 0x14fc654f, 0x31953edf, 0x14fb7d4f, 0x2df53f19, 0x14fc654f, 0x31953edf, 0x14fb7d4f, 0x2df53f19, 0x14fc654f, 0x31953edf, 0x14fb7d4f, 0x2df53f19, 0x14fc654f, 0x31953edf, 0x14fb7d4f, 0x2df53f19, 0x14fc654f, 
0x31953edf, 0x14fb7d4f, 0x2df53f19, 0x14fc654f, 0x31953edf, 0x14fb7d4f, 0x2df53f19, 0x14fc654f, 0x31953ede, 0x14fb194f, 0x27153b1d, 0x12acad42, 0x33e449fc, 0x10469d06, 0x18f4134c, 0x104d4104, 0x3504118f, 0x10463d04, 0x18f41350, 0x104d4104, 0x3504118f, 0x10463d04, 0x18f41350, 0x104d4104, 0x3504118f, 0x10463d04, 0x18f41350, 0x104d4104, 0x3504118f, 0x10463d04, 0x18f41350, 0x104d4104, 
0x3504118f, 0x10463d04, 0x18f41350, 0x104d4104, 0x3504118f, 0x10463d04, 0x18f41350, 0x104d4104, 0x3504118f, 0x10463d04, 0x18f41350, 0x104d4104, 0x3504118f, 0x10463d04, 0x18f41350, 0x104d4104, 0x3504118f, 0x10463d04, 0x18f41350, 0x104d4104, 0x3504118f, 0x10463d04, 0x18f41350, 0x104d4104, 0x3504118f, 0x10463d04, 0x18f41350, 0x104d4104, 0x3504118f, 0x10463d04, 0x18f41350, 0x104d4104, 
0x3504118f, 0x10463d04, 0x18f41350, 0x104d4104, 0x34941197, 0x10277d04, 0x26f3bf0a, 0xa1a34c8, 0x20f23700, 0x8bd208b, 0x35022dd1, 0x8b7248b, 0x1c922f50, 0x8bd408b, 0x35022dc9, 0x8b7248b, 0x1c922f50, 0x8bd408b, 0x35022dc9, 0x8b7248b, 0x1c922f50, 0x8bd408b, 0x35022dc9, 0x8b7248b, 0x1c922f50, 0x8bd408b, 0x35022dc9, 0x8b7248b, 0x1c922f50, 0x8bd408b, 0x35022dc9, 0x8b7248b, 
0x1c922f50, 0x8bd408b, 0x35022dc9, 0x8b7248b, 0x1c922f50, 0x8bd408b, 0x35022dc9, 0x8b7248b, 0x1c922f50, 0x8bd408b, 0x35022dc9, 0x8b7248b, 0x1c922f50, 0x8bd408b, 0x35022dc9, 0x8b7248b, 0x1c922f50, 0x8bd408b, 0x35022dc9, 0x8b7248b, 0x1c922f50, 0x8bd408b, 0x35022dc9, 0x8b7248b, 0x1c922f50, 0x8bd408b, 0x35022dc9, 0x8b7248b, 0x1c922f50, 0x8bd408b, 0x34a22dc9, 0x8b7288b, 
0x1d322b14, 0x65aa07e, 0x23c135e5, 0x407d841, 0x1ff10206, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 
0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 
};

static uint32_t ColorBars75_576_0[] = 
{ //0
0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x5080040, 0x20037200, 0x310801f6, 0x200e7200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 
0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x200eb200, 0x3ac803ac, 0x1faeb200, 0x3ac807ac, 
0x20ae9dc4, 0x31956378, 0xecaea1b, 0x2868b68c, 0x236a18b6, 0x2862c286, 0xb0a1a37, 0x2868de86, 0x237a18b0, 0x2862c286, 0xb0a1a37, 0x2868de86, 0x237a18b0, 0x2862c286, 0xb0a1a37, 0x2868de86, 0x237a18b0, 0x2862c286, 0xb0a1a37, 0x2868de86, 0x237a18b0, 0x2862c286, 0xb0a1a37, 0x2868de86, 0x237a18b0, 0x2862c286, 0xb0a1a37, 0x2868de86, 0x237a18b0, 0x2862c286, 0xb0a1a37, 0x2868de86, 
0x237a18b0, 0x2862c286, 0xb0a1a37, 0x2868de86, 0x237a18b0, 0x2862c286, 0xb0a1a37, 0x2868de86, 0x237a18b0, 0x2862c286, 0xb0a1a37, 0x2868de86, 0x237a18b0, 0x2862c286, 0xb0a1a37, 0x2868de86, 0x237a18b0, 0x2862c286, 0xb0a1a37, 0x2868de86, 0x237a18b0, 0x2862c286, 0xb0a1a37, 0x2868de86, 0x236a18b0, 0x28634686, 0x143a121a, 0x2496de71, 0x12f889df, 0x20d9420f, 0x271834cd, 0x20d2c20d, 
0xb083671, 0x20d9c60d, 0x271834b0, 0x20d2c20d, 0xb083671, 0x20d9c60d, 0x271834b0, 0x20d2c20d, 0xb083671, 0x20d9c60d, 0x271834b0, 0x20d2c20d, 0xb083671, 0x20d9c60d, 0x271834b0, 0x20d2c20d, 0xb083671, 0x20d9c60d, 0x271834b0, 0x20d2c20d, 0xb083671, 0x20d9c60d, 0x271834b0, 0x20d2c20d, 0xb083671, 0x20d9c60d, 0x271834b0, 0x20d2c20d, 0xb083671, 0x20d9c60d, 0x271834b0, 0x20d2c20d, 
0xb083671, 0x20d9c60d, 0x271834b0, 0x20d2c20d, 0xb083671, 0x20d9c60d, 0x271834b0, 0x20d2c20d, 0xb083671, 0x20d9c60d, 0x271834b0, 0x20d2c20d, 0xb083671, 0x20d9c60d, 0x271834b0, 0x20d2c20d, 0xb083671, 0x20d9c60d, 0x271834b0, 0x20d2c20d, 0xb483659, 0x1ff8120b, 0x18f79cc2, 0x1c3355cf, 0xe37093a, 0x1c2489c2, 0x121708e7, 0x1c239dc2, 0xe770921, 0x1c2485c2, 0x121708e7, 0x1c239dc2, 
0xe770921, 0x1c2485c2, 0x121708e7, 0x1c239dc2, 0xe770921, 0x1c2485c2, 0x121708e7, 0x1c239dc2, 0xe770921, 0x1c2485c2, 0x121708e7, 0x1c239dc2, 0xe770921, 0x1c2485c2, 0x121708e7, 0x1c239dc2, 0xe770921, 0x1c2485c2, 0x121708e7, 0x1c239dc2, 0xe770921, 0x1c2485c2, 0x121708e7, 0x1c239dc2, 0xe770921, 0x1c2485c2, 0x121708e7, 0x1c239dc2, 0xe770921, 0x1c2485c2, 0x121708e7, 0x1c239dc2, 
0xe770921, 0x1c2485c2, 0x121708e7, 0x1c239dc2, 0xe770921, 0x1c2485c2, 0x121708e7, 0x1c239dc2, 0xe770921, 0x1c2485c2, 0x121708e7, 0x1c239dc2, 0xe770921, 0x1c2489c2, 0x142708e7, 0x1c0441c2, 0x19e6b5b3, 0x16493588, 0x2be54662, 0x14fbc14f, 0x31953ede, 0x14fb7d4f, 0x2df53f19, 0x14fc654f, 0x31953edf, 0x14fb7d4f, 0x2df53f19, 0x14fc654f, 0x31953edf, 0x14fb7d4f, 0x2df53f19, 0x14fc654f, 
0x31953edf, 0x14fb7d4f, 0x2df53f19, 0x14fc654f, 0x31953edf, 0x14fb7d4f, 0x2df53f19, 0x14fc654f, 0x31953edf, 0x14fb7d4f, 0x2df53f19, 0x14fc654f, 0x31953edf, 0x14fb7d4f, 0x2df53f19, 0x14fc654f, 0x31953edf, 0x14fb7d4f, 0x2df53f19, 0x14fc654f, 0x31953edf, 0x14fb7d4f, 0x2df53f19, 0x14fc654f, 0x31953edf, 0x14fb7d4f, 0x2df53f19, 0x14fc654f, 0x31953edf, 0x14fb7d4f, 0x2df53f19, 0x14fc654f, 
0x31953edf, 0x14fb7d4f, 0x2df53f19, 0x14fc654f, 0x31953edf, 0x14fb7d4f, 0x2df53f19, 0x14fc654f, 0x31a53ed8, 0x14ea8d4f, 0x23750b23, 0x112cd52a, 0x346419ca, 0x10465504, 0x18f4134f, 0x104d4104, 0x3504118f, 0x10463d04, 0x18f41350, 0x104d4104, 0x3504118f, 0x10463d04, 0x18f41350, 0x104d4104, 0x3504118f, 0x10463d04, 0x18f41350, 0x104d4104, 0x3504118f, 0x10463d04, 0x18f41350, 0x104d4104, 
0x3504118f, 0x10463d04, 0x18f41350, 0x104d4104, 0x3504118f, 0x10463d04, 0x18f41350, 0x104d4104, 0x3504118f, 0x10463d04, 0x18f41350, 0x104d4104, 0x3504118f, 0x10463d04, 0x18f41350, 0x104d4104, 0x3504118f, 0x10463d04, 0x18f41350, 0x104d4104, 0x3504118f, 0x10463d04, 0x18f41350, 0x104d4104, 0x3504118f, 0x10463d04, 0x18f41350, 0x104d4104, 0x3504118f, 0x10463d04, 0x18f41350, 0x104d4104, 
0x3504118f, 0x10463d04, 0x19741350, 0x104d2504, 0x30a409df, 0xc89bcef, 0x3002868d, 0x8b83c8d, 0x1d122f48, 0x8bd408b, 0x35022dc9, 0x8b7248b, 0x1c922f50, 0x8bd408b, 0x35022dc9, 0x8b7248b, 0x1c922f50, 0x8bd408b, 0x35022dc9, 0x8b7248b, 0x1c922f50, 0x8bd408b, 0x35022dc9, 0x8b7248b, 0x1c922f50, 0x8bd408b, 0x35022dc9, 0x8b7248b, 0x1c922f50, 0x8bd408b, 0x35022dc9, 0x8b7248b, 
0x1c922f50, 0x8bd408b, 0x35022dc9, 0x8b7248b, 0x1c922f50, 0x8bd408b, 0x35022dc9, 0x8b7248b, 0x1c922f50, 0x8bd408b, 0x35022dc9, 0x8b7248b, 0x1c922f50, 0x8bd408b, 0x35022dc9, 0x8b7248b, 0x1c922f50, 0x8bd408b, 0x35022dc9, 0x8b7248b, 0x1c922f50, 0x8bd408b, 0x35022dc9, 0x8b7248b, 0x1c922f50, 0x8bd408b, 0x35022dc9, 0x8b7248b, 0x1c922f50, 0x8bcdc8b, 0x2e2229cd, 0x6576c7e, 
0x1ee1366e, 0x4086441, 0x200101fc, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 
0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 
};


static uint32_t Ramp_1080_0[] = 
{ //0
0x20010200, 0x407a840, 0x172101ea, 0x405c840, 0xce100ce, 0x4015840, 0x4010056, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 
0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4110041, 0x4010840, 0x4310042, 0x4010c40, 0x4410044, 0x4011440, 0x4610045, 0x4011840, 0x4710047, 0x4012040, 0x4910048, 0x4012440, 0x4a1044a, 0x4212c41, 0x4c1084b, 0x4313043, 0x4d1104d, 0x4513844, 0x4f1144e, 0x4613c46, 
0x5011c50, 0x4814447, 0x5212051, 0x4914849, 0x5312853, 0x4b1504a, 0x5512c54, 0x4c1544c, 0x5613456, 0x4e15c4d, 0x5813857, 0x4f1604f, 0x5914059, 0x5116850, 0x5b1445a, 0x5216c52, 0x5c14c5c, 0x5417453, 0x5e1505d, 0x5517855, 0x5f1585f, 0x5718056, 0x6115c60, 0x5818458, 0x6216462, 0x5a18c59, 0x6416863, 0x5b1905b, 0x6517065, 0x5d1985c, 0x6717466, 0x5e19c5e, 
0x6817c68, 0x601a45f, 0x6a18069, 0x611a861, 0x6b1886b, 0x631b062, 0x6d18c6c, 0x641b464, 0x6e1946e, 0x661bc65, 0x701986f, 0x671c067, 0x711a071, 0x691c868, 0x731a472, 0x6a1cc6a, 0x741ac74, 0x6c1d46b, 0x761b075, 0x6d1d86d, 0x771b877, 0x6f1e06e, 0x791bc78, 0x701e470, 0x7a1c47a, 0x721ec71, 0x7c1c87b, 0x731f073, 0x7d1d07d, 0x751f874, 0x7f1d47e, 0x761fc76, 
0x811dc81, 0x7820877, 0x831e082, 0x7920c79, 0x841e884, 0x7b2147a, 0x861ec85, 0x7c2187c, 0x871f487, 0x7e2207d, 0x891f888, 0x7f2247f, 0x8a2008a, 0x8122c80, 0x8c2048b, 0x8223082, 0x8d20c8d, 0x8423883, 0x8f2108e, 0x8523c85, 0x9021890, 0x8724486, 0x9221c91, 0x8824888, 0x9322493, 0x8a25089, 0x9522894, 0x8b2548b, 0x9623096, 0x8d25c8c, 0x9823497, 0x8e2608e, 
0x9923c99, 0x902688f, 0x9b2409a, 0x9126c91, 0x9c2489c, 0x9327492, 0x9e24c9d, 0x9427894, 0x9f2549f, 0x9628095, 0xa1258a0, 0x9728497, 0xa2260a2, 0x9928c98, 0xa4264a3, 0x9a2909a, 0xa526ca5, 0x9c2989b, 0xa7270a6, 0x9d29c9d, 0xa8278a8, 0x9f2a49e, 0xaa27ca9, 0xa02a8a0, 0xab284ab, 0xa22b0a1, 0xad288ac, 0xa32b4a3, 0xae290ae, 0xa52bca4, 0xb0294af, 0xa62c0a6, 
0xb129cb1, 0xa82c8a7, 0xb32a0b2, 0xa92cca9, 0xb42a8b4, 0xab2d4aa, 0xb62acb5, 0xac2d8ac, 0xb72b4b7, 0xae2e0ad, 0xb92b8b8, 0xaf2e4af, 0xba2c0ba, 0xb12ecb0, 0xbc2c4bb, 0xb22f0b2, 0xbd2ccbd, 0xb42f8b3, 0xbf2d0be, 0xb52fcb5, 0xc02d8c0, 0xb7304b6, 0xc22dcc1, 0xb8308b8, 0xc32e4c3, 0xba310b9, 0xc52e8c4, 0xbb314bb, 0xc62f0c6, 0xbd31cbc, 0xc82f4c7, 0xbe320be, 
0xc92fcc9, 0xc0328bf, 0xcb300ca, 0xc132cc1, 0xcc308cc, 0xc3334c2, 0xce30ccd, 0xc4338c4, 0xcf314cf, 0xc6340c5, 0xd1318d0, 0xc7344c7, 0xd2320d2, 0xc934cc8, 0xd4324d3, 0xca350ca, 0xd532cd5, 0xcc358cb, 0xd7330d6, 0xcd35ccd, 0xd8338d8, 0xcf364ce, 0xda33cd9, 0xd0368d0, 0xdb344db, 0xd2370d1, 0xdd348dc, 0xd3374d3, 0xde350de, 0xd537cd4, 0xe0354df, 0xd6380d6, 
0xe135ce1, 0xd8388d7, 0xe3360e2, 0xd938cd9, 0xe4368e4, 0xdb394da, 0xe636ce5, 0xdc398dc, 0xe7374e7, 0xde3a0dd, 0xe9378e8, 0xdf3a4df, 0xea380ea, 0xe13ace0, 0xec384eb, 0xe23b0e2, 0xed38ced, 0xe43b8e3, 0xef390ee, 0xe53bce5, 0xf0398f0, 0xe73c4e6, 0xf239cf1, 0xe83c8e8, 0xf33a4f3, 0xea3d0e9, 0xf53a8f4, 0xeb3d4eb, 0xf63b0f6, 0xed3dcec, 0xf83b4f7, 0xee3e0ee, 
0xf93bcf9, 0xf03e8ef, 0xfb3c0fa, 0xf13ecf1, 0xfc3c8fc, 0xf33f4f2, 0xfe3ccfd, 0xf43f8f4, 0xff3d4ff, 0xf6400f5, 0x1013d900, 0xf7404f7, 0x1023e102, 0xf940cf8, 0x1043e503, 0xfa410fa, 0x1053ed05, 0xfc418fb, 0x1073f106, 0xfd41cfd, 0x1083f908, 0xff424fe, 0x10a3fd09, 0x10042900, 0x10b4050b, 0x10243101, 0x10d4090c, 0x10343503, 0x10e4110e, 0x10543d04, 0x1104150f, 0x10644106, 
0x11141d11, 0x10844907, 0x11342112, 0x10944d09, 0x11442914, 0x10b4550a, 0x11642d15, 0x10c4590c, 0x11743517, 0x10e4610d, 0x11943918, 0x10f4650f, 0x11a4411a, 0x11146d10, 0x11c4451b, 0x11247112, 0x11d44d1d, 0x11447913, 0x11f4511e, 0x11547d15, 0x12045920, 0x11748516, 0x12245d21, 0x11848918, 0x12346523, 0x11a49119, 0x12546924, 0x11b4951b, 0x12647126, 0x11d49d1c, 0x12847527, 0x11e4a11e, 
0x12947d29, 0x1204a91f, 0x12b4812a, 0x1214ad21, 0x12c4892c, 0x1234b522, 0x12e48d2d, 0x1244b924, 0x12f4952f, 0x1264c125, 0x13149930, 0x1274c527, 0x1324a132, 0x1294cd28, 0x1344a533, 0x12a4d12a, 0x1354ad35, 0x12c4d92b, 0x1374b136, 0x12d4dd2d, 0x1384b938, 0x12f4e52e, 0x13a4bd39, 0x1304e930, 0x13b4c53b, 0x1324f131, 0x13d4c93c, 0x1334f533, 0x13e4d13e, 0x1354fd34, 0x1404d53f, 0x13650136, 
0x1414dd41, 0x13850937, 0x1434e142, 0x13950d39, 0x1444e944, 0x13b5153a, 0x1464ed45, 0x13c5193c, 0x1474f547, 0x13e5213d, 0x1494f948, 0x13f5253f, 0x14a5014a, 0x14152d40, 0x14c5054b, 0x14253142, 0x14d50d4d, 0x14453943, 0x14f5114e, 0x14553d45, 0x15051950, 0x14754546, 0x15251d51, 0x14854948, 0x15352553, 0x14a55149, 0x15552954, 0x14b5554b, 0x15653156, 0x14d55d4c, 0x15853557, 0x14e5614e, 
0x15953d59, 0x1505694f, 0x15b5415a, 0x15156d51, 0x15c5495c, 0x15357552, 0x15e54d5d, 0x15457954, 0x15f5555f, 0x15658155, 0x16155960, 0x15758557, 0x16256162, 0x15958d58, 0x16456563, 0x15a5915a, 0x16556d65, 0x15c5995b, 0x16757166, 0x15d59d5d, 0x16857968, 0x15f5a55e, 0x16a57d69, 0x1605a960, 0x16b5856b, 0x1625b161, 0x16d5896c, 0x1635b563, 0x16e5916e, 0x1655bd64, 0x1705956f, 0x1665c166, 
0x17159d71, 0x1685c967, 0x1735a172, 0x1695cd69, 0x1745a974, 0x16b5d56a, 0x1765ad75, 0x16c5d96c, 0x1775b577, 0x16e5e16d, 0x1795b978, 0x16f5e56f, 0x17a5c17a, 0x1715ed70, 0x17c5c57b, 0x1725f172, 0x17d5cd7d, 0x1745f973, 0x17f5d17e, 0x1755fd75, 0x1805d980, 0x17760576, 0x1825dd81, 0x17860978, 0x1835e583, 0x17a61179, 0x1855e984, 0x17b6157b, 0x1865f186, 0x17d61d7c, 0x1885f587, 0x17e6217e, 
0x1895fd89, 0x1806297f, 0x18b6018a, 0x18162d81, 0x18c6098c, 0x18363582, 0x18e60d8d, 0x18463984, 0x18f6158f, 0x18664185, 0x19161990, 0x18764587, 0x19262192, 0x18964d88, 0x19462593, 0x18a6518a, 0x19562d95, 0x18c6598b, 0x19763196, 0x18d65d8d, 0x19863998, 0x18f6658e, 0x19a63d99, 0x19066990, 0x19b6459b, 0x19267191, 0x19d6499c, 0x19367593, 0x19e6519e, 0x19567d94, 0x1a06559f, 0x19668196, 
0x1a165da1, 0x19868997, 0x1a3661a2, 0x19968d99, 0x1a4669a4, 0x19b6959a, 0x1a666da5, 0x19c6999c, 0x1a7675a7, 0x19e6a19d, 0x1a9679a8, 0x19f6a59f, 0x1aa681aa, 0x1a16ada0, 0x1ac685ab, 0x1a26b1a2, 0x1ad68dad, 0x1a46b9a3, 0x1af691ae, 0x1a56bda5, 0x1b0699b0, 0x1a76c5a6, 0x1b269db1, 0x1a86c9a8, 0x1b36a5b3, 0x1aa6d1a9, 0x1b56a9b4, 0x1ab6d5ab, 0x1b66b1b6, 0x1ad6ddac, 0x1b86b5b7, 0x1ae6e1ae, 
0x1b96bdb9, 0x1b06e9af, 0x1bb6c1ba, 0x1b16edb1, 0x1bc6c9bc, 0x1b36f5b2, 0x1be6cdbd, 0x1b46f9b4, 0x1bf6d5bf, 0x1b6701b5, 0x1c16d9c0, 0x1b7705b7, 0x1c26e1c2, 0x1b970db8, 0x1c46e5c3, 0x1ba711ba, 0x1c56edc5, 0x1bc719bb, 0x1c76f1c6, 0x1bd71dbd, 0x1c86f9c8, 0x1bf725be, 0x1ca6fdc9, 0x1c0729c0, 0x1cb705cb, 0x1c2731c1, 0x1cd709cc, 0x1c3735c3, 0x1ce711ce, 0x1c573dc4, 0x1d0715cf, 0x1c6741c6, 
0x1d171dd1, 0x1c8749c7, 0x1d3721d2, 0x1c974dc9, 0x1d4729d4, 0x1cb755ca, 0x1d672dd5, 0x1cc759cc, 0x1d7735d7, 0x1ce761cd, 0x1d9739d8, 0x1cf765cf, 0x1da741da, 0x1d176dd0, 0x1dc745db, 0x1d2771d2, 0x1dd74ddd, 0x1d4779d3, 0x1df751de, 0x1d577dd5, 0x1e0759e0, 0x1d7785d6, 0x1e275de1, 0x1d8789d8, 0x1e3765e3, 0x1da791d9, 0x1e5769e4, 0x1db795db, 0x1e6771e6, 0x1dd79ddc, 0x1e8775e7, 0x1de7a1de, 
0x1e977de9, 0x1e07a9df, 0x1eb781ea, 0x1e17ade1, 0x1ec789ec, 0x1e37b5e2, 0x1ee78ded, 0x1e47b9e4, 0x1ef795ef, 0x1e67c1e5, 0x1f1799f0, 0x1e77c5e7, 0x1f27a1f2, 0x1e97cde8, 0x1f47a5f3, 0x1ea7d1ea, 0x1f57adf5, 0x1ec7d9eb, 0x1f77b1f6, 0x1ed7dded, 0x1f87b9f8, 0x1ef7e5ee, 0x1fa7bdf9, 0x1f07e9f0, 0x1fb7c5fb, 0x1f27f1f1, 0x1fd7c9fc, 0x1f37f5f3, 0x1fe7d1fe, 0x1f57fdf4, 0x2007d5ff, 0x1f6801f6, 
0x2017de01, 0x1f8809f7, 0x2037e202, 0x1f980df9, 0x2047ea04, 0x1fb815fa, 0x2067ee05, 0x1fc819fc, 0x2077f607, 0x1fe821fd, 0x2097fa08, 0x1ff825ff, 0x20a8020a, 0x20182e00, 0x20c8060b, 0x20283202, 0x20d80e0d, 0x20483a03, 0x20f8120e, 0x20583e05, 0x21081a10, 0x20784606, 0x21281e11, 0x20884a08, 0x21382613, 0x20a85209, 0x21582a14, 0x20b8560b, 0x21683216, 0x20d85e0c, 0x21883617, 0x20e8620e, 
0x21983e19, 0x21086a0f, 0x21b8421a, 0x21186e11, 0x21c84a1c, 0x21387612, 0x21e84e1d, 0x21487a14, 0x21f8561f, 0x21688215, 0x22185a20, 0x21788617, 0x22286222, 0x21988e18, 0x22486623, 0x21a8921a, 0x22586e25, 0x21c89a1b, 0x22787226, 0x21d89e1d, 0x22887a28, 0x21f8a61e, 0x22a87e29, 0x2208aa20, 0x22b8862b, 0x2228b221, 0x22d88a2c, 0x2238b623, 0x22e8922e, 0x2258be24, 0x2308962f, 0x2268c226, 
0x23189e31, 0x2288ca27, 0x2338a232, 0x2298ce29, 0x2348aa34, 0x22b8d62a, 0x2368ae35, 0x22c8da2c, 0x2378b637, 0x22e8e22d, 0x2398ba38, 0x22f8e62f, 0x23a8c23a, 0x2318ee30, 0x23c8c63b, 0x2328f232, 0x23d8ce3d, 0x2348fa33, 0x23f8d23e, 0x2358fe35, 0x2408da40, 0x23790636, 0x2428de41, 0x23890a38, 0x2438e643, 0x23a91239, 0x2458ea44, 0x23b9163b, 0x2468f246, 0x23d91e3c, 0x2488f647, 0x23e9223e, 
0x2498fe49, 0x24092a3f, 0x24b9024a, 0x24192e41, 0x24c90a4c, 0x24393642, 0x24e90e4d, 0x24493a44, 0x24f9164f, 0x24694245, 0x25191a50, 0x24794647, 0x25292252, 0x24994e48, 0x25492653, 0x24a9524a, 0x25592e55, 0x24c95a4b, 0x25793256, 0x24d95e4d, 0x25893a58, 0x24f9664e, 0x25a93e59, 0x25096a50, 0x25b9465b, 0x25297251, 0x25d94a5c, 0x25397653, 0x25e9525e, 0x25597e54, 0x2609565f, 0x25698256, 
0x26195e61, 0x25898a57, 0x26396262, 0x25998e59, 0x26496a64, 0x25b9965a, 0x26696e65, 0x25c99a5c, 0x26797667, 0x25e9a25d, 0x26997a68, 0x25f9a65f, 0x26a9826a, 0x2619ae60, 0x26c9866b, 0x2629b262, 0x26d98e6d, 0x2649ba63, 0x26f9926e, 0x2659be65, 0x27099a70, 0x2679c666, 0x27299e71, 0x2689ca68, 0x2739a673, 0x26a9d269, 0x2759aa74, 0x26b9d66b, 0x2769b276, 0x26d9de6c, 0x2789b677, 0x26e9e26e, 
0x2799be79, 0x2709ea6f, 0x27b9c27a, 0x2719ee71, 0x27c9ca7c, 0x2739f672, 0x27e9ce7d, 0x2749fa74, 0x27f9d67f, 0x276a0275, 0x2819da80, 0x277a0677, 0x2829e282, 0x279a0e78, 0x2849e683, 0x27aa127a, 0x2859ee85, 0x27ca1a7b, 0x2879f286, 0x27da1e7d, 0x2889fa88, 0x27fa267e, 0x28a9fe89, 0x280a2a80, 0x28ba068b, 0x282a3281, 0x28da0a8c, 0x283a3683, 0x28ea128e, 0x285a3e84, 0x290a168f, 0x286a4286, 
0x291a1e91, 0x288a4a87, 0x293a2292, 0x289a4e89, 0x294a2a94, 0x28ba568a, 0x296a2e95, 0x28ca5a8c, 0x297a3697, 0x28ea628d, 0x299a3a98, 0x28fa668f, 0x29aa429a, 0x291a6e90, 0x29ca469b, 0x292a7292, 0x29da4e9d, 0x294a7a93, 0x29fa529e, 0x295a7e95, 0x2a0a5aa0, 0x297a8696, 0x2a2a5ea1, 0x298a8a98, 0x2a3a66a3, 0x29aa9299, 0x2a5a6aa4, 0x29ba969b, 0x2a6a72a6, 0x29da9e9c, 0x2a8a76a7, 0x29eaa29e, 
0x2a9a7ea9, 0x2a0aaa9f, 0x2aba82aa, 0x2a1aaea1, 0x2aca8aac, 0x2a3ab6a2, 0x2aea8ead, 0x2a4abaa4, 0x2afa96af, 0x2a6ac2a5, 0x2b1a9ab0, 0x2a7ac6a7, 0x2b2aa2b2, 0x2a9acea8, 0x2b4aa6b3, 0x2aaad2aa, 0x2b5aaeb5, 0x2acadaab, 0x2b7ab2b6, 0x2adadead, 0x2b8abab8, 0x2afae6ae, 0x2baabeb9, 0x2b0aeab0, 0x2bbac6bb, 0x2b2af2b1, 0x2bdacabc, 0x2b3af6b3, 0x2bead2be, 0x2b5afeb4, 0x2c0ad6bf, 0x2b6b02b6, 
0x2c1adec1, 0x2b8b0ab7, 0x2c3ae2c2, 0x2b9b0eb9, 0x2c4aeac4, 0x2bbb16ba, 0x2c6aeec5, 0x2bcb1abc, 0x2c7af6c7, 0x2beb22bd, 0x2c9afac8, 0x2bfb26bf, 0x2cab02ca, 0x2c1b2ec0, 0x2ccb06cb, 0x2c2b32c2, 0x2cdb0ecd, 0x2c4b3ac3, 0x2cfb12ce, 0x2c5b3ec5, 0x2d0b1ad0, 0x2c7b46c6, 0x2d2b1ed1, 0x2c8b4ac8, 0x2d3b26d3, 0x2cab52c9, 0x2d5b2ad4, 0x2cbb56cb, 0x2d6b32d6, 0x2cdb5ecc, 0x2d8b36d7, 0x2ceb62ce, 
0x2d9b3ed9, 0x2d0b6acf, 0x2dbb42da, 0x2d1b6ed1, 0x2dcb4adc, 0x2d3b76d2, 0x2deb4edd, 0x2d4b7ad4, 0x2dfb56df, 0x2d6b82d5, 0x2e1b5ae0, 0x2d7b86d7, 0x2e2b62e2, 0x2d9b8ed8, 0x2e4b66e3, 0x2dab92da, 0x2e5b6ee5, 0x2dcb9adb, 0x2e7b72e6, 0x2ddb9edd, 0x2e8b7ae8, 0x2dfba6de, 0x2eab7ee9, 0x2e0baae0, 0x2ebb86eb, 0x2e2bb2e1, 0x2edb8aec, 0x2e3bb6e3, 0x2eeb92ee, 0x2e5bbee4, 0x2f0b96ef, 0x2e6bc2e6, 
0x2f1b9ef1, 0x2e8bcae7, 0x2f3ba2f2, 0x2e9bcee9, 0x2f4baaf4, 0x2ebbd6ea, 0x2f6baef5, 0x2ecbdaec, 0x2f7bb6f7, 0x2eebe2ed, 0x2f9bbaf8, 0x2efbe6ef, 0x2fabc2fa, 0x2f1beef0, 0x2fcbc6fb, 0x2f2bf2f2, 0x2fdbcefd, 0x2f4bfaf3, 0x2ffbd2fe, 0x2f5bfef5, 0x300bdb00, 0x2f7c06f6, 0x302bdf01, 0x2f8c0af8, 0x303be703, 0x2fac12f9, 0x305beb04, 0x2fbc16fb, 0x306bf306, 0x2fdc1efc, 0x308bf707, 0x2fec22fe, 
0x309bff09, 0x300c2aff, 0x30bc030a, 0x301c2f01, 0x30cc0b0c, 0x303c3702, 0x30ec0f0d, 0x304c3b04, 0x30fc170f, 0x306c4305, 0x311c1b10, 0x307c4707, 0x312c2312, 0x309c4f08, 0x314c2713, 0x30ac530a, 0x315c2f15, 0x30cc5b0b, 0x317c3316, 0x30dc5f0d, 0x318c3b18, 0x30fc670e, 0x31ac3f19, 0x310c6b10, 0x31bc471b, 0x312c7311, 0x31dc4b1c, 0x313c7713, 0x31ec531e, 0x315c7f14, 0x320c571f, 0x316c8316, 
0x321c5f21, 0x318c8b17, 0x323c6322, 0x319c8f19, 0x324c6b24, 0x31bc971a, 0x326c6f25, 0x31cc9b1c, 0x327c7727, 0x31eca31d, 0x329c7b28, 0x31fca71f, 0x32ac832a, 0x321caf20, 0x32cc872b, 0x322cb322, 0x32dc8f2d, 0x324cbb23, 0x32fc932e, 0x325cbf25, 0x330c9b30, 0x327cc726, 0x332c9f31, 0x328ccb28, 0x333ca733, 0x32acd329, 0x335cab34, 0x32bcd72b, 0x336cb336, 0x32dcdf2c, 0x338cb737, 0x32ece32e, 
0x339cbf39, 0x330ceb2f, 0x33bcc33a, 0x331cef31, 0x33cccb3c, 0x333cf732, 0x33eccf3d, 0x334cfb34, 0x33fcd73f, 0x336d0335, 0x341cdb40, 0x337d0737, 0x342ce342, 0x339d0f38, 0x344ce743, 0x33ad133a, 0x345cef45, 0x33cd1b3b, 0x347cf346, 0x33dd1f3d, 0x348cfb48, 0x33fd273e, 0x34acff49, 0x340d2b40, 0x34bd074b, 0x342d3341, 0x34dd0b4c, 0x343d3743, 0x34ed134e, 0x345d3f44, 0x350d174f, 0x346d4346, 
0x351d1f51, 0x348d4b47, 0x353d2352, 0x349d4f49, 0x354d2b54, 0x34bd574a, 0x356d2f55, 0x34cd5b4c, 0x357d3757, 0x34ed634d, 0x359d3b58, 0x34fd674f, 0x35ad435a, 0x351d6f50, 0x35cd475b, 0x352d7352, 0x35dd4f5d, 0x354d7b53, 0x35fd535e, 0x355d7f55, 0x360d5b60, 0x357d8756, 0x362d5f61, 0x358d8b58, 0x363d6763, 0x35ad9359, 0x365d6b64, 0x35bd975b, 0x366d7366, 0x35dd9f5c, 0x368d7767, 0x35eda35e, 
0x369d7f69, 0x360dab5f, 0x36bd836a, 0x361daf61, 0x36cd8b6c, 0x363db762, 0x36ed8f6d, 0x364dbb64, 0x36fd976f, 0x366dc365, 0x371d9b70, 0x367dc767, 0x372da372, 0x369dcf68, 0x374da773, 0x36add36a, 0x375daf75, 0x36cddb6b, 0x377db376, 0x36dddf6d, 0x378dbb78, 0x36fde76e, 0x37adbf79, 0x370deb70, 0x37bdc77b, 0x372df371, 0x37ddcb7c, 0x373df773, 0x37edd37e, 0x375dff74, 0x380dd77f, 0x376e0376, 
0x381ddf81, 0x378e0b77, 0x383de382, 0x379e0f79, 0x384deb84, 0x37be177a, 0x386def85, 0x37ce1b7c, 0x387df787, 0x37ee237d, 0x389dfb88, 0x37fe277f, 0x38ae038a, 0x381e2f80, 0x38ce078b, 0x382e3382, 0x38de0f8d, 0x384e3b83, 0x38fe138e, 0x385e3f85, 0x390e1b90, 0x387e4786, 0x392e1f91, 0x388e4b88, 0x393e2793, 0x38ae5389, 0x395e2b94, 0x38be578b, 0x396e3396, 0x38de5f8c, 0x398e3797, 0x38ee638e, 
0x399e3f99, 0x390e6b8f, 0x39be439a, 0x391e6f91, 0x39ce4b9c, 0x393e7792, 0x39ee4f9d, 0x394e7b94, 0x39fe579f, 0x396e8395, 0x3a1e5ba0, 0x397e8797, 0x3a2e63a2, 0x399e8f98, 0x3a4e67a3, 0x39ae939a, 0x3a5e6fa5, 0x39ce9b9b, 0x3a7e73a6, 0x39de9f9d, 0x3a8e7ba8, 0x39fea79e, 0x3aae7fa9, 0x3a0eaba0, 0x3abe87ab, 0x3a2eb3a1, 0x3ade8bac, 0x3a3eb7a3, 0x3aee93ae, 0x3a5ebfa4, 0x3b0e97af, 0x3a6ec3a6, 
0x3b1e9fb1, 0x3a8ecba7, 0x3b3ea3b2, 0x3a9ecfa9, 0x3b4eabb4, 0x3abed7aa, 0x3b6eafb5, 0x3acedbac, 0x3b7eb3b7, 0x3acee3ac, 0x3b9eb3b8, 0x3acee7ac, 0x3baeb3ba, 0x3aceefac, 0x3bceb3bb, 0x3acef3ac, 0x3bdeb3bd, 0x3acefbac, 0x3bfeb3be, 0x3aceffac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 
0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3aceffac, 0x379eb3bf, 0x321de7ab, 0x2e07dae0, 0x4191ccb, 0x20110247, 0x4080440, 
};

static uint32_t Ramp_720_0[] = 
{ //0
0x20010200, 0x407a840, 0x172101ea, 0x405c840, 0xce100ce, 0x4015840, 0x4010056, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 
0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010440, 0x4210041, 0x4010840, 0x4410044, 0x4011840, 0x4710046, 0x4011c40, 0x4910049, 0x4012840, 0x4c1044a, 0x4213042, 
0x4e10c4e, 0x4513c44, 0x511184f, 0x4714446, 0x5212052, 0x4a15049, 0x5612854, 0x4c1584b, 0x5713457, 0x4e1644e, 0x5a13c59, 0x5116850, 0x5c1485c, 0x5317852, 0x5f1505e, 0x5617c55, 0x6115861, 0x5818857, 0x6416462, 0x5a1905a, 0x6616c66, 0x5d19c5c, 0x6917867, 0x5f1a45e, 0x6a1806a, 0x621b061, 0x6e1886c, 0x641b863, 0x6f1946f, 0x661c466, 0x7219c71, 0x691c868, 
0x741a874, 0x6b1d86a, 0x771b076, 0x6e1dc6d, 0x791b879, 0x701e86f, 0x7c1c47a, 0x721f072, 0x7e1cc7e, 0x751fc74, 0x811d87f, 0x7720476, 0x821e082, 0x7a21079, 0x861e884, 0x7c2187b, 0x871f487, 0x7e2247e, 0x8a1fc89, 0x8122880, 0x8c2088c, 0x8323882, 0x8f2108e, 0x8623c85, 0x9121891, 0x8824887, 0x9422492, 0x8a2508a, 0x9622c96, 0x8d25c8c, 0x9923897, 0x8f2648e, 
0x9a2409a, 0x9227091, 0x9e2489c, 0x9427893, 0x9f2549f, 0x9628496, 0xa225ca1, 0x9928898, 0xa4268a4, 0x9b2989a, 0xa7270a6, 0x9e29c9d, 0xa9278a9, 0xa02a89f, 0xac284aa, 0xa22b0a2, 0xae28cae, 0xa52bca4, 0xb1298af, 0xa72c4a6, 0xb22a0b2, 0xaa2d0a9, 0xb62a8b4, 0xac2d8ab, 0xb72b4b7, 0xae2e4ae, 0xba2bcb9, 0xb12e8b0, 0xbc2c8bc, 0xb32f8b2, 0xbf2d0be, 0xb62fcb5, 
0xc12d8c1, 0xb8308b7, 0xc42e4c2, 0xba310ba, 0xc62ecc6, 0xbd31cbc, 0xc92f8c7, 0xbf324be, 0xca300ca, 0xc2330c1, 0xce308cc, 0xc4338c3, 0xcf314cf, 0xc6344c6, 0xd231cd1, 0xc9348c8, 0xd4328d4, 0xcb358ca, 0xd7330d6, 0xce35ccd, 0xd9338d9, 0xd0368cf, 0xdc344da, 0xd2370d2, 0xde34cde, 0xd537cd4, 0xe1358df, 0xd7384d6, 0xe2360e2, 0xda390d9, 0xe6368e4, 0xdc398db, 
0xe7374e7, 0xde3a4de, 0xea37ce9, 0xe13a8e0, 0xec388ec, 0xe33b8e2, 0xef390ee, 0xe63bce5, 0xf1398f1, 0xe83c8e7, 0xf43a4f2, 0xea3d0ea, 0xf63acf6, 0xed3dcec, 0xf93b8f7, 0xef3e4ee, 0xfa3c0fa, 0xf23f0f1, 0xfe3c8fc, 0xf43f8f3, 0xff3d4ff, 0xf6404f6, 0x1023dd01, 0xf9408f8, 0x1043e904, 0xfb418fa, 0x1073f106, 0xfe41cfd, 0x1093f909, 0x100428ff, 0x10c4050a, 0x10243102, 
0x10e40d0e, 0x10543d04, 0x1114190f, 0x10744506, 0x11242112, 0x10a45109, 0x11642914, 0x10c4590b, 0x11743517, 0x10e4650e, 0x11a43d19, 0x11146910, 0x11c4491c, 0x11347912, 0x11f4511e, 0x11647d15, 0x12145921, 0x11848917, 0x12446522, 0x11a4911a, 0x12646d26, 0x11d49d1c, 0x12947927, 0x11f4a51e, 0x12a4812a, 0x1224b121, 0x12e4892c, 0x1244b923, 0x12f4952f, 0x1264c526, 0x13249d31, 0x1294c928, 
0x1344a934, 0x12b4d92a, 0x1374b136, 0x12e4dd2d, 0x1394b939, 0x1304e92f, 0x13c4c53a, 0x1324f132, 0x13e4cd3e, 0x1354fd34, 0x1414d93f, 0x13750536, 0x1424e142, 0x13a51139, 0x1464e944, 0x13c5193b, 0x1474f547, 0x13e5253e, 0x14a4fd49, 0x14152940, 0x14c5094c, 0x14353942, 0x14f5114e, 0x14653d45, 0x15151951, 0x14854947, 0x15452552, 0x14a5514a, 0x15652d56, 0x14d55d4c, 0x15953957, 0x14f5654e, 
0x15a5415a, 0x15257151, 0x15e5495c, 0x15457953, 0x15f5555f, 0x15658556, 0x16255d61, 0x15958958, 0x16456964, 0x15b5995a, 0x16757166, 0x15e59d5d, 0x16957969, 0x1605a95f, 0x16c5856a, 0x1625b162, 0x16e58d6e, 0x1655bd64, 0x1715996f, 0x1675c566, 0x1725a172, 0x16a5d169, 0x1765a974, 0x16c5d96b, 0x1775b577, 0x16e5e56e, 0x17a5bd79, 0x1715e970, 0x17c5c97c, 0x1735f972, 0x17f5d17e, 0x1765fd75, 
0x1815d981, 0x17860977, 0x1845e582, 0x17a6117a, 0x1865ed86, 0x17d61d7c, 0x1895f987, 0x17f6257e, 0x18a6018a, 0x18263181, 0x18e6098c, 0x18463983, 0x18f6158f, 0x18664586, 0x19261d91, 0x18964988, 0x19462994, 0x18b6598a, 0x19763196, 0x18e65d8d, 0x19963999, 0x1906698f, 0x19c6459a, 0x19267192, 0x19e64d9e, 0x19567d94, 0x1a16599f, 0x19768596, 0x1a2661a2, 0x19a69199, 0x1a6669a4, 0x19c6999b, 
0x1a7675a7, 0x19e6a59e, 0x1aa67da9, 0x1a16a9a0, 0x1ac689ac, 0x1a36b9a2, 0x1af691ae, 0x1a66bda5, 0x1b1699b1, 0x1a86c9a7, 0x1b46a5b2, 0x1aa6d1aa, 0x1b66adb6, 0x1ad6ddac, 0x1b96b9b7, 0x1af6e5ae, 0x1ba6c1ba, 0x1b26f1b1, 0x1be6c9bc, 0x1b46f9b3, 0x1bf6d5bf, 0x1b6705b6, 0x1c26ddc1, 0x1b9709b8, 0x1c46e9c4, 0x1bb719ba, 0x1c76f1c6, 0x1be71dbd, 0x1c96f9c9, 0x1c0729bf, 0x1cc705ca, 0x1c2731c2, 
0x1ce70dce, 0x1c573dc4, 0x1d1719cf, 0x1c7745c6, 0x1d2721d2, 0x1ca751c9, 0x1d6729d4, 0x1cc759cb, 0x1d7735d7, 0x1ce765ce, 0x1da73dd9, 0x1d1769d0, 0x1dc749dc, 0x1d3779d2, 0x1df751de, 0x1d677dd5, 0x1e1759e1, 0x1d8789d7, 0x1e4765e2, 0x1da791da, 0x1e676de6, 0x1dd79ddc, 0x1e9779e7, 0x1df7a5de, 0x1ea781ea, 0x1e27b1e1, 0x1ee789ec, 0x1e47b9e3, 0x1ef795ef, 0x1e67c5e6, 0x1f279df1, 0x1e97c9e8, 
0x1f47a9f4, 0x1eb7d9ea, 0x1f77b1f6, 0x1ee7dded, 0x1f97b9f9, 0x1f07e9ef, 0x1fc7c5fa, 0x1f27f1f2, 0x1fe7cdfe, 0x1f57fdf4, 0x2017d9ff, 0x1f7805f6, 0x2027e202, 0x1fa811f9, 0x2067ea04, 0x1fc819fb, 0x2077f607, 0x1fe825fe, 0x20a7fe09, 0x20182a00, 0x20c80a0c, 0x20383a02, 0x20f8120e, 0x20683e05, 0x21181a11, 0x20884a07, 0x21482612, 0x20a8520a, 0x21682e16, 0x20d85e0c, 0x21983a17, 0x20f8660e, 
0x21a8421a, 0x21287211, 0x21e84a1c, 0x21487a13, 0x21f8561f, 0x21688616, 0x22285e21, 0x21988a18, 0x22486a24, 0x21b89a1a, 0x22787226, 0x21e89e1d, 0x22987a29, 0x2208aa1f, 0x22c8862a, 0x2228b222, 0x22e88e2e, 0x2258be24, 0x23189a2f, 0x2278c626, 0x2328a232, 0x22a8d229, 0x2368aa34, 0x22c8da2b, 0x2378b637, 0x22e8e62e, 0x23a8be39, 0x2318ea30, 0x23c8ca3c, 0x2338fa32, 0x23f8d23e, 0x2368fe35, 
0x2418da41, 0x23890a37, 0x2448e642, 0x23a9123a, 0x2468ee46, 0x23d91e3c, 0x2498fa47, 0x23f9263e, 0x24a9024a, 0x24293241, 0x24e90a4c, 0x24493a43, 0x24f9164f, 0x24694646, 0x25291e51, 0x24994a48, 0x25492a54, 0x24b95a4a, 0x25793256, 0x24e95e4d, 0x25993a59, 0x25096a4f, 0x25c9465a, 0x25297252, 0x25e94e5e, 0x25597e54, 0x26195a5f, 0x25798656, 0x26296262, 0x25a99259, 0x26696a64, 0x25c99a5b, 
0x26797667, 0x25e9a65e, 0x26a97e69, 0x2619aa60, 0x26c98a6c, 0x2639ba62, 0x26f9926e, 0x2669be65, 0x27199a71, 0x2689ca67, 0x2749a672, 0x26a9d26a, 0x2769ae76, 0x26d9de6c, 0x2799ba77, 0x26f9e66e, 0x27a9c27a, 0x2729f271, 0x27e9ca7c, 0x2749fa73, 0x27f9d67f, 0x276a0676, 0x2829de81, 0x279a0a78, 0x2849ea84, 0x27ba1a7a, 0x2879f286, 0x27ea1e7d, 0x2899fa89, 0x280a2a7f, 0x28ca068a, 0x282a3282, 
0x28ea0e8e, 0x285a3e84, 0x291a1a8f, 0x287a4686, 0x292a2292, 0x28aa5289, 0x296a2a94, 0x28ca5a8b, 0x297a3697, 0x28ea668e, 0x29aa3e99, 0x291a6a90, 0x29ca4a9c, 0x293a7a92, 0x29fa529e, 0x296a7e95, 0x2a1a5aa1, 0x298a8a97, 0x2a4a66a2, 0x29aa929a, 0x2a6a6ea6, 0x29da9e9c, 0x2a9a7aa7, 0x29faa69e, 0x2aaa82aa, 0x2a2ab2a1, 0x2aea8aac, 0x2a4abaa3, 0x2afa96af, 0x2a6ac6a6, 0x2b2a9eb1, 0x2a9acaa8, 
0x2b4aaab4, 0x2abadaaa, 0x2b7ab2b6, 0x2aeadead, 0x2b9abab9, 0x2b0aeaaf, 0x2bcac6ba, 0x2b2af2b2, 0x2beacebe, 0x2b5afeb4, 0x2c1adabf, 0x2b7b06b6, 0x2c2ae2c2, 0x2bab12b9, 0x2c6aeac4, 0x2bcb1abb, 0x2c7af6c7, 0x2beb26be, 0x2caafec9, 0x2c1b2ac0, 0x2ccb0acc, 0x2c3b3ac2, 0x2cfb12ce, 0x2c6b3ec5, 0x2d1b1ad1, 0x2c8b4ac7, 0x2d4b26d2, 0x2cab52ca, 0x2d6b2ed6, 0x2cdb5ecc, 0x2d9b3ad7, 0x2cfb66ce, 
0x2dab42da, 0x2d2b72d1, 0x2deb4adc, 0x2d4b7ad3, 0x2dfb56df, 0x2d6b86d6, 0x2e2b5ee1, 0x2d9b8ad8, 0x2e4b6ae4, 0x2dbb9ada, 0x2e7b72e6, 0x2deb9edd, 0x2e9b7ae9, 0x2e0baadf, 0x2ecb86ea, 0x2e2bb2e2, 0x2eeb8eee, 0x2e5bbee4, 0x2f1b9aef, 0x2e7bc6e6, 0x2f2ba2f2, 0x2eabd2e9, 0x2f6baaf4, 0x2ecbdaeb, 0x2f7bb6f7, 0x2eebe6ee, 0x2fabbef9, 0x2f1beaf0, 0x2fcbcafc, 0x2f3bfaf2, 0x2ffbd2fe, 0x2f6bfef5, 
0x301bdb01, 0x2f8c0af7, 0x304be702, 0x2fac12fa, 0x306bef06, 0x2fdc1efc, 0x309bfb07, 0x2ffc26fe, 0x30ac030a, 0x302c3301, 0x30ec0b0c, 0x304c3b03, 0x30fc170f, 0x306c4706, 0x312c1f11, 0x309c4b08, 0x314c2b14, 0x30bc5b0a, 0x317c3316, 0x30ec5f0d, 0x319c3b19, 0x310c6b0f, 0x31cc471a, 0x312c7312, 0x31ec4f1e, 0x315c7f14, 0x321c5b1f, 0x317c8716, 0x322c6322, 0x31ac9319, 0x326c6b24, 0x31cc9b1b, 
0x327c7727, 0x31eca71e, 0x32ac7f29, 0x321cab20, 0x32cc8b2c, 0x323cbb22, 0x32fc932e, 0x326cbf25, 0x331c9b31, 0x328ccb27, 0x334ca732, 0x32acd32a, 0x336caf36, 0x32dcdf2c, 0x339cbb37, 0x32fce72e, 0x33acc33a, 0x332cf331, 0x33eccb3c, 0x334cfb33, 0x33fcd73f, 0x336d0736, 0x342cdf41, 0x339d0b38, 0x344ceb44, 0x33bd1b3a, 0x347cf346, 0x33ed1f3d, 0x349cfb49, 0x340d2b3f, 0x34cd074a, 0x342d3342, 
0x34ed0f4e, 0x345d3f44, 0x351d1b4f, 0x347d4746, 0x352d2352, 0x34ad5349, 0x356d2b54, 0x34cd5b4b, 0x357d3757, 0x34ed674e, 0x35ad3f59, 0x351d6b50, 0x35cd4b5c, 0x353d7b52, 0x35fd535e, 0x356d7f55, 0x361d5b61, 0x358d8b57, 0x364d6762, 0x35ad935a, 0x366d6f66, 0x35dd9f5c, 0x369d7b67, 0x35fda75e, 0x36ad836a, 0x362db361, 0x36ed8b6c, 0x364dbb63, 0x36fd976f, 0x366dc766, 0x372d9f71, 0x369dcb68, 
0x374dab74, 0x36bddb6a, 0x377db376, 0x36eddf6d, 0x379dbb79, 0x370deb6f, 0x37cdc77a, 0x372df372, 0x37edcf7e, 0x375dff74, 0x381ddb7f, 0x377e0776, 0x382de382, 0x37ae1379, 0x386deb84, 0x37ce1b7b, 0x387df787, 0x37ee277e, 0x38adff89, 0x381e2b80, 0x38ce0b8c, 0x383e3b82, 0x38fe138e, 0x386e3f85, 0x391e1b91, 0x388e4b87, 0x394e2792, 0x38ae538a, 0x396e2f96, 0x38de5f8c, 0x399e3b97, 0x38fe678e, 
0x39ae439a, 0x392e7391, 0x39ee4b9c, 0x394e7b93, 0x39fe579f, 0x396e8796, 0x3a2e5fa1, 0x399e8b98, 0x3a4e6ba4, 0x39be9b9a, 0x3a7e73a6, 0x39ee9f9d, 0x3a9e7ba9, 0x3a0eab9f, 0x3ace87aa, 0x3a2eb3a2, 0x3aee8fae, 0x3a5ebfa4, 0x3b1e9baf, 0x3a7ec7a6, 0x3b2ea3b2, 0x3aaed3a9, 0x3b6eabb4, 0x3acedbab, 0x3b7eb3b7, 0x3acee7ac, 0x3baeb3b9, 0x3aceebac, 0x3bceb3bc, 0x3acefbac, 0x3bfeb3be, 0x3aceffac, 
0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 
0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3bfeb3c0, 0x3aceffac, 0x379eaf79, 0x1f6b8321, 0x24732ee0, 0x4091c41, 0x20110201, 0x3ffffc40, 0x0, 0x2749d000, 0x2009b26c, 0x15341200, 0xb0a7f, 0x40ffc40, 0x2e7103ff, 0x4086c40, 0x15210218, 0x4080040, 
};


static uint32_t Ramp_486_0[] = 
{ //0
0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 
0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x1df10200, 0x4077c40, 0x16e1016e, 0x4034840, 0x61100d2, 0x4018440, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 
0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x3d1003d, 0x400c440, 0x2210031, 0x4008840, 0x1710017, 0x4004c40, 0x1310013, 0x3804c3f, 0x150a815, 0x150641c, 0x1d05019, 0x1607414, 0x2106021, 0x1c0941a, 0x2907825, 0x220a420, 0x2d0902d, 0x280c426, 0x350a831, 0x2e0d42c, 0x390c039, 0x340f432, 0x410d83d, 0x3a10438, 0x450f045, 0x401243e, 0x4d10849, 0x4613444, 
0x5112051, 0x4c1544a, 0x5913855, 0x5216450, 0x5d1505d, 0x5818456, 0x6516861, 0x5e1945c, 0x6918069, 0x641b462, 0x711986d, 0x6a1c468, 0x751b075, 0x701e46e, 0x7d1c879, 0x761f474, 0x811e081, 0x7c2147a, 0x891f885, 0x8222480, 0x8d2108d, 0x8824486, 0x9522891, 0x8e2548c, 0x9924099, 0x9427492, 0xa12589d, 0x9a28498, 0xa5270a5, 0xa02a49e, 0xad288a9, 0xa62b4a4, 
0xb12a0b1, 0xac2d4aa, 0xb92b8b5, 0xb22e4b0, 0xbd2d0bd, 0xb8304b6, 0xc52e8c1, 0xbe314bc, 0xc9300c9, 0xc4334c2, 0xd1318cd, 0xca344c8, 0xd5330d5, 0xd0364ce, 0xdd348d9, 0xd6374d4, 0xe1360e1, 0xdc394da, 0xe9378e5, 0xe23a4e0, 0xed390ed, 0xe83c4e6, 0xf53a8f1, 0xee3d4ec, 0xf93c0f9, 0xf43f4f2, 0x1013d8fd, 0xfa404f8, 0x1053f105, 0x100424fe, 0x10d40909, 0x10643504, 
0x11142111, 0x10c4550a, 0x11943915, 0x11246510, 0x11d4511d, 0x11848516, 0x12546921, 0x11e4951c, 0x12948129, 0x1244b522, 0x1314992d, 0x12a4c528, 0x1354b135, 0x1304e52e, 0x13d4c939, 0x1364f534, 0x1414e141, 0x13c5153a, 0x1494f945, 0x14252540, 0x14d5114d, 0x14854546, 0x15552951, 0x14e5554c, 0x15954159, 0x15457552, 0x1615595d, 0x15a58558, 0x16557165, 0x1605a55e, 0x16d58969, 0x1665b564, 
0x1715a171, 0x16c5d56a, 0x1795b975, 0x1725e570, 0x17d5d17d, 0x17860576, 0x1855e981, 0x17e6157c, 0x18960189, 0x18463582, 0x1916198d, 0x18a64588, 0x19563195, 0x1906658e, 0x19d64999, 0x19667594, 0x1a1661a1, 0x19c6959a, 0x1a9679a5, 0x1a26a5a0, 0x1ad691ad, 0x1a86c5a6, 0x1b56a9b1, 0x1ae6d5ac, 0x1b96c1b9, 0x1b46f5b2, 0x1c16d9bd, 0x1ba705b8, 0x1c56f1c5, 0x1c0725be, 0x1cd709c9, 0x1c6735c4, 
0x1d1721d1, 0x1cc755ca, 0x1d9739d5, 0x1d2765d0, 0x1dd751dd, 0x1d8785d6, 0x1e5769e1, 0x1de795dc, 0x1e9781e9, 0x1e47b5e2, 0x1f1799ed, 0x1ea7c5e8, 0x1f57b1f5, 0x1f07e5ee, 0x1fd7c9f9, 0x1f67f5f4, 0x2017e201, 0x1fc815fa, 0x2097fa05, 0x20282600, 0x20d8120d, 0x20884606, 0x21582a11, 0x20e8560c, 0x21984219, 0x21487612, 0x22185a1d, 0x21a88618, 0x22587225, 0x2208a61e, 0x22d88a29, 0x2268b624, 
0x2318a231, 0x22c8d62a, 0x2398ba35, 0x2328e630, 0x23d8d23d, 0x23890636, 0x2458ea41, 0x23e9163c, 0x24990249, 0x24493642, 0x25191a4d, 0x24a94648, 0x25593255, 0x2509664e, 0x25d94a59, 0x25697654, 0x26196261, 0x25c9965a, 0x26997a65, 0x2629a660, 0x26d9926d, 0x2689c666, 0x2759aa71, 0x26e9d66c, 0x2799c279, 0x2749f672, 0x2819da7d, 0x27aa0678, 0x2859f285, 0x280a267e, 0x28da0a89, 0x286a3684, 
0x291a2291, 0x28ca568a, 0x299a3a95, 0x292a6690, 0x29da529d, 0x298a8696, 0x2a5a6aa1, 0x29ea969c, 0x2a9a82a9, 0x2a4ab6a2, 0x2b1a9aad, 0x2aaac6a8, 0x2b5ab2b5, 0x2b0ae6ae, 0x2bdacab9, 0x2b6af6b4, 0x2c1ae2c1, 0x2bcb16ba, 0x2c9afac5, 0x2c2b26c0, 0x2cdb12cd, 0x2c8b46c6, 0x2d5b2ad1, 0x2ceb56cc, 0x2d9b42d9, 0x2d4b76d2, 0x2e1b5add, 0x2dab86d8, 0x2e5b72e5, 0x2e0ba6de, 0x2edb8ae9, 0x2e6bb6e4, 
0x2f1ba2f1, 0x2ecbd6ea, 0x2f9bbaf5, 0x2f2be6f0, 0x2fdbd2fd, 0x2f8c06f6, 0x305beb01, 0x2fec16fc, 0x309c0309, 0x304c3702, 0x311c1b0d, 0x30ac4708, 0x315c3315, 0x310c670e, 0x31dc4b19, 0x316c7714, 0x321c6321, 0x31cc971a, 0x329c7b25, 0x322ca720, 0x32dc932d, 0x328cc726, 0x335cab31, 0x32ecd72c, 0x339cc339, 0x334cf732, 0x341cdb3d, 0x33ad0738, 0x345cf345, 0x340d273e, 0x34dd0b49, 0x346d3744, 
0x351d2351, 0x34cd574a, 0x359d3b55, 0x352d6750, 0x35dd535d, 0x358d8756, 0x365d6b61, 0x35ed975c, 0x369d8369, 0x364db762, 0x371d9b6d, 0x36adc768, 0x375db375, 0x370de76e, 0x37ddcb79, 0x376df774, 0x381de381, 0x37ce177a, 0x389dfb85, 0x382e2780, 0x38de138d, 0x388e4786, 0x395e2b91, 0x38ee578c, 0x399e4399, 0x394e7792, 0x3a1e5b9d, 0x39ae8798, 0x3a5e73a5, 0x3a0ea79e, 0x3ade8ba9, 0x3a6eb7a4, 
0x3b1ea3b1, 0x3aced7aa, 0x3b9ebbb5, 0x3b2ee7b0, 0x3bded3bd, 0x3b8f07b6, 0x3c5eebc1, 0x3bef17bc, 0x3c9f03c9, 0x3c4f37c2, 0x3d1f1bcd, 0x3caf47c8, 0x3d5f33d5, 0x3d0f67ce, 0x3ddf4bd9, 0x3d6f77d4, 0x3e1f63e1, 0x3d7f97d8, 0x3e9f43e5, 0x3b4fa7c2, 0x3edeb7ed, 0x3acfb7ac, 0x3eceb3ed, 0x3acfb3ac, 0x3e5eb3e5, 0x3acf5bac, 0x3c8eb3d6, 0x3acf23ac, 0x3c1eb3c1, 0x3acf03ac, 0x3aceb3c0, 0x39ceb3ac, 
0x338c4338, 0xdca21f6, 0x21414288, 0x4085040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 
0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 
};

static uint32_t Ramp_576_0[] = 
{ //0
0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 
0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x1df10200, 0x4077c40, 0x16e1016e, 0x4034840, 0x61100d2, 0x4018440, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 
0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x3d1003d, 0x400c440, 0x2210031, 0x4008840, 0x1710017, 0x4004c40, 0x1310013, 0x3804c3f, 0x150a815, 0x150641c, 0x1d05019, 0x1607414, 0x2106021, 0x1c0941a, 0x2907825, 0x220a420, 0x2d0902d, 0x280c426, 0x350a831, 0x2e0d42c, 0x390c039, 0x340f432, 0x410d83d, 0x3a10438, 0x450f045, 0x401243e, 0x4d10849, 0x4613444, 
0x5112051, 0x4c1544a, 0x5913855, 0x5216450, 0x5d1505d, 0x5818456, 0x6516861, 0x5e1945c, 0x6918069, 0x641b462, 0x711986d, 0x6a1c468, 0x751b075, 0x701e46e, 0x7d1c879, 0x761f474, 0x811e081, 0x7c2147a, 0x891f885, 0x8222480, 0x8d2108d, 0x8824486, 0x9522891, 0x8e2548c, 0x9924099, 0x9427492, 0xa12589d, 0x9a28498, 0xa5270a5, 0xa02a49e, 0xad288a9, 0xa62b4a4, 
0xb12a0b1, 0xac2d4aa, 0xb92b8b5, 0xb22e4b0, 0xbd2d0bd, 0xb8304b6, 0xc52e8c1, 0xbe314bc, 0xc9300c9, 0xc4334c2, 0xd1318cd, 0xca344c8, 0xd5330d5, 0xd0364ce, 0xdd348d9, 0xd6374d4, 0xe1360e1, 0xdc394da, 0xe9378e5, 0xe23a4e0, 0xed390ed, 0xe83c4e6, 0xf53a8f1, 0xee3d4ec, 0xf93c0f9, 0xf43f4f2, 0x1013d8fd, 0xfa404f8, 0x1053f105, 0x100424fe, 0x10d40909, 0x10643504, 
0x11142111, 0x10c4550a, 0x11943915, 0x11246510, 0x11d4511d, 0x11848516, 0x12546921, 0x11e4951c, 0x12948129, 0x1244b522, 0x1314992d, 0x12a4c528, 0x1354b135, 0x1304e52e, 0x13d4c939, 0x1364f534, 0x1414e141, 0x13c5153a, 0x1494f945, 0x14252540, 0x14d5114d, 0x14854546, 0x15552951, 0x14e5554c, 0x15954159, 0x15457552, 0x1615595d, 0x15a58558, 0x16557165, 0x1605a55e, 0x16d58969, 0x1665b564, 
0x1715a171, 0x16c5d56a, 0x1795b975, 0x1725e570, 0x17d5d17d, 0x17860576, 0x1855e981, 0x17e6157c, 0x18960189, 0x18463582, 0x1916198d, 0x18a64588, 0x19563195, 0x1906658e, 0x19d64999, 0x19667594, 0x1a1661a1, 0x19c6959a, 0x1a9679a5, 0x1a26a5a0, 0x1ad691ad, 0x1a86c5a6, 0x1b56a9b1, 0x1ae6d5ac, 0x1b96c1b9, 0x1b46f5b2, 0x1c16d9bd, 0x1ba705b8, 0x1c56f1c5, 0x1c0725be, 0x1cd709c9, 0x1c6735c4, 
0x1d1721d1, 0x1cc755ca, 0x1d9739d5, 0x1d2765d0, 0x1dd751dd, 0x1d8785d6, 0x1e5769e1, 0x1de795dc, 0x1e9781e9, 0x1e47b5e2, 0x1f1799ed, 0x1ea7c5e8, 0x1f57b1f5, 0x1f07e5ee, 0x1fd7c9f9, 0x1f67f5f4, 0x2017e201, 0x1fc815fa, 0x2097fa05, 0x20282600, 0x20d8120d, 0x20884606, 0x21582a11, 0x20e8560c, 0x21984219, 0x21487612, 0x22185a1d, 0x21a88618, 0x22587225, 0x2208a61e, 0x22d88a29, 0x2268b624, 
0x2318a231, 0x22c8d62a, 0x2398ba35, 0x2328e630, 0x23d8d23d, 0x23890636, 0x2458ea41, 0x23e9163c, 0x24990249, 0x24493642, 0x25191a4d, 0x24a94648, 0x25593255, 0x2509664e, 0x25d94a59, 0x25697654, 0x26196261, 0x25c9965a, 0x26997a65, 0x2629a660, 0x26d9926d, 0x2689c666, 0x2759aa71, 0x26e9d66c, 0x2799c279, 0x2749f672, 0x2819da7d, 0x27aa0678, 0x2859f285, 0x280a267e, 0x28da0a89, 0x286a3684, 
0x291a2291, 0x28ca568a, 0x299a3a95, 0x292a6690, 0x29da529d, 0x298a8696, 0x2a5a6aa1, 0x29ea969c, 0x2a9a82a9, 0x2a4ab6a2, 0x2b1a9aad, 0x2aaac6a8, 0x2b5ab2b5, 0x2b0ae6ae, 0x2bdacab9, 0x2b6af6b4, 0x2c1ae2c1, 0x2bcb16ba, 0x2c9afac5, 0x2c2b26c0, 0x2cdb12cd, 0x2c8b46c6, 0x2d5b2ad1, 0x2ceb56cc, 0x2d9b42d9, 0x2d4b76d2, 0x2e1b5add, 0x2dab86d8, 0x2e5b72e5, 0x2e0ba6de, 0x2edb8ae9, 0x2e6bb6e4, 
0x2f1ba2f1, 0x2ecbd6ea, 0x2f9bbaf5, 0x2f2be6f0, 0x2fdbd2fd, 0x2f8c06f6, 0x305beb01, 0x2fec16fc, 0x309c0309, 0x304c3702, 0x311c1b0d, 0x30ac4708, 0x315c3315, 0x310c670e, 0x31dc4b19, 0x316c7714, 0x321c6321, 0x31cc971a, 0x329c7b25, 0x322ca720, 0x32dc932d, 0x328cc726, 0x335cab31, 0x32ecd72c, 0x339cc339, 0x334cf732, 0x341cdb3d, 0x33ad0738, 0x345cf345, 0x340d273e, 0x34dd0b49, 0x346d3744, 
0x351d2351, 0x34cd574a, 0x359d3b55, 0x352d6750, 0x35dd535d, 0x358d8756, 0x365d6b61, 0x35ed975c, 0x369d8369, 0x364db762, 0x371d9b6d, 0x36adc768, 0x375db375, 0x370de76e, 0x37ddcb79, 0x376df774, 0x381de381, 0x37ce177a, 0x389dfb85, 0x382e2780, 0x38de138d, 0x388e4786, 0x395e2b91, 0x38ee578c, 0x399e4399, 0x394e7792, 0x3a1e5b9d, 0x39ae8798, 0x3a5e73a5, 0x3a0ea79e, 0x3ade8ba9, 0x3a6eb7a4, 
0x3b1ea3b1, 0x3aced7aa, 0x3b9ebbb5, 0x3b2ee7b0, 0x3bded3bd, 0x3b8f07b6, 0x3c5eebc1, 0x3bef17bc, 0x3c9f03c9, 0x3c4f37c2, 0x3d1f1bcd, 0x3caf47c8, 0x3d5f33d5, 0x3d0f67ce, 0x3ddf4bd9, 0x3d6f77d4, 0x3e1f63e1, 0x3d7f97d8, 0x3e9f43e5, 0x3b4fa7c2, 0x3edeb7ed, 0x3acfb7ac, 0x3eceb3ed, 0x3acfb3ac, 0x3e5eb3e5, 0x3acf5bac, 0x3c8eb3d6, 0x3acf23ac, 0x3c1eb3c1, 0x3acf03ac, 0x3aceb3c0, 0x39ceb3ac, 
0x338c4338, 0xdca21f6, 0x21414288, 0x4085040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 
0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 
};


static uint32_t Multiburst_1080_0[] = 
{ //0
0x20010200, 0x4085840, 0x28e10616, 0x1f6a38cb, 0x332c8732, 0x3aceabab, 0x3c0eb3aa, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 
0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3ace53ac, 0x2a4eaf94, 0x1f6a9321, 
0x15c32d5c, 0x401b041, 0x401006c, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 
0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4015840, 0xce10456, 0x11b33886, 0x1726c172, 0x1f67a9f5, 0x2007d9ea, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1fd80df8, 0x21382203, 0x23484e1a, 0x23495a34, 0x2ad9967f, 0x2a1b7a65, 0x33da870f, 
0x2dcd96dc, 0x398c2784, 0x327e8b09, 0x3acc9fa8, 0x343eb343, 0x3a3d73a9, 0x373e675c, 0x37edcf8d, 0x387db387, 0x340e6358, 0x3a6c9f98, 0x2ede9b0b, 0x3b1b3bb1, 0x28bee6ad, 0x3be99fb9, 0x21eefa43, 0x3c07e7c0, 0x1afefdd4, 0x3ba62fbf, 0x145ee967, 0x3b2493b2, 0xe6e9d04, 0x39932ba7, 0x98e64b0, 0x38820f88, 0x61dd071, 0x35e15774, 0x44d784b, 0x34510745, 0x43ca840, 0x30d1272a, 0x5ec3452, 
0x2ed1b6ed, 0x93b307e, 0x2aa2aacc, 0xdeaa8c3, 0x2863f286, 0x13c9851b, 0x23c57a61, 0x1a68f182, 0x21672a16, 0x2157c1ef, 0x1cb8e5f0, 0x28172e5e, 0x1a5a91a5, 0x2e5602c5, 0x15cc0d80, 0x33a57320, 0x13ad493a, 0x37a46367, 0xf9e2518, 0x3a03e796, 0xdbe9cdb, 0x3ac2ffab, 0xa6ea4bf, 0x39b29ba4, 0x8fe408f, 0x36f1ef81, 0x6ad6c7b, 0x32b1ab45, 0x5bc405b, 0x2d4142f3, 0x47acc50, 0x26e11e91, 
0x4292442, 0x20010225, 0x4176c40, 0x191105b6, 0x465b846, 0x1291354b, 0x584244d, 0xcf160eb, 0x662d066, 0x871d89c, 0x8a1d076, 0x5722864, 0xa0130a0, 0x412e445, 0xd4100b9, 0x4835042, 0xf1140f1, 0x6a4405b, 0x1311ed10, 0xa54c48f, 0x1532f953, 0xf75dcd9, 0x19b45977, 0x15866d36, 0x1c15edc1, 0x1c47999f, 0x20c7a5e6, 0x2338320e, 0x23295e32, 0x29e9627b, 0x27cb0258, 0x2fe9f2e0, 
0x2a0c6ea0, 0x34eb0f35, 0x2e5d8ec3, 0x387b9777, 0x304e5304, 0x3a6c8b9f, 0x33eeaf22, 0x3aacfbac, 0x358e9758, 0x392dbf9d, 0x383e136f, 0x35fe0f73, 0x395d2795, 0x315e9330, 0x3afbe3a4, 0x2b9ebed9, 0x3b8a5fb8, 0x250efa74, 0x3c08afbe, 0x1e1f0206, 0x3bf6f3bf, 0x174eed98, 0x3b4547bb, 0x10fed12f, 0x3a93c3a9, 0xb9e70d4, 0x38b2839c, 0x77e2c8a, 0x37819b78, 0x4ed8859, 0x34a11b62, 0x40d2842, 
0x32f10b2f, 0x4ec4846, 0x2ee16b12, 0x8fbb86f, 0x2b82e2b8, 0x1169f0e6, 0x24651a7c, 0x19b91974, 0x21e6f21e, 0x1e6821d5, 0x2017c208, 0x1f6805f5, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2047da00, 0x210811fd, 0x2298ae29, 0x23e9f641, 0x2de8527d, 0x151b79c1, 0x30f38f0f, 0x90b7898, 0x24d35ade, 0x21593561, 0x193b1593, 0x3a03ab52, 0x72e90ea, 0x2d41cb5b, 0x4189441, 0xcf1796e, 0xc61905e, 0x6a31840, 0x16536565, 0x23387d7b, 0x2d4b821f, 0x3a6b5363, 
0x364e7764, 0x2b9ed349, 0x3b881bb4, 0xb9ee151, 0x36d1676d, 0x78b8c42, 0x2303c6e3, 0x2518c199, 0x175be575, 0x3aa34b73, 0x65e50d2, 0x29d19735, 0x407a040, 0xa51ad35, 0xdd1406b, 0x8737445, 0x18342983, 0x26f8f9b7, 0x2efc463e, 0x3acbbf81, 0x376e2776, 0x280eeb1f, 0x3b1727ba, 0x92ec51a, 0x35b1275b, 0x99b1c4b, 0x211496c7, 0x28c845d5, 0x157ca157, 0x3ab2f38e, 0x59df0bc, 0x26316708, 
0x426ac42, 0x811e500, 0xf511079, 0xac3d453, 0x1a1501a1, 0x2a8975f4, 0x309cf65d, 0x3a9c2798, 0x386db786, 0x245efaef, 0x3a7637be, 0x72e9ce8, 0x34610746, 0xc1aac5d, 0x1f1572ab, 0x2c47c613, 0x13bd413b, 0x3a429fa0, 0x50d70a7, 0x227142d5, 0x455c045, 0x65224d0, 0x10f10089, 0xd843c69, 0x1c05e5c0, 0x2de9ee31, 0x322d8a7b, 0x39dc8ba6, 0x394d2b94, 0x208f02bb, 0x39c54fc0, 0x59e70ba, 
0x33010730, 0xf0a3477, 0x1d265e8d, 0x2f774a4f, 0x11fdc91f, 0x395253aa, 0x49cd894, 0x1ea1269f, 0x4b4dc4b, 0x5026ca6, 0x12a1149b, 0x1094a886, 0x1df6d5df, 0x310a666d, 0x339e0699, 0x38ace7ac, 0x3a1c83a1, 0x1cbefe82, 0x38f473bf, 0x49e3c93, 0x31812f18, 0x1239bc98, 0x1b374e6f, 0x3266ce8a, 0x105e3505, 0x37d20bac, 0x44c2482, 0x1ad11265, 0x5340853, 0x442bc82, 0x146148af, 0x13e518ab, 
0x1fe7c9fe, 0x327aaea3, 0x30bd92ab, 0x300c2f52, 0x303a3b03, 0x1cdabe1f, 0x24d69eaf, 0x1c0935a8, 0x21077610, 0x1f6801f0, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x205869ff, 0x24d7a61a, 0x17f935a8, 0x21f6ea1f, 0x2f855e5e, 0x9abcd57, 0xf326a1b, 0xd916cd9, 0x23387cdf, 0x364d8e1f, 0x2b9d939d, 0x3b8547b8, 0x78b8c59, 0x175666e3, 0x3aa5d6f9, 0x65cd465, 0xa51ade8, 0x1831146b, 0x26f60d0a, 0x2efe06ef, 0x280eeb89, 0x35b46bba, 0x99d6c49, 
0x21175611, 0x3ab2f328, 0x42c20bc, 0x81109ab, 0xf514cf5, 0x2a897540, 0x386e625d, 0x245e1b6d, 0x3a73a3a7, 0xc1aac41, 0x13b84eab, 0x3a44ef50, 0x50b5450, 0x6522570, 0x1c01a489, 0x2de70179, 0x322e9b22, 0x208f034a, 0x3302ebc0, 0xf0cc041, 0x1d293dd2, 0x39525372, 0x4ba7c94, 0x5012d37, 0x12a2192a, 0x310a65b5, 0x3a1eb299, 0x1cbe8720, 0x38f24f8f, 0x1239bc4b, 0x105a2a6f, 0x37d4178d, 
0x4499444, 0x442bd02, 0x1fe2acaf, 0x33b7f9f2, 0x34eea74e, 0x18fef6f1, 0x2ff1cfbd, 0x15abfc5c, 0x195b0995, 0x35e1cf9f, 0x5e8a473, 0x40178d2, 0x16335963, 0x361b4a2f, 0x3b4e7ad2, 0x155ed2bc, 0x36f16b6f, 0x1958c876, 0xd3bda32, 0x33734faa, 0x407b040, 0x4536ca7, 0x23c41cdb, 0x3808f26b, 0x375e2f75, 0x11eec684, 0x2c9127b1, 0x1d1b2497, 0x159c9559, 0x30b16bac, 0x786bc5a, 0x521e083, 
0x19f4f19f, 0x397c1ea4, 0x3bedbf07, 0xebefa49, 0x34710747, 0x20e7ccbe, 0xa8d39f3, 0x2d92a3a5, 0x455d045, 0x6743466, 0x2795d50d, 0x3a59e6db, 0x394d3794, 0xbde760c, 0x28f1079d, 0x24ba3cec, 0x121dc121, 0x2a312796, 0x9a4ec49, 0x8426851, 0x1dd6c5dd, 0x3accdf0c, 0x3c0c8f37, 0x95f01cf, 0x31a12b1a, 0x2866d51f, 0x84e2db5, 0x2692137f, 0x5341453, 0xa851044, 0x2b17b944, 0x38fac732, 
0x376b5776, 0xe5c41a7, 0x2293f710, 0x2458a5a6, 0x1b09c9b0, 0x1fd7263f, 0x1f9791c9, 0x1f67e5ed, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2097de00, 0x1e5825fb, 0x21f7121f, 0x2736bdfc, 0x12f935af, 0x1064bd62, 0x21688616, 0x2a1dff50, 0x2de3337f, 0x251b7880, 0xd2ea8d2, 0xa51ae9d, 0x23e21c6b, 0x3ac8fa6f, 0x3baa03ba, 0x99b1c92, 0xbca32c7, 0x2632f3ab, 0x7920479, 0x2a8974ac, 0x3beea65d, 0x72efa45, 0x2ab306ab, 0x3a429ec4, 0x8989ca7, 0xd822465, 
0x27bb7a7b, 0x208f039d, 0x28d167c0, 0x2f7a34f0, 0x94e5494, 0x5026dea, 0x2994249b, 0x38aa6710, 0x3bf72fbf, 0x1239bc49, 0x82c9a6f, 0x1ad20b7d, 0xaf110af, 0x33bad93e, 0x3bddbab6, 0x41ef58f, 0x25156a51, 0x35e1cf4f, 0xc45c873, 0x17731040, 0x2d2d86d2, 0x155ee34b, 0x232107b8, 0x3718c995, 0x65cdc65, 0x4536d39, 0x2ed6ccdb, 0x322bb780, 0x3b147bb1, 0x1d184c4a, 0x5ae3213, 0x10416b0b, 
0xf4148f4, 0x397c1df0, 0x3a8bcb07, 0x5bea0eb, 0x1f3839f3, 0x2d91479f, 0x10d34c51, 0x22d43467, 0x320e9720, 0xbde76be, 0x1d41d79d, 0x3aa7524b, 0x49a8c49, 0x844a0a8, 0x3379a528, 0x286cdfac, 0x39025790, 0x2866d495, 0x44eb1b5, 0x8411269, 0x1442a144, 0x3aad36a3, 0x38192f4d, 0xbde0475, 0x197af997, 0x22d107a5, 0x16119c41, 0x2d9584d3, 0x361e7f61, 0x5bdc20e, 0x1793af70, 0x3975e6f2, 
0x407c040, 0x1045fc52, 0x373c2d7f, 0x1d1dcf8c, 0x35d12b5d, 0x32256d1e, 0x41e015b, 0x45105b3, 0x19d4e59d, 0x371e1337, 0x34965784, 0x155d2441, 0x13ed2d3e, 0x17711761, 0x1bb10045, 0x35e6ed72, 0x393d3f93, 0x41ccd5a, 0x12363f33, 0x33b48f6e, 0x4a4f84a, 0x1ad76c44, 0x39fdf5db, 0x123e7f26, 0x31b1271b, 0x38a421cb, 0x52c4108, 0x5014909, 0x1fa7a9fa, 0x2e8e438c, 0x2ce44390, 0x203b38ac, 
0x15abdd5a, 0x18556e6a, 0x2056055b, 0x22b81600, 0x21b80e1b, 0x1f5801f0, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007de00, 0x1dd841f4, 0x1b083e10, 0x1a06c23e, 0x1c3619c3, 0x26cc22ad, 0x22634b08, 0x375899ac, 0x5c7a45c, 0x26f8f84e, 0x3b1e263e, 0x99ec51a, 0x157ca157, 0x811e708, 0x30950079, 0x245c2798, 0x34610746, 0x3a429e13, 0x10f5c0a7, 0x2de43c69, 0x394d2b94, 0xf0a34ba, 0x49dca8d, 0x501269f, 0x1df6d5df, 0x1cbeffac, 0x1b312fbf, 0x37d6ce8a, 
0x5340853, 0x33bad8ab, 0x380bc6b6, 0x15ae0073, 0xebe7ceb, 0x4031229, 0x3628bcc4, 0x155d8b9e, 0x2e41dae4, 0x337196f6, 0x18129c65, 0x38060507, 0x3baa13ba, 0x1d184c49, 0x41eb213, 0x52105af, 0x25ba925b, 0xebea36f, 0x13d2fba8, 0x2d94f74e, 0x8819888, 0x3a5c8175, 0x33183320, 0x24bcc441, 0x95e5895, 0x844a13b, 0x3a0c3128, 0x95e8323, 0x27147e71, 0x2691138b, 0x1fc11044, 0x3aa7f1ee, 
0x3bd64fbd, 0x2be65c5b, 0x5dd8197, 0xd3174d5, 0x2d0d7ed0, 0x5bdc2c0, 0xd564770, 0x1f0357a9, 0xda110da, 0x38cdce67, 0x2cb48773, 0x322b2c94, 0x5bc385b, 0x13967485, 0x3bee559d, 0x41efa4d, 0x1f6829f6, 0x177117a6, 0x27719445, 0x34f9ded7, 0x39e3039e, 0x36e48ce9, 0x99a9923, 0x1ad26452, 0x336eb336, 0x49c6dd3, 0x85a0b1b, 0x10921781, 0x14229942, 0x2f7eab36, 0x2551dfaa, 0x39d95553, 
0x418c441, 0x22786440, 0x3b9e8219, 0x72ee55c, 0x17bbbd7b, 0xac1a33d, 0x2ea40068, 0x28cbab7c, 0x35e12f5e, 0x3ac301c9, 0xf06dcc0, 0x29d3c050, 0x383dcf83, 0xb9ac0f1, 0x52d26b0, 0x6a14ae0, 0x1b95b9b9, 0x215f03a4, 0x1d8107c0, 0x39876243, 0x4a5084a, 0x306a4c80, 0x392ca693, 0x118e489a, 0x10ae210a, 0x462ae71, 0x343798ab, 0x1a1d0fa1, 0x2e422ee4, 0x2f93a690, 0x1af528e9, 0x2826bd62, 
0x27f8ce7f, 0x1e981da4, 0x1f784607, 0x1f57ddf6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2087de00, 0x1f8821ee, 0x1cf889cf, 0x208825a5, 0x2b79ee09, 0x22dadd27, 0xddb5cdd, 0x2608dca4, 0x353c3637, 0x28cd4c51, 0x59c2059, 0x2a897444, 0x346bbe5d, 0x2c4d1841, 0x50b5450, 0x2de9ec40, 0x330aee7b, 0x2f7cc041, 0x49a7c49, 0x310a6445, 0x318a0a99, 0x326c604b, 0x4499444, 0x33bad852, 0x2ff91eb6, 0x34fbfc5c, 0x418a441, 0x361b4868, 0x2e482ad2, 0x371b9076, 
0x407b040, 0x380bb485, 0x2c9736ed, 0x38cb2497, 0x416bc41, 0x397c1caa, 0x2ad64707, 0x39fab4be, 0x455d045, 0x3a5c80d5, 0x28f55f20, 0x3aaa3cec, 0x4b4ec4b, 0x3accdd05, 0x27147f37, 0x3ac9c51f, 0x5341453, 0x3aad353b, 0x2533b34d, 0x3a594d57, 0x5d3545d, 0x39fd8574, 0x2342fb61, 0x3978d191, 0x692a869, 0x38cdcdaf, 0x21525f73, 0x380855cd, 0x7721477, 0x371e11ec, 0x1f61db84, 0x3617da0a, 
0x871a087, 0x34fe4e29, 0x1d617393, 0x33b75a47, 0x9914899, 0x326e7e65, 0x1b712f9f, 0x3106de82, 0xac114ac, 0x2f7eaa9f, 0x199107aa, 0x2de666bb, 0xc1100c1, 0x2c4eced5, 0x17b107b3, 0x2a85eeef, 0xd8110d8, 0x28cee708, 0x15d127b9, 0x26f5771f, 0xf0140f0, 0x251efb35, 0x140167be, 0x23350349, 0x10a1910a, 0x215f035b, 0x1251c7c0, 0x1f64976c, 0x12520125, 0x1d7f037b, 0x10a247c0, 0x1b942b88, 
0x14028d40, 0x19befb93, 0xf02dfbe, 0x17d3c39c, 0x15d3355d, 0x160ee7a3, 0xd8393b9, 0x144363a8, 0x17b3f57b, 0x128ecfab, 0xc145fb3, 0x10e307ac, 0x1994c599, 0xf5eabab, 0xac537aa, 0xdc2b3a7, 0x1b75a9b7, 0xc6e7fa1, 0x9961f9f, 0xb12679a, 0x1d6695d6, 0x9de4f90, 0x8770f93, 0x8b21f84, 0x1f6789f6, 0x92db36e, 0xc67ff6c, 0xe031b1d, 0x20d83e0d, 0x156a4aa6, 0x1ae82e92, 0x1c36ba39, 
0x2037f203, 0x1f5801fc, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2017da01, 0x2107bdee, 0x206749ef, 0x22f81a02, 0x25957e59, 0x12942ad0, 0x36192d0a, 0xc4d8665, 0xd0e44d0, 0x2a897489, 0x2ab9165d, 0x3a4aacc1, 0x8919489, 0x208f02de, 0x943c3c0, 0x5025395, 0x299c4299, 0x1239bdcb, 0xafdf66f, 0x33b2bc44, 0x3bd63fbd, 0x35e1cd5a, 0x2d210073, 0x155b4b61, 0x23265632, 0x4536f37, 0x3b1e00db, 0x1d1ec51e, 0x5ac2c5a, 0x397c1c52, 0x1f33af07, 0x2d97ce0e, 
0x10d19d0d, 0xbde77a5, 0x4992f9d, 0x84126a3, 0x337eb337, 0x2866d495, 0x1449a5b5, 0x3aa510a8, 0x3811d781, 0x22d106be, 0x36134c41, 0x5bd879f, 0x179bc979, 0x1045fdf0, 0x35de317f, 0x322d744a, 0x416cc41, 0x371e1139, 0x13e10784, 0x1774fb4b, 0x1bb5c9bb, 0x41ccf4f, 0x4adbb33, 0x1ad1293e, 0x39fc9b9f, 0x38a42049, 0x1fa42508, 0x2f77e9ea, 0x30216702, 0xd81739d, 0x3b389c5c, 0x72ecec4, 
0xd7ea4d7, 0x2638e0ac, 0x2cda3238, 0x3acb3492, 0x7621c76, 0x251efa9d, 0xab2e7be, 0x6a2afa6, 0x275b5275, 0xe6a4e15, 0x97e6293, 0x30625c54, 0x3c075fc0, 0x38221918, 0x2b011886, 0x19bac333, 0x25753e57, 0x4030365, 0x3b9d68c0, 0x189ee560, 0x68d0068, 0x37aba043, 0x2194a2e8, 0x314865c5, 0xef13cef, 0xf5eab93, 0x5280baa, 0x6214ae3, 0x31be8f1b, 0x23f76cc6, 0x123ab9db, 0x3ab48c7e, 
0x39327793, 0x2751167a, 0x34928445, 0x7bd27ab, 0x19dacd9d, 0xca56e39, 0x373e895b, 0x2e8dcc60, 0x407f040, 0x391dc0fa, 0x16113770, 0x1bf58719, 0x1974b997, 0x42d3777, 0x44d134d, 0x16611183, 0x390d5f90, 0x3684a040, 0x1d452528, 0x32f751a1, 0x32011f20, 0x11314785, 0x39f77851, 0x6fe7efc, 0x115d9d15, 0x21083519, 0x2779e60d, 0x2a19dd31, 0x18866188, 0x20a8da09, 0x1fa78236, 0x1f67e9ff, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1b0801f5, 0x20046e00, 0x4180086, 0x20010200, 0x4080040, 
};

static uint32_t Multiburst_720_0[] = 
{ //0
0x20010200, 0x4085840, 0x28e10616, 0x1f6a38cb, 0x332c8732, 0x3aceabab, 0x3c0eb3aa, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 
0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x3c0eb3c0, 0x3acf03ac, 0x394eb394, 0x321a93ab, 0x15c7daa4, 0x41570cb, 0x6c1006c, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 
0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x4010040, 0x5610040, 0x4115840, 0xce218ce, 0x1b05c91b, 0x1ea7d572, 0x1f67a9f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x21386e13, 0x2648e640, 0x25ea2239, 0x2cb97aaa, 0x283bae83, 0x324a9f09, 0x2c9cfaa7, 0x36ab2756, 0x2eadf6ea, 0x398c2b8c, 0x327e8b0a, 0x3acc9fa8, 0x343eb343, 0x3a3d73a9, 0x373e675c, 0x37edcf8d, 0x387db387, 0x340e6358, 0x3a6c9f98, 0x2ede9b0b, 0x3b1b3bb1, 0x28bee6ad, 0x3be99fb9, 0x21eefa43, 0x3c07e7c0, 0x1afefdd4, 0x3ba62fbf, 0x145ee967, 
0x3b2493b2, 0xe6e9d04, 0x39932ba7, 0x98e64b0, 0x38820f88, 0x61dd071, 0x35e15774, 0x44d784b, 0x34510745, 0x43ca840, 0x30d1272a, 0x5ec3452, 0x2ed1b6ed, 0x93b307e, 0x2aa2aacc, 0xdeaa8c3, 0x2863f286, 0x13c9851b, 0x23c57a61, 0x1a68f182, 0x21672a16, 0x2157c1ef, 0x1cb8e5f0, 0x28172e5e, 0x1a5a91a5, 0x2e5602c5, 0x15cc0d80, 0x33a57320, 0x13ad493a, 0x37a46367, 0xf9e2518, 0x3a03e796, 
0xdbe9cdb, 0x3ac2ffab, 0xa6ea4bf, 0x39b29ba4, 0x8fe408f, 0x36f1ef81, 0x6ad6c7b, 0x32b1ab45, 0x5bc405b, 0x2d4142f3, 0x47acc50, 0x26e11e91, 0x4292442, 0x20010225, 0x4176c40, 0x191105b6, 0x465b846, 0x1291354b, 0x584244d, 0xcf160eb, 0x662d066, 0x871d89c, 0x8a1d076, 0x5722864, 0xa0130a0, 0x412e445, 0xd4100b9, 0x4835042, 0xf1140f1, 0x6a4405b, 0x1311ed10, 0xa54c48f, 
0x1532f953, 0xf75dcd9, 0x19b45977, 0x15866d36, 0x1c15edc1, 0x1c47999f, 0x2007d9e6, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1fd801f6, 0x21084210, 0x24193a2b, 0x2b08fa4e, 0x1c1ac214, 0x30054700, 0x98c10e3, 0x29f24304, 0x161a7cd6, 
0x1f0855f0, 0x3524eac5, 0xa6e813a, 0x35b29ba4, 0x50b5050, 0x16e11a25, 0x8a33c46, 0x4022864, 0x1101a910, 0x17b704d9, 0x27c8cdc1, 0x3639f2e0, 0x322e9b22, 0x349e579d, 0x3c0ae795, 0x151f0206, 0x39c2e79c, 0x42cbc59, 0x28c1e32f, 0x199a30f1, 0x1d1945d1, 0x37347af9, 0x93ea91e, 0x33524f94, 0x49a7449, 0x135131e8, 0x9c2944c, 0x4527050, 0x12b21d2b, 0x1b77810a, 0x29a9bde0, 0x381a6b11, 
0x339eb339, 0x31fe8789, 0x3bfa03a1, 0x11aefdc9, 0x38e24b8e, 0x4bc5c49, 0x26e26717, 0x1d59b925, 0x1b2a31b2, 0x38e41328, 0x82ead04, 0x30820b7c, 0x4498c44, 0x100151ab, 0xb020454, 0x532c044, 0x1472b147, 0x1f47fd40, 0x2b7aa1ff, 0x398adf3d, 0x34fea74f, 0x2efeb36d, 0x3bd917ac, 0xe8ef58d, 0x37f1cb7f, 0x5dbf841, 0x250306fe, 0x2139415c, 0x194b1194, 0x3a03af50, 0x72e90eb, 0x2d51cb5c, 
0x4189c41, 0xd017970, 0xc51945e, 0x6931440, 0x16436164, 0x23187979, 0x2c6b661e, 0x371b1b4c, 0x31cd231c, 0x26dc22e7, 0x2ad7ff08, 0x19aab5b6, 0x24968e49, 0x1de839c1, 0x2007c60e, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x205869ff, 0x24d7a61a, 0x17f935a8, 0x21f6ea1f, 0x2f855e5e, 0x9abcd57, 0xf326a1b, 0xd916cd9, 0x23387cdf, 0x364d8e1f, 0x2b9d939d, 0x3b8547b8, 0x78b8c59, 0x175666e3, 0x3aa5d6f9, 0x65cd465, 0xa51ade8, 0x1831146b, 0x26f60d0a, 0x2efe06ef, 0x280eeb89, 0x35b46bba, 0x99d6c49, 0x21175611, 0x3ab2f328, 0x42c20bc, 0x81109ab, 0xf514cf5, 0x2a897540, 0x386e625d, 0x245e1b6d, 
0x3a73a3a7, 0xc1aac41, 0x13b84eab, 0x3a44ef50, 0x50b5450, 0x6522570, 0x1c01a489, 0x2de70179, 0x322e9b22, 0x208f034a, 0x3302ebc0, 0xf0cc041, 0x1d293dd2, 0x39525372, 0x4ba7c94, 0x5012d37, 0x12a2192a, 0x310a65b5, 0x3a1eb299, 0x1cbe8720, 0x38f24f8f, 0x1239bc4b, 0x105a2a6f, 0x37d4178d, 0x4499444, 0x442bd02, 0x1fe2acaf, 0x33b7f9f2, 0x34eea74e, 0x18fef6f1, 0x2ff1cfbd, 0x15abfc5c, 
0x195b0995, 0x35e1cf9f, 0x5e8a473, 0x40178d2, 0x16335963, 0x361b4a2f, 0x3b4e7ad2, 0x155ed2bc, 0x36f16b6f, 0x1958c876, 0xd3bda32, 0x33734faa, 0x407b040, 0x4536ca7, 0x23c41cdb, 0x3788f26b, 0x35edcb5e, 0x149d6a73, 0x27a31f5a, 0x1e49e921, 0x1be9b5be, 0x22e6ae76, 0x1e87b5ab, 0x1ed7a1df, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f7801f6, 0x21a7ee00, 0x1c4869e5, 0x1fd7f1fd, 0x24d55a73, 0x16e58956, 0x2215b906, 0x2e8d42e8, 0xcce0aa1, 0x1d120382, 0x3aa74651, 0x49a7449, 0x874aca5, 0x3399bd2b, 0x280ce7ac, 0x38e24b8e, 0x28c6c899, 0x44eadb2, 0x8111263, 0x1472b147, 0x3a9d3ea8, 0x37f9174f, 0xc1dfc72, 
0x194b1194, 0x227107a4, 0x16419441, 0x2de590d8, 0x363e7763, 0x59dba08, 0x1763c36e, 0x3955daf7, 0x407a840, 0x10960850, 0x375c4182, 0x1cbdd78a, 0x35b1275b, 0x32656123, 0x42df558, 0x44109ad, 0x1a04f9a0, 0x36ee1b3b, 0x34763f86, 0x15ad1c41, 0x13cd3d3c, 0x1721175e, 0x1bf10045, 0x3616fd77, 0x394d2f94, 0x41cc155, 0x12065730, 0x33748371, 0x4b4e44b, 0x1b377845, 0x3a1e01de, 0x11ee8722, 
0x31912b19, 0x38c415d1, 0x53c2d05, 0x5214d04, 0x1fd7c1fd, 0x2f2eaf97, 0x3003afab, 0x20ec005b, 0xece7cec, 0xd3176d9, 0x21c19c5d, 0x3a58722d, 0x3b3afbb3, 0x75b94bd, 0xd492ee5, 0x2a3353aa, 0x692a069, 0x2698ec84, 0x3baeb23b, 0x95eea86, 0x2ca256ca, 0x3ac2fa86, 0x779a4be, 0xa81dc84, 0x25aa8a5a, 0x246e8ba1, 0x28b293a2, 0x284a2cfc, 0x130bed30, 0x1595b211, 0x2186856c, 0x22a86224, 
0x21c7e21c, 0x1f6801ee, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f4801f7, 0x21077610, 0x23e6c20f, 0x1c3681b0, 0x2ad70d86, 0x3089b308, 0x1ac898d2, 0x5cdd626, 0x4e171e9, 0x23e9be3e, 0x11aec789, 0x157267b1, 0x30855f28, 
0x7920479, 0x398c2540, 0x34691709, 0x213d1841, 0xa7e90a7, 0x6943d70, 0x394b790f, 0xbae534a, 0x28d3c28d, 0x29f12772, 0x1df14049, 0x3ac77db5, 0x3bf72fbf, 0x28a6cc4b, 0x53df5b3, 0xab14d02, 0x2b6ceeb6, 0x73e02f1, 0xeb56b80, 0x2293af9f, 0xc4100c4, 0x39ed8a2f, 0x2e455762, 0x2f6b9076, 0x65cdc65, 0x107604a7, 0x3bae0181, 0x49eea84, 0x21374613, 0x1af107ac, 0x25b14841, 0x36f96ea4, 
0x3a83afa8, 0x34e4f4be, 0x88b653d, 0x17522066, 0x320e9720, 0x41cc60c, 0x9592f31, 0x13b25796, 0x12821128, 0x323e830c, 0x271257a0, 0x38b9c51f, 0x449a444, 0x1ee7f044, 0x3bdea9fc, 0x5bef593, 0x197af997, 0xd517760, 0x2d034c5d, 0x2c0b435f, 0x37016f70, 0x3a935591, 0xda7c0d5, 0x26736844, 0x373e3373, 0x94b2d21, 0x5bc8acb, 0x8516f0e, 0x19d4e59d, 0x24defb95, 0x1f6107be, 0x3a67da0a, 
0x455dc45, 0x2d79dc65, 0x384d2277, 0x10ae10d3, 0x14fc8d4f, 0xf849a73, 0x27a74526, 0x1ec9eaa2, 0x23968239, 0x20e7a607, 0x2007c5e9, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2017de01, 0x1f87fdee, 0x1b5889ff, 0x2086d5a5, 
0x29f9ee9f, 0x22d79127, 0xe3b5de4, 0x26038ca4, 0x388c3788, 0x28c6c851, 0xb0c21b2, 0x2a82c044, 0x3acbbfac, 0x2c465041, 0xc5b5594, 0x2de31440, 0x3b4aefb4, 0x2f75d841, 0xdca7d76, 0x31037045, 0x3baa0bba, 0x3265604b, 0xf499558, 0x33b3d052, 0x3be91fbe, 0x34f4f05c, 0x10e8a53c, 0x36143868, 0x3c082bc0, 0x37148076, 0x1297b120, 0x3804a485, 0x3c0737c0, 0x38c41497, 0x1456bd05, 0x397514aa, 
0x3bd647bd, 0x39f3b0be, 0x1625d0ec, 0x3a5588d5, 0x3b855fb8, 0x3aa350ec, 0x1804ecd4, 0x3ac60105, 0x3b147fb1, 0x3ac2f91f, 0x19e414be, 0x3aa6793b, 0x3a83b3a8, 0x3a52a557, 0x1bc354a9, 0x39f6f174, 0x39d2fb9d, 0x39725991, 0x1dc2a896, 0x38c771af, 0x39025f90, 0x380211cd, 0x1fb21484, 0x3717edec, 0x3811db81, 0x3611d20a, 0x21a1a074, 0x34f86a29, 0x37017370, 0x33b19e47, 0x23914867, 0x3268e665, 
0x35e12f5e, 0x31016e82, 0x2581145b, 0x2f79629f, 0x34910749, 0x2de146bb, 0x27610051, 0x2c49dad5, 0x33310733, 0x2a812aef, 0x2941104a, 0x289a5307, 0x30a18f0a, 0x256276fa, 0x26c32c9d, 0x2249b2b7, 0x26654e66, 0x20269a59, 0x20d715a6, 0x1f78360c, 0x2007d600, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6805f6, 0x1ef7ba01, 0x1d27be10, 0x20680a06, 0x15f9662f, 0x10ab4259, 0x24b42929, 0x36199761, 0x391340c4, 0x25d224d0, 0x245976a8, 0x2ab306ab, 0x65227a4, 0x3c0b7889, 0xf0f0208, 0x94e5494, 0x310a6450, 0x26f72e99, 0x37d9bd23, 0xaf110af, 0x18fef73b, 0x7356bbd, 0x401cf5e, 0x2d2d86d2, 0x1958c955, 0xdbcde32, 0x38036c45, 
0x3b147bb1, 0x30b169d1, 0x3071485a, 0xebc1f97, 0x1f3839f3, 0x67436d9, 0x39de950d, 0x24be74bd, 0x49a8c49, 0x3accdc84, 0x1b525737, 0x2696d686, 0x1442a144, 0x75e07aa, 0x41afb81, 0xd31062d, 0x361e7f61, 0x2f25e45b, 0x17f7c179, 0x38c5fd04, 0x35d12b5d, 0x1b310722, 0x3844e441, 0x41e1371, 0x13ed2d3e, 0x1726ed77, 0x333d3dbb, 0x36eccc41, 0x4a4f84a, 0x326e7dad, 0x1081279f, 0x1094238a, 
0x1fa7a9fa, 0x59c0af7, 0x5ce7702, 0x227170d8, 0x3b3b13b3, 0x3a935c72, 0x2382b0d7, 0x28c8e263, 0x2cd24acd, 0x871dbac, 0x3bea7476, 0xb9efa51, 0xabe98ab, 0x2d49d46a, 0x29385675, 0x398a4ce6, 0x9715097, 0x1d7f0306, 0x86463c0, 0x4621b82, 0x2b0cceb0, 0x1599499d, 0x100ce252, 0x2f240098, 0x30b66f0b, 0x27857dc0, 0x22f5dd5f, 0x1dd8be44, 0x2027ce02, 0x1f5801fc, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007d600, 0x11b801b0, 0x20021a00, 0x4080041, 0x20010200, 0x3ffffc40, 0x0, 0x2749d000, 0x2009b26c, 0x12bbd200, 0x41663, 0x4000040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 
};

static uint32_t Multiburst_486_0[] = 
{ //0
0x20010200, 0x4085040, 0x25812a14, 0x1479609e, 0x2b57c2b5, 0x24ebe644, 0x30d93af9, 0x24ec364e, 0x30d93b0d, 0x24ec364e, 0x30d93b0d, 0x24ec364e, 0x30d93b0d, 0x24ec364e, 0x30d93b0d, 0x24ec364e, 0x30d93b0d, 0x24ec364e, 0x30d93b0d, 0x24ec364e, 0x30d93b0d, 0x24ec364e, 0x30d93b0d, 0x24ec364e, 0x30d93b0d, 0x24ec364e, 0x30c93b0d, 0x24ec324e, 0x2e593ae5, 0x24e97a4e, 0x1a293a5e, 0x24e68a4e, 
0x11b9391b, 0x24e3d24e, 0xf3938f4, 0x24e3ce4e, 0xf3938f3, 0x24e3ce4e, 0xf3938f3, 0x24e3ce4e, 0xf3938f3, 0x24e3ce4e, 0xf3938f3, 0x24e3ce4e, 0xf3938f3, 0x24e3ce4e, 0xf3938f3, 0x24e3ce4e, 0xf3938f3, 0x24e3ce4e, 0xf3938f3, 0x24e3ce4e, 0xf3938f3, 0x24e3ce4e, 0xf3938f3, 0x24e3ce4e, 0xf38ecf3, 0x1213cdd3, 0xf3214f3, 0x403cc44, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 
0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403d040, 0xf8100f4, 0x403e040, 0xfc100fc, 0x403f840, 0xfb100fe, 0x403ec40, 0xf6100f6, 0x403cc40, 0xf9100f3, 0x403e440, 0x10d1010d, 0x404cc40, 0x16a10133, 0x405a840, 0x1a8101a8, 0x4078440, 0x207101e1, 0x4081c40, 0x20e1020e, 0x407c440, 0x1b6101f1, 0x406d840, 0x16b1016b, 0x4049440, 0xf910125, 0x403e440, 
0xfa100fa, 0x404b040, 0x18c1012c, 0x4063040, 0x20610206, 0x40a0040, 0x2de10280, 0x40b7840, 0x30b1030b, 0x40bf040, 0x2b4102fc, 0x40ad040, 0x24410244, 0x4071c40, 0x157111c7, 0x4a55c48, 0x10d1250d, 0x403cc44, 0x10a10cf3, 0x7442853, 0x14629546, 0x11c644e1, 0x1d751d91, 0x14275d56, 0x20443e04, 0x8083cc8, 0x1f71360f, 0x677dc42, 0x1c62edc6, 0x1a76252d, 0x14d83589, 0x24653646, 
0x11e8351e, 0x12d405a7, 0xf42ed01, 0x423d067, 0xf4134f4, 0xc83e480, 0xfd43cf9, 0x1563f542, 0xfd51cfd, 0xe13e91c, 0xf6294fa, 0x533d874, 0xf310cf3, 0x443cc40, 0xf3124f3, 0x483cc4a, 0xf3110f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 
0xf3100f3, 0x403d440, 0xfd100f5, 0x403f440, 0xfa100fa, 0x403cc40, 0x115100f3, 0x4045440, 0x17910179, 0x407b440, 0x20a101ed, 0x4082840, 0x1a4101a4, 0x4045c40, 0x10210117, 0x4040840, 0x1a9101a9, 0x40a6c40, 0x30d1029b, 0x41c3440, 0x29b10e9b, 0x416a441, 0x10213da9, 0x8e4086f, 0x11723d17, 0x436906a, 0x20a145a4, 0x119828a8, 0x1ed52ded, 0x8c5e50d, 0x11510179, 0x13d45484, 
0xf3790f3, 0x14e3e9ef, 0xfd214fa, 0xcc3f443, 0xf56e0f5, 0x2073ce49, 0xf34a4f3, 0x533cc64, 0xf33e0f3, 0x1ff3cdbe, 0xf362cf3, 0x483ccc6, 0xf3184f3, 0x13f3ccdb, 0xf34e4f3, 0x6c3ccd7, 0xf3100f3, 0x843cc58, 0xf324cf3, 0x5a3cc7d, 0xf3110f3, 0x423cc40, 0xf3108f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 
0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf6100f6, 0x403d840, 0xf9100f6, 0x403e440, 0x13b1013b, 0x4060c40, 0x14910183, 0x4052440, 0xf3100f3, 0x405f040, 0x26d1017c, 0x409b440, 0x23e1023e, 0x414b040, 0x1301012c, 0x5b4c045, 0x28319683, 0x45bf04c, 0x1cd21efc, 0x94734c5, 
0xf3108f3, 0x1286cc85, 0x2874adb3, 0x54a1c7c, 0x2024ca02, 0x11a459cb, 0x10f11516, 0x1ff43cd2, 0x17878178, 0x5e5a4a2, 0x11165d69, 0x14f4464b, 0xf3118f3, 0x20b3e0df, 0xf3744f8, 0x5a3cc99, 0xf3544f3, 0xfc3cdc6, 0xf3110f3, 0x13e3cc9f, 0xf3430f3, 0x4b3cc69, 0xf3298f3, 0x763ccc0, 0xf3104f3, 0x663cc53, 0xf3158f3, 0x403cc43, 0xf3104f3, 0x403cc40, 0xf3100f3, 0x403cc40, 
0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf6100f3, 0x403d840, 0xf6100f6, 0x404ac40, 0x13f1012b, 0x404fc40, 0xf4100f4, 0x405d840, 0x20110176, 0x4080440, 
0x12911129, 0x4b56054, 0x2b211558, 0x7eac87e, 0x1dc101dc, 0xdf40c97, 0x29f17103, 0x141a7c7e, 0x29f30a9f, 0x15e40c4c, 0x1dc59d03, 0x11477049, 0x2b27eeb2, 0x95560ad, 0x12988558, 0x434a562, 0x2016ea01, 0x655da08, 0xf440d76, 0xe53d239, 0x13f1b53f, 0x1664add9, 0xf61012b, 0x18d3d92a, 0xf61b8f6, 0x1483cc90, 0xf32a4f3, 0xd03cc48, 0xf32ccf3, 0x703cc43, 0xf3220f3, 0x463cc4c, 
0xf3158f3, 0x403cc47, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 
0xf4100f4, 0x4040840, 0xf310102, 0x403cc40, 0x14310143, 0x4145442, 0x14d12515, 0x4753452, 0x1bd1f1bd, 0xa13f440, 0x265184fd, 0xc399494, 0x13716537, 0x4482934, 0x2575420a, 0xed95ca6, 0x11f5a11f, 0x1fac3463, 0x11f13b0d, 0xf147dd7, 0x25744e57, 0x5c829de, 0x13793a0a, 0x1de4dc5c, 0x26544e65, 0x1d73f4f1, 0x1bd138fd, 0x636f5fa, 0x14d5a14d, 0xa6454ed, 0x14354115, 0x13450c44, 
0xf3164f3, 0x94408c3, 0xf318502, 0x403cca1, 0xf31f0f3, 0x523cc47, 0xf3124f3, 0x403cc41, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 
0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403e040, 0x123100f8, 0x4048c40, 0x17a1017a, 0x4074040, 0x1fb101d0, 0x407ec40, 
};


static uint32_t Multiburst_576_0[] = 
{ //0
0x20010200, 0x4085040, 0x25812a14, 0x1479609e, 0x2b57c2b5, 0x24ebe644, 0x30d93af9, 0x24ec364e, 0x30d93b0d, 0x24ec364e, 0x30d93b0d, 0x24ec364e, 0x30d93b0d, 0x24ec364e, 0x30d93b0d, 0x24ec364e, 0x30d93b0d, 0x24ec364e, 0x30d93b0d, 0x24ec364e, 0x30d93b0d, 0x24ec364e, 0x30d93b0d, 0x24ec364e, 0x30d93b0d, 0x24ec364e, 0x30c93b0d, 0x24ec324e, 0x2e593ae5, 0x24e97a4e, 0x1a293a5e, 0x24e68a4e, 
0x11b9391b, 0x24e3d24e, 0xf3938f4, 0x24e3ce4e, 0xf3938f3, 0x24e3ce4e, 0xf3938f3, 0x24e3ce4e, 0xf3938f3, 0x24e3ce4e, 0xf3938f3, 0x24e3ce4e, 0xf3938f3, 0x24e3ce4e, 0xf3938f3, 0x24e3ce4e, 0xf3938f3, 0x24e3ce4e, 0xf3938f3, 0x24e3ce4e, 0xf3938f3, 0x24e3ce4e, 0xf3938f3, 0x24e3ce4e, 0xf38ecf3, 0x1213cdd3, 0xf3214f3, 0x403cc44, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 
0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403d040, 0xf8100f4, 0x403e040, 0xfc100fc, 0x403f840, 0xfb100fe, 0x403ec40, 0xf6100f6, 0x403cc40, 0xf9100f3, 0x403e440, 0x10d1010d, 0x404cc40, 0x16a10133, 0x405a840, 0x1a8101a8, 0x4078440, 0x207101e1, 0x4081c40, 0x20e1020e, 0x407c440, 0x1b6101f1, 0x406d840, 0x16b1016b, 0x4049440, 0xf910125, 0x403e440, 
0xfa100fa, 0x404b040, 0x18c1012c, 0x4063040, 0x20610206, 0x40a0040, 0x2de10280, 0x40b7840, 0x30b1030b, 0x40bf040, 0x2b4102fc, 0x40ad040, 0x24410244, 0x4071c40, 0x157111c7, 0x4a55c48, 0x10d1250d, 0x403cc44, 0x10a10cf3, 0x7442853, 0x14629546, 0x11c644e1, 0x1d751d91, 0x14275d56, 0x20443e04, 0x8083cc8, 0x1f71360f, 0x677dc42, 0x1c62edc6, 0x1a76252d, 0x14d83589, 0x24653646, 
0x11e8351e, 0x12d405a7, 0xf42ed01, 0x423d067, 0xf4134f4, 0xc83e480, 0xfd43cf9, 0x1563f542, 0xfd51cfd, 0xe13e91c, 0xf6294fa, 0x533d874, 0xf310cf3, 0x443cc40, 0xf3124f3, 0x483cc4a, 0xf3110f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 
0xf3100f3, 0x403d440, 0xfd100f5, 0x403f440, 0xfa100fa, 0x403cc40, 0x115100f3, 0x4045440, 0x17910179, 0x407b440, 0x20a101ed, 0x4082840, 0x1a4101a4, 0x4045c40, 0x10210117, 0x4040840, 0x1a9101a9, 0x40a6c40, 0x30d1029b, 0x41c3440, 0x29b10e9b, 0x416a441, 0x10213da9, 0x8e4086f, 0x11723d17, 0x436906a, 0x20a145a4, 0x119828a8, 0x1ed52ded, 0x8c5e50d, 0x11510179, 0x13d45484, 
0xf3790f3, 0x14e3e9ef, 0xfd214fa, 0xcc3f443, 0xf56e0f5, 0x2073ce49, 0xf34a4f3, 0x533cc64, 0xf33e0f3, 0x1ff3cdbe, 0xf362cf3, 0x483ccc6, 0xf3184f3, 0x13f3ccdb, 0xf34e4f3, 0x6c3ccd7, 0xf3100f3, 0x843cc58, 0xf324cf3, 0x5a3cc7d, 0xf3110f3, 0x423cc40, 0xf3108f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 
0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf6100f6, 0x403d840, 0xf9100f6, 0x403e440, 0x13b1013b, 0x4060c40, 0x14910183, 0x4052440, 0xf3100f3, 0x405f040, 0x26d1017c, 0x409b440, 0x23e1023e, 0x414b040, 0x1301012c, 0x5b4c045, 0x28319683, 0x45bf04c, 0x1cd21efc, 0x94734c5, 
0xf3108f3, 0x1286cc85, 0x2874adb3, 0x54a1c7c, 0x2024ca02, 0x11a459cb, 0x10f11516, 0x1ff43cd2, 0x17878178, 0x5e5a4a2, 0x11165d69, 0x14f4464b, 0xf3118f3, 0x20b3e0df, 0xf3744f8, 0x5a3cc99, 0xf3544f3, 0xfc3cdc6, 0xf3110f3, 0x13e3cc9f, 0xf3430f3, 0x4b3cc69, 0xf3298f3, 0x763ccc0, 0xf3104f3, 0x663cc53, 0xf3158f3, 0x403cc43, 0xf3104f3, 0x403cc40, 0xf3100f3, 0x403cc40, 
0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf6100f3, 0x403d840, 0xf6100f6, 0x404ac40, 0x13f1012b, 0x404fc40, 0xf4100f4, 0x405d840, 0x20110176, 0x4080440, 
0x12911129, 0x4b56054, 0x2b211558, 0x7eac87e, 0x1dc101dc, 0xdf40c97, 0x29f17103, 0x141a7c7e, 0x29f30a9f, 0x15e40c4c, 0x1dc59d03, 0x11477049, 0x2b27eeb2, 0x95560ad, 0x12988558, 0x434a562, 0x2016ea01, 0x655da08, 0xf440d76, 0xe53d239, 0x13f1b53f, 0x1664add9, 0xf61012b, 0x18d3d92a, 0xf61b8f6, 0x1483cc90, 0xf32a4f3, 0xd03cc48, 0xf32ccf3, 0x703cc43, 0xf3220f3, 0x463cc4c, 
0xf3158f3, 0x403cc47, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 
0xf4100f4, 0x4040840, 0xf310102, 0x403cc40, 0x14310143, 0x4145442, 0x14d12515, 0x4753452, 0x1bd1f1bd, 0xa13f440, 0x265184fd, 0xc399494, 0x13716537, 0x4482934, 0x2575420a, 0xed95ca6, 0x11f5a11f, 0x1fac3463, 0x11f13b0d, 0xf147dd7, 0x25744e57, 0x5c829de, 0x13793a0a, 0x1de4dc5c, 0x26544e65, 0x1d73f4f1, 0x1bd138fd, 0x636f5fa, 0x14d5a14d, 0xa6454ed, 0x14354115, 0x13450c44, 
0xf3164f3, 0x94408c3, 0xf318502, 0x403cca1, 0xf31f0f3, 0x523cc47, 0xf3124f3, 0x403cc41, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 
0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403cc40, 0xf3100f3, 0x403e040, 0x123100f8, 0x4048c40, 0x17a1017a, 0x4074040, 0x1fb101d0, 0x407ec40, 
};


static uint32_t LineSweep_1080_0[] = 
{ //0
0x20010200, 0x4080040, 0x20010600, 0x11b80086, 0x2006c200, 0x1f6801f5, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x1fc7d9fc, 0x1f674df6, 0x1847d9d3, 0x1f6611f6, 0x1207d920, 0x1f62f1f6, 0x6d7c8bc, 0x17d1b5ca, 0x4446c44, 0x6c11cb9, 0x9a11047, 0x4726840, 0x13826138, 0x1f680132, 0x2c8aea00, 0x3a5b2354, 0x366eb366, 0x380ee7a8, 0x3bcccfb9, 0x26fef2d1, 
0x39388b93, 0x1f6d11fa, 0x2e07db44, 0x1f6b81f6, 0x27c7da7c, 0x1f68b5f6, 0x2047da2d, 0x1f6811f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x1fc7d9fc, 0x1f674df6, 0x1847d9d3, 0x1f6611f6, 0x1207d920, 0x1f62f1f6, 0x6d7c8bc, 0x17d1b5ca, 0x4446c44, 0x6c11cb9, 0x9a11047, 0x4726840, 0x13826138, 0x1f680132, 0x2c8aea00, 0x3a5b2354, 0x366eb366, 0x380ee7a8, 0x3bcccfb9, 0x26fef2d1, 0x39388b93, 0x1f6d11fa, 0x2e07db44, 0x1f6b81f6, 0x27c7da7c, 0x1f68b5f6, 0x2047da2d, 0x1f6811f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f67b5f6, 0x1af7d9ed, 0x1f66bdf6, 
0x1537d953, 0x1f63b5f6, 0x917d8ed, 0x1ca245f2, 0x535f453, 0xb91011b, 0x661b040, 0x4019844, 0xe111ce1, 0x13266498, 0x2677d999, 0x35499eba, 0x31fe971f, 0x3a8e6bac, 0x3c0e039a, 0x2d1f0333, 0x3ad9bfad, 0x1fadbe22, 0x3137db6f, 0x1f6c4df6, 0x2ad7daad, 0x1f6945f6, 0x2137da51, 0x1f684df6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f67f1f6, 0x1d37d9fc, 0x1f674df6, 0x1847d984, 0x1f6481f6, 0xbc7d920, 0x1f22f1f6, 0x6d7286d, 0x11b1117d, 0x472e444, 0x4411c6c, 
0x9a1009a, 0x984e047, 0x2004c938, 0x2ba801f6, 0x2c8d52c8, 0x3acd9ba5, 0x3b9ea366, 0x333ee780, 0x3bcb47bc, 0x222e4e6f, 0x3447eb93, 0x1f6d11f6, 0x2e07dae0, 0x1f69f1f6, 0x22d7da7c, 0x1f68b5f6, 0x2047da04, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f67f1f6, 0x1d37d9fc, 0x1f674df6, 0x1847d984, 0x1f6481f6, 0xbc7d920, 0x1f22f1f6, 0x6d7286d, 0x11b1117d, 0x472e444, 0x4411c6c, 0x9a1009a, 0x984e047, 0x2004c938, 0x2ba801f6, 0x2c8d52c8, 0x3acd9ba5, 0x3b9ea366, 0x333ee780, 
0x3bcb47bc, 0x222e4e6f, 0x3447eb93, 0x1f6d11f6, 0x2e07dae0, 0x1f69f1f6, 0x22d7da7c, 0x1f68b5f6, 0x2047da04, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x1ed7d9ed, 0x1f66bdf6, 0x1537d9af, 0x1f654df6, 0xed7d8ed, 0x1f2245f6, 0x5372891, 0x11b14d7d, 0x402e440, 0x441986c, 0xe110066, 0x9838447, 0x1994c999, 0x2ba99df6, 0x31fd5267, 0x3acc7fa5, 
0x39aea39a, 0x333f0380, 0x3adb47c0, 0x222eb66f, 0x36f7eb6f, 0x1f6c4df6, 0x2ad7db13, 0x1f6ab5f6, 0x2517da51, 0x1f684df6, 0x2007da13, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1b0801f5, 0x20046e00, 0x4180086, 0x20010200, 0x4080040, 
};

static uint32_t LineSweep_1080_1[] = 
{ //182
0x20010200, 0x4080040, 0x20010600, 0x11b80086, 0x2006c200, 0x1f6801f5, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x24189a1b, 0x24e99e26, 0x2b093a8c, 0x275b5275, 0x317a76f6, 0x2c4cd69d, 0x369b1350, 0x2ebdfaeb, 0x39ec4390, 0x333e9f10, 0x3abccfab, 0x354e9b54, 0x38cdc79c, 0x38bddf71, 0x33fe2f5d, 0x3a0c6fa0, 0x2c7ec2f3, 0x3bba63b0, 0x232eee66, 
0x3c07f3c0, 0x18fef9c5, 0x3b556bbe, 0xf7ed527, 0x3a532ba5, 0x81e38a3, 0x36f1978e, 0x44dbc51, 0x34a1034a, 0x51c7444, 0x2ea19b1d, 0xaaba884, 0x2b235eb2, 0x1459d50b, 0x23560e75, 0x2078d5c4, 0x1f2929f2, 0x2ca6be8c, 0x16cc11af, 0x3635b337, 0x12ce152c, 0x3aa3c39d, 0xbbeacf0, 0x3882efa0, 0x8dd948d, 0x2ff1a337, 0x4faf868, 0x22c13e77, 0x4277842, 0x14510990, 0x4f40042, 0x8e13cc2, 
0x6a1986a, 0x4024c4c, 0xc911493, 0x7c32459, 0x1092b509, 0x135550ec, 0x1a561554, 0x233695db, 0x1fba21fb, 0x32094ad8, 0x2a7d6e52, 0x3a3a9f87, 0x2f6eb2f6, 0x384cf3a2, 0x376d573c, 0x2c7ddb15, 0x3a19c3a1, 0x1b2eea12, 0x3bf553ba, 0xb5efcff, 0x3b11ebb1, 0x41e3853, 0x35711b8e, 0x92d5c61, 0x30f35f0f, 0x18bae52b, 0x2597cab9, 0x2bb96659, 0x1f2c4df2, 0x38d6335a, 0x12bea18c, 0x3904afa9, 
0xd4d74d4, 0x2b923b14, 0x5c9448e, 0x175171e3, 0x4343c43, 0x75110b8, 0x6013044, 0x5218040, 0x9620496, 0x128390ca, 0x145658e4, 0x27f5160b, 0x1b4ba9b4, 0x3848a343, 0x29be9e28, 0x38aa6fa9, 0x304d2f04, 0x283d6ef1, 0x39a82b5b, 0x11ae698e, 0x3bc2e3bc, 0x47ef06f, 0x39a10fbc, 0xa7e6864, 0x35942359, 0x1ffbed7e, 0x2899fefb, 0x353a26f4, 0x20ae4a0a, 0x39d62bac, 0x112d998a, 0x29944b0d, 
0xae854ae, 0x10f19d8d, 0x4329c67, 0x4110c60, 0x4713847, 0xe41d086, 0xc657874, 0x276319e9, 0x136bd536, 0x39a6ef5a, 0x247eb1bb, 0x34491f8e, 0x2cdb52cd, 0x1b8d024b, 0x3934b340, 0x64e4cb6, 0x3bc107bc, 0x92edc51, 0x3843f7b7, 0x21fe1187, 0x326acb26, 0x385a9b2f, 0x214eaea6, 0x3558539a, 0x17eb897e, 0x1b53da52, 0x8c47cf6, 0x58230a6, 0x4e1004e, 0xbc10863, 0x6d4fc42, 0x27d1b5dc, 
0xcac30ca, 0x3a853b74, 0x1e9e7d4e, 0x2e17a75a, 0x28891e88, 0x106c5da0, 0x38223b17, 0x46e084a, 0x3ba20fba, 0x193edcf7, 0x3788fbb7, 0x35cde2de, 0x304e8b04, 0x3649afa5, 0x1c2baa6b, 0x19870a48, 0x1213dd21, 0x442807f, 0x51140a0, 0x12d144a2, 0x4376843, 0x3261de8d, 0xe9e2c77, 0x3803a7ac, 0x186c4186, 0x1b78de6f, 0x2e042a37, 0x45b8087, 0x36714767, 0x13fed0aa, 0x3b97dfb4, 0x345ee6af, 
0x376e7776, 0x35cbcfa5, 0x246b3ef3, 0x15991a17, 0x18c2e58c, 0x4439456, 0x6f220e5, 0x1ce1bd14, 0x40a4440, 0x39818b35, 0xcfe9c62, 0x2c833f5d, 0x17582175, 0xa48d944, 0x2ed12e36, 0xa9bb44d, 0x37953779, 0x2d8ef215, 0x3aadabbc, 0x38beabaa, 0x343c4b43, 0x18aa7259, 0x1d534a9c, 0x437545c, 0x11523515, 0x1f72152b, 0x42b1085, 0x3aa10b61, 0x5de2c5d, 0x24b3430d, 0x1855d4d0, 0x51614bd, 
0x25612e56, 0x161c50ad, 0x3978eb14, 0x388e5f02, 0x3c0eabc0, 0x2b6e135d, 0x2f077784, 0x73bc10a, 0x22410224, 0x12053c7f, 0xa27e54f, 0x37228ad2, 0x48eb048, 0x2d115771, 0xca7d055, 0x7832918, 0x18b1018b, 0x1299a481, 0x32e82e69, 0x380cbae7, 0x3a9eaba9, 0x2a2ee359, 0x3586ebb8, 0x5ad60e2, 0x29f1269f, 0x17f6ecb5, 0xe99b5bb, 0x3a43a738, 0x60e4060, 0x22111700, 0xa14d045, 0x4028481, 
0x15d2155d, 0x22d91d3c, 0x31ec3647, 0x39ec7b97, 0x3a6c7fa6, 0x14dee242, 0x34d237b8, 0x81d3440, 0x2824ea82, 0x31564631, 0xbfe6d91, 0x3092ff98, 0x4b8804b, 0x7416127, 0xe410858, 0x178390a3, 0x1c69e1c6, 0x3abaef4c, 0x377dcebb, 0x1b8ddeb7, 0x3c033bc0, 0x5fdf44b, 0x2c240f7d, 0x2f6b09fe, 0x1c9e4dc9, 0x30c3839c, 0x5485ce0, 0x6615115, 0x5212452, 0x1bb374ca, 0x1c9b08dd, 0x3a67277e, 
0x2c8cb2c8, 0x132e163d, 0x3bf1c785, 0xbfefc45, 0x3606c760, 0x37ea22bf, 0x180e9688, 0x22a60323, 0xa4470a4, 0x4c10464, 0x7d37841, 0x2ec1f5e1, 0x144e5544, 0x2ec93f95, 0x33e77a4f, 0x4acf8d9, 0x3ba1afba, 0x249e4d30, 0x2d6cff93, 0x35fb5bab, 0x1c89e9c8, 0x8033d5c, 0x4810ccf, 0x1c5120c1, 0x6ab786a, 0x3944a793, 0x23cb7d29, 0xbe8f1c4, 0x33810b38, 0x171ee888, 0x38da5bba, 0x3a5e3774, 
0x2c0c52c0, 0xe769a00, 0xaf129a6, 0x14c2bc71, 0x419d841, 0x3a922f65, 0x171c888b, 0xee5c60e, 0x29312e93, 0x152de072, 0x3bea0778, 0x3a6efb6e, 0x346c3b46, 0xd1909ee, 0x12010e42, 0x1844808a, 0x5fad85f, 0x3951538a, 0x107b4454, 0x9941da0, 0x22910629, 0x1e6ce8c7, 0x3bdc3b3a, 0x363ef7a7, 0x37798f77, 0x5ba152a, 0x15518285, 0x2765553a, 0x73dbc73, 0x2f412ba2, 0xef6f84a, 0x413bca6, 
0x21631616, 0x31bccdee, 0x3bdeab33, 0x235ef74d, 0x3723eb72, 0x839c849, 0x13a62a72, 0x3994eacd, 0x63df063, 0x13e15e85, 0x12017457, 0x14d48063, 0x259a5e59, 0x391d9f86, 0x3beac367, 0x6cef964, 0x33215f32, 0x28182133, 0xd9dfa08, 0x2b936795, 0x435a443, 0x592586c, 0x1a84ec96, 0x3856a28d, 0x2eae3aea, 0x14cec2a0, 0x38d17bb0, 0x165e3468, 0x294aee94, 0x37552b99, 0x629914a, 0x491890f, 
0x5e2385e, 0x304509b4, 0x290ea942, 0x201a433e, 0x38e2fb8e, 0xdaeb040, 0x2d78abac, 0x3a3b5f59, 0x187b6187, 0x6c1ed7a, 0x4f17c7b, 0x2be13d5b, 0x11fe751f, 0x23b9cf66, 0x38438a73, 0xc3e1041, 0x3b084fb0, 0x3a4b6f50, 0x182b5adb, 0x6460970, 0x741a874, 0x2e51597e, 0x13bea056, 0x1f44ef40, 0x2992a699, 0x10ee6845, 0x39d9eb9a, 0x37ee7789, 0x29f97a9f, 0x414f0f4, 0x543113c, 0x36015221, 
0x7be6c7b, 0x134666a8, 0x2fa13199, 0x1e3be898, 0x3bbcf3bb, 0x2d5d77a7, 0x21b57f5d, 0x8386c58, 0xc7704c7, 0x3aa10327, 0xe2ba040, 0x5d38970, 0x2421f642, 0x325dddba, 0x3b0eab77, 0x167ec2e3, 0x2c5162c5, 0x1d054c86, 0x57cdd53, 0x2c615fa6, 0x7f5107f, 0xa16c44c, 0x31b805b1, 0x399c6f59, 0x3c0a3bc0, 0x41ca90b, 0x1c23532a, 0x38270a4e, 0x85de485, 0xc215a38, 0x15911456, 0x2b256527, 
0x2d5e92d5, 0x1c3edf37, 0x35a1e3b7, 0x1a0d6868, 0x1ffc81ff, 0x2c8293a9, 0x4a4e0a4, 0xbf12846, 0x1358f535, 0x376ae380, 0x3b289eb8, 0x4cec8ae, 0x36455764, 0x3ac822e8, 0xa5bde08, 0x4f29564, 0x4b2a04b, 0x37750a23, 0x2ccded42, 0xacb322b, 0x3b813fb8, 0x2fdd3566, 0x1dbeaf4d, 0x13876ed5, 0x8611086, 0x268170d4, 0x181e585c, 0x1cf6074d, 0x30c1cf0c, 0x1d7f0077, 0x30ad53c0, 0x256c2b91, 
0x17b3097b, 0x15c1604a, 0x91bf458, 0x2c3247ab, 0x1f8471f8, 0xfed9840, 0x3aba9766, 0x311eafa7, 0x28b5c28b, 0xbd3d44d, 0x40960f5, 0x34610395, 0x1076d507, 0x94a8862, 0x3b386ea2, 0x366ecf7f, 0x34e79f4e, 0x7c72077, 0x727cdc8, 0x3771cb6d, 0x7681476, 0x7175084, 0x35977dd4, 0x37dd6765, 0x3ae83fae, 0x6fa1488, 0xe578285, 0x37a39767, 0x4281042, 0x784c480, 0x2db7d531, 0x36cb6f74, 
0x3bf793bf, 0x8cc2c6f, 0x16287f0b, 0x35058b88, 0x4a6c44a, 0xb031859, 0x266974c6, 0x32199b9d, 0x3a85aba8, 0xebd7046, 0x1c9aaf5c, 0x2da727ab, 0x6945469, 0x14022c41, 0x211c0c8b, 0x276847a5, 0x3872f387, 0x1b4e1457, 0x20bd6785, 0x1f482f7c, 0x861bc86, 0x2401c096, 0x1e2e6470, 0x16078b23, 0x37210f72, 0x2d7e5509, 0x227eab95, 0xce89e96, 0x9114891, 0x35c1a9af, 0x1dadd46a, 0x61769dc, 
0x3712cb71, 0x3a7e4e74, 0x21bbaf93, 0x4286d16, 0x8759087, 0x3901d72f, 0x1f985875, 0x957e477, 0x38593b85, 0x300dfba1, 0x1e949f7e, 0x15d7a441, 0x6bcb86b, 0x20b25f8e, 0x23f1bc97, 0x26b8fca3, 0x3a5e9fa5, 0xfed32dd, 0x1901234c, 0x35964198, 0x4cdb84c, 0x50375bc, 0x2a9394dd, 0x3aaaa6c7, 0x3be9e3be, 0x70bb8a7, 0x119866ee, 0x31246797, 0x414b841, 0x17355842, 0x327d2156, 0x1c6c9f78, 
0x3b1143b1, 0x2d6960eb, 0x9ce9e58, 0x8c27256, 0x7023070, 0x3a781e57, 0x397b4207, 0x55e5ce2, 0x35977b59, 0x32c64786, 0x4850d91, 0x17412041, 0xf9d3cf9, 0x1a2b6b6b, 0x3bf11ada, 0x311efd1e, 0x29ce4a9c, 0x5b30df7, 0x5d370c3, 0x3a5176d2, 0x1e48f5e4, 0xaee3477, 0x360a6b8d, 0x274d83ac, 0x19025190, 0x26c1188e, 0x10deac46, 0xac4369c, 0x2f91eef9, 0x3a8ee24c, 0x262adbb8, 0x70988be, 
0x948e094, 0x2c220ba6, 0x24431482, 0x2339106c, 0x3b3e9bb3, 0xc3c26c2, 0x1161bf09, 0x3a745a3c, 0x46ad446, 0x79674b7, 0x37194d9d, 0x29adc7aa, 0x37528b75, 0x27768c8b, 0x46eb1a3, 0x8611a71, 0x11b2a51b, 0x3a8c52a8, 0x3ad8e714, 0xd5eb469, 0x21fb8a1f, 0x1f11a79a, 0xc113c69, 0x32230514, 0x2b7deeb7, 0x41efd9c, 0x27f59fbf, 0x3449ff5f, 0x984f498, 0x1ce22c47, 0x26ae448b, 0xdc9aaf2, 
0x3be1abbe, 0x3abb0646, 0xc2a0ac1, 0xb330887, 0x6db146d, 0x1f88d79f, 0x3b613a35, 0x33aed926, 0x2e7d8ae7, 0x4337960, 0x606f8de, 0x2ee1838f, 0x21a3421a, 0x26bec476, 0x2f4eb3b1, 0x65bd248, 0xe63bce6, 0x37b17b11, 0x21b61c5e, 0x1a586c40, 0x3b2e27b2, 0xd1baef5, 0xd91eaeb, 0x3aa36679, 0x678a867, 0x1168d857, 0x3b9ce636, 0x144ee75a, 0x2c912ac9, 0x3a42e9fc, 0x7da6cba, 0xc21f489, 
0x26cbae6c, 0x19cf0389, 0x28c103c0, 0x390a31aa, 0x8db6c8d, 0x992a4b1, 0x2b9aeca9, 0x1c9ae79a, 0x3bb107bb, 0x3848c988, 0x5fbc232, 0x9117cbf, 0xf4accf4, 0x1c8c5b9c, 0x39b10716, 0x38ae6d93, 0x1bab79ba, 0xa4108ad, 0x167b4c42, 0x19959f8e, 0x37310773, 0x39ed39cb, 0x12fa8b4e, 0xda4bc82, 0x4dc584d, 0x14180b66, 0x3b414602, 0x3aced232, 0x2c98d6c9, 0x1432a051, 0x9ada8a8, 0xcd26b0e, 
0x2b623eb6, 0x391ee2c0, 0x20c65bb8, 0x1e883042, 0x4ee9c4e, 0x634e26f, 0x35d46d38, 0x324d7755, 0x35c37b5c, 0x2ba4d087, 0x50e4534, 0x441418f, 0x21b7fa1b, 0x24beefaa, 0x296153bb, 0x375a594a, 0x80bc080, 0xba350a9, 0x30dc14d4, 0x12ec3767, 0x39318393, 0x3a362a73, 0x417198a, 0x1d910440, 0x1d2e9dd2, 0x56eba5c, 0x2c752fae, 0x2dfb1f7a, 0x9825898, 0x32a2f0d7, 0x2fad0cbc, 0x84be8f2, 
0x399b1799, 0x15d63b85, 0x421498e, 0x3a610a58, 0x1e2729e2, 0x1eded440, 0x2a7eafb5, 0x48a9e31, 0x7f6307f, 0x28c39399, 0x32c18ce4, 0x377cb138, 0x375b6375, 0xf34fc8a, 0x54d313f, 0xb715316, 0x2492f649, 0x344f031d, 0x23039fc0, 0x2ee8c095, 0x4dd984d, 0x7857d14, 0x38ab0d5f, 0x13de2b7e, 0x30419704, 0x38e2da9d, 0xac57cb6, 0x27f2b058, 0x2fae62fa, 0x51e3979, 0x1609a78e, 0x18b5839e, 
0x4e1304e, 0x3a190a5b, 0x3c065242, 0x256f004b, 0x21be861b, 0x4b11995, 0x18e96846, 0x18c63ba0, 0x3a413ba4, 0x39cb0a67, 0x7f5eec2, 0x27d1fc53, 0xfae50fa, 0x5dd4d61, 0x340a6f53, 0x140d0388, 0xe11b0e1, 0x37524ec0, 0x2e745c93, 0x2ebb9c83, 0x390d6790, 0xa554cea, 0x58c6553, 0xbb16332, 0x27434e74, 0x2fdedf49, 0x1c3237b7, 0x37470d0f, 0x41ae841, 0x15a82865, 0x3c0e5e0a, 0x49f0267, 
0x2266d226, 0x206113aa, 0x1b010044, 0x3a76c21a, 0x3b5673b5, 0x2879d850, 0x55e2676, 0x7f1552e, 0x169bc969, 0xc8e8349, 0x2b3343a0, 0x2e7acf50, 0x6b1dc6b, 0x3924d942, 0x38b99d36, 0x1cee2c47, 0x2ddeb2dd, 0x461fdd2, 0x1159a07f, 0x13845791, 0x37a1ff7a, 0x33bbdafb, 0x8c2caf6, 0x36e230f1, 0x103abd03, 0x194dc458, 0x300ea771, 0x42c01fc, 0x9094090, 0x13f40796, 0x3711fd01, 0x32fdc702, 
0x2fb286fb, 0x38322d0e, 0x10c9f88b, 0x1d843048, 0x37beaf7b, 0x55ba1a6, 0x7dac6e8, 0xda1f766, 0x12734527, 0x2b9e3760, 0x2c515f8d, 0x3acb15a6, 0x6873068, 0x29a54c4c, 0x3a3dc153, 0xcce8ce4, 0x290d8290, 0x5314ab4, 0x1926dc52, 0x1ad64bac, 0x3b715fb7, 0x35591ec1, 0x432ee47, 0x38210cfd, 0x1e59b9e5, 0x20ff0043, 0x1ebe87c0, 0x847ad4e, 0x42c7442, 0x7292b02, 0x3b45ca4a, 0x1e0ed3a8, 
0x17f1317f, 0x360176a6, 0x2bb3085d, 0x386aecfd, 0x38996789, 0x23843040, 0x9ce490c, 0xb027116, 0x32cd572c, 0x4dcceb3, 0xa178b33, 0x15d287a7, 0x10920d09, 0x2ece2b26, 0x2b01878a, 0x3acac1a8, 0x5563455, 0x3066846d, 0x3bdc2da1, 0x18aef46f, 0x205eb205, 0x65109a3, 0x258be842, 0x7296313, 0x3ab61fab, 0x19e52bac, 0x7e1a54a, 0x3061fb05, 0x30e1a70e, 0x3acd0da0, 0xa55f743, 0x3242947a, 
0x112b8512, 0x1d5e5857, 0x288e9b96, 0x9ea2144, 0x47d4847, 0x457b2a0, 0x3be899ec, 0xf6efb8f, 0x19a3819a, 0x23f17b84, 0x2dc1085e, 0x359b7290, 0x36328763, 0x3a82f547, 0xfd6f8bd, 0x3073f463, 0x391bdb91, 0x1d7a205a, 0x45e8e88, 0xbb11529, 0x204dca04, 0x41eea5d, 0x16da1bba, 0x9c5b75a, 0x7755c77, 0x199c5fab, 0x32a1df17, 0x2bdcab31, 0x8311c83, 0x38556e2d, 0x3b734d5b, 0x3a0edd15, 
0x20775e07, 0x30b1185f, 0x29bb9046, 0x20ba6c4f, 0x380e4380, 0x107350e4, 0xf3e74d4, 0x5f3cddd, 0x394c4394, 0x4b9bada, 0x4088a6e, 0xca10385, 0x2464a646, 0x1a9e8fa7, 0x10e1e3a3, 0x29d43b3d, 0xc2104c2, 0x35ade271, 0x29e23b78, 0x3aba7984, 0x4550845, 0x38088cbc, 0x3ac89223, 0x2eceb04d, 0x11fbd51f, 0x21d2e44f, 0x375e04b9, 0x148dd4bb, 0x29ceae9c, 0xa110d6f, 0x234dc043, 0x498d23d, 
0x3a4b8fa4, 0x4f40ef8, 0xd68a103, 0xa935b79, 0x38e59f8e, 0x14299bac, 0x4031a66, 0x1f71038c, 0x27a17e7a, 0x2a8e0b26, 0xc110382, 0x33630690, 0x1231a123, 0x390ec9e6, 0x1fa32bb2, 0x3ac7e944, 0x5255052, 0x38bbb0bf, 0x32f7c2ec, 0x338cbc66, 0x70a1c70, 0x2c16b441, 0x3bec25ad, 0x237ef84f, 0x15bda15b, 0x1ab27c8a, 0x36de7c9f, 0x12bdb4e7, 0x290eae90, 0xc210159, 0x274e4440, 0x779d1d5, 
0x37cd5f7c, 0x4c2b64e, 0x14ec14ad, 0x4053abb, 0x3bea93be, 0x5169717, 0x7a8f5a5, 0x7a1eb5e, 0x34a75b4a, 0xb4aeb8e, 0x435daba, 0xfb10fa7, 0x25e4865e, 0x149e0bab, 0xad36b82, 0x1992b79f, 0x15728157, 0x1e7eff84, 0x1861dbbf, 0x23161b5f, 0x9116091, 0x274db332, 0x27d11f6c, 0x2af9f702, 0x4110041, 0x2e2abed0, 0x34810aaf, 0x30dd229f, 0x7112471, 0x33072a70, 0x3b4155ca, 0x34ded245, 
0x10718d07, 0x3633ee1e, 0x3b11ccfb, 0x374ec5fb, 0x1d2209d2, 0x3801c1de, 0x34d24070, 0x38ad35c6, 0x29f2769f, 0x390101b4, 0x2a929840, 0x394aa5a6, 0x3432b743, 0x3961a19e, 0x1ed2c468, 0x3977b59a, 0x3a62c7a6, 0x3963559c, 0x13e2b4d5, 0x3934f9a3, 0x3bf29bbf, 0x38e5adae, 0xb42756b, 0x3872d1bf, 0x39724797, 0x37d839d6, 0x5f20a0e, 0x36f17df1, 0x33c1cf3c, 0x35ca9a11, 0x4018ea6, 0x34410237, 
0x2c2156c2, 0x325c8a61, 0x5212722, 0x30014a8f, 0x23d10a3d, 0x2d2deebf, 0x8a1037b, 0x29c22af1, 0x1bb11dbb, 0x25febf22, 0xdb163af, 0x21936f50, 0x1481d548, 0x1cef0378, 0x13a283c0, 0x17f4eb97, 0xea364ea, 0x12fed7a9, 0x19b487b5, 0xe366faa, 0xa35d8a3, 0xa0e5798, 0x1f975b95, 0x6a7e771, 0x728f072, 0x49da732, 0x24ca9369, 0x41932dd, 0x53c1453, 0x56cd674, 0x294d5f35, 0x8ca51fe, 
0x44e4444, 0xe2c0582, 0x2d0eaf01, 0x153b410c, 0x40e7c40, 0x1d8b3ca6, 0x2ffda6cf, 0x265bfc5f, 0x43c2443, 0x2eba8c40, 0x322a22a3, 0x358c8854, 0x4a7c04a, 0x39c9fc9b, 0x33c5567f, 0x3aacf112, 0x5232c52, 0x37998dad, 0x34e1a263, 0x30dd3a58, 0x5810058, 0x270942f7, 0x35817e50, 0x1bad6370, 0x5d3145d, 0x10b91faa, 0x35c59a47, 0x83d7393, 0x5e89c5e, 0x439232b, 0x359b8a48, 0x5cd6681, 
0x5bdc05b, 0xd0949b4, 0x351eae52, 0x18bd44f2, 0x56e0856, 0x26499869, 0x341bda66, 0x326d0441, 0x4e8944e, 0x39ba0c8b, 0x32850e83, 0x39eca139, 0x4623c46, 0x326aa621, 0x307106a9, 0x250c1f00, 0x411dc41, 0x15ab5791, 0x2da4a2d5, 0x92b6ba1, 0x4188441, 0x40c2321, 0x2a2c3f08, 0x87a8a37, 0x49e7449, 0x156cf131, 0x25ce433c, 0x26597071, 0x5fb945f, 0x34ddbc46, 0x20b7636f, 0x3ac82cc8, 
0x8634c86, 0x354e69ca, 0x1af11f9a, 0x2616bee3, 0xc11dcc1, 0x13bee397, 0x14e55bb8, 0x6853b8c, 0x113a1113, 0x51efec0, 0xeedc7bf, 0x10c3b98d, 0x17be8d7b, 0x241ea88c, 0x99bdfaa, 0x35226445, 0x1f6701f6, 0x3a9dc8e6, 0x5b28b72, 0x30d16e21, 0x27b10a7b, 0x1cec5347, 0x4037b14, 0xa3103aa, 0x2fd892fd, 0x43a5307, 0x54d4694, 0xf3151b8, 0x36be9b6b, 0x24c7e48d, 0x9eb89f9, 0x3702784c, 
0x3b15ffb1, 0x39655929, 0x11e1a556, 0x29a47a96, 0x3bc1a3bc, 0x12731395, 0x1c7614c4, 0x4871f69, 0x381be781, 0xaa17a28, 0x283eb05e, 0x20ca0cbe, 0x2fec36fe, 0x36010444, 0x32f63c41, 0x393cbd25, 0x24318643, 0x2711f6b3, 0x3a32087d, 0xe4e8fa6, 0x17178171, 0x4144b28, 0x3bcd5112, 0x11fef19d, 0xb8e4cb8, 0x2c079c5f, 0x36796de7, 0x3aad9c93, 0x4c30c4c, 0x2fbb2e14, 0x2ad12ecb, 0x14fab77b, 
0x555c055, 0x44df769, 0x1b9c6f7d, 0xea6e5e5, 0xe0e84e0, 0x2a4f0070, 0xd39c3c0, 0x3aa34c8d, 0x1cd2f1cd, 0x2e2dbe28, 0x4c15b6f, 0x11913390, 0x2d46d6d4, 0x41a6738, 0x61d7e99, 0x15518577, 0x393dc793, 0x32360445, 0x11873981, 0x39446108, 0x3b715fb7, 0x218256e6, 0x23634095, 0x718dba5, 0x320abf20, 0xa810654, 0x344eac41, 0x282d108c, 0x203a0203, 0x3ac2e48e, 0x3bf288b9, 0x29eefe61, 
0xdc1f8dc, 0xb175baa, 0x35e935d6, 0x77d7aae, 0x43ea443, 0x247c3cb7, 0x240ac70f, 0x3a990077, 0x982d098, 0x2a6eea4f, 0x108217ba, 0xd042390, 0x1c993dc9, 0x11bb6e62, 0x151b46db, 0x2215456a, 0x23683636, 0x21180dcd, 0x2007ba03, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1b0801f5, 0x20046e00, 0x4180086, 0x20010200, 0x4080040, 
};

static uint32_t LineSweep_1080_2[] = 
{ //902
0x20010200, 0x4080040, 0x20010600, 0x11b80086, 0x2006c200, 0x1f6801f5, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x1fc7d9fc, 0x1f674df6, 0x1847d9d3, 0x1f6611f6, 0x1207d920, 0x1f62f1f6, 0x6d7c8bc, 0x17d1b5ca, 0x4446c44, 0x6c11cb9, 0x9a11047, 0x4726840, 0x13826138, 0x1f680132, 0x2c8aea00, 0x3a5b2354, 0x366eb366, 0x380ee7a8, 0x3bcccfb9, 0x26fef2d1, 
0x39388b93, 0x1f6d11fa, 0x2e07db44, 0x1f6b81f6, 0x27c7da7c, 0x1f68b5f6, 0x2047da2d, 0x1f6811f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x1fc7d9fc, 0x1f674df6, 0x1847d9d3, 0x1f6611f6, 0x1207d920, 0x1f62f1f6, 0x6d7c8bc, 0x17d1b5ca, 0x4446c44, 0x6c11cb9, 0x9a11047, 0x4726840, 0x13826138, 0x1f680132, 0x2c8aea00, 0x3a5b2354, 0x366eb366, 0x380ee7a8, 0x3bcccfb9, 0x26fef2d1, 0x39388b93, 0x1f6d11fa, 0x2e07db44, 0x1f6b81f6, 0x27c7da7c, 0x1f68b5f6, 0x2047da2d, 0x1f6811f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f67b5f6, 0x1af7d9ed, 0x1f66bdf6, 
0x1537d953, 0x1f63b5f6, 0x917d8ed, 0x1ca245f2, 0x535f453, 0xb91011b, 0x661b040, 0x4019844, 0xe111ce1, 0x13266498, 0x2677d999, 0x35499eba, 0x31fe971f, 0x3a8e6bac, 0x3c0e039a, 0x2d1f0333, 0x3ad9bfad, 0x1fadbe22, 0x3137db6f, 0x1f6c4df6, 0x2ad7daad, 0x1f6945f6, 0x2137da51, 0x1f684df6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f67f1f6, 0x1d37d9fc, 0x1f674df6, 0x1847d984, 0x1f6481f6, 0xbc7d920, 0x1f22f1f6, 0x6d7286d, 0x11b1117d, 0x472e444, 0x4411c6c, 
0x9a1009a, 0x984e047, 0x2004c938, 0x2ba801f6, 0x2c8d52c8, 0x3acd9ba5, 0x3b9ea366, 0x333ee780, 0x3bcb47bc, 0x222e4e6f, 0x3447eb93, 0x1f6d11f6, 0x2e07dae0, 0x1f69f1f6, 0x22d7da7c, 0x1f68b5f6, 0x2047da04, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f67f1f6, 0x1d37d9fc, 0x1f674df6, 0x1847d984, 0x1f6481f6, 0xbc7d920, 0x1f22f1f6, 0x6d7286d, 0x11b1117d, 0x472e444, 0x4411c6c, 0x9a1009a, 0x984e047, 0x2004c938, 0x2ba801f6, 0x2c8d52c8, 0x3acd9ba5, 0x3b9ea366, 0x333ee780, 
0x3bcb47bc, 0x222e4e6f, 0x3447eb93, 0x1f6d11f6, 0x2e07dae0, 0x1f69f1f6, 0x22d7da7c, 0x1f68b5f6, 0x2047da04, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x1ed7d9ed, 0x1f66bdf6, 0x1537d9af, 0x1f654df6, 0xed7d8ed, 0x1f2245f6, 0x5372891, 0x11b14d7d, 0x402e440, 0x441986c, 0xe110066, 0x9838447, 0x1994c999, 0x2ba99df6, 0x31fd5267, 0x3acc7fa5, 
0x39aea39a, 0x333f0380, 0x3adb47c0, 0x222eb66f, 0x36f7eb6f, 0x1f6c4df6, 0x2ad7db13, 0x1f6ab5f6, 0x2517da51, 0x1f684df6, 0x2007da13, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1b0801f5, 0x20046e00, 0x4180086, 0x20010200, 0x4080040, 
};

static uint32_t LineSweep_720_0[] = 
{ //0
0x20010200, 0x4080040, 0x20010600, 0x11b80086, 0x2006c200, 0x1f6801f5, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f67b5f6, 0x1af7d9ed, 0x1f66bdf6, 0x1537d953, 0x1f63b5f6, 0x917d8ed, 0x1ca245f2, 0x535f453, 0xb91011b, 0x661b040, 0x4019844, 0xe111ce1, 0x13266498, 0x2677d999, 0x35499eba, 
0x31fe971f, 0x3a8e6bac, 0x3c0e039a, 0x2d1f0333, 0x3ad9bfad, 0x1fadbe22, 0x3137db6f, 0x1f6c4df6, 0x2ad7daad, 0x1f6945f6, 0x2137da51, 0x1f684df6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x1fc7d9fc, 0x1f674df6, 0x1847d9d3, 0x1f6611f6, 0x1207d920, 0x1f62f1f6, 0x6d7c8bc, 0x17d1b5ca, 0x4446c44, 0x6c11cb9, 0x9a11047, 0x4726840, 0x13826138, 0x1f680132, 0x2c8aea00, 0x3a5b2354, 0x366eb366, 0x380ee7a8, 0x3bcccfb9, 0x26fef2d1, 0x39388b93, 0x1f6d11fa, 0x2e07db44, 0x1f6b81f6, 0x27c7da7c, 0x1f68b5f6, 0x2047da2d, 0x1f6811f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x1fc7da00, 0x1f67f1f6, 0x1d37d9d3, 0x1f6611f6, 0x1207d984, 0x1f6481f6, 0xbc7d8bc, 0x1ca1b5f2, 0x445f46d, 0xb91111b, 0x471b047, 0x4026844, 0x13811c9a, 0x1324e098, 0x2007da00, 0x354b22ba, 0x366e96c8, 0x3a8d9bac, 
0x3b9e03b9, 0x2d1ef333, 0x3939bfbc, 0x1fae4e22, 0x3447db44, 0x1f6b81f6, 0x27c7dae0, 0x1f69f1f6, 0x22d7da2d, 0x1f6811f6, 0x2007da04, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f67f1f6, 0x1d37d9fc, 0x1f674df6, 
0x1847d984, 0x1f6481f6, 0xbc7d920, 0x1f22f1f6, 0x6d7286d, 0x11b1117d, 0x472e444, 0x4411c6c, 0x9a1009a, 0x984e047, 0x2004c938, 0x2ba801f6, 0x2c8d52c8, 0x3acd9ba5, 0x3b9ea366, 0x333ee780, 0x3bcb47bc, 0x222e4e6f, 0x3447eb93, 0x1f6d11f6, 0x2e07dae0, 0x1f69f1f6, 0x22d7da7c, 0x1f68b5f6, 0x2047da04, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f67b5f6, 0x1af7d9ed, 0x1f66bdf6, 0x1537d953, 0x1f63b5f6, 0x917d8ed, 0x1ca245f2, 0x535f453, 0xb91011b, 0x661b040, 0x4019844, 0xe111ce1, 0x13266498, 0x2677d999, 0x35499eba, 0x31fe971f, 0x3a8e6bac, 0x3c0e039a, 0x2d1f0333, 
0x3ad9bfad, 0x1fadbe22, 0x3137db6f, 0x1f6c4df6, 0x2ad7daad, 0x1f6945f6, 0x2137da51, 0x1f684df6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x1ed7da00, 0x1f67b5f6, 0x1af7d9af, 0x1f654df6, 0xed7d953, 0x1f63b5f6, 0x917c891, 0x17d14dca, 0x4046c53, 0x6c100b9, 0x6611066, 0x4738440, 0x199260e1, 0x1f666532, 0x267aea67, 0x3a5c7f54, 0x39aeb31f, 0x380e6ba8, 0x3c0ccfc0, 0x26feb6d1, 0x36f88bad, 0x1f6dbdfa, 0x3137db13, 0x1f6ab5f6, 0x2517daad, 0x1f6945f6, 0x2137da13, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007d600, 0x11b801b0, 0x20021a00, 0x4080041, 0x20010200, 0x3ffffc40, 0x0, 0x2749d000, 0x2009b26c, 0x18b90200, 0xbcd67, 0x40ffc40, 0x2e7103ff, 0x407a440, 0x15210218, 0x4080040, 
};

static uint32_t LineSweep_720_1[] = 
{ //121
0x20010200, 0x4080040, 0x20010600, 0x11b80086, 0x2006c200, 0x1f6801f5, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x24289e1b, 0x24f9a227, 0x2b493e8e, 0x278b6678, 0x31ea8afc, 0x2cccf6a2, 0x372b3359, 0x2f5e1ef5, 0x3a4c7798, 0x343eaf1d, 0x3a7d0fac, 0x365e7365, 0x372e0f8a, 0x39dd5383, 0x306e7730, 0x3b0b5fb0, 0x26bef2a3, 0x3c08c7bc, 0x1b6f01f4, 
0x3bb5e7bb, 0x106eb53e, 0x39534bad, 0x7ee54a4, 0x37318373, 0x41d1c4b, 0x31210b47, 0x66c484e, 0x2d322ad3, 0xefa38b8, 0x2424be8e, 0x1c290976, 0x1f3841f3, 0x2aa68a5e, 0x153bc1a2, 0x36254f2e, 0x108e2908, 0x3ac317a3, 0x8de94c5, 0x3642378c, 0x62cb062, 0x296122e6, 0x408fc48, 0x187101e3, 0x4c4c04c, 0x9e1b4e0, 0xa21ac6d, 0x402884b, 0xe912ce9, 0xa25006c, 0x1a23ad40, 0x1a568943, 
0x20c8360c, 0x2d59da74, 0x2dbca676, 0x399b6f6c, 0x335eaf35, 0x37fdf3a3, 0x3acd0b7c, 0x289eb2ee, 0x3c0867c0, 0x138ed5a6, 0x38b35bb5, 0x55e2c89, 0x34310343, 0x78b884c, 0x26e30ae2, 0x1999b925, 0x1f0855f0, 0x2fe5c690, 0xfdd5d71, 0x3ac3f793, 0x9ee789e, 0x3161736b, 0x41a985c, 0x1a010626, 0x4e4844e, 0x6a218b6, 0xe310c86, 0x7838c48, 0x15e33d5e, 0x1ce7b145, 0x27d971ec, 0x34c9f6e0, 
0x302e4b02, 0x395db3ac, 0x3aed3b6c, 0x256ebae0, 0x3bf703bf, 0xb6e6d2f, 0x34418f9b, 0x54d1041, 0x2c5276c5, 0x1a38a911, 0x1899062a, 0x34e626d6, 0xf6e64f6, 0x382217ab, 0x48c8885, 0x1f512297, 0x4854c48, 0x67220c7, 0xff10088, 0xb33fc5b, 0x19f4f19f, 0x28d939e3, 0x2f4c864e, 0x3acbd386, 0x374e3374, 0x295ee32a, 0x3b5797b8, 0xa9ed538, 0x36714f67, 0x80b7043, 0x2283f6dc, 0x2618a1a8, 
0x16cc1d6c, 0x3ac3277d, 0x5ee28c9, 0x27817b1d, 0x416e441, 0x801e506, 0xfe10879, 0xc33f85a, 0x1b85a9b8, 0x2e7a062e, 0x331dc281, 0x38bcc7ab, 0x3a4c5ba4, 0x198ef663, 0x377387bd, 0x41ddc65, 0x2de1f6de, 0x1d28490d, 0x141a8212, 0x3a350748, 0x9ae6c9a, 0x27b11730, 0x5a69845, 0x62168e3, 0xd4108d4, 0x1326648e, 0x27982199, 0x3739e6da, 0x33ceb33c, 0x2daebf75, 0x3b3813af, 0x84ecd29, 
0x34310343, 0x10d9f072, 0x1927a27c, 0x36e64ac7, 0xc4eb0c4, 0x2c913b70, 0x537944e, 0x6b14d06, 0xd3108d3, 0x1576b499, 0x2a1911ad, 0x39ba871b, 0x365e6f65, 0x241efb1b, 0x38e53fbe, 0x40e3890, 0x2e01eee0, 0x2227a92e, 0xf9c21ea, 0x39d3e796, 0x5dc645d, 0x13a12e34, 0xcb1f84b, 0x9732c41, 0x1b5595b5, 0x341aea66, 0x380ea6ba, 0x2c0e0379, 0x3bf6ffbf, 0x4bd7cd1, 0x27f1835f, 0x2089fd08, 
0x16fc096f, 0x39525399, 0x40bd494, 0xf3101f4, 0x9615496, 0xf95e056, 0x2907f978, 0x39ba4301, 0x371e3f71, 0x1d2f02df, 0x35a34bc0, 0x6dd6848, 0x2664d266, 0x34051e4b, 0x74ead47, 0x27a1d35f, 0x4757047, 0x4335c80, 0x1e930cd7, 0x2e27a5c8, 0x305e5705, 0x2d6ec391, 0x39a6dbb0, 0x41e68b2, 0x2ca256ca, 0x2b36758c, 0x9ce119d, 0x2ef2739c, 0x4173041, 0x412e0bd, 0x1ce258b8, 0x2c273994, 
0x2fce3afc, 0x2ceec793, 0x391677b1, 0x41e4499, 0x2a9312a9, 0x30a5a9e2, 0x77e996a, 0x2681df66, 0x4c4bc4c, 0x5f4145c, 0x2424e105, 0x37090a75, 0x35de8b5d, 0x1b6efeef, 0x32f27fbf, 0xd3cbc42, 0x1f9811f9, 0x3ac3172e, 0x40cd8c5, 0xd61020c, 0xb7104b7, 0x1c97a4a5, 0x32ac1de9, 0x34fcaba9, 0x3bf8b3bf, 0x43d3ce9, 0x21927b4f, 0x30a865c5, 0xd3ea8d3, 0x21410344, 0xbe34440, 0xbb2f840, 
0x2017e601, 0x3abd1735, 0x3bfc4745, 0x97efdc5, 0x32011f20, 0x26272109, 0x93dddc8, 0x2a524f94, 0x4a5104a, 0x7947c56, 0x28965d1f, 0x3a9a26f5, 0x399cef99, 0xace61f3, 0x28211398, 0x268a0903, 0x112e0112, 0x27b11789, 0xab44045, 0xa92ac45, 0x2017de01, 0x3a6d5f45, 0x3b9b4f57, 0x5aee561, 0x2df1f2df, 0x317589b0, 0x57eb162, 0x18f15eff, 0x851a885, 0x1937346b, 0x33cc15cd, 0x308cf3ac, 
0x3bd653bd, 0x6fbac6a, 0x164682eb, 0x3ab59314, 0x54bbc54, 0x5924970, 0x1f021c92, 0x3407c1d7, 0x35ce8f5c, 0x126ecaaf, 0x2ab117b2, 0x239aacc1, 0x118de918, 0x24010b7f, 0xdb31042, 0x12d36c45, 0x269afa69, 0x325e83a7, 0x37868ba0, 0x7ede066, 0x21075a10, 0x39a2674b, 0x589fc99, 0x41160ed, 0x18744987, 0x3a6c8aac, 0x3bdc8f22, 0x5def595, 0x2cd24acd, 0x36d49206, 0x41e0524, 0xa910630, 
0xf4148f4, 0x316a757b, 0x3b6e9e9d, 0x103edaa7, 0x33810338, 0x2c065917, 0x56ead96, 0x15015af8, 0xab118ab, 0x27d918d8, 0x39fe8246, 0x187e7f28, 0x36614766, 0x25573cb6, 0x67e5dcf, 0x1a019f3e, 0x9416094, 0x24a8acac, 0x399e562b, 0x19be673e, 0x36915369, 0x25f728b6, 0x61e71ca, 0x17818728, 0xa4128a4, 0x290940d8, 0x3aaea250, 0x139eaaf9, 0x34410344, 0x2db61d17, 0x4aead87, 0xe612aa8, 
0xe3120e3, 0x333ac17a, 0x3bfe4eb0, 0x8eefe31, 0x2e51d6e5, 0x38443a05, 0x43d2d0e, 0x4c10d96, 0x16837968, 0x3acce6aa, 0x3a9aff39, 0x49ea4ee, 0x23663636, 0x38121749, 0x877c885, 0xaa21c67, 0x23e9be3e, 0x2e5eb7a7, 0x32542fad, 0x17dc9444, 0x143d1543, 0x1e510380, 0x15417c40, 0x295550bf, 0x337eb337, 0xd3e8eb1, 0x21115fa3, 0x37b845d4, 0x6ad146a, 0x422d972, 0x29b4b4b6, 0x396a6f12, 
0x3c084fc0, 0xb3ad06b, 0xc5a4ab4, 0x29b317ac, 0x642e064, 0x2168406a, 0x3a8e6610, 0x111ea302, 0x31d1231d, 0x371481ac, 0x46d2120, 0x4011965, 0x1af56daf, 0x373e0f42, 0x3566ab83, 0x122d5846, 0x160c6960, 0x1db1038b, 0x17c14040, 0x2fd5f0ff, 0x36be5b6b, 0x57db1f8, 0x1793bf6c, 0x3995e6f1, 0x407f840, 0xf15cc58, 0x36bbd973, 0x1efdaf96, 0x36714b67, 0x30c5a504, 0x41e2d69, 0x48105ca, 
0x1954ad95, 0x373e0f31, 0x34464783, 0x169d1041, 0x130d7930, 0x14512b48, 0x1e41144a, 0x38b791bf, 0x3a8c0ba8, 0x60be8ee, 0xd98b6fa, 0x29b367a8, 0x7025c70, 0x2ac97ca1, 0x3c0e965f, 0x55f0213, 0x27a4427a, 0x36e1eb2a, 0xcf5cc7a, 0x1b033c41, 0x2f9e2ef9, 0xd4e8ef5, 0x1c21dba3, 0x3ab70a6e, 0x418f041, 0x1025f45f, 0x388c997d, 0x161e236a, 0x32611326, 0x39d3c1db, 0x6daecf0, 0xaa1b49d, 
0x272b3a72, 0x1bceff95, 0x236107bf, 0x3848d98c, 0x55bc455, 0x8d4bcc2, 0x362aa92f, 0x1d5d8b9f, 0x34b10b4b, 0x38443984, 0x64bb10e, 0x9a190b8, 0x26db166d, 0x1a8efb94, 0x21c103be, 0x39c871c0, 0x4aaa44a, 0xd959084, 0x38ac5d64, 0x13ae2b64, 0x30815708, 0x3ac2f242, 0xa386cbc, 0x16528c4a, 0x2ecdfaec, 0xa8e5ae7, 0x1742db96, 0x3725d2fa, 0x4952049, 0x24a8ac54, 0x3c0eaa2b, 0x43f01fd, 
0x23165e31, 0x2a512796, 0x17c1dc49, 0x3495f100, 0x39fca79f, 0x93b30d9, 0x83b66cc, 0x15120f7e, 0xf8154f8, 0x3a6d5a5c, 0x33973756, 0x1e4ce440, 0xd4ea8d4, 0x4b2863f, 0x3025eca1, 0x29fc0b93, 0x37b1af7b, 0x36c49524, 0x70bad25, 0xe21c096, 0x2b9cfeb9, 0xc4e7f24, 0x1652cf9f, 0x34b59713, 0x573b457, 0x2eca1092, 0x3afd9a84, 0x7debd10, 0x18db3d8d, 0x12713776, 0x2691c84d, 0x37e9a6bd, 
0x3b44d3b4, 0x2b766c6d, 0x4cdfd9b, 0x6e13134, 0x269af669, 0x127ecf7a, 0x18d1dfb3, 0x36e636cf, 0x5143c51, 0x2eda1087, 0x3a9d6a84, 0xa1ea4ed, 0x164c4d64, 0xc318739, 0x2b932461, 0x309ae740, 0x39025790, 0x36d49102, 0x85b1924, 0x14e2146b, 0x303e4f03, 0x4bd7a70, 0xd46bf5e, 0x206353aa, 0xc8100c8, 0x3a6d5a21, 0x30763b56, 0x29dc1c55, 0x82df482, 0x944d512, 0x39fc5535, 0xa2e7f27, 
0x28340a83, 0x2a312776, 0x1d115449, 0x3a97459a, 0x3c07efc0, 0x24d75042, 0x4ae61d4, 0x7c12945, 0x28dbf28d, 0xa6e5b34, 0x11341f96, 0x28444f80, 0xa4124a4, 0x3abd15d4, 0x30769b45, 0x2b5c1c56, 0x75d8875, 0xdc598d2, 0x3b7da966, 0x4fedea5, 0x21a7121a, 0x1a410bac, 0x26f16842, 0x3509bec9, 0x39b2d79b, 0x38643104, 0xb69910c, 0x21c2d842, 0x363e7763, 0x8fb3d3e, 0x54cb6cf, 0x66152ed, 
0x1cc645cc, 0x1b7effac, 0x18b163bf, 0x33f62ed2, 0x6e2686e, 0x39ec4936, 0x32383312, 0x291c8c45, 0x77d9c77, 0x106600c2, 0x3bfe3d80, 0x41efe36, 0x1bf9d1bf, 0xcf17b73, 0x2fc3f05e, 0x237bf38d, 0x32f10b2f, 0x36a1e67f, 0x1892f879, 0x39962516, 0x3c0833c0, 0x2b267848, 0x71d1d9e, 0x1571c493, 0x32aea72a, 0x63bddb8, 0x57c12f7, 0x5f15efd, 0x1e8719e8, 0x13eedba6, 0x12d2a7b6, 0x27c4b762, 
0xbe100be, 0x36fe1662, 0x2672db85, 0x3a599d32, 0x4170c41, 0x312a6c64, 0x364b869b, 0x205d9050, 0x93e4c93, 0xf75dcef, 0x3c0e5d77, 0x55f01f6, 0x175be175, 0x5425ef6, 0x36e7f497, 0xe8dbb93, 0x28041a80, 0x1d31039e, 0x2a419440, 0x2c2a9320, 0x35311753, 0x36e1ea4b, 0x1b42907a, 0x3ac6d163, 0x3b9573b9, 0x375470aa, 0xe68dd1c, 0x2e33984a, 0x3a9beba9, 0x21f7ac50, 0x66df9eb, 0x15a198b2, 
0x33eeb33e, 0xbaac151, 0x40e16b0, 0x5910209, 0x2a0c6aa0, 0x41d1eb6, 0x68a0f47, 0x6c1a33e, 0x1f477df4, 0xcce8792, 0xc5513a1, 0x14d317ac, 0x15931d59, 0x1dbf0391, 0x13e1c7c0, 0x2644fb4c, 0xdf118df, 0x2dcebeea, 0x1bc10faf, 0x33a6f279, 0x8b18c8b, 0x37cdfa06, 0x23026f7e, 0x3a18c198, 0x5939459, 0x3accf538, 0x2924df3d, 0x3a2a48e8, 0x4362c43, 0x389bdca9, 0x2df76ef7, 0x365b7c7b, 
0x4189441, 0x33bad85d, 0x31899ab6, 0x310c604b, 0x49a7449, 0x2e5a0042, 0x33fb2a80, 0x2becfc40, 0x54bb854, 0x29c95c43, 0x358c2a57, 0x280d6047, 0x5fc7c5f, 0x26b8f44c, 0x365cb63d, 0x25ed9451, 0x65cd465, 0x2588c853, 0x368cde32, 0x259da053, 0x65cd065, 0x2628e051, 0x362cb238, 0x273d884e, 0x5ec785e, 0x28a93449, 0x351c264d, 0x2a9d4444, 0x54bb454, 0x2cd9c840, 0x333b2272, 0x2f6ccc41, 
0x48a6848, 0x321a9047, 0x30698aa4, 0x34cc1857, 0x4188441, 0x374b8c72, 0x2c675ee3, 0x394b189b, 0x4461844, 0x3a8ca0d5, 0x2714cb28, 0x3aa9c520, 0x5a3805a, 0x396dad7c, 0x2082636b, 0x366821e6, 0x8c1808c, 0x319e8e59, 0x18f10fa3, 0x2b063ecc, 0xe211ce2, 0x230eff33, 0x1101d7bf, 0x1a344382, 0x15d3355d, 0x118ec3a9, 0x9f537b0, 0xa127f9f, 0x1f97a1f9, 0x54da75b, 0x52a3769, 0x4214ae0, 
0x2a4c86a4, 0x77b923b, 0x44e26e4, 0xf211183, 0x342eb342, 0x1a48a8d9, 0x8ade62a, 0x26e22863, 0x3abbc7ab, 0x32556441, 0x1298a959, 0x3984a486, 0x3b8543b8, 0x3a228d29, 0x20a26ca3, 0x33782a0a, 0x34e10f4e, 0x269112eb, 0x2f61ac44, 0x172bdb88, 0x27944a79, 0xa01b3a5, 0x39d8306c, 0x41e772e, 0x16ec116e, 0x8349e42, 0x3b4e7127, 0x159ed132, 0x8ee388e, 0x2759086c, 0x318b4e42, 0x360c604b, 
0x416c441, 0x3aad30ea, 0x1f52ab4c, 0x3227d60c, 0xc5100c5, 0x200f0329, 0xcb2d7c0, 0xd332fab, 0x1f1765f1, 0x41d2341, 0x40c4f48, 0xaa10217, 0x331eaf31, 0x1de834d5, 0xbecea0d, 0x3262f840, 0x3c07e3c0, 0x3ac2f8c5, 0x2122bcbe, 0x30984a19, 0x32711327, 0x1a110b5a, 0x36443c42, 0x72d939d, 0x1b4a25b4, 0x6843aa1, 0x3b1e5d0e, 0x199ec51c, 0x71d6871, 0x31ba8043, 0x29e7d2a0, 0x3a9a78d5, 
0x7423074, 0x2baed264, 0xfa187b4, 0x1163eb95, 0x1d96a9d9, 0x40d0348, 0x41cff40, 0x110105b6, 0x36be5b6b, 0x2c86445f, 0x14192991, 0x3ac504a4, 0x39528f95, 0x2c11364d, 0x30f1904d, 0xf6c3f9c, 0x20c77e0c, 0x4738318, 0x3b7de0e0, 0x188edd47, 0x6ed446e, 0x34fb1040, 0x25a62ac4, 0x3749694a, 0xae110ae, 0x1baeff2b, 0x88487bf, 0x4b22386, 0x29cc529c, 0x10d9f1d5, 0x9ee367c, 0x3072784f, 
0x3a4777a4, 0x33b35d29, 0x25f324d7, 0x1e197ea4, 0x22d6862d, 0x19f6ee6a, 0x21b871bb, 0x1f286df1, 0x1ff7ddff, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007d600, 0x11b801b0, 0x20021a00, 0x4080041, 0x20010200, 0x3ffffc40, 0x0, 0x2749d000, 0x20494250, 0x26372e04, 0xb396d, 0x40ffc40, 0x2e7103ff, 0x40a0440, 0x1f810218, 0x4080c40, 
};

static uint32_t LineSweep_720_2[] = 
{ //601
0x20010200, 0x4080040, 0x20010600, 0x11b80086, 0x2006c200, 0x1f6801f5, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f67b5f6, 0x1af7d9ed, 0x1f66bdf6, 0x1537d953, 0x1f63b5f6, 0x917d8ed, 0x1ca245f2, 0x535f453, 0xb91011b, 0x661b040, 0x4019844, 0xe111ce1, 0x13266498, 0x2677d999, 0x35499eba, 
0x31fe971f, 0x3a8e6bac, 0x3c0e039a, 0x2d1f0333, 0x3ad9bfad, 0x1fadbe22, 0x3137db6f, 0x1f6c4df6, 0x2ad7daad, 0x1f6945f6, 0x2137da51, 0x1f684df6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x1fc7d9fc, 0x1f674df6, 0x1847d9d3, 0x1f6611f6, 0x1207d920, 0x1f62f1f6, 0x6d7c8bc, 0x17d1b5ca, 0x4446c44, 0x6c11cb9, 0x9a11047, 0x4726840, 0x13826138, 0x1f680132, 0x2c8aea00, 0x3a5b2354, 0x366eb366, 0x380ee7a8, 0x3bcccfb9, 0x26fef2d1, 0x39388b93, 0x1f6d11fa, 0x2e07db44, 0x1f6b81f6, 0x27c7da7c, 0x1f68b5f6, 0x2047da2d, 0x1f6811f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x1fc7da00, 0x1f67f1f6, 0x1d37d9d3, 0x1f6611f6, 0x1207d984, 0x1f6481f6, 0xbc7d8bc, 0x1ca1b5f2, 0x445f46d, 0xb91111b, 0x471b047, 0x4026844, 0x13811c9a, 0x1324e098, 0x2007da00, 0x354b22ba, 0x366e96c8, 0x3a8d9bac, 
0x3b9e03b9, 0x2d1ef333, 0x3939bfbc, 0x1fae4e22, 0x3447db44, 0x1f6b81f6, 0x27c7dae0, 0x1f69f1f6, 0x22d7da2d, 0x1f6811f6, 0x2007da04, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f67f1f6, 0x1d37d9fc, 0x1f674df6, 
0x1847d984, 0x1f6481f6, 0xbc7d920, 0x1f22f1f6, 0x6d7286d, 0x11b1117d, 0x472e444, 0x4411c6c, 0x9a1009a, 0x984e047, 0x2004c938, 0x2ba801f6, 0x2c8d52c8, 0x3acd9ba5, 0x3b9ea366, 0x333ee780, 0x3bcb47bc, 0x222e4e6f, 0x3447eb93, 0x1f6d11f6, 0x2e07dae0, 0x1f69f1f6, 0x22d7da7c, 0x1f68b5f6, 0x2047da04, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f67b5f6, 0x1af7d9ed, 0x1f66bdf6, 0x1537d953, 0x1f63b5f6, 0x917d8ed, 0x1ca245f2, 0x535f453, 0xb91011b, 0x661b040, 0x4019844, 0xe111ce1, 0x13266498, 0x2677d999, 0x35499eba, 0x31fe971f, 0x3a8e6bac, 0x3c0e039a, 0x2d1f0333, 
0x3ad9bfad, 0x1fadbe22, 0x3137db6f, 0x1f6c4df6, 0x2ad7daad, 0x1f6945f6, 0x2137da51, 0x1f684df6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x1ed7da00, 0x1f67b5f6, 0x1af7d9af, 0x1f654df6, 0xed7d953, 0x1f63b5f6, 0x917c891, 0x17d14dca, 0x4046c53, 0x6c100b9, 0x6611066, 0x4738440, 0x199260e1, 0x1f666532, 0x267aea67, 0x3a5c7f54, 0x39aeb31f, 0x380e6ba8, 0x3c0ccfc0, 0x26feb6d1, 0x36f88bad, 0x1f6dbdfa, 0x3137db13, 0x1f6ab5f6, 0x2517daad, 0x1f6945f6, 0x2137da13, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007d600, 0x11b801b0, 0x20021a00, 0x4080041, 0x20010200, 0x3ffffc40, 0x0, 0x2749d000, 0x210741d0, 0x1ed89a10, 0x7ca66, 0x4000040, 0x3ff103ff, 0x4079840, 0x21810203, 0x409e040, 
};


static uint32_t LineSweep_486_0[] = 
{ //0
0x20010200, 0x4080040, 0x20012200, 0x11b8008e, 0x2006a200, 0x1f6801ee, 0x2007da00, 0x1f6801f6, 0x2027e602, 0x21f85604, 0x25493615, 0x2da9528e, 0x2b5ca2b5, 0x395c4369, 0x34bea710, 0x39ed2faa, 0x378e1778, 0x331e7361, 0x3b5bdb9c, 0x266ed6b2, 0x3c0853c0, 0x16cee9c0, 0x3a3473ba, 0x96e8cd4, 0x37919f79, 0x40cf04a, 0x2ed12f3c, 0xa3bb46d, 0x28f3b28f, 0x1aa89d46, 0x1b985627, 0x2e36e680, 
0x14cce54c, 0x3a23a37a, 0x95eace8, 0x36125796, 0x5bc405b, 0x22f106a7, 0x4b6c041, 0xcc12d36, 0x7c1e87c, 0x423484a, 0x14718cd2, 0x11851cad, 0x1d1671d1, 0x2b49922a, 0x2eecae64, 0x3a9bbb81, 0x360e8360, 0x2f8eab63, 0x3c09b3aa, 0x137f01d0, 0x39b2db9b, 0x40cf85f, 0x2b117b3e, 0x140ac4b8, 0x20879a08, 0x32256e8f, 0xc5e1d5b, 0x38a317ac, 0x60c9060, 0x1d410289, 0x6f49040, 0x4a1bc97, 
0xe912ce9, 0x1316649d, 0x2607b599, 0x349982ad, 0x316e8316, 0x346e5ba0, 0x3c0a8f96, 0x114f01d9, 0x38720787, 0x66bd041, 0x2253aaf4, 0x285895ae, 0x14aced4a, 0x39b26ba1, 0x44ca49a, 0x18511267, 0x6230462, 0x503c44f, 0x1ce320f1, 0x28073995, 0x2bcd12bc, 0x389ddba7, 0x3c0bcb76, 0x11ef020c, 0x3801cf80, 0x9db1442, 0x1c75a6c5, 0x33d71e65, 0xd9ea0d9, 0x2cd13f7f, 0x5b73c4f, 0x4f16cdd, 
0xff16cff, 0x1fe810fd, 0x30abf204, 0x394c2b98, 0x3acbbbac, 0xe2e99e5, 0x2f6137a6, 0x121bd864, 0x1de8e1de, 0x3aa34b34, 0x46d94d2, 0x15c11a7f, 0x7b1f07b, 0xd258045, 0x29179960, 0x3a2a4702, 0x380de380, 0x165eea96, 0x31c1ebba, 0xedc7049, 0x1ef85def, 0x3ac32332, 0x41d10c8, 0xf81062d, 0xa4124a4, 0x18271080, 0x307b11c4, 0x381c1f96, 0x3b9a37b9, 0x5edc943, 0x25419372, 0x2a695156, 
0x102e3d02, 0x28711b84, 0x984c446, 0x7826053, 0x1ca635ca, 0x3a6c82e5, 0x3c0d4b20, 0xccf021c, 0x33b1033b, 0x22e78cd6, 0x9dd85e3, 0x2b72779d, 0x4952849, 0x844a054, 0x2a26e928, 0x3aca8b1d, 0x3a9bf7a9, 0x6ade98d, 0x2311b37a, 0x30a8c597, 0xc1eb0c1, 0x184112fe, 0x12118444, 0x1c24847c, 0x2b0ccab0, 0x2bced3a6, 0x3554c3b4, 0xc0d5446, 0x1dc8f5dc, 0x3761ff7f, 0x688987f, 0x4e1a0ab, 
0x1b3585b3, 0x3acd0af7, 0x3b5b7342, 0x45ed53e, 0x29e3529e, 0x3993d66d, 0x41d08f5, 0x64105b5, 0x13023930, 0x378b9a0e, 0x3c0dbee6, 0x7ef01f8, 0x2e51d6e5, 0x36a499e9, 0x40de126, 0x7e10200, 0x1201ed20, 0x37aba1fe, 0x3c0d8ae8, 0x62f01cd, 0x2c028ec0, 0x39b3ca4e, 0x47c88f2, 0x4311d63, 0x17e4097e, 0x3abd1acf, 0x3a3a7b46, 0x51e8cd3, 0x2246be24, 0x36f1ef5f, 0x947247b, 0xcc25057, 
0x259a8659, 0x2acedbac, 0x305347b6, 0x1d5c1457, 0x116df116, 0x16f11744, 0x19a10445, 0x31b66935, 0x370e4370, 0x60dcdfc, 0x19933773, 0x3aa666ba, 0x4398443, 0x944d48c, 0x3349c935, 0x29bcd3ab, 0x3982b398, 0x24e74c7b, 0x4bea5d3, 0xb512eae, 0x11e1e51e, 0x3aacba51, 0x394a732e, 0x8ce50a2, 0x1ba9f5ba, 0x26210fac, 0x1521ec43, 0x2cb548bd, 0x361e7f61, 0x50d95fd, 0x15246b65, 0x36b54b2f, 
0x455c445, 0x1af76c41, 0x3abe29db, 0xd3eaef5, 0x2e31dee3, 0x3ab2de74, 0x938b8b7, 0x11824c58, 0x2b7cf6b7, 0x134ed353, 0x1ec143b4, 0x3aa7b21e, 0x4499c44, 0xff5f068, 0x391ccd7c, 0x127e4753, 0x30316703, 0x3ac2f24a, 0xa187cbc, 0x15a2844c, 0x2e6de2e6, 0xb3e6af5, 0x17d2ab9a, 0x37a5f6eb, 0x4855448, 0x24189c50, 0x3c0eae27, 0x42f01fd, 0x22b68e2b, 0x28c11f9c, 0x19319c47, 0x36964d26, 
0x3aabdbaa, 0xd0a84a2, 0x67caea1, 0xdf19f3b, 0x13926539, 0x364e2af2, 0x2e04478a, 0x2c9b807b, 0x80de480, 0x6e4512f, 0x37cad914, 0x137df380, 0x2ed1b6ed, 0x37b20aba, 0x11d4a082, 0x2d547478, 0x388da788, 0x93b3102, 0x69c0ecc, 0xcc1a744, 0x15731157, 0x304ea33f, 0x277237a8, 0x37c9dd15, 0x49a8449, 0x18b72457, 0x3c0e99c9, 0x40f0218, 0x1e8891e8, 0x173117a3, 0x27319045, 0x3589cecf, 
0x3a1333a1, 0x3644acda, 0x94ad92b, 0x1a425057, 0x335eaf35, 0x4cc55cd, 0x7aa7315, 0xdc1eb6d, 0x16436164, 0x298ee36c, 0x207127b8, 0x3a781de9, 0x4659c46, 0x313a707a, 0x37ec169c, 0x182df86f, 0xcdeaccd, 0x5c405b5, 0x39fb9501, 0x80e7f28, 0x2485b248, 0x1b6107aa, 0x28a18041, 0x30fa2af7, 0x37b1af7b, 0x3ab2e5a2, 0x12d5a4b9, 0x3424b48b, 0x3b5abfb5, 0x22a79446, 0x5ae25e5, 0x103168df, 
0x30be670b, 0x54c25f4, 0x57bcb09, 0x5815efe, 0x1fc7bdfc, 0xf4eab98, 0xf33ebaa, 0x1de3cf9b, 0x10718907, 0x2c3ecf1d, 0x1cf113b3, 0x36573e55, 0x7125071, 0x3aad3583, 0x29d4b74d, 0x394a74d6, 0x4078440, 0x339ad069, 0x334a2eb4, 0x2b7cd041, 0x5cc4c5c, 0x22986853, 0x38edbe1a, 0x1a3e3890, 0xa0e80a0, 0x133664e5, 0x3b6eb199, 0xdced942, 0xede78ed, 0x9d4f19c, 0x3c0e093c, 0x74f01ec, 
0x130d7930, 0x5b4022d, 0x3bdcf100, 0x4eef65f, 0x15dc7d5d, 0x4738682, 0x3b8c30e1, 0x44ee296, 0x16fc096f, 0x4436a9c, 0x3b8c14da, 0x46ee295, 0x165c4d65, 0x4c3aa7f, 0x3bdcacea, 0x57ef65b, 0x13fd293f, 0x6d44e28, 0x3c0db913, 0x92f01e5, 0x102e3d02, 0xca56d95, 0x3b5e9d5b, 0x11bed53a, 0xb6ea8b6, 0x186718dd, 0x38be41c6, 0x207e2c89, 0x6dd386d, 0x29594850, 0x32fb7a52, 0x31ccbc42, 
0x4291842, 0x383bc470, 0x295652f1, 0x3aca54e4, 0x5939859, 0x37edf595, 0x1c519f7d, 0x2f271669, 0xd1108d1, 0x219f032c, 0xea253c0, 0x1293aba1, 0x1af569af, 0x72e0390, 0x5398780, 0x4514eea, 0x2c1d2ec1, 0xcaa95d9, 0x60eb2a5, 0x1de180ca, 0x397d0b97, 0x3095ac42, 0x13b8a56b, 0x3a94ec9d, 0x3a83a7a8, 0x34c1b1c2, 0x29b1086c, 0x211a6f12, 0x2b32d6b3, 0xba193ac, 0x3a683c64, 0x44e9b0d, 
0x12fd7d2f, 0x12564591, 0x373e4991, 0x2bcdcc5f, 0x4398443, 0x3aacb48f, 0x1f231b2d, 0x2fa7ca12, 0xec134ec, 0x13eed781, 0x6f62bb5, 0x401bf55, 0x2bcd0ebc, 0x1309a1a0, 0xa3e0a68, 0x31128c4a, 0x3c077fc0, 0x39424d01, 0x28b15093, 0x1f6a2ef8, 0x28a3d68a, 0x5425f96, 0x3c0c0097, 0x10af01e4, 0x8be288b, 0x327aa049, 0x25c6a6a8, 0x36797146, 0xc1100c1, 0x14ae9b61, 0xbc6b7a6, 0x502f31c, 
0x27ce6a7c, 0x2417e8d4, 0x1fca61fa, 0x3aa7f099, 0x2001a200, 0x1d6802ef, 0x2004da00, 0x4180361, 0x200e0a00, 0x226800f8, 0x200a7e00, 0x3a5800a0, 0x20015a00, 0x17d80325, 0x20067a00, 0x658030a, 0x200eae00, 0x2e68007b, 0x20070a00, 0x2ef80174, 0x20039200, 0x178802d0, 0x20089600, 0x1f3801f0, 0x2007de00, 0x1f6801f6, 0x2007da00, 0x1a8801ee, 0x20046e00, 0x488008e, 0x20010200, 0x4080040, 
};

static uint32_t LineSweep_486_1[] = 
{ //341
0x20010200, 0x4080040, 0x20012200, 0x11b8008e, 0x2006a200, 0x1f6801ee, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f67b1f6, 0x1a87d9ec, 0x1f66a1f6, 0x14b7d94b, 0x1f641df6, 0xf37d907, 0x1f63cdf6, 0xf37d8f3, 0x1c7399f1, 0xb95cce6, 0xf42e51e, 0x7a3bc7a, 0xec134ef, 0x403404d, 0x5f10098, 0x4110c41, 0x4020840, 0x16414082, 0x1f6590dc, 0x29cc429c, 0x3acdfb9c, 0x3bfeb37e, 0x38deffa9, 
0x3c0d53c0, 0x300ecf1c, 0x386bf7b3, 0x2f8e1afd, 0x347b3b47, 0x225c6a79, 0x30d7ef1a, 0x1f6c35f6, 0x30d7db0d, 0x1f6be5f6, 0x2b57daf9, 0x1f6ad5f6, 0x2587da58, 0x1f6851f6, 0x2007da14, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x1fb7da00, 0x1f67edf6, 0x1d07d9d0, 0x1f65e9f6, 0x1237d97a, 0x1f648df6, 0xf87d8f8, 0x1f63cdf6, 0xf07d8f3, 0x1c73c1f1, 0xd35ccd3, 0xf42691e, 0x603bc9a, 0xec180ef, 
0x4334043, 0x5f10098, 0x5010c40, 0x4014040, 0xdf140df, 0x1f6800dc, 0x321c4200, 0x3acc879c, 0x3b0eb3b0, 0x38df03a9, 0x3bdd53c0, 0x300ef71c, 0x3a0bf7a0, 0x2f8d9afd, 0x32db3b66, 0x225cb679, 0x3107ef10, 0x1f6c35f6, 0x3087db0d, 0x1f6c21f6, 0x2dd7dadd, 0x1f6a19f6, 0x2307da86, 0x1f68c1f6, 0x2057da05, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x1ec7da00, 0x1f67b1f6, 0x1a87d9a8, 0x1f652df6, 0x1077d94b, 0x1f641df6, 0xf37d8f3, 0x1f63cdf6, 0xe67c4f3, 0x173399c7, 0xb9478b9, 0xef1e8f4, 0x4d3bc7a, 0xd0134ec, 0x4026040, 0x431045f, 0x8210041, 0x5020840, 0x16437164, 0x310a71f6, 0x37ee729c, 0x3acdfbac, 0x3bfea7bf, 0x354f038d, 0x3b3c73c0, 0x2fdecf00, 
0x386bf786, 0x2ced1ef8, 0x31a9e747, 0x1fbc6a25, 0x30d7db0d, 0x1f6c35f6, 0x2f97db0d, 0x1f6be5f6, 0x2b57dab5, 0x1f6961f6, 0x2147da58, 0x1f6851f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f67edf6, 0x1d07d9fb, 0x1f6741f6, 0x17a7d97a, 0x1f648df6, 0xf87d923, 0x1f63e1f6, 
0xf37d8f3, 0x1f13c1f6, 0xd371cf0, 0x11e34d73, 0x9a3d09a, 0xef180ef, 0x433b060, 0x9810cd0, 0x4017c40, 0x4014043, 0xdf10050, 0xdc37c50, 0x2007da00, 0x39cc8710, 0x3b0eb321, 0x3a9ec3ac, 0x3c0e37c0, 0x31cef754, 0x3a0c03bd, 0x2fde82fd, 0x366be366, 0x279cb6ce, 0x3108972d, 0x1f6c41fb, 0x30d7db0d, 0x1f6c21f6, 0x2dd7db08, 0x1f6b75f6, 0x2867da86, 0x1f68c1f6, 0x2057da30, 0x1f6815f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x1fb7d9fb, 0x1f6741f6, 0x17a7d9d0, 0x1f65e9f6, 0x1237d923, 0x1f63e1f6, 0xf37d8f8, 0x1f63cdf6, 0xf07c4f0, 0x17334dc7, 0x9a478d3, 0xef268f4, 0x603bc60, 0xd010cec, 0x4026043, 0x431005f, 0x5010050, 0x5037c40, 0x200370df, 0x310801f6, 
0x321e7321, 0x3acec3ac, 0x3c0ea7b0, 0x354f038d, 0x3bdc73bd, 0x2fde8300, 0x366bf7a0, 0x2ced9af8, 0x32d9e72d, 0x1fbc4225, 0x30d7db10, 0x1f6c35f6, 0x3087db08, 0x1f6b75f6, 0x2867dadd, 0x1f6a19f6, 0x2307da30, 0x1f6815f6, 0x2007da05, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x1ec7d9ec, 0x1f66a1f6, 0x14b7d9a8, 0x1f652df6, 0x1077d907, 0x1f63cdf6, 0xf37d8f3, 0x1f13cdf6, 0xe671ce6, 0x11e2e573, 0x7a3d0b9, 0xef1e8ef, 0x4d3b04d, 0x98100d0, 0x4117c40, 0x4010443, 0x8210082, 0xdc59050, 0x29c7d964, 0x39ca7310, 0x37eeb37e, 0x3a9effac, 0x3c0e37bf, 0x31cf0354, 0x3b3c03b3, 0x2fde1afd, 0x347be386, 0x279d1ece, 0x31a8971a, 0x1f6c35fb, 0x30d7db0d, 0x1f6c35f6, 
0x2f97daf9, 0x1f6ad5f6, 0x2587dab5, 0x1f6961f6, 0x2147da14, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1a8801ee, 0x20046e00, 0x488008e, 0x20010200, 0x4080040, 
};

static uint32_t LineSweep_576_0[] = 
{ //0
0x20010200, 0x4080040, 0x20012200, 0x11b8008e, 0x2006a200, 0x1f6801ee, 0x2007da00, 0x1f6801f6, 0x2027e602, 0x21f85604, 0x25493615, 0x2da9528e, 0x2b5ca2b5, 0x395c4369, 0x34bea710, 0x39ed2faa, 0x378e1778, 0x331e7361, 0x3b5bdb9c, 0x266ed6b2, 0x3c0853c0, 0x16cee9c0, 0x3a3473ba, 0x96e8cd4, 0x37919f79, 0x40cf04a, 0x2ed12f3c, 0xa3bb46d, 0x28f3b28f, 0x1aa89d46, 0x1b985627, 0x2e36e680, 
0x14cce54c, 0x3a23a37a, 0x95eace8, 0x36125796, 0x5bc405b, 0x22f106a7, 0x4b6c041, 0xcc12d36, 0x7c1e87c, 0x423484a, 0x14718cd2, 0x11851cad, 0x1d1671d1, 0x2b49922a, 0x2eecae64, 0x3a9bbb81, 0x360e8360, 0x2f8eab63, 0x3c09b3aa, 0x137f01d0, 0x39b2db9b, 0x40cf85f, 0x2b117b3e, 0x140ac4b8, 0x20879a08, 0x32256e8f, 0xc5e1d5b, 0x38a317ac, 0x60c9060, 0x1d410289, 0x6f49040, 0x4a1bc97, 
0xe912ce9, 0x1316649d, 0x2607b599, 0x349982ad, 0x316e8316, 0x346e5ba0, 0x3c0a8f96, 0x114f01d9, 0x38720787, 0x66bd041, 0x2253aaf4, 0x285895ae, 0x14aced4a, 0x39b26ba1, 0x44ca49a, 0x18511267, 0x6230462, 0x503c44f, 0x1ce320f1, 0x28073995, 0x2bcd12bc, 0x389ddba7, 0x3c0bcb76, 0x11ef020c, 0x3801cf80, 0x9db1442, 0x1c75a6c5, 0x33d71e65, 0xd9ea0d9, 0x2cd13f7f, 0x5b73c4f, 0x4f16cdd, 
0xff16cff, 0x1fe810fd, 0x30abf204, 0x394c2b98, 0x3acbbbac, 0xe2e99e5, 0x2f6137a6, 0x121bd864, 0x1de8e1de, 0x3aa34b34, 0x46d94d2, 0x15c11a7f, 0x7b1f07b, 0xd258045, 0x29179960, 0x3a2a4702, 0x380de380, 0x165eea96, 0x31c1ebba, 0xedc7049, 0x1ef85def, 0x3ac32332, 0x41d10c8, 0xf81062d, 0xa4124a4, 0x18271080, 0x307b11c4, 0x381c1f96, 0x3b9a37b9, 0x5edc943, 0x25419372, 0x2a695156, 
0x102e3d02, 0x28711b84, 0x984c446, 0x7826053, 0x1ca635ca, 0x3a6c82e5, 0x3c0d4b20, 0xccf021c, 0x33b1033b, 0x22e78cd6, 0x9dd85e3, 0x2b72779d, 0x4952849, 0x844a054, 0x2a26e928, 0x3aca8b1d, 0x3a9bf7a9, 0x6ade98d, 0x2311b37a, 0x30a8c597, 0xc1eb0c1, 0x184112fe, 0x12118444, 0x1c24847c, 0x2b0ccab0, 0x2bced3a6, 0x3554c3b4, 0xc0d5446, 0x1dc8f5dc, 0x3761ff7f, 0x688987f, 0x4e1a0ab, 
0x1b3585b3, 0x3acd0af7, 0x3b5b7342, 0x45ed53e, 0x29e3529e, 0x3993d66d, 0x41d08f5, 0x64105b5, 0x13023930, 0x378b9a0e, 0x3c0dbee6, 0x7ef01f8, 0x2e51d6e5, 0x36a499e9, 0x40de126, 0x7e10200, 0x1201ed20, 0x37aba1fe, 0x3c0d8ae8, 0x62f01cd, 0x2c028ec0, 0x39b3ca4e, 0x47c88f2, 0x4311d63, 0x17e4097e, 0x3abd1acf, 0x3a3a7b46, 0x51e8cd3, 0x2246be24, 0x36f1ef5f, 0x947247b, 0xcc25057, 
0x259a8659, 0x2acedbac, 0x305347b6, 0x1d5c1457, 0x116df116, 0x16f11744, 0x19a10445, 0x31b66935, 0x370e4370, 0x60dcdfc, 0x19933773, 0x3aa666ba, 0x4398443, 0x944d48c, 0x3349c935, 0x29bcd3ab, 0x3982b398, 0x24e74c7b, 0x4bea5d3, 0xb512eae, 0x11e1e51e, 0x3aacba51, 0x394a732e, 0x8ce50a2, 0x1ba9f5ba, 0x26210fac, 0x1521ec43, 0x2cb548bd, 0x361e7f61, 0x50d95fd, 0x15246b65, 0x36b54b2f, 
0x455c445, 0x1af76c41, 0x3abe29db, 0xd3eaef5, 0x2e31dee3, 0x3ab2de74, 0x938b8b7, 0x11824c58, 0x2b7cf6b7, 0x134ed353, 0x1ec143b4, 0x3aa7b21e, 0x4499c44, 0xff5f068, 0x391ccd7c, 0x127e4753, 0x30316703, 0x3ac2f24a, 0xa187cbc, 0x15a2844c, 0x2e6de2e6, 0xb3e6af5, 0x17d2ab9a, 0x37a5f6eb, 0x4855448, 0x24189c50, 0x3c0eae27, 0x42f01fd, 0x22b68e2b, 0x28c11f9c, 0x19319c47, 0x36964d26, 
0x3aabdbaa, 0xd0a84a2, 0x67caea1, 0xdf19f3b, 0x13926539, 0x364e2af2, 0x2e04478a, 0x2c9b807b, 0x80de480, 0x6e4512f, 0x37cad914, 0x137df380, 0x2ed1b6ed, 0x37b20aba, 0x11d4a082, 0x2d547478, 0x388da788, 0x93b3102, 0x69c0ecc, 0xcc1a744, 0x15731157, 0x304ea33f, 0x277237a8, 0x37c9dd15, 0x49a8449, 0x18b72457, 0x3c0e99c9, 0x40f0218, 0x1e8891e8, 0x173117a3, 0x27319045, 0x3589cecf, 
0x3a1333a1, 0x3644acda, 0x94ad92b, 0x1a425057, 0x335eaf35, 0x4cc55cd, 0x7aa7315, 0xdc1eb6d, 0x16436164, 0x298ee36c, 0x207127b8, 0x3a781de9, 0x4659c46, 0x313a707a, 0x37ec169c, 0x182df86f, 0xcdeaccd, 0x5c405b5, 0x39fb9501, 0x80e7f28, 0x2485b248, 0x1b6107aa, 0x28a18041, 0x30fa2af7, 0x37b1af7b, 0x3ab2e5a2, 0x12d5a4b9, 0x3424b48b, 0x3b5abfb5, 0x22a79446, 0x5ae25e5, 0x103168df, 
0x30be670b, 0x54c25f4, 0x57bcb09, 0x5815efe, 0x1fc7bdfc, 0xf4eab98, 0xf33ebaa, 0x1de3cf9b, 0x10718907, 0x2c3ecf1d, 0x1cf113b3, 0x36573e55, 0x7125071, 0x3aad3583, 0x29d4b74d, 0x394a74d6, 0x4078440, 0x339ad069, 0x334a2eb4, 0x2b7cd041, 0x5cc4c5c, 0x22986853, 0x38edbe1a, 0x1a3e3890, 0xa0e80a0, 0x133664e5, 0x3b6eb199, 0xdced942, 0xede78ed, 0x9d4f19c, 0x3c0e093c, 0x74f01ec, 
0x130d7930, 0x5b4022d, 0x3bdcf100, 0x4eef65f, 0x15dc7d5d, 0x4738682, 0x3b8c30e1, 0x44ee296, 0x16fc096f, 0x4436a9c, 0x3b8c14da, 0x46ee295, 0x165c4d65, 0x4c3aa7f, 0x3bdcacea, 0x57ef65b, 0x13fd293f, 0x6d44e28, 0x3c0db913, 0x92f01e5, 0x102e3d02, 0xca56d95, 0x3b5e9d5b, 0x11bed53a, 0xb6ea8b6, 0x186718dd, 0x38be41c6, 0x207e2c89, 0x6dd386d, 0x29594850, 0x32fb7a52, 0x31ccbc42, 
0x4291842, 0x383bc470, 0x295652f1, 0x3aca54e4, 0x5939859, 0x37edf595, 0x1c519f7d, 0x2f271669, 0xd1108d1, 0x219f032c, 0xea253c0, 0x1293aba1, 0x1af569af, 0x72e0390, 0x5398780, 0x4514eea, 0x2c1d2ec1, 0xcaa95d9, 0x60eb2a5, 0x1de180ca, 0x397d0b97, 0x3095ac42, 0x13b8a56b, 0x3a94ec9d, 0x3a83a7a8, 0x34c1b1c2, 0x29b1086c, 0x211a6f12, 0x2b32d6b3, 0xba193ac, 0x3a683c64, 0x44e9b0d, 
0x12fd7d2f, 0x12564591, 0x373e4991, 0x2bcdcc5f, 0x4398443, 0x3aacb48f, 0x1f231b2d, 0x2fa7ca12, 0xec134ec, 0x13eed781, 0x6f62bb5, 0x401bf55, 0x2bcd0ebc, 0x1309a1a0, 0xa3e0a68, 0x31128c4a, 0x3c077fc0, 0x39424d01, 0x28b15093, 0x1f6a2ef8, 0x28a3d68a, 0x5425f96, 0x3c0c0097, 0x10af01e4, 0x8be288b, 0x327aa049, 0x25c6a6a8, 0x36797146, 0xc1100c1, 0x14ae9b61, 0xbc6b7a6, 0x502f31c, 
0x27ce6a7c, 0x2417e8d4, 0x1fca61fa, 0x3aa7f099, 0x2001a200, 0x1d6802ef, 0x2004da00, 0x4180361, 0x200e0a00, 0x226800f8, 0x200a7e00, 0x3a5800a0, 0x20015a00, 0x17d80325, 0x20067a00, 0x658030a, 0x200eae00, 0x2e68007b, 0x20070a00, 0x2ef80174, 0x20039200, 0x178802d0, 0x20089600, 0x1f3801f0, 0x2007de00, 0x1f6801f6, 0x2007da00, 0x1a8801ee, 0x20046e00, 0x488008e, 0x20010200, 0x4080040, 
};

static uint32_t LineSweep_576_1[] = 
{ //404
0x20010200, 0x4080040, 0x20012200, 0x11b8008e, 0x2006a200, 0x1f6801ee, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f67b1f6, 0x1a87d9ec, 0x1f66a1f6, 0x14b7d94b, 0x1f641df6, 0xf37d907, 0x1f63cdf6, 0xf37d8f3, 0x1c7399f1, 0xb95cce6, 0xf42e51e, 0x7a3bc7a, 0xec134ef, 0x403404d, 0x5f10098, 0x4110c41, 0x4020840, 0x16414082, 0x1f6590dc, 0x29cc429c, 0x3acdfb9c, 0x3bfeb37e, 0x38deffa9, 
0x3c0d53c0, 0x300ecf1c, 0x386bf7b3, 0x2f8e1afd, 0x347b3b47, 0x225c6a79, 0x30d7ef1a, 0x1f6c35f6, 0x30d7db0d, 0x1f6be5f6, 0x2b57daf9, 0x1f6ad5f6, 0x2587da58, 0x1f6851f6, 0x2007da14, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x1fb7da00, 0x1f67edf6, 0x1d07d9d0, 0x1f65e9f6, 0x1237d97a, 0x1f648df6, 0xf87d8f8, 0x1f63cdf6, 0xf07d8f3, 0x1c73c1f1, 0xd35ccd3, 0xf42691e, 0x603bc9a, 0xec180ef, 
0x4334043, 0x5f10098, 0x5010c40, 0x4014040, 0xdf140df, 0x1f6800dc, 0x321c4200, 0x3acc879c, 0x3b0eb3b0, 0x38df03a9, 0x3bdd53c0, 0x300ef71c, 0x3a0bf7a0, 0x2f8d9afd, 0x32db3b66, 0x225cb679, 0x3107ef10, 0x1f6c35f6, 0x3087db0d, 0x1f6c21f6, 0x2dd7dadd, 0x1f6a19f6, 0x2307da86, 0x1f68c1f6, 0x2057da05, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x1ec7da00, 0x1f67b1f6, 0x1a87d9a8, 0x1f652df6, 0x1077d94b, 0x1f641df6, 0xf37d8f3, 0x1f63cdf6, 0xe67c4f3, 0x173399c7, 0xb9478b9, 0xef1e8f4, 0x4d3bc7a, 0xd0134ec, 0x4026040, 0x431045f, 0x8210041, 0x5020840, 0x16437164, 0x310a71f6, 0x37ee729c, 0x3acdfbac, 0x3bfea7bf, 0x354f038d, 0x3b3c73c0, 0x2fdecf00, 
0x386bf786, 0x2ced1ef8, 0x31a9e747, 0x1fbc6a25, 0x30d7db0d, 0x1f6c35f6, 0x2f97db0d, 0x1f6be5f6, 0x2b57dab5, 0x1f6961f6, 0x2147da58, 0x1f6851f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f67edf6, 0x1d07d9fb, 0x1f6741f6, 0x17a7d97a, 0x1f648df6, 0xf87d923, 0x1f63e1f6, 
0xf37d8f3, 0x1f13c1f6, 0xd371cf0, 0x11e34d73, 0x9a3d09a, 0xef180ef, 0x433b060, 0x9810cd0, 0x4017c40, 0x4014043, 0xdf10050, 0xdc37c50, 0x2007da00, 0x39cc8710, 0x3b0eb321, 0x3a9ec3ac, 0x3c0e37c0, 0x31cef754, 0x3a0c03bd, 0x2fde82fd, 0x366be366, 0x279cb6ce, 0x3108972d, 0x1f6c41fb, 0x30d7db0d, 0x1f6c21f6, 0x2dd7db08, 0x1f6b75f6, 0x2867da86, 0x1f68c1f6, 0x2057da30, 0x1f6815f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x1fb7d9fb, 0x1f6741f6, 0x17a7d9d0, 0x1f65e9f6, 0x1237d923, 0x1f63e1f6, 0xf37d8f8, 0x1f63cdf6, 0xf07c4f0, 0x17334dc7, 0x9a478d3, 0xef268f4, 0x603bc60, 0xd010cec, 0x4026043, 0x431005f, 0x5010050, 0x5037c40, 0x200370df, 0x310801f6, 
0x321e7321, 0x3acec3ac, 0x3c0ea7b0, 0x354f038d, 0x3bdc73bd, 0x2fde8300, 0x366bf7a0, 0x2ced9af8, 0x32d9e72d, 0x1fbc4225, 0x30d7db10, 0x1f6c35f6, 0x3087db08, 0x1f6b75f6, 0x2867dadd, 0x1f6a19f6, 0x2307da30, 0x1f6815f6, 0x2007da05, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x1ec7d9ec, 0x1f66a1f6, 0x14b7d9a8, 0x1f652df6, 0x1077d907, 0x1f63cdf6, 0xf37d8f3, 0x1f13cdf6, 0xe671ce6, 0x11e2e573, 0x7a3d0b9, 0xef1e8ef, 0x4d3b04d, 0x98100d0, 0x4117c40, 0x4010443, 0x8210082, 0xdc59050, 0x29c7d964, 0x39ca7310, 0x37eeb37e, 0x3a9effac, 0x3c0e37bf, 0x31cf0354, 0x3b3c03b3, 0x2fde1afd, 0x347be386, 0x279d1ece, 0x31a8971a, 0x1f6c35fb, 0x30d7db0d, 0x1f6c35f6, 
0x2f97daf9, 0x1f6ad5f6, 0x2587dab5, 0x1f6961f6, 0x2147da14, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1a8801ee, 0x20046e00, 0x488008e, 0x20010200, 0x4080040, 
};



static uint32_t Pathological_1080_0[] = 
{ //0
0x30064300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
};

static uint32_t Pathological_1080_1[] = 
{ //1
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
};

static uint32_t Pathological_1080_2[] = 
{ //2
0x30064300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
};

static uint32_t Pathological_1080_3[] = 
{ //3
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
};

static uint32_t Pathological_1080_4[] = 
{ //543
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
};

static uint32_t Pathological_720_0[] = 
{ //0
0x30064300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x3ffffd98, 0x0, 0x2749d000, 0x2009b26c, 0x2996e600, 0x20045685, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 
};

static uint32_t Pathological_720_1[] = 
{ //2
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x3ffffd98, 0x0, 0x2749d000, 0x2009d274, 0x2c66fe00, 0x20063a2a, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 
};

static uint32_t Pathological_720_2[] = 
{ //361
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x3ffffd10, 0x0, 0x2749d000, 0x20c84210, 0x12ba160c, 0x2005ee43, 0x4080040, 0x20010200, 0x4080040, 0x20010200, 0x4080040, 
};

static uint32_t Pathological_486_0[] = 
{ //0
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
};

static uint32_t Pathological_486_1[] = 
{ //243
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
};

static uint32_t Pathological_576_0[] = 
{ //0
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 0x30066300, 0x198c0198, 
};

static uint32_t Pathological_576_1[] = 
{ //288
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 0x20044200, 0x11080110, 
};



static uint32_t FlatField_1080_0[] = 
{ //0
0x20010200, 0x4080040, 0x20010600, 0x11b80086, 0x2006c200, 0x1f6801f5, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1b0801f5, 0x20046e00, 0x4180086, 0x20010200, 0x4080040, 
};


static uint32_t FlatField_720_0[] = 
{ //0
0x20010200, 0x4080040, 0x20010600, 0x11b80086, 0x2006c200, 0x1f6801f5, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007d600, 0x11b801b0, 0x20021a00, 0x4080041, 0x20010200, 0x3ffffc40, 0x0, 0x2749d000, 0x2009b26c, 0x18f4ee00, 0x8aa54, 0x40ffc40, 0x2e7103ff, 0x4074c40, 0x25a10218, 0x4041040, 
};

static uint32_t FlatField_486_0[] = 
{ //0
0x20010200, 0x4080040, 0x20012200, 0x11f80090, 0x2006be00, 0x1ff801f7, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 
0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 
0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 
0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 
0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 
0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 
0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 
0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 
0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 
0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 
0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 
0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 
0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 
0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 
0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1af801f7, 0x20047e00, 0x4880090, 0x20010200, 0x4080040, 
};

static uint32_t FlatField_576_0[] = 
{ //0
0x20010200, 0x4080040, 0x20012200, 0x11b8008e, 0x2006a200, 0x1f6801ee, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1a8801ee, 0x20046e00, 0x488008e, 0x20010200, 0x4080040, 
};

static uint32_t FlatField_Pluge_1080_0[] = 
{ 

	0x20010200, 0x04080040, 0x20010600, 0x11b80086, 0x2006c200, 0x1f6801f5, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 
	0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 
	0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 
	0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 
	0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 
	0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 
	0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 
	0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 
	0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 
	0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 
	0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 
	0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 
	0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 
	0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x04080004, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 
	0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 
	0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 
	0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 
	0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 
	0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 
	0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 
	0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 
	0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 
	0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 
	0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 
	0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 
	0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 
	0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 
	0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 
	0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 
	0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 
	0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 
	0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 
	0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 
	0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 
	0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 
	0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 
	0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 
	0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 
	0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 
	0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 
};

static uint32_t FlatField_Pluge_720_0[] = 
{ 

	0x20010200, 0x04080040, 0x20010600, 0x11b80086, 0x2006c200, 0x1f6801f5, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 
	0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 
	0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 
	0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 
	0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 
	0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 
	0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 
	0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 
	0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 
	0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 
	0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 
	0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 
	0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 
	0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 
	0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 
	0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 
	0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 
	0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 
	0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 
	0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 
	0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 
	0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 
	0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 
	0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 
	0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 
	0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 
	0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 
	0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x3ffffc40, 0xcff3fccc, 0xcff3fccc, 0xcccccccc, 0xcccccccc, 0xcccccccc, 0xcccccccc, 0xcccccccc, 0xcccccccc, 0xcccccccc, 0xcccccccc, 
};

static uint32_t FlatField_Pluge_486_0[] = 
{ 

	0x20010200, 0x04080040, 0x20012200, 0x11f80090, 0x2006be00, 0x1ff801f7, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 
	0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 
	0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 
	0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 
	0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 
	0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 
	0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 
	0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 
	0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 
	0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 
	0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 
	0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 
	0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 
	0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 
	0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 0x2007fe00, 0x1ff801ff, 
	0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 
	0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 
	0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 
	0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 
	0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 
	0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 
	0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 
	0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 
	0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 
	0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 
	0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 
	0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 
	0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 
	0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 
	0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 
};

static uint32_t FlatField_Pluge_576_0[] = 
{ 

	0x20010200, 0x04080040, 0x20012200, 0x11b8008e, 0x2006a200, 0x1f6801ee, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 0x2007da00, 0x1f6801f6, 
	0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 
	0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 
	0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 
	0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 
	0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 0x20001200, 0x00480004, 
	0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 
	0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 
	0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 
	0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 
	0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 0x20010200, 0x04080040, 
	0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 
	0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 
	0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 
	0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 
	0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 0x2001f200, 0x07c8007c, 
};

#ifndef HD_NUMACTIVELINES_2K
#define HD_NUMACTIVELINES_2K		  1556	
#endif
static SegmentTestPatternData NTV2TestPatternSegments[] = 
{
	{
		"100% ColorBars",
		{
			{	// NTV2_STANDARD_1080
			 {0,1079, ColarBars100_1080_0} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL}
			},
			{	// NTV2_STANDARD_720
			 {0,719, ColorBars100_720_0} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL}
			},
			{	// NTV2_STANDARD_525
			 {0,485, ColorBars100_486_0} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL}
			},
			{	// NTV2_STANDARD_625
			 {0,575, ColorBars100_576_0} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL}
			},
			{	// NTV2_STANDARD_1080p
			 {0,1079, ColarBars100_1080_0} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL}
			},
			{ // NTV2_STANDARD_2K
			 {0,1555, ColarBars100_1080_0} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL}
			}


		}
	},
	{
		"75% ColorBars",
		{
			{
			 {0,1079, ColorBars75_1080_0} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL}
			},
			{
			 {0,719, ColorBars75_720_0} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL}
			},
			{
			 {0,485, ColorBars75_486_0} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL}
			},
			{
			 {0,575, ColorBars75_576_0} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL}
			},
			{
			 {0,1079, ColorBars75_1080_0} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL}
			},
			{
			 {0,1555, ColorBars75_1080_0} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} 
			}


		}
	},
	{
		"Ramp",
		{
			{
			 {0,1079, Ramp_1080_0} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL}
			},
			{
			 {0,719, Ramp_720_0} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL}
			},
			{
			 {0,485, Ramp_486_0} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL}
			},
			{
			 {0,575, Ramp_576_0} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL}
			},
			{
			 {0,1079, Ramp_1080_0} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL}
			},
			{
			 {0,1555, Ramp_1080_0} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} 
			}

		}
	},
	{
		"Multiburst",
		{
			{
			 {0,1079, Multiburst_1080_0} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL}
			},
			{
			 {0,719, Multiburst_720_0} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL}
			},
			{
			 {0,485, Multiburst_486_0} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL}
			},
			{
			 {0,575, Multiburst_576_0} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL}
			},
			{
			 {0,1079, Multiburst_1080_0} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL}
			},
			{
			 {0,1555, Multiburst_1080_0} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} 
			}
		}
	},
	{
		"Linesweep",
		{
			{
			 {0,181, LineSweep_1080_0} ,
			 {182,901, LineSweep_1080_1} ,
			 {902,1079, LineSweep_1080_2} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL}
			},
			{
			 {0,120, LineSweep_720_0} ,
			 {121,600, LineSweep_720_1} ,
			 {601,719, LineSweep_720_2} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL}
			},
			{
			 {0,340, LineSweep_486_0} ,
			 {341,485, LineSweep_486_1} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL}
			},
			{
			 {0,403, LineSweep_576_0} ,
			 {404,575, LineSweep_576_1} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL}
			},
			{
			 {0,181, LineSweep_1080_0} ,
			 {182,901, LineSweep_1080_1} ,
			 {902,1079, LineSweep_1080_2} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL}
			},
			{
			 {0,261, LineSweep_1080_0} ,
			 {262,1298, LineSweep_1080_1} ,
			 {1299,1555, LineSweep_1080_2} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} 
			}
		}
	},
	{
		"Check Field",
		{
			{
			 {0,0, Pathological_1080_0} ,
			 {1,1, Pathological_1080_1} ,
			 {2,2, Pathological_1080_2} ,
			 {3,542, Pathological_1080_3} ,
			 {543,1079, Pathological_1080_4} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} 
			},
			{
			 {0,1, Pathological_720_0} ,
			 {2,360, Pathological_720_1} ,
			 {361,719, Pathological_720_2} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL}
			},
			{
			 {0,242, Pathological_486_0} ,
			 {243,485, Pathological_486_1} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL}
			},
			{
			 {0,287, Pathological_576_0} ,
			 {288,575, Pathological_576_1} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL}
			},
			{
			 {0,0, Pathological_1080_0} ,
			 {1,1, Pathological_1080_1} ,
			 {2,2, Pathological_1080_2} ,
			 {3,542, Pathological_1080_3} ,
			 {543,1079, Pathological_1080_4} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} 
			},
			{
			 {0,0, Pathological_1080_0} ,
			 {1,1, Pathological_1080_1} ,
			 {2,2, Pathological_1080_2} ,
			 {3,781, Pathological_1080_3} ,
			 {782,1555, Pathological_1080_4} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} 
			}
		}
	},
	{
		"Flat Field",
		{
			{
			 {0,1079, FlatField_1080_0} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} 
			},
			{
			 {0,719, FlatField_720_0} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL}
			},
			{
			 {0,485, FlatField_486_0} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL}
			},
			{
			 {0,575, FlatField_576_0} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL}
			},
			{
			 {0,1079, FlatField_1080_0} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} 
			},
			{
			 {0,1555, FlatField_1080_0} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} 
			}
		}
	},
	{
		"Multi Pattern",
		{
			{
			 {0,215, ColarBars100_1080_0} ,
			 {216,431, ColorBars75_1080_0} ,
			 {432,647, Ramp_1080_0} ,
			 {648,863,	Multiburst_1080_0} ,
			 {864,1079, FlatField_Pluge_1080_0} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} 
			},
			{
			 {0,143, ColorBars100_720_0} ,
			 {144,287, ColorBars75_720_0} ,
			 {288,431, Ramp_720_0} ,
			 {432,575, Multiburst_720_0} ,
			 {576,719, FlatField_Pluge_720_0} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL}
			},
			{
			 {0,97, ColorBars100_486_0} ,
			 {98,195, ColorBars75_486_0} ,
			 {196,293, Ramp_486_0} ,
			 {294,389,	Multiburst_486_0} ,
			 {390,485, FlatField_Pluge_486_0} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} 
			},
			{
			 {0,115, ColorBars100_576_0} ,
			 {116,231, ColorBars75_576_0} ,
			 {232,347, Ramp_576_0} ,
			 {348,463, Multiburst_576_0} ,
			 {464,575, FlatField_Pluge_576_0} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL}
			},
			{
			 {0,215, ColarBars100_1080_0} ,
			 {216,431, ColorBars75_1080_0} ,
			 {432,647, Ramp_1080_0} ,
			 {648,863,	Multiburst_1080_0} ,
			 {864,1079, FlatField_Pluge_1080_0} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} 
			},
			{
			 {0,310, ColarBars100_1080_0} ,
			 {311,621, ColorBars75_1080_0} ,
			 {622,932, Ramp_1080_0} ,
			 {933,1243,	 Multiburst_1080_0} ,
			 {1244,1555, FlatField_Pluge_1080_0} ,
			 {0,0, NULL} ,
			 {0,0, NULL} ,
			 {0,0, NULL} 
			}
		}
	},

};

//const uint32_t numSegmentTestPatterns = sizeof(NTV2TestPatternSegments)/sizeof(SegmentTestPatternData);


uint32_t MakeSineWaveVideo(double radians, bool bChroma,double Gain);

//*********************************************************************************

// CTestPattern

AJATestPatternGen::AJATestPatternGen() :
	_patternNumber(AJA_TestPatt_ColorBars100),
	_frameWidth(0),
	_frameHeight(0),
	_linePitch(0),
	_dataLinePitch(0),
	_bufferSize(0),
	_pTestPatternBuffer(NULL),
	_pPackedLineBuffer(NULL),
	_pUnPackedLineBuffer(NULL),
	_sliderValue(DEFAULT_PATT_GAIN),
	_signalMask(AJA_SIGNALMASK_ALL),
	_pixelFormat(AJA_PixelFormat_Unknown),
	_bayerPhase(AJA_BayerColorPhase_RedGreen)
{
}


AJATestPatternGen::~AJATestPatternGen()
{

}


// DrawTestPattern()
//	Note: "dSlider" is expected to range between 0.0 and 1.0
//
bool AJATestPatternGen::DrawTestPattern( AJATestPatternSelect pattNum, uint32_t frameWidth, uint32_t frameHeight, AJA_PixelFormat pixelFormat, AJATestPatternBuffer &testPatternBuffer )
{
	bool bResult = false;

	// Save this away for worker methods.
	_patternNumber = pattNum;
	_frameWidth	 = frameWidth;
	_frameHeight = frameHeight;
	_pixelFormat = pixelFormat;

	_linePitch	   = AJA_CalcRowBytesForFormat(_pixelFormat, _frameWidth);		// number of BYTES per line of frame buffer format
	_dataLinePitch = AJA_CalcRowBytesForFormat(AJA_PixelFormat_YCbCr10, _frameWidth);			// number of BYTES per line of test pattern data (always stored as 10-bit YCbCr)
	_bufferSize = _linePitch*_frameHeight;
	if(_bufferSize == 0)
		return bResult;

	if ( testPatternBuffer.size() != _bufferSize )
		testPatternBuffer.resize(_bufferSize);

	_pTestPatternBuffer = &testPatternBuffer[0];

	_pPackedLineBuffer = new uint32_t[_frameWidth*2];
	_pUnPackedLineBuffer = new uint16_t[(_frameWidth+1)*2]; // add 1 for 720p
	// Fill Unpacked buffer with Black.
	AJA_MakeUnPacked10BitYCbCrBuffer( _pUnPackedLineBuffer, CCIR601_10BIT_BLACK , CCIR601_10BIT_CHROMAOFFSET , CCIR601_10BIT_CHROMAOFFSET ,_frameWidth );

	switch (pattNum)
	{
		case AJA_TestPatt_ColorBars100:
		case AJA_TestPatt_ColorBars75:
		case AJA_TestPatt_Ramp:
		case AJA_TestPatt_MultiBurst:
		case AJA_TestPatt_LineSweep:
		case AJA_TestPatt_CheckField:
		case AJA_TestPatt_FlatField:
		case AJA_TestPatt_MultiPattern:
			bResult = DrawSegmentedTestPattern();
			break;

		case AJA_TestPatt_Black:
			bResult = DrawYCbCrFrame(CCIR601_10BIT_BLACK,CCIR601_10BIT_CHROMAOFFSET,CCIR601_10BIT_CHROMAOFFSET);
			break;
		case AJA_TestPatt_White:
			bResult = DrawYCbCrFrame(CCIR601_10BIT_WHITE,CCIR601_10BIT_CHROMAOFFSET,CCIR601_10BIT_CHROMAOFFSET);
			break;
		case AJA_TestPatt_Border:
			bResult = DrawBorderFrame();
			break;
		case AJA_TestPatt_LinearRamp:
			DrawLinearRampFrame();
			bResult = true;
			break;
		case AJA_TestPatt_SlantRamp:
			DrawSlantRampFrame();
			bResult = true;
			break;
		case AJA_TestPatt_ZonePlate:
			DrawZonePlateFrame();
			bResult = true;
			break;
		case AJA_TestPatt_ColorQuadrant:
			DrawColorQuandrantFrame();
			bResult = true;
			break;
		case AJA_TestPatt_ColorQuadrantBorder:
			DrawQuandrantBorderFrame();
			bResult = true;
			break;
		case AJA_TestPatt_ColorQuadrantTSI:
			DrawColorQuandrantTSIFrame();
			bResult = true;
			break;
		default:	// unknown test pattern ID?
			break;
	}

	delete [] _pPackedLineBuffer;
	delete [] _pUnPackedLineBuffer;

	return bResult;
}


bool AJATestPatternGen::DrawTestPattern(AJATestPatternSelect pattNum, uint32_t frameWidth, uint32_t frameHeight, 
										AJA_PixelFormat pixelFormat, AJA_BayerColorPhase phase, AJATestPatternBuffer &testPatternBuffer )
{
	_bayerPhase = phase;
	return DrawTestPattern(pattNum, frameWidth, frameHeight, pixelFormat, testPatternBuffer);
}


bool AJATestPatternGen::DrawSegmentedTestPattern()
{
	bool bResult = true;
	bool b4K = false;

		// which video standard are we?
	int standard;  // this standard is used to index the SegmentTestPatternData
	if		(_frameWidth == 1920 && _frameHeight == 1080)
		standard = 0;			// aka "NTV2_STANDARD_1080"

	else if (_frameWidth == 2048 && _frameHeight == 1080)
		standard = 0;			// aka "NTV2_STANDARD_1080"

	else if (_frameWidth == 1280 && _frameHeight == 720)
		standard = 1;			// aka "NTV2_STANDARD_720"

	else if (_frameWidth == 720 && _frameHeight == 486)
		standard = 2;			// aka "NTV2_STANDARD_525"

	else if (_frameWidth == 720 && _frameHeight == 576)
		standard = 3;			// aka "NTV2_STANDARD_625"

	else if (_frameWidth == 2048 && _frameHeight == 1556)
		standard = 5;			// aka "NTV2_STANDARD2_K"

	else if (_frameWidth == 3840 && _frameHeight == 2160)
	{
		//kludge for now.
		standard = 0;			// aka "NTV2_STANDARD_1080"
		b4K = true;
	}
	else if (_frameWidth == 4096 && _frameHeight == 2160)
	{
		//kludge for now.
		standard = 0;			// aka "NTV2_STANDARD_1080"
		b4K = true;
	}

	else
		return false;


		// find the appropriate test pattern descriptor
	SegmentTestPatternData *pTestPatternSegmentData = &NTV2TestPatternSegments[_patternNumber];

		// walk through the segments
	for (int segmentCount = 0; segmentCount < NumTestPatternSegments; segmentCount++ )
	{
		SegmentDescriptor* segmentDescriptor = &pTestPatternSegmentData->segmentDescriptor[standard][segmentCount];
		uint32_t* data = segmentDescriptor->data;
		if ( data != NULL )
		{

			// copy the test pattern line to the local "_pPackedLineBuffer"
			memcpy(_pPackedLineBuffer, data, _dataLinePitch);

			if (_frameWidth == HD_NUMCOMPONENTPIXELS_2K || _frameWidth == (HD_NUMCOMPONENTPIXELS_2K*2) )
			{
				AJA_UnPack10BitYCbCrBuffer(_pPackedLineBuffer, _pUnPackedLineBuffer, HD_NUMCOMPONENTPIXELS_1080);
				AJA_ReSampleYCbCrSampleLine((int16_t*)_pUnPackedLineBuffer, (int16_t*)_pUnPackedLineBuffer, 1920, 2048);
			}
			else
				AJA_UnPack10BitYCbCrBuffer(_pPackedLineBuffer, _pUnPackedLineBuffer, _frameWidth);

			int startLine = segmentDescriptor->startLine;
			int numLines  = (segmentDescriptor->endLine - startLine) + 1;
			if ( b4K )
			{
				// total kludge....just stretch out 1080 pattern.
				startLine *= 2;
				numLines *= 2;
				
				// stretch line by copying pixels.
				uint16_t* pLineSrc	= &_pUnPackedLineBuffer[_frameWidth-1];
				uint16_t* pLineDest = &_pUnPackedLineBuffer[_frameWidth*2-1];
				for ( uint32_t count = 0; count < _frameWidth/4; count ++)
				{
					uint16_t y2	 = *pLineSrc--;
					uint16_t cr1 = *pLineSrc--;
					uint16_t y1	 = *pLineSrc--;
					uint16_t cb1 = *pLineSrc--;
					*pLineDest-- = y2;	
					*pLineDest-- = cr1; 
					*pLineDest-- = y1;
					*pLineDest-- = cb1;
					*pLineDest-- = y2;
					*pLineDest-- = cr1;
					*pLineDest-- = y1;
					*pLineDest-- = cb1;
						
				}
			}

			// go through hoops to mask out undesired components
			if (_patternNumber == AJA_TestPatt_MultiBurst || _patternNumber == AJA_TestPatt_LineSweep)
			{
				_signalMask = AJA_SIGNALMASK_Y;		// just assume that Multiburst and LineSweep are "Y Only"
				AJA_MaskUnPacked10BitYCbCrBuffer(_pUnPackedLineBuffer, (uint16_t)_signalMask , _frameWidth);
			}

				// now RE-pack, according to the desired pixel format
			AJA_ConvertUnpacked10BitYCbCrToPixelFormat(_pUnPackedLineBuffer, _pPackedLineBuffer, _frameWidth, _pixelFormat);


				// copy and repeat for as many lines as called for in segment
			for (int line = 0; line < numLines; line++)
			{

				int currentLine = startLine+line;
				WriteLineToBuffer( _pixelFormat, _bayerPhase, currentLine,_frameWidth, _linePitch, _pTestPatternBuffer,_pPackedLineBuffer); 

			}
		}
	}

	return bResult;
}

bool AJATestPatternGen::DrawYCbCrFrame(uint16_t Y, uint16_t Cb, uint16_t Cr)
{
	// Make a BlackLine
	AJA_MakeUnPacked10BitYCbCrBuffer( _pUnPackedLineBuffer, Y , Cb , Cr ,_frameWidth );
	AJA_ConvertUnpacked10BitYCbCrToPixelFormat(_pUnPackedLineBuffer, _pPackedLineBuffer, _frameWidth, _pixelFormat);

	for (uint32_t line = 0; line < _frameHeight; line++)
	{
		WriteLineToBuffer( _pixelFormat, _bayerPhase, line,_frameWidth, _linePitch, _pTestPatternBuffer,_pPackedLineBuffer); 
#if 0
		memcpy(_pTestPatternBuffer, _pPackedLineBuffer, _linePitch);
		_pTestPatternBuffer += _linePitch;
#endif
	}

	return true;
}

bool AJATestPatternGen::DrawLinearRampFrame()
{

	// Ramp from 0x40-0x3AC
	uint16_t value = 0x40;
	for ( uint16_t pixel = 0; pixel < _frameWidth; pixel++ )
	{
		_pUnPackedLineBuffer[pixel*2] = value;
		_pUnPackedLineBuffer[pixel*2+1] = value;
		value++;
		if ( value > 0x3AC )
			value = 0x40;
	}
	AJA_ConvertUnpacked10BitYCbCrToPixelFormat(_pUnPackedLineBuffer, _pPackedLineBuffer,_frameWidth,_pixelFormat);

	for ( uint32_t line = 0; line < _frameHeight ; line++ )
	{
		WriteLineToBuffer( _pixelFormat, _bayerPhase, line,_frameWidth, _linePitch, _pTestPatternBuffer,_pPackedLineBuffer); 

	}
	return true;

}


bool AJATestPatternGen::DrawSlantRampFrame()
{
	// Ramp from 0x40-0x3AC
	for ( uint32_t line = 0; line < _frameHeight; line++ )
	{
		uint16_t value = (line%(0x3AC-0x40))+0x40;

		for ( uint16_t pixel = 0; pixel < _frameWidth; pixel++ )
		{
			_pUnPackedLineBuffer[pixel*2] = value;
			_pUnPackedLineBuffer[pixel*2+1] = value;
			value++;
			if ( value > 0x3AC )
				value = 0x40;
		}
		AJA_ConvertUnpacked10BitYCbCrToPixelFormat(_pUnPackedLineBuffer, _pPackedLineBuffer,_frameWidth,_pixelFormat);
		WriteLineToBuffer( _pixelFormat, _bayerPhase, line,_frameWidth, _linePitch, _pTestPatternBuffer,_pPackedLineBuffer); 

	}

	return true;
}

bool AJATestPatternGen::DrawBorderFrame()
{
	uint32_t* pPackedWhiteLineBuffer= new uint32_t[_frameWidth*2];
	uint32_t* pPackedEdgeLineBuffer= new uint32_t[_frameWidth*2];
	uint16_t* pUnPackedEdgeBuffer= new uint16_t[_frameWidth*2];
	uint16_t* pUnPackedWhiteBuffer= new uint16_t[_frameWidth*2];

	AJA_MakeUnPacked10BitYCbCrBuffer(pUnPackedEdgeBuffer,CCIR601_10BIT_BLACK,CCIR601_10BIT_CHROMAOFFSET,CCIR601_10BIT_CHROMAOFFSET,_frameWidth);
	AJA_MakeUnPacked10BitYCbCrBuffer(pUnPackedWhiteBuffer,CCIR601_10BIT_WHITE,CCIR601_10BIT_CHROMAOFFSET,CCIR601_10BIT_CHROMAOFFSET,_frameWidth);

	// Put in White Edge.
	pUnPackedEdgeBuffer[0] = CCIR601_10BIT_CHROMAOFFSET;
	pUnPackedEdgeBuffer[+1] = CCIR601_10BIT_WHITE;
	pUnPackedEdgeBuffer[+2] = CCIR601_10BIT_CHROMAOFFSET;
	pUnPackedEdgeBuffer[(_frameWidth)*2-1] = CCIR601_10BIT_WHITE;
	pUnPackedEdgeBuffer[(_frameWidth)*2-2] = CCIR601_10BIT_CHROMAOFFSET;

	AJA_ConvertUnpacked10BitYCbCrToPixelFormat(pUnPackedWhiteBuffer, pPackedWhiteLineBuffer,_frameWidth,_pixelFormat);
	AJA_ConvertUnpacked10BitYCbCrToPixelFormat(pUnPackedEdgeBuffer, pPackedEdgeLineBuffer,_frameWidth,_pixelFormat);

	for ( uint32_t line = 0; line < _frameHeight; line++ )
	{
		if ( line == 0 || line == (_frameHeight-1))
			::memcpy(_pTestPatternBuffer,pPackedWhiteLineBuffer,_linePitch);
		else
			::memcpy(_pTestPatternBuffer,pPackedEdgeLineBuffer,_linePitch);

		_pTestPatternBuffer += _linePitch;
	}

	delete [] pPackedWhiteLineBuffer;
	delete [] pPackedEdgeLineBuffer;
	delete [] pUnPackedEdgeBuffer;
	delete [] pUnPackedWhiteBuffer;

	return true;
}

const double kPi = 3.1415926535898;
bool AJATestPatternGen::DrawZonePlateFrame()
{

	double pattScale = (kPi*.5 ) / (_frameWidth + 1);

	for ( uint32_t line = 0; line < _frameHeight; line++ )
	{

		for ( uint16_t pixel = 0; pixel < _frameWidth; pixel++ )
		{
			double xDist = (double)pixel - ((double)_frameWidth	 / 2.0);
			double yDist = (double)line - ((double)_frameHeight / 2.0);
			double r = ((xDist * xDist) + (yDist * yDist)) * pattScale;

			_pUnPackedLineBuffer[pixel*2+1] = MakeSineWaveVideo(r, false,_sliderValue);
			_pUnPackedLineBuffer[pixel*2] = MakeSineWaveVideo(r, true,_sliderValue);

		}
		AJA_ConvertUnpacked10BitYCbCrToPixelFormat(_pUnPackedLineBuffer, _pPackedLineBuffer,_frameWidth,_pixelFormat);
		WriteLineToBuffer( _pixelFormat, _bayerPhase, line,_frameWidth, _linePitch, _pTestPatternBuffer,_pPackedLineBuffer); 

	}

	return true;

}



bool AJATestPatternGen::DrawColorQuandrantFrame()
{
	uint32_t* pPackedUpperLineBuffer= new uint32_t[_frameWidth*2];
	uint16_t* pUnPackedUpperLineBuffer= new uint16_t[_frameWidth*2];
	uint32_t* pPackedLowerLineBuffer= new uint32_t[_frameWidth*2];
	uint16_t* pUnPackedLowerLineBuffer= new uint16_t[_frameWidth*2];

	// Colors for the quadrants are from SMPTE 435-1-2009 section 6.4.2
	static const unsigned char fullRange = 235;
	static const unsigned char midRange	 = 187;
	static const unsigned char lowRange	 = 140;
	AJA_RGBAlphaPixel rgbaPixel;
	AJA_YCbCr10BitPixel yCbCrPixel;
	rgbaPixel.Alpha = 0;  // Upper left - yellow
	rgbaPixel.Red = fullRange;
	rgbaPixel.Green = fullRange;
	rgbaPixel.Blue = lowRange;
	AJA_HDConvertRGBAlphatoYCbCr(&rgbaPixel, &yCbCrPixel);
	AJA_MakeUnPacked10BitYCbCrBuffer(pUnPackedUpperLineBuffer,yCbCrPixel.y,yCbCrPixel.cb,yCbCrPixel.cr,_frameWidth/2);
	rgbaPixel.Alpha = 0;  // Upper right - blue
	rgbaPixel.Red = midRange;
	rgbaPixel.Green = fullRange;
	rgbaPixel.Blue = fullRange;
	AJA_HDConvertRGBAlphatoYCbCr(&rgbaPixel, &yCbCrPixel);
	AJA_MakeUnPacked10BitYCbCrBuffer(&pUnPackedUpperLineBuffer[_frameWidth],yCbCrPixel.y,yCbCrPixel.cb,yCbCrPixel.cr,_frameWidth/2);
	rgbaPixel.Alpha = 0;  // Lower left - green
	rgbaPixel.Red = lowRange;
	rgbaPixel.Green = fullRange;
	rgbaPixel.Blue = lowRange;
	AJA_HDConvertRGBAlphatoYCbCr(&rgbaPixel, &yCbCrPixel);
	AJA_MakeUnPacked10BitYCbCrBuffer(pUnPackedLowerLineBuffer,yCbCrPixel.y,yCbCrPixel.cb,yCbCrPixel.cr,_frameWidth/2);
	rgbaPixel.Alpha = 0;  // Lower right - pink
	rgbaPixel.Red = fullRange;
	rgbaPixel.Green = lowRange;
	rgbaPixel.Blue = midRange;
	AJA_HDConvertRGBAlphatoYCbCr(&rgbaPixel, &yCbCrPixel);
	AJA_MakeUnPacked10BitYCbCrBuffer(&pUnPackedLowerLineBuffer[_frameWidth],yCbCrPixel.y,yCbCrPixel.cb,yCbCrPixel.cr,_frameWidth/2);

	AJA_ConvertUnpacked10BitYCbCrToPixelFormat(pUnPackedUpperLineBuffer, pPackedUpperLineBuffer,_frameWidth,_pixelFormat);
	AJA_ConvertUnpacked10BitYCbCrToPixelFormat(pUnPackedLowerLineBuffer, pPackedLowerLineBuffer,_frameWidth,_pixelFormat);

	uint32_t line;
	for ( line = 0; line < _frameHeight/2; line++ )
	{
		WriteLineToBuffer( _pixelFormat, _bayerPhase, line,_frameWidth, _linePitch, _pTestPatternBuffer,pPackedUpperLineBuffer); 
	}
	for ( line = 0; line < _frameHeight/2; line++ )
	{
		WriteLineToBuffer( _pixelFormat, _bayerPhase, line + (_frameHeight/2),_frameWidth, _linePitch, _pTestPatternBuffer,pPackedLowerLineBuffer); 
	}

	delete [] pUnPackedUpperLineBuffer;
	delete [] pPackedUpperLineBuffer;
	delete [] pUnPackedLowerLineBuffer;
	delete [] pPackedLowerLineBuffer;

	return true;

}

bool AJATestPatternGen::DrawColorQuandrantTSIFrame()
{
	uint32_t* pPackedEvenLineBuffer= new uint32_t[_frameWidth*2];
	uint16_t* pUnPackedEvenLineBuffer= new uint16_t[_frameWidth*2];
	uint32_t* pPackedOddLineBuffer= new uint32_t[_frameWidth*2];
	uint16_t* pUnPackedOddLineBuffer= new uint16_t[_frameWidth*2];

	// Colors for the quadrants are from SMPTE 435-1-2009 section 6.4.2
	static const unsigned char fullRange = 235;
	static const unsigned char midRange	 = 187;
	static const unsigned char lowRange	 = 140;
	AJA_RGBAlphaPixel rgbaPixelYellow, rgbaPixelBlue, rgbaPixelGreen, rgbaPixelPink;
	AJA_YCbCr10BitPixel yCbCrPixelYellow, yCbCrPixelBlue, yCbCrPixelGreen, yCbCrPixelPink;
	rgbaPixelYellow.Alpha = 0;	// Upper left - yellow
	rgbaPixelYellow.Red = fullRange;
	rgbaPixelYellow.Green = fullRange;
	rgbaPixelYellow.Blue = lowRange;
	AJA_HDConvertRGBAlphatoYCbCr(&rgbaPixelYellow, &yCbCrPixelYellow);
	rgbaPixelBlue.Alpha = 0;  // Upper right - blue
	rgbaPixelBlue.Red = midRange;
	rgbaPixelBlue.Green = fullRange;
	rgbaPixelBlue.Blue = fullRange;
	AJA_HDConvertRGBAlphatoYCbCr(&rgbaPixelBlue, &yCbCrPixelBlue);
	rgbaPixelGreen.Alpha = 0;  // Lower left - green
	rgbaPixelGreen.Red = lowRange;
	rgbaPixelGreen.Green = fullRange;
	rgbaPixelGreen.Blue = lowRange;
	AJA_HDConvertRGBAlphatoYCbCr(&rgbaPixelGreen, &yCbCrPixelGreen);
	rgbaPixelPink.Alpha = 0;  // Lower right - pink
	rgbaPixelPink.Red = fullRange;
	rgbaPixelPink.Green = lowRange;
	rgbaPixelPink.Blue = midRange;
	AJA_HDConvertRGBAlphatoYCbCr(&rgbaPixelPink, &yCbCrPixelPink);

	for ( uint32_t count = 0; count < _frameWidth; count+=16 )
	{
		pUnPackedEvenLineBuffer[count] = yCbCrPixelYellow.cb;
		pUnPackedEvenLineBuffer[count+1] = yCbCrPixelYellow.y;
		pUnPackedEvenLineBuffer[count+2] = yCbCrPixelYellow.cr;
		pUnPackedEvenLineBuffer[count+3] = yCbCrPixelYellow.y;

		pUnPackedEvenLineBuffer[count+4] = yCbCrPixelYellow.cb;
		pUnPackedEvenLineBuffer[count+5] = yCbCrPixelYellow.y;
		pUnPackedEvenLineBuffer[count+6] = yCbCrPixelYellow.cr;
		pUnPackedEvenLineBuffer[count+7] = yCbCrPixelYellow.y;

		pUnPackedEvenLineBuffer[count+8] = yCbCrPixelBlue.cb;
		pUnPackedEvenLineBuffer[count+9] = yCbCrPixelBlue.y;
		pUnPackedEvenLineBuffer[count+10] = yCbCrPixelBlue.cr;
		pUnPackedEvenLineBuffer[count+11] = yCbCrPixelBlue.y;

		pUnPackedEvenLineBuffer[count+12] = yCbCrPixelBlue.cb;
		pUnPackedEvenLineBuffer[count+13] = yCbCrPixelBlue.y;
		pUnPackedEvenLineBuffer[count+14] = yCbCrPixelBlue.cr;
		pUnPackedEvenLineBuffer[count+15] = yCbCrPixelBlue.y;
	}

	for ( uint32_t count = 0; count < _frameWidth; count+=16 )
	{
		pUnPackedOddLineBuffer[count] = yCbCrPixelGreen.cb;
		pUnPackedOddLineBuffer[count+1] = yCbCrPixelGreen.y;
		pUnPackedOddLineBuffer[count+2] = yCbCrPixelGreen.cr;
		pUnPackedOddLineBuffer[count+3] = yCbCrPixelGreen.y;

		pUnPackedOddLineBuffer[count+4] = yCbCrPixelGreen.cb;
		pUnPackedOddLineBuffer[count+5] = yCbCrPixelGreen.y;
		pUnPackedOddLineBuffer[count+6] = yCbCrPixelGreen.cr;
		pUnPackedOddLineBuffer[count+7] = yCbCrPixelGreen.y;

		pUnPackedOddLineBuffer[count+8] = yCbCrPixelPink.cb;
		pUnPackedOddLineBuffer[count+9] = yCbCrPixelPink.y;
		pUnPackedOddLineBuffer[count+10] = yCbCrPixelPink.cr;
		pUnPackedOddLineBuffer[count+11] = yCbCrPixelPink.y;

		pUnPackedOddLineBuffer[count+12] = yCbCrPixelPink.cb;
		pUnPackedOddLineBuffer[count+13] = yCbCrPixelPink.y;
		pUnPackedOddLineBuffer[count+14] = yCbCrPixelPink.cr;
		pUnPackedOddLineBuffer[count+15] = yCbCrPixelPink.y;
	}
	AJA_ConvertUnpacked10BitYCbCrToPixelFormat(pUnPackedEvenLineBuffer, pPackedEvenLineBuffer,_frameWidth,_pixelFormat);
	AJA_ConvertUnpacked10BitYCbCrToPixelFormat(pUnPackedOddLineBuffer, pPackedOddLineBuffer,_frameWidth,_pixelFormat);

	for(uint32_t line = 0; line < _frameHeight; line+=2)
	{
		WriteLineToBuffer( _pixelFormat, _bayerPhase, line,_frameWidth, _linePitch, _pTestPatternBuffer,pPackedEvenLineBuffer);
		WriteLineToBuffer( _pixelFormat, _bayerPhase, line + 1,_frameWidth, _linePitch, _pTestPatternBuffer,pPackedOddLineBuffer);
	}

	delete [] pUnPackedEvenLineBuffer;
	delete [] pPackedEvenLineBuffer;
	delete [] pUnPackedOddLineBuffer;
	delete [] pPackedOddLineBuffer;

	return true;

}

bool AJATestPatternGen::DrawQuandrantBorderFrame()
{
	uint32_t* pPackedRedLineBuffer= new uint32_t[_frameWidth*2];
	uint16_t* pUnPackedRedLineBuffer= new uint16_t[_frameWidth*2];
	uint32_t* pPackedBlueLineBuffer= new uint32_t[_frameWidth*2];
	uint16_t* pUnPackedBlueLineBuffer= new uint16_t[_frameWidth*2];
	uint32_t* pPackedMagentaGreenLineBuffer= new uint32_t[_frameWidth*2];
	uint16_t* pUnPackedMagentaGreenLineBuffer= new uint16_t[_frameWidth*2];

	AJA_RGBAlphaPixel rgbaRedPixel;
	rgbaRedPixel.Alpha = 0;
	rgbaRedPixel.Red = 0xFF;
	rgbaRedPixel.Green = 0;
	rgbaRedPixel.Blue = 0;
	AJA_RGBAlphaPixel rgbaGreenPixel;
	rgbaGreenPixel.Alpha = 0;
	rgbaGreenPixel.Red = 0;
	rgbaGreenPixel.Green = 0xFF;
	rgbaGreenPixel.Blue = 0;
	AJA_RGBAlphaPixel rgbaBluePixel;
	rgbaBluePixel.Alpha = 0;
	rgbaBluePixel.Red = 0;
	rgbaBluePixel.Green = 0;
	rgbaBluePixel.Blue = 0xFF;
	AJA_RGBAlphaPixel rgbaMagentaPixel;
	rgbaMagentaPixel.Alpha = 0;
	rgbaMagentaPixel.Red = 0xFF;
	rgbaMagentaPixel.Green = 0;
	rgbaMagentaPixel.Blue = 0xFF;
	AJA_YCbCr10BitPixel yCbCrRedPixel;
	AJA_HDConvertRGBAlphatoYCbCr(&rgbaRedPixel, &yCbCrRedPixel);
	AJA_YCbCr10BitPixel yCbCrGreenPixel;
	AJA_HDConvertRGBAlphatoYCbCr(&rgbaGreenPixel, &yCbCrGreenPixel);
	AJA_YCbCr10BitPixel yCbCrBluePixel;
	AJA_HDConvertRGBAlphatoYCbCr(&rgbaBluePixel, &yCbCrBluePixel);
	AJA_YCbCr10BitPixel yCbCrMagentaPixel;
	AJA_HDConvertRGBAlphatoYCbCr(&rgbaMagentaPixel, &yCbCrMagentaPixel);

	AJA_MakeUnPacked10BitYCbCrBuffer(pUnPackedRedLineBuffer,yCbCrRedPixel.y,yCbCrRedPixel.cb,yCbCrRedPixel.cr,_frameWidth);

	AJA_MakeUnPacked10BitYCbCrBuffer(pUnPackedBlueLineBuffer,yCbCrBluePixel.y,yCbCrBluePixel.cb,yCbCrBluePixel.cr,_frameWidth);
	AJA_MakeUnPacked10BitYCbCrBuffer(pUnPackedMagentaGreenLineBuffer,0x40,0x200,0x200,_frameWidth);
	pUnPackedMagentaGreenLineBuffer[0] = yCbCrMagentaPixel.cb;
	pUnPackedMagentaGreenLineBuffer[1] = yCbCrMagentaPixel.y;
	pUnPackedMagentaGreenLineBuffer[2] = yCbCrMagentaPixel.cr;

	pUnPackedMagentaGreenLineBuffer[_frameWidth-1] = yCbCrGreenPixel.y;
	pUnPackedMagentaGreenLineBuffer[_frameWidth-4] = yCbCrGreenPixel.cb;
	pUnPackedMagentaGreenLineBuffer[_frameWidth-3] = yCbCrGreenPixel.y;
	pUnPackedMagentaGreenLineBuffer[_frameWidth-2] = yCbCrGreenPixel.cr;

	pUnPackedMagentaGreenLineBuffer[_frameWidth] = yCbCrMagentaPixel.cb;
	pUnPackedMagentaGreenLineBuffer[_frameWidth+1] = yCbCrMagentaPixel.y;
	pUnPackedMagentaGreenLineBuffer[_frameWidth+2] = yCbCrMagentaPixel.cr;

	pUnPackedMagentaGreenLineBuffer[_frameWidth*2-1] = yCbCrGreenPixel.y;
	pUnPackedMagentaGreenLineBuffer[_frameWidth*2-4] = yCbCrGreenPixel.cb;
	pUnPackedMagentaGreenLineBuffer[_frameWidth*2-3] = yCbCrGreenPixel.y;
	pUnPackedMagentaGreenLineBuffer[_frameWidth*2-2] = yCbCrGreenPixel.cr;


	AJA_ConvertUnpacked10BitYCbCrToPixelFormat(pUnPackedRedLineBuffer, pPackedRedLineBuffer,_frameWidth,_pixelFormat);
	AJA_ConvertUnpacked10BitYCbCrToPixelFormat(pUnPackedBlueLineBuffer, pPackedBlueLineBuffer,_frameWidth,_pixelFormat);
	AJA_ConvertUnpacked10BitYCbCrToPixelFormat(pUnPackedMagentaGreenLineBuffer, pPackedMagentaGreenLineBuffer,_frameWidth,_pixelFormat);

	uint32_t line;
	for ( line = 0; line < _frameHeight; line++ )
	{
		if ( line == 0 )
		{
			WriteLineToBuffer( _pixelFormat, _bayerPhase, line,_frameWidth, _linePitch, _pTestPatternBuffer,pPackedRedLineBuffer); 
		}
		else if ( line == _frameHeight/2 )
		{
			WriteLineToBuffer( _pixelFormat, _bayerPhase, line,_frameWidth, _linePitch, _pTestPatternBuffer,pPackedBlueLineBuffer); 
		}
		else if ( line == (_frameHeight-1) )
		{
			WriteLineToBuffer( _pixelFormat, _bayerPhase, line,_frameWidth, _linePitch, _pTestPatternBuffer,pPackedRedLineBuffer); 
		}
		else
		{
			WriteLineToBuffer( _pixelFormat, _bayerPhase, line,_frameWidth, _linePitch, _pTestPatternBuffer,pPackedMagentaGreenLineBuffer); 
		}
	}

	delete [] pPackedRedLineBuffer;
	delete [] pUnPackedRedLineBuffer;
	delete [] pPackedBlueLineBuffer;
	delete [] pUnPackedBlueLineBuffer;
	delete [] pPackedMagentaGreenLineBuffer;
	delete [] pUnPackedMagentaGreenLineBuffer;

	return true;
}



// 10-bit YUV values
const int kYUVBlack10	   =  64;
const int kYUVWhite10	   = 940;
//const int kYUVMidGray10	   = (kYUVWhite10 + kYUVBlack10) / 2;

const int kYUVMinChroma10  =  64;
const int kYUVMaxChroma10  = 960;
//const int kYUVZeroChroma10 = 512;

uint32_t MakeSineWaveVideo(double radians, bool bChroma, double Gain)
{
	int result;


	double Scale;
	double Offset;

	if (!bChroma)
	{
		Scale  = ((float)kYUVWhite10 - (float)kYUVBlack10) / 2.0;
		Offset = ((float)kYUVWhite10 + (float)kYUVBlack10) / 2.0;

		// calculate -cosine value to start Y at minimum value
		result = (int)((sin(radians) * Scale * Gain) + Offset + 0.5);	// convert to 10-bit luma video levels
	}
	else
	{
		Scale  = ((float)kYUVMaxChroma10 - (float)kYUVMinChroma10) / 2.0;
		Offset = ((float)kYUVMaxChroma10 + (float)kYUVMinChroma10) / 2.0;

		// calculate sine value to start C at "zero" value
		result = (int)((sin(radians) * Scale * Gain) + Offset + 0.5);	// convert to 10-bit chroma video levels
	}

	return result;
}
 
#endif	//	!defined(NTV2_DEPRECATE_15_0)
