/*
 * SPDX-License-Identifier: MIT
 * Copyright (C) 2004 - 2021 AJA Video Systems, Inc.
 */
////////////////////////////////////////////////////////////
//
// Filename: ntv2genregs.h
// Purpose:	 Genlock register config
//
///////////////////////////////////////////////////////////////

#ifndef NTV2GENREGS_HEADER
#define NTV2GENREGS_HEADER

#include "ntv2system.h"

struct ntv2_genlock_data {
	uint32_t	addr;
	uint32_t	data;
};

/*
 * Si5345 Rev D Configuration Register Export Header File
 *
 * This file represents a series of Silicon Labs Si5345 Rev D 
 * register writes that can be performed to load a single configuration 
 * on a device. It was created by a Silicon Labs ClockBuilder Pro
 * export tool.
 *
 * Part:		                                       Si5345 Rev D
 * Design ID:                                          IO4K+43D
 * Includes Pre/Post Download Control Register Writes: Yes
 * Created By:                                         ClockBuilder Pro v2.16.1 [2017-07-19]
 * Timestamp:                                          2020-04-03 13:25:47 GMT-07:00
 *
 * A complete design report corresponding to this export is included at the end 
 * of this header file.
 *
 */

static struct ntv2_genlock_data s_genlock_525_2997[] =
{

	/* Start configuration preamble */
	{ 0x0B24, 0xC0 },
	{ 0x0B25, 0x00 },
	{ 0x0540, 0x01 },
	/* End configuration preamble */

	/* Delay 300 msec */
	/*    Delay is worst case time for device to complete any calibration */
	/*    that is running due to device state change previous to this script */
	/*    being processed. */
	{ 0x0000, 0x01 },

	/* Start configuration registers */
	{ 0x000B, 0x64 },
	{ 0x0016, 0x02 },
	{ 0x0017, 0xFC },
	{ 0x0018, 0xFF },
	{ 0x0019, 0xDF },
	{ 0x001A, 0xDF },
	{ 0x002B, 0x02 },
	{ 0x002C, 0x01 },
	{ 0x002D, 0x00 },
	{ 0x002E, 0x48 },
	{ 0x002F, 0x10 },
	{ 0x0030, 0x00 },
	{ 0x0031, 0x00 },
	{ 0x0032, 0x00 },
	{ 0x0033, 0x00 },
	{ 0x0034, 0x00 },
	{ 0x0035, 0x00 },
	{ 0x0036, 0xED },
	{ 0x0037, 0x0E },
	{ 0x0038, 0x00 },
	{ 0x0039, 0x00 },
	{ 0x003A, 0x00 },
	{ 0x003B, 0x00 },
	{ 0x003C, 0x00 },
	{ 0x003D, 0x00 },
	{ 0x003F, 0x00 },
	{ 0x0040, 0x04 },
	{ 0x0041, 0x00 },
	{ 0x0042, 0x00 },
	{ 0x0043, 0x00 },
	{ 0x0044, 0x00 },
	{ 0x0045, 0x0C },
	{ 0x0046, 0x96 },
	{ 0x0047, 0x00 },
	{ 0x0048, 0x00 },
	{ 0x0049, 0x00 },
	{ 0x004A, 0x4B },
	{ 0x004B, 0x00 },
	{ 0x004C, 0x00 },
	{ 0x004D, 0x00 },
	{ 0x004E, 0x05 },
	{ 0x004F, 0x00 },
	{ 0x0050, 0x0E },
	{ 0x0051, 0x00 },
	{ 0x0052, 0x00 },
	{ 0x0053, 0x00 },
	{ 0x0054, 0x00 },
	{ 0x0055, 0x00 },
	{ 0x0056, 0x00 },
	{ 0x0057, 0x00 },
	{ 0x0058, 0x00 },
	{ 0x0059, 0x01 },
	{ 0x005A, 0xBF },
	{ 0x005B, 0x47 },
	{ 0x005C, 0x3D },
	{ 0x005D, 0x01 },
	{ 0x005E, 0x00 },
	{ 0x005F, 0x00 },
	{ 0x0060, 0x00 },
	{ 0x0061, 0x00 },
	{ 0x0062, 0x00 },
	{ 0x0063, 0x00 },
	{ 0x0064, 0x00 },
	{ 0x0065, 0x00 },
	{ 0x0066, 0x00 },
	{ 0x0067, 0x00 },
	{ 0x0068, 0x00 },
	{ 0x0069, 0x00 },
	{ 0x0092, 0x02 },
	{ 0x0093, 0x80 },
	{ 0x0095, 0x00 },
	{ 0x0096, 0x60 },
	{ 0x0098, 0x40 },
	{ 0x009A, 0x02 },
	{ 0x009B, 0x40 },
	{ 0x009D, 0x00 },
	{ 0x009E, 0x40 },
	{ 0x00A0, 0x00 },
	{ 0x00A2, 0x00 },
	{ 0x00A9, 0xE4 },
	{ 0x00AA, 0x31 },
	{ 0x00AB, 0x00 },
	{ 0x00AC, 0x00 },
	{ 0x00E5, 0x21 },
	{ 0x00EA, 0x12 },
	{ 0x00EB, 0x1A },
	{ 0x00EC, 0x00 },
	{ 0x00ED, 0x00 },
	{ 0x0102, 0x01 },
	{ 0x0108, 0x02 },
	{ 0x0109, 0x09 },
	{ 0x010A, 0x3B },
	{ 0x010B, 0x28 },
	{ 0x010D, 0x01 },
	{ 0x010E, 0x09 },
	{ 0x010F, 0x3B },
	{ 0x0110, 0x28 },
	{ 0x0112, 0x02 },
	{ 0x0113, 0x09 },
	{ 0x0114, 0x3B },
	{ 0x0115, 0x28 },
	{ 0x0117, 0x01 },
	{ 0x0118, 0x09 },
	{ 0x0119, 0x3B },
	{ 0x011A, 0x28 },
	{ 0x011C, 0x01 },
	{ 0x011D, 0x09 },
	{ 0x011E, 0x3B },
	{ 0x011F, 0x28 },
	{ 0x0121, 0x02 },
	{ 0x0122, 0x09 },
	{ 0x0123, 0x3B },
	{ 0x0124, 0x29 },
	{ 0x0126, 0x01 },
	{ 0x0127, 0x09 },
	{ 0x0128, 0x3B },
	{ 0x0129, 0x28 },
	{ 0x012B, 0x01 },
	{ 0x012C, 0x09 },
	{ 0x012D, 0x3B },
	{ 0x012E, 0x28 },
	{ 0x0130, 0x02 },
	{ 0x0131, 0x09 },
	{ 0x0132, 0x3B },
	{ 0x0133, 0x2A },
	{ 0x013A, 0x01 },
	{ 0x013B, 0x09 },
	{ 0x013C, 0x3B },
	{ 0x013D, 0x28 },
	{ 0x013F, 0x00 },
	{ 0x0140, 0x00 },
	{ 0x0141, 0x40 },
	{ 0x0142, 0xFF },
	{ 0x0206, 0x00 },
	{ 0x0208, 0x01 },
	{ 0x0209, 0x00 },
	{ 0x020A, 0x00 },
	{ 0x020B, 0x00 },
	{ 0x020C, 0x00 },
	{ 0x020D, 0x00 },
	{ 0x020E, 0x01 },
	{ 0x020F, 0x00 },
	{ 0x0210, 0x00 },
	{ 0x0211, 0x00 },
	{ 0x0212, 0x00 },
	{ 0x0213, 0x00 },
	{ 0x0214, 0x00 },
	{ 0x0215, 0x00 },
	{ 0x0216, 0x00 },
	{ 0x0217, 0x00 },
	{ 0x0218, 0x00 },
	{ 0x0219, 0x00 },
	{ 0x021A, 0x00 },
	{ 0x021B, 0x00 },
	{ 0x021C, 0x00 },
	{ 0x021D, 0x00 },
	{ 0x021E, 0x00 },
	{ 0x021F, 0x00 },
	{ 0x0220, 0x00 },
	{ 0x0221, 0x00 },
	{ 0x0222, 0x00 },
	{ 0x0223, 0x00 },
	{ 0x0224, 0x00 },
	{ 0x0225, 0x00 },
	{ 0x0226, 0x00 },
	{ 0x0227, 0x00 },
	{ 0x0228, 0x00 },
	{ 0x0229, 0x00 },
	{ 0x022A, 0x00 },
	{ 0x022B, 0x00 },
	{ 0x022C, 0x00 },
	{ 0x022D, 0x00 },
	{ 0x022E, 0x00 },
	{ 0x022F, 0x00 },
	{ 0x0231, 0x0B },
	{ 0x0232, 0x0B },
	{ 0x0233, 0x0B },
	{ 0x0234, 0x0B },
	{ 0x0235, 0x00 },
	{ 0x0236, 0x00 },
	{ 0x0237, 0x00 },
	{ 0x0238, 0x78 },
	{ 0x0239, 0xD5 },
	{ 0x023A, 0x00 },
	{ 0x023B, 0x00 },
	{ 0x023C, 0x00 },
	{ 0x023D, 0x00 },
	{ 0x023E, 0xD0 },
	{ 0x024A, 0x0A },
	{ 0x024B, 0x00 },
	{ 0x024C, 0x00 },
	{ 0x024D, 0x00 },
	{ 0x024E, 0x00 },
	{ 0x024F, 0x00 },
	{ 0x0250, 0x01 },
	{ 0x0251, 0x00 },
	{ 0x0252, 0x00 },
	{ 0x0253, 0x00 },
	{ 0x0254, 0x00 },
	{ 0x0255, 0x00 },
	{ 0x0256, 0x00 },
	{ 0x0257, 0x00 },
	{ 0x0258, 0x00 },
	{ 0x0259, 0x02 },
	{ 0x025A, 0x00 },
	{ 0x025B, 0x00 },
	{ 0x025C, 0x00 },
	{ 0x025D, 0x00 },
	{ 0x025E, 0x00 },
	{ 0x025F, 0x00 },
	{ 0x0260, 0x00 },
	{ 0x0261, 0x00 },
	{ 0x0262, 0x02 },
	{ 0x0263, 0x00 },
	{ 0x0264, 0x00 },
	{ 0x0268, 0x00 },
	{ 0x0269, 0x00 },
	{ 0x026A, 0x00 },
	{ 0x026B, 0x49 },
	{ 0x026C, 0x4F },
	{ 0x026D, 0x34 },
	{ 0x026E, 0x4B },
	{ 0x026F, 0x2B },
	{ 0x0270, 0x34 },
	{ 0x0271, 0x33 },
	{ 0x0272, 0x44 },
	{ 0x0294, 0x80 },
	{ 0x0296, 0x00 },
	{ 0x0297, 0x02 },
	{ 0x0299, 0x02 },
	{ 0x029D, 0x0A },
	{ 0x029E, 0x07 },
	{ 0x029F, 0x00 },
	{ 0x02A9, 0x99 },
	{ 0x02AA, 0x09 },
	{ 0x02AB, 0x00 },
	{ 0x02B7, 0xFF },
	{ 0x0302, 0x00 },
	{ 0x0303, 0x00 },
	{ 0x0304, 0x00 },
	{ 0x0305, 0x80 },
	{ 0x0306, 0x0B },
	{ 0x0307, 0x00 },
	{ 0x0308, 0x00 },
	{ 0x0309, 0x00 },
	{ 0x030A, 0x00 },
	{ 0x030B, 0x80 },
	{ 0x030C, 0x00 },
	{ 0x030D, 0x00 },
	{ 0x030E, 0x00 },
	{ 0x030F, 0x60 },
	{ 0x0310, 0x53 },
	{ 0x0311, 0x2E },
	{ 0x0312, 0x00 },
	{ 0x0313, 0x00 },
	{ 0x0314, 0x00 },
	{ 0x0315, 0x00 },
	{ 0x0316, 0x80 },
	{ 0x0317, 0x00 },
	{ 0x0318, 0x00 },
	{ 0x0319, 0x00 },
	{ 0x031A, 0xE0 },
	{ 0x031B, 0x3D },
	{ 0x031C, 0x0B },
	{ 0x031D, 0x00 },
	{ 0x031E, 0x00 },
	{ 0x031F, 0x00 },
	{ 0x0320, 0x80 },
	{ 0x0321, 0xBB },
	{ 0x0322, 0x00 },
	{ 0x0323, 0x00 },
	{ 0x0324, 0x00 },
	{ 0x0325, 0x00 },
	{ 0x0326, 0x00 },
	{ 0x0327, 0x00 },
	{ 0x0328, 0x00 },
	{ 0x0329, 0x00 },
	{ 0x032A, 0x00 },
	{ 0x032B, 0x00 },
	{ 0x032C, 0x00 },
	{ 0x032D, 0x00 },
	{ 0x032E, 0x00 },
	{ 0x032F, 0x00 },
	{ 0x0330, 0x00 },
	{ 0x0331, 0x00 },
	{ 0x0332, 0x00 },
	{ 0x0333, 0x00 },
	{ 0x0334, 0x00 },
	{ 0x0335, 0x00 },
	{ 0x0336, 0x00 },
	{ 0x0337, 0x00 },
	{ 0x0338, 0x00 },
	{ 0x0339, 0x1F },
	{ 0x033B, 0x00 },
	{ 0x033C, 0x00 },
	{ 0x033D, 0x00 },
	{ 0x033E, 0x00 },
	{ 0x033F, 0x00 },
	{ 0x0340, 0x00 },
	{ 0x0341, 0x00 },
	{ 0x0342, 0x00 },
	{ 0x0343, 0x00 },
	{ 0x0344, 0x00 },
	{ 0x0345, 0x00 },
	{ 0x0346, 0x00 },
	{ 0x0347, 0x00 },
	{ 0x0348, 0x00 },
	{ 0x0349, 0x00 },
	{ 0x034A, 0x00 },
	{ 0x034B, 0x00 },
	{ 0x034C, 0x00 },
	{ 0x034D, 0x00 },
	{ 0x034E, 0x00 },
	{ 0x034F, 0x00 },
	{ 0x0350, 0x00 },
	{ 0x0351, 0x00 },
	{ 0x0352, 0x00 },
	{ 0x0353, 0x00 },
	{ 0x0354, 0x00 },
	{ 0x0355, 0x00 },
	{ 0x0356, 0x00 },
	{ 0x0357, 0x00 },
	{ 0x0358, 0x00 },
	{ 0x0359, 0x00 },
	{ 0x035A, 0x00 },
	{ 0x035B, 0x00 },
	{ 0x035C, 0x00 },
	{ 0x035D, 0x00 },
	{ 0x035E, 0x00 },
	{ 0x035F, 0x00 },
	{ 0x0360, 0x00 },
	{ 0x0361, 0x00 },
	{ 0x0362, 0x00 },
	{ 0x0487, 0x00 },
	{ 0x0502, 0x01 },
	{ 0x0508, 0x12 },
	{ 0x0509, 0x1D },
	{ 0x050A, 0x0F },
	{ 0x050B, 0x0F },
	{ 0x050C, 0x07 },
	{ 0x050D, 0x03 },
	{ 0x050E, 0x19 },
	{ 0x050F, 0x2D },
	{ 0x0510, 0x09 },
	{ 0x0511, 0x08 },
	{ 0x0512, 0x07 },
	{ 0x0513, 0x03 },
	{ 0x0515, 0x00 },
	{ 0x0516, 0x00 },
	{ 0x0517, 0x00 },
	{ 0x0518, 0x00 },
	{ 0x0519, 0xF9 },
	{ 0x051A, 0xA7 },
	{ 0x051B, 0x01 },
	{ 0x051C, 0x00 },
	{ 0x051D, 0x00 },
	{ 0x051E, 0x00 },
	{ 0x051F, 0xA0 },
	{ 0x0521, 0x3B },
	{ 0x052A, 0x01 },
	{ 0x052B, 0x01 },
	{ 0x052C, 0x0F },
	{ 0x052D, 0x03 },
	{ 0x052E, 0x17 },
	{ 0x052F, 0x19 },
	{ 0x0531, 0x00 },
	{ 0x0532, 0xC6 },
	{ 0x0533, 0x9D },
	{ 0x0534, 0x01 },
	{ 0x0535, 0x00 },
	{ 0x0536, 0x00 },
	{ 0x0537, 0x00 },
	{ 0x0538, 0x00 },
	{ 0x0539, 0x00 },
	{ 0x053A, 0x02 },
	{ 0x053B, 0x03 },
	{ 0x053C, 0x00 },
	{ 0x053D, 0x0E },
	{ 0x053E, 0x06 },
	{ 0x0589, 0xC6 },
	{ 0x058A, 0x06 },
	{ 0x059B, 0xF8 },
	{ 0x059D, 0x19 },
	{ 0x059E, 0x2D },
	{ 0x059F, 0x09 },
	{ 0x05A0, 0x08 },
	{ 0x05A1, 0x07 },
	{ 0x05A2, 0x03 },
	{ 0x05A6, 0x00 },
	{ 0x0802, 0x35 },
	{ 0x0803, 0x05 },
	{ 0x0804, 0x00 },
	{ 0x0805, 0x00 },
	{ 0x0806, 0x00 },
	{ 0x0807, 0x00 },
	{ 0x0808, 0x00 },
	{ 0x0809, 0x00 },
	{ 0x080A, 0x00 },
	{ 0x080B, 0x00 },
	{ 0x080C, 0x00 },
	{ 0x080D, 0x00 },
	{ 0x080E, 0x00 },
	{ 0x080F, 0x00 },
	{ 0x0810, 0x00 },
	{ 0x0811, 0x00 },
	{ 0x0812, 0x00 },
	{ 0x0813, 0x00 },
	{ 0x0814, 0x00 },
	{ 0x0815, 0x00 },
	{ 0x0816, 0x00 },
	{ 0x0817, 0x00 },
	{ 0x0818, 0x00 },
	{ 0x0819, 0x00 },
	{ 0x081A, 0x00 },
	{ 0x081B, 0x00 },
	{ 0x081C, 0x00 },
	{ 0x081D, 0x00 },
	{ 0x081E, 0x00 },
	{ 0x081F, 0x00 },
	{ 0x0820, 0x00 },
	{ 0x0821, 0x00 },
	{ 0x0822, 0x00 },
	{ 0x0823, 0x00 },
	{ 0x0824, 0x00 },
	{ 0x0825, 0x00 },
	{ 0x0826, 0x00 },
	{ 0x0827, 0x00 },
	{ 0x0828, 0x00 },
	{ 0x0829, 0x00 },
	{ 0x082A, 0x00 },
	{ 0x082B, 0x00 },
	{ 0x082C, 0x00 },
	{ 0x082D, 0x00 },
	{ 0x082E, 0x00 },
	{ 0x082F, 0x00 },
	{ 0x0830, 0x00 },
	{ 0x0831, 0x00 },
	{ 0x0832, 0x00 },
	{ 0x0833, 0x00 },
	{ 0x0834, 0x00 },
	{ 0x0835, 0x00 },
	{ 0x0836, 0x00 },
	{ 0x0837, 0x00 },
	{ 0x0838, 0x00 },
	{ 0x0839, 0x00 },
	{ 0x083A, 0x00 },
	{ 0x083B, 0x00 },
	{ 0x083C, 0x00 },
	{ 0x083D, 0x00 },
	{ 0x083E, 0x00 },
	{ 0x083F, 0x00 },
	{ 0x0840, 0x00 },
	{ 0x0841, 0x00 },
	{ 0x0842, 0x00 },
	{ 0x0843, 0x00 },
	{ 0x0844, 0x00 },
	{ 0x0845, 0x00 },
	{ 0x0846, 0x00 },
	{ 0x0847, 0x00 },
	{ 0x0848, 0x00 },
	{ 0x0849, 0x00 },
	{ 0x084A, 0x00 },
	{ 0x084B, 0x00 },
	{ 0x084C, 0x00 },
	{ 0x084D, 0x00 },
	{ 0x084E, 0x00 },
	{ 0x084F, 0x00 },
	{ 0x0850, 0x00 },
	{ 0x0851, 0x00 },
	{ 0x0852, 0x00 },
	{ 0x0853, 0x00 },
	{ 0x0854, 0x00 },
	{ 0x0855, 0x00 },
	{ 0x0856, 0x00 },
	{ 0x0857, 0x00 },
	{ 0x0858, 0x00 },
	{ 0x0859, 0x00 },
	{ 0x085A, 0x00 },
	{ 0x085B, 0x00 },
	{ 0x085C, 0x00 },
	{ 0x085D, 0x00 },
	{ 0x085E, 0x00 },
	{ 0x085F, 0x00 },
	{ 0x0860, 0x00 },
	{ 0x0861, 0x00 },
	{ 0x090E, 0x03 },
	{ 0x0943, 0x00 },
	{ 0x0949, 0x31 },
	{ 0x094A, 0x01 },
	{ 0x094E, 0x49 },
	{ 0x094F, 0x02 },
	{ 0x095E, 0x00 },
	{ 0x0A02, 0x00 },
	{ 0x0A03, 0x07 },
	{ 0x0A04, 0x01 },
	{ 0x0A05, 0x07 },
	{ 0x0A14, 0x00 },
	{ 0x0A1A, 0x00 },
	{ 0x0A20, 0x00 },
	{ 0x0A26, 0x00 },
	{ 0x0A2C, 0x00 },
	{ 0x0B44, 0x0F },
	{ 0x0B46, 0x00 },
	{ 0x0B47, 0x0E },
	{ 0x0B48, 0x0E },
	{ 0x0B4A, 0x18 },
	{ 0x0B57, 0xF9 },
	{ 0x0B58, 0x00 },
	/* End configuration registers */

	/* Start configuration postamble */
	{ 0x0514, 0x01 },
	{ 0x001C, 0x01 },
	{ 0x0540, 0x00 },
	{ 0x0B24, 0xC3 },
	{ 0x0B25, 0x02 },
	/* End configuration postamble */
	{ 0x0000, 0x00 }
};

/*
 * Design Report
 *
 * Overview
 * ========
 * Part:         Si5345 Rev D
 * Design ID:    IO4K+43D
 * Created By:   ClockBuilder Pro v2.16.1 [2017-07-19]
 * Timestamp:    2020-04-03 13:25:46 GMT-07:00
 * 
 * Design Notes
 * ============
 * assumes NTSC HSYNC (pulsed) input = (30/1.001)*525
 * 
 * Design Rule Check
 * =================
 * Errors:
 * - No errors
 * 
 * Warnings:
 * - Pulsed LVCMOS input buffer mode has been selected. This mode has non-standard input voltage logic thresholds: 0.33 V for Vil (max) and 0.49 V for Vih (min). Select this mode only if your input clock has a duty cycle significantly less or more than 50%.  Refer to the device datasheet for the exact threshold voltage specifications and the input attenuator circuit (DC coupled Pulsed LVCMOS) in the Family Reference Manual.
 * 
 * Device Grade
 * ============
 * Maximum Output Frequency: 148.5 MHz
 * Frequency Synthesis Mode: Fractional
 * Minimum Base OPN:         Si5345B
 * Actual Base OPN:          Si5345B
 * 
 * Base       Output Clock         Supported Frequency Synthesis Modes
 * OPN Grade  Frequency Range      (Typical Jitter)
 * ---------  -------------------  --------------------------------------------
 * Si5345A    100 Hz to 1.028 GHz  Integer (< 100 fs) and fractional (< 150 fs)
 * Si5345B    100 Hz to 350 MHz    "
 * Si5345C    100 Hz to 1.028 GHz  Integer only (< 100 fs)
 * Si5345D    100 Hz to 350 MHz    "
 * 
 * Design
 * ======
 * Host Interface:
 *    I/O Power Supply: VDD (Core)
 *    SPI Mode: 4-Wire
 *    I2C Address Range: 100d to 103d / 0x64 to 0x67 (selected via A0/A1 pins)
 * 
 * XA/XB:
 *    52 MHz (XO - External Oscillator)
 * 
 * Inputs:
 *     IN0: 15.7342657342657342... kHz [ 15 + 105/143 kHz ]
 *          [ (30/1.001)*525 ]
 *          Pulsed LVCMOS
 *     IN1: Unused
 *     IN2: Unused
 *     IN3: Unused
 * 
 * Outputs:
 *    OUT0: 27 MHz
 *          Enabled, LVDS 2.5 V
 *    OUT1: Unused
 *    OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT3: Unused
 *    OUT4: Unused
 *    OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT6: Unused
 *    OUT7: Unused
 *    OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *          [ 148.5/1.001 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT9: Unused
 * 
 * Frequency Plan
 * ==============
 * Priority: maximize the number of low jitter outputs
 * 
 * Fvco = 13.662 GHz [ 13 + 331/500 GHz ]
 * Fpfd = 15.7342657342657342... kHz [ 15 + 105/143 kHz ]
 * Fms0 = 594 MHz
 * Fms1 = 147.456 MHz [ 147 + 57/125 MHz ]
 * Fms2 = 890.1098901098901098... MHz [ 890 + 10/91 MHz ]
 * 
 * P dividers:
 *    P0  = 1
 *    P1  = Unused
 *    P2  = Unused
 *    P3  = Unused
 *    Pxaxb = 1
 * 
 * MXAXB = 262.7307692307692307... [ 262 + 19/26 ]
 * M = 173659.2 [ 173659 + 1/5 ]
 * N dividers:
 *    N0:
 *       Value: 23
 *       Skew:  0.000 s
 *       OUT0: 27 MHz
 *       OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *    N1:
 *       Value: 92.6513671875 [ 92 + 667/1024 ]
 *       Skew:  0.000 s
 *       OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *    N2:
 *       Value: 15.3486666666666666... [ 15 + 523/1500 ]
 *       Skew:  0.000 s
 *       OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *    N3:
 *       Unused
 *    N4:
 *       Unused
 * 
 * R dividers:
 *    R0 = 22
 *    R1 = Unused
 *    R2 = 4
 *    R3 = Unused
 *    R4 = Unused
 *    R5 = 6
 *    R6 = Unused
 *    R7 = Unused
 *    R8 = 6
 *    R9 = Unused
 * 
 * Nominal Bandwidth:
 *   Desired: 8.000 Hz
 *   Actual:  5.574 Hz
 *   Coefficients:
 *      BW0:  18
 *      BW1:  29
 *      BW2:  15
 *      BW3:  15
 *      BW4:  7
 *      BW5:  3
 * Fastlock Bandwidth:
 *   Desired: 800.000 Hz
 *   Actual:  898.678 Hz
 *   Coefficients:
 *      BW0:  25
 *      BW1:  45
 *      BW2:  9
 *      BW3:  8
 *      BW4:  7
 *      BW5:  3
 * Holdover Bandwidth:
 *   Desired: 800.000 Hz
 *   Actual:  898.678 Hz
 *   Coefficients:
 *      BW0:  25
 *      BW1:  45
 *      BW2:  9
 *      BW3:  8
 *      BW4:  7
 *      BW5:  3
 * 
 * Dividers listed above show effective values. These values are translated to register settings by ClockBuilder Pro. For the actual register values, see below. Refer to the Family Reference Manual for information on registers related to frequency plan.
 * 
 * Digitally Controlled Oscillator (DCO)
 * =====================================
 * Mode: Register Direct Write
 * 
 * N0: DCO Disabled
 * 
 * N1: DCO Disabled
 * 
 * N2: DCO Disabled
 * 
 * N3: DCO Disabled
 * 
 * N4: DCO Disabled
 * 
 * Estimated Power & Junction Temperature
 * ======================================
 * Assumptions:
 * 
 * Revision: D
 * VDD:      1.8 V
 * Ta:       70 C
 * Airflow:  None
 * 
 * Total Power: 808 mW, On Chip Power: 784 mW, Tj: 87 C
 * 
 *                 Frequency  Format   Voltage   Current     Power
 *         -----------------  ------  --------  --------  --------
 * VDD                                   1.8 V  147.9 mA    266 mW
 * VDDA                                  3.3 V  117.4 mA    387 mW
 * VDDO0              27 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO1              Unused                                      
 * VDDO2           148.5 MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO3              Unused                                      
 * VDDO4              Unused                                      
 * VDDO5          24.576 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO6              Unused                                      
 * VDDO7              Unused                                      
 * VDDO8   148.351648... MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO9              Unused                                      
 *                                              --------  --------
 *                                       Total  327.2 mA    808 mW
 * 
 * Note:
 * 
 * -Total power includes on- and off-chip power. This is a typical value and estimate only.
 * -Use an EVB for a more exact power measurement
 * -On-chip power excludes power dissipated in external terminations.
 * -Tj is junction temperature. Tj must be less than 125 C (on Si5345 Revision D) for device to comply with datasheet specifications.
 * 
 * Settings
 * ========
 * 
 * Location      Setting Name           Decimal Value      Hex Value        
 * ------------  ---------------------  -----------------  -----------------
 * 0x000B[6:0]   I2C_ADDR               100                0x64             
 * 0x0016[1]     LOL_ON_HOLD            1                  0x1              
 * 0x0017[0]     SYSINCAL_INTR_MSK      0                  0x0              
 * 0x0017[1]     LOSXAXB_INTR_MSK       0                  0x0              
 * 0x0017[5]     SMB_TMOUT_INTR_MSK     1                  0x1              
 * 0x0018[3:0]   LOS_INTR_MSK           15                 0xF              
 * 0x0018[7:4]   OOF_INTR_MSK           15                 0xF              
 * 0x0019[1]     LOL_INTR_MSK           1                  0x1              
 * 0x0019[5]     HOLD_INTR_MSK          0                  0x0              
 * 0x001A[5]     CAL_INTR_MSK           0                  0x0              
 * 0x002B[3]     SPI_3WIRE              0                  0x0              
 * 0x002B[5]     AUTO_NDIV_UPDATE       0                  0x0              
 * 0x002C[3:0]   LOS_EN                 1                  0x1              
 * 0x002C[4]     LOSXAXB_DIS            0                  0x0              
 * 0x002D[1:0]   LOS0_VAL_TIME          0                  0x0              
 * 0x002D[3:2]   LOS1_VAL_TIME          0                  0x0              
 * 0x002D[5:4]   LOS2_VAL_TIME          0                  0x0              
 * 0x002D[7:6]   LOS3_VAL_TIME          0                  0x0              
 * 0x002E[15:0]  LOS0_TRG_THR           4168               0x1048           
 * 0x0030[15:0]  LOS1_TRG_THR           0                  0x0000           
 * 0x0032[15:0]  LOS2_TRG_THR           0                  0x0000           
 * 0x0034[15:0]  LOS3_TRG_THR           0                  0x0000           
 * 0x0036[15:0]  LOS0_CLR_THR           3821               0x0EED           
 * 0x0038[15:0]  LOS1_CLR_THR           0                  0x0000           
 * 0x003A[15:0]  LOS2_CLR_THR           0                  0x0000           
 * 0x003C[15:0]  LOS3_CLR_THR           0                  0x0000           
 * 0x003F[3:0]   OOF_EN                 0                  0x0              
 * 0x003F[7:4]   FAST_OOF_EN            0                  0x0              
 * 0x0040[2:0]   OOF_REF_SEL            4                  0x4              
 * 0x0041[4:0]   OOF0_DIV_SEL           0                  0x00             
 * 0x0042[4:0]   OOF1_DIV_SEL           0                  0x00             
 * 0x0043[4:0]   OOF2_DIV_SEL           0                  0x00             
 * 0x0044[4:0]   OOF3_DIV_SEL           0                  0x00             
 * 0x0045[4:0]   OOFXO_DIV_SEL          12                 0x0C             
 * 0x0046[7:0]   OOF0_SET_THR           150                0x96             
 * 0x0047[7:0]   OOF1_SET_THR           0                  0x00             
 * 0x0048[7:0]   OOF2_SET_THR           0                  0x00             
 * 0x0049[7:0]   OOF3_SET_THR           0                  0x00             
 * 0x004A[7:0]   OOF0_CLR_THR           75                 0x4B             
 * 0x004B[7:0]   OOF1_CLR_THR           0                  0x00             
 * 0x004C[7:0]   OOF2_CLR_THR           0                  0x00             
 * 0x004D[7:0]   OOF3_CLR_THR           0                  0x00             
 * 0x004E[2:0]   OOF0_DETWIN_SEL        5                  0x5              
 * 0x004E[6:4]   OOF1_DETWIN_SEL        0                  0x0              
 * 0x004F[2:0]   OOF2_DETWIN_SEL        0                  0x0              
 * 0x004F[6:4]   OOF3_DETWIN_SEL        0                  0x0              
 * 0x0050[3:0]   OOF_ON_LOS             14                 0xE              
 * 0x0051[3:0]   FAST_OOF0_SET_THR      0                  0x0              
 * 0x0052[3:0]   FAST_OOF1_SET_THR      0                  0x0              
 * 0x0053[3:0]   FAST_OOF2_SET_THR      0                  0x0              
 * 0x0054[3:0]   FAST_OOF3_SET_THR      0                  0x0              
 * 0x0055[3:0]   FAST_OOF0_CLR_THR      0                  0x0              
 * 0x0056[3:0]   FAST_OOF1_CLR_THR      0                  0x0              
 * 0x0057[3:0]   FAST_OOF2_CLR_THR      0                  0x0              
 * 0x0058[3:0]   FAST_OOF3_CLR_THR      0                  0x0              
 * 0x0059[1:0]   FAST_OOF0_DETWIN_SEL   1                  0x1              
 * 0x0059[3:2]   FAST_OOF1_DETWIN_SEL   0                  0x0              
 * 0x0059[5:4]   FAST_OOF2_DETWIN_SEL   0                  0x0              
 * 0x0059[7:6]   FAST_OOF3_DETWIN_SEL   0                  0x0              
 * 0x005A[25:0]  OOF0_RATIO_REF         20793279           0x13D47BF        
 * 0x005E[25:0]  OOF1_RATIO_REF         0                  0x0000000        
 * 0x0062[25:0]  OOF2_RATIO_REF         0                  0x0000000        
 * 0x0066[25:0]  OOF3_RATIO_REF         0                  0x0000000        
 * 0x0092[1]     LOL_FST_EN             1                  0x1              
 * 0x0093[7:4]   LOL_FST_DETWIN_SEL     8                  0x8              
 * 0x0095[3:2]   LOL_FST_VALWIN_SEL     0                  0x0              
 * 0x0096[7:4]   LOL_FST_SET_THR_SEL    6                  0x6              
 * 0x0098[7:4]   LOL_FST_CLR_THR_SEL    4                  0x4              
 * 0x009A[1]     LOL_SLOW_EN_PLL        1                  0x1              
 * 0x009B[7:4]   LOL_SLW_DETWIN_SEL     4                  0x4              
 * 0x009D[3:2]   LOL_SLW_VALWIN_SEL     0                  0x0              
 * 0x009E[7:4]   LOL_SLW_SET_THR        4                  0x4              
 * 0x00A0[7:4]   LOL_SLW_CLR_THR        0                  0x0              
 * 0x00A2[1]     LOL_TIMER_EN           0                  0x0              
 * 0x00A9[28:0]  LOL_CLR_DELAY_DIV256   12772              0x000031E4       
 * 0x00E5[5]     FASTLOCK_EXTEND_EN     1                  0x1              
 * 0x00EA[28:0]  FASTLOCK_EXTEND        6674               0x00001A12       
 * 0x0102[0]     OUTALL_DISABLE_LOW     1                  0x1              
 * 0x0108[0]     OUT0_PDN               0                  0x0              
 * 0x0108[1]     OUT0_OE                1                  0x1              
 * 0x0108[2]     OUT0_RDIV_FORCE2       0                  0x0              
 * 0x0109[2:0]   OUT0_FORMAT            1                  0x1              
 * 0x0109[3]     OUT0_SYNC_EN           1                  0x1              
 * 0x0109[5:4]   OUT0_DIS_STATE         0                  0x0              
 * 0x0109[7:6]   OUT0_CMOS_DRV          0                  0x0              
 * 0x010A[3:0]   OUT0_CM                11                 0xB              
 * 0x010A[6:4]   OUT0_AMPL              3                  0x3              
 * 0x010B[2:0]   OUT0_MUX_SEL           0                  0x0              
 * 0x010B[5:4]   OUT0_VDD_SEL           2                  0x2              
 * 0x010B[3]     OUT0_VDD_SEL_EN        1                  0x1              
 * 0x010B[7:6]   OUT0_INV               0                  0x0              
 * 0x010D[0]     OUT1_PDN               1                  0x1              
 * 0x010D[1]     OUT1_OE                0                  0x0              
 * 0x010D[2]     OUT1_RDIV_FORCE2       0                  0x0              
 * 0x010E[2:0]   OUT1_FORMAT            1                  0x1              
 * 0x010E[3]     OUT1_SYNC_EN           1                  0x1              
 * 0x010E[5:4]   OUT1_DIS_STATE         0                  0x0              
 * 0x010E[7:6]   OUT1_CMOS_DRV          0                  0x0              
 * 0x010F[3:0]   OUT1_CM                11                 0xB              
 * 0x010F[6:4]   OUT1_AMPL              3                  0x3              
 * 0x0110[2:0]   OUT1_MUX_SEL           0                  0x0              
 * 0x0110[5:4]   OUT1_VDD_SEL           2                  0x2              
 * 0x0110[3]     OUT1_VDD_SEL_EN        1                  0x1              
 * 0x0110[7:6]   OUT1_INV               0                  0x0              
 * 0x0112[0]     OUT2_PDN               0                  0x0              
 * 0x0112[1]     OUT2_OE                1                  0x1              
 * 0x0112[2]     OUT2_RDIV_FORCE2       0                  0x0              
 * 0x0113[2:0]   OUT2_FORMAT            1                  0x1              
 * 0x0113[3]     OUT2_SYNC_EN           1                  0x1              
 * 0x0113[5:4]   OUT2_DIS_STATE         0                  0x0              
 * 0x0113[7:6]   OUT2_CMOS_DRV          0                  0x0              
 * 0x0114[3:0]   OUT2_CM                11                 0xB              
 * 0x0114[6:4]   OUT2_AMPL              3                  0x3              
 * 0x0115[2:0]   OUT2_MUX_SEL           0                  0x0              
 * 0x0115[5:4]   OUT2_VDD_SEL           2                  0x2              
 * 0x0115[3]     OUT2_VDD_SEL_EN        1                  0x1              
 * 0x0115[7:6]   OUT2_INV               0                  0x0              
 * 0x0117[0]     OUT3_PDN               1                  0x1              
 * 0x0117[1]     OUT3_OE                0                  0x0              
 * 0x0117[2]     OUT3_RDIV_FORCE2       0                  0x0              
 * 0x0118[2:0]   OUT3_FORMAT            1                  0x1              
 * 0x0118[3]     OUT3_SYNC_EN           1                  0x1              
 * 0x0118[5:4]   OUT3_DIS_STATE         0                  0x0              
 * 0x0118[7:6]   OUT3_CMOS_DRV          0                  0x0              
 * 0x0119[3:0]   OUT3_CM                11                 0xB              
 * 0x0119[6:4]   OUT3_AMPL              3                  0x3              
 * 0x011A[2:0]   OUT3_MUX_SEL           0                  0x0              
 * 0x011A[5:4]   OUT3_VDD_SEL           2                  0x2              
 * 0x011A[3]     OUT3_VDD_SEL_EN        1                  0x1              
 * 0x011A[7:6]   OUT3_INV               0                  0x0              
 * 0x011C[0]     OUT4_PDN               1                  0x1              
 * 0x011C[1]     OUT4_OE                0                  0x0              
 * 0x011C[2]     OUT4_RDIV_FORCE2       0                  0x0              
 * 0x011D[2:0]   OUT4_FORMAT            1                  0x1              
 * 0x011D[3]     OUT4_SYNC_EN           1                  0x1              
 * 0x011D[5:4]   OUT4_DIS_STATE         0                  0x0              
 * 0x011D[7:6]   OUT4_CMOS_DRV          0                  0x0              
 * 0x011E[3:0]   OUT4_CM                11                 0xB              
 * 0x011E[6:4]   OUT4_AMPL              3                  0x3              
 * 0x011F[2:0]   OUT4_MUX_SEL           0                  0x0              
 * 0x011F[5:4]   OUT4_VDD_SEL           2                  0x2              
 * 0x011F[3]     OUT4_VDD_SEL_EN        1                  0x1              
 * 0x011F[7:6]   OUT4_INV               0                  0x0              
 * 0x0121[0]     OUT5_PDN               0                  0x0              
 * 0x0121[1]     OUT5_OE                1                  0x1              
 * 0x0121[2]     OUT5_RDIV_FORCE2       0                  0x0              
 * 0x0122[2:0]   OUT5_FORMAT            1                  0x1              
 * 0x0122[3]     OUT5_SYNC_EN           1                  0x1              
 * 0x0122[5:4]   OUT5_DIS_STATE         0                  0x0              
 * 0x0122[7:6]   OUT5_CMOS_DRV          0                  0x0              
 * 0x0123[3:0]   OUT5_CM                11                 0xB              
 * 0x0123[6:4]   OUT5_AMPL              3                  0x3              
 * 0x0124[2:0]   OUT5_MUX_SEL           1                  0x1              
 * 0x0124[5:4]   OUT5_VDD_SEL           2                  0x2              
 * 0x0124[3]     OUT5_VDD_SEL_EN        1                  0x1              
 * 0x0124[7:6]   OUT5_INV               0                  0x0              
 * 0x0126[0]     OUT6_PDN               1                  0x1              
 * 0x0126[1]     OUT6_OE                0                  0x0              
 * 0x0126[2]     OUT6_RDIV_FORCE2       0                  0x0              
 * 0x0127[2:0]   OUT6_FORMAT            1                  0x1              
 * 0x0127[3]     OUT6_SYNC_EN           1                  0x1              
 * 0x0127[5:4]   OUT6_DIS_STATE         0                  0x0              
 * 0x0127[7:6]   OUT6_CMOS_DRV          0                  0x0              
 * 0x0128[3:0]   OUT6_CM                11                 0xB              
 * 0x0128[6:4]   OUT6_AMPL              3                  0x3              
 * 0x0129[2:0]   OUT6_MUX_SEL           0                  0x0              
 * 0x0129[5:4]   OUT6_VDD_SEL           2                  0x2              
 * 0x0129[3]     OUT6_VDD_SEL_EN        1                  0x1              
 * 0x0129[7:6]   OUT6_INV               0                  0x0              
 * 0x012B[0]     OUT7_PDN               1                  0x1              
 * 0x012B[1]     OUT7_OE                0                  0x0              
 * 0x012B[2]     OUT7_RDIV_FORCE2       0                  0x0              
 * 0x012C[2:0]   OUT7_FORMAT            1                  0x1              
 * 0x012C[3]     OUT7_SYNC_EN           1                  0x1              
 * 0x012C[5:4]   OUT7_DIS_STATE         0                  0x0              
 * 0x012C[7:6]   OUT7_CMOS_DRV          0                  0x0              
 * 0x012D[3:0]   OUT7_CM                11                 0xB              
 * 0x012D[6:4]   OUT7_AMPL              3                  0x3              
 * 0x012E[2:0]   OUT7_MUX_SEL           0                  0x0              
 * 0x012E[5:4]   OUT7_VDD_SEL           2                  0x2              
 * 0x012E[3]     OUT7_VDD_SEL_EN        1                  0x1              
 * 0x012E[7:6]   OUT7_INV               0                  0x0              
 * 0x0130[0]     OUT8_PDN               0                  0x0              
 * 0x0130[1]     OUT8_OE                1                  0x1              
 * 0x0130[2]     OUT8_RDIV_FORCE2       0                  0x0              
 * 0x0131[2:0]   OUT8_FORMAT            1                  0x1              
 * 0x0131[3]     OUT8_SYNC_EN           1                  0x1              
 * 0x0131[5:4]   OUT8_DIS_STATE         0                  0x0              
 * 0x0131[7:6]   OUT8_CMOS_DRV          0                  0x0              
 * 0x0132[3:0]   OUT8_CM                11                 0xB              
 * 0x0132[6:4]   OUT8_AMPL              3                  0x3              
 * 0x0133[2:0]   OUT8_MUX_SEL           2                  0x2              
 * 0x0133[5:4]   OUT8_VDD_SEL           2                  0x2              
 * 0x0133[3]     OUT8_VDD_SEL_EN        1                  0x1              
 * 0x0133[7:6]   OUT8_INV               0                  0x0              
 * 0x013A[0]     OUT9_PDN               1                  0x1              
 * 0x013A[1]     OUT9_OE                0                  0x0              
 * 0x013A[2]     OUT9_RDIV_FORCE2       0                  0x0              
 * 0x013B[2:0]   OUT9_FORMAT            1                  0x1              
 * 0x013B[3]     OUT9_SYNC_EN           1                  0x1              
 * 0x013B[5:4]   OUT9_DIS_STATE         0                  0x0              
 * 0x013B[7:6]   OUT9_CMOS_DRV          0                  0x0              
 * 0x013C[3:0]   OUT9_CM                11                 0xB              
 * 0x013C[6:4]   OUT9_AMPL              3                  0x3              
 * 0x013D[2:0]   OUT9_MUX_SEL           0                  0x0              
 * 0x013D[5:4]   OUT9_VDD_SEL           2                  0x2              
 * 0x013D[3]     OUT9_VDD_SEL_EN        1                  0x1              
 * 0x013D[7:6]   OUT9_INV               0                  0x0              
 * 0x013F[11:0]  OUTX_ALWAYS_ON         0                  0x000            
 * 0x0141[1]     OUT_DIS_MSK            0                  0x0              
 * 0x0141[5]     OUT_DIS_LOL_MSK        0                  0x0              
 * 0x0141[6]     OUT_DIS_LOSXAXB_MSK    1                  0x1              
 * 0x0141[7]     OUT_DIS_MSK_LOS_PFD    0                  0x0              
 * 0x0142[1]     OUT_DIS_MSK_LOL        1                  0x1              
 * 0x0142[5]     OUT_DIS_MSK_HOLD       1                  0x1              
 * 0x0206[1:0]   PXAXB                  0                  0x0              
 * 0x0208[47:0]  P0_NUM                 1                  0x000000000001   
 * 0x020E[31:0]  P0_DEN                 1                  0x00000001       
 * 0x0212[47:0]  P1_NUM                 0                  0x000000000000   
 * 0x0218[31:0]  P1_DEN                 0                  0x00000000       
 * 0x021C[47:0]  P2_NUM                 0                  0x000000000000   
 * 0x0222[31:0]  P2_DEN                 0                  0x00000000       
 * 0x0226[47:0]  P3_NUM                 0                  0x000000000000   
 * 0x022C[31:0]  P3_DEN                 0                  0x00000000       
 * 0x0231[3:0]   P0_FRACN_MODE          11                 0xB              
 * 0x0231[4]     P0_FRACN_EN            0                  0x0              
 * 0x0232[3:0]   P1_FRACN_MODE          11                 0xB              
 * 0x0232[4]     P1_FRACN_EN            0                  0x0              
 * 0x0233[3:0]   P2_FRACN_MODE          11                 0xB              
 * 0x0233[4]     P2_FRACN_EN            0                  0x0              
 * 0x0234[3:0]   P3_FRACN_MODE          11                 0xB              
 * 0x0234[4]     P3_FRACN_EN            0                  0x0              
 * 0x0235[43:0]  MXAXB_NUM              916841299968       0x0D578000000    
 * 0x023B[31:0]  MXAXB_DEN              3489660928         0xD0000000       
 * 0x024A[23:0]  R0_REG                 10                 0x00000A         
 * 0x024D[23:0]  R1_REG                 0                  0x000000         
 * 0x0250[23:0]  R2_REG                 1                  0x000001         
 * 0x0253[23:0]  R3_REG                 0                  0x000000         
 * 0x0256[23:0]  R4_REG                 0                  0x000000         
 * 0x0259[23:0]  R5_REG                 2                  0x000002         
 * 0x025C[23:0]  R6_REG                 0                  0x000000         
 * 0x025F[23:0]  R7_REG                 0                  0x000000         
 * 0x0262[23:0]  R8_REG                 2                  0x000002         
 * 0x0268[23:0]  R9_REG                 0                  0x000000         
 * 0x026B[7:0]   DESIGN_ID0             73                 0x49             
 * 0x026C[7:0]   DESIGN_ID1             79                 0x4F             
 * 0x026D[7:0]   DESIGN_ID2             52                 0x34             
 * 0x026E[7:0]   DESIGN_ID3             75                 0x4B             
 * 0x026F[7:0]   DESIGN_ID4             43                 0x2B             
 * 0x0270[7:0]   DESIGN_ID5             52                 0x34             
 * 0x0271[7:0]   DESIGN_ID6             51                 0x33             
 * 0x0272[7:0]   DESIGN_ID7             68                 0x44             
 * 0x0294[7:4]   FASTLOCK_EXTEND_SCL    8                  0x8              
 * 0x0296[1]     LOL_SLW_VALWIN_SELX    0                  0x0              
 * 0x0297[1]     FASTLOCK_DLY_ONSW_EN   1                  0x1              
 * 0x0299[1]     FASTLOCK_DLY_ONLOL_EN  1                  0x1              
 * 0x029D[19:0]  FASTLOCK_DLY_ONLOL     1802               0x0070A          
 * 0x02A9[19:0]  FASTLOCK_DLY_ONSW      2457               0x00999          
 * 0x02B7[3:2]   LOL_NOSIG_TIME         3                  0x3              
 * 0x0302[43:0]  N0_NUM                 49392123904        0x00B80000000    
 * 0x0308[31:0]  N0_DEN                 2147483648         0x80000000       
 * 0x030C[0]     N0_UPDATE              0                  0x0              
 * 0x030D[43:0]  N1_NUM                 198967296000       0x02E53600000    
 * 0x0313[31:0]  N1_DEN                 2147483648         0x80000000       
 * 0x0317[0]     N1_UPDATE              0                  0x0              
 * 0x0318[43:0]  N2_NUM                 48282730496        0x00B3DE00000    
 * 0x031E[31:0]  N2_DEN                 3145728000         0xBB800000       
 * 0x0322[0]     N2_UPDATE              0                  0x0              
 * 0x0323[43:0]  N3_NUM                 0                  0x00000000000    
 * 0x0329[31:0]  N3_DEN                 0                  0x00000000       
 * 0x032D[0]     N3_UPDATE              0                  0x0              
 * 0x032E[43:0]  N4_NUM                 0                  0x00000000000    
 * 0x0334[31:0]  N4_DEN                 0                  0x00000000       
 * 0x0338[0]     N4_UPDATE              0                  0x0              
 * 0x0338[1]     N_UPDATE               0                  0x0              
 * 0x0339[4:0]   N_FSTEP_MSK            31                 0x1F             
 * 0x033B[43:0]  N0_FSTEPW              0                  0x00000000000    
 * 0x0341[43:0]  N1_FSTEPW              0                  0x00000000000    
 * 0x0347[43:0]  N2_FSTEPW              0                  0x00000000000    
 * 0x034D[43:0]  N3_FSTEPW              0                  0x00000000000    
 * 0x0353[43:0]  N4_FSTEPW              0                  0x00000000000    
 * 0x0359[15:0]  N0_DELAY               0                  0x0000           
 * 0x035B[15:0]  N1_DELAY               0                  0x0000           
 * 0x035D[15:0]  N2_DELAY               0                  0x0000           
 * 0x035F[15:0]  N3_DELAY               0                  0x0000           
 * 0x0361[15:0]  N4_DELAY               0                  0x0000           
 * 0x0487[0]     ZDM_EN                 0                  0x0              
 * 0x0487[2:1]   ZDM_IN_SEL             0                  0x0              
 * 0x0487[4]     ZDM_AUTOSW_EN          0                  0x0              
 * 0x0502[4]     ADD_DIV256             0                  0x0              
 * 0x0508[5:0]   BW0_PLL                18                 0x12             
 * 0x0509[5:0]   BW1_PLL                29                 0x1D             
 * 0x050A[5:0]   BW2_PLL                15                 0x0F             
 * 0x050B[5:0]   BW3_PLL                15                 0x0F             
 * 0x050C[5:0]   BW4_PLL                7                  0x07             
 * 0x050D[5:0]   BW5_PLL                3                  0x03             
 * 0x050E[5:0]   FASTLOCK_BW0_PLL       25                 0x19             
 * 0x050F[5:0]   FASTLOCK_BW1_PLL       45                 0x2D             
 * 0x0510[5:0]   FASTLOCK_BW2_PLL       9                  0x09             
 * 0x0511[5:0]   FASTLOCK_BW3_PLL       8                  0x08             
 * 0x0512[5:0]   FASTLOCK_BW4_PLL       7                  0x07             
 * 0x0513[5:0]   FASTLOCK_BW5_PLL       3                  0x03             
 * 0x0515[55:0]  M_NUM                  466162865405952    0x01A7F900000000 
 * 0x051C[31:0]  M_DEN                  2684354560         0xA0000000       
 * 0x0521[3:0]   M_FRAC_MODE            11                 0xB              
 * 0x0521[4]     M_FRAC_EN              1                  0x1              
 * 0x0521[5]     PLL_OUT_RATE_SEL       1                  0x1              
 * 0x052A[0]     IN_SEL_REGCTRL         1                  0x1              
 * 0x052A[3:1]   IN_SEL                 0                  0x0              
 * 0x052B[0]     FASTLOCK_AUTO_EN       1                  0x1              
 * 0x052B[1]     FASTLOCK_MAN           0                  0x0              
 * 0x052C[0]     HOLD_EN                1                  0x1              
 * 0x052C[3]     HOLD_RAMP_BYP          1                  0x1              
 * 0x052C[4]     HOLDEXIT_BW_SEL1       0                  0x0              
 * 0x052C[7:5]   RAMP_STEP_INTERVAL     0                  0x0              
 * 0x052D[1]     HOLD_RAMPBYP_NOHIST    1                  0x1              
 * 0x052E[4:0]   HOLD_HIST_LEN          23                 0x17             
 * 0x052F[4:0]   HOLD_HIST_DELAY        25                 0x19             
 * 0x0531[4:0]   HOLD_REF_COUNT_FRC     0                  0x00             
 * 0x0532[23:0]  HOLD_15M_CYC_COUNT     105926             0x019DC6         
 * 0x0535[0]     FORCE_HOLD             0                  0x0              
 * 0x0536[1:0]   CLK_SWITCH_MODE        0                  0x0              
 * 0x0536[2]     HSW_EN                 0                  0x0              
 * 0x0537[3:0]   IN_LOS_MSK             0                  0x0              
 * 0x0537[7:4]   IN_OOF_MSK             0                  0x0              
 * 0x0538[2:0]   IN0_PRIORITY           0                  0x0              
 * 0x0538[6:4]   IN1_PRIORITY           0                  0x0              
 * 0x0539[2:0]   IN2_PRIORITY           0                  0x0              
 * 0x0539[6:4]   IN3_PRIORITY           0                  0x0              
 * 0x053A[1:0]   HSW_MODE               2                  0x2              
 * 0x053A[3:2]   HSW_PHMEAS_CTRL        0                  0x0              
 * 0x053B[9:0]   HSW_PHMEAS_THR         3                  0x003            
 * 0x053D[4:0]   HSW_COARSE_PM_LEN      14                 0x0E             
 * 0x053E[4:0]   HSW_COARSE_PM_DLY      6                  0x06             
 * 0x0589[12:0]  CAP_SHORT_DELAY        1734               0x06C6           
 * 0x059B[4]     HOLD_PRESERVE_HIST     1                  0x1              
 * 0x059B[5]     HOLD_FRZ_WITH_INTONLY  1                  0x1              
 * 0x059B[6]     HOLDEXIT_BW_SEL0       1                  0x1              
 * 0x059B[7]     HOLDEXIT_STD_BO        1                  0x1              
 * 0x059D[5:0]   HOLDEXIT_BW0           25                 0x19             
 * 0x059E[5:0]   HOLDEXIT_BW1           45                 0x2D             
 * 0x059F[5:0]   HOLDEXIT_BW2           9                  0x09             
 * 0x05A0[5:0]   HOLDEXIT_BW3           8                  0x08             
 * 0x05A1[5:0]   HOLDEXIT_BW4           7                  0x07             
 * 0x05A2[5:0]   HOLDEXIT_BW5           3                  0x03             
 * 0x05A6[2:0]   RAMP_STEP_SIZE         0                  0x0              
 * 0x05A6[3]     RAMP_SWITCH_EN         0                  0x0              
 * 0x0802[15:0]  FIXREGSA0              1333               0x0535           
 * 0x0804[7:0]   FIXREGSD0              0                  0x00             
 * 0x0805[15:0]  FIXREGSA1              0                  0x0000           
 * 0x0807[7:0]   FIXREGSD1              0                  0x00             
 * 0x0808[15:0]  FIXREGSA2              0                  0x0000           
 * 0x080A[7:0]   FIXREGSD2              0                  0x00             
 * 0x080B[15:0]  FIXREGSA3              0                  0x0000           
 * 0x080D[7:0]   FIXREGSD3              0                  0x00             
 * 0x080E[15:0]  FIXREGSA4              0                  0x0000           
 * 0x0810[7:0]   FIXREGSD4              0                  0x00             
 * 0x0811[15:0]  FIXREGSA5              0                  0x0000           
 * 0x0813[7:0]   FIXREGSD5              0                  0x00             
 * 0x0814[15:0]  FIXREGSA6              0                  0x0000           
 * 0x0816[7:0]   FIXREGSD6              0                  0x00             
 * 0x0817[15:0]  FIXREGSA7              0                  0x0000           
 * 0x0819[7:0]   FIXREGSD7              0                  0x00             
 * 0x081A[15:0]  FIXREGSA8              0                  0x0000           
 * 0x081C[7:0]   FIXREGSD8              0                  0x00             
 * 0x081D[15:0]  FIXREGSA9              0                  0x0000           
 * 0x081F[7:0]   FIXREGSD9              0                  0x00             
 * 0x0820[15:0]  FIXREGSA10             0                  0x0000           
 * 0x0822[7:0]   FIXREGSD10             0                  0x00             
 * 0x0823[15:0]  FIXREGSA11             0                  0x0000           
 * 0x0825[7:0]   FIXREGSD11             0                  0x00             
 * 0x0826[15:0]  FIXREGSA12             0                  0x0000           
 * 0x0828[7:0]   FIXREGSD12             0                  0x00             
 * 0x0829[15:0]  FIXREGSA13             0                  0x0000           
 * 0x082B[7:0]   FIXREGSD13             0                  0x00             
 * 0x082C[15:0]  FIXREGSA14             0                  0x0000           
 * 0x082E[7:0]   FIXREGSD14             0                  0x00             
 * 0x082F[15:0]  FIXREGSA15             0                  0x0000           
 * 0x0831[7:0]   FIXREGSD15             0                  0x00             
 * 0x0832[15:0]  FIXREGSA16             0                  0x0000           
 * 0x0834[7:0]   FIXREGSD16             0                  0x00             
 * 0x0835[15:0]  FIXREGSA17             0                  0x0000           
 * 0x0837[7:0]   FIXREGSD17             0                  0x00             
 * 0x0838[15:0]  FIXREGSA18             0                  0x0000           
 * 0x083A[7:0]   FIXREGSD18             0                  0x00             
 * 0x083B[15:0]  FIXREGSA19             0                  0x0000           
 * 0x083D[7:0]   FIXREGSD19             0                  0x00             
 * 0x083E[15:0]  FIXREGSA20             0                  0x0000           
 * 0x0840[7:0]   FIXREGSD20             0                  0x00             
 * 0x0841[15:0]  FIXREGSA21             0                  0x0000           
 * 0x0843[7:0]   FIXREGSD21             0                  0x00             
 * 0x0844[15:0]  FIXREGSA22             0                  0x0000           
 * 0x0846[7:0]   FIXREGSD22             0                  0x00             
 * 0x0847[15:0]  FIXREGSA23             0                  0x0000           
 * 0x0849[7:0]   FIXREGSD23             0                  0x00             
 * 0x084A[15:0]  FIXREGSA24             0                  0x0000           
 * 0x084C[7:0]   FIXREGSD24             0                  0x00             
 * 0x084D[15:0]  FIXREGSA25             0                  0x0000           
 * 0x084F[7:0]   FIXREGSD25             0                  0x00             
 * 0x0850[15:0]  FIXREGSA26             0                  0x0000           
 * 0x0852[7:0]   FIXREGSD26             0                  0x00             
 * 0x0853[15:0]  FIXREGSA27             0                  0x0000           
 * 0x0855[7:0]   FIXREGSD27             0                  0x00             
 * 0x0856[15:0]  FIXREGSA28             0                  0x0000           
 * 0x0858[7:0]   FIXREGSD28             0                  0x00             
 * 0x0859[15:0]  FIXREGSA29             0                  0x0000           
 * 0x085B[7:0]   FIXREGSD29             0                  0x00             
 * 0x085C[15:0]  FIXREGSA30             0                  0x0000           
 * 0x085E[7:0]   FIXREGSD30             0                  0x00             
 * 0x085F[15:0]  FIXREGSA31             0                  0x0000           
 * 0x0861[7:0]   FIXREGSD31             0                  0x00             
 * 0x090E[0]     XAXB_EXTCLK_EN         1                  0x1              
 * 0x0943[0]     IO_VDD_SEL             0                  0x0              
 * 0x0949[3:0]   IN_EN                  1                  0x1              
 * 0x0949[7:4]   IN_PULSED_CMOS_EN      3                  0x3              
 * 0x094A[3:0]   INX_TO_PFD_EN          1                  0x1              
 * 0x094E[11:0]  REFCLK_HYS_SEL         585                0x249            
 * 0x095E[0]     MXAXB_INTEGER          0                  0x0              
 * 0x0A02[4:0]   N_ADD_0P5              0                  0x00             
 * 0x0A03[4:0]   N_CLK_TO_OUTX_EN       7                  0x07             
 * 0x0A04[4:0]   N_PIBYP                1                  0x01             
 * 0x0A05[4:0]   N_PDNB                 7                  0x07             
 * 0x0A14[3]     N0_HIGH_FREQ           0                  0x0              
 * 0x0A1A[3]     N1_HIGH_FREQ           0                  0x0              
 * 0x0A20[3]     N2_HIGH_FREQ           0                  0x0              
 * 0x0A26[3]     N3_HIGH_FREQ           0                  0x0              
 * 0x0A2C[3]     N4_HIGH_FREQ           0                  0x0              
 * 0x0B44[3:0]   PDIV_FRACN_CLK_DIS     15                 0xF              
 * 0x0B44[5]     FRACN_CLK_DIS_PLL      0                  0x0              
 * 0x0B46[3:0]   LOS_CLK_DIS            0                  0x0              
 * 0x0B47[4:0]   OOF_CLK_DIS            14                 0x0E             
 * 0x0B48[4:0]   OOF_DIV_CLK_DIS        14                 0x0E             
 * 0x0B4A[4:0]   N_CLK_DIS              24                 0x18             
 * 0x0B57[11:0]  VCO_RESET_CALCODE      249                0x0F9
 * 
 *
 */


#if 0
// # Si538x/4x Registers Script
// # 
// # Part: Si5345
// # Project File: C:\12GM_17.4\trunk\FPGA\Source\genlock\FormatFiles\12GM_NTSC_0vK.slabtimeproj
// # Design ID: 12GM_vJ
// # Includes Pre/Post Download Control Register Writes: Yes
// # Die Revision: B1
// # Creator: ClockBuilder Pro v2.15 [2017-05-15]
// # Created On: 2019-03-26 11:08:50 GMT-07:00
// Address,Data
static struct ntv2_genlock_data s_genlock_525_2997[] =
{
	// #
	// # Start configuration preamble
	{ 0x0B24, 0xC0 },
	{ 0x0B25, 0x00 },
	{ 0x0540, 0x01 },
	// # End configuration preamble
	// # 
	// # Delay 300 msec
	// #    Delay is worst case time for device to complete any calibration
	// #    that is running due to device state change previous to this script
	// #    being processed.
	{ 0x0000, 0x01 },
	// # 
	// # Start configuration registers
	{ 0x000B, 0x64 },
	{ 0x0016, 0x02 },
	{ 0x0017, 0xFC },
	{ 0x0018, 0xFF },
	{ 0x0019, 0xDF },
	{ 0x001A, 0xDF },
	{ 0x002B, 0x02 },
	{ 0x002C, 0x01 },
	{ 0x002D, 0x00 },
	{ 0x002E, 0x82 },
	{ 0x002F, 0xCB },
	{ 0x0030, 0x00 },
	{ 0x0031, 0x00 },
	{ 0x0032, 0x00 },
	{ 0x0033, 0x00 },
	{ 0x0034, 0x00 },
	{ 0x0035, 0x00 },
	{ 0x0036, 0x48 },
	{ 0x0037, 0x10 },
	{ 0x0038, 0x00 },
	{ 0x0039, 0x00 },
	{ 0x003A, 0x00 },
	{ 0x003B, 0x00 },
	{ 0x003C, 0x00 },
	{ 0x003D, 0x00 },
	{ 0x003F, 0x00 },
	{ 0x0040, 0x04 },
	{ 0x0041, 0x00 },
	{ 0x0042, 0x00 },
	{ 0x0043, 0x00 },
	{ 0x0044, 0x00 },
	{ 0x0045, 0x0C },
	{ 0x0046, 0x96 },
	{ 0x0047, 0x00 },
	{ 0x0048, 0x00 },
	{ 0x0049, 0x00 },
	{ 0x004A, 0x4B },
	{ 0x004B, 0x00 },
	{ 0x004C, 0x00 },
	{ 0x004D, 0x00 },
	{ 0x004E, 0x05 },
	{ 0x004F, 0x00 },
	{ 0x0051, 0x00 },
	{ 0x0052, 0x00 },
	{ 0x0053, 0x00 },
	{ 0x0054, 0x00 },
	{ 0x0055, 0x00 },
	{ 0x0056, 0x00 },
	{ 0x0057, 0x00 },
	{ 0x0058, 0x00 },
	{ 0x0059, 0x01 },
	{ 0x005A, 0xBF },
	{ 0x005B, 0x47 },
	{ 0x005C, 0x3D },
	{ 0x005D, 0x01 },
	{ 0x005E, 0x00 },
	{ 0x005F, 0x00 },
	{ 0x0060, 0x00 },
	{ 0x0061, 0x00 },
	{ 0x0062, 0x00 },
	{ 0x0063, 0x00 },
	{ 0x0064, 0x00 },
	{ 0x0065, 0x00 },
	{ 0x0066, 0x00 },
	{ 0x0067, 0x00 },
	{ 0x0068, 0x00 },
	{ 0x0069, 0x00 },
	{ 0x0092, 0x02 },
	{ 0x0093, 0x80 },
	{ 0x0095, 0x00 },
	{ 0x0096, 0x60 },
	{ 0x0098, 0x40 },
	{ 0x009A, 0x02 },
	{ 0x009B, 0x40 },
	{ 0x009D, 0x00 },
	{ 0x009E, 0x40 },
	{ 0x00A0, 0x00 },
	{ 0x00A2, 0x00 },
	{ 0x00A9, 0xED },
	{ 0x00AA, 0x24 },
	{ 0x00AB, 0x00 },
	{ 0x00AC, 0x00 },
	{ 0x00E5, 0x21 },
	{ 0x00EA, 0x12 },
	{ 0x00EB, 0x1A },
	{ 0x00EC, 0x00 },
	{ 0x00ED, 0x00 },
	{ 0x0102, 0x01 },
	{ 0x0108, 0x02 },
	{ 0x0109, 0x09 },
	{ 0x010A, 0x3B },
	{ 0x010B, 0x28 },
	{ 0x010D, 0x01 },
	{ 0x010E, 0x09 },
	{ 0x010F, 0x3B },
	{ 0x0110, 0x28 },
	{ 0x0112, 0x02 },
	{ 0x0113, 0x09 },
	{ 0x0114, 0x3B },
	{ 0x0115, 0x28 },
	{ 0x0117, 0x01 },
	{ 0x0118, 0x09 },
	{ 0x0119, 0x3B },
	{ 0x011A, 0x28 },
	{ 0x011C, 0x01 },
	{ 0x011D, 0x09 },
	{ 0x011E, 0x3B },
	{ 0x011F, 0x28 },
	{ 0x0121, 0x02 },
	{ 0x0122, 0x09 },
	{ 0x0123, 0x3B },
	{ 0x0124, 0x29 },
	{ 0x0126, 0x01 },
	{ 0x0127, 0x09 },
	{ 0x0128, 0x3B },
	{ 0x0129, 0x28 },
	{ 0x012B, 0x01 },
	{ 0x012C, 0x09 },
	{ 0x012D, 0x3B },
	{ 0x012E, 0x28 },
	{ 0x0130, 0x02 },
	{ 0x0131, 0x09 },
	{ 0x0132, 0x3B },
	{ 0x0133, 0x2A },
	{ 0x013A, 0x01 },
	{ 0x013B, 0x09 },
	{ 0x013C, 0x3B },
	{ 0x013D, 0x28 },
	{ 0x013F, 0x00 },
	{ 0x0140, 0x00 },
	{ 0x0141, 0x40 },
	{ 0x0142, 0xFF },
	{ 0x0206, 0x00 },
	{ 0x0208, 0x01 },
	{ 0x0209, 0x00 },
	{ 0x020A, 0x00 },
	{ 0x020B, 0x00 },
	{ 0x020C, 0x00 },
	{ 0x020D, 0x00 },
	{ 0x020E, 0x01 },
	{ 0x020F, 0x00 },
	{ 0x0210, 0x00 },
	{ 0x0211, 0x00 },
	{ 0x0212, 0x00 },
	{ 0x0213, 0x00 },
	{ 0x0214, 0x00 },
	{ 0x0215, 0x00 },
	{ 0x0216, 0x00 },
	{ 0x0217, 0x00 },
	{ 0x0218, 0x00 },
	{ 0x0219, 0x00 },
	{ 0x021A, 0x00 },
	{ 0x021B, 0x00 },
	{ 0x021C, 0x00 },
	{ 0x021D, 0x00 },
	{ 0x021E, 0x00 },
	{ 0x021F, 0x00 },
	{ 0x0220, 0x00 },
	{ 0x0221, 0x00 },
	{ 0x0222, 0x00 },
	{ 0x0223, 0x00 },
	{ 0x0224, 0x00 },
	{ 0x0225, 0x00 },
	{ 0x0226, 0x00 },
	{ 0x0227, 0x00 },
	{ 0x0228, 0x00 },
	{ 0x0229, 0x00 },
	{ 0x022A, 0x00 },
	{ 0x022B, 0x00 },
	{ 0x022C, 0x00 },
	{ 0x022D, 0x00 },
	{ 0x022E, 0x00 },
	{ 0x022F, 0x00 },
	{ 0x0231, 0x0B },
	{ 0x0232, 0x0B },
	{ 0x0233, 0x0B },
	{ 0x0234, 0x0B },
	{ 0x0235, 0x00 },
	{ 0x0236, 0x00 },
	{ 0x0237, 0x00 },
	{ 0x0238, 0x78 },
	{ 0x0239, 0xD5 },
	{ 0x023A, 0x00 },
	{ 0x023B, 0x00 },
	{ 0x023C, 0x00 },
	{ 0x023D, 0x00 },
	{ 0x023E, 0xD0 },
	{ 0x024A, 0x0A },
	{ 0x024B, 0x00 },
	{ 0x024C, 0x00 },
	{ 0x024D, 0x00 },
	{ 0x024E, 0x00 },
	{ 0x024F, 0x00 },
	{ 0x0250, 0x01 },
	{ 0x0251, 0x00 },
	{ 0x0252, 0x00 },
	{ 0x0253, 0x00 },
	{ 0x0254, 0x00 },
	{ 0x0255, 0x00 },
	{ 0x0256, 0x00 },
	{ 0x0257, 0x00 },
	{ 0x0258, 0x00 },
	{ 0x0259, 0x02 },
	{ 0x025A, 0x00 },
	{ 0x025B, 0x00 },
	{ 0x025C, 0x00 },
	{ 0x025D, 0x00 },
	{ 0x025E, 0x00 },
	{ 0x025F, 0x00 },
	{ 0x0260, 0x00 },
	{ 0x0261, 0x00 },
	{ 0x0262, 0x02 },
	{ 0x0263, 0x00 },
	{ 0x0264, 0x00 },
	{ 0x0268, 0x00 },
	{ 0x0269, 0x00 },
	{ 0x026A, 0x00 },
	{ 0x026B, 0x31 },
	{ 0x026C, 0x32 },
	{ 0x026D, 0x47 },
	{ 0x026E, 0x4D },
	{ 0x026F, 0x5F },
	{ 0x0270, 0x76 },
	{ 0x0271, 0x4A },
	{ 0x0272, 0x00 },
	{ 0x0294, 0x80 },
	{ 0x0296, 0x00 },
	{ 0x0297, 0x02 },
	{ 0x0299, 0x02 },
	{ 0x029D, 0x0A },
	{ 0x029E, 0x07 },
	{ 0x029F, 0x00 },
	{ 0x02A9, 0x99 },
	{ 0x02AA, 0x09 },
	{ 0x02AB, 0x00 },
	{ 0x02B7, 0xFF },
	{ 0x0302, 0x00 },
	{ 0x0303, 0x00 },
	{ 0x0304, 0x00 },
	{ 0x0305, 0x80 },
	{ 0x0306, 0x0B },
	{ 0x0307, 0x00 },
	{ 0x0308, 0x00 },
	{ 0x0309, 0x00 },
	{ 0x030A, 0x00 },
	{ 0x030B, 0x80 },
	{ 0x030C, 0x00 },
	{ 0x030D, 0x00 },
	{ 0x030E, 0x00 },
	{ 0x030F, 0x60 },
	{ 0x0310, 0x53 },
	{ 0x0311, 0x2E },
	{ 0x0312, 0x00 },
	{ 0x0313, 0x00 },
	{ 0x0314, 0x00 },
	{ 0x0315, 0x00 },
	{ 0x0316, 0x80 },
	{ 0x0317, 0x00 },
	{ 0x0318, 0x00 },
	{ 0x0319, 0x00 },
	{ 0x031A, 0xE0 },
	{ 0x031B, 0x3D },
	{ 0x031C, 0x0B },
	{ 0x031D, 0x00 },
	{ 0x031E, 0x00 },
	{ 0x031F, 0x00 },
	{ 0x0320, 0x80 },
	{ 0x0321, 0xBB },
	{ 0x0322, 0x00 },
	{ 0x0323, 0x00 },
	{ 0x0324, 0x00 },
	{ 0x0325, 0x00 },
	{ 0x0326, 0x00 },
	{ 0x0327, 0x00 },
	{ 0x0328, 0x00 },
	{ 0x0329, 0x00 },
	{ 0x032A, 0x00 },
	{ 0x032B, 0x00 },
	{ 0x032C, 0x00 },
	{ 0x032D, 0x00 },
	{ 0x032E, 0x00 },
	{ 0x032F, 0x00 },
	{ 0x0330, 0x00 },
	{ 0x0331, 0x00 },
	{ 0x0332, 0x00 },
	{ 0x0333, 0x00 },
	{ 0x0334, 0x00 },
	{ 0x0335, 0x00 },
	{ 0x0336, 0x00 },
	{ 0x0337, 0x00 },
	{ 0x0338, 0x00 },
	{ 0x0339, 0x1F },
	{ 0x033B, 0x00 },
	{ 0x033C, 0x00 },
	{ 0x033D, 0x00 },
	{ 0x033E, 0x00 },
	{ 0x033F, 0x00 },
	{ 0x0340, 0x00 },
	{ 0x0341, 0x00 },
	{ 0x0342, 0x00 },
	{ 0x0343, 0x00 },
	{ 0x0344, 0x00 },
	{ 0x0345, 0x00 },
	{ 0x0346, 0x00 },
	{ 0x0347, 0x00 },
	{ 0x0348, 0x00 },
	{ 0x0349, 0x00 },
	{ 0x034A, 0x00 },
	{ 0x034B, 0x00 },
	{ 0x034C, 0x00 },
	{ 0x034D, 0x00 },
	{ 0x034E, 0x00 },
	{ 0x034F, 0x00 },
	{ 0x0350, 0x00 },
	{ 0x0351, 0x00 },
	{ 0x0352, 0x00 },
	{ 0x0353, 0x00 },
	{ 0x0354, 0x00 },
	{ 0x0355, 0x00 },
	{ 0x0356, 0x00 },
	{ 0x0357, 0x00 },
	{ 0x0358, 0x00 },
	{ 0x0359, 0x00 },
	{ 0x035A, 0x00 },
	{ 0x035B, 0x00 },
	{ 0x035C, 0x00 },
	{ 0x035D, 0x00 },
	{ 0x035E, 0x00 },
	{ 0x035F, 0x00 },
	{ 0x0360, 0x00 },
	{ 0x0361, 0x00 },
	{ 0x0362, 0x00 },
	{ 0x0487, 0x00 },
	{ 0x0502, 0x01 },
	{ 0x0508, 0x13 },
	{ 0x0509, 0x1F },
	{ 0x050A, 0x0F },
	{ 0x050B, 0x0E },
	{ 0x050C, 0x07 },
	{ 0x050D, 0x03 },
	{ 0x050E, 0x19 },
	{ 0x050F, 0x2D },
	{ 0x0510, 0x09 },
	{ 0x0511, 0x08 },
	{ 0x0512, 0x07 },
	{ 0x0513, 0x03 },
	{ 0x0515, 0x00 },
	{ 0x0516, 0x00 },
	{ 0x0517, 0x00 },
	{ 0x0518, 0x00 },
	{ 0x0519, 0xF9 },
	{ 0x051A, 0xA7 },
	{ 0x051B, 0x01 },
	{ 0x051C, 0x00 },
	{ 0x051D, 0x00 },
	{ 0x051E, 0x00 },
	{ 0x051F, 0xA0 },
	{ 0x0521, 0x3B },
	{ 0x052A, 0x01 },
	{ 0x052B, 0x01 },
	{ 0x052C, 0xEF },
	{ 0x052D, 0x03 },
	{ 0x052E, 0x15 },
	{ 0x052F, 0x14 },
	{ 0x0531, 0x00 },
	{ 0x0532, 0xC6 },
	{ 0x0533, 0x9D },
	{ 0x0534, 0x01 },
	{ 0x0535, 0x00 },
	{ 0x0536, 0x00 },
	{ 0x0537, 0x00 },
	{ 0x0538, 0x00 },
	{ 0x0539, 0x00 },
	{ 0x053A, 0x02 },
	{ 0x053B, 0x03 },
	{ 0x053C, 0x00 },
	{ 0x053D, 0x0D },
	{ 0x053E, 0x06 },
	{ 0x0589, 0xC6 },
	{ 0x058A, 0x06 },
	{ 0x059B, 0xD8 },
	{ 0x059D, 0x19 },
	{ 0x059E, 0x2D },
	{ 0x059F, 0x09 },
	{ 0x05A0, 0x08 },
	{ 0x05A1, 0x07 },
	{ 0x05A2, 0x03 },
	{ 0x05A6, 0x05 },
	{ 0x0802, 0x35 },
	{ 0x0803, 0x05 },
	{ 0x0804, 0x00 },
	{ 0x0805, 0x00 },
	{ 0x0806, 0x00 },
	{ 0x0807, 0x00 },
	{ 0x0808, 0x00 },
	{ 0x0809, 0x00 },
	{ 0x080A, 0x00 },
	{ 0x080B, 0x00 },
	{ 0x080C, 0x00 },
	{ 0x080D, 0x00 },
	{ 0x080E, 0x00 },
	{ 0x080F, 0x00 },
	{ 0x0810, 0x00 },
	{ 0x0811, 0x00 },
	{ 0x0812, 0x00 },
	{ 0x0813, 0x00 },
	{ 0x0814, 0x00 },
	{ 0x0815, 0x00 },
	{ 0x0816, 0x00 },
	{ 0x0817, 0x00 },
	{ 0x0818, 0x00 },
	{ 0x0819, 0x00 },
	{ 0x081A, 0x00 },
	{ 0x081B, 0x00 },
	{ 0x081C, 0x00 },
	{ 0x081D, 0x00 },
	{ 0x081E, 0x00 },
	{ 0x081F, 0x00 },
	{ 0x0820, 0x00 },
	{ 0x0821, 0x00 },
	{ 0x0822, 0x00 },
	{ 0x0823, 0x00 },
	{ 0x0824, 0x00 },
	{ 0x0825, 0x00 },
	{ 0x0826, 0x00 },
	{ 0x0827, 0x00 },
	{ 0x0828, 0x00 },
	{ 0x0829, 0x00 },
	{ 0x082A, 0x00 },
	{ 0x082B, 0x00 },
	{ 0x082C, 0x00 },
	{ 0x082D, 0x00 },
	{ 0x082E, 0x00 },
	{ 0x082F, 0x00 },
	{ 0x0830, 0x00 },
	{ 0x0831, 0x00 },
	{ 0x0832, 0x00 },
	{ 0x0833, 0x00 },
	{ 0x0834, 0x00 },
	{ 0x0835, 0x00 },
	{ 0x0836, 0x00 },
	{ 0x0837, 0x00 },
	{ 0x0838, 0x00 },
	{ 0x0839, 0x00 },
	{ 0x083A, 0x00 },
	{ 0x083B, 0x00 },
	{ 0x083C, 0x00 },
	{ 0x083D, 0x00 },
	{ 0x083E, 0x00 },
	{ 0x083F, 0x00 },
	{ 0x0840, 0x00 },
	{ 0x0841, 0x00 },
	{ 0x0842, 0x00 },
	{ 0x0843, 0x00 },
	{ 0x0844, 0x00 },
	{ 0x0845, 0x00 },
	{ 0x0846, 0x00 },
	{ 0x0847, 0x00 },
	{ 0x0848, 0x00 },
	{ 0x0849, 0x00 },
	{ 0x084A, 0x00 },
	{ 0x084B, 0x00 },
	{ 0x084C, 0x00 },
	{ 0x084D, 0x00 },
	{ 0x084E, 0x00 },
	{ 0x084F, 0x00 },
	{ 0x0850, 0x00 },
	{ 0x0851, 0x00 },
	{ 0x0852, 0x00 },
	{ 0x0853, 0x00 },
	{ 0x0854, 0x00 },
	{ 0x0855, 0x00 },
	{ 0x0856, 0x00 },
	{ 0x0857, 0x00 },
	{ 0x0858, 0x00 },
	{ 0x0859, 0x00 },
	{ 0x085A, 0x00 },
	{ 0x085B, 0x00 },
	{ 0x085C, 0x00 },
	{ 0x085D, 0x00 },
	{ 0x085E, 0x00 },
	{ 0x085F, 0x00 },
	{ 0x0860, 0x00 },
	{ 0x0861, 0x00 },
	{ 0x090E, 0x03 },
	{ 0x0943, 0x00 },
	{ 0x0949, 0x31 },
	{ 0x094A, 0x01 },
	{ 0x094E, 0x49 },
	{ 0x094F, 0x02 },
	{ 0x095E, 0x00 },
	{ 0x0A02, 0x00 },
	{ 0x0A03, 0x07 },
	{ 0x0A04, 0x01 },
	{ 0x0A05, 0x07 },
	{ 0x0B44, 0x0F },
	{ 0x0B46, 0x00 },
	{ 0x0B47, 0x00 },
	{ 0x0B48, 0x0F },
	{ 0x0B4A, 0x18 },
	{ 0x0B57, 0xF9 },
	{ 0x0B58, 0x00 },
	//# End configuration registers
	//# 
	//# Start configuration postamble
	{ 0x0514, 0x01 },
	{ 0x001C, 0x01 },
	{ 0x0540, 0x00 },
	{ 0x0B24, 0xC3 },
	{ 0x0B25, 0x02 },
	//# End configuration postamble
	{ 0x0000, 0x00 }
};
#endif

#if 0
static struct ntv2_genlock_data s_genlock_525_2997[] =
{
	/* Start configuration preamble */
	{ 0x0B24, 0xC0 },
	{ 0x0B25, 0x00 },
	{ 0x0540, 0x01 },
	/* End configuration preamble */

	/* Delay 300 msec */
	/*    Delay is worst case time for device to complete any calibration */
	/*    that is running due to device state change previous to this script */
	/*    being processed. */
	{ 0x0000, 0x01 },

	/* Start configuration registers */
	{ 0x000B, 0x64 },
	{ 0x0016, 0x02 },
	{ 0x0017, 0xFC },
	{ 0x0018, 0xFF },
	{ 0x0019, 0xDF },
	{ 0x001A, 0xDF },
	{ 0x002B, 0x02 },
	{ 0x002C, 0x01 },
	{ 0x002D, 0x02 },
	{ 0x002E, 0x48 },
	{ 0x002F, 0x10 },
	{ 0x0030, 0x00 },
	{ 0x0031, 0x00 },
	{ 0x0032, 0x00 },
	{ 0x0033, 0x00 },
	{ 0x0034, 0x00 },
	{ 0x0035, 0x00 },
	{ 0x0036, 0xED },
	{ 0x0037, 0x0E },
	{ 0x0038, 0x00 },
	{ 0x0039, 0x00 },
	{ 0x003A, 0x00 },
	{ 0x003B, 0x00 },
	{ 0x003C, 0x00 },
	{ 0x003D, 0x00 },
	{ 0x003F, 0x01 },
	{ 0x0040, 0x04 },
	{ 0x0041, 0x00 },
	{ 0x0042, 0x00 },
	{ 0x0043, 0x00 },
	{ 0x0044, 0x00 },
	{ 0x0045, 0x0C },
	{ 0x0046, 0x96 },
	{ 0x0047, 0x00 },
	{ 0x0048, 0x00 },
	{ 0x0049, 0x00 },
	{ 0x004A, 0x4B },
	{ 0x004B, 0x00 },
	{ 0x004C, 0x00 },
	{ 0x004D, 0x00 },
	{ 0x004E, 0x05 },
	{ 0x004F, 0x00 },
	{ 0x0050, 0x0F },
	{ 0x0051, 0x00 },
	{ 0x0052, 0x00 },
	{ 0x0053, 0x00 },
	{ 0x0054, 0x00 },
	{ 0x0055, 0x00 },
	{ 0x0056, 0x00 },
	{ 0x0057, 0x00 },
	{ 0x0058, 0x00 },
	{ 0x0059, 0x01 },
	{ 0x005A, 0xBF },
	{ 0x005B, 0x47 },
	{ 0x005C, 0x3D },
	{ 0x005D, 0x01 },
	{ 0x005E, 0x00 },
	{ 0x005F, 0x00 },
	{ 0x0060, 0x00 },
	{ 0x0061, 0x00 },
	{ 0x0062, 0x00 },
	{ 0x0063, 0x00 },
	{ 0x0064, 0x00 },
	{ 0x0065, 0x00 },
	{ 0x0066, 0x00 },
	{ 0x0067, 0x00 },
	{ 0x0068, 0x00 },
	{ 0x0069, 0x00 },
	{ 0x0092, 0x02 },
	{ 0x0093, 0xA0 },
	{ 0x0095, 0x00 },
	{ 0x0096, 0x90 },
	{ 0x0098, 0x70 },
	{ 0x009A, 0x02 },
	{ 0x009B, 0x50 },
	{ 0x009D, 0x04 },
	{ 0x009E, 0x60 },
	{ 0x00A0, 0x30 },
	{ 0x00A2, 0x00 },
	{ 0x00A9, 0x8D },
	{ 0x00AA, 0x8C },
	{ 0x00AB, 0x04 },
	{ 0x00AC, 0x00 },
	{ 0x00E5, 0x21 },
	{ 0x00EA, 0xD1 },
	{ 0x00EB, 0xB1 },
	{ 0x00EC, 0x03 },
	{ 0x00ED, 0x00 },
	{ 0x0102, 0x01 },
	{ 0x0108, 0x02 },
	{ 0x0109, 0x09 },
	{ 0x010A, 0x3B },
	{ 0x010B, 0x28 },
	{ 0x010D, 0x01 },
	{ 0x010E, 0x09 },
	{ 0x010F, 0x3B },
	{ 0x0110, 0x28 },
	{ 0x0112, 0x02 },
	{ 0x0113, 0x09 },
	{ 0x0114, 0x3B },
	{ 0x0115, 0x28 },
	{ 0x0117, 0x01 },
	{ 0x0118, 0x09 },
	{ 0x0119, 0x3B },
	{ 0x011A, 0x28 },
	{ 0x011C, 0x01 },
	{ 0x011D, 0x09 },
	{ 0x011E, 0x3B },
	{ 0x011F, 0x28 },
	{ 0x0121, 0x02 },
	{ 0x0122, 0x09 },
	{ 0x0123, 0x3B },
	{ 0x0124, 0x29 },
	{ 0x0126, 0x01 },
	{ 0x0127, 0x09 },
	{ 0x0128, 0x3B },
	{ 0x0129, 0x28 },
	{ 0x012B, 0x01 },
	{ 0x012C, 0x09 },
	{ 0x012D, 0x3B },
	{ 0x012E, 0x28 },
	{ 0x0130, 0x02 },
	{ 0x0131, 0x09 },
	{ 0x0132, 0x3B },
	{ 0x0133, 0x2A },
	{ 0x013A, 0x01 },
	{ 0x013B, 0x09 },
	{ 0x013C, 0x3B },
	{ 0x013D, 0x28 },
	{ 0x013F, 0x00 },
	{ 0x0140, 0x00 },
	{ 0x0141, 0x40 },
	{ 0x0142, 0xFF },
	{ 0x0206, 0x00 },
	{ 0x0208, 0x01 },
	{ 0x0209, 0x00 },
	{ 0x020A, 0x00 },
	{ 0x020B, 0x00 },
	{ 0x020C, 0x00 },
	{ 0x020D, 0x00 },
	{ 0x020E, 0x01 },
	{ 0x020F, 0x00 },
	{ 0x0210, 0x00 },
	{ 0x0211, 0x00 },
	{ 0x0212, 0x00 },
	{ 0x0213, 0x00 },
	{ 0x0214, 0x00 },
	{ 0x0215, 0x00 },
	{ 0x0216, 0x00 },
	{ 0x0217, 0x00 },
	{ 0x0218, 0x00 },
	{ 0x0219, 0x00 },
	{ 0x021A, 0x00 },
	{ 0x021B, 0x00 },
	{ 0x021C, 0x00 },
	{ 0x021D, 0x00 },
	{ 0x021E, 0x00 },
	{ 0x021F, 0x00 },
	{ 0x0220, 0x00 },
	{ 0x0221, 0x00 },
	{ 0x0222, 0x00 },
	{ 0x0223, 0x00 },
	{ 0x0224, 0x00 },
	{ 0x0225, 0x00 },
	{ 0x0226, 0x00 },
	{ 0x0227, 0x00 },
	{ 0x0228, 0x00 },
	{ 0x0229, 0x00 },
	{ 0x022A, 0x00 },
	{ 0x022B, 0x00 },
	{ 0x022C, 0x00 },
	{ 0x022D, 0x00 },
	{ 0x022E, 0x00 },
	{ 0x022F, 0x00 },
	{ 0x0231, 0x0B },
	{ 0x0232, 0x0B },
	{ 0x0233, 0x0B },
	{ 0x0234, 0x0B },
	{ 0x0235, 0x00 },
	{ 0x0236, 0x00 },
	{ 0x0237, 0x00 },
	{ 0x0238, 0x78 },
	{ 0x0239, 0xD5 },
	{ 0x023A, 0x00 },
	{ 0x023B, 0x00 },
	{ 0x023C, 0x00 },
	{ 0x023D, 0x00 },
	{ 0x023E, 0xD0 },
	{ 0x024A, 0x0A },
	{ 0x024B, 0x00 },
	{ 0x024C, 0x00 },
	{ 0x024D, 0x00 },
	{ 0x024E, 0x00 },
	{ 0x024F, 0x00 },
	{ 0x0250, 0x01 },
	{ 0x0251, 0x00 },
	{ 0x0252, 0x00 },
	{ 0x0253, 0x00 },
	{ 0x0254, 0x00 },
	{ 0x0255, 0x00 },
	{ 0x0256, 0x00 },
	{ 0x0257, 0x00 },
	{ 0x0258, 0x00 },
	{ 0x0259, 0x02 },
	{ 0x025A, 0x00 },
	{ 0x025B, 0x00 },
	{ 0x025C, 0x00 },
	{ 0x025D, 0x00 },
	{ 0x025E, 0x00 },
	{ 0x025F, 0x00 },
	{ 0x0260, 0x00 },
	{ 0x0261, 0x00 },
	{ 0x0262, 0x02 },
	{ 0x0263, 0x00 },
	{ 0x0264, 0x00 },
	{ 0x0268, 0x00 },
	{ 0x0269, 0x00 },
	{ 0x026A, 0x00 },
	{ 0x026B, 0x49 },
	{ 0x026C, 0x4F },
	{ 0x026D, 0x34 },
	{ 0x026E, 0x4B },
	{ 0x026F, 0x2B },
	{ 0x0270, 0x00 },
	{ 0x0271, 0x00 },
	{ 0x0272, 0x00 },
	{ 0x0294, 0x80 },
	{ 0x0296, 0x00 },
	{ 0x0297, 0x02 },
	{ 0x0299, 0x02 },
	{ 0x029D, 0xF5 },
	{ 0x029E, 0x0E },
	{ 0x029F, 0x00 },
	{ 0x02A9, 0x66 },
	{ 0x02AA, 0x26 },
	{ 0x02AB, 0x00 },
	{ 0x02B7, 0xFF },
	{ 0x0302, 0x00 },
	{ 0x0303, 0x00 },
	{ 0x0304, 0x00 },
	{ 0x0305, 0x80 },
	{ 0x0306, 0x0B },
	{ 0x0307, 0x00 },
	{ 0x0308, 0x00 },
	{ 0x0309, 0x00 },
	{ 0x030A, 0x00 },
	{ 0x030B, 0x80 },
	{ 0x030C, 0x00 },
	{ 0x030D, 0x00 },
	{ 0x030E, 0x00 },
	{ 0x030F, 0x60 },
	{ 0x0310, 0x53 },
	{ 0x0311, 0x2E },
	{ 0x0312, 0x00 },
	{ 0x0313, 0x00 },
	{ 0x0314, 0x00 },
	{ 0x0315, 0x00 },
	{ 0x0316, 0x80 },
	{ 0x0317, 0x00 },
	{ 0x0318, 0x00 },
	{ 0x0319, 0x00 },
	{ 0x031A, 0xE0 },
	{ 0x031B, 0x3D },
	{ 0x031C, 0x0B },
	{ 0x031D, 0x00 },
	{ 0x031E, 0x00 },
	{ 0x031F, 0x00 },
	{ 0x0320, 0x80 },
	{ 0x0321, 0xBB },
	{ 0x0322, 0x00 },
	{ 0x0323, 0x00 },
	{ 0x0324, 0x00 },
	{ 0x0325, 0x00 },
	{ 0x0326, 0x00 },
	{ 0x0327, 0x00 },
	{ 0x0328, 0x00 },
	{ 0x0329, 0x00 },
	{ 0x032A, 0x00 },
	{ 0x032B, 0x00 },
	{ 0x032C, 0x00 },
	{ 0x032D, 0x00 },
	{ 0x032E, 0x00 },
	{ 0x032F, 0x00 },
	{ 0x0330, 0x00 },
	{ 0x0331, 0x00 },
	{ 0x0332, 0x00 },
	{ 0x0333, 0x00 },
	{ 0x0334, 0x00 },
	{ 0x0335, 0x00 },
	{ 0x0336, 0x00 },
	{ 0x0337, 0x00 },
	{ 0x0338, 0x00 },
	{ 0x0339, 0x1F },
	{ 0x033B, 0x00 },
	{ 0x033C, 0x00 },
	{ 0x033D, 0x00 },
	{ 0x033E, 0x00 },
	{ 0x033F, 0x00 },
	{ 0x0340, 0x00 },
	{ 0x0341, 0x00 },
	{ 0x0342, 0x00 },
	{ 0x0343, 0x00 },
	{ 0x0344, 0x00 },
	{ 0x0345, 0x00 },
	{ 0x0346, 0x00 },
	{ 0x0347, 0x00 },
	{ 0x0348, 0x00 },
	{ 0x0349, 0x00 },
	{ 0x034A, 0x00 },
	{ 0x034B, 0x00 },
	{ 0x034C, 0x00 },
	{ 0x034D, 0x00 },
	{ 0x034E, 0x00 },
	{ 0x034F, 0x00 },
	{ 0x0350, 0x00 },
	{ 0x0351, 0x00 },
	{ 0x0352, 0x00 },
	{ 0x0353, 0x00 },
	{ 0x0354, 0x00 },
	{ 0x0355, 0x00 },
	{ 0x0356, 0x00 },
	{ 0x0357, 0x00 },
	{ 0x0358, 0x00 },
	{ 0x0359, 0x00 },
	{ 0x035A, 0x00 },
	{ 0x035B, 0x00 },
	{ 0x035C, 0x00 },
	{ 0x035D, 0x00 },
	{ 0x035E, 0x00 },
	{ 0x035F, 0x00 },
	{ 0x0360, 0x00 },
	{ 0x0361, 0x00 },
	{ 0x0362, 0x00 },
	{ 0x0487, 0x00 },
	{ 0x0502, 0x01 },
	{ 0x0508, 0x10 },
	{ 0x0509, 0x18 },
	{ 0x050A, 0x0F },
	{ 0x050B, 0x0F },
	{ 0x050C, 0x07 },
	{ 0x050D, 0x07 },
	{ 0x050E, 0x17 },
	{ 0x050F, 0x28 },
	{ 0x0510, 0x0C },
	{ 0x0511, 0x0B },
	{ 0x0512, 0x07 },
	{ 0x0513, 0x07 },
	{ 0x0515, 0x00 },
	{ 0x0516, 0x00 },
	{ 0x0517, 0x00 },
	{ 0x0518, 0x00 },
	{ 0x0519, 0xF9 },
	{ 0x051A, 0xA7 },
	{ 0x051B, 0x01 },
	{ 0x051C, 0x00 },
	{ 0x051D, 0x00 },
	{ 0x051E, 0x00 },
	{ 0x051F, 0xA0 },
	{ 0x0521, 0x3B },
	{ 0x052A, 0x01 },
	{ 0x052B, 0x01 },
	{ 0x052C, 0x0f },  // 0xE7
	{ 0x052D, 0x03 },
	{ 0x052E, 0x15 },
	{ 0x052F, 0x14 },
	{ 0x0531, 0x00 },
	{ 0x0532, 0xC6 },
	{ 0x0533, 0x9D },
	{ 0x0534, 0x01 },
	{ 0x0535, 0x00 },
	{ 0x0536, 0x00 },
	{ 0x0537, 0x00 },
	{ 0x0538, 0x00 },
	{ 0x0539, 0x00 },
	{ 0x053A, 0x02 },
	{ 0x053B, 0x03 },
	{ 0x053C, 0x00 },
	{ 0x053D, 0x11 },
	{ 0x053E, 0x06 },
	{ 0x0589, 0xC6 },
	{ 0x058A, 0x06 },
	{ 0x059B, 0xF8 },
	{ 0x059D, 0x17 },
	{ 0x059E, 0x28 },
	{ 0x059F, 0x0C },
	{ 0x05A0, 0x0B },
	{ 0x05A1, 0x07 },
	{ 0x05A2, 0x07 },
	{ 0x05A6, 0x00 },  // 0x05
	{ 0x0802, 0x35 },
	{ 0x0803, 0x05 },
	{ 0x0804, 0x00 },
	{ 0x0805, 0x00 },
	{ 0x0806, 0x00 },
	{ 0x0807, 0x00 },
	{ 0x0808, 0x00 },
	{ 0x0809, 0x00 },
	{ 0x080A, 0x00 },
	{ 0x080B, 0x00 },
	{ 0x080C, 0x00 },
	{ 0x080D, 0x00 },
	{ 0x080E, 0x00 },
	{ 0x080F, 0x00 },
	{ 0x0810, 0x00 },
	{ 0x0811, 0x00 },
	{ 0x0812, 0x00 },
	{ 0x0813, 0x00 },
	{ 0x0814, 0x00 },
	{ 0x0815, 0x00 },
	{ 0x0816, 0x00 },
	{ 0x0817, 0x00 },
	{ 0x0818, 0x00 },
	{ 0x0819, 0x00 },
	{ 0x081A, 0x00 },
	{ 0x081B, 0x00 },
	{ 0x081C, 0x00 },
	{ 0x081D, 0x00 },
	{ 0x081E, 0x00 },
	{ 0x081F, 0x00 },
	{ 0x0820, 0x00 },
	{ 0x0821, 0x00 },
	{ 0x0822, 0x00 },
	{ 0x0823, 0x00 },
	{ 0x0824, 0x00 },
	{ 0x0825, 0x00 },
	{ 0x0826, 0x00 },
	{ 0x0827, 0x00 },
	{ 0x0828, 0x00 },
	{ 0x0829, 0x00 },
	{ 0x082A, 0x00 },
	{ 0x082B, 0x00 },
	{ 0x082C, 0x00 },
	{ 0x082D, 0x00 },
	{ 0x082E, 0x00 },
	{ 0x082F, 0x00 },
	{ 0x0830, 0x00 },
	{ 0x0831, 0x00 },
	{ 0x0832, 0x00 },
	{ 0x0833, 0x00 },
	{ 0x0834, 0x00 },
	{ 0x0835, 0x00 },
	{ 0x0836, 0x00 },
	{ 0x0837, 0x00 },
	{ 0x0838, 0x00 },
	{ 0x0839, 0x00 },
	{ 0x083A, 0x00 },
	{ 0x083B, 0x00 },
	{ 0x083C, 0x00 },
	{ 0x083D, 0x00 },
	{ 0x083E, 0x00 },
	{ 0x083F, 0x00 },
	{ 0x0840, 0x00 },
	{ 0x0841, 0x00 },
	{ 0x0842, 0x00 },
	{ 0x0843, 0x00 },
	{ 0x0844, 0x00 },
	{ 0x0845, 0x00 },
	{ 0x0846, 0x00 },
	{ 0x0847, 0x00 },
	{ 0x0848, 0x00 },
	{ 0x0849, 0x00 },
	{ 0x084A, 0x00 },
	{ 0x084B, 0x00 },
	{ 0x084C, 0x00 },
	{ 0x084D, 0x00 },
	{ 0x084E, 0x00 },
	{ 0x084F, 0x00 },
	{ 0x0850, 0x00 },
	{ 0x0851, 0x00 },
	{ 0x0852, 0x00 },
	{ 0x0853, 0x00 },
	{ 0x0854, 0x00 },
	{ 0x0855, 0x00 },
	{ 0x0856, 0x00 },
	{ 0x0857, 0x00 },
	{ 0x0858, 0x00 },
	{ 0x0859, 0x00 },
	{ 0x085A, 0x00 },
	{ 0x085B, 0x00 },
	{ 0x085C, 0x00 },
	{ 0x085D, 0x00 },
	{ 0x085E, 0x00 },
	{ 0x085F, 0x00 },
	{ 0x0860, 0x00 },
	{ 0x0861, 0x00 },
	{ 0x090E, 0x03 },
	{ 0x0943, 0x00 },
	{ 0x0949, 0x31 },
	{ 0x094A, 0x01 },
	{ 0x094E, 0x49 },
	{ 0x094F, 0x02 },
	{ 0x095E, 0x00 },
	{ 0x0A02, 0x00 },
	{ 0x0A03, 0x07 },
	{ 0x0A04, 0x01 },
	{ 0x0A05, 0x07 },
	{ 0x0A14, 0x00 },
	{ 0x0A1A, 0x00 },
	{ 0x0A20, 0x00 },
	{ 0x0A26, 0x00 },
	{ 0x0A2C, 0x00 },
	{ 0x0B44, 0x0F },
	{ 0x0B46, 0x00 },
	{ 0x0B47, 0x0E },
	{ 0x0B48, 0x0E },
	{ 0x0B4A, 0x18 },
	{ 0x0B57, 0xF9 },
	{ 0x0B58, 0x00 },
	/* End configuration registers */

	/* Start configuration postamble */
	{ 0x0514, 0x01 },
	{ 0x001C, 0x01 },
	{ 0x0540, 0x00 },
	{ 0x0B24, 0xC3 },
	{ 0x0B25, 0x02 },
	/* End configuration postamble */

	{ 0x0000, 0x00 }
};
#endif
/*
 * Design Report
 *
 * Overview
 * ========
 * Part:         Si5345 Rev D
 * Project File: C:\XilinxProjects\flint_tr051017\genlock\FormatFiles\IO4K+_VIC6_720x480i59.94.slabtimeproj
 * Design ID:    IO4K+
 * Created By:   ClockBuilder Pro v2.16.1 [2017-07-19]
 * Timestamp:    2017-08-24 15:58:16 GMT-07:00
 * 
 * Design Notes
 * ============
 * assumes NTSC HSYNC (pulsed) input = (30/1.001)*525
 * 
 * Design Rule Check
 * =================
 * Errors:
 * - No errors
 * 
 * Warnings:
 * - Pulsed LVCMOS input buffer mode has been selected. This mode has non-standard input voltage logic thresholds: 0.33 V for Vil (max) and 0.49 V for Vih (min). Select this mode only if your input clock has a duty cycle significantly less or more than 50%.  Refer to the device datasheet for the exact threshold voltage specifications and the input attenuator circuit (DC coupled Pulsed LVCMOS) in the Family Reference Manual.
 * 
 * Device Grade
 * ============
 * Maximum Output Frequency: 148.5 MHz
 * Frequency Synthesis Mode: Fractional
 * Minimum Base OPN:         Si5345B
 * Actual Base OPN:          Si5345B
 * 
 * Base       Output Clock         Supported Frequency Synthesis Modes
 * OPN Grade  Frequency Range      (Typical Jitter)
 * ---------  -------------------  --------------------------------------------
 * Si5345A    100 Hz to 1.028 GHz  Integer (< 100 fs) and fractional (< 150 fs)
 * Si5345B    100 Hz to 350 MHz    "
 * Si5345C    100 Hz to 1.028 GHz  Integer only (< 100 fs)
 * Si5345D    100 Hz to 350 MHz    "
 * 
 * Design
 * ======
 * Host Interface:
 *    I/O Power Supply: VDD (Core)
 *    SPI Mode: 4-Wire
 *    I2C Address Range: 100d to 103d / 0x64 to 0x67 (selected via A0/A1 pins)
 * 
 * XA/XB:
 *    52 MHz (XO - External Oscillator)
 * 
 * Inputs:
 *     IN0: 15.7342657342657342... kHz [ 15 + 105/143 kHz ]
 *          [ (30/1.001)*525 ]
 *          Pulsed LVCMOS
 *     IN1: Unused
 *     IN2: Unused
 *     IN3: Unused
 * 
 * Outputs:
 *    OUT0: 27 MHz
 *          Enabled, LVDS 2.5 V
 *    OUT1: Unused
 *    OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT3: Unused
 *    OUT4: Unused
 *    OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT6: Unused
 *    OUT7: Unused
 *    OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *          [ 148.5/1.001 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT9: Unused
 * 
 * Frequency Plan
 * ==============
 * Priority: maximize the number of low jitter outputs
 * 
 * Fvco = 13.662 GHz [ 13 + 331/500 GHz ]
 * Fpfd = 15.7342657342657342... kHz [ 15 + 105/143 kHz ]
 * Fms0 = 594 MHz
 * Fms1 = 147.456 MHz [ 147 + 57/125 MHz ]
 * Fms2 = 890.1098901098901098... MHz [ 890 + 10/91 MHz ]
 * 
 * P dividers:
 *    P0  = 1
 *    P1  = Unused
 *    P2  = Unused
 *    P3  = Unused
 *    Pxaxb = 1
 * 
 * MXAXB = 262.7307692307692307... [ 262 + 19/26 ]
 * M = 173659.2 [ 173659 + 1/5 ]
 * N dividers:
 *    N0:
 *       Value: 23
 *       Skew:  0.000 s
 *       OUT0: 27 MHz
 *       OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *    N1:
 *       Value: 92.6513671875 [ 92 + 667/1024 ]
 *       Skew:  0.000 s
 *       OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *    N2:
 *       Value: 15.3486666666666666... [ 15 + 523/1500 ]
 *       Skew:  0.000 s
 *       OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *    N3:
 *       Unused
 *    N4:
 *       Unused
 * 
 * R dividers:
 *    R0 = 22
 *    R1 = Unused
 *    R2 = 4
 *    R3 = Unused
 *    R4 = Unused
 *    R5 = 6
 *    R6 = Unused
 *    R7 = Unused
 *    R8 = 6
 *    R9 = Unused
 * 
 * Nominal Bandwidth:
 *   Desired: 1.000 Hz
 *   Actual:  607.038 mHz
 *   Coefficients:
 *      BW0:  16
 *      BW1:  24
 *      BW2:  15
 *      BW3:  15
 *      BW4:  7
 *      BW5:  7
 * Fastlock Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  99.189 Hz
 *   Coefficients:
 *      BW0:  23
 *      BW1:  40
 *      BW2:  12
 *      BW3:  11
 *      BW4:  7
 *      BW5:  7
 * Holdover Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  99.189 Hz
 *   Coefficients:
 *      BW0:  23
 *      BW1:  40
 *      BW2:  12
 *      BW3:  11
 *      BW4:  7
 *      BW5:  7
 * 
 * Dividers listed above show effective values. These values are translated to register settings by ClockBuilder Pro. For the actual register values, see below. Refer to the Family Reference Manual for information on registers related to frequency plan.
 * 
 * Digitally Controlled Oscillator (DCO)
 * =====================================
 * Mode: Register Direct Write
 * 
 * N0: DCO Disabled
 * 
 * N1: DCO Disabled
 * 
 * N2: DCO Disabled
 * 
 * N3: DCO Disabled
 * 
 * N4: DCO Disabled
 * 
 * Estimated Power & Junction Temperature
 * ======================================
 * Assumptions:
 * 
 * Revision: D
 * VDD:      1.8 V
 * Ta:       70 C
 * Airflow:  None
 * 
 * Total Power: 808 mW, On Chip Power: 784 mW, Tj: 87 C
 * 
 *                 Frequency  Format   Voltage   Current     Power
 *         -----------------  ------  --------  --------  --------
 * VDD                                   1.8 V  147.9 mA    266 mW
 * VDDA                                  3.3 V  117.4 mA    387 mW
 * VDDO0              27 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO1              Unused                                      
 * VDDO2           148.5 MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO3              Unused                                      
 * VDDO4              Unused                                      
 * VDDO5          24.576 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO6              Unused                                      
 * VDDO7              Unused                                      
 * VDDO8   148.351648... MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO9              Unused                                      
 *                                              --------  --------
 *                                       Total  327.2 mA    808 mW
 * 
 * Note:
 * 
 * -Total power includes on- and off-chip power. This is a typical value and estimate only.
 * -Use an EVB for a more exact power measurement
 * -On-chip power excludes power dissipated in external terminations.
 * -Tj is junction temperature. Tj must be less than 125 C (on Si5345 Revision D) for device to comply with datasheet specifications.
 * 
 * Settings
 * ========
 * 
 * Location      Setting Name           Decimal Value      Hex Value        
 * ------------  ---------------------  -----------------  -----------------
 * 0x000B[6:0]   I2C_ADDR               100                0x64             
 * 0x0016[1]     LOL_ON_HOLD            1                  0x1              
 * 0x0017[0]     SYSINCAL_INTR_MSK      0                  0x0              
 * 0x0017[1]     LOSXAXB_INTR_MSK       0                  0x0              
 * 0x0017[5]     SMB_TMOUT_INTR_MSK     1                  0x1              
 * 0x0018[3:0]   LOS_INTR_MSK           15                 0xF              
 * 0x0018[7:4]   OOF_INTR_MSK           15                 0xF              
 * 0x0019[1]     LOL_INTR_MSK           1                  0x1              
 * 0x0019[5]     HOLD_INTR_MSK          0                  0x0              
 * 0x001A[5]     CAL_INTR_MSK           0                  0x0              
 * 0x002B[3]     SPI_3WIRE              0                  0x0              
 * 0x002B[5]     AUTO_NDIV_UPDATE       0                  0x0              
 * 0x002C[3:0]   LOS_EN                 1                  0x1              
 * 0x002C[4]     LOSXAXB_DIS            0                  0x0              
 * 0x002D[1:0]   LOS0_VAL_TIME          2                  0x2              
 * 0x002D[3:2]   LOS1_VAL_TIME          0                  0x0              
 * 0x002D[5:4]   LOS2_VAL_TIME          0                  0x0              
 * 0x002D[7:6]   LOS3_VAL_TIME          0                  0x0              
 * 0x002E[15:0]  LOS0_TRG_THR           4168               0x1048           
 * 0x0030[15:0]  LOS1_TRG_THR           0                  0x0000           
 * 0x0032[15:0]  LOS2_TRG_THR           0                  0x0000           
 * 0x0034[15:0]  LOS3_TRG_THR           0                  0x0000           
 * 0x0036[15:0]  LOS0_CLR_THR           3821               0x0EED           
 * 0x0038[15:0]  LOS1_CLR_THR           0                  0x0000           
 * 0x003A[15:0]  LOS2_CLR_THR           0                  0x0000           
 * 0x003C[15:0]  LOS3_CLR_THR           0                  0x0000           
 * 0x003F[3:0]   OOF_EN                 1                  0x1              
 * 0x003F[7:4]   FAST_OOF_EN            0                  0x0              
 * 0x0040[2:0]   OOF_REF_SEL            4                  0x4              
 * 0x0041[4:0]   OOF0_DIV_SEL           0                  0x00             
 * 0x0042[4:0]   OOF1_DIV_SEL           0                  0x00             
 * 0x0043[4:0]   OOF2_DIV_SEL           0                  0x00             
 * 0x0044[4:0]   OOF3_DIV_SEL           0                  0x00             
 * 0x0045[4:0]   OOFXO_DIV_SEL          12                 0x0C             
 * 0x0046[7:0]   OOF0_SET_THR           150                0x96             
 * 0x0047[7:0]   OOF1_SET_THR           0                  0x00             
 * 0x0048[7:0]   OOF2_SET_THR           0                  0x00             
 * 0x0049[7:0]   OOF3_SET_THR           0                  0x00             
 * 0x004A[7:0]   OOF0_CLR_THR           75                 0x4B             
 * 0x004B[7:0]   OOF1_CLR_THR           0                  0x00             
 * 0x004C[7:0]   OOF2_CLR_THR           0                  0x00             
 * 0x004D[7:0]   OOF3_CLR_THR           0                  0x00             
 * 0x004E[2:0]   OOF0_DETWIN_SEL        5                  0x5              
 * 0x004E[6:4]   OOF1_DETWIN_SEL        0                  0x0              
 * 0x004F[2:0]   OOF2_DETWIN_SEL        0                  0x0              
 * 0x004F[6:4]   OOF3_DETWIN_SEL        0                  0x0              
 * 0x0050[3:0]   OOF_ON_LOS             15                 0xF              
 * 0x0051[3:0]   FAST_OOF0_SET_THR      0                  0x0              
 * 0x0052[3:0]   FAST_OOF1_SET_THR      0                  0x0              
 * 0x0053[3:0]   FAST_OOF2_SET_THR      0                  0x0              
 * 0x0054[3:0]   FAST_OOF3_SET_THR      0                  0x0              
 * 0x0055[3:0]   FAST_OOF0_CLR_THR      0                  0x0              
 * 0x0056[3:0]   FAST_OOF1_CLR_THR      0                  0x0              
 * 0x0057[3:0]   FAST_OOF2_CLR_THR      0                  0x0              
 * 0x0058[3:0]   FAST_OOF3_CLR_THR      0                  0x0              
 * 0x0059[1:0]   FAST_OOF0_DETWIN_SEL   1                  0x1              
 * 0x0059[3:2]   FAST_OOF1_DETWIN_SEL   0                  0x0              
 * 0x0059[5:4]   FAST_OOF2_DETWIN_SEL   0                  0x0              
 * 0x0059[7:6]   FAST_OOF3_DETWIN_SEL   0                  0x0              
 * 0x005A[25:0]  OOF0_RATIO_REF         20793279           0x13D47BF        
 * 0x005E[25:0]  OOF1_RATIO_REF         0                  0x0000000        
 * 0x0062[25:0]  OOF2_RATIO_REF         0                  0x0000000        
 * 0x0066[25:0]  OOF3_RATIO_REF         0                  0x0000000        
 * 0x0092[1]     LOL_FST_EN             1                  0x1              
 * 0x0093[7:4]   LOL_FST_DETWIN_SEL     10                 0xA              
 * 0x0095[3:2]   LOL_FST_VALWIN_SEL     0                  0x0              
 * 0x0096[7:4]   LOL_FST_SET_THR_SEL    9                  0x9              
 * 0x0098[7:4]   LOL_FST_CLR_THR_SEL    7                  0x7              
 * 0x009A[1]     LOL_SLOW_EN_PLL        1                  0x1              
 * 0x009B[7:4]   LOL_SLW_DETWIN_SEL     5                  0x5              
 * 0x009D[3:2]   LOL_SLW_VALWIN_SEL     1                  0x1              
 * 0x009E[7:4]   LOL_SLW_SET_THR        6                  0x6              
 * 0x00A0[7:4]   LOL_SLW_CLR_THR        3                  0x3              
 * 0x00A2[1]     LOL_TIMER_EN           0                  0x0              
 * 0x00A9[28:0]  LOL_CLR_DELAY_DIV256   298125             0x00048C8D       
 * 0x00E5[5]     FASTLOCK_EXTEND_EN     1                  0x1              
 * 0x00EA[28:0]  FASTLOCK_EXTEND        242129             0x0003B1D1       
 * 0x0102[0]     OUTALL_DISABLE_LOW     1                  0x1              
 * 0x0108[0]     OUT0_PDN               0                  0x0              
 * 0x0108[1]     OUT0_OE                1                  0x1              
 * 0x0108[2]     OUT0_RDIV_FORCE2       0                  0x0              
 * 0x0109[2:0]   OUT0_FORMAT            1                  0x1              
 * 0x0109[3]     OUT0_SYNC_EN           1                  0x1              
 * 0x0109[5:4]   OUT0_DIS_STATE         0                  0x0              
 * 0x0109[7:6]   OUT0_CMOS_DRV          0                  0x0              
 * 0x010A[3:0]   OUT0_CM                11                 0xB              
 * 0x010A[6:4]   OUT0_AMPL              3                  0x3              
 * 0x010B[2:0]   OUT0_MUX_SEL           0                  0x0              
 * 0x010B[5:4]   OUT0_VDD_SEL           2                  0x2              
 * 0x010B[3]     OUT0_VDD_SEL_EN        1                  0x1              
 * 0x010B[7:6]   OUT0_INV               0                  0x0              
 * 0x010D[0]     OUT1_PDN               1                  0x1              
 * 0x010D[1]     OUT1_OE                0                  0x0              
 * 0x010D[2]     OUT1_RDIV_FORCE2       0                  0x0              
 * 0x010E[2:0]   OUT1_FORMAT            1                  0x1              
 * 0x010E[3]     OUT1_SYNC_EN           1                  0x1              
 * 0x010E[5:4]   OUT1_DIS_STATE         0                  0x0              
 * 0x010E[7:6]   OUT1_CMOS_DRV          0                  0x0              
 * 0x010F[3:0]   OUT1_CM                11                 0xB              
 * 0x010F[6:4]   OUT1_AMPL              3                  0x3              
 * 0x0110[2:0]   OUT1_MUX_SEL           0                  0x0              
 * 0x0110[5:4]   OUT1_VDD_SEL           2                  0x2              
 * 0x0110[3]     OUT1_VDD_SEL_EN        1                  0x1              
 * 0x0110[7:6]   OUT1_INV               0                  0x0              
 * 0x0112[0]     OUT2_PDN               0                  0x0              
 * 0x0112[1]     OUT2_OE                1                  0x1              
 * 0x0112[2]     OUT2_RDIV_FORCE2       0                  0x0              
 * 0x0113[2:0]   OUT2_FORMAT            1                  0x1              
 * 0x0113[3]     OUT2_SYNC_EN           1                  0x1              
 * 0x0113[5:4]   OUT2_DIS_STATE         0                  0x0              
 * 0x0113[7:6]   OUT2_CMOS_DRV          0                  0x0              
 * 0x0114[3:0]   OUT2_CM                11                 0xB              
 * 0x0114[6:4]   OUT2_AMPL              3                  0x3              
 * 0x0115[2:0]   OUT2_MUX_SEL           0                  0x0              
 * 0x0115[5:4]   OUT2_VDD_SEL           2                  0x2              
 * 0x0115[3]     OUT2_VDD_SEL_EN        1                  0x1              
 * 0x0115[7:6]   OUT2_INV               0                  0x0              
 * 0x0117[0]     OUT3_PDN               1                  0x1              
 * 0x0117[1]     OUT3_OE                0                  0x0              
 * 0x0117[2]     OUT3_RDIV_FORCE2       0                  0x0              
 * 0x0118[2:0]   OUT3_FORMAT            1                  0x1              
 * 0x0118[3]     OUT3_SYNC_EN           1                  0x1              
 * 0x0118[5:4]   OUT3_DIS_STATE         0                  0x0              
 * 0x0118[7:6]   OUT3_CMOS_DRV          0                  0x0              
 * 0x0119[3:0]   OUT3_CM                11                 0xB              
 * 0x0119[6:4]   OUT3_AMPL              3                  0x3              
 * 0x011A[2:0]   OUT3_MUX_SEL           0                  0x0              
 * 0x011A[5:4]   OUT3_VDD_SEL           2                  0x2              
 * 0x011A[3]     OUT3_VDD_SEL_EN        1                  0x1              
 * 0x011A[7:6]   OUT3_INV               0                  0x0              
 * 0x011C[0]     OUT4_PDN               1                  0x1              
 * 0x011C[1]     OUT4_OE                0                  0x0              
 * 0x011C[2]     OUT4_RDIV_FORCE2       0                  0x0              
 * 0x011D[2:0]   OUT4_FORMAT            1                  0x1              
 * 0x011D[3]     OUT4_SYNC_EN           1                  0x1              
 * 0x011D[5:4]   OUT4_DIS_STATE         0                  0x0              
 * 0x011D[7:6]   OUT4_CMOS_DRV          0                  0x0              
 * 0x011E[3:0]   OUT4_CM                11                 0xB              
 * 0x011E[6:4]   OUT4_AMPL              3                  0x3              
 * 0x011F[2:0]   OUT4_MUX_SEL           0                  0x0              
 * 0x011F[5:4]   OUT4_VDD_SEL           2                  0x2              
 * 0x011F[3]     OUT4_VDD_SEL_EN        1                  0x1              
 * 0x011F[7:6]   OUT4_INV               0                  0x0              
 * 0x0121[0]     OUT5_PDN               0                  0x0              
 * 0x0121[1]     OUT5_OE                1                  0x1              
 * 0x0121[2]     OUT5_RDIV_FORCE2       0                  0x0              
 * 0x0122[2:0]   OUT5_FORMAT            1                  0x1              
 * 0x0122[3]     OUT5_SYNC_EN           1                  0x1              
 * 0x0122[5:4]   OUT5_DIS_STATE         0                  0x0              
 * 0x0122[7:6]   OUT5_CMOS_DRV          0                  0x0              
 * 0x0123[3:0]   OUT5_CM                11                 0xB              
 * 0x0123[6:4]   OUT5_AMPL              3                  0x3              
 * 0x0124[2:0]   OUT5_MUX_SEL           1                  0x1              
 * 0x0124[5:4]   OUT5_VDD_SEL           2                  0x2              
 * 0x0124[3]     OUT5_VDD_SEL_EN        1                  0x1              
 * 0x0124[7:6]   OUT5_INV               0                  0x0              
 * 0x0126[0]     OUT6_PDN               1                  0x1              
 * 0x0126[1]     OUT6_OE                0                  0x0              
 * 0x0126[2]     OUT6_RDIV_FORCE2       0                  0x0              
 * 0x0127[2:0]   OUT6_FORMAT            1                  0x1              
 * 0x0127[3]     OUT6_SYNC_EN           1                  0x1              
 * 0x0127[5:4]   OUT6_DIS_STATE         0                  0x0              
 * 0x0127[7:6]   OUT6_CMOS_DRV          0                  0x0              
 * 0x0128[3:0]   OUT6_CM                11                 0xB              
 * 0x0128[6:4]   OUT6_AMPL              3                  0x3              
 * 0x0129[2:0]   OUT6_MUX_SEL           0                  0x0              
 * 0x0129[5:4]   OUT6_VDD_SEL           2                  0x2              
 * 0x0129[3]     OUT6_VDD_SEL_EN        1                  0x1              
 * 0x0129[7:6]   OUT6_INV               0                  0x0              
 * 0x012B[0]     OUT7_PDN               1                  0x1              
 * 0x012B[1]     OUT7_OE                0                  0x0              
 * 0x012B[2]     OUT7_RDIV_FORCE2       0                  0x0              
 * 0x012C[2:0]   OUT7_FORMAT            1                  0x1              
 * 0x012C[3]     OUT7_SYNC_EN           1                  0x1              
 * 0x012C[5:4]   OUT7_DIS_STATE         0                  0x0              
 * 0x012C[7:6]   OUT7_CMOS_DRV          0                  0x0              
 * 0x012D[3:0]   OUT7_CM                11                 0xB              
 * 0x012D[6:4]   OUT7_AMPL              3                  0x3              
 * 0x012E[2:0]   OUT7_MUX_SEL           0                  0x0              
 * 0x012E[5:4]   OUT7_VDD_SEL           2                  0x2              
 * 0x012E[3]     OUT7_VDD_SEL_EN        1                  0x1              
 * 0x012E[7:6]   OUT7_INV               0                  0x0              
 * 0x0130[0]     OUT8_PDN               0                  0x0              
 * 0x0130[1]     OUT8_OE                1                  0x1              
 * 0x0130[2]     OUT8_RDIV_FORCE2       0                  0x0              
 * 0x0131[2:0]   OUT8_FORMAT            1                  0x1              
 * 0x0131[3]     OUT8_SYNC_EN           1                  0x1              
 * 0x0131[5:4]   OUT8_DIS_STATE         0                  0x0              
 * 0x0131[7:6]   OUT8_CMOS_DRV          0                  0x0              
 * 0x0132[3:0]   OUT8_CM                11                 0xB              
 * 0x0132[6:4]   OUT8_AMPL              3                  0x3              
 * 0x0133[2:0]   OUT8_MUX_SEL           2                  0x2              
 * 0x0133[5:4]   OUT8_VDD_SEL           2                  0x2              
 * 0x0133[3]     OUT8_VDD_SEL_EN        1                  0x1              
 * 0x0133[7:6]   OUT8_INV               0                  0x0              
 * 0x013A[0]     OUT9_PDN               1                  0x1              
 * 0x013A[1]     OUT9_OE                0                  0x0              
 * 0x013A[2]     OUT9_RDIV_FORCE2       0                  0x0              
 * 0x013B[2:0]   OUT9_FORMAT            1                  0x1              
 * 0x013B[3]     OUT9_SYNC_EN           1                  0x1              
 * 0x013B[5:4]   OUT9_DIS_STATE         0                  0x0              
 * 0x013B[7:6]   OUT9_CMOS_DRV          0                  0x0              
 * 0x013C[3:0]   OUT9_CM                11                 0xB              
 * 0x013C[6:4]   OUT9_AMPL              3                  0x3              
 * 0x013D[2:0]   OUT9_MUX_SEL           0                  0x0              
 * 0x013D[5:4]   OUT9_VDD_SEL           2                  0x2              
 * 0x013D[3]     OUT9_VDD_SEL_EN        1                  0x1              
 * 0x013D[7:6]   OUT9_INV               0                  0x0              
 * 0x013F[11:0]  OUTX_ALWAYS_ON         0                  0x000            
 * 0x0141[1]     OUT_DIS_MSK            0                  0x0              
 * 0x0141[5]     OUT_DIS_LOL_MSK        0                  0x0              
 * 0x0141[6]     OUT_DIS_LOSXAXB_MSK    1                  0x1              
 * 0x0141[7]     OUT_DIS_MSK_LOS_PFD    0                  0x0              
 * 0x0142[1]     OUT_DIS_MSK_LOL        1                  0x1              
 * 0x0142[5]     OUT_DIS_MSK_HOLD       1                  0x1              
 * 0x0206[1:0]   PXAXB                  0                  0x0              
 * 0x0208[47:0]  P0_NUM                 1                  0x000000000001   
 * 0x020E[31:0]  P0_DEN                 1                  0x00000001       
 * 0x0212[47:0]  P1_NUM                 0                  0x000000000000   
 * 0x0218[31:0]  P1_DEN                 0                  0x00000000       
 * 0x021C[47:0]  P2_NUM                 0                  0x000000000000   
 * 0x0222[31:0]  P2_DEN                 0                  0x00000000       
 * 0x0226[47:0]  P3_NUM                 0                  0x000000000000   
 * 0x022C[31:0]  P3_DEN                 0                  0x00000000       
 * 0x0231[3:0]   P0_FRACN_MODE          11                 0xB              
 * 0x0231[4]     P0_FRACN_EN            0                  0x0              
 * 0x0232[3:0]   P1_FRACN_MODE          11                 0xB              
 * 0x0232[4]     P1_FRACN_EN            0                  0x0              
 * 0x0233[3:0]   P2_FRACN_MODE          11                 0xB              
 * 0x0233[4]     P2_FRACN_EN            0                  0x0              
 * 0x0234[3:0]   P3_FRACN_MODE          11                 0xB              
 * 0x0234[4]     P3_FRACN_EN            0                  0x0              
 * 0x0235[43:0]  MXAXB_NUM              916841299968       0x0D578000000    
 * 0x023B[31:0]  MXAXB_DEN              3489660928         0xD0000000       
 * 0x024A[23:0]  R0_REG                 10                 0x00000A         
 * 0x024D[23:0]  R1_REG                 0                  0x000000         
 * 0x0250[23:0]  R2_REG                 1                  0x000001         
 * 0x0253[23:0]  R3_REG                 0                  0x000000         
 * 0x0256[23:0]  R4_REG                 0                  0x000000         
 * 0x0259[23:0]  R5_REG                 2                  0x000002         
 * 0x025C[23:0]  R6_REG                 0                  0x000000         
 * 0x025F[23:0]  R7_REG                 0                  0x000000         
 * 0x0262[23:0]  R8_REG                 2                  0x000002         
 * 0x0268[23:0]  R9_REG                 0                  0x000000         
 * 0x026B[7:0]   DESIGN_ID0             73                 0x49             
 * 0x026C[7:0]   DESIGN_ID1             79                 0x4F             
 * 0x026D[7:0]   DESIGN_ID2             52                 0x34             
 * 0x026E[7:0]   DESIGN_ID3             75                 0x4B             
 * 0x026F[7:0]   DESIGN_ID4             43                 0x2B             
 * 0x0270[7:0]   DESIGN_ID5             0                  0x00             
 * 0x0271[7:0]   DESIGN_ID6             0                  0x00             
 * 0x0272[7:0]   DESIGN_ID7             0                  0x00             
 * 0x0294[7:4]   FASTLOCK_EXTEND_SCL    8                  0x8              
 * 0x0296[1]     LOL_SLW_VALWIN_SELX    0                  0x0              
 * 0x0297[1]     FASTLOCK_DLY_ONSW_EN   1                  0x1              
 * 0x0299[1]     FASTLOCK_DLY_ONLOL_EN  1                  0x1              
 * 0x029D[19:0]  FASTLOCK_DLY_ONLOL     3829               0x00EF5          
 * 0x02A9[19:0]  FASTLOCK_DLY_ONSW      9830               0x02666          
 * 0x02B7[3:2]   LOL_NOSIG_TIME         3                  0x3              
 * 0x0302[43:0]  N0_NUM                 49392123904        0x00B80000000    
 * 0x0308[31:0]  N0_DEN                 2147483648         0x80000000       
 * 0x030C[0]     N0_UPDATE              0                  0x0              
 * 0x030D[43:0]  N1_NUM                 198967296000       0x02E53600000    
 * 0x0313[31:0]  N1_DEN                 2147483648         0x80000000       
 * 0x0317[0]     N1_UPDATE              0                  0x0              
 * 0x0318[43:0]  N2_NUM                 48282730496        0x00B3DE00000    
 * 0x031E[31:0]  N2_DEN                 3145728000         0xBB800000       
 * 0x0322[0]     N2_UPDATE              0                  0x0              
 * 0x0323[43:0]  N3_NUM                 0                  0x00000000000    
 * 0x0329[31:0]  N3_DEN                 0                  0x00000000       
 * 0x032D[0]     N3_UPDATE              0                  0x0              
 * 0x032E[43:0]  N4_NUM                 0                  0x00000000000    
 * 0x0334[31:0]  N4_DEN                 0                  0x00000000       
 * 0x0338[0]     N4_UPDATE              0                  0x0              
 * 0x0338[1]     N_UPDATE               0                  0x0              
 * 0x0339[4:0]   N_FSTEP_MSK            31                 0x1F             
 * 0x033B[43:0]  N0_FSTEPW              0                  0x00000000000    
 * 0x0341[43:0]  N1_FSTEPW              0                  0x00000000000    
 * 0x0347[43:0]  N2_FSTEPW              0                  0x00000000000    
 * 0x034D[43:0]  N3_FSTEPW              0                  0x00000000000    
 * 0x0353[43:0]  N4_FSTEPW              0                  0x00000000000    
 * 0x0359[15:0]  N0_DELAY               0                  0x0000           
 * 0x035B[15:0]  N1_DELAY               0                  0x0000           
 * 0x035D[15:0]  N2_DELAY               0                  0x0000           
 * 0x035F[15:0]  N3_DELAY               0                  0x0000           
 * 0x0361[15:0]  N4_DELAY               0                  0x0000           
 * 0x0487[0]     ZDM_EN                 0                  0x0              
 * 0x0487[2:1]   ZDM_IN_SEL             0                  0x0              
 * 0x0487[4]     ZDM_AUTOSW_EN          0                  0x0              
 * 0x0502[4]     ADD_DIV256             0                  0x0              
 * 0x0508[5:0]   BW0_PLL                16                 0x10             
 * 0x0509[5:0]   BW1_PLL                24                 0x18             
 * 0x050A[5:0]   BW2_PLL                15                 0x0F             
 * 0x050B[5:0]   BW3_PLL                15                 0x0F             
 * 0x050C[5:0]   BW4_PLL                7                  0x07             
 * 0x050D[5:0]   BW5_PLL                7                  0x07             
 * 0x050E[5:0]   FASTLOCK_BW0_PLL       23                 0x17             
 * 0x050F[5:0]   FASTLOCK_BW1_PLL       40                 0x28             
 * 0x0510[5:0]   FASTLOCK_BW2_PLL       12                 0x0C             
 * 0x0511[5:0]   FASTLOCK_BW3_PLL       11                 0x0B             
 * 0x0512[5:0]   FASTLOCK_BW4_PLL       7                  0x07             
 * 0x0513[5:0]   FASTLOCK_BW5_PLL       7                  0x07             
 * 0x0515[55:0]  M_NUM                  466162865405952    0x01A7F900000000 
 * 0x051C[31:0]  M_DEN                  2684354560         0xA0000000       
 * 0x0521[3:0]   M_FRAC_MODE            11                 0xB              
 * 0x0521[4]     M_FRAC_EN              1                  0x1              
 * 0x0521[5]     PLL_OUT_RATE_SEL       1                  0x1              
 * 0x052A[0]     IN_SEL_REGCTRL         1                  0x1              
 * 0x052A[3:1]   IN_SEL                 0                  0x0              
 * 0x052B[0]     FASTLOCK_AUTO_EN       1                  0x1              
 * 0x052B[1]     FASTLOCK_MAN           0                  0x0              
 * 0x052C[0]     HOLD_EN                1                  0x1              
 * 0x052C[3]     HOLD_RAMP_BYP          1                  0x1              
 * 0x052C[4]     HOLDEXIT_BW_SEL1       0                  0x0              
 * 0x052C[7:5]   RAMP_STEP_INTERVAL     0                  0x0              
 * 0x052D[1]     HOLD_RAMPBYP_NOHIST    1                  0x1              
 * 0x052E[4:0]   HOLD_HIST_LEN          21                 0x15             
 * 0x052F[4:0]   HOLD_HIST_DELAY        20                 0x14             
 * 0x0531[4:0]   HOLD_REF_COUNT_FRC     0                  0x00             
 * 0x0532[23:0]  HOLD_15M_CYC_COUNT     105926             0x019DC6         
 * 0x0535[0]     FORCE_HOLD             0                  0x0              
 * 0x0536[1:0]   CLK_SWITCH_MODE        0                  0x0              
 * 0x0536[2]     HSW_EN                 0                  0x0              
 * 0x0537[3:0]   IN_LOS_MSK             0                  0x0              
 * 0x0537[7:4]   IN_OOF_MSK             0                  0x0              
 * 0x0538[2:0]   IN0_PRIORITY           0                  0x0              
 * 0x0538[6:4]   IN1_PRIORITY           0                  0x0              
 * 0x0539[2:0]   IN2_PRIORITY           0                  0x0              
 * 0x0539[6:4]   IN3_PRIORITY           0                  0x0              
 * 0x053A[1:0]   HSW_MODE               2                  0x2              
 * 0x053A[3:2]   HSW_PHMEAS_CTRL        0                  0x0              
 * 0x053B[9:0]   HSW_PHMEAS_THR         3                  0x003            
 * 0x053D[4:0]   HSW_COARSE_PM_LEN      17                 0x11             
 * 0x053E[4:0]   HSW_COARSE_PM_DLY      6                  0x06             
 * 0x0589[12:0]  CAP_SHORT_DELAY        1734               0x06C6           
 * 0x059B[4]     HOLD_PRESERVE_HIST     1                  0x1              
 * 0x059B[5]     HOLD_FRZ_WITH_INTONLY  1                  0x1              
 * 0x059B[6]     HOLDEXIT_BW_SEL0       1                  0x1              
 * 0x059B[7]     HOLDEXIT_STD_BO        1                  0x1              
 * 0x059D[5:0]   HOLDEXIT_BW0           23                 0x17             
 * 0x059E[5:0]   HOLDEXIT_BW1           40                 0x28             
 * 0x059F[5:0]   HOLDEXIT_BW2           12                 0x0C             
 * 0x05A0[5:0]   HOLDEXIT_BW3           11                 0x0B             
 * 0x05A1[5:0]   HOLDEXIT_BW4           7                  0x07             
 * 0x05A2[5:0]   HOLDEXIT_BW5           7                  0x07             
 * 0x05A6[2:0]   RAMP_STEP_SIZE         0                  0x0              
 * 0x05A6[3]     RAMP_SWITCH_EN         0                  0x0              
 * 0x0802[15:0]  FIXREGSA0              1333               0x0535           
 * 0x0804[7:0]   FIXREGSD0              0                  0x00             
 * 0x0805[15:0]  FIXREGSA1              0                  0x0000           
 * 0x0807[7:0]   FIXREGSD1              0                  0x00             
 * 0x0808[15:0]  FIXREGSA2              0                  0x0000           
 * 0x080A[7:0]   FIXREGSD2              0                  0x00             
 * 0x080B[15:0]  FIXREGSA3              0                  0x0000           
 * 0x080D[7:0]   FIXREGSD3              0                  0x00             
 * 0x080E[15:0]  FIXREGSA4              0                  0x0000           
 * 0x0810[7:0]   FIXREGSD4              0                  0x00             
 * 0x0811[15:0]  FIXREGSA5              0                  0x0000           
 * 0x0813[7:0]   FIXREGSD5              0                  0x00             
 * 0x0814[15:0]  FIXREGSA6              0                  0x0000           
 * 0x0816[7:0]   FIXREGSD6              0                  0x00             
 * 0x0817[15:0]  FIXREGSA7              0                  0x0000           
 * 0x0819[7:0]   FIXREGSD7              0                  0x00             
 * 0x081A[15:0]  FIXREGSA8              0                  0x0000           
 * 0x081C[7:0]   FIXREGSD8              0                  0x00             
 * 0x081D[15:0]  FIXREGSA9              0                  0x0000           
 * 0x081F[7:0]   FIXREGSD9              0                  0x00             
 * 0x0820[15:0]  FIXREGSA10             0                  0x0000           
 * 0x0822[7:0]   FIXREGSD10             0                  0x00             
 * 0x0823[15:0]  FIXREGSA11             0                  0x0000           
 * 0x0825[7:0]   FIXREGSD11             0                  0x00             
 * 0x0826[15:0]  FIXREGSA12             0                  0x0000           
 * 0x0828[7:0]   FIXREGSD12             0                  0x00             
 * 0x0829[15:0]  FIXREGSA13             0                  0x0000           
 * 0x082B[7:0]   FIXREGSD13             0                  0x00             
 * 0x082C[15:0]  FIXREGSA14             0                  0x0000           
 * 0x082E[7:0]   FIXREGSD14             0                  0x00             
 * 0x082F[15:0]  FIXREGSA15             0                  0x0000           
 * 0x0831[7:0]   FIXREGSD15             0                  0x00             
 * 0x0832[15:0]  FIXREGSA16             0                  0x0000           
 * 0x0834[7:0]   FIXREGSD16             0                  0x00             
 * 0x0835[15:0]  FIXREGSA17             0                  0x0000           
 * 0x0837[7:0]   FIXREGSD17             0                  0x00             
 * 0x0838[15:0]  FIXREGSA18             0                  0x0000           
 * 0x083A[7:0]   FIXREGSD18             0                  0x00             
 * 0x083B[15:0]  FIXREGSA19             0                  0x0000           
 * 0x083D[7:0]   FIXREGSD19             0                  0x00             
 * 0x083E[15:0]  FIXREGSA20             0                  0x0000           
 * 0x0840[7:0]   FIXREGSD20             0                  0x00             
 * 0x0841[15:0]  FIXREGSA21             0                  0x0000           
 * 0x0843[7:0]   FIXREGSD21             0                  0x00             
 * 0x0844[15:0]  FIXREGSA22             0                  0x0000           
 * 0x0846[7:0]   FIXREGSD22             0                  0x00             
 * 0x0847[15:0]  FIXREGSA23             0                  0x0000           
 * 0x0849[7:0]   FIXREGSD23             0                  0x00             
 * 0x084A[15:0]  FIXREGSA24             0                  0x0000           
 * 0x084C[7:0]   FIXREGSD24             0                  0x00             
 * 0x084D[15:0]  FIXREGSA25             0                  0x0000           
 * 0x084F[7:0]   FIXREGSD25             0                  0x00             
 * 0x0850[15:0]  FIXREGSA26             0                  0x0000           
 * 0x0852[7:0]   FIXREGSD26             0                  0x00             
 * 0x0853[15:0]  FIXREGSA27             0                  0x0000           
 * 0x0855[7:0]   FIXREGSD27             0                  0x00             
 * 0x0856[15:0]  FIXREGSA28             0                  0x0000           
 * 0x0858[7:0]   FIXREGSD28             0                  0x00             
 * 0x0859[15:0]  FIXREGSA29             0                  0x0000           
 * 0x085B[7:0]   FIXREGSD29             0                  0x00             
 * 0x085C[15:0]  FIXREGSA30             0                  0x0000           
 * 0x085E[7:0]   FIXREGSD30             0                  0x00             
 * 0x085F[15:0]  FIXREGSA31             0                  0x0000           
 * 0x0861[7:0]   FIXREGSD31             0                  0x00             
 * 0x090E[0]     XAXB_EXTCLK_EN         1                  0x1              
 * 0x0943[0]     IO_VDD_SEL             0                  0x0              
 * 0x0949[3:0]   IN_EN                  1                  0x1              
 * 0x0949[7:4]   IN_PULSED_CMOS_EN      3                  0x3              
 * 0x094A[3:0]   INX_TO_PFD_EN          1                  0x1              
 * 0x094E[11:0]  REFCLK_HYS_SEL         585                0x249            
 * 0x095E[0]     MXAXB_INTEGER          0                  0x0              
 * 0x0A02[4:0]   N_ADD_0P5              0                  0x00             
 * 0x0A03[4:0]   N_CLK_TO_OUTX_EN       7                  0x07             
 * 0x0A04[4:0]   N_PIBYP                1                  0x01             
 * 0x0A05[4:0]   N_PDNB                 7                  0x07             
 * 0x0A14[3]     N0_HIGH_FREQ           0                  0x0              
 * 0x0A1A[3]     N1_HIGH_FREQ           0                  0x0              
 * 0x0A20[3]     N2_HIGH_FREQ           0                  0x0              
 * 0x0A26[3]     N3_HIGH_FREQ           0                  0x0              
 * 0x0A2C[3]     N4_HIGH_FREQ           0                  0x0              
 * 0x0B44[3:0]   PDIV_FRACN_CLK_DIS     15                 0xF              
 * 0x0B44[5]     FRACN_CLK_DIS_PLL      0                  0x0              
 * 0x0B46[3:0]   LOS_CLK_DIS            0                  0x0              
 * 0x0B47[4:0]   OOF_CLK_DIS            14                 0x0E             
 * 0x0B48[4:0]   OOF_DIV_CLK_DIS        14                 0x0E             
 * 0x0B4A[4:0]   N_CLK_DIS              24                 0x18             
 * 0x0B57[11:0]  VCO_RESET_CALCODE      249                0x0F9
 * 
 *
 */


static struct ntv2_genlock_data s_genlock_625_2500[] =
{
	/* Start configuration preamble */
	{ 0x0B24, 0xC0 },
	{ 0x0B25, 0x00 },
	{ 0x0540, 0x01 },
	/* End configuration preamble */

	/* Delay 300 msec */
	/*    Delay is worst case time for device to complete any calibration */
	/*    that is running due to device state change previous to this script */
	/*    being processed. */
	{ 0x0000, 0x01 },

	/* Start configuration registers */
	{ 0x000B, 0x64 },
	{ 0x0016, 0x02 },
	{ 0x0017, 0xFC },
	{ 0x0018, 0xFF },
	{ 0x0019, 0xDF },
	{ 0x001A, 0xDF },
	{ 0x002B, 0x02 },
	{ 0x002C, 0x01 },
	{ 0x002D, 0x02 },
	{ 0x002E, 0x65 },
	{ 0x002F, 0x10 },
	{ 0x0030, 0x00 },
	{ 0x0031, 0x00 },
	{ 0x0032, 0x00 },
	{ 0x0033, 0x00 },
	{ 0x0034, 0x00 },
	{ 0x0035, 0x00 },
	{ 0x0036, 0x08 },
	{ 0x0037, 0x0F },
	{ 0x0038, 0x00 },
	{ 0x0039, 0x00 },
	{ 0x003A, 0x00 },
	{ 0x003B, 0x00 },
	{ 0x003C, 0x00 },
	{ 0x003D, 0x00 },
	{ 0x003F, 0x01 },
	{ 0x0040, 0x04 },
	{ 0x0041, 0x00 },
	{ 0x0042, 0x00 },
	{ 0x0043, 0x00 },
	{ 0x0044, 0x00 },
	{ 0x0045, 0x0C },
	{ 0x0046, 0x96 },
	{ 0x0047, 0x00 },
	{ 0x0048, 0x00 },
	{ 0x0049, 0x00 },
	{ 0x004A, 0x4B },
	{ 0x004B, 0x00 },
	{ 0x004C, 0x00 },
	{ 0x004D, 0x00 },
	{ 0x004E, 0x05 },
	{ 0x004F, 0x00 },
	{ 0x0050, 0x0F },
	{ 0x0051, 0x00 },
	{ 0x0052, 0x00 },
	{ 0x0053, 0x00 },
	{ 0x0054, 0x00 },
	{ 0x0055, 0x00 },
	{ 0x0056, 0x00 },
	{ 0x0057, 0x00 },
	{ 0x0058, 0x00 },
	{ 0x0059, 0x01 },
	{ 0x005A, 0xB1 },
	{ 0x005B, 0x13 },
	{ 0x005C, 0x3B },
	{ 0x005D, 0x01 },
	{ 0x005E, 0x00 },
	{ 0x005F, 0x00 },
	{ 0x0060, 0x00 },
	{ 0x0061, 0x00 },
	{ 0x0062, 0x00 },
	{ 0x0063, 0x00 },
	{ 0x0064, 0x00 },
	{ 0x0065, 0x00 },
	{ 0x0066, 0x00 },
	{ 0x0067, 0x00 },
	{ 0x0068, 0x00 },
	{ 0x0069, 0x00 },
	{ 0x0092, 0x02 },
	{ 0x0093, 0xA0 },
	{ 0x0095, 0x00 },
	{ 0x0096, 0x90 },
	{ 0x0098, 0x70 },
	{ 0x009A, 0x02 },
	{ 0x009B, 0x50 },
	{ 0x009D, 0x04 },
	{ 0x009E, 0x60 },
	{ 0x00A0, 0x30 },
	{ 0x00A2, 0x00 },
	{ 0x00A9, 0x1C },
	{ 0x00AA, 0x8E },
	{ 0x00AB, 0x04 },
	{ 0x00AC, 0x00 },
	{ 0x00E5, 0x21 },
	{ 0x00EA, 0xD1 },
	{ 0x00EB, 0xB1 },
	{ 0x00EC, 0x03 },
	{ 0x00ED, 0x00 },
	{ 0x0102, 0x01 },
	{ 0x0108, 0x02 },
	{ 0x0109, 0x09 },
	{ 0x010A, 0x3B },
	{ 0x010B, 0x28 },
	{ 0x010D, 0x01 },
	{ 0x010E, 0x09 },
	{ 0x010F, 0x3B },
	{ 0x0110, 0x28 },
	{ 0x0112, 0x02 },
	{ 0x0113, 0x09 },
	{ 0x0114, 0x3B },
	{ 0x0115, 0x28 },
	{ 0x0117, 0x01 },
	{ 0x0118, 0x09 },
	{ 0x0119, 0x3B },
	{ 0x011A, 0x28 },
	{ 0x011C, 0x01 },
	{ 0x011D, 0x09 },
	{ 0x011E, 0x3B },
	{ 0x011F, 0x28 },
	{ 0x0121, 0x02 },
	{ 0x0122, 0x09 },
	{ 0x0123, 0x3B },
	{ 0x0124, 0x29 },
	{ 0x0126, 0x01 },
	{ 0x0127, 0x09 },
	{ 0x0128, 0x3B },
	{ 0x0129, 0x28 },
	{ 0x012B, 0x01 },
	{ 0x012C, 0x09 },
	{ 0x012D, 0x3B },
	{ 0x012E, 0x28 },
	{ 0x0130, 0x02 },
	{ 0x0131, 0x09 },
	{ 0x0132, 0x3B },
	{ 0x0133, 0x2A },
	{ 0x013A, 0x01 },
	{ 0x013B, 0x09 },
	{ 0x013C, 0x3B },
	{ 0x013D, 0x28 },
	{ 0x013F, 0x00 },
	{ 0x0140, 0x00 },
	{ 0x0141, 0x40 },
	{ 0x0142, 0xFF },
	{ 0x0206, 0x00 },
	{ 0x0208, 0x01 },
	{ 0x0209, 0x00 },
	{ 0x020A, 0x00 },
	{ 0x020B, 0x00 },
	{ 0x020C, 0x00 },
	{ 0x020D, 0x00 },
	{ 0x020E, 0x01 },
	{ 0x020F, 0x00 },
	{ 0x0210, 0x00 },
	{ 0x0211, 0x00 },
	{ 0x0212, 0x00 },
	{ 0x0213, 0x00 },
	{ 0x0214, 0x00 },
	{ 0x0215, 0x00 },
	{ 0x0216, 0x00 },
	{ 0x0217, 0x00 },
	{ 0x0218, 0x00 },
	{ 0x0219, 0x00 },
	{ 0x021A, 0x00 },
	{ 0x021B, 0x00 },
	{ 0x021C, 0x00 },
	{ 0x021D, 0x00 },
	{ 0x021E, 0x00 },
	{ 0x021F, 0x00 },
	{ 0x0220, 0x00 },
	{ 0x0221, 0x00 },
	{ 0x0222, 0x00 },
	{ 0x0223, 0x00 },
	{ 0x0224, 0x00 },
	{ 0x0225, 0x00 },
	{ 0x0226, 0x00 },
	{ 0x0227, 0x00 },
	{ 0x0228, 0x00 },
	{ 0x0229, 0x00 },
	{ 0x022A, 0x00 },
	{ 0x022B, 0x00 },
	{ 0x022C, 0x00 },
	{ 0x022D, 0x00 },
	{ 0x022E, 0x00 },
	{ 0x022F, 0x00 },
	{ 0x0231, 0x0B },
	{ 0x0232, 0x0B },
	{ 0x0233, 0x0B },
	{ 0x0234, 0x0B },
	{ 0x0235, 0x00 },
	{ 0x0236, 0x00 },
	{ 0x0237, 0x00 },
	{ 0x0238, 0x78 },
	{ 0x0239, 0xD5 },
	{ 0x023A, 0x00 },
	{ 0x023B, 0x00 },
	{ 0x023C, 0x00 },
	{ 0x023D, 0x00 },
	{ 0x023E, 0xD0 },
	{ 0x024A, 0x0A },
	{ 0x024B, 0x00 },
	{ 0x024C, 0x00 },
	{ 0x024D, 0x00 },
	{ 0x024E, 0x00 },
	{ 0x024F, 0x00 },
	{ 0x0250, 0x01 },
	{ 0x0251, 0x00 },
	{ 0x0252, 0x00 },
	{ 0x0253, 0x00 },
	{ 0x0254, 0x00 },
	{ 0x0255, 0x00 },
	{ 0x0256, 0x00 },
	{ 0x0257, 0x00 },
	{ 0x0258, 0x00 },
	{ 0x0259, 0x02 },
	{ 0x025A, 0x00 },
	{ 0x025B, 0x00 },
	{ 0x025C, 0x00 },
	{ 0x025D, 0x00 },
	{ 0x025E, 0x00 },
	{ 0x025F, 0x00 },
	{ 0x0260, 0x00 },
	{ 0x0261, 0x00 },
	{ 0x0262, 0x02 },
	{ 0x0263, 0x00 },
	{ 0x0264, 0x00 },
	{ 0x0268, 0x00 },
	{ 0x0269, 0x00 },
	{ 0x026A, 0x00 },
	{ 0x026B, 0x49 },
	{ 0x026C, 0x4F },
	{ 0x026D, 0x34 },
	{ 0x026E, 0x4B },
	{ 0x026F, 0x2B },
	{ 0x0270, 0x00 },
	{ 0x0271, 0x00 },
	{ 0x0272, 0x00 },
	{ 0x0294, 0x80 },
	{ 0x0296, 0x00 },
	{ 0x0297, 0x02 },
	{ 0x0299, 0x02 },
	{ 0x029D, 0xF5 },
	{ 0x029E, 0x0E },
	{ 0x029F, 0x00 },
	{ 0x02A9, 0x66 },
	{ 0x02AA, 0x26 },
	{ 0x02AB, 0x00 },
	{ 0x02B7, 0xFF },
	{ 0x0302, 0x00 },
	{ 0x0303, 0x00 },
	{ 0x0304, 0x00 },
	{ 0x0305, 0x80 },
	{ 0x0306, 0x0B },
	{ 0x0307, 0x00 },
	{ 0x0308, 0x00 },
	{ 0x0309, 0x00 },
	{ 0x030A, 0x00 },
	{ 0x030B, 0x80 },
	{ 0x030C, 0x00 },
	{ 0x030D, 0x00 },
	{ 0x030E, 0x00 },
	{ 0x030F, 0x60 },
	{ 0x0310, 0x53 },
	{ 0x0311, 0x2E },
	{ 0x0312, 0x00 },
	{ 0x0313, 0x00 },
	{ 0x0314, 0x00 },
	{ 0x0315, 0x00 },
	{ 0x0316, 0x80 },
	{ 0x0317, 0x00 },
	{ 0x0318, 0x00 },
	{ 0x0319, 0x00 },
	{ 0x031A, 0xE0 },
	{ 0x031B, 0x3D },
	{ 0x031C, 0x0B },
	{ 0x031D, 0x00 },
	{ 0x031E, 0x00 },
	{ 0x031F, 0x00 },
	{ 0x0320, 0x80 },
	{ 0x0321, 0xBB },
	{ 0x0322, 0x00 },
	{ 0x0323, 0x00 },
	{ 0x0324, 0x00 },
	{ 0x0325, 0x00 },
	{ 0x0326, 0x00 },
	{ 0x0327, 0x00 },
	{ 0x0328, 0x00 },
	{ 0x0329, 0x00 },
	{ 0x032A, 0x00 },
	{ 0x032B, 0x00 },
	{ 0x032C, 0x00 },
	{ 0x032D, 0x00 },
	{ 0x032E, 0x00 },
	{ 0x032F, 0x00 },
	{ 0x0330, 0x00 },
	{ 0x0331, 0x00 },
	{ 0x0332, 0x00 },
	{ 0x0333, 0x00 },
	{ 0x0334, 0x00 },
	{ 0x0335, 0x00 },
	{ 0x0336, 0x00 },
	{ 0x0337, 0x00 },
	{ 0x0338, 0x00 },
	{ 0x0339, 0x1F },
	{ 0x033B, 0x00 },
	{ 0x033C, 0x00 },
	{ 0x033D, 0x00 },
	{ 0x033E, 0x00 },
	{ 0x033F, 0x00 },
	{ 0x0340, 0x00 },
	{ 0x0341, 0x00 },
	{ 0x0342, 0x00 },
	{ 0x0343, 0x00 },
	{ 0x0344, 0x00 },
	{ 0x0345, 0x00 },
	{ 0x0346, 0x00 },
	{ 0x0347, 0x00 },
	{ 0x0348, 0x00 },
	{ 0x0349, 0x00 },
	{ 0x034A, 0x00 },
	{ 0x034B, 0x00 },
	{ 0x034C, 0x00 },
	{ 0x034D, 0x00 },
	{ 0x034E, 0x00 },
	{ 0x034F, 0x00 },
	{ 0x0350, 0x00 },
	{ 0x0351, 0x00 },
	{ 0x0352, 0x00 },
	{ 0x0353, 0x00 },
	{ 0x0354, 0x00 },
	{ 0x0355, 0x00 },
	{ 0x0356, 0x00 },
	{ 0x0357, 0x00 },
	{ 0x0358, 0x00 },
	{ 0x0359, 0x00 },
	{ 0x035A, 0x00 },
	{ 0x035B, 0x00 },
	{ 0x035C, 0x00 },
	{ 0x035D, 0x00 },
	{ 0x035E, 0x00 },
	{ 0x035F, 0x00 },
	{ 0x0360, 0x00 },
	{ 0x0361, 0x00 },
	{ 0x0362, 0x00 },
	{ 0x0487, 0x00 },
	{ 0x0502, 0x01 },
	{ 0x0508, 0x10 },
	{ 0x0509, 0x18 },
	{ 0x050A, 0x0F },
	{ 0x050B, 0x0F },
	{ 0x050C, 0x07 },
	{ 0x050D, 0x07 },
	{ 0x050E, 0x17 },
	{ 0x050F, 0x28 },
	{ 0x0510, 0x0C },
	{ 0x0511, 0x0B },
	{ 0x0512, 0x07 },
	{ 0x0513, 0x07 },
	{ 0x0515, 0x00 },
	{ 0x0516, 0x00 },
	{ 0x0517, 0x00 },
	{ 0x0518, 0x00 },
	{ 0x0519, 0xF0 },
	{ 0x051A, 0xAA },
	{ 0x051B, 0x01 },
	{ 0x051C, 0x00 },
	{ 0x051D, 0x00 },
	{ 0x051E, 0x00 },
	{ 0x051F, 0xA0 },
	{ 0x0521, 0x3B },
	{ 0x052A, 0x01 },
	{ 0x052B, 0x01 },
	{ 0x052C, 0x0F },
	{ 0x052D, 0x03 },
	{ 0x052E, 0x15 },
	{ 0x052F, 0x14 },
	{ 0x0531, 0x00 },
	{ 0x0532, 0xAB },
	{ 0x0533, 0xA0 },
	{ 0x0534, 0x01 },
	{ 0x0535, 0x00 },
	{ 0x0536, 0x00 },
	{ 0x0537, 0x00 },
	{ 0x0538, 0x00 },
	{ 0x0539, 0x00 },
	{ 0x053A, 0x02 },
	{ 0x053B, 0x03 },
	{ 0x053C, 0x00 },
	{ 0x053D, 0x11 },
	{ 0x053E, 0x06 },
	{ 0x0589, 0xD2 },
	{ 0x058A, 0x06 },
	{ 0x059B, 0xF8 },
	{ 0x059D, 0x17 },
	{ 0x059E, 0x28 },
	{ 0x059F, 0x0C },
	{ 0x05A0, 0x0B },
	{ 0x05A1, 0x07 },
	{ 0x05A2, 0x07 },
	{ 0x05A6, 0x00 },
	{ 0x0802, 0x35 },
	{ 0x0803, 0x05 },
	{ 0x0804, 0x00 },
	{ 0x0805, 0x00 },
	{ 0x0806, 0x00 },
	{ 0x0807, 0x00 },
	{ 0x0808, 0x00 },
	{ 0x0809, 0x00 },
	{ 0x080A, 0x00 },
	{ 0x080B, 0x00 },
	{ 0x080C, 0x00 },
	{ 0x080D, 0x00 },
	{ 0x080E, 0x00 },
	{ 0x080F, 0x00 },
	{ 0x0810, 0x00 },
	{ 0x0811, 0x00 },
	{ 0x0812, 0x00 },
	{ 0x0813, 0x00 },
	{ 0x0814, 0x00 },
	{ 0x0815, 0x00 },
	{ 0x0816, 0x00 },
	{ 0x0817, 0x00 },
	{ 0x0818, 0x00 },
	{ 0x0819, 0x00 },
	{ 0x081A, 0x00 },
	{ 0x081B, 0x00 },
	{ 0x081C, 0x00 },
	{ 0x081D, 0x00 },
	{ 0x081E, 0x00 },
	{ 0x081F, 0x00 },
	{ 0x0820, 0x00 },
	{ 0x0821, 0x00 },
	{ 0x0822, 0x00 },
	{ 0x0823, 0x00 },
	{ 0x0824, 0x00 },
	{ 0x0825, 0x00 },
	{ 0x0826, 0x00 },
	{ 0x0827, 0x00 },
	{ 0x0828, 0x00 },
	{ 0x0829, 0x00 },
	{ 0x082A, 0x00 },
	{ 0x082B, 0x00 },
	{ 0x082C, 0x00 },
	{ 0x082D, 0x00 },
	{ 0x082E, 0x00 },
	{ 0x082F, 0x00 },
	{ 0x0830, 0x00 },
	{ 0x0831, 0x00 },
	{ 0x0832, 0x00 },
	{ 0x0833, 0x00 },
	{ 0x0834, 0x00 },
	{ 0x0835, 0x00 },
	{ 0x0836, 0x00 },
	{ 0x0837, 0x00 },
	{ 0x0838, 0x00 },
	{ 0x0839, 0x00 },
	{ 0x083A, 0x00 },
	{ 0x083B, 0x00 },
	{ 0x083C, 0x00 },
	{ 0x083D, 0x00 },
	{ 0x083E, 0x00 },
	{ 0x083F, 0x00 },
	{ 0x0840, 0x00 },
	{ 0x0841, 0x00 },
	{ 0x0842, 0x00 },
	{ 0x0843, 0x00 },
	{ 0x0844, 0x00 },
	{ 0x0845, 0x00 },
	{ 0x0846, 0x00 },
	{ 0x0847, 0x00 },
	{ 0x0848, 0x00 },
	{ 0x0849, 0x00 },
	{ 0x084A, 0x00 },
	{ 0x084B, 0x00 },
	{ 0x084C, 0x00 },
	{ 0x084D, 0x00 },
	{ 0x084E, 0x00 },
	{ 0x084F, 0x00 },
	{ 0x0850, 0x00 },
	{ 0x0851, 0x00 },
	{ 0x0852, 0x00 },
	{ 0x0853, 0x00 },
	{ 0x0854, 0x00 },
	{ 0x0855, 0x00 },
	{ 0x0856, 0x00 },
	{ 0x0857, 0x00 },
	{ 0x0858, 0x00 },
	{ 0x0859, 0x00 },
	{ 0x085A, 0x00 },
	{ 0x085B, 0x00 },
	{ 0x085C, 0x00 },
	{ 0x085D, 0x00 },
	{ 0x085E, 0x00 },
	{ 0x085F, 0x00 },
	{ 0x0860, 0x00 },
	{ 0x0861, 0x00 },
	{ 0x090E, 0x03 },
	{ 0x0943, 0x00 },
	{ 0x0949, 0x31 },
	{ 0x094A, 0x01 },
	{ 0x094E, 0x49 },
	{ 0x094F, 0x02 },
	{ 0x095E, 0x00 },
	{ 0x0A02, 0x00 },
	{ 0x0A03, 0x07 },
	{ 0x0A04, 0x01 },
	{ 0x0A05, 0x07 },
	{ 0x0A14, 0x00 },
	{ 0x0A1A, 0x00 },
	{ 0x0A20, 0x00 },
	{ 0x0A26, 0x00 },
	{ 0x0A2C, 0x00 },
	{ 0x0B44, 0x0F },
	{ 0x0B46, 0x00 },
	{ 0x0B47, 0x0E },
	{ 0x0B48, 0x0E },
	{ 0x0B4A, 0x18 },
	{ 0x0B57, 0xF9 },
	{ 0x0B58, 0x00 },
	/* End configuration registers */

	/* Start configuration postamble */
	{ 0x0514, 0x01 },
	{ 0x001C, 0x01 },
	{ 0x0540, 0x00 },
	{ 0x0B24, 0xC3 },
	{ 0x0B25, 0x02 },
	/* End configuration postamble */

	{ 0x0000, 0x00 }
};

/*
 * Design Report
 *
 * Overview
 * ========
 * Part:         Si5345 Rev D
 * Project File: C:\XilinxProjects\flint_tr051017\genlock\FormatFiles\IO4K+_NTV2_FORMAT_525_5994.slabtimeproj
 * Design ID:    IO4K+
 * Created By:   ClockBuilder Pro v2.16.1 [2017-07-19]
 * Timestamp:    2017-08-24 16:05:28 GMT-07:00
 * 
 * Design Notes
 * ============
 * assumes NTSC HSYNC (pulsed) input = (30/1.001)*525
 * 
 * Design Rule Check
 * =================
 * Errors:
 * - No errors
 * 
 * Warnings:
 * - Pulsed LVCMOS input buffer mode has been selected. This mode has non-standard input voltage logic thresholds: 0.33 V for Vil (max) and 0.49 V for Vih (min). Select this mode only if your input clock has a duty cycle significantly less or more than 50%.  Refer to the device datasheet for the exact threshold voltage specifications and the input attenuator circuit (DC coupled Pulsed LVCMOS) in the Family Reference Manual.
 * 
 * Device Grade
 * ============
 * Maximum Output Frequency: 148.5 MHz
 * Frequency Synthesis Mode: Fractional
 * Minimum Base OPN:         Si5345B
 * Actual Base OPN:          Si5345B
 * 
 * Base       Output Clock         Supported Frequency Synthesis Modes
 * OPN Grade  Frequency Range      (Typical Jitter)
 * ---------  -------------------  --------------------------------------------
 * Si5345A    100 Hz to 1.028 GHz  Integer (< 100 fs) and fractional (< 150 fs)
 * Si5345B    100 Hz to 350 MHz    "
 * Si5345C    100 Hz to 1.028 GHz  Integer only (< 100 fs)
 * Si5345D    100 Hz to 350 MHz    "
 * 
 * Design
 * ======
 * Host Interface:
 *    I/O Power Supply: VDD (Core)
 *    SPI Mode: 4-Wire
 *    I2C Address Range: 100d to 103d / 0x64 to 0x67 (selected via A0/A1 pins)
 * 
 * XA/XB:
 *    52 MHz (XO - External Oscillator)
 * 
 * Inputs:
 *     IN0: 15.625 kHz [ 15 + 5/8 kHz ]
 *          [ (25)*625 ]
 *          Pulsed LVCMOS
 *     IN1: Unused
 *     IN2: Unused
 *     IN3: Unused
 * 
 * Outputs:
 *    OUT0: 27 MHz
 *          Enabled, LVDS 2.5 V
 *    OUT1: Unused
 *    OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT3: Unused
 *    OUT4: Unused
 *    OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT6: Unused
 *    OUT7: Unused
 *    OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *          [ 148.5/1.001 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT9: Unused
 * 
 * Frequency Plan
 * ==============
 * Priority: maximize the number of low jitter outputs
 * 
 * Fvco = 13.662 GHz [ 13 + 331/500 GHz ]
 * Fpfd = 15.625 kHz [ 15 + 5/8 kHz ]
 * Fms0 = 594 MHz
 * Fms1 = 147.456 MHz [ 147 + 57/125 MHz ]
 * Fms2 = 890.1098901098901098... MHz [ 890 + 10/91 MHz ]
 * 
 * P dividers:
 *    P0  = 1
 *    P1  = Unused
 *    P2  = Unused
 *    P3  = Unused
 *    Pxaxb = 1
 * 
 * MXAXB = 262.7307692307692307... [ 262 + 19/26 ]
 * M = 174873.6 [ 174873 + 3/5 ]
 * N dividers:
 *    N0:
 *       Value: 23
 *       Skew:  0.000 s
 *       OUT0: 27 MHz
 *       OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *    N1:
 *       Value: 92.6513671875 [ 92 + 667/1024 ]
 *       Skew:  0.000 s
 *       OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *    N2:
 *       Value: 15.3486666666666666... [ 15 + 523/1500 ]
 *       Skew:  0.000 s
 *       OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *    N3:
 *       Unused
 *    N4:
 *       Unused
 * 
 * R dividers:
 *    R0 = 22
 *    R1 = Unused
 *    R2 = 4
 *    R3 = Unused
 *    R4 = Unused
 *    R5 = 6
 *    R6 = Unused
 *    R7 = Unused
 *    R8 = 6
 *    R9 = Unused
 * 
 * Nominal Bandwidth:
 *   Desired: 1.000 Hz
 *   Actual:  602.746 mHz
 *   Coefficients:
 *      BW0:  16
 *      BW1:  24
 *      BW2:  15
 *      BW3:  15
 *      BW4:  7
 *      BW5:  7
 * Fastlock Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  98.305 Hz
 *   Coefficients:
 *      BW0:  23
 *      BW1:  40
 *      BW2:  12
 *      BW3:  11
 *      BW4:  7
 *      BW5:  7
 * Holdover Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  98.305 Hz
 *   Coefficients:
 *      BW0:  23
 *      BW1:  40
 *      BW2:  12
 *      BW3:  11
 *      BW4:  7
 *      BW5:  7
 * 
 * Dividers listed above show effective values. These values are translated to register settings by ClockBuilder Pro. For the actual register values, see below. Refer to the Family Reference Manual for information on registers related to frequency plan.
 * 
 * Digitally Controlled Oscillator (DCO)
 * =====================================
 * Mode: Register Direct Write
 * 
 * N0: DCO Disabled
 * 
 * N1: DCO Disabled
 * 
 * N2: DCO Disabled
 * 
 * N3: DCO Disabled
 * 
 * N4: DCO Disabled
 * 
 * Estimated Power & Junction Temperature
 * ======================================
 * Assumptions:
 * 
 * Revision: D
 * VDD:      1.8 V
 * Ta:       70 C
 * Airflow:  None
 * 
 * Total Power: 808 mW, On Chip Power: 784 mW, Tj: 87 C
 * 
 *                 Frequency  Format   Voltage   Current     Power
 *         -----------------  ------  --------  --------  --------
 * VDD                                   1.8 V  147.9 mA    266 mW
 * VDDA                                  3.3 V  117.4 mA    387 mW
 * VDDO0              27 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO1              Unused                                      
 * VDDO2           148.5 MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO3              Unused                                      
 * VDDO4              Unused                                      
 * VDDO5          24.576 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO6              Unused                                      
 * VDDO7              Unused                                      
 * VDDO8   148.351648... MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO9              Unused                                      
 *                                              --------  --------
 *                                       Total  327.2 mA    808 mW
 * 
 * Note:
 * 
 * -Total power includes on- and off-chip power. This is a typical value and estimate only.
 * -Use an EVB for a more exact power measurement
 * -On-chip power excludes power dissipated in external terminations.
 * -Tj is junction temperature. Tj must be less than 125 C (on Si5345 Revision D) for device to comply with datasheet specifications.
 * 
 * Settings
 * ========
 * 
 * Location      Setting Name           Decimal Value      Hex Value        
 * ------------  ---------------------  -----------------  -----------------
 * 0x000B[6:0]   I2C_ADDR               100                0x64             
 * 0x0016[1]     LOL_ON_HOLD            1                  0x1              
 * 0x0017[0]     SYSINCAL_INTR_MSK      0                  0x0              
 * 0x0017[1]     LOSXAXB_INTR_MSK       0                  0x0              
 * 0x0017[5]     SMB_TMOUT_INTR_MSK     1                  0x1              
 * 0x0018[3:0]   LOS_INTR_MSK           15                 0xF              
 * 0x0018[7:4]   OOF_INTR_MSK           15                 0xF              
 * 0x0019[1]     LOL_INTR_MSK           1                  0x1              
 * 0x0019[5]     HOLD_INTR_MSK          0                  0x0              
 * 0x001A[5]     CAL_INTR_MSK           0                  0x0              
 * 0x002B[3]     SPI_3WIRE              0                  0x0              
 * 0x002B[5]     AUTO_NDIV_UPDATE       0                  0x0              
 * 0x002C[3:0]   LOS_EN                 1                  0x1              
 * 0x002C[4]     LOSXAXB_DIS            0                  0x0              
 * 0x002D[1:0]   LOS0_VAL_TIME          2                  0x2              
 * 0x002D[3:2]   LOS1_VAL_TIME          0                  0x0              
 * 0x002D[5:4]   LOS2_VAL_TIME          0                  0x0              
 * 0x002D[7:6]   LOS3_VAL_TIME          0                  0x0              
 * 0x002E[15:0]  LOS0_TRG_THR           4197               0x1065           
 * 0x0030[15:0]  LOS1_TRG_THR           0                  0x0000           
 * 0x0032[15:0]  LOS2_TRG_THR           0                  0x0000           
 * 0x0034[15:0]  LOS3_TRG_THR           0                  0x0000           
 * 0x0036[15:0]  LOS0_CLR_THR           3848               0x0F08           
 * 0x0038[15:0]  LOS1_CLR_THR           0                  0x0000           
 * 0x003A[15:0]  LOS2_CLR_THR           0                  0x0000           
 * 0x003C[15:0]  LOS3_CLR_THR           0                  0x0000           
 * 0x003F[3:0]   OOF_EN                 1                  0x1              
 * 0x003F[7:4]   FAST_OOF_EN            0                  0x0              
 * 0x0040[2:0]   OOF_REF_SEL            4                  0x4              
 * 0x0041[4:0]   OOF0_DIV_SEL           0                  0x00             
 * 0x0042[4:0]   OOF1_DIV_SEL           0                  0x00             
 * 0x0043[4:0]   OOF2_DIV_SEL           0                  0x00             
 * 0x0044[4:0]   OOF3_DIV_SEL           0                  0x00             
 * 0x0045[4:0]   OOFXO_DIV_SEL          12                 0x0C             
 * 0x0046[7:0]   OOF0_SET_THR           150                0x96             
 * 0x0047[7:0]   OOF1_SET_THR           0                  0x00             
 * 0x0048[7:0]   OOF2_SET_THR           0                  0x00             
 * 0x0049[7:0]   OOF3_SET_THR           0                  0x00             
 * 0x004A[7:0]   OOF0_CLR_THR           75                 0x4B             
 * 0x004B[7:0]   OOF1_CLR_THR           0                  0x00             
 * 0x004C[7:0]   OOF2_CLR_THR           0                  0x00             
 * 0x004D[7:0]   OOF3_CLR_THR           0                  0x00             
 * 0x004E[2:0]   OOF0_DETWIN_SEL        5                  0x5              
 * 0x004E[6:4]   OOF1_DETWIN_SEL        0                  0x0              
 * 0x004F[2:0]   OOF2_DETWIN_SEL        0                  0x0              
 * 0x004F[6:4]   OOF3_DETWIN_SEL        0                  0x0              
 * 0x0050[3:0]   OOF_ON_LOS             15                 0xF              
 * 0x0051[3:0]   FAST_OOF0_SET_THR      0                  0x0              
 * 0x0052[3:0]   FAST_OOF1_SET_THR      0                  0x0              
 * 0x0053[3:0]   FAST_OOF2_SET_THR      0                  0x0              
 * 0x0054[3:0]   FAST_OOF3_SET_THR      0                  0x0              
 * 0x0055[3:0]   FAST_OOF0_CLR_THR      0                  0x0              
 * 0x0056[3:0]   FAST_OOF1_CLR_THR      0                  0x0              
 * 0x0057[3:0]   FAST_OOF2_CLR_THR      0                  0x0              
 * 0x0058[3:0]   FAST_OOF3_CLR_THR      0                  0x0              
 * 0x0059[1:0]   FAST_OOF0_DETWIN_SEL   1                  0x1              
 * 0x0059[3:2]   FAST_OOF1_DETWIN_SEL   0                  0x0              
 * 0x0059[5:4]   FAST_OOF2_DETWIN_SEL   0                  0x0              
 * 0x0059[7:6]   FAST_OOF3_DETWIN_SEL   0                  0x0              
 * 0x005A[25:0]  OOF0_RATIO_REF         20648881           0x13B13B1        
 * 0x005E[25:0]  OOF1_RATIO_REF         0                  0x0000000        
 * 0x0062[25:0]  OOF2_RATIO_REF         0                  0x0000000        
 * 0x0066[25:0]  OOF3_RATIO_REF         0                  0x0000000        
 * 0x0092[1]     LOL_FST_EN             1                  0x1              
 * 0x0093[7:4]   LOL_FST_DETWIN_SEL     10                 0xA              
 * 0x0095[3:2]   LOL_FST_VALWIN_SEL     0                  0x0              
 * 0x0096[7:4]   LOL_FST_SET_THR_SEL    9                  0x9              
 * 0x0098[7:4]   LOL_FST_CLR_THR_SEL    7                  0x7              
 * 0x009A[1]     LOL_SLOW_EN_PLL        1                  0x1              
 * 0x009B[7:4]   LOL_SLW_DETWIN_SEL     5                  0x5              
 * 0x009D[3:2]   LOL_SLW_VALWIN_SEL     1                  0x1              
 * 0x009E[7:4]   LOL_SLW_SET_THR        6                  0x6              
 * 0x00A0[7:4]   LOL_SLW_CLR_THR        3                  0x3              
 * 0x00A2[1]     LOL_TIMER_EN           0                  0x0              
 * 0x00A9[28:0]  LOL_CLR_DELAY_DIV256   298524             0x00048E1C       
 * 0x00E5[5]     FASTLOCK_EXTEND_EN     1                  0x1              
 * 0x00EA[28:0]  FASTLOCK_EXTEND        242129             0x0003B1D1       
 * 0x0102[0]     OUTALL_DISABLE_LOW     1                  0x1              
 * 0x0108[0]     OUT0_PDN               0                  0x0              
 * 0x0108[1]     OUT0_OE                1                  0x1              
 * 0x0108[2]     OUT0_RDIV_FORCE2       0                  0x0              
 * 0x0109[2:0]   OUT0_FORMAT            1                  0x1              
 * 0x0109[3]     OUT0_SYNC_EN           1                  0x1              
 * 0x0109[5:4]   OUT0_DIS_STATE         0                  0x0              
 * 0x0109[7:6]   OUT0_CMOS_DRV          0                  0x0              
 * 0x010A[3:0]   OUT0_CM                11                 0xB              
 * 0x010A[6:4]   OUT0_AMPL              3                  0x3              
 * 0x010B[2:0]   OUT0_MUX_SEL           0                  0x0              
 * 0x010B[5:4]   OUT0_VDD_SEL           2                  0x2              
 * 0x010B[3]     OUT0_VDD_SEL_EN        1                  0x1              
 * 0x010B[7:6]   OUT0_INV               0                  0x0              
 * 0x010D[0]     OUT1_PDN               1                  0x1              
 * 0x010D[1]     OUT1_OE                0                  0x0              
 * 0x010D[2]     OUT1_RDIV_FORCE2       0                  0x0              
 * 0x010E[2:0]   OUT1_FORMAT            1                  0x1              
 * 0x010E[3]     OUT1_SYNC_EN           1                  0x1              
 * 0x010E[5:4]   OUT1_DIS_STATE         0                  0x0              
 * 0x010E[7:6]   OUT1_CMOS_DRV          0                  0x0              
 * 0x010F[3:0]   OUT1_CM                11                 0xB              
 * 0x010F[6:4]   OUT1_AMPL              3                  0x3              
 * 0x0110[2:0]   OUT1_MUX_SEL           0                  0x0              
 * 0x0110[5:4]   OUT1_VDD_SEL           2                  0x2              
 * 0x0110[3]     OUT1_VDD_SEL_EN        1                  0x1              
 * 0x0110[7:6]   OUT1_INV               0                  0x0              
 * 0x0112[0]     OUT2_PDN               0                  0x0              
 * 0x0112[1]     OUT2_OE                1                  0x1              
 * 0x0112[2]     OUT2_RDIV_FORCE2       0                  0x0              
 * 0x0113[2:0]   OUT2_FORMAT            1                  0x1              
 * 0x0113[3]     OUT2_SYNC_EN           1                  0x1              
 * 0x0113[5:4]   OUT2_DIS_STATE         0                  0x0              
 * 0x0113[7:6]   OUT2_CMOS_DRV          0                  0x0              
 * 0x0114[3:0]   OUT2_CM                11                 0xB              
 * 0x0114[6:4]   OUT2_AMPL              3                  0x3              
 * 0x0115[2:0]   OUT2_MUX_SEL           0                  0x0              
 * 0x0115[5:4]   OUT2_VDD_SEL           2                  0x2              
 * 0x0115[3]     OUT2_VDD_SEL_EN        1                  0x1              
 * 0x0115[7:6]   OUT2_INV               0                  0x0              
 * 0x0117[0]     OUT3_PDN               1                  0x1              
 * 0x0117[1]     OUT3_OE                0                  0x0              
 * 0x0117[2]     OUT3_RDIV_FORCE2       0                  0x0              
 * 0x0118[2:0]   OUT3_FORMAT            1                  0x1              
 * 0x0118[3]     OUT3_SYNC_EN           1                  0x1              
 * 0x0118[5:4]   OUT3_DIS_STATE         0                  0x0              
 * 0x0118[7:6]   OUT3_CMOS_DRV          0                  0x0              
 * 0x0119[3:0]   OUT3_CM                11                 0xB              
 * 0x0119[6:4]   OUT3_AMPL              3                  0x3              
 * 0x011A[2:0]   OUT3_MUX_SEL           0                  0x0              
 * 0x011A[5:4]   OUT3_VDD_SEL           2                  0x2              
 * 0x011A[3]     OUT3_VDD_SEL_EN        1                  0x1              
 * 0x011A[7:6]   OUT3_INV               0                  0x0              
 * 0x011C[0]     OUT4_PDN               1                  0x1              
 * 0x011C[1]     OUT4_OE                0                  0x0              
 * 0x011C[2]     OUT4_RDIV_FORCE2       0                  0x0              
 * 0x011D[2:0]   OUT4_FORMAT            1                  0x1              
 * 0x011D[3]     OUT4_SYNC_EN           1                  0x1              
 * 0x011D[5:4]   OUT4_DIS_STATE         0                  0x0              
 * 0x011D[7:6]   OUT4_CMOS_DRV          0                  0x0              
 * 0x011E[3:0]   OUT4_CM                11                 0xB              
 * 0x011E[6:4]   OUT4_AMPL              3                  0x3              
 * 0x011F[2:0]   OUT4_MUX_SEL           0                  0x0              
 * 0x011F[5:4]   OUT4_VDD_SEL           2                  0x2              
 * 0x011F[3]     OUT4_VDD_SEL_EN        1                  0x1              
 * 0x011F[7:6]   OUT4_INV               0                  0x0              
 * 0x0121[0]     OUT5_PDN               0                  0x0              
 * 0x0121[1]     OUT5_OE                1                  0x1              
 * 0x0121[2]     OUT5_RDIV_FORCE2       0                  0x0              
 * 0x0122[2:0]   OUT5_FORMAT            1                  0x1              
 * 0x0122[3]     OUT5_SYNC_EN           1                  0x1              
 * 0x0122[5:4]   OUT5_DIS_STATE         0                  0x0              
 * 0x0122[7:6]   OUT5_CMOS_DRV          0                  0x0              
 * 0x0123[3:0]   OUT5_CM                11                 0xB              
 * 0x0123[6:4]   OUT5_AMPL              3                  0x3              
 * 0x0124[2:0]   OUT5_MUX_SEL           1                  0x1              
 * 0x0124[5:4]   OUT5_VDD_SEL           2                  0x2              
 * 0x0124[3]     OUT5_VDD_SEL_EN        1                  0x1              
 * 0x0124[7:6]   OUT5_INV               0                  0x0              
 * 0x0126[0]     OUT6_PDN               1                  0x1              
 * 0x0126[1]     OUT6_OE                0                  0x0              
 * 0x0126[2]     OUT6_RDIV_FORCE2       0                  0x0              
 * 0x0127[2:0]   OUT6_FORMAT            1                  0x1              
 * 0x0127[3]     OUT6_SYNC_EN           1                  0x1              
 * 0x0127[5:4]   OUT6_DIS_STATE         0                  0x0              
 * 0x0127[7:6]   OUT6_CMOS_DRV          0                  0x0              
 * 0x0128[3:0]   OUT6_CM                11                 0xB              
 * 0x0128[6:4]   OUT6_AMPL              3                  0x3              
 * 0x0129[2:0]   OUT6_MUX_SEL           0                  0x0              
 * 0x0129[5:4]   OUT6_VDD_SEL           2                  0x2              
 * 0x0129[3]     OUT6_VDD_SEL_EN        1                  0x1              
 * 0x0129[7:6]   OUT6_INV               0                  0x0              
 * 0x012B[0]     OUT7_PDN               1                  0x1              
 * 0x012B[1]     OUT7_OE                0                  0x0              
 * 0x012B[2]     OUT7_RDIV_FORCE2       0                  0x0              
 * 0x012C[2:0]   OUT7_FORMAT            1                  0x1              
 * 0x012C[3]     OUT7_SYNC_EN           1                  0x1              
 * 0x012C[5:4]   OUT7_DIS_STATE         0                  0x0              
 * 0x012C[7:6]   OUT7_CMOS_DRV          0                  0x0              
 * 0x012D[3:0]   OUT7_CM                11                 0xB              
 * 0x012D[6:4]   OUT7_AMPL              3                  0x3              
 * 0x012E[2:0]   OUT7_MUX_SEL           0                  0x0              
 * 0x012E[5:4]   OUT7_VDD_SEL           2                  0x2              
 * 0x012E[3]     OUT7_VDD_SEL_EN        1                  0x1              
 * 0x012E[7:6]   OUT7_INV               0                  0x0              
 * 0x0130[0]     OUT8_PDN               0                  0x0              
 * 0x0130[1]     OUT8_OE                1                  0x1              
 * 0x0130[2]     OUT8_RDIV_FORCE2       0                  0x0              
 * 0x0131[2:0]   OUT8_FORMAT            1                  0x1              
 * 0x0131[3]     OUT8_SYNC_EN           1                  0x1              
 * 0x0131[5:4]   OUT8_DIS_STATE         0                  0x0              
 * 0x0131[7:6]   OUT8_CMOS_DRV          0                  0x0              
 * 0x0132[3:0]   OUT8_CM                11                 0xB              
 * 0x0132[6:4]   OUT8_AMPL              3                  0x3              
 * 0x0133[2:0]   OUT8_MUX_SEL           2                  0x2              
 * 0x0133[5:4]   OUT8_VDD_SEL           2                  0x2              
 * 0x0133[3]     OUT8_VDD_SEL_EN        1                  0x1              
 * 0x0133[7:6]   OUT8_INV               0                  0x0              
 * 0x013A[0]     OUT9_PDN               1                  0x1              
 * 0x013A[1]     OUT9_OE                0                  0x0              
 * 0x013A[2]     OUT9_RDIV_FORCE2       0                  0x0              
 * 0x013B[2:0]   OUT9_FORMAT            1                  0x1              
 * 0x013B[3]     OUT9_SYNC_EN           1                  0x1              
 * 0x013B[5:4]   OUT9_DIS_STATE         0                  0x0              
 * 0x013B[7:6]   OUT9_CMOS_DRV          0                  0x0              
 * 0x013C[3:0]   OUT9_CM                11                 0xB              
 * 0x013C[6:4]   OUT9_AMPL              3                  0x3              
 * 0x013D[2:0]   OUT9_MUX_SEL           0                  0x0              
 * 0x013D[5:4]   OUT9_VDD_SEL           2                  0x2              
 * 0x013D[3]     OUT9_VDD_SEL_EN        1                  0x1              
 * 0x013D[7:6]   OUT9_INV               0                  0x0              
 * 0x013F[11:0]  OUTX_ALWAYS_ON         0                  0x000            
 * 0x0141[1]     OUT_DIS_MSK            0                  0x0              
 * 0x0141[5]     OUT_DIS_LOL_MSK        0                  0x0              
 * 0x0141[6]     OUT_DIS_LOSXAXB_MSK    1                  0x1              
 * 0x0141[7]     OUT_DIS_MSK_LOS_PFD    0                  0x0              
 * 0x0142[1]     OUT_DIS_MSK_LOL        1                  0x1              
 * 0x0142[5]     OUT_DIS_MSK_HOLD       1                  0x1              
 * 0x0206[1:0]   PXAXB                  0                  0x0              
 * 0x0208[47:0]  P0_NUM                 1                  0x000000000001   
 * 0x020E[31:0]  P0_DEN                 1                  0x00000001       
 * 0x0212[47:0]  P1_NUM                 0                  0x000000000000   
 * 0x0218[31:0]  P1_DEN                 0                  0x00000000       
 * 0x021C[47:0]  P2_NUM                 0                  0x000000000000   
 * 0x0222[31:0]  P2_DEN                 0                  0x00000000       
 * 0x0226[47:0]  P3_NUM                 0                  0x000000000000   
 * 0x022C[31:0]  P3_DEN                 0                  0x00000000       
 * 0x0231[3:0]   P0_FRACN_MODE          11                 0xB              
 * 0x0231[4]     P0_FRACN_EN            0                  0x0              
 * 0x0232[3:0]   P1_FRACN_MODE          11                 0xB              
 * 0x0232[4]     P1_FRACN_EN            0                  0x0              
 * 0x0233[3:0]   P2_FRACN_MODE          11                 0xB              
 * 0x0233[4]     P2_FRACN_EN            0                  0x0              
 * 0x0234[3:0]   P3_FRACN_MODE          11                 0xB              
 * 0x0234[4]     P3_FRACN_EN            0                  0x0              
 * 0x0235[43:0]  MXAXB_NUM              916841299968       0x0D578000000    
 * 0x023B[31:0]  MXAXB_DEN              3489660928         0xD0000000       
 * 0x024A[23:0]  R0_REG                 10                 0x00000A         
 * 0x024D[23:0]  R1_REG                 0                  0x000000         
 * 0x0250[23:0]  R2_REG                 1                  0x000001         
 * 0x0253[23:0]  R3_REG                 0                  0x000000         
 * 0x0256[23:0]  R4_REG                 0                  0x000000         
 * 0x0259[23:0]  R5_REG                 2                  0x000002         
 * 0x025C[23:0]  R6_REG                 0                  0x000000         
 * 0x025F[23:0]  R7_REG                 0                  0x000000         
 * 0x0262[23:0]  R8_REG                 2                  0x000002         
 * 0x0268[23:0]  R9_REG                 0                  0x000000         
 * 0x026B[7:0]   DESIGN_ID0             73                 0x49             
 * 0x026C[7:0]   DESIGN_ID1             79                 0x4F             
 * 0x026D[7:0]   DESIGN_ID2             52                 0x34             
 * 0x026E[7:0]   DESIGN_ID3             75                 0x4B             
 * 0x026F[7:0]   DESIGN_ID4             43                 0x2B             
 * 0x0270[7:0]   DESIGN_ID5             0                  0x00             
 * 0x0271[7:0]   DESIGN_ID6             0                  0x00             
 * 0x0272[7:0]   DESIGN_ID7             0                  0x00             
 * 0x0294[7:4]   FASTLOCK_EXTEND_SCL    8                  0x8              
 * 0x0296[1]     LOL_SLW_VALWIN_SELX    0                  0x0              
 * 0x0297[1]     FASTLOCK_DLY_ONSW_EN   1                  0x1              
 * 0x0299[1]     FASTLOCK_DLY_ONLOL_EN  1                  0x1              
 * 0x029D[19:0]  FASTLOCK_DLY_ONLOL     3829               0x00EF5          
 * 0x02A9[19:0]  FASTLOCK_DLY_ONSW      9830               0x02666          
 * 0x02B7[3:2]   LOL_NOSIG_TIME         3                  0x3              
 * 0x0302[43:0]  N0_NUM                 49392123904        0x00B80000000    
 * 0x0308[31:0]  N0_DEN                 2147483648         0x80000000       
 * 0x030C[0]     N0_UPDATE              0                  0x0              
 * 0x030D[43:0]  N1_NUM                 198967296000       0x02E53600000    
 * 0x0313[31:0]  N1_DEN                 2147483648         0x80000000       
 * 0x0317[0]     N1_UPDATE              0                  0x0              
 * 0x0318[43:0]  N2_NUM                 48282730496        0x00B3DE00000    
 * 0x031E[31:0]  N2_DEN                 3145728000         0xBB800000       
 * 0x0322[0]     N2_UPDATE              0                  0x0              
 * 0x0323[43:0]  N3_NUM                 0                  0x00000000000    
 * 0x0329[31:0]  N3_DEN                 0                  0x00000000       
 * 0x032D[0]     N3_UPDATE              0                  0x0              
 * 0x032E[43:0]  N4_NUM                 0                  0x00000000000    
 * 0x0334[31:0]  N4_DEN                 0                  0x00000000       
 * 0x0338[0]     N4_UPDATE              0                  0x0              
 * 0x0338[1]     N_UPDATE               0                  0x0              
 * 0x0339[4:0]   N_FSTEP_MSK            31                 0x1F             
 * 0x033B[43:0]  N0_FSTEPW              0                  0x00000000000    
 * 0x0341[43:0]  N1_FSTEPW              0                  0x00000000000    
 * 0x0347[43:0]  N2_FSTEPW              0                  0x00000000000    
 * 0x034D[43:0]  N3_FSTEPW              0                  0x00000000000    
 * 0x0353[43:0]  N4_FSTEPW              0                  0x00000000000    
 * 0x0359[15:0]  N0_DELAY               0                  0x0000           
 * 0x035B[15:0]  N1_DELAY               0                  0x0000           
 * 0x035D[15:0]  N2_DELAY               0                  0x0000           
 * 0x035F[15:0]  N3_DELAY               0                  0x0000           
 * 0x0361[15:0]  N4_DELAY               0                  0x0000           
 * 0x0487[0]     ZDM_EN                 0                  0x0              
 * 0x0487[2:1]   ZDM_IN_SEL             0                  0x0              
 * 0x0487[4]     ZDM_AUTOSW_EN          0                  0x0              
 * 0x0502[4]     ADD_DIV256             0                  0x0              
 * 0x0508[5:0]   BW0_PLL                16                 0x10             
 * 0x0509[5:0]   BW1_PLL                24                 0x18             
 * 0x050A[5:0]   BW2_PLL                15                 0x0F             
 * 0x050B[5:0]   BW3_PLL                15                 0x0F             
 * 0x050C[5:0]   BW4_PLL                7                  0x07             
 * 0x050D[5:0]   BW5_PLL                7                  0x07             
 * 0x050E[5:0]   FASTLOCK_BW0_PLL       23                 0x17             
 * 0x050F[5:0]   FASTLOCK_BW1_PLL       40                 0x28             
 * 0x0510[5:0]   FASTLOCK_BW2_PLL       12                 0x0C             
 * 0x0511[5:0]   FASTLOCK_BW3_PLL       11                 0x0B             
 * 0x0512[5:0]   FASTLOCK_BW4_PLL       7                  0x07             
 * 0x0513[5:0]   FASTLOCK_BW5_PLL       7                  0x07             
 * 0x0515[55:0]  M_NUM                  469422745583616    0x01AAF000000000 
 * 0x051C[31:0]  M_DEN                  2684354560         0xA0000000       
 * 0x0521[3:0]   M_FRAC_MODE            11                 0xB              
 * 0x0521[4]     M_FRAC_EN              1                  0x1              
 * 0x0521[5]     PLL_OUT_RATE_SEL       1                  0x1              
 * 0x052A[0]     IN_SEL_REGCTRL         1                  0x1              
 * 0x052A[3:1]   IN_SEL                 0                  0x0              
 * 0x052B[0]     FASTLOCK_AUTO_EN       1                  0x1              
 * 0x052B[1]     FASTLOCK_MAN           0                  0x0              
 * 0x052C[0]     HOLD_EN                1                  0x1              
 * 0x052C[3]     HOLD_RAMP_BYP          1                  0x1              
 * 0x052C[4]     HOLDEXIT_BW_SEL1       0                  0x0              
 * 0x052C[7:5]   RAMP_STEP_INTERVAL     0                  0x0              
 * 0x052D[1]     HOLD_RAMPBYP_NOHIST    1                  0x1              
 * 0x052E[4:0]   HOLD_HIST_LEN          21                 0x15             
 * 0x052F[4:0]   HOLD_HIST_DELAY        20                 0x14             
 * 0x0531[4:0]   HOLD_REF_COUNT_FRC     0                  0x00             
 * 0x0532[23:0]  HOLD_15M_CYC_COUNT     106667             0x01A0AB         
 * 0x0535[0]     FORCE_HOLD             0                  0x0              
 * 0x0536[1:0]   CLK_SWITCH_MODE        0                  0x0              
 * 0x0536[2]     HSW_EN                 0                  0x0              
 * 0x0537[3:0]   IN_LOS_MSK             0                  0x0              
 * 0x0537[7:4]   IN_OOF_MSK             0                  0x0              
 * 0x0538[2:0]   IN0_PRIORITY           0                  0x0              
 * 0x0538[6:4]   IN1_PRIORITY           0                  0x0              
 * 0x0539[2:0]   IN2_PRIORITY           0                  0x0              
 * 0x0539[6:4]   IN3_PRIORITY           0                  0x0              
 * 0x053A[1:0]   HSW_MODE               2                  0x2              
 * 0x053A[3:2]   HSW_PHMEAS_CTRL        0                  0x0              
 * 0x053B[9:0]   HSW_PHMEAS_THR         3                  0x003            
 * 0x053D[4:0]   HSW_COARSE_PM_LEN      17                 0x11             
 * 0x053E[4:0]   HSW_COARSE_PM_DLY      6                  0x06             
 * 0x0589[12:0]  CAP_SHORT_DELAY        1746               0x06D2           
 * 0x059B[4]     HOLD_PRESERVE_HIST     1                  0x1              
 * 0x059B[5]     HOLD_FRZ_WITH_INTONLY  1                  0x1              
 * 0x059B[6]     HOLDEXIT_BW_SEL0       1                  0x1              
 * 0x059B[7]     HOLDEXIT_STD_BO        1                  0x1              
 * 0x059D[5:0]   HOLDEXIT_BW0           23                 0x17             
 * 0x059E[5:0]   HOLDEXIT_BW1           40                 0x28             
 * 0x059F[5:0]   HOLDEXIT_BW2           12                 0x0C             
 * 0x05A0[5:0]   HOLDEXIT_BW3           11                 0x0B             
 * 0x05A1[5:0]   HOLDEXIT_BW4           7                  0x07             
 * 0x05A2[5:0]   HOLDEXIT_BW5           7                  0x07             
 * 0x05A6[2:0]   RAMP_STEP_SIZE         0                  0x0              
 * 0x05A6[3]     RAMP_SWITCH_EN         0                  0x0              
 * 0x0802[15:0]  FIXREGSA0              1333               0x0535           
 * 0x0804[7:0]   FIXREGSD0              0                  0x00             
 * 0x0805[15:0]  FIXREGSA1              0                  0x0000           
 * 0x0807[7:0]   FIXREGSD1              0                  0x00             
 * 0x0808[15:0]  FIXREGSA2              0                  0x0000           
 * 0x080A[7:0]   FIXREGSD2              0                  0x00             
 * 0x080B[15:0]  FIXREGSA3              0                  0x0000           
 * 0x080D[7:0]   FIXREGSD3              0                  0x00             
 * 0x080E[15:0]  FIXREGSA4              0                  0x0000           
 * 0x0810[7:0]   FIXREGSD4              0                  0x00             
 * 0x0811[15:0]  FIXREGSA5              0                  0x0000           
 * 0x0813[7:0]   FIXREGSD5              0                  0x00             
 * 0x0814[15:0]  FIXREGSA6              0                  0x0000           
 * 0x0816[7:0]   FIXREGSD6              0                  0x00             
 * 0x0817[15:0]  FIXREGSA7              0                  0x0000           
 * 0x0819[7:0]   FIXREGSD7              0                  0x00             
 * 0x081A[15:0]  FIXREGSA8              0                  0x0000           
 * 0x081C[7:0]   FIXREGSD8              0                  0x00             
 * 0x081D[15:0]  FIXREGSA9              0                  0x0000           
 * 0x081F[7:0]   FIXREGSD9              0                  0x00             
 * 0x0820[15:0]  FIXREGSA10             0                  0x0000           
 * 0x0822[7:0]   FIXREGSD10             0                  0x00             
 * 0x0823[15:0]  FIXREGSA11             0                  0x0000           
 * 0x0825[7:0]   FIXREGSD11             0                  0x00             
 * 0x0826[15:0]  FIXREGSA12             0                  0x0000           
 * 0x0828[7:0]   FIXREGSD12             0                  0x00             
 * 0x0829[15:0]  FIXREGSA13             0                  0x0000           
 * 0x082B[7:0]   FIXREGSD13             0                  0x00             
 * 0x082C[15:0]  FIXREGSA14             0                  0x0000           
 * 0x082E[7:0]   FIXREGSD14             0                  0x00             
 * 0x082F[15:0]  FIXREGSA15             0                  0x0000           
 * 0x0831[7:0]   FIXREGSD15             0                  0x00             
 * 0x0832[15:0]  FIXREGSA16             0                  0x0000           
 * 0x0834[7:0]   FIXREGSD16             0                  0x00             
 * 0x0835[15:0]  FIXREGSA17             0                  0x0000           
 * 0x0837[7:0]   FIXREGSD17             0                  0x00             
 * 0x0838[15:0]  FIXREGSA18             0                  0x0000           
 * 0x083A[7:0]   FIXREGSD18             0                  0x00             
 * 0x083B[15:0]  FIXREGSA19             0                  0x0000           
 * 0x083D[7:0]   FIXREGSD19             0                  0x00             
 * 0x083E[15:0]  FIXREGSA20             0                  0x0000           
 * 0x0840[7:0]   FIXREGSD20             0                  0x00             
 * 0x0841[15:0]  FIXREGSA21             0                  0x0000           
 * 0x0843[7:0]   FIXREGSD21             0                  0x00             
 * 0x0844[15:0]  FIXREGSA22             0                  0x0000           
 * 0x0846[7:0]   FIXREGSD22             0                  0x00             
 * 0x0847[15:0]  FIXREGSA23             0                  0x0000           
 * 0x0849[7:0]   FIXREGSD23             0                  0x00             
 * 0x084A[15:0]  FIXREGSA24             0                  0x0000           
 * 0x084C[7:0]   FIXREGSD24             0                  0x00             
 * 0x084D[15:0]  FIXREGSA25             0                  0x0000           
 * 0x084F[7:0]   FIXREGSD25             0                  0x00             
 * 0x0850[15:0]  FIXREGSA26             0                  0x0000           
 * 0x0852[7:0]   FIXREGSD26             0                  0x00             
 * 0x0853[15:0]  FIXREGSA27             0                  0x0000           
 * 0x0855[7:0]   FIXREGSD27             0                  0x00             
 * 0x0856[15:0]  FIXREGSA28             0                  0x0000           
 * 0x0858[7:0]   FIXREGSD28             0                  0x00             
 * 0x0859[15:0]  FIXREGSA29             0                  0x0000           
 * 0x085B[7:0]   FIXREGSD29             0                  0x00             
 * 0x085C[15:0]  FIXREGSA30             0                  0x0000           
 * 0x085E[7:0]   FIXREGSD30             0                  0x00             
 * 0x085F[15:0]  FIXREGSA31             0                  0x0000           
 * 0x0861[7:0]   FIXREGSD31             0                  0x00             
 * 0x090E[0]     XAXB_EXTCLK_EN         1                  0x1              
 * 0x0943[0]     IO_VDD_SEL             0                  0x0              
 * 0x0949[3:0]   IN_EN                  1                  0x1              
 * 0x0949[7:4]   IN_PULSED_CMOS_EN      3                  0x3              
 * 0x094A[3:0]   INX_TO_PFD_EN          1                  0x1              
 * 0x094E[11:0]  REFCLK_HYS_SEL         585                0x249            
 * 0x095E[0]     MXAXB_INTEGER          0                  0x0              
 * 0x0A02[4:0]   N_ADD_0P5              0                  0x00             
 * 0x0A03[4:0]   N_CLK_TO_OUTX_EN       7                  0x07             
 * 0x0A04[4:0]   N_PIBYP                1                  0x01             
 * 0x0A05[4:0]   N_PDNB                 7                  0x07             
 * 0x0A14[3]     N0_HIGH_FREQ           0                  0x0              
 * 0x0A1A[3]     N1_HIGH_FREQ           0                  0x0              
 * 0x0A20[3]     N2_HIGH_FREQ           0                  0x0              
 * 0x0A26[3]     N3_HIGH_FREQ           0                  0x0              
 * 0x0A2C[3]     N4_HIGH_FREQ           0                  0x0              
 * 0x0B44[3:0]   PDIV_FRACN_CLK_DIS     15                 0xF              
 * 0x0B44[5]     FRACN_CLK_DIS_PLL      0                  0x0              
 * 0x0B46[3:0]   LOS_CLK_DIS            0                  0x0              
 * 0x0B47[4:0]   OOF_CLK_DIS            14                 0x0E             
 * 0x0B48[4:0]   OOF_DIV_CLK_DIS        14                 0x0E             
 * 0x0B4A[4:0]   N_CLK_DIS              24                 0x18             
 * 0x0B57[11:0]  VCO_RESET_CALCODE      249                0x0F9
 * 
 *
 */


static struct ntv2_genlock_data s_genlock_750_5000[] =
{
	/* Start configuration preamble */
	{ 0x0B24, 0xC0 },
	{ 0x0B25, 0x00 },
	{ 0x0540, 0x01 },
	/* End configuration preamble */

	/* Delay 300 msec */
	/*    Delay is worst case time for device to complete any calibration */
	/*    that is running due to device state change previous to this script */
	/*    being processed. */
	{ 0x0000, 0x01 },

	/* Start configuration registers */
	{ 0x000B, 0x64 },
	{ 0x0016, 0x02 },
	{ 0x0017, 0xFC },
	{ 0x0018, 0xFF },
	{ 0x0019, 0xDF },
	{ 0x001A, 0xDF },
	{ 0x002B, 0x02 },
	{ 0x002C, 0x01 },
	{ 0x002D, 0x02 },
	{ 0x002E, 0xD5 },
	{ 0x002F, 0x06 },
	{ 0x0030, 0x00 },
	{ 0x0031, 0x00 },
	{ 0x0032, 0x00 },
	{ 0x0033, 0x00 },
	{ 0x0034, 0x00 },
	{ 0x0035, 0x00 },
	{ 0x0036, 0x44 },
	{ 0x0037, 0x06 },
	{ 0x0038, 0x00 },
	{ 0x0039, 0x00 },
	{ 0x003A, 0x00 },
	{ 0x003B, 0x00 },
	{ 0x003C, 0x00 },
	{ 0x003D, 0x00 },
	{ 0x003F, 0x01 },
	{ 0x0040, 0x04 },
	{ 0x0041, 0x02 },
	{ 0x0042, 0x00 },
	{ 0x0043, 0x00 },
	{ 0x0044, 0x00 },
	{ 0x0045, 0x0C },
	{ 0x0046, 0x96 },
	{ 0x0047, 0x00 },
	{ 0x0048, 0x00 },
	{ 0x0049, 0x00 },
	{ 0x004A, 0x4B },
	{ 0x004B, 0x00 },
	{ 0x004C, 0x00 },
	{ 0x004D, 0x00 },
	{ 0x004E, 0x05 },
	{ 0x004F, 0x00 },
	{ 0x0050, 0x0F },
	{ 0x0051, 0x00 },
	{ 0x0052, 0x00 },
	{ 0x0053, 0x00 },
	{ 0x0054, 0x00 },
	{ 0x0055, 0x00 },
	{ 0x0056, 0x00 },
	{ 0x0057, 0x00 },
	{ 0x0058, 0x00 },
	{ 0x0059, 0x01 },
	{ 0x005A, 0xD0 },
	{ 0x005B, 0x0B },
	{ 0x005C, 0xBD },
	{ 0x005D, 0x00 },
	{ 0x005E, 0x00 },
	{ 0x005F, 0x00 },
	{ 0x0060, 0x00 },
	{ 0x0061, 0x00 },
	{ 0x0062, 0x00 },
	{ 0x0063, 0x00 },
	{ 0x0064, 0x00 },
	{ 0x0065, 0x00 },
	{ 0x0066, 0x00 },
	{ 0x0067, 0x00 },
	{ 0x0068, 0x00 },
	{ 0x0069, 0x00 },
	{ 0x0092, 0x02 },
	{ 0x0093, 0xA0 },
	{ 0x0095, 0x00 },
	{ 0x0096, 0x90 },
	{ 0x0098, 0x70 },
	{ 0x009A, 0x02 },
	{ 0x009B, 0x50 },
	{ 0x009D, 0x04 },
	{ 0x009E, 0x60 },
	{ 0x00A0, 0x30 },
	{ 0x00A2, 0x00 },
	{ 0x00A9, 0xBD },
	{ 0x00AA, 0x68 },
	{ 0x00AB, 0x04 },
	{ 0x00AC, 0x00 },
	{ 0x00E5, 0x21 },
	{ 0x00EA, 0xD1 },
	{ 0x00EB, 0xB1 },
	{ 0x00EC, 0x03 },
	{ 0x00ED, 0x00 },
	{ 0x0102, 0x01 },
	{ 0x0108, 0x02 },
	{ 0x0109, 0x09 },
	{ 0x010A, 0x3B },
	{ 0x010B, 0x28 },
	{ 0x010D, 0x01 },
	{ 0x010E, 0x09 },
	{ 0x010F, 0x3B },
	{ 0x0110, 0x28 },
	{ 0x0112, 0x02 },
	{ 0x0113, 0x09 },
	{ 0x0114, 0x3B },
	{ 0x0115, 0x28 },
	{ 0x0117, 0x01 },
	{ 0x0118, 0x09 },
	{ 0x0119, 0x3B },
	{ 0x011A, 0x28 },
	{ 0x011C, 0x01 },
	{ 0x011D, 0x09 },
	{ 0x011E, 0x3B },
	{ 0x011F, 0x28 },
	{ 0x0121, 0x02 },
	{ 0x0122, 0x09 },
	{ 0x0123, 0x3B },
	{ 0x0124, 0x29 },
	{ 0x0126, 0x01 },
	{ 0x0127, 0x09 },
	{ 0x0128, 0x3B },
	{ 0x0129, 0x28 },
	{ 0x012B, 0x01 },
	{ 0x012C, 0x09 },
	{ 0x012D, 0x3B },
	{ 0x012E, 0x28 },
	{ 0x0130, 0x02 },
	{ 0x0131, 0x09 },
	{ 0x0132, 0x3B },
	{ 0x0133, 0x2A },
	{ 0x013A, 0x01 },
	{ 0x013B, 0x09 },
	{ 0x013C, 0x3B },
	{ 0x013D, 0x28 },
	{ 0x013F, 0x00 },
	{ 0x0140, 0x00 },
	{ 0x0141, 0x40 },
	{ 0x0142, 0xFF },
	{ 0x0206, 0x00 },
	{ 0x0208, 0x01 },
	{ 0x0209, 0x00 },
	{ 0x020A, 0x00 },
	{ 0x020B, 0x00 },
	{ 0x020C, 0x00 },
	{ 0x020D, 0x00 },
	{ 0x020E, 0x01 },
	{ 0x020F, 0x00 },
	{ 0x0210, 0x00 },
	{ 0x0211, 0x00 },
	{ 0x0212, 0x00 },
	{ 0x0213, 0x00 },
	{ 0x0214, 0x00 },
	{ 0x0215, 0x00 },
	{ 0x0216, 0x00 },
	{ 0x0217, 0x00 },
	{ 0x0218, 0x00 },
	{ 0x0219, 0x00 },
	{ 0x021A, 0x00 },
	{ 0x021B, 0x00 },
	{ 0x021C, 0x00 },
	{ 0x021D, 0x00 },
	{ 0x021E, 0x00 },
	{ 0x021F, 0x00 },
	{ 0x0220, 0x00 },
	{ 0x0221, 0x00 },
	{ 0x0222, 0x00 },
	{ 0x0223, 0x00 },
	{ 0x0224, 0x00 },
	{ 0x0225, 0x00 },
	{ 0x0226, 0x00 },
	{ 0x0227, 0x00 },
	{ 0x0228, 0x00 },
	{ 0x0229, 0x00 },
	{ 0x022A, 0x00 },
	{ 0x022B, 0x00 },
	{ 0x022C, 0x00 },
	{ 0x022D, 0x00 },
	{ 0x022E, 0x00 },
	{ 0x022F, 0x00 },
	{ 0x0231, 0x0B },
	{ 0x0232, 0x0B },
	{ 0x0233, 0x0B },
	{ 0x0234, 0x0B },
	{ 0x0235, 0x00 },
	{ 0x0236, 0x00 },
	{ 0x0237, 0x00 },
	{ 0x0238, 0x78 },
	{ 0x0239, 0xD5 },
	{ 0x023A, 0x00 },
	{ 0x023B, 0x00 },
	{ 0x023C, 0x00 },
	{ 0x023D, 0x00 },
	{ 0x023E, 0xD0 },
	{ 0x024A, 0x0A },
	{ 0x024B, 0x00 },
	{ 0x024C, 0x00 },
	{ 0x024D, 0x00 },
	{ 0x024E, 0x00 },
	{ 0x024F, 0x00 },
	{ 0x0250, 0x01 },
	{ 0x0251, 0x00 },
	{ 0x0252, 0x00 },
	{ 0x0253, 0x00 },
	{ 0x0254, 0x00 },
	{ 0x0255, 0x00 },
	{ 0x0256, 0x00 },
	{ 0x0257, 0x00 },
	{ 0x0258, 0x00 },
	{ 0x0259, 0x02 },
	{ 0x025A, 0x00 },
	{ 0x025B, 0x00 },
	{ 0x025C, 0x00 },
	{ 0x025D, 0x00 },
	{ 0x025E, 0x00 },
	{ 0x025F, 0x00 },
	{ 0x0260, 0x00 },
	{ 0x0261, 0x00 },
	{ 0x0262, 0x02 },
	{ 0x0263, 0x00 },
	{ 0x0264, 0x00 },
	{ 0x0268, 0x00 },
	{ 0x0269, 0x00 },
	{ 0x026A, 0x00 },
	{ 0x026B, 0x49 },
	{ 0x026C, 0x4F },
	{ 0x026D, 0x34 },
	{ 0x026E, 0x4B },
	{ 0x026F, 0x2B },
	{ 0x0270, 0x00 },
	{ 0x0271, 0x00 },
	{ 0x0272, 0x00 },
	{ 0x0294, 0x80 },
	{ 0x0296, 0x00 },
	{ 0x0297, 0x02 },
	{ 0x0299, 0x02 },
	{ 0x029D, 0xF5 },
	{ 0x029E, 0x0E },
	{ 0x029F, 0x00 },
	{ 0x02A9, 0x66 },
	{ 0x02AA, 0x26 },
	{ 0x02AB, 0x00 },
	{ 0x02B7, 0xFF },
	{ 0x0302, 0x00 },
	{ 0x0303, 0x00 },
	{ 0x0304, 0x00 },
	{ 0x0305, 0x80 },
	{ 0x0306, 0x0B },
	{ 0x0307, 0x00 },
	{ 0x0308, 0x00 },
	{ 0x0309, 0x00 },
	{ 0x030A, 0x00 },
	{ 0x030B, 0x80 },
	{ 0x030C, 0x00 },
	{ 0x030D, 0x00 },
	{ 0x030E, 0x00 },
	{ 0x030F, 0x60 },
	{ 0x0310, 0x53 },
	{ 0x0311, 0x2E },
	{ 0x0312, 0x00 },
	{ 0x0313, 0x00 },
	{ 0x0314, 0x00 },
	{ 0x0315, 0x00 },
	{ 0x0316, 0x80 },
	{ 0x0317, 0x00 },
	{ 0x0318, 0x00 },
	{ 0x0319, 0x00 },
	{ 0x031A, 0xE0 },
	{ 0x031B, 0x3D },
	{ 0x031C, 0x0B },
	{ 0x031D, 0x00 },
	{ 0x031E, 0x00 },
	{ 0x031F, 0x00 },
	{ 0x0320, 0x80 },
	{ 0x0321, 0xBB },
	{ 0x0322, 0x00 },
	{ 0x0323, 0x00 },
	{ 0x0324, 0x00 },
	{ 0x0325, 0x00 },
	{ 0x0326, 0x00 },
	{ 0x0327, 0x00 },
	{ 0x0328, 0x00 },
	{ 0x0329, 0x00 },
	{ 0x032A, 0x00 },
	{ 0x032B, 0x00 },
	{ 0x032C, 0x00 },
	{ 0x032D, 0x00 },
	{ 0x032E, 0x00 },
	{ 0x032F, 0x00 },
	{ 0x0330, 0x00 },
	{ 0x0331, 0x00 },
	{ 0x0332, 0x00 },
	{ 0x0333, 0x00 },
	{ 0x0334, 0x00 },
	{ 0x0335, 0x00 },
	{ 0x0336, 0x00 },
	{ 0x0337, 0x00 },
	{ 0x0338, 0x00 },
	{ 0x0339, 0x1F },
	{ 0x033B, 0x00 },
	{ 0x033C, 0x00 },
	{ 0x033D, 0x00 },
	{ 0x033E, 0x00 },
	{ 0x033F, 0x00 },
	{ 0x0340, 0x00 },
	{ 0x0341, 0x00 },
	{ 0x0342, 0x00 },
	{ 0x0343, 0x00 },
	{ 0x0344, 0x00 },
	{ 0x0345, 0x00 },
	{ 0x0346, 0x00 },
	{ 0x0347, 0x00 },
	{ 0x0348, 0x00 },
	{ 0x0349, 0x00 },
	{ 0x034A, 0x00 },
	{ 0x034B, 0x00 },
	{ 0x034C, 0x00 },
	{ 0x034D, 0x00 },
	{ 0x034E, 0x00 },
	{ 0x034F, 0x00 },
	{ 0x0350, 0x00 },
	{ 0x0351, 0x00 },
	{ 0x0352, 0x00 },
	{ 0x0353, 0x00 },
	{ 0x0354, 0x00 },
	{ 0x0355, 0x00 },
	{ 0x0356, 0x00 },
	{ 0x0357, 0x00 },
	{ 0x0358, 0x00 },
	{ 0x0359, 0x00 },
	{ 0x035A, 0x00 },
	{ 0x035B, 0x00 },
	{ 0x035C, 0x00 },
	{ 0x035D, 0x00 },
	{ 0x035E, 0x00 },
	{ 0x035F, 0x00 },
	{ 0x0360, 0x00 },
	{ 0x0361, 0x00 },
	{ 0x0362, 0x00 },
	{ 0x0487, 0x00 },
	{ 0x0502, 0x01 },
	{ 0x0508, 0x11 },
	{ 0x0509, 0x19 },
	{ 0x050A, 0x0F },
	{ 0x050B, 0x0F },
	{ 0x050C, 0x01 },
	{ 0x050D, 0x07 },
	{ 0x050E, 0x18 },
	{ 0x050F, 0x29 },
	{ 0x0510, 0x0C },
	{ 0x0511, 0x0B },
	{ 0x0512, 0x01 },
	{ 0x0513, 0x07 },
	{ 0x0515, 0x00 },
	{ 0x0516, 0x00 },
	{ 0x0517, 0x00 },
	{ 0x0518, 0x00 },
	{ 0x0519, 0x50 },
	{ 0x051A, 0x8E },
	{ 0x051B, 0x00 },
	{ 0x051C, 0x00 },
	{ 0x051D, 0x00 },
	{ 0x051E, 0x00 },
	{ 0x051F, 0x80 },
	{ 0x0521, 0x2B },
	{ 0x052A, 0x01 },
	{ 0x052B, 0x01 },
	{ 0x052C, 0x0F },
	{ 0x052D, 0x03 },
	{ 0x052E, 0x15 },
	{ 0x052F, 0x14 },
	{ 0x0531, 0x00 },
	{ 0x0532, 0x9D },
	{ 0x0533, 0xAD },
	{ 0x0534, 0x00 },
	{ 0x0535, 0x00 },
	{ 0x0536, 0x00 },
	{ 0x0537, 0x00 },
	{ 0x0538, 0x00 },
	{ 0x0539, 0x00 },
	{ 0x053A, 0x02 },
	{ 0x053B, 0x03 },
	{ 0x053C, 0x00 },
	{ 0x053D, 0x12 },
	{ 0x053E, 0x06 },
	{ 0x0589, 0xD6 },
	{ 0x058A, 0x02 },
	{ 0x059B, 0xF8 },
	{ 0x059D, 0x18 },
	{ 0x059E, 0x29 },
	{ 0x059F, 0x0C },
	{ 0x05A0, 0x0B },
	{ 0x05A1, 0x01 },
	{ 0x05A2, 0x07 },
	{ 0x05A6, 0x00 },
	{ 0x0802, 0x35 },
	{ 0x0803, 0x05 },
	{ 0x0804, 0x00 },
	{ 0x0805, 0x00 },
	{ 0x0806, 0x00 },
	{ 0x0807, 0x00 },
	{ 0x0808, 0x00 },
	{ 0x0809, 0x00 },
	{ 0x080A, 0x00 },
	{ 0x080B, 0x00 },
	{ 0x080C, 0x00 },
	{ 0x080D, 0x00 },
	{ 0x080E, 0x00 },
	{ 0x080F, 0x00 },
	{ 0x0810, 0x00 },
	{ 0x0811, 0x00 },
	{ 0x0812, 0x00 },
	{ 0x0813, 0x00 },
	{ 0x0814, 0x00 },
	{ 0x0815, 0x00 },
	{ 0x0816, 0x00 },
	{ 0x0817, 0x00 },
	{ 0x0818, 0x00 },
	{ 0x0819, 0x00 },
	{ 0x081A, 0x00 },
	{ 0x081B, 0x00 },
	{ 0x081C, 0x00 },
	{ 0x081D, 0x00 },
	{ 0x081E, 0x00 },
	{ 0x081F, 0x00 },
	{ 0x0820, 0x00 },
	{ 0x0821, 0x00 },
	{ 0x0822, 0x00 },
	{ 0x0823, 0x00 },
	{ 0x0824, 0x00 },
	{ 0x0825, 0x00 },
	{ 0x0826, 0x00 },
	{ 0x0827, 0x00 },
	{ 0x0828, 0x00 },
	{ 0x0829, 0x00 },
	{ 0x082A, 0x00 },
	{ 0x082B, 0x00 },
	{ 0x082C, 0x00 },
	{ 0x082D, 0x00 },
	{ 0x082E, 0x00 },
	{ 0x082F, 0x00 },
	{ 0x0830, 0x00 },
	{ 0x0831, 0x00 },
	{ 0x0832, 0x00 },
	{ 0x0833, 0x00 },
	{ 0x0834, 0x00 },
	{ 0x0835, 0x00 },
	{ 0x0836, 0x00 },
	{ 0x0837, 0x00 },
	{ 0x0838, 0x00 },
	{ 0x0839, 0x00 },
	{ 0x083A, 0x00 },
	{ 0x083B, 0x00 },
	{ 0x083C, 0x00 },
	{ 0x083D, 0x00 },
	{ 0x083E, 0x00 },
	{ 0x083F, 0x00 },
	{ 0x0840, 0x00 },
	{ 0x0841, 0x00 },
	{ 0x0842, 0x00 },
	{ 0x0843, 0x00 },
	{ 0x0844, 0x00 },
	{ 0x0845, 0x00 },
	{ 0x0846, 0x00 },
	{ 0x0847, 0x00 },
	{ 0x0848, 0x00 },
	{ 0x0849, 0x00 },
	{ 0x084A, 0x00 },
	{ 0x084B, 0x00 },
	{ 0x084C, 0x00 },
	{ 0x084D, 0x00 },
	{ 0x084E, 0x00 },
	{ 0x084F, 0x00 },
	{ 0x0850, 0x00 },
	{ 0x0851, 0x00 },
	{ 0x0852, 0x00 },
	{ 0x0853, 0x00 },
	{ 0x0854, 0x00 },
	{ 0x0855, 0x00 },
	{ 0x0856, 0x00 },
	{ 0x0857, 0x00 },
	{ 0x0858, 0x00 },
	{ 0x0859, 0x00 },
	{ 0x085A, 0x00 },
	{ 0x085B, 0x00 },
	{ 0x085C, 0x00 },
	{ 0x085D, 0x00 },
	{ 0x085E, 0x00 },
	{ 0x085F, 0x00 },
	{ 0x0860, 0x00 },
	{ 0x0861, 0x00 },
	{ 0x090E, 0x03 },
	{ 0x0943, 0x00 },
	{ 0x0949, 0x31 },
	{ 0x094A, 0x01 },
	{ 0x094E, 0x49 },
	{ 0x094F, 0x02 },
	{ 0x095E, 0x00 },
	{ 0x0A02, 0x00 },
	{ 0x0A03, 0x07 },
	{ 0x0A04, 0x01 },
	{ 0x0A05, 0x07 },
	{ 0x0A14, 0x00 },
	{ 0x0A1A, 0x00 },
	{ 0x0A20, 0x00 },
	{ 0x0A26, 0x00 },
	{ 0x0A2C, 0x00 },
	{ 0x0B44, 0x2F },
	{ 0x0B46, 0x00 },
	{ 0x0B47, 0x0E },
	{ 0x0B48, 0x0E },
	{ 0x0B4A, 0x18 },
	{ 0x0B57, 0xF9 },
	{ 0x0B58, 0x00 },
	/* End configuration registers */

	/* Start configuration postamble */
	{ 0x0514, 0x01 },
	{ 0x001C, 0x01 },
	{ 0x0540, 0x00 },
	{ 0x0B24, 0xC3 },
	{ 0x0B25, 0x02 },
	/* End configuration postamble */

	{ 0x0000, 0x00 }
};

/*
 * Design Report
 *
 * Overview
 * ========
 * Part:         Si5345 Rev D
 * Project File: C:\XilinxProjects\flint_tr051017\genlock\FormatFiles\IO4K+_750_6000.slabtimeproj
 * Design ID:    IO4K+
 * Created By:   ClockBuilder Pro v2.16.1 [2017-07-19]
 * Timestamp:    2017-08-24 16:26:04 GMT-07:00
 * 
 * Design Notes
 * ============
 * assumes NTSC HSYNC (pulsed) input = (30/1.001)*525
 * 
 * Design Rule Check
 * =================
 * Errors:
 * - No errors
 * 
 * Warnings:
 * - Pulsed LVCMOS input buffer mode has been selected. This mode has non-standard input voltage logic thresholds: 0.33 V for Vil (max) and 0.49 V for Vih (min). Select this mode only if your input clock has a duty cycle significantly less or more than 50%.  Refer to the device datasheet for the exact threshold voltage specifications and the input attenuator circuit (DC coupled Pulsed LVCMOS) in the Family Reference Manual.
 * 
 * Device Grade
 * ============
 * Maximum Output Frequency: 148.5 MHz
 * Frequency Synthesis Mode: Fractional
 * Minimum Base OPN:         Si5345B
 * Actual Base OPN:          Si5345B
 * 
 * Base       Output Clock         Supported Frequency Synthesis Modes
 * OPN Grade  Frequency Range      (Typical Jitter)
 * ---------  -------------------  --------------------------------------------
 * Si5345A    100 Hz to 1.028 GHz  Integer (< 100 fs) and fractional (< 150 fs)
 * Si5345B    100 Hz to 350 MHz    "
 * Si5345C    100 Hz to 1.028 GHz  Integer only (< 100 fs)
 * Si5345D    100 Hz to 350 MHz    "
 * 
 * Design
 * ======
 * Host Interface:
 *    I/O Power Supply: VDD (Core)
 *    SPI Mode: 4-Wire
 *    I2C Address Range: 100d to 103d / 0x64 to 0x67 (selected via A0/A1 pins)
 * 
 * XA/XB:
 *    52 MHz (XO - External Oscillator)
 * 
 * Inputs:
 *     IN0: 37.5 kHz [ 37 + 1/2 kHz ]
 *          [ (50)*750 ]
 *          Pulsed LVCMOS
 *     IN1: Unused
 *     IN2: Unused
 *     IN3: Unused
 * 
 * Outputs:
 *    OUT0: 27 MHz
 *          Enabled, LVDS 2.5 V
 *    OUT1: Unused
 *    OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT3: Unused
 *    OUT4: Unused
 *    OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT6: Unused
 *    OUT7: Unused
 *    OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *          [ 148.5/1.001 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT9: Unused
 * 
 * Frequency Plan
 * ==============
 * Priority: maximize the number of low jitter outputs
 * 
 * Fvco = 13.662 GHz [ 13 + 331/500 GHz ]
 * Fpfd = 37.5 kHz [ 37 + 1/2 kHz ]
 * Fms0 = 594 MHz
 * Fms1 = 147.456 MHz [ 147 + 57/125 MHz ]
 * Fms2 = 890.1098901098901098... MHz [ 890 + 10/91 MHz ]
 * 
 * P dividers:
 *    P0  = 1
 *    P1  = Unused
 *    P2  = Unused
 *    P3  = Unused
 *    Pxaxb = 1
 * 
 * MXAXB = 262.7307692307692307... [ 262 + 19/26 ]
 * M = 72864
 * N dividers:
 *    N0:
 *       Value: 23
 *       Skew:  0.000 s
 *       OUT0: 27 MHz
 *       OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *    N1:
 *       Value: 92.6513671875 [ 92 + 667/1024 ]
 *       Skew:  0.000 s
 *       OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *    N2:
 *       Value: 15.3486666666666666... [ 15 + 523/1500 ]
 *       Skew:  0.000 s
 *       OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *    N3:
 *       Unused
 *    N4:
 *       Unused
 * 
 * R dividers:
 *    R0 = 22
 *    R1 = Unused
 *    R2 = 4
 *    R3 = Unused
 *    R4 = Unused
 *    R5 = 6
 *    R6 = Unused
 *    R7 = Unused
 *    R8 = 6
 *    R9 = Unused
 * 
 * Nominal Bandwidth:
 *   Desired: 1.000 Hz
 *   Actual:  725.888 mHz
 *   Coefficients:
 *      BW0:  17
 *      BW1:  25
 *      BW2:  15
 *      BW3:  15
 *      BW4:  1
 *      BW5:  7
 * Fastlock Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  124.106 Hz
 *   Coefficients:
 *      BW0:  24
 *      BW1:  41
 *      BW2:  12
 *      BW3:  11
 *      BW4:  1
 *      BW5:  7
 * Holdover Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  124.106 Hz
 *   Coefficients:
 *      BW0:  24
 *      BW1:  41
 *      BW2:  12
 *      BW3:  11
 *      BW4:  1
 *      BW5:  7
 * 
 * Dividers listed above show effective values. These values are translated to register settings by ClockBuilder Pro. For the actual register values, see below. Refer to the Family Reference Manual for information on registers related to frequency plan.
 * 
 * Digitally Controlled Oscillator (DCO)
 * =====================================
 * Mode: Register Direct Write
 * 
 * N0: DCO Disabled
 * 
 * N1: DCO Disabled
 * 
 * N2: DCO Disabled
 * 
 * N3: DCO Disabled
 * 
 * N4: DCO Disabled
 * 
 * Estimated Power & Junction Temperature
 * ======================================
 * Assumptions:
 * 
 * Revision: D
 * VDD:      1.8 V
 * Ta:       70 C
 * Airflow:  None
 * 
 * Total Power: 808 mW, On Chip Power: 784 mW, Tj: 87 C
 * 
 *                 Frequency  Format   Voltage   Current     Power
 *         -----------------  ------  --------  --------  --------
 * VDD                                   1.8 V  147.9 mA    266 mW
 * VDDA                                  3.3 V  117.4 mA    387 mW
 * VDDO0              27 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO1              Unused                                      
 * VDDO2           148.5 MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO3              Unused                                      
 * VDDO4              Unused                                      
 * VDDO5          24.576 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO6              Unused                                      
 * VDDO7              Unused                                      
 * VDDO8   148.351648... MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO9              Unused                                      
 *                                              --------  --------
 *                                       Total  327.2 mA    808 mW
 * 
 * Note:
 * 
 * -Total power includes on- and off-chip power. This is a typical value and estimate only.
 * -Use an EVB for a more exact power measurement
 * -On-chip power excludes power dissipated in external terminations.
 * -Tj is junction temperature. Tj must be less than 125 C (on Si5345 Revision D) for device to comply with datasheet specifications.
 * 
 * Settings
 * ========
 * 
 * Location      Setting Name           Decimal Value      Hex Value        
 * ------------  ---------------------  -----------------  -----------------
 * 0x000B[6:0]   I2C_ADDR               100                0x64             
 * 0x0016[1]     LOL_ON_HOLD            1                  0x1              
 * 0x0017[0]     SYSINCAL_INTR_MSK      0                  0x0              
 * 0x0017[1]     LOSXAXB_INTR_MSK       0                  0x0              
 * 0x0017[5]     SMB_TMOUT_INTR_MSK     1                  0x1              
 * 0x0018[3:0]   LOS_INTR_MSK           15                 0xF              
 * 0x0018[7:4]   OOF_INTR_MSK           15                 0xF              
 * 0x0019[1]     LOL_INTR_MSK           1                  0x1              
 * 0x0019[5]     HOLD_INTR_MSK          0                  0x0              
 * 0x001A[5]     CAL_INTR_MSK           0                  0x0              
 * 0x002B[3]     SPI_3WIRE              0                  0x0              
 * 0x002B[5]     AUTO_NDIV_UPDATE       0                  0x0              
 * 0x002C[3:0]   LOS_EN                 1                  0x1              
 * 0x002C[4]     LOSXAXB_DIS            0                  0x0              
 * 0x002D[1:0]   LOS0_VAL_TIME          2                  0x2              
 * 0x002D[3:2]   LOS1_VAL_TIME          0                  0x0              
 * 0x002D[5:4]   LOS2_VAL_TIME          0                  0x0              
 * 0x002D[7:6]   LOS3_VAL_TIME          0                  0x0              
 * 0x002E[15:0]  LOS0_TRG_THR           1749               0x06D5           
 * 0x0030[15:0]  LOS1_TRG_THR           0                  0x0000           
 * 0x0032[15:0]  LOS2_TRG_THR           0                  0x0000           
 * 0x0034[15:0]  LOS3_TRG_THR           0                  0x0000           
 * 0x0036[15:0]  LOS0_CLR_THR           1604               0x0644           
 * 0x0038[15:0]  LOS1_CLR_THR           0                  0x0000           
 * 0x003A[15:0]  LOS2_CLR_THR           0                  0x0000           
 * 0x003C[15:0]  LOS3_CLR_THR           0                  0x0000           
 * 0x003F[3:0]   OOF_EN                 1                  0x1              
 * 0x003F[7:4]   FAST_OOF_EN            0                  0x0              
 * 0x0040[2:0]   OOF_REF_SEL            4                  0x4              
 * 0x0041[4:0]   OOF0_DIV_SEL           2                  0x02             
 * 0x0042[4:0]   OOF1_DIV_SEL           0                  0x00             
 * 0x0043[4:0]   OOF2_DIV_SEL           0                  0x00             
 * 0x0044[4:0]   OOF3_DIV_SEL           0                  0x00             
 * 0x0045[4:0]   OOFXO_DIV_SEL          12                 0x0C             
 * 0x0046[7:0]   OOF0_SET_THR           150                0x96             
 * 0x0047[7:0]   OOF1_SET_THR           0                  0x00             
 * 0x0048[7:0]   OOF2_SET_THR           0                  0x00             
 * 0x0049[7:0]   OOF3_SET_THR           0                  0x00             
 * 0x004A[7:0]   OOF0_CLR_THR           75                 0x4B             
 * 0x004B[7:0]   OOF1_CLR_THR           0                  0x00             
 * 0x004C[7:0]   OOF2_CLR_THR           0                  0x00             
 * 0x004D[7:0]   OOF3_CLR_THR           0                  0x00             
 * 0x004E[2:0]   OOF0_DETWIN_SEL        5                  0x5              
 * 0x004E[6:4]   OOF1_DETWIN_SEL        0                  0x0              
 * 0x004F[2:0]   OOF2_DETWIN_SEL        0                  0x0              
 * 0x004F[6:4]   OOF3_DETWIN_SEL        0                  0x0              
 * 0x0050[3:0]   OOF_ON_LOS             15                 0xF              
 * 0x0051[3:0]   FAST_OOF0_SET_THR      0                  0x0              
 * 0x0052[3:0]   FAST_OOF1_SET_THR      0                  0x0              
 * 0x0053[3:0]   FAST_OOF2_SET_THR      0                  0x0              
 * 0x0054[3:0]   FAST_OOF3_SET_THR      0                  0x0              
 * 0x0055[3:0]   FAST_OOF0_CLR_THR      0                  0x0              
 * 0x0056[3:0]   FAST_OOF1_CLR_THR      0                  0x0              
 * 0x0057[3:0]   FAST_OOF2_CLR_THR      0                  0x0              
 * 0x0058[3:0]   FAST_OOF3_CLR_THR      0                  0x0              
 * 0x0059[1:0]   FAST_OOF0_DETWIN_SEL   1                  0x1              
 * 0x0059[3:2]   FAST_OOF1_DETWIN_SEL   0                  0x0              
 * 0x0059[5:4]   FAST_OOF2_DETWIN_SEL   0                  0x0              
 * 0x0059[7:6]   FAST_OOF3_DETWIN_SEL   0                  0x0              
 * 0x005A[25:0]  OOF0_RATIO_REF         12389328           0x0BD0BD0        
 * 0x005E[25:0]  OOF1_RATIO_REF         0                  0x0000000        
 * 0x0062[25:0]  OOF2_RATIO_REF         0                  0x0000000        
 * 0x0066[25:0]  OOF3_RATIO_REF         0                  0x0000000        
 * 0x0092[1]     LOL_FST_EN             1                  0x1              
 * 0x0093[7:4]   LOL_FST_DETWIN_SEL     10                 0xA              
 * 0x0095[3:2]   LOL_FST_VALWIN_SEL     0                  0x0              
 * 0x0096[7:4]   LOL_FST_SET_THR_SEL    9                  0x9              
 * 0x0098[7:4]   LOL_FST_CLR_THR_SEL    7                  0x7              
 * 0x009A[1]     LOL_SLOW_EN_PLL        1                  0x1              
 * 0x009B[7:4]   LOL_SLW_DETWIN_SEL     5                  0x5              
 * 0x009D[3:2]   LOL_SLW_VALWIN_SEL     1                  0x1              
 * 0x009E[7:4]   LOL_SLW_SET_THR        6                  0x6              
 * 0x00A0[7:4]   LOL_SLW_CLR_THR        3                  0x3              
 * 0x00A2[1]     LOL_TIMER_EN           0                  0x0              
 * 0x00A9[28:0]  LOL_CLR_DELAY_DIV256   288957             0x000468BD       
 * 0x00E5[5]     FASTLOCK_EXTEND_EN     1                  0x1              
 * 0x00EA[28:0]  FASTLOCK_EXTEND        242129             0x0003B1D1       
 * 0x0102[0]     OUTALL_DISABLE_LOW     1                  0x1              
 * 0x0108[0]     OUT0_PDN               0                  0x0              
 * 0x0108[1]     OUT0_OE                1                  0x1              
 * 0x0108[2]     OUT0_RDIV_FORCE2       0                  0x0              
 * 0x0109[2:0]   OUT0_FORMAT            1                  0x1              
 * 0x0109[3]     OUT0_SYNC_EN           1                  0x1              
 * 0x0109[5:4]   OUT0_DIS_STATE         0                  0x0              
 * 0x0109[7:6]   OUT0_CMOS_DRV          0                  0x0              
 * 0x010A[3:0]   OUT0_CM                11                 0xB              
 * 0x010A[6:4]   OUT0_AMPL              3                  0x3              
 * 0x010B[2:0]   OUT0_MUX_SEL           0                  0x0              
 * 0x010B[5:4]   OUT0_VDD_SEL           2                  0x2              
 * 0x010B[3]     OUT0_VDD_SEL_EN        1                  0x1              
 * 0x010B[7:6]   OUT0_INV               0                  0x0              
 * 0x010D[0]     OUT1_PDN               1                  0x1              
 * 0x010D[1]     OUT1_OE                0                  0x0              
 * 0x010D[2]     OUT1_RDIV_FORCE2       0                  0x0              
 * 0x010E[2:0]   OUT1_FORMAT            1                  0x1              
 * 0x010E[3]     OUT1_SYNC_EN           1                  0x1              
 * 0x010E[5:4]   OUT1_DIS_STATE         0                  0x0              
 * 0x010E[7:6]   OUT1_CMOS_DRV          0                  0x0              
 * 0x010F[3:0]   OUT1_CM                11                 0xB              
 * 0x010F[6:4]   OUT1_AMPL              3                  0x3              
 * 0x0110[2:0]   OUT1_MUX_SEL           0                  0x0              
 * 0x0110[5:4]   OUT1_VDD_SEL           2                  0x2              
 * 0x0110[3]     OUT1_VDD_SEL_EN        1                  0x1              
 * 0x0110[7:6]   OUT1_INV               0                  0x0              
 * 0x0112[0]     OUT2_PDN               0                  0x0              
 * 0x0112[1]     OUT2_OE                1                  0x1              
 * 0x0112[2]     OUT2_RDIV_FORCE2       0                  0x0              
 * 0x0113[2:0]   OUT2_FORMAT            1                  0x1              
 * 0x0113[3]     OUT2_SYNC_EN           1                  0x1              
 * 0x0113[5:4]   OUT2_DIS_STATE         0                  0x0              
 * 0x0113[7:6]   OUT2_CMOS_DRV          0                  0x0              
 * 0x0114[3:0]   OUT2_CM                11                 0xB              
 * 0x0114[6:4]   OUT2_AMPL              3                  0x3              
 * 0x0115[2:0]   OUT2_MUX_SEL           0                  0x0              
 * 0x0115[5:4]   OUT2_VDD_SEL           2                  0x2              
 * 0x0115[3]     OUT2_VDD_SEL_EN        1                  0x1              
 * 0x0115[7:6]   OUT2_INV               0                  0x0              
 * 0x0117[0]     OUT3_PDN               1                  0x1              
 * 0x0117[1]     OUT3_OE                0                  0x0              
 * 0x0117[2]     OUT3_RDIV_FORCE2       0                  0x0              
 * 0x0118[2:0]   OUT3_FORMAT            1                  0x1              
 * 0x0118[3]     OUT3_SYNC_EN           1                  0x1              
 * 0x0118[5:4]   OUT3_DIS_STATE         0                  0x0              
 * 0x0118[7:6]   OUT3_CMOS_DRV          0                  0x0              
 * 0x0119[3:0]   OUT3_CM                11                 0xB              
 * 0x0119[6:4]   OUT3_AMPL              3                  0x3              
 * 0x011A[2:0]   OUT3_MUX_SEL           0                  0x0              
 * 0x011A[5:4]   OUT3_VDD_SEL           2                  0x2              
 * 0x011A[3]     OUT3_VDD_SEL_EN        1                  0x1              
 * 0x011A[7:6]   OUT3_INV               0                  0x0              
 * 0x011C[0]     OUT4_PDN               1                  0x1              
 * 0x011C[1]     OUT4_OE                0                  0x0              
 * 0x011C[2]     OUT4_RDIV_FORCE2       0                  0x0              
 * 0x011D[2:0]   OUT4_FORMAT            1                  0x1              
 * 0x011D[3]     OUT4_SYNC_EN           1                  0x1              
 * 0x011D[5:4]   OUT4_DIS_STATE         0                  0x0              
 * 0x011D[7:6]   OUT4_CMOS_DRV          0                  0x0              
 * 0x011E[3:0]   OUT4_CM                11                 0xB              
 * 0x011E[6:4]   OUT4_AMPL              3                  0x3              
 * 0x011F[2:0]   OUT4_MUX_SEL           0                  0x0              
 * 0x011F[5:4]   OUT4_VDD_SEL           2                  0x2              
 * 0x011F[3]     OUT4_VDD_SEL_EN        1                  0x1              
 * 0x011F[7:6]   OUT4_INV               0                  0x0              
 * 0x0121[0]     OUT5_PDN               0                  0x0              
 * 0x0121[1]     OUT5_OE                1                  0x1              
 * 0x0121[2]     OUT5_RDIV_FORCE2       0                  0x0              
 * 0x0122[2:0]   OUT5_FORMAT            1                  0x1              
 * 0x0122[3]     OUT5_SYNC_EN           1                  0x1              
 * 0x0122[5:4]   OUT5_DIS_STATE         0                  0x0              
 * 0x0122[7:6]   OUT5_CMOS_DRV          0                  0x0              
 * 0x0123[3:0]   OUT5_CM                11                 0xB              
 * 0x0123[6:4]   OUT5_AMPL              3                  0x3              
 * 0x0124[2:0]   OUT5_MUX_SEL           1                  0x1              
 * 0x0124[5:4]   OUT5_VDD_SEL           2                  0x2              
 * 0x0124[3]     OUT5_VDD_SEL_EN        1                  0x1              
 * 0x0124[7:6]   OUT5_INV               0                  0x0              
 * 0x0126[0]     OUT6_PDN               1                  0x1              
 * 0x0126[1]     OUT6_OE                0                  0x0              
 * 0x0126[2]     OUT6_RDIV_FORCE2       0                  0x0              
 * 0x0127[2:0]   OUT6_FORMAT            1                  0x1              
 * 0x0127[3]     OUT6_SYNC_EN           1                  0x1              
 * 0x0127[5:4]   OUT6_DIS_STATE         0                  0x0              
 * 0x0127[7:6]   OUT6_CMOS_DRV          0                  0x0              
 * 0x0128[3:0]   OUT6_CM                11                 0xB              
 * 0x0128[6:4]   OUT6_AMPL              3                  0x3              
 * 0x0129[2:0]   OUT6_MUX_SEL           0                  0x0              
 * 0x0129[5:4]   OUT6_VDD_SEL           2                  0x2              
 * 0x0129[3]     OUT6_VDD_SEL_EN        1                  0x1              
 * 0x0129[7:6]   OUT6_INV               0                  0x0              
 * 0x012B[0]     OUT7_PDN               1                  0x1              
 * 0x012B[1]     OUT7_OE                0                  0x0              
 * 0x012B[2]     OUT7_RDIV_FORCE2       0                  0x0              
 * 0x012C[2:0]   OUT7_FORMAT            1                  0x1              
 * 0x012C[3]     OUT7_SYNC_EN           1                  0x1              
 * 0x012C[5:4]   OUT7_DIS_STATE         0                  0x0              
 * 0x012C[7:6]   OUT7_CMOS_DRV          0                  0x0              
 * 0x012D[3:0]   OUT7_CM                11                 0xB              
 * 0x012D[6:4]   OUT7_AMPL              3                  0x3              
 * 0x012E[2:0]   OUT7_MUX_SEL           0                  0x0              
 * 0x012E[5:4]   OUT7_VDD_SEL           2                  0x2              
 * 0x012E[3]     OUT7_VDD_SEL_EN        1                  0x1              
 * 0x012E[7:6]   OUT7_INV               0                  0x0              
 * 0x0130[0]     OUT8_PDN               0                  0x0              
 * 0x0130[1]     OUT8_OE                1                  0x1              
 * 0x0130[2]     OUT8_RDIV_FORCE2       0                  0x0              
 * 0x0131[2:0]   OUT8_FORMAT            1                  0x1              
 * 0x0131[3]     OUT8_SYNC_EN           1                  0x1              
 * 0x0131[5:4]   OUT8_DIS_STATE         0                  0x0              
 * 0x0131[7:6]   OUT8_CMOS_DRV          0                  0x0              
 * 0x0132[3:0]   OUT8_CM                11                 0xB              
 * 0x0132[6:4]   OUT8_AMPL              3                  0x3              
 * 0x0133[2:0]   OUT8_MUX_SEL           2                  0x2              
 * 0x0133[5:4]   OUT8_VDD_SEL           2                  0x2              
 * 0x0133[3]     OUT8_VDD_SEL_EN        1                  0x1              
 * 0x0133[7:6]   OUT8_INV               0                  0x0              
 * 0x013A[0]     OUT9_PDN               1                  0x1              
 * 0x013A[1]     OUT9_OE                0                  0x0              
 * 0x013A[2]     OUT9_RDIV_FORCE2       0                  0x0              
 * 0x013B[2:0]   OUT9_FORMAT            1                  0x1              
 * 0x013B[3]     OUT9_SYNC_EN           1                  0x1              
 * 0x013B[5:4]   OUT9_DIS_STATE         0                  0x0              
 * 0x013B[7:6]   OUT9_CMOS_DRV          0                  0x0              
 * 0x013C[3:0]   OUT9_CM                11                 0xB              
 * 0x013C[6:4]   OUT9_AMPL              3                  0x3              
 * 0x013D[2:0]   OUT9_MUX_SEL           0                  0x0              
 * 0x013D[5:4]   OUT9_VDD_SEL           2                  0x2              
 * 0x013D[3]     OUT9_VDD_SEL_EN        1                  0x1              
 * 0x013D[7:6]   OUT9_INV               0                  0x0              
 * 0x013F[11:0]  OUTX_ALWAYS_ON         0                  0x000            
 * 0x0141[1]     OUT_DIS_MSK            0                  0x0              
 * 0x0141[5]     OUT_DIS_LOL_MSK        0                  0x0              
 * 0x0141[6]     OUT_DIS_LOSXAXB_MSK    1                  0x1              
 * 0x0141[7]     OUT_DIS_MSK_LOS_PFD    0                  0x0              
 * 0x0142[1]     OUT_DIS_MSK_LOL        1                  0x1              
 * 0x0142[5]     OUT_DIS_MSK_HOLD       1                  0x1              
 * 0x0206[1:0]   PXAXB                  0                  0x0              
 * 0x0208[47:0]  P0_NUM                 1                  0x000000000001   
 * 0x020E[31:0]  P0_DEN                 1                  0x00000001       
 * 0x0212[47:0]  P1_NUM                 0                  0x000000000000   
 * 0x0218[31:0]  P1_DEN                 0                  0x00000000       
 * 0x021C[47:0]  P2_NUM                 0                  0x000000000000   
 * 0x0222[31:0]  P2_DEN                 0                  0x00000000       
 * 0x0226[47:0]  P3_NUM                 0                  0x000000000000   
 * 0x022C[31:0]  P3_DEN                 0                  0x00000000       
 * 0x0231[3:0]   P0_FRACN_MODE          11                 0xB              
 * 0x0231[4]     P0_FRACN_EN            0                  0x0              
 * 0x0232[3:0]   P1_FRACN_MODE          11                 0xB              
 * 0x0232[4]     P1_FRACN_EN            0                  0x0              
 * 0x0233[3:0]   P2_FRACN_MODE          11                 0xB              
 * 0x0233[4]     P2_FRACN_EN            0                  0x0              
 * 0x0234[3:0]   P3_FRACN_MODE          11                 0xB              
 * 0x0234[4]     P3_FRACN_EN            0                  0x0              
 * 0x0235[43:0]  MXAXB_NUM              916841299968       0x0D578000000    
 * 0x023B[31:0]  MXAXB_DEN              3489660928         0xD0000000       
 * 0x024A[23:0]  R0_REG                 10                 0x00000A         
 * 0x024D[23:0]  R1_REG                 0                  0x000000         
 * 0x0250[23:0]  R2_REG                 1                  0x000001         
 * 0x0253[23:0]  R3_REG                 0                  0x000000         
 * 0x0256[23:0]  R4_REG                 0                  0x000000         
 * 0x0259[23:0]  R5_REG                 2                  0x000002         
 * 0x025C[23:0]  R6_REG                 0                  0x000000         
 * 0x025F[23:0]  R7_REG                 0                  0x000000         
 * 0x0262[23:0]  R8_REG                 2                  0x000002         
 * 0x0268[23:0]  R9_REG                 0                  0x000000         
 * 0x026B[7:0]   DESIGN_ID0             73                 0x49             
 * 0x026C[7:0]   DESIGN_ID1             79                 0x4F             
 * 0x026D[7:0]   DESIGN_ID2             52                 0x34             
 * 0x026E[7:0]   DESIGN_ID3             75                 0x4B             
 * 0x026F[7:0]   DESIGN_ID4             43                 0x2B             
 * 0x0270[7:0]   DESIGN_ID5             0                  0x00             
 * 0x0271[7:0]   DESIGN_ID6             0                  0x00             
 * 0x0272[7:0]   DESIGN_ID7             0                  0x00             
 * 0x0294[7:4]   FASTLOCK_EXTEND_SCL    8                  0x8              
 * 0x0296[1]     LOL_SLW_VALWIN_SELX    0                  0x0              
 * 0x0297[1]     FASTLOCK_DLY_ONSW_EN   1                  0x1              
 * 0x0299[1]     FASTLOCK_DLY_ONLOL_EN  1                  0x1              
 * 0x029D[19:0]  FASTLOCK_DLY_ONLOL     3829               0x00EF5          
 * 0x02A9[19:0]  FASTLOCK_DLY_ONSW      9830               0x02666          
 * 0x02B7[3:2]   LOL_NOSIG_TIME         3                  0x3              
 * 0x0302[43:0]  N0_NUM                 49392123904        0x00B80000000    
 * 0x0308[31:0]  N0_DEN                 2147483648         0x80000000       
 * 0x030C[0]     N0_UPDATE              0                  0x0              
 * 0x030D[43:0]  N1_NUM                 198967296000       0x02E53600000    
 * 0x0313[31:0]  N1_DEN                 2147483648         0x80000000       
 * 0x0317[0]     N1_UPDATE              0                  0x0              
 * 0x0318[43:0]  N2_NUM                 48282730496        0x00B3DE00000    
 * 0x031E[31:0]  N2_DEN                 3145728000         0xBB800000       
 * 0x0322[0]     N2_UPDATE              0                  0x0              
 * 0x0323[43:0]  N3_NUM                 0                  0x00000000000    
 * 0x0329[31:0]  N3_DEN                 0                  0x00000000       
 * 0x032D[0]     N3_UPDATE              0                  0x0              
 * 0x032E[43:0]  N4_NUM                 0                  0x00000000000    
 * 0x0334[31:0]  N4_DEN                 0                  0x00000000       
 * 0x0338[0]     N4_UPDATE              0                  0x0              
 * 0x0338[1]     N_UPDATE               0                  0x0              
 * 0x0339[4:0]   N_FSTEP_MSK            31                 0x1F             
 * 0x033B[43:0]  N0_FSTEPW              0                  0x00000000000    
 * 0x0341[43:0]  N1_FSTEPW              0                  0x00000000000    
 * 0x0347[43:0]  N2_FSTEPW              0                  0x00000000000    
 * 0x034D[43:0]  N3_FSTEPW              0                  0x00000000000    
 * 0x0353[43:0]  N4_FSTEPW              0                  0x00000000000    
 * 0x0359[15:0]  N0_DELAY               0                  0x0000           
 * 0x035B[15:0]  N1_DELAY               0                  0x0000           
 * 0x035D[15:0]  N2_DELAY               0                  0x0000           
 * 0x035F[15:0]  N3_DELAY               0                  0x0000           
 * 0x0361[15:0]  N4_DELAY               0                  0x0000           
 * 0x0487[0]     ZDM_EN                 0                  0x0              
 * 0x0487[2:1]   ZDM_IN_SEL             0                  0x0              
 * 0x0487[4]     ZDM_AUTOSW_EN          0                  0x0              
 * 0x0502[4]     ADD_DIV256             0                  0x0              
 * 0x0508[5:0]   BW0_PLL                17                 0x11             
 * 0x0509[5:0]   BW1_PLL                25                 0x19             
 * 0x050A[5:0]   BW2_PLL                15                 0x0F             
 * 0x050B[5:0]   BW3_PLL                15                 0x0F             
 * 0x050C[5:0]   BW4_PLL                1                  0x01             
 * 0x050D[5:0]   BW5_PLL                7                  0x07             
 * 0x050E[5:0]   FASTLOCK_BW0_PLL       24                 0x18             
 * 0x050F[5:0]   FASTLOCK_BW1_PLL       41                 0x29             
 * 0x0510[5:0]   FASTLOCK_BW2_PLL       12                 0x0C             
 * 0x0511[5:0]   FASTLOCK_BW3_PLL       11                 0x0B             
 * 0x0512[5:0]   FASTLOCK_BW4_PLL       1                  0x01             
 * 0x0513[5:0]   FASTLOCK_BW5_PLL       7                  0x07             
 * 0x0515[55:0]  M_NUM                  156474248527872    0x008E5000000000 
 * 0x051C[31:0]  M_DEN                  2147483648         0x80000000       
 * 0x0521[3:0]   M_FRAC_MODE            11                 0xB              
 * 0x0521[4]     M_FRAC_EN              0                  0x0              
 * 0x0521[5]     PLL_OUT_RATE_SEL       1                  0x1              
 * 0x052A[0]     IN_SEL_REGCTRL         1                  0x1              
 * 0x052A[3:1]   IN_SEL                 0                  0x0              
 * 0x052B[0]     FASTLOCK_AUTO_EN       1                  0x1              
 * 0x052B[1]     FASTLOCK_MAN           0                  0x0              
 * 0x052C[0]     HOLD_EN                1                  0x1              
 * 0x052C[3]     HOLD_RAMP_BYP          1                  0x1              
 * 0x052C[4]     HOLDEXIT_BW_SEL1       0                  0x0              
 * 0x052C[7:5]   RAMP_STEP_INTERVAL     0                  0x0              
 * 0x052D[1]     HOLD_RAMPBYP_NOHIST    1                  0x1              
 * 0x052E[4:0]   HOLD_HIST_LEN          21                 0x15             
 * 0x052F[4:0]   HOLD_HIST_DELAY        20                 0x14             
 * 0x0531[4:0]   HOLD_REF_COUNT_FRC     0                  0x00             
 * 0x0532[23:0]  HOLD_15M_CYC_COUNT     44445              0x00AD9D         
 * 0x0535[0]     FORCE_HOLD             0                  0x0              
 * 0x0536[1:0]   CLK_SWITCH_MODE        0                  0x0              
 * 0x0536[2]     HSW_EN                 0                  0x0              
 * 0x0537[3:0]   IN_LOS_MSK             0                  0x0              
 * 0x0537[7:4]   IN_OOF_MSK             0                  0x0              
 * 0x0538[2:0]   IN0_PRIORITY           0                  0x0              
 * 0x0538[6:4]   IN1_PRIORITY           0                  0x0              
 * 0x0539[2:0]   IN2_PRIORITY           0                  0x0              
 * 0x0539[6:4]   IN3_PRIORITY           0                  0x0              
 * 0x053A[1:0]   HSW_MODE               2                  0x2              
 * 0x053A[3:2]   HSW_PHMEAS_CTRL        0                  0x0              
 * 0x053B[9:0]   HSW_PHMEAS_THR         3                  0x003            
 * 0x053D[4:0]   HSW_COARSE_PM_LEN      18                 0x12             
 * 0x053E[4:0]   HSW_COARSE_PM_DLY      6                  0x06             
 * 0x0589[12:0]  CAP_SHORT_DELAY        726                0x02D6           
 * 0x059B[4]     HOLD_PRESERVE_HIST     1                  0x1              
 * 0x059B[5]     HOLD_FRZ_WITH_INTONLY  1                  0x1              
 * 0x059B[6]     HOLDEXIT_BW_SEL0       1                  0x1              
 * 0x059B[7]     HOLDEXIT_STD_BO        1                  0x1              
 * 0x059D[5:0]   HOLDEXIT_BW0           24                 0x18             
 * 0x059E[5:0]   HOLDEXIT_BW1           41                 0x29             
 * 0x059F[5:0]   HOLDEXIT_BW2           12                 0x0C             
 * 0x05A0[5:0]   HOLDEXIT_BW3           11                 0x0B             
 * 0x05A1[5:0]   HOLDEXIT_BW4           1                  0x01             
 * 0x05A2[5:0]   HOLDEXIT_BW5           7                  0x07             
 * 0x05A6[2:0]   RAMP_STEP_SIZE         0                  0x0              
 * 0x05A6[3]     RAMP_SWITCH_EN         0                  0x0              
 * 0x0802[15:0]  FIXREGSA0              1333               0x0535           
 * 0x0804[7:0]   FIXREGSD0              0                  0x00             
 * 0x0805[15:0]  FIXREGSA1              0                  0x0000           
 * 0x0807[7:0]   FIXREGSD1              0                  0x00             
 * 0x0808[15:0]  FIXREGSA2              0                  0x0000           
 * 0x080A[7:0]   FIXREGSD2              0                  0x00             
 * 0x080B[15:0]  FIXREGSA3              0                  0x0000           
 * 0x080D[7:0]   FIXREGSD3              0                  0x00             
 * 0x080E[15:0]  FIXREGSA4              0                  0x0000           
 * 0x0810[7:0]   FIXREGSD4              0                  0x00             
 * 0x0811[15:0]  FIXREGSA5              0                  0x0000           
 * 0x0813[7:0]   FIXREGSD5              0                  0x00             
 * 0x0814[15:0]  FIXREGSA6              0                  0x0000           
 * 0x0816[7:0]   FIXREGSD6              0                  0x00             
 * 0x0817[15:0]  FIXREGSA7              0                  0x0000           
 * 0x0819[7:0]   FIXREGSD7              0                  0x00             
 * 0x081A[15:0]  FIXREGSA8              0                  0x0000           
 * 0x081C[7:0]   FIXREGSD8              0                  0x00             
 * 0x081D[15:0]  FIXREGSA9              0                  0x0000           
 * 0x081F[7:0]   FIXREGSD9              0                  0x00             
 * 0x0820[15:0]  FIXREGSA10             0                  0x0000           
 * 0x0822[7:0]   FIXREGSD10             0                  0x00             
 * 0x0823[15:0]  FIXREGSA11             0                  0x0000           
 * 0x0825[7:0]   FIXREGSD11             0                  0x00             
 * 0x0826[15:0]  FIXREGSA12             0                  0x0000           
 * 0x0828[7:0]   FIXREGSD12             0                  0x00             
 * 0x0829[15:0]  FIXREGSA13             0                  0x0000           
 * 0x082B[7:0]   FIXREGSD13             0                  0x00             
 * 0x082C[15:0]  FIXREGSA14             0                  0x0000           
 * 0x082E[7:0]   FIXREGSD14             0                  0x00             
 * 0x082F[15:0]  FIXREGSA15             0                  0x0000           
 * 0x0831[7:0]   FIXREGSD15             0                  0x00             
 * 0x0832[15:0]  FIXREGSA16             0                  0x0000           
 * 0x0834[7:0]   FIXREGSD16             0                  0x00             
 * 0x0835[15:0]  FIXREGSA17             0                  0x0000           
 * 0x0837[7:0]   FIXREGSD17             0                  0x00             
 * 0x0838[15:0]  FIXREGSA18             0                  0x0000           
 * 0x083A[7:0]   FIXREGSD18             0                  0x00             
 * 0x083B[15:0]  FIXREGSA19             0                  0x0000           
 * 0x083D[7:0]   FIXREGSD19             0                  0x00             
 * 0x083E[15:0]  FIXREGSA20             0                  0x0000           
 * 0x0840[7:0]   FIXREGSD20             0                  0x00             
 * 0x0841[15:0]  FIXREGSA21             0                  0x0000           
 * 0x0843[7:0]   FIXREGSD21             0                  0x00             
 * 0x0844[15:0]  FIXREGSA22             0                  0x0000           
 * 0x0846[7:0]   FIXREGSD22             0                  0x00             
 * 0x0847[15:0]  FIXREGSA23             0                  0x0000           
 * 0x0849[7:0]   FIXREGSD23             0                  0x00             
 * 0x084A[15:0]  FIXREGSA24             0                  0x0000           
 * 0x084C[7:0]   FIXREGSD24             0                  0x00             
 * 0x084D[15:0]  FIXREGSA25             0                  0x0000           
 * 0x084F[7:0]   FIXREGSD25             0                  0x00             
 * 0x0850[15:0]  FIXREGSA26             0                  0x0000           
 * 0x0852[7:0]   FIXREGSD26             0                  0x00             
 * 0x0853[15:0]  FIXREGSA27             0                  0x0000           
 * 0x0855[7:0]   FIXREGSD27             0                  0x00             
 * 0x0856[15:0]  FIXREGSA28             0                  0x0000           
 * 0x0858[7:0]   FIXREGSD28             0                  0x00             
 * 0x0859[15:0]  FIXREGSA29             0                  0x0000           
 * 0x085B[7:0]   FIXREGSD29             0                  0x00             
 * 0x085C[15:0]  FIXREGSA30             0                  0x0000           
 * 0x085E[7:0]   FIXREGSD30             0                  0x00             
 * 0x085F[15:0]  FIXREGSA31             0                  0x0000           
 * 0x0861[7:0]   FIXREGSD31             0                  0x00             
 * 0x090E[0]     XAXB_EXTCLK_EN         1                  0x1              
 * 0x0943[0]     IO_VDD_SEL             0                  0x0              
 * 0x0949[3:0]   IN_EN                  1                  0x1              
 * 0x0949[7:4]   IN_PULSED_CMOS_EN      3                  0x3              
 * 0x094A[3:0]   INX_TO_PFD_EN          1                  0x1              
 * 0x094E[11:0]  REFCLK_HYS_SEL         585                0x249            
 * 0x095E[0]     MXAXB_INTEGER          0                  0x0              
 * 0x0A02[4:0]   N_ADD_0P5              0                  0x00             
 * 0x0A03[4:0]   N_CLK_TO_OUTX_EN       7                  0x07             
 * 0x0A04[4:0]   N_PIBYP                1                  0x01             
 * 0x0A05[4:0]   N_PDNB                 7                  0x07             
 * 0x0A14[3]     N0_HIGH_FREQ           0                  0x0              
 * 0x0A1A[3]     N1_HIGH_FREQ           0                  0x0              
 * 0x0A20[3]     N2_HIGH_FREQ           0                  0x0              
 * 0x0A26[3]     N3_HIGH_FREQ           0                  0x0              
 * 0x0A2C[3]     N4_HIGH_FREQ           0                  0x0              
 * 0x0B44[3:0]   PDIV_FRACN_CLK_DIS     15                 0xF              
 * 0x0B44[5]     FRACN_CLK_DIS_PLL      1                  0x1              
 * 0x0B46[3:0]   LOS_CLK_DIS            0                  0x0              
 * 0x0B47[4:0]   OOF_CLK_DIS            14                 0x0E             
 * 0x0B48[4:0]   OOF_DIV_CLK_DIS        14                 0x0E             
 * 0x0B4A[4:0]   N_CLK_DIS              24                 0x18             
 * 0x0B57[11:0]  VCO_RESET_CALCODE      249                0x0F9
 * 
 *
 */


static struct ntv2_genlock_data s_genlock_750_5994[] =
{
	/* Start configuration preamble */
	{ 0x0B24, 0xC0 },
	{ 0x0B25, 0x00 },
	{ 0x0540, 0x01 },
	/* End configuration preamble */

	/* Delay 300 msec */
	/*    Delay is worst case time for device to complete any calibration */
	/*    that is running due to device state change previous to this script */
	/*    being processed. */
	{ 0x0000, 0x01 },

	/* Start configuration registers */
	{ 0x000B, 0x64 },
	{ 0x0016, 0x02 },
	{ 0x0017, 0xFC },
	{ 0x0018, 0xFF },
	{ 0x0019, 0xDF },
	{ 0x001A, 0xDF },
	{ 0x002B, 0x02 },
	{ 0x002C, 0x01 },
	{ 0x002D, 0x02 },
	{ 0x002E, 0xB3 },
	{ 0x002F, 0x05 },
	{ 0x0030, 0x00 },
	{ 0x0031, 0x00 },
	{ 0x0032, 0x00 },
	{ 0x0033, 0x00 },
	{ 0x0034, 0x00 },
	{ 0x0035, 0x00 },
	{ 0x0036, 0x3A },
	{ 0x0037, 0x05 },
	{ 0x0038, 0x00 },
	{ 0x0039, 0x00 },
	{ 0x003A, 0x00 },
	{ 0x003B, 0x00 },
	{ 0x003C, 0x00 },
	{ 0x003D, 0x00 },
	{ 0x003F, 0x01 },
	{ 0x0040, 0x04 },
	{ 0x0041, 0x02 },
	{ 0x0042, 0x00 },
	{ 0x0043, 0x00 },
	{ 0x0044, 0x00 },
	{ 0x0045, 0x0C },
	{ 0x0046, 0x96 },
	{ 0x0047, 0x00 },
	{ 0x0048, 0x00 },
	{ 0x0049, 0x00 },
	{ 0x004A, 0x4B },
	{ 0x004B, 0x00 },
	{ 0x004C, 0x00 },
	{ 0x004D, 0x00 },
	{ 0x004E, 0x05 },
	{ 0x004F, 0x00 },
	{ 0x0050, 0x0F },
	{ 0x0051, 0x00 },
	{ 0x0052, 0x00 },
	{ 0x0053, 0x00 },
	{ 0x0054, 0x00 },
	{ 0x0055, 0x00 },
	{ 0x0056, 0x00 },
	{ 0x0057, 0x00 },
	{ 0x0058, 0x00 },
	{ 0x0059, 0x01 },
	{ 0x005A, 0xF6 },
	{ 0x005B, 0xA0 },
	{ 0x005C, 0xE2 },
	{ 0x005D, 0x00 },
	{ 0x005E, 0x00 },
	{ 0x005F, 0x00 },
	{ 0x0060, 0x00 },
	{ 0x0061, 0x00 },
	{ 0x0062, 0x00 },
	{ 0x0063, 0x00 },
	{ 0x0064, 0x00 },
	{ 0x0065, 0x00 },
	{ 0x0066, 0x00 },
	{ 0x0067, 0x00 },
	{ 0x0068, 0x00 },
	{ 0x0069, 0x00 },
	{ 0x0092, 0x02 },
	{ 0x0093, 0xA0 },
	{ 0x0095, 0x00 },
	{ 0x0096, 0x90 },
	{ 0x0098, 0x70 },
	{ 0x009A, 0x02 },
	{ 0x009B, 0x50 },
	{ 0x009D, 0x04 },
	{ 0x009E, 0x60 },
	{ 0x00A0, 0x30 },
	{ 0x00A2, 0x00 },
	{ 0x00A9, 0xBE },
	{ 0x00AA, 0x49 },
	{ 0x00AB, 0x04 },
	{ 0x00AC, 0x00 },
	{ 0x00E5, 0x21 },
	{ 0x00EA, 0xD1 },
	{ 0x00EB, 0xB1 },
	{ 0x00EC, 0x03 },
	{ 0x00ED, 0x00 },
	{ 0x0102, 0x01 },
	{ 0x0108, 0x02 },
	{ 0x0109, 0x09 },
	{ 0x010A, 0x3B },
	{ 0x010B, 0x28 },
	{ 0x010D, 0x01 },
	{ 0x010E, 0x09 },
	{ 0x010F, 0x3B },
	{ 0x0110, 0x28 },
	{ 0x0112, 0x02 },
	{ 0x0113, 0x09 },
	{ 0x0114, 0x3B },
	{ 0x0115, 0x28 },
	{ 0x0117, 0x01 },
	{ 0x0118, 0x09 },
	{ 0x0119, 0x3B },
	{ 0x011A, 0x28 },
	{ 0x011C, 0x01 },
	{ 0x011D, 0x09 },
	{ 0x011E, 0x3B },
	{ 0x011F, 0x28 },
	{ 0x0121, 0x02 },
	{ 0x0122, 0x09 },
	{ 0x0123, 0x3B },
	{ 0x0124, 0x29 },
	{ 0x0126, 0x01 },
	{ 0x0127, 0x09 },
	{ 0x0128, 0x3B },
	{ 0x0129, 0x28 },
	{ 0x012B, 0x01 },
	{ 0x012C, 0x09 },
	{ 0x012D, 0x3B },
	{ 0x012E, 0x28 },
	{ 0x0130, 0x02 },
	{ 0x0131, 0x09 },
	{ 0x0132, 0x3B },
	{ 0x0133, 0x2A },
	{ 0x013A, 0x01 },
	{ 0x013B, 0x09 },
	{ 0x013C, 0x3B },
	{ 0x013D, 0x28 },
	{ 0x013F, 0x00 },
	{ 0x0140, 0x00 },
	{ 0x0141, 0x40 },
	{ 0x0142, 0xFF },
	{ 0x0206, 0x00 },
	{ 0x0208, 0x01 },
	{ 0x0209, 0x00 },
	{ 0x020A, 0x00 },
	{ 0x020B, 0x00 },
	{ 0x020C, 0x00 },
	{ 0x020D, 0x00 },
	{ 0x020E, 0x01 },
	{ 0x020F, 0x00 },
	{ 0x0210, 0x00 },
	{ 0x0211, 0x00 },
	{ 0x0212, 0x00 },
	{ 0x0213, 0x00 },
	{ 0x0214, 0x00 },
	{ 0x0215, 0x00 },
	{ 0x0216, 0x00 },
	{ 0x0217, 0x00 },
	{ 0x0218, 0x00 },
	{ 0x0219, 0x00 },
	{ 0x021A, 0x00 },
	{ 0x021B, 0x00 },
	{ 0x021C, 0x00 },
	{ 0x021D, 0x00 },
	{ 0x021E, 0x00 },
	{ 0x021F, 0x00 },
	{ 0x0220, 0x00 },
	{ 0x0221, 0x00 },
	{ 0x0222, 0x00 },
	{ 0x0223, 0x00 },
	{ 0x0224, 0x00 },
	{ 0x0225, 0x00 },
	{ 0x0226, 0x00 },
	{ 0x0227, 0x00 },
	{ 0x0228, 0x00 },
	{ 0x0229, 0x00 },
	{ 0x022A, 0x00 },
	{ 0x022B, 0x00 },
	{ 0x022C, 0x00 },
	{ 0x022D, 0x00 },
	{ 0x022E, 0x00 },
	{ 0x022F, 0x00 },
	{ 0x0231, 0x0B },
	{ 0x0232, 0x0B },
	{ 0x0233, 0x0B },
	{ 0x0234, 0x0B },
	{ 0x0235, 0x00 },
	{ 0x0236, 0x00 },
	{ 0x0237, 0x00 },
	{ 0x0238, 0x78 },
	{ 0x0239, 0xD5 },
	{ 0x023A, 0x00 },
	{ 0x023B, 0x00 },
	{ 0x023C, 0x00 },
	{ 0x023D, 0x00 },
	{ 0x023E, 0xD0 },
	{ 0x024A, 0x0A },
	{ 0x024B, 0x00 },
	{ 0x024C, 0x00 },
	{ 0x024D, 0x00 },
	{ 0x024E, 0x00 },
	{ 0x024F, 0x00 },
	{ 0x0250, 0x01 },
	{ 0x0251, 0x00 },
	{ 0x0252, 0x00 },
	{ 0x0253, 0x00 },
	{ 0x0254, 0x00 },
	{ 0x0255, 0x00 },
	{ 0x0256, 0x00 },
	{ 0x0257, 0x00 },
	{ 0x0258, 0x00 },
	{ 0x0259, 0x02 },
	{ 0x025A, 0x00 },
	{ 0x025B, 0x00 },
	{ 0x025C, 0x00 },
	{ 0x025D, 0x00 },
	{ 0x025E, 0x00 },
	{ 0x025F, 0x00 },
	{ 0x0260, 0x00 },
	{ 0x0261, 0x00 },
	{ 0x0262, 0x02 },
	{ 0x0263, 0x00 },
	{ 0x0264, 0x00 },
	{ 0x0268, 0x00 },
	{ 0x0269, 0x00 },
	{ 0x026A, 0x00 },
	{ 0x026B, 0x49 },
	{ 0x026C, 0x4F },
	{ 0x026D, 0x34 },
	{ 0x026E, 0x4B },
	{ 0x026F, 0x2B },
	{ 0x0270, 0x00 },
	{ 0x0271, 0x00 },
	{ 0x0272, 0x00 },
	{ 0x0294, 0x80 },
	{ 0x0296, 0x00 },
	{ 0x0297, 0x02 },
	{ 0x0299, 0x02 },
	{ 0x029D, 0xF5 },
	{ 0x029E, 0x0E },
	{ 0x029F, 0x00 },
	{ 0x02A9, 0x66 },
	{ 0x02AA, 0x26 },
	{ 0x02AB, 0x00 },
	{ 0x02B7, 0xFF },
	{ 0x0302, 0x00 },
	{ 0x0303, 0x00 },
	{ 0x0304, 0x00 },
	{ 0x0305, 0x80 },
	{ 0x0306, 0x0B },
	{ 0x0307, 0x00 },
	{ 0x0308, 0x00 },
	{ 0x0309, 0x00 },
	{ 0x030A, 0x00 },
	{ 0x030B, 0x80 },
	{ 0x030C, 0x00 },
	{ 0x030D, 0x00 },
	{ 0x030E, 0x00 },
	{ 0x030F, 0x60 },
	{ 0x0310, 0x53 },
	{ 0x0311, 0x2E },
	{ 0x0312, 0x00 },
	{ 0x0313, 0x00 },
	{ 0x0314, 0x00 },
	{ 0x0315, 0x00 },
	{ 0x0316, 0x80 },
	{ 0x0317, 0x00 },
	{ 0x0318, 0x00 },
	{ 0x0319, 0x00 },
	{ 0x031A, 0xE0 },
	{ 0x031B, 0x3D },
	{ 0x031C, 0x0B },
	{ 0x031D, 0x00 },
	{ 0x031E, 0x00 },
	{ 0x031F, 0x00 },
	{ 0x0320, 0x80 },
	{ 0x0321, 0xBB },
	{ 0x0322, 0x00 },
	{ 0x0323, 0x00 },
	{ 0x0324, 0x00 },
	{ 0x0325, 0x00 },
	{ 0x0326, 0x00 },
	{ 0x0327, 0x00 },
	{ 0x0328, 0x00 },
	{ 0x0329, 0x00 },
	{ 0x032A, 0x00 },
	{ 0x032B, 0x00 },
	{ 0x032C, 0x00 },
	{ 0x032D, 0x00 },
	{ 0x032E, 0x00 },
	{ 0x032F, 0x00 },
	{ 0x0330, 0x00 },
	{ 0x0331, 0x00 },
	{ 0x0332, 0x00 },
	{ 0x0333, 0x00 },
	{ 0x0334, 0x00 },
	{ 0x0335, 0x00 },
	{ 0x0336, 0x00 },
	{ 0x0337, 0x00 },
	{ 0x0338, 0x00 },
	{ 0x0339, 0x1F },
	{ 0x033B, 0x00 },
	{ 0x033C, 0x00 },
	{ 0x033D, 0x00 },
	{ 0x033E, 0x00 },
	{ 0x033F, 0x00 },
	{ 0x0340, 0x00 },
	{ 0x0341, 0x00 },
	{ 0x0342, 0x00 },
	{ 0x0343, 0x00 },
	{ 0x0344, 0x00 },
	{ 0x0345, 0x00 },
	{ 0x0346, 0x00 },
	{ 0x0347, 0x00 },
	{ 0x0348, 0x00 },
	{ 0x0349, 0x00 },
	{ 0x034A, 0x00 },
	{ 0x034B, 0x00 },
	{ 0x034C, 0x00 },
	{ 0x034D, 0x00 },
	{ 0x034E, 0x00 },
	{ 0x034F, 0x00 },
	{ 0x0350, 0x00 },
	{ 0x0351, 0x00 },
	{ 0x0352, 0x00 },
	{ 0x0353, 0x00 },
	{ 0x0354, 0x00 },
	{ 0x0355, 0x00 },
	{ 0x0356, 0x00 },
	{ 0x0357, 0x00 },
	{ 0x0358, 0x00 },
	{ 0x0359, 0x00 },
	{ 0x035A, 0x00 },
	{ 0x035B, 0x00 },
	{ 0x035C, 0x00 },
	{ 0x035D, 0x00 },
	{ 0x035E, 0x00 },
	{ 0x035F, 0x00 },
	{ 0x0360, 0x00 },
	{ 0x0361, 0x00 },
	{ 0x0362, 0x00 },
	{ 0x0487, 0x00 },
	{ 0x0502, 0x01 },
	{ 0x0508, 0x11 },
	{ 0x0509, 0x1A },
	{ 0x050A, 0x0F },
	{ 0x050B, 0x0F },
	{ 0x050C, 0x01 },
	{ 0x050D, 0x07 },
	{ 0x050E, 0x17 },
	{ 0x050F, 0x28 },
	{ 0x0510, 0x0C },
	{ 0x0511, 0x0B },
	{ 0x0512, 0x01 },
	{ 0x0513, 0x07 },
	{ 0x0515, 0x00 },
	{ 0x0516, 0x00 },
	{ 0x0517, 0x00 },
	{ 0x0518, 0xF0 },
	{ 0x0519, 0x7C },
	{ 0x051A, 0xB9 },
	{ 0x051B, 0x00 },
	{ 0x051C, 0x00 },
	{ 0x051D, 0x00 },
	{ 0x051E, 0x00 },
	{ 0x051F, 0xC8 },
	{ 0x0521, 0x3B },
	{ 0x052A, 0x01 },
	{ 0x052B, 0x01 },
	{ 0x052C, 0x0F },
	{ 0x052D, 0x03 },
	{ 0x052E, 0x15 },
	{ 0x052F, 0x14 },
	{ 0x0531, 0x00 },
	{ 0x0532, 0xD3 },
	{ 0x0533, 0x90 },
	{ 0x0534, 0x00 },
	{ 0x0535, 0x00 },
	{ 0x0536, 0x00 },
	{ 0x0537, 0x00 },
	{ 0x0538, 0x00 },
	{ 0x0539, 0x00 },
	{ 0x053A, 0x02 },
	{ 0x053B, 0x03 },
	{ 0x053C, 0x00 },
	{ 0x053D, 0x12 },
	{ 0x053E, 0x06 },
	{ 0x0589, 0x5D },
	{ 0x058A, 0x02 },
	{ 0x059B, 0xF8 },
	{ 0x059D, 0x17 },
	{ 0x059E, 0x28 },
	{ 0x059F, 0x0C },
	{ 0x05A0, 0x0B },
	{ 0x05A1, 0x01 },
	{ 0x05A2, 0x07 },
	{ 0x05A6, 0x00 },
	{ 0x0802, 0x35 },
	{ 0x0803, 0x05 },
	{ 0x0804, 0x00 },
	{ 0x0805, 0x00 },
	{ 0x0806, 0x00 },
	{ 0x0807, 0x00 },
	{ 0x0808, 0x00 },
	{ 0x0809, 0x00 },
	{ 0x080A, 0x00 },
	{ 0x080B, 0x00 },
	{ 0x080C, 0x00 },
	{ 0x080D, 0x00 },
	{ 0x080E, 0x00 },
	{ 0x080F, 0x00 },
	{ 0x0810, 0x00 },
	{ 0x0811, 0x00 },
	{ 0x0812, 0x00 },
	{ 0x0813, 0x00 },
	{ 0x0814, 0x00 },
	{ 0x0815, 0x00 },
	{ 0x0816, 0x00 },
	{ 0x0817, 0x00 },
	{ 0x0818, 0x00 },
	{ 0x0819, 0x00 },
	{ 0x081A, 0x00 },
	{ 0x081B, 0x00 },
	{ 0x081C, 0x00 },
	{ 0x081D, 0x00 },
	{ 0x081E, 0x00 },
	{ 0x081F, 0x00 },
	{ 0x0820, 0x00 },
	{ 0x0821, 0x00 },
	{ 0x0822, 0x00 },
	{ 0x0823, 0x00 },
	{ 0x0824, 0x00 },
	{ 0x0825, 0x00 },
	{ 0x0826, 0x00 },
	{ 0x0827, 0x00 },
	{ 0x0828, 0x00 },
	{ 0x0829, 0x00 },
	{ 0x082A, 0x00 },
	{ 0x082B, 0x00 },
	{ 0x082C, 0x00 },
	{ 0x082D, 0x00 },
	{ 0x082E, 0x00 },
	{ 0x082F, 0x00 },
	{ 0x0830, 0x00 },
	{ 0x0831, 0x00 },
	{ 0x0832, 0x00 },
	{ 0x0833, 0x00 },
	{ 0x0834, 0x00 },
	{ 0x0835, 0x00 },
	{ 0x0836, 0x00 },
	{ 0x0837, 0x00 },
	{ 0x0838, 0x00 },
	{ 0x0839, 0x00 },
	{ 0x083A, 0x00 },
	{ 0x083B, 0x00 },
	{ 0x083C, 0x00 },
	{ 0x083D, 0x00 },
	{ 0x083E, 0x00 },
	{ 0x083F, 0x00 },
	{ 0x0840, 0x00 },
	{ 0x0841, 0x00 },
	{ 0x0842, 0x00 },
	{ 0x0843, 0x00 },
	{ 0x0844, 0x00 },
	{ 0x0845, 0x00 },
	{ 0x0846, 0x00 },
	{ 0x0847, 0x00 },
	{ 0x0848, 0x00 },
	{ 0x0849, 0x00 },
	{ 0x084A, 0x00 },
	{ 0x084B, 0x00 },
	{ 0x084C, 0x00 },
	{ 0x084D, 0x00 },
	{ 0x084E, 0x00 },
	{ 0x084F, 0x00 },
	{ 0x0850, 0x00 },
	{ 0x0851, 0x00 },
	{ 0x0852, 0x00 },
	{ 0x0853, 0x00 },
	{ 0x0854, 0x00 },
	{ 0x0855, 0x00 },
	{ 0x0856, 0x00 },
	{ 0x0857, 0x00 },
	{ 0x0858, 0x00 },
	{ 0x0859, 0x00 },
	{ 0x085A, 0x00 },
	{ 0x085B, 0x00 },
	{ 0x085C, 0x00 },
	{ 0x085D, 0x00 },
	{ 0x085E, 0x00 },
	{ 0x085F, 0x00 },
	{ 0x0860, 0x00 },
	{ 0x0861, 0x00 },
	{ 0x090E, 0x03 },
	{ 0x0943, 0x00 },
	{ 0x0949, 0x31 },
	{ 0x094A, 0x01 },
	{ 0x094E, 0x49 },
	{ 0x094F, 0x02 },
	{ 0x095E, 0x00 },
	{ 0x0A02, 0x00 },
	{ 0x0A03, 0x07 },
	{ 0x0A04, 0x01 },
	{ 0x0A05, 0x07 },
	{ 0x0A14, 0x00 },
	{ 0x0A1A, 0x00 },
	{ 0x0A20, 0x00 },
	{ 0x0A26, 0x00 },
	{ 0x0A2C, 0x00 },
	{ 0x0B44, 0x0F },
	{ 0x0B46, 0x00 },
	{ 0x0B47, 0x0E },
	{ 0x0B48, 0x0E },
	{ 0x0B4A, 0x18 },
	{ 0x0B57, 0xF9 },
	{ 0x0B58, 0x00 },
	/* End configuration registers */

	/* Start configuration postamble */
	{ 0x0514, 0x01 },
	{ 0x001C, 0x01 },
	{ 0x0540, 0x00 },
	{ 0x0B24, 0xC3 },
	{ 0x0B25, 0x02 },
	/* End configuration postamble */

	{ 0x0000, 0x00 }
};

/*
 * Design Report
 *
 * Overview
 * ========
 * Part:         Si5345 Rev D
 * Project File: C:\XilinxProjects\flint_tr051017\genlock\FormatFiles\IO4K+_1125_5994.slabtimeproj
 * Design ID:    IO4K+
 * Created By:   ClockBuilder Pro v2.16.1 [2017-07-19]
 * Timestamp:    2017-08-24 16:19:47 GMT-07:00
 * 
 * Design Notes
 * ============
 * assumes NTSC HSYNC (pulsed) input = (30/1.001)*525
 * 
 * Design Rule Check
 * =================
 * Errors:
 * - No errors
 * 
 * Warnings:
 * - Pulsed LVCMOS input buffer mode has been selected. This mode has non-standard input voltage logic thresholds: 0.33 V for Vil (max) and 0.49 V for Vih (min). Select this mode only if your input clock has a duty cycle significantly less or more than 50%.  Refer to the device datasheet for the exact threshold voltage specifications and the input attenuator circuit (DC coupled Pulsed LVCMOS) in the Family Reference Manual.
 * 
 * Device Grade
 * ============
 * Maximum Output Frequency: 148.5 MHz
 * Frequency Synthesis Mode: Fractional
 * Minimum Base OPN:         Si5345B
 * Actual Base OPN:          Si5345B
 * 
 * Base       Output Clock         Supported Frequency Synthesis Modes
 * OPN Grade  Frequency Range      (Typical Jitter)
 * ---------  -------------------  --------------------------------------------
 * Si5345A    100 Hz to 1.028 GHz  Integer (< 100 fs) and fractional (< 150 fs)
 * Si5345B    100 Hz to 350 MHz    "
 * Si5345C    100 Hz to 1.028 GHz  Integer only (< 100 fs)
 * Si5345D    100 Hz to 350 MHz    "
 * 
 * Design
 * ======
 * Host Interface:
 *    I/O Power Supply: VDD (Core)
 *    SPI Mode: 4-Wire
 *    I2C Address Range: 100d to 103d / 0x64 to 0x67 (selected via A0/A1 pins)
 * 
 * XA/XB:
 *    52 MHz (XO - External Oscillator)
 * 
 * Inputs:
 *     IN0: 44.9550449550449550... kHz [ 44 + 956/1001 kHz ]
 *          [ (60000/1001)*750 ]
 *          Pulsed LVCMOS
 *     IN1: Unused
 *     IN2: Unused
 *     IN3: Unused
 * 
 * Outputs:
 *    OUT0: 27 MHz
 *          Enabled, LVDS 2.5 V
 *    OUT1: Unused
 *    OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT3: Unused
 *    OUT4: Unused
 *    OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT6: Unused
 *    OUT7: Unused
 *    OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *          [ 148.5/1.001 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT9: Unused
 * 
 * Frequency Plan
 * ==============
 * Priority: maximize the number of low jitter outputs
 * 
 * Fvco = 13.662 GHz [ 13 + 331/500 GHz ]
 * Fpfd = 44.9550449550449550... kHz [ 44 + 956/1001 kHz ]
 * Fms0 = 594 MHz
 * Fms1 = 147.456 MHz [ 147 + 57/125 MHz ]
 * Fms2 = 890.1098901098901098... MHz [ 890 + 10/91 MHz ]
 * 
 * P dividers:
 *    P0  = 1
 *    P1  = Unused
 *    P2  = Unused
 *    P3  = Unused
 *    Pxaxb = 1
 * 
 * MXAXB = 262.7307692307692307... [ 262 + 19/26 ]
 * M = 60780.72 [ 60780 + 18/25 ]
 * N dividers:
 *    N0:
 *       Value: 23
 *       Skew:  0.000 s
 *       OUT0: 27 MHz
 *       OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *    N1:
 *       Value: 92.6513671875 [ 92 + 667/1024 ]
 *       Skew:  0.000 s
 *       OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *    N2:
 *       Value: 15.3486666666666666... [ 15 + 523/1500 ]
 *       Skew:  0.000 s
 *       OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *    N3:
 *       Unused
 *    N4:
 *       Unused
 * 
 * R dividers:
 *    R0 = 22
 *    R1 = Unused
 *    R2 = 4
 *    R3 = Unused
 *    R4 = Unused
 *    R5 = 6
 *    R6 = Unused
 *    R7 = Unused
 *    R8 = 6
 *    R9 = Unused
 * 
 * Nominal Bandwidth:
 *   Desired: 1.000 Hz
 *   Actual:  873.995 mHz
 *   Coefficients:
 *      BW0:  17
 *      BW1:  26
 *      BW2:  15
 *      BW3:  15
 *      BW4:  1
 *      BW5:  7
 * Fastlock Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  64.779 Hz
 *   Coefficients:
 *      BW0:  23
 *      BW1:  40
 *      BW2:  12
 *      BW3:  11
 *      BW4:  1
 *      BW5:  7
 * Holdover Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  64.779 Hz
 *   Coefficients:
 *      BW0:  23
 *      BW1:  40
 *      BW2:  12
 *      BW3:  11
 *      BW4:  1
 *      BW5:  7
 * 
 * Dividers listed above show effective values. These values are translated to register settings by ClockBuilder Pro. For the actual register values, see below. Refer to the Family Reference Manual for information on registers related to frequency plan.
 * 
 * Digitally Controlled Oscillator (DCO)
 * =====================================
 * Mode: Register Direct Write
 * 
 * N0: DCO Disabled
 * 
 * N1: DCO Disabled
 * 
 * N2: DCO Disabled
 * 
 * N3: DCO Disabled
 * 
 * N4: DCO Disabled
 * 
 * Estimated Power & Junction Temperature
 * ======================================
 * Assumptions:
 * 
 * Revision: D
 * VDD:      1.8 V
 * Ta:       70 C
 * Airflow:  None
 * 
 * Total Power: 808 mW, On Chip Power: 784 mW, Tj: 87 C
 * 
 *                 Frequency  Format   Voltage   Current     Power
 *         -----------------  ------  --------  --------  --------
 * VDD                                   1.8 V  147.9 mA    266 mW
 * VDDA                                  3.3 V  117.4 mA    387 mW
 * VDDO0              27 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO1              Unused                                      
 * VDDO2           148.5 MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO3              Unused                                      
 * VDDO4              Unused                                      
 * VDDO5          24.576 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO6              Unused                                      
 * VDDO7              Unused                                      
 * VDDO8   148.351648... MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO9              Unused                                      
 *                                              --------  --------
 *                                       Total  327.2 mA    808 mW
 * 
 * Note:
 * 
 * -Total power includes on- and off-chip power. This is a typical value and estimate only.
 * -Use an EVB for a more exact power measurement
 * -On-chip power excludes power dissipated in external terminations.
 * -Tj is junction temperature. Tj must be less than 125 C (on Si5345 Revision D) for device to comply with datasheet specifications.
 * 
 * Settings
 * ========
 * 
 * Location      Setting Name           Decimal Value      Hex Value        
 * ------------  ---------------------  -----------------  -----------------
 * 0x000B[6:0]   I2C_ADDR               100                0x64             
 * 0x0016[1]     LOL_ON_HOLD            1                  0x1              
 * 0x0017[0]     SYSINCAL_INTR_MSK      0                  0x0              
 * 0x0017[1]     LOSXAXB_INTR_MSK       0                  0x0              
 * 0x0017[5]     SMB_TMOUT_INTR_MSK     1                  0x1              
 * 0x0018[3:0]   LOS_INTR_MSK           15                 0xF              
 * 0x0018[7:4]   OOF_INTR_MSK           15                 0xF              
 * 0x0019[1]     LOL_INTR_MSK           1                  0x1              
 * 0x0019[5]     HOLD_INTR_MSK          0                  0x0              
 * 0x001A[5]     CAL_INTR_MSK           0                  0x0              
 * 0x002B[3]     SPI_3WIRE              0                  0x0              
 * 0x002B[5]     AUTO_NDIV_UPDATE       0                  0x0              
 * 0x002C[3:0]   LOS_EN                 1                  0x1              
 * 0x002C[4]     LOSXAXB_DIS            0                  0x0              
 * 0x002D[1:0]   LOS0_VAL_TIME          2                  0x2              
 * 0x002D[3:2]   LOS1_VAL_TIME          0                  0x0              
 * 0x002D[5:4]   LOS2_VAL_TIME          0                  0x0              
 * 0x002D[7:6]   LOS3_VAL_TIME          0                  0x0              
 * 0x002E[15:0]  LOS0_TRG_THR           1459               0x05B3           
 * 0x0030[15:0]  LOS1_TRG_THR           0                  0x0000           
 * 0x0032[15:0]  LOS2_TRG_THR           0                  0x0000           
 * 0x0034[15:0]  LOS3_TRG_THR           0                  0x0000           
 * 0x0036[15:0]  LOS0_CLR_THR           1338               0x053A           
 * 0x0038[15:0]  LOS1_CLR_THR           0                  0x0000           
 * 0x003A[15:0]  LOS2_CLR_THR           0                  0x0000           
 * 0x003C[15:0]  LOS3_CLR_THR           0                  0x0000           
 * 0x003F[3:0]   OOF_EN                 1                  0x1              
 * 0x003F[7:4]   FAST_OOF_EN            0                  0x0              
 * 0x0040[2:0]   OOF_REF_SEL            4                  0x4              
 * 0x0041[4:0]   OOF0_DIV_SEL           2                  0x02             
 * 0x0042[4:0]   OOF1_DIV_SEL           0                  0x00             
 * 0x0043[4:0]   OOF2_DIV_SEL           0                  0x00             
 * 0x0044[4:0]   OOF3_DIV_SEL           0                  0x00             
 * 0x0045[4:0]   OOFXO_DIV_SEL          12                 0x0C             
 * 0x0046[7:0]   OOF0_SET_THR           150                0x96             
 * 0x0047[7:0]   OOF1_SET_THR           0                  0x00             
 * 0x0048[7:0]   OOF2_SET_THR           0                  0x00             
 * 0x0049[7:0]   OOF3_SET_THR           0                  0x00             
 * 0x004A[7:0]   OOF0_CLR_THR           75                 0x4B             
 * 0x004B[7:0]   OOF1_CLR_THR           0                  0x00             
 * 0x004C[7:0]   OOF2_CLR_THR           0                  0x00             
 * 0x004D[7:0]   OOF3_CLR_THR           0                  0x00             
 * 0x004E[2:0]   OOF0_DETWIN_SEL        5                  0x5              
 * 0x004E[6:4]   OOF1_DETWIN_SEL        0                  0x0              
 * 0x004F[2:0]   OOF2_DETWIN_SEL        0                  0x0              
 * 0x004F[6:4]   OOF3_DETWIN_SEL        0                  0x0              
 * 0x0050[3:0]   OOF_ON_LOS             15                 0xF              
 * 0x0051[3:0]   FAST_OOF0_SET_THR      0                  0x0              
 * 0x0052[3:0]   FAST_OOF1_SET_THR      0                  0x0              
 * 0x0053[3:0]   FAST_OOF2_SET_THR      0                  0x0              
 * 0x0054[3:0]   FAST_OOF3_SET_THR      0                  0x0              
 * 0x0055[3:0]   FAST_OOF0_CLR_THR      0                  0x0              
 * 0x0056[3:0]   FAST_OOF1_CLR_THR      0                  0x0              
 * 0x0057[3:0]   FAST_OOF2_CLR_THR      0                  0x0              
 * 0x0058[3:0]   FAST_OOF3_CLR_THR      0                  0x0              
 * 0x0059[1:0]   FAST_OOF0_DETWIN_SEL   1                  0x1              
 * 0x0059[3:2]   FAST_OOF1_DETWIN_SEL   0                  0x0              
 * 0x0059[5:4]   FAST_OOF2_DETWIN_SEL   0                  0x0              
 * 0x0059[7:6]   FAST_OOF3_DETWIN_SEL   0                  0x0              
 * 0x005A[25:0]  OOF0_RATIO_REF         14852342           0x0E2A0F6        
 * 0x005E[25:0]  OOF1_RATIO_REF         0                  0x0000000        
 * 0x0062[25:0]  OOF2_RATIO_REF         0                  0x0000000        
 * 0x0066[25:0]  OOF3_RATIO_REF         0                  0x0000000        
 * 0x0092[1]     LOL_FST_EN             1                  0x1              
 * 0x0093[7:4]   LOL_FST_DETWIN_SEL     10                 0xA              
 * 0x0095[3:2]   LOL_FST_VALWIN_SEL     0                  0x0              
 * 0x0096[7:4]   LOL_FST_SET_THR_SEL    9                  0x9              
 * 0x0098[7:4]   LOL_FST_CLR_THR_SEL    7                  0x7              
 * 0x009A[1]     LOL_SLOW_EN_PLL        1                  0x1              
 * 0x009B[7:4]   LOL_SLW_DETWIN_SEL     5                  0x5              
 * 0x009D[3:2]   LOL_SLW_VALWIN_SEL     1                  0x1              
 * 0x009E[7:4]   LOL_SLW_SET_THR        6                  0x6              
 * 0x00A0[7:4]   LOL_SLW_CLR_THR        3                  0x3              
 * 0x00A2[1]     LOL_TIMER_EN           0                  0x0              
 * 0x00A9[28:0]  LOL_CLR_DELAY_DIV256   281022             0x000449BE       
 * 0x00E5[5]     FASTLOCK_EXTEND_EN     1                  0x1              
 * 0x00EA[28:0]  FASTLOCK_EXTEND        242129             0x0003B1D1       
 * 0x0102[0]     OUTALL_DISABLE_LOW     1                  0x1              
 * 0x0108[0]     OUT0_PDN               0                  0x0              
 * 0x0108[1]     OUT0_OE                1                  0x1              
 * 0x0108[2]     OUT0_RDIV_FORCE2       0                  0x0              
 * 0x0109[2:0]   OUT0_FORMAT            1                  0x1              
 * 0x0109[3]     OUT0_SYNC_EN           1                  0x1              
 * 0x0109[5:4]   OUT0_DIS_STATE         0                  0x0              
 * 0x0109[7:6]   OUT0_CMOS_DRV          0                  0x0              
 * 0x010A[3:0]   OUT0_CM                11                 0xB              
 * 0x010A[6:4]   OUT0_AMPL              3                  0x3              
 * 0x010B[2:0]   OUT0_MUX_SEL           0                  0x0              
 * 0x010B[5:4]   OUT0_VDD_SEL           2                  0x2              
 * 0x010B[3]     OUT0_VDD_SEL_EN        1                  0x1              
 * 0x010B[7:6]   OUT0_INV               0                  0x0              
 * 0x010D[0]     OUT1_PDN               1                  0x1              
 * 0x010D[1]     OUT1_OE                0                  0x0              
 * 0x010D[2]     OUT1_RDIV_FORCE2       0                  0x0              
 * 0x010E[2:0]   OUT1_FORMAT            1                  0x1              
 * 0x010E[3]     OUT1_SYNC_EN           1                  0x1              
 * 0x010E[5:4]   OUT1_DIS_STATE         0                  0x0              
 * 0x010E[7:6]   OUT1_CMOS_DRV          0                  0x0              
 * 0x010F[3:0]   OUT1_CM                11                 0xB              
 * 0x010F[6:4]   OUT1_AMPL              3                  0x3              
 * 0x0110[2:0]   OUT1_MUX_SEL           0                  0x0              
 * 0x0110[5:4]   OUT1_VDD_SEL           2                  0x2              
 * 0x0110[3]     OUT1_VDD_SEL_EN        1                  0x1              
 * 0x0110[7:6]   OUT1_INV               0                  0x0              
 * 0x0112[0]     OUT2_PDN               0                  0x0              
 * 0x0112[1]     OUT2_OE                1                  0x1              
 * 0x0112[2]     OUT2_RDIV_FORCE2       0                  0x0              
 * 0x0113[2:0]   OUT2_FORMAT            1                  0x1              
 * 0x0113[3]     OUT2_SYNC_EN           1                  0x1              
 * 0x0113[5:4]   OUT2_DIS_STATE         0                  0x0              
 * 0x0113[7:6]   OUT2_CMOS_DRV          0                  0x0              
 * 0x0114[3:0]   OUT2_CM                11                 0xB              
 * 0x0114[6:4]   OUT2_AMPL              3                  0x3              
 * 0x0115[2:0]   OUT2_MUX_SEL           0                  0x0              
 * 0x0115[5:4]   OUT2_VDD_SEL           2                  0x2              
 * 0x0115[3]     OUT2_VDD_SEL_EN        1                  0x1              
 * 0x0115[7:6]   OUT2_INV               0                  0x0              
 * 0x0117[0]     OUT3_PDN               1                  0x1              
 * 0x0117[1]     OUT3_OE                0                  0x0              
 * 0x0117[2]     OUT3_RDIV_FORCE2       0                  0x0              
 * 0x0118[2:0]   OUT3_FORMAT            1                  0x1              
 * 0x0118[3]     OUT3_SYNC_EN           1                  0x1              
 * 0x0118[5:4]   OUT3_DIS_STATE         0                  0x0              
 * 0x0118[7:6]   OUT3_CMOS_DRV          0                  0x0              
 * 0x0119[3:0]   OUT3_CM                11                 0xB              
 * 0x0119[6:4]   OUT3_AMPL              3                  0x3              
 * 0x011A[2:0]   OUT3_MUX_SEL           0                  0x0              
 * 0x011A[5:4]   OUT3_VDD_SEL           2                  0x2              
 * 0x011A[3]     OUT3_VDD_SEL_EN        1                  0x1              
 * 0x011A[7:6]   OUT3_INV               0                  0x0              
 * 0x011C[0]     OUT4_PDN               1                  0x1              
 * 0x011C[1]     OUT4_OE                0                  0x0              
 * 0x011C[2]     OUT4_RDIV_FORCE2       0                  0x0              
 * 0x011D[2:0]   OUT4_FORMAT            1                  0x1              
 * 0x011D[3]     OUT4_SYNC_EN           1                  0x1              
 * 0x011D[5:4]   OUT4_DIS_STATE         0                  0x0              
 * 0x011D[7:6]   OUT4_CMOS_DRV          0                  0x0              
 * 0x011E[3:0]   OUT4_CM                11                 0xB              
 * 0x011E[6:4]   OUT4_AMPL              3                  0x3              
 * 0x011F[2:0]   OUT4_MUX_SEL           0                  0x0              
 * 0x011F[5:4]   OUT4_VDD_SEL           2                  0x2              
 * 0x011F[3]     OUT4_VDD_SEL_EN        1                  0x1              
 * 0x011F[7:6]   OUT4_INV               0                  0x0              
 * 0x0121[0]     OUT5_PDN               0                  0x0              
 * 0x0121[1]     OUT5_OE                1                  0x1              
 * 0x0121[2]     OUT5_RDIV_FORCE2       0                  0x0              
 * 0x0122[2:0]   OUT5_FORMAT            1                  0x1              
 * 0x0122[3]     OUT5_SYNC_EN           1                  0x1              
 * 0x0122[5:4]   OUT5_DIS_STATE         0                  0x0              
 * 0x0122[7:6]   OUT5_CMOS_DRV          0                  0x0              
 * 0x0123[3:0]   OUT5_CM                11                 0xB              
 * 0x0123[6:4]   OUT5_AMPL              3                  0x3              
 * 0x0124[2:0]   OUT5_MUX_SEL           1                  0x1              
 * 0x0124[5:4]   OUT5_VDD_SEL           2                  0x2              
 * 0x0124[3]     OUT5_VDD_SEL_EN        1                  0x1              
 * 0x0124[7:6]   OUT5_INV               0                  0x0              
 * 0x0126[0]     OUT6_PDN               1                  0x1              
 * 0x0126[1]     OUT6_OE                0                  0x0              
 * 0x0126[2]     OUT6_RDIV_FORCE2       0                  0x0              
 * 0x0127[2:0]   OUT6_FORMAT            1                  0x1              
 * 0x0127[3]     OUT6_SYNC_EN           1                  0x1              
 * 0x0127[5:4]   OUT6_DIS_STATE         0                  0x0              
 * 0x0127[7:6]   OUT6_CMOS_DRV          0                  0x0              
 * 0x0128[3:0]   OUT6_CM                11                 0xB              
 * 0x0128[6:4]   OUT6_AMPL              3                  0x3              
 * 0x0129[2:0]   OUT6_MUX_SEL           0                  0x0              
 * 0x0129[5:4]   OUT6_VDD_SEL           2                  0x2              
 * 0x0129[3]     OUT6_VDD_SEL_EN        1                  0x1              
 * 0x0129[7:6]   OUT6_INV               0                  0x0              
 * 0x012B[0]     OUT7_PDN               1                  0x1              
 * 0x012B[1]     OUT7_OE                0                  0x0              
 * 0x012B[2]     OUT7_RDIV_FORCE2       0                  0x0              
 * 0x012C[2:0]   OUT7_FORMAT            1                  0x1              
 * 0x012C[3]     OUT7_SYNC_EN           1                  0x1              
 * 0x012C[5:4]   OUT7_DIS_STATE         0                  0x0              
 * 0x012C[7:6]   OUT7_CMOS_DRV          0                  0x0              
 * 0x012D[3:0]   OUT7_CM                11                 0xB              
 * 0x012D[6:4]   OUT7_AMPL              3                  0x3              
 * 0x012E[2:0]   OUT7_MUX_SEL           0                  0x0              
 * 0x012E[5:4]   OUT7_VDD_SEL           2                  0x2              
 * 0x012E[3]     OUT7_VDD_SEL_EN        1                  0x1              
 * 0x012E[7:6]   OUT7_INV               0                  0x0              
 * 0x0130[0]     OUT8_PDN               0                  0x0              
 * 0x0130[1]     OUT8_OE                1                  0x1              
 * 0x0130[2]     OUT8_RDIV_FORCE2       0                  0x0              
 * 0x0131[2:0]   OUT8_FORMAT            1                  0x1              
 * 0x0131[3]     OUT8_SYNC_EN           1                  0x1              
 * 0x0131[5:4]   OUT8_DIS_STATE         0                  0x0              
 * 0x0131[7:6]   OUT8_CMOS_DRV          0                  0x0              
 * 0x0132[3:0]   OUT8_CM                11                 0xB              
 * 0x0132[6:4]   OUT8_AMPL              3                  0x3              
 * 0x0133[2:0]   OUT8_MUX_SEL           2                  0x2              
 * 0x0133[5:4]   OUT8_VDD_SEL           2                  0x2              
 * 0x0133[3]     OUT8_VDD_SEL_EN        1                  0x1              
 * 0x0133[7:6]   OUT8_INV               0                  0x0              
 * 0x013A[0]     OUT9_PDN               1                  0x1              
 * 0x013A[1]     OUT9_OE                0                  0x0              
 * 0x013A[2]     OUT9_RDIV_FORCE2       0                  0x0              
 * 0x013B[2:0]   OUT9_FORMAT            1                  0x1              
 * 0x013B[3]     OUT9_SYNC_EN           1                  0x1              
 * 0x013B[5:4]   OUT9_DIS_STATE         0                  0x0              
 * 0x013B[7:6]   OUT9_CMOS_DRV          0                  0x0              
 * 0x013C[3:0]   OUT9_CM                11                 0xB              
 * 0x013C[6:4]   OUT9_AMPL              3                  0x3              
 * 0x013D[2:0]   OUT9_MUX_SEL           0                  0x0              
 * 0x013D[5:4]   OUT9_VDD_SEL           2                  0x2              
 * 0x013D[3]     OUT9_VDD_SEL_EN        1                  0x1              
 * 0x013D[7:6]   OUT9_INV               0                  0x0              
 * 0x013F[11:0]  OUTX_ALWAYS_ON         0                  0x000            
 * 0x0141[1]     OUT_DIS_MSK            0                  0x0              
 * 0x0141[5]     OUT_DIS_LOL_MSK        0                  0x0              
 * 0x0141[6]     OUT_DIS_LOSXAXB_MSK    1                  0x1              
 * 0x0141[7]     OUT_DIS_MSK_LOS_PFD    0                  0x0              
 * 0x0142[1]     OUT_DIS_MSK_LOL        1                  0x1              
 * 0x0142[5]     OUT_DIS_MSK_HOLD       1                  0x1              
 * 0x0206[1:0]   PXAXB                  0                  0x0              
 * 0x0208[47:0]  P0_NUM                 1                  0x000000000001   
 * 0x020E[31:0]  P0_DEN                 1                  0x00000001       
 * 0x0212[47:0]  P1_NUM                 0                  0x000000000000   
 * 0x0218[31:0]  P1_DEN                 0                  0x00000000       
 * 0x021C[47:0]  P2_NUM                 0                  0x000000000000   
 * 0x0222[31:0]  P2_DEN                 0                  0x00000000       
 * 0x0226[47:0]  P3_NUM                 0                  0x000000000000   
 * 0x022C[31:0]  P3_DEN                 0                  0x00000000       
 * 0x0231[3:0]   P0_FRACN_MODE          11                 0xB              
 * 0x0231[4]     P0_FRACN_EN            0                  0x0              
 * 0x0232[3:0]   P1_FRACN_MODE          11                 0xB              
 * 0x0232[4]     P1_FRACN_EN            0                  0x0              
 * 0x0233[3:0]   P2_FRACN_MODE          11                 0xB              
 * 0x0233[4]     P2_FRACN_EN            0                  0x0              
 * 0x0234[3:0]   P3_FRACN_MODE          11                 0xB              
 * 0x0234[4]     P3_FRACN_EN            0                  0x0              
 * 0x0235[43:0]  MXAXB_NUM              916841299968       0x0D578000000    
 * 0x023B[31:0]  MXAXB_DEN              3489660928         0xD0000000       
 * 0x024A[23:0]  R0_REG                 10                 0x00000A         
 * 0x024D[23:0]  R1_REG                 0                  0x000000         
 * 0x0250[23:0]  R2_REG                 1                  0x000001         
 * 0x0253[23:0]  R3_REG                 0                  0x000000         
 * 0x0256[23:0]  R4_REG                 0                  0x000000         
 * 0x0259[23:0]  R5_REG                 2                  0x000002         
 * 0x025C[23:0]  R6_REG                 0                  0x000000         
 * 0x025F[23:0]  R7_REG                 0                  0x000000         
 * 0x0262[23:0]  R8_REG                 2                  0x000002         
 * 0x0268[23:0]  R9_REG                 0                  0x000000         
 * 0x026B[7:0]   DESIGN_ID0             73                 0x49             
 * 0x026C[7:0]   DESIGN_ID1             79                 0x4F             
 * 0x026D[7:0]   DESIGN_ID2             52                 0x34             
 * 0x026E[7:0]   DESIGN_ID3             75                 0x4B             
 * 0x026F[7:0]   DESIGN_ID4             43                 0x2B             
 * 0x0270[7:0]   DESIGN_ID5             0                  0x00             
 * 0x0271[7:0]   DESIGN_ID6             0                  0x00             
 * 0x0272[7:0]   DESIGN_ID7             0                  0x00             
 * 0x0294[7:4]   FASTLOCK_EXTEND_SCL    8                  0x8              
 * 0x0296[1]     LOL_SLW_VALWIN_SELX    0                  0x0              
 * 0x0297[1]     FASTLOCK_DLY_ONSW_EN   1                  0x1              
 * 0x0299[1]     FASTLOCK_DLY_ONLOL_EN  1                  0x1              
 * 0x029D[19:0]  FASTLOCK_DLY_ONLOL     3829               0x00EF5          
 * 0x02A9[19:0]  FASTLOCK_DLY_ONSW      9830               0x02666          
 * 0x02B7[3:2]   LOL_NOSIG_TIME         3                  0x3              
 * 0x0302[43:0]  N0_NUM                 49392123904        0x00B80000000    
 * 0x0308[31:0]  N0_DEN                 2147483648         0x80000000       
 * 0x030C[0]     N0_UPDATE              0                  0x0              
 * 0x030D[43:0]  N1_NUM                 198967296000       0x02E53600000    
 * 0x0313[31:0]  N1_DEN                 2147483648         0x80000000       
 * 0x0317[0]     N1_UPDATE              0                  0x0              
 * 0x0318[43:0]  N2_NUM                 48282730496        0x00B3DE00000    
 * 0x031E[31:0]  N2_DEN                 3145728000         0xBB800000       
 * 0x0322[0]     N2_UPDATE              0                  0x0              
 * 0x0323[43:0]  N3_NUM                 0                  0x00000000000    
 * 0x0329[31:0]  N3_DEN                 0                  0x00000000       
 * 0x032D[0]     N3_UPDATE              0                  0x0              
 * 0x032E[43:0]  N4_NUM                 0                  0x00000000000    
 * 0x0334[31:0]  N4_DEN                 0                  0x00000000       
 * 0x0338[0]     N4_UPDATE              0                  0x0              
 * 0x0338[1]     N_UPDATE               0                  0x0              
 * 0x0339[4:0]   N_FSTEP_MSK            31                 0x1F             
 * 0x033B[43:0]  N0_FSTEPW              0                  0x00000000000    
 * 0x0341[43:0]  N1_FSTEPW              0                  0x00000000000    
 * 0x0347[43:0]  N2_FSTEPW              0                  0x00000000000    
 * 0x034D[43:0]  N3_FSTEPW              0                  0x00000000000    
 * 0x0353[43:0]  N4_FSTEPW              0                  0x00000000000    
 * 0x0359[15:0]  N0_DELAY               0                  0x0000           
 * 0x035B[15:0]  N1_DELAY               0                  0x0000           
 * 0x035D[15:0]  N2_DELAY               0                  0x0000           
 * 0x035F[15:0]  N3_DELAY               0                  0x0000           
 * 0x0361[15:0]  N4_DELAY               0                  0x0000           
 * 0x0487[0]     ZDM_EN                 0                  0x0              
 * 0x0487[2:1]   ZDM_IN_SEL             0                  0x0              
 * 0x0487[4]     ZDM_AUTOSW_EN          0                  0x0              
 * 0x0502[4]     ADD_DIV256             0                  0x0              
 * 0x0508[5:0]   BW0_PLL                17                 0x11             
 * 0x0509[5:0]   BW1_PLL                26                 0x1A             
 * 0x050A[5:0]   BW2_PLL                15                 0x0F             
 * 0x050B[5:0]   BW3_PLL                15                 0x0F             
 * 0x050C[5:0]   BW4_PLL                1                  0x01             
 * 0x050D[5:0]   BW5_PLL                7                  0x07             
 * 0x050E[5:0]   FASTLOCK_BW0_PLL       23                 0x17             
 * 0x050F[5:0]   FASTLOCK_BW1_PLL       40                 0x28             
 * 0x0510[5:0]   FASTLOCK_BW2_PLL       12                 0x0C             
 * 0x0511[5:0]   FASTLOCK_BW3_PLL       11                 0x0B             
 * 0x0512[5:0]   FASTLOCK_BW4_PLL       1                  0x01             
 * 0x0513[5:0]   FASTLOCK_BW5_PLL       7                  0x07             
 * 0x0515[55:0]  M_NUM                  203946253615104    0x00B97CF0000000 
 * 0x051C[31:0]  M_DEN                  3355443200         0xC8000000       
 * 0x0521[3:0]   M_FRAC_MODE            11                 0xB              
 * 0x0521[4]     M_FRAC_EN              1                  0x1              
 * 0x0521[5]     PLL_OUT_RATE_SEL       1                  0x1              
 * 0x052A[0]     IN_SEL_REGCTRL         1                  0x1              
 * 0x052A[3:1]   IN_SEL                 0                  0x0              
 * 0x052B[0]     FASTLOCK_AUTO_EN       1                  0x1              
 * 0x052B[1]     FASTLOCK_MAN           0                  0x0              
 * 0x052C[0]     HOLD_EN                1                  0x1              
 * 0x052C[3]     HOLD_RAMP_BYP          1                  0x1              
 * 0x052C[4]     HOLDEXIT_BW_SEL1       0                  0x0              
 * 0x052C[7:5]   RAMP_STEP_INTERVAL     0                  0x0              
 * 0x052D[1]     HOLD_RAMPBYP_NOHIST    1                  0x1              
 * 0x052E[4:0]   HOLD_HIST_LEN          21                 0x15             
 * 0x052F[4:0]   HOLD_HIST_DELAY        20                 0x14             
 * 0x0531[4:0]   HOLD_REF_COUNT_FRC     0                  0x00             
 * 0x0532[23:0]  HOLD_15M_CYC_COUNT     37075              0x0090D3         
 * 0x0535[0]     FORCE_HOLD             0                  0x0              
 * 0x0536[1:0]   CLK_SWITCH_MODE        0                  0x0              
 * 0x0536[2]     HSW_EN                 0                  0x0              
 * 0x0537[3:0]   IN_LOS_MSK             0                  0x0              
 * 0x0537[7:4]   IN_OOF_MSK             0                  0x0              
 * 0x0538[2:0]   IN0_PRIORITY           0                  0x0              
 * 0x0538[6:4]   IN1_PRIORITY           0                  0x0              
 * 0x0539[2:0]   IN2_PRIORITY           0                  0x0              
 * 0x0539[6:4]   IN3_PRIORITY           0                  0x0              
 * 0x053A[1:0]   HSW_MODE               2                  0x2              
 * 0x053A[3:2]   HSW_PHMEAS_CTRL        0                  0x0              
 * 0x053B[9:0]   HSW_PHMEAS_THR         3                  0x003            
 * 0x053D[4:0]   HSW_COARSE_PM_LEN      18                 0x12             
 * 0x053E[4:0]   HSW_COARSE_PM_DLY      6                  0x06             
 * 0x0589[12:0]  CAP_SHORT_DELAY        605                0x025D           
 * 0x059B[4]     HOLD_PRESERVE_HIST     1                  0x1              
 * 0x059B[5]     HOLD_FRZ_WITH_INTONLY  1                  0x1              
 * 0x059B[6]     HOLDEXIT_BW_SEL0       1                  0x1              
 * 0x059B[7]     HOLDEXIT_STD_BO        1                  0x1              
 * 0x059D[5:0]   HOLDEXIT_BW0           23                 0x17             
 * 0x059E[5:0]   HOLDEXIT_BW1           40                 0x28             
 * 0x059F[5:0]   HOLDEXIT_BW2           12                 0x0C             
 * 0x05A0[5:0]   HOLDEXIT_BW3           11                 0x0B             
 * 0x05A1[5:0]   HOLDEXIT_BW4           1                  0x01             
 * 0x05A2[5:0]   HOLDEXIT_BW5           7                  0x07             
 * 0x05A6[2:0]   RAMP_STEP_SIZE         0                  0x0              
 * 0x05A6[3]     RAMP_SWITCH_EN         0                  0x0              
 * 0x0802[15:0]  FIXREGSA0              1333               0x0535           
 * 0x0804[7:0]   FIXREGSD0              0                  0x00             
 * 0x0805[15:0]  FIXREGSA1              0                  0x0000           
 * 0x0807[7:0]   FIXREGSD1              0                  0x00             
 * 0x0808[15:0]  FIXREGSA2              0                  0x0000           
 * 0x080A[7:0]   FIXREGSD2              0                  0x00             
 * 0x080B[15:0]  FIXREGSA3              0                  0x0000           
 * 0x080D[7:0]   FIXREGSD3              0                  0x00             
 * 0x080E[15:0]  FIXREGSA4              0                  0x0000           
 * 0x0810[7:0]   FIXREGSD4              0                  0x00             
 * 0x0811[15:0]  FIXREGSA5              0                  0x0000           
 * 0x0813[7:0]   FIXREGSD5              0                  0x00             
 * 0x0814[15:0]  FIXREGSA6              0                  0x0000           
 * 0x0816[7:0]   FIXREGSD6              0                  0x00             
 * 0x0817[15:0]  FIXREGSA7              0                  0x0000           
 * 0x0819[7:0]   FIXREGSD7              0                  0x00             
 * 0x081A[15:0]  FIXREGSA8              0                  0x0000           
 * 0x081C[7:0]   FIXREGSD8              0                  0x00             
 * 0x081D[15:0]  FIXREGSA9              0                  0x0000           
 * 0x081F[7:0]   FIXREGSD9              0                  0x00             
 * 0x0820[15:0]  FIXREGSA10             0                  0x0000           
 * 0x0822[7:0]   FIXREGSD10             0                  0x00             
 * 0x0823[15:0]  FIXREGSA11             0                  0x0000           
 * 0x0825[7:0]   FIXREGSD11             0                  0x00             
 * 0x0826[15:0]  FIXREGSA12             0                  0x0000           
 * 0x0828[7:0]   FIXREGSD12             0                  0x00             
 * 0x0829[15:0]  FIXREGSA13             0                  0x0000           
 * 0x082B[7:0]   FIXREGSD13             0                  0x00             
 * 0x082C[15:0]  FIXREGSA14             0                  0x0000           
 * 0x082E[7:0]   FIXREGSD14             0                  0x00             
 * 0x082F[15:0]  FIXREGSA15             0                  0x0000           
 * 0x0831[7:0]   FIXREGSD15             0                  0x00             
 * 0x0832[15:0]  FIXREGSA16             0                  0x0000           
 * 0x0834[7:0]   FIXREGSD16             0                  0x00             
 * 0x0835[15:0]  FIXREGSA17             0                  0x0000           
 * 0x0837[7:0]   FIXREGSD17             0                  0x00             
 * 0x0838[15:0]  FIXREGSA18             0                  0x0000           
 * 0x083A[7:0]   FIXREGSD18             0                  0x00             
 * 0x083B[15:0]  FIXREGSA19             0                  0x0000           
 * 0x083D[7:0]   FIXREGSD19             0                  0x00             
 * 0x083E[15:0]  FIXREGSA20             0                  0x0000           
 * 0x0840[7:0]   FIXREGSD20             0                  0x00             
 * 0x0841[15:0]  FIXREGSA21             0                  0x0000           
 * 0x0843[7:0]   FIXREGSD21             0                  0x00             
 * 0x0844[15:0]  FIXREGSA22             0                  0x0000           
 * 0x0846[7:0]   FIXREGSD22             0                  0x00             
 * 0x0847[15:0]  FIXREGSA23             0                  0x0000           
 * 0x0849[7:0]   FIXREGSD23             0                  0x00             
 * 0x084A[15:0]  FIXREGSA24             0                  0x0000           
 * 0x084C[7:0]   FIXREGSD24             0                  0x00             
 * 0x084D[15:0]  FIXREGSA25             0                  0x0000           
 * 0x084F[7:0]   FIXREGSD25             0                  0x00             
 * 0x0850[15:0]  FIXREGSA26             0                  0x0000           
 * 0x0852[7:0]   FIXREGSD26             0                  0x00             
 * 0x0853[15:0]  FIXREGSA27             0                  0x0000           
 * 0x0855[7:0]   FIXREGSD27             0                  0x00             
 * 0x0856[15:0]  FIXREGSA28             0                  0x0000           
 * 0x0858[7:0]   FIXREGSD28             0                  0x00             
 * 0x0859[15:0]  FIXREGSA29             0                  0x0000           
 * 0x085B[7:0]   FIXREGSD29             0                  0x00             
 * 0x085C[15:0]  FIXREGSA30             0                  0x0000           
 * 0x085E[7:0]   FIXREGSD30             0                  0x00             
 * 0x085F[15:0]  FIXREGSA31             0                  0x0000           
 * 0x0861[7:0]   FIXREGSD31             0                  0x00             
 * 0x090E[0]     XAXB_EXTCLK_EN         1                  0x1              
 * 0x0943[0]     IO_VDD_SEL             0                  0x0              
 * 0x0949[3:0]   IN_EN                  1                  0x1              
 * 0x0949[7:4]   IN_PULSED_CMOS_EN      3                  0x3              
 * 0x094A[3:0]   INX_TO_PFD_EN          1                  0x1              
 * 0x094E[11:0]  REFCLK_HYS_SEL         585                0x249            
 * 0x095E[0]     MXAXB_INTEGER          0                  0x0              
 * 0x0A02[4:0]   N_ADD_0P5              0                  0x00             
 * 0x0A03[4:0]   N_CLK_TO_OUTX_EN       7                  0x07             
 * 0x0A04[4:0]   N_PIBYP                1                  0x01             
 * 0x0A05[4:0]   N_PDNB                 7                  0x07             
 * 0x0A14[3]     N0_HIGH_FREQ           0                  0x0              
 * 0x0A1A[3]     N1_HIGH_FREQ           0                  0x0              
 * 0x0A20[3]     N2_HIGH_FREQ           0                  0x0              
 * 0x0A26[3]     N3_HIGH_FREQ           0                  0x0              
 * 0x0A2C[3]     N4_HIGH_FREQ           0                  0x0              
 * 0x0B44[3:0]   PDIV_FRACN_CLK_DIS     15                 0xF              
 * 0x0B44[5]     FRACN_CLK_DIS_PLL      0                  0x0              
 * 0x0B46[3:0]   LOS_CLK_DIS            0                  0x0              
 * 0x0B47[4:0]   OOF_CLK_DIS            14                 0x0E             
 * 0x0B48[4:0]   OOF_DIV_CLK_DIS        14                 0x0E             
 * 0x0B4A[4:0]   N_CLK_DIS              24                 0x18             
 * 0x0B57[11:0]  VCO_RESET_CALCODE      249                0x0F9
 * 
 *
 */


static struct ntv2_genlock_data s_genlock_750_6000[] =
{
	/* Start configuration preamble */
	{ 0x0B24, 0xC0 },
	{ 0x0B25, 0x00 },
	{ 0x0540, 0x01 },
	/* End configuration preamble */

	/* Delay 300 msec */
	/*    Delay is worst case time for device to complete any calibration */
	/*    that is running due to device state change previous to this script */
	/*    being processed. */
	{ 0x0000, 0x01 },

	/* Start configuration registers */
	{ 0x000B, 0x64 },
	{ 0x0016, 0x02 },
	{ 0x0017, 0xFC },
	{ 0x0018, 0xFF },
	{ 0x0019, 0xDF },
	{ 0x001A, 0xDF },
	{ 0x002B, 0x02 },
	{ 0x002C, 0x01 },
	{ 0x002D, 0x02 },
	{ 0x002E, 0xB2 },
	{ 0x002F, 0x05 },
	{ 0x0030, 0x00 },
	{ 0x0031, 0x00 },
	{ 0x0032, 0x00 },
	{ 0x0033, 0x00 },
	{ 0x0034, 0x00 },
	{ 0x0035, 0x00 },
	{ 0x0036, 0x38 },
	{ 0x0037, 0x05 },
	{ 0x0038, 0x00 },
	{ 0x0039, 0x00 },
	{ 0x003A, 0x00 },
	{ 0x003B, 0x00 },
	{ 0x003C, 0x00 },
	{ 0x003D, 0x00 },
	{ 0x003F, 0x01 },
	{ 0x0040, 0x04 },
	{ 0x0041, 0x02 },
	{ 0x0042, 0x00 },
	{ 0x0043, 0x00 },
	{ 0x0044, 0x00 },
	{ 0x0045, 0x0C },
	{ 0x0046, 0x96 },
	{ 0x0047, 0x00 },
	{ 0x0048, 0x00 },
	{ 0x0049, 0x00 },
	{ 0x004A, 0x4B },
	{ 0x004B, 0x00 },
	{ 0x004C, 0x00 },
	{ 0x004D, 0x00 },
	{ 0x004E, 0x05 },
	{ 0x004F, 0x00 },
	{ 0x0050, 0x0F },
	{ 0x0051, 0x00 },
	{ 0x0052, 0x00 },
	{ 0x0053, 0x00 },
	{ 0x0054, 0x00 },
	{ 0x0055, 0x00 },
	{ 0x0056, 0x00 },
	{ 0x0057, 0x00 },
	{ 0x0058, 0x00 },
	{ 0x0059, 0x01 },
	{ 0x005A, 0xFA },
	{ 0x005B, 0xDA },
	{ 0x005C, 0xE2 },
	{ 0x005D, 0x00 },
	{ 0x005E, 0x00 },
	{ 0x005F, 0x00 },
	{ 0x0060, 0x00 },
	{ 0x0061, 0x00 },
	{ 0x0062, 0x00 },
	{ 0x0063, 0x00 },
	{ 0x0064, 0x00 },
	{ 0x0065, 0x00 },
	{ 0x0066, 0x00 },
	{ 0x0067, 0x00 },
	{ 0x0068, 0x00 },
	{ 0x0069, 0x00 },
	{ 0x0092, 0x02 },
	{ 0x0093, 0xA0 },
	{ 0x0095, 0x00 },
	{ 0x0096, 0x90 },
	{ 0x0098, 0x70 },
	{ 0x009A, 0x02 },
	{ 0x009B, 0x50 },
	{ 0x009D, 0x04 },
	{ 0x009E, 0x60 },
	{ 0x00A0, 0x30 },
	{ 0x00A2, 0x00 },
	{ 0x00A9, 0x96 },
	{ 0x00AA, 0x49 },
	{ 0x00AB, 0x04 },
	{ 0x00AC, 0x00 },
	{ 0x00E5, 0x21 },
	{ 0x00EA, 0xD1 },
	{ 0x00EB, 0xB1 },
	{ 0x00EC, 0x03 },
	{ 0x00ED, 0x00 },
	{ 0x0102, 0x01 },
	{ 0x0108, 0x02 },
	{ 0x0109, 0x09 },
	{ 0x010A, 0x3B },
	{ 0x010B, 0x28 },
	{ 0x010D, 0x01 },
	{ 0x010E, 0x09 },
	{ 0x010F, 0x3B },
	{ 0x0110, 0x28 },
	{ 0x0112, 0x02 },
	{ 0x0113, 0x09 },
	{ 0x0114, 0x3B },
	{ 0x0115, 0x28 },
	{ 0x0117, 0x01 },
	{ 0x0118, 0x09 },
	{ 0x0119, 0x3B },
	{ 0x011A, 0x28 },
	{ 0x011C, 0x01 },
	{ 0x011D, 0x09 },
	{ 0x011E, 0x3B },
	{ 0x011F, 0x28 },
	{ 0x0121, 0x02 },
	{ 0x0122, 0x09 },
	{ 0x0123, 0x3B },
	{ 0x0124, 0x29 },
	{ 0x0126, 0x01 },
	{ 0x0127, 0x09 },
	{ 0x0128, 0x3B },
	{ 0x0129, 0x28 },
	{ 0x012B, 0x01 },
	{ 0x012C, 0x09 },
	{ 0x012D, 0x3B },
	{ 0x012E, 0x28 },
	{ 0x0130, 0x02 },
	{ 0x0131, 0x09 },
	{ 0x0132, 0x3B },
	{ 0x0133, 0x2A },
	{ 0x013A, 0x01 },
	{ 0x013B, 0x09 },
	{ 0x013C, 0x3B },
	{ 0x013D, 0x28 },
	{ 0x013F, 0x00 },
	{ 0x0140, 0x00 },
	{ 0x0141, 0x40 },
	{ 0x0142, 0xFF },
	{ 0x0206, 0x00 },
	{ 0x0208, 0x01 },
	{ 0x0209, 0x00 },
	{ 0x020A, 0x00 },
	{ 0x020B, 0x00 },
	{ 0x020C, 0x00 },
	{ 0x020D, 0x00 },
	{ 0x020E, 0x01 },
	{ 0x020F, 0x00 },
	{ 0x0210, 0x00 },
	{ 0x0211, 0x00 },
	{ 0x0212, 0x00 },
	{ 0x0213, 0x00 },
	{ 0x0214, 0x00 },
	{ 0x0215, 0x00 },
	{ 0x0216, 0x00 },
	{ 0x0217, 0x00 },
	{ 0x0218, 0x00 },
	{ 0x0219, 0x00 },
	{ 0x021A, 0x00 },
	{ 0x021B, 0x00 },
	{ 0x021C, 0x00 },
	{ 0x021D, 0x00 },
	{ 0x021E, 0x00 },
	{ 0x021F, 0x00 },
	{ 0x0220, 0x00 },
	{ 0x0221, 0x00 },
	{ 0x0222, 0x00 },
	{ 0x0223, 0x00 },
	{ 0x0224, 0x00 },
	{ 0x0225, 0x00 },
	{ 0x0226, 0x00 },
	{ 0x0227, 0x00 },
	{ 0x0228, 0x00 },
	{ 0x0229, 0x00 },
	{ 0x022A, 0x00 },
	{ 0x022B, 0x00 },
	{ 0x022C, 0x00 },
	{ 0x022D, 0x00 },
	{ 0x022E, 0x00 },
	{ 0x022F, 0x00 },
	{ 0x0231, 0x0B },
	{ 0x0232, 0x0B },
	{ 0x0233, 0x0B },
	{ 0x0234, 0x0B },
	{ 0x0235, 0x00 },
	{ 0x0236, 0x00 },
	{ 0x0237, 0x00 },
	{ 0x0238, 0x78 },
	{ 0x0239, 0xD5 },
	{ 0x023A, 0x00 },
	{ 0x023B, 0x00 },
	{ 0x023C, 0x00 },
	{ 0x023D, 0x00 },
	{ 0x023E, 0xD0 },
	{ 0x024A, 0x0A },
	{ 0x024B, 0x00 },
	{ 0x024C, 0x00 },
	{ 0x024D, 0x00 },
	{ 0x024E, 0x00 },
	{ 0x024F, 0x00 },
	{ 0x0250, 0x01 },
	{ 0x0251, 0x00 },
	{ 0x0252, 0x00 },
	{ 0x0253, 0x00 },
	{ 0x0254, 0x00 },
	{ 0x0255, 0x00 },
	{ 0x0256, 0x00 },
	{ 0x0257, 0x00 },
	{ 0x0258, 0x00 },
	{ 0x0259, 0x02 },
	{ 0x025A, 0x00 },
	{ 0x025B, 0x00 },
	{ 0x025C, 0x00 },
	{ 0x025D, 0x00 },
	{ 0x025E, 0x00 },
	{ 0x025F, 0x00 },
	{ 0x0260, 0x00 },
	{ 0x0261, 0x00 },
	{ 0x0262, 0x02 },
	{ 0x0263, 0x00 },
	{ 0x0264, 0x00 },
	{ 0x0268, 0x00 },
	{ 0x0269, 0x00 },
	{ 0x026A, 0x00 },
	{ 0x026B, 0x49 },
	{ 0x026C, 0x4F },
	{ 0x026D, 0x34 },
	{ 0x026E, 0x4B },
	{ 0x026F, 0x2B },
	{ 0x0270, 0x00 },
	{ 0x0271, 0x00 },
	{ 0x0272, 0x00 },
	{ 0x0294, 0x80 },
	{ 0x0296, 0x00 },
	{ 0x0297, 0x02 },
	{ 0x0299, 0x02 },
	{ 0x029D, 0xF5 },
	{ 0x029E, 0x0E },
	{ 0x029F, 0x00 },
	{ 0x02A9, 0x66 },
	{ 0x02AA, 0x26 },
	{ 0x02AB, 0x00 },
	{ 0x02B7, 0xFF },
	{ 0x0302, 0x00 },
	{ 0x0303, 0x00 },
	{ 0x0304, 0x00 },
	{ 0x0305, 0x80 },
	{ 0x0306, 0x0B },
	{ 0x0307, 0x00 },
	{ 0x0308, 0x00 },
	{ 0x0309, 0x00 },
	{ 0x030A, 0x00 },
	{ 0x030B, 0x80 },
	{ 0x030C, 0x00 },
	{ 0x030D, 0x00 },
	{ 0x030E, 0x00 },
	{ 0x030F, 0x60 },
	{ 0x0310, 0x53 },
	{ 0x0311, 0x2E },
	{ 0x0312, 0x00 },
	{ 0x0313, 0x00 },
	{ 0x0314, 0x00 },
	{ 0x0315, 0x00 },
	{ 0x0316, 0x80 },
	{ 0x0317, 0x00 },
	{ 0x0318, 0x00 },
	{ 0x0319, 0x00 },
	{ 0x031A, 0xE0 },
	{ 0x031B, 0x3D },
	{ 0x031C, 0x0B },
	{ 0x031D, 0x00 },
	{ 0x031E, 0x00 },
	{ 0x031F, 0x00 },
	{ 0x0320, 0x80 },
	{ 0x0321, 0xBB },
	{ 0x0322, 0x00 },
	{ 0x0323, 0x00 },
	{ 0x0324, 0x00 },
	{ 0x0325, 0x00 },
	{ 0x0326, 0x00 },
	{ 0x0327, 0x00 },
	{ 0x0328, 0x00 },
	{ 0x0329, 0x00 },
	{ 0x032A, 0x00 },
	{ 0x032B, 0x00 },
	{ 0x032C, 0x00 },
	{ 0x032D, 0x00 },
	{ 0x032E, 0x00 },
	{ 0x032F, 0x00 },
	{ 0x0330, 0x00 },
	{ 0x0331, 0x00 },
	{ 0x0332, 0x00 },
	{ 0x0333, 0x00 },
	{ 0x0334, 0x00 },
	{ 0x0335, 0x00 },
	{ 0x0336, 0x00 },
	{ 0x0337, 0x00 },
	{ 0x0338, 0x00 },
	{ 0x0339, 0x1F },
	{ 0x033B, 0x00 },
	{ 0x033C, 0x00 },
	{ 0x033D, 0x00 },
	{ 0x033E, 0x00 },
	{ 0x033F, 0x00 },
	{ 0x0340, 0x00 },
	{ 0x0341, 0x00 },
	{ 0x0342, 0x00 },
	{ 0x0343, 0x00 },
	{ 0x0344, 0x00 },
	{ 0x0345, 0x00 },
	{ 0x0346, 0x00 },
	{ 0x0347, 0x00 },
	{ 0x0348, 0x00 },
	{ 0x0349, 0x00 },
	{ 0x034A, 0x00 },
	{ 0x034B, 0x00 },
	{ 0x034C, 0x00 },
	{ 0x034D, 0x00 },
	{ 0x034E, 0x00 },
	{ 0x034F, 0x00 },
	{ 0x0350, 0x00 },
	{ 0x0351, 0x00 },
	{ 0x0352, 0x00 },
	{ 0x0353, 0x00 },
	{ 0x0354, 0x00 },
	{ 0x0355, 0x00 },
	{ 0x0356, 0x00 },
	{ 0x0357, 0x00 },
	{ 0x0358, 0x00 },
	{ 0x0359, 0x00 },
	{ 0x035A, 0x00 },
	{ 0x035B, 0x00 },
	{ 0x035C, 0x00 },
	{ 0x035D, 0x00 },
	{ 0x035E, 0x00 },
	{ 0x035F, 0x00 },
	{ 0x0360, 0x00 },
	{ 0x0361, 0x00 },
	{ 0x0362, 0x00 },
	{ 0x0487, 0x00 },
	{ 0x0502, 0x01 },
	{ 0x0508, 0x11 },
	{ 0x0509, 0x1A },
	{ 0x050A, 0x0F },
	{ 0x050B, 0x0F },
	{ 0x050C, 0x01 },
	{ 0x050D, 0x07 },
	{ 0x050E, 0x17 },
	{ 0x050F, 0x28 },
	{ 0x0510, 0x0C },
	{ 0x0511, 0x0B },
	{ 0x0512, 0x01 },
	{ 0x0513, 0x07 },
	{ 0x0515, 0x00 },
	{ 0x0516, 0x00 },
	{ 0x0517, 0x00 },
	{ 0x0518, 0x00 },
	{ 0x0519, 0x98 },
	{ 0x051A, 0x76 },
	{ 0x051B, 0x00 },
	{ 0x051C, 0x00 },
	{ 0x051D, 0x00 },
	{ 0x051E, 0x00 },
	{ 0x051F, 0x80 },
	{ 0x0521, 0x2B },
	{ 0x052A, 0x01 },
	{ 0x052B, 0x01 },
	{ 0x052C, 0x0F },
	{ 0x052D, 0x03 },
	{ 0x052E, 0x15 },
	{ 0x052F, 0x14 },
	{ 0x0531, 0x00 },
	{ 0x0532, 0xAE },
	{ 0x0533, 0x90 },
	{ 0x0534, 0x00 },
	{ 0x0535, 0x00 },
	{ 0x0536, 0x00 },
	{ 0x0537, 0x00 },
	{ 0x0538, 0x00 },
	{ 0x0539, 0x00 },
	{ 0x053A, 0x02 },
	{ 0x053B, 0x03 },
	{ 0x053C, 0x00 },
	{ 0x053D, 0x12 },
	{ 0x053E, 0x06 },
	{ 0x0589, 0x5C },
	{ 0x058A, 0x02 },
	{ 0x059B, 0xF8 },
	{ 0x059D, 0x17 },
	{ 0x059E, 0x28 },
	{ 0x059F, 0x0C },
	{ 0x05A0, 0x0B },
	{ 0x05A1, 0x01 },
	{ 0x05A2, 0x07 },
	{ 0x05A6, 0x00 },
	{ 0x0802, 0x35 },
	{ 0x0803, 0x05 },
	{ 0x0804, 0x00 },
	{ 0x0805, 0x00 },
	{ 0x0806, 0x00 },
	{ 0x0807, 0x00 },
	{ 0x0808, 0x00 },
	{ 0x0809, 0x00 },
	{ 0x080A, 0x00 },
	{ 0x080B, 0x00 },
	{ 0x080C, 0x00 },
	{ 0x080D, 0x00 },
	{ 0x080E, 0x00 },
	{ 0x080F, 0x00 },
	{ 0x0810, 0x00 },
	{ 0x0811, 0x00 },
	{ 0x0812, 0x00 },
	{ 0x0813, 0x00 },
	{ 0x0814, 0x00 },
	{ 0x0815, 0x00 },
	{ 0x0816, 0x00 },
	{ 0x0817, 0x00 },
	{ 0x0818, 0x00 },
	{ 0x0819, 0x00 },
	{ 0x081A, 0x00 },
	{ 0x081B, 0x00 },
	{ 0x081C, 0x00 },
	{ 0x081D, 0x00 },
	{ 0x081E, 0x00 },
	{ 0x081F, 0x00 },
	{ 0x0820, 0x00 },
	{ 0x0821, 0x00 },
	{ 0x0822, 0x00 },
	{ 0x0823, 0x00 },
	{ 0x0824, 0x00 },
	{ 0x0825, 0x00 },
	{ 0x0826, 0x00 },
	{ 0x0827, 0x00 },
	{ 0x0828, 0x00 },
	{ 0x0829, 0x00 },
	{ 0x082A, 0x00 },
	{ 0x082B, 0x00 },
	{ 0x082C, 0x00 },
	{ 0x082D, 0x00 },
	{ 0x082E, 0x00 },
	{ 0x082F, 0x00 },
	{ 0x0830, 0x00 },
	{ 0x0831, 0x00 },
	{ 0x0832, 0x00 },
	{ 0x0833, 0x00 },
	{ 0x0834, 0x00 },
	{ 0x0835, 0x00 },
	{ 0x0836, 0x00 },
	{ 0x0837, 0x00 },
	{ 0x0838, 0x00 },
	{ 0x0839, 0x00 },
	{ 0x083A, 0x00 },
	{ 0x083B, 0x00 },
	{ 0x083C, 0x00 },
	{ 0x083D, 0x00 },
	{ 0x083E, 0x00 },
	{ 0x083F, 0x00 },
	{ 0x0840, 0x00 },
	{ 0x0841, 0x00 },
	{ 0x0842, 0x00 },
	{ 0x0843, 0x00 },
	{ 0x0844, 0x00 },
	{ 0x0845, 0x00 },
	{ 0x0846, 0x00 },
	{ 0x0847, 0x00 },
	{ 0x0848, 0x00 },
	{ 0x0849, 0x00 },
	{ 0x084A, 0x00 },
	{ 0x084B, 0x00 },
	{ 0x084C, 0x00 },
	{ 0x084D, 0x00 },
	{ 0x084E, 0x00 },
	{ 0x084F, 0x00 },
	{ 0x0850, 0x00 },
	{ 0x0851, 0x00 },
	{ 0x0852, 0x00 },
	{ 0x0853, 0x00 },
	{ 0x0854, 0x00 },
	{ 0x0855, 0x00 },
	{ 0x0856, 0x00 },
	{ 0x0857, 0x00 },
	{ 0x0858, 0x00 },
	{ 0x0859, 0x00 },
	{ 0x085A, 0x00 },
	{ 0x085B, 0x00 },
	{ 0x085C, 0x00 },
	{ 0x085D, 0x00 },
	{ 0x085E, 0x00 },
	{ 0x085F, 0x00 },
	{ 0x0860, 0x00 },
	{ 0x0861, 0x00 },
	{ 0x090E, 0x03 },
	{ 0x0943, 0x00 },
	{ 0x0949, 0x31 },
	{ 0x094A, 0x01 },
	{ 0x094E, 0x49 },
	{ 0x094F, 0x02 },
	{ 0x095E, 0x00 },
	{ 0x0A02, 0x00 },
	{ 0x0A03, 0x07 },
	{ 0x0A04, 0x01 },
	{ 0x0A05, 0x07 },
	{ 0x0A14, 0x00 },
	{ 0x0A1A, 0x00 },
	{ 0x0A20, 0x00 },
	{ 0x0A26, 0x00 },
	{ 0x0A2C, 0x00 },
	{ 0x0B44, 0x2F },
	{ 0x0B46, 0x00 },
	{ 0x0B47, 0x0E },
	{ 0x0B48, 0x0E },
	{ 0x0B4A, 0x18 },
	{ 0x0B57, 0xF9 },
	{ 0x0B58, 0x00 },
	/* End configuration registers */

	/* Start configuration postamble */
	{ 0x0514, 0x01 },
	{ 0x001C, 0x01 },
	{ 0x0540, 0x00 },
	{ 0x0B24, 0xC3 },
	{ 0x0B25, 0x02 },
	/* End configuration postamble */

	{ 0x0000, 0x00 }
};

/*
 * Design Report
 *
 * Overview
 * ========
 * Part:         Si5345 Rev D
 * Project File: C:\XilinxProjects\flint_tr051017\genlock\FormatFiles\IO4K+_750_6000.slabtimeproj
 * Design ID:    IO4K+
 * Created By:   ClockBuilder Pro v2.16.1 [2017-07-19]
 * Timestamp:    2017-08-24 16:25:01 GMT-07:00
 * 
 * Design Notes
 * ============
 * assumes NTSC HSYNC (pulsed) input = (30/1.001)*525
 * 
 * Design Rule Check
 * =================
 * Errors:
 * - No errors
 * 
 * Warnings:
 * - Pulsed LVCMOS input buffer mode has been selected. This mode has non-standard input voltage logic thresholds: 0.33 V for Vil (max) and 0.49 V for Vih (min). Select this mode only if your input clock has a duty cycle significantly less or more than 50%.  Refer to the device datasheet for the exact threshold voltage specifications and the input attenuator circuit (DC coupled Pulsed LVCMOS) in the Family Reference Manual.
 * 
 * Device Grade
 * ============
 * Maximum Output Frequency: 148.5 MHz
 * Frequency Synthesis Mode: Fractional
 * Minimum Base OPN:         Si5345B
 * Actual Base OPN:          Si5345B
 * 
 * Base       Output Clock         Supported Frequency Synthesis Modes
 * OPN Grade  Frequency Range      (Typical Jitter)
 * ---------  -------------------  --------------------------------------------
 * Si5345A    100 Hz to 1.028 GHz  Integer (< 100 fs) and fractional (< 150 fs)
 * Si5345B    100 Hz to 350 MHz    "
 * Si5345C    100 Hz to 1.028 GHz  Integer only (< 100 fs)
 * Si5345D    100 Hz to 350 MHz    "
 * 
 * Design
 * ======
 * Host Interface:
 *    I/O Power Supply: VDD (Core)
 *    SPI Mode: 4-Wire
 *    I2C Address Range: 100d to 103d / 0x64 to 0x67 (selected via A0/A1 pins)
 * 
 * XA/XB:
 *    52 MHz (XO - External Oscillator)
 * 
 * Inputs:
 *     IN0: 45 kHz
 *          [ (60)*750 ]
 *          Pulsed LVCMOS
 *     IN1: Unused
 *     IN2: Unused
 *     IN3: Unused
 * 
 * Outputs:
 *    OUT0: 27 MHz
 *          Enabled, LVDS 2.5 V
 *    OUT1: Unused
 *    OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT3: Unused
 *    OUT4: Unused
 *    OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT6: Unused
 *    OUT7: Unused
 *    OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *          [ 148.5/1.001 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT9: Unused
 * 
 * Frequency Plan
 * ==============
 * Priority: maximize the number of low jitter outputs
 * 
 * Fvco = 13.662 GHz [ 13 + 331/500 GHz ]
 * Fpfd = 45 kHz
 * Fms0 = 594 MHz
 * Fms1 = 147.456 MHz [ 147 + 57/125 MHz ]
 * Fms2 = 890.1098901098901098... MHz [ 890 + 10/91 MHz ]
 * 
 * P dividers:
 *    P0  = 1
 *    P1  = Unused
 *    P2  = Unused
 *    P3  = Unused
 *    Pxaxb = 1
 * 
 * MXAXB = 262.7307692307692307... [ 262 + 19/26 ]
 * M = 60720
 * N dividers:
 *    N0:
 *       Value: 23
 *       Skew:  0.000 s
 *       OUT0: 27 MHz
 *       OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *    N1:
 *       Value: 92.6513671875 [ 92 + 667/1024 ]
 *       Skew:  0.000 s
 *       OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *    N2:
 *       Value: 15.3486666666666666... [ 15 + 523/1500 ]
 *       Skew:  0.000 s
 *       OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *    N3:
 *       Unused
 *    N4:
 *       Unused
 * 
 * R dividers:
 *    R0 = 22
 *    R1 = Unused
 *    R2 = 4
 *    R3 = Unused
 *    R4 = Unused
 *    R5 = 6
 *    R6 = Unused
 *    R7 = Unused
 *    R8 = 6
 *    R9 = Unused
 * 
 * Nominal Bandwidth:
 *   Desired: 1.000 Hz
 *   Actual:  874.892 mHz
 *   Coefficients:
 *      BW0:  17
 *      BW1:  26
 *      BW2:  15
 *      BW3:  15
 *      BW4:  1
 *      BW5:  7
 * Fastlock Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  64.856 Hz
 *   Coefficients:
 *      BW0:  23
 *      BW1:  40
 *      BW2:  12
 *      BW3:  11
 *      BW4:  1
 *      BW5:  7
 * Holdover Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  64.856 Hz
 *   Coefficients:
 *      BW0:  23
 *      BW1:  40
 *      BW2:  12
 *      BW3:  11
 *      BW4:  1
 *      BW5:  7
 * 
 * Dividers listed above show effective values. These values are translated to register settings by ClockBuilder Pro. For the actual register values, see below. Refer to the Family Reference Manual for information on registers related to frequency plan.
 * 
 * Digitally Controlled Oscillator (DCO)
 * =====================================
 * Mode: Register Direct Write
 * 
 * N0: DCO Disabled
 * 
 * N1: DCO Disabled
 * 
 * N2: DCO Disabled
 * 
 * N3: DCO Disabled
 * 
 * N4: DCO Disabled
 * 
 * Estimated Power & Junction Temperature
 * ======================================
 * Assumptions:
 * 
 * Revision: D
 * VDD:      1.8 V
 * Ta:       70 C
 * Airflow:  None
 * 
 * Total Power: 808 mW, On Chip Power: 784 mW, Tj: 87 C
 * 
 *                 Frequency  Format   Voltage   Current     Power
 *         -----------------  ------  --------  --------  --------
 * VDD                                   1.8 V  147.9 mA    266 mW
 * VDDA                                  3.3 V  117.4 mA    387 mW
 * VDDO0              27 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO1              Unused                                      
 * VDDO2           148.5 MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO3              Unused                                      
 * VDDO4              Unused                                      
 * VDDO5          24.576 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO6              Unused                                      
 * VDDO7              Unused                                      
 * VDDO8   148.351648... MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO9              Unused                                      
 *                                              --------  --------
 *                                       Total  327.2 mA    808 mW
 * 
 * Note:
 * 
 * -Total power includes on- and off-chip power. This is a typical value and estimate only.
 * -Use an EVB for a more exact power measurement
 * -On-chip power excludes power dissipated in external terminations.
 * -Tj is junction temperature. Tj must be less than 125 C (on Si5345 Revision D) for device to comply with datasheet specifications.
 * 
 * Settings
 * ========
 * 
 * Location      Setting Name           Decimal Value      Hex Value        
 * ------------  ---------------------  -----------------  -----------------
 * 0x000B[6:0]   I2C_ADDR               100                0x64             
 * 0x0016[1]     LOL_ON_HOLD            1                  0x1              
 * 0x0017[0]     SYSINCAL_INTR_MSK      0                  0x0              
 * 0x0017[1]     LOSXAXB_INTR_MSK       0                  0x0              
 * 0x0017[5]     SMB_TMOUT_INTR_MSK     1                  0x1              
 * 0x0018[3:0]   LOS_INTR_MSK           15                 0xF              
 * 0x0018[7:4]   OOF_INTR_MSK           15                 0xF              
 * 0x0019[1]     LOL_INTR_MSK           1                  0x1              
 * 0x0019[5]     HOLD_INTR_MSK          0                  0x0              
 * 0x001A[5]     CAL_INTR_MSK           0                  0x0              
 * 0x002B[3]     SPI_3WIRE              0                  0x0              
 * 0x002B[5]     AUTO_NDIV_UPDATE       0                  0x0              
 * 0x002C[3:0]   LOS_EN                 1                  0x1              
 * 0x002C[4]     LOSXAXB_DIS            0                  0x0              
 * 0x002D[1:0]   LOS0_VAL_TIME          2                  0x2              
 * 0x002D[3:2]   LOS1_VAL_TIME          0                  0x0              
 * 0x002D[5:4]   LOS2_VAL_TIME          0                  0x0              
 * 0x002D[7:6]   LOS3_VAL_TIME          0                  0x0              
 * 0x002E[15:0]  LOS0_TRG_THR           1458               0x05B2           
 * 0x0030[15:0]  LOS1_TRG_THR           0                  0x0000           
 * 0x0032[15:0]  LOS2_TRG_THR           0                  0x0000           
 * 0x0034[15:0]  LOS3_TRG_THR           0                  0x0000           
 * 0x0036[15:0]  LOS0_CLR_THR           1336               0x0538           
 * 0x0038[15:0]  LOS1_CLR_THR           0                  0x0000           
 * 0x003A[15:0]  LOS2_CLR_THR           0                  0x0000           
 * 0x003C[15:0]  LOS3_CLR_THR           0                  0x0000           
 * 0x003F[3:0]   OOF_EN                 1                  0x1              
 * 0x003F[7:4]   FAST_OOF_EN            0                  0x0              
 * 0x0040[2:0]   OOF_REF_SEL            4                  0x4              
 * 0x0041[4:0]   OOF0_DIV_SEL           2                  0x02             
 * 0x0042[4:0]   OOF1_DIV_SEL           0                  0x00             
 * 0x0043[4:0]   OOF2_DIV_SEL           0                  0x00             
 * 0x0044[4:0]   OOF3_DIV_SEL           0                  0x00             
 * 0x0045[4:0]   OOFXO_DIV_SEL          12                 0x0C             
 * 0x0046[7:0]   OOF0_SET_THR           150                0x96             
 * 0x0047[7:0]   OOF1_SET_THR           0                  0x00             
 * 0x0048[7:0]   OOF2_SET_THR           0                  0x00             
 * 0x0049[7:0]   OOF3_SET_THR           0                  0x00             
 * 0x004A[7:0]   OOF0_CLR_THR           75                 0x4B             
 * 0x004B[7:0]   OOF1_CLR_THR           0                  0x00             
 * 0x004C[7:0]   OOF2_CLR_THR           0                  0x00             
 * 0x004D[7:0]   OOF3_CLR_THR           0                  0x00             
 * 0x004E[2:0]   OOF0_DETWIN_SEL        5                  0x5              
 * 0x004E[6:4]   OOF1_DETWIN_SEL        0                  0x0              
 * 0x004F[2:0]   OOF2_DETWIN_SEL        0                  0x0              
 * 0x004F[6:4]   OOF3_DETWIN_SEL        0                  0x0              
 * 0x0050[3:0]   OOF_ON_LOS             15                 0xF              
 * 0x0051[3:0]   FAST_OOF0_SET_THR      0                  0x0              
 * 0x0052[3:0]   FAST_OOF1_SET_THR      0                  0x0              
 * 0x0053[3:0]   FAST_OOF2_SET_THR      0                  0x0              
 * 0x0054[3:0]   FAST_OOF3_SET_THR      0                  0x0              
 * 0x0055[3:0]   FAST_OOF0_CLR_THR      0                  0x0              
 * 0x0056[3:0]   FAST_OOF1_CLR_THR      0                  0x0              
 * 0x0057[3:0]   FAST_OOF2_CLR_THR      0                  0x0              
 * 0x0058[3:0]   FAST_OOF3_CLR_THR      0                  0x0              
 * 0x0059[1:0]   FAST_OOF0_DETWIN_SEL   1                  0x1              
 * 0x0059[3:2]   FAST_OOF1_DETWIN_SEL   0                  0x0              
 * 0x0059[5:4]   FAST_OOF2_DETWIN_SEL   0                  0x0              
 * 0x0059[7:6]   FAST_OOF3_DETWIN_SEL   0                  0x0              
 * 0x005A[25:0]  OOF0_RATIO_REF         14867194           0x0E2DAFA        
 * 0x005E[25:0]  OOF1_RATIO_REF         0                  0x0000000        
 * 0x0062[25:0]  OOF2_RATIO_REF         0                  0x0000000        
 * 0x0066[25:0]  OOF3_RATIO_REF         0                  0x0000000        
 * 0x0092[1]     LOL_FST_EN             1                  0x1              
 * 0x0093[7:4]   LOL_FST_DETWIN_SEL     10                 0xA              
 * 0x0095[3:2]   LOL_FST_VALWIN_SEL     0                  0x0              
 * 0x0096[7:4]   LOL_FST_SET_THR_SEL    9                  0x9              
 * 0x0098[7:4]   LOL_FST_CLR_THR_SEL    7                  0x7              
 * 0x009A[1]     LOL_SLOW_EN_PLL        1                  0x1              
 * 0x009B[7:4]   LOL_SLW_DETWIN_SEL     5                  0x5              
 * 0x009D[3:2]   LOL_SLW_VALWIN_SEL     1                  0x1              
 * 0x009E[7:4]   LOL_SLW_SET_THR        6                  0x6              
 * 0x00A0[7:4]   LOL_SLW_CLR_THR        3                  0x3              
 * 0x00A2[1]     LOL_TIMER_EN           0                  0x0              
 * 0x00A9[28:0]  LOL_CLR_DELAY_DIV256   280982             0x00044996       
 * 0x00E5[5]     FASTLOCK_EXTEND_EN     1                  0x1              
 * 0x00EA[28:0]  FASTLOCK_EXTEND        242129             0x0003B1D1       
 * 0x0102[0]     OUTALL_DISABLE_LOW     1                  0x1              
 * 0x0108[0]     OUT0_PDN               0                  0x0              
 * 0x0108[1]     OUT0_OE                1                  0x1              
 * 0x0108[2]     OUT0_RDIV_FORCE2       0                  0x0              
 * 0x0109[2:0]   OUT0_FORMAT            1                  0x1              
 * 0x0109[3]     OUT0_SYNC_EN           1                  0x1              
 * 0x0109[5:4]   OUT0_DIS_STATE         0                  0x0              
 * 0x0109[7:6]   OUT0_CMOS_DRV          0                  0x0              
 * 0x010A[3:0]   OUT0_CM                11                 0xB              
 * 0x010A[6:4]   OUT0_AMPL              3                  0x3              
 * 0x010B[2:0]   OUT0_MUX_SEL           0                  0x0              
 * 0x010B[5:4]   OUT0_VDD_SEL           2                  0x2              
 * 0x010B[3]     OUT0_VDD_SEL_EN        1                  0x1              
 * 0x010B[7:6]   OUT0_INV               0                  0x0              
 * 0x010D[0]     OUT1_PDN               1                  0x1              
 * 0x010D[1]     OUT1_OE                0                  0x0              
 * 0x010D[2]     OUT1_RDIV_FORCE2       0                  0x0              
 * 0x010E[2:0]   OUT1_FORMAT            1                  0x1              
 * 0x010E[3]     OUT1_SYNC_EN           1                  0x1              
 * 0x010E[5:4]   OUT1_DIS_STATE         0                  0x0              
 * 0x010E[7:6]   OUT1_CMOS_DRV          0                  0x0              
 * 0x010F[3:0]   OUT1_CM                11                 0xB              
 * 0x010F[6:4]   OUT1_AMPL              3                  0x3              
 * 0x0110[2:0]   OUT1_MUX_SEL           0                  0x0              
 * 0x0110[5:4]   OUT1_VDD_SEL           2                  0x2              
 * 0x0110[3]     OUT1_VDD_SEL_EN        1                  0x1              
 * 0x0110[7:6]   OUT1_INV               0                  0x0              
 * 0x0112[0]     OUT2_PDN               0                  0x0              
 * 0x0112[1]     OUT2_OE                1                  0x1              
 * 0x0112[2]     OUT2_RDIV_FORCE2       0                  0x0              
 * 0x0113[2:0]   OUT2_FORMAT            1                  0x1              
 * 0x0113[3]     OUT2_SYNC_EN           1                  0x1              
 * 0x0113[5:4]   OUT2_DIS_STATE         0                  0x0              
 * 0x0113[7:6]   OUT2_CMOS_DRV          0                  0x0              
 * 0x0114[3:0]   OUT2_CM                11                 0xB              
 * 0x0114[6:4]   OUT2_AMPL              3                  0x3              
 * 0x0115[2:0]   OUT2_MUX_SEL           0                  0x0              
 * 0x0115[5:4]   OUT2_VDD_SEL           2                  0x2              
 * 0x0115[3]     OUT2_VDD_SEL_EN        1                  0x1              
 * 0x0115[7:6]   OUT2_INV               0                  0x0              
 * 0x0117[0]     OUT3_PDN               1                  0x1              
 * 0x0117[1]     OUT3_OE                0                  0x0              
 * 0x0117[2]     OUT3_RDIV_FORCE2       0                  0x0              
 * 0x0118[2:0]   OUT3_FORMAT            1                  0x1              
 * 0x0118[3]     OUT3_SYNC_EN           1                  0x1              
 * 0x0118[5:4]   OUT3_DIS_STATE         0                  0x0              
 * 0x0118[7:6]   OUT3_CMOS_DRV          0                  0x0              
 * 0x0119[3:0]   OUT3_CM                11                 0xB              
 * 0x0119[6:4]   OUT3_AMPL              3                  0x3              
 * 0x011A[2:0]   OUT3_MUX_SEL           0                  0x0              
 * 0x011A[5:4]   OUT3_VDD_SEL           2                  0x2              
 * 0x011A[3]     OUT3_VDD_SEL_EN        1                  0x1              
 * 0x011A[7:6]   OUT3_INV               0                  0x0              
 * 0x011C[0]     OUT4_PDN               1                  0x1              
 * 0x011C[1]     OUT4_OE                0                  0x0              
 * 0x011C[2]     OUT4_RDIV_FORCE2       0                  0x0              
 * 0x011D[2:0]   OUT4_FORMAT            1                  0x1              
 * 0x011D[3]     OUT4_SYNC_EN           1                  0x1              
 * 0x011D[5:4]   OUT4_DIS_STATE         0                  0x0              
 * 0x011D[7:6]   OUT4_CMOS_DRV          0                  0x0              
 * 0x011E[3:0]   OUT4_CM                11                 0xB              
 * 0x011E[6:4]   OUT4_AMPL              3                  0x3              
 * 0x011F[2:0]   OUT4_MUX_SEL           0                  0x0              
 * 0x011F[5:4]   OUT4_VDD_SEL           2                  0x2              
 * 0x011F[3]     OUT4_VDD_SEL_EN        1                  0x1              
 * 0x011F[7:6]   OUT4_INV               0                  0x0              
 * 0x0121[0]     OUT5_PDN               0                  0x0              
 * 0x0121[1]     OUT5_OE                1                  0x1              
 * 0x0121[2]     OUT5_RDIV_FORCE2       0                  0x0              
 * 0x0122[2:0]   OUT5_FORMAT            1                  0x1              
 * 0x0122[3]     OUT5_SYNC_EN           1                  0x1              
 * 0x0122[5:4]   OUT5_DIS_STATE         0                  0x0              
 * 0x0122[7:6]   OUT5_CMOS_DRV          0                  0x0              
 * 0x0123[3:0]   OUT5_CM                11                 0xB              
 * 0x0123[6:4]   OUT5_AMPL              3                  0x3              
 * 0x0124[2:0]   OUT5_MUX_SEL           1                  0x1              
 * 0x0124[5:4]   OUT5_VDD_SEL           2                  0x2              
 * 0x0124[3]     OUT5_VDD_SEL_EN        1                  0x1              
 * 0x0124[7:6]   OUT5_INV               0                  0x0              
 * 0x0126[0]     OUT6_PDN               1                  0x1              
 * 0x0126[1]     OUT6_OE                0                  0x0              
 * 0x0126[2]     OUT6_RDIV_FORCE2       0                  0x0              
 * 0x0127[2:0]   OUT6_FORMAT            1                  0x1              
 * 0x0127[3]     OUT6_SYNC_EN           1                  0x1              
 * 0x0127[5:4]   OUT6_DIS_STATE         0                  0x0              
 * 0x0127[7:6]   OUT6_CMOS_DRV          0                  0x0              
 * 0x0128[3:0]   OUT6_CM                11                 0xB              
 * 0x0128[6:4]   OUT6_AMPL              3                  0x3              
 * 0x0129[2:0]   OUT6_MUX_SEL           0                  0x0              
 * 0x0129[5:4]   OUT6_VDD_SEL           2                  0x2              
 * 0x0129[3]     OUT6_VDD_SEL_EN        1                  0x1              
 * 0x0129[7:6]   OUT6_INV               0                  0x0              
 * 0x012B[0]     OUT7_PDN               1                  0x1              
 * 0x012B[1]     OUT7_OE                0                  0x0              
 * 0x012B[2]     OUT7_RDIV_FORCE2       0                  0x0              
 * 0x012C[2:0]   OUT7_FORMAT            1                  0x1              
 * 0x012C[3]     OUT7_SYNC_EN           1                  0x1              
 * 0x012C[5:4]   OUT7_DIS_STATE         0                  0x0              
 * 0x012C[7:6]   OUT7_CMOS_DRV          0                  0x0              
 * 0x012D[3:0]   OUT7_CM                11                 0xB              
 * 0x012D[6:4]   OUT7_AMPL              3                  0x3              
 * 0x012E[2:0]   OUT7_MUX_SEL           0                  0x0              
 * 0x012E[5:4]   OUT7_VDD_SEL           2                  0x2              
 * 0x012E[3]     OUT7_VDD_SEL_EN        1                  0x1              
 * 0x012E[7:6]   OUT7_INV               0                  0x0              
 * 0x0130[0]     OUT8_PDN               0                  0x0              
 * 0x0130[1]     OUT8_OE                1                  0x1              
 * 0x0130[2]     OUT8_RDIV_FORCE2       0                  0x0              
 * 0x0131[2:0]   OUT8_FORMAT            1                  0x1              
 * 0x0131[3]     OUT8_SYNC_EN           1                  0x1              
 * 0x0131[5:4]   OUT8_DIS_STATE         0                  0x0              
 * 0x0131[7:6]   OUT8_CMOS_DRV          0                  0x0              
 * 0x0132[3:0]   OUT8_CM                11                 0xB              
 * 0x0132[6:4]   OUT8_AMPL              3                  0x3              
 * 0x0133[2:0]   OUT8_MUX_SEL           2                  0x2              
 * 0x0133[5:4]   OUT8_VDD_SEL           2                  0x2              
 * 0x0133[3]     OUT8_VDD_SEL_EN        1                  0x1              
 * 0x0133[7:6]   OUT8_INV               0                  0x0              
 * 0x013A[0]     OUT9_PDN               1                  0x1              
 * 0x013A[1]     OUT9_OE                0                  0x0              
 * 0x013A[2]     OUT9_RDIV_FORCE2       0                  0x0              
 * 0x013B[2:0]   OUT9_FORMAT            1                  0x1              
 * 0x013B[3]     OUT9_SYNC_EN           1                  0x1              
 * 0x013B[5:4]   OUT9_DIS_STATE         0                  0x0              
 * 0x013B[7:6]   OUT9_CMOS_DRV          0                  0x0              
 * 0x013C[3:0]   OUT9_CM                11                 0xB              
 * 0x013C[6:4]   OUT9_AMPL              3                  0x3              
 * 0x013D[2:0]   OUT9_MUX_SEL           0                  0x0              
 * 0x013D[5:4]   OUT9_VDD_SEL           2                  0x2              
 * 0x013D[3]     OUT9_VDD_SEL_EN        1                  0x1              
 * 0x013D[7:6]   OUT9_INV               0                  0x0              
 * 0x013F[11:0]  OUTX_ALWAYS_ON         0                  0x000            
 * 0x0141[1]     OUT_DIS_MSK            0                  0x0              
 * 0x0141[5]     OUT_DIS_LOL_MSK        0                  0x0              
 * 0x0141[6]     OUT_DIS_LOSXAXB_MSK    1                  0x1              
 * 0x0141[7]     OUT_DIS_MSK_LOS_PFD    0                  0x0              
 * 0x0142[1]     OUT_DIS_MSK_LOL        1                  0x1              
 * 0x0142[5]     OUT_DIS_MSK_HOLD       1                  0x1              
 * 0x0206[1:0]   PXAXB                  0                  0x0              
 * 0x0208[47:0]  P0_NUM                 1                  0x000000000001   
 * 0x020E[31:0]  P0_DEN                 1                  0x00000001       
 * 0x0212[47:0]  P1_NUM                 0                  0x000000000000   
 * 0x0218[31:0]  P1_DEN                 0                  0x00000000       
 * 0x021C[47:0]  P2_NUM                 0                  0x000000000000   
 * 0x0222[31:0]  P2_DEN                 0                  0x00000000       
 * 0x0226[47:0]  P3_NUM                 0                  0x000000000000   
 * 0x022C[31:0]  P3_DEN                 0                  0x00000000       
 * 0x0231[3:0]   P0_FRACN_MODE          11                 0xB              
 * 0x0231[4]     P0_FRACN_EN            0                  0x0              
 * 0x0232[3:0]   P1_FRACN_MODE          11                 0xB              
 * 0x0232[4]     P1_FRACN_EN            0                  0x0              
 * 0x0233[3:0]   P2_FRACN_MODE          11                 0xB              
 * 0x0233[4]     P2_FRACN_EN            0                  0x0              
 * 0x0234[3:0]   P3_FRACN_MODE          11                 0xB              
 * 0x0234[4]     P3_FRACN_EN            0                  0x0              
 * 0x0235[43:0]  MXAXB_NUM              916841299968       0x0D578000000    
 * 0x023B[31:0]  MXAXB_DEN              3489660928         0xD0000000       
 * 0x024A[23:0]  R0_REG                 10                 0x00000A         
 * 0x024D[23:0]  R1_REG                 0                  0x000000         
 * 0x0250[23:0]  R2_REG                 1                  0x000001         
 * 0x0253[23:0]  R3_REG                 0                  0x000000         
 * 0x0256[23:0]  R4_REG                 0                  0x000000         
 * 0x0259[23:0]  R5_REG                 2                  0x000002         
 * 0x025C[23:0]  R6_REG                 0                  0x000000         
 * 0x025F[23:0]  R7_REG                 0                  0x000000         
 * 0x0262[23:0]  R8_REG                 2                  0x000002         
 * 0x0268[23:0]  R9_REG                 0                  0x000000         
 * 0x026B[7:0]   DESIGN_ID0             73                 0x49             
 * 0x026C[7:0]   DESIGN_ID1             79                 0x4F             
 * 0x026D[7:0]   DESIGN_ID2             52                 0x34             
 * 0x026E[7:0]   DESIGN_ID3             75                 0x4B             
 * 0x026F[7:0]   DESIGN_ID4             43                 0x2B             
 * 0x0270[7:0]   DESIGN_ID5             0                  0x00             
 * 0x0271[7:0]   DESIGN_ID6             0                  0x00             
 * 0x0272[7:0]   DESIGN_ID7             0                  0x00             
 * 0x0294[7:4]   FASTLOCK_EXTEND_SCL    8                  0x8              
 * 0x0296[1]     LOL_SLW_VALWIN_SELX    0                  0x0              
 * 0x0297[1]     FASTLOCK_DLY_ONSW_EN   1                  0x1              
 * 0x0299[1]     FASTLOCK_DLY_ONLOL_EN  1                  0x1              
 * 0x029D[19:0]  FASTLOCK_DLY_ONLOL     3829               0x00EF5          
 * 0x02A9[19:0]  FASTLOCK_DLY_ONSW      9830               0x02666          
 * 0x02B7[3:2]   LOL_NOSIG_TIME         3                  0x3              
 * 0x0302[43:0]  N0_NUM                 49392123904        0x00B80000000    
 * 0x0308[31:0]  N0_DEN                 2147483648         0x80000000       
 * 0x030C[0]     N0_UPDATE              0                  0x0              
 * 0x030D[43:0]  N1_NUM                 198967296000       0x02E53600000    
 * 0x0313[31:0]  N1_DEN                 2147483648         0x80000000       
 * 0x0317[0]     N1_UPDATE              0                  0x0              
 * 0x0318[43:0]  N2_NUM                 48282730496        0x00B3DE00000    
 * 0x031E[31:0]  N2_DEN                 3145728000         0xBB800000       
 * 0x0322[0]     N2_UPDATE              0                  0x0              
 * 0x0323[43:0]  N3_NUM                 0                  0x00000000000    
 * 0x0329[31:0]  N3_DEN                 0                  0x00000000       
 * 0x032D[0]     N3_UPDATE              0                  0x0              
 * 0x032E[43:0]  N4_NUM                 0                  0x00000000000    
 * 0x0334[31:0]  N4_DEN                 0                  0x00000000       
 * 0x0338[0]     N4_UPDATE              0                  0x0              
 * 0x0338[1]     N_UPDATE               0                  0x0              
 * 0x0339[4:0]   N_FSTEP_MSK            31                 0x1F             
 * 0x033B[43:0]  N0_FSTEPW              0                  0x00000000000    
 * 0x0341[43:0]  N1_FSTEPW              0                  0x00000000000    
 * 0x0347[43:0]  N2_FSTEPW              0                  0x00000000000    
 * 0x034D[43:0]  N3_FSTEPW              0                  0x00000000000    
 * 0x0353[43:0]  N4_FSTEPW              0                  0x00000000000    
 * 0x0359[15:0]  N0_DELAY               0                  0x0000           
 * 0x035B[15:0]  N1_DELAY               0                  0x0000           
 * 0x035D[15:0]  N2_DELAY               0                  0x0000           
 * 0x035F[15:0]  N3_DELAY               0                  0x0000           
 * 0x0361[15:0]  N4_DELAY               0                  0x0000           
 * 0x0487[0]     ZDM_EN                 0                  0x0              
 * 0x0487[2:1]   ZDM_IN_SEL             0                  0x0              
 * 0x0487[4]     ZDM_AUTOSW_EN          0                  0x0              
 * 0x0502[4]     ADD_DIV256             0                  0x0              
 * 0x0508[5:0]   BW0_PLL                17                 0x11             
 * 0x0509[5:0]   BW1_PLL                26                 0x1A             
 * 0x050A[5:0]   BW2_PLL                15                 0x0F             
 * 0x050B[5:0]   BW3_PLL                15                 0x0F             
 * 0x050C[5:0]   BW4_PLL                1                  0x01             
 * 0x050D[5:0]   BW5_PLL                7                  0x07             
 * 0x050E[5:0]   FASTLOCK_BW0_PLL       23                 0x17             
 * 0x050F[5:0]   FASTLOCK_BW1_PLL       40                 0x28             
 * 0x0510[5:0]   FASTLOCK_BW2_PLL       12                 0x0C             
 * 0x0511[5:0]   FASTLOCK_BW3_PLL       11                 0x0B             
 * 0x0512[5:0]   FASTLOCK_BW4_PLL       1                  0x01             
 * 0x0513[5:0]   FASTLOCK_BW5_PLL       7                  0x07             
 * 0x0515[55:0]  M_NUM                  130395207106560    0x00769800000000 
 * 0x051C[31:0]  M_DEN                  2147483648         0x80000000       
 * 0x0521[3:0]   M_FRAC_MODE            11                 0xB              
 * 0x0521[4]     M_FRAC_EN              0                  0x0              
 * 0x0521[5]     PLL_OUT_RATE_SEL       1                  0x1              
 * 0x052A[0]     IN_SEL_REGCTRL         1                  0x1              
 * 0x052A[3:1]   IN_SEL                 0                  0x0              
 * 0x052B[0]     FASTLOCK_AUTO_EN       1                  0x1              
 * 0x052B[1]     FASTLOCK_MAN           0                  0x0              
 * 0x052C[0]     HOLD_EN                1                  0x1              
 * 0x052C[3]     HOLD_RAMP_BYP          1                  0x1              
 * 0x052C[4]     HOLDEXIT_BW_SEL1       0                  0x0              
 * 0x052C[7:5]   RAMP_STEP_INTERVAL     0                  0x0              
 * 0x052D[1]     HOLD_RAMPBYP_NOHIST    1                  0x1              
 * 0x052E[4:0]   HOLD_HIST_LEN          21                 0x15             
 * 0x052F[4:0]   HOLD_HIST_DELAY        20                 0x14             
 * 0x0531[4:0]   HOLD_REF_COUNT_FRC     0                  0x00             
 * 0x0532[23:0]  HOLD_15M_CYC_COUNT     37038              0x0090AE         
 * 0x0535[0]     FORCE_HOLD             0                  0x0              
 * 0x0536[1:0]   CLK_SWITCH_MODE        0                  0x0              
 * 0x0536[2]     HSW_EN                 0                  0x0              
 * 0x0537[3:0]   IN_LOS_MSK             0                  0x0              
 * 0x0537[7:4]   IN_OOF_MSK             0                  0x0              
 * 0x0538[2:0]   IN0_PRIORITY           0                  0x0              
 * 0x0538[6:4]   IN1_PRIORITY           0                  0x0              
 * 0x0539[2:0]   IN2_PRIORITY           0                  0x0              
 * 0x0539[6:4]   IN3_PRIORITY           0                  0x0              
 * 0x053A[1:0]   HSW_MODE               2                  0x2              
 * 0x053A[3:2]   HSW_PHMEAS_CTRL        0                  0x0              
 * 0x053B[9:0]   HSW_PHMEAS_THR         3                  0x003            
 * 0x053D[4:0]   HSW_COARSE_PM_LEN      18                 0x12             
 * 0x053E[4:0]   HSW_COARSE_PM_DLY      6                  0x06             
 * 0x0589[12:0]  CAP_SHORT_DELAY        604                0x025C           
 * 0x059B[4]     HOLD_PRESERVE_HIST     1                  0x1              
 * 0x059B[5]     HOLD_FRZ_WITH_INTONLY  1                  0x1              
 * 0x059B[6]     HOLDEXIT_BW_SEL0       1                  0x1              
 * 0x059B[7]     HOLDEXIT_STD_BO        1                  0x1              
 * 0x059D[5:0]   HOLDEXIT_BW0           23                 0x17             
 * 0x059E[5:0]   HOLDEXIT_BW1           40                 0x28             
 * 0x059F[5:0]   HOLDEXIT_BW2           12                 0x0C             
 * 0x05A0[5:0]   HOLDEXIT_BW3           11                 0x0B             
 * 0x05A1[5:0]   HOLDEXIT_BW4           1                  0x01             
 * 0x05A2[5:0]   HOLDEXIT_BW5           7                  0x07             
 * 0x05A6[2:0]   RAMP_STEP_SIZE         0                  0x0              
 * 0x05A6[3]     RAMP_SWITCH_EN         0                  0x0              
 * 0x0802[15:0]  FIXREGSA0              1333               0x0535           
 * 0x0804[7:0]   FIXREGSD0              0                  0x00             
 * 0x0805[15:0]  FIXREGSA1              0                  0x0000           
 * 0x0807[7:0]   FIXREGSD1              0                  0x00             
 * 0x0808[15:0]  FIXREGSA2              0                  0x0000           
 * 0x080A[7:0]   FIXREGSD2              0                  0x00             
 * 0x080B[15:0]  FIXREGSA3              0                  0x0000           
 * 0x080D[7:0]   FIXREGSD3              0                  0x00             
 * 0x080E[15:0]  FIXREGSA4              0                  0x0000           
 * 0x0810[7:0]   FIXREGSD4              0                  0x00             
 * 0x0811[15:0]  FIXREGSA5              0                  0x0000           
 * 0x0813[7:0]   FIXREGSD5              0                  0x00             
 * 0x0814[15:0]  FIXREGSA6              0                  0x0000           
 * 0x0816[7:0]   FIXREGSD6              0                  0x00             
 * 0x0817[15:0]  FIXREGSA7              0                  0x0000           
 * 0x0819[7:0]   FIXREGSD7              0                  0x00             
 * 0x081A[15:0]  FIXREGSA8              0                  0x0000           
 * 0x081C[7:0]   FIXREGSD8              0                  0x00             
 * 0x081D[15:0]  FIXREGSA9              0                  0x0000           
 * 0x081F[7:0]   FIXREGSD9              0                  0x00             
 * 0x0820[15:0]  FIXREGSA10             0                  0x0000           
 * 0x0822[7:0]   FIXREGSD10             0                  0x00             
 * 0x0823[15:0]  FIXREGSA11             0                  0x0000           
 * 0x0825[7:0]   FIXREGSD11             0                  0x00             
 * 0x0826[15:0]  FIXREGSA12             0                  0x0000           
 * 0x0828[7:0]   FIXREGSD12             0                  0x00             
 * 0x0829[15:0]  FIXREGSA13             0                  0x0000           
 * 0x082B[7:0]   FIXREGSD13             0                  0x00             
 * 0x082C[15:0]  FIXREGSA14             0                  0x0000           
 * 0x082E[7:0]   FIXREGSD14             0                  0x00             
 * 0x082F[15:0]  FIXREGSA15             0                  0x0000           
 * 0x0831[7:0]   FIXREGSD15             0                  0x00             
 * 0x0832[15:0]  FIXREGSA16             0                  0x0000           
 * 0x0834[7:0]   FIXREGSD16             0                  0x00             
 * 0x0835[15:0]  FIXREGSA17             0                  0x0000           
 * 0x0837[7:0]   FIXREGSD17             0                  0x00             
 * 0x0838[15:0]  FIXREGSA18             0                  0x0000           
 * 0x083A[7:0]   FIXREGSD18             0                  0x00             
 * 0x083B[15:0]  FIXREGSA19             0                  0x0000           
 * 0x083D[7:0]   FIXREGSD19             0                  0x00             
 * 0x083E[15:0]  FIXREGSA20             0                  0x0000           
 * 0x0840[7:0]   FIXREGSD20             0                  0x00             
 * 0x0841[15:0]  FIXREGSA21             0                  0x0000           
 * 0x0843[7:0]   FIXREGSD21             0                  0x00             
 * 0x0844[15:0]  FIXREGSA22             0                  0x0000           
 * 0x0846[7:0]   FIXREGSD22             0                  0x00             
 * 0x0847[15:0]  FIXREGSA23             0                  0x0000           
 * 0x0849[7:0]   FIXREGSD23             0                  0x00             
 * 0x084A[15:0]  FIXREGSA24             0                  0x0000           
 * 0x084C[7:0]   FIXREGSD24             0                  0x00             
 * 0x084D[15:0]  FIXREGSA25             0                  0x0000           
 * 0x084F[7:0]   FIXREGSD25             0                  0x00             
 * 0x0850[15:0]  FIXREGSA26             0                  0x0000           
 * 0x0852[7:0]   FIXREGSD26             0                  0x00             
 * 0x0853[15:0]  FIXREGSA27             0                  0x0000           
 * 0x0855[7:0]   FIXREGSD27             0                  0x00             
 * 0x0856[15:0]  FIXREGSA28             0                  0x0000           
 * 0x0858[7:0]   FIXREGSD28             0                  0x00             
 * 0x0859[15:0]  FIXREGSA29             0                  0x0000           
 * 0x085B[7:0]   FIXREGSD29             0                  0x00             
 * 0x085C[15:0]  FIXREGSA30             0                  0x0000           
 * 0x085E[7:0]   FIXREGSD30             0                  0x00             
 * 0x085F[15:0]  FIXREGSA31             0                  0x0000           
 * 0x0861[7:0]   FIXREGSD31             0                  0x00             
 * 0x090E[0]     XAXB_EXTCLK_EN         1                  0x1              
 * 0x0943[0]     IO_VDD_SEL             0                  0x0              
 * 0x0949[3:0]   IN_EN                  1                  0x1              
 * 0x0949[7:4]   IN_PULSED_CMOS_EN      3                  0x3              
 * 0x094A[3:0]   INX_TO_PFD_EN          1                  0x1              
 * 0x094E[11:0]  REFCLK_HYS_SEL         585                0x249            
 * 0x095E[0]     MXAXB_INTEGER          0                  0x0              
 * 0x0A02[4:0]   N_ADD_0P5              0                  0x00             
 * 0x0A03[4:0]   N_CLK_TO_OUTX_EN       7                  0x07             
 * 0x0A04[4:0]   N_PIBYP                1                  0x01             
 * 0x0A05[4:0]   N_PDNB                 7                  0x07             
 * 0x0A14[3]     N0_HIGH_FREQ           0                  0x0              
 * 0x0A1A[3]     N1_HIGH_FREQ           0                  0x0              
 * 0x0A20[3]     N2_HIGH_FREQ           0                  0x0              
 * 0x0A26[3]     N3_HIGH_FREQ           0                  0x0              
 * 0x0A2C[3]     N4_HIGH_FREQ           0                  0x0              
 * 0x0B44[3:0]   PDIV_FRACN_CLK_DIS     15                 0xF              
 * 0x0B44[5]     FRACN_CLK_DIS_PLL      1                  0x1              
 * 0x0B46[3:0]   LOS_CLK_DIS            0                  0x0              
 * 0x0B47[4:0]   OOF_CLK_DIS            14                 0x0E             
 * 0x0B48[4:0]   OOF_DIV_CLK_DIS        14                 0x0E             
 * 0x0B4A[4:0]   N_CLK_DIS              24                 0x18             
 * 0x0B57[11:0]  VCO_RESET_CALCODE      249                0x0F9
 * 
 *
 */


static struct ntv2_genlock_data s_genlock_1125_2398[] =
{
	/* Start configuration preamble */
	{ 0x0B24, 0xC0 },
	{ 0x0B25, 0x00 },
	{ 0x0540, 0x01 },
	/* End configuration preamble */

	/* Delay 300 msec */
	/*    Delay is worst case time for device to complete any calibration */
	/*    that is running due to device state change previous to this script */
	/*    being processed. */
	{ 0x0000, 0x01 },

	/* Start configuration registers */
	{ 0x000B, 0x64 },
	{ 0x0016, 0x02 },
	{ 0x0017, 0xFC },
	{ 0x0018, 0xFF },
	{ 0x0019, 0xDF },
	{ 0x001A, 0xDF },
	{ 0x002B, 0x02 },
	{ 0x002C, 0x01 },
	{ 0x002D, 0x02 },
	{ 0x002E, 0x80 },
	{ 0x002F, 0x09 },
	{ 0x0030, 0x00 },
	{ 0x0031, 0x00 },
	{ 0x0032, 0x00 },
	{ 0x0033, 0x00 },
	{ 0x0034, 0x00 },
	{ 0x0035, 0x00 },
	{ 0x0036, 0xB5 },
	{ 0x0037, 0x08 },
	{ 0x0038, 0x00 },
	{ 0x0039, 0x00 },
	{ 0x003A, 0x00 },
	{ 0x003B, 0x00 },
	{ 0x003C, 0x00 },
	{ 0x003D, 0x00 },
	{ 0x003F, 0x01 },
	{ 0x0040, 0x04 },
	{ 0x0041, 0x01 },
	{ 0x0042, 0x00 },
	{ 0x0043, 0x00 },
	{ 0x0044, 0x00 },
	{ 0x0045, 0x0C },
	{ 0x0046, 0x96 },
	{ 0x0047, 0x00 },
	{ 0x0048, 0x00 },
	{ 0x0049, 0x00 },
	{ 0x004A, 0x4B },
	{ 0x004B, 0x00 },
	{ 0x004C, 0x00 },
	{ 0x004D, 0x00 },
	{ 0x004E, 0x05 },
	{ 0x004F, 0x00 },
	{ 0x0050, 0x0F },
	{ 0x0051, 0x00 },
	{ 0x0052, 0x00 },
	{ 0x0053, 0x00 },
	{ 0x0054, 0x00 },
	{ 0x0055, 0x00 },
	{ 0x0056, 0x00 },
	{ 0x0057, 0x00 },
	{ 0x0058, 0x00 },
	{ 0x0059, 0x01 },
	{ 0x005A, 0x5A },
	{ 0x005B, 0xF4 },
	{ 0x005C, 0x0F },
	{ 0x005D, 0x01 },
	{ 0x005E, 0x00 },
	{ 0x005F, 0x00 },
	{ 0x0060, 0x00 },
	{ 0x0061, 0x00 },
	{ 0x0062, 0x00 },
	{ 0x0063, 0x00 },
	{ 0x0064, 0x00 },
	{ 0x0065, 0x00 },
	{ 0x0066, 0x00 },
	{ 0x0067, 0x00 },
	{ 0x0068, 0x00 },
	{ 0x0069, 0x00 },
	{ 0x0092, 0x02 },
	{ 0x0093, 0xA0 },
	{ 0x0095, 0x00 },
	{ 0x0096, 0x90 },
	{ 0x0098, 0x70 },
	{ 0x009A, 0x02 },
	{ 0x009B, 0x50 },
	{ 0x009D, 0x04 },
	{ 0x009E, 0x60 },
	{ 0x00A0, 0x30 },
	{ 0x00A2, 0x00 },
	{ 0x00A9, 0xB1 },
	{ 0x00AA, 0xB1 },
	{ 0x00AB, 0x04 },
	{ 0x00AC, 0x00 },
	{ 0x00E5, 0x21 },
	{ 0x00EA, 0xD1 },
	{ 0x00EB, 0xB1 },
	{ 0x00EC, 0x03 },
	{ 0x00ED, 0x00 },
	{ 0x0102, 0x01 },
	{ 0x0108, 0x02 },
	{ 0x0109, 0x09 },
	{ 0x010A, 0x3B },
	{ 0x010B, 0x28 },
	{ 0x010D, 0x01 },
	{ 0x010E, 0x09 },
	{ 0x010F, 0x3B },
	{ 0x0110, 0x28 },
	{ 0x0112, 0x02 },
	{ 0x0113, 0x09 },
	{ 0x0114, 0x3B },
	{ 0x0115, 0x28 },
	{ 0x0117, 0x01 },
	{ 0x0118, 0x09 },
	{ 0x0119, 0x3B },
	{ 0x011A, 0x28 },
	{ 0x011C, 0x01 },
	{ 0x011D, 0x09 },
	{ 0x011E, 0x3B },
	{ 0x011F, 0x28 },
	{ 0x0121, 0x02 },
	{ 0x0122, 0x09 },
	{ 0x0123, 0x3B },
	{ 0x0124, 0x29 },
	{ 0x0126, 0x01 },
	{ 0x0127, 0x09 },
	{ 0x0128, 0x3B },
	{ 0x0129, 0x28 },
	{ 0x012B, 0x01 },
	{ 0x012C, 0x09 },
	{ 0x012D, 0x3B },
	{ 0x012E, 0x28 },
	{ 0x0130, 0x02 },
	{ 0x0131, 0x09 },
	{ 0x0132, 0x3B },
	{ 0x0133, 0x2A },
	{ 0x013A, 0x01 },
	{ 0x013B, 0x09 },
	{ 0x013C, 0x3B },
	{ 0x013D, 0x28 },
	{ 0x013F, 0x00 },
	{ 0x0140, 0x00 },
	{ 0x0141, 0x40 },
	{ 0x0142, 0xFF },
	{ 0x0206, 0x00 },
	{ 0x0208, 0x01 },
	{ 0x0209, 0x00 },
	{ 0x020A, 0x00 },
	{ 0x020B, 0x00 },
	{ 0x020C, 0x00 },
	{ 0x020D, 0x00 },
	{ 0x020E, 0x01 },
	{ 0x020F, 0x00 },
	{ 0x0210, 0x00 },
	{ 0x0211, 0x00 },
	{ 0x0212, 0x00 },
	{ 0x0213, 0x00 },
	{ 0x0214, 0x00 },
	{ 0x0215, 0x00 },
	{ 0x0216, 0x00 },
	{ 0x0217, 0x00 },
	{ 0x0218, 0x00 },
	{ 0x0219, 0x00 },
	{ 0x021A, 0x00 },
	{ 0x021B, 0x00 },
	{ 0x021C, 0x00 },
	{ 0x021D, 0x00 },
	{ 0x021E, 0x00 },
	{ 0x021F, 0x00 },
	{ 0x0220, 0x00 },
	{ 0x0221, 0x00 },
	{ 0x0222, 0x00 },
	{ 0x0223, 0x00 },
	{ 0x0224, 0x00 },
	{ 0x0225, 0x00 },
	{ 0x0226, 0x00 },
	{ 0x0227, 0x00 },
	{ 0x0228, 0x00 },
	{ 0x0229, 0x00 },
	{ 0x022A, 0x00 },
	{ 0x022B, 0x00 },
	{ 0x022C, 0x00 },
	{ 0x022D, 0x00 },
	{ 0x022E, 0x00 },
	{ 0x022F, 0x00 },
	{ 0x0231, 0x0B },
	{ 0x0232, 0x0B },
	{ 0x0233, 0x0B },
	{ 0x0234, 0x0B },
	{ 0x0235, 0x00 },
	{ 0x0236, 0x00 },
	{ 0x0237, 0x00 },
	{ 0x0238, 0x78 },
	{ 0x0239, 0xD5 },
	{ 0x023A, 0x00 },
	{ 0x023B, 0x00 },
	{ 0x023C, 0x00 },
	{ 0x023D, 0x00 },
	{ 0x023E, 0xD0 },
	{ 0x024A, 0x0A },
	{ 0x024B, 0x00 },
	{ 0x024C, 0x00 },
	{ 0x024D, 0x00 },
	{ 0x024E, 0x00 },
	{ 0x024F, 0x00 },
	{ 0x0250, 0x01 },
	{ 0x0251, 0x00 },
	{ 0x0252, 0x00 },
	{ 0x0253, 0x00 },
	{ 0x0254, 0x00 },
	{ 0x0255, 0x00 },
	{ 0x0256, 0x00 },
	{ 0x0257, 0x00 },
	{ 0x0258, 0x00 },
	{ 0x0259, 0x02 },
	{ 0x025A, 0x00 },
	{ 0x025B, 0x00 },
	{ 0x025C, 0x00 },
	{ 0x025D, 0x00 },
	{ 0x025E, 0x00 },
	{ 0x025F, 0x00 },
	{ 0x0260, 0x00 },
	{ 0x0261, 0x00 },
	{ 0x0262, 0x02 },
	{ 0x0263, 0x00 },
	{ 0x0264, 0x00 },
	{ 0x0268, 0x00 },
	{ 0x0269, 0x00 },
	{ 0x026A, 0x00 },
	{ 0x026B, 0x49 },
	{ 0x026C, 0x4F },
	{ 0x026D, 0x34 },
	{ 0x026E, 0x4B },
	{ 0x026F, 0x2B },
	{ 0x0270, 0x00 },
	{ 0x0271, 0x00 },
	{ 0x0272, 0x00 },
	{ 0x0294, 0x80 },
	{ 0x0296, 0x00 },
	{ 0x0297, 0x02 },
	{ 0x0299, 0x02 },
	{ 0x029D, 0xF5 },
	{ 0x029E, 0x0E },
	{ 0x029F, 0x00 },
	{ 0x02A9, 0x66 },
	{ 0x02AA, 0x26 },
	{ 0x02AB, 0x00 },
	{ 0x02B7, 0xFF },
	{ 0x0302, 0x00 },
	{ 0x0303, 0x00 },
	{ 0x0304, 0x00 },
	{ 0x0305, 0x80 },
	{ 0x0306, 0x0B },
	{ 0x0307, 0x00 },
	{ 0x0308, 0x00 },
	{ 0x0309, 0x00 },
	{ 0x030A, 0x00 },
	{ 0x030B, 0x80 },
	{ 0x030C, 0x00 },
	{ 0x030D, 0x00 },
	{ 0x030E, 0x00 },
	{ 0x030F, 0x60 },
	{ 0x0310, 0x53 },
	{ 0x0311, 0x2E },
	{ 0x0312, 0x00 },
	{ 0x0313, 0x00 },
	{ 0x0314, 0x00 },
	{ 0x0315, 0x00 },
	{ 0x0316, 0x80 },
	{ 0x0317, 0x00 },
	{ 0x0318, 0x00 },
	{ 0x0319, 0x00 },
	{ 0x031A, 0xE0 },
	{ 0x031B, 0x3D },
	{ 0x031C, 0x0B },
	{ 0x031D, 0x00 },
	{ 0x031E, 0x00 },
	{ 0x031F, 0x00 },
	{ 0x0320, 0x80 },
	{ 0x0321, 0xBB },
	{ 0x0322, 0x00 },
	{ 0x0323, 0x00 },
	{ 0x0324, 0x00 },
	{ 0x0325, 0x00 },
	{ 0x0326, 0x00 },
	{ 0x0327, 0x00 },
	{ 0x0328, 0x00 },
	{ 0x0329, 0x00 },
	{ 0x032A, 0x00 },
	{ 0x032B, 0x00 },
	{ 0x032C, 0x00 },
	{ 0x032D, 0x00 },
	{ 0x032E, 0x00 },
	{ 0x032F, 0x00 },
	{ 0x0330, 0x00 },
	{ 0x0331, 0x00 },
	{ 0x0332, 0x00 },
	{ 0x0333, 0x00 },
	{ 0x0334, 0x00 },
	{ 0x0335, 0x00 },
	{ 0x0336, 0x00 },
	{ 0x0337, 0x00 },
	{ 0x0338, 0x00 },
	{ 0x0339, 0x1F },
	{ 0x033B, 0x00 },
	{ 0x033C, 0x00 },
	{ 0x033D, 0x00 },
	{ 0x033E, 0x00 },
	{ 0x033F, 0x00 },
	{ 0x0340, 0x00 },
	{ 0x0341, 0x00 },
	{ 0x0342, 0x00 },
	{ 0x0343, 0x00 },
	{ 0x0344, 0x00 },
	{ 0x0345, 0x00 },
	{ 0x0346, 0x00 },
	{ 0x0347, 0x00 },
	{ 0x0348, 0x00 },
	{ 0x0349, 0x00 },
	{ 0x034A, 0x00 },
	{ 0x034B, 0x00 },
	{ 0x034C, 0x00 },
	{ 0x034D, 0x00 },
	{ 0x034E, 0x00 },
	{ 0x034F, 0x00 },
	{ 0x0350, 0x00 },
	{ 0x0351, 0x00 },
	{ 0x0352, 0x00 },
	{ 0x0353, 0x00 },
	{ 0x0354, 0x00 },
	{ 0x0355, 0x00 },
	{ 0x0356, 0x00 },
	{ 0x0357, 0x00 },
	{ 0x0358, 0x00 },
	{ 0x0359, 0x00 },
	{ 0x035A, 0x00 },
	{ 0x035B, 0x00 },
	{ 0x035C, 0x00 },
	{ 0x035D, 0x00 },
	{ 0x035E, 0x00 },
	{ 0x035F, 0x00 },
	{ 0x0360, 0x00 },
	{ 0x0361, 0x00 },
	{ 0x0362, 0x00 },
	{ 0x0487, 0x00 },
	{ 0x0502, 0x01 },
	{ 0x0508, 0x10 },
	{ 0x0509, 0x18 },
	{ 0x050A, 0x0F },
	{ 0x050B, 0x0F },
	{ 0x050C, 0x03 },
	{ 0x050D, 0x07 },
	{ 0x050E, 0x17 },
	{ 0x050F, 0x28 },
	{ 0x0510, 0x0C },
	{ 0x0511, 0x0B },
	{ 0x0512, 0x03 },
	{ 0x0513, 0x07 },
	{ 0x0515, 0x00 },
	{ 0x0516, 0x00 },
	{ 0x0517, 0x00 },
	{ 0x0518, 0x40 },
	{ 0x0519, 0x51 },
	{ 0x051A, 0xF7 },
	{ 0x051B, 0x00 },
	{ 0x051C, 0x00 },
	{ 0x051D, 0x00 },
	{ 0x051E, 0x00 },
	{ 0x051F, 0xA0 },
	{ 0x0521, 0x3B },
	{ 0x052A, 0x01 },
	{ 0x052B, 0x01 },
	{ 0x052C, 0x0F },
	{ 0x052D, 0x03 },
	{ 0x052E, 0x15 },
	{ 0x052F, 0x14 },
	{ 0x0531, 0x00 },
	{ 0x0532, 0x5F },
	{ 0x0533, 0xF1 },
	{ 0x0534, 0x00 },
	{ 0x0535, 0x00 },
	{ 0x0536, 0x00 },
	{ 0x0537, 0x00 },
	{ 0x0538, 0x00 },
	{ 0x0539, 0x00 },
	{ 0x053A, 0x02 },
	{ 0x053B, 0x03 },
	{ 0x053C, 0x00 },
	{ 0x053D, 0x12 },
	{ 0x053E, 0x06 },
	{ 0x0589, 0xF2 },
	{ 0x058A, 0x03 },
	{ 0x059B, 0xF8 },
	{ 0x059D, 0x17 },
	{ 0x059E, 0x28 },
	{ 0x059F, 0x0C },
	{ 0x05A0, 0x0B },
	{ 0x05A1, 0x03 },
	{ 0x05A2, 0x07 },
	{ 0x05A6, 0x00 },
	{ 0x0802, 0x35 },
	{ 0x0803, 0x05 },
	{ 0x0804, 0x00 },
	{ 0x0805, 0x00 },
	{ 0x0806, 0x00 },
	{ 0x0807, 0x00 },
	{ 0x0808, 0x00 },
	{ 0x0809, 0x00 },
	{ 0x080A, 0x00 },
	{ 0x080B, 0x00 },
	{ 0x080C, 0x00 },
	{ 0x080D, 0x00 },
	{ 0x080E, 0x00 },
	{ 0x080F, 0x00 },
	{ 0x0810, 0x00 },
	{ 0x0811, 0x00 },
	{ 0x0812, 0x00 },
	{ 0x0813, 0x00 },
	{ 0x0814, 0x00 },
	{ 0x0815, 0x00 },
	{ 0x0816, 0x00 },
	{ 0x0817, 0x00 },
	{ 0x0818, 0x00 },
	{ 0x0819, 0x00 },
	{ 0x081A, 0x00 },
	{ 0x081B, 0x00 },
	{ 0x081C, 0x00 },
	{ 0x081D, 0x00 },
	{ 0x081E, 0x00 },
	{ 0x081F, 0x00 },
	{ 0x0820, 0x00 },
	{ 0x0821, 0x00 },
	{ 0x0822, 0x00 },
	{ 0x0823, 0x00 },
	{ 0x0824, 0x00 },
	{ 0x0825, 0x00 },
	{ 0x0826, 0x00 },
	{ 0x0827, 0x00 },
	{ 0x0828, 0x00 },
	{ 0x0829, 0x00 },
	{ 0x082A, 0x00 },
	{ 0x082B, 0x00 },
	{ 0x082C, 0x00 },
	{ 0x082D, 0x00 },
	{ 0x082E, 0x00 },
	{ 0x082F, 0x00 },
	{ 0x0830, 0x00 },
	{ 0x0831, 0x00 },
	{ 0x0832, 0x00 },
	{ 0x0833, 0x00 },
	{ 0x0834, 0x00 },
	{ 0x0835, 0x00 },
	{ 0x0836, 0x00 },
	{ 0x0837, 0x00 },
	{ 0x0838, 0x00 },
	{ 0x0839, 0x00 },
	{ 0x083A, 0x00 },
	{ 0x083B, 0x00 },
	{ 0x083C, 0x00 },
	{ 0x083D, 0x00 },
	{ 0x083E, 0x00 },
	{ 0x083F, 0x00 },
	{ 0x0840, 0x00 },
	{ 0x0841, 0x00 },
	{ 0x0842, 0x00 },
	{ 0x0843, 0x00 },
	{ 0x0844, 0x00 },
	{ 0x0845, 0x00 },
	{ 0x0846, 0x00 },
	{ 0x0847, 0x00 },
	{ 0x0848, 0x00 },
	{ 0x0849, 0x00 },
	{ 0x084A, 0x00 },
	{ 0x084B, 0x00 },
	{ 0x084C, 0x00 },
	{ 0x084D, 0x00 },
	{ 0x084E, 0x00 },
	{ 0x084F, 0x00 },
	{ 0x0850, 0x00 },
	{ 0x0851, 0x00 },
	{ 0x0852, 0x00 },
	{ 0x0853, 0x00 },
	{ 0x0854, 0x00 },
	{ 0x0855, 0x00 },
	{ 0x0856, 0x00 },
	{ 0x0857, 0x00 },
	{ 0x0858, 0x00 },
	{ 0x0859, 0x00 },
	{ 0x085A, 0x00 },
	{ 0x085B, 0x00 },
	{ 0x085C, 0x00 },
	{ 0x085D, 0x00 },
	{ 0x085E, 0x00 },
	{ 0x085F, 0x00 },
	{ 0x0860, 0x00 },
	{ 0x0861, 0x00 },
	{ 0x090E, 0x03 },
	{ 0x0943, 0x00 },
	{ 0x0949, 0x31 },
	{ 0x094A, 0x01 },
	{ 0x094E, 0x49 },
	{ 0x094F, 0x02 },
	{ 0x095E, 0x00 },
	{ 0x0A02, 0x00 },
	{ 0x0A03, 0x07 },
	{ 0x0A04, 0x01 },
	{ 0x0A05, 0x07 },
	{ 0x0A14, 0x00 },
	{ 0x0A1A, 0x00 },
	{ 0x0A20, 0x00 },
	{ 0x0A26, 0x00 },
	{ 0x0A2C, 0x00 },
	{ 0x0B44, 0x0F },
	{ 0x0B46, 0x00 },
	{ 0x0B47, 0x0E },
	{ 0x0B48, 0x0E },
	{ 0x0B4A, 0x18 },
	{ 0x0B57, 0xF9 },
	{ 0x0B58, 0x00 },
	/* End configuration registers */

	/* Start configuration postamble */
	{ 0x0514, 0x01 },
	{ 0x001C, 0x01 },
	{ 0x0540, 0x00 },
	{ 0x0B24, 0xC3 },
	{ 0x0B25, 0x02 },
	/* End configuration postamble */

	{ 0x0000, 0x00 }
};

/*
 * Design Report
 *
 * Overview
 * ========
 * Part:         Si5345 Rev D
 * Project File: C:\XilinxProjects\flint_tr051017\genlock\FormatFiles\IO4K+_1125_5994.slabtimeproj
 * Design ID:    IO4K+
 * Created By:   ClockBuilder Pro v2.16.1 [2017-07-19]
 * Timestamp:    2017-08-24 16:34:13 GMT-07:00
 * 
 * Design Notes
 * ============
 * assumes NTSC HSYNC (pulsed) input = (30/1.001)*525
 * 
 * Design Rule Check
 * =================
 * Errors:
 * - No errors
 * 
 * Warnings:
 * - Pulsed LVCMOS input buffer mode has been selected. This mode has non-standard input voltage logic thresholds: 0.33 V for Vil (max) and 0.49 V for Vih (min). Select this mode only if your input clock has a duty cycle significantly less or more than 50%.  Refer to the device datasheet for the exact threshold voltage specifications and the input attenuator circuit (DC coupled Pulsed LVCMOS) in the Family Reference Manual.
 * 
 * Device Grade
 * ============
 * Maximum Output Frequency: 148.5 MHz
 * Frequency Synthesis Mode: Fractional
 * Minimum Base OPN:         Si5345B
 * Actual Base OPN:          Si5345B
 * 
 * Base       Output Clock         Supported Frequency Synthesis Modes
 * OPN Grade  Frequency Range      (Typical Jitter)
 * ---------  -------------------  --------------------------------------------
 * Si5345A    100 Hz to 1.028 GHz  Integer (< 100 fs) and fractional (< 150 fs)
 * Si5345B    100 Hz to 350 MHz    "
 * Si5345C    100 Hz to 1.028 GHz  Integer only (< 100 fs)
 * Si5345D    100 Hz to 350 MHz    "
 * 
 * Design
 * ======
 * Host Interface:
 *    I/O Power Supply: VDD (Core)
 *    SPI Mode: 4-Wire
 *    I2C Address Range: 100d to 103d / 0x64 to 0x67 (selected via A0/A1 pins)
 * 
 * XA/XB:
 *    52 MHz (XO - External Oscillator)
 * 
 * Inputs:
 *     IN0: 26.9730269730269730... kHz [ 26 + 974/1001 kHz ]
 *          [ (24000/1001)*1125 ]
 *          Pulsed LVCMOS
 *     IN1: Unused
 *     IN2: Unused
 *     IN3: Unused
 * 
 * Outputs:
 *    OUT0: 27 MHz
 *          Enabled, LVDS 2.5 V
 *    OUT1: Unused
 *    OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT3: Unused
 *    OUT4: Unused
 *    OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT6: Unused
 *    OUT7: Unused
 *    OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *          [ 148.5/1.001 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT9: Unused
 * 
 * Frequency Plan
 * ==============
 * Priority: maximize the number of low jitter outputs
 * 
 * Fvco = 13.662 GHz [ 13 + 331/500 GHz ]
 * Fpfd = 26.9730269730269730... kHz [ 26 + 974/1001 kHz ]
 * Fms0 = 594 MHz
 * Fms1 = 147.456 MHz [ 147 + 57/125 MHz ]
 * Fms2 = 890.1098901098901098... MHz [ 890 + 10/91 MHz ]
 * 
 * P dividers:
 *    P0  = 1
 *    P1  = Unused
 *    P2  = Unused
 *    P3  = Unused
 *    Pxaxb = 1
 * 
 * MXAXB = 262.7307692307692307... [ 262 + 19/26 ]
 * M = 101301.2 [ 101301 + 1/5 ]
 * N dividers:
 *    N0:
 *       Value: 23
 *       Skew:  0.000 s
 *       OUT0: 27 MHz
 *       OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *    N1:
 *       Value: 92.6513671875 [ 92 + 667/1024 ]
 *       Skew:  0.000 s
 *       OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *    N2:
 *       Value: 15.3486666666666666... [ 15 + 523/1500 ]
 *       Skew:  0.000 s
 *       OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *    N3:
 *       Unused
 *    N4:
 *       Unused
 * 
 * R dividers:
 *    R0 = 22
 *    R1 = Unused
 *    R2 = 4
 *    R3 = Unused
 *    R4 = Unused
 *    R5 = 6
 *    R6 = Unused
 *    R7 = Unused
 *    R8 = 6
 *    R9 = Unused
 * 
 * Nominal Bandwidth:
 *   Desired: 1.000 Hz
 *   Actual:  518.932 mHz
 *   Coefficients:
 *      BW0:  16
 *      BW1:  24
 *      BW2:  15
 *      BW3:  15
 *      BW4:  3
 *      BW5:  7
 * Fastlock Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  81.064 Hz
 *   Coefficients:
 *      BW0:  23
 *      BW1:  40
 *      BW2:  12
 *      BW3:  11
 *      BW4:  3
 *      BW5:  7
 * Holdover Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  81.064 Hz
 *   Coefficients:
 *      BW0:  23
 *      BW1:  40
 *      BW2:  12
 *      BW3:  11
 *      BW4:  3
 *      BW5:  7
 * 
 * Dividers listed above show effective values. These values are translated to register settings by ClockBuilder Pro. For the actual register values, see below. Refer to the Family Reference Manual for information on registers related to frequency plan.
 * 
 * Digitally Controlled Oscillator (DCO)
 * =====================================
 * Mode: Register Direct Write
 * 
 * N0: DCO Disabled
 * 
 * N1: DCO Disabled
 * 
 * N2: DCO Disabled
 * 
 * N3: DCO Disabled
 * 
 * N4: DCO Disabled
 * 
 * Estimated Power & Junction Temperature
 * ======================================
 * Assumptions:
 * 
 * Revision: D
 * VDD:      1.8 V
 * Ta:       70 C
 * Airflow:  None
 * 
 * Total Power: 808 mW, On Chip Power: 784 mW, Tj: 87 C
 * 
 *                 Frequency  Format   Voltage   Current     Power
 *         -----------------  ------  --------  --------  --------
 * VDD                                   1.8 V  147.9 mA    266 mW
 * VDDA                                  3.3 V  117.4 mA    387 mW
 * VDDO0              27 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO1              Unused                                      
 * VDDO2           148.5 MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO3              Unused                                      
 * VDDO4              Unused                                      
 * VDDO5          24.576 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO6              Unused                                      
 * VDDO7              Unused                                      
 * VDDO8   148.351648... MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO9              Unused                                      
 *                                              --------  --------
 *                                       Total  327.2 mA    808 mW
 * 
 * Note:
 * 
 * -Total power includes on- and off-chip power. This is a typical value and estimate only.
 * -Use an EVB for a more exact power measurement
 * -On-chip power excludes power dissipated in external terminations.
 * -Tj is junction temperature. Tj must be less than 125 C (on Si5345 Revision D) for device to comply with datasheet specifications.
 * 
 * Settings
 * ========
 * 
 * Location      Setting Name           Decimal Value      Hex Value        
 * ------------  ---------------------  -----------------  -----------------
 * 0x000B[6:0]   I2C_ADDR               100                0x64             
 * 0x0016[1]     LOL_ON_HOLD            1                  0x1              
 * 0x0017[0]     SYSINCAL_INTR_MSK      0                  0x0              
 * 0x0017[1]     LOSXAXB_INTR_MSK       0                  0x0              
 * 0x0017[5]     SMB_TMOUT_INTR_MSK     1                  0x1              
 * 0x0018[3:0]   LOS_INTR_MSK           15                 0xF              
 * 0x0018[7:4]   OOF_INTR_MSK           15                 0xF              
 * 0x0019[1]     LOL_INTR_MSK           1                  0x1              
 * 0x0019[5]     HOLD_INTR_MSK          0                  0x0              
 * 0x001A[5]     CAL_INTR_MSK           0                  0x0              
 * 0x002B[3]     SPI_3WIRE              0                  0x0              
 * 0x002B[5]     AUTO_NDIV_UPDATE       0                  0x0              
 * 0x002C[3:0]   LOS_EN                 1                  0x1              
 * 0x002C[4]     LOSXAXB_DIS            0                  0x0              
 * 0x002D[1:0]   LOS0_VAL_TIME          2                  0x2              
 * 0x002D[3:2]   LOS1_VAL_TIME          0                  0x0              
 * 0x002D[5:4]   LOS2_VAL_TIME          0                  0x0              
 * 0x002D[7:6]   LOS3_VAL_TIME          0                  0x0              
 * 0x002E[15:0]  LOS0_TRG_THR           2432               0x0980           
 * 0x0030[15:0]  LOS1_TRG_THR           0                  0x0000           
 * 0x0032[15:0]  LOS2_TRG_THR           0                  0x0000           
 * 0x0034[15:0]  LOS3_TRG_THR           0                  0x0000           
 * 0x0036[15:0]  LOS0_CLR_THR           2229               0x08B5           
 * 0x0038[15:0]  LOS1_CLR_THR           0                  0x0000           
 * 0x003A[15:0]  LOS2_CLR_THR           0                  0x0000           
 * 0x003C[15:0]  LOS3_CLR_THR           0                  0x0000           
 * 0x003F[3:0]   OOF_EN                 1                  0x1              
 * 0x003F[7:4]   FAST_OOF_EN            0                  0x0              
 * 0x0040[2:0]   OOF_REF_SEL            4                  0x4              
 * 0x0041[4:0]   OOF0_DIV_SEL           1                  0x01             
 * 0x0042[4:0]   OOF1_DIV_SEL           0                  0x00             
 * 0x0043[4:0]   OOF2_DIV_SEL           0                  0x00             
 * 0x0044[4:0]   OOF3_DIV_SEL           0                  0x00             
 * 0x0045[4:0]   OOFXO_DIV_SEL          12                 0x0C             
 * 0x0046[7:0]   OOF0_SET_THR           150                0x96             
 * 0x0047[7:0]   OOF1_SET_THR           0                  0x00             
 * 0x0048[7:0]   OOF2_SET_THR           0                  0x00             
 * 0x0049[7:0]   OOF3_SET_THR           0                  0x00             
 * 0x004A[7:0]   OOF0_CLR_THR           75                 0x4B             
 * 0x004B[7:0]   OOF1_CLR_THR           0                  0x00             
 * 0x004C[7:0]   OOF2_CLR_THR           0                  0x00             
 * 0x004D[7:0]   OOF3_CLR_THR           0                  0x00             
 * 0x004E[2:0]   OOF0_DETWIN_SEL        5                  0x5              
 * 0x004E[6:4]   OOF1_DETWIN_SEL        0                  0x0              
 * 0x004F[2:0]   OOF2_DETWIN_SEL        0                  0x0              
 * 0x004F[6:4]   OOF3_DETWIN_SEL        0                  0x0              
 * 0x0050[3:0]   OOF_ON_LOS             15                 0xF              
 * 0x0051[3:0]   FAST_OOF0_SET_THR      0                  0x0              
 * 0x0052[3:0]   FAST_OOF1_SET_THR      0                  0x0              
 * 0x0053[3:0]   FAST_OOF2_SET_THR      0                  0x0              
 * 0x0054[3:0]   FAST_OOF3_SET_THR      0                  0x0              
 * 0x0055[3:0]   FAST_OOF0_CLR_THR      0                  0x0              
 * 0x0056[3:0]   FAST_OOF1_CLR_THR      0                  0x0              
 * 0x0057[3:0]   FAST_OOF2_CLR_THR      0                  0x0              
 * 0x0058[3:0]   FAST_OOF3_CLR_THR      0                  0x0              
 * 0x0059[1:0]   FAST_OOF0_DETWIN_SEL   1                  0x1              
 * 0x0059[3:2]   FAST_OOF1_DETWIN_SEL   0                  0x0              
 * 0x0059[5:4]   FAST_OOF2_DETWIN_SEL   0                  0x0              
 * 0x0059[7:6]   FAST_OOF3_DETWIN_SEL   0                  0x0              
 * 0x005A[25:0]  OOF0_RATIO_REF         17822810           0x10FF45A        
 * 0x005E[25:0]  OOF1_RATIO_REF         0                  0x0000000        
 * 0x0062[25:0]  OOF2_RATIO_REF         0                  0x0000000        
 * 0x0066[25:0]  OOF3_RATIO_REF         0                  0x0000000        
 * 0x0092[1]     LOL_FST_EN             1                  0x1              
 * 0x0093[7:4]   LOL_FST_DETWIN_SEL     10                 0xA              
 * 0x0095[3:2]   LOL_FST_VALWIN_SEL     0                  0x0              
 * 0x0096[7:4]   LOL_FST_SET_THR_SEL    9                  0x9              
 * 0x0098[7:4]   LOL_FST_CLR_THR_SEL    7                  0x7              
 * 0x009A[1]     LOL_SLOW_EN_PLL        1                  0x1              
 * 0x009B[7:4]   LOL_SLW_DETWIN_SEL     5                  0x5              
 * 0x009D[3:2]   LOL_SLW_VALWIN_SEL     1                  0x1              
 * 0x009E[7:4]   LOL_SLW_SET_THR        6                  0x6              
 * 0x00A0[7:4]   LOL_SLW_CLR_THR        3                  0x3              
 * 0x00A2[1]     LOL_TIMER_EN           0                  0x0              
 * 0x00A9[28:0]  LOL_CLR_DELAY_DIV256   307633             0x0004B1B1       
 * 0x00E5[5]     FASTLOCK_EXTEND_EN     1                  0x1              
 * 0x00EA[28:0]  FASTLOCK_EXTEND        242129             0x0003B1D1       
 * 0x0102[0]     OUTALL_DISABLE_LOW     1                  0x1              
 * 0x0108[0]     OUT0_PDN               0                  0x0              
 * 0x0108[1]     OUT0_OE                1                  0x1              
 * 0x0108[2]     OUT0_RDIV_FORCE2       0                  0x0              
 * 0x0109[2:0]   OUT0_FORMAT            1                  0x1              
 * 0x0109[3]     OUT0_SYNC_EN           1                  0x1              
 * 0x0109[5:4]   OUT0_DIS_STATE         0                  0x0              
 * 0x0109[7:6]   OUT0_CMOS_DRV          0                  0x0              
 * 0x010A[3:0]   OUT0_CM                11                 0xB              
 * 0x010A[6:4]   OUT0_AMPL              3                  0x3              
 * 0x010B[2:0]   OUT0_MUX_SEL           0                  0x0              
 * 0x010B[5:4]   OUT0_VDD_SEL           2                  0x2              
 * 0x010B[3]     OUT0_VDD_SEL_EN        1                  0x1              
 * 0x010B[7:6]   OUT0_INV               0                  0x0              
 * 0x010D[0]     OUT1_PDN               1                  0x1              
 * 0x010D[1]     OUT1_OE                0                  0x0              
 * 0x010D[2]     OUT1_RDIV_FORCE2       0                  0x0              
 * 0x010E[2:0]   OUT1_FORMAT            1                  0x1              
 * 0x010E[3]     OUT1_SYNC_EN           1                  0x1              
 * 0x010E[5:4]   OUT1_DIS_STATE         0                  0x0              
 * 0x010E[7:6]   OUT1_CMOS_DRV          0                  0x0              
 * 0x010F[3:0]   OUT1_CM                11                 0xB              
 * 0x010F[6:4]   OUT1_AMPL              3                  0x3              
 * 0x0110[2:0]   OUT1_MUX_SEL           0                  0x0              
 * 0x0110[5:4]   OUT1_VDD_SEL           2                  0x2              
 * 0x0110[3]     OUT1_VDD_SEL_EN        1                  0x1              
 * 0x0110[7:6]   OUT1_INV               0                  0x0              
 * 0x0112[0]     OUT2_PDN               0                  0x0              
 * 0x0112[1]     OUT2_OE                1                  0x1              
 * 0x0112[2]     OUT2_RDIV_FORCE2       0                  0x0              
 * 0x0113[2:0]   OUT2_FORMAT            1                  0x1              
 * 0x0113[3]     OUT2_SYNC_EN           1                  0x1              
 * 0x0113[5:4]   OUT2_DIS_STATE         0                  0x0              
 * 0x0113[7:6]   OUT2_CMOS_DRV          0                  0x0              
 * 0x0114[3:0]   OUT2_CM                11                 0xB              
 * 0x0114[6:4]   OUT2_AMPL              3                  0x3              
 * 0x0115[2:0]   OUT2_MUX_SEL           0                  0x0              
 * 0x0115[5:4]   OUT2_VDD_SEL           2                  0x2              
 * 0x0115[3]     OUT2_VDD_SEL_EN        1                  0x1              
 * 0x0115[7:6]   OUT2_INV               0                  0x0              
 * 0x0117[0]     OUT3_PDN               1                  0x1              
 * 0x0117[1]     OUT3_OE                0                  0x0              
 * 0x0117[2]     OUT3_RDIV_FORCE2       0                  0x0              
 * 0x0118[2:0]   OUT3_FORMAT            1                  0x1              
 * 0x0118[3]     OUT3_SYNC_EN           1                  0x1              
 * 0x0118[5:4]   OUT3_DIS_STATE         0                  0x0              
 * 0x0118[7:6]   OUT3_CMOS_DRV          0                  0x0              
 * 0x0119[3:0]   OUT3_CM                11                 0xB              
 * 0x0119[6:4]   OUT3_AMPL              3                  0x3              
 * 0x011A[2:0]   OUT3_MUX_SEL           0                  0x0              
 * 0x011A[5:4]   OUT3_VDD_SEL           2                  0x2              
 * 0x011A[3]     OUT3_VDD_SEL_EN        1                  0x1              
 * 0x011A[7:6]   OUT3_INV               0                  0x0              
 * 0x011C[0]     OUT4_PDN               1                  0x1              
 * 0x011C[1]     OUT4_OE                0                  0x0              
 * 0x011C[2]     OUT4_RDIV_FORCE2       0                  0x0              
 * 0x011D[2:0]   OUT4_FORMAT            1                  0x1              
 * 0x011D[3]     OUT4_SYNC_EN           1                  0x1              
 * 0x011D[5:4]   OUT4_DIS_STATE         0                  0x0              
 * 0x011D[7:6]   OUT4_CMOS_DRV          0                  0x0              
 * 0x011E[3:0]   OUT4_CM                11                 0xB              
 * 0x011E[6:4]   OUT4_AMPL              3                  0x3              
 * 0x011F[2:0]   OUT4_MUX_SEL           0                  0x0              
 * 0x011F[5:4]   OUT4_VDD_SEL           2                  0x2              
 * 0x011F[3]     OUT4_VDD_SEL_EN        1                  0x1              
 * 0x011F[7:6]   OUT4_INV               0                  0x0              
 * 0x0121[0]     OUT5_PDN               0                  0x0              
 * 0x0121[1]     OUT5_OE                1                  0x1              
 * 0x0121[2]     OUT5_RDIV_FORCE2       0                  0x0              
 * 0x0122[2:0]   OUT5_FORMAT            1                  0x1              
 * 0x0122[3]     OUT5_SYNC_EN           1                  0x1              
 * 0x0122[5:4]   OUT5_DIS_STATE         0                  0x0              
 * 0x0122[7:6]   OUT5_CMOS_DRV          0                  0x0              
 * 0x0123[3:0]   OUT5_CM                11                 0xB              
 * 0x0123[6:4]   OUT5_AMPL              3                  0x3              
 * 0x0124[2:0]   OUT5_MUX_SEL           1                  0x1              
 * 0x0124[5:4]   OUT5_VDD_SEL           2                  0x2              
 * 0x0124[3]     OUT5_VDD_SEL_EN        1                  0x1              
 * 0x0124[7:6]   OUT5_INV               0                  0x0              
 * 0x0126[0]     OUT6_PDN               1                  0x1              
 * 0x0126[1]     OUT6_OE                0                  0x0              
 * 0x0126[2]     OUT6_RDIV_FORCE2       0                  0x0              
 * 0x0127[2:0]   OUT6_FORMAT            1                  0x1              
 * 0x0127[3]     OUT6_SYNC_EN           1                  0x1              
 * 0x0127[5:4]   OUT6_DIS_STATE         0                  0x0              
 * 0x0127[7:6]   OUT6_CMOS_DRV          0                  0x0              
 * 0x0128[3:0]   OUT6_CM                11                 0xB              
 * 0x0128[6:4]   OUT6_AMPL              3                  0x3              
 * 0x0129[2:0]   OUT6_MUX_SEL           0                  0x0              
 * 0x0129[5:4]   OUT6_VDD_SEL           2                  0x2              
 * 0x0129[3]     OUT6_VDD_SEL_EN        1                  0x1              
 * 0x0129[7:6]   OUT6_INV               0                  0x0              
 * 0x012B[0]     OUT7_PDN               1                  0x1              
 * 0x012B[1]     OUT7_OE                0                  0x0              
 * 0x012B[2]     OUT7_RDIV_FORCE2       0                  0x0              
 * 0x012C[2:0]   OUT7_FORMAT            1                  0x1              
 * 0x012C[3]     OUT7_SYNC_EN           1                  0x1              
 * 0x012C[5:4]   OUT7_DIS_STATE         0                  0x0              
 * 0x012C[7:6]   OUT7_CMOS_DRV          0                  0x0              
 * 0x012D[3:0]   OUT7_CM                11                 0xB              
 * 0x012D[6:4]   OUT7_AMPL              3                  0x3              
 * 0x012E[2:0]   OUT7_MUX_SEL           0                  0x0              
 * 0x012E[5:4]   OUT7_VDD_SEL           2                  0x2              
 * 0x012E[3]     OUT7_VDD_SEL_EN        1                  0x1              
 * 0x012E[7:6]   OUT7_INV               0                  0x0              
 * 0x0130[0]     OUT8_PDN               0                  0x0              
 * 0x0130[1]     OUT8_OE                1                  0x1              
 * 0x0130[2]     OUT8_RDIV_FORCE2       0                  0x0              
 * 0x0131[2:0]   OUT8_FORMAT            1                  0x1              
 * 0x0131[3]     OUT8_SYNC_EN           1                  0x1              
 * 0x0131[5:4]   OUT8_DIS_STATE         0                  0x0              
 * 0x0131[7:6]   OUT8_CMOS_DRV          0                  0x0              
 * 0x0132[3:0]   OUT8_CM                11                 0xB              
 * 0x0132[6:4]   OUT8_AMPL              3                  0x3              
 * 0x0133[2:0]   OUT8_MUX_SEL           2                  0x2              
 * 0x0133[5:4]   OUT8_VDD_SEL           2                  0x2              
 * 0x0133[3]     OUT8_VDD_SEL_EN        1                  0x1              
 * 0x0133[7:6]   OUT8_INV               0                  0x0              
 * 0x013A[0]     OUT9_PDN               1                  0x1              
 * 0x013A[1]     OUT9_OE                0                  0x0              
 * 0x013A[2]     OUT9_RDIV_FORCE2       0                  0x0              
 * 0x013B[2:0]   OUT9_FORMAT            1                  0x1              
 * 0x013B[3]     OUT9_SYNC_EN           1                  0x1              
 * 0x013B[5:4]   OUT9_DIS_STATE         0                  0x0              
 * 0x013B[7:6]   OUT9_CMOS_DRV          0                  0x0              
 * 0x013C[3:0]   OUT9_CM                11                 0xB              
 * 0x013C[6:4]   OUT9_AMPL              3                  0x3              
 * 0x013D[2:0]   OUT9_MUX_SEL           0                  0x0              
 * 0x013D[5:4]   OUT9_VDD_SEL           2                  0x2              
 * 0x013D[3]     OUT9_VDD_SEL_EN        1                  0x1              
 * 0x013D[7:6]   OUT9_INV               0                  0x0              
 * 0x013F[11:0]  OUTX_ALWAYS_ON         0                  0x000            
 * 0x0141[1]     OUT_DIS_MSK            0                  0x0              
 * 0x0141[5]     OUT_DIS_LOL_MSK        0                  0x0              
 * 0x0141[6]     OUT_DIS_LOSXAXB_MSK    1                  0x1              
 * 0x0141[7]     OUT_DIS_MSK_LOS_PFD    0                  0x0              
 * 0x0142[1]     OUT_DIS_MSK_LOL        1                  0x1              
 * 0x0142[5]     OUT_DIS_MSK_HOLD       1                  0x1              
 * 0x0206[1:0]   PXAXB                  0                  0x0              
 * 0x0208[47:0]  P0_NUM                 1                  0x000000000001   
 * 0x020E[31:0]  P0_DEN                 1                  0x00000001       
 * 0x0212[47:0]  P1_NUM                 0                  0x000000000000   
 * 0x0218[31:0]  P1_DEN                 0                  0x00000000       
 * 0x021C[47:0]  P2_NUM                 0                  0x000000000000   
 * 0x0222[31:0]  P2_DEN                 0                  0x00000000       
 * 0x0226[47:0]  P3_NUM                 0                  0x000000000000   
 * 0x022C[31:0]  P3_DEN                 0                  0x00000000       
 * 0x0231[3:0]   P0_FRACN_MODE          11                 0xB              
 * 0x0231[4]     P0_FRACN_EN            0                  0x0              
 * 0x0232[3:0]   P1_FRACN_MODE          11                 0xB              
 * 0x0232[4]     P1_FRACN_EN            0                  0x0              
 * 0x0233[3:0]   P2_FRACN_MODE          11                 0xB              
 * 0x0233[4]     P2_FRACN_EN            0                  0x0              
 * 0x0234[3:0]   P3_FRACN_MODE          11                 0xB              
 * 0x0234[4]     P3_FRACN_EN            0                  0x0              
 * 0x0235[43:0]  MXAXB_NUM              916841299968       0x0D578000000    
 * 0x023B[31:0]  MXAXB_DEN              3489660928         0xD0000000       
 * 0x024A[23:0]  R0_REG                 10                 0x00000A         
 * 0x024D[23:0]  R1_REG                 0                  0x000000         
 * 0x0250[23:0]  R2_REG                 1                  0x000001         
 * 0x0253[23:0]  R3_REG                 0                  0x000000         
 * 0x0256[23:0]  R4_REG                 0                  0x000000         
 * 0x0259[23:0]  R5_REG                 2                  0x000002         
 * 0x025C[23:0]  R6_REG                 0                  0x000000         
 * 0x025F[23:0]  R7_REG                 0                  0x000000         
 * 0x0262[23:0]  R8_REG                 2                  0x000002         
 * 0x0268[23:0]  R9_REG                 0                  0x000000         
 * 0x026B[7:0]   DESIGN_ID0             73                 0x49             
 * 0x026C[7:0]   DESIGN_ID1             79                 0x4F             
 * 0x026D[7:0]   DESIGN_ID2             52                 0x34             
 * 0x026E[7:0]   DESIGN_ID3             75                 0x4B             
 * 0x026F[7:0]   DESIGN_ID4             43                 0x2B             
 * 0x0270[7:0]   DESIGN_ID5             0                  0x00             
 * 0x0271[7:0]   DESIGN_ID6             0                  0x00             
 * 0x0272[7:0]   DESIGN_ID7             0                  0x00             
 * 0x0294[7:4]   FASTLOCK_EXTEND_SCL    8                  0x8              
 * 0x0296[1]     LOL_SLW_VALWIN_SELX    0                  0x0              
 * 0x0297[1]     FASTLOCK_DLY_ONSW_EN   1                  0x1              
 * 0x0299[1]     FASTLOCK_DLY_ONLOL_EN  1                  0x1              
 * 0x029D[19:0]  FASTLOCK_DLY_ONLOL     3829               0x00EF5          
 * 0x02A9[19:0]  FASTLOCK_DLY_ONSW      9830               0x02666          
 * 0x02B7[3:2]   LOL_NOSIG_TIME         3                  0x3              
 * 0x0302[43:0]  N0_NUM                 49392123904        0x00B80000000    
 * 0x0308[31:0]  N0_DEN                 2147483648         0x80000000       
 * 0x030C[0]     N0_UPDATE              0                  0x0              
 * 0x030D[43:0]  N1_NUM                 198967296000       0x02E53600000    
 * 0x0313[31:0]  N1_DEN                 2147483648         0x80000000       
 * 0x0317[0]     N1_UPDATE              0                  0x0              
 * 0x0318[43:0]  N2_NUM                 48282730496        0x00B3DE00000    
 * 0x031E[31:0]  N2_DEN                 3145728000         0xBB800000       
 * 0x0322[0]     N2_UPDATE              0                  0x0              
 * 0x0323[43:0]  N3_NUM                 0                  0x00000000000    
 * 0x0329[31:0]  N3_DEN                 0                  0x00000000       
 * 0x032D[0]     N3_UPDATE              0                  0x0              
 * 0x032E[43:0]  N4_NUM                 0                  0x00000000000    
 * 0x0334[31:0]  N4_DEN                 0                  0x00000000       
 * 0x0338[0]     N4_UPDATE              0                  0x0              
 * 0x0338[1]     N_UPDATE               0                  0x0              
 * 0x0339[4:0]   N_FSTEP_MSK            31                 0x1F             
 * 0x033B[43:0]  N0_FSTEPW              0                  0x00000000000    
 * 0x0341[43:0]  N1_FSTEPW              0                  0x00000000000    
 * 0x0347[43:0]  N2_FSTEPW              0                  0x00000000000    
 * 0x034D[43:0]  N3_FSTEPW              0                  0x00000000000    
 * 0x0353[43:0]  N4_FSTEPW              0                  0x00000000000    
 * 0x0359[15:0]  N0_DELAY               0                  0x0000           
 * 0x035B[15:0]  N1_DELAY               0                  0x0000           
 * 0x035D[15:0]  N2_DELAY               0                  0x0000           
 * 0x035F[15:0]  N3_DELAY               0                  0x0000           
 * 0x0361[15:0]  N4_DELAY               0                  0x0000           
 * 0x0487[0]     ZDM_EN                 0                  0x0              
 * 0x0487[2:1]   ZDM_IN_SEL             0                  0x0              
 * 0x0487[4]     ZDM_AUTOSW_EN          0                  0x0              
 * 0x0502[4]     ADD_DIV256             0                  0x0              
 * 0x0508[5:0]   BW0_PLL                16                 0x10             
 * 0x0509[5:0]   BW1_PLL                24                 0x18             
 * 0x050A[5:0]   BW2_PLL                15                 0x0F             
 * 0x050B[5:0]   BW3_PLL                15                 0x0F             
 * 0x050C[5:0]   BW4_PLL                3                  0x03             
 * 0x050D[5:0]   BW5_PLL                7                  0x07             
 * 0x050E[5:0]   FASTLOCK_BW0_PLL       23                 0x17             
 * 0x050F[5:0]   FASTLOCK_BW1_PLL       40                 0x28             
 * 0x0510[5:0]   FASTLOCK_BW2_PLL       12                 0x0C             
 * 0x0511[5:0]   FASTLOCK_BW3_PLL       11                 0x0B             
 * 0x0512[5:0]   FASTLOCK_BW4_PLL       3                  0x03             
 * 0x0513[5:0]   FASTLOCK_BW5_PLL       7                  0x07             
 * 0x0515[55:0]  M_NUM                  271928338153472    0x00F75140000000 
 * 0x051C[31:0]  M_DEN                  2684354560         0xA0000000       
 * 0x0521[3:0]   M_FRAC_MODE            11                 0xB              
 * 0x0521[4]     M_FRAC_EN              1                  0x1              
 * 0x0521[5]     PLL_OUT_RATE_SEL       1                  0x1              
 * 0x052A[0]     IN_SEL_REGCTRL         1                  0x1              
 * 0x052A[3:1]   IN_SEL                 0                  0x0              
 * 0x052B[0]     FASTLOCK_AUTO_EN       1                  0x1              
 * 0x052B[1]     FASTLOCK_MAN           0                  0x0              
 * 0x052C[0]     HOLD_EN                1                  0x1              
 * 0x052C[3]     HOLD_RAMP_BYP          1                  0x1              
 * 0x052C[4]     HOLDEXIT_BW_SEL1       0                  0x0              
 * 0x052C[7:5]   RAMP_STEP_INTERVAL     0                  0x0              
 * 0x052D[1]     HOLD_RAMPBYP_NOHIST    1                  0x1              
 * 0x052E[4:0]   HOLD_HIST_LEN          21                 0x15             
 * 0x052F[4:0]   HOLD_HIST_DELAY        20                 0x14             
 * 0x0531[4:0]   HOLD_REF_COUNT_FRC     0                  0x00             
 * 0x0532[23:0]  HOLD_15M_CYC_COUNT     61791              0x00F15F         
 * 0x0535[0]     FORCE_HOLD             0                  0x0              
 * 0x0536[1:0]   CLK_SWITCH_MODE        0                  0x0              
 * 0x0536[2]     HSW_EN                 0                  0x0              
 * 0x0537[3:0]   IN_LOS_MSK             0                  0x0              
 * 0x0537[7:4]   IN_OOF_MSK             0                  0x0              
 * 0x0538[2:0]   IN0_PRIORITY           0                  0x0              
 * 0x0538[6:4]   IN1_PRIORITY           0                  0x0              
 * 0x0539[2:0]   IN2_PRIORITY           0                  0x0              
 * 0x0539[6:4]   IN3_PRIORITY           0                  0x0              
 * 0x053A[1:0]   HSW_MODE               2                  0x2              
 * 0x053A[3:2]   HSW_PHMEAS_CTRL        0                  0x0              
 * 0x053B[9:0]   HSW_PHMEAS_THR         3                  0x003            
 * 0x053D[4:0]   HSW_COARSE_PM_LEN      18                 0x12             
 * 0x053E[4:0]   HSW_COARSE_PM_DLY      6                  0x06             
 * 0x0589[12:0]  CAP_SHORT_DELAY        1010               0x03F2           
 * 0x059B[4]     HOLD_PRESERVE_HIST     1                  0x1              
 * 0x059B[5]     HOLD_FRZ_WITH_INTONLY  1                  0x1              
 * 0x059B[6]     HOLDEXIT_BW_SEL0       1                  0x1              
 * 0x059B[7]     HOLDEXIT_STD_BO        1                  0x1              
 * 0x059D[5:0]   HOLDEXIT_BW0           23                 0x17             
 * 0x059E[5:0]   HOLDEXIT_BW1           40                 0x28             
 * 0x059F[5:0]   HOLDEXIT_BW2           12                 0x0C             
 * 0x05A0[5:0]   HOLDEXIT_BW3           11                 0x0B             
 * 0x05A1[5:0]   HOLDEXIT_BW4           3                  0x03             
 * 0x05A2[5:0]   HOLDEXIT_BW5           7                  0x07             
 * 0x05A6[2:0]   RAMP_STEP_SIZE         0                  0x0              
 * 0x05A6[3]     RAMP_SWITCH_EN         0                  0x0              
 * 0x0802[15:0]  FIXREGSA0              1333               0x0535           
 * 0x0804[7:0]   FIXREGSD0              0                  0x00             
 * 0x0805[15:0]  FIXREGSA1              0                  0x0000           
 * 0x0807[7:0]   FIXREGSD1              0                  0x00             
 * 0x0808[15:0]  FIXREGSA2              0                  0x0000           
 * 0x080A[7:0]   FIXREGSD2              0                  0x00             
 * 0x080B[15:0]  FIXREGSA3              0                  0x0000           
 * 0x080D[7:0]   FIXREGSD3              0                  0x00             
 * 0x080E[15:0]  FIXREGSA4              0                  0x0000           
 * 0x0810[7:0]   FIXREGSD4              0                  0x00             
 * 0x0811[15:0]  FIXREGSA5              0                  0x0000           
 * 0x0813[7:0]   FIXREGSD5              0                  0x00             
 * 0x0814[15:0]  FIXREGSA6              0                  0x0000           
 * 0x0816[7:0]   FIXREGSD6              0                  0x00             
 * 0x0817[15:0]  FIXREGSA7              0                  0x0000           
 * 0x0819[7:0]   FIXREGSD7              0                  0x00             
 * 0x081A[15:0]  FIXREGSA8              0                  0x0000           
 * 0x081C[7:0]   FIXREGSD8              0                  0x00             
 * 0x081D[15:0]  FIXREGSA9              0                  0x0000           
 * 0x081F[7:0]   FIXREGSD9              0                  0x00             
 * 0x0820[15:0]  FIXREGSA10             0                  0x0000           
 * 0x0822[7:0]   FIXREGSD10             0                  0x00             
 * 0x0823[15:0]  FIXREGSA11             0                  0x0000           
 * 0x0825[7:0]   FIXREGSD11             0                  0x00             
 * 0x0826[15:0]  FIXREGSA12             0                  0x0000           
 * 0x0828[7:0]   FIXREGSD12             0                  0x00             
 * 0x0829[15:0]  FIXREGSA13             0                  0x0000           
 * 0x082B[7:0]   FIXREGSD13             0                  0x00             
 * 0x082C[15:0]  FIXREGSA14             0                  0x0000           
 * 0x082E[7:0]   FIXREGSD14             0                  0x00             
 * 0x082F[15:0]  FIXREGSA15             0                  0x0000           
 * 0x0831[7:0]   FIXREGSD15             0                  0x00             
 * 0x0832[15:0]  FIXREGSA16             0                  0x0000           
 * 0x0834[7:0]   FIXREGSD16             0                  0x00             
 * 0x0835[15:0]  FIXREGSA17             0                  0x0000           
 * 0x0837[7:0]   FIXREGSD17             0                  0x00             
 * 0x0838[15:0]  FIXREGSA18             0                  0x0000           
 * 0x083A[7:0]   FIXREGSD18             0                  0x00             
 * 0x083B[15:0]  FIXREGSA19             0                  0x0000           
 * 0x083D[7:0]   FIXREGSD19             0                  0x00             
 * 0x083E[15:0]  FIXREGSA20             0                  0x0000           
 * 0x0840[7:0]   FIXREGSD20             0                  0x00             
 * 0x0841[15:0]  FIXREGSA21             0                  0x0000           
 * 0x0843[7:0]   FIXREGSD21             0                  0x00             
 * 0x0844[15:0]  FIXREGSA22             0                  0x0000           
 * 0x0846[7:0]   FIXREGSD22             0                  0x00             
 * 0x0847[15:0]  FIXREGSA23             0                  0x0000           
 * 0x0849[7:0]   FIXREGSD23             0                  0x00             
 * 0x084A[15:0]  FIXREGSA24             0                  0x0000           
 * 0x084C[7:0]   FIXREGSD24             0                  0x00             
 * 0x084D[15:0]  FIXREGSA25             0                  0x0000           
 * 0x084F[7:0]   FIXREGSD25             0                  0x00             
 * 0x0850[15:0]  FIXREGSA26             0                  0x0000           
 * 0x0852[7:0]   FIXREGSD26             0                  0x00             
 * 0x0853[15:0]  FIXREGSA27             0                  0x0000           
 * 0x0855[7:0]   FIXREGSD27             0                  0x00             
 * 0x0856[15:0]  FIXREGSA28             0                  0x0000           
 * 0x0858[7:0]   FIXREGSD28             0                  0x00             
 * 0x0859[15:0]  FIXREGSA29             0                  0x0000           
 * 0x085B[7:0]   FIXREGSD29             0                  0x00             
 * 0x085C[15:0]  FIXREGSA30             0                  0x0000           
 * 0x085E[7:0]   FIXREGSD30             0                  0x00             
 * 0x085F[15:0]  FIXREGSA31             0                  0x0000           
 * 0x0861[7:0]   FIXREGSD31             0                  0x00             
 * 0x090E[0]     XAXB_EXTCLK_EN         1                  0x1              
 * 0x0943[0]     IO_VDD_SEL             0                  0x0              
 * 0x0949[3:0]   IN_EN                  1                  0x1              
 * 0x0949[7:4]   IN_PULSED_CMOS_EN      3                  0x3              
 * 0x094A[3:0]   INX_TO_PFD_EN          1                  0x1              
 * 0x094E[11:0]  REFCLK_HYS_SEL         585                0x249            
 * 0x095E[0]     MXAXB_INTEGER          0                  0x0              
 * 0x0A02[4:0]   N_ADD_0P5              0                  0x00             
 * 0x0A03[4:0]   N_CLK_TO_OUTX_EN       7                  0x07             
 * 0x0A04[4:0]   N_PIBYP                1                  0x01             
 * 0x0A05[4:0]   N_PDNB                 7                  0x07             
 * 0x0A14[3]     N0_HIGH_FREQ           0                  0x0              
 * 0x0A1A[3]     N1_HIGH_FREQ           0                  0x0              
 * 0x0A20[3]     N2_HIGH_FREQ           0                  0x0              
 * 0x0A26[3]     N3_HIGH_FREQ           0                  0x0              
 * 0x0A2C[3]     N4_HIGH_FREQ           0                  0x0              
 * 0x0B44[3:0]   PDIV_FRACN_CLK_DIS     15                 0xF              
 * 0x0B44[5]     FRACN_CLK_DIS_PLL      0                  0x0              
 * 0x0B46[3:0]   LOS_CLK_DIS            0                  0x0              
 * 0x0B47[4:0]   OOF_CLK_DIS            14                 0x0E             
 * 0x0B48[4:0]   OOF_DIV_CLK_DIS        14                 0x0E             
 * 0x0B4A[4:0]   N_CLK_DIS              24                 0x18             
 * 0x0B57[11:0]  VCO_RESET_CALCODE      249                0x0F9
 * 
 *
 */


static struct ntv2_genlock_data s_genlock_1125_2400[] =
{
	/* Start configuration preamble */
	{ 0x0B24, 0xC0 },
	{ 0x0B25, 0x00 },
	{ 0x0540, 0x01 },
	/* End configuration preamble */

	/* Delay 300 msec */
	/*    Delay is worst case time for device to complete any calibration */
	/*    that is running due to device state change previous to this script */
	/*    being processed. */
	{ 0x0000, 0x01 },

	/* Start configuration registers */
	{ 0x000B, 0x64 },
	{ 0x0016, 0x02 },
	{ 0x0017, 0xFC },
	{ 0x0018, 0xFF },
	{ 0x0019, 0xDF },
	{ 0x001A, 0xDF },
	{ 0x002B, 0x02 },
	{ 0x002C, 0x01 },
	{ 0x002D, 0x02 },
	{ 0x002E, 0x7D },
	{ 0x002F, 0x09 },
	{ 0x0030, 0x00 },
	{ 0x0031, 0x00 },
	{ 0x0032, 0x00 },
	{ 0x0033, 0x00 },
	{ 0x0034, 0x00 },
	{ 0x0035, 0x00 },
	{ 0x0036, 0xB3 },
	{ 0x0037, 0x08 },
	{ 0x0038, 0x00 },
	{ 0x0039, 0x00 },
	{ 0x003A, 0x00 },
	{ 0x003B, 0x00 },
	{ 0x003C, 0x00 },
	{ 0x003D, 0x00 },
	{ 0x003F, 0x01 },
	{ 0x0040, 0x04 },
	{ 0x0041, 0x01 },
	{ 0x0042, 0x00 },
	{ 0x0043, 0x00 },
	{ 0x0044, 0x00 },
	{ 0x0045, 0x0C },
	{ 0x0046, 0x96 },
	{ 0x0047, 0x00 },
	{ 0x0048, 0x00 },
	{ 0x0049, 0x00 },
	{ 0x004A, 0x4B },
	{ 0x004B, 0x00 },
	{ 0x004C, 0x00 },
	{ 0x004D, 0x00 },
	{ 0x004E, 0x05 },
	{ 0x004F, 0x00 },
	{ 0x0050, 0x0F },
	{ 0x0051, 0x00 },
	{ 0x0052, 0x00 },
	{ 0x0053, 0x00 },
	{ 0x0054, 0x00 },
	{ 0x0055, 0x00 },
	{ 0x0056, 0x00 },
	{ 0x0057, 0x00 },
	{ 0x0058, 0x00 },
	{ 0x0059, 0x01 },
	{ 0x005A, 0xF9 },
	{ 0x005B, 0x39 },
	{ 0x005C, 0x10 },
	{ 0x005D, 0x01 },
	{ 0x005E, 0x00 },
	{ 0x005F, 0x00 },
	{ 0x0060, 0x00 },
	{ 0x0061, 0x00 },
	{ 0x0062, 0x00 },
	{ 0x0063, 0x00 },
	{ 0x0064, 0x00 },
	{ 0x0065, 0x00 },
	{ 0x0066, 0x00 },
	{ 0x0067, 0x00 },
	{ 0x0068, 0x00 },
	{ 0x0069, 0x00 },
	{ 0x0092, 0x02 },
	{ 0x0093, 0xA0 },
	{ 0x0095, 0x00 },
	{ 0x0096, 0x90 },
	{ 0x0098, 0x70 },
	{ 0x009A, 0x02 },
	{ 0x009B, 0x50 },
	{ 0x009D, 0x04 },
	{ 0x009E, 0x60 },
	{ 0x00A0, 0x30 },
	{ 0x00A2, 0x00 },
	{ 0x00A9, 0x6E },
	{ 0x00AA, 0xB1 },
	{ 0x00AB, 0x04 },
	{ 0x00AC, 0x00 },
	{ 0x00E5, 0x21 },
	{ 0x00EA, 0xD1 },
	{ 0x00EB, 0xB1 },
	{ 0x00EC, 0x03 },
	{ 0x00ED, 0x00 },
	{ 0x0102, 0x01 },
	{ 0x0108, 0x02 },
	{ 0x0109, 0x09 },
	{ 0x010A, 0x3B },
	{ 0x010B, 0x28 },
	{ 0x010D, 0x01 },
	{ 0x010E, 0x09 },
	{ 0x010F, 0x3B },
	{ 0x0110, 0x28 },
	{ 0x0112, 0x02 },
	{ 0x0113, 0x09 },
	{ 0x0114, 0x3B },
	{ 0x0115, 0x28 },
	{ 0x0117, 0x01 },
	{ 0x0118, 0x09 },
	{ 0x0119, 0x3B },
	{ 0x011A, 0x28 },
	{ 0x011C, 0x01 },
	{ 0x011D, 0x09 },
	{ 0x011E, 0x3B },
	{ 0x011F, 0x28 },
	{ 0x0121, 0x02 },
	{ 0x0122, 0x09 },
	{ 0x0123, 0x3B },
	{ 0x0124, 0x29 },
	{ 0x0126, 0x01 },
	{ 0x0127, 0x09 },
	{ 0x0128, 0x3B },
	{ 0x0129, 0x28 },
	{ 0x012B, 0x01 },
	{ 0x012C, 0x09 },
	{ 0x012D, 0x3B },
	{ 0x012E, 0x28 },
	{ 0x0130, 0x02 },
	{ 0x0131, 0x09 },
	{ 0x0132, 0x3B },
	{ 0x0133, 0x2A },
	{ 0x013A, 0x01 },
	{ 0x013B, 0x09 },
	{ 0x013C, 0x3B },
	{ 0x013D, 0x28 },
	{ 0x013F, 0x00 },
	{ 0x0140, 0x00 },
	{ 0x0141, 0x40 },
	{ 0x0142, 0xFF },
	{ 0x0206, 0x00 },
	{ 0x0208, 0x01 },
	{ 0x0209, 0x00 },
	{ 0x020A, 0x00 },
	{ 0x020B, 0x00 },
	{ 0x020C, 0x00 },
	{ 0x020D, 0x00 },
	{ 0x020E, 0x01 },
	{ 0x020F, 0x00 },
	{ 0x0210, 0x00 },
	{ 0x0211, 0x00 },
	{ 0x0212, 0x00 },
	{ 0x0213, 0x00 },
	{ 0x0214, 0x00 },
	{ 0x0215, 0x00 },
	{ 0x0216, 0x00 },
	{ 0x0217, 0x00 },
	{ 0x0218, 0x00 },
	{ 0x0219, 0x00 },
	{ 0x021A, 0x00 },
	{ 0x021B, 0x00 },
	{ 0x021C, 0x00 },
	{ 0x021D, 0x00 },
	{ 0x021E, 0x00 },
	{ 0x021F, 0x00 },
	{ 0x0220, 0x00 },
	{ 0x0221, 0x00 },
	{ 0x0222, 0x00 },
	{ 0x0223, 0x00 },
	{ 0x0224, 0x00 },
	{ 0x0225, 0x00 },
	{ 0x0226, 0x00 },
	{ 0x0227, 0x00 },
	{ 0x0228, 0x00 },
	{ 0x0229, 0x00 },
	{ 0x022A, 0x00 },
	{ 0x022B, 0x00 },
	{ 0x022C, 0x00 },
	{ 0x022D, 0x00 },
	{ 0x022E, 0x00 },
	{ 0x022F, 0x00 },
	{ 0x0231, 0x0B },
	{ 0x0232, 0x0B },
	{ 0x0233, 0x0B },
	{ 0x0234, 0x0B },
	{ 0x0235, 0x00 },
	{ 0x0236, 0x00 },
	{ 0x0237, 0x00 },
	{ 0x0238, 0x78 },
	{ 0x0239, 0xD5 },
	{ 0x023A, 0x00 },
	{ 0x023B, 0x00 },
	{ 0x023C, 0x00 },
	{ 0x023D, 0x00 },
	{ 0x023E, 0xD0 },
	{ 0x024A, 0x0A },
	{ 0x024B, 0x00 },
	{ 0x024C, 0x00 },
	{ 0x024D, 0x00 },
	{ 0x024E, 0x00 },
	{ 0x024F, 0x00 },
	{ 0x0250, 0x01 },
	{ 0x0251, 0x00 },
	{ 0x0252, 0x00 },
	{ 0x0253, 0x00 },
	{ 0x0254, 0x00 },
	{ 0x0255, 0x00 },
	{ 0x0256, 0x00 },
	{ 0x0257, 0x00 },
	{ 0x0258, 0x00 },
	{ 0x0259, 0x02 },
	{ 0x025A, 0x00 },
	{ 0x025B, 0x00 },
	{ 0x025C, 0x00 },
	{ 0x025D, 0x00 },
	{ 0x025E, 0x00 },
	{ 0x025F, 0x00 },
	{ 0x0260, 0x00 },
	{ 0x0261, 0x00 },
	{ 0x0262, 0x02 },
	{ 0x0263, 0x00 },
	{ 0x0264, 0x00 },
	{ 0x0268, 0x00 },
	{ 0x0269, 0x00 },
	{ 0x026A, 0x00 },
	{ 0x026B, 0x49 },
	{ 0x026C, 0x4F },
	{ 0x026D, 0x34 },
	{ 0x026E, 0x4B },
	{ 0x026F, 0x2B },
	{ 0x0270, 0x00 },
	{ 0x0271, 0x00 },
	{ 0x0272, 0x00 },
	{ 0x0294, 0x80 },
	{ 0x0296, 0x00 },
	{ 0x0297, 0x02 },
	{ 0x0299, 0x02 },
	{ 0x029D, 0xF5 },
	{ 0x029E, 0x0E },
	{ 0x029F, 0x00 },
	{ 0x02A9, 0x66 },
	{ 0x02AA, 0x26 },
	{ 0x02AB, 0x00 },
	{ 0x02B7, 0xFF },
	{ 0x0302, 0x00 },
	{ 0x0303, 0x00 },
	{ 0x0304, 0x00 },
	{ 0x0305, 0x80 },
	{ 0x0306, 0x0B },
	{ 0x0307, 0x00 },
	{ 0x0308, 0x00 },
	{ 0x0309, 0x00 },
	{ 0x030A, 0x00 },
	{ 0x030B, 0x80 },
	{ 0x030C, 0x00 },
	{ 0x030D, 0x00 },
	{ 0x030E, 0x00 },
	{ 0x030F, 0x60 },
	{ 0x0310, 0x53 },
	{ 0x0311, 0x2E },
	{ 0x0312, 0x00 },
	{ 0x0313, 0x00 },
	{ 0x0314, 0x00 },
	{ 0x0315, 0x00 },
	{ 0x0316, 0x80 },
	{ 0x0317, 0x00 },
	{ 0x0318, 0x00 },
	{ 0x0319, 0x00 },
	{ 0x031A, 0xE0 },
	{ 0x031B, 0x3D },
	{ 0x031C, 0x0B },
	{ 0x031D, 0x00 },
	{ 0x031E, 0x00 },
	{ 0x031F, 0x00 },
	{ 0x0320, 0x80 },
	{ 0x0321, 0xBB },
	{ 0x0322, 0x00 },
	{ 0x0323, 0x00 },
	{ 0x0324, 0x00 },
	{ 0x0325, 0x00 },
	{ 0x0326, 0x00 },
	{ 0x0327, 0x00 },
	{ 0x0328, 0x00 },
	{ 0x0329, 0x00 },
	{ 0x032A, 0x00 },
	{ 0x032B, 0x00 },
	{ 0x032C, 0x00 },
	{ 0x032D, 0x00 },
	{ 0x032E, 0x00 },
	{ 0x032F, 0x00 },
	{ 0x0330, 0x00 },
	{ 0x0331, 0x00 },
	{ 0x0332, 0x00 },
	{ 0x0333, 0x00 },
	{ 0x0334, 0x00 },
	{ 0x0335, 0x00 },
	{ 0x0336, 0x00 },
	{ 0x0337, 0x00 },
	{ 0x0338, 0x00 },
	{ 0x0339, 0x1F },
	{ 0x033B, 0x00 },
	{ 0x033C, 0x00 },
	{ 0x033D, 0x00 },
	{ 0x033E, 0x00 },
	{ 0x033F, 0x00 },
	{ 0x0340, 0x00 },
	{ 0x0341, 0x00 },
	{ 0x0342, 0x00 },
	{ 0x0343, 0x00 },
	{ 0x0344, 0x00 },
	{ 0x0345, 0x00 },
	{ 0x0346, 0x00 },
	{ 0x0347, 0x00 },
	{ 0x0348, 0x00 },
	{ 0x0349, 0x00 },
	{ 0x034A, 0x00 },
	{ 0x034B, 0x00 },
	{ 0x034C, 0x00 },
	{ 0x034D, 0x00 },
	{ 0x034E, 0x00 },
	{ 0x034F, 0x00 },
	{ 0x0350, 0x00 },
	{ 0x0351, 0x00 },
	{ 0x0352, 0x00 },
	{ 0x0353, 0x00 },
	{ 0x0354, 0x00 },
	{ 0x0355, 0x00 },
	{ 0x0356, 0x00 },
	{ 0x0357, 0x00 },
	{ 0x0358, 0x00 },
	{ 0x0359, 0x00 },
	{ 0x035A, 0x00 },
	{ 0x035B, 0x00 },
	{ 0x035C, 0x00 },
	{ 0x035D, 0x00 },
	{ 0x035E, 0x00 },
	{ 0x035F, 0x00 },
	{ 0x0360, 0x00 },
	{ 0x0361, 0x00 },
	{ 0x0362, 0x00 },
	{ 0x0487, 0x00 },
	{ 0x0502, 0x01 },
	{ 0x0508, 0x10 },
	{ 0x0509, 0x18 },
	{ 0x050A, 0x0F },
	{ 0x050B, 0x0F },
	{ 0x050C, 0x03 },
	{ 0x050D, 0x07 },
	{ 0x050E, 0x17 },
	{ 0x050F, 0x28 },
	{ 0x0510, 0x0C },
	{ 0x0511, 0x0B },
	{ 0x0512, 0x03 },
	{ 0x0513, 0x07 },
	{ 0x0515, 0x00 },
	{ 0x0516, 0x00 },
	{ 0x0517, 0x00 },
	{ 0x0518, 0x00 },
	{ 0x0519, 0xA8 },
	{ 0x051A, 0xC5 },
	{ 0x051B, 0x00 },
	{ 0x051C, 0x00 },
	{ 0x051D, 0x00 },
	{ 0x051E, 0x00 },
	{ 0x051F, 0x80 },
	{ 0x0521, 0x2B },
	{ 0x052A, 0x01 },
	{ 0x052B, 0x01 },
	{ 0x052C, 0x0F },
	{ 0x052D, 0x03 },
	{ 0x052E, 0x15 },
	{ 0x052F, 0x14 },
	{ 0x0531, 0x00 },
	{ 0x0532, 0x21 },
	{ 0x0533, 0xF1 },
	{ 0x0534, 0x00 },
	{ 0x0535, 0x00 },
	{ 0x0536, 0x00 },
	{ 0x0537, 0x00 },
	{ 0x0538, 0x00 },
	{ 0x0539, 0x00 },
	{ 0x053A, 0x02 },
	{ 0x053B, 0x03 },
	{ 0x053C, 0x00 },
	{ 0x053D, 0x12 },
	{ 0x053E, 0x06 },
	{ 0x0589, 0xF1 },
	{ 0x058A, 0x03 },
	{ 0x059B, 0xF8 },
	{ 0x059D, 0x17 },
	{ 0x059E, 0x28 },
	{ 0x059F, 0x0C },
	{ 0x05A0, 0x0B },
	{ 0x05A1, 0x03 },
	{ 0x05A2, 0x07 },
	{ 0x05A6, 0x00 },
	{ 0x0802, 0x35 },
	{ 0x0803, 0x05 },
	{ 0x0804, 0x00 },
	{ 0x0805, 0x00 },
	{ 0x0806, 0x00 },
	{ 0x0807, 0x00 },
	{ 0x0808, 0x00 },
	{ 0x0809, 0x00 },
	{ 0x080A, 0x00 },
	{ 0x080B, 0x00 },
	{ 0x080C, 0x00 },
	{ 0x080D, 0x00 },
	{ 0x080E, 0x00 },
	{ 0x080F, 0x00 },
	{ 0x0810, 0x00 },
	{ 0x0811, 0x00 },
	{ 0x0812, 0x00 },
	{ 0x0813, 0x00 },
	{ 0x0814, 0x00 },
	{ 0x0815, 0x00 },
	{ 0x0816, 0x00 },
	{ 0x0817, 0x00 },
	{ 0x0818, 0x00 },
	{ 0x0819, 0x00 },
	{ 0x081A, 0x00 },
	{ 0x081B, 0x00 },
	{ 0x081C, 0x00 },
	{ 0x081D, 0x00 },
	{ 0x081E, 0x00 },
	{ 0x081F, 0x00 },
	{ 0x0820, 0x00 },
	{ 0x0821, 0x00 },
	{ 0x0822, 0x00 },
	{ 0x0823, 0x00 },
	{ 0x0824, 0x00 },
	{ 0x0825, 0x00 },
	{ 0x0826, 0x00 },
	{ 0x0827, 0x00 },
	{ 0x0828, 0x00 },
	{ 0x0829, 0x00 },
	{ 0x082A, 0x00 },
	{ 0x082B, 0x00 },
	{ 0x082C, 0x00 },
	{ 0x082D, 0x00 },
	{ 0x082E, 0x00 },
	{ 0x082F, 0x00 },
	{ 0x0830, 0x00 },
	{ 0x0831, 0x00 },
	{ 0x0832, 0x00 },
	{ 0x0833, 0x00 },
	{ 0x0834, 0x00 },
	{ 0x0835, 0x00 },
	{ 0x0836, 0x00 },
	{ 0x0837, 0x00 },
	{ 0x0838, 0x00 },
	{ 0x0839, 0x00 },
	{ 0x083A, 0x00 },
	{ 0x083B, 0x00 },
	{ 0x083C, 0x00 },
	{ 0x083D, 0x00 },
	{ 0x083E, 0x00 },
	{ 0x083F, 0x00 },
	{ 0x0840, 0x00 },
	{ 0x0841, 0x00 },
	{ 0x0842, 0x00 },
	{ 0x0843, 0x00 },
	{ 0x0844, 0x00 },
	{ 0x0845, 0x00 },
	{ 0x0846, 0x00 },
	{ 0x0847, 0x00 },
	{ 0x0848, 0x00 },
	{ 0x0849, 0x00 },
	{ 0x084A, 0x00 },
	{ 0x084B, 0x00 },
	{ 0x084C, 0x00 },
	{ 0x084D, 0x00 },
	{ 0x084E, 0x00 },
	{ 0x084F, 0x00 },
	{ 0x0850, 0x00 },
	{ 0x0851, 0x00 },
	{ 0x0852, 0x00 },
	{ 0x0853, 0x00 },
	{ 0x0854, 0x00 },
	{ 0x0855, 0x00 },
	{ 0x0856, 0x00 },
	{ 0x0857, 0x00 },
	{ 0x0858, 0x00 },
	{ 0x0859, 0x00 },
	{ 0x085A, 0x00 },
	{ 0x085B, 0x00 },
	{ 0x085C, 0x00 },
	{ 0x085D, 0x00 },
	{ 0x085E, 0x00 },
	{ 0x085F, 0x00 },
	{ 0x0860, 0x00 },
	{ 0x0861, 0x00 },
	{ 0x090E, 0x03 },
	{ 0x0943, 0x00 },
	{ 0x0949, 0x31 },
	{ 0x094A, 0x01 },
	{ 0x094E, 0x49 },
	{ 0x094F, 0x02 },
	{ 0x095E, 0x00 },
	{ 0x0A02, 0x00 },
	{ 0x0A03, 0x07 },
	{ 0x0A04, 0x01 },
	{ 0x0A05, 0x07 },
	{ 0x0A14, 0x00 },
	{ 0x0A1A, 0x00 },
	{ 0x0A20, 0x00 },
	{ 0x0A26, 0x00 },
	{ 0x0A2C, 0x00 },
	{ 0x0B44, 0x2F },
	{ 0x0B46, 0x00 },
	{ 0x0B47, 0x0E },
	{ 0x0B48, 0x0E },
	{ 0x0B4A, 0x18 },
	{ 0x0B57, 0xF9 },
	{ 0x0B58, 0x00 },
	/* End configuration registers */

	/* Start configuration postamble */
	{ 0x0514, 0x01 },
	{ 0x001C, 0x01 },
	{ 0x0540, 0x00 },
	{ 0x0B24, 0xC3 },
	{ 0x0B25, 0x02 },
	/* End configuration postamble */

	{ 0x0000, 0x00 }
};

/*
 * Design Report
 *
 * Overview
 * ========
 * Part:         Si5345 Rev D
 * Project File: C:\XilinxProjects\flint_tr051017\genlock\FormatFiles\IO4K+_1125_5994.slabtimeproj
 * Design ID:    IO4K+
 * Created By:   ClockBuilder Pro v2.16.1 [2017-07-19]
 * Timestamp:    2017-08-24 16:39:11 GMT-07:00
 * 
 * Design Notes
 * ============
 * assumes NTSC HSYNC (pulsed) input = (30/1.001)*525
 * 
 * Design Rule Check
 * =================
 * Errors:
 * - No errors
 * 
 * Warnings:
 * - Pulsed LVCMOS input buffer mode has been selected. This mode has non-standard input voltage logic thresholds: 0.33 V for Vil (max) and 0.49 V for Vih (min). Select this mode only if your input clock has a duty cycle significantly less or more than 50%.  Refer to the device datasheet for the exact threshold voltage specifications and the input attenuator circuit (DC coupled Pulsed LVCMOS) in the Family Reference Manual.
 * 
 * Device Grade
 * ============
 * Maximum Output Frequency: 148.5 MHz
 * Frequency Synthesis Mode: Fractional
 * Minimum Base OPN:         Si5345B
 * Actual Base OPN:          Si5345B
 * 
 * Base       Output Clock         Supported Frequency Synthesis Modes
 * OPN Grade  Frequency Range      (Typical Jitter)
 * ---------  -------------------  --------------------------------------------
 * Si5345A    100 Hz to 1.028 GHz  Integer (< 100 fs) and fractional (< 150 fs)
 * Si5345B    100 Hz to 350 MHz    "
 * Si5345C    100 Hz to 1.028 GHz  Integer only (< 100 fs)
 * Si5345D    100 Hz to 350 MHz    "
 * 
 * Design
 * ======
 * Host Interface:
 *    I/O Power Supply: VDD (Core)
 *    SPI Mode: 4-Wire
 *    I2C Address Range: 100d to 103d / 0x64 to 0x67 (selected via A0/A1 pins)
 * 
 * XA/XB:
 *    52 MHz (XO - External Oscillator)
 * 
 * Inputs:
 *     IN0: 27 kHz
 *          [ (24)*1125 ]
 *          Pulsed LVCMOS
 *     IN1: Unused
 *     IN2: Unused
 *     IN3: Unused
 * 
 * Outputs:
 *    OUT0: 27 MHz
 *          Enabled, LVDS 2.5 V
 *    OUT1: Unused
 *    OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT3: Unused
 *    OUT4: Unused
 *    OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT6: Unused
 *    OUT7: Unused
 *    OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *          [ 148.5/1.001 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT9: Unused
 * 
 * Frequency Plan
 * ==============
 * Priority: maximize the number of low jitter outputs
 * 
 * Fvco = 13.662 GHz [ 13 + 331/500 GHz ]
 * Fpfd = 27 kHz
 * Fms0 = 594 MHz
 * Fms1 = 147.456 MHz [ 147 + 57/125 MHz ]
 * Fms2 = 890.1098901098901098... MHz [ 890 + 10/91 MHz ]
 * 
 * P dividers:
 *    P0  = 1
 *    P1  = Unused
 *    P2  = Unused
 *    P3  = Unused
 *    Pxaxb = 1
 * 
 * MXAXB = 262.7307692307692307... [ 262 + 19/26 ]
 * M = 101200
 * N dividers:
 *    N0:
 *       Value: 23
 *       Skew:  0.000 s
 *       OUT0: 27 MHz
 *       OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *    N1:
 *       Value: 92.6513671875 [ 92 + 667/1024 ]
 *       Skew:  0.000 s
 *       OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *    N2:
 *       Value: 15.3486666666666666... [ 15 + 523/1500 ]
 *       Skew:  0.000 s
 *       OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *    N3:
 *       Unused
 *    N4:
 *       Unused
 * 
 * R dividers:
 *    R0 = 22
 *    R1 = Unused
 *    R2 = 4
 *    R3 = Unused
 *    R4 = Unused
 *    R5 = 6
 *    R6 = Unused
 *    R7 = Unused
 *    R8 = 6
 *    R9 = Unused
 * 
 * Nominal Bandwidth:
 *   Desired: 1.000 Hz
 *   Actual:  519.459 mHz
 *   Coefficients:
 *      BW0:  16
 *      BW1:  24
 *      BW2:  15
 *      BW3:  15
 *      BW4:  3
 *      BW5:  7
 * Fastlock Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  81.164 Hz
 *   Coefficients:
 *      BW0:  23
 *      BW1:  40
 *      BW2:  12
 *      BW3:  11
 *      BW4:  3
 *      BW5:  7
 * Holdover Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  81.164 Hz
 *   Coefficients:
 *      BW0:  23
 *      BW1:  40
 *      BW2:  12
 *      BW3:  11
 *      BW4:  3
 *      BW5:  7
 * 
 * Dividers listed above show effective values. These values are translated to register settings by ClockBuilder Pro. For the actual register values, see below. Refer to the Family Reference Manual for information on registers related to frequency plan.
 * 
 * Digitally Controlled Oscillator (DCO)
 * =====================================
 * Mode: Register Direct Write
 * 
 * N0: DCO Disabled
 * 
 * N1: DCO Disabled
 * 
 * N2: DCO Disabled
 * 
 * N3: DCO Disabled
 * 
 * N4: DCO Disabled
 * 
 * Estimated Power & Junction Temperature
 * ======================================
 * Assumptions:
 * 
 * Revision: D
 * VDD:      1.8 V
 * Ta:       70 C
 * Airflow:  None
 * 
 * Total Power: 808 mW, On Chip Power: 784 mW, Tj: 87 C
 * 
 *                 Frequency  Format   Voltage   Current     Power
 *         -----------------  ------  --------  --------  --------
 * VDD                                   1.8 V  147.9 mA    266 mW
 * VDDA                                  3.3 V  117.4 mA    387 mW
 * VDDO0              27 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO1              Unused                                      
 * VDDO2           148.5 MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO3              Unused                                      
 * VDDO4              Unused                                      
 * VDDO5          24.576 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO6              Unused                                      
 * VDDO7              Unused                                      
 * VDDO8   148.351648... MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO9              Unused                                      
 *                                              --------  --------
 *                                       Total  327.2 mA    808 mW
 * 
 * Note:
 * 
 * -Total power includes on- and off-chip power. This is a typical value and estimate only.
 * -Use an EVB for a more exact power measurement
 * -On-chip power excludes power dissipated in external terminations.
 * -Tj is junction temperature. Tj must be less than 125 C (on Si5345 Revision D) for device to comply with datasheet specifications.
 * 
 * Settings
 * ========
 * 
 * Location      Setting Name           Decimal Value      Hex Value        
 * ------------  ---------------------  -----------------  -----------------
 * 0x000B[6:0]   I2C_ADDR               100                0x64             
 * 0x0016[1]     LOL_ON_HOLD            1                  0x1              
 * 0x0017[0]     SYSINCAL_INTR_MSK      0                  0x0              
 * 0x0017[1]     LOSXAXB_INTR_MSK       0                  0x0              
 * 0x0017[5]     SMB_TMOUT_INTR_MSK     1                  0x1              
 * 0x0018[3:0]   LOS_INTR_MSK           15                 0xF              
 * 0x0018[7:4]   OOF_INTR_MSK           15                 0xF              
 * 0x0019[1]     LOL_INTR_MSK           1                  0x1              
 * 0x0019[5]     HOLD_INTR_MSK          0                  0x0              
 * 0x001A[5]     CAL_INTR_MSK           0                  0x0              
 * 0x002B[3]     SPI_3WIRE              0                  0x0              
 * 0x002B[5]     AUTO_NDIV_UPDATE       0                  0x0              
 * 0x002C[3:0]   LOS_EN                 1                  0x1              
 * 0x002C[4]     LOSXAXB_DIS            0                  0x0              
 * 0x002D[1:0]   LOS0_VAL_TIME          2                  0x2              
 * 0x002D[3:2]   LOS1_VAL_TIME          0                  0x0              
 * 0x002D[5:4]   LOS2_VAL_TIME          0                  0x0              
 * 0x002D[7:6]   LOS3_VAL_TIME          0                  0x0              
 * 0x002E[15:0]  LOS0_TRG_THR           2429               0x097D           
 * 0x0030[15:0]  LOS1_TRG_THR           0                  0x0000           
 * 0x0032[15:0]  LOS2_TRG_THR           0                  0x0000           
 * 0x0034[15:0]  LOS3_TRG_THR           0                  0x0000           
 * 0x0036[15:0]  LOS0_CLR_THR           2227               0x08B3           
 * 0x0038[15:0]  LOS1_CLR_THR           0                  0x0000           
 * 0x003A[15:0]  LOS2_CLR_THR           0                  0x0000           
 * 0x003C[15:0]  LOS3_CLR_THR           0                  0x0000           
 * 0x003F[3:0]   OOF_EN                 1                  0x1              
 * 0x003F[7:4]   FAST_OOF_EN            0                  0x0              
 * 0x0040[2:0]   OOF_REF_SEL            4                  0x4              
 * 0x0041[4:0]   OOF0_DIV_SEL           1                  0x01             
 * 0x0042[4:0]   OOF1_DIV_SEL           0                  0x00             
 * 0x0043[4:0]   OOF2_DIV_SEL           0                  0x00             
 * 0x0044[4:0]   OOF3_DIV_SEL           0                  0x00             
 * 0x0045[4:0]   OOFXO_DIV_SEL          12                 0x0C             
 * 0x0046[7:0]   OOF0_SET_THR           150                0x96             
 * 0x0047[7:0]   OOF1_SET_THR           0                  0x00             
 * 0x0048[7:0]   OOF2_SET_THR           0                  0x00             
 * 0x0049[7:0]   OOF3_SET_THR           0                  0x00             
 * 0x004A[7:0]   OOF0_CLR_THR           75                 0x4B             
 * 0x004B[7:0]   OOF1_CLR_THR           0                  0x00             
 * 0x004C[7:0]   OOF2_CLR_THR           0                  0x00             
 * 0x004D[7:0]   OOF3_CLR_THR           0                  0x00             
 * 0x004E[2:0]   OOF0_DETWIN_SEL        5                  0x5              
 * 0x004E[6:4]   OOF1_DETWIN_SEL        0                  0x0              
 * 0x004F[2:0]   OOF2_DETWIN_SEL        0                  0x0              
 * 0x004F[6:4]   OOF3_DETWIN_SEL        0                  0x0              
 * 0x0050[3:0]   OOF_ON_LOS             15                 0xF              
 * 0x0051[3:0]   FAST_OOF0_SET_THR      0                  0x0              
 * 0x0052[3:0]   FAST_OOF1_SET_THR      0                  0x0              
 * 0x0053[3:0]   FAST_OOF2_SET_THR      0                  0x0              
 * 0x0054[3:0]   FAST_OOF3_SET_THR      0                  0x0              
 * 0x0055[3:0]   FAST_OOF0_CLR_THR      0                  0x0              
 * 0x0056[3:0]   FAST_OOF1_CLR_THR      0                  0x0              
 * 0x0057[3:0]   FAST_OOF2_CLR_THR      0                  0x0              
 * 0x0058[3:0]   FAST_OOF3_CLR_THR      0                  0x0              
 * 0x0059[1:0]   FAST_OOF0_DETWIN_SEL   1                  0x1              
 * 0x0059[3:2]   FAST_OOF1_DETWIN_SEL   0                  0x0              
 * 0x0059[5:4]   FAST_OOF2_DETWIN_SEL   0                  0x0              
 * 0x0059[7:6]   FAST_OOF3_DETWIN_SEL   0                  0x0              
 * 0x005A[25:0]  OOF0_RATIO_REF         17840633           0x11039F9        
 * 0x005E[25:0]  OOF1_RATIO_REF         0                  0x0000000        
 * 0x0062[25:0]  OOF2_RATIO_REF         0                  0x0000000        
 * 0x0066[25:0]  OOF3_RATIO_REF         0                  0x0000000        
 * 0x0092[1]     LOL_FST_EN             1                  0x1              
 * 0x0093[7:4]   LOL_FST_DETWIN_SEL     10                 0xA              
 * 0x0095[3:2]   LOL_FST_VALWIN_SEL     0                  0x0              
 * 0x0096[7:4]   LOL_FST_SET_THR_SEL    9                  0x9              
 * 0x0098[7:4]   LOL_FST_CLR_THR_SEL    7                  0x7              
 * 0x009A[1]     LOL_SLOW_EN_PLL        1                  0x1              
 * 0x009B[7:4]   LOL_SLW_DETWIN_SEL     5                  0x5              
 * 0x009D[3:2]   LOL_SLW_VALWIN_SEL     1                  0x1              
 * 0x009E[7:4]   LOL_SLW_SET_THR        6                  0x6              
 * 0x00A0[7:4]   LOL_SLW_CLR_THR        3                  0x3              
 * 0x00A2[1]     LOL_TIMER_EN           0                  0x0              
 * 0x00A9[28:0]  LOL_CLR_DELAY_DIV256   307566             0x0004B16E       
 * 0x00E5[5]     FASTLOCK_EXTEND_EN     1                  0x1              
 * 0x00EA[28:0]  FASTLOCK_EXTEND        242129             0x0003B1D1       
 * 0x0102[0]     OUTALL_DISABLE_LOW     1                  0x1              
 * 0x0108[0]     OUT0_PDN               0                  0x0              
 * 0x0108[1]     OUT0_OE                1                  0x1              
 * 0x0108[2]     OUT0_RDIV_FORCE2       0                  0x0              
 * 0x0109[2:0]   OUT0_FORMAT            1                  0x1              
 * 0x0109[3]     OUT0_SYNC_EN           1                  0x1              
 * 0x0109[5:4]   OUT0_DIS_STATE         0                  0x0              
 * 0x0109[7:6]   OUT0_CMOS_DRV          0                  0x0              
 * 0x010A[3:0]   OUT0_CM                11                 0xB              
 * 0x010A[6:4]   OUT0_AMPL              3                  0x3              
 * 0x010B[2:0]   OUT0_MUX_SEL           0                  0x0              
 * 0x010B[5:4]   OUT0_VDD_SEL           2                  0x2              
 * 0x010B[3]     OUT0_VDD_SEL_EN        1                  0x1              
 * 0x010B[7:6]   OUT0_INV               0                  0x0              
 * 0x010D[0]     OUT1_PDN               1                  0x1              
 * 0x010D[1]     OUT1_OE                0                  0x0              
 * 0x010D[2]     OUT1_RDIV_FORCE2       0                  0x0              
 * 0x010E[2:0]   OUT1_FORMAT            1                  0x1              
 * 0x010E[3]     OUT1_SYNC_EN           1                  0x1              
 * 0x010E[5:4]   OUT1_DIS_STATE         0                  0x0              
 * 0x010E[7:6]   OUT1_CMOS_DRV          0                  0x0              
 * 0x010F[3:0]   OUT1_CM                11                 0xB              
 * 0x010F[6:4]   OUT1_AMPL              3                  0x3              
 * 0x0110[2:0]   OUT1_MUX_SEL           0                  0x0              
 * 0x0110[5:4]   OUT1_VDD_SEL           2                  0x2              
 * 0x0110[3]     OUT1_VDD_SEL_EN        1                  0x1              
 * 0x0110[7:6]   OUT1_INV               0                  0x0              
 * 0x0112[0]     OUT2_PDN               0                  0x0              
 * 0x0112[1]     OUT2_OE                1                  0x1              
 * 0x0112[2]     OUT2_RDIV_FORCE2       0                  0x0              
 * 0x0113[2:0]   OUT2_FORMAT            1                  0x1              
 * 0x0113[3]     OUT2_SYNC_EN           1                  0x1              
 * 0x0113[5:4]   OUT2_DIS_STATE         0                  0x0              
 * 0x0113[7:6]   OUT2_CMOS_DRV          0                  0x0              
 * 0x0114[3:0]   OUT2_CM                11                 0xB              
 * 0x0114[6:4]   OUT2_AMPL              3                  0x3              
 * 0x0115[2:0]   OUT2_MUX_SEL           0                  0x0              
 * 0x0115[5:4]   OUT2_VDD_SEL           2                  0x2              
 * 0x0115[3]     OUT2_VDD_SEL_EN        1                  0x1              
 * 0x0115[7:6]   OUT2_INV               0                  0x0              
 * 0x0117[0]     OUT3_PDN               1                  0x1              
 * 0x0117[1]     OUT3_OE                0                  0x0              
 * 0x0117[2]     OUT3_RDIV_FORCE2       0                  0x0              
 * 0x0118[2:0]   OUT3_FORMAT            1                  0x1              
 * 0x0118[3]     OUT3_SYNC_EN           1                  0x1              
 * 0x0118[5:4]   OUT3_DIS_STATE         0                  0x0              
 * 0x0118[7:6]   OUT3_CMOS_DRV          0                  0x0              
 * 0x0119[3:0]   OUT3_CM                11                 0xB              
 * 0x0119[6:4]   OUT3_AMPL              3                  0x3              
 * 0x011A[2:0]   OUT3_MUX_SEL           0                  0x0              
 * 0x011A[5:4]   OUT3_VDD_SEL           2                  0x2              
 * 0x011A[3]     OUT3_VDD_SEL_EN        1                  0x1              
 * 0x011A[7:6]   OUT3_INV               0                  0x0              
 * 0x011C[0]     OUT4_PDN               1                  0x1              
 * 0x011C[1]     OUT4_OE                0                  0x0              
 * 0x011C[2]     OUT4_RDIV_FORCE2       0                  0x0              
 * 0x011D[2:0]   OUT4_FORMAT            1                  0x1              
 * 0x011D[3]     OUT4_SYNC_EN           1                  0x1              
 * 0x011D[5:4]   OUT4_DIS_STATE         0                  0x0              
 * 0x011D[7:6]   OUT4_CMOS_DRV          0                  0x0              
 * 0x011E[3:0]   OUT4_CM                11                 0xB              
 * 0x011E[6:4]   OUT4_AMPL              3                  0x3              
 * 0x011F[2:0]   OUT4_MUX_SEL           0                  0x0              
 * 0x011F[5:4]   OUT4_VDD_SEL           2                  0x2              
 * 0x011F[3]     OUT4_VDD_SEL_EN        1                  0x1              
 * 0x011F[7:6]   OUT4_INV               0                  0x0              
 * 0x0121[0]     OUT5_PDN               0                  0x0              
 * 0x0121[1]     OUT5_OE                1                  0x1              
 * 0x0121[2]     OUT5_RDIV_FORCE2       0                  0x0              
 * 0x0122[2:0]   OUT5_FORMAT            1                  0x1              
 * 0x0122[3]     OUT5_SYNC_EN           1                  0x1              
 * 0x0122[5:4]   OUT5_DIS_STATE         0                  0x0              
 * 0x0122[7:6]   OUT5_CMOS_DRV          0                  0x0              
 * 0x0123[3:0]   OUT5_CM                11                 0xB              
 * 0x0123[6:4]   OUT5_AMPL              3                  0x3              
 * 0x0124[2:0]   OUT5_MUX_SEL           1                  0x1              
 * 0x0124[5:4]   OUT5_VDD_SEL           2                  0x2              
 * 0x0124[3]     OUT5_VDD_SEL_EN        1                  0x1              
 * 0x0124[7:6]   OUT5_INV               0                  0x0              
 * 0x0126[0]     OUT6_PDN               1                  0x1              
 * 0x0126[1]     OUT6_OE                0                  0x0              
 * 0x0126[2]     OUT6_RDIV_FORCE2       0                  0x0              
 * 0x0127[2:0]   OUT6_FORMAT            1                  0x1              
 * 0x0127[3]     OUT6_SYNC_EN           1                  0x1              
 * 0x0127[5:4]   OUT6_DIS_STATE         0                  0x0              
 * 0x0127[7:6]   OUT6_CMOS_DRV          0                  0x0              
 * 0x0128[3:0]   OUT6_CM                11                 0xB              
 * 0x0128[6:4]   OUT6_AMPL              3                  0x3              
 * 0x0129[2:0]   OUT6_MUX_SEL           0                  0x0              
 * 0x0129[5:4]   OUT6_VDD_SEL           2                  0x2              
 * 0x0129[3]     OUT6_VDD_SEL_EN        1                  0x1              
 * 0x0129[7:6]   OUT6_INV               0                  0x0              
 * 0x012B[0]     OUT7_PDN               1                  0x1              
 * 0x012B[1]     OUT7_OE                0                  0x0              
 * 0x012B[2]     OUT7_RDIV_FORCE2       0                  0x0              
 * 0x012C[2:0]   OUT7_FORMAT            1                  0x1              
 * 0x012C[3]     OUT7_SYNC_EN           1                  0x1              
 * 0x012C[5:4]   OUT7_DIS_STATE         0                  0x0              
 * 0x012C[7:6]   OUT7_CMOS_DRV          0                  0x0              
 * 0x012D[3:0]   OUT7_CM                11                 0xB              
 * 0x012D[6:4]   OUT7_AMPL              3                  0x3              
 * 0x012E[2:0]   OUT7_MUX_SEL           0                  0x0              
 * 0x012E[5:4]   OUT7_VDD_SEL           2                  0x2              
 * 0x012E[3]     OUT7_VDD_SEL_EN        1                  0x1              
 * 0x012E[7:6]   OUT7_INV               0                  0x0              
 * 0x0130[0]     OUT8_PDN               0                  0x0              
 * 0x0130[1]     OUT8_OE                1                  0x1              
 * 0x0130[2]     OUT8_RDIV_FORCE2       0                  0x0              
 * 0x0131[2:0]   OUT8_FORMAT            1                  0x1              
 * 0x0131[3]     OUT8_SYNC_EN           1                  0x1              
 * 0x0131[5:4]   OUT8_DIS_STATE         0                  0x0              
 * 0x0131[7:6]   OUT8_CMOS_DRV          0                  0x0              
 * 0x0132[3:0]   OUT8_CM                11                 0xB              
 * 0x0132[6:4]   OUT8_AMPL              3                  0x3              
 * 0x0133[2:0]   OUT8_MUX_SEL           2                  0x2              
 * 0x0133[5:4]   OUT8_VDD_SEL           2                  0x2              
 * 0x0133[3]     OUT8_VDD_SEL_EN        1                  0x1              
 * 0x0133[7:6]   OUT8_INV               0                  0x0              
 * 0x013A[0]     OUT9_PDN               1                  0x1              
 * 0x013A[1]     OUT9_OE                0                  0x0              
 * 0x013A[2]     OUT9_RDIV_FORCE2       0                  0x0              
 * 0x013B[2:0]   OUT9_FORMAT            1                  0x1              
 * 0x013B[3]     OUT9_SYNC_EN           1                  0x1              
 * 0x013B[5:4]   OUT9_DIS_STATE         0                  0x0              
 * 0x013B[7:6]   OUT9_CMOS_DRV          0                  0x0              
 * 0x013C[3:0]   OUT9_CM                11                 0xB              
 * 0x013C[6:4]   OUT9_AMPL              3                  0x3              
 * 0x013D[2:0]   OUT9_MUX_SEL           0                  0x0              
 * 0x013D[5:4]   OUT9_VDD_SEL           2                  0x2              
 * 0x013D[3]     OUT9_VDD_SEL_EN        1                  0x1              
 * 0x013D[7:6]   OUT9_INV               0                  0x0              
 * 0x013F[11:0]  OUTX_ALWAYS_ON         0                  0x000            
 * 0x0141[1]     OUT_DIS_MSK            0                  0x0              
 * 0x0141[5]     OUT_DIS_LOL_MSK        0                  0x0              
 * 0x0141[6]     OUT_DIS_LOSXAXB_MSK    1                  0x1              
 * 0x0141[7]     OUT_DIS_MSK_LOS_PFD    0                  0x0              
 * 0x0142[1]     OUT_DIS_MSK_LOL        1                  0x1              
 * 0x0142[5]     OUT_DIS_MSK_HOLD       1                  0x1              
 * 0x0206[1:0]   PXAXB                  0                  0x0              
 * 0x0208[47:0]  P0_NUM                 1                  0x000000000001   
 * 0x020E[31:0]  P0_DEN                 1                  0x00000001       
 * 0x0212[47:0]  P1_NUM                 0                  0x000000000000   
 * 0x0218[31:0]  P1_DEN                 0                  0x00000000       
 * 0x021C[47:0]  P2_NUM                 0                  0x000000000000   
 * 0x0222[31:0]  P2_DEN                 0                  0x00000000       
 * 0x0226[47:0]  P3_NUM                 0                  0x000000000000   
 * 0x022C[31:0]  P3_DEN                 0                  0x00000000       
 * 0x0231[3:0]   P0_FRACN_MODE          11                 0xB              
 * 0x0231[4]     P0_FRACN_EN            0                  0x0              
 * 0x0232[3:0]   P1_FRACN_MODE          11                 0xB              
 * 0x0232[4]     P1_FRACN_EN            0                  0x0              
 * 0x0233[3:0]   P2_FRACN_MODE          11                 0xB              
 * 0x0233[4]     P2_FRACN_EN            0                  0x0              
 * 0x0234[3:0]   P3_FRACN_MODE          11                 0xB              
 * 0x0234[4]     P3_FRACN_EN            0                  0x0              
 * 0x0235[43:0]  MXAXB_NUM              916841299968       0x0D578000000    
 * 0x023B[31:0]  MXAXB_DEN              3489660928         0xD0000000       
 * 0x024A[23:0]  R0_REG                 10                 0x00000A         
 * 0x024D[23:0]  R1_REG                 0                  0x000000         
 * 0x0250[23:0]  R2_REG                 1                  0x000001         
 * 0x0253[23:0]  R3_REG                 0                  0x000000         
 * 0x0256[23:0]  R4_REG                 0                  0x000000         
 * 0x0259[23:0]  R5_REG                 2                  0x000002         
 * 0x025C[23:0]  R6_REG                 0                  0x000000         
 * 0x025F[23:0]  R7_REG                 0                  0x000000         
 * 0x0262[23:0]  R8_REG                 2                  0x000002         
 * 0x0268[23:0]  R9_REG                 0                  0x000000         
 * 0x026B[7:0]   DESIGN_ID0             73                 0x49             
 * 0x026C[7:0]   DESIGN_ID1             79                 0x4F             
 * 0x026D[7:0]   DESIGN_ID2             52                 0x34             
 * 0x026E[7:0]   DESIGN_ID3             75                 0x4B             
 * 0x026F[7:0]   DESIGN_ID4             43                 0x2B             
 * 0x0270[7:0]   DESIGN_ID5             0                  0x00             
 * 0x0271[7:0]   DESIGN_ID6             0                  0x00             
 * 0x0272[7:0]   DESIGN_ID7             0                  0x00             
 * 0x0294[7:4]   FASTLOCK_EXTEND_SCL    8                  0x8              
 * 0x0296[1]     LOL_SLW_VALWIN_SELX    0                  0x0              
 * 0x0297[1]     FASTLOCK_DLY_ONSW_EN   1                  0x1              
 * 0x0299[1]     FASTLOCK_DLY_ONLOL_EN  1                  0x1              
 * 0x029D[19:0]  FASTLOCK_DLY_ONLOL     3829               0x00EF5          
 * 0x02A9[19:0]  FASTLOCK_DLY_ONSW      9830               0x02666          
 * 0x02B7[3:2]   LOL_NOSIG_TIME         3                  0x3              
 * 0x0302[43:0]  N0_NUM                 49392123904        0x00B80000000    
 * 0x0308[31:0]  N0_DEN                 2147483648         0x80000000       
 * 0x030C[0]     N0_UPDATE              0                  0x0              
 * 0x030D[43:0]  N1_NUM                 198967296000       0x02E53600000    
 * 0x0313[31:0]  N1_DEN                 2147483648         0x80000000       
 * 0x0317[0]     N1_UPDATE              0                  0x0              
 * 0x0318[43:0]  N2_NUM                 48282730496        0x00B3DE00000    
 * 0x031E[31:0]  N2_DEN                 3145728000         0xBB800000       
 * 0x0322[0]     N2_UPDATE              0                  0x0              
 * 0x0323[43:0]  N3_NUM                 0                  0x00000000000    
 * 0x0329[31:0]  N3_DEN                 0                  0x00000000       
 * 0x032D[0]     N3_UPDATE              0                  0x0              
 * 0x032E[43:0]  N4_NUM                 0                  0x00000000000    
 * 0x0334[31:0]  N4_DEN                 0                  0x00000000       
 * 0x0338[0]     N4_UPDATE              0                  0x0              
 * 0x0338[1]     N_UPDATE               0                  0x0              
 * 0x0339[4:0]   N_FSTEP_MSK            31                 0x1F             
 * 0x033B[43:0]  N0_FSTEPW              0                  0x00000000000    
 * 0x0341[43:0]  N1_FSTEPW              0                  0x00000000000    
 * 0x0347[43:0]  N2_FSTEPW              0                  0x00000000000    
 * 0x034D[43:0]  N3_FSTEPW              0                  0x00000000000    
 * 0x0353[43:0]  N4_FSTEPW              0                  0x00000000000    
 * 0x0359[15:0]  N0_DELAY               0                  0x0000           
 * 0x035B[15:0]  N1_DELAY               0                  0x0000           
 * 0x035D[15:0]  N2_DELAY               0                  0x0000           
 * 0x035F[15:0]  N3_DELAY               0                  0x0000           
 * 0x0361[15:0]  N4_DELAY               0                  0x0000           
 * 0x0487[0]     ZDM_EN                 0                  0x0              
 * 0x0487[2:1]   ZDM_IN_SEL             0                  0x0              
 * 0x0487[4]     ZDM_AUTOSW_EN          0                  0x0              
 * 0x0502[4]     ADD_DIV256             0                  0x0              
 * 0x0508[5:0]   BW0_PLL                16                 0x10             
 * 0x0509[5:0]   BW1_PLL                24                 0x18             
 * 0x050A[5:0]   BW2_PLL                15                 0x0F             
 * 0x050B[5:0]   BW3_PLL                15                 0x0F             
 * 0x050C[5:0]   BW4_PLL                3                  0x03             
 * 0x050D[5:0]   BW5_PLL                7                  0x07             
 * 0x050E[5:0]   FASTLOCK_BW0_PLL       23                 0x17             
 * 0x050F[5:0]   FASTLOCK_BW1_PLL       40                 0x28             
 * 0x0510[5:0]   FASTLOCK_BW2_PLL       12                 0x0C             
 * 0x0511[5:0]   FASTLOCK_BW3_PLL       11                 0x0B             
 * 0x0512[5:0]   FASTLOCK_BW4_PLL       3                  0x03             
 * 0x0513[5:0]   FASTLOCK_BW5_PLL       7                  0x07             
 * 0x0515[55:0]  M_NUM                  217325345177600    0x00C5A800000000 
 * 0x051C[31:0]  M_DEN                  2147483648         0x80000000       
 * 0x0521[3:0]   M_FRAC_MODE            11                 0xB              
 * 0x0521[4]     M_FRAC_EN              0                  0x0              
 * 0x0521[5]     PLL_OUT_RATE_SEL       1                  0x1              
 * 0x052A[0]     IN_SEL_REGCTRL         1                  0x1              
 * 0x052A[3:1]   IN_SEL                 0                  0x0              
 * 0x052B[0]     FASTLOCK_AUTO_EN       1                  0x1              
 * 0x052B[1]     FASTLOCK_MAN           0                  0x0              
 * 0x052C[0]     HOLD_EN                1                  0x1              
 * 0x052C[3]     HOLD_RAMP_BYP          1                  0x1              
 * 0x052C[4]     HOLDEXIT_BW_SEL1       0                  0x0              
 * 0x052C[7:5]   RAMP_STEP_INTERVAL     0                  0x0              
 * 0x052D[1]     HOLD_RAMPBYP_NOHIST    1                  0x1              
 * 0x052E[4:0]   HOLD_HIST_LEN          21                 0x15             
 * 0x052F[4:0]   HOLD_HIST_DELAY        20                 0x14             
 * 0x0531[4:0]   HOLD_REF_COUNT_FRC     0                  0x00             
 * 0x0532[23:0]  HOLD_15M_CYC_COUNT     61729              0x00F121         
 * 0x0535[0]     FORCE_HOLD             0                  0x0              
 * 0x0536[1:0]   CLK_SWITCH_MODE        0                  0x0              
 * 0x0536[2]     HSW_EN                 0                  0x0              
 * 0x0537[3:0]   IN_LOS_MSK             0                  0x0              
 * 0x0537[7:4]   IN_OOF_MSK             0                  0x0              
 * 0x0538[2:0]   IN0_PRIORITY           0                  0x0              
 * 0x0538[6:4]   IN1_PRIORITY           0                  0x0              
 * 0x0539[2:0]   IN2_PRIORITY           0                  0x0              
 * 0x0539[6:4]   IN3_PRIORITY           0                  0x0              
 * 0x053A[1:0]   HSW_MODE               2                  0x2              
 * 0x053A[3:2]   HSW_PHMEAS_CTRL        0                  0x0              
 * 0x053B[9:0]   HSW_PHMEAS_THR         3                  0x003            
 * 0x053D[4:0]   HSW_COARSE_PM_LEN      18                 0x12             
 * 0x053E[4:0]   HSW_COARSE_PM_DLY      6                  0x06             
 * 0x0589[12:0]  CAP_SHORT_DELAY        1009               0x03F1           
 * 0x059B[4]     HOLD_PRESERVE_HIST     1                  0x1              
 * 0x059B[5]     HOLD_FRZ_WITH_INTONLY  1                  0x1              
 * 0x059B[6]     HOLDEXIT_BW_SEL0       1                  0x1              
 * 0x059B[7]     HOLDEXIT_STD_BO        1                  0x1              
 * 0x059D[5:0]   HOLDEXIT_BW0           23                 0x17             
 * 0x059E[5:0]   HOLDEXIT_BW1           40                 0x28             
 * 0x059F[5:0]   HOLDEXIT_BW2           12                 0x0C             
 * 0x05A0[5:0]   HOLDEXIT_BW3           11                 0x0B             
 * 0x05A1[5:0]   HOLDEXIT_BW4           3                  0x03             
 * 0x05A2[5:0]   HOLDEXIT_BW5           7                  0x07             
 * 0x05A6[2:0]   RAMP_STEP_SIZE         0                  0x0              
 * 0x05A6[3]     RAMP_SWITCH_EN         0                  0x0              
 * 0x0802[15:0]  FIXREGSA0              1333               0x0535           
 * 0x0804[7:0]   FIXREGSD0              0                  0x00             
 * 0x0805[15:0]  FIXREGSA1              0                  0x0000           
 * 0x0807[7:0]   FIXREGSD1              0                  0x00             
 * 0x0808[15:0]  FIXREGSA2              0                  0x0000           
 * 0x080A[7:0]   FIXREGSD2              0                  0x00             
 * 0x080B[15:0]  FIXREGSA3              0                  0x0000           
 * 0x080D[7:0]   FIXREGSD3              0                  0x00             
 * 0x080E[15:0]  FIXREGSA4              0                  0x0000           
 * 0x0810[7:0]   FIXREGSD4              0                  0x00             
 * 0x0811[15:0]  FIXREGSA5              0                  0x0000           
 * 0x0813[7:0]   FIXREGSD5              0                  0x00             
 * 0x0814[15:0]  FIXREGSA6              0                  0x0000           
 * 0x0816[7:0]   FIXREGSD6              0                  0x00             
 * 0x0817[15:0]  FIXREGSA7              0                  0x0000           
 * 0x0819[7:0]   FIXREGSD7              0                  0x00             
 * 0x081A[15:0]  FIXREGSA8              0                  0x0000           
 * 0x081C[7:0]   FIXREGSD8              0                  0x00             
 * 0x081D[15:0]  FIXREGSA9              0                  0x0000           
 * 0x081F[7:0]   FIXREGSD9              0                  0x00             
 * 0x0820[15:0]  FIXREGSA10             0                  0x0000           
 * 0x0822[7:0]   FIXREGSD10             0                  0x00             
 * 0x0823[15:0]  FIXREGSA11             0                  0x0000           
 * 0x0825[7:0]   FIXREGSD11             0                  0x00             
 * 0x0826[15:0]  FIXREGSA12             0                  0x0000           
 * 0x0828[7:0]   FIXREGSD12             0                  0x00             
 * 0x0829[15:0]  FIXREGSA13             0                  0x0000           
 * 0x082B[7:0]   FIXREGSD13             0                  0x00             
 * 0x082C[15:0]  FIXREGSA14             0                  0x0000           
 * 0x082E[7:0]   FIXREGSD14             0                  0x00             
 * 0x082F[15:0]  FIXREGSA15             0                  0x0000           
 * 0x0831[7:0]   FIXREGSD15             0                  0x00             
 * 0x0832[15:0]  FIXREGSA16             0                  0x0000           
 * 0x0834[7:0]   FIXREGSD16             0                  0x00             
 * 0x0835[15:0]  FIXREGSA17             0                  0x0000           
 * 0x0837[7:0]   FIXREGSD17             0                  0x00             
 * 0x0838[15:0]  FIXREGSA18             0                  0x0000           
 * 0x083A[7:0]   FIXREGSD18             0                  0x00             
 * 0x083B[15:0]  FIXREGSA19             0                  0x0000           
 * 0x083D[7:0]   FIXREGSD19             0                  0x00             
 * 0x083E[15:0]  FIXREGSA20             0                  0x0000           
 * 0x0840[7:0]   FIXREGSD20             0                  0x00             
 * 0x0841[15:0]  FIXREGSA21             0                  0x0000           
 * 0x0843[7:0]   FIXREGSD21             0                  0x00             
 * 0x0844[15:0]  FIXREGSA22             0                  0x0000           
 * 0x0846[7:0]   FIXREGSD22             0                  0x00             
 * 0x0847[15:0]  FIXREGSA23             0                  0x0000           
 * 0x0849[7:0]   FIXREGSD23             0                  0x00             
 * 0x084A[15:0]  FIXREGSA24             0                  0x0000           
 * 0x084C[7:0]   FIXREGSD24             0                  0x00             
 * 0x084D[15:0]  FIXREGSA25             0                  0x0000           
 * 0x084F[7:0]   FIXREGSD25             0                  0x00             
 * 0x0850[15:0]  FIXREGSA26             0                  0x0000           
 * 0x0852[7:0]   FIXREGSD26             0                  0x00             
 * 0x0853[15:0]  FIXREGSA27             0                  0x0000           
 * 0x0855[7:0]   FIXREGSD27             0                  0x00             
 * 0x0856[15:0]  FIXREGSA28             0                  0x0000           
 * 0x0858[7:0]   FIXREGSD28             0                  0x00             
 * 0x0859[15:0]  FIXREGSA29             0                  0x0000           
 * 0x085B[7:0]   FIXREGSD29             0                  0x00             
 * 0x085C[15:0]  FIXREGSA30             0                  0x0000           
 * 0x085E[7:0]   FIXREGSD30             0                  0x00             
 * 0x085F[15:0]  FIXREGSA31             0                  0x0000           
 * 0x0861[7:0]   FIXREGSD31             0                  0x00             
 * 0x090E[0]     XAXB_EXTCLK_EN         1                  0x1              
 * 0x0943[0]     IO_VDD_SEL             0                  0x0              
 * 0x0949[3:0]   IN_EN                  1                  0x1              
 * 0x0949[7:4]   IN_PULSED_CMOS_EN      3                  0x3              
 * 0x094A[3:0]   INX_TO_PFD_EN          1                  0x1              
 * 0x094E[11:0]  REFCLK_HYS_SEL         585                0x249            
 * 0x095E[0]     MXAXB_INTEGER          0                  0x0              
 * 0x0A02[4:0]   N_ADD_0P5              0                  0x00             
 * 0x0A03[4:0]   N_CLK_TO_OUTX_EN       7                  0x07             
 * 0x0A04[4:0]   N_PIBYP                1                  0x01             
 * 0x0A05[4:0]   N_PDNB                 7                  0x07             
 * 0x0A14[3]     N0_HIGH_FREQ           0                  0x0              
 * 0x0A1A[3]     N1_HIGH_FREQ           0                  0x0              
 * 0x0A20[3]     N2_HIGH_FREQ           0                  0x0              
 * 0x0A26[3]     N3_HIGH_FREQ           0                  0x0              
 * 0x0A2C[3]     N4_HIGH_FREQ           0                  0x0              
 * 0x0B44[3:0]   PDIV_FRACN_CLK_DIS     15                 0xF              
 * 0x0B44[5]     FRACN_CLK_DIS_PLL      1                  0x1              
 * 0x0B46[3:0]   LOS_CLK_DIS            0                  0x0              
 * 0x0B47[4:0]   OOF_CLK_DIS            14                 0x0E             
 * 0x0B48[4:0]   OOF_DIV_CLK_DIS        14                 0x0E             
 * 0x0B4A[4:0]   N_CLK_DIS              24                 0x18             
 * 0x0B57[11:0]  VCO_RESET_CALCODE      249                0x0F9
 * 
 *
 */


static struct ntv2_genlock_data s_genlock_1125_2500[] =
{
	/* Start configuration preamble */
	{ 0x0B24, 0xC0 },
	{ 0x0B25, 0x00 },
	{ 0x0540, 0x01 },
	/* End configuration preamble */

	/* Delay 300 msec */
	/*    Delay is worst case time for device to complete any calibration */
	/*    that is running due to device state change previous to this script */
	/*    being processed. */
	{ 0x0000, 0x01 },

	/* Start configuration registers */
	{ 0x000B, 0x64 },
	{ 0x0016, 0x02 },
	{ 0x0017, 0xFC },
	{ 0x0018, 0xFF },
	{ 0x0019, 0xDF },
	{ 0x001A, 0xDF },
	{ 0x002B, 0x02 },
	{ 0x002C, 0x01 },
	{ 0x002D, 0x02 },
	{ 0x002E, 0x1C },
	{ 0x002F, 0x09 },
	{ 0x0030, 0x00 },
	{ 0x0031, 0x00 },
	{ 0x0032, 0x00 },
	{ 0x0033, 0x00 },
	{ 0x0034, 0x00 },
	{ 0x0035, 0x00 },
	{ 0x0036, 0x5A },
	{ 0x0037, 0x08 },
	{ 0x0038, 0x00 },
	{ 0x0039, 0x00 },
	{ 0x003A, 0x00 },
	{ 0x003B, 0x00 },
	{ 0x003C, 0x00 },
	{ 0x003D, 0x00 },
	{ 0x003F, 0x01 },
	{ 0x0040, 0x04 },
	{ 0x0041, 0x01 },
	{ 0x0042, 0x00 },
	{ 0x0043, 0x00 },
	{ 0x0044, 0x00 },
	{ 0x0045, 0x0C },
	{ 0x0046, 0x96 },
	{ 0x0047, 0x00 },
	{ 0x0048, 0x00 },
	{ 0x0049, 0x00 },
	{ 0x004A, 0x4B },
	{ 0x004B, 0x00 },
	{ 0x004C, 0x00 },
	{ 0x004D, 0x00 },
	{ 0x004E, 0x05 },
	{ 0x004F, 0x00 },
	{ 0x0050, 0x0F },
	{ 0x0051, 0x00 },
	{ 0x0052, 0x00 },
	{ 0x0053, 0x00 },
	{ 0x0054, 0x00 },
	{ 0x0055, 0x00 },
	{ 0x0056, 0x00 },
	{ 0x0057, 0x00 },
	{ 0x0058, 0x00 },
	{ 0x0059, 0x01 },
	{ 0x005A, 0xB9 },
	{ 0x005B, 0x91 },
	{ 0x005C, 0x1B },
	{ 0x005D, 0x01 },
	{ 0x005E, 0x00 },
	{ 0x005F, 0x00 },
	{ 0x0060, 0x00 },
	{ 0x0061, 0x00 },
	{ 0x0062, 0x00 },
	{ 0x0063, 0x00 },
	{ 0x0064, 0x00 },
	{ 0x0065, 0x00 },
	{ 0x0066, 0x00 },
	{ 0x0067, 0x00 },
	{ 0x0068, 0x00 },
	{ 0x0069, 0x00 },
	{ 0x0092, 0x02 },
	{ 0x0093, 0xA0 },
	{ 0x0095, 0x00 },
	{ 0x0096, 0x90 },
	{ 0x0098, 0x70 },
	{ 0x009A, 0x02 },
	{ 0x009B, 0x50 },
	{ 0x009D, 0x04 },
	{ 0x009E, 0x60 },
	{ 0x00A0, 0x30 },
	{ 0x00A2, 0x00 },
	{ 0x00A9, 0x0C },
	{ 0x00AA, 0xA7 },
	{ 0x00AB, 0x04 },
	{ 0x00AC, 0x00 },
	{ 0x00E5, 0x21 },
	{ 0x00EA, 0xD1 },
	{ 0x00EB, 0xB1 },
	{ 0x00EC, 0x03 },
	{ 0x00ED, 0x00 },
	{ 0x0102, 0x01 },
	{ 0x0108, 0x02 },
	{ 0x0109, 0x09 },
	{ 0x010A, 0x3B },
	{ 0x010B, 0x28 },
	{ 0x010D, 0x01 },
	{ 0x010E, 0x09 },
	{ 0x010F, 0x3B },
	{ 0x0110, 0x28 },
	{ 0x0112, 0x02 },
	{ 0x0113, 0x09 },
	{ 0x0114, 0x3B },
	{ 0x0115, 0x28 },
	{ 0x0117, 0x01 },
	{ 0x0118, 0x09 },
	{ 0x0119, 0x3B },
	{ 0x011A, 0x28 },
	{ 0x011C, 0x01 },
	{ 0x011D, 0x09 },
	{ 0x011E, 0x3B },
	{ 0x011F, 0x28 },
	{ 0x0121, 0x02 },
	{ 0x0122, 0x09 },
	{ 0x0123, 0x3B },
	{ 0x0124, 0x29 },
	{ 0x0126, 0x01 },
	{ 0x0127, 0x09 },
	{ 0x0128, 0x3B },
	{ 0x0129, 0x28 },
	{ 0x012B, 0x01 },
	{ 0x012C, 0x09 },
	{ 0x012D, 0x3B },
	{ 0x012E, 0x28 },
	{ 0x0130, 0x02 },
	{ 0x0131, 0x09 },
	{ 0x0132, 0x3B },
	{ 0x0133, 0x2A },
	{ 0x013A, 0x01 },
	{ 0x013B, 0x09 },
	{ 0x013C, 0x3B },
	{ 0x013D, 0x28 },
	{ 0x013F, 0x00 },
	{ 0x0140, 0x00 },
	{ 0x0141, 0x40 },
	{ 0x0142, 0xFF },
	{ 0x0206, 0x00 },
	{ 0x0208, 0x01 },
	{ 0x0209, 0x00 },
	{ 0x020A, 0x00 },
	{ 0x020B, 0x00 },
	{ 0x020C, 0x00 },
	{ 0x020D, 0x00 },
	{ 0x020E, 0x01 },
	{ 0x020F, 0x00 },
	{ 0x0210, 0x00 },
	{ 0x0211, 0x00 },
	{ 0x0212, 0x00 },
	{ 0x0213, 0x00 },
	{ 0x0214, 0x00 },
	{ 0x0215, 0x00 },
	{ 0x0216, 0x00 },
	{ 0x0217, 0x00 },
	{ 0x0218, 0x00 },
	{ 0x0219, 0x00 },
	{ 0x021A, 0x00 },
	{ 0x021B, 0x00 },
	{ 0x021C, 0x00 },
	{ 0x021D, 0x00 },
	{ 0x021E, 0x00 },
	{ 0x021F, 0x00 },
	{ 0x0220, 0x00 },
	{ 0x0221, 0x00 },
	{ 0x0222, 0x00 },
	{ 0x0223, 0x00 },
	{ 0x0224, 0x00 },
	{ 0x0225, 0x00 },
	{ 0x0226, 0x00 },
	{ 0x0227, 0x00 },
	{ 0x0228, 0x00 },
	{ 0x0229, 0x00 },
	{ 0x022A, 0x00 },
	{ 0x022B, 0x00 },
	{ 0x022C, 0x00 },
	{ 0x022D, 0x00 },
	{ 0x022E, 0x00 },
	{ 0x022F, 0x00 },
	{ 0x0231, 0x0B },
	{ 0x0232, 0x0B },
	{ 0x0233, 0x0B },
	{ 0x0234, 0x0B },
	{ 0x0235, 0x00 },
	{ 0x0236, 0x00 },
	{ 0x0237, 0x00 },
	{ 0x0238, 0x78 },
	{ 0x0239, 0xD5 },
	{ 0x023A, 0x00 },
	{ 0x023B, 0x00 },
	{ 0x023C, 0x00 },
	{ 0x023D, 0x00 },
	{ 0x023E, 0xD0 },
	{ 0x024A, 0x0A },
	{ 0x024B, 0x00 },
	{ 0x024C, 0x00 },
	{ 0x024D, 0x00 },
	{ 0x024E, 0x00 },
	{ 0x024F, 0x00 },
	{ 0x0250, 0x01 },
	{ 0x0251, 0x00 },
	{ 0x0252, 0x00 },
	{ 0x0253, 0x00 },
	{ 0x0254, 0x00 },
	{ 0x0255, 0x00 },
	{ 0x0256, 0x00 },
	{ 0x0257, 0x00 },
	{ 0x0258, 0x00 },
	{ 0x0259, 0x02 },
	{ 0x025A, 0x00 },
	{ 0x025B, 0x00 },
	{ 0x025C, 0x00 },
	{ 0x025D, 0x00 },
	{ 0x025E, 0x00 },
	{ 0x025F, 0x00 },
	{ 0x0260, 0x00 },
	{ 0x0261, 0x00 },
	{ 0x0262, 0x02 },
	{ 0x0263, 0x00 },
	{ 0x0264, 0x00 },
	{ 0x0268, 0x00 },
	{ 0x0269, 0x00 },
	{ 0x026A, 0x00 },
	{ 0x026B, 0x49 },
	{ 0x026C, 0x4F },
	{ 0x026D, 0x34 },
	{ 0x026E, 0x4B },
	{ 0x026F, 0x2B },
	{ 0x0270, 0x00 },
	{ 0x0271, 0x00 },
	{ 0x0272, 0x00 },
	{ 0x0294, 0x80 },
	{ 0x0296, 0x00 },
	{ 0x0297, 0x02 },
	{ 0x0299, 0x02 },
	{ 0x029D, 0xF5 },
	{ 0x029E, 0x0E },
	{ 0x029F, 0x00 },
	{ 0x02A9, 0x66 },
	{ 0x02AA, 0x26 },
	{ 0x02AB, 0x00 },
	{ 0x02B7, 0xFF },
	{ 0x0302, 0x00 },
	{ 0x0303, 0x00 },
	{ 0x0304, 0x00 },
	{ 0x0305, 0x80 },
	{ 0x0306, 0x0B },
	{ 0x0307, 0x00 },
	{ 0x0308, 0x00 },
	{ 0x0309, 0x00 },
	{ 0x030A, 0x00 },
	{ 0x030B, 0x80 },
	{ 0x030C, 0x00 },
	{ 0x030D, 0x00 },
	{ 0x030E, 0x00 },
	{ 0x030F, 0x60 },
	{ 0x0310, 0x53 },
	{ 0x0311, 0x2E },
	{ 0x0312, 0x00 },
	{ 0x0313, 0x00 },
	{ 0x0314, 0x00 },
	{ 0x0315, 0x00 },
	{ 0x0316, 0x80 },
	{ 0x0317, 0x00 },
	{ 0x0318, 0x00 },
	{ 0x0319, 0x00 },
	{ 0x031A, 0xE0 },
	{ 0x031B, 0x3D },
	{ 0x031C, 0x0B },
	{ 0x031D, 0x00 },
	{ 0x031E, 0x00 },
	{ 0x031F, 0x00 },
	{ 0x0320, 0x80 },
	{ 0x0321, 0xBB },
	{ 0x0322, 0x00 },
	{ 0x0323, 0x00 },
	{ 0x0324, 0x00 },
	{ 0x0325, 0x00 },
	{ 0x0326, 0x00 },
	{ 0x0327, 0x00 },
	{ 0x0328, 0x00 },
	{ 0x0329, 0x00 },
	{ 0x032A, 0x00 },
	{ 0x032B, 0x00 },
	{ 0x032C, 0x00 },
	{ 0x032D, 0x00 },
	{ 0x032E, 0x00 },
	{ 0x032F, 0x00 },
	{ 0x0330, 0x00 },
	{ 0x0331, 0x00 },
	{ 0x0332, 0x00 },
	{ 0x0333, 0x00 },
	{ 0x0334, 0x00 },
	{ 0x0335, 0x00 },
	{ 0x0336, 0x00 },
	{ 0x0337, 0x00 },
	{ 0x0338, 0x00 },
	{ 0x0339, 0x1F },
	{ 0x033B, 0x00 },
	{ 0x033C, 0x00 },
	{ 0x033D, 0x00 },
	{ 0x033E, 0x00 },
	{ 0x033F, 0x00 },
	{ 0x0340, 0x00 },
	{ 0x0341, 0x00 },
	{ 0x0342, 0x00 },
	{ 0x0343, 0x00 },
	{ 0x0344, 0x00 },
	{ 0x0345, 0x00 },
	{ 0x0346, 0x00 },
	{ 0x0347, 0x00 },
	{ 0x0348, 0x00 },
	{ 0x0349, 0x00 },
	{ 0x034A, 0x00 },
	{ 0x034B, 0x00 },
	{ 0x034C, 0x00 },
	{ 0x034D, 0x00 },
	{ 0x034E, 0x00 },
	{ 0x034F, 0x00 },
	{ 0x0350, 0x00 },
	{ 0x0351, 0x00 },
	{ 0x0352, 0x00 },
	{ 0x0353, 0x00 },
	{ 0x0354, 0x00 },
	{ 0x0355, 0x00 },
	{ 0x0356, 0x00 },
	{ 0x0357, 0x00 },
	{ 0x0358, 0x00 },
	{ 0x0359, 0x00 },
	{ 0x035A, 0x00 },
	{ 0x035B, 0x00 },
	{ 0x035C, 0x00 },
	{ 0x035D, 0x00 },
	{ 0x035E, 0x00 },
	{ 0x035F, 0x00 },
	{ 0x0360, 0x00 },
	{ 0x0361, 0x00 },
	{ 0x0362, 0x00 },
	{ 0x0487, 0x00 },
	{ 0x0502, 0x01 },
	{ 0x0508, 0x10 },
	{ 0x0509, 0x18 },
	{ 0x050A, 0x0F },
	{ 0x050B, 0x0F },
	{ 0x050C, 0x03 },
	{ 0x050D, 0x07 },
	{ 0x050E, 0x17 },
	{ 0x050F, 0x28 },
	{ 0x0510, 0x0C },
	{ 0x0511, 0x0B },
	{ 0x0512, 0x03 },
	{ 0x0513, 0x07 },
	{ 0x0515, 0x00 },
	{ 0x0516, 0x00 },
	{ 0x0517, 0x00 },
	{ 0x0518, 0x00 },
	{ 0x0519, 0xC0 },
	{ 0x051A, 0xBD },
	{ 0x051B, 0x00 },
	{ 0x051C, 0x00 },
	{ 0x051D, 0x00 },
	{ 0x051E, 0x00 },
	{ 0x051F, 0x80 },
	{ 0x0521, 0x2B },
	{ 0x052A, 0x01 },
	{ 0x052B, 0x01 },
	{ 0x052C, 0x0F },
	{ 0x052D, 0x03 },
	{ 0x052E, 0x15 },
	{ 0x052F, 0x14 },
	{ 0x0531, 0x00 },
	{ 0x0532, 0x7C },
	{ 0x0533, 0xE7 },
	{ 0x0534, 0x00 },
	{ 0x0535, 0x00 },
	{ 0x0536, 0x00 },
	{ 0x0537, 0x00 },
	{ 0x0538, 0x00 },
	{ 0x0539, 0x00 },
	{ 0x053A, 0x02 },
	{ 0x053B, 0x03 },
	{ 0x053C, 0x00 },
	{ 0x053D, 0x12 },
	{ 0x053E, 0x06 },
	{ 0x0589, 0xC9 },
	{ 0x058A, 0x03 },
	{ 0x059B, 0xF8 },
	{ 0x059D, 0x17 },
	{ 0x059E, 0x28 },
	{ 0x059F, 0x0C },
	{ 0x05A0, 0x0B },
	{ 0x05A1, 0x03 },
	{ 0x05A2, 0x07 },
	{ 0x05A6, 0x00 },
	{ 0x0802, 0x35 },
	{ 0x0803, 0x05 },
	{ 0x0804, 0x00 },
	{ 0x0805, 0x00 },
	{ 0x0806, 0x00 },
	{ 0x0807, 0x00 },
	{ 0x0808, 0x00 },
	{ 0x0809, 0x00 },
	{ 0x080A, 0x00 },
	{ 0x080B, 0x00 },
	{ 0x080C, 0x00 },
	{ 0x080D, 0x00 },
	{ 0x080E, 0x00 },
	{ 0x080F, 0x00 },
	{ 0x0810, 0x00 },
	{ 0x0811, 0x00 },
	{ 0x0812, 0x00 },
	{ 0x0813, 0x00 },
	{ 0x0814, 0x00 },
	{ 0x0815, 0x00 },
	{ 0x0816, 0x00 },
	{ 0x0817, 0x00 },
	{ 0x0818, 0x00 },
	{ 0x0819, 0x00 },
	{ 0x081A, 0x00 },
	{ 0x081B, 0x00 },
	{ 0x081C, 0x00 },
	{ 0x081D, 0x00 },
	{ 0x081E, 0x00 },
	{ 0x081F, 0x00 },
	{ 0x0820, 0x00 },
	{ 0x0821, 0x00 },
	{ 0x0822, 0x00 },
	{ 0x0823, 0x00 },
	{ 0x0824, 0x00 },
	{ 0x0825, 0x00 },
	{ 0x0826, 0x00 },
	{ 0x0827, 0x00 },
	{ 0x0828, 0x00 },
	{ 0x0829, 0x00 },
	{ 0x082A, 0x00 },
	{ 0x082B, 0x00 },
	{ 0x082C, 0x00 },
	{ 0x082D, 0x00 },
	{ 0x082E, 0x00 },
	{ 0x082F, 0x00 },
	{ 0x0830, 0x00 },
	{ 0x0831, 0x00 },
	{ 0x0832, 0x00 },
	{ 0x0833, 0x00 },
	{ 0x0834, 0x00 },
	{ 0x0835, 0x00 },
	{ 0x0836, 0x00 },
	{ 0x0837, 0x00 },
	{ 0x0838, 0x00 },
	{ 0x0839, 0x00 },
	{ 0x083A, 0x00 },
	{ 0x083B, 0x00 },
	{ 0x083C, 0x00 },
	{ 0x083D, 0x00 },
	{ 0x083E, 0x00 },
	{ 0x083F, 0x00 },
	{ 0x0840, 0x00 },
	{ 0x0841, 0x00 },
	{ 0x0842, 0x00 },
	{ 0x0843, 0x00 },
	{ 0x0844, 0x00 },
	{ 0x0845, 0x00 },
	{ 0x0846, 0x00 },
	{ 0x0847, 0x00 },
	{ 0x0848, 0x00 },
	{ 0x0849, 0x00 },
	{ 0x084A, 0x00 },
	{ 0x084B, 0x00 },
	{ 0x084C, 0x00 },
	{ 0x084D, 0x00 },
	{ 0x084E, 0x00 },
	{ 0x084F, 0x00 },
	{ 0x0850, 0x00 },
	{ 0x0851, 0x00 },
	{ 0x0852, 0x00 },
	{ 0x0853, 0x00 },
	{ 0x0854, 0x00 },
	{ 0x0855, 0x00 },
	{ 0x0856, 0x00 },
	{ 0x0857, 0x00 },
	{ 0x0858, 0x00 },
	{ 0x0859, 0x00 },
	{ 0x085A, 0x00 },
	{ 0x085B, 0x00 },
	{ 0x085C, 0x00 },
	{ 0x085D, 0x00 },
	{ 0x085E, 0x00 },
	{ 0x085F, 0x00 },
	{ 0x0860, 0x00 },
	{ 0x0861, 0x00 },
	{ 0x090E, 0x03 },
	{ 0x0943, 0x00 },
	{ 0x0949, 0x31 },
	{ 0x094A, 0x01 },
	{ 0x094E, 0x49 },
	{ 0x094F, 0x02 },
	{ 0x095E, 0x00 },
	{ 0x0A02, 0x00 },
	{ 0x0A03, 0x07 },
	{ 0x0A04, 0x01 },
	{ 0x0A05, 0x07 },
	{ 0x0A14, 0x00 },
	{ 0x0A1A, 0x00 },
	{ 0x0A20, 0x00 },
	{ 0x0A26, 0x00 },
	{ 0x0A2C, 0x00 },
	{ 0x0B44, 0x2F },
	{ 0x0B46, 0x00 },
	{ 0x0B47, 0x0E },
	{ 0x0B48, 0x0E },
	{ 0x0B4A, 0x18 },
	{ 0x0B57, 0xF9 },
	{ 0x0B58, 0x00 },
	/* End configuration registers */

	/* Start configuration postamble */
	{ 0x0514, 0x01 },
	{ 0x001C, 0x01 },
	{ 0x0540, 0x00 },
	{ 0x0B24, 0xC3 },
	{ 0x0B25, 0x02 },
	/* End configuration postamble */

	{ 0x0000, 0x00 }
};

/*
 * Design Report
 *
 * Overview
 * ========
 * Part:         Si5345 Rev D
 * Project File: C:\XilinxProjects\flint_tr051017\genlock\FormatFiles\IO4K+_1125_5994.slabtimeproj
 * Design ID:    IO4K+
 * Created By:   ClockBuilder Pro v2.16.1 [2017-07-19]
 * Timestamp:    2017-08-24 17:04:16 GMT-07:00
 * 
 * Design Notes
 * ============
 * assumes NTSC HSYNC (pulsed) input = (30/1.001)*525
 * 
 * Design Rule Check
 * =================
 * Errors:
 * - No errors
 * 
 * Warnings:
 * - Pulsed LVCMOS input buffer mode has been selected. This mode has non-standard input voltage logic thresholds: 0.33 V for Vil (max) and 0.49 V for Vih (min). Select this mode only if your input clock has a duty cycle significantly less or more than 50%.  Refer to the device datasheet for the exact threshold voltage specifications and the input attenuator circuit (DC coupled Pulsed LVCMOS) in the Family Reference Manual.
 * 
 * Device Grade
 * ============
 * Maximum Output Frequency: 148.5 MHz
 * Frequency Synthesis Mode: Fractional
 * Minimum Base OPN:         Si5345B
 * Actual Base OPN:          Si5345B
 * 
 * Base       Output Clock         Supported Frequency Synthesis Modes
 * OPN Grade  Frequency Range      (Typical Jitter)
 * ---------  -------------------  --------------------------------------------
 * Si5345A    100 Hz to 1.028 GHz  Integer (< 100 fs) and fractional (< 150 fs)
 * Si5345B    100 Hz to 350 MHz    "
 * Si5345C    100 Hz to 1.028 GHz  Integer only (< 100 fs)
 * Si5345D    100 Hz to 350 MHz    "
 * 
 * Design
 * ======
 * Host Interface:
 *    I/O Power Supply: VDD (Core)
 *    SPI Mode: 4-Wire
 *    I2C Address Range: 100d to 103d / 0x64 to 0x67 (selected via A0/A1 pins)
 * 
 * XA/XB:
 *    52 MHz (XO - External Oscillator)
 * 
 * Inputs:
 *     IN0: 28.125 kHz [ 28 + 1/8 kHz ]
 *          [ (25)*1125 ]
 *          Pulsed LVCMOS
 *     IN1: Unused
 *     IN2: Unused
 *     IN3: Unused
 * 
 * Outputs:
 *    OUT0: 27 MHz
 *          Enabled, LVDS 2.5 V
 *    OUT1: Unused
 *    OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT3: Unused
 *    OUT4: Unused
 *    OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT6: Unused
 *    OUT7: Unused
 *    OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *          [ 148.5/1.001 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT9: Unused
 * 
 * Frequency Plan
 * ==============
 * Priority: maximize the number of low jitter outputs
 * 
 * Fvco = 13.662 GHz [ 13 + 331/500 GHz ]
 * Fpfd = 28.125 kHz [ 28 + 1/8 kHz ]
 * Fms0 = 594 MHz
 * Fms1 = 147.456 MHz [ 147 + 57/125 MHz ]
 * Fms2 = 890.1098901098901098... MHz [ 890 + 10/91 MHz ]
 * 
 * P dividers:
 *    P0  = 1
 *    P1  = Unused
 *    P2  = Unused
 *    P3  = Unused
 *    Pxaxb = 1
 * 
 * MXAXB = 262.7307692307692307... [ 262 + 19/26 ]
 * M = 97152
 * N dividers:
 *    N0:
 *       Value: 23
 *       Skew:  0.000 s
 *       OUT0: 27 MHz
 *       OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *    N1:
 *       Value: 92.6513671875 [ 92 + 667/1024 ]
 *       Skew:  0.000 s
 *       OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *    N2:
 *       Value: 15.3486666666666666... [ 15 + 523/1500 ]
 *       Skew:  0.000 s
 *       OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *    N3:
 *       Unused
 *    N4:
 *       Unused
 * 
 * R dividers:
 *    R0 = 22
 *    R1 = Unused
 *    R2 = 4
 *    R3 = Unused
 *    R4 = Unused
 *    R5 = 6
 *    R6 = Unused
 *    R7 = Unused
 *    R8 = 6
 *    R9 = Unused
 * 
 * Nominal Bandwidth:
 *   Desired: 1.000 Hz
 *   Actual:  541.456 mHz
 *   Coefficients:
 *      BW0:  16
 *      BW1:  24
 *      BW2:  15
 *      BW3:  15
 *      BW4:  3
 *      BW5:  7
 * Fastlock Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  85.378 Hz
 *   Coefficients:
 *      BW0:  23
 *      BW1:  40
 *      BW2:  12
 *      BW3:  11
 *      BW4:  3
 *      BW5:  7
 * Holdover Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  85.378 Hz
 *   Coefficients:
 *      BW0:  23
 *      BW1:  40
 *      BW2:  12
 *      BW3:  11
 *      BW4:  3
 *      BW5:  7
 * 
 * Dividers listed above show effective values. These values are translated to register settings by ClockBuilder Pro. For the actual register values, see below. Refer to the Family Reference Manual for information on registers related to frequency plan.
 * 
 * Digitally Controlled Oscillator (DCO)
 * =====================================
 * Mode: Register Direct Write
 * 
 * N0: DCO Disabled
 * 
 * N1: DCO Disabled
 * 
 * N2: DCO Disabled
 * 
 * N3: DCO Disabled
 * 
 * N4: DCO Disabled
 * 
 * Estimated Power & Junction Temperature
 * ======================================
 * Assumptions:
 * 
 * Revision: D
 * VDD:      1.8 V
 * Ta:       70 C
 * Airflow:  None
 * 
 * Total Power: 808 mW, On Chip Power: 784 mW, Tj: 87 C
 * 
 *                 Frequency  Format   Voltage   Current     Power
 *         -----------------  ------  --------  --------  --------
 * VDD                                   1.8 V  147.9 mA    266 mW
 * VDDA                                  3.3 V  117.4 mA    387 mW
 * VDDO0              27 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO1              Unused                                      
 * VDDO2           148.5 MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO3              Unused                                      
 * VDDO4              Unused                                      
 * VDDO5          24.576 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO6              Unused                                      
 * VDDO7              Unused                                      
 * VDDO8   148.351648... MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO9              Unused                                      
 *                                              --------  --------
 *                                       Total  327.2 mA    808 mW
 * 
 * Note:
 * 
 * -Total power includes on- and off-chip power. This is a typical value and estimate only.
 * -Use an EVB for a more exact power measurement
 * -On-chip power excludes power dissipated in external terminations.
 * -Tj is junction temperature. Tj must be less than 125 C (on Si5345 Revision D) for device to comply with datasheet specifications.
 * 
 * Settings
 * ========
 * 
 * Location      Setting Name           Decimal Value      Hex Value        
 * ------------  ---------------------  -----------------  -----------------
 * 0x000B[6:0]   I2C_ADDR               100                0x64             
 * 0x0016[1]     LOL_ON_HOLD            1                  0x1              
 * 0x0017[0]     SYSINCAL_INTR_MSK      0                  0x0              
 * 0x0017[1]     LOSXAXB_INTR_MSK       0                  0x0              
 * 0x0017[5]     SMB_TMOUT_INTR_MSK     1                  0x1              
 * 0x0018[3:0]   LOS_INTR_MSK           15                 0xF              
 * 0x0018[7:4]   OOF_INTR_MSK           15                 0xF              
 * 0x0019[1]     LOL_INTR_MSK           1                  0x1              
 * 0x0019[5]     HOLD_INTR_MSK          0                  0x0              
 * 0x001A[5]     CAL_INTR_MSK           0                  0x0              
 * 0x002B[3]     SPI_3WIRE              0                  0x0              
 * 0x002B[5]     AUTO_NDIV_UPDATE       0                  0x0              
 * 0x002C[3:0]   LOS_EN                 1                  0x1              
 * 0x002C[4]     LOSXAXB_DIS            0                  0x0              
 * 0x002D[1:0]   LOS0_VAL_TIME          2                  0x2              
 * 0x002D[3:2]   LOS1_VAL_TIME          0                  0x0              
 * 0x002D[5:4]   LOS2_VAL_TIME          0                  0x0              
 * 0x002D[7:6]   LOS3_VAL_TIME          0                  0x0              
 * 0x002E[15:0]  LOS0_TRG_THR           2332               0x091C           
 * 0x0030[15:0]  LOS1_TRG_THR           0                  0x0000           
 * 0x0032[15:0]  LOS2_TRG_THR           0                  0x0000           
 * 0x0034[15:0]  LOS3_TRG_THR           0                  0x0000           
 * 0x0036[15:0]  LOS0_CLR_THR           2138               0x085A           
 * 0x0038[15:0]  LOS1_CLR_THR           0                  0x0000           
 * 0x003A[15:0]  LOS2_CLR_THR           0                  0x0000           
 * 0x003C[15:0]  LOS3_CLR_THR           0                  0x0000           
 * 0x003F[3:0]   OOF_EN                 1                  0x1              
 * 0x003F[7:4]   FAST_OOF_EN            0                  0x0              
 * 0x0040[2:0]   OOF_REF_SEL            4                  0x4              
 * 0x0041[4:0]   OOF0_DIV_SEL           1                  0x01             
 * 0x0042[4:0]   OOF1_DIV_SEL           0                  0x00             
 * 0x0043[4:0]   OOF2_DIV_SEL           0                  0x00             
 * 0x0044[4:0]   OOF3_DIV_SEL           0                  0x00             
 * 0x0045[4:0]   OOFXO_DIV_SEL          12                 0x0C             
 * 0x0046[7:0]   OOF0_SET_THR           150                0x96             
 * 0x0047[7:0]   OOF1_SET_THR           0                  0x00             
 * 0x0048[7:0]   OOF2_SET_THR           0                  0x00             
 * 0x0049[7:0]   OOF3_SET_THR           0                  0x00             
 * 0x004A[7:0]   OOF0_CLR_THR           75                 0x4B             
 * 0x004B[7:0]   OOF1_CLR_THR           0                  0x00             
 * 0x004C[7:0]   OOF2_CLR_THR           0                  0x00             
 * 0x004D[7:0]   OOF3_CLR_THR           0                  0x00             
 * 0x004E[2:0]   OOF0_DETWIN_SEL        5                  0x5              
 * 0x004E[6:4]   OOF1_DETWIN_SEL        0                  0x0              
 * 0x004F[2:0]   OOF2_DETWIN_SEL        0                  0x0              
 * 0x004F[6:4]   OOF3_DETWIN_SEL        0                  0x0              
 * 0x0050[3:0]   OOF_ON_LOS             15                 0xF              
 * 0x0051[3:0]   FAST_OOF0_SET_THR      0                  0x0              
 * 0x0052[3:0]   FAST_OOF1_SET_THR      0                  0x0              
 * 0x0053[3:0]   FAST_OOF2_SET_THR      0                  0x0              
 * 0x0054[3:0]   FAST_OOF3_SET_THR      0                  0x0              
 * 0x0055[3:0]   FAST_OOF0_CLR_THR      0                  0x0              
 * 0x0056[3:0]   FAST_OOF1_CLR_THR      0                  0x0              
 * 0x0057[3:0]   FAST_OOF2_CLR_THR      0                  0x0              
 * 0x0058[3:0]   FAST_OOF3_CLR_THR      0                  0x0              
 * 0x0059[1:0]   FAST_OOF0_DETWIN_SEL   1                  0x1              
 * 0x0059[3:2]   FAST_OOF1_DETWIN_SEL   0                  0x0              
 * 0x0059[5:4]   FAST_OOF2_DETWIN_SEL   0                  0x0              
 * 0x0059[7:6]   FAST_OOF3_DETWIN_SEL   0                  0x0              
 * 0x005A[25:0]  OOF0_RATIO_REF         18583993           0x11B91B9        
 * 0x005E[25:0]  OOF1_RATIO_REF         0                  0x0000000        
 * 0x0062[25:0]  OOF2_RATIO_REF         0                  0x0000000        
 * 0x0066[25:0]  OOF3_RATIO_REF         0                  0x0000000        
 * 0x0092[1]     LOL_FST_EN             1                  0x1              
 * 0x0093[7:4]   LOL_FST_DETWIN_SEL     10                 0xA              
 * 0x0095[3:2]   LOL_FST_VALWIN_SEL     0                  0x0              
 * 0x0096[7:4]   LOL_FST_SET_THR_SEL    9                  0x9              
 * 0x0098[7:4]   LOL_FST_CLR_THR_SEL    7                  0x7              
 * 0x009A[1]     LOL_SLOW_EN_PLL        1                  0x1              
 * 0x009B[7:4]   LOL_SLW_DETWIN_SEL     5                  0x5              
 * 0x009D[3:2]   LOL_SLW_VALWIN_SEL     1                  0x1              
 * 0x009E[7:4]   LOL_SLW_SET_THR        6                  0x6              
 * 0x00A0[7:4]   LOL_SLW_CLR_THR        3                  0x3              
 * 0x00A2[1]     LOL_TIMER_EN           0                  0x0              
 * 0x00A9[28:0]  LOL_CLR_DELAY_DIV256   304908             0x0004A70C       
 * 0x00E5[5]     FASTLOCK_EXTEND_EN     1                  0x1              
 * 0x00EA[28:0]  FASTLOCK_EXTEND        242129             0x0003B1D1       
 * 0x0102[0]     OUTALL_DISABLE_LOW     1                  0x1              
 * 0x0108[0]     OUT0_PDN               0                  0x0              
 * 0x0108[1]     OUT0_OE                1                  0x1              
 * 0x0108[2]     OUT0_RDIV_FORCE2       0                  0x0              
 * 0x0109[2:0]   OUT0_FORMAT            1                  0x1              
 * 0x0109[3]     OUT0_SYNC_EN           1                  0x1              
 * 0x0109[5:4]   OUT0_DIS_STATE         0                  0x0              
 * 0x0109[7:6]   OUT0_CMOS_DRV          0                  0x0              
 * 0x010A[3:0]   OUT0_CM                11                 0xB              
 * 0x010A[6:4]   OUT0_AMPL              3                  0x3              
 * 0x010B[2:0]   OUT0_MUX_SEL           0                  0x0              
 * 0x010B[5:4]   OUT0_VDD_SEL           2                  0x2              
 * 0x010B[3]     OUT0_VDD_SEL_EN        1                  0x1              
 * 0x010B[7:6]   OUT0_INV               0                  0x0              
 * 0x010D[0]     OUT1_PDN               1                  0x1              
 * 0x010D[1]     OUT1_OE                0                  0x0              
 * 0x010D[2]     OUT1_RDIV_FORCE2       0                  0x0              
 * 0x010E[2:0]   OUT1_FORMAT            1                  0x1              
 * 0x010E[3]     OUT1_SYNC_EN           1                  0x1              
 * 0x010E[5:4]   OUT1_DIS_STATE         0                  0x0              
 * 0x010E[7:6]   OUT1_CMOS_DRV          0                  0x0              
 * 0x010F[3:0]   OUT1_CM                11                 0xB              
 * 0x010F[6:4]   OUT1_AMPL              3                  0x3              
 * 0x0110[2:0]   OUT1_MUX_SEL           0                  0x0              
 * 0x0110[5:4]   OUT1_VDD_SEL           2                  0x2              
 * 0x0110[3]     OUT1_VDD_SEL_EN        1                  0x1              
 * 0x0110[7:6]   OUT1_INV               0                  0x0              
 * 0x0112[0]     OUT2_PDN               0                  0x0              
 * 0x0112[1]     OUT2_OE                1                  0x1              
 * 0x0112[2]     OUT2_RDIV_FORCE2       0                  0x0              
 * 0x0113[2:0]   OUT2_FORMAT            1                  0x1              
 * 0x0113[3]     OUT2_SYNC_EN           1                  0x1              
 * 0x0113[5:4]   OUT2_DIS_STATE         0                  0x0              
 * 0x0113[7:6]   OUT2_CMOS_DRV          0                  0x0              
 * 0x0114[3:0]   OUT2_CM                11                 0xB              
 * 0x0114[6:4]   OUT2_AMPL              3                  0x3              
 * 0x0115[2:0]   OUT2_MUX_SEL           0                  0x0              
 * 0x0115[5:4]   OUT2_VDD_SEL           2                  0x2              
 * 0x0115[3]     OUT2_VDD_SEL_EN        1                  0x1              
 * 0x0115[7:6]   OUT2_INV               0                  0x0              
 * 0x0117[0]     OUT3_PDN               1                  0x1              
 * 0x0117[1]     OUT3_OE                0                  0x0              
 * 0x0117[2]     OUT3_RDIV_FORCE2       0                  0x0              
 * 0x0118[2:0]   OUT3_FORMAT            1                  0x1              
 * 0x0118[3]     OUT3_SYNC_EN           1                  0x1              
 * 0x0118[5:4]   OUT3_DIS_STATE         0                  0x0              
 * 0x0118[7:6]   OUT3_CMOS_DRV          0                  0x0              
 * 0x0119[3:0]   OUT3_CM                11                 0xB              
 * 0x0119[6:4]   OUT3_AMPL              3                  0x3              
 * 0x011A[2:0]   OUT3_MUX_SEL           0                  0x0              
 * 0x011A[5:4]   OUT3_VDD_SEL           2                  0x2              
 * 0x011A[3]     OUT3_VDD_SEL_EN        1                  0x1              
 * 0x011A[7:6]   OUT3_INV               0                  0x0              
 * 0x011C[0]     OUT4_PDN               1                  0x1              
 * 0x011C[1]     OUT4_OE                0                  0x0              
 * 0x011C[2]     OUT4_RDIV_FORCE2       0                  0x0              
 * 0x011D[2:0]   OUT4_FORMAT            1                  0x1              
 * 0x011D[3]     OUT4_SYNC_EN           1                  0x1              
 * 0x011D[5:4]   OUT4_DIS_STATE         0                  0x0              
 * 0x011D[7:6]   OUT4_CMOS_DRV          0                  0x0              
 * 0x011E[3:0]   OUT4_CM                11                 0xB              
 * 0x011E[6:4]   OUT4_AMPL              3                  0x3              
 * 0x011F[2:0]   OUT4_MUX_SEL           0                  0x0              
 * 0x011F[5:4]   OUT4_VDD_SEL           2                  0x2              
 * 0x011F[3]     OUT4_VDD_SEL_EN        1                  0x1              
 * 0x011F[7:6]   OUT4_INV               0                  0x0              
 * 0x0121[0]     OUT5_PDN               0                  0x0              
 * 0x0121[1]     OUT5_OE                1                  0x1              
 * 0x0121[2]     OUT5_RDIV_FORCE2       0                  0x0              
 * 0x0122[2:0]   OUT5_FORMAT            1                  0x1              
 * 0x0122[3]     OUT5_SYNC_EN           1                  0x1              
 * 0x0122[5:4]   OUT5_DIS_STATE         0                  0x0              
 * 0x0122[7:6]   OUT5_CMOS_DRV          0                  0x0              
 * 0x0123[3:0]   OUT5_CM                11                 0xB              
 * 0x0123[6:4]   OUT5_AMPL              3                  0x3              
 * 0x0124[2:0]   OUT5_MUX_SEL           1                  0x1              
 * 0x0124[5:4]   OUT5_VDD_SEL           2                  0x2              
 * 0x0124[3]     OUT5_VDD_SEL_EN        1                  0x1              
 * 0x0124[7:6]   OUT5_INV               0                  0x0              
 * 0x0126[0]     OUT6_PDN               1                  0x1              
 * 0x0126[1]     OUT6_OE                0                  0x0              
 * 0x0126[2]     OUT6_RDIV_FORCE2       0                  0x0              
 * 0x0127[2:0]   OUT6_FORMAT            1                  0x1              
 * 0x0127[3]     OUT6_SYNC_EN           1                  0x1              
 * 0x0127[5:4]   OUT6_DIS_STATE         0                  0x0              
 * 0x0127[7:6]   OUT6_CMOS_DRV          0                  0x0              
 * 0x0128[3:0]   OUT6_CM                11                 0xB              
 * 0x0128[6:4]   OUT6_AMPL              3                  0x3              
 * 0x0129[2:0]   OUT6_MUX_SEL           0                  0x0              
 * 0x0129[5:4]   OUT6_VDD_SEL           2                  0x2              
 * 0x0129[3]     OUT6_VDD_SEL_EN        1                  0x1              
 * 0x0129[7:6]   OUT6_INV               0                  0x0              
 * 0x012B[0]     OUT7_PDN               1                  0x1              
 * 0x012B[1]     OUT7_OE                0                  0x0              
 * 0x012B[2]     OUT7_RDIV_FORCE2       0                  0x0              
 * 0x012C[2:0]   OUT7_FORMAT            1                  0x1              
 * 0x012C[3]     OUT7_SYNC_EN           1                  0x1              
 * 0x012C[5:4]   OUT7_DIS_STATE         0                  0x0              
 * 0x012C[7:6]   OUT7_CMOS_DRV          0                  0x0              
 * 0x012D[3:0]   OUT7_CM                11                 0xB              
 * 0x012D[6:4]   OUT7_AMPL              3                  0x3              
 * 0x012E[2:0]   OUT7_MUX_SEL           0                  0x0              
 * 0x012E[5:4]   OUT7_VDD_SEL           2                  0x2              
 * 0x012E[3]     OUT7_VDD_SEL_EN        1                  0x1              
 * 0x012E[7:6]   OUT7_INV               0                  0x0              
 * 0x0130[0]     OUT8_PDN               0                  0x0              
 * 0x0130[1]     OUT8_OE                1                  0x1              
 * 0x0130[2]     OUT8_RDIV_FORCE2       0                  0x0              
 * 0x0131[2:0]   OUT8_FORMAT            1                  0x1              
 * 0x0131[3]     OUT8_SYNC_EN           1                  0x1              
 * 0x0131[5:4]   OUT8_DIS_STATE         0                  0x0              
 * 0x0131[7:6]   OUT8_CMOS_DRV          0                  0x0              
 * 0x0132[3:0]   OUT8_CM                11                 0xB              
 * 0x0132[6:4]   OUT8_AMPL              3                  0x3              
 * 0x0133[2:0]   OUT8_MUX_SEL           2                  0x2              
 * 0x0133[5:4]   OUT8_VDD_SEL           2                  0x2              
 * 0x0133[3]     OUT8_VDD_SEL_EN        1                  0x1              
 * 0x0133[7:6]   OUT8_INV               0                  0x0              
 * 0x013A[0]     OUT9_PDN               1                  0x1              
 * 0x013A[1]     OUT9_OE                0                  0x0              
 * 0x013A[2]     OUT9_RDIV_FORCE2       0                  0x0              
 * 0x013B[2:0]   OUT9_FORMAT            1                  0x1              
 * 0x013B[3]     OUT9_SYNC_EN           1                  0x1              
 * 0x013B[5:4]   OUT9_DIS_STATE         0                  0x0              
 * 0x013B[7:6]   OUT9_CMOS_DRV          0                  0x0              
 * 0x013C[3:0]   OUT9_CM                11                 0xB              
 * 0x013C[6:4]   OUT9_AMPL              3                  0x3              
 * 0x013D[2:0]   OUT9_MUX_SEL           0                  0x0              
 * 0x013D[5:4]   OUT9_VDD_SEL           2                  0x2              
 * 0x013D[3]     OUT9_VDD_SEL_EN        1                  0x1              
 * 0x013D[7:6]   OUT9_INV               0                  0x0              
 * 0x013F[11:0]  OUTX_ALWAYS_ON         0                  0x000            
 * 0x0141[1]     OUT_DIS_MSK            0                  0x0              
 * 0x0141[5]     OUT_DIS_LOL_MSK        0                  0x0              
 * 0x0141[6]     OUT_DIS_LOSXAXB_MSK    1                  0x1              
 * 0x0141[7]     OUT_DIS_MSK_LOS_PFD    0                  0x0              
 * 0x0142[1]     OUT_DIS_MSK_LOL        1                  0x1              
 * 0x0142[5]     OUT_DIS_MSK_HOLD       1                  0x1              
 * 0x0206[1:0]   PXAXB                  0                  0x0              
 * 0x0208[47:0]  P0_NUM                 1                  0x000000000001   
 * 0x020E[31:0]  P0_DEN                 1                  0x00000001       
 * 0x0212[47:0]  P1_NUM                 0                  0x000000000000   
 * 0x0218[31:0]  P1_DEN                 0                  0x00000000       
 * 0x021C[47:0]  P2_NUM                 0                  0x000000000000   
 * 0x0222[31:0]  P2_DEN                 0                  0x00000000       
 * 0x0226[47:0]  P3_NUM                 0                  0x000000000000   
 * 0x022C[31:0]  P3_DEN                 0                  0x00000000       
 * 0x0231[3:0]   P0_FRACN_MODE          11                 0xB              
 * 0x0231[4]     P0_FRACN_EN            0                  0x0              
 * 0x0232[3:0]   P1_FRACN_MODE          11                 0xB              
 * 0x0232[4]     P1_FRACN_EN            0                  0x0              
 * 0x0233[3:0]   P2_FRACN_MODE          11                 0xB              
 * 0x0233[4]     P2_FRACN_EN            0                  0x0              
 * 0x0234[3:0]   P3_FRACN_MODE          11                 0xB              
 * 0x0234[4]     P3_FRACN_EN            0                  0x0              
 * 0x0235[43:0]  MXAXB_NUM              916841299968       0x0D578000000    
 * 0x023B[31:0]  MXAXB_DEN              3489660928         0xD0000000       
 * 0x024A[23:0]  R0_REG                 10                 0x00000A         
 * 0x024D[23:0]  R1_REG                 0                  0x000000         
 * 0x0250[23:0]  R2_REG                 1                  0x000001         
 * 0x0253[23:0]  R3_REG                 0                  0x000000         
 * 0x0256[23:0]  R4_REG                 0                  0x000000         
 * 0x0259[23:0]  R5_REG                 2                  0x000002         
 * 0x025C[23:0]  R6_REG                 0                  0x000000         
 * 0x025F[23:0]  R7_REG                 0                  0x000000         
 * 0x0262[23:0]  R8_REG                 2                  0x000002         
 * 0x0268[23:0]  R9_REG                 0                  0x000000         
 * 0x026B[7:0]   DESIGN_ID0             73                 0x49             
 * 0x026C[7:0]   DESIGN_ID1             79                 0x4F             
 * 0x026D[7:0]   DESIGN_ID2             52                 0x34             
 * 0x026E[7:0]   DESIGN_ID3             75                 0x4B             
 * 0x026F[7:0]   DESIGN_ID4             43                 0x2B             
 * 0x0270[7:0]   DESIGN_ID5             0                  0x00             
 * 0x0271[7:0]   DESIGN_ID6             0                  0x00             
 * 0x0272[7:0]   DESIGN_ID7             0                  0x00             
 * 0x0294[7:4]   FASTLOCK_EXTEND_SCL    8                  0x8              
 * 0x0296[1]     LOL_SLW_VALWIN_SELX    0                  0x0              
 * 0x0297[1]     FASTLOCK_DLY_ONSW_EN   1                  0x1              
 * 0x0299[1]     FASTLOCK_DLY_ONLOL_EN  1                  0x1              
 * 0x029D[19:0]  FASTLOCK_DLY_ONLOL     3829               0x00EF5          
 * 0x02A9[19:0]  FASTLOCK_DLY_ONSW      9830               0x02666          
 * 0x02B7[3:2]   LOL_NOSIG_TIME         3                  0x3              
 * 0x0302[43:0]  N0_NUM                 49392123904        0x00B80000000    
 * 0x0308[31:0]  N0_DEN                 2147483648         0x80000000       
 * 0x030C[0]     N0_UPDATE              0                  0x0              
 * 0x030D[43:0]  N1_NUM                 198967296000       0x02E53600000    
 * 0x0313[31:0]  N1_DEN                 2147483648         0x80000000       
 * 0x0317[0]     N1_UPDATE              0                  0x0              
 * 0x0318[43:0]  N2_NUM                 48282730496        0x00B3DE00000    
 * 0x031E[31:0]  N2_DEN                 3145728000         0xBB800000       
 * 0x0322[0]     N2_UPDATE              0                  0x0              
 * 0x0323[43:0]  N3_NUM                 0                  0x00000000000    
 * 0x0329[31:0]  N3_DEN                 0                  0x00000000       
 * 0x032D[0]     N3_UPDATE              0                  0x0              
 * 0x032E[43:0]  N4_NUM                 0                  0x00000000000    
 * 0x0334[31:0]  N4_DEN                 0                  0x00000000       
 * 0x0338[0]     N4_UPDATE              0                  0x0              
 * 0x0338[1]     N_UPDATE               0                  0x0              
 * 0x0339[4:0]   N_FSTEP_MSK            31                 0x1F             
 * 0x033B[43:0]  N0_FSTEPW              0                  0x00000000000    
 * 0x0341[43:0]  N1_FSTEPW              0                  0x00000000000    
 * 0x0347[43:0]  N2_FSTEPW              0                  0x00000000000    
 * 0x034D[43:0]  N3_FSTEPW              0                  0x00000000000    
 * 0x0353[43:0]  N4_FSTEPW              0                  0x00000000000    
 * 0x0359[15:0]  N0_DELAY               0                  0x0000           
 * 0x035B[15:0]  N1_DELAY               0                  0x0000           
 * 0x035D[15:0]  N2_DELAY               0                  0x0000           
 * 0x035F[15:0]  N3_DELAY               0                  0x0000           
 * 0x0361[15:0]  N4_DELAY               0                  0x0000           
 * 0x0487[0]     ZDM_EN                 0                  0x0              
 * 0x0487[2:1]   ZDM_IN_SEL             0                  0x0              
 * 0x0487[4]     ZDM_AUTOSW_EN          0                  0x0              
 * 0x0502[4]     ADD_DIV256             0                  0x0              
 * 0x0508[5:0]   BW0_PLL                16                 0x10             
 * 0x0509[5:0]   BW1_PLL                24                 0x18             
 * 0x050A[5:0]   BW2_PLL                15                 0x0F             
 * 0x050B[5:0]   BW3_PLL                15                 0x0F             
 * 0x050C[5:0]   BW4_PLL                3                  0x03             
 * 0x050D[5:0]   BW5_PLL                7                  0x07             
 * 0x050E[5:0]   FASTLOCK_BW0_PLL       23                 0x17             
 * 0x050F[5:0]   FASTLOCK_BW1_PLL       40                 0x28             
 * 0x0510[5:0]   FASTLOCK_BW2_PLL       12                 0x0C             
 * 0x0511[5:0]   FASTLOCK_BW3_PLL       11                 0x0B             
 * 0x0512[5:0]   FASTLOCK_BW4_PLL       3                  0x03             
 * 0x0513[5:0]   FASTLOCK_BW5_PLL       7                  0x07             
 * 0x0515[55:0]  M_NUM                  208632331370496    0x00BDC000000000 
 * 0x051C[31:0]  M_DEN                  2147483648         0x80000000       
 * 0x0521[3:0]   M_FRAC_MODE            11                 0xB              
 * 0x0521[4]     M_FRAC_EN              0                  0x0              
 * 0x0521[5]     PLL_OUT_RATE_SEL       1                  0x1              
 * 0x052A[0]     IN_SEL_REGCTRL         1                  0x1              
 * 0x052A[3:1]   IN_SEL                 0                  0x0              
 * 0x052B[0]     FASTLOCK_AUTO_EN       1                  0x1              
 * 0x052B[1]     FASTLOCK_MAN           0                  0x0              
 * 0x052C[0]     HOLD_EN                1                  0x1              
 * 0x052C[3]     HOLD_RAMP_BYP          1                  0x1              
 * 0x052C[4]     HOLDEXIT_BW_SEL1       0                  0x0              
 * 0x052C[7:5]   RAMP_STEP_INTERVAL     0                  0x0              
 * 0x052D[1]     HOLD_RAMPBYP_NOHIST    1                  0x1              
 * 0x052E[4:0]   HOLD_HIST_LEN          21                 0x15             
 * 0x052F[4:0]   HOLD_HIST_DELAY        20                 0x14             
 * 0x0531[4:0]   HOLD_REF_COUNT_FRC     0                  0x00             
 * 0x0532[23:0]  HOLD_15M_CYC_COUNT     59260              0x00E77C         
 * 0x0535[0]     FORCE_HOLD             0                  0x0              
 * 0x0536[1:0]   CLK_SWITCH_MODE        0                  0x0              
 * 0x0536[2]     HSW_EN                 0                  0x0              
 * 0x0537[3:0]   IN_LOS_MSK             0                  0x0              
 * 0x0537[7:4]   IN_OOF_MSK             0                  0x0              
 * 0x0538[2:0]   IN0_PRIORITY           0                  0x0              
 * 0x0538[6:4]   IN1_PRIORITY           0                  0x0              
 * 0x0539[2:0]   IN2_PRIORITY           0                  0x0              
 * 0x0539[6:4]   IN3_PRIORITY           0                  0x0              
 * 0x053A[1:0]   HSW_MODE               2                  0x2              
 * 0x053A[3:2]   HSW_PHMEAS_CTRL        0                  0x0              
 * 0x053B[9:0]   HSW_PHMEAS_THR         3                  0x003            
 * 0x053D[4:0]   HSW_COARSE_PM_LEN      18                 0x12             
 * 0x053E[4:0]   HSW_COARSE_PM_DLY      6                  0x06             
 * 0x0589[12:0]  CAP_SHORT_DELAY        969                0x03C9           
 * 0x059B[4]     HOLD_PRESERVE_HIST     1                  0x1              
 * 0x059B[5]     HOLD_FRZ_WITH_INTONLY  1                  0x1              
 * 0x059B[6]     HOLDEXIT_BW_SEL0       1                  0x1              
 * 0x059B[7]     HOLDEXIT_STD_BO        1                  0x1              
 * 0x059D[5:0]   HOLDEXIT_BW0           23                 0x17             
 * 0x059E[5:0]   HOLDEXIT_BW1           40                 0x28             
 * 0x059F[5:0]   HOLDEXIT_BW2           12                 0x0C             
 * 0x05A0[5:0]   HOLDEXIT_BW3           11                 0x0B             
 * 0x05A1[5:0]   HOLDEXIT_BW4           3                  0x03             
 * 0x05A2[5:0]   HOLDEXIT_BW5           7                  0x07             
 * 0x05A6[2:0]   RAMP_STEP_SIZE         0                  0x0              
 * 0x05A6[3]     RAMP_SWITCH_EN         0                  0x0              
 * 0x0802[15:0]  FIXREGSA0              1333               0x0535           
 * 0x0804[7:0]   FIXREGSD0              0                  0x00             
 * 0x0805[15:0]  FIXREGSA1              0                  0x0000           
 * 0x0807[7:0]   FIXREGSD1              0                  0x00             
 * 0x0808[15:0]  FIXREGSA2              0                  0x0000           
 * 0x080A[7:0]   FIXREGSD2              0                  0x00             
 * 0x080B[15:0]  FIXREGSA3              0                  0x0000           
 * 0x080D[7:0]   FIXREGSD3              0                  0x00             
 * 0x080E[15:0]  FIXREGSA4              0                  0x0000           
 * 0x0810[7:0]   FIXREGSD4              0                  0x00             
 * 0x0811[15:0]  FIXREGSA5              0                  0x0000           
 * 0x0813[7:0]   FIXREGSD5              0                  0x00             
 * 0x0814[15:0]  FIXREGSA6              0                  0x0000           
 * 0x0816[7:0]   FIXREGSD6              0                  0x00             
 * 0x0817[15:0]  FIXREGSA7              0                  0x0000           
 * 0x0819[7:0]   FIXREGSD7              0                  0x00             
 * 0x081A[15:0]  FIXREGSA8              0                  0x0000           
 * 0x081C[7:0]   FIXREGSD8              0                  0x00             
 * 0x081D[15:0]  FIXREGSA9              0                  0x0000           
 * 0x081F[7:0]   FIXREGSD9              0                  0x00             
 * 0x0820[15:0]  FIXREGSA10             0                  0x0000           
 * 0x0822[7:0]   FIXREGSD10             0                  0x00             
 * 0x0823[15:0]  FIXREGSA11             0                  0x0000           
 * 0x0825[7:0]   FIXREGSD11             0                  0x00             
 * 0x0826[15:0]  FIXREGSA12             0                  0x0000           
 * 0x0828[7:0]   FIXREGSD12             0                  0x00             
 * 0x0829[15:0]  FIXREGSA13             0                  0x0000           
 * 0x082B[7:0]   FIXREGSD13             0                  0x00             
 * 0x082C[15:0]  FIXREGSA14             0                  0x0000           
 * 0x082E[7:0]   FIXREGSD14             0                  0x00             
 * 0x082F[15:0]  FIXREGSA15             0                  0x0000           
 * 0x0831[7:0]   FIXREGSD15             0                  0x00             
 * 0x0832[15:0]  FIXREGSA16             0                  0x0000           
 * 0x0834[7:0]   FIXREGSD16             0                  0x00             
 * 0x0835[15:0]  FIXREGSA17             0                  0x0000           
 * 0x0837[7:0]   FIXREGSD17             0                  0x00             
 * 0x0838[15:0]  FIXREGSA18             0                  0x0000           
 * 0x083A[7:0]   FIXREGSD18             0                  0x00             
 * 0x083B[15:0]  FIXREGSA19             0                  0x0000           
 * 0x083D[7:0]   FIXREGSD19             0                  0x00             
 * 0x083E[15:0]  FIXREGSA20             0                  0x0000           
 * 0x0840[7:0]   FIXREGSD20             0                  0x00             
 * 0x0841[15:0]  FIXREGSA21             0                  0x0000           
 * 0x0843[7:0]   FIXREGSD21             0                  0x00             
 * 0x0844[15:0]  FIXREGSA22             0                  0x0000           
 * 0x0846[7:0]   FIXREGSD22             0                  0x00             
 * 0x0847[15:0]  FIXREGSA23             0                  0x0000           
 * 0x0849[7:0]   FIXREGSD23             0                  0x00             
 * 0x084A[15:0]  FIXREGSA24             0                  0x0000           
 * 0x084C[7:0]   FIXREGSD24             0                  0x00             
 * 0x084D[15:0]  FIXREGSA25             0                  0x0000           
 * 0x084F[7:0]   FIXREGSD25             0                  0x00             
 * 0x0850[15:0]  FIXREGSA26             0                  0x0000           
 * 0x0852[7:0]   FIXREGSD26             0                  0x00             
 * 0x0853[15:0]  FIXREGSA27             0                  0x0000           
 * 0x0855[7:0]   FIXREGSD27             0                  0x00             
 * 0x0856[15:0]  FIXREGSA28             0                  0x0000           
 * 0x0858[7:0]   FIXREGSD28             0                  0x00             
 * 0x0859[15:0]  FIXREGSA29             0                  0x0000           
 * 0x085B[7:0]   FIXREGSD29             0                  0x00             
 * 0x085C[15:0]  FIXREGSA30             0                  0x0000           
 * 0x085E[7:0]   FIXREGSD30             0                  0x00             
 * 0x085F[15:0]  FIXREGSA31             0                  0x0000           
 * 0x0861[7:0]   FIXREGSD31             0                  0x00             
 * 0x090E[0]     XAXB_EXTCLK_EN         1                  0x1              
 * 0x0943[0]     IO_VDD_SEL             0                  0x0              
 * 0x0949[3:0]   IN_EN                  1                  0x1              
 * 0x0949[7:4]   IN_PULSED_CMOS_EN      3                  0x3              
 * 0x094A[3:0]   INX_TO_PFD_EN          1                  0x1              
 * 0x094E[11:0]  REFCLK_HYS_SEL         585                0x249            
 * 0x095E[0]     MXAXB_INTEGER          0                  0x0              
 * 0x0A02[4:0]   N_ADD_0P5              0                  0x00             
 * 0x0A03[4:0]   N_CLK_TO_OUTX_EN       7                  0x07             
 * 0x0A04[4:0]   N_PIBYP                1                  0x01             
 * 0x0A05[4:0]   N_PDNB                 7                  0x07             
 * 0x0A14[3]     N0_HIGH_FREQ           0                  0x0              
 * 0x0A1A[3]     N1_HIGH_FREQ           0                  0x0              
 * 0x0A20[3]     N2_HIGH_FREQ           0                  0x0              
 * 0x0A26[3]     N3_HIGH_FREQ           0                  0x0              
 * 0x0A2C[3]     N4_HIGH_FREQ           0                  0x0              
 * 0x0B44[3:0]   PDIV_FRACN_CLK_DIS     15                 0xF              
 * 0x0B44[5]     FRACN_CLK_DIS_PLL      1                  0x1              
 * 0x0B46[3:0]   LOS_CLK_DIS            0                  0x0              
 * 0x0B47[4:0]   OOF_CLK_DIS            14                 0x0E             
 * 0x0B48[4:0]   OOF_DIV_CLK_DIS        14                 0x0E             
 * 0x0B4A[4:0]   N_CLK_DIS              24                 0x18             
 * 0x0B57[11:0]  VCO_RESET_CALCODE      249                0x0F9
 * 
 *
 */


static struct ntv2_genlock_data s_genlock_1125_2997[] =
{
	/* Start configuration preamble */
	{ 0x0B24, 0xC0 },
	{ 0x0B25, 0x00 },
	{ 0x0540, 0x01 },
	/* End configuration preamble */

	/* Delay 300 msec */
	/*    Delay is worst case time for device to complete any calibration */
	/*    that is running due to device state change previous to this script */
	/*    being processed. */
	{ 0x0000, 0x01 },

	/* Start configuration registers */
	{ 0x000B, 0x64 },
	{ 0x0016, 0x02 },
	{ 0x0017, 0xFC },
	{ 0x0018, 0xFF },
	{ 0x0019, 0xDF },
	{ 0x001A, 0xDF },
	{ 0x002B, 0x02 },
	{ 0x002C, 0x01 },
	{ 0x002D, 0x02 },
	{ 0x002E, 0x99 },
	{ 0x002F, 0x07 },
	{ 0x0030, 0x00 },
	{ 0x0031, 0x00 },
	{ 0x0032, 0x00 },
	{ 0x0033, 0x00 },
	{ 0x0034, 0x00 },
	{ 0x0035, 0x00 },
	{ 0x0036, 0xF7 },
	{ 0x0037, 0x06 },
	{ 0x0038, 0x00 },
	{ 0x0039, 0x00 },
	{ 0x003A, 0x00 },
	{ 0x003B, 0x00 },
	{ 0x003C, 0x00 },
	{ 0x003D, 0x00 },
	{ 0x003F, 0x01 },
	{ 0x0040, 0x04 },
	{ 0x0041, 0x02 },
	{ 0x0042, 0x00 },
	{ 0x0043, 0x00 },
	{ 0x0044, 0x00 },
	{ 0x0045, 0x0C },
	{ 0x0046, 0x96 },
	{ 0x0047, 0x00 },
	{ 0x0048, 0x00 },
	{ 0x0049, 0x00 },
	{ 0x004A, 0x4B },
	{ 0x004B, 0x00 },
	{ 0x004C, 0x00 },
	{ 0x004D, 0x00 },
	{ 0x004E, 0x05 },
	{ 0x004F, 0x00 },
	{ 0x0050, 0x0F },
	{ 0x0051, 0x00 },
	{ 0x0052, 0x00 },
	{ 0x0053, 0x00 },
	{ 0x0054, 0x00 },
	{ 0x0055, 0x00 },
	{ 0x0056, 0x00 },
	{ 0x0057, 0x00 },
	{ 0x0058, 0x00 },
	{ 0x0059, 0x01 },
	{ 0x005A, 0xB8 },
	{ 0x005B, 0xF8 },
	{ 0x005C, 0xA9 },
	{ 0x005D, 0x00 },
	{ 0x005E, 0x00 },
	{ 0x005F, 0x00 },
	{ 0x0060, 0x00 },
	{ 0x0061, 0x00 },
	{ 0x0062, 0x00 },
	{ 0x0063, 0x00 },
	{ 0x0064, 0x00 },
	{ 0x0065, 0x00 },
	{ 0x0066, 0x00 },
	{ 0x0067, 0x00 },
	{ 0x0068, 0x00 },
	{ 0x0069, 0x00 },
	{ 0x0092, 0x02 },
	{ 0x0093, 0xA0 },
	{ 0x0095, 0x00 },
	{ 0x0096, 0x90 },
	{ 0x0098, 0x70 },
	{ 0x009A, 0x02 },
	{ 0x009B, 0x50 },
	{ 0x009D, 0x04 },
	{ 0x009E, 0x60 },
	{ 0x00A0, 0x30 },
	{ 0x00A2, 0x00 },
	{ 0x00A9, 0xB7 },
	{ 0x00AA, 0x7D },
	{ 0x00AB, 0x04 },
	{ 0x00AC, 0x00 },
	{ 0x00E5, 0x21 },
	{ 0x00EA, 0xD1 },
	{ 0x00EB, 0xB1 },
	{ 0x00EC, 0x03 },
	{ 0x00ED, 0x00 },
	{ 0x0102, 0x01 },
	{ 0x0108, 0x02 },
	{ 0x0109, 0x09 },
	{ 0x010A, 0x3B },
	{ 0x010B, 0x28 },
	{ 0x010D, 0x01 },
	{ 0x010E, 0x09 },
	{ 0x010F, 0x3B },
	{ 0x0110, 0x28 },
	{ 0x0112, 0x02 },
	{ 0x0113, 0x09 },
	{ 0x0114, 0x3B },
	{ 0x0115, 0x28 },
	{ 0x0117, 0x01 },
	{ 0x0118, 0x09 },
	{ 0x0119, 0x3B },
	{ 0x011A, 0x28 },
	{ 0x011C, 0x01 },
	{ 0x011D, 0x09 },
	{ 0x011E, 0x3B },
	{ 0x011F, 0x28 },
	{ 0x0121, 0x02 },
	{ 0x0122, 0x09 },
	{ 0x0123, 0x3B },
	{ 0x0124, 0x29 },
	{ 0x0126, 0x01 },
	{ 0x0127, 0x09 },
	{ 0x0128, 0x3B },
	{ 0x0129, 0x28 },
	{ 0x012B, 0x01 },
	{ 0x012C, 0x09 },
	{ 0x012D, 0x3B },
	{ 0x012E, 0x28 },
	{ 0x0130, 0x02 },
	{ 0x0131, 0x09 },
	{ 0x0132, 0x3B },
	{ 0x0133, 0x2A },
	{ 0x013A, 0x01 },
	{ 0x013B, 0x09 },
	{ 0x013C, 0x3B },
	{ 0x013D, 0x28 },
	{ 0x013F, 0x00 },
	{ 0x0140, 0x00 },
	{ 0x0141, 0x40 },
	{ 0x0142, 0xFF },
	{ 0x0206, 0x00 },
	{ 0x0208, 0x01 },
	{ 0x0209, 0x00 },
	{ 0x020A, 0x00 },
	{ 0x020B, 0x00 },
	{ 0x020C, 0x00 },
	{ 0x020D, 0x00 },
	{ 0x020E, 0x01 },
	{ 0x020F, 0x00 },
	{ 0x0210, 0x00 },
	{ 0x0211, 0x00 },
	{ 0x0212, 0x00 },
	{ 0x0213, 0x00 },
	{ 0x0214, 0x00 },
	{ 0x0215, 0x00 },
	{ 0x0216, 0x00 },
	{ 0x0217, 0x00 },
	{ 0x0218, 0x00 },
	{ 0x0219, 0x00 },
	{ 0x021A, 0x00 },
	{ 0x021B, 0x00 },
	{ 0x021C, 0x00 },
	{ 0x021D, 0x00 },
	{ 0x021E, 0x00 },
	{ 0x021F, 0x00 },
	{ 0x0220, 0x00 },
	{ 0x0221, 0x00 },
	{ 0x0222, 0x00 },
	{ 0x0223, 0x00 },
	{ 0x0224, 0x00 },
	{ 0x0225, 0x00 },
	{ 0x0226, 0x00 },
	{ 0x0227, 0x00 },
	{ 0x0228, 0x00 },
	{ 0x0229, 0x00 },
	{ 0x022A, 0x00 },
	{ 0x022B, 0x00 },
	{ 0x022C, 0x00 },
	{ 0x022D, 0x00 },
	{ 0x022E, 0x00 },
	{ 0x022F, 0x00 },
	{ 0x0231, 0x0B },
	{ 0x0232, 0x0B },
	{ 0x0233, 0x0B },
	{ 0x0234, 0x0B },
	{ 0x0235, 0x00 },
	{ 0x0236, 0x00 },
	{ 0x0237, 0x00 },
	{ 0x0238, 0x78 },
	{ 0x0239, 0xD5 },
	{ 0x023A, 0x00 },
	{ 0x023B, 0x00 },
	{ 0x023C, 0x00 },
	{ 0x023D, 0x00 },
	{ 0x023E, 0xD0 },
	{ 0x024A, 0x0A },
	{ 0x024B, 0x00 },
	{ 0x024C, 0x00 },
	{ 0x024D, 0x00 },
	{ 0x024E, 0x00 },
	{ 0x024F, 0x00 },
	{ 0x0250, 0x01 },
	{ 0x0251, 0x00 },
	{ 0x0252, 0x00 },
	{ 0x0253, 0x00 },
	{ 0x0254, 0x00 },
	{ 0x0255, 0x00 },
	{ 0x0256, 0x00 },
	{ 0x0257, 0x00 },
	{ 0x0258, 0x00 },
	{ 0x0259, 0x02 },
	{ 0x025A, 0x00 },
	{ 0x025B, 0x00 },
	{ 0x025C, 0x00 },
	{ 0x025D, 0x00 },
	{ 0x025E, 0x00 },
	{ 0x025F, 0x00 },
	{ 0x0260, 0x00 },
	{ 0x0261, 0x00 },
	{ 0x0262, 0x02 },
	{ 0x0263, 0x00 },
	{ 0x0264, 0x00 },
	{ 0x0268, 0x00 },
	{ 0x0269, 0x00 },
	{ 0x026A, 0x00 },
	{ 0x026B, 0x49 },
	{ 0x026C, 0x4F },
	{ 0x026D, 0x34 },
	{ 0x026E, 0x4B },
	{ 0x026F, 0x2B },
	{ 0x0270, 0x00 },
	{ 0x0271, 0x00 },
	{ 0x0272, 0x00 },
	{ 0x0294, 0x80 },
	{ 0x0296, 0x00 },
	{ 0x0297, 0x02 },
	{ 0x0299, 0x02 },
	{ 0x029D, 0xF5 },
	{ 0x029E, 0x0E },
	{ 0x029F, 0x00 },
	{ 0x02A9, 0x66 },
	{ 0x02AA, 0x26 },
	{ 0x02AB, 0x00 },
	{ 0x02B7, 0xFF },
	{ 0x0302, 0x00 },
	{ 0x0303, 0x00 },
	{ 0x0304, 0x00 },
	{ 0x0305, 0x80 },
	{ 0x0306, 0x0B },
	{ 0x0307, 0x00 },
	{ 0x0308, 0x00 },
	{ 0x0309, 0x00 },
	{ 0x030A, 0x00 },
	{ 0x030B, 0x80 },
	{ 0x030C, 0x00 },
	{ 0x030D, 0x00 },
	{ 0x030E, 0x00 },
	{ 0x030F, 0x60 },
	{ 0x0310, 0x53 },
	{ 0x0311, 0x2E },
	{ 0x0312, 0x00 },
	{ 0x0313, 0x00 },
	{ 0x0314, 0x00 },
	{ 0x0315, 0x00 },
	{ 0x0316, 0x80 },
	{ 0x0317, 0x00 },
	{ 0x0318, 0x00 },
	{ 0x0319, 0x00 },
	{ 0x031A, 0xE0 },
	{ 0x031B, 0x3D },
	{ 0x031C, 0x0B },
	{ 0x031D, 0x00 },
	{ 0x031E, 0x00 },
	{ 0x031F, 0x00 },
	{ 0x0320, 0x80 },
	{ 0x0321, 0xBB },
	{ 0x0322, 0x00 },
	{ 0x0323, 0x00 },
	{ 0x0324, 0x00 },
	{ 0x0325, 0x00 },
	{ 0x0326, 0x00 },
	{ 0x0327, 0x00 },
	{ 0x0328, 0x00 },
	{ 0x0329, 0x00 },
	{ 0x032A, 0x00 },
	{ 0x032B, 0x00 },
	{ 0x032C, 0x00 },
	{ 0x032D, 0x00 },
	{ 0x032E, 0x00 },
	{ 0x032F, 0x00 },
	{ 0x0330, 0x00 },
	{ 0x0331, 0x00 },
	{ 0x0332, 0x00 },
	{ 0x0333, 0x00 },
	{ 0x0334, 0x00 },
	{ 0x0335, 0x00 },
	{ 0x0336, 0x00 },
	{ 0x0337, 0x00 },
	{ 0x0338, 0x00 },
	{ 0x0339, 0x1F },
	{ 0x033B, 0x00 },
	{ 0x033C, 0x00 },
	{ 0x033D, 0x00 },
	{ 0x033E, 0x00 },
	{ 0x033F, 0x00 },
	{ 0x0340, 0x00 },
	{ 0x0341, 0x00 },
	{ 0x0342, 0x00 },
	{ 0x0343, 0x00 },
	{ 0x0344, 0x00 },
	{ 0x0345, 0x00 },
	{ 0x0346, 0x00 },
	{ 0x0347, 0x00 },
	{ 0x0348, 0x00 },
	{ 0x0349, 0x00 },
	{ 0x034A, 0x00 },
	{ 0x034B, 0x00 },
	{ 0x034C, 0x00 },
	{ 0x034D, 0x00 },
	{ 0x034E, 0x00 },
	{ 0x034F, 0x00 },
	{ 0x0350, 0x00 },
	{ 0x0351, 0x00 },
	{ 0x0352, 0x00 },
	{ 0x0353, 0x00 },
	{ 0x0354, 0x00 },
	{ 0x0355, 0x00 },
	{ 0x0356, 0x00 },
	{ 0x0357, 0x00 },
	{ 0x0358, 0x00 },
	{ 0x0359, 0x00 },
	{ 0x035A, 0x00 },
	{ 0x035B, 0x00 },
	{ 0x035C, 0x00 },
	{ 0x035D, 0x00 },
	{ 0x035E, 0x00 },
	{ 0x035F, 0x00 },
	{ 0x0360, 0x00 },
	{ 0x0361, 0x00 },
	{ 0x0362, 0x00 },
	{ 0x0487, 0x00 },
	{ 0x0502, 0x01 },
	{ 0x0508, 0x11 },
	{ 0x0509, 0x19 },
	{ 0x050A, 0x0F },
	{ 0x050B, 0x0F },
	{ 0x050C, 0x01 },
	{ 0x050D, 0x07 },
	{ 0x050E, 0x18 },
	{ 0x050F, 0x29 },
	{ 0x0510, 0x0C },
	{ 0x0511, 0x0B },
	{ 0x0512, 0x01 },
	{ 0x0513, 0x07 },
	{ 0x0515, 0x00 },
	{ 0x0516, 0x00 },
	{ 0x0517, 0x00 },
	{ 0x0518, 0x40 },
	{ 0x0519, 0x51 },
	{ 0x051A, 0xF7 },
	{ 0x051B, 0x00 },
	{ 0x051C, 0x00 },
	{ 0x051D, 0x00 },
	{ 0x051E, 0x00 },
	{ 0x051F, 0xC8 },
	{ 0x0521, 0x3B },
	{ 0x052A, 0x01 },
	{ 0x052B, 0x01 },
	{ 0x052C, 0x0F },
	{ 0x052D, 0x03 },
	{ 0x052E, 0x15 },
	{ 0x052F, 0x14 },
	{ 0x0531, 0x00 },
	{ 0x0532, 0x19 },
	{ 0x0533, 0xC1 },
	{ 0x0534, 0x00 },
	{ 0x0535, 0x00 },
	{ 0x0536, 0x00 },
	{ 0x0537, 0x00 },
	{ 0x0538, 0x00 },
	{ 0x0539, 0x00 },
	{ 0x053A, 0x02 },
	{ 0x053B, 0x03 },
	{ 0x053C, 0x00 },
	{ 0x053D, 0x12 },
	{ 0x053E, 0x06 },
	{ 0x0589, 0x27 },
	{ 0x058A, 0x03 },
	{ 0x059B, 0xF8 },
	{ 0x059D, 0x18 },
	{ 0x059E, 0x29 },
	{ 0x059F, 0x0C },
	{ 0x05A0, 0x0B },
	{ 0x05A1, 0x01 },
	{ 0x05A2, 0x07 },
	{ 0x05A6, 0x00 },
	{ 0x0802, 0x35 },
	{ 0x0803, 0x05 },
	{ 0x0804, 0x00 },
	{ 0x0805, 0x00 },
	{ 0x0806, 0x00 },
	{ 0x0807, 0x00 },
	{ 0x0808, 0x00 },
	{ 0x0809, 0x00 },
	{ 0x080A, 0x00 },
	{ 0x080B, 0x00 },
	{ 0x080C, 0x00 },
	{ 0x080D, 0x00 },
	{ 0x080E, 0x00 },
	{ 0x080F, 0x00 },
	{ 0x0810, 0x00 },
	{ 0x0811, 0x00 },
	{ 0x0812, 0x00 },
	{ 0x0813, 0x00 },
	{ 0x0814, 0x00 },
	{ 0x0815, 0x00 },
	{ 0x0816, 0x00 },
	{ 0x0817, 0x00 },
	{ 0x0818, 0x00 },
	{ 0x0819, 0x00 },
	{ 0x081A, 0x00 },
	{ 0x081B, 0x00 },
	{ 0x081C, 0x00 },
	{ 0x081D, 0x00 },
	{ 0x081E, 0x00 },
	{ 0x081F, 0x00 },
	{ 0x0820, 0x00 },
	{ 0x0821, 0x00 },
	{ 0x0822, 0x00 },
	{ 0x0823, 0x00 },
	{ 0x0824, 0x00 },
	{ 0x0825, 0x00 },
	{ 0x0826, 0x00 },
	{ 0x0827, 0x00 },
	{ 0x0828, 0x00 },
	{ 0x0829, 0x00 },
	{ 0x082A, 0x00 },
	{ 0x082B, 0x00 },
	{ 0x082C, 0x00 },
	{ 0x082D, 0x00 },
	{ 0x082E, 0x00 },
	{ 0x082F, 0x00 },
	{ 0x0830, 0x00 },
	{ 0x0831, 0x00 },
	{ 0x0832, 0x00 },
	{ 0x0833, 0x00 },
	{ 0x0834, 0x00 },
	{ 0x0835, 0x00 },
	{ 0x0836, 0x00 },
	{ 0x0837, 0x00 },
	{ 0x0838, 0x00 },
	{ 0x0839, 0x00 },
	{ 0x083A, 0x00 },
	{ 0x083B, 0x00 },
	{ 0x083C, 0x00 },
	{ 0x083D, 0x00 },
	{ 0x083E, 0x00 },
	{ 0x083F, 0x00 },
	{ 0x0840, 0x00 },
	{ 0x0841, 0x00 },
	{ 0x0842, 0x00 },
	{ 0x0843, 0x00 },
	{ 0x0844, 0x00 },
	{ 0x0845, 0x00 },
	{ 0x0846, 0x00 },
	{ 0x0847, 0x00 },
	{ 0x0848, 0x00 },
	{ 0x0849, 0x00 },
	{ 0x084A, 0x00 },
	{ 0x084B, 0x00 },
	{ 0x084C, 0x00 },
	{ 0x084D, 0x00 },
	{ 0x084E, 0x00 },
	{ 0x084F, 0x00 },
	{ 0x0850, 0x00 },
	{ 0x0851, 0x00 },
	{ 0x0852, 0x00 },
	{ 0x0853, 0x00 },
	{ 0x0854, 0x00 },
	{ 0x0855, 0x00 },
	{ 0x0856, 0x00 },
	{ 0x0857, 0x00 },
	{ 0x0858, 0x00 },
	{ 0x0859, 0x00 },
	{ 0x085A, 0x00 },
	{ 0x085B, 0x00 },
	{ 0x085C, 0x00 },
	{ 0x085D, 0x00 },
	{ 0x085E, 0x00 },
	{ 0x085F, 0x00 },
	{ 0x0860, 0x00 },
	{ 0x0861, 0x00 },
	{ 0x090E, 0x03 },
	{ 0x0943, 0x00 },
	{ 0x0949, 0x31 },
	{ 0x094A, 0x01 },
	{ 0x094E, 0x49 },
	{ 0x094F, 0x02 },
	{ 0x095E, 0x00 },
	{ 0x0A02, 0x00 },
	{ 0x0A03, 0x07 },
	{ 0x0A04, 0x01 },
	{ 0x0A05, 0x07 },
	{ 0x0A14, 0x00 },
	{ 0x0A1A, 0x00 },
	{ 0x0A20, 0x00 },
	{ 0x0A26, 0x00 },
	{ 0x0A2C, 0x00 },
	{ 0x0B44, 0x0F },
	{ 0x0B46, 0x00 },
	{ 0x0B47, 0x0E },
	{ 0x0B48, 0x0E },
	{ 0x0B4A, 0x18 },
	{ 0x0B57, 0xF9 },
	{ 0x0B58, 0x00 },
	/* End configuration registers */

	/* Start configuration postamble */
	{ 0x0514, 0x01 },
	{ 0x001C, 0x01 },
	{ 0x0540, 0x00 },
	{ 0x0B24, 0xC3 },
	{ 0x0B25, 0x02 },
	/* End configuration postamble */

	{ 0x0000, 0x00 }
};

/*
 * Design Report
 *
 * Overview
 * ========
 * Part:         Si5345 Rev D
 * Project File: C:\XilinxProjects\flint_tr051017\genlock\FormatFiles\IO4K+_1125_5994.slabtimeproj
 * Design ID:    IO4K+
 * Created By:   ClockBuilder Pro v2.16.1 [2017-07-19]
 * Timestamp:    2017-08-24 16:36:10 GMT-07:00
 * 
 * Design Notes
 * ============
 * assumes NTSC HSYNC (pulsed) input = (30/1.001)*525
 * 
 * Design Rule Check
 * =================
 * Errors:
 * - No errors
 * 
 * Warnings:
 * - Pulsed LVCMOS input buffer mode has been selected. This mode has non-standard input voltage logic thresholds: 0.33 V for Vil (max) and 0.49 V for Vih (min). Select this mode only if your input clock has a duty cycle significantly less or more than 50%.  Refer to the device datasheet for the exact threshold voltage specifications and the input attenuator circuit (DC coupled Pulsed LVCMOS) in the Family Reference Manual.
 * 
 * Device Grade
 * ============
 * Maximum Output Frequency: 148.5 MHz
 * Frequency Synthesis Mode: Fractional
 * Minimum Base OPN:         Si5345B
 * Actual Base OPN:          Si5345B
 * 
 * Base       Output Clock         Supported Frequency Synthesis Modes
 * OPN Grade  Frequency Range      (Typical Jitter)
 * ---------  -------------------  --------------------------------------------
 * Si5345A    100 Hz to 1.028 GHz  Integer (< 100 fs) and fractional (< 150 fs)
 * Si5345B    100 Hz to 350 MHz    "
 * Si5345C    100 Hz to 1.028 GHz  Integer only (< 100 fs)
 * Si5345D    100 Hz to 350 MHz    "
 * 
 * Design
 * ======
 * Host Interface:
 *    I/O Power Supply: VDD (Core)
 *    SPI Mode: 4-Wire
 *    I2C Address Range: 100d to 103d / 0x64 to 0x67 (selected via A0/A1 pins)
 * 
 * XA/XB:
 *    52 MHz (XO - External Oscillator)
 * 
 * Inputs:
 *     IN0: 33.7162837162837162... kHz [ 33 + 717/1001 kHz ]
 *          [ (30000/1001)*1125 ]
 *          Pulsed LVCMOS
 *     IN1: Unused
 *     IN2: Unused
 *     IN3: Unused
 * 
 * Outputs:
 *    OUT0: 27 MHz
 *          Enabled, LVDS 2.5 V
 *    OUT1: Unused
 *    OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT3: Unused
 *    OUT4: Unused
 *    OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT6: Unused
 *    OUT7: Unused
 *    OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *          [ 148.5/1.001 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT9: Unused
 * 
 * Frequency Plan
 * ==============
 * Priority: maximize the number of low jitter outputs
 * 
 * Fvco = 13.662 GHz [ 13 + 331/500 GHz ]
 * Fpfd = 33.7162837162837162... kHz [ 33 + 717/1001 kHz ]
 * Fms0 = 594 MHz
 * Fms1 = 147.456 MHz [ 147 + 57/125 MHz ]
 * Fms2 = 890.1098901098901098... MHz [ 890 + 10/91 MHz ]
 * 
 * P dividers:
 *    P0  = 1
 *    P1  = Unused
 *    P2  = Unused
 *    P3  = Unused
 *    Pxaxb = 1
 * 
 * MXAXB = 262.7307692307692307... [ 262 + 19/26 ]
 * M = 81040.96 [ 81040 + 24/25 ]
 * N dividers:
 *    N0:
 *       Value: 23
 *       Skew:  0.000 s
 *       OUT0: 27 MHz
 *       OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *    N1:
 *       Value: 92.6513671875 [ 92 + 667/1024 ]
 *       Skew:  0.000 s
 *       OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *    N2:
 *       Value: 15.3486666666666666... [ 15 + 523/1500 ]
 *       Skew:  0.000 s
 *       OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *    N3:
 *       Unused
 *    N4:
 *       Unused
 * 
 * R dividers:
 *    R0 = 22
 *    R1 = Unused
 *    R2 = 4
 *    R3 = Unused
 *    R4 = Unused
 *    R5 = 6
 *    R6 = Unused
 *    R7 = Unused
 *    R8 = 6
 *    R9 = Unused
 * 
 * Nominal Bandwidth:
 *   Desired: 1.000 Hz
 *   Actual:  651.210 mHz
 *   Coefficients:
 *      BW0:  17
 *      BW1:  25
 *      BW2:  15
 *      BW3:  15
 *      BW4:  1
 *      BW5:  7
 * Fastlock Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  107.647 Hz
 *   Coefficients:
 *      BW0:  24
 *      BW1:  41
 *      BW2:  12
 *      BW3:  11
 *      BW4:  1
 *      BW5:  7
 * Holdover Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  107.647 Hz
 *   Coefficients:
 *      BW0:  24
 *      BW1:  41
 *      BW2:  12
 *      BW3:  11
 *      BW4:  1
 *      BW5:  7
 * 
 * Dividers listed above show effective values. These values are translated to register settings by ClockBuilder Pro. For the actual register values, see below. Refer to the Family Reference Manual for information on registers related to frequency plan.
 * 
 * Digitally Controlled Oscillator (DCO)
 * =====================================
 * Mode: Register Direct Write
 * 
 * N0: DCO Disabled
 * 
 * N1: DCO Disabled
 * 
 * N2: DCO Disabled
 * 
 * N3: DCO Disabled
 * 
 * N4: DCO Disabled
 * 
 * Estimated Power & Junction Temperature
 * ======================================
 * Assumptions:
 * 
 * Revision: D
 * VDD:      1.8 V
 * Ta:       70 C
 * Airflow:  None
 * 
 * Total Power: 808 mW, On Chip Power: 784 mW, Tj: 87 C
 * 
 *                 Frequency  Format   Voltage   Current     Power
 *         -----------------  ------  --------  --------  --------
 * VDD                                   1.8 V  147.9 mA    266 mW
 * VDDA                                  3.3 V  117.4 mA    387 mW
 * VDDO0              27 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO1              Unused                                      
 * VDDO2           148.5 MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO3              Unused                                      
 * VDDO4              Unused                                      
 * VDDO5          24.576 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO6              Unused                                      
 * VDDO7              Unused                                      
 * VDDO8   148.351648... MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO9              Unused                                      
 *                                              --------  --------
 *                                       Total  327.2 mA    808 mW
 * 
 * Note:
 * 
 * -Total power includes on- and off-chip power. This is a typical value and estimate only.
 * -Use an EVB for a more exact power measurement
 * -On-chip power excludes power dissipated in external terminations.
 * -Tj is junction temperature. Tj must be less than 125 C (on Si5345 Revision D) for device to comply with datasheet specifications.
 * 
 * Settings
 * ========
 * 
 * Location      Setting Name           Decimal Value      Hex Value        
 * ------------  ---------------------  -----------------  -----------------
 * 0x000B[6:0]   I2C_ADDR               100                0x64             
 * 0x0016[1]     LOL_ON_HOLD            1                  0x1              
 * 0x0017[0]     SYSINCAL_INTR_MSK      0                  0x0              
 * 0x0017[1]     LOSXAXB_INTR_MSK       0                  0x0              
 * 0x0017[5]     SMB_TMOUT_INTR_MSK     1                  0x1              
 * 0x0018[3:0]   LOS_INTR_MSK           15                 0xF              
 * 0x0018[7:4]   OOF_INTR_MSK           15                 0xF              
 * 0x0019[1]     LOL_INTR_MSK           1                  0x1              
 * 0x0019[5]     HOLD_INTR_MSK          0                  0x0              
 * 0x001A[5]     CAL_INTR_MSK           0                  0x0              
 * 0x002B[3]     SPI_3WIRE              0                  0x0              
 * 0x002B[5]     AUTO_NDIV_UPDATE       0                  0x0              
 * 0x002C[3:0]   LOS_EN                 1                  0x1              
 * 0x002C[4]     LOSXAXB_DIS            0                  0x0              
 * 0x002D[1:0]   LOS0_VAL_TIME          2                  0x2              
 * 0x002D[3:2]   LOS1_VAL_TIME          0                  0x0              
 * 0x002D[5:4]   LOS2_VAL_TIME          0                  0x0              
 * 0x002D[7:6]   LOS3_VAL_TIME          0                  0x0              
 * 0x002E[15:0]  LOS0_TRG_THR           1945               0x0799           
 * 0x0030[15:0]  LOS1_TRG_THR           0                  0x0000           
 * 0x0032[15:0]  LOS2_TRG_THR           0                  0x0000           
 * 0x0034[15:0]  LOS3_TRG_THR           0                  0x0000           
 * 0x0036[15:0]  LOS0_CLR_THR           1783               0x06F7           
 * 0x0038[15:0]  LOS1_CLR_THR           0                  0x0000           
 * 0x003A[15:0]  LOS2_CLR_THR           0                  0x0000           
 * 0x003C[15:0]  LOS3_CLR_THR           0                  0x0000           
 * 0x003F[3:0]   OOF_EN                 1                  0x1              
 * 0x003F[7:4]   FAST_OOF_EN            0                  0x0              
 * 0x0040[2:0]   OOF_REF_SEL            4                  0x4              
 * 0x0041[4:0]   OOF0_DIV_SEL           2                  0x02             
 * 0x0042[4:0]   OOF1_DIV_SEL           0                  0x00             
 * 0x0043[4:0]   OOF2_DIV_SEL           0                  0x00             
 * 0x0044[4:0]   OOF3_DIV_SEL           0                  0x00             
 * 0x0045[4:0]   OOFXO_DIV_SEL          12                 0x0C             
 * 0x0046[7:0]   OOF0_SET_THR           150                0x96             
 * 0x0047[7:0]   OOF1_SET_THR           0                  0x00             
 * 0x0048[7:0]   OOF2_SET_THR           0                  0x00             
 * 0x0049[7:0]   OOF3_SET_THR           0                  0x00             
 * 0x004A[7:0]   OOF0_CLR_THR           75                 0x4B             
 * 0x004B[7:0]   OOF1_CLR_THR           0                  0x00             
 * 0x004C[7:0]   OOF2_CLR_THR           0                  0x00             
 * 0x004D[7:0]   OOF3_CLR_THR           0                  0x00             
 * 0x004E[2:0]   OOF0_DETWIN_SEL        5                  0x5              
 * 0x004E[6:4]   OOF1_DETWIN_SEL        0                  0x0              
 * 0x004F[2:0]   OOF2_DETWIN_SEL        0                  0x0              
 * 0x004F[6:4]   OOF3_DETWIN_SEL        0                  0x0              
 * 0x0050[3:0]   OOF_ON_LOS             15                 0xF              
 * 0x0051[3:0]   FAST_OOF0_SET_THR      0                  0x0              
 * 0x0052[3:0]   FAST_OOF1_SET_THR      0                  0x0              
 * 0x0053[3:0]   FAST_OOF2_SET_THR      0                  0x0              
 * 0x0054[3:0]   FAST_OOF3_SET_THR      0                  0x0              
 * 0x0055[3:0]   FAST_OOF0_CLR_THR      0                  0x0              
 * 0x0056[3:0]   FAST_OOF1_CLR_THR      0                  0x0              
 * 0x0057[3:0]   FAST_OOF2_CLR_THR      0                  0x0              
 * 0x0058[3:0]   FAST_OOF3_CLR_THR      0                  0x0              
 * 0x0059[1:0]   FAST_OOF0_DETWIN_SEL   1                  0x1              
 * 0x0059[3:2]   FAST_OOF1_DETWIN_SEL   0                  0x0              
 * 0x0059[5:4]   FAST_OOF2_DETWIN_SEL   0                  0x0              
 * 0x0059[7:6]   FAST_OOF3_DETWIN_SEL   0                  0x0              
 * 0x005A[25:0]  OOF0_RATIO_REF         11139256           0x0A9F8B8        
 * 0x005E[25:0]  OOF1_RATIO_REF         0                  0x0000000        
 * 0x0062[25:0]  OOF2_RATIO_REF         0                  0x0000000        
 * 0x0066[25:0]  OOF3_RATIO_REF         0                  0x0000000        
 * 0x0092[1]     LOL_FST_EN             1                  0x1              
 * 0x0093[7:4]   LOL_FST_DETWIN_SEL     10                 0xA              
 * 0x0095[3:2]   LOL_FST_VALWIN_SEL     0                  0x0              
 * 0x0096[7:4]   LOL_FST_SET_THR_SEL    9                  0x9              
 * 0x0098[7:4]   LOL_FST_CLR_THR_SEL    7                  0x7              
 * 0x009A[1]     LOL_SLOW_EN_PLL        1                  0x1              
 * 0x009B[7:4]   LOL_SLW_DETWIN_SEL     5                  0x5              
 * 0x009D[3:2]   LOL_SLW_VALWIN_SEL     1                  0x1              
 * 0x009E[7:4]   LOL_SLW_SET_THR        6                  0x6              
 * 0x00A0[7:4]   LOL_SLW_CLR_THR        3                  0x3              
 * 0x00A2[1]     LOL_TIMER_EN           0                  0x0              
 * 0x00A9[28:0]  LOL_CLR_DELAY_DIV256   294327             0x00047DB7       
 * 0x00E5[5]     FASTLOCK_EXTEND_EN     1                  0x1              
 * 0x00EA[28:0]  FASTLOCK_EXTEND        242129             0x0003B1D1       
 * 0x0102[0]     OUTALL_DISABLE_LOW     1                  0x1              
 * 0x0108[0]     OUT0_PDN               0                  0x0              
 * 0x0108[1]     OUT0_OE                1                  0x1              
 * 0x0108[2]     OUT0_RDIV_FORCE2       0                  0x0              
 * 0x0109[2:0]   OUT0_FORMAT            1                  0x1              
 * 0x0109[3]     OUT0_SYNC_EN           1                  0x1              
 * 0x0109[5:4]   OUT0_DIS_STATE         0                  0x0              
 * 0x0109[7:6]   OUT0_CMOS_DRV          0                  0x0              
 * 0x010A[3:0]   OUT0_CM                11                 0xB              
 * 0x010A[6:4]   OUT0_AMPL              3                  0x3              
 * 0x010B[2:0]   OUT0_MUX_SEL           0                  0x0              
 * 0x010B[5:4]   OUT0_VDD_SEL           2                  0x2              
 * 0x010B[3]     OUT0_VDD_SEL_EN        1                  0x1              
 * 0x010B[7:6]   OUT0_INV               0                  0x0              
 * 0x010D[0]     OUT1_PDN               1                  0x1              
 * 0x010D[1]     OUT1_OE                0                  0x0              
 * 0x010D[2]     OUT1_RDIV_FORCE2       0                  0x0              
 * 0x010E[2:0]   OUT1_FORMAT            1                  0x1              
 * 0x010E[3]     OUT1_SYNC_EN           1                  0x1              
 * 0x010E[5:4]   OUT1_DIS_STATE         0                  0x0              
 * 0x010E[7:6]   OUT1_CMOS_DRV          0                  0x0              
 * 0x010F[3:0]   OUT1_CM                11                 0xB              
 * 0x010F[6:4]   OUT1_AMPL              3                  0x3              
 * 0x0110[2:0]   OUT1_MUX_SEL           0                  0x0              
 * 0x0110[5:4]   OUT1_VDD_SEL           2                  0x2              
 * 0x0110[3]     OUT1_VDD_SEL_EN        1                  0x1              
 * 0x0110[7:6]   OUT1_INV               0                  0x0              
 * 0x0112[0]     OUT2_PDN               0                  0x0              
 * 0x0112[1]     OUT2_OE                1                  0x1              
 * 0x0112[2]     OUT2_RDIV_FORCE2       0                  0x0              
 * 0x0113[2:0]   OUT2_FORMAT            1                  0x1              
 * 0x0113[3]     OUT2_SYNC_EN           1                  0x1              
 * 0x0113[5:4]   OUT2_DIS_STATE         0                  0x0              
 * 0x0113[7:6]   OUT2_CMOS_DRV          0                  0x0              
 * 0x0114[3:0]   OUT2_CM                11                 0xB              
 * 0x0114[6:4]   OUT2_AMPL              3                  0x3              
 * 0x0115[2:0]   OUT2_MUX_SEL           0                  0x0              
 * 0x0115[5:4]   OUT2_VDD_SEL           2                  0x2              
 * 0x0115[3]     OUT2_VDD_SEL_EN        1                  0x1              
 * 0x0115[7:6]   OUT2_INV               0                  0x0              
 * 0x0117[0]     OUT3_PDN               1                  0x1              
 * 0x0117[1]     OUT3_OE                0                  0x0              
 * 0x0117[2]     OUT3_RDIV_FORCE2       0                  0x0              
 * 0x0118[2:0]   OUT3_FORMAT            1                  0x1              
 * 0x0118[3]     OUT3_SYNC_EN           1                  0x1              
 * 0x0118[5:4]   OUT3_DIS_STATE         0                  0x0              
 * 0x0118[7:6]   OUT3_CMOS_DRV          0                  0x0              
 * 0x0119[3:0]   OUT3_CM                11                 0xB              
 * 0x0119[6:4]   OUT3_AMPL              3                  0x3              
 * 0x011A[2:0]   OUT3_MUX_SEL           0                  0x0              
 * 0x011A[5:4]   OUT3_VDD_SEL           2                  0x2              
 * 0x011A[3]     OUT3_VDD_SEL_EN        1                  0x1              
 * 0x011A[7:6]   OUT3_INV               0                  0x0              
 * 0x011C[0]     OUT4_PDN               1                  0x1              
 * 0x011C[1]     OUT4_OE                0                  0x0              
 * 0x011C[2]     OUT4_RDIV_FORCE2       0                  0x0              
 * 0x011D[2:0]   OUT4_FORMAT            1                  0x1              
 * 0x011D[3]     OUT4_SYNC_EN           1                  0x1              
 * 0x011D[5:4]   OUT4_DIS_STATE         0                  0x0              
 * 0x011D[7:6]   OUT4_CMOS_DRV          0                  0x0              
 * 0x011E[3:0]   OUT4_CM                11                 0xB              
 * 0x011E[6:4]   OUT4_AMPL              3                  0x3              
 * 0x011F[2:0]   OUT4_MUX_SEL           0                  0x0              
 * 0x011F[5:4]   OUT4_VDD_SEL           2                  0x2              
 * 0x011F[3]     OUT4_VDD_SEL_EN        1                  0x1              
 * 0x011F[7:6]   OUT4_INV               0                  0x0              
 * 0x0121[0]     OUT5_PDN               0                  0x0              
 * 0x0121[1]     OUT5_OE                1                  0x1              
 * 0x0121[2]     OUT5_RDIV_FORCE2       0                  0x0              
 * 0x0122[2:0]   OUT5_FORMAT            1                  0x1              
 * 0x0122[3]     OUT5_SYNC_EN           1                  0x1              
 * 0x0122[5:4]   OUT5_DIS_STATE         0                  0x0              
 * 0x0122[7:6]   OUT5_CMOS_DRV          0                  0x0              
 * 0x0123[3:0]   OUT5_CM                11                 0xB              
 * 0x0123[6:4]   OUT5_AMPL              3                  0x3              
 * 0x0124[2:0]   OUT5_MUX_SEL           1                  0x1              
 * 0x0124[5:4]   OUT5_VDD_SEL           2                  0x2              
 * 0x0124[3]     OUT5_VDD_SEL_EN        1                  0x1              
 * 0x0124[7:6]   OUT5_INV               0                  0x0              
 * 0x0126[0]     OUT6_PDN               1                  0x1              
 * 0x0126[1]     OUT6_OE                0                  0x0              
 * 0x0126[2]     OUT6_RDIV_FORCE2       0                  0x0              
 * 0x0127[2:0]   OUT6_FORMAT            1                  0x1              
 * 0x0127[3]     OUT6_SYNC_EN           1                  0x1              
 * 0x0127[5:4]   OUT6_DIS_STATE         0                  0x0              
 * 0x0127[7:6]   OUT6_CMOS_DRV          0                  0x0              
 * 0x0128[3:0]   OUT6_CM                11                 0xB              
 * 0x0128[6:4]   OUT6_AMPL              3                  0x3              
 * 0x0129[2:0]   OUT6_MUX_SEL           0                  0x0              
 * 0x0129[5:4]   OUT6_VDD_SEL           2                  0x2              
 * 0x0129[3]     OUT6_VDD_SEL_EN        1                  0x1              
 * 0x0129[7:6]   OUT6_INV               0                  0x0              
 * 0x012B[0]     OUT7_PDN               1                  0x1              
 * 0x012B[1]     OUT7_OE                0                  0x0              
 * 0x012B[2]     OUT7_RDIV_FORCE2       0                  0x0              
 * 0x012C[2:0]   OUT7_FORMAT            1                  0x1              
 * 0x012C[3]     OUT7_SYNC_EN           1                  0x1              
 * 0x012C[5:4]   OUT7_DIS_STATE         0                  0x0              
 * 0x012C[7:6]   OUT7_CMOS_DRV          0                  0x0              
 * 0x012D[3:0]   OUT7_CM                11                 0xB              
 * 0x012D[6:4]   OUT7_AMPL              3                  0x3              
 * 0x012E[2:0]   OUT7_MUX_SEL           0                  0x0              
 * 0x012E[5:4]   OUT7_VDD_SEL           2                  0x2              
 * 0x012E[3]     OUT7_VDD_SEL_EN        1                  0x1              
 * 0x012E[7:6]   OUT7_INV               0                  0x0              
 * 0x0130[0]     OUT8_PDN               0                  0x0              
 * 0x0130[1]     OUT8_OE                1                  0x1              
 * 0x0130[2]     OUT8_RDIV_FORCE2       0                  0x0              
 * 0x0131[2:0]   OUT8_FORMAT            1                  0x1              
 * 0x0131[3]     OUT8_SYNC_EN           1                  0x1              
 * 0x0131[5:4]   OUT8_DIS_STATE         0                  0x0              
 * 0x0131[7:6]   OUT8_CMOS_DRV          0                  0x0              
 * 0x0132[3:0]   OUT8_CM                11                 0xB              
 * 0x0132[6:4]   OUT8_AMPL              3                  0x3              
 * 0x0133[2:0]   OUT8_MUX_SEL           2                  0x2              
 * 0x0133[5:4]   OUT8_VDD_SEL           2                  0x2              
 * 0x0133[3]     OUT8_VDD_SEL_EN        1                  0x1              
 * 0x0133[7:6]   OUT8_INV               0                  0x0              
 * 0x013A[0]     OUT9_PDN               1                  0x1              
 * 0x013A[1]     OUT9_OE                0                  0x0              
 * 0x013A[2]     OUT9_RDIV_FORCE2       0                  0x0              
 * 0x013B[2:0]   OUT9_FORMAT            1                  0x1              
 * 0x013B[3]     OUT9_SYNC_EN           1                  0x1              
 * 0x013B[5:4]   OUT9_DIS_STATE         0                  0x0              
 * 0x013B[7:6]   OUT9_CMOS_DRV          0                  0x0              
 * 0x013C[3:0]   OUT9_CM                11                 0xB              
 * 0x013C[6:4]   OUT9_AMPL              3                  0x3              
 * 0x013D[2:0]   OUT9_MUX_SEL           0                  0x0              
 * 0x013D[5:4]   OUT9_VDD_SEL           2                  0x2              
 * 0x013D[3]     OUT9_VDD_SEL_EN        1                  0x1              
 * 0x013D[7:6]   OUT9_INV               0                  0x0              
 * 0x013F[11:0]  OUTX_ALWAYS_ON         0                  0x000            
 * 0x0141[1]     OUT_DIS_MSK            0                  0x0              
 * 0x0141[5]     OUT_DIS_LOL_MSK        0                  0x0              
 * 0x0141[6]     OUT_DIS_LOSXAXB_MSK    1                  0x1              
 * 0x0141[7]     OUT_DIS_MSK_LOS_PFD    0                  0x0              
 * 0x0142[1]     OUT_DIS_MSK_LOL        1                  0x1              
 * 0x0142[5]     OUT_DIS_MSK_HOLD       1                  0x1              
 * 0x0206[1:0]   PXAXB                  0                  0x0              
 * 0x0208[47:0]  P0_NUM                 1                  0x000000000001   
 * 0x020E[31:0]  P0_DEN                 1                  0x00000001       
 * 0x0212[47:0]  P1_NUM                 0                  0x000000000000   
 * 0x0218[31:0]  P1_DEN                 0                  0x00000000       
 * 0x021C[47:0]  P2_NUM                 0                  0x000000000000   
 * 0x0222[31:0]  P2_DEN                 0                  0x00000000       
 * 0x0226[47:0]  P3_NUM                 0                  0x000000000000   
 * 0x022C[31:0]  P3_DEN                 0                  0x00000000       
 * 0x0231[3:0]   P0_FRACN_MODE          11                 0xB              
 * 0x0231[4]     P0_FRACN_EN            0                  0x0              
 * 0x0232[3:0]   P1_FRACN_MODE          11                 0xB              
 * 0x0232[4]     P1_FRACN_EN            0                  0x0              
 * 0x0233[3:0]   P2_FRACN_MODE          11                 0xB              
 * 0x0233[4]     P2_FRACN_EN            0                  0x0              
 * 0x0234[3:0]   P3_FRACN_MODE          11                 0xB              
 * 0x0234[4]     P3_FRACN_EN            0                  0x0              
 * 0x0235[43:0]  MXAXB_NUM              916841299968       0x0D578000000    
 * 0x023B[31:0]  MXAXB_DEN              3489660928         0xD0000000       
 * 0x024A[23:0]  R0_REG                 10                 0x00000A         
 * 0x024D[23:0]  R1_REG                 0                  0x000000         
 * 0x0250[23:0]  R2_REG                 1                  0x000001         
 * 0x0253[23:0]  R3_REG                 0                  0x000000         
 * 0x0256[23:0]  R4_REG                 0                  0x000000         
 * 0x0259[23:0]  R5_REG                 2                  0x000002         
 * 0x025C[23:0]  R6_REG                 0                  0x000000         
 * 0x025F[23:0]  R7_REG                 0                  0x000000         
 * 0x0262[23:0]  R8_REG                 2                  0x000002         
 * 0x0268[23:0]  R9_REG                 0                  0x000000         
 * 0x026B[7:0]   DESIGN_ID0             73                 0x49             
 * 0x026C[7:0]   DESIGN_ID1             79                 0x4F             
 * 0x026D[7:0]   DESIGN_ID2             52                 0x34             
 * 0x026E[7:0]   DESIGN_ID3             75                 0x4B             
 * 0x026F[7:0]   DESIGN_ID4             43                 0x2B             
 * 0x0270[7:0]   DESIGN_ID5             0                  0x00             
 * 0x0271[7:0]   DESIGN_ID6             0                  0x00             
 * 0x0272[7:0]   DESIGN_ID7             0                  0x00             
 * 0x0294[7:4]   FASTLOCK_EXTEND_SCL    8                  0x8              
 * 0x0296[1]     LOL_SLW_VALWIN_SELX    0                  0x0              
 * 0x0297[1]     FASTLOCK_DLY_ONSW_EN   1                  0x1              
 * 0x0299[1]     FASTLOCK_DLY_ONLOL_EN  1                  0x1              
 * 0x029D[19:0]  FASTLOCK_DLY_ONLOL     3829               0x00EF5          
 * 0x02A9[19:0]  FASTLOCK_DLY_ONSW      9830               0x02666          
 * 0x02B7[3:2]   LOL_NOSIG_TIME         3                  0x3              
 * 0x0302[43:0]  N0_NUM                 49392123904        0x00B80000000    
 * 0x0308[31:0]  N0_DEN                 2147483648         0x80000000       
 * 0x030C[0]     N0_UPDATE              0                  0x0              
 * 0x030D[43:0]  N1_NUM                 198967296000       0x02E53600000    
 * 0x0313[31:0]  N1_DEN                 2147483648         0x80000000       
 * 0x0317[0]     N1_UPDATE              0                  0x0              
 * 0x0318[43:0]  N2_NUM                 48282730496        0x00B3DE00000    
 * 0x031E[31:0]  N2_DEN                 3145728000         0xBB800000       
 * 0x0322[0]     N2_UPDATE              0                  0x0              
 * 0x0323[43:0]  N3_NUM                 0                  0x00000000000    
 * 0x0329[31:0]  N3_DEN                 0                  0x00000000       
 * 0x032D[0]     N3_UPDATE              0                  0x0              
 * 0x032E[43:0]  N4_NUM                 0                  0x00000000000    
 * 0x0334[31:0]  N4_DEN                 0                  0x00000000       
 * 0x0338[0]     N4_UPDATE              0                  0x0              
 * 0x0338[1]     N_UPDATE               0                  0x0              
 * 0x0339[4:0]   N_FSTEP_MSK            31                 0x1F             
 * 0x033B[43:0]  N0_FSTEPW              0                  0x00000000000    
 * 0x0341[43:0]  N1_FSTEPW              0                  0x00000000000    
 * 0x0347[43:0]  N2_FSTEPW              0                  0x00000000000    
 * 0x034D[43:0]  N3_FSTEPW              0                  0x00000000000    
 * 0x0353[43:0]  N4_FSTEPW              0                  0x00000000000    
 * 0x0359[15:0]  N0_DELAY               0                  0x0000           
 * 0x035B[15:0]  N1_DELAY               0                  0x0000           
 * 0x035D[15:0]  N2_DELAY               0                  0x0000           
 * 0x035F[15:0]  N3_DELAY               0                  0x0000           
 * 0x0361[15:0]  N4_DELAY               0                  0x0000           
 * 0x0487[0]     ZDM_EN                 0                  0x0              
 * 0x0487[2:1]   ZDM_IN_SEL             0                  0x0              
 * 0x0487[4]     ZDM_AUTOSW_EN          0                  0x0              
 * 0x0502[4]     ADD_DIV256             0                  0x0              
 * 0x0508[5:0]   BW0_PLL                17                 0x11             
 * 0x0509[5:0]   BW1_PLL                25                 0x19             
 * 0x050A[5:0]   BW2_PLL                15                 0x0F             
 * 0x050B[5:0]   BW3_PLL                15                 0x0F             
 * 0x050C[5:0]   BW4_PLL                1                  0x01             
 * 0x050D[5:0]   BW5_PLL                7                  0x07             
 * 0x050E[5:0]   FASTLOCK_BW0_PLL       24                 0x18             
 * 0x050F[5:0]   FASTLOCK_BW1_PLL       41                 0x29             
 * 0x0510[5:0]   FASTLOCK_BW2_PLL       12                 0x0C             
 * 0x0511[5:0]   FASTLOCK_BW3_PLL       11                 0x0B             
 * 0x0512[5:0]   FASTLOCK_BW4_PLL       1                  0x01             
 * 0x0513[5:0]   FASTLOCK_BW5_PLL       7                  0x07             
 * 0x0515[55:0]  M_NUM                  271928338153472    0x00F75140000000 
 * 0x051C[31:0]  M_DEN                  3355443200         0xC8000000       
 * 0x0521[3:0]   M_FRAC_MODE            11                 0xB              
 * 0x0521[4]     M_FRAC_EN              1                  0x1              
 * 0x0521[5]     PLL_OUT_RATE_SEL       1                  0x1              
 * 0x052A[0]     IN_SEL_REGCTRL         1                  0x1              
 * 0x052A[3:1]   IN_SEL                 0                  0x0              
 * 0x052B[0]     FASTLOCK_AUTO_EN       1                  0x1              
 * 0x052B[1]     FASTLOCK_MAN           0                  0x0              
 * 0x052C[0]     HOLD_EN                1                  0x1              
 * 0x052C[3]     HOLD_RAMP_BYP          1                  0x1              
 * 0x052C[4]     HOLDEXIT_BW_SEL1       0                  0x0              
 * 0x052C[7:5]   RAMP_STEP_INTERVAL     0                  0x0              
 * 0x052D[1]     HOLD_RAMPBYP_NOHIST    1                  0x1              
 * 0x052E[4:0]   HOLD_HIST_LEN          21                 0x15             
 * 0x052F[4:0]   HOLD_HIST_DELAY        20                 0x14             
 * 0x0531[4:0]   HOLD_REF_COUNT_FRC     0                  0x00             
 * 0x0532[23:0]  HOLD_15M_CYC_COUNT     49433              0x00C119         
 * 0x0535[0]     FORCE_HOLD             0                  0x0              
 * 0x0536[1:0]   CLK_SWITCH_MODE        0                  0x0              
 * 0x0536[2]     HSW_EN                 0                  0x0              
 * 0x0537[3:0]   IN_LOS_MSK             0                  0x0              
 * 0x0537[7:4]   IN_OOF_MSK             0                  0x0              
 * 0x0538[2:0]   IN0_PRIORITY           0                  0x0              
 * 0x0538[6:4]   IN1_PRIORITY           0                  0x0              
 * 0x0539[2:0]   IN2_PRIORITY           0                  0x0              
 * 0x0539[6:4]   IN3_PRIORITY           0                  0x0              
 * 0x053A[1:0]   HSW_MODE               2                  0x2              
 * 0x053A[3:2]   HSW_PHMEAS_CTRL        0                  0x0              
 * 0x053B[9:0]   HSW_PHMEAS_THR         3                  0x003            
 * 0x053D[4:0]   HSW_COARSE_PM_LEN      18                 0x12             
 * 0x053E[4:0]   HSW_COARSE_PM_DLY      6                  0x06             
 * 0x0589[12:0]  CAP_SHORT_DELAY        807                0x0327           
 * 0x059B[4]     HOLD_PRESERVE_HIST     1                  0x1              
 * 0x059B[5]     HOLD_FRZ_WITH_INTONLY  1                  0x1              
 * 0x059B[6]     HOLDEXIT_BW_SEL0       1                  0x1              
 * 0x059B[7]     HOLDEXIT_STD_BO        1                  0x1              
 * 0x059D[5:0]   HOLDEXIT_BW0           24                 0x18             
 * 0x059E[5:0]   HOLDEXIT_BW1           41                 0x29             
 * 0x059F[5:0]   HOLDEXIT_BW2           12                 0x0C             
 * 0x05A0[5:0]   HOLDEXIT_BW3           11                 0x0B             
 * 0x05A1[5:0]   HOLDEXIT_BW4           1                  0x01             
 * 0x05A2[5:0]   HOLDEXIT_BW5           7                  0x07             
 * 0x05A6[2:0]   RAMP_STEP_SIZE         0                  0x0              
 * 0x05A6[3]     RAMP_SWITCH_EN         0                  0x0              
 * 0x0802[15:0]  FIXREGSA0              1333               0x0535           
 * 0x0804[7:0]   FIXREGSD0              0                  0x00             
 * 0x0805[15:0]  FIXREGSA1              0                  0x0000           
 * 0x0807[7:0]   FIXREGSD1              0                  0x00             
 * 0x0808[15:0]  FIXREGSA2              0                  0x0000           
 * 0x080A[7:0]   FIXREGSD2              0                  0x00             
 * 0x080B[15:0]  FIXREGSA3              0                  0x0000           
 * 0x080D[7:0]   FIXREGSD3              0                  0x00             
 * 0x080E[15:0]  FIXREGSA4              0                  0x0000           
 * 0x0810[7:0]   FIXREGSD4              0                  0x00             
 * 0x0811[15:0]  FIXREGSA5              0                  0x0000           
 * 0x0813[7:0]   FIXREGSD5              0                  0x00             
 * 0x0814[15:0]  FIXREGSA6              0                  0x0000           
 * 0x0816[7:0]   FIXREGSD6              0                  0x00             
 * 0x0817[15:0]  FIXREGSA7              0                  0x0000           
 * 0x0819[7:0]   FIXREGSD7              0                  0x00             
 * 0x081A[15:0]  FIXREGSA8              0                  0x0000           
 * 0x081C[7:0]   FIXREGSD8              0                  0x00             
 * 0x081D[15:0]  FIXREGSA9              0                  0x0000           
 * 0x081F[7:0]   FIXREGSD9              0                  0x00             
 * 0x0820[15:0]  FIXREGSA10             0                  0x0000           
 * 0x0822[7:0]   FIXREGSD10             0                  0x00             
 * 0x0823[15:0]  FIXREGSA11             0                  0x0000           
 * 0x0825[7:0]   FIXREGSD11             0                  0x00             
 * 0x0826[15:0]  FIXREGSA12             0                  0x0000           
 * 0x0828[7:0]   FIXREGSD12             0                  0x00             
 * 0x0829[15:0]  FIXREGSA13             0                  0x0000           
 * 0x082B[7:0]   FIXREGSD13             0                  0x00             
 * 0x082C[15:0]  FIXREGSA14             0                  0x0000           
 * 0x082E[7:0]   FIXREGSD14             0                  0x00             
 * 0x082F[15:0]  FIXREGSA15             0                  0x0000           
 * 0x0831[7:0]   FIXREGSD15             0                  0x00             
 * 0x0832[15:0]  FIXREGSA16             0                  0x0000           
 * 0x0834[7:0]   FIXREGSD16             0                  0x00             
 * 0x0835[15:0]  FIXREGSA17             0                  0x0000           
 * 0x0837[7:0]   FIXREGSD17             0                  0x00             
 * 0x0838[15:0]  FIXREGSA18             0                  0x0000           
 * 0x083A[7:0]   FIXREGSD18             0                  0x00             
 * 0x083B[15:0]  FIXREGSA19             0                  0x0000           
 * 0x083D[7:0]   FIXREGSD19             0                  0x00             
 * 0x083E[15:0]  FIXREGSA20             0                  0x0000           
 * 0x0840[7:0]   FIXREGSD20             0                  0x00             
 * 0x0841[15:0]  FIXREGSA21             0                  0x0000           
 * 0x0843[7:0]   FIXREGSD21             0                  0x00             
 * 0x0844[15:0]  FIXREGSA22             0                  0x0000           
 * 0x0846[7:0]   FIXREGSD22             0                  0x00             
 * 0x0847[15:0]  FIXREGSA23             0                  0x0000           
 * 0x0849[7:0]   FIXREGSD23             0                  0x00             
 * 0x084A[15:0]  FIXREGSA24             0                  0x0000           
 * 0x084C[7:0]   FIXREGSD24             0                  0x00             
 * 0x084D[15:0]  FIXREGSA25             0                  0x0000           
 * 0x084F[7:0]   FIXREGSD25             0                  0x00             
 * 0x0850[15:0]  FIXREGSA26             0                  0x0000           
 * 0x0852[7:0]   FIXREGSD26             0                  0x00             
 * 0x0853[15:0]  FIXREGSA27             0                  0x0000           
 * 0x0855[7:0]   FIXREGSD27             0                  0x00             
 * 0x0856[15:0]  FIXREGSA28             0                  0x0000           
 * 0x0858[7:0]   FIXREGSD28             0                  0x00             
 * 0x0859[15:0]  FIXREGSA29             0                  0x0000           
 * 0x085B[7:0]   FIXREGSD29             0                  0x00             
 * 0x085C[15:0]  FIXREGSA30             0                  0x0000           
 * 0x085E[7:0]   FIXREGSD30             0                  0x00             
 * 0x085F[15:0]  FIXREGSA31             0                  0x0000           
 * 0x0861[7:0]   FIXREGSD31             0                  0x00             
 * 0x090E[0]     XAXB_EXTCLK_EN         1                  0x1              
 * 0x0943[0]     IO_VDD_SEL             0                  0x0              
 * 0x0949[3:0]   IN_EN                  1                  0x1              
 * 0x0949[7:4]   IN_PULSED_CMOS_EN      3                  0x3              
 * 0x094A[3:0]   INX_TO_PFD_EN          1                  0x1              
 * 0x094E[11:0]  REFCLK_HYS_SEL         585                0x249            
 * 0x095E[0]     MXAXB_INTEGER          0                  0x0              
 * 0x0A02[4:0]   N_ADD_0P5              0                  0x00             
 * 0x0A03[4:0]   N_CLK_TO_OUTX_EN       7                  0x07             
 * 0x0A04[4:0]   N_PIBYP                1                  0x01             
 * 0x0A05[4:0]   N_PDNB                 7                  0x07             
 * 0x0A14[3]     N0_HIGH_FREQ           0                  0x0              
 * 0x0A1A[3]     N1_HIGH_FREQ           0                  0x0              
 * 0x0A20[3]     N2_HIGH_FREQ           0                  0x0              
 * 0x0A26[3]     N3_HIGH_FREQ           0                  0x0              
 * 0x0A2C[3]     N4_HIGH_FREQ           0                  0x0              
 * 0x0B44[3:0]   PDIV_FRACN_CLK_DIS     15                 0xF              
 * 0x0B44[5]     FRACN_CLK_DIS_PLL      0                  0x0              
 * 0x0B46[3:0]   LOS_CLK_DIS            0                  0x0              
 * 0x0B47[4:0]   OOF_CLK_DIS            14                 0x0E             
 * 0x0B48[4:0]   OOF_DIV_CLK_DIS        14                 0x0E             
 * 0x0B4A[4:0]   N_CLK_DIS              24                 0x18             
 * 0x0B57[11:0]  VCO_RESET_CALCODE      249                0x0F9
 * 
 *
 */


static struct ntv2_genlock_data s_genlock_1125_3000[] =
{
	/* Start configuration preamble */
	{ 0x0B24, 0xC0 },
	{ 0x0B25, 0x00 },
	{ 0x0540, 0x01 },
	/* End configuration preamble */

	/* Delay 300 msec */
	/*    Delay is worst case time for device to complete any calibration */
	/*    that is running due to device state change previous to this script */
	/*    being processed. */
	{ 0x0000, 0x01 },

	/* Start configuration registers */
	{ 0x000B, 0x64 },
	{ 0x0016, 0x02 },
	{ 0x0017, 0xFC },
	{ 0x0018, 0xFF },
	{ 0x0019, 0xDF },
	{ 0x001A, 0xDF },
	{ 0x002B, 0x02 },
	{ 0x002C, 0x01 },
	{ 0x002D, 0x02 },
	{ 0x002E, 0x98 },
	{ 0x002F, 0x07 },
	{ 0x0030, 0x00 },
	{ 0x0031, 0x00 },
	{ 0x0032, 0x00 },
	{ 0x0033, 0x00 },
	{ 0x0034, 0x00 },
	{ 0x0035, 0x00 },
	{ 0x0036, 0xF6 },
	{ 0x0037, 0x06 },
	{ 0x0038, 0x00 },
	{ 0x0039, 0x00 },
	{ 0x003A, 0x00 },
	{ 0x003B, 0x00 },
	{ 0x003C, 0x00 },
	{ 0x003D, 0x00 },
	{ 0x003F, 0x01 },
	{ 0x0040, 0x04 },
	{ 0x0041, 0x02 },
	{ 0x0042, 0x00 },
	{ 0x0043, 0x00 },
	{ 0x0044, 0x00 },
	{ 0x0045, 0x0C },
	{ 0x0046, 0x96 },
	{ 0x0047, 0x00 },
	{ 0x0048, 0x00 },
	{ 0x0049, 0x00 },
	{ 0x004A, 0x4B },
	{ 0x004B, 0x00 },
	{ 0x004C, 0x00 },
	{ 0x004D, 0x00 },
	{ 0x004E, 0x05 },
	{ 0x004F, 0x00 },
	{ 0x0050, 0x0F },
	{ 0x0051, 0x00 },
	{ 0x0052, 0x00 },
	{ 0x0053, 0x00 },
	{ 0x0054, 0x00 },
	{ 0x0055, 0x00 },
	{ 0x0056, 0x00 },
	{ 0x0057, 0x00 },
	{ 0x0058, 0x00 },
	{ 0x0059, 0x01 },
	{ 0x005A, 0x3B },
	{ 0x005B, 0x24 },
	{ 0x005C, 0xAA },
	{ 0x005D, 0x00 },
	{ 0x005E, 0x00 },
	{ 0x005F, 0x00 },
	{ 0x0060, 0x00 },
	{ 0x0061, 0x00 },
	{ 0x0062, 0x00 },
	{ 0x0063, 0x00 },
	{ 0x0064, 0x00 },
	{ 0x0065, 0x00 },
	{ 0x0066, 0x00 },
	{ 0x0067, 0x00 },
	{ 0x0068, 0x00 },
	{ 0x0069, 0x00 },
	{ 0x0092, 0x02 },
	{ 0x0093, 0xA0 },
	{ 0x0095, 0x00 },
	{ 0x0096, 0x90 },
	{ 0x0098, 0x70 },
	{ 0x009A, 0x02 },
	{ 0x009B, 0x50 },
	{ 0x009D, 0x04 },
	{ 0x009E, 0x60 },
	{ 0x00A0, 0x30 },
	{ 0x00A2, 0x00 },
	{ 0x00A9, 0x82 },
	{ 0x00AA, 0x7D },
	{ 0x00AB, 0x04 },
	{ 0x00AC, 0x00 },
	{ 0x00E5, 0x21 },
	{ 0x00EA, 0xD1 },
	{ 0x00EB, 0xB1 },
	{ 0x00EC, 0x03 },
	{ 0x00ED, 0x00 },
	{ 0x0102, 0x01 },
	{ 0x0108, 0x02 },
	{ 0x0109, 0x09 },
	{ 0x010A, 0x3B },
	{ 0x010B, 0x28 },
	{ 0x010D, 0x01 },
	{ 0x010E, 0x09 },
	{ 0x010F, 0x3B },
	{ 0x0110, 0x28 },
	{ 0x0112, 0x02 },
	{ 0x0113, 0x09 },
	{ 0x0114, 0x3B },
	{ 0x0115, 0x28 },
	{ 0x0117, 0x01 },
	{ 0x0118, 0x09 },
	{ 0x0119, 0x3B },
	{ 0x011A, 0x28 },
	{ 0x011C, 0x01 },
	{ 0x011D, 0x09 },
	{ 0x011E, 0x3B },
	{ 0x011F, 0x28 },
	{ 0x0121, 0x02 },
	{ 0x0122, 0x09 },
	{ 0x0123, 0x3B },
	{ 0x0124, 0x29 },
	{ 0x0126, 0x01 },
	{ 0x0127, 0x09 },
	{ 0x0128, 0x3B },
	{ 0x0129, 0x28 },
	{ 0x012B, 0x01 },
	{ 0x012C, 0x09 },
	{ 0x012D, 0x3B },
	{ 0x012E, 0x28 },
	{ 0x0130, 0x02 },
	{ 0x0131, 0x09 },
	{ 0x0132, 0x3B },
	{ 0x0133, 0x2A },
	{ 0x013A, 0x01 },
	{ 0x013B, 0x09 },
	{ 0x013C, 0x3B },
	{ 0x013D, 0x28 },
	{ 0x013F, 0x00 },
	{ 0x0140, 0x00 },
	{ 0x0141, 0x40 },
	{ 0x0142, 0xFF },
	{ 0x0206, 0x00 },
	{ 0x0208, 0x01 },
	{ 0x0209, 0x00 },
	{ 0x020A, 0x00 },
	{ 0x020B, 0x00 },
	{ 0x020C, 0x00 },
	{ 0x020D, 0x00 },
	{ 0x020E, 0x01 },
	{ 0x020F, 0x00 },
	{ 0x0210, 0x00 },
	{ 0x0211, 0x00 },
	{ 0x0212, 0x00 },
	{ 0x0213, 0x00 },
	{ 0x0214, 0x00 },
	{ 0x0215, 0x00 },
	{ 0x0216, 0x00 },
	{ 0x0217, 0x00 },
	{ 0x0218, 0x00 },
	{ 0x0219, 0x00 },
	{ 0x021A, 0x00 },
	{ 0x021B, 0x00 },
	{ 0x021C, 0x00 },
	{ 0x021D, 0x00 },
	{ 0x021E, 0x00 },
	{ 0x021F, 0x00 },
	{ 0x0220, 0x00 },
	{ 0x0221, 0x00 },
	{ 0x0222, 0x00 },
	{ 0x0223, 0x00 },
	{ 0x0224, 0x00 },
	{ 0x0225, 0x00 },
	{ 0x0226, 0x00 },
	{ 0x0227, 0x00 },
	{ 0x0228, 0x00 },
	{ 0x0229, 0x00 },
	{ 0x022A, 0x00 },
	{ 0x022B, 0x00 },
	{ 0x022C, 0x00 },
	{ 0x022D, 0x00 },
	{ 0x022E, 0x00 },
	{ 0x022F, 0x00 },
	{ 0x0231, 0x0B },
	{ 0x0232, 0x0B },
	{ 0x0233, 0x0B },
	{ 0x0234, 0x0B },
	{ 0x0235, 0x00 },
	{ 0x0236, 0x00 },
	{ 0x0237, 0x00 },
	{ 0x0238, 0x78 },
	{ 0x0239, 0xD5 },
	{ 0x023A, 0x00 },
	{ 0x023B, 0x00 },
	{ 0x023C, 0x00 },
	{ 0x023D, 0x00 },
	{ 0x023E, 0xD0 },
	{ 0x024A, 0x0A },
	{ 0x024B, 0x00 },
	{ 0x024C, 0x00 },
	{ 0x024D, 0x00 },
	{ 0x024E, 0x00 },
	{ 0x024F, 0x00 },
	{ 0x0250, 0x01 },
	{ 0x0251, 0x00 },
	{ 0x0252, 0x00 },
	{ 0x0253, 0x00 },
	{ 0x0254, 0x00 },
	{ 0x0255, 0x00 },
	{ 0x0256, 0x00 },
	{ 0x0257, 0x00 },
	{ 0x0258, 0x00 },
	{ 0x0259, 0x02 },
	{ 0x025A, 0x00 },
	{ 0x025B, 0x00 },
	{ 0x025C, 0x00 },
	{ 0x025D, 0x00 },
	{ 0x025E, 0x00 },
	{ 0x025F, 0x00 },
	{ 0x0260, 0x00 },
	{ 0x0261, 0x00 },
	{ 0x0262, 0x02 },
	{ 0x0263, 0x00 },
	{ 0x0264, 0x00 },
	{ 0x0268, 0x00 },
	{ 0x0269, 0x00 },
	{ 0x026A, 0x00 },
	{ 0x026B, 0x49 },
	{ 0x026C, 0x4F },
	{ 0x026D, 0x34 },
	{ 0x026E, 0x4B },
	{ 0x026F, 0x2B },
	{ 0x0270, 0x00 },
	{ 0x0271, 0x00 },
	{ 0x0272, 0x00 },
	{ 0x0294, 0x80 },
	{ 0x0296, 0x00 },
	{ 0x0297, 0x02 },
	{ 0x0299, 0x02 },
	{ 0x029D, 0xF5 },
	{ 0x029E, 0x0E },
	{ 0x029F, 0x00 },
	{ 0x02A9, 0x66 },
	{ 0x02AA, 0x26 },
	{ 0x02AB, 0x00 },
	{ 0x02B7, 0xFF },
	{ 0x0302, 0x00 },
	{ 0x0303, 0x00 },
	{ 0x0304, 0x00 },
	{ 0x0305, 0x80 },
	{ 0x0306, 0x0B },
	{ 0x0307, 0x00 },
	{ 0x0308, 0x00 },
	{ 0x0309, 0x00 },
	{ 0x030A, 0x00 },
	{ 0x030B, 0x80 },
	{ 0x030C, 0x00 },
	{ 0x030D, 0x00 },
	{ 0x030E, 0x00 },
	{ 0x030F, 0x60 },
	{ 0x0310, 0x53 },
	{ 0x0311, 0x2E },
	{ 0x0312, 0x00 },
	{ 0x0313, 0x00 },
	{ 0x0314, 0x00 },
	{ 0x0315, 0x00 },
	{ 0x0316, 0x80 },
	{ 0x0317, 0x00 },
	{ 0x0318, 0x00 },
	{ 0x0319, 0x00 },
	{ 0x031A, 0xE0 },
	{ 0x031B, 0x3D },
	{ 0x031C, 0x0B },
	{ 0x031D, 0x00 },
	{ 0x031E, 0x00 },
	{ 0x031F, 0x00 },
	{ 0x0320, 0x80 },
	{ 0x0321, 0xBB },
	{ 0x0322, 0x00 },
	{ 0x0323, 0x00 },
	{ 0x0324, 0x00 },
	{ 0x0325, 0x00 },
	{ 0x0326, 0x00 },
	{ 0x0327, 0x00 },
	{ 0x0328, 0x00 },
	{ 0x0329, 0x00 },
	{ 0x032A, 0x00 },
	{ 0x032B, 0x00 },
	{ 0x032C, 0x00 },
	{ 0x032D, 0x00 },
	{ 0x032E, 0x00 },
	{ 0x032F, 0x00 },
	{ 0x0330, 0x00 },
	{ 0x0331, 0x00 },
	{ 0x0332, 0x00 },
	{ 0x0333, 0x00 },
	{ 0x0334, 0x00 },
	{ 0x0335, 0x00 },
	{ 0x0336, 0x00 },
	{ 0x0337, 0x00 },
	{ 0x0338, 0x00 },
	{ 0x0339, 0x1F },
	{ 0x033B, 0x00 },
	{ 0x033C, 0x00 },
	{ 0x033D, 0x00 },
	{ 0x033E, 0x00 },
	{ 0x033F, 0x00 },
	{ 0x0340, 0x00 },
	{ 0x0341, 0x00 },
	{ 0x0342, 0x00 },
	{ 0x0343, 0x00 },
	{ 0x0344, 0x00 },
	{ 0x0345, 0x00 },
	{ 0x0346, 0x00 },
	{ 0x0347, 0x00 },
	{ 0x0348, 0x00 },
	{ 0x0349, 0x00 },
	{ 0x034A, 0x00 },
	{ 0x034B, 0x00 },
	{ 0x034C, 0x00 },
	{ 0x034D, 0x00 },
	{ 0x034E, 0x00 },
	{ 0x034F, 0x00 },
	{ 0x0350, 0x00 },
	{ 0x0351, 0x00 },
	{ 0x0352, 0x00 },
	{ 0x0353, 0x00 },
	{ 0x0354, 0x00 },
	{ 0x0355, 0x00 },
	{ 0x0356, 0x00 },
	{ 0x0357, 0x00 },
	{ 0x0358, 0x00 },
	{ 0x0359, 0x00 },
	{ 0x035A, 0x00 },
	{ 0x035B, 0x00 },
	{ 0x035C, 0x00 },
	{ 0x035D, 0x00 },
	{ 0x035E, 0x00 },
	{ 0x035F, 0x00 },
	{ 0x0360, 0x00 },
	{ 0x0361, 0x00 },
	{ 0x0362, 0x00 },
	{ 0x0487, 0x00 },
	{ 0x0502, 0x01 },
	{ 0x0508, 0x11 },
	{ 0x0509, 0x19 },
	{ 0x050A, 0x0F },
	{ 0x050B, 0x0F },
	{ 0x050C, 0x01 },
	{ 0x050D, 0x07 },
	{ 0x050E, 0x18 },
	{ 0x050F, 0x29 },
	{ 0x0510, 0x0C },
	{ 0x0511, 0x0B },
	{ 0x0512, 0x01 },
	{ 0x0513, 0x07 },
	{ 0x0515, 0x00 },
	{ 0x0516, 0x00 },
	{ 0x0517, 0x00 },
	{ 0x0518, 0x00 },
	{ 0x0519, 0x20 },
	{ 0x051A, 0x9E },
	{ 0x051B, 0x00 },
	{ 0x051C, 0x00 },
	{ 0x051D, 0x00 },
	{ 0x051E, 0x00 },
	{ 0x051F, 0x80 },
	{ 0x0521, 0x2B },
	{ 0x052A, 0x01 },
	{ 0x052B, 0x01 },
	{ 0x052C, 0x0F },
	{ 0x052D, 0x03 },
	{ 0x052E, 0x15 },
	{ 0x052F, 0x14 },
	{ 0x0531, 0x00 },
	{ 0x0532, 0xE7 },
	{ 0x0533, 0xC0 },
	{ 0x0534, 0x00 },
	{ 0x0535, 0x00 },
	{ 0x0536, 0x00 },
	{ 0x0537, 0x00 },
	{ 0x0538, 0x00 },
	{ 0x0539, 0x00 },
	{ 0x053A, 0x02 },
	{ 0x053B, 0x03 },
	{ 0x053C, 0x00 },
	{ 0x053D, 0x12 },
	{ 0x053E, 0x06 },
	{ 0x0589, 0x27 },
	{ 0x058A, 0x03 },
	{ 0x059B, 0xF8 },
	{ 0x059D, 0x18 },
	{ 0x059E, 0x29 },
	{ 0x059F, 0x0C },
	{ 0x05A0, 0x0B },
	{ 0x05A1, 0x01 },
	{ 0x05A2, 0x07 },
	{ 0x05A6, 0x00 },
	{ 0x0802, 0x35 },
	{ 0x0803, 0x05 },
	{ 0x0804, 0x00 },
	{ 0x0805, 0x00 },
	{ 0x0806, 0x00 },
	{ 0x0807, 0x00 },
	{ 0x0808, 0x00 },
	{ 0x0809, 0x00 },
	{ 0x080A, 0x00 },
	{ 0x080B, 0x00 },
	{ 0x080C, 0x00 },
	{ 0x080D, 0x00 },
	{ 0x080E, 0x00 },
	{ 0x080F, 0x00 },
	{ 0x0810, 0x00 },
	{ 0x0811, 0x00 },
	{ 0x0812, 0x00 },
	{ 0x0813, 0x00 },
	{ 0x0814, 0x00 },
	{ 0x0815, 0x00 },
	{ 0x0816, 0x00 },
	{ 0x0817, 0x00 },
	{ 0x0818, 0x00 },
	{ 0x0819, 0x00 },
	{ 0x081A, 0x00 },
	{ 0x081B, 0x00 },
	{ 0x081C, 0x00 },
	{ 0x081D, 0x00 },
	{ 0x081E, 0x00 },
	{ 0x081F, 0x00 },
	{ 0x0820, 0x00 },
	{ 0x0821, 0x00 },
	{ 0x0822, 0x00 },
	{ 0x0823, 0x00 },
	{ 0x0824, 0x00 },
	{ 0x0825, 0x00 },
	{ 0x0826, 0x00 },
	{ 0x0827, 0x00 },
	{ 0x0828, 0x00 },
	{ 0x0829, 0x00 },
	{ 0x082A, 0x00 },
	{ 0x082B, 0x00 },
	{ 0x082C, 0x00 },
	{ 0x082D, 0x00 },
	{ 0x082E, 0x00 },
	{ 0x082F, 0x00 },
	{ 0x0830, 0x00 },
	{ 0x0831, 0x00 },
	{ 0x0832, 0x00 },
	{ 0x0833, 0x00 },
	{ 0x0834, 0x00 },
	{ 0x0835, 0x00 },
	{ 0x0836, 0x00 },
	{ 0x0837, 0x00 },
	{ 0x0838, 0x00 },
	{ 0x0839, 0x00 },
	{ 0x083A, 0x00 },
	{ 0x083B, 0x00 },
	{ 0x083C, 0x00 },
	{ 0x083D, 0x00 },
	{ 0x083E, 0x00 },
	{ 0x083F, 0x00 },
	{ 0x0840, 0x00 },
	{ 0x0841, 0x00 },
	{ 0x0842, 0x00 },
	{ 0x0843, 0x00 },
	{ 0x0844, 0x00 },
	{ 0x0845, 0x00 },
	{ 0x0846, 0x00 },
	{ 0x0847, 0x00 },
	{ 0x0848, 0x00 },
	{ 0x0849, 0x00 },
	{ 0x084A, 0x00 },
	{ 0x084B, 0x00 },
	{ 0x084C, 0x00 },
	{ 0x084D, 0x00 },
	{ 0x084E, 0x00 },
	{ 0x084F, 0x00 },
	{ 0x0850, 0x00 },
	{ 0x0851, 0x00 },
	{ 0x0852, 0x00 },
	{ 0x0853, 0x00 },
	{ 0x0854, 0x00 },
	{ 0x0855, 0x00 },
	{ 0x0856, 0x00 },
	{ 0x0857, 0x00 },
	{ 0x0858, 0x00 },
	{ 0x0859, 0x00 },
	{ 0x085A, 0x00 },
	{ 0x085B, 0x00 },
	{ 0x085C, 0x00 },
	{ 0x085D, 0x00 },
	{ 0x085E, 0x00 },
	{ 0x085F, 0x00 },
	{ 0x0860, 0x00 },
	{ 0x0861, 0x00 },
	{ 0x090E, 0x03 },
	{ 0x0943, 0x00 },
	{ 0x0949, 0x31 },
	{ 0x094A, 0x01 },
	{ 0x094E, 0x49 },
	{ 0x094F, 0x02 },
	{ 0x095E, 0x00 },
	{ 0x0A02, 0x00 },
	{ 0x0A03, 0x07 },
	{ 0x0A04, 0x01 },
	{ 0x0A05, 0x07 },
	{ 0x0A14, 0x00 },
	{ 0x0A1A, 0x00 },
	{ 0x0A20, 0x00 },
	{ 0x0A26, 0x00 },
	{ 0x0A2C, 0x00 },
	{ 0x0B44, 0x2F },
	{ 0x0B46, 0x00 },
	{ 0x0B47, 0x0E },
	{ 0x0B48, 0x0E },
	{ 0x0B4A, 0x18 },
	{ 0x0B57, 0xF9 },
	{ 0x0B58, 0x00 },
	/* End configuration registers */

	/* Start configuration postamble */
	{ 0x0514, 0x01 },
	{ 0x001C, 0x01 },
	{ 0x0540, 0x00 },
	{ 0x0B24, 0xC3 },
	{ 0x0B25, 0x02 },
	/* End configuration postamble */

	{ 0x0000, 0x00 }
};

/*
 * Design Report
 *
 * Overview
 * ========
 * Part:         Si5345 Rev D
 * Project File: C:\XilinxProjects\flint_tr051017\genlock\FormatFiles\IO4K+_1125_5994.slabtimeproj
 * Design ID:    IO4K+
 * Created By:   ClockBuilder Pro v2.16.1 [2017-07-19]
 * Timestamp:    2017-08-24 16:37:53 GMT-07:00
 * 
 * Design Notes
 * ============
 * assumes NTSC HSYNC (pulsed) input = (30/1.001)*525
 * 
 * Design Rule Check
 * =================
 * Errors:
 * - No errors
 * 
 * Warnings:
 * - Pulsed LVCMOS input buffer mode has been selected. This mode has non-standard input voltage logic thresholds: 0.33 V for Vil (max) and 0.49 V for Vih (min). Select this mode only if your input clock has a duty cycle significantly less or more than 50%.  Refer to the device datasheet for the exact threshold voltage specifications and the input attenuator circuit (DC coupled Pulsed LVCMOS) in the Family Reference Manual.
 * 
 * Device Grade
 * ============
 * Maximum Output Frequency: 148.5 MHz
 * Frequency Synthesis Mode: Fractional
 * Minimum Base OPN:         Si5345B
 * Actual Base OPN:          Si5345B
 * 
 * Base       Output Clock         Supported Frequency Synthesis Modes
 * OPN Grade  Frequency Range      (Typical Jitter)
 * ---------  -------------------  --------------------------------------------
 * Si5345A    100 Hz to 1.028 GHz  Integer (< 100 fs) and fractional (< 150 fs)
 * Si5345B    100 Hz to 350 MHz    "
 * Si5345C    100 Hz to 1.028 GHz  Integer only (< 100 fs)
 * Si5345D    100 Hz to 350 MHz    "
 * 
 * Design
 * ======
 * Host Interface:
 *    I/O Power Supply: VDD (Core)
 *    SPI Mode: 4-Wire
 *    I2C Address Range: 100d to 103d / 0x64 to 0x67 (selected via A0/A1 pins)
 * 
 * XA/XB:
 *    52 MHz (XO - External Oscillator)
 * 
 * Inputs:
 *     IN0: 33.75 kHz [ 33 + 3/4 kHz ]
 *          [ (30)*1125 ]
 *          Pulsed LVCMOS
 *     IN1: Unused
 *     IN2: Unused
 *     IN3: Unused
 * 
 * Outputs:
 *    OUT0: 27 MHz
 *          Enabled, LVDS 2.5 V
 *    OUT1: Unused
 *    OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT3: Unused
 *    OUT4: Unused
 *    OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT6: Unused
 *    OUT7: Unused
 *    OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *          [ 148.5/1.001 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT9: Unused
 * 
 * Frequency Plan
 * ==============
 * Priority: maximize the number of low jitter outputs
 * 
 * Fvco = 13.662 GHz [ 13 + 331/500 GHz ]
 * Fpfd = 33.75 kHz [ 33 + 3/4 kHz ]
 * Fms0 = 594 MHz
 * Fms1 = 147.456 MHz [ 147 + 57/125 MHz ]
 * Fms2 = 890.1098901098901098... MHz [ 890 + 10/91 MHz ]
 * 
 * P dividers:
 *    P0  = 1
 *    P1  = Unused
 *    P2  = Unused
 *    P3  = Unused
 *    Pxaxb = 1
 * 
 * MXAXB = 262.7307692307692307... [ 262 + 19/26 ]
 * M = 80960
 * N dividers:
 *    N0:
 *       Value: 23
 *       Skew:  0.000 s
 *       OUT0: 27 MHz
 *       OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *    N1:
 *       Value: 92.6513671875 [ 92 + 667/1024 ]
 *       Skew:  0.000 s
 *       OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *    N2:
 *       Value: 15.3486666666666666... [ 15 + 523/1500 ]
 *       Skew:  0.000 s
 *       OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *    N3:
 *       Unused
 *    N4:
 *       Unused
 * 
 * R dividers:
 *    R0 = 22
 *    R1 = Unused
 *    R2 = 4
 *    R3 = Unused
 *    R4 = Unused
 *    R5 = 6
 *    R6 = Unused
 *    R7 = Unused
 *    R8 = 6
 *    R9 = Unused
 * 
 * Nominal Bandwidth:
 *   Desired: 1.000 Hz
 *   Actual:  651.874 mHz
 *   Coefficients:
 *      BW0:  17
 *      BW1:  25
 *      BW2:  15
 *      BW3:  15
 *      BW4:  1
 *      BW5:  7
 * Fastlock Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  107.789 Hz
 *   Coefficients:
 *      BW0:  24
 *      BW1:  41
 *      BW2:  12
 *      BW3:  11
 *      BW4:  1
 *      BW5:  7
 * Holdover Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  107.789 Hz
 *   Coefficients:
 *      BW0:  24
 *      BW1:  41
 *      BW2:  12
 *      BW3:  11
 *      BW4:  1
 *      BW5:  7
 * 
 * Dividers listed above show effective values. These values are translated to register settings by ClockBuilder Pro. For the actual register values, see below. Refer to the Family Reference Manual for information on registers related to frequency plan.
 * 
 * Digitally Controlled Oscillator (DCO)
 * =====================================
 * Mode: Register Direct Write
 * 
 * N0: DCO Disabled
 * 
 * N1: DCO Disabled
 * 
 * N2: DCO Disabled
 * 
 * N3: DCO Disabled
 * 
 * N4: DCO Disabled
 * 
 * Estimated Power & Junction Temperature
 * ======================================
 * Assumptions:
 * 
 * Revision: D
 * VDD:      1.8 V
 * Ta:       70 C
 * Airflow:  None
 * 
 * Total Power: 808 mW, On Chip Power: 784 mW, Tj: 87 C
 * 
 *                 Frequency  Format   Voltage   Current     Power
 *         -----------------  ------  --------  --------  --------
 * VDD                                   1.8 V  147.9 mA    266 mW
 * VDDA                                  3.3 V  117.4 mA    387 mW
 * VDDO0              27 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO1              Unused                                      
 * VDDO2           148.5 MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO3              Unused                                      
 * VDDO4              Unused                                      
 * VDDO5          24.576 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO6              Unused                                      
 * VDDO7              Unused                                      
 * VDDO8   148.351648... MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO9              Unused                                      
 *                                              --------  --------
 *                                       Total  327.2 mA    808 mW
 * 
 * Note:
 * 
 * -Total power includes on- and off-chip power. This is a typical value and estimate only.
 * -Use an EVB for a more exact power measurement
 * -On-chip power excludes power dissipated in external terminations.
 * -Tj is junction temperature. Tj must be less than 125 C (on Si5345 Revision D) for device to comply with datasheet specifications.
 * 
 * Settings
 * ========
 * 
 * Location      Setting Name           Decimal Value      Hex Value        
 * ------------  ---------------------  -----------------  -----------------
 * 0x000B[6:0]   I2C_ADDR               100                0x64             
 * 0x0016[1]     LOL_ON_HOLD            1                  0x1              
 * 0x0017[0]     SYSINCAL_INTR_MSK      0                  0x0              
 * 0x0017[1]     LOSXAXB_INTR_MSK       0                  0x0              
 * 0x0017[5]     SMB_TMOUT_INTR_MSK     1                  0x1              
 * 0x0018[3:0]   LOS_INTR_MSK           15                 0xF              
 * 0x0018[7:4]   OOF_INTR_MSK           15                 0xF              
 * 0x0019[1]     LOL_INTR_MSK           1                  0x1              
 * 0x0019[5]     HOLD_INTR_MSK          0                  0x0              
 * 0x001A[5]     CAL_INTR_MSK           0                  0x0              
 * 0x002B[3]     SPI_3WIRE              0                  0x0              
 * 0x002B[5]     AUTO_NDIV_UPDATE       0                  0x0              
 * 0x002C[3:0]   LOS_EN                 1                  0x1              
 * 0x002C[4]     LOSXAXB_DIS            0                  0x0              
 * 0x002D[1:0]   LOS0_VAL_TIME          2                  0x2              
 * 0x002D[3:2]   LOS1_VAL_TIME          0                  0x0              
 * 0x002D[5:4]   LOS2_VAL_TIME          0                  0x0              
 * 0x002D[7:6]   LOS3_VAL_TIME          0                  0x0              
 * 0x002E[15:0]  LOS0_TRG_THR           1944               0x0798           
 * 0x0030[15:0]  LOS1_TRG_THR           0                  0x0000           
 * 0x0032[15:0]  LOS2_TRG_THR           0                  0x0000           
 * 0x0034[15:0]  LOS3_TRG_THR           0                  0x0000           
 * 0x0036[15:0]  LOS0_CLR_THR           1782               0x06F6           
 * 0x0038[15:0]  LOS1_CLR_THR           0                  0x0000           
 * 0x003A[15:0]  LOS2_CLR_THR           0                  0x0000           
 * 0x003C[15:0]  LOS3_CLR_THR           0                  0x0000           
 * 0x003F[3:0]   OOF_EN                 1                  0x1              
 * 0x003F[7:4]   FAST_OOF_EN            0                  0x0              
 * 0x0040[2:0]   OOF_REF_SEL            4                  0x4              
 * 0x0041[4:0]   OOF0_DIV_SEL           2                  0x02             
 * 0x0042[4:0]   OOF1_DIV_SEL           0                  0x00             
 * 0x0043[4:0]   OOF2_DIV_SEL           0                  0x00             
 * 0x0044[4:0]   OOF3_DIV_SEL           0                  0x00             
 * 0x0045[4:0]   OOFXO_DIV_SEL          12                 0x0C             
 * 0x0046[7:0]   OOF0_SET_THR           150                0x96             
 * 0x0047[7:0]   OOF1_SET_THR           0                  0x00             
 * 0x0048[7:0]   OOF2_SET_THR           0                  0x00             
 * 0x0049[7:0]   OOF3_SET_THR           0                  0x00             
 * 0x004A[7:0]   OOF0_CLR_THR           75                 0x4B             
 * 0x004B[7:0]   OOF1_CLR_THR           0                  0x00             
 * 0x004C[7:0]   OOF2_CLR_THR           0                  0x00             
 * 0x004D[7:0]   OOF3_CLR_THR           0                  0x00             
 * 0x004E[2:0]   OOF0_DETWIN_SEL        5                  0x5              
 * 0x004E[6:4]   OOF1_DETWIN_SEL        0                  0x0              
 * 0x004F[2:0]   OOF2_DETWIN_SEL        0                  0x0              
 * 0x004F[6:4]   OOF3_DETWIN_SEL        0                  0x0              
 * 0x0050[3:0]   OOF_ON_LOS             15                 0xF              
 * 0x0051[3:0]   FAST_OOF0_SET_THR      0                  0x0              
 * 0x0052[3:0]   FAST_OOF1_SET_THR      0                  0x0              
 * 0x0053[3:0]   FAST_OOF2_SET_THR      0                  0x0              
 * 0x0054[3:0]   FAST_OOF3_SET_THR      0                  0x0              
 * 0x0055[3:0]   FAST_OOF0_CLR_THR      0                  0x0              
 * 0x0056[3:0]   FAST_OOF1_CLR_THR      0                  0x0              
 * 0x0057[3:0]   FAST_OOF2_CLR_THR      0                  0x0              
 * 0x0058[3:0]   FAST_OOF3_CLR_THR      0                  0x0              
 * 0x0059[1:0]   FAST_OOF0_DETWIN_SEL   1                  0x1              
 * 0x0059[3:2]   FAST_OOF1_DETWIN_SEL   0                  0x0              
 * 0x0059[5:4]   FAST_OOF2_DETWIN_SEL   0                  0x0              
 * 0x0059[7:6]   FAST_OOF3_DETWIN_SEL   0                  0x0              
 * 0x005A[25:0]  OOF0_RATIO_REF         11150395           0x0AA243B        
 * 0x005E[25:0]  OOF1_RATIO_REF         0                  0x0000000        
 * 0x0062[25:0]  OOF2_RATIO_REF         0                  0x0000000        
 * 0x0066[25:0]  OOF3_RATIO_REF         0                  0x0000000        
 * 0x0092[1]     LOL_FST_EN             1                  0x1              
 * 0x0093[7:4]   LOL_FST_DETWIN_SEL     10                 0xA              
 * 0x0095[3:2]   LOL_FST_VALWIN_SEL     0                  0x0              
 * 0x0096[7:4]   LOL_FST_SET_THR_SEL    9                  0x9              
 * 0x0098[7:4]   LOL_FST_CLR_THR_SEL    7                  0x7              
 * 0x009A[1]     LOL_SLOW_EN_PLL        1                  0x1              
 * 0x009B[7:4]   LOL_SLW_DETWIN_SEL     5                  0x5              
 * 0x009D[3:2]   LOL_SLW_VALWIN_SEL     1                  0x1              
 * 0x009E[7:4]   LOL_SLW_SET_THR        6                  0x6              
 * 0x00A0[7:4]   LOL_SLW_CLR_THR        3                  0x3              
 * 0x00A2[1]     LOL_TIMER_EN           0                  0x0              
 * 0x00A9[28:0]  LOL_CLR_DELAY_DIV256   294274             0x00047D82       
 * 0x00E5[5]     FASTLOCK_EXTEND_EN     1                  0x1              
 * 0x00EA[28:0]  FASTLOCK_EXTEND        242129             0x0003B1D1       
 * 0x0102[0]     OUTALL_DISABLE_LOW     1                  0x1              
 * 0x0108[0]     OUT0_PDN               0                  0x0              
 * 0x0108[1]     OUT0_OE                1                  0x1              
 * 0x0108[2]     OUT0_RDIV_FORCE2       0                  0x0              
 * 0x0109[2:0]   OUT0_FORMAT            1                  0x1              
 * 0x0109[3]     OUT0_SYNC_EN           1                  0x1              
 * 0x0109[5:4]   OUT0_DIS_STATE         0                  0x0              
 * 0x0109[7:6]   OUT0_CMOS_DRV          0                  0x0              
 * 0x010A[3:0]   OUT0_CM                11                 0xB              
 * 0x010A[6:4]   OUT0_AMPL              3                  0x3              
 * 0x010B[2:0]   OUT0_MUX_SEL           0                  0x0              
 * 0x010B[5:4]   OUT0_VDD_SEL           2                  0x2              
 * 0x010B[3]     OUT0_VDD_SEL_EN        1                  0x1              
 * 0x010B[7:6]   OUT0_INV               0                  0x0              
 * 0x010D[0]     OUT1_PDN               1                  0x1              
 * 0x010D[1]     OUT1_OE                0                  0x0              
 * 0x010D[2]     OUT1_RDIV_FORCE2       0                  0x0              
 * 0x010E[2:0]   OUT1_FORMAT            1                  0x1              
 * 0x010E[3]     OUT1_SYNC_EN           1                  0x1              
 * 0x010E[5:4]   OUT1_DIS_STATE         0                  0x0              
 * 0x010E[7:6]   OUT1_CMOS_DRV          0                  0x0              
 * 0x010F[3:0]   OUT1_CM                11                 0xB              
 * 0x010F[6:4]   OUT1_AMPL              3                  0x3              
 * 0x0110[2:0]   OUT1_MUX_SEL           0                  0x0              
 * 0x0110[5:4]   OUT1_VDD_SEL           2                  0x2              
 * 0x0110[3]     OUT1_VDD_SEL_EN        1                  0x1              
 * 0x0110[7:6]   OUT1_INV               0                  0x0              
 * 0x0112[0]     OUT2_PDN               0                  0x0              
 * 0x0112[1]     OUT2_OE                1                  0x1              
 * 0x0112[2]     OUT2_RDIV_FORCE2       0                  0x0              
 * 0x0113[2:0]   OUT2_FORMAT            1                  0x1              
 * 0x0113[3]     OUT2_SYNC_EN           1                  0x1              
 * 0x0113[5:4]   OUT2_DIS_STATE         0                  0x0              
 * 0x0113[7:6]   OUT2_CMOS_DRV          0                  0x0              
 * 0x0114[3:0]   OUT2_CM                11                 0xB              
 * 0x0114[6:4]   OUT2_AMPL              3                  0x3              
 * 0x0115[2:0]   OUT2_MUX_SEL           0                  0x0              
 * 0x0115[5:4]   OUT2_VDD_SEL           2                  0x2              
 * 0x0115[3]     OUT2_VDD_SEL_EN        1                  0x1              
 * 0x0115[7:6]   OUT2_INV               0                  0x0              
 * 0x0117[0]     OUT3_PDN               1                  0x1              
 * 0x0117[1]     OUT3_OE                0                  0x0              
 * 0x0117[2]     OUT3_RDIV_FORCE2       0                  0x0              
 * 0x0118[2:0]   OUT3_FORMAT            1                  0x1              
 * 0x0118[3]     OUT3_SYNC_EN           1                  0x1              
 * 0x0118[5:4]   OUT3_DIS_STATE         0                  0x0              
 * 0x0118[7:6]   OUT3_CMOS_DRV          0                  0x0              
 * 0x0119[3:0]   OUT3_CM                11                 0xB              
 * 0x0119[6:4]   OUT3_AMPL              3                  0x3              
 * 0x011A[2:0]   OUT3_MUX_SEL           0                  0x0              
 * 0x011A[5:4]   OUT3_VDD_SEL           2                  0x2              
 * 0x011A[3]     OUT3_VDD_SEL_EN        1                  0x1              
 * 0x011A[7:6]   OUT3_INV               0                  0x0              
 * 0x011C[0]     OUT4_PDN               1                  0x1              
 * 0x011C[1]     OUT4_OE                0                  0x0              
 * 0x011C[2]     OUT4_RDIV_FORCE2       0                  0x0              
 * 0x011D[2:0]   OUT4_FORMAT            1                  0x1              
 * 0x011D[3]     OUT4_SYNC_EN           1                  0x1              
 * 0x011D[5:4]   OUT4_DIS_STATE         0                  0x0              
 * 0x011D[7:6]   OUT4_CMOS_DRV          0                  0x0              
 * 0x011E[3:0]   OUT4_CM                11                 0xB              
 * 0x011E[6:4]   OUT4_AMPL              3                  0x3              
 * 0x011F[2:0]   OUT4_MUX_SEL           0                  0x0              
 * 0x011F[5:4]   OUT4_VDD_SEL           2                  0x2              
 * 0x011F[3]     OUT4_VDD_SEL_EN        1                  0x1              
 * 0x011F[7:6]   OUT4_INV               0                  0x0              
 * 0x0121[0]     OUT5_PDN               0                  0x0              
 * 0x0121[1]     OUT5_OE                1                  0x1              
 * 0x0121[2]     OUT5_RDIV_FORCE2       0                  0x0              
 * 0x0122[2:0]   OUT5_FORMAT            1                  0x1              
 * 0x0122[3]     OUT5_SYNC_EN           1                  0x1              
 * 0x0122[5:4]   OUT5_DIS_STATE         0                  0x0              
 * 0x0122[7:6]   OUT5_CMOS_DRV          0                  0x0              
 * 0x0123[3:0]   OUT5_CM                11                 0xB              
 * 0x0123[6:4]   OUT5_AMPL              3                  0x3              
 * 0x0124[2:0]   OUT5_MUX_SEL           1                  0x1              
 * 0x0124[5:4]   OUT5_VDD_SEL           2                  0x2              
 * 0x0124[3]     OUT5_VDD_SEL_EN        1                  0x1              
 * 0x0124[7:6]   OUT5_INV               0                  0x0              
 * 0x0126[0]     OUT6_PDN               1                  0x1              
 * 0x0126[1]     OUT6_OE                0                  0x0              
 * 0x0126[2]     OUT6_RDIV_FORCE2       0                  0x0              
 * 0x0127[2:0]   OUT6_FORMAT            1                  0x1              
 * 0x0127[3]     OUT6_SYNC_EN           1                  0x1              
 * 0x0127[5:4]   OUT6_DIS_STATE         0                  0x0              
 * 0x0127[7:6]   OUT6_CMOS_DRV          0                  0x0              
 * 0x0128[3:0]   OUT6_CM                11                 0xB              
 * 0x0128[6:4]   OUT6_AMPL              3                  0x3              
 * 0x0129[2:0]   OUT6_MUX_SEL           0                  0x0              
 * 0x0129[5:4]   OUT6_VDD_SEL           2                  0x2              
 * 0x0129[3]     OUT6_VDD_SEL_EN        1                  0x1              
 * 0x0129[7:6]   OUT6_INV               0                  0x0              
 * 0x012B[0]     OUT7_PDN               1                  0x1              
 * 0x012B[1]     OUT7_OE                0                  0x0              
 * 0x012B[2]     OUT7_RDIV_FORCE2       0                  0x0              
 * 0x012C[2:0]   OUT7_FORMAT            1                  0x1              
 * 0x012C[3]     OUT7_SYNC_EN           1                  0x1              
 * 0x012C[5:4]   OUT7_DIS_STATE         0                  0x0              
 * 0x012C[7:6]   OUT7_CMOS_DRV          0                  0x0              
 * 0x012D[3:0]   OUT7_CM                11                 0xB              
 * 0x012D[6:4]   OUT7_AMPL              3                  0x3              
 * 0x012E[2:0]   OUT7_MUX_SEL           0                  0x0              
 * 0x012E[5:4]   OUT7_VDD_SEL           2                  0x2              
 * 0x012E[3]     OUT7_VDD_SEL_EN        1                  0x1              
 * 0x012E[7:6]   OUT7_INV               0                  0x0              
 * 0x0130[0]     OUT8_PDN               0                  0x0              
 * 0x0130[1]     OUT8_OE                1                  0x1              
 * 0x0130[2]     OUT8_RDIV_FORCE2       0                  0x0              
 * 0x0131[2:0]   OUT8_FORMAT            1                  0x1              
 * 0x0131[3]     OUT8_SYNC_EN           1                  0x1              
 * 0x0131[5:4]   OUT8_DIS_STATE         0                  0x0              
 * 0x0131[7:6]   OUT8_CMOS_DRV          0                  0x0              
 * 0x0132[3:0]   OUT8_CM                11                 0xB              
 * 0x0132[6:4]   OUT8_AMPL              3                  0x3              
 * 0x0133[2:0]   OUT8_MUX_SEL           2                  0x2              
 * 0x0133[5:4]   OUT8_VDD_SEL           2                  0x2              
 * 0x0133[3]     OUT8_VDD_SEL_EN        1                  0x1              
 * 0x0133[7:6]   OUT8_INV               0                  0x0              
 * 0x013A[0]     OUT9_PDN               1                  0x1              
 * 0x013A[1]     OUT9_OE                0                  0x0              
 * 0x013A[2]     OUT9_RDIV_FORCE2       0                  0x0              
 * 0x013B[2:0]   OUT9_FORMAT            1                  0x1              
 * 0x013B[3]     OUT9_SYNC_EN           1                  0x1              
 * 0x013B[5:4]   OUT9_DIS_STATE         0                  0x0              
 * 0x013B[7:6]   OUT9_CMOS_DRV          0                  0x0              
 * 0x013C[3:0]   OUT9_CM                11                 0xB              
 * 0x013C[6:4]   OUT9_AMPL              3                  0x3              
 * 0x013D[2:0]   OUT9_MUX_SEL           0                  0x0              
 * 0x013D[5:4]   OUT9_VDD_SEL           2                  0x2              
 * 0x013D[3]     OUT9_VDD_SEL_EN        1                  0x1              
 * 0x013D[7:6]   OUT9_INV               0                  0x0              
 * 0x013F[11:0]  OUTX_ALWAYS_ON         0                  0x000            
 * 0x0141[1]     OUT_DIS_MSK            0                  0x0              
 * 0x0141[5]     OUT_DIS_LOL_MSK        0                  0x0              
 * 0x0141[6]     OUT_DIS_LOSXAXB_MSK    1                  0x1              
 * 0x0141[7]     OUT_DIS_MSK_LOS_PFD    0                  0x0              
 * 0x0142[1]     OUT_DIS_MSK_LOL        1                  0x1              
 * 0x0142[5]     OUT_DIS_MSK_HOLD       1                  0x1              
 * 0x0206[1:0]   PXAXB                  0                  0x0              
 * 0x0208[47:0]  P0_NUM                 1                  0x000000000001   
 * 0x020E[31:0]  P0_DEN                 1                  0x00000001       
 * 0x0212[47:0]  P1_NUM                 0                  0x000000000000   
 * 0x0218[31:0]  P1_DEN                 0                  0x00000000       
 * 0x021C[47:0]  P2_NUM                 0                  0x000000000000   
 * 0x0222[31:0]  P2_DEN                 0                  0x00000000       
 * 0x0226[47:0]  P3_NUM                 0                  0x000000000000   
 * 0x022C[31:0]  P3_DEN                 0                  0x00000000       
 * 0x0231[3:0]   P0_FRACN_MODE          11                 0xB              
 * 0x0231[4]     P0_FRACN_EN            0                  0x0              
 * 0x0232[3:0]   P1_FRACN_MODE          11                 0xB              
 * 0x0232[4]     P1_FRACN_EN            0                  0x0              
 * 0x0233[3:0]   P2_FRACN_MODE          11                 0xB              
 * 0x0233[4]     P2_FRACN_EN            0                  0x0              
 * 0x0234[3:0]   P3_FRACN_MODE          11                 0xB              
 * 0x0234[4]     P3_FRACN_EN            0                  0x0              
 * 0x0235[43:0]  MXAXB_NUM              916841299968       0x0D578000000    
 * 0x023B[31:0]  MXAXB_DEN              3489660928         0xD0000000       
 * 0x024A[23:0]  R0_REG                 10                 0x00000A         
 * 0x024D[23:0]  R1_REG                 0                  0x000000         
 * 0x0250[23:0]  R2_REG                 1                  0x000001         
 * 0x0253[23:0]  R3_REG                 0                  0x000000         
 * 0x0256[23:0]  R4_REG                 0                  0x000000         
 * 0x0259[23:0]  R5_REG                 2                  0x000002         
 * 0x025C[23:0]  R6_REG                 0                  0x000000         
 * 0x025F[23:0]  R7_REG                 0                  0x000000         
 * 0x0262[23:0]  R8_REG                 2                  0x000002         
 * 0x0268[23:0]  R9_REG                 0                  0x000000         
 * 0x026B[7:0]   DESIGN_ID0             73                 0x49             
 * 0x026C[7:0]   DESIGN_ID1             79                 0x4F             
 * 0x026D[7:0]   DESIGN_ID2             52                 0x34             
 * 0x026E[7:0]   DESIGN_ID3             75                 0x4B             
 * 0x026F[7:0]   DESIGN_ID4             43                 0x2B             
 * 0x0270[7:0]   DESIGN_ID5             0                  0x00             
 * 0x0271[7:0]   DESIGN_ID6             0                  0x00             
 * 0x0272[7:0]   DESIGN_ID7             0                  0x00             
 * 0x0294[7:4]   FASTLOCK_EXTEND_SCL    8                  0x8              
 * 0x0296[1]     LOL_SLW_VALWIN_SELX    0                  0x0              
 * 0x0297[1]     FASTLOCK_DLY_ONSW_EN   1                  0x1              
 * 0x0299[1]     FASTLOCK_DLY_ONLOL_EN  1                  0x1              
 * 0x029D[19:0]  FASTLOCK_DLY_ONLOL     3829               0x00EF5          
 * 0x02A9[19:0]  FASTLOCK_DLY_ONSW      9830               0x02666          
 * 0x02B7[3:2]   LOL_NOSIG_TIME         3                  0x3              
 * 0x0302[43:0]  N0_NUM                 49392123904        0x00B80000000    
 * 0x0308[31:0]  N0_DEN                 2147483648         0x80000000       
 * 0x030C[0]     N0_UPDATE              0                  0x0              
 * 0x030D[43:0]  N1_NUM                 198967296000       0x02E53600000    
 * 0x0313[31:0]  N1_DEN                 2147483648         0x80000000       
 * 0x0317[0]     N1_UPDATE              0                  0x0              
 * 0x0318[43:0]  N2_NUM                 48282730496        0x00B3DE00000    
 * 0x031E[31:0]  N2_DEN                 3145728000         0xBB800000       
 * 0x0322[0]     N2_UPDATE              0                  0x0              
 * 0x0323[43:0]  N3_NUM                 0                  0x00000000000    
 * 0x0329[31:0]  N3_DEN                 0                  0x00000000       
 * 0x032D[0]     N3_UPDATE              0                  0x0              
 * 0x032E[43:0]  N4_NUM                 0                  0x00000000000    
 * 0x0334[31:0]  N4_DEN                 0                  0x00000000       
 * 0x0338[0]     N4_UPDATE              0                  0x0              
 * 0x0338[1]     N_UPDATE               0                  0x0              
 * 0x0339[4:0]   N_FSTEP_MSK            31                 0x1F             
 * 0x033B[43:0]  N0_FSTEPW              0                  0x00000000000    
 * 0x0341[43:0]  N1_FSTEPW              0                  0x00000000000    
 * 0x0347[43:0]  N2_FSTEPW              0                  0x00000000000    
 * 0x034D[43:0]  N3_FSTEPW              0                  0x00000000000    
 * 0x0353[43:0]  N4_FSTEPW              0                  0x00000000000    
 * 0x0359[15:0]  N0_DELAY               0                  0x0000           
 * 0x035B[15:0]  N1_DELAY               0                  0x0000           
 * 0x035D[15:0]  N2_DELAY               0                  0x0000           
 * 0x035F[15:0]  N3_DELAY               0                  0x0000           
 * 0x0361[15:0]  N4_DELAY               0                  0x0000           
 * 0x0487[0]     ZDM_EN                 0                  0x0              
 * 0x0487[2:1]   ZDM_IN_SEL             0                  0x0              
 * 0x0487[4]     ZDM_AUTOSW_EN          0                  0x0              
 * 0x0502[4]     ADD_DIV256             0                  0x0              
 * 0x0508[5:0]   BW0_PLL                17                 0x11             
 * 0x0509[5:0]   BW1_PLL                25                 0x19             
 * 0x050A[5:0]   BW2_PLL                15                 0x0F             
 * 0x050B[5:0]   BW3_PLL                15                 0x0F             
 * 0x050C[5:0]   BW4_PLL                1                  0x01             
 * 0x050D[5:0]   BW5_PLL                7                  0x07             
 * 0x050E[5:0]   FASTLOCK_BW0_PLL       24                 0x18             
 * 0x050F[5:0]   FASTLOCK_BW1_PLL       41                 0x29             
 * 0x0510[5:0]   FASTLOCK_BW2_PLL       12                 0x0C             
 * 0x0511[5:0]   FASTLOCK_BW3_PLL       11                 0x0B             
 * 0x0512[5:0]   FASTLOCK_BW4_PLL       1                  0x01             
 * 0x0513[5:0]   FASTLOCK_BW5_PLL       7                  0x07             
 * 0x0515[55:0]  M_NUM                  173860276142080    0x009E2000000000 
 * 0x051C[31:0]  M_DEN                  2147483648         0x80000000       
 * 0x0521[3:0]   M_FRAC_MODE            11                 0xB              
 * 0x0521[4]     M_FRAC_EN              0                  0x0              
 * 0x0521[5]     PLL_OUT_RATE_SEL       1                  0x1              
 * 0x052A[0]     IN_SEL_REGCTRL         1                  0x1              
 * 0x052A[3:1]   IN_SEL                 0                  0x0              
 * 0x052B[0]     FASTLOCK_AUTO_EN       1                  0x1              
 * 0x052B[1]     FASTLOCK_MAN           0                  0x0              
 * 0x052C[0]     HOLD_EN                1                  0x1              
 * 0x052C[3]     HOLD_RAMP_BYP          1                  0x1              
 * 0x052C[4]     HOLDEXIT_BW_SEL1       0                  0x0              
 * 0x052C[7:5]   RAMP_STEP_INTERVAL     0                  0x0              
 * 0x052D[1]     HOLD_RAMPBYP_NOHIST    1                  0x1              
 * 0x052E[4:0]   HOLD_HIST_LEN          21                 0x15             
 * 0x052F[4:0]   HOLD_HIST_DELAY        20                 0x14             
 * 0x0531[4:0]   HOLD_REF_COUNT_FRC     0                  0x00             
 * 0x0532[23:0]  HOLD_15M_CYC_COUNT     49383              0x00C0E7         
 * 0x0535[0]     FORCE_HOLD             0                  0x0              
 * 0x0536[1:0]   CLK_SWITCH_MODE        0                  0x0              
 * 0x0536[2]     HSW_EN                 0                  0x0              
 * 0x0537[3:0]   IN_LOS_MSK             0                  0x0              
 * 0x0537[7:4]   IN_OOF_MSK             0                  0x0              
 * 0x0538[2:0]   IN0_PRIORITY           0                  0x0              
 * 0x0538[6:4]   IN1_PRIORITY           0                  0x0              
 * 0x0539[2:0]   IN2_PRIORITY           0                  0x0              
 * 0x0539[6:4]   IN3_PRIORITY           0                  0x0              
 * 0x053A[1:0]   HSW_MODE               2                  0x2              
 * 0x053A[3:2]   HSW_PHMEAS_CTRL        0                  0x0              
 * 0x053B[9:0]   HSW_PHMEAS_THR         3                  0x003            
 * 0x053D[4:0]   HSW_COARSE_PM_LEN      18                 0x12             
 * 0x053E[4:0]   HSW_COARSE_PM_DLY      6                  0x06             
 * 0x0589[12:0]  CAP_SHORT_DELAY        807                0x0327           
 * 0x059B[4]     HOLD_PRESERVE_HIST     1                  0x1              
 * 0x059B[5]     HOLD_FRZ_WITH_INTONLY  1                  0x1              
 * 0x059B[6]     HOLDEXIT_BW_SEL0       1                  0x1              
 * 0x059B[7]     HOLDEXIT_STD_BO        1                  0x1              
 * 0x059D[5:0]   HOLDEXIT_BW0           24                 0x18             
 * 0x059E[5:0]   HOLDEXIT_BW1           41                 0x29             
 * 0x059F[5:0]   HOLDEXIT_BW2           12                 0x0C             
 * 0x05A0[5:0]   HOLDEXIT_BW3           11                 0x0B             
 * 0x05A1[5:0]   HOLDEXIT_BW4           1                  0x01             
 * 0x05A2[5:0]   HOLDEXIT_BW5           7                  0x07             
 * 0x05A6[2:0]   RAMP_STEP_SIZE         0                  0x0              
 * 0x05A6[3]     RAMP_SWITCH_EN         0                  0x0              
 * 0x0802[15:0]  FIXREGSA0              1333               0x0535           
 * 0x0804[7:0]   FIXREGSD0              0                  0x00             
 * 0x0805[15:0]  FIXREGSA1              0                  0x0000           
 * 0x0807[7:0]   FIXREGSD1              0                  0x00             
 * 0x0808[15:0]  FIXREGSA2              0                  0x0000           
 * 0x080A[7:0]   FIXREGSD2              0                  0x00             
 * 0x080B[15:0]  FIXREGSA3              0                  0x0000           
 * 0x080D[7:0]   FIXREGSD3              0                  0x00             
 * 0x080E[15:0]  FIXREGSA4              0                  0x0000           
 * 0x0810[7:0]   FIXREGSD4              0                  0x00             
 * 0x0811[15:0]  FIXREGSA5              0                  0x0000           
 * 0x0813[7:0]   FIXREGSD5              0                  0x00             
 * 0x0814[15:0]  FIXREGSA6              0                  0x0000           
 * 0x0816[7:0]   FIXREGSD6              0                  0x00             
 * 0x0817[15:0]  FIXREGSA7              0                  0x0000           
 * 0x0819[7:0]   FIXREGSD7              0                  0x00             
 * 0x081A[15:0]  FIXREGSA8              0                  0x0000           
 * 0x081C[7:0]   FIXREGSD8              0                  0x00             
 * 0x081D[15:0]  FIXREGSA9              0                  0x0000           
 * 0x081F[7:0]   FIXREGSD9              0                  0x00             
 * 0x0820[15:0]  FIXREGSA10             0                  0x0000           
 * 0x0822[7:0]   FIXREGSD10             0                  0x00             
 * 0x0823[15:0]  FIXREGSA11             0                  0x0000           
 * 0x0825[7:0]   FIXREGSD11             0                  0x00             
 * 0x0826[15:0]  FIXREGSA12             0                  0x0000           
 * 0x0828[7:0]   FIXREGSD12             0                  0x00             
 * 0x0829[15:0]  FIXREGSA13             0                  0x0000           
 * 0x082B[7:0]   FIXREGSD13             0                  0x00             
 * 0x082C[15:0]  FIXREGSA14             0                  0x0000           
 * 0x082E[7:0]   FIXREGSD14             0                  0x00             
 * 0x082F[15:0]  FIXREGSA15             0                  0x0000           
 * 0x0831[7:0]   FIXREGSD15             0                  0x00             
 * 0x0832[15:0]  FIXREGSA16             0                  0x0000           
 * 0x0834[7:0]   FIXREGSD16             0                  0x00             
 * 0x0835[15:0]  FIXREGSA17             0                  0x0000           
 * 0x0837[7:0]   FIXREGSD17             0                  0x00             
 * 0x0838[15:0]  FIXREGSA18             0                  0x0000           
 * 0x083A[7:0]   FIXREGSD18             0                  0x00             
 * 0x083B[15:0]  FIXREGSA19             0                  0x0000           
 * 0x083D[7:0]   FIXREGSD19             0                  0x00             
 * 0x083E[15:0]  FIXREGSA20             0                  0x0000           
 * 0x0840[7:0]   FIXREGSD20             0                  0x00             
 * 0x0841[15:0]  FIXREGSA21             0                  0x0000           
 * 0x0843[7:0]   FIXREGSD21             0                  0x00             
 * 0x0844[15:0]  FIXREGSA22             0                  0x0000           
 * 0x0846[7:0]   FIXREGSD22             0                  0x00             
 * 0x0847[15:0]  FIXREGSA23             0                  0x0000           
 * 0x0849[7:0]   FIXREGSD23             0                  0x00             
 * 0x084A[15:0]  FIXREGSA24             0                  0x0000           
 * 0x084C[7:0]   FIXREGSD24             0                  0x00             
 * 0x084D[15:0]  FIXREGSA25             0                  0x0000           
 * 0x084F[7:0]   FIXREGSD25             0                  0x00             
 * 0x0850[15:0]  FIXREGSA26             0                  0x0000           
 * 0x0852[7:0]   FIXREGSD26             0                  0x00             
 * 0x0853[15:0]  FIXREGSA27             0                  0x0000           
 * 0x0855[7:0]   FIXREGSD27             0                  0x00             
 * 0x0856[15:0]  FIXREGSA28             0                  0x0000           
 * 0x0858[7:0]   FIXREGSD28             0                  0x00             
 * 0x0859[15:0]  FIXREGSA29             0                  0x0000           
 * 0x085B[7:0]   FIXREGSD29             0                  0x00             
 * 0x085C[15:0]  FIXREGSA30             0                  0x0000           
 * 0x085E[7:0]   FIXREGSD30             0                  0x00             
 * 0x085F[15:0]  FIXREGSA31             0                  0x0000           
 * 0x0861[7:0]   FIXREGSD31             0                  0x00             
 * 0x090E[0]     XAXB_EXTCLK_EN         1                  0x1              
 * 0x0943[0]     IO_VDD_SEL             0                  0x0              
 * 0x0949[3:0]   IN_EN                  1                  0x1              
 * 0x0949[7:4]   IN_PULSED_CMOS_EN      3                  0x3              
 * 0x094A[3:0]   INX_TO_PFD_EN          1                  0x1              
 * 0x094E[11:0]  REFCLK_HYS_SEL         585                0x249            
 * 0x095E[0]     MXAXB_INTEGER          0                  0x0              
 * 0x0A02[4:0]   N_ADD_0P5              0                  0x00             
 * 0x0A03[4:0]   N_CLK_TO_OUTX_EN       7                  0x07             
 * 0x0A04[4:0]   N_PIBYP                1                  0x01             
 * 0x0A05[4:0]   N_PDNB                 7                  0x07             
 * 0x0A14[3]     N0_HIGH_FREQ           0                  0x0              
 * 0x0A1A[3]     N1_HIGH_FREQ           0                  0x0              
 * 0x0A20[3]     N2_HIGH_FREQ           0                  0x0              
 * 0x0A26[3]     N3_HIGH_FREQ           0                  0x0              
 * 0x0A2C[3]     N4_HIGH_FREQ           0                  0x0              
 * 0x0B44[3:0]   PDIV_FRACN_CLK_DIS     15                 0xF              
 * 0x0B44[5]     FRACN_CLK_DIS_PLL      1                  0x1              
 * 0x0B46[3:0]   LOS_CLK_DIS            0                  0x0              
 * 0x0B47[4:0]   OOF_CLK_DIS            14                 0x0E             
 * 0x0B48[4:0]   OOF_DIV_CLK_DIS        14                 0x0E             
 * 0x0B4A[4:0]   N_CLK_DIS              24                 0x18             
 * 0x0B57[11:0]  VCO_RESET_CALCODE      249                0x0F9
 * 
 *
 */


static struct ntv2_genlock_data s_genlock_1125_4795[] =
{
	/* Start configuration preamble */
	{ 0x0B24, 0xC0 },
	{ 0x0B25, 0x00 },
	{ 0x0540, 0x01 },
	/* End configuration preamble */

	/* Delay 300 msec */
	/*    Delay is worst case time for device to complete any calibration */
	/*    that is running due to device state change previous to this script */
	/*    being processed. */
	{ 0x0000, 0x01 },

	/* Start configuration registers */
	{ 0x000B, 0x64 },
	{ 0x0016, 0x02 },
	{ 0x0017, 0xFC },
	{ 0x0018, 0xFF },
	{ 0x0019, 0xDF },
	{ 0x001A, 0xDF },
	{ 0x002B, 0x02 },
	{ 0x002C, 0x01 },
	{ 0x002D, 0x02 },
	{ 0x002E, 0xC0 },
	{ 0x002F, 0x04 },
	{ 0x0030, 0x00 },
	{ 0x0031, 0x00 },
	{ 0x0032, 0x00 },
	{ 0x0033, 0x00 },
	{ 0x0034, 0x00 },
	{ 0x0035, 0x00 },
	{ 0x0036, 0x5B },
	{ 0x0037, 0x04 },
	{ 0x0038, 0x00 },
	{ 0x0039, 0x00 },
	{ 0x003A, 0x00 },
	{ 0x003B, 0x00 },
	{ 0x003C, 0x00 },
	{ 0x003D, 0x00 },
	{ 0x003F, 0x01 },
	{ 0x0040, 0x04 },
	{ 0x0041, 0x02 },
	{ 0x0042, 0x00 },
	{ 0x0043, 0x00 },
	{ 0x0044, 0x00 },
	{ 0x0045, 0x0C },
	{ 0x0046, 0x96 },
	{ 0x0047, 0x00 },
	{ 0x0048, 0x00 },
	{ 0x0049, 0x00 },
	{ 0x004A, 0x4B },
	{ 0x004B, 0x00 },
	{ 0x004C, 0x00 },
	{ 0x004D, 0x00 },
	{ 0x004E, 0x05 },
	{ 0x004F, 0x00 },
	{ 0x0050, 0x0F },
	{ 0x0051, 0x00 },
	{ 0x0052, 0x00 },
	{ 0x0053, 0x00 },
	{ 0x0054, 0x00 },
	{ 0x0055, 0x00 },
	{ 0x0056, 0x00 },
	{ 0x0057, 0x00 },
	{ 0x0058, 0x00 },
	{ 0x0059, 0x01 },
	{ 0x005A, 0x5A },
	{ 0x005B, 0xF4 },
	{ 0x005C, 0x0F },
	{ 0x005D, 0x01 },
	{ 0x005E, 0x00 },
	{ 0x005F, 0x00 },
	{ 0x0060, 0x00 },
	{ 0x0061, 0x00 },
	{ 0x0062, 0x00 },
	{ 0x0063, 0x00 },
	{ 0x0064, 0x00 },
	{ 0x0065, 0x00 },
	{ 0x0066, 0x00 },
	{ 0x0067, 0x00 },
	{ 0x0068, 0x00 },
	{ 0x0069, 0x00 },
	{ 0x0092, 0x02 },
	{ 0x0093, 0xA0 },
	{ 0x0095, 0x00 },
	{ 0x0096, 0x90 },
	{ 0x0098, 0x70 },
	{ 0x009A, 0x02 },
	{ 0x009B, 0x50 },
	{ 0x009D, 0x04 },
	{ 0x009E, 0x60 },
	{ 0x00A0, 0x30 },
	{ 0x00A2, 0x00 },
	{ 0x00A9, 0xB3 },
	{ 0x00AA, 0xB1 },
	{ 0x00AB, 0x04 },
	{ 0x00AC, 0x00 },
	{ 0x00E5, 0x21 },
	{ 0x00EA, 0xD1 },
	{ 0x00EB, 0xB1 },
	{ 0x00EC, 0x03 },
	{ 0x00ED, 0x00 },
	{ 0x0102, 0x01 },
	{ 0x0108, 0x02 },
	{ 0x0109, 0x09 },
	{ 0x010A, 0x3B },
	{ 0x010B, 0x28 },
	{ 0x010D, 0x01 },
	{ 0x010E, 0x09 },
	{ 0x010F, 0x3B },
	{ 0x0110, 0x28 },
	{ 0x0112, 0x02 },
	{ 0x0113, 0x09 },
	{ 0x0114, 0x3B },
	{ 0x0115, 0x28 },
	{ 0x0117, 0x01 },
	{ 0x0118, 0x09 },
	{ 0x0119, 0x3B },
	{ 0x011A, 0x28 },
	{ 0x011C, 0x01 },
	{ 0x011D, 0x09 },
	{ 0x011E, 0x3B },
	{ 0x011F, 0x28 },
	{ 0x0121, 0x02 },
	{ 0x0122, 0x09 },
	{ 0x0123, 0x3B },
	{ 0x0124, 0x29 },
	{ 0x0126, 0x01 },
	{ 0x0127, 0x09 },
	{ 0x0128, 0x3B },
	{ 0x0129, 0x28 },
	{ 0x012B, 0x01 },
	{ 0x012C, 0x09 },
	{ 0x012D, 0x3B },
	{ 0x012E, 0x28 },
	{ 0x0130, 0x02 },
	{ 0x0131, 0x09 },
	{ 0x0132, 0x3B },
	{ 0x0133, 0x2A },
	{ 0x013A, 0x01 },
	{ 0x013B, 0x09 },
	{ 0x013C, 0x3B },
	{ 0x013D, 0x28 },
	{ 0x013F, 0x00 },
	{ 0x0140, 0x00 },
	{ 0x0141, 0x40 },
	{ 0x0142, 0xFF },
	{ 0x0206, 0x00 },
	{ 0x0208, 0x01 },
	{ 0x0209, 0x00 },
	{ 0x020A, 0x00 },
	{ 0x020B, 0x00 },
	{ 0x020C, 0x00 },
	{ 0x020D, 0x00 },
	{ 0x020E, 0x01 },
	{ 0x020F, 0x00 },
	{ 0x0210, 0x00 },
	{ 0x0211, 0x00 },
	{ 0x0212, 0x00 },
	{ 0x0213, 0x00 },
	{ 0x0214, 0x00 },
	{ 0x0215, 0x00 },
	{ 0x0216, 0x00 },
	{ 0x0217, 0x00 },
	{ 0x0218, 0x00 },
	{ 0x0219, 0x00 },
	{ 0x021A, 0x00 },
	{ 0x021B, 0x00 },
	{ 0x021C, 0x00 },
	{ 0x021D, 0x00 },
	{ 0x021E, 0x00 },
	{ 0x021F, 0x00 },
	{ 0x0220, 0x00 },
	{ 0x0221, 0x00 },
	{ 0x0222, 0x00 },
	{ 0x0223, 0x00 },
	{ 0x0224, 0x00 },
	{ 0x0225, 0x00 },
	{ 0x0226, 0x00 },
	{ 0x0227, 0x00 },
	{ 0x0228, 0x00 },
	{ 0x0229, 0x00 },
	{ 0x022A, 0x00 },
	{ 0x022B, 0x00 },
	{ 0x022C, 0x00 },
	{ 0x022D, 0x00 },
	{ 0x022E, 0x00 },
	{ 0x022F, 0x00 },
	{ 0x0231, 0x0B },
	{ 0x0232, 0x0B },
	{ 0x0233, 0x0B },
	{ 0x0234, 0x0B },
	{ 0x0235, 0x00 },
	{ 0x0236, 0x00 },
	{ 0x0237, 0x00 },
	{ 0x0238, 0x78 },
	{ 0x0239, 0xD5 },
	{ 0x023A, 0x00 },
	{ 0x023B, 0x00 },
	{ 0x023C, 0x00 },
	{ 0x023D, 0x00 },
	{ 0x023E, 0xD0 },
	{ 0x024A, 0x0A },
	{ 0x024B, 0x00 },
	{ 0x024C, 0x00 },
	{ 0x024D, 0x00 },
	{ 0x024E, 0x00 },
	{ 0x024F, 0x00 },
	{ 0x0250, 0x01 },
	{ 0x0251, 0x00 },
	{ 0x0252, 0x00 },
	{ 0x0253, 0x00 },
	{ 0x0254, 0x00 },
	{ 0x0255, 0x00 },
	{ 0x0256, 0x00 },
	{ 0x0257, 0x00 },
	{ 0x0258, 0x00 },
	{ 0x0259, 0x02 },
	{ 0x025A, 0x00 },
	{ 0x025B, 0x00 },
	{ 0x025C, 0x00 },
	{ 0x025D, 0x00 },
	{ 0x025E, 0x00 },
	{ 0x025F, 0x00 },
	{ 0x0260, 0x00 },
	{ 0x0261, 0x00 },
	{ 0x0262, 0x02 },
	{ 0x0263, 0x00 },
	{ 0x0264, 0x00 },
	{ 0x0268, 0x00 },
	{ 0x0269, 0x00 },
	{ 0x026A, 0x00 },
	{ 0x026B, 0x49 },
	{ 0x026C, 0x4F },
	{ 0x026D, 0x34 },
	{ 0x026E, 0x4B },
	{ 0x026F, 0x2B },
	{ 0x0270, 0x00 },
	{ 0x0271, 0x00 },
	{ 0x0272, 0x00 },
	{ 0x0294, 0x80 },
	{ 0x0296, 0x00 },
	{ 0x0297, 0x02 },
	{ 0x0299, 0x02 },
	{ 0x029D, 0xF5 },
	{ 0x029E, 0x0E },
	{ 0x029F, 0x00 },
	{ 0x02A9, 0x66 },
	{ 0x02AA, 0x26 },
	{ 0x02AB, 0x00 },
	{ 0x02B7, 0xFF },
	{ 0x0302, 0x00 },
	{ 0x0303, 0x00 },
	{ 0x0304, 0x00 },
	{ 0x0305, 0x80 },
	{ 0x0306, 0x0B },
	{ 0x0307, 0x00 },
	{ 0x0308, 0x00 },
	{ 0x0309, 0x00 },
	{ 0x030A, 0x00 },
	{ 0x030B, 0x80 },
	{ 0x030C, 0x00 },
	{ 0x030D, 0x00 },
	{ 0x030E, 0x00 },
	{ 0x030F, 0x60 },
	{ 0x0310, 0x53 },
	{ 0x0311, 0x2E },
	{ 0x0312, 0x00 },
	{ 0x0313, 0x00 },
	{ 0x0314, 0x00 },
	{ 0x0315, 0x00 },
	{ 0x0316, 0x80 },
	{ 0x0317, 0x00 },
	{ 0x0318, 0x00 },
	{ 0x0319, 0x00 },
	{ 0x031A, 0xE0 },
	{ 0x031B, 0x3D },
	{ 0x031C, 0x0B },
	{ 0x031D, 0x00 },
	{ 0x031E, 0x00 },
	{ 0x031F, 0x00 },
	{ 0x0320, 0x80 },
	{ 0x0321, 0xBB },
	{ 0x0322, 0x00 },
	{ 0x0323, 0x00 },
	{ 0x0324, 0x00 },
	{ 0x0325, 0x00 },
	{ 0x0326, 0x00 },
	{ 0x0327, 0x00 },
	{ 0x0328, 0x00 },
	{ 0x0329, 0x00 },
	{ 0x032A, 0x00 },
	{ 0x032B, 0x00 },
	{ 0x032C, 0x00 },
	{ 0x032D, 0x00 },
	{ 0x032E, 0x00 },
	{ 0x032F, 0x00 },
	{ 0x0330, 0x00 },
	{ 0x0331, 0x00 },
	{ 0x0332, 0x00 },
	{ 0x0333, 0x00 },
	{ 0x0334, 0x00 },
	{ 0x0335, 0x00 },
	{ 0x0336, 0x00 },
	{ 0x0337, 0x00 },
	{ 0x0338, 0x00 },
	{ 0x0339, 0x1F },
	{ 0x033B, 0x00 },
	{ 0x033C, 0x00 },
	{ 0x033D, 0x00 },
	{ 0x033E, 0x00 },
	{ 0x033F, 0x00 },
	{ 0x0340, 0x00 },
	{ 0x0341, 0x00 },
	{ 0x0342, 0x00 },
	{ 0x0343, 0x00 },
	{ 0x0344, 0x00 },
	{ 0x0345, 0x00 },
	{ 0x0346, 0x00 },
	{ 0x0347, 0x00 },
	{ 0x0348, 0x00 },
	{ 0x0349, 0x00 },
	{ 0x034A, 0x00 },
	{ 0x034B, 0x00 },
	{ 0x034C, 0x00 },
	{ 0x034D, 0x00 },
	{ 0x034E, 0x00 },
	{ 0x034F, 0x00 },
	{ 0x0350, 0x00 },
	{ 0x0351, 0x00 },
	{ 0x0352, 0x00 },
	{ 0x0353, 0x00 },
	{ 0x0354, 0x00 },
	{ 0x0355, 0x00 },
	{ 0x0356, 0x00 },
	{ 0x0357, 0x00 },
	{ 0x0358, 0x00 },
	{ 0x0359, 0x00 },
	{ 0x035A, 0x00 },
	{ 0x035B, 0x00 },
	{ 0x035C, 0x00 },
	{ 0x035D, 0x00 },
	{ 0x035E, 0x00 },
	{ 0x035F, 0x00 },
	{ 0x0360, 0x00 },
	{ 0x0361, 0x00 },
	{ 0x0362, 0x00 },
	{ 0x0487, 0x00 },
	{ 0x0502, 0x01 },
	{ 0x0508, 0x10 },
	{ 0x0509, 0x18 },
	{ 0x050A, 0x0F },
	{ 0x050B, 0x0F },
	{ 0x050C, 0x01 },
	{ 0x050D, 0x07 },
	{ 0x050E, 0x17 },
	{ 0x050F, 0x28 },
	{ 0x0510, 0x0C },
	{ 0x0511, 0x0B },
	{ 0x0512, 0x01 },
	{ 0x0513, 0x07 },
	{ 0x0515, 0x00 },
	{ 0x0516, 0x00 },
	{ 0x0517, 0x00 },
	{ 0x0518, 0xA0 },
	{ 0x0519, 0xA8 },
	{ 0x051A, 0x7B },
	{ 0x051B, 0x00 },
	{ 0x051C, 0x00 },
	{ 0x051D, 0x00 },
	{ 0x051E, 0x00 },
	{ 0x051F, 0xA0 },
	{ 0x0521, 0x3B },
	{ 0x052A, 0x01 },
	{ 0x052B, 0x01 },
	{ 0x052C, 0x0F },
	{ 0x052D, 0x03 },
	{ 0x052E, 0x15 },
	{ 0x052F, 0x14 },
	{ 0x0531, 0x00 },
	{ 0x0532, 0xB0 },
	{ 0x0533, 0x78 },
	{ 0x0534, 0x00 },
	{ 0x0535, 0x00 },
	{ 0x0536, 0x00 },
	{ 0x0537, 0x00 },
	{ 0x0538, 0x00 },
	{ 0x0539, 0x00 },
	{ 0x053A, 0x02 },
	{ 0x053B, 0x03 },
	{ 0x053C, 0x00 },
	{ 0x053D, 0x13 },
	{ 0x053E, 0x06 },
	{ 0x0589, 0xF8 },
	{ 0x058A, 0x01 },
	{ 0x059B, 0xF8 },
	{ 0x059D, 0x17 },
	{ 0x059E, 0x28 },
	{ 0x059F, 0x0C },
	{ 0x05A0, 0x0B },
	{ 0x05A1, 0x01 },
	{ 0x05A2, 0x07 },
	{ 0x05A6, 0x00 },
	{ 0x0802, 0x35 },
	{ 0x0803, 0x05 },
	{ 0x0804, 0x00 },
	{ 0x0805, 0x00 },
	{ 0x0806, 0x00 },
	{ 0x0807, 0x00 },
	{ 0x0808, 0x00 },
	{ 0x0809, 0x00 },
	{ 0x080A, 0x00 },
	{ 0x080B, 0x00 },
	{ 0x080C, 0x00 },
	{ 0x080D, 0x00 },
	{ 0x080E, 0x00 },
	{ 0x080F, 0x00 },
	{ 0x0810, 0x00 },
	{ 0x0811, 0x00 },
	{ 0x0812, 0x00 },
	{ 0x0813, 0x00 },
	{ 0x0814, 0x00 },
	{ 0x0815, 0x00 },
	{ 0x0816, 0x00 },
	{ 0x0817, 0x00 },
	{ 0x0818, 0x00 },
	{ 0x0819, 0x00 },
	{ 0x081A, 0x00 },
	{ 0x081B, 0x00 },
	{ 0x081C, 0x00 },
	{ 0x081D, 0x00 },
	{ 0x081E, 0x00 },
	{ 0x081F, 0x00 },
	{ 0x0820, 0x00 },
	{ 0x0821, 0x00 },
	{ 0x0822, 0x00 },
	{ 0x0823, 0x00 },
	{ 0x0824, 0x00 },
	{ 0x0825, 0x00 },
	{ 0x0826, 0x00 },
	{ 0x0827, 0x00 },
	{ 0x0828, 0x00 },
	{ 0x0829, 0x00 },
	{ 0x082A, 0x00 },
	{ 0x082B, 0x00 },
	{ 0x082C, 0x00 },
	{ 0x082D, 0x00 },
	{ 0x082E, 0x00 },
	{ 0x082F, 0x00 },
	{ 0x0830, 0x00 },
	{ 0x0831, 0x00 },
	{ 0x0832, 0x00 },
	{ 0x0833, 0x00 },
	{ 0x0834, 0x00 },
	{ 0x0835, 0x00 },
	{ 0x0836, 0x00 },
	{ 0x0837, 0x00 },
	{ 0x0838, 0x00 },
	{ 0x0839, 0x00 },
	{ 0x083A, 0x00 },
	{ 0x083B, 0x00 },
	{ 0x083C, 0x00 },
	{ 0x083D, 0x00 },
	{ 0x083E, 0x00 },
	{ 0x083F, 0x00 },
	{ 0x0840, 0x00 },
	{ 0x0841, 0x00 },
	{ 0x0842, 0x00 },
	{ 0x0843, 0x00 },
	{ 0x0844, 0x00 },
	{ 0x0845, 0x00 },
	{ 0x0846, 0x00 },
	{ 0x0847, 0x00 },
	{ 0x0848, 0x00 },
	{ 0x0849, 0x00 },
	{ 0x084A, 0x00 },
	{ 0x084B, 0x00 },
	{ 0x084C, 0x00 },
	{ 0x084D, 0x00 },
	{ 0x084E, 0x00 },
	{ 0x084F, 0x00 },
	{ 0x0850, 0x00 },
	{ 0x0851, 0x00 },
	{ 0x0852, 0x00 },
	{ 0x0853, 0x00 },
	{ 0x0854, 0x00 },
	{ 0x0855, 0x00 },
	{ 0x0856, 0x00 },
	{ 0x0857, 0x00 },
	{ 0x0858, 0x00 },
	{ 0x0859, 0x00 },
	{ 0x085A, 0x00 },
	{ 0x085B, 0x00 },
	{ 0x085C, 0x00 },
	{ 0x085D, 0x00 },
	{ 0x085E, 0x00 },
	{ 0x085F, 0x00 },
	{ 0x0860, 0x00 },
	{ 0x0861, 0x00 },
	{ 0x090E, 0x03 },
	{ 0x0943, 0x00 },
	{ 0x0949, 0x31 },
	{ 0x094A, 0x01 },
	{ 0x094E, 0x49 },
	{ 0x094F, 0x02 },
	{ 0x095E, 0x00 },
	{ 0x0A02, 0x00 },
	{ 0x0A03, 0x07 },
	{ 0x0A04, 0x01 },
	{ 0x0A05, 0x07 },
	{ 0x0A14, 0x00 },
	{ 0x0A1A, 0x00 },
	{ 0x0A20, 0x00 },
	{ 0x0A26, 0x00 },
	{ 0x0A2C, 0x00 },
	{ 0x0B44, 0x0F },
	{ 0x0B46, 0x00 },
	{ 0x0B47, 0x0E },
	{ 0x0B48, 0x0E },
	{ 0x0B4A, 0x18 },
	{ 0x0B57, 0xF9 },
	{ 0x0B58, 0x00 },
	/* End configuration registers */

	/* Start configuration postamble */
	{ 0x0514, 0x01 },
	{ 0x001C, 0x01 },
	{ 0x0540, 0x00 },
	{ 0x0B24, 0xC3 },
	{ 0x0B25, 0x02 },
	/* End configuration postamble */

	{ 0x0000, 0x00 }
};

/*
 * Design Report
 *
 * Overview
 * ========
 * Part:         Si5345 Rev D
 * Project File: C:\XilinxProjects\flint_tr051017\genlock\FormatFiles\IO4K+_1125_5994.slabtimeproj
 * Design ID:    IO4K+
 * Created By:   ClockBuilder Pro v2.16.1 [2017-07-19]
 * Timestamp:    2017-08-24 16:42:45 GMT-07:00
 * 
 * Design Notes
 * ============
 * assumes NTSC HSYNC (pulsed) input = (30/1.001)*525
 * 
 * Design Rule Check
 * =================
 * Errors:
 * - No errors
 * 
 * Warnings:
 * - Pulsed LVCMOS input buffer mode has been selected. This mode has non-standard input voltage logic thresholds: 0.33 V for Vil (max) and 0.49 V for Vih (min). Select this mode only if your input clock has a duty cycle significantly less or more than 50%.  Refer to the device datasheet for the exact threshold voltage specifications and the input attenuator circuit (DC coupled Pulsed LVCMOS) in the Family Reference Manual.
 * 
 * Device Grade
 * ============
 * Maximum Output Frequency: 148.5 MHz
 * Frequency Synthesis Mode: Fractional
 * Minimum Base OPN:         Si5345B
 * Actual Base OPN:          Si5345B
 * 
 * Base       Output Clock         Supported Frequency Synthesis Modes
 * OPN Grade  Frequency Range      (Typical Jitter)
 * ---------  -------------------  --------------------------------------------
 * Si5345A    100 Hz to 1.028 GHz  Integer (< 100 fs) and fractional (< 150 fs)
 * Si5345B    100 Hz to 350 MHz    "
 * Si5345C    100 Hz to 1.028 GHz  Integer only (< 100 fs)
 * Si5345D    100 Hz to 350 MHz    "
 * 
 * Design
 * ======
 * Host Interface:
 *    I/O Power Supply: VDD (Core)
 *    SPI Mode: 4-Wire
 *    I2C Address Range: 100d to 103d / 0x64 to 0x67 (selected via A0/A1 pins)
 * 
 * XA/XB:
 *    52 MHz (XO - External Oscillator)
 * 
 * Inputs:
 *     IN0: 53.9460539460539460... kHz [ 53 + 947/1001 kHz ]
 *          [ (48000/1001)*1125 ]
 *          Pulsed LVCMOS
 *     IN1: Unused
 *     IN2: Unused
 *     IN3: Unused
 * 
 * Outputs:
 *    OUT0: 27 MHz
 *          Enabled, LVDS 2.5 V
 *    OUT1: Unused
 *    OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT3: Unused
 *    OUT4: Unused
 *    OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT6: Unused
 *    OUT7: Unused
 *    OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *          [ 148.5/1.001 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT9: Unused
 * 
 * Frequency Plan
 * ==============
 * Priority: maximize the number of low jitter outputs
 * 
 * Fvco = 13.662 GHz [ 13 + 331/500 GHz ]
 * Fpfd = 53.9460539460539460... kHz [ 53 + 947/1001 kHz ]
 * Fms0 = 594 MHz
 * Fms1 = 147.456 MHz [ 147 + 57/125 MHz ]
 * Fms2 = 890.1098901098901098... MHz [ 890 + 10/91 MHz ]
 * 
 * P dividers:
 *    P0  = 1
 *    P1  = Unused
 *    P2  = Unused
 *    P3  = Unused
 *    Pxaxb = 1
 * 
 * MXAXB = 262.7307692307692307... [ 262 + 19/26 ]
 * M = 50650.6 [ 50650 + 3/5 ]
 * N dividers:
 *    N0:
 *       Value: 23
 *       Skew:  0.000 s
 *       OUT0: 27 MHz
 *       OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *    N1:
 *       Value: 92.6513671875 [ 92 + 667/1024 ]
 *       Skew:  0.000 s
 *       OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *    N2:
 *       Value: 15.3486666666666666... [ 15 + 523/1500 ]
 *       Skew:  0.000 s
 *       OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *    N3:
 *       Unused
 *    N4:
 *       Unused
 * 
 * R dividers:
 *    R0 = 22
 *    R1 = Unused
 *    R2 = 4
 *    R3 = Unused
 *    R4 = Unused
 *    R5 = 6
 *    R6 = Unused
 *    R7 = Unused
 *    R8 = 6
 *    R9 = Unused
 * 
 * Nominal Bandwidth:
 *   Desired: 1.000 Hz
 *   Actual:  518.917 mHz
 *   Coefficients:
 *      BW0:  16
 *      BW1:  24
 *      BW2:  15
 *      BW3:  15
 *      BW4:  1
 *      BW5:  7
 * Fastlock Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  80.752 Hz
 *   Coefficients:
 *      BW0:  23
 *      BW1:  40
 *      BW2:  12
 *      BW3:  11
 *      BW4:  1
 *      BW5:  7
 * Holdover Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  80.752 Hz
 *   Coefficients:
 *      BW0:  23
 *      BW1:  40
 *      BW2:  12
 *      BW3:  11
 *      BW4:  1
 *      BW5:  7
 * 
 * Dividers listed above show effective values. These values are translated to register settings by ClockBuilder Pro. For the actual register values, see below. Refer to the Family Reference Manual for information on registers related to frequency plan.
 * 
 * Digitally Controlled Oscillator (DCO)
 * =====================================
 * Mode: Register Direct Write
 * 
 * N0: DCO Disabled
 * 
 * N1: DCO Disabled
 * 
 * N2: DCO Disabled
 * 
 * N3: DCO Disabled
 * 
 * N4: DCO Disabled
 * 
 * Estimated Power & Junction Temperature
 * ======================================
 * Assumptions:
 * 
 * Revision: D
 * VDD:      1.8 V
 * Ta:       70 C
 * Airflow:  None
 * 
 * Total Power: 808 mW, On Chip Power: 784 mW, Tj: 87 C
 * 
 *                 Frequency  Format   Voltage   Current     Power
 *         -----------------  ------  --------  --------  --------
 * VDD                                   1.8 V  147.9 mA    266 mW
 * VDDA                                  3.3 V  117.4 mA    387 mW
 * VDDO0              27 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO1              Unused                                      
 * VDDO2           148.5 MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO3              Unused                                      
 * VDDO4              Unused                                      
 * VDDO5          24.576 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO6              Unused                                      
 * VDDO7              Unused                                      
 * VDDO8   148.351648... MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO9              Unused                                      
 *                                              --------  --------
 *                                       Total  327.2 mA    808 mW
 * 
 * Note:
 * 
 * -Total power includes on- and off-chip power. This is a typical value and estimate only.
 * -Use an EVB for a more exact power measurement
 * -On-chip power excludes power dissipated in external terminations.
 * -Tj is junction temperature. Tj must be less than 125 C (on Si5345 Revision D) for device to comply with datasheet specifications.
 * 
 * Settings
 * ========
 * 
 * Location      Setting Name           Decimal Value      Hex Value        
 * ------------  ---------------------  -----------------  -----------------
 * 0x000B[6:0]   I2C_ADDR               100                0x64             
 * 0x0016[1]     LOL_ON_HOLD            1                  0x1              
 * 0x0017[0]     SYSINCAL_INTR_MSK      0                  0x0              
 * 0x0017[1]     LOSXAXB_INTR_MSK       0                  0x0              
 * 0x0017[5]     SMB_TMOUT_INTR_MSK     1                  0x1              
 * 0x0018[3:0]   LOS_INTR_MSK           15                 0xF              
 * 0x0018[7:4]   OOF_INTR_MSK           15                 0xF              
 * 0x0019[1]     LOL_INTR_MSK           1                  0x1              
 * 0x0019[5]     HOLD_INTR_MSK          0                  0x0              
 * 0x001A[5]     CAL_INTR_MSK           0                  0x0              
 * 0x002B[3]     SPI_3WIRE              0                  0x0              
 * 0x002B[5]     AUTO_NDIV_UPDATE       0                  0x0              
 * 0x002C[3:0]   LOS_EN                 1                  0x1              
 * 0x002C[4]     LOSXAXB_DIS            0                  0x0              
 * 0x002D[1:0]   LOS0_VAL_TIME          2                  0x2              
 * 0x002D[3:2]   LOS1_VAL_TIME          0                  0x0              
 * 0x002D[5:4]   LOS2_VAL_TIME          0                  0x0              
 * 0x002D[7:6]   LOS3_VAL_TIME          0                  0x0              
 * 0x002E[15:0]  LOS0_TRG_THR           1216               0x04C0           
 * 0x0030[15:0]  LOS1_TRG_THR           0                  0x0000           
 * 0x0032[15:0]  LOS2_TRG_THR           0                  0x0000           
 * 0x0034[15:0]  LOS3_TRG_THR           0                  0x0000           
 * 0x0036[15:0]  LOS0_CLR_THR           1115               0x045B           
 * 0x0038[15:0]  LOS1_CLR_THR           0                  0x0000           
 * 0x003A[15:0]  LOS2_CLR_THR           0                  0x0000           
 * 0x003C[15:0]  LOS3_CLR_THR           0                  0x0000           
 * 0x003F[3:0]   OOF_EN                 1                  0x1              
 * 0x003F[7:4]   FAST_OOF_EN            0                  0x0              
 * 0x0040[2:0]   OOF_REF_SEL            4                  0x4              
 * 0x0041[4:0]   OOF0_DIV_SEL           2                  0x02             
 * 0x0042[4:0]   OOF1_DIV_SEL           0                  0x00             
 * 0x0043[4:0]   OOF2_DIV_SEL           0                  0x00             
 * 0x0044[4:0]   OOF3_DIV_SEL           0                  0x00             
 * 0x0045[4:0]   OOFXO_DIV_SEL          12                 0x0C             
 * 0x0046[7:0]   OOF0_SET_THR           150                0x96             
 * 0x0047[7:0]   OOF1_SET_THR           0                  0x00             
 * 0x0048[7:0]   OOF2_SET_THR           0                  0x00             
 * 0x0049[7:0]   OOF3_SET_THR           0                  0x00             
 * 0x004A[7:0]   OOF0_CLR_THR           75                 0x4B             
 * 0x004B[7:0]   OOF1_CLR_THR           0                  0x00             
 * 0x004C[7:0]   OOF2_CLR_THR           0                  0x00             
 * 0x004D[7:0]   OOF3_CLR_THR           0                  0x00             
 * 0x004E[2:0]   OOF0_DETWIN_SEL        5                  0x5              
 * 0x004E[6:4]   OOF1_DETWIN_SEL        0                  0x0              
 * 0x004F[2:0]   OOF2_DETWIN_SEL        0                  0x0              
 * 0x004F[6:4]   OOF3_DETWIN_SEL        0                  0x0              
 * 0x0050[3:0]   OOF_ON_LOS             15                 0xF              
 * 0x0051[3:0]   FAST_OOF0_SET_THR      0                  0x0              
 * 0x0052[3:0]   FAST_OOF1_SET_THR      0                  0x0              
 * 0x0053[3:0]   FAST_OOF2_SET_THR      0                  0x0              
 * 0x0054[3:0]   FAST_OOF3_SET_THR      0                  0x0              
 * 0x0055[3:0]   FAST_OOF0_CLR_THR      0                  0x0              
 * 0x0056[3:0]   FAST_OOF1_CLR_THR      0                  0x0              
 * 0x0057[3:0]   FAST_OOF2_CLR_THR      0                  0x0              
 * 0x0058[3:0]   FAST_OOF3_CLR_THR      0                  0x0              
 * 0x0059[1:0]   FAST_OOF0_DETWIN_SEL   1                  0x1              
 * 0x0059[3:2]   FAST_OOF1_DETWIN_SEL   0                  0x0              
 * 0x0059[5:4]   FAST_OOF2_DETWIN_SEL   0                  0x0              
 * 0x0059[7:6]   FAST_OOF3_DETWIN_SEL   0                  0x0              
 * 0x005A[25:0]  OOF0_RATIO_REF         17822810           0x10FF45A        
 * 0x005E[25:0]  OOF1_RATIO_REF         0                  0x0000000        
 * 0x0062[25:0]  OOF2_RATIO_REF         0                  0x0000000        
 * 0x0066[25:0]  OOF3_RATIO_REF         0                  0x0000000        
 * 0x0092[1]     LOL_FST_EN             1                  0x1              
 * 0x0093[7:4]   LOL_FST_DETWIN_SEL     10                 0xA              
 * 0x0095[3:2]   LOL_FST_VALWIN_SEL     0                  0x0              
 * 0x0096[7:4]   LOL_FST_SET_THR_SEL    9                  0x9              
 * 0x0098[7:4]   LOL_FST_CLR_THR_SEL    7                  0x7              
 * 0x009A[1]     LOL_SLOW_EN_PLL        1                  0x1              
 * 0x009B[7:4]   LOL_SLW_DETWIN_SEL     5                  0x5              
 * 0x009D[3:2]   LOL_SLW_VALWIN_SEL     1                  0x1              
 * 0x009E[7:4]   LOL_SLW_SET_THR        6                  0x6              
 * 0x00A0[7:4]   LOL_SLW_CLR_THR        3                  0x3              
 * 0x00A2[1]     LOL_TIMER_EN           0                  0x0              
 * 0x00A9[28:0]  LOL_CLR_DELAY_DIV256   307635             0x0004B1B3       
 * 0x00E5[5]     FASTLOCK_EXTEND_EN     1                  0x1              
 * 0x00EA[28:0]  FASTLOCK_EXTEND        242129             0x0003B1D1       
 * 0x0102[0]     OUTALL_DISABLE_LOW     1                  0x1              
 * 0x0108[0]     OUT0_PDN               0                  0x0              
 * 0x0108[1]     OUT0_OE                1                  0x1              
 * 0x0108[2]     OUT0_RDIV_FORCE2       0                  0x0              
 * 0x0109[2:0]   OUT0_FORMAT            1                  0x1              
 * 0x0109[3]     OUT0_SYNC_EN           1                  0x1              
 * 0x0109[5:4]   OUT0_DIS_STATE         0                  0x0              
 * 0x0109[7:6]   OUT0_CMOS_DRV          0                  0x0              
 * 0x010A[3:0]   OUT0_CM                11                 0xB              
 * 0x010A[6:4]   OUT0_AMPL              3                  0x3              
 * 0x010B[2:0]   OUT0_MUX_SEL           0                  0x0              
 * 0x010B[5:4]   OUT0_VDD_SEL           2                  0x2              
 * 0x010B[3]     OUT0_VDD_SEL_EN        1                  0x1              
 * 0x010B[7:6]   OUT0_INV               0                  0x0              
 * 0x010D[0]     OUT1_PDN               1                  0x1              
 * 0x010D[1]     OUT1_OE                0                  0x0              
 * 0x010D[2]     OUT1_RDIV_FORCE2       0                  0x0              
 * 0x010E[2:0]   OUT1_FORMAT            1                  0x1              
 * 0x010E[3]     OUT1_SYNC_EN           1                  0x1              
 * 0x010E[5:4]   OUT1_DIS_STATE         0                  0x0              
 * 0x010E[7:6]   OUT1_CMOS_DRV          0                  0x0              
 * 0x010F[3:0]   OUT1_CM                11                 0xB              
 * 0x010F[6:4]   OUT1_AMPL              3                  0x3              
 * 0x0110[2:0]   OUT1_MUX_SEL           0                  0x0              
 * 0x0110[5:4]   OUT1_VDD_SEL           2                  0x2              
 * 0x0110[3]     OUT1_VDD_SEL_EN        1                  0x1              
 * 0x0110[7:6]   OUT1_INV               0                  0x0              
 * 0x0112[0]     OUT2_PDN               0                  0x0              
 * 0x0112[1]     OUT2_OE                1                  0x1              
 * 0x0112[2]     OUT2_RDIV_FORCE2       0                  0x0              
 * 0x0113[2:0]   OUT2_FORMAT            1                  0x1              
 * 0x0113[3]     OUT2_SYNC_EN           1                  0x1              
 * 0x0113[5:4]   OUT2_DIS_STATE         0                  0x0              
 * 0x0113[7:6]   OUT2_CMOS_DRV          0                  0x0              
 * 0x0114[3:0]   OUT2_CM                11                 0xB              
 * 0x0114[6:4]   OUT2_AMPL              3                  0x3              
 * 0x0115[2:0]   OUT2_MUX_SEL           0                  0x0              
 * 0x0115[5:4]   OUT2_VDD_SEL           2                  0x2              
 * 0x0115[3]     OUT2_VDD_SEL_EN        1                  0x1              
 * 0x0115[7:6]   OUT2_INV               0                  0x0              
 * 0x0117[0]     OUT3_PDN               1                  0x1              
 * 0x0117[1]     OUT3_OE                0                  0x0              
 * 0x0117[2]     OUT3_RDIV_FORCE2       0                  0x0              
 * 0x0118[2:0]   OUT3_FORMAT            1                  0x1              
 * 0x0118[3]     OUT3_SYNC_EN           1                  0x1              
 * 0x0118[5:4]   OUT3_DIS_STATE         0                  0x0              
 * 0x0118[7:6]   OUT3_CMOS_DRV          0                  0x0              
 * 0x0119[3:0]   OUT3_CM                11                 0xB              
 * 0x0119[6:4]   OUT3_AMPL              3                  0x3              
 * 0x011A[2:0]   OUT3_MUX_SEL           0                  0x0              
 * 0x011A[5:4]   OUT3_VDD_SEL           2                  0x2              
 * 0x011A[3]     OUT3_VDD_SEL_EN        1                  0x1              
 * 0x011A[7:6]   OUT3_INV               0                  0x0              
 * 0x011C[0]     OUT4_PDN               1                  0x1              
 * 0x011C[1]     OUT4_OE                0                  0x0              
 * 0x011C[2]     OUT4_RDIV_FORCE2       0                  0x0              
 * 0x011D[2:0]   OUT4_FORMAT            1                  0x1              
 * 0x011D[3]     OUT4_SYNC_EN           1                  0x1              
 * 0x011D[5:4]   OUT4_DIS_STATE         0                  0x0              
 * 0x011D[7:6]   OUT4_CMOS_DRV          0                  0x0              
 * 0x011E[3:0]   OUT4_CM                11                 0xB              
 * 0x011E[6:4]   OUT4_AMPL              3                  0x3              
 * 0x011F[2:0]   OUT4_MUX_SEL           0                  0x0              
 * 0x011F[5:4]   OUT4_VDD_SEL           2                  0x2              
 * 0x011F[3]     OUT4_VDD_SEL_EN        1                  0x1              
 * 0x011F[7:6]   OUT4_INV               0                  0x0              
 * 0x0121[0]     OUT5_PDN               0                  0x0              
 * 0x0121[1]     OUT5_OE                1                  0x1              
 * 0x0121[2]     OUT5_RDIV_FORCE2       0                  0x0              
 * 0x0122[2:0]   OUT5_FORMAT            1                  0x1              
 * 0x0122[3]     OUT5_SYNC_EN           1                  0x1              
 * 0x0122[5:4]   OUT5_DIS_STATE         0                  0x0              
 * 0x0122[7:6]   OUT5_CMOS_DRV          0                  0x0              
 * 0x0123[3:0]   OUT5_CM                11                 0xB              
 * 0x0123[6:4]   OUT5_AMPL              3                  0x3              
 * 0x0124[2:0]   OUT5_MUX_SEL           1                  0x1              
 * 0x0124[5:4]   OUT5_VDD_SEL           2                  0x2              
 * 0x0124[3]     OUT5_VDD_SEL_EN        1                  0x1              
 * 0x0124[7:6]   OUT5_INV               0                  0x0              
 * 0x0126[0]     OUT6_PDN               1                  0x1              
 * 0x0126[1]     OUT6_OE                0                  0x0              
 * 0x0126[2]     OUT6_RDIV_FORCE2       0                  0x0              
 * 0x0127[2:0]   OUT6_FORMAT            1                  0x1              
 * 0x0127[3]     OUT6_SYNC_EN           1                  0x1              
 * 0x0127[5:4]   OUT6_DIS_STATE         0                  0x0              
 * 0x0127[7:6]   OUT6_CMOS_DRV          0                  0x0              
 * 0x0128[3:0]   OUT6_CM                11                 0xB              
 * 0x0128[6:4]   OUT6_AMPL              3                  0x3              
 * 0x0129[2:0]   OUT6_MUX_SEL           0                  0x0              
 * 0x0129[5:4]   OUT6_VDD_SEL           2                  0x2              
 * 0x0129[3]     OUT6_VDD_SEL_EN        1                  0x1              
 * 0x0129[7:6]   OUT6_INV               0                  0x0              
 * 0x012B[0]     OUT7_PDN               1                  0x1              
 * 0x012B[1]     OUT7_OE                0                  0x0              
 * 0x012B[2]     OUT7_RDIV_FORCE2       0                  0x0              
 * 0x012C[2:0]   OUT7_FORMAT            1                  0x1              
 * 0x012C[3]     OUT7_SYNC_EN           1                  0x1              
 * 0x012C[5:4]   OUT7_DIS_STATE         0                  0x0              
 * 0x012C[7:6]   OUT7_CMOS_DRV          0                  0x0              
 * 0x012D[3:0]   OUT7_CM                11                 0xB              
 * 0x012D[6:4]   OUT7_AMPL              3                  0x3              
 * 0x012E[2:0]   OUT7_MUX_SEL           0                  0x0              
 * 0x012E[5:4]   OUT7_VDD_SEL           2                  0x2              
 * 0x012E[3]     OUT7_VDD_SEL_EN        1                  0x1              
 * 0x012E[7:6]   OUT7_INV               0                  0x0              
 * 0x0130[0]     OUT8_PDN               0                  0x0              
 * 0x0130[1]     OUT8_OE                1                  0x1              
 * 0x0130[2]     OUT8_RDIV_FORCE2       0                  0x0              
 * 0x0131[2:0]   OUT8_FORMAT            1                  0x1              
 * 0x0131[3]     OUT8_SYNC_EN           1                  0x1              
 * 0x0131[5:4]   OUT8_DIS_STATE         0                  0x0              
 * 0x0131[7:6]   OUT8_CMOS_DRV          0                  0x0              
 * 0x0132[3:0]   OUT8_CM                11                 0xB              
 * 0x0132[6:4]   OUT8_AMPL              3                  0x3              
 * 0x0133[2:0]   OUT8_MUX_SEL           2                  0x2              
 * 0x0133[5:4]   OUT8_VDD_SEL           2                  0x2              
 * 0x0133[3]     OUT8_VDD_SEL_EN        1                  0x1              
 * 0x0133[7:6]   OUT8_INV               0                  0x0              
 * 0x013A[0]     OUT9_PDN               1                  0x1              
 * 0x013A[1]     OUT9_OE                0                  0x0              
 * 0x013A[2]     OUT9_RDIV_FORCE2       0                  0x0              
 * 0x013B[2:0]   OUT9_FORMAT            1                  0x1              
 * 0x013B[3]     OUT9_SYNC_EN           1                  0x1              
 * 0x013B[5:4]   OUT9_DIS_STATE         0                  0x0              
 * 0x013B[7:6]   OUT9_CMOS_DRV          0                  0x0              
 * 0x013C[3:0]   OUT9_CM                11                 0xB              
 * 0x013C[6:4]   OUT9_AMPL              3                  0x3              
 * 0x013D[2:0]   OUT9_MUX_SEL           0                  0x0              
 * 0x013D[5:4]   OUT9_VDD_SEL           2                  0x2              
 * 0x013D[3]     OUT9_VDD_SEL_EN        1                  0x1              
 * 0x013D[7:6]   OUT9_INV               0                  0x0              
 * 0x013F[11:0]  OUTX_ALWAYS_ON         0                  0x000            
 * 0x0141[1]     OUT_DIS_MSK            0                  0x0              
 * 0x0141[5]     OUT_DIS_LOL_MSK        0                  0x0              
 * 0x0141[6]     OUT_DIS_LOSXAXB_MSK    1                  0x1              
 * 0x0141[7]     OUT_DIS_MSK_LOS_PFD    0                  0x0              
 * 0x0142[1]     OUT_DIS_MSK_LOL        1                  0x1              
 * 0x0142[5]     OUT_DIS_MSK_HOLD       1                  0x1              
 * 0x0206[1:0]   PXAXB                  0                  0x0              
 * 0x0208[47:0]  P0_NUM                 1                  0x000000000001   
 * 0x020E[31:0]  P0_DEN                 1                  0x00000001       
 * 0x0212[47:0]  P1_NUM                 0                  0x000000000000   
 * 0x0218[31:0]  P1_DEN                 0                  0x00000000       
 * 0x021C[47:0]  P2_NUM                 0                  0x000000000000   
 * 0x0222[31:0]  P2_DEN                 0                  0x00000000       
 * 0x0226[47:0]  P3_NUM                 0                  0x000000000000   
 * 0x022C[31:0]  P3_DEN                 0                  0x00000000       
 * 0x0231[3:0]   P0_FRACN_MODE          11                 0xB              
 * 0x0231[4]     P0_FRACN_EN            0                  0x0              
 * 0x0232[3:0]   P1_FRACN_MODE          11                 0xB              
 * 0x0232[4]     P1_FRACN_EN            0                  0x0              
 * 0x0233[3:0]   P2_FRACN_MODE          11                 0xB              
 * 0x0233[4]     P2_FRACN_EN            0                  0x0              
 * 0x0234[3:0]   P3_FRACN_MODE          11                 0xB              
 * 0x0234[4]     P3_FRACN_EN            0                  0x0              
 * 0x0235[43:0]  MXAXB_NUM              916841299968       0x0D578000000    
 * 0x023B[31:0]  MXAXB_DEN              3489660928         0xD0000000       
 * 0x024A[23:0]  R0_REG                 10                 0x00000A         
 * 0x024D[23:0]  R1_REG                 0                  0x000000         
 * 0x0250[23:0]  R2_REG                 1                  0x000001         
 * 0x0253[23:0]  R3_REG                 0                  0x000000         
 * 0x0256[23:0]  R4_REG                 0                  0x000000         
 * 0x0259[23:0]  R5_REG                 2                  0x000002         
 * 0x025C[23:0]  R6_REG                 0                  0x000000         
 * 0x025F[23:0]  R7_REG                 0                  0x000000         
 * 0x0262[23:0]  R8_REG                 2                  0x000002         
 * 0x0268[23:0]  R9_REG                 0                  0x000000         
 * 0x026B[7:0]   DESIGN_ID0             73                 0x49             
 * 0x026C[7:0]   DESIGN_ID1             79                 0x4F             
 * 0x026D[7:0]   DESIGN_ID2             52                 0x34             
 * 0x026E[7:0]   DESIGN_ID3             75                 0x4B             
 * 0x026F[7:0]   DESIGN_ID4             43                 0x2B             
 * 0x0270[7:0]   DESIGN_ID5             0                  0x00             
 * 0x0271[7:0]   DESIGN_ID6             0                  0x00             
 * 0x0272[7:0]   DESIGN_ID7             0                  0x00             
 * 0x0294[7:4]   FASTLOCK_EXTEND_SCL    8                  0x8              
 * 0x0296[1]     LOL_SLW_VALWIN_SELX    0                  0x0              
 * 0x0297[1]     FASTLOCK_DLY_ONSW_EN   1                  0x1              
 * 0x0299[1]     FASTLOCK_DLY_ONLOL_EN  1                  0x1              
 * 0x029D[19:0]  FASTLOCK_DLY_ONLOL     3829               0x00EF5          
 * 0x02A9[19:0]  FASTLOCK_DLY_ONSW      9830               0x02666          
 * 0x02B7[3:2]   LOL_NOSIG_TIME         3                  0x3              
 * 0x0302[43:0]  N0_NUM                 49392123904        0x00B80000000    
 * 0x0308[31:0]  N0_DEN                 2147483648         0x80000000       
 * 0x030C[0]     N0_UPDATE              0                  0x0              
 * 0x030D[43:0]  N1_NUM                 198967296000       0x02E53600000    
 * 0x0313[31:0]  N1_DEN                 2147483648         0x80000000       
 * 0x0317[0]     N1_UPDATE              0                  0x0              
 * 0x0318[43:0]  N2_NUM                 48282730496        0x00B3DE00000    
 * 0x031E[31:0]  N2_DEN                 3145728000         0xBB800000       
 * 0x0322[0]     N2_UPDATE              0                  0x0              
 * 0x0323[43:0]  N3_NUM                 0                  0x00000000000    
 * 0x0329[31:0]  N3_DEN                 0                  0x00000000       
 * 0x032D[0]     N3_UPDATE              0                  0x0              
 * 0x032E[43:0]  N4_NUM                 0                  0x00000000000    
 * 0x0334[31:0]  N4_DEN                 0                  0x00000000       
 * 0x0338[0]     N4_UPDATE              0                  0x0              
 * 0x0338[1]     N_UPDATE               0                  0x0              
 * 0x0339[4:0]   N_FSTEP_MSK            31                 0x1F             
 * 0x033B[43:0]  N0_FSTEPW              0                  0x00000000000    
 * 0x0341[43:0]  N1_FSTEPW              0                  0x00000000000    
 * 0x0347[43:0]  N2_FSTEPW              0                  0x00000000000    
 * 0x034D[43:0]  N3_FSTEPW              0                  0x00000000000    
 * 0x0353[43:0]  N4_FSTEPW              0                  0x00000000000    
 * 0x0359[15:0]  N0_DELAY               0                  0x0000           
 * 0x035B[15:0]  N1_DELAY               0                  0x0000           
 * 0x035D[15:0]  N2_DELAY               0                  0x0000           
 * 0x035F[15:0]  N3_DELAY               0                  0x0000           
 * 0x0361[15:0]  N4_DELAY               0                  0x0000           
 * 0x0487[0]     ZDM_EN                 0                  0x0              
 * 0x0487[2:1]   ZDM_IN_SEL             0                  0x0              
 * 0x0487[4]     ZDM_AUTOSW_EN          0                  0x0              
 * 0x0502[4]     ADD_DIV256             0                  0x0              
 * 0x0508[5:0]   BW0_PLL                16                 0x10             
 * 0x0509[5:0]   BW1_PLL                24                 0x18             
 * 0x050A[5:0]   BW2_PLL                15                 0x0F             
 * 0x050B[5:0]   BW3_PLL                15                 0x0F             
 * 0x050C[5:0]   BW4_PLL                1                  0x01             
 * 0x050D[5:0]   BW5_PLL                7                  0x07             
 * 0x050E[5:0]   FASTLOCK_BW0_PLL       23                 0x17             
 * 0x050F[5:0]   FASTLOCK_BW1_PLL       40                 0x28             
 * 0x0510[5:0]   FASTLOCK_BW2_PLL       12                 0x0C             
 * 0x0511[5:0]   FASTLOCK_BW3_PLL       11                 0x0B             
 * 0x0512[5:0]   FASTLOCK_BW4_PLL       1                  0x01             
 * 0x0513[5:0]   FASTLOCK_BW5_PLL       7                  0x07             
 * 0x0515[55:0]  M_NUM                  135964169076736    0x007BA8A0000000 
 * 0x051C[31:0]  M_DEN                  2684354560         0xA0000000       
 * 0x0521[3:0]   M_FRAC_MODE            11                 0xB              
 * 0x0521[4]     M_FRAC_EN              1                  0x1              
 * 0x0521[5]     PLL_OUT_RATE_SEL       1                  0x1              
 * 0x052A[0]     IN_SEL_REGCTRL         1                  0x1              
 * 0x052A[3:1]   IN_SEL                 0                  0x0              
 * 0x052B[0]     FASTLOCK_AUTO_EN       1                  0x1              
 * 0x052B[1]     FASTLOCK_MAN           0                  0x0              
 * 0x052C[0]     HOLD_EN                1                  0x1              
 * 0x052C[3]     HOLD_RAMP_BYP          1                  0x1              
 * 0x052C[4]     HOLDEXIT_BW_SEL1       0                  0x0              
 * 0x052C[7:5]   RAMP_STEP_INTERVAL     0                  0x0              
 * 0x052D[1]     HOLD_RAMPBYP_NOHIST    1                  0x1              
 * 0x052E[4:0]   HOLD_HIST_LEN          21                 0x15             
 * 0x052F[4:0]   HOLD_HIST_DELAY        20                 0x14             
 * 0x0531[4:0]   HOLD_REF_COUNT_FRC     0                  0x00             
 * 0x0532[23:0]  HOLD_15M_CYC_COUNT     30896              0x0078B0         
 * 0x0535[0]     FORCE_HOLD             0                  0x0              
 * 0x0536[1:0]   CLK_SWITCH_MODE        0                  0x0              
 * 0x0536[2]     HSW_EN                 0                  0x0              
 * 0x0537[3:0]   IN_LOS_MSK             0                  0x0              
 * 0x0537[7:4]   IN_OOF_MSK             0                  0x0              
 * 0x0538[2:0]   IN0_PRIORITY           0                  0x0              
 * 0x0538[6:4]   IN1_PRIORITY           0                  0x0              
 * 0x0539[2:0]   IN2_PRIORITY           0                  0x0              
 * 0x0539[6:4]   IN3_PRIORITY           0                  0x0              
 * 0x053A[1:0]   HSW_MODE               2                  0x2              
 * 0x053A[3:2]   HSW_PHMEAS_CTRL        0                  0x0              
 * 0x053B[9:0]   HSW_PHMEAS_THR         3                  0x003            
 * 0x053D[4:0]   HSW_COARSE_PM_LEN      19                 0x13             
 * 0x053E[4:0]   HSW_COARSE_PM_DLY      6                  0x06             
 * 0x0589[12:0]  CAP_SHORT_DELAY        504                0x01F8           
 * 0x059B[4]     HOLD_PRESERVE_HIST     1                  0x1              
 * 0x059B[5]     HOLD_FRZ_WITH_INTONLY  1                  0x1              
 * 0x059B[6]     HOLDEXIT_BW_SEL0       1                  0x1              
 * 0x059B[7]     HOLDEXIT_STD_BO        1                  0x1              
 * 0x059D[5:0]   HOLDEXIT_BW0           23                 0x17             
 * 0x059E[5:0]   HOLDEXIT_BW1           40                 0x28             
 * 0x059F[5:0]   HOLDEXIT_BW2           12                 0x0C             
 * 0x05A0[5:0]   HOLDEXIT_BW3           11                 0x0B             
 * 0x05A1[5:0]   HOLDEXIT_BW4           1                  0x01             
 * 0x05A2[5:0]   HOLDEXIT_BW5           7                  0x07             
 * 0x05A6[2:0]   RAMP_STEP_SIZE         0                  0x0              
 * 0x05A6[3]     RAMP_SWITCH_EN         0                  0x0              
 * 0x0802[15:0]  FIXREGSA0              1333               0x0535           
 * 0x0804[7:0]   FIXREGSD0              0                  0x00             
 * 0x0805[15:0]  FIXREGSA1              0                  0x0000           
 * 0x0807[7:0]   FIXREGSD1              0                  0x00             
 * 0x0808[15:0]  FIXREGSA2              0                  0x0000           
 * 0x080A[7:0]   FIXREGSD2              0                  0x00             
 * 0x080B[15:0]  FIXREGSA3              0                  0x0000           
 * 0x080D[7:0]   FIXREGSD3              0                  0x00             
 * 0x080E[15:0]  FIXREGSA4              0                  0x0000           
 * 0x0810[7:0]   FIXREGSD4              0                  0x00             
 * 0x0811[15:0]  FIXREGSA5              0                  0x0000           
 * 0x0813[7:0]   FIXREGSD5              0                  0x00             
 * 0x0814[15:0]  FIXREGSA6              0                  0x0000           
 * 0x0816[7:0]   FIXREGSD6              0                  0x00             
 * 0x0817[15:0]  FIXREGSA7              0                  0x0000           
 * 0x0819[7:0]   FIXREGSD7              0                  0x00             
 * 0x081A[15:0]  FIXREGSA8              0                  0x0000           
 * 0x081C[7:0]   FIXREGSD8              0                  0x00             
 * 0x081D[15:0]  FIXREGSA9              0                  0x0000           
 * 0x081F[7:0]   FIXREGSD9              0                  0x00             
 * 0x0820[15:0]  FIXREGSA10             0                  0x0000           
 * 0x0822[7:0]   FIXREGSD10             0                  0x00             
 * 0x0823[15:0]  FIXREGSA11             0                  0x0000           
 * 0x0825[7:0]   FIXREGSD11             0                  0x00             
 * 0x0826[15:0]  FIXREGSA12             0                  0x0000           
 * 0x0828[7:0]   FIXREGSD12             0                  0x00             
 * 0x0829[15:0]  FIXREGSA13             0                  0x0000           
 * 0x082B[7:0]   FIXREGSD13             0                  0x00             
 * 0x082C[15:0]  FIXREGSA14             0                  0x0000           
 * 0x082E[7:0]   FIXREGSD14             0                  0x00             
 * 0x082F[15:0]  FIXREGSA15             0                  0x0000           
 * 0x0831[7:0]   FIXREGSD15             0                  0x00             
 * 0x0832[15:0]  FIXREGSA16             0                  0x0000           
 * 0x0834[7:0]   FIXREGSD16             0                  0x00             
 * 0x0835[15:0]  FIXREGSA17             0                  0x0000           
 * 0x0837[7:0]   FIXREGSD17             0                  0x00             
 * 0x0838[15:0]  FIXREGSA18             0                  0x0000           
 * 0x083A[7:0]   FIXREGSD18             0                  0x00             
 * 0x083B[15:0]  FIXREGSA19             0                  0x0000           
 * 0x083D[7:0]   FIXREGSD19             0                  0x00             
 * 0x083E[15:0]  FIXREGSA20             0                  0x0000           
 * 0x0840[7:0]   FIXREGSD20             0                  0x00             
 * 0x0841[15:0]  FIXREGSA21             0                  0x0000           
 * 0x0843[7:0]   FIXREGSD21             0                  0x00             
 * 0x0844[15:0]  FIXREGSA22             0                  0x0000           
 * 0x0846[7:0]   FIXREGSD22             0                  0x00             
 * 0x0847[15:0]  FIXREGSA23             0                  0x0000           
 * 0x0849[7:0]   FIXREGSD23             0                  0x00             
 * 0x084A[15:0]  FIXREGSA24             0                  0x0000           
 * 0x084C[7:0]   FIXREGSD24             0                  0x00             
 * 0x084D[15:0]  FIXREGSA25             0                  0x0000           
 * 0x084F[7:0]   FIXREGSD25             0                  0x00             
 * 0x0850[15:0]  FIXREGSA26             0                  0x0000           
 * 0x0852[7:0]   FIXREGSD26             0                  0x00             
 * 0x0853[15:0]  FIXREGSA27             0                  0x0000           
 * 0x0855[7:0]   FIXREGSD27             0                  0x00             
 * 0x0856[15:0]  FIXREGSA28             0                  0x0000           
 * 0x0858[7:0]   FIXREGSD28             0                  0x00             
 * 0x0859[15:0]  FIXREGSA29             0                  0x0000           
 * 0x085B[7:0]   FIXREGSD29             0                  0x00             
 * 0x085C[15:0]  FIXREGSA30             0                  0x0000           
 * 0x085E[7:0]   FIXREGSD30             0                  0x00             
 * 0x085F[15:0]  FIXREGSA31             0                  0x0000           
 * 0x0861[7:0]   FIXREGSD31             0                  0x00             
 * 0x090E[0]     XAXB_EXTCLK_EN         1                  0x1              
 * 0x0943[0]     IO_VDD_SEL             0                  0x0              
 * 0x0949[3:0]   IN_EN                  1                  0x1              
 * 0x0949[7:4]   IN_PULSED_CMOS_EN      3                  0x3              
 * 0x094A[3:0]   INX_TO_PFD_EN          1                  0x1              
 * 0x094E[11:0]  REFCLK_HYS_SEL         585                0x249            
 * 0x095E[0]     MXAXB_INTEGER          0                  0x0              
 * 0x0A02[4:0]   N_ADD_0P5              0                  0x00             
 * 0x0A03[4:0]   N_CLK_TO_OUTX_EN       7                  0x07             
 * 0x0A04[4:0]   N_PIBYP                1                  0x01             
 * 0x0A05[4:0]   N_PDNB                 7                  0x07             
 * 0x0A14[3]     N0_HIGH_FREQ           0                  0x0              
 * 0x0A1A[3]     N1_HIGH_FREQ           0                  0x0              
 * 0x0A20[3]     N2_HIGH_FREQ           0                  0x0              
 * 0x0A26[3]     N3_HIGH_FREQ           0                  0x0              
 * 0x0A2C[3]     N4_HIGH_FREQ           0                  0x0              
 * 0x0B44[3:0]   PDIV_FRACN_CLK_DIS     15                 0xF              
 * 0x0B44[5]     FRACN_CLK_DIS_PLL      0                  0x0              
 * 0x0B46[3:0]   LOS_CLK_DIS            0                  0x0              
 * 0x0B47[4:0]   OOF_CLK_DIS            14                 0x0E             
 * 0x0B48[4:0]   OOF_DIV_CLK_DIS        14                 0x0E             
 * 0x0B4A[4:0]   N_CLK_DIS              24                 0x18             
 * 0x0B57[11:0]  VCO_RESET_CALCODE      249                0x0F9
 * 
 *
 */


static struct ntv2_genlock_data s_genlock_1125_4800[] =
{
	/* Start configuration preamble */
	{ 0x0B24, 0xC0 },
	{ 0x0B25, 0x00 },
	{ 0x0540, 0x01 },
	/* End configuration preamble */

	/* Delay 300 msec */
	/*    Delay is worst case time for device to complete any calibration */
	/*    that is running due to device state change previous to this script */
	/*    being processed. */
	{ 0x0000, 0x01 },

	/* Start configuration registers */
	{ 0x000B, 0x64 },
	{ 0x0016, 0x02 },
	{ 0x0017, 0xFC },
	{ 0x0018, 0xFF },
	{ 0x0019, 0xDF },
	{ 0x001A, 0xDF },
	{ 0x002B, 0x02 },
	{ 0x002C, 0x01 },
	{ 0x002D, 0x02 },
	{ 0x002E, 0xBF },
	{ 0x002F, 0x04 },
	{ 0x0030, 0x00 },
	{ 0x0031, 0x00 },
	{ 0x0032, 0x00 },
	{ 0x0033, 0x00 },
	{ 0x0034, 0x00 },
	{ 0x0035, 0x00 },
	{ 0x0036, 0x5A },
	{ 0x0037, 0x04 },
	{ 0x0038, 0x00 },
	{ 0x0039, 0x00 },
	{ 0x003A, 0x00 },
	{ 0x003B, 0x00 },
	{ 0x003C, 0x00 },
	{ 0x003D, 0x00 },
	{ 0x003F, 0x01 },
	{ 0x0040, 0x04 },
	{ 0x0041, 0x02 },
	{ 0x0042, 0x00 },
	{ 0x0043, 0x00 },
	{ 0x0044, 0x00 },
	{ 0x0045, 0x0C },
	{ 0x0046, 0x96 },
	{ 0x0047, 0x00 },
	{ 0x0048, 0x00 },
	{ 0x0049, 0x00 },
	{ 0x004A, 0x4B },
	{ 0x004B, 0x00 },
	{ 0x004C, 0x00 },
	{ 0x004D, 0x00 },
	{ 0x004E, 0x05 },
	{ 0x004F, 0x00 },
	{ 0x0050, 0x0F },
	{ 0x0051, 0x00 },
	{ 0x0052, 0x00 },
	{ 0x0053, 0x00 },
	{ 0x0054, 0x00 },
	{ 0x0055, 0x00 },
	{ 0x0056, 0x00 },
	{ 0x0057, 0x00 },
	{ 0x0058, 0x00 },
	{ 0x0059, 0x01 },
	{ 0x005A, 0xF9 },
	{ 0x005B, 0x39 },
	{ 0x005C, 0x10 },
	{ 0x005D, 0x01 },
	{ 0x005E, 0x00 },
	{ 0x005F, 0x00 },
	{ 0x0060, 0x00 },
	{ 0x0061, 0x00 },
	{ 0x0062, 0x00 },
	{ 0x0063, 0x00 },
	{ 0x0064, 0x00 },
	{ 0x0065, 0x00 },
	{ 0x0066, 0x00 },
	{ 0x0067, 0x00 },
	{ 0x0068, 0x00 },
	{ 0x0069, 0x00 },
	{ 0x0092, 0x02 },
	{ 0x0093, 0xA0 },
	{ 0x0095, 0x00 },
	{ 0x0096, 0x90 },
	{ 0x0098, 0x70 },
	{ 0x009A, 0x02 },
	{ 0x009B, 0x50 },
	{ 0x009D, 0x04 },
	{ 0x009E, 0x60 },
	{ 0x00A0, 0x30 },
	{ 0x00A2, 0x00 },
	{ 0x00A9, 0x70 },
	{ 0x00AA, 0xB1 },
	{ 0x00AB, 0x04 },
	{ 0x00AC, 0x00 },
	{ 0x00E5, 0x21 },
	{ 0x00EA, 0xD1 },
	{ 0x00EB, 0xB1 },
	{ 0x00EC, 0x03 },
	{ 0x00ED, 0x00 },
	{ 0x0102, 0x01 },
	{ 0x0108, 0x02 },
	{ 0x0109, 0x09 },
	{ 0x010A, 0x3B },
	{ 0x010B, 0x28 },
	{ 0x010D, 0x01 },
	{ 0x010E, 0x09 },
	{ 0x010F, 0x3B },
	{ 0x0110, 0x28 },
	{ 0x0112, 0x02 },
	{ 0x0113, 0x09 },
	{ 0x0114, 0x3B },
	{ 0x0115, 0x28 },
	{ 0x0117, 0x01 },
	{ 0x0118, 0x09 },
	{ 0x0119, 0x3B },
	{ 0x011A, 0x28 },
	{ 0x011C, 0x01 },
	{ 0x011D, 0x09 },
	{ 0x011E, 0x3B },
	{ 0x011F, 0x28 },
	{ 0x0121, 0x02 },
	{ 0x0122, 0x09 },
	{ 0x0123, 0x3B },
	{ 0x0124, 0x29 },
	{ 0x0126, 0x01 },
	{ 0x0127, 0x09 },
	{ 0x0128, 0x3B },
	{ 0x0129, 0x28 },
	{ 0x012B, 0x01 },
	{ 0x012C, 0x09 },
	{ 0x012D, 0x3B },
	{ 0x012E, 0x28 },
	{ 0x0130, 0x02 },
	{ 0x0131, 0x09 },
	{ 0x0132, 0x3B },
	{ 0x0133, 0x2A },
	{ 0x013A, 0x01 },
	{ 0x013B, 0x09 },
	{ 0x013C, 0x3B },
	{ 0x013D, 0x28 },
	{ 0x013F, 0x00 },
	{ 0x0140, 0x00 },
	{ 0x0141, 0x40 },
	{ 0x0142, 0xFF },
	{ 0x0206, 0x00 },
	{ 0x0208, 0x01 },
	{ 0x0209, 0x00 },
	{ 0x020A, 0x00 },
	{ 0x020B, 0x00 },
	{ 0x020C, 0x00 },
	{ 0x020D, 0x00 },
	{ 0x020E, 0x01 },
	{ 0x020F, 0x00 },
	{ 0x0210, 0x00 },
	{ 0x0211, 0x00 },
	{ 0x0212, 0x00 },
	{ 0x0213, 0x00 },
	{ 0x0214, 0x00 },
	{ 0x0215, 0x00 },
	{ 0x0216, 0x00 },
	{ 0x0217, 0x00 },
	{ 0x0218, 0x00 },
	{ 0x0219, 0x00 },
	{ 0x021A, 0x00 },
	{ 0x021B, 0x00 },
	{ 0x021C, 0x00 },
	{ 0x021D, 0x00 },
	{ 0x021E, 0x00 },
	{ 0x021F, 0x00 },
	{ 0x0220, 0x00 },
	{ 0x0221, 0x00 },
	{ 0x0222, 0x00 },
	{ 0x0223, 0x00 },
	{ 0x0224, 0x00 },
	{ 0x0225, 0x00 },
	{ 0x0226, 0x00 },
	{ 0x0227, 0x00 },
	{ 0x0228, 0x00 },
	{ 0x0229, 0x00 },
	{ 0x022A, 0x00 },
	{ 0x022B, 0x00 },
	{ 0x022C, 0x00 },
	{ 0x022D, 0x00 },
	{ 0x022E, 0x00 },
	{ 0x022F, 0x00 },
	{ 0x0231, 0x0B },
	{ 0x0232, 0x0B },
	{ 0x0233, 0x0B },
	{ 0x0234, 0x0B },
	{ 0x0235, 0x00 },
	{ 0x0236, 0x00 },
	{ 0x0237, 0x00 },
	{ 0x0238, 0x78 },
	{ 0x0239, 0xD5 },
	{ 0x023A, 0x00 },
	{ 0x023B, 0x00 },
	{ 0x023C, 0x00 },
	{ 0x023D, 0x00 },
	{ 0x023E, 0xD0 },
	{ 0x024A, 0x0A },
	{ 0x024B, 0x00 },
	{ 0x024C, 0x00 },
	{ 0x024D, 0x00 },
	{ 0x024E, 0x00 },
	{ 0x024F, 0x00 },
	{ 0x0250, 0x01 },
	{ 0x0251, 0x00 },
	{ 0x0252, 0x00 },
	{ 0x0253, 0x00 },
	{ 0x0254, 0x00 },
	{ 0x0255, 0x00 },
	{ 0x0256, 0x00 },
	{ 0x0257, 0x00 },
	{ 0x0258, 0x00 },
	{ 0x0259, 0x02 },
	{ 0x025A, 0x00 },
	{ 0x025B, 0x00 },
	{ 0x025C, 0x00 },
	{ 0x025D, 0x00 },
	{ 0x025E, 0x00 },
	{ 0x025F, 0x00 },
	{ 0x0260, 0x00 },
	{ 0x0261, 0x00 },
	{ 0x0262, 0x02 },
	{ 0x0263, 0x00 },
	{ 0x0264, 0x00 },
	{ 0x0268, 0x00 },
	{ 0x0269, 0x00 },
	{ 0x026A, 0x00 },
	{ 0x026B, 0x49 },
	{ 0x026C, 0x4F },
	{ 0x026D, 0x34 },
	{ 0x026E, 0x4B },
	{ 0x026F, 0x2B },
	{ 0x0270, 0x00 },
	{ 0x0271, 0x00 },
	{ 0x0272, 0x00 },
	{ 0x0294, 0x80 },
	{ 0x0296, 0x00 },
	{ 0x0297, 0x02 },
	{ 0x0299, 0x02 },
	{ 0x029D, 0xF5 },
	{ 0x029E, 0x0E },
	{ 0x029F, 0x00 },
	{ 0x02A9, 0x66 },
	{ 0x02AA, 0x26 },
	{ 0x02AB, 0x00 },
	{ 0x02B7, 0xFF },
	{ 0x0302, 0x00 },
	{ 0x0303, 0x00 },
	{ 0x0304, 0x00 },
	{ 0x0305, 0x80 },
	{ 0x0306, 0x0B },
	{ 0x0307, 0x00 },
	{ 0x0308, 0x00 },
	{ 0x0309, 0x00 },
	{ 0x030A, 0x00 },
	{ 0x030B, 0x80 },
	{ 0x030C, 0x00 },
	{ 0x030D, 0x00 },
	{ 0x030E, 0x00 },
	{ 0x030F, 0x60 },
	{ 0x0310, 0x53 },
	{ 0x0311, 0x2E },
	{ 0x0312, 0x00 },
	{ 0x0313, 0x00 },
	{ 0x0314, 0x00 },
	{ 0x0315, 0x00 },
	{ 0x0316, 0x80 },
	{ 0x0317, 0x00 },
	{ 0x0318, 0x00 },
	{ 0x0319, 0x00 },
	{ 0x031A, 0xE0 },
	{ 0x031B, 0x3D },
	{ 0x031C, 0x0B },
	{ 0x031D, 0x00 },
	{ 0x031E, 0x00 },
	{ 0x031F, 0x00 },
	{ 0x0320, 0x80 },
	{ 0x0321, 0xBB },
	{ 0x0322, 0x00 },
	{ 0x0323, 0x00 },
	{ 0x0324, 0x00 },
	{ 0x0325, 0x00 },
	{ 0x0326, 0x00 },
	{ 0x0327, 0x00 },
	{ 0x0328, 0x00 },
	{ 0x0329, 0x00 },
	{ 0x032A, 0x00 },
	{ 0x032B, 0x00 },
	{ 0x032C, 0x00 },
	{ 0x032D, 0x00 },
	{ 0x032E, 0x00 },
	{ 0x032F, 0x00 },
	{ 0x0330, 0x00 },
	{ 0x0331, 0x00 },
	{ 0x0332, 0x00 },
	{ 0x0333, 0x00 },
	{ 0x0334, 0x00 },
	{ 0x0335, 0x00 },
	{ 0x0336, 0x00 },
	{ 0x0337, 0x00 },
	{ 0x0338, 0x00 },
	{ 0x0339, 0x1F },
	{ 0x033B, 0x00 },
	{ 0x033C, 0x00 },
	{ 0x033D, 0x00 },
	{ 0x033E, 0x00 },
	{ 0x033F, 0x00 },
	{ 0x0340, 0x00 },
	{ 0x0341, 0x00 },
	{ 0x0342, 0x00 },
	{ 0x0343, 0x00 },
	{ 0x0344, 0x00 },
	{ 0x0345, 0x00 },
	{ 0x0346, 0x00 },
	{ 0x0347, 0x00 },
	{ 0x0348, 0x00 },
	{ 0x0349, 0x00 },
	{ 0x034A, 0x00 },
	{ 0x034B, 0x00 },
	{ 0x034C, 0x00 },
	{ 0x034D, 0x00 },
	{ 0x034E, 0x00 },
	{ 0x034F, 0x00 },
	{ 0x0350, 0x00 },
	{ 0x0351, 0x00 },
	{ 0x0352, 0x00 },
	{ 0x0353, 0x00 },
	{ 0x0354, 0x00 },
	{ 0x0355, 0x00 },
	{ 0x0356, 0x00 },
	{ 0x0357, 0x00 },
	{ 0x0358, 0x00 },
	{ 0x0359, 0x00 },
	{ 0x035A, 0x00 },
	{ 0x035B, 0x00 },
	{ 0x035C, 0x00 },
	{ 0x035D, 0x00 },
	{ 0x035E, 0x00 },
	{ 0x035F, 0x00 },
	{ 0x0360, 0x00 },
	{ 0x0361, 0x00 },
	{ 0x0362, 0x00 },
	{ 0x0487, 0x00 },
	{ 0x0502, 0x01 },
	{ 0x0508, 0x10 },
	{ 0x0509, 0x18 },
	{ 0x050A, 0x0F },
	{ 0x050B, 0x0F },
	{ 0x050C, 0x01 },
	{ 0x050D, 0x07 },
	{ 0x050E, 0x17 },
	{ 0x050F, 0x28 },
	{ 0x0510, 0x0C },
	{ 0x0511, 0x0B },
	{ 0x0512, 0x01 },
	{ 0x0513, 0x07 },
	{ 0x0515, 0x00 },
	{ 0x0516, 0x00 },
	{ 0x0517, 0x00 },
	{ 0x0518, 0x00 },
	{ 0x0519, 0xD4 },
	{ 0x051A, 0x62 },
	{ 0x051B, 0x00 },
	{ 0x051C, 0x00 },
	{ 0x051D, 0x00 },
	{ 0x051E, 0x00 },
	{ 0x051F, 0x80 },
	{ 0x0521, 0x2B },
	{ 0x052A, 0x01 },
	{ 0x052B, 0x01 },
	{ 0x052C, 0x0F },
	{ 0x052D, 0x03 },
	{ 0x052E, 0x15 },
	{ 0x052F, 0x14 },
	{ 0x0531, 0x00 },
	{ 0x0532, 0x91 },
	{ 0x0533, 0x78 },
	{ 0x0534, 0x00 },
	{ 0x0535, 0x00 },
	{ 0x0536, 0x00 },
	{ 0x0537, 0x00 },
	{ 0x0538, 0x00 },
	{ 0x0539, 0x00 },
	{ 0x053A, 0x02 },
	{ 0x053B, 0x03 },
	{ 0x053C, 0x00 },
	{ 0x053D, 0x13 },
	{ 0x053E, 0x06 },
	{ 0x0589, 0xF7 },
	{ 0x058A, 0x01 },
	{ 0x059B, 0xF8 },
	{ 0x059D, 0x17 },
	{ 0x059E, 0x28 },
	{ 0x059F, 0x0C },
	{ 0x05A0, 0x0B },
	{ 0x05A1, 0x01 },
	{ 0x05A2, 0x07 },
	{ 0x05A6, 0x00 },
	{ 0x0802, 0x35 },
	{ 0x0803, 0x05 },
	{ 0x0804, 0x00 },
	{ 0x0805, 0x00 },
	{ 0x0806, 0x00 },
	{ 0x0807, 0x00 },
	{ 0x0808, 0x00 },
	{ 0x0809, 0x00 },
	{ 0x080A, 0x00 },
	{ 0x080B, 0x00 },
	{ 0x080C, 0x00 },
	{ 0x080D, 0x00 },
	{ 0x080E, 0x00 },
	{ 0x080F, 0x00 },
	{ 0x0810, 0x00 },
	{ 0x0811, 0x00 },
	{ 0x0812, 0x00 },
	{ 0x0813, 0x00 },
	{ 0x0814, 0x00 },
	{ 0x0815, 0x00 },
	{ 0x0816, 0x00 },
	{ 0x0817, 0x00 },
	{ 0x0818, 0x00 },
	{ 0x0819, 0x00 },
	{ 0x081A, 0x00 },
	{ 0x081B, 0x00 },
	{ 0x081C, 0x00 },
	{ 0x081D, 0x00 },
	{ 0x081E, 0x00 },
	{ 0x081F, 0x00 },
	{ 0x0820, 0x00 },
	{ 0x0821, 0x00 },
	{ 0x0822, 0x00 },
	{ 0x0823, 0x00 },
	{ 0x0824, 0x00 },
	{ 0x0825, 0x00 },
	{ 0x0826, 0x00 },
	{ 0x0827, 0x00 },
	{ 0x0828, 0x00 },
	{ 0x0829, 0x00 },
	{ 0x082A, 0x00 },
	{ 0x082B, 0x00 },
	{ 0x082C, 0x00 },
	{ 0x082D, 0x00 },
	{ 0x082E, 0x00 },
	{ 0x082F, 0x00 },
	{ 0x0830, 0x00 },
	{ 0x0831, 0x00 },
	{ 0x0832, 0x00 },
	{ 0x0833, 0x00 },
	{ 0x0834, 0x00 },
	{ 0x0835, 0x00 },
	{ 0x0836, 0x00 },
	{ 0x0837, 0x00 },
	{ 0x0838, 0x00 },
	{ 0x0839, 0x00 },
	{ 0x083A, 0x00 },
	{ 0x083B, 0x00 },
	{ 0x083C, 0x00 },
	{ 0x083D, 0x00 },
	{ 0x083E, 0x00 },
	{ 0x083F, 0x00 },
	{ 0x0840, 0x00 },
	{ 0x0841, 0x00 },
	{ 0x0842, 0x00 },
	{ 0x0843, 0x00 },
	{ 0x0844, 0x00 },
	{ 0x0845, 0x00 },
	{ 0x0846, 0x00 },
	{ 0x0847, 0x00 },
	{ 0x0848, 0x00 },
	{ 0x0849, 0x00 },
	{ 0x084A, 0x00 },
	{ 0x084B, 0x00 },
	{ 0x084C, 0x00 },
	{ 0x084D, 0x00 },
	{ 0x084E, 0x00 },
	{ 0x084F, 0x00 },
	{ 0x0850, 0x00 },
	{ 0x0851, 0x00 },
	{ 0x0852, 0x00 },
	{ 0x0853, 0x00 },
	{ 0x0854, 0x00 },
	{ 0x0855, 0x00 },
	{ 0x0856, 0x00 },
	{ 0x0857, 0x00 },
	{ 0x0858, 0x00 },
	{ 0x0859, 0x00 },
	{ 0x085A, 0x00 },
	{ 0x085B, 0x00 },
	{ 0x085C, 0x00 },
	{ 0x085D, 0x00 },
	{ 0x085E, 0x00 },
	{ 0x085F, 0x00 },
	{ 0x0860, 0x00 },
	{ 0x0861, 0x00 },
	{ 0x090E, 0x03 },
	{ 0x0943, 0x00 },
	{ 0x0949, 0x31 },
	{ 0x094A, 0x01 },
	{ 0x094E, 0x49 },
	{ 0x094F, 0x02 },
	{ 0x095E, 0x00 },
	{ 0x0A02, 0x00 },
	{ 0x0A03, 0x07 },
	{ 0x0A04, 0x01 },
	{ 0x0A05, 0x07 },
	{ 0x0A14, 0x00 },
	{ 0x0A1A, 0x00 },
	{ 0x0A20, 0x00 },
	{ 0x0A26, 0x00 },
	{ 0x0A2C, 0x00 },
	{ 0x0B44, 0x2F },
	{ 0x0B46, 0x00 },
	{ 0x0B47, 0x0E },
	{ 0x0B48, 0x0E },
	{ 0x0B4A, 0x18 },
	{ 0x0B57, 0xF9 },
	{ 0x0B58, 0x00 },
	/* End configuration registers */

	/* Start configuration postamble */
	{ 0x0514, 0x01 },
	{ 0x001C, 0x01 },
	{ 0x0540, 0x00 },
	{ 0x0B24, 0xC3 },
	{ 0x0B25, 0x02 },
	/* End configuration postamble */

	{ 0x0000, 0x00 }
};

/*
 * Design Report
 *
 * Overview
 * ========
 * Part:         Si5345 Rev D
 * Project File: C:\XilinxProjects\flint_tr051017\genlock\FormatFiles\IO4K+_1125_5994.slabtimeproj
 * Design ID:    IO4K+
 * Created By:   ClockBuilder Pro v2.16.1 [2017-07-19]
 * Timestamp:    2017-08-24 16:41:23 GMT-07:00
 * 
 * Design Notes
 * ============
 * assumes NTSC HSYNC (pulsed) input = (30/1.001)*525
 * 
 * Design Rule Check
 * =================
 * Errors:
 * - No errors
 * 
 * Warnings:
 * - Pulsed LVCMOS input buffer mode has been selected. This mode has non-standard input voltage logic thresholds: 0.33 V for Vil (max) and 0.49 V for Vih (min). Select this mode only if your input clock has a duty cycle significantly less or more than 50%.  Refer to the device datasheet for the exact threshold voltage specifications and the input attenuator circuit (DC coupled Pulsed LVCMOS) in the Family Reference Manual.
 * 
 * Device Grade
 * ============
 * Maximum Output Frequency: 148.5 MHz
 * Frequency Synthesis Mode: Fractional
 * Minimum Base OPN:         Si5345B
 * Actual Base OPN:          Si5345B
 * 
 * Base       Output Clock         Supported Frequency Synthesis Modes
 * OPN Grade  Frequency Range      (Typical Jitter)
 * ---------  -------------------  --------------------------------------------
 * Si5345A    100 Hz to 1.028 GHz  Integer (< 100 fs) and fractional (< 150 fs)
 * Si5345B    100 Hz to 350 MHz    "
 * Si5345C    100 Hz to 1.028 GHz  Integer only (< 100 fs)
 * Si5345D    100 Hz to 350 MHz    "
 * 
 * Design
 * ======
 * Host Interface:
 *    I/O Power Supply: VDD (Core)
 *    SPI Mode: 4-Wire
 *    I2C Address Range: 100d to 103d / 0x64 to 0x67 (selected via A0/A1 pins)
 * 
 * XA/XB:
 *    52 MHz (XO - External Oscillator)
 * 
 * Inputs:
 *     IN0: 54 kHz
 *          [ (48)*1125 ]
 *          Pulsed LVCMOS
 *     IN1: Unused
 *     IN2: Unused
 *     IN3: Unused
 * 
 * Outputs:
 *    OUT0: 27 MHz
 *          Enabled, LVDS 2.5 V
 *    OUT1: Unused
 *    OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT3: Unused
 *    OUT4: Unused
 *    OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT6: Unused
 *    OUT7: Unused
 *    OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *          [ 148.5/1.001 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT9: Unused
 * 
 * Frequency Plan
 * ==============
 * Priority: maximize the number of low jitter outputs
 * 
 * Fvco = 13.662 GHz [ 13 + 331/500 GHz ]
 * Fpfd = 54 kHz
 * Fms0 = 594 MHz
 * Fms1 = 147.456 MHz [ 147 + 57/125 MHz ]
 * Fms2 = 890.1098901098901098... MHz [ 890 + 10/91 MHz ]
 * 
 * P dividers:
 *    P0  = 1
 *    P1  = Unused
 *    P2  = Unused
 *    P3  = Unused
 *    Pxaxb = 1
 * 
 * MXAXB = 262.7307692307692307... [ 262 + 19/26 ]
 * M = 50600
 * N dividers:
 *    N0:
 *       Value: 23
 *       Skew:  0.000 s
 *       OUT0: 27 MHz
 *       OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *    N1:
 *       Value: 92.6513671875 [ 92 + 667/1024 ]
 *       Skew:  0.000 s
 *       OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *    N2:
 *       Value: 15.3486666666666666... [ 15 + 523/1500 ]
 *       Skew:  0.000 s
 *       OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *    N3:
 *       Unused
 *    N4:
 *       Unused
 * 
 * R dividers:
 *    R0 = 22
 *    R1 = Unused
 *    R2 = 4
 *    R3 = Unused
 *    R4 = Unused
 *    R5 = 6
 *    R6 = Unused
 *    R7 = Unused
 *    R8 = 6
 *    R9 = Unused
 * 
 * Nominal Bandwidth:
 *   Desired: 1.000 Hz
 *   Actual:  519.444 mHz
 *   Coefficients:
 *      BW0:  16
 *      BW1:  24
 *      BW2:  15
 *      BW3:  15
 *      BW4:  1
 *      BW5:  7
 * Fastlock Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  80.852 Hz
 *   Coefficients:
 *      BW0:  23
 *      BW1:  40
 *      BW2:  12
 *      BW3:  11
 *      BW4:  1
 *      BW5:  7
 * Holdover Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  80.852 Hz
 *   Coefficients:
 *      BW0:  23
 *      BW1:  40
 *      BW2:  12
 *      BW3:  11
 *      BW4:  1
 *      BW5:  7
 * 
 * Dividers listed above show effective values. These values are translated to register settings by ClockBuilder Pro. For the actual register values, see below. Refer to the Family Reference Manual for information on registers related to frequency plan.
 * 
 * Digitally Controlled Oscillator (DCO)
 * =====================================
 * Mode: Register Direct Write
 * 
 * N0: DCO Disabled
 * 
 * N1: DCO Disabled
 * 
 * N2: DCO Disabled
 * 
 * N3: DCO Disabled
 * 
 * N4: DCO Disabled
 * 
 * Estimated Power & Junction Temperature
 * ======================================
 * Assumptions:
 * 
 * Revision: D
 * VDD:      1.8 V
 * Ta:       70 C
 * Airflow:  None
 * 
 * Total Power: 808 mW, On Chip Power: 784 mW, Tj: 87 C
 * 
 *                 Frequency  Format   Voltage   Current     Power
 *         -----------------  ------  --------  --------  --------
 * VDD                                   1.8 V  147.9 mA    266 mW
 * VDDA                                  3.3 V  117.4 mA    387 mW
 * VDDO0              27 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO1              Unused                                      
 * VDDO2           148.5 MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO3              Unused                                      
 * VDDO4              Unused                                      
 * VDDO5          24.576 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO6              Unused                                      
 * VDDO7              Unused                                      
 * VDDO8   148.351648... MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO9              Unused                                      
 *                                              --------  --------
 *                                       Total  327.2 mA    808 mW
 * 
 * Note:
 * 
 * -Total power includes on- and off-chip power. This is a typical value and estimate only.
 * -Use an EVB for a more exact power measurement
 * -On-chip power excludes power dissipated in external terminations.
 * -Tj is junction temperature. Tj must be less than 125 C (on Si5345 Revision D) for device to comply with datasheet specifications.
 * 
 * Settings
 * ========
 * 
 * Location      Setting Name           Decimal Value      Hex Value        
 * ------------  ---------------------  -----------------  -----------------
 * 0x000B[6:0]   I2C_ADDR               100                0x64             
 * 0x0016[1]     LOL_ON_HOLD            1                  0x1              
 * 0x0017[0]     SYSINCAL_INTR_MSK      0                  0x0              
 * 0x0017[1]     LOSXAXB_INTR_MSK       0                  0x0              
 * 0x0017[5]     SMB_TMOUT_INTR_MSK     1                  0x1              
 * 0x0018[3:0]   LOS_INTR_MSK           15                 0xF              
 * 0x0018[7:4]   OOF_INTR_MSK           15                 0xF              
 * 0x0019[1]     LOL_INTR_MSK           1                  0x1              
 * 0x0019[5]     HOLD_INTR_MSK          0                  0x0              
 * 0x001A[5]     CAL_INTR_MSK           0                  0x0              
 * 0x002B[3]     SPI_3WIRE              0                  0x0              
 * 0x002B[5]     AUTO_NDIV_UPDATE       0                  0x0              
 * 0x002C[3:0]   LOS_EN                 1                  0x1              
 * 0x002C[4]     LOSXAXB_DIS            0                  0x0              
 * 0x002D[1:0]   LOS0_VAL_TIME          2                  0x2              
 * 0x002D[3:2]   LOS1_VAL_TIME          0                  0x0              
 * 0x002D[5:4]   LOS2_VAL_TIME          0                  0x0              
 * 0x002D[7:6]   LOS3_VAL_TIME          0                  0x0              
 * 0x002E[15:0]  LOS0_TRG_THR           1215               0x04BF           
 * 0x0030[15:0]  LOS1_TRG_THR           0                  0x0000           
 * 0x0032[15:0]  LOS2_TRG_THR           0                  0x0000           
 * 0x0034[15:0]  LOS3_TRG_THR           0                  0x0000           
 * 0x0036[15:0]  LOS0_CLR_THR           1114               0x045A           
 * 0x0038[15:0]  LOS1_CLR_THR           0                  0x0000           
 * 0x003A[15:0]  LOS2_CLR_THR           0                  0x0000           
 * 0x003C[15:0]  LOS3_CLR_THR           0                  0x0000           
 * 0x003F[3:0]   OOF_EN                 1                  0x1              
 * 0x003F[7:4]   FAST_OOF_EN            0                  0x0              
 * 0x0040[2:0]   OOF_REF_SEL            4                  0x4              
 * 0x0041[4:0]   OOF0_DIV_SEL           2                  0x02             
 * 0x0042[4:0]   OOF1_DIV_SEL           0                  0x00             
 * 0x0043[4:0]   OOF2_DIV_SEL           0                  0x00             
 * 0x0044[4:0]   OOF3_DIV_SEL           0                  0x00             
 * 0x0045[4:0]   OOFXO_DIV_SEL          12                 0x0C             
 * 0x0046[7:0]   OOF0_SET_THR           150                0x96             
 * 0x0047[7:0]   OOF1_SET_THR           0                  0x00             
 * 0x0048[7:0]   OOF2_SET_THR           0                  0x00             
 * 0x0049[7:0]   OOF3_SET_THR           0                  0x00             
 * 0x004A[7:0]   OOF0_CLR_THR           75                 0x4B             
 * 0x004B[7:0]   OOF1_CLR_THR           0                  0x00             
 * 0x004C[7:0]   OOF2_CLR_THR           0                  0x00             
 * 0x004D[7:0]   OOF3_CLR_THR           0                  0x00             
 * 0x004E[2:0]   OOF0_DETWIN_SEL        5                  0x5              
 * 0x004E[6:4]   OOF1_DETWIN_SEL        0                  0x0              
 * 0x004F[2:0]   OOF2_DETWIN_SEL        0                  0x0              
 * 0x004F[6:4]   OOF3_DETWIN_SEL        0                  0x0              
 * 0x0050[3:0]   OOF_ON_LOS             15                 0xF              
 * 0x0051[3:0]   FAST_OOF0_SET_THR      0                  0x0              
 * 0x0052[3:0]   FAST_OOF1_SET_THR      0                  0x0              
 * 0x0053[3:0]   FAST_OOF2_SET_THR      0                  0x0              
 * 0x0054[3:0]   FAST_OOF3_SET_THR      0                  0x0              
 * 0x0055[3:0]   FAST_OOF0_CLR_THR      0                  0x0              
 * 0x0056[3:0]   FAST_OOF1_CLR_THR      0                  0x0              
 * 0x0057[3:0]   FAST_OOF2_CLR_THR      0                  0x0              
 * 0x0058[3:0]   FAST_OOF3_CLR_THR      0                  0x0              
 * 0x0059[1:0]   FAST_OOF0_DETWIN_SEL   1                  0x1              
 * 0x0059[3:2]   FAST_OOF1_DETWIN_SEL   0                  0x0              
 * 0x0059[5:4]   FAST_OOF2_DETWIN_SEL   0                  0x0              
 * 0x0059[7:6]   FAST_OOF3_DETWIN_SEL   0                  0x0              
 * 0x005A[25:0]  OOF0_RATIO_REF         17840633           0x11039F9        
 * 0x005E[25:0]  OOF1_RATIO_REF         0                  0x0000000        
 * 0x0062[25:0]  OOF2_RATIO_REF         0                  0x0000000        
 * 0x0066[25:0]  OOF3_RATIO_REF         0                  0x0000000        
 * 0x0092[1]     LOL_FST_EN             1                  0x1              
 * 0x0093[7:4]   LOL_FST_DETWIN_SEL     10                 0xA              
 * 0x0095[3:2]   LOL_FST_VALWIN_SEL     0                  0x0              
 * 0x0096[7:4]   LOL_FST_SET_THR_SEL    9                  0x9              
 * 0x0098[7:4]   LOL_FST_CLR_THR_SEL    7                  0x7              
 * 0x009A[1]     LOL_SLOW_EN_PLL        1                  0x1              
 * 0x009B[7:4]   LOL_SLW_DETWIN_SEL     5                  0x5              
 * 0x009D[3:2]   LOL_SLW_VALWIN_SEL     1                  0x1              
 * 0x009E[7:4]   LOL_SLW_SET_THR        6                  0x6              
 * 0x00A0[7:4]   LOL_SLW_CLR_THR        3                  0x3              
 * 0x00A2[1]     LOL_TIMER_EN           0                  0x0              
 * 0x00A9[28:0]  LOL_CLR_DELAY_DIV256   307568             0x0004B170       
 * 0x00E5[5]     FASTLOCK_EXTEND_EN     1                  0x1              
 * 0x00EA[28:0]  FASTLOCK_EXTEND        242129             0x0003B1D1       
 * 0x0102[0]     OUTALL_DISABLE_LOW     1                  0x1              
 * 0x0108[0]     OUT0_PDN               0                  0x0              
 * 0x0108[1]     OUT0_OE                1                  0x1              
 * 0x0108[2]     OUT0_RDIV_FORCE2       0                  0x0              
 * 0x0109[2:0]   OUT0_FORMAT            1                  0x1              
 * 0x0109[3]     OUT0_SYNC_EN           1                  0x1              
 * 0x0109[5:4]   OUT0_DIS_STATE         0                  0x0              
 * 0x0109[7:6]   OUT0_CMOS_DRV          0                  0x0              
 * 0x010A[3:0]   OUT0_CM                11                 0xB              
 * 0x010A[6:4]   OUT0_AMPL              3                  0x3              
 * 0x010B[2:0]   OUT0_MUX_SEL           0                  0x0              
 * 0x010B[5:4]   OUT0_VDD_SEL           2                  0x2              
 * 0x010B[3]     OUT0_VDD_SEL_EN        1                  0x1              
 * 0x010B[7:6]   OUT0_INV               0                  0x0              
 * 0x010D[0]     OUT1_PDN               1                  0x1              
 * 0x010D[1]     OUT1_OE                0                  0x0              
 * 0x010D[2]     OUT1_RDIV_FORCE2       0                  0x0              
 * 0x010E[2:0]   OUT1_FORMAT            1                  0x1              
 * 0x010E[3]     OUT1_SYNC_EN           1                  0x1              
 * 0x010E[5:4]   OUT1_DIS_STATE         0                  0x0              
 * 0x010E[7:6]   OUT1_CMOS_DRV          0                  0x0              
 * 0x010F[3:0]   OUT1_CM                11                 0xB              
 * 0x010F[6:4]   OUT1_AMPL              3                  0x3              
 * 0x0110[2:0]   OUT1_MUX_SEL           0                  0x0              
 * 0x0110[5:4]   OUT1_VDD_SEL           2                  0x2              
 * 0x0110[3]     OUT1_VDD_SEL_EN        1                  0x1              
 * 0x0110[7:6]   OUT1_INV               0                  0x0              
 * 0x0112[0]     OUT2_PDN               0                  0x0              
 * 0x0112[1]     OUT2_OE                1                  0x1              
 * 0x0112[2]     OUT2_RDIV_FORCE2       0                  0x0              
 * 0x0113[2:0]   OUT2_FORMAT            1                  0x1              
 * 0x0113[3]     OUT2_SYNC_EN           1                  0x1              
 * 0x0113[5:4]   OUT2_DIS_STATE         0                  0x0              
 * 0x0113[7:6]   OUT2_CMOS_DRV          0                  0x0              
 * 0x0114[3:0]   OUT2_CM                11                 0xB              
 * 0x0114[6:4]   OUT2_AMPL              3                  0x3              
 * 0x0115[2:0]   OUT2_MUX_SEL           0                  0x0              
 * 0x0115[5:4]   OUT2_VDD_SEL           2                  0x2              
 * 0x0115[3]     OUT2_VDD_SEL_EN        1                  0x1              
 * 0x0115[7:6]   OUT2_INV               0                  0x0              
 * 0x0117[0]     OUT3_PDN               1                  0x1              
 * 0x0117[1]     OUT3_OE                0                  0x0              
 * 0x0117[2]     OUT3_RDIV_FORCE2       0                  0x0              
 * 0x0118[2:0]   OUT3_FORMAT            1                  0x1              
 * 0x0118[3]     OUT3_SYNC_EN           1                  0x1              
 * 0x0118[5:4]   OUT3_DIS_STATE         0                  0x0              
 * 0x0118[7:6]   OUT3_CMOS_DRV          0                  0x0              
 * 0x0119[3:0]   OUT3_CM                11                 0xB              
 * 0x0119[6:4]   OUT3_AMPL              3                  0x3              
 * 0x011A[2:0]   OUT3_MUX_SEL           0                  0x0              
 * 0x011A[5:4]   OUT3_VDD_SEL           2                  0x2              
 * 0x011A[3]     OUT3_VDD_SEL_EN        1                  0x1              
 * 0x011A[7:6]   OUT3_INV               0                  0x0              
 * 0x011C[0]     OUT4_PDN               1                  0x1              
 * 0x011C[1]     OUT4_OE                0                  0x0              
 * 0x011C[2]     OUT4_RDIV_FORCE2       0                  0x0              
 * 0x011D[2:0]   OUT4_FORMAT            1                  0x1              
 * 0x011D[3]     OUT4_SYNC_EN           1                  0x1              
 * 0x011D[5:4]   OUT4_DIS_STATE         0                  0x0              
 * 0x011D[7:6]   OUT4_CMOS_DRV          0                  0x0              
 * 0x011E[3:0]   OUT4_CM                11                 0xB              
 * 0x011E[6:4]   OUT4_AMPL              3                  0x3              
 * 0x011F[2:0]   OUT4_MUX_SEL           0                  0x0              
 * 0x011F[5:4]   OUT4_VDD_SEL           2                  0x2              
 * 0x011F[3]     OUT4_VDD_SEL_EN        1                  0x1              
 * 0x011F[7:6]   OUT4_INV               0                  0x0              
 * 0x0121[0]     OUT5_PDN               0                  0x0              
 * 0x0121[1]     OUT5_OE                1                  0x1              
 * 0x0121[2]     OUT5_RDIV_FORCE2       0                  0x0              
 * 0x0122[2:0]   OUT5_FORMAT            1                  0x1              
 * 0x0122[3]     OUT5_SYNC_EN           1                  0x1              
 * 0x0122[5:4]   OUT5_DIS_STATE         0                  0x0              
 * 0x0122[7:6]   OUT5_CMOS_DRV          0                  0x0              
 * 0x0123[3:0]   OUT5_CM                11                 0xB              
 * 0x0123[6:4]   OUT5_AMPL              3                  0x3              
 * 0x0124[2:0]   OUT5_MUX_SEL           1                  0x1              
 * 0x0124[5:4]   OUT5_VDD_SEL           2                  0x2              
 * 0x0124[3]     OUT5_VDD_SEL_EN        1                  0x1              
 * 0x0124[7:6]   OUT5_INV               0                  0x0              
 * 0x0126[0]     OUT6_PDN               1                  0x1              
 * 0x0126[1]     OUT6_OE                0                  0x0              
 * 0x0126[2]     OUT6_RDIV_FORCE2       0                  0x0              
 * 0x0127[2:0]   OUT6_FORMAT            1                  0x1              
 * 0x0127[3]     OUT6_SYNC_EN           1                  0x1              
 * 0x0127[5:4]   OUT6_DIS_STATE         0                  0x0              
 * 0x0127[7:6]   OUT6_CMOS_DRV          0                  0x0              
 * 0x0128[3:0]   OUT6_CM                11                 0xB              
 * 0x0128[6:4]   OUT6_AMPL              3                  0x3              
 * 0x0129[2:0]   OUT6_MUX_SEL           0                  0x0              
 * 0x0129[5:4]   OUT6_VDD_SEL           2                  0x2              
 * 0x0129[3]     OUT6_VDD_SEL_EN        1                  0x1              
 * 0x0129[7:6]   OUT6_INV               0                  0x0              
 * 0x012B[0]     OUT7_PDN               1                  0x1              
 * 0x012B[1]     OUT7_OE                0                  0x0              
 * 0x012B[2]     OUT7_RDIV_FORCE2       0                  0x0              
 * 0x012C[2:0]   OUT7_FORMAT            1                  0x1              
 * 0x012C[3]     OUT7_SYNC_EN           1                  0x1              
 * 0x012C[5:4]   OUT7_DIS_STATE         0                  0x0              
 * 0x012C[7:6]   OUT7_CMOS_DRV          0                  0x0              
 * 0x012D[3:0]   OUT7_CM                11                 0xB              
 * 0x012D[6:4]   OUT7_AMPL              3                  0x3              
 * 0x012E[2:0]   OUT7_MUX_SEL           0                  0x0              
 * 0x012E[5:4]   OUT7_VDD_SEL           2                  0x2              
 * 0x012E[3]     OUT7_VDD_SEL_EN        1                  0x1              
 * 0x012E[7:6]   OUT7_INV               0                  0x0              
 * 0x0130[0]     OUT8_PDN               0                  0x0              
 * 0x0130[1]     OUT8_OE                1                  0x1              
 * 0x0130[2]     OUT8_RDIV_FORCE2       0                  0x0              
 * 0x0131[2:0]   OUT8_FORMAT            1                  0x1              
 * 0x0131[3]     OUT8_SYNC_EN           1                  0x1              
 * 0x0131[5:4]   OUT8_DIS_STATE         0                  0x0              
 * 0x0131[7:6]   OUT8_CMOS_DRV          0                  0x0              
 * 0x0132[3:0]   OUT8_CM                11                 0xB              
 * 0x0132[6:4]   OUT8_AMPL              3                  0x3              
 * 0x0133[2:0]   OUT8_MUX_SEL           2                  0x2              
 * 0x0133[5:4]   OUT8_VDD_SEL           2                  0x2              
 * 0x0133[3]     OUT8_VDD_SEL_EN        1                  0x1              
 * 0x0133[7:6]   OUT8_INV               0                  0x0              
 * 0x013A[0]     OUT9_PDN               1                  0x1              
 * 0x013A[1]     OUT9_OE                0                  0x0              
 * 0x013A[2]     OUT9_RDIV_FORCE2       0                  0x0              
 * 0x013B[2:0]   OUT9_FORMAT            1                  0x1              
 * 0x013B[3]     OUT9_SYNC_EN           1                  0x1              
 * 0x013B[5:4]   OUT9_DIS_STATE         0                  0x0              
 * 0x013B[7:6]   OUT9_CMOS_DRV          0                  0x0              
 * 0x013C[3:0]   OUT9_CM                11                 0xB              
 * 0x013C[6:4]   OUT9_AMPL              3                  0x3              
 * 0x013D[2:0]   OUT9_MUX_SEL           0                  0x0              
 * 0x013D[5:4]   OUT9_VDD_SEL           2                  0x2              
 * 0x013D[3]     OUT9_VDD_SEL_EN        1                  0x1              
 * 0x013D[7:6]   OUT9_INV               0                  0x0              
 * 0x013F[11:0]  OUTX_ALWAYS_ON         0                  0x000            
 * 0x0141[1]     OUT_DIS_MSK            0                  0x0              
 * 0x0141[5]     OUT_DIS_LOL_MSK        0                  0x0              
 * 0x0141[6]     OUT_DIS_LOSXAXB_MSK    1                  0x1              
 * 0x0141[7]     OUT_DIS_MSK_LOS_PFD    0                  0x0              
 * 0x0142[1]     OUT_DIS_MSK_LOL        1                  0x1              
 * 0x0142[5]     OUT_DIS_MSK_HOLD       1                  0x1              
 * 0x0206[1:0]   PXAXB                  0                  0x0              
 * 0x0208[47:0]  P0_NUM                 1                  0x000000000001   
 * 0x020E[31:0]  P0_DEN                 1                  0x00000001       
 * 0x0212[47:0]  P1_NUM                 0                  0x000000000000   
 * 0x0218[31:0]  P1_DEN                 0                  0x00000000       
 * 0x021C[47:0]  P2_NUM                 0                  0x000000000000   
 * 0x0222[31:0]  P2_DEN                 0                  0x00000000       
 * 0x0226[47:0]  P3_NUM                 0                  0x000000000000   
 * 0x022C[31:0]  P3_DEN                 0                  0x00000000       
 * 0x0231[3:0]   P0_FRACN_MODE          11                 0xB              
 * 0x0231[4]     P0_FRACN_EN            0                  0x0              
 * 0x0232[3:0]   P1_FRACN_MODE          11                 0xB              
 * 0x0232[4]     P1_FRACN_EN            0                  0x0              
 * 0x0233[3:0]   P2_FRACN_MODE          11                 0xB              
 * 0x0233[4]     P2_FRACN_EN            0                  0x0              
 * 0x0234[3:0]   P3_FRACN_MODE          11                 0xB              
 * 0x0234[4]     P3_FRACN_EN            0                  0x0              
 * 0x0235[43:0]  MXAXB_NUM              916841299968       0x0D578000000    
 * 0x023B[31:0]  MXAXB_DEN              3489660928         0xD0000000       
 * 0x024A[23:0]  R0_REG                 10                 0x00000A         
 * 0x024D[23:0]  R1_REG                 0                  0x000000         
 * 0x0250[23:0]  R2_REG                 1                  0x000001         
 * 0x0253[23:0]  R3_REG                 0                  0x000000         
 * 0x0256[23:0]  R4_REG                 0                  0x000000         
 * 0x0259[23:0]  R5_REG                 2                  0x000002         
 * 0x025C[23:0]  R6_REG                 0                  0x000000         
 * 0x025F[23:0]  R7_REG                 0                  0x000000         
 * 0x0262[23:0]  R8_REG                 2                  0x000002         
 * 0x0268[23:0]  R9_REG                 0                  0x000000         
 * 0x026B[7:0]   DESIGN_ID0             73                 0x49             
 * 0x026C[7:0]   DESIGN_ID1             79                 0x4F             
 * 0x026D[7:0]   DESIGN_ID2             52                 0x34             
 * 0x026E[7:0]   DESIGN_ID3             75                 0x4B             
 * 0x026F[7:0]   DESIGN_ID4             43                 0x2B             
 * 0x0270[7:0]   DESIGN_ID5             0                  0x00             
 * 0x0271[7:0]   DESIGN_ID6             0                  0x00             
 * 0x0272[7:0]   DESIGN_ID7             0                  0x00             
 * 0x0294[7:4]   FASTLOCK_EXTEND_SCL    8                  0x8              
 * 0x0296[1]     LOL_SLW_VALWIN_SELX    0                  0x0              
 * 0x0297[1]     FASTLOCK_DLY_ONSW_EN   1                  0x1              
 * 0x0299[1]     FASTLOCK_DLY_ONLOL_EN  1                  0x1              
 * 0x029D[19:0]  FASTLOCK_DLY_ONLOL     3829               0x00EF5          
 * 0x02A9[19:0]  FASTLOCK_DLY_ONSW      9830               0x02666          
 * 0x02B7[3:2]   LOL_NOSIG_TIME         3                  0x3              
 * 0x0302[43:0]  N0_NUM                 49392123904        0x00B80000000    
 * 0x0308[31:0]  N0_DEN                 2147483648         0x80000000       
 * 0x030C[0]     N0_UPDATE              0                  0x0              
 * 0x030D[43:0]  N1_NUM                 198967296000       0x02E53600000    
 * 0x0313[31:0]  N1_DEN                 2147483648         0x80000000       
 * 0x0317[0]     N1_UPDATE              0                  0x0              
 * 0x0318[43:0]  N2_NUM                 48282730496        0x00B3DE00000    
 * 0x031E[31:0]  N2_DEN                 3145728000         0xBB800000       
 * 0x0322[0]     N2_UPDATE              0                  0x0              
 * 0x0323[43:0]  N3_NUM                 0                  0x00000000000    
 * 0x0329[31:0]  N3_DEN                 0                  0x00000000       
 * 0x032D[0]     N3_UPDATE              0                  0x0              
 * 0x032E[43:0]  N4_NUM                 0                  0x00000000000    
 * 0x0334[31:0]  N4_DEN                 0                  0x00000000       
 * 0x0338[0]     N4_UPDATE              0                  0x0              
 * 0x0338[1]     N_UPDATE               0                  0x0              
 * 0x0339[4:0]   N_FSTEP_MSK            31                 0x1F             
 * 0x033B[43:0]  N0_FSTEPW              0                  0x00000000000    
 * 0x0341[43:0]  N1_FSTEPW              0                  0x00000000000    
 * 0x0347[43:0]  N2_FSTEPW              0                  0x00000000000    
 * 0x034D[43:0]  N3_FSTEPW              0                  0x00000000000    
 * 0x0353[43:0]  N4_FSTEPW              0                  0x00000000000    
 * 0x0359[15:0]  N0_DELAY               0                  0x0000           
 * 0x035B[15:0]  N1_DELAY               0                  0x0000           
 * 0x035D[15:0]  N2_DELAY               0                  0x0000           
 * 0x035F[15:0]  N3_DELAY               0                  0x0000           
 * 0x0361[15:0]  N4_DELAY               0                  0x0000           
 * 0x0487[0]     ZDM_EN                 0                  0x0              
 * 0x0487[2:1]   ZDM_IN_SEL             0                  0x0              
 * 0x0487[4]     ZDM_AUTOSW_EN          0                  0x0              
 * 0x0502[4]     ADD_DIV256             0                  0x0              
 * 0x0508[5:0]   BW0_PLL                16                 0x10             
 * 0x0509[5:0]   BW1_PLL                24                 0x18             
 * 0x050A[5:0]   BW2_PLL                15                 0x0F             
 * 0x050B[5:0]   BW3_PLL                15                 0x0F             
 * 0x050C[5:0]   BW4_PLL                1                  0x01             
 * 0x050D[5:0]   BW5_PLL                7                  0x07             
 * 0x050E[5:0]   FASTLOCK_BW0_PLL       23                 0x17             
 * 0x050F[5:0]   FASTLOCK_BW1_PLL       40                 0x28             
 * 0x0510[5:0]   FASTLOCK_BW2_PLL       12                 0x0C             
 * 0x0511[5:0]   FASTLOCK_BW3_PLL       11                 0x0B             
 * 0x0512[5:0]   FASTLOCK_BW4_PLL       1                  0x01             
 * 0x0513[5:0]   FASTLOCK_BW5_PLL       7                  0x07             
 * 0x0515[55:0]  M_NUM                  108662672588800    0x0062D400000000 
 * 0x051C[31:0]  M_DEN                  2147483648         0x80000000       
 * 0x0521[3:0]   M_FRAC_MODE            11                 0xB              
 * 0x0521[4]     M_FRAC_EN              0                  0x0              
 * 0x0521[5]     PLL_OUT_RATE_SEL       1                  0x1              
 * 0x052A[0]     IN_SEL_REGCTRL         1                  0x1              
 * 0x052A[3:1]   IN_SEL                 0                  0x0              
 * 0x052B[0]     FASTLOCK_AUTO_EN       1                  0x1              
 * 0x052B[1]     FASTLOCK_MAN           0                  0x0              
 * 0x052C[0]     HOLD_EN                1                  0x1              
 * 0x052C[3]     HOLD_RAMP_BYP          1                  0x1              
 * 0x052C[4]     HOLDEXIT_BW_SEL1       0                  0x0              
 * 0x052C[7:5]   RAMP_STEP_INTERVAL     0                  0x0              
 * 0x052D[1]     HOLD_RAMPBYP_NOHIST    1                  0x1              
 * 0x052E[4:0]   HOLD_HIST_LEN          21                 0x15             
 * 0x052F[4:0]   HOLD_HIST_DELAY        20                 0x14             
 * 0x0531[4:0]   HOLD_REF_COUNT_FRC     0                  0x00             
 * 0x0532[23:0]  HOLD_15M_CYC_COUNT     30865              0x007891         
 * 0x0535[0]     FORCE_HOLD             0                  0x0              
 * 0x0536[1:0]   CLK_SWITCH_MODE        0                  0x0              
 * 0x0536[2]     HSW_EN                 0                  0x0              
 * 0x0537[3:0]   IN_LOS_MSK             0                  0x0              
 * 0x0537[7:4]   IN_OOF_MSK             0                  0x0              
 * 0x0538[2:0]   IN0_PRIORITY           0                  0x0              
 * 0x0538[6:4]   IN1_PRIORITY           0                  0x0              
 * 0x0539[2:0]   IN2_PRIORITY           0                  0x0              
 * 0x0539[6:4]   IN3_PRIORITY           0                  0x0              
 * 0x053A[1:0]   HSW_MODE               2                  0x2              
 * 0x053A[3:2]   HSW_PHMEAS_CTRL        0                  0x0              
 * 0x053B[9:0]   HSW_PHMEAS_THR         3                  0x003            
 * 0x053D[4:0]   HSW_COARSE_PM_LEN      19                 0x13             
 * 0x053E[4:0]   HSW_COARSE_PM_DLY      6                  0x06             
 * 0x0589[12:0]  CAP_SHORT_DELAY        503                0x01F7           
 * 0x059B[4]     HOLD_PRESERVE_HIST     1                  0x1              
 * 0x059B[5]     HOLD_FRZ_WITH_INTONLY  1                  0x1              
 * 0x059B[6]     HOLDEXIT_BW_SEL0       1                  0x1              
 * 0x059B[7]     HOLDEXIT_STD_BO        1                  0x1              
 * 0x059D[5:0]   HOLDEXIT_BW0           23                 0x17             
 * 0x059E[5:0]   HOLDEXIT_BW1           40                 0x28             
 * 0x059F[5:0]   HOLDEXIT_BW2           12                 0x0C             
 * 0x05A0[5:0]   HOLDEXIT_BW3           11                 0x0B             
 * 0x05A1[5:0]   HOLDEXIT_BW4           1                  0x01             
 * 0x05A2[5:0]   HOLDEXIT_BW5           7                  0x07             
 * 0x05A6[2:0]   RAMP_STEP_SIZE         0                  0x0              
 * 0x05A6[3]     RAMP_SWITCH_EN         0                  0x0              
 * 0x0802[15:0]  FIXREGSA0              1333               0x0535           
 * 0x0804[7:0]   FIXREGSD0              0                  0x00             
 * 0x0805[15:0]  FIXREGSA1              0                  0x0000           
 * 0x0807[7:0]   FIXREGSD1              0                  0x00             
 * 0x0808[15:0]  FIXREGSA2              0                  0x0000           
 * 0x080A[7:0]   FIXREGSD2              0                  0x00             
 * 0x080B[15:0]  FIXREGSA3              0                  0x0000           
 * 0x080D[7:0]   FIXREGSD3              0                  0x00             
 * 0x080E[15:0]  FIXREGSA4              0                  0x0000           
 * 0x0810[7:0]   FIXREGSD4              0                  0x00             
 * 0x0811[15:0]  FIXREGSA5              0                  0x0000           
 * 0x0813[7:0]   FIXREGSD5              0                  0x00             
 * 0x0814[15:0]  FIXREGSA6              0                  0x0000           
 * 0x0816[7:0]   FIXREGSD6              0                  0x00             
 * 0x0817[15:0]  FIXREGSA7              0                  0x0000           
 * 0x0819[7:0]   FIXREGSD7              0                  0x00             
 * 0x081A[15:0]  FIXREGSA8              0                  0x0000           
 * 0x081C[7:0]   FIXREGSD8              0                  0x00             
 * 0x081D[15:0]  FIXREGSA9              0                  0x0000           
 * 0x081F[7:0]   FIXREGSD9              0                  0x00             
 * 0x0820[15:0]  FIXREGSA10             0                  0x0000           
 * 0x0822[7:0]   FIXREGSD10             0                  0x00             
 * 0x0823[15:0]  FIXREGSA11             0                  0x0000           
 * 0x0825[7:0]   FIXREGSD11             0                  0x00             
 * 0x0826[15:0]  FIXREGSA12             0                  0x0000           
 * 0x0828[7:0]   FIXREGSD12             0                  0x00             
 * 0x0829[15:0]  FIXREGSA13             0                  0x0000           
 * 0x082B[7:0]   FIXREGSD13             0                  0x00             
 * 0x082C[15:0]  FIXREGSA14             0                  0x0000           
 * 0x082E[7:0]   FIXREGSD14             0                  0x00             
 * 0x082F[15:0]  FIXREGSA15             0                  0x0000           
 * 0x0831[7:0]   FIXREGSD15             0                  0x00             
 * 0x0832[15:0]  FIXREGSA16             0                  0x0000           
 * 0x0834[7:0]   FIXREGSD16             0                  0x00             
 * 0x0835[15:0]  FIXREGSA17             0                  0x0000           
 * 0x0837[7:0]   FIXREGSD17             0                  0x00             
 * 0x0838[15:0]  FIXREGSA18             0                  0x0000           
 * 0x083A[7:0]   FIXREGSD18             0                  0x00             
 * 0x083B[15:0]  FIXREGSA19             0                  0x0000           
 * 0x083D[7:0]   FIXREGSD19             0                  0x00             
 * 0x083E[15:0]  FIXREGSA20             0                  0x0000           
 * 0x0840[7:0]   FIXREGSD20             0                  0x00             
 * 0x0841[15:0]  FIXREGSA21             0                  0x0000           
 * 0x0843[7:0]   FIXREGSD21             0                  0x00             
 * 0x0844[15:0]  FIXREGSA22             0                  0x0000           
 * 0x0846[7:0]   FIXREGSD22             0                  0x00             
 * 0x0847[15:0]  FIXREGSA23             0                  0x0000           
 * 0x0849[7:0]   FIXREGSD23             0                  0x00             
 * 0x084A[15:0]  FIXREGSA24             0                  0x0000           
 * 0x084C[7:0]   FIXREGSD24             0                  0x00             
 * 0x084D[15:0]  FIXREGSA25             0                  0x0000           
 * 0x084F[7:0]   FIXREGSD25             0                  0x00             
 * 0x0850[15:0]  FIXREGSA26             0                  0x0000           
 * 0x0852[7:0]   FIXREGSD26             0                  0x00             
 * 0x0853[15:0]  FIXREGSA27             0                  0x0000           
 * 0x0855[7:0]   FIXREGSD27             0                  0x00             
 * 0x0856[15:0]  FIXREGSA28             0                  0x0000           
 * 0x0858[7:0]   FIXREGSD28             0                  0x00             
 * 0x0859[15:0]  FIXREGSA29             0                  0x0000           
 * 0x085B[7:0]   FIXREGSD29             0                  0x00             
 * 0x085C[15:0]  FIXREGSA30             0                  0x0000           
 * 0x085E[7:0]   FIXREGSD30             0                  0x00             
 * 0x085F[15:0]  FIXREGSA31             0                  0x0000           
 * 0x0861[7:0]   FIXREGSD31             0                  0x00             
 * 0x090E[0]     XAXB_EXTCLK_EN         1                  0x1              
 * 0x0943[0]     IO_VDD_SEL             0                  0x0              
 * 0x0949[3:0]   IN_EN                  1                  0x1              
 * 0x0949[7:4]   IN_PULSED_CMOS_EN      3                  0x3              
 * 0x094A[3:0]   INX_TO_PFD_EN          1                  0x1              
 * 0x094E[11:0]  REFCLK_HYS_SEL         585                0x249            
 * 0x095E[0]     MXAXB_INTEGER          0                  0x0              
 * 0x0A02[4:0]   N_ADD_0P5              0                  0x00             
 * 0x0A03[4:0]   N_CLK_TO_OUTX_EN       7                  0x07             
 * 0x0A04[4:0]   N_PIBYP                1                  0x01             
 * 0x0A05[4:0]   N_PDNB                 7                  0x07             
 * 0x0A14[3]     N0_HIGH_FREQ           0                  0x0              
 * 0x0A1A[3]     N1_HIGH_FREQ           0                  0x0              
 * 0x0A20[3]     N2_HIGH_FREQ           0                  0x0              
 * 0x0A26[3]     N3_HIGH_FREQ           0                  0x0              
 * 0x0A2C[3]     N4_HIGH_FREQ           0                  0x0              
 * 0x0B44[3:0]   PDIV_FRACN_CLK_DIS     15                 0xF              
 * 0x0B44[5]     FRACN_CLK_DIS_PLL      1                  0x1              
 * 0x0B46[3:0]   LOS_CLK_DIS            0                  0x0              
 * 0x0B47[4:0]   OOF_CLK_DIS            14                 0x0E             
 * 0x0B48[4:0]   OOF_DIV_CLK_DIS        14                 0x0E             
 * 0x0B4A[4:0]   N_CLK_DIS              24                 0x18             
 * 0x0B57[11:0]  VCO_RESET_CALCODE      249                0x0F9
 * 
 *
 */


static struct ntv2_genlock_data s_genlock_1125_5000[] =
{
	/* Start configuration preamble */
	{ 0x0B24, 0xC0 },
	{ 0x0B25, 0x00 },
	{ 0x0540, 0x01 },
	/* End configuration preamble */

	/* Delay 300 msec */
	/*    Delay is worst case time for device to complete any calibration */
	/*    that is running due to device state change previous to this script */
	/*    being processed. */
	{ 0x0000, 0x01 },

	/* Start configuration registers */
	{ 0x000B, 0x64 },
	{ 0x0016, 0x02 },
	{ 0x0017, 0xFC },
	{ 0x0018, 0xFF },
	{ 0x0019, 0xDF },
	{ 0x001A, 0xDF },
	{ 0x002B, 0x02 },
	{ 0x002C, 0x01 },
	{ 0x002D, 0x02 },
	{ 0x002E, 0x8E },
	{ 0x002F, 0x04 },
	{ 0x0030, 0x00 },
	{ 0x0031, 0x00 },
	{ 0x0032, 0x00 },
	{ 0x0033, 0x00 },
	{ 0x0034, 0x00 },
	{ 0x0035, 0x00 },
	{ 0x0036, 0x2D },
	{ 0x0037, 0x04 },
	{ 0x0038, 0x00 },
	{ 0x0039, 0x00 },
	{ 0x003A, 0x00 },
	{ 0x003B, 0x00 },
	{ 0x003C, 0x00 },
	{ 0x003D, 0x00 },
	{ 0x003F, 0x01 },
	{ 0x0040, 0x04 },
	{ 0x0041, 0x02 },
	{ 0x0042, 0x00 },
	{ 0x0043, 0x00 },
	{ 0x0044, 0x00 },
	{ 0x0045, 0x0C },
	{ 0x0046, 0x96 },
	{ 0x0047, 0x00 },
	{ 0x0048, 0x00 },
	{ 0x0049, 0x00 },
	{ 0x004A, 0x4B },
	{ 0x004B, 0x00 },
	{ 0x004C, 0x00 },
	{ 0x004D, 0x00 },
	{ 0x004E, 0x05 },
	{ 0x004F, 0x00 },
	{ 0x0050, 0x0F },
	{ 0x0051, 0x00 },
	{ 0x0052, 0x00 },
	{ 0x0053, 0x00 },
	{ 0x0054, 0x00 },
	{ 0x0055, 0x00 },
	{ 0x0056, 0x00 },
	{ 0x0057, 0x00 },
	{ 0x0058, 0x00 },
	{ 0x0059, 0x01 },
	{ 0x005A, 0xB9 },
	{ 0x005B, 0x91 },
	{ 0x005C, 0x1B },
	{ 0x005D, 0x01 },
	{ 0x005E, 0x00 },
	{ 0x005F, 0x00 },
	{ 0x0060, 0x00 },
	{ 0x0061, 0x00 },
	{ 0x0062, 0x00 },
	{ 0x0063, 0x00 },
	{ 0x0064, 0x00 },
	{ 0x0065, 0x00 },
	{ 0x0066, 0x00 },
	{ 0x0067, 0x00 },
	{ 0x0068, 0x00 },
	{ 0x0069, 0x00 },
	{ 0x0092, 0x02 },
	{ 0x0093, 0xA0 },
	{ 0x0095, 0x00 },
	{ 0x0096, 0x90 },
	{ 0x0098, 0x70 },
	{ 0x009A, 0x02 },
	{ 0x009B, 0x50 },
	{ 0x009D, 0x04 },
	{ 0x009E, 0x60 },
	{ 0x00A0, 0x30 },
	{ 0x00A2, 0x00 },
	{ 0x00A9, 0x0E },
	{ 0x00AA, 0xA7 },
	{ 0x00AB, 0x04 },
	{ 0x00AC, 0x00 },
	{ 0x00E5, 0x21 },
	{ 0x00EA, 0xD1 },
	{ 0x00EB, 0xB1 },
	{ 0x00EC, 0x03 },
	{ 0x00ED, 0x00 },
	{ 0x0102, 0x01 },
	{ 0x0108, 0x02 },
	{ 0x0109, 0x09 },
	{ 0x010A, 0x3B },
	{ 0x010B, 0x28 },
	{ 0x010D, 0x01 },
	{ 0x010E, 0x09 },
	{ 0x010F, 0x3B },
	{ 0x0110, 0x28 },
	{ 0x0112, 0x02 },
	{ 0x0113, 0x09 },
	{ 0x0114, 0x3B },
	{ 0x0115, 0x28 },
	{ 0x0117, 0x01 },
	{ 0x0118, 0x09 },
	{ 0x0119, 0x3B },
	{ 0x011A, 0x28 },
	{ 0x011C, 0x01 },
	{ 0x011D, 0x09 },
	{ 0x011E, 0x3B },
	{ 0x011F, 0x28 },
	{ 0x0121, 0x02 },
	{ 0x0122, 0x09 },
	{ 0x0123, 0x3B },
	{ 0x0124, 0x29 },
	{ 0x0126, 0x01 },
	{ 0x0127, 0x09 },
	{ 0x0128, 0x3B },
	{ 0x0129, 0x28 },
	{ 0x012B, 0x01 },
	{ 0x012C, 0x09 },
	{ 0x012D, 0x3B },
	{ 0x012E, 0x28 },
	{ 0x0130, 0x02 },
	{ 0x0131, 0x09 },
	{ 0x0132, 0x3B },
	{ 0x0133, 0x2A },
	{ 0x013A, 0x01 },
	{ 0x013B, 0x09 },
	{ 0x013C, 0x3B },
	{ 0x013D, 0x28 },
	{ 0x013F, 0x00 },
	{ 0x0140, 0x00 },
	{ 0x0141, 0x40 },
	{ 0x0142, 0xFF },
	{ 0x0206, 0x00 },
	{ 0x0208, 0x01 },
	{ 0x0209, 0x00 },
	{ 0x020A, 0x00 },
	{ 0x020B, 0x00 },
	{ 0x020C, 0x00 },
	{ 0x020D, 0x00 },
	{ 0x020E, 0x01 },
	{ 0x020F, 0x00 },
	{ 0x0210, 0x00 },
	{ 0x0211, 0x00 },
	{ 0x0212, 0x00 },
	{ 0x0213, 0x00 },
	{ 0x0214, 0x00 },
	{ 0x0215, 0x00 },
	{ 0x0216, 0x00 },
	{ 0x0217, 0x00 },
	{ 0x0218, 0x00 },
	{ 0x0219, 0x00 },
	{ 0x021A, 0x00 },
	{ 0x021B, 0x00 },
	{ 0x021C, 0x00 },
	{ 0x021D, 0x00 },
	{ 0x021E, 0x00 },
	{ 0x021F, 0x00 },
	{ 0x0220, 0x00 },
	{ 0x0221, 0x00 },
	{ 0x0222, 0x00 },
	{ 0x0223, 0x00 },
	{ 0x0224, 0x00 },
	{ 0x0225, 0x00 },
	{ 0x0226, 0x00 },
	{ 0x0227, 0x00 },
	{ 0x0228, 0x00 },
	{ 0x0229, 0x00 },
	{ 0x022A, 0x00 },
	{ 0x022B, 0x00 },
	{ 0x022C, 0x00 },
	{ 0x022D, 0x00 },
	{ 0x022E, 0x00 },
	{ 0x022F, 0x00 },
	{ 0x0231, 0x0B },
	{ 0x0232, 0x0B },
	{ 0x0233, 0x0B },
	{ 0x0234, 0x0B },
	{ 0x0235, 0x00 },
	{ 0x0236, 0x00 },
	{ 0x0237, 0x00 },
	{ 0x0238, 0x78 },
	{ 0x0239, 0xD5 },
	{ 0x023A, 0x00 },
	{ 0x023B, 0x00 },
	{ 0x023C, 0x00 },
	{ 0x023D, 0x00 },
	{ 0x023E, 0xD0 },
	{ 0x024A, 0x0A },
	{ 0x024B, 0x00 },
	{ 0x024C, 0x00 },
	{ 0x024D, 0x00 },
	{ 0x024E, 0x00 },
	{ 0x024F, 0x00 },
	{ 0x0250, 0x01 },
	{ 0x0251, 0x00 },
	{ 0x0252, 0x00 },
	{ 0x0253, 0x00 },
	{ 0x0254, 0x00 },
	{ 0x0255, 0x00 },
	{ 0x0256, 0x00 },
	{ 0x0257, 0x00 },
	{ 0x0258, 0x00 },
	{ 0x0259, 0x02 },
	{ 0x025A, 0x00 },
	{ 0x025B, 0x00 },
	{ 0x025C, 0x00 },
	{ 0x025D, 0x00 },
	{ 0x025E, 0x00 },
	{ 0x025F, 0x00 },
	{ 0x0260, 0x00 },
	{ 0x0261, 0x00 },
	{ 0x0262, 0x02 },
	{ 0x0263, 0x00 },
	{ 0x0264, 0x00 },
	{ 0x0268, 0x00 },
	{ 0x0269, 0x00 },
	{ 0x026A, 0x00 },
	{ 0x026B, 0x49 },
	{ 0x026C, 0x4F },
	{ 0x026D, 0x34 },
	{ 0x026E, 0x4B },
	{ 0x026F, 0x2B },
	{ 0x0270, 0x00 },
	{ 0x0271, 0x00 },
	{ 0x0272, 0x00 },
	{ 0x0294, 0x80 },
	{ 0x0296, 0x00 },
	{ 0x0297, 0x02 },
	{ 0x0299, 0x02 },
	{ 0x029D, 0xF5 },
	{ 0x029E, 0x0E },
	{ 0x029F, 0x00 },
	{ 0x02A9, 0x66 },
	{ 0x02AA, 0x26 },
	{ 0x02AB, 0x00 },
	{ 0x02B7, 0xFF },
	{ 0x0302, 0x00 },
	{ 0x0303, 0x00 },
	{ 0x0304, 0x00 },
	{ 0x0305, 0x80 },
	{ 0x0306, 0x0B },
	{ 0x0307, 0x00 },
	{ 0x0308, 0x00 },
	{ 0x0309, 0x00 },
	{ 0x030A, 0x00 },
	{ 0x030B, 0x80 },
	{ 0x030C, 0x00 },
	{ 0x030D, 0x00 },
	{ 0x030E, 0x00 },
	{ 0x030F, 0x60 },
	{ 0x0310, 0x53 },
	{ 0x0311, 0x2E },
	{ 0x0312, 0x00 },
	{ 0x0313, 0x00 },
	{ 0x0314, 0x00 },
	{ 0x0315, 0x00 },
	{ 0x0316, 0x80 },
	{ 0x0317, 0x00 },
	{ 0x0318, 0x00 },
	{ 0x0319, 0x00 },
	{ 0x031A, 0xE0 },
	{ 0x031B, 0x3D },
	{ 0x031C, 0x0B },
	{ 0x031D, 0x00 },
	{ 0x031E, 0x00 },
	{ 0x031F, 0x00 },
	{ 0x0320, 0x80 },
	{ 0x0321, 0xBB },
	{ 0x0322, 0x00 },
	{ 0x0323, 0x00 },
	{ 0x0324, 0x00 },
	{ 0x0325, 0x00 },
	{ 0x0326, 0x00 },
	{ 0x0327, 0x00 },
	{ 0x0328, 0x00 },
	{ 0x0329, 0x00 },
	{ 0x032A, 0x00 },
	{ 0x032B, 0x00 },
	{ 0x032C, 0x00 },
	{ 0x032D, 0x00 },
	{ 0x032E, 0x00 },
	{ 0x032F, 0x00 },
	{ 0x0330, 0x00 },
	{ 0x0331, 0x00 },
	{ 0x0332, 0x00 },
	{ 0x0333, 0x00 },
	{ 0x0334, 0x00 },
	{ 0x0335, 0x00 },
	{ 0x0336, 0x00 },
	{ 0x0337, 0x00 },
	{ 0x0338, 0x00 },
	{ 0x0339, 0x1F },
	{ 0x033B, 0x00 },
	{ 0x033C, 0x00 },
	{ 0x033D, 0x00 },
	{ 0x033E, 0x00 },
	{ 0x033F, 0x00 },
	{ 0x0340, 0x00 },
	{ 0x0341, 0x00 },
	{ 0x0342, 0x00 },
	{ 0x0343, 0x00 },
	{ 0x0344, 0x00 },
	{ 0x0345, 0x00 },
	{ 0x0346, 0x00 },
	{ 0x0347, 0x00 },
	{ 0x0348, 0x00 },
	{ 0x0349, 0x00 },
	{ 0x034A, 0x00 },
	{ 0x034B, 0x00 },
	{ 0x034C, 0x00 },
	{ 0x034D, 0x00 },
	{ 0x034E, 0x00 },
	{ 0x034F, 0x00 },
	{ 0x0350, 0x00 },
	{ 0x0351, 0x00 },
	{ 0x0352, 0x00 },
	{ 0x0353, 0x00 },
	{ 0x0354, 0x00 },
	{ 0x0355, 0x00 },
	{ 0x0356, 0x00 },
	{ 0x0357, 0x00 },
	{ 0x0358, 0x00 },
	{ 0x0359, 0x00 },
	{ 0x035A, 0x00 },
	{ 0x035B, 0x00 },
	{ 0x035C, 0x00 },
	{ 0x035D, 0x00 },
	{ 0x035E, 0x00 },
	{ 0x035F, 0x00 },
	{ 0x0360, 0x00 },
	{ 0x0361, 0x00 },
	{ 0x0362, 0x00 },
	{ 0x0487, 0x00 },
	{ 0x0502, 0x01 },
	{ 0x0508, 0x10 },
	{ 0x0509, 0x18 },
	{ 0x050A, 0x0F },
	{ 0x050B, 0x0F },
	{ 0x050C, 0x01 },
	{ 0x050D, 0x07 },
	{ 0x050E, 0x17 },
	{ 0x050F, 0x28 },
	{ 0x0510, 0x0C },
	{ 0x0511, 0x0B },
	{ 0x0512, 0x01 },
	{ 0x0513, 0x07 },
	{ 0x0515, 0x00 },
	{ 0x0516, 0x00 },
	{ 0x0517, 0x00 },
	{ 0x0518, 0x00 },
	{ 0x0519, 0xE0 },
	{ 0x051A, 0x5E },
	{ 0x051B, 0x00 },
	{ 0x051C, 0x00 },
	{ 0x051D, 0x00 },
	{ 0x051E, 0x00 },
	{ 0x051F, 0x80 },
	{ 0x0521, 0x2B },
	{ 0x052A, 0x01 },
	{ 0x052B, 0x01 },
	{ 0x052C, 0x0F },
	{ 0x052D, 0x03 },
	{ 0x052E, 0x15 },
	{ 0x052F, 0x14 },
	{ 0x0531, 0x00 },
	{ 0x0532, 0xBE },
	{ 0x0533, 0x73 },
	{ 0x0534, 0x00 },
	{ 0x0535, 0x00 },
	{ 0x0536, 0x00 },
	{ 0x0537, 0x00 },
	{ 0x0538, 0x00 },
	{ 0x0539, 0x00 },
	{ 0x053A, 0x02 },
	{ 0x053B, 0x03 },
	{ 0x053C, 0x00 },
	{ 0x053D, 0x13 },
	{ 0x053E, 0x06 },
	{ 0x0589, 0xE3 },
	{ 0x058A, 0x01 },
	{ 0x059B, 0xF8 },
	{ 0x059D, 0x17 },
	{ 0x059E, 0x28 },
	{ 0x059F, 0x0C },
	{ 0x05A0, 0x0B },
	{ 0x05A1, 0x01 },
	{ 0x05A2, 0x07 },
	{ 0x05A6, 0x00 },
	{ 0x0802, 0x35 },
	{ 0x0803, 0x05 },
	{ 0x0804, 0x00 },
	{ 0x0805, 0x00 },
	{ 0x0806, 0x00 },
	{ 0x0807, 0x00 },
	{ 0x0808, 0x00 },
	{ 0x0809, 0x00 },
	{ 0x080A, 0x00 },
	{ 0x080B, 0x00 },
	{ 0x080C, 0x00 },
	{ 0x080D, 0x00 },
	{ 0x080E, 0x00 },
	{ 0x080F, 0x00 },
	{ 0x0810, 0x00 },
	{ 0x0811, 0x00 },
	{ 0x0812, 0x00 },
	{ 0x0813, 0x00 },
	{ 0x0814, 0x00 },
	{ 0x0815, 0x00 },
	{ 0x0816, 0x00 },
	{ 0x0817, 0x00 },
	{ 0x0818, 0x00 },
	{ 0x0819, 0x00 },
	{ 0x081A, 0x00 },
	{ 0x081B, 0x00 },
	{ 0x081C, 0x00 },
	{ 0x081D, 0x00 },
	{ 0x081E, 0x00 },
	{ 0x081F, 0x00 },
	{ 0x0820, 0x00 },
	{ 0x0821, 0x00 },
	{ 0x0822, 0x00 },
	{ 0x0823, 0x00 },
	{ 0x0824, 0x00 },
	{ 0x0825, 0x00 },
	{ 0x0826, 0x00 },
	{ 0x0827, 0x00 },
	{ 0x0828, 0x00 },
	{ 0x0829, 0x00 },
	{ 0x082A, 0x00 },
	{ 0x082B, 0x00 },
	{ 0x082C, 0x00 },
	{ 0x082D, 0x00 },
	{ 0x082E, 0x00 },
	{ 0x082F, 0x00 },
	{ 0x0830, 0x00 },
	{ 0x0831, 0x00 },
	{ 0x0832, 0x00 },
	{ 0x0833, 0x00 },
	{ 0x0834, 0x00 },
	{ 0x0835, 0x00 },
	{ 0x0836, 0x00 },
	{ 0x0837, 0x00 },
	{ 0x0838, 0x00 },
	{ 0x0839, 0x00 },
	{ 0x083A, 0x00 },
	{ 0x083B, 0x00 },
	{ 0x083C, 0x00 },
	{ 0x083D, 0x00 },
	{ 0x083E, 0x00 },
	{ 0x083F, 0x00 },
	{ 0x0840, 0x00 },
	{ 0x0841, 0x00 },
	{ 0x0842, 0x00 },
	{ 0x0843, 0x00 },
	{ 0x0844, 0x00 },
	{ 0x0845, 0x00 },
	{ 0x0846, 0x00 },
	{ 0x0847, 0x00 },
	{ 0x0848, 0x00 },
	{ 0x0849, 0x00 },
	{ 0x084A, 0x00 },
	{ 0x084B, 0x00 },
	{ 0x084C, 0x00 },
	{ 0x084D, 0x00 },
	{ 0x084E, 0x00 },
	{ 0x084F, 0x00 },
	{ 0x0850, 0x00 },
	{ 0x0851, 0x00 },
	{ 0x0852, 0x00 },
	{ 0x0853, 0x00 },
	{ 0x0854, 0x00 },
	{ 0x0855, 0x00 },
	{ 0x0856, 0x00 },
	{ 0x0857, 0x00 },
	{ 0x0858, 0x00 },
	{ 0x0859, 0x00 },
	{ 0x085A, 0x00 },
	{ 0x085B, 0x00 },
	{ 0x085C, 0x00 },
	{ 0x085D, 0x00 },
	{ 0x085E, 0x00 },
	{ 0x085F, 0x00 },
	{ 0x0860, 0x00 },
	{ 0x0861, 0x00 },
	{ 0x090E, 0x03 },
	{ 0x0943, 0x00 },
	{ 0x0949, 0x31 },
	{ 0x094A, 0x01 },
	{ 0x094E, 0x49 },
	{ 0x094F, 0x02 },
	{ 0x095E, 0x00 },
	{ 0x0A02, 0x00 },
	{ 0x0A03, 0x07 },
	{ 0x0A04, 0x01 },
	{ 0x0A05, 0x07 },
	{ 0x0A14, 0x00 },
	{ 0x0A1A, 0x00 },
	{ 0x0A20, 0x00 },
	{ 0x0A26, 0x00 },
	{ 0x0A2C, 0x00 },
	{ 0x0B44, 0x2F },
	{ 0x0B46, 0x00 },
	{ 0x0B47, 0x0E },
	{ 0x0B48, 0x0E },
	{ 0x0B4A, 0x18 },
	{ 0x0B57, 0xF9 },
	{ 0x0B58, 0x00 },
	/* End configuration registers */

	/* Start configuration postamble */
	{ 0x0514, 0x01 },
	{ 0x001C, 0x01 },
	{ 0x0540, 0x00 },
	{ 0x0B24, 0xC3 },
	{ 0x0B25, 0x02 },
	/* End configuration postamble */

	{ 0x0000, 0x00 }
};

/*
 * Design Report
 *
 * Overview
 * ========
 * Part:         Si5345 Rev D
 * Project File: C:\XilinxProjects\flint_tr051017\genlock\FormatFiles\IO4K+_1125_5994.slabtimeproj
 * Design ID:    IO4K+
 * Created By:   ClockBuilder Pro v2.16.1 [2017-07-19]
 * Timestamp:    2017-08-24 16:32:31 GMT-07:00
 * 
 * Design Notes
 * ============
 * assumes NTSC HSYNC (pulsed) input = (30/1.001)*525
 * 
 * Design Rule Check
 * =================
 * Errors:
 * - No errors
 * 
 * Warnings:
 * - Pulsed LVCMOS input buffer mode has been selected. This mode has non-standard input voltage logic thresholds: 0.33 V for Vil (max) and 0.49 V for Vih (min). Select this mode only if your input clock has a duty cycle significantly less or more than 50%.  Refer to the device datasheet for the exact threshold voltage specifications and the input attenuator circuit (DC coupled Pulsed LVCMOS) in the Family Reference Manual.
 * 
 * Device Grade
 * ============
 * Maximum Output Frequency: 148.5 MHz
 * Frequency Synthesis Mode: Fractional
 * Minimum Base OPN:         Si5345B
 * Actual Base OPN:          Si5345B
 * 
 * Base       Output Clock         Supported Frequency Synthesis Modes
 * OPN Grade  Frequency Range      (Typical Jitter)
 * ---------  -------------------  --------------------------------------------
 * Si5345A    100 Hz to 1.028 GHz  Integer (< 100 fs) and fractional (< 150 fs)
 * Si5345B    100 Hz to 350 MHz    "
 * Si5345C    100 Hz to 1.028 GHz  Integer only (< 100 fs)
 * Si5345D    100 Hz to 350 MHz    "
 * 
 * Design
 * ======
 * Host Interface:
 *    I/O Power Supply: VDD (Core)
 *    SPI Mode: 4-Wire
 *    I2C Address Range: 100d to 103d / 0x64 to 0x67 (selected via A0/A1 pins)
 * 
 * XA/XB:
 *    52 MHz (XO - External Oscillator)
 * 
 * Inputs:
 *     IN0: 56.25 kHz [ 56 + 1/4 kHz ]
 *          [ (50)*1125 ]
 *          Pulsed LVCMOS
 *     IN1: Unused
 *     IN2: Unused
 *     IN3: Unused
 * 
 * Outputs:
 *    OUT0: 27 MHz
 *          Enabled, LVDS 2.5 V
 *    OUT1: Unused
 *    OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT3: Unused
 *    OUT4: Unused
 *    OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT6: Unused
 *    OUT7: Unused
 *    OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *          [ 148.5/1.001 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT9: Unused
 * 
 * Frequency Plan
 * ==============
 * Priority: maximize the number of low jitter outputs
 * 
 * Fvco = 13.662 GHz [ 13 + 331/500 GHz ]
 * Fpfd = 56.25 kHz [ 56 + 1/4 kHz ]
 * Fms0 = 594 MHz
 * Fms1 = 147.456 MHz [ 147 + 57/125 MHz ]
 * Fms2 = 890.1098901098901098... MHz [ 890 + 10/91 MHz ]
 * 
 * P dividers:
 *    P0  = 1
 *    P1  = Unused
 *    P2  = Unused
 *    P3  = Unused
 *    Pxaxb = 1
 * 
 * MXAXB = 262.7307692307692307... [ 262 + 19/26 ]
 * M = 48576
 * N dividers:
 *    N0:
 *       Value: 23
 *       Skew:  0.000 s
 *       OUT0: 27 MHz
 *       OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *    N1:
 *       Value: 92.6513671875 [ 92 + 667/1024 ]
 *       Skew:  0.000 s
 *       OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *    N2:
 *       Value: 15.3486666666666666... [ 15 + 523/1500 ]
 *       Skew:  0.000 s
 *       OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *    N3:
 *       Unused
 *    N4:
 *       Unused
 * 
 * R dividers:
 *    R0 = 22
 *    R1 = Unused
 *    R2 = 4
 *    R3 = Unused
 *    R4 = Unused
 *    R5 = 6
 *    R6 = Unused
 *    R7 = Unused
 *    R8 = 6
 *    R9 = Unused
 * 
 * Nominal Bandwidth:
 *   Desired: 1.000 Hz
 *   Actual:  541.440 mHz
 *   Coefficients:
 *      BW0:  16
 *      BW1:  24
 *      BW2:  15
 *      BW3:  15
 *      BW4:  1
 *      BW5:  7
 * Fastlock Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  85.050 Hz
 *   Coefficients:
 *      BW0:  23
 *      BW1:  40
 *      BW2:  12
 *      BW3:  11
 *      BW4:  1
 *      BW5:  7
 * Holdover Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  85.050 Hz
 *   Coefficients:
 *      BW0:  23
 *      BW1:  40
 *      BW2:  12
 *      BW3:  11
 *      BW4:  1
 *      BW5:  7
 * 
 * Dividers listed above show effective values. These values are translated to register settings by ClockBuilder Pro. For the actual register values, see below. Refer to the Family Reference Manual for information on registers related to frequency plan.
 * 
 * Digitally Controlled Oscillator (DCO)
 * =====================================
 * Mode: Register Direct Write
 * 
 * N0: DCO Disabled
 * 
 * N1: DCO Disabled
 * 
 * N2: DCO Disabled
 * 
 * N3: DCO Disabled
 * 
 * N4: DCO Disabled
 * 
 * Estimated Power & Junction Temperature
 * ======================================
 * Assumptions:
 * 
 * Revision: D
 * VDD:      1.8 V
 * Ta:       70 C
 * Airflow:  None
 * 
 * Total Power: 808 mW, On Chip Power: 784 mW, Tj: 87 C
 * 
 *                 Frequency  Format   Voltage   Current     Power
 *         -----------------  ------  --------  --------  --------
 * VDD                                   1.8 V  147.9 mA    266 mW
 * VDDA                                  3.3 V  117.4 mA    387 mW
 * VDDO0              27 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO1              Unused                                      
 * VDDO2           148.5 MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO3              Unused                                      
 * VDDO4              Unused                                      
 * VDDO5          24.576 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO6              Unused                                      
 * VDDO7              Unused                                      
 * VDDO8   148.351648... MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO9              Unused                                      
 *                                              --------  --------
 *                                       Total  327.2 mA    808 mW
 * 
 * Note:
 * 
 * -Total power includes on- and off-chip power. This is a typical value and estimate only.
 * -Use an EVB for a more exact power measurement
 * -On-chip power excludes power dissipated in external terminations.
 * -Tj is junction temperature. Tj must be less than 125 C (on Si5345 Revision D) for device to comply with datasheet specifications.
 * 
 * Settings
 * ========
 * 
 * Location      Setting Name           Decimal Value      Hex Value        
 * ------------  ---------------------  -----------------  -----------------
 * 0x000B[6:0]   I2C_ADDR               100                0x64             
 * 0x0016[1]     LOL_ON_HOLD            1                  0x1              
 * 0x0017[0]     SYSINCAL_INTR_MSK      0                  0x0              
 * 0x0017[1]     LOSXAXB_INTR_MSK       0                  0x0              
 * 0x0017[5]     SMB_TMOUT_INTR_MSK     1                  0x1              
 * 0x0018[3:0]   LOS_INTR_MSK           15                 0xF              
 * 0x0018[7:4]   OOF_INTR_MSK           15                 0xF              
 * 0x0019[1]     LOL_INTR_MSK           1                  0x1              
 * 0x0019[5]     HOLD_INTR_MSK          0                  0x0              
 * 0x001A[5]     CAL_INTR_MSK           0                  0x0              
 * 0x002B[3]     SPI_3WIRE              0                  0x0              
 * 0x002B[5]     AUTO_NDIV_UPDATE       0                  0x0              
 * 0x002C[3:0]   LOS_EN                 1                  0x1              
 * 0x002C[4]     LOSXAXB_DIS            0                  0x0              
 * 0x002D[1:0]   LOS0_VAL_TIME          2                  0x2              
 * 0x002D[3:2]   LOS1_VAL_TIME          0                  0x0              
 * 0x002D[5:4]   LOS2_VAL_TIME          0                  0x0              
 * 0x002D[7:6]   LOS3_VAL_TIME          0                  0x0              
 * 0x002E[15:0]  LOS0_TRG_THR           1166               0x048E           
 * 0x0030[15:0]  LOS1_TRG_THR           0                  0x0000           
 * 0x0032[15:0]  LOS2_TRG_THR           0                  0x0000           
 * 0x0034[15:0]  LOS3_TRG_THR           0                  0x0000           
 * 0x0036[15:0]  LOS0_CLR_THR           1069               0x042D           
 * 0x0038[15:0]  LOS1_CLR_THR           0                  0x0000           
 * 0x003A[15:0]  LOS2_CLR_THR           0                  0x0000           
 * 0x003C[15:0]  LOS3_CLR_THR           0                  0x0000           
 * 0x003F[3:0]   OOF_EN                 1                  0x1              
 * 0x003F[7:4]   FAST_OOF_EN            0                  0x0              
 * 0x0040[2:0]   OOF_REF_SEL            4                  0x4              
 * 0x0041[4:0]   OOF0_DIV_SEL           2                  0x02             
 * 0x0042[4:0]   OOF1_DIV_SEL           0                  0x00             
 * 0x0043[4:0]   OOF2_DIV_SEL           0                  0x00             
 * 0x0044[4:0]   OOF3_DIV_SEL           0                  0x00             
 * 0x0045[4:0]   OOFXO_DIV_SEL          12                 0x0C             
 * 0x0046[7:0]   OOF0_SET_THR           150                0x96             
 * 0x0047[7:0]   OOF1_SET_THR           0                  0x00             
 * 0x0048[7:0]   OOF2_SET_THR           0                  0x00             
 * 0x0049[7:0]   OOF3_SET_THR           0                  0x00             
 * 0x004A[7:0]   OOF0_CLR_THR           75                 0x4B             
 * 0x004B[7:0]   OOF1_CLR_THR           0                  0x00             
 * 0x004C[7:0]   OOF2_CLR_THR           0                  0x00             
 * 0x004D[7:0]   OOF3_CLR_THR           0                  0x00             
 * 0x004E[2:0]   OOF0_DETWIN_SEL        5                  0x5              
 * 0x004E[6:4]   OOF1_DETWIN_SEL        0                  0x0              
 * 0x004F[2:0]   OOF2_DETWIN_SEL        0                  0x0              
 * 0x004F[6:4]   OOF3_DETWIN_SEL        0                  0x0              
 * 0x0050[3:0]   OOF_ON_LOS             15                 0xF              
 * 0x0051[3:0]   FAST_OOF0_SET_THR      0                  0x0              
 * 0x0052[3:0]   FAST_OOF1_SET_THR      0                  0x0              
 * 0x0053[3:0]   FAST_OOF2_SET_THR      0                  0x0              
 * 0x0054[3:0]   FAST_OOF3_SET_THR      0                  0x0              
 * 0x0055[3:0]   FAST_OOF0_CLR_THR      0                  0x0              
 * 0x0056[3:0]   FAST_OOF1_CLR_THR      0                  0x0              
 * 0x0057[3:0]   FAST_OOF2_CLR_THR      0                  0x0              
 * 0x0058[3:0]   FAST_OOF3_CLR_THR      0                  0x0              
 * 0x0059[1:0]   FAST_OOF0_DETWIN_SEL   1                  0x1              
 * 0x0059[3:2]   FAST_OOF1_DETWIN_SEL   0                  0x0              
 * 0x0059[5:4]   FAST_OOF2_DETWIN_SEL   0                  0x0              
 * 0x0059[7:6]   FAST_OOF3_DETWIN_SEL   0                  0x0              
 * 0x005A[25:0]  OOF0_RATIO_REF         18583993           0x11B91B9        
 * 0x005E[25:0]  OOF1_RATIO_REF         0                  0x0000000        
 * 0x0062[25:0]  OOF2_RATIO_REF         0                  0x0000000        
 * 0x0066[25:0]  OOF3_RATIO_REF         0                  0x0000000        
 * 0x0092[1]     LOL_FST_EN             1                  0x1              
 * 0x0093[7:4]   LOL_FST_DETWIN_SEL     10                 0xA              
 * 0x0095[3:2]   LOL_FST_VALWIN_SEL     0                  0x0              
 * 0x0096[7:4]   LOL_FST_SET_THR_SEL    9                  0x9              
 * 0x0098[7:4]   LOL_FST_CLR_THR_SEL    7                  0x7              
 * 0x009A[1]     LOL_SLOW_EN_PLL        1                  0x1              
 * 0x009B[7:4]   LOL_SLW_DETWIN_SEL     5                  0x5              
 * 0x009D[3:2]   LOL_SLW_VALWIN_SEL     1                  0x1              
 * 0x009E[7:4]   LOL_SLW_SET_THR        6                  0x6              
 * 0x00A0[7:4]   LOL_SLW_CLR_THR        3                  0x3              
 * 0x00A2[1]     LOL_TIMER_EN           0                  0x0              
 * 0x00A9[28:0]  LOL_CLR_DELAY_DIV256   304910             0x0004A70E       
 * 0x00E5[5]     FASTLOCK_EXTEND_EN     1                  0x1              
 * 0x00EA[28:0]  FASTLOCK_EXTEND        242129             0x0003B1D1       
 * 0x0102[0]     OUTALL_DISABLE_LOW     1                  0x1              
 * 0x0108[0]     OUT0_PDN               0                  0x0              
 * 0x0108[1]     OUT0_OE                1                  0x1              
 * 0x0108[2]     OUT0_RDIV_FORCE2       0                  0x0              
 * 0x0109[2:0]   OUT0_FORMAT            1                  0x1              
 * 0x0109[3]     OUT0_SYNC_EN           1                  0x1              
 * 0x0109[5:4]   OUT0_DIS_STATE         0                  0x0              
 * 0x0109[7:6]   OUT0_CMOS_DRV          0                  0x0              
 * 0x010A[3:0]   OUT0_CM                11                 0xB              
 * 0x010A[6:4]   OUT0_AMPL              3                  0x3              
 * 0x010B[2:0]   OUT0_MUX_SEL           0                  0x0              
 * 0x010B[5:4]   OUT0_VDD_SEL           2                  0x2              
 * 0x010B[3]     OUT0_VDD_SEL_EN        1                  0x1              
 * 0x010B[7:6]   OUT0_INV               0                  0x0              
 * 0x010D[0]     OUT1_PDN               1                  0x1              
 * 0x010D[1]     OUT1_OE                0                  0x0              
 * 0x010D[2]     OUT1_RDIV_FORCE2       0                  0x0              
 * 0x010E[2:0]   OUT1_FORMAT            1                  0x1              
 * 0x010E[3]     OUT1_SYNC_EN           1                  0x1              
 * 0x010E[5:4]   OUT1_DIS_STATE         0                  0x0              
 * 0x010E[7:6]   OUT1_CMOS_DRV          0                  0x0              
 * 0x010F[3:0]   OUT1_CM                11                 0xB              
 * 0x010F[6:4]   OUT1_AMPL              3                  0x3              
 * 0x0110[2:0]   OUT1_MUX_SEL           0                  0x0              
 * 0x0110[5:4]   OUT1_VDD_SEL           2                  0x2              
 * 0x0110[3]     OUT1_VDD_SEL_EN        1                  0x1              
 * 0x0110[7:6]   OUT1_INV               0                  0x0              
 * 0x0112[0]     OUT2_PDN               0                  0x0              
 * 0x0112[1]     OUT2_OE                1                  0x1              
 * 0x0112[2]     OUT2_RDIV_FORCE2       0                  0x0              
 * 0x0113[2:0]   OUT2_FORMAT            1                  0x1              
 * 0x0113[3]     OUT2_SYNC_EN           1                  0x1              
 * 0x0113[5:4]   OUT2_DIS_STATE         0                  0x0              
 * 0x0113[7:6]   OUT2_CMOS_DRV          0                  0x0              
 * 0x0114[3:0]   OUT2_CM                11                 0xB              
 * 0x0114[6:4]   OUT2_AMPL              3                  0x3              
 * 0x0115[2:0]   OUT2_MUX_SEL           0                  0x0              
 * 0x0115[5:4]   OUT2_VDD_SEL           2                  0x2              
 * 0x0115[3]     OUT2_VDD_SEL_EN        1                  0x1              
 * 0x0115[7:6]   OUT2_INV               0                  0x0              
 * 0x0117[0]     OUT3_PDN               1                  0x1              
 * 0x0117[1]     OUT3_OE                0                  0x0              
 * 0x0117[2]     OUT3_RDIV_FORCE2       0                  0x0              
 * 0x0118[2:0]   OUT3_FORMAT            1                  0x1              
 * 0x0118[3]     OUT3_SYNC_EN           1                  0x1              
 * 0x0118[5:4]   OUT3_DIS_STATE         0                  0x0              
 * 0x0118[7:6]   OUT3_CMOS_DRV          0                  0x0              
 * 0x0119[3:0]   OUT3_CM                11                 0xB              
 * 0x0119[6:4]   OUT3_AMPL              3                  0x3              
 * 0x011A[2:0]   OUT3_MUX_SEL           0                  0x0              
 * 0x011A[5:4]   OUT3_VDD_SEL           2                  0x2              
 * 0x011A[3]     OUT3_VDD_SEL_EN        1                  0x1              
 * 0x011A[7:6]   OUT3_INV               0                  0x0              
 * 0x011C[0]     OUT4_PDN               1                  0x1              
 * 0x011C[1]     OUT4_OE                0                  0x0              
 * 0x011C[2]     OUT4_RDIV_FORCE2       0                  0x0              
 * 0x011D[2:0]   OUT4_FORMAT            1                  0x1              
 * 0x011D[3]     OUT4_SYNC_EN           1                  0x1              
 * 0x011D[5:4]   OUT4_DIS_STATE         0                  0x0              
 * 0x011D[7:6]   OUT4_CMOS_DRV          0                  0x0              
 * 0x011E[3:0]   OUT4_CM                11                 0xB              
 * 0x011E[6:4]   OUT4_AMPL              3                  0x3              
 * 0x011F[2:0]   OUT4_MUX_SEL           0                  0x0              
 * 0x011F[5:4]   OUT4_VDD_SEL           2                  0x2              
 * 0x011F[3]     OUT4_VDD_SEL_EN        1                  0x1              
 * 0x011F[7:6]   OUT4_INV               0                  0x0              
 * 0x0121[0]     OUT5_PDN               0                  0x0              
 * 0x0121[1]     OUT5_OE                1                  0x1              
 * 0x0121[2]     OUT5_RDIV_FORCE2       0                  0x0              
 * 0x0122[2:0]   OUT5_FORMAT            1                  0x1              
 * 0x0122[3]     OUT5_SYNC_EN           1                  0x1              
 * 0x0122[5:4]   OUT5_DIS_STATE         0                  0x0              
 * 0x0122[7:6]   OUT5_CMOS_DRV          0                  0x0              
 * 0x0123[3:0]   OUT5_CM                11                 0xB              
 * 0x0123[6:4]   OUT5_AMPL              3                  0x3              
 * 0x0124[2:0]   OUT5_MUX_SEL           1                  0x1              
 * 0x0124[5:4]   OUT5_VDD_SEL           2                  0x2              
 * 0x0124[3]     OUT5_VDD_SEL_EN        1                  0x1              
 * 0x0124[7:6]   OUT5_INV               0                  0x0              
 * 0x0126[0]     OUT6_PDN               1                  0x1              
 * 0x0126[1]     OUT6_OE                0                  0x0              
 * 0x0126[2]     OUT6_RDIV_FORCE2       0                  0x0              
 * 0x0127[2:0]   OUT6_FORMAT            1                  0x1              
 * 0x0127[3]     OUT6_SYNC_EN           1                  0x1              
 * 0x0127[5:4]   OUT6_DIS_STATE         0                  0x0              
 * 0x0127[7:6]   OUT6_CMOS_DRV          0                  0x0              
 * 0x0128[3:0]   OUT6_CM                11                 0xB              
 * 0x0128[6:4]   OUT6_AMPL              3                  0x3              
 * 0x0129[2:0]   OUT6_MUX_SEL           0                  0x0              
 * 0x0129[5:4]   OUT6_VDD_SEL           2                  0x2              
 * 0x0129[3]     OUT6_VDD_SEL_EN        1                  0x1              
 * 0x0129[7:6]   OUT6_INV               0                  0x0              
 * 0x012B[0]     OUT7_PDN               1                  0x1              
 * 0x012B[1]     OUT7_OE                0                  0x0              
 * 0x012B[2]     OUT7_RDIV_FORCE2       0                  0x0              
 * 0x012C[2:0]   OUT7_FORMAT            1                  0x1              
 * 0x012C[3]     OUT7_SYNC_EN           1                  0x1              
 * 0x012C[5:4]   OUT7_DIS_STATE         0                  0x0              
 * 0x012C[7:6]   OUT7_CMOS_DRV          0                  0x0              
 * 0x012D[3:0]   OUT7_CM                11                 0xB              
 * 0x012D[6:4]   OUT7_AMPL              3                  0x3              
 * 0x012E[2:0]   OUT7_MUX_SEL           0                  0x0              
 * 0x012E[5:4]   OUT7_VDD_SEL           2                  0x2              
 * 0x012E[3]     OUT7_VDD_SEL_EN        1                  0x1              
 * 0x012E[7:6]   OUT7_INV               0                  0x0              
 * 0x0130[0]     OUT8_PDN               0                  0x0              
 * 0x0130[1]     OUT8_OE                1                  0x1              
 * 0x0130[2]     OUT8_RDIV_FORCE2       0                  0x0              
 * 0x0131[2:0]   OUT8_FORMAT            1                  0x1              
 * 0x0131[3]     OUT8_SYNC_EN           1                  0x1              
 * 0x0131[5:4]   OUT8_DIS_STATE         0                  0x0              
 * 0x0131[7:6]   OUT8_CMOS_DRV          0                  0x0              
 * 0x0132[3:0]   OUT8_CM                11                 0xB              
 * 0x0132[6:4]   OUT8_AMPL              3                  0x3              
 * 0x0133[2:0]   OUT8_MUX_SEL           2                  0x2              
 * 0x0133[5:4]   OUT8_VDD_SEL           2                  0x2              
 * 0x0133[3]     OUT8_VDD_SEL_EN        1                  0x1              
 * 0x0133[7:6]   OUT8_INV               0                  0x0              
 * 0x013A[0]     OUT9_PDN               1                  0x1              
 * 0x013A[1]     OUT9_OE                0                  0x0              
 * 0x013A[2]     OUT9_RDIV_FORCE2       0                  0x0              
 * 0x013B[2:0]   OUT9_FORMAT            1                  0x1              
 * 0x013B[3]     OUT9_SYNC_EN           1                  0x1              
 * 0x013B[5:4]   OUT9_DIS_STATE         0                  0x0              
 * 0x013B[7:6]   OUT9_CMOS_DRV          0                  0x0              
 * 0x013C[3:0]   OUT9_CM                11                 0xB              
 * 0x013C[6:4]   OUT9_AMPL              3                  0x3              
 * 0x013D[2:0]   OUT9_MUX_SEL           0                  0x0              
 * 0x013D[5:4]   OUT9_VDD_SEL           2                  0x2              
 * 0x013D[3]     OUT9_VDD_SEL_EN        1                  0x1              
 * 0x013D[7:6]   OUT9_INV               0                  0x0              
 * 0x013F[11:0]  OUTX_ALWAYS_ON         0                  0x000            
 * 0x0141[1]     OUT_DIS_MSK            0                  0x0              
 * 0x0141[5]     OUT_DIS_LOL_MSK        0                  0x0              
 * 0x0141[6]     OUT_DIS_LOSXAXB_MSK    1                  0x1              
 * 0x0141[7]     OUT_DIS_MSK_LOS_PFD    0                  0x0              
 * 0x0142[1]     OUT_DIS_MSK_LOL        1                  0x1              
 * 0x0142[5]     OUT_DIS_MSK_HOLD       1                  0x1              
 * 0x0206[1:0]   PXAXB                  0                  0x0              
 * 0x0208[47:0]  P0_NUM                 1                  0x000000000001   
 * 0x020E[31:0]  P0_DEN                 1                  0x00000001       
 * 0x0212[47:0]  P1_NUM                 0                  0x000000000000   
 * 0x0218[31:0]  P1_DEN                 0                  0x00000000       
 * 0x021C[47:0]  P2_NUM                 0                  0x000000000000   
 * 0x0222[31:0]  P2_DEN                 0                  0x00000000       
 * 0x0226[47:0]  P3_NUM                 0                  0x000000000000   
 * 0x022C[31:0]  P3_DEN                 0                  0x00000000       
 * 0x0231[3:0]   P0_FRACN_MODE          11                 0xB              
 * 0x0231[4]     P0_FRACN_EN            0                  0x0              
 * 0x0232[3:0]   P1_FRACN_MODE          11                 0xB              
 * 0x0232[4]     P1_FRACN_EN            0                  0x0              
 * 0x0233[3:0]   P2_FRACN_MODE          11                 0xB              
 * 0x0233[4]     P2_FRACN_EN            0                  0x0              
 * 0x0234[3:0]   P3_FRACN_MODE          11                 0xB              
 * 0x0234[4]     P3_FRACN_EN            0                  0x0              
 * 0x0235[43:0]  MXAXB_NUM              916841299968       0x0D578000000    
 * 0x023B[31:0]  MXAXB_DEN              3489660928         0xD0000000       
 * 0x024A[23:0]  R0_REG                 10                 0x00000A         
 * 0x024D[23:0]  R1_REG                 0                  0x000000         
 * 0x0250[23:0]  R2_REG                 1                  0x000001         
 * 0x0253[23:0]  R3_REG                 0                  0x000000         
 * 0x0256[23:0]  R4_REG                 0                  0x000000         
 * 0x0259[23:0]  R5_REG                 2                  0x000002         
 * 0x025C[23:0]  R6_REG                 0                  0x000000         
 * 0x025F[23:0]  R7_REG                 0                  0x000000         
 * 0x0262[23:0]  R8_REG                 2                  0x000002         
 * 0x0268[23:0]  R9_REG                 0                  0x000000         
 * 0x026B[7:0]   DESIGN_ID0             73                 0x49             
 * 0x026C[7:0]   DESIGN_ID1             79                 0x4F             
 * 0x026D[7:0]   DESIGN_ID2             52                 0x34             
 * 0x026E[7:0]   DESIGN_ID3             75                 0x4B             
 * 0x026F[7:0]   DESIGN_ID4             43                 0x2B             
 * 0x0270[7:0]   DESIGN_ID5             0                  0x00             
 * 0x0271[7:0]   DESIGN_ID6             0                  0x00             
 * 0x0272[7:0]   DESIGN_ID7             0                  0x00             
 * 0x0294[7:4]   FASTLOCK_EXTEND_SCL    8                  0x8              
 * 0x0296[1]     LOL_SLW_VALWIN_SELX    0                  0x0              
 * 0x0297[1]     FASTLOCK_DLY_ONSW_EN   1                  0x1              
 * 0x0299[1]     FASTLOCK_DLY_ONLOL_EN  1                  0x1              
 * 0x029D[19:0]  FASTLOCK_DLY_ONLOL     3829               0x00EF5          
 * 0x02A9[19:0]  FASTLOCK_DLY_ONSW      9830               0x02666          
 * 0x02B7[3:2]   LOL_NOSIG_TIME         3                  0x3              
 * 0x0302[43:0]  N0_NUM                 49392123904        0x00B80000000    
 * 0x0308[31:0]  N0_DEN                 2147483648         0x80000000       
 * 0x030C[0]     N0_UPDATE              0                  0x0              
 * 0x030D[43:0]  N1_NUM                 198967296000       0x02E53600000    
 * 0x0313[31:0]  N1_DEN                 2147483648         0x80000000       
 * 0x0317[0]     N1_UPDATE              0                  0x0              
 * 0x0318[43:0]  N2_NUM                 48282730496        0x00B3DE00000    
 * 0x031E[31:0]  N2_DEN                 3145728000         0xBB800000       
 * 0x0322[0]     N2_UPDATE              0                  0x0              
 * 0x0323[43:0]  N3_NUM                 0                  0x00000000000    
 * 0x0329[31:0]  N3_DEN                 0                  0x00000000       
 * 0x032D[0]     N3_UPDATE              0                  0x0              
 * 0x032E[43:0]  N4_NUM                 0                  0x00000000000    
 * 0x0334[31:0]  N4_DEN                 0                  0x00000000       
 * 0x0338[0]     N4_UPDATE              0                  0x0              
 * 0x0338[1]     N_UPDATE               0                  0x0              
 * 0x0339[4:0]   N_FSTEP_MSK            31                 0x1F             
 * 0x033B[43:0]  N0_FSTEPW              0                  0x00000000000    
 * 0x0341[43:0]  N1_FSTEPW              0                  0x00000000000    
 * 0x0347[43:0]  N2_FSTEPW              0                  0x00000000000    
 * 0x034D[43:0]  N3_FSTEPW              0                  0x00000000000    
 * 0x0353[43:0]  N4_FSTEPW              0                  0x00000000000    
 * 0x0359[15:0]  N0_DELAY               0                  0x0000           
 * 0x035B[15:0]  N1_DELAY               0                  0x0000           
 * 0x035D[15:0]  N2_DELAY               0                  0x0000           
 * 0x035F[15:0]  N3_DELAY               0                  0x0000           
 * 0x0361[15:0]  N4_DELAY               0                  0x0000           
 * 0x0487[0]     ZDM_EN                 0                  0x0              
 * 0x0487[2:1]   ZDM_IN_SEL             0                  0x0              
 * 0x0487[4]     ZDM_AUTOSW_EN          0                  0x0              
 * 0x0502[4]     ADD_DIV256             0                  0x0              
 * 0x0508[5:0]   BW0_PLL                16                 0x10             
 * 0x0509[5:0]   BW1_PLL                24                 0x18             
 * 0x050A[5:0]   BW2_PLL                15                 0x0F             
 * 0x050B[5:0]   BW3_PLL                15                 0x0F             
 * 0x050C[5:0]   BW4_PLL                1                  0x01             
 * 0x050D[5:0]   BW5_PLL                7                  0x07             
 * 0x050E[5:0]   FASTLOCK_BW0_PLL       23                 0x17             
 * 0x050F[5:0]   FASTLOCK_BW1_PLL       40                 0x28             
 * 0x0510[5:0]   FASTLOCK_BW2_PLL       12                 0x0C             
 * 0x0511[5:0]   FASTLOCK_BW3_PLL       11                 0x0B             
 * 0x0512[5:0]   FASTLOCK_BW4_PLL       1                  0x01             
 * 0x0513[5:0]   FASTLOCK_BW5_PLL       7                  0x07             
 * 0x0515[55:0]  M_NUM                  104316165685248    0x005EE000000000 
 * 0x051C[31:0]  M_DEN                  2147483648         0x80000000       
 * 0x0521[3:0]   M_FRAC_MODE            11                 0xB              
 * 0x0521[4]     M_FRAC_EN              0                  0x0              
 * 0x0521[5]     PLL_OUT_RATE_SEL       1                  0x1              
 * 0x052A[0]     IN_SEL_REGCTRL         1                  0x1              
 * 0x052A[3:1]   IN_SEL                 0                  0x0              
 * 0x052B[0]     FASTLOCK_AUTO_EN       1                  0x1              
 * 0x052B[1]     FASTLOCK_MAN           0                  0x0              
 * 0x052C[0]     HOLD_EN                1                  0x1              
 * 0x052C[3]     HOLD_RAMP_BYP          1                  0x1              
 * 0x052C[4]     HOLDEXIT_BW_SEL1       0                  0x0              
 * 0x052C[7:5]   RAMP_STEP_INTERVAL     0                  0x0              
 * 0x052D[1]     HOLD_RAMPBYP_NOHIST    1                  0x1              
 * 0x052E[4:0]   HOLD_HIST_LEN          21                 0x15             
 * 0x052F[4:0]   HOLD_HIST_DELAY        20                 0x14             
 * 0x0531[4:0]   HOLD_REF_COUNT_FRC     0                  0x00             
 * 0x0532[23:0]  HOLD_15M_CYC_COUNT     29630              0x0073BE         
 * 0x0535[0]     FORCE_HOLD             0                  0x0              
 * 0x0536[1:0]   CLK_SWITCH_MODE        0                  0x0              
 * 0x0536[2]     HSW_EN                 0                  0x0              
 * 0x0537[3:0]   IN_LOS_MSK             0                  0x0              
 * 0x0537[7:4]   IN_OOF_MSK             0                  0x0              
 * 0x0538[2:0]   IN0_PRIORITY           0                  0x0              
 * 0x0538[6:4]   IN1_PRIORITY           0                  0x0              
 * 0x0539[2:0]   IN2_PRIORITY           0                  0x0              
 * 0x0539[6:4]   IN3_PRIORITY           0                  0x0              
 * 0x053A[1:0]   HSW_MODE               2                  0x2              
 * 0x053A[3:2]   HSW_PHMEAS_CTRL        0                  0x0              
 * 0x053B[9:0]   HSW_PHMEAS_THR         3                  0x003            
 * 0x053D[4:0]   HSW_COARSE_PM_LEN      19                 0x13             
 * 0x053E[4:0]   HSW_COARSE_PM_DLY      6                  0x06             
 * 0x0589[12:0]  CAP_SHORT_DELAY        483                0x01E3           
 * 0x059B[4]     HOLD_PRESERVE_HIST     1                  0x1              
 * 0x059B[5]     HOLD_FRZ_WITH_INTONLY  1                  0x1              
 * 0x059B[6]     HOLDEXIT_BW_SEL0       1                  0x1              
 * 0x059B[7]     HOLDEXIT_STD_BO        1                  0x1              
 * 0x059D[5:0]   HOLDEXIT_BW0           23                 0x17             
 * 0x059E[5:0]   HOLDEXIT_BW1           40                 0x28             
 * 0x059F[5:0]   HOLDEXIT_BW2           12                 0x0C             
 * 0x05A0[5:0]   HOLDEXIT_BW3           11                 0x0B             
 * 0x05A1[5:0]   HOLDEXIT_BW4           1                  0x01             
 * 0x05A2[5:0]   HOLDEXIT_BW5           7                  0x07             
 * 0x05A6[2:0]   RAMP_STEP_SIZE         0                  0x0              
 * 0x05A6[3]     RAMP_SWITCH_EN         0                  0x0              
 * 0x0802[15:0]  FIXREGSA0              1333               0x0535           
 * 0x0804[7:0]   FIXREGSD0              0                  0x00             
 * 0x0805[15:0]  FIXREGSA1              0                  0x0000           
 * 0x0807[7:0]   FIXREGSD1              0                  0x00             
 * 0x0808[15:0]  FIXREGSA2              0                  0x0000           
 * 0x080A[7:0]   FIXREGSD2              0                  0x00             
 * 0x080B[15:0]  FIXREGSA3              0                  0x0000           
 * 0x080D[7:0]   FIXREGSD3              0                  0x00             
 * 0x080E[15:0]  FIXREGSA4              0                  0x0000           
 * 0x0810[7:0]   FIXREGSD4              0                  0x00             
 * 0x0811[15:0]  FIXREGSA5              0                  0x0000           
 * 0x0813[7:0]   FIXREGSD5              0                  0x00             
 * 0x0814[15:0]  FIXREGSA6              0                  0x0000           
 * 0x0816[7:0]   FIXREGSD6              0                  0x00             
 * 0x0817[15:0]  FIXREGSA7              0                  0x0000           
 * 0x0819[7:0]   FIXREGSD7              0                  0x00             
 * 0x081A[15:0]  FIXREGSA8              0                  0x0000           
 * 0x081C[7:0]   FIXREGSD8              0                  0x00             
 * 0x081D[15:0]  FIXREGSA9              0                  0x0000           
 * 0x081F[7:0]   FIXREGSD9              0                  0x00             
 * 0x0820[15:0]  FIXREGSA10             0                  0x0000           
 * 0x0822[7:0]   FIXREGSD10             0                  0x00             
 * 0x0823[15:0]  FIXREGSA11             0                  0x0000           
 * 0x0825[7:0]   FIXREGSD11             0                  0x00             
 * 0x0826[15:0]  FIXREGSA12             0                  0x0000           
 * 0x0828[7:0]   FIXREGSD12             0                  0x00             
 * 0x0829[15:0]  FIXREGSA13             0                  0x0000           
 * 0x082B[7:0]   FIXREGSD13             0                  0x00             
 * 0x082C[15:0]  FIXREGSA14             0                  0x0000           
 * 0x082E[7:0]   FIXREGSD14             0                  0x00             
 * 0x082F[15:0]  FIXREGSA15             0                  0x0000           
 * 0x0831[7:0]   FIXREGSD15             0                  0x00             
 * 0x0832[15:0]  FIXREGSA16             0                  0x0000           
 * 0x0834[7:0]   FIXREGSD16             0                  0x00             
 * 0x0835[15:0]  FIXREGSA17             0                  0x0000           
 * 0x0837[7:0]   FIXREGSD17             0                  0x00             
 * 0x0838[15:0]  FIXREGSA18             0                  0x0000           
 * 0x083A[7:0]   FIXREGSD18             0                  0x00             
 * 0x083B[15:0]  FIXREGSA19             0                  0x0000           
 * 0x083D[7:0]   FIXREGSD19             0                  0x00             
 * 0x083E[15:0]  FIXREGSA20             0                  0x0000           
 * 0x0840[7:0]   FIXREGSD20             0                  0x00             
 * 0x0841[15:0]  FIXREGSA21             0                  0x0000           
 * 0x0843[7:0]   FIXREGSD21             0                  0x00             
 * 0x0844[15:0]  FIXREGSA22             0                  0x0000           
 * 0x0846[7:0]   FIXREGSD22             0                  0x00             
 * 0x0847[15:0]  FIXREGSA23             0                  0x0000           
 * 0x0849[7:0]   FIXREGSD23             0                  0x00             
 * 0x084A[15:0]  FIXREGSA24             0                  0x0000           
 * 0x084C[7:0]   FIXREGSD24             0                  0x00             
 * 0x084D[15:0]  FIXREGSA25             0                  0x0000           
 * 0x084F[7:0]   FIXREGSD25             0                  0x00             
 * 0x0850[15:0]  FIXREGSA26             0                  0x0000           
 * 0x0852[7:0]   FIXREGSD26             0                  0x00             
 * 0x0853[15:0]  FIXREGSA27             0                  0x0000           
 * 0x0855[7:0]   FIXREGSD27             0                  0x00             
 * 0x0856[15:0]  FIXREGSA28             0                  0x0000           
 * 0x0858[7:0]   FIXREGSD28             0                  0x00             
 * 0x0859[15:0]  FIXREGSA29             0                  0x0000           
 * 0x085B[7:0]   FIXREGSD29             0                  0x00             
 * 0x085C[15:0]  FIXREGSA30             0                  0x0000           
 * 0x085E[7:0]   FIXREGSD30             0                  0x00             
 * 0x085F[15:0]  FIXREGSA31             0                  0x0000           
 * 0x0861[7:0]   FIXREGSD31             0                  0x00             
 * 0x090E[0]     XAXB_EXTCLK_EN         1                  0x1              
 * 0x0943[0]     IO_VDD_SEL             0                  0x0              
 * 0x0949[3:0]   IN_EN                  1                  0x1              
 * 0x0949[7:4]   IN_PULSED_CMOS_EN      3                  0x3              
 * 0x094A[3:0]   INX_TO_PFD_EN          1                  0x1              
 * 0x094E[11:0]  REFCLK_HYS_SEL         585                0x249            
 * 0x095E[0]     MXAXB_INTEGER          0                  0x0              
 * 0x0A02[4:0]   N_ADD_0P5              0                  0x00             
 * 0x0A03[4:0]   N_CLK_TO_OUTX_EN       7                  0x07             
 * 0x0A04[4:0]   N_PIBYP                1                  0x01             
 * 0x0A05[4:0]   N_PDNB                 7                  0x07             
 * 0x0A14[3]     N0_HIGH_FREQ           0                  0x0              
 * 0x0A1A[3]     N1_HIGH_FREQ           0                  0x0              
 * 0x0A20[3]     N2_HIGH_FREQ           0                  0x0              
 * 0x0A26[3]     N3_HIGH_FREQ           0                  0x0              
 * 0x0A2C[3]     N4_HIGH_FREQ           0                  0x0              
 * 0x0B44[3:0]   PDIV_FRACN_CLK_DIS     15                 0xF              
 * 0x0B44[5]     FRACN_CLK_DIS_PLL      1                  0x1              
 * 0x0B46[3:0]   LOS_CLK_DIS            0                  0x0              
 * 0x0B47[4:0]   OOF_CLK_DIS            14                 0x0E             
 * 0x0B48[4:0]   OOF_DIV_CLK_DIS        14                 0x0E             
 * 0x0B4A[4:0]   N_CLK_DIS              24                 0x18             
 * 0x0B57[11:0]  VCO_RESET_CALCODE      249                0x0F9
 * 
 *
 */


static struct ntv2_genlock_data s_genlock_1125_5994[] =
{
	/* Start configuration preamble */
	{ 0x0B24, 0xC0 },
	{ 0x0B25, 0x00 },
	{ 0x0540, 0x01 },
	/* End configuration preamble */

	/* Delay 300 msec */
	/*    Delay is worst case time for device to complete any calibration */
	/*    that is running due to device state change previous to this script */
	/*    being processed. */
	{ 0x0000, 0x01 },

	/* Start configuration registers */
	{ 0x000B, 0x64 },
	{ 0x0016, 0x02 },
	{ 0x0017, 0xFC },
	{ 0x0018, 0xFF },
	{ 0x0019, 0xDF },
	{ 0x001A, 0xDF },
	{ 0x002B, 0x02 },
	{ 0x002C, 0x01 },
	{ 0x002D, 0x02 },
	{ 0x002E, 0xCD },
	{ 0x002F, 0x03 },
	{ 0x0030, 0x00 },
	{ 0x0031, 0x00 },
	{ 0x0032, 0x00 },
	{ 0x0033, 0x00 },
	{ 0x0034, 0x00 },
	{ 0x0035, 0x00 },
	{ 0x0036, 0x7C },
	{ 0x0037, 0x03 },
	{ 0x0038, 0x00 },
	{ 0x0039, 0x00 },
	{ 0x003A, 0x00 },
	{ 0x003B, 0x00 },
	{ 0x003C, 0x00 },
	{ 0x003D, 0x00 },
	{ 0x003F, 0x01 },
	{ 0x0040, 0x04 },
	{ 0x0041, 0x03 },
	{ 0x0042, 0x00 },
	{ 0x0043, 0x00 },
	{ 0x0044, 0x00 },
	{ 0x0045, 0x0C },
	{ 0x0046, 0x96 },
	{ 0x0047, 0x00 },
	{ 0x0048, 0x00 },
	{ 0x0049, 0x00 },
	{ 0x004A, 0x4B },
	{ 0x004B, 0x00 },
	{ 0x004C, 0x00 },
	{ 0x004D, 0x00 },
	{ 0x004E, 0x05 },
	{ 0x004F, 0x00 },
	{ 0x0050, 0x0F },
	{ 0x0051, 0x00 },
	{ 0x0052, 0x00 },
	{ 0x0053, 0x00 },
	{ 0x0054, 0x00 },
	{ 0x0055, 0x00 },
	{ 0x0056, 0x00 },
	{ 0x0057, 0x00 },
	{ 0x0058, 0x00 },
	{ 0x0059, 0x01 },
	{ 0x005A, 0xB8 },
	{ 0x005B, 0xF8 },
	{ 0x005C, 0xA9 },
	{ 0x005D, 0x00 },
	{ 0x005E, 0x00 },
	{ 0x005F, 0x00 },
	{ 0x0060, 0x00 },
	{ 0x0061, 0x00 },
	{ 0x0062, 0x00 },
	{ 0x0063, 0x00 },
	{ 0x0064, 0x00 },
	{ 0x0065, 0x00 },
	{ 0x0066, 0x00 },
	{ 0x0067, 0x00 },
	{ 0x0068, 0x00 },
	{ 0x0069, 0x00 },
	{ 0x0092, 0x02 },
	{ 0x0093, 0xA0 },
	{ 0x0095, 0x00 },
	{ 0x0096, 0x90 },
	{ 0x0098, 0x70 },
	{ 0x009A, 0x02 },
	{ 0x009B, 0x50 },
	{ 0x009D, 0x04 },
	{ 0x009E, 0x60 },
	{ 0x00A0, 0x30 },
	{ 0x00A2, 0x00 },
	{ 0x00A9, 0xB9 },
	{ 0x00AA, 0x7D },
	{ 0x00AB, 0x04 },
	{ 0x00AC, 0x00 },
	{ 0x00E5, 0x21 },
	{ 0x00EA, 0xD1 },
	{ 0x00EB, 0xB1 },
	{ 0x00EC, 0x03 },
	{ 0x00ED, 0x00 },
	{ 0x0102, 0x01 },
	{ 0x0108, 0x02 },
	{ 0x0109, 0x09 },
	{ 0x010A, 0x3B },
	{ 0x010B, 0x28 },
	{ 0x010D, 0x01 },
	{ 0x010E, 0x09 },
	{ 0x010F, 0x3B },
	{ 0x0110, 0x28 },
	{ 0x0112, 0x02 },
	{ 0x0113, 0x09 },
	{ 0x0114, 0x3B },
	{ 0x0115, 0x28 },
	{ 0x0117, 0x01 },
	{ 0x0118, 0x09 },
	{ 0x0119, 0x3B },
	{ 0x011A, 0x28 },
	{ 0x011C, 0x01 },
	{ 0x011D, 0x09 },
	{ 0x011E, 0x3B },
	{ 0x011F, 0x28 },
	{ 0x0121, 0x02 },
	{ 0x0122, 0x09 },
	{ 0x0123, 0x3B },
	{ 0x0124, 0x29 },
	{ 0x0126, 0x01 },
	{ 0x0127, 0x09 },
	{ 0x0128, 0x3B },
	{ 0x0129, 0x28 },
	{ 0x012B, 0x01 },
	{ 0x012C, 0x09 },
	{ 0x012D, 0x3B },
	{ 0x012E, 0x28 },
	{ 0x0130, 0x02 },
	{ 0x0131, 0x09 },
	{ 0x0132, 0x3B },
	{ 0x0133, 0x2A },
	{ 0x013A, 0x01 },
	{ 0x013B, 0x09 },
	{ 0x013C, 0x3B },
	{ 0x013D, 0x28 },
	{ 0x013F, 0x00 },
	{ 0x0140, 0x00 },
	{ 0x0141, 0x40 },
	{ 0x0142, 0xFF },
	{ 0x0206, 0x00 },
	{ 0x0208, 0x01 },
	{ 0x0209, 0x00 },
	{ 0x020A, 0x00 },
	{ 0x020B, 0x00 },
	{ 0x020C, 0x00 },
	{ 0x020D, 0x00 },
	{ 0x020E, 0x01 },
	{ 0x020F, 0x00 },
	{ 0x0210, 0x00 },
	{ 0x0211, 0x00 },
	{ 0x0212, 0x00 },
	{ 0x0213, 0x00 },
	{ 0x0214, 0x00 },
	{ 0x0215, 0x00 },
	{ 0x0216, 0x00 },
	{ 0x0217, 0x00 },
	{ 0x0218, 0x00 },
	{ 0x0219, 0x00 },
	{ 0x021A, 0x00 },
	{ 0x021B, 0x00 },
	{ 0x021C, 0x00 },
	{ 0x021D, 0x00 },
	{ 0x021E, 0x00 },
	{ 0x021F, 0x00 },
	{ 0x0220, 0x00 },
	{ 0x0221, 0x00 },
	{ 0x0222, 0x00 },
	{ 0x0223, 0x00 },
	{ 0x0224, 0x00 },
	{ 0x0225, 0x00 },
	{ 0x0226, 0x00 },
	{ 0x0227, 0x00 },
	{ 0x0228, 0x00 },
	{ 0x0229, 0x00 },
	{ 0x022A, 0x00 },
	{ 0x022B, 0x00 },
	{ 0x022C, 0x00 },
	{ 0x022D, 0x00 },
	{ 0x022E, 0x00 },
	{ 0x022F, 0x00 },
	{ 0x0231, 0x0B },
	{ 0x0232, 0x0B },
	{ 0x0233, 0x0B },
	{ 0x0234, 0x0B },
	{ 0x0235, 0x00 },
	{ 0x0236, 0x00 },
	{ 0x0237, 0x00 },
	{ 0x0238, 0x78 },
	{ 0x0239, 0xD5 },
	{ 0x023A, 0x00 },
	{ 0x023B, 0x00 },
	{ 0x023C, 0x00 },
	{ 0x023D, 0x00 },
	{ 0x023E, 0xD0 },
	{ 0x024A, 0x0A },
	{ 0x024B, 0x00 },
	{ 0x024C, 0x00 },
	{ 0x024D, 0x00 },
	{ 0x024E, 0x00 },
	{ 0x024F, 0x00 },
	{ 0x0250, 0x01 },
	{ 0x0251, 0x00 },
	{ 0x0252, 0x00 },
	{ 0x0253, 0x00 },
	{ 0x0254, 0x00 },
	{ 0x0255, 0x00 },
	{ 0x0256, 0x00 },
	{ 0x0257, 0x00 },
	{ 0x0258, 0x00 },
	{ 0x0259, 0x02 },
	{ 0x025A, 0x00 },
	{ 0x025B, 0x00 },
	{ 0x025C, 0x00 },
	{ 0x025D, 0x00 },
	{ 0x025E, 0x00 },
	{ 0x025F, 0x00 },
	{ 0x0260, 0x00 },
	{ 0x0261, 0x00 },
	{ 0x0262, 0x02 },
	{ 0x0263, 0x00 },
	{ 0x0264, 0x00 },
	{ 0x0268, 0x00 },
	{ 0x0269, 0x00 },
	{ 0x026A, 0x00 },
	{ 0x026B, 0x49 },
	{ 0x026C, 0x4F },
	{ 0x026D, 0x34 },
	{ 0x026E, 0x4B },
	{ 0x026F, 0x2B },
	{ 0x0270, 0x00 },
	{ 0x0271, 0x00 },
	{ 0x0272, 0x00 },
	{ 0x0294, 0x80 },
	{ 0x0296, 0x00 },
	{ 0x0297, 0x02 },
	{ 0x0299, 0x02 },
	{ 0x029D, 0xF5 },
	{ 0x029E, 0x0E },
	{ 0x029F, 0x00 },
	{ 0x02A9, 0x66 },
	{ 0x02AA, 0x26 },
	{ 0x02AB, 0x00 },
	{ 0x02B7, 0xFF },
	{ 0x0302, 0x00 },
	{ 0x0303, 0x00 },
	{ 0x0304, 0x00 },
	{ 0x0305, 0x80 },
	{ 0x0306, 0x0B },
	{ 0x0307, 0x00 },
	{ 0x0308, 0x00 },
	{ 0x0309, 0x00 },
	{ 0x030A, 0x00 },
	{ 0x030B, 0x80 },
	{ 0x030C, 0x00 },
	{ 0x030D, 0x00 },
	{ 0x030E, 0x00 },
	{ 0x030F, 0x60 },
	{ 0x0310, 0x53 },
	{ 0x0311, 0x2E },
	{ 0x0312, 0x00 },
	{ 0x0313, 0x00 },
	{ 0x0314, 0x00 },
	{ 0x0315, 0x00 },
	{ 0x0316, 0x80 },
	{ 0x0317, 0x00 },
	{ 0x0318, 0x00 },
	{ 0x0319, 0x00 },
	{ 0x031A, 0xE0 },
	{ 0x031B, 0x3D },
	{ 0x031C, 0x0B },
	{ 0x031D, 0x00 },
	{ 0x031E, 0x00 },
	{ 0x031F, 0x00 },
	{ 0x0320, 0x80 },
	{ 0x0321, 0xBB },
	{ 0x0322, 0x00 },
	{ 0x0323, 0x00 },
	{ 0x0324, 0x00 },
	{ 0x0325, 0x00 },
	{ 0x0326, 0x00 },
	{ 0x0327, 0x00 },
	{ 0x0328, 0x00 },
	{ 0x0329, 0x00 },
	{ 0x032A, 0x00 },
	{ 0x032B, 0x00 },
	{ 0x032C, 0x00 },
	{ 0x032D, 0x00 },
	{ 0x032E, 0x00 },
	{ 0x032F, 0x00 },
	{ 0x0330, 0x00 },
	{ 0x0331, 0x00 },
	{ 0x0332, 0x00 },
	{ 0x0333, 0x00 },
	{ 0x0334, 0x00 },
	{ 0x0335, 0x00 },
	{ 0x0336, 0x00 },
	{ 0x0337, 0x00 },
	{ 0x0338, 0x00 },
	{ 0x0339, 0x1F },
	{ 0x033B, 0x00 },
	{ 0x033C, 0x00 },
	{ 0x033D, 0x00 },
	{ 0x033E, 0x00 },
	{ 0x033F, 0x00 },
	{ 0x0340, 0x00 },
	{ 0x0341, 0x00 },
	{ 0x0342, 0x00 },
	{ 0x0343, 0x00 },
	{ 0x0344, 0x00 },
	{ 0x0345, 0x00 },
	{ 0x0346, 0x00 },
	{ 0x0347, 0x00 },
	{ 0x0348, 0x00 },
	{ 0x0349, 0x00 },
	{ 0x034A, 0x00 },
	{ 0x034B, 0x00 },
	{ 0x034C, 0x00 },
	{ 0x034D, 0x00 },
	{ 0x034E, 0x00 },
	{ 0x034F, 0x00 },
	{ 0x0350, 0x00 },
	{ 0x0351, 0x00 },
	{ 0x0352, 0x00 },
	{ 0x0353, 0x00 },
	{ 0x0354, 0x00 },
	{ 0x0355, 0x00 },
	{ 0x0356, 0x00 },
	{ 0x0357, 0x00 },
	{ 0x0358, 0x00 },
	{ 0x0359, 0x00 },
	{ 0x035A, 0x00 },
	{ 0x035B, 0x00 },
	{ 0x035C, 0x00 },
	{ 0x035D, 0x00 },
	{ 0x035E, 0x00 },
	{ 0x035F, 0x00 },
	{ 0x0360, 0x00 },
	{ 0x0361, 0x00 },
	{ 0x0362, 0x00 },
	{ 0x0487, 0x00 },
	{ 0x0502, 0x01 },
	{ 0x0508, 0x11 },
	{ 0x0509, 0x19 },
	{ 0x050A, 0x0F },
	{ 0x050B, 0x0F },
	{ 0x050C, 0x01 },
	{ 0x050D, 0x0F },
	{ 0x050E, 0x18 },
	{ 0x050F, 0x29 },
	{ 0x0510, 0x0C },
	{ 0x0511, 0x0B },
	{ 0x0512, 0x01 },
	{ 0x0513, 0x0F },
	{ 0x0515, 0x00 },
	{ 0x0516, 0x00 },
	{ 0x0517, 0x00 },
	{ 0x0518, 0xA0 },
	{ 0x0519, 0xA8 },
	{ 0x051A, 0x7B },
	{ 0x051B, 0x00 },
	{ 0x051C, 0x00 },
	{ 0x051D, 0x00 },
	{ 0x051E, 0x00 },
	{ 0x051F, 0xC8 },
	{ 0x0521, 0x3B },
	{ 0x052A, 0x01 },
	{ 0x052B, 0x01 },
	{ 0x052C, 0x0F },
	{ 0x052D, 0x03 },
	{ 0x052E, 0x15 },
	{ 0x052F, 0x14 },
	{ 0x0531, 0x00 },
	{ 0x0532, 0x8D },
	{ 0x0533, 0x60 },
	{ 0x0534, 0x00 },
	{ 0x0535, 0x00 },
	{ 0x0536, 0x00 },
	{ 0x0537, 0x00 },
	{ 0x0538, 0x00 },
	{ 0x0539, 0x00 },
	{ 0x053A, 0x02 },
	{ 0x053B, 0x03 },
	{ 0x053C, 0x00 },
	{ 0x053D, 0x13 },
	{ 0x053E, 0x06 },
	{ 0x0589, 0x92 },
	{ 0x058A, 0x01 },
	{ 0x059B, 0xF8 },
	{ 0x059D, 0x18 },
	{ 0x059E, 0x29 },
	{ 0x059F, 0x0C },
	{ 0x05A0, 0x0B },
	{ 0x05A1, 0x01 },
	{ 0x05A2, 0x0F },
	{ 0x05A6, 0x00 },
	{ 0x0802, 0x35 },
	{ 0x0803, 0x05 },
	{ 0x0804, 0x00 },
	{ 0x0805, 0x00 },
	{ 0x0806, 0x00 },
	{ 0x0807, 0x00 },
	{ 0x0808, 0x00 },
	{ 0x0809, 0x00 },
	{ 0x080A, 0x00 },
	{ 0x080B, 0x00 },
	{ 0x080C, 0x00 },
	{ 0x080D, 0x00 },
	{ 0x080E, 0x00 },
	{ 0x080F, 0x00 },
	{ 0x0810, 0x00 },
	{ 0x0811, 0x00 },
	{ 0x0812, 0x00 },
	{ 0x0813, 0x00 },
	{ 0x0814, 0x00 },
	{ 0x0815, 0x00 },
	{ 0x0816, 0x00 },
	{ 0x0817, 0x00 },
	{ 0x0818, 0x00 },
	{ 0x0819, 0x00 },
	{ 0x081A, 0x00 },
	{ 0x081B, 0x00 },
	{ 0x081C, 0x00 },
	{ 0x081D, 0x00 },
	{ 0x081E, 0x00 },
	{ 0x081F, 0x00 },
	{ 0x0820, 0x00 },
	{ 0x0821, 0x00 },
	{ 0x0822, 0x00 },
	{ 0x0823, 0x00 },
	{ 0x0824, 0x00 },
	{ 0x0825, 0x00 },
	{ 0x0826, 0x00 },
	{ 0x0827, 0x00 },
	{ 0x0828, 0x00 },
	{ 0x0829, 0x00 },
	{ 0x082A, 0x00 },
	{ 0x082B, 0x00 },
	{ 0x082C, 0x00 },
	{ 0x082D, 0x00 },
	{ 0x082E, 0x00 },
	{ 0x082F, 0x00 },
	{ 0x0830, 0x00 },
	{ 0x0831, 0x00 },
	{ 0x0832, 0x00 },
	{ 0x0833, 0x00 },
	{ 0x0834, 0x00 },
	{ 0x0835, 0x00 },
	{ 0x0836, 0x00 },
	{ 0x0837, 0x00 },
	{ 0x0838, 0x00 },
	{ 0x0839, 0x00 },
	{ 0x083A, 0x00 },
	{ 0x083B, 0x00 },
	{ 0x083C, 0x00 },
	{ 0x083D, 0x00 },
	{ 0x083E, 0x00 },
	{ 0x083F, 0x00 },
	{ 0x0840, 0x00 },
	{ 0x0841, 0x00 },
	{ 0x0842, 0x00 },
	{ 0x0843, 0x00 },
	{ 0x0844, 0x00 },
	{ 0x0845, 0x00 },
	{ 0x0846, 0x00 },
	{ 0x0847, 0x00 },
	{ 0x0848, 0x00 },
	{ 0x0849, 0x00 },
	{ 0x084A, 0x00 },
	{ 0x084B, 0x00 },
	{ 0x084C, 0x00 },
	{ 0x084D, 0x00 },
	{ 0x084E, 0x00 },
	{ 0x084F, 0x00 },
	{ 0x0850, 0x00 },
	{ 0x0851, 0x00 },
	{ 0x0852, 0x00 },
	{ 0x0853, 0x00 },
	{ 0x0854, 0x00 },
	{ 0x0855, 0x00 },
	{ 0x0856, 0x00 },
	{ 0x0857, 0x00 },
	{ 0x0858, 0x00 },
	{ 0x0859, 0x00 },
	{ 0x085A, 0x00 },
	{ 0x085B, 0x00 },
	{ 0x085C, 0x00 },
	{ 0x085D, 0x00 },
	{ 0x085E, 0x00 },
	{ 0x085F, 0x00 },
	{ 0x0860, 0x00 },
	{ 0x0861, 0x00 },
	{ 0x090E, 0x03 },
	{ 0x0943, 0x00 },
	{ 0x0949, 0x31 },
	{ 0x094A, 0x01 },
	{ 0x094E, 0x49 },
	{ 0x094F, 0x02 },
	{ 0x095E, 0x00 },
	{ 0x0A02, 0x00 },
	{ 0x0A03, 0x07 },
	{ 0x0A04, 0x01 },
	{ 0x0A05, 0x07 },
	{ 0x0A14, 0x00 },
	{ 0x0A1A, 0x00 },
	{ 0x0A20, 0x00 },
	{ 0x0A26, 0x00 },
	{ 0x0A2C, 0x00 },
	{ 0x0B44, 0x0F },
	{ 0x0B46, 0x00 },
	{ 0x0B47, 0x0E },
	{ 0x0B48, 0x0E },
	{ 0x0B4A, 0x18 },
	{ 0x0B57, 0xF9 },
	{ 0x0B58, 0x00 },
	/* End configuration registers */

	/* Start configuration postamble */
	{ 0x0514, 0x01 },
	{ 0x001C, 0x01 },
	{ 0x0540, 0x00 },
	{ 0x0B24, 0xC3 },
	{ 0x0B25, 0x02 },
	/* End configuration postamble */

	{ 0x0000, 0x00 }
};

/*
 * Design Report
 *
 * Overview
 * ========
 * Part:         Si5345 Rev D
 * Project File: C:\XilinxProjects\flint_tr051017\genlock\FormatFiles\IO4K+_NTV2_FORMAT_625_5000.slabtimeproj
 * Design ID:    IO4K+
 * Created By:   ClockBuilder Pro v2.16.1 [2017-07-19]
 * Timestamp:    2017-08-24 16:12:49 GMT-07:00
 * 
 * Design Notes
 * ============
 * assumes NTSC HSYNC (pulsed) input = (30/1.001)*525
 * 
 * Design Rule Check
 * =================
 * Errors:
 * - No errors
 * 
 * Warnings:
 * - Pulsed LVCMOS input buffer mode has been selected. This mode has non-standard input voltage logic thresholds: 0.33 V for Vil (max) and 0.49 V for Vih (min). Select this mode only if your input clock has a duty cycle significantly less or more than 50%.  Refer to the device datasheet for the exact threshold voltage specifications and the input attenuator circuit (DC coupled Pulsed LVCMOS) in the Family Reference Manual.
 * 
 * Device Grade
 * ============
 * Maximum Output Frequency: 148.5 MHz
 * Frequency Synthesis Mode: Fractional
 * Minimum Base OPN:         Si5345B
 * Actual Base OPN:          Si5345B
 * 
 * Base       Output Clock         Supported Frequency Synthesis Modes
 * OPN Grade  Frequency Range      (Typical Jitter)
 * ---------  -------------------  --------------------------------------------
 * Si5345A    100 Hz to 1.028 GHz  Integer (< 100 fs) and fractional (< 150 fs)
 * Si5345B    100 Hz to 350 MHz    "
 * Si5345C    100 Hz to 1.028 GHz  Integer only (< 100 fs)
 * Si5345D    100 Hz to 350 MHz    "
 * 
 * Design
 * ======
 * Host Interface:
 *    I/O Power Supply: VDD (Core)
 *    SPI Mode: 4-Wire
 *    I2C Address Range: 100d to 103d / 0x64 to 0x67 (selected via A0/A1 pins)
 * 
 * XA/XB:
 *    52 MHz (XO - External Oscillator)
 * 
 * Inputs:
 *     IN0: 67.4325674325674325... kHz [ 67 + 433/1001 kHz ]
 *          [ (60000/1001)*1125 ]
 *          Pulsed LVCMOS
 *     IN1: Unused
 *     IN2: Unused
 *     IN3: Unused
 * 
 * Outputs:
 *    OUT0: 27 MHz
 *          Enabled, LVDS 2.5 V
 *    OUT1: Unused
 *    OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT3: Unused
 *    OUT4: Unused
 *    OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT6: Unused
 *    OUT7: Unused
 *    OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *          [ 148.5/1.001 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT9: Unused
 * 
 * Frequency Plan
 * ==============
 * Priority: maximize the number of low jitter outputs
 * 
 * Fvco = 13.662 GHz [ 13 + 331/500 GHz ]
 * Fpfd = 67.4325674325674325... kHz [ 67 + 433/1001 kHz ]
 * Fms0 = 594 MHz
 * Fms1 = 147.456 MHz [ 147 + 57/125 MHz ]
 * Fms2 = 890.1098901098901098... MHz [ 890 + 10/91 MHz ]
 * 
 * P dividers:
 *    P0  = 1
 *    P1  = Unused
 *    P2  = Unused
 *    P3  = Unused
 *    Pxaxb = 1
 * 
 * MXAXB = 262.7307692307692307... [ 262 + 19/26 ]
 * M = 40520.48 [ 40520 + 12/25 ]
 * N dividers:
 *    N0:
 *       Value: 23
 *       Skew:  0.000 s
 *       OUT0: 27 MHz
 *       OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *    N1:
 *       Value: 92.6513671875 [ 92 + 667/1024 ]
 *       Skew:  0.000 s
 *       OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *    N2:
 *       Value: 15.3486666666666666... [ 15 + 523/1500 ]
 *       Skew:  0.000 s
 *       OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *    N3:
 *       Unused
 *    N4:
 *       Unused
 * 
 * R dividers:
 *    R0 = 22
 *    R1 = Unused
 *    R2 = 4
 *    R3 = Unused
 *    R4 = Unused
 *    R5 = 6
 *    R6 = Unused
 *    R7 = Unused
 *    R8 = 6
 *    R9 = Unused
 * 
 * Nominal Bandwidth:
 *   Desired: 1.000 Hz
 *   Actual:  651.191 mHz
 *   Coefficients:
 *      BW0:  17
 *      BW1:  25
 *      BW2:  15
 *      BW3:  15
 *      BW4:  1
 *      BW5:  15
 * Fastlock Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  107.233 Hz
 *   Coefficients:
 *      BW0:  24
 *      BW1:  41
 *      BW2:  12
 *      BW3:  11
 *      BW4:  1
 *      BW5:  15
 * Holdover Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  107.233 Hz
 *   Coefficients:
 *      BW0:  24
 *      BW1:  41
 *      BW2:  12
 *      BW3:  11
 *      BW4:  1
 *      BW5:  15
 * 
 * Dividers listed above show effective values. These values are translated to register settings by ClockBuilder Pro. For the actual register values, see below. Refer to the Family Reference Manual for information on registers related to frequency plan.
 * 
 * Digitally Controlled Oscillator (DCO)
 * =====================================
 * Mode: Register Direct Write
 * 
 * N0: DCO Disabled
 * 
 * N1: DCO Disabled
 * 
 * N2: DCO Disabled
 * 
 * N3: DCO Disabled
 * 
 * N4: DCO Disabled
 * 
 * Estimated Power & Junction Temperature
 * ======================================
 * Assumptions:
 * 
 * Revision: D
 * VDD:      1.8 V
 * Ta:       70 C
 * Airflow:  None
 * 
 * Total Power: 808 mW, On Chip Power: 784 mW, Tj: 87 C
 * 
 *                 Frequency  Format   Voltage   Current     Power
 *         -----------------  ------  --------  --------  --------
 * VDD                                   1.8 V  147.9 mA    266 mW
 * VDDA                                  3.3 V  117.4 mA    387 mW
 * VDDO0              27 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO1              Unused                                      
 * VDDO2           148.5 MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO3              Unused                                      
 * VDDO4              Unused                                      
 * VDDO5          24.576 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO6              Unused                                      
 * VDDO7              Unused                                      
 * VDDO8   148.351648... MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO9              Unused                                      
 *                                              --------  --------
 *                                       Total  327.2 mA    808 mW
 * 
 * Note:
 * 
 * -Total power includes on- and off-chip power. This is a typical value and estimate only.
 * -Use an EVB for a more exact power measurement
 * -On-chip power excludes power dissipated in external terminations.
 * -Tj is junction temperature. Tj must be less than 125 C (on Si5345 Revision D) for device to comply with datasheet specifications.
 * 
 * Settings
 * ========
 * 
 * Location      Setting Name           Decimal Value      Hex Value        
 * ------------  ---------------------  -----------------  -----------------
 * 0x000B[6:0]   I2C_ADDR               100                0x64             
 * 0x0016[1]     LOL_ON_HOLD            1                  0x1              
 * 0x0017[0]     SYSINCAL_INTR_MSK      0                  0x0              
 * 0x0017[1]     LOSXAXB_INTR_MSK       0                  0x0              
 * 0x0017[5]     SMB_TMOUT_INTR_MSK     1                  0x1              
 * 0x0018[3:0]   LOS_INTR_MSK           15                 0xF              
 * 0x0018[7:4]   OOF_INTR_MSK           15                 0xF              
 * 0x0019[1]     LOL_INTR_MSK           1                  0x1              
 * 0x0019[5]     HOLD_INTR_MSK          0                  0x0              
 * 0x001A[5]     CAL_INTR_MSK           0                  0x0              
 * 0x002B[3]     SPI_3WIRE              0                  0x0              
 * 0x002B[5]     AUTO_NDIV_UPDATE       0                  0x0              
 * 0x002C[3:0]   LOS_EN                 1                  0x1              
 * 0x002C[4]     LOSXAXB_DIS            0                  0x0              
 * 0x002D[1:0]   LOS0_VAL_TIME          2                  0x2              
 * 0x002D[3:2]   LOS1_VAL_TIME          0                  0x0              
 * 0x002D[5:4]   LOS2_VAL_TIME          0                  0x0              
 * 0x002D[7:6]   LOS3_VAL_TIME          0                  0x0              
 * 0x002E[15:0]  LOS0_TRG_THR           973                0x03CD           
 * 0x0030[15:0]  LOS1_TRG_THR           0                  0x0000           
 * 0x0032[15:0]  LOS2_TRG_THR           0                  0x0000           
 * 0x0034[15:0]  LOS3_TRG_THR           0                  0x0000           
 * 0x0036[15:0]  LOS0_CLR_THR           892                0x037C           
 * 0x0038[15:0]  LOS1_CLR_THR           0                  0x0000           
 * 0x003A[15:0]  LOS2_CLR_THR           0                  0x0000           
 * 0x003C[15:0]  LOS3_CLR_THR           0                  0x0000           
 * 0x003F[3:0]   OOF_EN                 1                  0x1              
 * 0x003F[7:4]   FAST_OOF_EN            0                  0x0              
 * 0x0040[2:0]   OOF_REF_SEL            4                  0x4              
 * 0x0041[4:0]   OOF0_DIV_SEL           3                  0x03             
 * 0x0042[4:0]   OOF1_DIV_SEL           0                  0x00             
 * 0x0043[4:0]   OOF2_DIV_SEL           0                  0x00             
 * 0x0044[4:0]   OOF3_DIV_SEL           0                  0x00             
 * 0x0045[4:0]   OOFXO_DIV_SEL          12                 0x0C             
 * 0x0046[7:0]   OOF0_SET_THR           150                0x96             
 * 0x0047[7:0]   OOF1_SET_THR           0                  0x00             
 * 0x0048[7:0]   OOF2_SET_THR           0                  0x00             
 * 0x0049[7:0]   OOF3_SET_THR           0                  0x00             
 * 0x004A[7:0]   OOF0_CLR_THR           75                 0x4B             
 * 0x004B[7:0]   OOF1_CLR_THR           0                  0x00             
 * 0x004C[7:0]   OOF2_CLR_THR           0                  0x00             
 * 0x004D[7:0]   OOF3_CLR_THR           0                  0x00             
 * 0x004E[2:0]   OOF0_DETWIN_SEL        5                  0x5              
 * 0x004E[6:4]   OOF1_DETWIN_SEL        0                  0x0              
 * 0x004F[2:0]   OOF2_DETWIN_SEL        0                  0x0              
 * 0x004F[6:4]   OOF3_DETWIN_SEL        0                  0x0              
 * 0x0050[3:0]   OOF_ON_LOS             15                 0xF              
 * 0x0051[3:0]   FAST_OOF0_SET_THR      0                  0x0              
 * 0x0052[3:0]   FAST_OOF1_SET_THR      0                  0x0              
 * 0x0053[3:0]   FAST_OOF2_SET_THR      0                  0x0              
 * 0x0054[3:0]   FAST_OOF3_SET_THR      0                  0x0              
 * 0x0055[3:0]   FAST_OOF0_CLR_THR      0                  0x0              
 * 0x0056[3:0]   FAST_OOF1_CLR_THR      0                  0x0              
 * 0x0057[3:0]   FAST_OOF2_CLR_THR      0                  0x0              
 * 0x0058[3:0]   FAST_OOF3_CLR_THR      0                  0x0              
 * 0x0059[1:0]   FAST_OOF0_DETWIN_SEL   1                  0x1              
 * 0x0059[3:2]   FAST_OOF1_DETWIN_SEL   0                  0x0              
 * 0x0059[5:4]   FAST_OOF2_DETWIN_SEL   0                  0x0              
 * 0x0059[7:6]   FAST_OOF3_DETWIN_SEL   0                  0x0              
 * 0x005A[25:0]  OOF0_RATIO_REF         11139256           0x0A9F8B8        
 * 0x005E[25:0]  OOF1_RATIO_REF         0                  0x0000000        
 * 0x0062[25:0]  OOF2_RATIO_REF         0                  0x0000000        
 * 0x0066[25:0]  OOF3_RATIO_REF         0                  0x0000000        
 * 0x0092[1]     LOL_FST_EN             1                  0x1              
 * 0x0093[7:4]   LOL_FST_DETWIN_SEL     10                 0xA              
 * 0x0095[3:2]   LOL_FST_VALWIN_SEL     0                  0x0              
 * 0x0096[7:4]   LOL_FST_SET_THR_SEL    9                  0x9              
 * 0x0098[7:4]   LOL_FST_CLR_THR_SEL    7                  0x7              
 * 0x009A[1]     LOL_SLOW_EN_PLL        1                  0x1              
 * 0x009B[7:4]   LOL_SLW_DETWIN_SEL     5                  0x5              
 * 0x009D[3:2]   LOL_SLW_VALWIN_SEL     1                  0x1              
 * 0x009E[7:4]   LOL_SLW_SET_THR        6                  0x6              
 * 0x00A0[7:4]   LOL_SLW_CLR_THR        3                  0x3              
 * 0x00A2[1]     LOL_TIMER_EN           0                  0x0              
 * 0x00A9[28:0]  LOL_CLR_DELAY_DIV256   294329             0x00047DB9       
 * 0x00E5[5]     FASTLOCK_EXTEND_EN     1                  0x1              
 * 0x00EA[28:0]  FASTLOCK_EXTEND        242129             0x0003B1D1       
 * 0x0102[0]     OUTALL_DISABLE_LOW     1                  0x1              
 * 0x0108[0]     OUT0_PDN               0                  0x0              
 * 0x0108[1]     OUT0_OE                1                  0x1              
 * 0x0108[2]     OUT0_RDIV_FORCE2       0                  0x0              
 * 0x0109[2:0]   OUT0_FORMAT            1                  0x1              
 * 0x0109[3]     OUT0_SYNC_EN           1                  0x1              
 * 0x0109[5:4]   OUT0_DIS_STATE         0                  0x0              
 * 0x0109[7:6]   OUT0_CMOS_DRV          0                  0x0              
 * 0x010A[3:0]   OUT0_CM                11                 0xB              
 * 0x010A[6:4]   OUT0_AMPL              3                  0x3              
 * 0x010B[2:0]   OUT0_MUX_SEL           0                  0x0              
 * 0x010B[5:4]   OUT0_VDD_SEL           2                  0x2              
 * 0x010B[3]     OUT0_VDD_SEL_EN        1                  0x1              
 * 0x010B[7:6]   OUT0_INV               0                  0x0              
 * 0x010D[0]     OUT1_PDN               1                  0x1              
 * 0x010D[1]     OUT1_OE                0                  0x0              
 * 0x010D[2]     OUT1_RDIV_FORCE2       0                  0x0              
 * 0x010E[2:0]   OUT1_FORMAT            1                  0x1              
 * 0x010E[3]     OUT1_SYNC_EN           1                  0x1              
 * 0x010E[5:4]   OUT1_DIS_STATE         0                  0x0              
 * 0x010E[7:6]   OUT1_CMOS_DRV          0                  0x0              
 * 0x010F[3:0]   OUT1_CM                11                 0xB              
 * 0x010F[6:4]   OUT1_AMPL              3                  0x3              
 * 0x0110[2:0]   OUT1_MUX_SEL           0                  0x0              
 * 0x0110[5:4]   OUT1_VDD_SEL           2                  0x2              
 * 0x0110[3]     OUT1_VDD_SEL_EN        1                  0x1              
 * 0x0110[7:6]   OUT1_INV               0                  0x0              
 * 0x0112[0]     OUT2_PDN               0                  0x0              
 * 0x0112[1]     OUT2_OE                1                  0x1              
 * 0x0112[2]     OUT2_RDIV_FORCE2       0                  0x0              
 * 0x0113[2:0]   OUT2_FORMAT            1                  0x1              
 * 0x0113[3]     OUT2_SYNC_EN           1                  0x1              
 * 0x0113[5:4]   OUT2_DIS_STATE         0                  0x0              
 * 0x0113[7:6]   OUT2_CMOS_DRV          0                  0x0              
 * 0x0114[3:0]   OUT2_CM                11                 0xB              
 * 0x0114[6:4]   OUT2_AMPL              3                  0x3              
 * 0x0115[2:0]   OUT2_MUX_SEL           0                  0x0              
 * 0x0115[5:4]   OUT2_VDD_SEL           2                  0x2              
 * 0x0115[3]     OUT2_VDD_SEL_EN        1                  0x1              
 * 0x0115[7:6]   OUT2_INV               0                  0x0              
 * 0x0117[0]     OUT3_PDN               1                  0x1              
 * 0x0117[1]     OUT3_OE                0                  0x0              
 * 0x0117[2]     OUT3_RDIV_FORCE2       0                  0x0              
 * 0x0118[2:0]   OUT3_FORMAT            1                  0x1              
 * 0x0118[3]     OUT3_SYNC_EN           1                  0x1              
 * 0x0118[5:4]   OUT3_DIS_STATE         0                  0x0              
 * 0x0118[7:6]   OUT3_CMOS_DRV          0                  0x0              
 * 0x0119[3:0]   OUT3_CM                11                 0xB              
 * 0x0119[6:4]   OUT3_AMPL              3                  0x3              
 * 0x011A[2:0]   OUT3_MUX_SEL           0                  0x0              
 * 0x011A[5:4]   OUT3_VDD_SEL           2                  0x2              
 * 0x011A[3]     OUT3_VDD_SEL_EN        1                  0x1              
 * 0x011A[7:6]   OUT3_INV               0                  0x0              
 * 0x011C[0]     OUT4_PDN               1                  0x1              
 * 0x011C[1]     OUT4_OE                0                  0x0              
 * 0x011C[2]     OUT4_RDIV_FORCE2       0                  0x0              
 * 0x011D[2:0]   OUT4_FORMAT            1                  0x1              
 * 0x011D[3]     OUT4_SYNC_EN           1                  0x1              
 * 0x011D[5:4]   OUT4_DIS_STATE         0                  0x0              
 * 0x011D[7:6]   OUT4_CMOS_DRV          0                  0x0              
 * 0x011E[3:0]   OUT4_CM                11                 0xB              
 * 0x011E[6:4]   OUT4_AMPL              3                  0x3              
 * 0x011F[2:0]   OUT4_MUX_SEL           0                  0x0              
 * 0x011F[5:4]   OUT4_VDD_SEL           2                  0x2              
 * 0x011F[3]     OUT4_VDD_SEL_EN        1                  0x1              
 * 0x011F[7:6]   OUT4_INV               0                  0x0              
 * 0x0121[0]     OUT5_PDN               0                  0x0              
 * 0x0121[1]     OUT5_OE                1                  0x1              
 * 0x0121[2]     OUT5_RDIV_FORCE2       0                  0x0              
 * 0x0122[2:0]   OUT5_FORMAT            1                  0x1              
 * 0x0122[3]     OUT5_SYNC_EN           1                  0x1              
 * 0x0122[5:4]   OUT5_DIS_STATE         0                  0x0              
 * 0x0122[7:6]   OUT5_CMOS_DRV          0                  0x0              
 * 0x0123[3:0]   OUT5_CM                11                 0xB              
 * 0x0123[6:4]   OUT5_AMPL              3                  0x3              
 * 0x0124[2:0]   OUT5_MUX_SEL           1                  0x1              
 * 0x0124[5:4]   OUT5_VDD_SEL           2                  0x2              
 * 0x0124[3]     OUT5_VDD_SEL_EN        1                  0x1              
 * 0x0124[7:6]   OUT5_INV               0                  0x0              
 * 0x0126[0]     OUT6_PDN               1                  0x1              
 * 0x0126[1]     OUT6_OE                0                  0x0              
 * 0x0126[2]     OUT6_RDIV_FORCE2       0                  0x0              
 * 0x0127[2:0]   OUT6_FORMAT            1                  0x1              
 * 0x0127[3]     OUT6_SYNC_EN           1                  0x1              
 * 0x0127[5:4]   OUT6_DIS_STATE         0                  0x0              
 * 0x0127[7:6]   OUT6_CMOS_DRV          0                  0x0              
 * 0x0128[3:0]   OUT6_CM                11                 0xB              
 * 0x0128[6:4]   OUT6_AMPL              3                  0x3              
 * 0x0129[2:0]   OUT6_MUX_SEL           0                  0x0              
 * 0x0129[5:4]   OUT6_VDD_SEL           2                  0x2              
 * 0x0129[3]     OUT6_VDD_SEL_EN        1                  0x1              
 * 0x0129[7:6]   OUT6_INV               0                  0x0              
 * 0x012B[0]     OUT7_PDN               1                  0x1              
 * 0x012B[1]     OUT7_OE                0                  0x0              
 * 0x012B[2]     OUT7_RDIV_FORCE2       0                  0x0              
 * 0x012C[2:0]   OUT7_FORMAT            1                  0x1              
 * 0x012C[3]     OUT7_SYNC_EN           1                  0x1              
 * 0x012C[5:4]   OUT7_DIS_STATE         0                  0x0              
 * 0x012C[7:6]   OUT7_CMOS_DRV          0                  0x0              
 * 0x012D[3:0]   OUT7_CM                11                 0xB              
 * 0x012D[6:4]   OUT7_AMPL              3                  0x3              
 * 0x012E[2:0]   OUT7_MUX_SEL           0                  0x0              
 * 0x012E[5:4]   OUT7_VDD_SEL           2                  0x2              
 * 0x012E[3]     OUT7_VDD_SEL_EN        1                  0x1              
 * 0x012E[7:6]   OUT7_INV               0                  0x0              
 * 0x0130[0]     OUT8_PDN               0                  0x0              
 * 0x0130[1]     OUT8_OE                1                  0x1              
 * 0x0130[2]     OUT8_RDIV_FORCE2       0                  0x0              
 * 0x0131[2:0]   OUT8_FORMAT            1                  0x1              
 * 0x0131[3]     OUT8_SYNC_EN           1                  0x1              
 * 0x0131[5:4]   OUT8_DIS_STATE         0                  0x0              
 * 0x0131[7:6]   OUT8_CMOS_DRV          0                  0x0              
 * 0x0132[3:0]   OUT8_CM                11                 0xB              
 * 0x0132[6:4]   OUT8_AMPL              3                  0x3              
 * 0x0133[2:0]   OUT8_MUX_SEL           2                  0x2              
 * 0x0133[5:4]   OUT8_VDD_SEL           2                  0x2              
 * 0x0133[3]     OUT8_VDD_SEL_EN        1                  0x1              
 * 0x0133[7:6]   OUT8_INV               0                  0x0              
 * 0x013A[0]     OUT9_PDN               1                  0x1              
 * 0x013A[1]     OUT9_OE                0                  0x0              
 * 0x013A[2]     OUT9_RDIV_FORCE2       0                  0x0              
 * 0x013B[2:0]   OUT9_FORMAT            1                  0x1              
 * 0x013B[3]     OUT9_SYNC_EN           1                  0x1              
 * 0x013B[5:4]   OUT9_DIS_STATE         0                  0x0              
 * 0x013B[7:6]   OUT9_CMOS_DRV          0                  0x0              
 * 0x013C[3:0]   OUT9_CM                11                 0xB              
 * 0x013C[6:4]   OUT9_AMPL              3                  0x3              
 * 0x013D[2:0]   OUT9_MUX_SEL           0                  0x0              
 * 0x013D[5:4]   OUT9_VDD_SEL           2                  0x2              
 * 0x013D[3]     OUT9_VDD_SEL_EN        1                  0x1              
 * 0x013D[7:6]   OUT9_INV               0                  0x0              
 * 0x013F[11:0]  OUTX_ALWAYS_ON         0                  0x000            
 * 0x0141[1]     OUT_DIS_MSK            0                  0x0              
 * 0x0141[5]     OUT_DIS_LOL_MSK        0                  0x0              
 * 0x0141[6]     OUT_DIS_LOSXAXB_MSK    1                  0x1              
 * 0x0141[7]     OUT_DIS_MSK_LOS_PFD    0                  0x0              
 * 0x0142[1]     OUT_DIS_MSK_LOL        1                  0x1              
 * 0x0142[5]     OUT_DIS_MSK_HOLD       1                  0x1              
 * 0x0206[1:0]   PXAXB                  0                  0x0              
 * 0x0208[47:0]  P0_NUM                 1                  0x000000000001   
 * 0x020E[31:0]  P0_DEN                 1                  0x00000001       
 * 0x0212[47:0]  P1_NUM                 0                  0x000000000000   
 * 0x0218[31:0]  P1_DEN                 0                  0x00000000       
 * 0x021C[47:0]  P2_NUM                 0                  0x000000000000   
 * 0x0222[31:0]  P2_DEN                 0                  0x00000000       
 * 0x0226[47:0]  P3_NUM                 0                  0x000000000000   
 * 0x022C[31:0]  P3_DEN                 0                  0x00000000       
 * 0x0231[3:0]   P0_FRACN_MODE          11                 0xB              
 * 0x0231[4]     P0_FRACN_EN            0                  0x0              
 * 0x0232[3:0]   P1_FRACN_MODE          11                 0xB              
 * 0x0232[4]     P1_FRACN_EN            0                  0x0              
 * 0x0233[3:0]   P2_FRACN_MODE          11                 0xB              
 * 0x0233[4]     P2_FRACN_EN            0                  0x0              
 * 0x0234[3:0]   P3_FRACN_MODE          11                 0xB              
 * 0x0234[4]     P3_FRACN_EN            0                  0x0              
 * 0x0235[43:0]  MXAXB_NUM              916841299968       0x0D578000000    
 * 0x023B[31:0]  MXAXB_DEN              3489660928         0xD0000000       
 * 0x024A[23:0]  R0_REG                 10                 0x00000A         
 * 0x024D[23:0]  R1_REG                 0                  0x000000         
 * 0x0250[23:0]  R2_REG                 1                  0x000001         
 * 0x0253[23:0]  R3_REG                 0                  0x000000         
 * 0x0256[23:0]  R4_REG                 0                  0x000000         
 * 0x0259[23:0]  R5_REG                 2                  0x000002         
 * 0x025C[23:0]  R6_REG                 0                  0x000000         
 * 0x025F[23:0]  R7_REG                 0                  0x000000         
 * 0x0262[23:0]  R8_REG                 2                  0x000002         
 * 0x0268[23:0]  R9_REG                 0                  0x000000         
 * 0x026B[7:0]   DESIGN_ID0             73                 0x49             
 * 0x026C[7:0]   DESIGN_ID1             79                 0x4F             
 * 0x026D[7:0]   DESIGN_ID2             52                 0x34             
 * 0x026E[7:0]   DESIGN_ID3             75                 0x4B             
 * 0x026F[7:0]   DESIGN_ID4             43                 0x2B             
 * 0x0270[7:0]   DESIGN_ID5             0                  0x00             
 * 0x0271[7:0]   DESIGN_ID6             0                  0x00             
 * 0x0272[7:0]   DESIGN_ID7             0                  0x00             
 * 0x0294[7:4]   FASTLOCK_EXTEND_SCL    8                  0x8              
 * 0x0296[1]     LOL_SLW_VALWIN_SELX    0                  0x0              
 * 0x0297[1]     FASTLOCK_DLY_ONSW_EN   1                  0x1              
 * 0x0299[1]     FASTLOCK_DLY_ONLOL_EN  1                  0x1              
 * 0x029D[19:0]  FASTLOCK_DLY_ONLOL     3829               0x00EF5          
 * 0x02A9[19:0]  FASTLOCK_DLY_ONSW      9830               0x02666          
 * 0x02B7[3:2]   LOL_NOSIG_TIME         3                  0x3              
 * 0x0302[43:0]  N0_NUM                 49392123904        0x00B80000000    
 * 0x0308[31:0]  N0_DEN                 2147483648         0x80000000       
 * 0x030C[0]     N0_UPDATE              0                  0x0              
 * 0x030D[43:0]  N1_NUM                 198967296000       0x02E53600000    
 * 0x0313[31:0]  N1_DEN                 2147483648         0x80000000       
 * 0x0317[0]     N1_UPDATE              0                  0x0              
 * 0x0318[43:0]  N2_NUM                 48282730496        0x00B3DE00000    
 * 0x031E[31:0]  N2_DEN                 3145728000         0xBB800000       
 * 0x0322[0]     N2_UPDATE              0                  0x0              
 * 0x0323[43:0]  N3_NUM                 0                  0x00000000000    
 * 0x0329[31:0]  N3_DEN                 0                  0x00000000       
 * 0x032D[0]     N3_UPDATE              0                  0x0              
 * 0x032E[43:0]  N4_NUM                 0                  0x00000000000    
 * 0x0334[31:0]  N4_DEN                 0                  0x00000000       
 * 0x0338[0]     N4_UPDATE              0                  0x0              
 * 0x0338[1]     N_UPDATE               0                  0x0              
 * 0x0339[4:0]   N_FSTEP_MSK            31                 0x1F             
 * 0x033B[43:0]  N0_FSTEPW              0                  0x00000000000    
 * 0x0341[43:0]  N1_FSTEPW              0                  0x00000000000    
 * 0x0347[43:0]  N2_FSTEPW              0                  0x00000000000    
 * 0x034D[43:0]  N3_FSTEPW              0                  0x00000000000    
 * 0x0353[43:0]  N4_FSTEPW              0                  0x00000000000    
 * 0x0359[15:0]  N0_DELAY               0                  0x0000           
 * 0x035B[15:0]  N1_DELAY               0                  0x0000           
 * 0x035D[15:0]  N2_DELAY               0                  0x0000           
 * 0x035F[15:0]  N3_DELAY               0                  0x0000           
 * 0x0361[15:0]  N4_DELAY               0                  0x0000           
 * 0x0487[0]     ZDM_EN                 0                  0x0              
 * 0x0487[2:1]   ZDM_IN_SEL             0                  0x0              
 * 0x0487[4]     ZDM_AUTOSW_EN          0                  0x0              
 * 0x0502[4]     ADD_DIV256             0                  0x0              
 * 0x0508[5:0]   BW0_PLL                17                 0x11             
 * 0x0509[5:0]   BW1_PLL                25                 0x19             
 * 0x050A[5:0]   BW2_PLL                15                 0x0F             
 * 0x050B[5:0]   BW3_PLL                15                 0x0F             
 * 0x050C[5:0]   BW4_PLL                1                  0x01             
 * 0x050D[5:0]   BW5_PLL                15                 0x0F             
 * 0x050E[5:0]   FASTLOCK_BW0_PLL       24                 0x18             
 * 0x050F[5:0]   FASTLOCK_BW1_PLL       41                 0x29             
 * 0x0510[5:0]   FASTLOCK_BW2_PLL       12                 0x0C             
 * 0x0511[5:0]   FASTLOCK_BW3_PLL       11                 0x0B             
 * 0x0512[5:0]   FASTLOCK_BW4_PLL       1                  0x01             
 * 0x0513[5:0]   FASTLOCK_BW5_PLL       15                 0x0F             
 * 0x0515[55:0]  M_NUM                  135964169076736    0x007BA8A0000000 
 * 0x051C[31:0]  M_DEN                  3355443200         0xC8000000       
 * 0x0521[3:0]   M_FRAC_MODE            11                 0xB              
 * 0x0521[4]     M_FRAC_EN              1                  0x1              
 * 0x0521[5]     PLL_OUT_RATE_SEL       1                  0x1              
 * 0x052A[0]     IN_SEL_REGCTRL         1                  0x1              
 * 0x052A[3:1]   IN_SEL                 0                  0x0              
 * 0x052B[0]     FASTLOCK_AUTO_EN       1                  0x1              
 * 0x052B[1]     FASTLOCK_MAN           0                  0x0              
 * 0x052C[0]     HOLD_EN                1                  0x1              
 * 0x052C[3]     HOLD_RAMP_BYP          1                  0x1              
 * 0x052C[4]     HOLDEXIT_BW_SEL1       0                  0x0              
 * 0x052C[7:5]   RAMP_STEP_INTERVAL     0                  0x0              
 * 0x052D[1]     HOLD_RAMPBYP_NOHIST    1                  0x1              
 * 0x052E[4:0]   HOLD_HIST_LEN          21                 0x15             
 * 0x052F[4:0]   HOLD_HIST_DELAY        20                 0x14             
 * 0x0531[4:0]   HOLD_REF_COUNT_FRC     0                  0x00             
 * 0x0532[23:0]  HOLD_15M_CYC_COUNT     24717              0x00608D         
 * 0x0535[0]     FORCE_HOLD             0                  0x0              
 * 0x0536[1:0]   CLK_SWITCH_MODE        0                  0x0              
 * 0x0536[2]     HSW_EN                 0                  0x0              
 * 0x0537[3:0]   IN_LOS_MSK             0                  0x0              
 * 0x0537[7:4]   IN_OOF_MSK             0                  0x0              
 * 0x0538[2:0]   IN0_PRIORITY           0                  0x0              
 * 0x0538[6:4]   IN1_PRIORITY           0                  0x0              
 * 0x0539[2:0]   IN2_PRIORITY           0                  0x0              
 * 0x0539[6:4]   IN3_PRIORITY           0                  0x0              
 * 0x053A[1:0]   HSW_MODE               2                  0x2              
 * 0x053A[3:2]   HSW_PHMEAS_CTRL        0                  0x0              
 * 0x053B[9:0]   HSW_PHMEAS_THR         3                  0x003            
 * 0x053D[4:0]   HSW_COARSE_PM_LEN      19                 0x13             
 * 0x053E[4:0]   HSW_COARSE_PM_DLY      6                  0x06             
 * 0x0589[12:0]  CAP_SHORT_DELAY        402                0x0192           
 * 0x059B[4]     HOLD_PRESERVE_HIST     1                  0x1              
 * 0x059B[5]     HOLD_FRZ_WITH_INTONLY  1                  0x1              
 * 0x059B[6]     HOLDEXIT_BW_SEL0       1                  0x1              
 * 0x059B[7]     HOLDEXIT_STD_BO        1                  0x1              
 * 0x059D[5:0]   HOLDEXIT_BW0           24                 0x18             
 * 0x059E[5:0]   HOLDEXIT_BW1           41                 0x29             
 * 0x059F[5:0]   HOLDEXIT_BW2           12                 0x0C             
 * 0x05A0[5:0]   HOLDEXIT_BW3           11                 0x0B             
 * 0x05A1[5:0]   HOLDEXIT_BW4           1                  0x01             
 * 0x05A2[5:0]   HOLDEXIT_BW5           15                 0x0F             
 * 0x05A6[2:0]   RAMP_STEP_SIZE         0                  0x0              
 * 0x05A6[3]     RAMP_SWITCH_EN         0                  0x0              
 * 0x0802[15:0]  FIXREGSA0              1333               0x0535           
 * 0x0804[7:0]   FIXREGSD0              0                  0x00             
 * 0x0805[15:0]  FIXREGSA1              0                  0x0000           
 * 0x0807[7:0]   FIXREGSD1              0                  0x00             
 * 0x0808[15:0]  FIXREGSA2              0                  0x0000           
 * 0x080A[7:0]   FIXREGSD2              0                  0x00             
 * 0x080B[15:0]  FIXREGSA3              0                  0x0000           
 * 0x080D[7:0]   FIXREGSD3              0                  0x00             
 * 0x080E[15:0]  FIXREGSA4              0                  0x0000           
 * 0x0810[7:0]   FIXREGSD4              0                  0x00             
 * 0x0811[15:0]  FIXREGSA5              0                  0x0000           
 * 0x0813[7:0]   FIXREGSD5              0                  0x00             
 * 0x0814[15:0]  FIXREGSA6              0                  0x0000           
 * 0x0816[7:0]   FIXREGSD6              0                  0x00             
 * 0x0817[15:0]  FIXREGSA7              0                  0x0000           
 * 0x0819[7:0]   FIXREGSD7              0                  0x00             
 * 0x081A[15:0]  FIXREGSA8              0                  0x0000           
 * 0x081C[7:0]   FIXREGSD8              0                  0x00             
 * 0x081D[15:0]  FIXREGSA9              0                  0x0000           
 * 0x081F[7:0]   FIXREGSD9              0                  0x00             
 * 0x0820[15:0]  FIXREGSA10             0                  0x0000           
 * 0x0822[7:0]   FIXREGSD10             0                  0x00             
 * 0x0823[15:0]  FIXREGSA11             0                  0x0000           
 * 0x0825[7:0]   FIXREGSD11             0                  0x00             
 * 0x0826[15:0]  FIXREGSA12             0                  0x0000           
 * 0x0828[7:0]   FIXREGSD12             0                  0x00             
 * 0x0829[15:0]  FIXREGSA13             0                  0x0000           
 * 0x082B[7:0]   FIXREGSD13             0                  0x00             
 * 0x082C[15:0]  FIXREGSA14             0                  0x0000           
 * 0x082E[7:0]   FIXREGSD14             0                  0x00             
 * 0x082F[15:0]  FIXREGSA15             0                  0x0000           
 * 0x0831[7:0]   FIXREGSD15             0                  0x00             
 * 0x0832[15:0]  FIXREGSA16             0                  0x0000           
 * 0x0834[7:0]   FIXREGSD16             0                  0x00             
 * 0x0835[15:0]  FIXREGSA17             0                  0x0000           
 * 0x0837[7:0]   FIXREGSD17             0                  0x00             
 * 0x0838[15:0]  FIXREGSA18             0                  0x0000           
 * 0x083A[7:0]   FIXREGSD18             0                  0x00             
 * 0x083B[15:0]  FIXREGSA19             0                  0x0000           
 * 0x083D[7:0]   FIXREGSD19             0                  0x00             
 * 0x083E[15:0]  FIXREGSA20             0                  0x0000           
 * 0x0840[7:0]   FIXREGSD20             0                  0x00             
 * 0x0841[15:0]  FIXREGSA21             0                  0x0000           
 * 0x0843[7:0]   FIXREGSD21             0                  0x00             
 * 0x0844[15:0]  FIXREGSA22             0                  0x0000           
 * 0x0846[7:0]   FIXREGSD22             0                  0x00             
 * 0x0847[15:0]  FIXREGSA23             0                  0x0000           
 * 0x0849[7:0]   FIXREGSD23             0                  0x00             
 * 0x084A[15:0]  FIXREGSA24             0                  0x0000           
 * 0x084C[7:0]   FIXREGSD24             0                  0x00             
 * 0x084D[15:0]  FIXREGSA25             0                  0x0000           
 * 0x084F[7:0]   FIXREGSD25             0                  0x00             
 * 0x0850[15:0]  FIXREGSA26             0                  0x0000           
 * 0x0852[7:0]   FIXREGSD26             0                  0x00             
 * 0x0853[15:0]  FIXREGSA27             0                  0x0000           
 * 0x0855[7:0]   FIXREGSD27             0                  0x00             
 * 0x0856[15:0]  FIXREGSA28             0                  0x0000           
 * 0x0858[7:0]   FIXREGSD28             0                  0x00             
 * 0x0859[15:0]  FIXREGSA29             0                  0x0000           
 * 0x085B[7:0]   FIXREGSD29             0                  0x00             
 * 0x085C[15:0]  FIXREGSA30             0                  0x0000           
 * 0x085E[7:0]   FIXREGSD30             0                  0x00             
 * 0x085F[15:0]  FIXREGSA31             0                  0x0000           
 * 0x0861[7:0]   FIXREGSD31             0                  0x00             
 * 0x090E[0]     XAXB_EXTCLK_EN         1                  0x1              
 * 0x0943[0]     IO_VDD_SEL             0                  0x0              
 * 0x0949[3:0]   IN_EN                  1                  0x1              
 * 0x0949[7:4]   IN_PULSED_CMOS_EN      3                  0x3              
 * 0x094A[3:0]   INX_TO_PFD_EN          1                  0x1              
 * 0x094E[11:0]  REFCLK_HYS_SEL         585                0x249            
 * 0x095E[0]     MXAXB_INTEGER          0                  0x0              
 * 0x0A02[4:0]   N_ADD_0P5              0                  0x00             
 * 0x0A03[4:0]   N_CLK_TO_OUTX_EN       7                  0x07             
 * 0x0A04[4:0]   N_PIBYP                1                  0x01             
 * 0x0A05[4:0]   N_PDNB                 7                  0x07             
 * 0x0A14[3]     N0_HIGH_FREQ           0                  0x0              
 * 0x0A1A[3]     N1_HIGH_FREQ           0                  0x0              
 * 0x0A20[3]     N2_HIGH_FREQ           0                  0x0              
 * 0x0A26[3]     N3_HIGH_FREQ           0                  0x0              
 * 0x0A2C[3]     N4_HIGH_FREQ           0                  0x0              
 * 0x0B44[3:0]   PDIV_FRACN_CLK_DIS     15                 0xF              
 * 0x0B44[5]     FRACN_CLK_DIS_PLL      0                  0x0              
 * 0x0B46[3:0]   LOS_CLK_DIS            0                  0x0              
 * 0x0B47[4:0]   OOF_CLK_DIS            14                 0x0E             
 * 0x0B48[4:0]   OOF_DIV_CLK_DIS        14                 0x0E             
 * 0x0B4A[4:0]   N_CLK_DIS              24                 0x18             
 * 0x0B57[11:0]  VCO_RESET_CALCODE      249                0x0F9
 * 
 *
 */


static struct ntv2_genlock_data s_genlock_1125_6000[] =
{
	/* Start configuration preamble */
	{ 0x0B24, 0xC0 },
	{ 0x0B25, 0x00 },
	{ 0x0540, 0x01 },
	/* End configuration preamble */

	/* Delay 300 msec */
	/*    Delay is worst case time for device to complete any calibration */
	/*    that is running due to device state change previous to this script */
	/*    being processed. */
	{ 0x0000, 0x01 },

	/* Start configuration registers */
	{ 0x000B, 0x64 },
	{ 0x0016, 0x02 },
	{ 0x0017, 0xFC },
	{ 0x0018, 0xFF },
	{ 0x0019, 0xDF },
	{ 0x001A, 0xDF },
	{ 0x002B, 0x02 },
	{ 0x002C, 0x01 },
	{ 0x002D, 0x02 },
	{ 0x002E, 0xCC },
	{ 0x002F, 0x03 },
	{ 0x0030, 0x00 },
	{ 0x0031, 0x00 },
	{ 0x0032, 0x00 },
	{ 0x0033, 0x00 },
	{ 0x0034, 0x00 },
	{ 0x0035, 0x00 },
	{ 0x0036, 0x7B },
	{ 0x0037, 0x03 },
	{ 0x0038, 0x00 },
	{ 0x0039, 0x00 },
	{ 0x003A, 0x00 },
	{ 0x003B, 0x00 },
	{ 0x003C, 0x00 },
	{ 0x003D, 0x00 },
	{ 0x003F, 0x01 },
	{ 0x0040, 0x04 },
	{ 0x0041, 0x03 },
	{ 0x0042, 0x00 },
	{ 0x0043, 0x00 },
	{ 0x0044, 0x00 },
	{ 0x0045, 0x0C },
	{ 0x0046, 0x96 },
	{ 0x0047, 0x00 },
	{ 0x0048, 0x00 },
	{ 0x0049, 0x00 },
	{ 0x004A, 0x4B },
	{ 0x004B, 0x00 },
	{ 0x004C, 0x00 },
	{ 0x004D, 0x00 },
	{ 0x004E, 0x05 },
	{ 0x004F, 0x00 },
	{ 0x0050, 0x0F },
	{ 0x0051, 0x00 },
	{ 0x0052, 0x00 },
	{ 0x0053, 0x00 },
	{ 0x0054, 0x00 },
	{ 0x0055, 0x00 },
	{ 0x0056, 0x00 },
	{ 0x0057, 0x00 },
	{ 0x0058, 0x00 },
	{ 0x0059, 0x01 },
	{ 0x005A, 0x3B },
	{ 0x005B, 0x24 },
	{ 0x005C, 0xAA },
	{ 0x005D, 0x00 },
	{ 0x005E, 0x00 },
	{ 0x005F, 0x00 },
	{ 0x0060, 0x00 },
	{ 0x0061, 0x00 },
	{ 0x0062, 0x00 },
	{ 0x0063, 0x00 },
	{ 0x0064, 0x00 },
	{ 0x0065, 0x00 },
	{ 0x0066, 0x00 },
	{ 0x0067, 0x00 },
	{ 0x0068, 0x00 },
	{ 0x0069, 0x00 },
	{ 0x0092, 0x02 },
	{ 0x0093, 0xA0 },
	{ 0x0095, 0x00 },
	{ 0x0096, 0x90 },
	{ 0x0098, 0x70 },
	{ 0x009A, 0x02 },
	{ 0x009B, 0x50 },
	{ 0x009D, 0x04 },
	{ 0x009E, 0x60 },
	{ 0x00A0, 0x30 },
	{ 0x00A2, 0x00 },
	{ 0x00A9, 0x84 },
	{ 0x00AA, 0x7D },
	{ 0x00AB, 0x04 },
	{ 0x00AC, 0x00 },
	{ 0x00E5, 0x21 },
	{ 0x00EA, 0xD1 },
	{ 0x00EB, 0xB1 },
	{ 0x00EC, 0x03 },
	{ 0x00ED, 0x00 },
	{ 0x0102, 0x01 },
	{ 0x0108, 0x02 },
	{ 0x0109, 0x09 },
	{ 0x010A, 0x3B },
	{ 0x010B, 0x28 },
	{ 0x010D, 0x01 },
	{ 0x010E, 0x09 },
	{ 0x010F, 0x3B },
	{ 0x0110, 0x28 },
	{ 0x0112, 0x02 },
	{ 0x0113, 0x09 },
	{ 0x0114, 0x3B },
	{ 0x0115, 0x28 },
	{ 0x0117, 0x01 },
	{ 0x0118, 0x09 },
	{ 0x0119, 0x3B },
	{ 0x011A, 0x28 },
	{ 0x011C, 0x01 },
	{ 0x011D, 0x09 },
	{ 0x011E, 0x3B },
	{ 0x011F, 0x28 },
	{ 0x0121, 0x02 },
	{ 0x0122, 0x09 },
	{ 0x0123, 0x3B },
	{ 0x0124, 0x29 },
	{ 0x0126, 0x01 },
	{ 0x0127, 0x09 },
	{ 0x0128, 0x3B },
	{ 0x0129, 0x28 },
	{ 0x012B, 0x01 },
	{ 0x012C, 0x09 },
	{ 0x012D, 0x3B },
	{ 0x012E, 0x28 },
	{ 0x0130, 0x02 },
	{ 0x0131, 0x09 },
	{ 0x0132, 0x3B },
	{ 0x0133, 0x2A },
	{ 0x013A, 0x01 },
	{ 0x013B, 0x09 },
	{ 0x013C, 0x3B },
	{ 0x013D, 0x28 },
	{ 0x013F, 0x00 },
	{ 0x0140, 0x00 },
	{ 0x0141, 0x40 },
	{ 0x0142, 0xFF },
	{ 0x0206, 0x00 },
	{ 0x0208, 0x01 },
	{ 0x0209, 0x00 },
	{ 0x020A, 0x00 },
	{ 0x020B, 0x00 },
	{ 0x020C, 0x00 },
	{ 0x020D, 0x00 },
	{ 0x020E, 0x01 },
	{ 0x020F, 0x00 },
	{ 0x0210, 0x00 },
	{ 0x0211, 0x00 },
	{ 0x0212, 0x00 },
	{ 0x0213, 0x00 },
	{ 0x0214, 0x00 },
	{ 0x0215, 0x00 },
	{ 0x0216, 0x00 },
	{ 0x0217, 0x00 },
	{ 0x0218, 0x00 },
	{ 0x0219, 0x00 },
	{ 0x021A, 0x00 },
	{ 0x021B, 0x00 },
	{ 0x021C, 0x00 },
	{ 0x021D, 0x00 },
	{ 0x021E, 0x00 },
	{ 0x021F, 0x00 },
	{ 0x0220, 0x00 },
	{ 0x0221, 0x00 },
	{ 0x0222, 0x00 },
	{ 0x0223, 0x00 },
	{ 0x0224, 0x00 },
	{ 0x0225, 0x00 },
	{ 0x0226, 0x00 },
	{ 0x0227, 0x00 },
	{ 0x0228, 0x00 },
	{ 0x0229, 0x00 },
	{ 0x022A, 0x00 },
	{ 0x022B, 0x00 },
	{ 0x022C, 0x00 },
	{ 0x022D, 0x00 },
	{ 0x022E, 0x00 },
	{ 0x022F, 0x00 },
	{ 0x0231, 0x0B },
	{ 0x0232, 0x0B },
	{ 0x0233, 0x0B },
	{ 0x0234, 0x0B },
	{ 0x0235, 0x00 },
	{ 0x0236, 0x00 },
	{ 0x0237, 0x00 },
	{ 0x0238, 0x78 },
	{ 0x0239, 0xD5 },
	{ 0x023A, 0x00 },
	{ 0x023B, 0x00 },
	{ 0x023C, 0x00 },
	{ 0x023D, 0x00 },
	{ 0x023E, 0xD0 },
	{ 0x024A, 0x0A },
	{ 0x024B, 0x00 },
	{ 0x024C, 0x00 },
	{ 0x024D, 0x00 },
	{ 0x024E, 0x00 },
	{ 0x024F, 0x00 },
	{ 0x0250, 0x01 },
	{ 0x0251, 0x00 },
	{ 0x0252, 0x00 },
	{ 0x0253, 0x00 },
	{ 0x0254, 0x00 },
	{ 0x0255, 0x00 },
	{ 0x0256, 0x00 },
	{ 0x0257, 0x00 },
	{ 0x0258, 0x00 },
	{ 0x0259, 0x02 },
	{ 0x025A, 0x00 },
	{ 0x025B, 0x00 },
	{ 0x025C, 0x00 },
	{ 0x025D, 0x00 },
	{ 0x025E, 0x00 },
	{ 0x025F, 0x00 },
	{ 0x0260, 0x00 },
	{ 0x0261, 0x00 },
	{ 0x0262, 0x02 },
	{ 0x0263, 0x00 },
	{ 0x0264, 0x00 },
	{ 0x0268, 0x00 },
	{ 0x0269, 0x00 },
	{ 0x026A, 0x00 },
	{ 0x026B, 0x49 },
	{ 0x026C, 0x4F },
	{ 0x026D, 0x34 },
	{ 0x026E, 0x4B },
	{ 0x026F, 0x2B },
	{ 0x0270, 0x00 },
	{ 0x0271, 0x00 },
	{ 0x0272, 0x00 },
	{ 0x0294, 0x80 },
	{ 0x0296, 0x00 },
	{ 0x0297, 0x02 },
	{ 0x0299, 0x02 },
	{ 0x029D, 0xF5 },
	{ 0x029E, 0x0E },
	{ 0x029F, 0x00 },
	{ 0x02A9, 0x66 },
	{ 0x02AA, 0x26 },
	{ 0x02AB, 0x00 },
	{ 0x02B7, 0xFF },
	{ 0x0302, 0x00 },
	{ 0x0303, 0x00 },
	{ 0x0304, 0x00 },
	{ 0x0305, 0x80 },
	{ 0x0306, 0x0B },
	{ 0x0307, 0x00 },
	{ 0x0308, 0x00 },
	{ 0x0309, 0x00 },
	{ 0x030A, 0x00 },
	{ 0x030B, 0x80 },
	{ 0x030C, 0x00 },
	{ 0x030D, 0x00 },
	{ 0x030E, 0x00 },
	{ 0x030F, 0x60 },
	{ 0x0310, 0x53 },
	{ 0x0311, 0x2E },
	{ 0x0312, 0x00 },
	{ 0x0313, 0x00 },
	{ 0x0314, 0x00 },
	{ 0x0315, 0x00 },
	{ 0x0316, 0x80 },
	{ 0x0317, 0x00 },
	{ 0x0318, 0x00 },
	{ 0x0319, 0x00 },
	{ 0x031A, 0xE0 },
	{ 0x031B, 0x3D },
	{ 0x031C, 0x0B },
	{ 0x031D, 0x00 },
	{ 0x031E, 0x00 },
	{ 0x031F, 0x00 },
	{ 0x0320, 0x80 },
	{ 0x0321, 0xBB },
	{ 0x0322, 0x00 },
	{ 0x0323, 0x00 },
	{ 0x0324, 0x00 },
	{ 0x0325, 0x00 },
	{ 0x0326, 0x00 },
	{ 0x0327, 0x00 },
	{ 0x0328, 0x00 },
	{ 0x0329, 0x00 },
	{ 0x032A, 0x00 },
	{ 0x032B, 0x00 },
	{ 0x032C, 0x00 },
	{ 0x032D, 0x00 },
	{ 0x032E, 0x00 },
	{ 0x032F, 0x00 },
	{ 0x0330, 0x00 },
	{ 0x0331, 0x00 },
	{ 0x0332, 0x00 },
	{ 0x0333, 0x00 },
	{ 0x0334, 0x00 },
	{ 0x0335, 0x00 },
	{ 0x0336, 0x00 },
	{ 0x0337, 0x00 },
	{ 0x0338, 0x00 },
	{ 0x0339, 0x1F },
	{ 0x033B, 0x00 },
	{ 0x033C, 0x00 },
	{ 0x033D, 0x00 },
	{ 0x033E, 0x00 },
	{ 0x033F, 0x00 },
	{ 0x0340, 0x00 },
	{ 0x0341, 0x00 },
	{ 0x0342, 0x00 },
	{ 0x0343, 0x00 },
	{ 0x0344, 0x00 },
	{ 0x0345, 0x00 },
	{ 0x0346, 0x00 },
	{ 0x0347, 0x00 },
	{ 0x0348, 0x00 },
	{ 0x0349, 0x00 },
	{ 0x034A, 0x00 },
	{ 0x034B, 0x00 },
	{ 0x034C, 0x00 },
	{ 0x034D, 0x00 },
	{ 0x034E, 0x00 },
	{ 0x034F, 0x00 },
	{ 0x0350, 0x00 },
	{ 0x0351, 0x00 },
	{ 0x0352, 0x00 },
	{ 0x0353, 0x00 },
	{ 0x0354, 0x00 },
	{ 0x0355, 0x00 },
	{ 0x0356, 0x00 },
	{ 0x0357, 0x00 },
	{ 0x0358, 0x00 },
	{ 0x0359, 0x00 },
	{ 0x035A, 0x00 },
	{ 0x035B, 0x00 },
	{ 0x035C, 0x00 },
	{ 0x035D, 0x00 },
	{ 0x035E, 0x00 },
	{ 0x035F, 0x00 },
	{ 0x0360, 0x00 },
	{ 0x0361, 0x00 },
	{ 0x0362, 0x00 },
	{ 0x0487, 0x00 },
	{ 0x0502, 0x01 },
	{ 0x0508, 0x11 },
	{ 0x0509, 0x19 },
	{ 0x050A, 0x0F },
	{ 0x050B, 0x0F },
	{ 0x050C, 0x01 },
	{ 0x050D, 0x0F },
	{ 0x050E, 0x18 },
	{ 0x050F, 0x29 },
	{ 0x0510, 0x0C },
	{ 0x0511, 0x0B },
	{ 0x0512, 0x01 },
	{ 0x0513, 0x0F },
	{ 0x0515, 0x00 },
	{ 0x0516, 0x00 },
	{ 0x0517, 0x00 },
	{ 0x0518, 0x00 },
	{ 0x0519, 0x10 },
	{ 0x051A, 0x4F },
	{ 0x051B, 0x00 },
	{ 0x051C, 0x00 },
	{ 0x051D, 0x00 },
	{ 0x051E, 0x00 },
	{ 0x051F, 0x80 },
	{ 0x0521, 0x2B },
	{ 0x052A, 0x01 },
	{ 0x052B, 0x01 },
	{ 0x052C, 0x0F },
	{ 0x052D, 0x03 },
	{ 0x052E, 0x15 },
	{ 0x052F, 0x14 },
	{ 0x0531, 0x00 },
	{ 0x0532, 0x74 },
	{ 0x0533, 0x60 },
	{ 0x0534, 0x00 },
	{ 0x0535, 0x00 },
	{ 0x0536, 0x00 },
	{ 0x0537, 0x00 },
	{ 0x0538, 0x00 },
	{ 0x0539, 0x00 },
	{ 0x053A, 0x02 },
	{ 0x053B, 0x03 },
	{ 0x053C, 0x00 },
	{ 0x053D, 0x13 },
	{ 0x053E, 0x06 },
	{ 0x0589, 0x92 },
	{ 0x058A, 0x01 },
	{ 0x059B, 0xF8 },
	{ 0x059D, 0x18 },
	{ 0x059E, 0x29 },
	{ 0x059F, 0x0C },
	{ 0x05A0, 0x0B },
	{ 0x05A1, 0x01 },
	{ 0x05A2, 0x0F },
	{ 0x05A6, 0x00 },
	{ 0x0802, 0x35 },
	{ 0x0803, 0x05 },
	{ 0x0804, 0x00 },
	{ 0x0805, 0x00 },
	{ 0x0806, 0x00 },
	{ 0x0807, 0x00 },
	{ 0x0808, 0x00 },
	{ 0x0809, 0x00 },
	{ 0x080A, 0x00 },
	{ 0x080B, 0x00 },
	{ 0x080C, 0x00 },
	{ 0x080D, 0x00 },
	{ 0x080E, 0x00 },
	{ 0x080F, 0x00 },
	{ 0x0810, 0x00 },
	{ 0x0811, 0x00 },
	{ 0x0812, 0x00 },
	{ 0x0813, 0x00 },
	{ 0x0814, 0x00 },
	{ 0x0815, 0x00 },
	{ 0x0816, 0x00 },
	{ 0x0817, 0x00 },
	{ 0x0818, 0x00 },
	{ 0x0819, 0x00 },
	{ 0x081A, 0x00 },
	{ 0x081B, 0x00 },
	{ 0x081C, 0x00 },
	{ 0x081D, 0x00 },
	{ 0x081E, 0x00 },
	{ 0x081F, 0x00 },
	{ 0x0820, 0x00 },
	{ 0x0821, 0x00 },
	{ 0x0822, 0x00 },
	{ 0x0823, 0x00 },
	{ 0x0824, 0x00 },
	{ 0x0825, 0x00 },
	{ 0x0826, 0x00 },
	{ 0x0827, 0x00 },
	{ 0x0828, 0x00 },
	{ 0x0829, 0x00 },
	{ 0x082A, 0x00 },
	{ 0x082B, 0x00 },
	{ 0x082C, 0x00 },
	{ 0x082D, 0x00 },
	{ 0x082E, 0x00 },
	{ 0x082F, 0x00 },
	{ 0x0830, 0x00 },
	{ 0x0831, 0x00 },
	{ 0x0832, 0x00 },
	{ 0x0833, 0x00 },
	{ 0x0834, 0x00 },
	{ 0x0835, 0x00 },
	{ 0x0836, 0x00 },
	{ 0x0837, 0x00 },
	{ 0x0838, 0x00 },
	{ 0x0839, 0x00 },
	{ 0x083A, 0x00 },
	{ 0x083B, 0x00 },
	{ 0x083C, 0x00 },
	{ 0x083D, 0x00 },
	{ 0x083E, 0x00 },
	{ 0x083F, 0x00 },
	{ 0x0840, 0x00 },
	{ 0x0841, 0x00 },
	{ 0x0842, 0x00 },
	{ 0x0843, 0x00 },
	{ 0x0844, 0x00 },
	{ 0x0845, 0x00 },
	{ 0x0846, 0x00 },
	{ 0x0847, 0x00 },
	{ 0x0848, 0x00 },
	{ 0x0849, 0x00 },
	{ 0x084A, 0x00 },
	{ 0x084B, 0x00 },
	{ 0x084C, 0x00 },
	{ 0x084D, 0x00 },
	{ 0x084E, 0x00 },
	{ 0x084F, 0x00 },
	{ 0x0850, 0x00 },
	{ 0x0851, 0x00 },
	{ 0x0852, 0x00 },
	{ 0x0853, 0x00 },
	{ 0x0854, 0x00 },
	{ 0x0855, 0x00 },
	{ 0x0856, 0x00 },
	{ 0x0857, 0x00 },
	{ 0x0858, 0x00 },
	{ 0x0859, 0x00 },
	{ 0x085A, 0x00 },
	{ 0x085B, 0x00 },
	{ 0x085C, 0x00 },
	{ 0x085D, 0x00 },
	{ 0x085E, 0x00 },
	{ 0x085F, 0x00 },
	{ 0x0860, 0x00 },
	{ 0x0861, 0x00 },
	{ 0x090E, 0x03 },
	{ 0x0943, 0x00 },
	{ 0x0949, 0x31 },
	{ 0x094A, 0x01 },
	{ 0x094E, 0x49 },
	{ 0x094F, 0x02 },
	{ 0x095E, 0x00 },
	{ 0x0A02, 0x00 },
	{ 0x0A03, 0x07 },
	{ 0x0A04, 0x01 },
	{ 0x0A05, 0x07 },
	{ 0x0A14, 0x00 },
	{ 0x0A1A, 0x00 },
	{ 0x0A20, 0x00 },
	{ 0x0A26, 0x00 },
	{ 0x0A2C, 0x00 },
	{ 0x0B44, 0x2F },
	{ 0x0B46, 0x00 },
	{ 0x0B47, 0x0E },
	{ 0x0B48, 0x0E },
	{ 0x0B4A, 0x18 },
	{ 0x0B57, 0xF9 },
	{ 0x0B58, 0x00 },
	/* End configuration registers */

	/* Start configuration postamble */
	{ 0x0514, 0x01 },
	{ 0x001C, 0x01 },
	{ 0x0540, 0x00 },
	{ 0x0B24, 0xC3 },
	{ 0x0B25, 0x02 },
	/* End configuration postamble */

	{ 0x0000, 0x00 }
};

/*
 * Design Report
 *
 * Overview
 * ========
 * Part:         Si5345 Rev D
 * Project File: C:\XilinxProjects\flint_tr051017\genlock\FormatFiles\IO4K+_1125_5994.slabtimeproj
 * Design ID:    IO4K+
 * Created By:   ClockBuilder Pro v2.16.1 [2017-07-19]
 * Timestamp:    2017-08-24 16:17:21 GMT-07:00
 * 
 * Design Notes
 * ============
 * assumes NTSC HSYNC (pulsed) input = (30/1.001)*525
 * 
 * Design Rule Check
 * =================
 * Errors:
 * - No errors
 * 
 * Warnings:
 * - Pulsed LVCMOS input buffer mode has been selected. This mode has non-standard input voltage logic thresholds: 0.33 V for Vil (max) and 0.49 V for Vih (min). Select this mode only if your input clock has a duty cycle significantly less or more than 50%.  Refer to the device datasheet for the exact threshold voltage specifications and the input attenuator circuit (DC coupled Pulsed LVCMOS) in the Family Reference Manual.
 * 
 * Device Grade
 * ============
 * Maximum Output Frequency: 148.5 MHz
 * Frequency Synthesis Mode: Fractional
 * Minimum Base OPN:         Si5345B
 * Actual Base OPN:          Si5345B
 * 
 * Base       Output Clock         Supported Frequency Synthesis Modes
 * OPN Grade  Frequency Range      (Typical Jitter)
 * ---------  -------------------  --------------------------------------------
 * Si5345A    100 Hz to 1.028 GHz  Integer (< 100 fs) and fractional (< 150 fs)
 * Si5345B    100 Hz to 350 MHz    "
 * Si5345C    100 Hz to 1.028 GHz  Integer only (< 100 fs)
 * Si5345D    100 Hz to 350 MHz    "
 * 
 * Design
 * ======
 * Host Interface:
 *    I/O Power Supply: VDD (Core)
 *    SPI Mode: 4-Wire
 *    I2C Address Range: 100d to 103d / 0x64 to 0x67 (selected via A0/A1 pins)
 * 
 * XA/XB:
 *    52 MHz (XO - External Oscillator)
 * 
 * Inputs:
 *     IN0: 67.5 kHz [ 67 + 1/2 kHz ]
 *          [ (60)*1125 ]
 *          Pulsed LVCMOS
 *     IN1: Unused
 *     IN2: Unused
 *     IN3: Unused
 * 
 * Outputs:
 *    OUT0: 27 MHz
 *          Enabled, LVDS 2.5 V
 *    OUT1: Unused
 *    OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT3: Unused
 *    OUT4: Unused
 *    OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT6: Unused
 *    OUT7: Unused
 *    OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *          [ 148.5/1.001 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT9: Unused
 * 
 * Frequency Plan
 * ==============
 * Priority: maximize the number of low jitter outputs
 * 
 * Fvco = 13.662 GHz [ 13 + 331/500 GHz ]
 * Fpfd = 67.5 kHz [ 67 + 1/2 kHz ]
 * Fms0 = 594 MHz
 * Fms1 = 147.456 MHz [ 147 + 57/125 MHz ]
 * Fms2 = 890.1098901098901098... MHz [ 890 + 10/91 MHz ]
 * 
 * P dividers:
 *    P0  = 1
 *    P1  = Unused
 *    P2  = Unused
 *    P3  = Unused
 *    Pxaxb = 1
 * 
 * MXAXB = 262.7307692307692307... [ 262 + 19/26 ]
 * M = 40480
 * N dividers:
 *    N0:
 *       Value: 23
 *       Skew:  0.000 s
 *       OUT0: 27 MHz
 *       OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *    N1:
 *       Value: 92.6513671875 [ 92 + 667/1024 ]
 *       Skew:  0.000 s
 *       OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *    N2:
 *       Value: 15.3486666666666666... [ 15 + 523/1500 ]
 *       Skew:  0.000 s
 *       OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *    N3:
 *       Unused
 *    N4:
 *       Unused
 * 
 * R dividers:
 *    R0 = 22
 *    R1 = Unused
 *    R2 = 4
 *    R3 = Unused
 *    R4 = Unused
 *    R5 = 6
 *    R6 = Unused
 *    R7 = Unused
 *    R8 = 6
 *    R9 = Unused
 * 
 * Nominal Bandwidth:
 *   Desired: 1.000 Hz
 *   Actual:  651.855 mHz
 *   Coefficients:
 *      BW0:  17
 *      BW1:  25
 *      BW2:  15
 *      BW3:  15
 *      BW4:  1
 *      BW5:  15
 * Fastlock Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  107.374 Hz
 *   Coefficients:
 *      BW0:  24
 *      BW1:  41
 *      BW2:  12
 *      BW3:  11
 *      BW4:  1
 *      BW5:  15
 * Holdover Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  107.374 Hz
 *   Coefficients:
 *      BW0:  24
 *      BW1:  41
 *      BW2:  12
 *      BW3:  11
 *      BW4:  1
 *      BW5:  15
 * 
 * Dividers listed above show effective values. These values are translated to register settings by ClockBuilder Pro. For the actual register values, see below. Refer to the Family Reference Manual for information on registers related to frequency plan.
 * 
 * Digitally Controlled Oscillator (DCO)
 * =====================================
 * Mode: Register Direct Write
 * 
 * N0: DCO Disabled
 * 
 * N1: DCO Disabled
 * 
 * N2: DCO Disabled
 * 
 * N3: DCO Disabled
 * 
 * N4: DCO Disabled
 * 
 * Estimated Power & Junction Temperature
 * ======================================
 * Assumptions:
 * 
 * Revision: D
 * VDD:      1.8 V
 * Ta:       70 C
 * Airflow:  None
 * 
 * Total Power: 808 mW, On Chip Power: 784 mW, Tj: 87 C
 * 
 *                 Frequency  Format   Voltage   Current     Power
 *         -----------------  ------  --------  --------  --------
 * VDD                                   1.8 V  147.9 mA    266 mW
 * VDDA                                  3.3 V  117.4 mA    387 mW
 * VDDO0              27 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO1              Unused                                      
 * VDDO2           148.5 MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO3              Unused                                      
 * VDDO4              Unused                                      
 * VDDO5          24.576 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO6              Unused                                      
 * VDDO7              Unused                                      
 * VDDO8   148.351648... MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO9              Unused                                      
 *                                              --------  --------
 *                                       Total  327.2 mA    808 mW
 * 
 * Note:
 * 
 * -Total power includes on- and off-chip power. This is a typical value and estimate only.
 * -Use an EVB for a more exact power measurement
 * -On-chip power excludes power dissipated in external terminations.
 * -Tj is junction temperature. Tj must be less than 125 C (on Si5345 Revision D) for device to comply with datasheet specifications.
 * 
 * Settings
 * ========
 * 
 * Location      Setting Name           Decimal Value      Hex Value        
 * ------------  ---------------------  -----------------  -----------------
 * 0x000B[6:0]   I2C_ADDR               100                0x64             
 * 0x0016[1]     LOL_ON_HOLD            1                  0x1              
 * 0x0017[0]     SYSINCAL_INTR_MSK      0                  0x0              
 * 0x0017[1]     LOSXAXB_INTR_MSK       0                  0x0              
 * 0x0017[5]     SMB_TMOUT_INTR_MSK     1                  0x1              
 * 0x0018[3:0]   LOS_INTR_MSK           15                 0xF              
 * 0x0018[7:4]   OOF_INTR_MSK           15                 0xF              
 * 0x0019[1]     LOL_INTR_MSK           1                  0x1              
 * 0x0019[5]     HOLD_INTR_MSK          0                  0x0              
 * 0x001A[5]     CAL_INTR_MSK           0                  0x0              
 * 0x002B[3]     SPI_3WIRE              0                  0x0              
 * 0x002B[5]     AUTO_NDIV_UPDATE       0                  0x0              
 * 0x002C[3:0]   LOS_EN                 1                  0x1              
 * 0x002C[4]     LOSXAXB_DIS            0                  0x0              
 * 0x002D[1:0]   LOS0_VAL_TIME          2                  0x2              
 * 0x002D[3:2]   LOS1_VAL_TIME          0                  0x0              
 * 0x002D[5:4]   LOS2_VAL_TIME          0                  0x0              
 * 0x002D[7:6]   LOS3_VAL_TIME          0                  0x0              
 * 0x002E[15:0]  LOS0_TRG_THR           972                0x03CC           
 * 0x0030[15:0]  LOS1_TRG_THR           0                  0x0000           
 * 0x0032[15:0]  LOS2_TRG_THR           0                  0x0000           
 * 0x0034[15:0]  LOS3_TRG_THR           0                  0x0000           
 * 0x0036[15:0]  LOS0_CLR_THR           891                0x037B           
 * 0x0038[15:0]  LOS1_CLR_THR           0                  0x0000           
 * 0x003A[15:0]  LOS2_CLR_THR           0                  0x0000           
 * 0x003C[15:0]  LOS3_CLR_THR           0                  0x0000           
 * 0x003F[3:0]   OOF_EN                 1                  0x1              
 * 0x003F[7:4]   FAST_OOF_EN            0                  0x0              
 * 0x0040[2:0]   OOF_REF_SEL            4                  0x4              
 * 0x0041[4:0]   OOF0_DIV_SEL           3                  0x03             
 * 0x0042[4:0]   OOF1_DIV_SEL           0                  0x00             
 * 0x0043[4:0]   OOF2_DIV_SEL           0                  0x00             
 * 0x0044[4:0]   OOF3_DIV_SEL           0                  0x00             
 * 0x0045[4:0]   OOFXO_DIV_SEL          12                 0x0C             
 * 0x0046[7:0]   OOF0_SET_THR           150                0x96             
 * 0x0047[7:0]   OOF1_SET_THR           0                  0x00             
 * 0x0048[7:0]   OOF2_SET_THR           0                  0x00             
 * 0x0049[7:0]   OOF3_SET_THR           0                  0x00             
 * 0x004A[7:0]   OOF0_CLR_THR           75                 0x4B             
 * 0x004B[7:0]   OOF1_CLR_THR           0                  0x00             
 * 0x004C[7:0]   OOF2_CLR_THR           0                  0x00             
 * 0x004D[7:0]   OOF3_CLR_THR           0                  0x00             
 * 0x004E[2:0]   OOF0_DETWIN_SEL        5                  0x5              
 * 0x004E[6:4]   OOF1_DETWIN_SEL        0                  0x0              
 * 0x004F[2:0]   OOF2_DETWIN_SEL        0                  0x0              
 * 0x004F[6:4]   OOF3_DETWIN_SEL        0                  0x0              
 * 0x0050[3:0]   OOF_ON_LOS             15                 0xF              
 * 0x0051[3:0]   FAST_OOF0_SET_THR      0                  0x0              
 * 0x0052[3:0]   FAST_OOF1_SET_THR      0                  0x0              
 * 0x0053[3:0]   FAST_OOF2_SET_THR      0                  0x0              
 * 0x0054[3:0]   FAST_OOF3_SET_THR      0                  0x0              
 * 0x0055[3:0]   FAST_OOF0_CLR_THR      0                  0x0              
 * 0x0056[3:0]   FAST_OOF1_CLR_THR      0                  0x0              
 * 0x0057[3:0]   FAST_OOF2_CLR_THR      0                  0x0              
 * 0x0058[3:0]   FAST_OOF3_CLR_THR      0                  0x0              
 * 0x0059[1:0]   FAST_OOF0_DETWIN_SEL   1                  0x1              
 * 0x0059[3:2]   FAST_OOF1_DETWIN_SEL   0                  0x0              
 * 0x0059[5:4]   FAST_OOF2_DETWIN_SEL   0                  0x0              
 * 0x0059[7:6]   FAST_OOF3_DETWIN_SEL   0                  0x0              
 * 0x005A[25:0]  OOF0_RATIO_REF         11150395           0x0AA243B        
 * 0x005E[25:0]  OOF1_RATIO_REF         0                  0x0000000        
 * 0x0062[25:0]  OOF2_RATIO_REF         0                  0x0000000        
 * 0x0066[25:0]  OOF3_RATIO_REF         0                  0x0000000        
 * 0x0092[1]     LOL_FST_EN             1                  0x1              
 * 0x0093[7:4]   LOL_FST_DETWIN_SEL     10                 0xA              
 * 0x0095[3:2]   LOL_FST_VALWIN_SEL     0                  0x0              
 * 0x0096[7:4]   LOL_FST_SET_THR_SEL    9                  0x9              
 * 0x0098[7:4]   LOL_FST_CLR_THR_SEL    7                  0x7              
 * 0x009A[1]     LOL_SLOW_EN_PLL        1                  0x1              
 * 0x009B[7:4]   LOL_SLW_DETWIN_SEL     5                  0x5              
 * 0x009D[3:2]   LOL_SLW_VALWIN_SEL     1                  0x1              
 * 0x009E[7:4]   LOL_SLW_SET_THR        6                  0x6              
 * 0x00A0[7:4]   LOL_SLW_CLR_THR        3                  0x3              
 * 0x00A2[1]     LOL_TIMER_EN           0                  0x0              
 * 0x00A9[28:0]  LOL_CLR_DELAY_DIV256   294276             0x00047D84       
 * 0x00E5[5]     FASTLOCK_EXTEND_EN     1                  0x1              
 * 0x00EA[28:0]  FASTLOCK_EXTEND        242129             0x0003B1D1       
 * 0x0102[0]     OUTALL_DISABLE_LOW     1                  0x1              
 * 0x0108[0]     OUT0_PDN               0                  0x0              
 * 0x0108[1]     OUT0_OE                1                  0x1              
 * 0x0108[2]     OUT0_RDIV_FORCE2       0                  0x0              
 * 0x0109[2:0]   OUT0_FORMAT            1                  0x1              
 * 0x0109[3]     OUT0_SYNC_EN           1                  0x1              
 * 0x0109[5:4]   OUT0_DIS_STATE         0                  0x0              
 * 0x0109[7:6]   OUT0_CMOS_DRV          0                  0x0              
 * 0x010A[3:0]   OUT0_CM                11                 0xB              
 * 0x010A[6:4]   OUT0_AMPL              3                  0x3              
 * 0x010B[2:0]   OUT0_MUX_SEL           0                  0x0              
 * 0x010B[5:4]   OUT0_VDD_SEL           2                  0x2              
 * 0x010B[3]     OUT0_VDD_SEL_EN        1                  0x1              
 * 0x010B[7:6]   OUT0_INV               0                  0x0              
 * 0x010D[0]     OUT1_PDN               1                  0x1              
 * 0x010D[1]     OUT1_OE                0                  0x0              
 * 0x010D[2]     OUT1_RDIV_FORCE2       0                  0x0              
 * 0x010E[2:0]   OUT1_FORMAT            1                  0x1              
 * 0x010E[3]     OUT1_SYNC_EN           1                  0x1              
 * 0x010E[5:4]   OUT1_DIS_STATE         0                  0x0              
 * 0x010E[7:6]   OUT1_CMOS_DRV          0                  0x0              
 * 0x010F[3:0]   OUT1_CM                11                 0xB              
 * 0x010F[6:4]   OUT1_AMPL              3                  0x3              
 * 0x0110[2:0]   OUT1_MUX_SEL           0                  0x0              
 * 0x0110[5:4]   OUT1_VDD_SEL           2                  0x2              
 * 0x0110[3]     OUT1_VDD_SEL_EN        1                  0x1              
 * 0x0110[7:6]   OUT1_INV               0                  0x0              
 * 0x0112[0]     OUT2_PDN               0                  0x0              
 * 0x0112[1]     OUT2_OE                1                  0x1              
 * 0x0112[2]     OUT2_RDIV_FORCE2       0                  0x0              
 * 0x0113[2:0]   OUT2_FORMAT            1                  0x1              
 * 0x0113[3]     OUT2_SYNC_EN           1                  0x1              
 * 0x0113[5:4]   OUT2_DIS_STATE         0                  0x0              
 * 0x0113[7:6]   OUT2_CMOS_DRV          0                  0x0              
 * 0x0114[3:0]   OUT2_CM                11                 0xB              
 * 0x0114[6:4]   OUT2_AMPL              3                  0x3              
 * 0x0115[2:0]   OUT2_MUX_SEL           0                  0x0              
 * 0x0115[5:4]   OUT2_VDD_SEL           2                  0x2              
 * 0x0115[3]     OUT2_VDD_SEL_EN        1                  0x1              
 * 0x0115[7:6]   OUT2_INV               0                  0x0              
 * 0x0117[0]     OUT3_PDN               1                  0x1              
 * 0x0117[1]     OUT3_OE                0                  0x0              
 * 0x0117[2]     OUT3_RDIV_FORCE2       0                  0x0              
 * 0x0118[2:0]   OUT3_FORMAT            1                  0x1              
 * 0x0118[3]     OUT3_SYNC_EN           1                  0x1              
 * 0x0118[5:4]   OUT3_DIS_STATE         0                  0x0              
 * 0x0118[7:6]   OUT3_CMOS_DRV          0                  0x0              
 * 0x0119[3:0]   OUT3_CM                11                 0xB              
 * 0x0119[6:4]   OUT3_AMPL              3                  0x3              
 * 0x011A[2:0]   OUT3_MUX_SEL           0                  0x0              
 * 0x011A[5:4]   OUT3_VDD_SEL           2                  0x2              
 * 0x011A[3]     OUT3_VDD_SEL_EN        1                  0x1              
 * 0x011A[7:6]   OUT3_INV               0                  0x0              
 * 0x011C[0]     OUT4_PDN               1                  0x1              
 * 0x011C[1]     OUT4_OE                0                  0x0              
 * 0x011C[2]     OUT4_RDIV_FORCE2       0                  0x0              
 * 0x011D[2:0]   OUT4_FORMAT            1                  0x1              
 * 0x011D[3]     OUT4_SYNC_EN           1                  0x1              
 * 0x011D[5:4]   OUT4_DIS_STATE         0                  0x0              
 * 0x011D[7:6]   OUT4_CMOS_DRV          0                  0x0              
 * 0x011E[3:0]   OUT4_CM                11                 0xB              
 * 0x011E[6:4]   OUT4_AMPL              3                  0x3              
 * 0x011F[2:0]   OUT4_MUX_SEL           0                  0x0              
 * 0x011F[5:4]   OUT4_VDD_SEL           2                  0x2              
 * 0x011F[3]     OUT4_VDD_SEL_EN        1                  0x1              
 * 0x011F[7:6]   OUT4_INV               0                  0x0              
 * 0x0121[0]     OUT5_PDN               0                  0x0              
 * 0x0121[1]     OUT5_OE                1                  0x1              
 * 0x0121[2]     OUT5_RDIV_FORCE2       0                  0x0              
 * 0x0122[2:0]   OUT5_FORMAT            1                  0x1              
 * 0x0122[3]     OUT5_SYNC_EN           1                  0x1              
 * 0x0122[5:4]   OUT5_DIS_STATE         0                  0x0              
 * 0x0122[7:6]   OUT5_CMOS_DRV          0                  0x0              
 * 0x0123[3:0]   OUT5_CM                11                 0xB              
 * 0x0123[6:4]   OUT5_AMPL              3                  0x3              
 * 0x0124[2:0]   OUT5_MUX_SEL           1                  0x1              
 * 0x0124[5:4]   OUT5_VDD_SEL           2                  0x2              
 * 0x0124[3]     OUT5_VDD_SEL_EN        1                  0x1              
 * 0x0124[7:6]   OUT5_INV               0                  0x0              
 * 0x0126[0]     OUT6_PDN               1                  0x1              
 * 0x0126[1]     OUT6_OE                0                  0x0              
 * 0x0126[2]     OUT6_RDIV_FORCE2       0                  0x0              
 * 0x0127[2:0]   OUT6_FORMAT            1                  0x1              
 * 0x0127[3]     OUT6_SYNC_EN           1                  0x1              
 * 0x0127[5:4]   OUT6_DIS_STATE         0                  0x0              
 * 0x0127[7:6]   OUT6_CMOS_DRV          0                  0x0              
 * 0x0128[3:0]   OUT6_CM                11                 0xB              
 * 0x0128[6:4]   OUT6_AMPL              3                  0x3              
 * 0x0129[2:0]   OUT6_MUX_SEL           0                  0x0              
 * 0x0129[5:4]   OUT6_VDD_SEL           2                  0x2              
 * 0x0129[3]     OUT6_VDD_SEL_EN        1                  0x1              
 * 0x0129[7:6]   OUT6_INV               0                  0x0              
 * 0x012B[0]     OUT7_PDN               1                  0x1              
 * 0x012B[1]     OUT7_OE                0                  0x0              
 * 0x012B[2]     OUT7_RDIV_FORCE2       0                  0x0              
 * 0x012C[2:0]   OUT7_FORMAT            1                  0x1              
 * 0x012C[3]     OUT7_SYNC_EN           1                  0x1              
 * 0x012C[5:4]   OUT7_DIS_STATE         0                  0x0              
 * 0x012C[7:6]   OUT7_CMOS_DRV          0                  0x0              
 * 0x012D[3:0]   OUT7_CM                11                 0xB              
 * 0x012D[6:4]   OUT7_AMPL              3                  0x3              
 * 0x012E[2:0]   OUT7_MUX_SEL           0                  0x0              
 * 0x012E[5:4]   OUT7_VDD_SEL           2                  0x2              
 * 0x012E[3]     OUT7_VDD_SEL_EN        1                  0x1              
 * 0x012E[7:6]   OUT7_INV               0                  0x0              
 * 0x0130[0]     OUT8_PDN               0                  0x0              
 * 0x0130[1]     OUT8_OE                1                  0x1              
 * 0x0130[2]     OUT8_RDIV_FORCE2       0                  0x0              
 * 0x0131[2:0]   OUT8_FORMAT            1                  0x1              
 * 0x0131[3]     OUT8_SYNC_EN           1                  0x1              
 * 0x0131[5:4]   OUT8_DIS_STATE         0                  0x0              
 * 0x0131[7:6]   OUT8_CMOS_DRV          0                  0x0              
 * 0x0132[3:0]   OUT8_CM                11                 0xB              
 * 0x0132[6:4]   OUT8_AMPL              3                  0x3              
 * 0x0133[2:0]   OUT8_MUX_SEL           2                  0x2              
 * 0x0133[5:4]   OUT8_VDD_SEL           2                  0x2              
 * 0x0133[3]     OUT8_VDD_SEL_EN        1                  0x1              
 * 0x0133[7:6]   OUT8_INV               0                  0x0              
 * 0x013A[0]     OUT9_PDN               1                  0x1              
 * 0x013A[1]     OUT9_OE                0                  0x0              
 * 0x013A[2]     OUT9_RDIV_FORCE2       0                  0x0              
 * 0x013B[2:0]   OUT9_FORMAT            1                  0x1              
 * 0x013B[3]     OUT9_SYNC_EN           1                  0x1              
 * 0x013B[5:4]   OUT9_DIS_STATE         0                  0x0              
 * 0x013B[7:6]   OUT9_CMOS_DRV          0                  0x0              
 * 0x013C[3:0]   OUT9_CM                11                 0xB              
 * 0x013C[6:4]   OUT9_AMPL              3                  0x3              
 * 0x013D[2:0]   OUT9_MUX_SEL           0                  0x0              
 * 0x013D[5:4]   OUT9_VDD_SEL           2                  0x2              
 * 0x013D[3]     OUT9_VDD_SEL_EN        1                  0x1              
 * 0x013D[7:6]   OUT9_INV               0                  0x0              
 * 0x013F[11:0]  OUTX_ALWAYS_ON         0                  0x000            
 * 0x0141[1]     OUT_DIS_MSK            0                  0x0              
 * 0x0141[5]     OUT_DIS_LOL_MSK        0                  0x0              
 * 0x0141[6]     OUT_DIS_LOSXAXB_MSK    1                  0x1              
 * 0x0141[7]     OUT_DIS_MSK_LOS_PFD    0                  0x0              
 * 0x0142[1]     OUT_DIS_MSK_LOL        1                  0x1              
 * 0x0142[5]     OUT_DIS_MSK_HOLD       1                  0x1              
 * 0x0206[1:0]   PXAXB                  0                  0x0              
 * 0x0208[47:0]  P0_NUM                 1                  0x000000000001   
 * 0x020E[31:0]  P0_DEN                 1                  0x00000001       
 * 0x0212[47:0]  P1_NUM                 0                  0x000000000000   
 * 0x0218[31:0]  P1_DEN                 0                  0x00000000       
 * 0x021C[47:0]  P2_NUM                 0                  0x000000000000   
 * 0x0222[31:0]  P2_DEN                 0                  0x00000000       
 * 0x0226[47:0]  P3_NUM                 0                  0x000000000000   
 * 0x022C[31:0]  P3_DEN                 0                  0x00000000       
 * 0x0231[3:0]   P0_FRACN_MODE          11                 0xB              
 * 0x0231[4]     P0_FRACN_EN            0                  0x0              
 * 0x0232[3:0]   P1_FRACN_MODE          11                 0xB              
 * 0x0232[4]     P1_FRACN_EN            0                  0x0              
 * 0x0233[3:0]   P2_FRACN_MODE          11                 0xB              
 * 0x0233[4]     P2_FRACN_EN            0                  0x0              
 * 0x0234[3:0]   P3_FRACN_MODE          11                 0xB              
 * 0x0234[4]     P3_FRACN_EN            0                  0x0              
 * 0x0235[43:0]  MXAXB_NUM              916841299968       0x0D578000000    
 * 0x023B[31:0]  MXAXB_DEN              3489660928         0xD0000000       
 * 0x024A[23:0]  R0_REG                 10                 0x00000A         
 * 0x024D[23:0]  R1_REG                 0                  0x000000         
 * 0x0250[23:0]  R2_REG                 1                  0x000001         
 * 0x0253[23:0]  R3_REG                 0                  0x000000         
 * 0x0256[23:0]  R4_REG                 0                  0x000000         
 * 0x0259[23:0]  R5_REG                 2                  0x000002         
 * 0x025C[23:0]  R6_REG                 0                  0x000000         
 * 0x025F[23:0]  R7_REG                 0                  0x000000         
 * 0x0262[23:0]  R8_REG                 2                  0x000002         
 * 0x0268[23:0]  R9_REG                 0                  0x000000         
 * 0x026B[7:0]   DESIGN_ID0             73                 0x49             
 * 0x026C[7:0]   DESIGN_ID1             79                 0x4F             
 * 0x026D[7:0]   DESIGN_ID2             52                 0x34             
 * 0x026E[7:0]   DESIGN_ID3             75                 0x4B             
 * 0x026F[7:0]   DESIGN_ID4             43                 0x2B             
 * 0x0270[7:0]   DESIGN_ID5             0                  0x00             
 * 0x0271[7:0]   DESIGN_ID6             0                  0x00             
 * 0x0272[7:0]   DESIGN_ID7             0                  0x00             
 * 0x0294[7:4]   FASTLOCK_EXTEND_SCL    8                  0x8              
 * 0x0296[1]     LOL_SLW_VALWIN_SELX    0                  0x0              
 * 0x0297[1]     FASTLOCK_DLY_ONSW_EN   1                  0x1              
 * 0x0299[1]     FASTLOCK_DLY_ONLOL_EN  1                  0x1              
 * 0x029D[19:0]  FASTLOCK_DLY_ONLOL     3829               0x00EF5          
 * 0x02A9[19:0]  FASTLOCK_DLY_ONSW      9830               0x02666          
 * 0x02B7[3:2]   LOL_NOSIG_TIME         3                  0x3              
 * 0x0302[43:0]  N0_NUM                 49392123904        0x00B80000000    
 * 0x0308[31:0]  N0_DEN                 2147483648         0x80000000       
 * 0x030C[0]     N0_UPDATE              0                  0x0              
 * 0x030D[43:0]  N1_NUM                 198967296000       0x02E53600000    
 * 0x0313[31:0]  N1_DEN                 2147483648         0x80000000       
 * 0x0317[0]     N1_UPDATE              0                  0x0              
 * 0x0318[43:0]  N2_NUM                 48282730496        0x00B3DE00000    
 * 0x031E[31:0]  N2_DEN                 3145728000         0xBB800000       
 * 0x0322[0]     N2_UPDATE              0                  0x0              
 * 0x0323[43:0]  N3_NUM                 0                  0x00000000000    
 * 0x0329[31:0]  N3_DEN                 0                  0x00000000       
 * 0x032D[0]     N3_UPDATE              0                  0x0              
 * 0x032E[43:0]  N4_NUM                 0                  0x00000000000    
 * 0x0334[31:0]  N4_DEN                 0                  0x00000000       
 * 0x0338[0]     N4_UPDATE              0                  0x0              
 * 0x0338[1]     N_UPDATE               0                  0x0              
 * 0x0339[4:0]   N_FSTEP_MSK            31                 0x1F             
 * 0x033B[43:0]  N0_FSTEPW              0                  0x00000000000    
 * 0x0341[43:0]  N1_FSTEPW              0                  0x00000000000    
 * 0x0347[43:0]  N2_FSTEPW              0                  0x00000000000    
 * 0x034D[43:0]  N3_FSTEPW              0                  0x00000000000    
 * 0x0353[43:0]  N4_FSTEPW              0                  0x00000000000    
 * 0x0359[15:0]  N0_DELAY               0                  0x0000           
 * 0x035B[15:0]  N1_DELAY               0                  0x0000           
 * 0x035D[15:0]  N2_DELAY               0                  0x0000           
 * 0x035F[15:0]  N3_DELAY               0                  0x0000           
 * 0x0361[15:0]  N4_DELAY               0                  0x0000           
 * 0x0487[0]     ZDM_EN                 0                  0x0              
 * 0x0487[2:1]   ZDM_IN_SEL             0                  0x0              
 * 0x0487[4]     ZDM_AUTOSW_EN          0                  0x0              
 * 0x0502[4]     ADD_DIV256             0                  0x0              
 * 0x0508[5:0]   BW0_PLL                17                 0x11             
 * 0x0509[5:0]   BW1_PLL                25                 0x19             
 * 0x050A[5:0]   BW2_PLL                15                 0x0F             
 * 0x050B[5:0]   BW3_PLL                15                 0x0F             
 * 0x050C[5:0]   BW4_PLL                1                  0x01             
 * 0x050D[5:0]   BW5_PLL                15                 0x0F             
 * 0x050E[5:0]   FASTLOCK_BW0_PLL       24                 0x18             
 * 0x050F[5:0]   FASTLOCK_BW1_PLL       41                 0x29             
 * 0x0510[5:0]   FASTLOCK_BW2_PLL       12                 0x0C             
 * 0x0511[5:0]   FASTLOCK_BW3_PLL       11                 0x0B             
 * 0x0512[5:0]   FASTLOCK_BW4_PLL       1                  0x01             
 * 0x0513[5:0]   FASTLOCK_BW5_PLL       15                 0x0F             
 * 0x0515[55:0]  M_NUM                  86930138071040     0x004F1000000000 
 * 0x051C[31:0]  M_DEN                  2147483648         0x80000000       
 * 0x0521[3:0]   M_FRAC_MODE            11                 0xB              
 * 0x0521[4]     M_FRAC_EN              0                  0x0              
 * 0x0521[5]     PLL_OUT_RATE_SEL       1                  0x1              
 * 0x052A[0]     IN_SEL_REGCTRL         1                  0x1              
 * 0x052A[3:1]   IN_SEL                 0                  0x0              
 * 0x052B[0]     FASTLOCK_AUTO_EN       1                  0x1              
 * 0x052B[1]     FASTLOCK_MAN           0                  0x0              
 * 0x052C[0]     HOLD_EN                1                  0x1              
 * 0x052C[3]     HOLD_RAMP_BYP          1                  0x1              
 * 0x052C[4]     HOLDEXIT_BW_SEL1       0                  0x0              
 * 0x052C[7:5]   RAMP_STEP_INTERVAL     0                  0x0              
 * 0x052D[1]     HOLD_RAMPBYP_NOHIST    1                  0x1              
 * 0x052E[4:0]   HOLD_HIST_LEN          21                 0x15             
 * 0x052F[4:0]   HOLD_HIST_DELAY        20                 0x14             
 * 0x0531[4:0]   HOLD_REF_COUNT_FRC     0                  0x00             
 * 0x0532[23:0]  HOLD_15M_CYC_COUNT     24692              0x006074         
 * 0x0535[0]     FORCE_HOLD             0                  0x0              
 * 0x0536[1:0]   CLK_SWITCH_MODE        0                  0x0              
 * 0x0536[2]     HSW_EN                 0                  0x0              
 * 0x0537[3:0]   IN_LOS_MSK             0                  0x0              
 * 0x0537[7:4]   IN_OOF_MSK             0                  0x0              
 * 0x0538[2:0]   IN0_PRIORITY           0                  0x0              
 * 0x0538[6:4]   IN1_PRIORITY           0                  0x0              
 * 0x0539[2:0]   IN2_PRIORITY           0                  0x0              
 * 0x0539[6:4]   IN3_PRIORITY           0                  0x0              
 * 0x053A[1:0]   HSW_MODE               2                  0x2              
 * 0x053A[3:2]   HSW_PHMEAS_CTRL        0                  0x0              
 * 0x053B[9:0]   HSW_PHMEAS_THR         3                  0x003            
 * 0x053D[4:0]   HSW_COARSE_PM_LEN      19                 0x13             
 * 0x053E[4:0]   HSW_COARSE_PM_DLY      6                  0x06             
 * 0x0589[12:0]  CAP_SHORT_DELAY        402                0x0192           
 * 0x059B[4]     HOLD_PRESERVE_HIST     1                  0x1              
 * 0x059B[5]     HOLD_FRZ_WITH_INTONLY  1                  0x1              
 * 0x059B[6]     HOLDEXIT_BW_SEL0       1                  0x1              
 * 0x059B[7]     HOLDEXIT_STD_BO        1                  0x1              
 * 0x059D[5:0]   HOLDEXIT_BW0           24                 0x18             
 * 0x059E[5:0]   HOLDEXIT_BW1           41                 0x29             
 * 0x059F[5:0]   HOLDEXIT_BW2           12                 0x0C             
 * 0x05A0[5:0]   HOLDEXIT_BW3           11                 0x0B             
 * 0x05A1[5:0]   HOLDEXIT_BW4           1                  0x01             
 * 0x05A2[5:0]   HOLDEXIT_BW5           15                 0x0F             
 * 0x05A6[2:0]   RAMP_STEP_SIZE         0                  0x0              
 * 0x05A6[3]     RAMP_SWITCH_EN         0                  0x0              
 * 0x0802[15:0]  FIXREGSA0              1333               0x0535           
 * 0x0804[7:0]   FIXREGSD0              0                  0x00             
 * 0x0805[15:0]  FIXREGSA1              0                  0x0000           
 * 0x0807[7:0]   FIXREGSD1              0                  0x00             
 * 0x0808[15:0]  FIXREGSA2              0                  0x0000           
 * 0x080A[7:0]   FIXREGSD2              0                  0x00             
 * 0x080B[15:0]  FIXREGSA3              0                  0x0000           
 * 0x080D[7:0]   FIXREGSD3              0                  0x00             
 * 0x080E[15:0]  FIXREGSA4              0                  0x0000           
 * 0x0810[7:0]   FIXREGSD4              0                  0x00             
 * 0x0811[15:0]  FIXREGSA5              0                  0x0000           
 * 0x0813[7:0]   FIXREGSD5              0                  0x00             
 * 0x0814[15:0]  FIXREGSA6              0                  0x0000           
 * 0x0816[7:0]   FIXREGSD6              0                  0x00             
 * 0x0817[15:0]  FIXREGSA7              0                  0x0000           
 * 0x0819[7:0]   FIXREGSD7              0                  0x00             
 * 0x081A[15:0]  FIXREGSA8              0                  0x0000           
 * 0x081C[7:0]   FIXREGSD8              0                  0x00             
 * 0x081D[15:0]  FIXREGSA9              0                  0x0000           
 * 0x081F[7:0]   FIXREGSD9              0                  0x00             
 * 0x0820[15:0]  FIXREGSA10             0                  0x0000           
 * 0x0822[7:0]   FIXREGSD10             0                  0x00             
 * 0x0823[15:0]  FIXREGSA11             0                  0x0000           
 * 0x0825[7:0]   FIXREGSD11             0                  0x00             
 * 0x0826[15:0]  FIXREGSA12             0                  0x0000           
 * 0x0828[7:0]   FIXREGSD12             0                  0x00             
 * 0x0829[15:0]  FIXREGSA13             0                  0x0000           
 * 0x082B[7:0]   FIXREGSD13             0                  0x00             
 * 0x082C[15:0]  FIXREGSA14             0                  0x0000           
 * 0x082E[7:0]   FIXREGSD14             0                  0x00             
 * 0x082F[15:0]  FIXREGSA15             0                  0x0000           
 * 0x0831[7:0]   FIXREGSD15             0                  0x00             
 * 0x0832[15:0]  FIXREGSA16             0                  0x0000           
 * 0x0834[7:0]   FIXREGSD16             0                  0x00             
 * 0x0835[15:0]  FIXREGSA17             0                  0x0000           
 * 0x0837[7:0]   FIXREGSD17             0                  0x00             
 * 0x0838[15:0]  FIXREGSA18             0                  0x0000           
 * 0x083A[7:0]   FIXREGSD18             0                  0x00             
 * 0x083B[15:0]  FIXREGSA19             0                  0x0000           
 * 0x083D[7:0]   FIXREGSD19             0                  0x00             
 * 0x083E[15:0]  FIXREGSA20             0                  0x0000           
 * 0x0840[7:0]   FIXREGSD20             0                  0x00             
 * 0x0841[15:0]  FIXREGSA21             0                  0x0000           
 * 0x0843[7:0]   FIXREGSD21             0                  0x00             
 * 0x0844[15:0]  FIXREGSA22             0                  0x0000           
 * 0x0846[7:0]   FIXREGSD22             0                  0x00             
 * 0x0847[15:0]  FIXREGSA23             0                  0x0000           
 * 0x0849[7:0]   FIXREGSD23             0                  0x00             
 * 0x084A[15:0]  FIXREGSA24             0                  0x0000           
 * 0x084C[7:0]   FIXREGSD24             0                  0x00             
 * 0x084D[15:0]  FIXREGSA25             0                  0x0000           
 * 0x084F[7:0]   FIXREGSD25             0                  0x00             
 * 0x0850[15:0]  FIXREGSA26             0                  0x0000           
 * 0x0852[7:0]   FIXREGSD26             0                  0x00             
 * 0x0853[15:0]  FIXREGSA27             0                  0x0000           
 * 0x0855[7:0]   FIXREGSD27             0                  0x00             
 * 0x0856[15:0]  FIXREGSA28             0                  0x0000           
 * 0x0858[7:0]   FIXREGSD28             0                  0x00             
 * 0x0859[15:0]  FIXREGSA29             0                  0x0000           
 * 0x085B[7:0]   FIXREGSD29             0                  0x00             
 * 0x085C[15:0]  FIXREGSA30             0                  0x0000           
 * 0x085E[7:0]   FIXREGSD30             0                  0x00             
 * 0x085F[15:0]  FIXREGSA31             0                  0x0000           
 * 0x0861[7:0]   FIXREGSD31             0                  0x00             
 * 0x090E[0]     XAXB_EXTCLK_EN         1                  0x1              
 * 0x0943[0]     IO_VDD_SEL             0                  0x0              
 * 0x0949[3:0]   IN_EN                  1                  0x1              
 * 0x0949[7:4]   IN_PULSED_CMOS_EN      3                  0x3              
 * 0x094A[3:0]   INX_TO_PFD_EN          1                  0x1              
 * 0x094E[11:0]  REFCLK_HYS_SEL         585                0x249            
 * 0x095E[0]     MXAXB_INTEGER          0                  0x0              
 * 0x0A02[4:0]   N_ADD_0P5              0                  0x00             
 * 0x0A03[4:0]   N_CLK_TO_OUTX_EN       7                  0x07             
 * 0x0A04[4:0]   N_PIBYP                1                  0x01             
 * 0x0A05[4:0]   N_PDNB                 7                  0x07             
 * 0x0A14[3]     N0_HIGH_FREQ           0                  0x0              
 * 0x0A1A[3]     N1_HIGH_FREQ           0                  0x0              
 * 0x0A20[3]     N2_HIGH_FREQ           0                  0x0              
 * 0x0A26[3]     N3_HIGH_FREQ           0                  0x0              
 * 0x0A2C[3]     N4_HIGH_FREQ           0                  0x0              
 * 0x0B44[3:0]   PDIV_FRACN_CLK_DIS     15                 0xF              
 * 0x0B44[5]     FRACN_CLK_DIS_PLL      1                  0x1              
 * 0x0B46[3:0]   LOS_CLK_DIS            0                  0x0              
 * 0x0B47[4:0]   OOF_CLK_DIS            14                 0x0E             
 * 0x0B48[4:0]   OOF_DIV_CLK_DIS        14                 0x0E             
 * 0x0B4A[4:0]   N_CLK_DIS              24                 0x18             
 * 0x0B57[11:0]  VCO_RESET_CALCODE      249                0x0F9
 * 
 *
 */


static struct ntv2_genlock_data s_genlock_2250_2398[] =
{
	/* Start configuration preamble */
	{ 0x0B24, 0xC0 },
	{ 0x0B25, 0x00 },
	{ 0x0540, 0x01 },
	/* End configuration preamble */

	/* Delay 300 msec */
	/*    Delay is worst case time for device to complete any calibration */
	/*    that is running due to device state change previous to this script */
	/*    being processed. */
	{ 0x0000, 0x01 },

	/* Start configuration registers */
	{ 0x000B, 0x64 },
	{ 0x0016, 0x02 },
	{ 0x0017, 0xFC },
	{ 0x0018, 0xFF },
	{ 0x0019, 0xDF },
	{ 0x001A, 0xDF },
	{ 0x002B, 0x02 },
	{ 0x002C, 0x01 },
	{ 0x002D, 0x02 },
	{ 0x002E, 0xC0 },
	{ 0x002F, 0x04 },
	{ 0x0030, 0x00 },
	{ 0x0031, 0x00 },
	{ 0x0032, 0x00 },
	{ 0x0033, 0x00 },
	{ 0x0034, 0x00 },
	{ 0x0035, 0x00 },
	{ 0x0036, 0x5B },
	{ 0x0037, 0x04 },
	{ 0x0038, 0x00 },
	{ 0x0039, 0x00 },
	{ 0x003A, 0x00 },
	{ 0x003B, 0x00 },
	{ 0x003C, 0x00 },
	{ 0x003D, 0x00 },
	{ 0x003F, 0x01 },
	{ 0x0040, 0x04 },
	{ 0x0041, 0x02 },
	{ 0x0042, 0x00 },
	{ 0x0043, 0x00 },
	{ 0x0044, 0x00 },
	{ 0x0045, 0x0C },
	{ 0x0046, 0x96 },
	{ 0x0047, 0x00 },
	{ 0x0048, 0x00 },
	{ 0x0049, 0x00 },
	{ 0x004A, 0x4B },
	{ 0x004B, 0x00 },
	{ 0x004C, 0x00 },
	{ 0x004D, 0x00 },
	{ 0x004E, 0x05 },
	{ 0x004F, 0x00 },
	{ 0x0050, 0x0F },
	{ 0x0051, 0x00 },
	{ 0x0052, 0x00 },
	{ 0x0053, 0x00 },
	{ 0x0054, 0x00 },
	{ 0x0055, 0x00 },
	{ 0x0056, 0x00 },
	{ 0x0057, 0x00 },
	{ 0x0058, 0x00 },
	{ 0x0059, 0x01 },
	{ 0x005A, 0x5A },
	{ 0x005B, 0xF4 },
	{ 0x005C, 0x0F },
	{ 0x005D, 0x01 },
	{ 0x005E, 0x00 },
	{ 0x005F, 0x00 },
	{ 0x0060, 0x00 },
	{ 0x0061, 0x00 },
	{ 0x0062, 0x00 },
	{ 0x0063, 0x00 },
	{ 0x0064, 0x00 },
	{ 0x0065, 0x00 },
	{ 0x0066, 0x00 },
	{ 0x0067, 0x00 },
	{ 0x0068, 0x00 },
	{ 0x0069, 0x00 },
	{ 0x0092, 0x02 },
	{ 0x0093, 0xA0 },
	{ 0x0095, 0x00 },
	{ 0x0096, 0x90 },
	{ 0x0098, 0x70 },
	{ 0x009A, 0x02 },
	{ 0x009B, 0x50 },
	{ 0x009D, 0x04 },
	{ 0x009E, 0x60 },
	{ 0x00A0, 0x30 },
	{ 0x00A2, 0x00 },
	{ 0x00A9, 0xB3 },
	{ 0x00AA, 0xB1 },
	{ 0x00AB, 0x04 },
	{ 0x00AC, 0x00 },
	{ 0x00E5, 0x21 },
	{ 0x00EA, 0xD1 },
	{ 0x00EB, 0xB1 },
	{ 0x00EC, 0x03 },
	{ 0x00ED, 0x00 },
	{ 0x0102, 0x01 },
	{ 0x0108, 0x02 },
	{ 0x0109, 0x09 },
	{ 0x010A, 0x3B },
	{ 0x010B, 0x28 },
	{ 0x010D, 0x01 },
	{ 0x010E, 0x09 },
	{ 0x010F, 0x3B },
	{ 0x0110, 0x28 },
	{ 0x0112, 0x02 },
	{ 0x0113, 0x09 },
	{ 0x0114, 0x3B },
	{ 0x0115, 0x28 },
	{ 0x0117, 0x01 },
	{ 0x0118, 0x09 },
	{ 0x0119, 0x3B },
	{ 0x011A, 0x28 },
	{ 0x011C, 0x01 },
	{ 0x011D, 0x09 },
	{ 0x011E, 0x3B },
	{ 0x011F, 0x28 },
	{ 0x0121, 0x02 },
	{ 0x0122, 0x09 },
	{ 0x0123, 0x3B },
	{ 0x0124, 0x29 },
	{ 0x0126, 0x01 },
	{ 0x0127, 0x09 },
	{ 0x0128, 0x3B },
	{ 0x0129, 0x28 },
	{ 0x012B, 0x01 },
	{ 0x012C, 0x09 },
	{ 0x012D, 0x3B },
	{ 0x012E, 0x28 },
	{ 0x0130, 0x02 },
	{ 0x0131, 0x09 },
	{ 0x0132, 0x3B },
	{ 0x0133, 0x2A },
	{ 0x013A, 0x01 },
	{ 0x013B, 0x09 },
	{ 0x013C, 0x3B },
	{ 0x013D, 0x28 },
	{ 0x013F, 0x00 },
	{ 0x0140, 0x00 },
	{ 0x0141, 0x40 },
	{ 0x0142, 0xFF },
	{ 0x0206, 0x00 },
	{ 0x0208, 0x01 },
	{ 0x0209, 0x00 },
	{ 0x020A, 0x00 },
	{ 0x020B, 0x00 },
	{ 0x020C, 0x00 },
	{ 0x020D, 0x00 },
	{ 0x020E, 0x01 },
	{ 0x020F, 0x00 },
	{ 0x0210, 0x00 },
	{ 0x0211, 0x00 },
	{ 0x0212, 0x00 },
	{ 0x0213, 0x00 },
	{ 0x0214, 0x00 },
	{ 0x0215, 0x00 },
	{ 0x0216, 0x00 },
	{ 0x0217, 0x00 },
	{ 0x0218, 0x00 },
	{ 0x0219, 0x00 },
	{ 0x021A, 0x00 },
	{ 0x021B, 0x00 },
	{ 0x021C, 0x00 },
	{ 0x021D, 0x00 },
	{ 0x021E, 0x00 },
	{ 0x021F, 0x00 },
	{ 0x0220, 0x00 },
	{ 0x0221, 0x00 },
	{ 0x0222, 0x00 },
	{ 0x0223, 0x00 },
	{ 0x0224, 0x00 },
	{ 0x0225, 0x00 },
	{ 0x0226, 0x00 },
	{ 0x0227, 0x00 },
	{ 0x0228, 0x00 },
	{ 0x0229, 0x00 },
	{ 0x022A, 0x00 },
	{ 0x022B, 0x00 },
	{ 0x022C, 0x00 },
	{ 0x022D, 0x00 },
	{ 0x022E, 0x00 },
	{ 0x022F, 0x00 },
	{ 0x0231, 0x0B },
	{ 0x0232, 0x0B },
	{ 0x0233, 0x0B },
	{ 0x0234, 0x0B },
	{ 0x0235, 0x00 },
	{ 0x0236, 0x00 },
	{ 0x0237, 0x00 },
	{ 0x0238, 0x78 },
	{ 0x0239, 0xD5 },
	{ 0x023A, 0x00 },
	{ 0x023B, 0x00 },
	{ 0x023C, 0x00 },
	{ 0x023D, 0x00 },
	{ 0x023E, 0xD0 },
	{ 0x024A, 0x0A },
	{ 0x024B, 0x00 },
	{ 0x024C, 0x00 },
	{ 0x024D, 0x00 },
	{ 0x024E, 0x00 },
	{ 0x024F, 0x00 },
	{ 0x0250, 0x01 },
	{ 0x0251, 0x00 },
	{ 0x0252, 0x00 },
	{ 0x0253, 0x00 },
	{ 0x0254, 0x00 },
	{ 0x0255, 0x00 },
	{ 0x0256, 0x00 },
	{ 0x0257, 0x00 },
	{ 0x0258, 0x00 },
	{ 0x0259, 0x02 },
	{ 0x025A, 0x00 },
	{ 0x025B, 0x00 },
	{ 0x025C, 0x00 },
	{ 0x025D, 0x00 },
	{ 0x025E, 0x00 },
	{ 0x025F, 0x00 },
	{ 0x0260, 0x00 },
	{ 0x0261, 0x00 },
	{ 0x0262, 0x02 },
	{ 0x0263, 0x00 },
	{ 0x0264, 0x00 },
	{ 0x0268, 0x00 },
	{ 0x0269, 0x00 },
	{ 0x026A, 0x00 },
	{ 0x026B, 0x49 },
	{ 0x026C, 0x4F },
	{ 0x026D, 0x34 },
	{ 0x026E, 0x4B },
	{ 0x026F, 0x2B },
	{ 0x0270, 0x00 },
	{ 0x0271, 0x00 },
	{ 0x0272, 0x00 },
	{ 0x0294, 0x80 },
	{ 0x0296, 0x00 },
	{ 0x0297, 0x02 },
	{ 0x0299, 0x02 },
	{ 0x029D, 0xF5 },
	{ 0x029E, 0x0E },
	{ 0x029F, 0x00 },
	{ 0x02A9, 0x66 },
	{ 0x02AA, 0x26 },
	{ 0x02AB, 0x00 },
	{ 0x02B7, 0xFF },
	{ 0x0302, 0x00 },
	{ 0x0303, 0x00 },
	{ 0x0304, 0x00 },
	{ 0x0305, 0x80 },
	{ 0x0306, 0x0B },
	{ 0x0307, 0x00 },
	{ 0x0308, 0x00 },
	{ 0x0309, 0x00 },
	{ 0x030A, 0x00 },
	{ 0x030B, 0x80 },
	{ 0x030C, 0x00 },
	{ 0x030D, 0x00 },
	{ 0x030E, 0x00 },
	{ 0x030F, 0x60 },
	{ 0x0310, 0x53 },
	{ 0x0311, 0x2E },
	{ 0x0312, 0x00 },
	{ 0x0313, 0x00 },
	{ 0x0314, 0x00 },
	{ 0x0315, 0x00 },
	{ 0x0316, 0x80 },
	{ 0x0317, 0x00 },
	{ 0x0318, 0x00 },
	{ 0x0319, 0x00 },
	{ 0x031A, 0xE0 },
	{ 0x031B, 0x3D },
	{ 0x031C, 0x0B },
	{ 0x031D, 0x00 },
	{ 0x031E, 0x00 },
	{ 0x031F, 0x00 },
	{ 0x0320, 0x80 },
	{ 0x0321, 0xBB },
	{ 0x0322, 0x00 },
	{ 0x0323, 0x00 },
	{ 0x0324, 0x00 },
	{ 0x0325, 0x00 },
	{ 0x0326, 0x00 },
	{ 0x0327, 0x00 },
	{ 0x0328, 0x00 },
	{ 0x0329, 0x00 },
	{ 0x032A, 0x00 },
	{ 0x032B, 0x00 },
	{ 0x032C, 0x00 },
	{ 0x032D, 0x00 },
	{ 0x032E, 0x00 },
	{ 0x032F, 0x00 },
	{ 0x0330, 0x00 },
	{ 0x0331, 0x00 },
	{ 0x0332, 0x00 },
	{ 0x0333, 0x00 },
	{ 0x0334, 0x00 },
	{ 0x0335, 0x00 },
	{ 0x0336, 0x00 },
	{ 0x0337, 0x00 },
	{ 0x0338, 0x00 },
	{ 0x0339, 0x1F },
	{ 0x033B, 0x00 },
	{ 0x033C, 0x00 },
	{ 0x033D, 0x00 },
	{ 0x033E, 0x00 },
	{ 0x033F, 0x00 },
	{ 0x0340, 0x00 },
	{ 0x0341, 0x00 },
	{ 0x0342, 0x00 },
	{ 0x0343, 0x00 },
	{ 0x0344, 0x00 },
	{ 0x0345, 0x00 },
	{ 0x0346, 0x00 },
	{ 0x0347, 0x00 },
	{ 0x0348, 0x00 },
	{ 0x0349, 0x00 },
	{ 0x034A, 0x00 },
	{ 0x034B, 0x00 },
	{ 0x034C, 0x00 },
	{ 0x034D, 0x00 },
	{ 0x034E, 0x00 },
	{ 0x034F, 0x00 },
	{ 0x0350, 0x00 },
	{ 0x0351, 0x00 },
	{ 0x0352, 0x00 },
	{ 0x0353, 0x00 },
	{ 0x0354, 0x00 },
	{ 0x0355, 0x00 },
	{ 0x0356, 0x00 },
	{ 0x0357, 0x00 },
	{ 0x0358, 0x00 },
	{ 0x0359, 0x00 },
	{ 0x035A, 0x00 },
	{ 0x035B, 0x00 },
	{ 0x035C, 0x00 },
	{ 0x035D, 0x00 },
	{ 0x035E, 0x00 },
	{ 0x035F, 0x00 },
	{ 0x0360, 0x00 },
	{ 0x0361, 0x00 },
	{ 0x0362, 0x00 },
	{ 0x0487, 0x00 },
	{ 0x0502, 0x01 },
	{ 0x0508, 0x10 },
	{ 0x0509, 0x18 },
	{ 0x050A, 0x0F },
	{ 0x050B, 0x0F },
	{ 0x050C, 0x01 },
	{ 0x050D, 0x07 },
	{ 0x050E, 0x17 },
	{ 0x050F, 0x28 },
	{ 0x0510, 0x0C },
	{ 0x0511, 0x0B },
	{ 0x0512, 0x01 },
	{ 0x0513, 0x07 },
	{ 0x0515, 0x00 },
	{ 0x0516, 0x00 },
	{ 0x0517, 0x00 },
	{ 0x0518, 0xA0 },
	{ 0x0519, 0xA8 },
	{ 0x051A, 0x7B },
	{ 0x051B, 0x00 },
	{ 0x051C, 0x00 },
	{ 0x051D, 0x00 },
	{ 0x051E, 0x00 },
	{ 0x051F, 0xA0 },
	{ 0x0521, 0x3B },
	{ 0x052A, 0x01 },
	{ 0x052B, 0x01 },
	{ 0x052C, 0x0F },
	{ 0x052D, 0x03 },
	{ 0x052E, 0x15 },
	{ 0x052F, 0x14 },
	{ 0x0531, 0x00 },
	{ 0x0532, 0xB0 },
	{ 0x0533, 0x78 },
	{ 0x0534, 0x00 },
	{ 0x0535, 0x00 },
	{ 0x0536, 0x00 },
	{ 0x0537, 0x00 },
	{ 0x0538, 0x00 },
	{ 0x0539, 0x00 },
	{ 0x053A, 0x02 },
	{ 0x053B, 0x03 },
	{ 0x053C, 0x00 },
	{ 0x053D, 0x13 },
	{ 0x053E, 0x06 },
	{ 0x0589, 0xF8 },
	{ 0x058A, 0x01 },
	{ 0x059B, 0xF8 },
	{ 0x059D, 0x17 },
	{ 0x059E, 0x28 },
	{ 0x059F, 0x0C },
	{ 0x05A0, 0x0B },
	{ 0x05A1, 0x01 },
	{ 0x05A2, 0x07 },
	{ 0x05A6, 0x00 },
	{ 0x0802, 0x35 },
	{ 0x0803, 0x05 },
	{ 0x0804, 0x00 },
	{ 0x0805, 0x00 },
	{ 0x0806, 0x00 },
	{ 0x0807, 0x00 },
	{ 0x0808, 0x00 },
	{ 0x0809, 0x00 },
	{ 0x080A, 0x00 },
	{ 0x080B, 0x00 },
	{ 0x080C, 0x00 },
	{ 0x080D, 0x00 },
	{ 0x080E, 0x00 },
	{ 0x080F, 0x00 },
	{ 0x0810, 0x00 },
	{ 0x0811, 0x00 },
	{ 0x0812, 0x00 },
	{ 0x0813, 0x00 },
	{ 0x0814, 0x00 },
	{ 0x0815, 0x00 },
	{ 0x0816, 0x00 },
	{ 0x0817, 0x00 },
	{ 0x0818, 0x00 },
	{ 0x0819, 0x00 },
	{ 0x081A, 0x00 },
	{ 0x081B, 0x00 },
	{ 0x081C, 0x00 },
	{ 0x081D, 0x00 },
	{ 0x081E, 0x00 },
	{ 0x081F, 0x00 },
	{ 0x0820, 0x00 },
	{ 0x0821, 0x00 },
	{ 0x0822, 0x00 },
	{ 0x0823, 0x00 },
	{ 0x0824, 0x00 },
	{ 0x0825, 0x00 },
	{ 0x0826, 0x00 },
	{ 0x0827, 0x00 },
	{ 0x0828, 0x00 },
	{ 0x0829, 0x00 },
	{ 0x082A, 0x00 },
	{ 0x082B, 0x00 },
	{ 0x082C, 0x00 },
	{ 0x082D, 0x00 },
	{ 0x082E, 0x00 },
	{ 0x082F, 0x00 },
	{ 0x0830, 0x00 },
	{ 0x0831, 0x00 },
	{ 0x0832, 0x00 },
	{ 0x0833, 0x00 },
	{ 0x0834, 0x00 },
	{ 0x0835, 0x00 },
	{ 0x0836, 0x00 },
	{ 0x0837, 0x00 },
	{ 0x0838, 0x00 },
	{ 0x0839, 0x00 },
	{ 0x083A, 0x00 },
	{ 0x083B, 0x00 },
	{ 0x083C, 0x00 },
	{ 0x083D, 0x00 },
	{ 0x083E, 0x00 },
	{ 0x083F, 0x00 },
	{ 0x0840, 0x00 },
	{ 0x0841, 0x00 },
	{ 0x0842, 0x00 },
	{ 0x0843, 0x00 },
	{ 0x0844, 0x00 },
	{ 0x0845, 0x00 },
	{ 0x0846, 0x00 },
	{ 0x0847, 0x00 },
	{ 0x0848, 0x00 },
	{ 0x0849, 0x00 },
	{ 0x084A, 0x00 },
	{ 0x084B, 0x00 },
	{ 0x084C, 0x00 },
	{ 0x084D, 0x00 },
	{ 0x084E, 0x00 },
	{ 0x084F, 0x00 },
	{ 0x0850, 0x00 },
	{ 0x0851, 0x00 },
	{ 0x0852, 0x00 },
	{ 0x0853, 0x00 },
	{ 0x0854, 0x00 },
	{ 0x0855, 0x00 },
	{ 0x0856, 0x00 },
	{ 0x0857, 0x00 },
	{ 0x0858, 0x00 },
	{ 0x0859, 0x00 },
	{ 0x085A, 0x00 },
	{ 0x085B, 0x00 },
	{ 0x085C, 0x00 },
	{ 0x085D, 0x00 },
	{ 0x085E, 0x00 },
	{ 0x085F, 0x00 },
	{ 0x0860, 0x00 },
	{ 0x0861, 0x00 },
	{ 0x090E, 0x03 },
	{ 0x0943, 0x00 },
	{ 0x0949, 0x31 },
	{ 0x094A, 0x01 },
	{ 0x094E, 0x49 },
	{ 0x094F, 0x02 },
	{ 0x095E, 0x00 },
	{ 0x0A02, 0x00 },
	{ 0x0A03, 0x07 },
	{ 0x0A04, 0x01 },
	{ 0x0A05, 0x07 },
	{ 0x0A14, 0x00 },
	{ 0x0A1A, 0x00 },
	{ 0x0A20, 0x00 },
	{ 0x0A26, 0x00 },
	{ 0x0A2C, 0x00 },
	{ 0x0B44, 0x0F },
	{ 0x0B46, 0x00 },
	{ 0x0B47, 0x0E },
	{ 0x0B48, 0x0E },
	{ 0x0B4A, 0x18 },
	{ 0x0B57, 0xF9 },
	{ 0x0B58, 0x00 },
	/* End configuration registers */

	/* Start configuration postamble */
	{ 0x0514, 0x01 },
	{ 0x001C, 0x01 },
	{ 0x0540, 0x00 },
	{ 0x0B24, 0xC3 },
	{ 0x0B25, 0x02 },
	/* End configuration postamble */

	{ 0x0000, 0x00 }
};

/*
 * Design Report
 *
 * Overview
 * ========
 * Part:         Si5345 Rev D
 * Project File: C:\XilinxProjects\flint_tr051017\genlock\FormatFiles\IO4K+_1125_5994.slabtimeproj
 * Design ID:    IO4K+
 * Created By:   ClockBuilder Pro v2.16.1 [2017-07-19]
 * Timestamp:    2017-08-24 16:52:56 GMT-07:00
 * 
 * Design Notes
 * ============
 * assumes NTSC HSYNC (pulsed) input = (30/1.001)*525
 * 
 * Design Rule Check
 * =================
 * Errors:
 * - No errors
 * 
 * Warnings:
 * - Pulsed LVCMOS input buffer mode has been selected. This mode has non-standard input voltage logic thresholds: 0.33 V for Vil (max) and 0.49 V for Vih (min). Select this mode only if your input clock has a duty cycle significantly less or more than 50%.  Refer to the device datasheet for the exact threshold voltage specifications and the input attenuator circuit (DC coupled Pulsed LVCMOS) in the Family Reference Manual.
 * 
 * Device Grade
 * ============
 * Maximum Output Frequency: 148.5 MHz
 * Frequency Synthesis Mode: Fractional
 * Minimum Base OPN:         Si5345B
 * Actual Base OPN:          Si5345B
 * 
 * Base       Output Clock         Supported Frequency Synthesis Modes
 * OPN Grade  Frequency Range      (Typical Jitter)
 * ---------  -------------------  --------------------------------------------
 * Si5345A    100 Hz to 1.028 GHz  Integer (< 100 fs) and fractional (< 150 fs)
 * Si5345B    100 Hz to 350 MHz    "
 * Si5345C    100 Hz to 1.028 GHz  Integer only (< 100 fs)
 * Si5345D    100 Hz to 350 MHz    "
 * 
 * Design
 * ======
 * Host Interface:
 *    I/O Power Supply: VDD (Core)
 *    SPI Mode: 4-Wire
 *    I2C Address Range: 100d to 103d / 0x64 to 0x67 (selected via A0/A1 pins)
 * 
 * XA/XB:
 *    52 MHz (XO - External Oscillator)
 * 
 * Inputs:
 *     IN0: 53.9460539460539460... kHz [ 53 + 947/1001 kHz ]
 *          [ (24000/1001)*2250 ]
 *          Pulsed LVCMOS
 *     IN1: Unused
 *     IN2: Unused
 *     IN3: Unused
 * 
 * Outputs:
 *    OUT0: 27 MHz
 *          Enabled, LVDS 2.5 V
 *    OUT1: Unused
 *    OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT3: Unused
 *    OUT4: Unused
 *    OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT6: Unused
 *    OUT7: Unused
 *    OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *          [ 148.5/1.001 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT9: Unused
 * 
 * Frequency Plan
 * ==============
 * Priority: maximize the number of low jitter outputs
 * 
 * Fvco = 13.662 GHz [ 13 + 331/500 GHz ]
 * Fpfd = 53.9460539460539460... kHz [ 53 + 947/1001 kHz ]
 * Fms0 = 594 MHz
 * Fms1 = 147.456 MHz [ 147 + 57/125 MHz ]
 * Fms2 = 890.1098901098901098... MHz [ 890 + 10/91 MHz ]
 * 
 * P dividers:
 *    P0  = 1
 *    P1  = Unused
 *    P2  = Unused
 *    P3  = Unused
 *    Pxaxb = 1
 * 
 * MXAXB = 262.7307692307692307... [ 262 + 19/26 ]
 * M = 50650.6 [ 50650 + 3/5 ]
 * N dividers:
 *    N0:
 *       Value: 23
 *       Skew:  0.000 s
 *       OUT0: 27 MHz
 *       OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *    N1:
 *       Value: 92.6513671875 [ 92 + 667/1024 ]
 *       Skew:  0.000 s
 *       OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *    N2:
 *       Value: 15.3486666666666666... [ 15 + 523/1500 ]
 *       Skew:  0.000 s
 *       OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *    N3:
 *       Unused
 *    N4:
 *       Unused
 * 
 * R dividers:
 *    R0 = 22
 *    R1 = Unused
 *    R2 = 4
 *    R3 = Unused
 *    R4 = Unused
 *    R5 = 6
 *    R6 = Unused
 *    R7 = Unused
 *    R8 = 6
 *    R9 = Unused
 * 
 * Nominal Bandwidth:
 *   Desired: 1.000 Hz
 *   Actual:  518.917 mHz
 *   Coefficients:
 *      BW0:  16
 *      BW1:  24
 *      BW2:  15
 *      BW3:  15
 *      BW4:  1
 *      BW5:  7
 * Fastlock Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  80.752 Hz
 *   Coefficients:
 *      BW0:  23
 *      BW1:  40
 *      BW2:  12
 *      BW3:  11
 *      BW4:  1
 *      BW5:  7
 * Holdover Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  80.752 Hz
 *   Coefficients:
 *      BW0:  23
 *      BW1:  40
 *      BW2:  12
 *      BW3:  11
 *      BW4:  1
 *      BW5:  7
 * 
 * Dividers listed above show effective values. These values are translated to register settings by ClockBuilder Pro. For the actual register values, see below. Refer to the Family Reference Manual for information on registers related to frequency plan.
 * 
 * Digitally Controlled Oscillator (DCO)
 * =====================================
 * Mode: Register Direct Write
 * 
 * N0: DCO Disabled
 * 
 * N1: DCO Disabled
 * 
 * N2: DCO Disabled
 * 
 * N3: DCO Disabled
 * 
 * N4: DCO Disabled
 * 
 * Estimated Power & Junction Temperature
 * ======================================
 * Assumptions:
 * 
 * Revision: D
 * VDD:      1.8 V
 * Ta:       70 C
 * Airflow:  None
 * 
 * Total Power: 808 mW, On Chip Power: 784 mW, Tj: 87 C
 * 
 *                 Frequency  Format   Voltage   Current     Power
 *         -----------------  ------  --------  --------  --------
 * VDD                                   1.8 V  147.9 mA    266 mW
 * VDDA                                  3.3 V  117.4 mA    387 mW
 * VDDO0              27 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO1              Unused                                      
 * VDDO2           148.5 MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO3              Unused                                      
 * VDDO4              Unused                                      
 * VDDO5          24.576 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO6              Unused                                      
 * VDDO7              Unused                                      
 * VDDO8   148.351648... MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO9              Unused                                      
 *                                              --------  --------
 *                                       Total  327.2 mA    808 mW
 * 
 * Note:
 * 
 * -Total power includes on- and off-chip power. This is a typical value and estimate only.
 * -Use an EVB for a more exact power measurement
 * -On-chip power excludes power dissipated in external terminations.
 * -Tj is junction temperature. Tj must be less than 125 C (on Si5345 Revision D) for device to comply with datasheet specifications.
 * 
 * Settings
 * ========
 * 
 * Location      Setting Name           Decimal Value      Hex Value        
 * ------------  ---------------------  -----------------  -----------------
 * 0x000B[6:0]   I2C_ADDR               100                0x64             
 * 0x0016[1]     LOL_ON_HOLD            1                  0x1              
 * 0x0017[0]     SYSINCAL_INTR_MSK      0                  0x0              
 * 0x0017[1]     LOSXAXB_INTR_MSK       0                  0x0              
 * 0x0017[5]     SMB_TMOUT_INTR_MSK     1                  0x1              
 * 0x0018[3:0]   LOS_INTR_MSK           15                 0xF              
 * 0x0018[7:4]   OOF_INTR_MSK           15                 0xF              
 * 0x0019[1]     LOL_INTR_MSK           1                  0x1              
 * 0x0019[5]     HOLD_INTR_MSK          0                  0x0              
 * 0x001A[5]     CAL_INTR_MSK           0                  0x0              
 * 0x002B[3]     SPI_3WIRE              0                  0x0              
 * 0x002B[5]     AUTO_NDIV_UPDATE       0                  0x0              
 * 0x002C[3:0]   LOS_EN                 1                  0x1              
 * 0x002C[4]     LOSXAXB_DIS            0                  0x0              
 * 0x002D[1:0]   LOS0_VAL_TIME          2                  0x2              
 * 0x002D[3:2]   LOS1_VAL_TIME          0                  0x0              
 * 0x002D[5:4]   LOS2_VAL_TIME          0                  0x0              
 * 0x002D[7:6]   LOS3_VAL_TIME          0                  0x0              
 * 0x002E[15:0]  LOS0_TRG_THR           1216               0x04C0           
 * 0x0030[15:0]  LOS1_TRG_THR           0                  0x0000           
 * 0x0032[15:0]  LOS2_TRG_THR           0                  0x0000           
 * 0x0034[15:0]  LOS3_TRG_THR           0                  0x0000           
 * 0x0036[15:0]  LOS0_CLR_THR           1115               0x045B           
 * 0x0038[15:0]  LOS1_CLR_THR           0                  0x0000           
 * 0x003A[15:0]  LOS2_CLR_THR           0                  0x0000           
 * 0x003C[15:0]  LOS3_CLR_THR           0                  0x0000           
 * 0x003F[3:0]   OOF_EN                 1                  0x1              
 * 0x003F[7:4]   FAST_OOF_EN            0                  0x0              
 * 0x0040[2:0]   OOF_REF_SEL            4                  0x4              
 * 0x0041[4:0]   OOF0_DIV_SEL           2                  0x02             
 * 0x0042[4:0]   OOF1_DIV_SEL           0                  0x00             
 * 0x0043[4:0]   OOF2_DIV_SEL           0                  0x00             
 * 0x0044[4:0]   OOF3_DIV_SEL           0                  0x00             
 * 0x0045[4:0]   OOFXO_DIV_SEL          12                 0x0C             
 * 0x0046[7:0]   OOF0_SET_THR           150                0x96             
 * 0x0047[7:0]   OOF1_SET_THR           0                  0x00             
 * 0x0048[7:0]   OOF2_SET_THR           0                  0x00             
 * 0x0049[7:0]   OOF3_SET_THR           0                  0x00             
 * 0x004A[7:0]   OOF0_CLR_THR           75                 0x4B             
 * 0x004B[7:0]   OOF1_CLR_THR           0                  0x00             
 * 0x004C[7:0]   OOF2_CLR_THR           0                  0x00             
 * 0x004D[7:0]   OOF3_CLR_THR           0                  0x00             
 * 0x004E[2:0]   OOF0_DETWIN_SEL        5                  0x5              
 * 0x004E[6:4]   OOF1_DETWIN_SEL        0                  0x0              
 * 0x004F[2:0]   OOF2_DETWIN_SEL        0                  0x0              
 * 0x004F[6:4]   OOF3_DETWIN_SEL        0                  0x0              
 * 0x0050[3:0]   OOF_ON_LOS             15                 0xF              
 * 0x0051[3:0]   FAST_OOF0_SET_THR      0                  0x0              
 * 0x0052[3:0]   FAST_OOF1_SET_THR      0                  0x0              
 * 0x0053[3:0]   FAST_OOF2_SET_THR      0                  0x0              
 * 0x0054[3:0]   FAST_OOF3_SET_THR      0                  0x0              
 * 0x0055[3:0]   FAST_OOF0_CLR_THR      0                  0x0              
 * 0x0056[3:0]   FAST_OOF1_CLR_THR      0                  0x0              
 * 0x0057[3:0]   FAST_OOF2_CLR_THR      0                  0x0              
 * 0x0058[3:0]   FAST_OOF3_CLR_THR      0                  0x0              
 * 0x0059[1:0]   FAST_OOF0_DETWIN_SEL   1                  0x1              
 * 0x0059[3:2]   FAST_OOF1_DETWIN_SEL   0                  0x0              
 * 0x0059[5:4]   FAST_OOF2_DETWIN_SEL   0                  0x0              
 * 0x0059[7:6]   FAST_OOF3_DETWIN_SEL   0                  0x0              
 * 0x005A[25:0]  OOF0_RATIO_REF         17822810           0x10FF45A        
 * 0x005E[25:0]  OOF1_RATIO_REF         0                  0x0000000        
 * 0x0062[25:0]  OOF2_RATIO_REF         0                  0x0000000        
 * 0x0066[25:0]  OOF3_RATIO_REF         0                  0x0000000        
 * 0x0092[1]     LOL_FST_EN             1                  0x1              
 * 0x0093[7:4]   LOL_FST_DETWIN_SEL     10                 0xA              
 * 0x0095[3:2]   LOL_FST_VALWIN_SEL     0                  0x0              
 * 0x0096[7:4]   LOL_FST_SET_THR_SEL    9                  0x9              
 * 0x0098[7:4]   LOL_FST_CLR_THR_SEL    7                  0x7              
 * 0x009A[1]     LOL_SLOW_EN_PLL        1                  0x1              
 * 0x009B[7:4]   LOL_SLW_DETWIN_SEL     5                  0x5              
 * 0x009D[3:2]   LOL_SLW_VALWIN_SEL     1                  0x1              
 * 0x009E[7:4]   LOL_SLW_SET_THR        6                  0x6              
 * 0x00A0[7:4]   LOL_SLW_CLR_THR        3                  0x3              
 * 0x00A2[1]     LOL_TIMER_EN           0                  0x0              
 * 0x00A9[28:0]  LOL_CLR_DELAY_DIV256   307635             0x0004B1B3       
 * 0x00E5[5]     FASTLOCK_EXTEND_EN     1                  0x1              
 * 0x00EA[28:0]  FASTLOCK_EXTEND        242129             0x0003B1D1       
 * 0x0102[0]     OUTALL_DISABLE_LOW     1                  0x1              
 * 0x0108[0]     OUT0_PDN               0                  0x0              
 * 0x0108[1]     OUT0_OE                1                  0x1              
 * 0x0108[2]     OUT0_RDIV_FORCE2       0                  0x0              
 * 0x0109[2:0]   OUT0_FORMAT            1                  0x1              
 * 0x0109[3]     OUT0_SYNC_EN           1                  0x1              
 * 0x0109[5:4]   OUT0_DIS_STATE         0                  0x0              
 * 0x0109[7:6]   OUT0_CMOS_DRV          0                  0x0              
 * 0x010A[3:0]   OUT0_CM                11                 0xB              
 * 0x010A[6:4]   OUT0_AMPL              3                  0x3              
 * 0x010B[2:0]   OUT0_MUX_SEL           0                  0x0              
 * 0x010B[5:4]   OUT0_VDD_SEL           2                  0x2              
 * 0x010B[3]     OUT0_VDD_SEL_EN        1                  0x1              
 * 0x010B[7:6]   OUT0_INV               0                  0x0              
 * 0x010D[0]     OUT1_PDN               1                  0x1              
 * 0x010D[1]     OUT1_OE                0                  0x0              
 * 0x010D[2]     OUT1_RDIV_FORCE2       0                  0x0              
 * 0x010E[2:0]   OUT1_FORMAT            1                  0x1              
 * 0x010E[3]     OUT1_SYNC_EN           1                  0x1              
 * 0x010E[5:4]   OUT1_DIS_STATE         0                  0x0              
 * 0x010E[7:6]   OUT1_CMOS_DRV          0                  0x0              
 * 0x010F[3:0]   OUT1_CM                11                 0xB              
 * 0x010F[6:4]   OUT1_AMPL              3                  0x3              
 * 0x0110[2:0]   OUT1_MUX_SEL           0                  0x0              
 * 0x0110[5:4]   OUT1_VDD_SEL           2                  0x2              
 * 0x0110[3]     OUT1_VDD_SEL_EN        1                  0x1              
 * 0x0110[7:6]   OUT1_INV               0                  0x0              
 * 0x0112[0]     OUT2_PDN               0                  0x0              
 * 0x0112[1]     OUT2_OE                1                  0x1              
 * 0x0112[2]     OUT2_RDIV_FORCE2       0                  0x0              
 * 0x0113[2:0]   OUT2_FORMAT            1                  0x1              
 * 0x0113[3]     OUT2_SYNC_EN           1                  0x1              
 * 0x0113[5:4]   OUT2_DIS_STATE         0                  0x0              
 * 0x0113[7:6]   OUT2_CMOS_DRV          0                  0x0              
 * 0x0114[3:0]   OUT2_CM                11                 0xB              
 * 0x0114[6:4]   OUT2_AMPL              3                  0x3              
 * 0x0115[2:0]   OUT2_MUX_SEL           0                  0x0              
 * 0x0115[5:4]   OUT2_VDD_SEL           2                  0x2              
 * 0x0115[3]     OUT2_VDD_SEL_EN        1                  0x1              
 * 0x0115[7:6]   OUT2_INV               0                  0x0              
 * 0x0117[0]     OUT3_PDN               1                  0x1              
 * 0x0117[1]     OUT3_OE                0                  0x0              
 * 0x0117[2]     OUT3_RDIV_FORCE2       0                  0x0              
 * 0x0118[2:0]   OUT3_FORMAT            1                  0x1              
 * 0x0118[3]     OUT3_SYNC_EN           1                  0x1              
 * 0x0118[5:4]   OUT3_DIS_STATE         0                  0x0              
 * 0x0118[7:6]   OUT3_CMOS_DRV          0                  0x0              
 * 0x0119[3:0]   OUT3_CM                11                 0xB              
 * 0x0119[6:4]   OUT3_AMPL              3                  0x3              
 * 0x011A[2:0]   OUT3_MUX_SEL           0                  0x0              
 * 0x011A[5:4]   OUT3_VDD_SEL           2                  0x2              
 * 0x011A[3]     OUT3_VDD_SEL_EN        1                  0x1              
 * 0x011A[7:6]   OUT3_INV               0                  0x0              
 * 0x011C[0]     OUT4_PDN               1                  0x1              
 * 0x011C[1]     OUT4_OE                0                  0x0              
 * 0x011C[2]     OUT4_RDIV_FORCE2       0                  0x0              
 * 0x011D[2:0]   OUT4_FORMAT            1                  0x1              
 * 0x011D[3]     OUT4_SYNC_EN           1                  0x1              
 * 0x011D[5:4]   OUT4_DIS_STATE         0                  0x0              
 * 0x011D[7:6]   OUT4_CMOS_DRV          0                  0x0              
 * 0x011E[3:0]   OUT4_CM                11                 0xB              
 * 0x011E[6:4]   OUT4_AMPL              3                  0x3              
 * 0x011F[2:0]   OUT4_MUX_SEL           0                  0x0              
 * 0x011F[5:4]   OUT4_VDD_SEL           2                  0x2              
 * 0x011F[3]     OUT4_VDD_SEL_EN        1                  0x1              
 * 0x011F[7:6]   OUT4_INV               0                  0x0              
 * 0x0121[0]     OUT5_PDN               0                  0x0              
 * 0x0121[1]     OUT5_OE                1                  0x1              
 * 0x0121[2]     OUT5_RDIV_FORCE2       0                  0x0              
 * 0x0122[2:0]   OUT5_FORMAT            1                  0x1              
 * 0x0122[3]     OUT5_SYNC_EN           1                  0x1              
 * 0x0122[5:4]   OUT5_DIS_STATE         0                  0x0              
 * 0x0122[7:6]   OUT5_CMOS_DRV          0                  0x0              
 * 0x0123[3:0]   OUT5_CM                11                 0xB              
 * 0x0123[6:4]   OUT5_AMPL              3                  0x3              
 * 0x0124[2:0]   OUT5_MUX_SEL           1                  0x1              
 * 0x0124[5:4]   OUT5_VDD_SEL           2                  0x2              
 * 0x0124[3]     OUT5_VDD_SEL_EN        1                  0x1              
 * 0x0124[7:6]   OUT5_INV               0                  0x0              
 * 0x0126[0]     OUT6_PDN               1                  0x1              
 * 0x0126[1]     OUT6_OE                0                  0x0              
 * 0x0126[2]     OUT6_RDIV_FORCE2       0                  0x0              
 * 0x0127[2:0]   OUT6_FORMAT            1                  0x1              
 * 0x0127[3]     OUT6_SYNC_EN           1                  0x1              
 * 0x0127[5:4]   OUT6_DIS_STATE         0                  0x0              
 * 0x0127[7:6]   OUT6_CMOS_DRV          0                  0x0              
 * 0x0128[3:0]   OUT6_CM                11                 0xB              
 * 0x0128[6:4]   OUT6_AMPL              3                  0x3              
 * 0x0129[2:0]   OUT6_MUX_SEL           0                  0x0              
 * 0x0129[5:4]   OUT6_VDD_SEL           2                  0x2              
 * 0x0129[3]     OUT6_VDD_SEL_EN        1                  0x1              
 * 0x0129[7:6]   OUT6_INV               0                  0x0              
 * 0x012B[0]     OUT7_PDN               1                  0x1              
 * 0x012B[1]     OUT7_OE                0                  0x0              
 * 0x012B[2]     OUT7_RDIV_FORCE2       0                  0x0              
 * 0x012C[2:0]   OUT7_FORMAT            1                  0x1              
 * 0x012C[3]     OUT7_SYNC_EN           1                  0x1              
 * 0x012C[5:4]   OUT7_DIS_STATE         0                  0x0              
 * 0x012C[7:6]   OUT7_CMOS_DRV          0                  0x0              
 * 0x012D[3:0]   OUT7_CM                11                 0xB              
 * 0x012D[6:4]   OUT7_AMPL              3                  0x3              
 * 0x012E[2:0]   OUT7_MUX_SEL           0                  0x0              
 * 0x012E[5:4]   OUT7_VDD_SEL           2                  0x2              
 * 0x012E[3]     OUT7_VDD_SEL_EN        1                  0x1              
 * 0x012E[7:6]   OUT7_INV               0                  0x0              
 * 0x0130[0]     OUT8_PDN               0                  0x0              
 * 0x0130[1]     OUT8_OE                1                  0x1              
 * 0x0130[2]     OUT8_RDIV_FORCE2       0                  0x0              
 * 0x0131[2:0]   OUT8_FORMAT            1                  0x1              
 * 0x0131[3]     OUT8_SYNC_EN           1                  0x1              
 * 0x0131[5:4]   OUT8_DIS_STATE         0                  0x0              
 * 0x0131[7:6]   OUT8_CMOS_DRV          0                  0x0              
 * 0x0132[3:0]   OUT8_CM                11                 0xB              
 * 0x0132[6:4]   OUT8_AMPL              3                  0x3              
 * 0x0133[2:0]   OUT8_MUX_SEL           2                  0x2              
 * 0x0133[5:4]   OUT8_VDD_SEL           2                  0x2              
 * 0x0133[3]     OUT8_VDD_SEL_EN        1                  0x1              
 * 0x0133[7:6]   OUT8_INV               0                  0x0              
 * 0x013A[0]     OUT9_PDN               1                  0x1              
 * 0x013A[1]     OUT9_OE                0                  0x0              
 * 0x013A[2]     OUT9_RDIV_FORCE2       0                  0x0              
 * 0x013B[2:0]   OUT9_FORMAT            1                  0x1              
 * 0x013B[3]     OUT9_SYNC_EN           1                  0x1              
 * 0x013B[5:4]   OUT9_DIS_STATE         0                  0x0              
 * 0x013B[7:6]   OUT9_CMOS_DRV          0                  0x0              
 * 0x013C[3:0]   OUT9_CM                11                 0xB              
 * 0x013C[6:4]   OUT9_AMPL              3                  0x3              
 * 0x013D[2:0]   OUT9_MUX_SEL           0                  0x0              
 * 0x013D[5:4]   OUT9_VDD_SEL           2                  0x2              
 * 0x013D[3]     OUT9_VDD_SEL_EN        1                  0x1              
 * 0x013D[7:6]   OUT9_INV               0                  0x0              
 * 0x013F[11:0]  OUTX_ALWAYS_ON         0                  0x000            
 * 0x0141[1]     OUT_DIS_MSK            0                  0x0              
 * 0x0141[5]     OUT_DIS_LOL_MSK        0                  0x0              
 * 0x0141[6]     OUT_DIS_LOSXAXB_MSK    1                  0x1              
 * 0x0141[7]     OUT_DIS_MSK_LOS_PFD    0                  0x0              
 * 0x0142[1]     OUT_DIS_MSK_LOL        1                  0x1              
 * 0x0142[5]     OUT_DIS_MSK_HOLD       1                  0x1              
 * 0x0206[1:0]   PXAXB                  0                  0x0              
 * 0x0208[47:0]  P0_NUM                 1                  0x000000000001   
 * 0x020E[31:0]  P0_DEN                 1                  0x00000001       
 * 0x0212[47:0]  P1_NUM                 0                  0x000000000000   
 * 0x0218[31:0]  P1_DEN                 0                  0x00000000       
 * 0x021C[47:0]  P2_NUM                 0                  0x000000000000   
 * 0x0222[31:0]  P2_DEN                 0                  0x00000000       
 * 0x0226[47:0]  P3_NUM                 0                  0x000000000000   
 * 0x022C[31:0]  P3_DEN                 0                  0x00000000       
 * 0x0231[3:0]   P0_FRACN_MODE          11                 0xB              
 * 0x0231[4]     P0_FRACN_EN            0                  0x0              
 * 0x0232[3:0]   P1_FRACN_MODE          11                 0xB              
 * 0x0232[4]     P1_FRACN_EN            0                  0x0              
 * 0x0233[3:0]   P2_FRACN_MODE          11                 0xB              
 * 0x0233[4]     P2_FRACN_EN            0                  0x0              
 * 0x0234[3:0]   P3_FRACN_MODE          11                 0xB              
 * 0x0234[4]     P3_FRACN_EN            0                  0x0              
 * 0x0235[43:0]  MXAXB_NUM              916841299968       0x0D578000000    
 * 0x023B[31:0]  MXAXB_DEN              3489660928         0xD0000000       
 * 0x024A[23:0]  R0_REG                 10                 0x00000A         
 * 0x024D[23:0]  R1_REG                 0                  0x000000         
 * 0x0250[23:0]  R2_REG                 1                  0x000001         
 * 0x0253[23:0]  R3_REG                 0                  0x000000         
 * 0x0256[23:0]  R4_REG                 0                  0x000000         
 * 0x0259[23:0]  R5_REG                 2                  0x000002         
 * 0x025C[23:0]  R6_REG                 0                  0x000000         
 * 0x025F[23:0]  R7_REG                 0                  0x000000         
 * 0x0262[23:0]  R8_REG                 2                  0x000002         
 * 0x0268[23:0]  R9_REG                 0                  0x000000         
 * 0x026B[7:0]   DESIGN_ID0             73                 0x49             
 * 0x026C[7:0]   DESIGN_ID1             79                 0x4F             
 * 0x026D[7:0]   DESIGN_ID2             52                 0x34             
 * 0x026E[7:0]   DESIGN_ID3             75                 0x4B             
 * 0x026F[7:0]   DESIGN_ID4             43                 0x2B             
 * 0x0270[7:0]   DESIGN_ID5             0                  0x00             
 * 0x0271[7:0]   DESIGN_ID6             0                  0x00             
 * 0x0272[7:0]   DESIGN_ID7             0                  0x00             
 * 0x0294[7:4]   FASTLOCK_EXTEND_SCL    8                  0x8              
 * 0x0296[1]     LOL_SLW_VALWIN_SELX    0                  0x0              
 * 0x0297[1]     FASTLOCK_DLY_ONSW_EN   1                  0x1              
 * 0x0299[1]     FASTLOCK_DLY_ONLOL_EN  1                  0x1              
 * 0x029D[19:0]  FASTLOCK_DLY_ONLOL     3829               0x00EF5          
 * 0x02A9[19:0]  FASTLOCK_DLY_ONSW      9830               0x02666          
 * 0x02B7[3:2]   LOL_NOSIG_TIME         3                  0x3              
 * 0x0302[43:0]  N0_NUM                 49392123904        0x00B80000000    
 * 0x0308[31:0]  N0_DEN                 2147483648         0x80000000       
 * 0x030C[0]     N0_UPDATE              0                  0x0              
 * 0x030D[43:0]  N1_NUM                 198967296000       0x02E53600000    
 * 0x0313[31:0]  N1_DEN                 2147483648         0x80000000       
 * 0x0317[0]     N1_UPDATE              0                  0x0              
 * 0x0318[43:0]  N2_NUM                 48282730496        0x00B3DE00000    
 * 0x031E[31:0]  N2_DEN                 3145728000         0xBB800000       
 * 0x0322[0]     N2_UPDATE              0                  0x0              
 * 0x0323[43:0]  N3_NUM                 0                  0x00000000000    
 * 0x0329[31:0]  N3_DEN                 0                  0x00000000       
 * 0x032D[0]     N3_UPDATE              0                  0x0              
 * 0x032E[43:0]  N4_NUM                 0                  0x00000000000    
 * 0x0334[31:0]  N4_DEN                 0                  0x00000000       
 * 0x0338[0]     N4_UPDATE              0                  0x0              
 * 0x0338[1]     N_UPDATE               0                  0x0              
 * 0x0339[4:0]   N_FSTEP_MSK            31                 0x1F             
 * 0x033B[43:0]  N0_FSTEPW              0                  0x00000000000    
 * 0x0341[43:0]  N1_FSTEPW              0                  0x00000000000    
 * 0x0347[43:0]  N2_FSTEPW              0                  0x00000000000    
 * 0x034D[43:0]  N3_FSTEPW              0                  0x00000000000    
 * 0x0353[43:0]  N4_FSTEPW              0                  0x00000000000    
 * 0x0359[15:0]  N0_DELAY               0                  0x0000           
 * 0x035B[15:0]  N1_DELAY               0                  0x0000           
 * 0x035D[15:0]  N2_DELAY               0                  0x0000           
 * 0x035F[15:0]  N3_DELAY               0                  0x0000           
 * 0x0361[15:0]  N4_DELAY               0                  0x0000           
 * 0x0487[0]     ZDM_EN                 0                  0x0              
 * 0x0487[2:1]   ZDM_IN_SEL             0                  0x0              
 * 0x0487[4]     ZDM_AUTOSW_EN          0                  0x0              
 * 0x0502[4]     ADD_DIV256             0                  0x0              
 * 0x0508[5:0]   BW0_PLL                16                 0x10             
 * 0x0509[5:0]   BW1_PLL                24                 0x18             
 * 0x050A[5:0]   BW2_PLL                15                 0x0F             
 * 0x050B[5:0]   BW3_PLL                15                 0x0F             
 * 0x050C[5:0]   BW4_PLL                1                  0x01             
 * 0x050D[5:0]   BW5_PLL                7                  0x07             
 * 0x050E[5:0]   FASTLOCK_BW0_PLL       23                 0x17             
 * 0x050F[5:0]   FASTLOCK_BW1_PLL       40                 0x28             
 * 0x0510[5:0]   FASTLOCK_BW2_PLL       12                 0x0C             
 * 0x0511[5:0]   FASTLOCK_BW3_PLL       11                 0x0B             
 * 0x0512[5:0]   FASTLOCK_BW4_PLL       1                  0x01             
 * 0x0513[5:0]   FASTLOCK_BW5_PLL       7                  0x07             
 * 0x0515[55:0]  M_NUM                  135964169076736    0x007BA8A0000000 
 * 0x051C[31:0]  M_DEN                  2684354560         0xA0000000       
 * 0x0521[3:0]   M_FRAC_MODE            11                 0xB              
 * 0x0521[4]     M_FRAC_EN              1                  0x1              
 * 0x0521[5]     PLL_OUT_RATE_SEL       1                  0x1              
 * 0x052A[0]     IN_SEL_REGCTRL         1                  0x1              
 * 0x052A[3:1]   IN_SEL                 0                  0x0              
 * 0x052B[0]     FASTLOCK_AUTO_EN       1                  0x1              
 * 0x052B[1]     FASTLOCK_MAN           0                  0x0              
 * 0x052C[0]     HOLD_EN                1                  0x1              
 * 0x052C[3]     HOLD_RAMP_BYP          1                  0x1              
 * 0x052C[4]     HOLDEXIT_BW_SEL1       0                  0x0              
 * 0x052C[7:5]   RAMP_STEP_INTERVAL     0                  0x0              
 * 0x052D[1]     HOLD_RAMPBYP_NOHIST    1                  0x1              
 * 0x052E[4:0]   HOLD_HIST_LEN          21                 0x15             
 * 0x052F[4:0]   HOLD_HIST_DELAY        20                 0x14             
 * 0x0531[4:0]   HOLD_REF_COUNT_FRC     0                  0x00             
 * 0x0532[23:0]  HOLD_15M_CYC_COUNT     30896              0x0078B0         
 * 0x0535[0]     FORCE_HOLD             0                  0x0              
 * 0x0536[1:0]   CLK_SWITCH_MODE        0                  0x0              
 * 0x0536[2]     HSW_EN                 0                  0x0              
 * 0x0537[3:0]   IN_LOS_MSK             0                  0x0              
 * 0x0537[7:4]   IN_OOF_MSK             0                  0x0              
 * 0x0538[2:0]   IN0_PRIORITY           0                  0x0              
 * 0x0538[6:4]   IN1_PRIORITY           0                  0x0              
 * 0x0539[2:0]   IN2_PRIORITY           0                  0x0              
 * 0x0539[6:4]   IN3_PRIORITY           0                  0x0              
 * 0x053A[1:0]   HSW_MODE               2                  0x2              
 * 0x053A[3:2]   HSW_PHMEAS_CTRL        0                  0x0              
 * 0x053B[9:0]   HSW_PHMEAS_THR         3                  0x003            
 * 0x053D[4:0]   HSW_COARSE_PM_LEN      19                 0x13             
 * 0x053E[4:0]   HSW_COARSE_PM_DLY      6                  0x06             
 * 0x0589[12:0]  CAP_SHORT_DELAY        504                0x01F8           
 * 0x059B[4]     HOLD_PRESERVE_HIST     1                  0x1              
 * 0x059B[5]     HOLD_FRZ_WITH_INTONLY  1                  0x1              
 * 0x059B[6]     HOLDEXIT_BW_SEL0       1                  0x1              
 * 0x059B[7]     HOLDEXIT_STD_BO        1                  0x1              
 * 0x059D[5:0]   HOLDEXIT_BW0           23                 0x17             
 * 0x059E[5:0]   HOLDEXIT_BW1           40                 0x28             
 * 0x059F[5:0]   HOLDEXIT_BW2           12                 0x0C             
 * 0x05A0[5:0]   HOLDEXIT_BW3           11                 0x0B             
 * 0x05A1[5:0]   HOLDEXIT_BW4           1                  0x01             
 * 0x05A2[5:0]   HOLDEXIT_BW5           7                  0x07             
 * 0x05A6[2:0]   RAMP_STEP_SIZE         0                  0x0              
 * 0x05A6[3]     RAMP_SWITCH_EN         0                  0x0              
 * 0x0802[15:0]  FIXREGSA0              1333               0x0535           
 * 0x0804[7:0]   FIXREGSD0              0                  0x00             
 * 0x0805[15:0]  FIXREGSA1              0                  0x0000           
 * 0x0807[7:0]   FIXREGSD1              0                  0x00             
 * 0x0808[15:0]  FIXREGSA2              0                  0x0000           
 * 0x080A[7:0]   FIXREGSD2              0                  0x00             
 * 0x080B[15:0]  FIXREGSA3              0                  0x0000           
 * 0x080D[7:0]   FIXREGSD3              0                  0x00             
 * 0x080E[15:0]  FIXREGSA4              0                  0x0000           
 * 0x0810[7:0]   FIXREGSD4              0                  0x00             
 * 0x0811[15:0]  FIXREGSA5              0                  0x0000           
 * 0x0813[7:0]   FIXREGSD5              0                  0x00             
 * 0x0814[15:0]  FIXREGSA6              0                  0x0000           
 * 0x0816[7:0]   FIXREGSD6              0                  0x00             
 * 0x0817[15:0]  FIXREGSA7              0                  0x0000           
 * 0x0819[7:0]   FIXREGSD7              0                  0x00             
 * 0x081A[15:0]  FIXREGSA8              0                  0x0000           
 * 0x081C[7:0]   FIXREGSD8              0                  0x00             
 * 0x081D[15:0]  FIXREGSA9              0                  0x0000           
 * 0x081F[7:0]   FIXREGSD9              0                  0x00             
 * 0x0820[15:0]  FIXREGSA10             0                  0x0000           
 * 0x0822[7:0]   FIXREGSD10             0                  0x00             
 * 0x0823[15:0]  FIXREGSA11             0                  0x0000           
 * 0x0825[7:0]   FIXREGSD11             0                  0x00             
 * 0x0826[15:0]  FIXREGSA12             0                  0x0000           
 * 0x0828[7:0]   FIXREGSD12             0                  0x00             
 * 0x0829[15:0]  FIXREGSA13             0                  0x0000           
 * 0x082B[7:0]   FIXREGSD13             0                  0x00             
 * 0x082C[15:0]  FIXREGSA14             0                  0x0000           
 * 0x082E[7:0]   FIXREGSD14             0                  0x00             
 * 0x082F[15:0]  FIXREGSA15             0                  0x0000           
 * 0x0831[7:0]   FIXREGSD15             0                  0x00             
 * 0x0832[15:0]  FIXREGSA16             0                  0x0000           
 * 0x0834[7:0]   FIXREGSD16             0                  0x00             
 * 0x0835[15:0]  FIXREGSA17             0                  0x0000           
 * 0x0837[7:0]   FIXREGSD17             0                  0x00             
 * 0x0838[15:0]  FIXREGSA18             0                  0x0000           
 * 0x083A[7:0]   FIXREGSD18             0                  0x00             
 * 0x083B[15:0]  FIXREGSA19             0                  0x0000           
 * 0x083D[7:0]   FIXREGSD19             0                  0x00             
 * 0x083E[15:0]  FIXREGSA20             0                  0x0000           
 * 0x0840[7:0]   FIXREGSD20             0                  0x00             
 * 0x0841[15:0]  FIXREGSA21             0                  0x0000           
 * 0x0843[7:0]   FIXREGSD21             0                  0x00             
 * 0x0844[15:0]  FIXREGSA22             0                  0x0000           
 * 0x0846[7:0]   FIXREGSD22             0                  0x00             
 * 0x0847[15:0]  FIXREGSA23             0                  0x0000           
 * 0x0849[7:0]   FIXREGSD23             0                  0x00             
 * 0x084A[15:0]  FIXREGSA24             0                  0x0000           
 * 0x084C[7:0]   FIXREGSD24             0                  0x00             
 * 0x084D[15:0]  FIXREGSA25             0                  0x0000           
 * 0x084F[7:0]   FIXREGSD25             0                  0x00             
 * 0x0850[15:0]  FIXREGSA26             0                  0x0000           
 * 0x0852[7:0]   FIXREGSD26             0                  0x00             
 * 0x0853[15:0]  FIXREGSA27             0                  0x0000           
 * 0x0855[7:0]   FIXREGSD27             0                  0x00             
 * 0x0856[15:0]  FIXREGSA28             0                  0x0000           
 * 0x0858[7:0]   FIXREGSD28             0                  0x00             
 * 0x0859[15:0]  FIXREGSA29             0                  0x0000           
 * 0x085B[7:0]   FIXREGSD29             0                  0x00             
 * 0x085C[15:0]  FIXREGSA30             0                  0x0000           
 * 0x085E[7:0]   FIXREGSD30             0                  0x00             
 * 0x085F[15:0]  FIXREGSA31             0                  0x0000           
 * 0x0861[7:0]   FIXREGSD31             0                  0x00             
 * 0x090E[0]     XAXB_EXTCLK_EN         1                  0x1              
 * 0x0943[0]     IO_VDD_SEL             0                  0x0              
 * 0x0949[3:0]   IN_EN                  1                  0x1              
 * 0x0949[7:4]   IN_PULSED_CMOS_EN      3                  0x3              
 * 0x094A[3:0]   INX_TO_PFD_EN          1                  0x1              
 * 0x094E[11:0]  REFCLK_HYS_SEL         585                0x249            
 * 0x095E[0]     MXAXB_INTEGER          0                  0x0              
 * 0x0A02[4:0]   N_ADD_0P5              0                  0x00             
 * 0x0A03[4:0]   N_CLK_TO_OUTX_EN       7                  0x07             
 * 0x0A04[4:0]   N_PIBYP                1                  0x01             
 * 0x0A05[4:0]   N_PDNB                 7                  0x07             
 * 0x0A14[3]     N0_HIGH_FREQ           0                  0x0              
 * 0x0A1A[3]     N1_HIGH_FREQ           0                  0x0              
 * 0x0A20[3]     N2_HIGH_FREQ           0                  0x0              
 * 0x0A26[3]     N3_HIGH_FREQ           0                  0x0              
 * 0x0A2C[3]     N4_HIGH_FREQ           0                  0x0              
 * 0x0B44[3:0]   PDIV_FRACN_CLK_DIS     15                 0xF              
 * 0x0B44[5]     FRACN_CLK_DIS_PLL      0                  0x0              
 * 0x0B46[3:0]   LOS_CLK_DIS            0                  0x0              
 * 0x0B47[4:0]   OOF_CLK_DIS            14                 0x0E             
 * 0x0B48[4:0]   OOF_DIV_CLK_DIS        14                 0x0E             
 * 0x0B4A[4:0]   N_CLK_DIS              24                 0x18             
 * 0x0B57[11:0]  VCO_RESET_CALCODE      249                0x0F9
 * 
 *
 */


static struct ntv2_genlock_data s_genlock_2250_2400[] =
{
	/* Start configuration preamble */
	{ 0x0B24, 0xC0 },
	{ 0x0B25, 0x00 },
	{ 0x0540, 0x01 },
	/* End configuration preamble */

	/* Delay 300 msec */
	/*    Delay is worst case time for device to complete any calibration */
	/*    that is running due to device state change previous to this script */
	/*    being processed. */
	{ 0x0000, 0x01 },

	/* Start configuration registers */
	{ 0x000B, 0x64 },
	{ 0x0016, 0x02 },
	{ 0x0017, 0xFC },
	{ 0x0018, 0xFF },
	{ 0x0019, 0xDF },
	{ 0x001A, 0xDF },
	{ 0x002B, 0x02 },
	{ 0x002C, 0x01 },
	{ 0x002D, 0x02 },
	{ 0x002E, 0xBF },
	{ 0x002F, 0x04 },
	{ 0x0030, 0x00 },
	{ 0x0031, 0x00 },
	{ 0x0032, 0x00 },
	{ 0x0033, 0x00 },
	{ 0x0034, 0x00 },
	{ 0x0035, 0x00 },
	{ 0x0036, 0x5A },
	{ 0x0037, 0x04 },
	{ 0x0038, 0x00 },
	{ 0x0039, 0x00 },
	{ 0x003A, 0x00 },
	{ 0x003B, 0x00 },
	{ 0x003C, 0x00 },
	{ 0x003D, 0x00 },
	{ 0x003F, 0x01 },
	{ 0x0040, 0x04 },
	{ 0x0041, 0x02 },
	{ 0x0042, 0x00 },
	{ 0x0043, 0x00 },
	{ 0x0044, 0x00 },
	{ 0x0045, 0x0C },
	{ 0x0046, 0x96 },
	{ 0x0047, 0x00 },
	{ 0x0048, 0x00 },
	{ 0x0049, 0x00 },
	{ 0x004A, 0x4B },
	{ 0x004B, 0x00 },
	{ 0x004C, 0x00 },
	{ 0x004D, 0x00 },
	{ 0x004E, 0x05 },
	{ 0x004F, 0x00 },
	{ 0x0050, 0x0F },
	{ 0x0051, 0x00 },
	{ 0x0052, 0x00 },
	{ 0x0053, 0x00 },
	{ 0x0054, 0x00 },
	{ 0x0055, 0x00 },
	{ 0x0056, 0x00 },
	{ 0x0057, 0x00 },
	{ 0x0058, 0x00 },
	{ 0x0059, 0x01 },
	{ 0x005A, 0xF9 },
	{ 0x005B, 0x39 },
	{ 0x005C, 0x10 },
	{ 0x005D, 0x01 },
	{ 0x005E, 0x00 },
	{ 0x005F, 0x00 },
	{ 0x0060, 0x00 },
	{ 0x0061, 0x00 },
	{ 0x0062, 0x00 },
	{ 0x0063, 0x00 },
	{ 0x0064, 0x00 },
	{ 0x0065, 0x00 },
	{ 0x0066, 0x00 },
	{ 0x0067, 0x00 },
	{ 0x0068, 0x00 },
	{ 0x0069, 0x00 },
	{ 0x0092, 0x02 },
	{ 0x0093, 0xA0 },
	{ 0x0095, 0x00 },
	{ 0x0096, 0x90 },
	{ 0x0098, 0x70 },
	{ 0x009A, 0x02 },
	{ 0x009B, 0x50 },
	{ 0x009D, 0x04 },
	{ 0x009E, 0x60 },
	{ 0x00A0, 0x30 },
	{ 0x00A2, 0x00 },
	{ 0x00A9, 0x70 },
	{ 0x00AA, 0xB1 },
	{ 0x00AB, 0x04 },
	{ 0x00AC, 0x00 },
	{ 0x00E5, 0x21 },
	{ 0x00EA, 0xD1 },
	{ 0x00EB, 0xB1 },
	{ 0x00EC, 0x03 },
	{ 0x00ED, 0x00 },
	{ 0x0102, 0x01 },
	{ 0x0108, 0x02 },
	{ 0x0109, 0x09 },
	{ 0x010A, 0x3B },
	{ 0x010B, 0x28 },
	{ 0x010D, 0x01 },
	{ 0x010E, 0x09 },
	{ 0x010F, 0x3B },
	{ 0x0110, 0x28 },
	{ 0x0112, 0x02 },
	{ 0x0113, 0x09 },
	{ 0x0114, 0x3B },
	{ 0x0115, 0x28 },
	{ 0x0117, 0x01 },
	{ 0x0118, 0x09 },
	{ 0x0119, 0x3B },
	{ 0x011A, 0x28 },
	{ 0x011C, 0x01 },
	{ 0x011D, 0x09 },
	{ 0x011E, 0x3B },
	{ 0x011F, 0x28 },
	{ 0x0121, 0x02 },
	{ 0x0122, 0x09 },
	{ 0x0123, 0x3B },
	{ 0x0124, 0x29 },
	{ 0x0126, 0x01 },
	{ 0x0127, 0x09 },
	{ 0x0128, 0x3B },
	{ 0x0129, 0x28 },
	{ 0x012B, 0x01 },
	{ 0x012C, 0x09 },
	{ 0x012D, 0x3B },
	{ 0x012E, 0x28 },
	{ 0x0130, 0x02 },
	{ 0x0131, 0x09 },
	{ 0x0132, 0x3B },
	{ 0x0133, 0x2A },
	{ 0x013A, 0x01 },
	{ 0x013B, 0x09 },
	{ 0x013C, 0x3B },
	{ 0x013D, 0x28 },
	{ 0x013F, 0x00 },
	{ 0x0140, 0x00 },
	{ 0x0141, 0x40 },
	{ 0x0142, 0xFF },
	{ 0x0206, 0x00 },
	{ 0x0208, 0x01 },
	{ 0x0209, 0x00 },
	{ 0x020A, 0x00 },
	{ 0x020B, 0x00 },
	{ 0x020C, 0x00 },
	{ 0x020D, 0x00 },
	{ 0x020E, 0x01 },
	{ 0x020F, 0x00 },
	{ 0x0210, 0x00 },
	{ 0x0211, 0x00 },
	{ 0x0212, 0x00 },
	{ 0x0213, 0x00 },
	{ 0x0214, 0x00 },
	{ 0x0215, 0x00 },
	{ 0x0216, 0x00 },
	{ 0x0217, 0x00 },
	{ 0x0218, 0x00 },
	{ 0x0219, 0x00 },
	{ 0x021A, 0x00 },
	{ 0x021B, 0x00 },
	{ 0x021C, 0x00 },
	{ 0x021D, 0x00 },
	{ 0x021E, 0x00 },
	{ 0x021F, 0x00 },
	{ 0x0220, 0x00 },
	{ 0x0221, 0x00 },
	{ 0x0222, 0x00 },
	{ 0x0223, 0x00 },
	{ 0x0224, 0x00 },
	{ 0x0225, 0x00 },
	{ 0x0226, 0x00 },
	{ 0x0227, 0x00 },
	{ 0x0228, 0x00 },
	{ 0x0229, 0x00 },
	{ 0x022A, 0x00 },
	{ 0x022B, 0x00 },
	{ 0x022C, 0x00 },
	{ 0x022D, 0x00 },
	{ 0x022E, 0x00 },
	{ 0x022F, 0x00 },
	{ 0x0231, 0x0B },
	{ 0x0232, 0x0B },
	{ 0x0233, 0x0B },
	{ 0x0234, 0x0B },
	{ 0x0235, 0x00 },
	{ 0x0236, 0x00 },
	{ 0x0237, 0x00 },
	{ 0x0238, 0x78 },
	{ 0x0239, 0xD5 },
	{ 0x023A, 0x00 },
	{ 0x023B, 0x00 },
	{ 0x023C, 0x00 },
	{ 0x023D, 0x00 },
	{ 0x023E, 0xD0 },
	{ 0x024A, 0x0A },
	{ 0x024B, 0x00 },
	{ 0x024C, 0x00 },
	{ 0x024D, 0x00 },
	{ 0x024E, 0x00 },
	{ 0x024F, 0x00 },
	{ 0x0250, 0x01 },
	{ 0x0251, 0x00 },
	{ 0x0252, 0x00 },
	{ 0x0253, 0x00 },
	{ 0x0254, 0x00 },
	{ 0x0255, 0x00 },
	{ 0x0256, 0x00 },
	{ 0x0257, 0x00 },
	{ 0x0258, 0x00 },
	{ 0x0259, 0x02 },
	{ 0x025A, 0x00 },
	{ 0x025B, 0x00 },
	{ 0x025C, 0x00 },
	{ 0x025D, 0x00 },
	{ 0x025E, 0x00 },
	{ 0x025F, 0x00 },
	{ 0x0260, 0x00 },
	{ 0x0261, 0x00 },
	{ 0x0262, 0x02 },
	{ 0x0263, 0x00 },
	{ 0x0264, 0x00 },
	{ 0x0268, 0x00 },
	{ 0x0269, 0x00 },
	{ 0x026A, 0x00 },
	{ 0x026B, 0x49 },
	{ 0x026C, 0x4F },
	{ 0x026D, 0x34 },
	{ 0x026E, 0x4B },
	{ 0x026F, 0x2B },
	{ 0x0270, 0x00 },
	{ 0x0271, 0x00 },
	{ 0x0272, 0x00 },
	{ 0x0294, 0x80 },
	{ 0x0296, 0x00 },
	{ 0x0297, 0x02 },
	{ 0x0299, 0x02 },
	{ 0x029D, 0xF5 },
	{ 0x029E, 0x0E },
	{ 0x029F, 0x00 },
	{ 0x02A9, 0x66 },
	{ 0x02AA, 0x26 },
	{ 0x02AB, 0x00 },
	{ 0x02B7, 0xFF },
	{ 0x0302, 0x00 },
	{ 0x0303, 0x00 },
	{ 0x0304, 0x00 },
	{ 0x0305, 0x80 },
	{ 0x0306, 0x0B },
	{ 0x0307, 0x00 },
	{ 0x0308, 0x00 },
	{ 0x0309, 0x00 },
	{ 0x030A, 0x00 },
	{ 0x030B, 0x80 },
	{ 0x030C, 0x00 },
	{ 0x030D, 0x00 },
	{ 0x030E, 0x00 },
	{ 0x030F, 0x60 },
	{ 0x0310, 0x53 },
	{ 0x0311, 0x2E },
	{ 0x0312, 0x00 },
	{ 0x0313, 0x00 },
	{ 0x0314, 0x00 },
	{ 0x0315, 0x00 },
	{ 0x0316, 0x80 },
	{ 0x0317, 0x00 },
	{ 0x0318, 0x00 },
	{ 0x0319, 0x00 },
	{ 0x031A, 0xE0 },
	{ 0x031B, 0x3D },
	{ 0x031C, 0x0B },
	{ 0x031D, 0x00 },
	{ 0x031E, 0x00 },
	{ 0x031F, 0x00 },
	{ 0x0320, 0x80 },
	{ 0x0321, 0xBB },
	{ 0x0322, 0x00 },
	{ 0x0323, 0x00 },
	{ 0x0324, 0x00 },
	{ 0x0325, 0x00 },
	{ 0x0326, 0x00 },
	{ 0x0327, 0x00 },
	{ 0x0328, 0x00 },
	{ 0x0329, 0x00 },
	{ 0x032A, 0x00 },
	{ 0x032B, 0x00 },
	{ 0x032C, 0x00 },
	{ 0x032D, 0x00 },
	{ 0x032E, 0x00 },
	{ 0x032F, 0x00 },
	{ 0x0330, 0x00 },
	{ 0x0331, 0x00 },
	{ 0x0332, 0x00 },
	{ 0x0333, 0x00 },
	{ 0x0334, 0x00 },
	{ 0x0335, 0x00 },
	{ 0x0336, 0x00 },
	{ 0x0337, 0x00 },
	{ 0x0338, 0x00 },
	{ 0x0339, 0x1F },
	{ 0x033B, 0x00 },
	{ 0x033C, 0x00 },
	{ 0x033D, 0x00 },
	{ 0x033E, 0x00 },
	{ 0x033F, 0x00 },
	{ 0x0340, 0x00 },
	{ 0x0341, 0x00 },
	{ 0x0342, 0x00 },
	{ 0x0343, 0x00 },
	{ 0x0344, 0x00 },
	{ 0x0345, 0x00 },
	{ 0x0346, 0x00 },
	{ 0x0347, 0x00 },
	{ 0x0348, 0x00 },
	{ 0x0349, 0x00 },
	{ 0x034A, 0x00 },
	{ 0x034B, 0x00 },
	{ 0x034C, 0x00 },
	{ 0x034D, 0x00 },
	{ 0x034E, 0x00 },
	{ 0x034F, 0x00 },
	{ 0x0350, 0x00 },
	{ 0x0351, 0x00 },
	{ 0x0352, 0x00 },
	{ 0x0353, 0x00 },
	{ 0x0354, 0x00 },
	{ 0x0355, 0x00 },
	{ 0x0356, 0x00 },
	{ 0x0357, 0x00 },
	{ 0x0358, 0x00 },
	{ 0x0359, 0x00 },
	{ 0x035A, 0x00 },
	{ 0x035B, 0x00 },
	{ 0x035C, 0x00 },
	{ 0x035D, 0x00 },
	{ 0x035E, 0x00 },
	{ 0x035F, 0x00 },
	{ 0x0360, 0x00 },
	{ 0x0361, 0x00 },
	{ 0x0362, 0x00 },
	{ 0x0487, 0x00 },
	{ 0x0502, 0x01 },
	{ 0x0508, 0x10 },
	{ 0x0509, 0x18 },
	{ 0x050A, 0x0F },
	{ 0x050B, 0x0F },
	{ 0x050C, 0x01 },
	{ 0x050D, 0x07 },
	{ 0x050E, 0x17 },
	{ 0x050F, 0x28 },
	{ 0x0510, 0x0C },
	{ 0x0511, 0x0B },
	{ 0x0512, 0x01 },
	{ 0x0513, 0x07 },
	{ 0x0515, 0x00 },
	{ 0x0516, 0x00 },
	{ 0x0517, 0x00 },
	{ 0x0518, 0x00 },
	{ 0x0519, 0xD4 },
	{ 0x051A, 0x62 },
	{ 0x051B, 0x00 },
	{ 0x051C, 0x00 },
	{ 0x051D, 0x00 },
	{ 0x051E, 0x00 },
	{ 0x051F, 0x80 },
	{ 0x0521, 0x2B },
	{ 0x052A, 0x01 },
	{ 0x052B, 0x01 },
	{ 0x052C, 0x0F },
	{ 0x052D, 0x03 },
	{ 0x052E, 0x15 },
	{ 0x052F, 0x14 },
	{ 0x0531, 0x00 },
	{ 0x0532, 0x91 },
	{ 0x0533, 0x78 },
	{ 0x0534, 0x00 },
	{ 0x0535, 0x00 },
	{ 0x0536, 0x00 },
	{ 0x0537, 0x00 },
	{ 0x0538, 0x00 },
	{ 0x0539, 0x00 },
	{ 0x053A, 0x02 },
	{ 0x053B, 0x03 },
	{ 0x053C, 0x00 },
	{ 0x053D, 0x13 },
	{ 0x053E, 0x06 },
	{ 0x0589, 0xF7 },
	{ 0x058A, 0x01 },
	{ 0x059B, 0xF8 },
	{ 0x059D, 0x17 },
	{ 0x059E, 0x28 },
	{ 0x059F, 0x0C },
	{ 0x05A0, 0x0B },
	{ 0x05A1, 0x01 },
	{ 0x05A2, 0x07 },
	{ 0x05A6, 0x00 },
	{ 0x0802, 0x35 },
	{ 0x0803, 0x05 },
	{ 0x0804, 0x00 },
	{ 0x0805, 0x00 },
	{ 0x0806, 0x00 },
	{ 0x0807, 0x00 },
	{ 0x0808, 0x00 },
	{ 0x0809, 0x00 },
	{ 0x080A, 0x00 },
	{ 0x080B, 0x00 },
	{ 0x080C, 0x00 },
	{ 0x080D, 0x00 },
	{ 0x080E, 0x00 },
	{ 0x080F, 0x00 },
	{ 0x0810, 0x00 },
	{ 0x0811, 0x00 },
	{ 0x0812, 0x00 },
	{ 0x0813, 0x00 },
	{ 0x0814, 0x00 },
	{ 0x0815, 0x00 },
	{ 0x0816, 0x00 },
	{ 0x0817, 0x00 },
	{ 0x0818, 0x00 },
	{ 0x0819, 0x00 },
	{ 0x081A, 0x00 },
	{ 0x081B, 0x00 },
	{ 0x081C, 0x00 },
	{ 0x081D, 0x00 },
	{ 0x081E, 0x00 },
	{ 0x081F, 0x00 },
	{ 0x0820, 0x00 },
	{ 0x0821, 0x00 },
	{ 0x0822, 0x00 },
	{ 0x0823, 0x00 },
	{ 0x0824, 0x00 },
	{ 0x0825, 0x00 },
	{ 0x0826, 0x00 },
	{ 0x0827, 0x00 },
	{ 0x0828, 0x00 },
	{ 0x0829, 0x00 },
	{ 0x082A, 0x00 },
	{ 0x082B, 0x00 },
	{ 0x082C, 0x00 },
	{ 0x082D, 0x00 },
	{ 0x082E, 0x00 },
	{ 0x082F, 0x00 },
	{ 0x0830, 0x00 },
	{ 0x0831, 0x00 },
	{ 0x0832, 0x00 },
	{ 0x0833, 0x00 },
	{ 0x0834, 0x00 },
	{ 0x0835, 0x00 },
	{ 0x0836, 0x00 },
	{ 0x0837, 0x00 },
	{ 0x0838, 0x00 },
	{ 0x0839, 0x00 },
	{ 0x083A, 0x00 },
	{ 0x083B, 0x00 },
	{ 0x083C, 0x00 },
	{ 0x083D, 0x00 },
	{ 0x083E, 0x00 },
	{ 0x083F, 0x00 },
	{ 0x0840, 0x00 },
	{ 0x0841, 0x00 },
	{ 0x0842, 0x00 },
	{ 0x0843, 0x00 },
	{ 0x0844, 0x00 },
	{ 0x0845, 0x00 },
	{ 0x0846, 0x00 },
	{ 0x0847, 0x00 },
	{ 0x0848, 0x00 },
	{ 0x0849, 0x00 },
	{ 0x084A, 0x00 },
	{ 0x084B, 0x00 },
	{ 0x084C, 0x00 },
	{ 0x084D, 0x00 },
	{ 0x084E, 0x00 },
	{ 0x084F, 0x00 },
	{ 0x0850, 0x00 },
	{ 0x0851, 0x00 },
	{ 0x0852, 0x00 },
	{ 0x0853, 0x00 },
	{ 0x0854, 0x00 },
	{ 0x0855, 0x00 },
	{ 0x0856, 0x00 },
	{ 0x0857, 0x00 },
	{ 0x0858, 0x00 },
	{ 0x0859, 0x00 },
	{ 0x085A, 0x00 },
	{ 0x085B, 0x00 },
	{ 0x085C, 0x00 },
	{ 0x085D, 0x00 },
	{ 0x085E, 0x00 },
	{ 0x085F, 0x00 },
	{ 0x0860, 0x00 },
	{ 0x0861, 0x00 },
	{ 0x090E, 0x03 },
	{ 0x0943, 0x00 },
	{ 0x0949, 0x31 },
	{ 0x094A, 0x01 },
	{ 0x094E, 0x49 },
	{ 0x094F, 0x02 },
	{ 0x095E, 0x00 },
	{ 0x0A02, 0x00 },
	{ 0x0A03, 0x07 },
	{ 0x0A04, 0x01 },
	{ 0x0A05, 0x07 },
	{ 0x0A14, 0x00 },
	{ 0x0A1A, 0x00 },
	{ 0x0A20, 0x00 },
	{ 0x0A26, 0x00 },
	{ 0x0A2C, 0x00 },
	{ 0x0B44, 0x2F },
	{ 0x0B46, 0x00 },
	{ 0x0B47, 0x0E },
	{ 0x0B48, 0x0E },
	{ 0x0B4A, 0x18 },
	{ 0x0B57, 0xF9 },
	{ 0x0B58, 0x00 },
	/* End configuration registers */

	/* Start configuration postamble */
	{ 0x0514, 0x01 },
	{ 0x001C, 0x01 },
	{ 0x0540, 0x00 },
	{ 0x0B24, 0xC3 },
	{ 0x0B25, 0x02 },
	/* End configuration postamble */

	{ 0x0000, 0x00 }
};

/*
 * Design Report
 *
 * Overview
 * ========
 * Part:         Si5345 Rev D
 * Project File: C:\XilinxProjects\flint_tr051017\genlock\FormatFiles\IO4K+_1125_5994.slabtimeproj
 * Design ID:    IO4K+
 * Created By:   ClockBuilder Pro v2.16.1 [2017-07-19]
 * Timestamp:    2017-08-24 16:56:56 GMT-07:00
 * 
 * Design Notes
 * ============
 * assumes NTSC HSYNC (pulsed) input = (30/1.001)*525
 * 
 * Design Rule Check
 * =================
 * Errors:
 * - No errors
 * 
 * Warnings:
 * - Pulsed LVCMOS input buffer mode has been selected. This mode has non-standard input voltage logic thresholds: 0.33 V for Vil (max) and 0.49 V for Vih (min). Select this mode only if your input clock has a duty cycle significantly less or more than 50%.  Refer to the device datasheet for the exact threshold voltage specifications and the input attenuator circuit (DC coupled Pulsed LVCMOS) in the Family Reference Manual.
 * 
 * Device Grade
 * ============
 * Maximum Output Frequency: 148.5 MHz
 * Frequency Synthesis Mode: Fractional
 * Minimum Base OPN:         Si5345B
 * Actual Base OPN:          Si5345B
 * 
 * Base       Output Clock         Supported Frequency Synthesis Modes
 * OPN Grade  Frequency Range      (Typical Jitter)
 * ---------  -------------------  --------------------------------------------
 * Si5345A    100 Hz to 1.028 GHz  Integer (< 100 fs) and fractional (< 150 fs)
 * Si5345B    100 Hz to 350 MHz    "
 * Si5345C    100 Hz to 1.028 GHz  Integer only (< 100 fs)
 * Si5345D    100 Hz to 350 MHz    "
 * 
 * Design
 * ======
 * Host Interface:
 *    I/O Power Supply: VDD (Core)
 *    SPI Mode: 4-Wire
 *    I2C Address Range: 100d to 103d / 0x64 to 0x67 (selected via A0/A1 pins)
 * 
 * XA/XB:
 *    52 MHz (XO - External Oscillator)
 * 
 * Inputs:
 *     IN0: 54 kHz
 *          [ (24)*2250 ]
 *          Pulsed LVCMOS
 *     IN1: Unused
 *     IN2: Unused
 *     IN3: Unused
 * 
 * Outputs:
 *    OUT0: 27 MHz
 *          Enabled, LVDS 2.5 V
 *    OUT1: Unused
 *    OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT3: Unused
 *    OUT4: Unused
 *    OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT6: Unused
 *    OUT7: Unused
 *    OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *          [ 148.5/1.001 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT9: Unused
 * 
 * Frequency Plan
 * ==============
 * Priority: maximize the number of low jitter outputs
 * 
 * Fvco = 13.662 GHz [ 13 + 331/500 GHz ]
 * Fpfd = 54 kHz
 * Fms0 = 594 MHz
 * Fms1 = 147.456 MHz [ 147 + 57/125 MHz ]
 * Fms2 = 890.1098901098901098... MHz [ 890 + 10/91 MHz ]
 * 
 * P dividers:
 *    P0  = 1
 *    P1  = Unused
 *    P2  = Unused
 *    P3  = Unused
 *    Pxaxb = 1
 * 
 * MXAXB = 262.7307692307692307... [ 262 + 19/26 ]
 * M = 50600
 * N dividers:
 *    N0:
 *       Value: 23
 *       Skew:  0.000 s
 *       OUT0: 27 MHz
 *       OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *    N1:
 *       Value: 92.6513671875 [ 92 + 667/1024 ]
 *       Skew:  0.000 s
 *       OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *    N2:
 *       Value: 15.3486666666666666... [ 15 + 523/1500 ]
 *       Skew:  0.000 s
 *       OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *    N3:
 *       Unused
 *    N4:
 *       Unused
 * 
 * R dividers:
 *    R0 = 22
 *    R1 = Unused
 *    R2 = 4
 *    R3 = Unused
 *    R4 = Unused
 *    R5 = 6
 *    R6 = Unused
 *    R7 = Unused
 *    R8 = 6
 *    R9 = Unused
 * 
 * Nominal Bandwidth:
 *   Desired: 1.000 Hz
 *   Actual:  519.444 mHz
 *   Coefficients:
 *      BW0:  16
 *      BW1:  24
 *      BW2:  15
 *      BW3:  15
 *      BW4:  1
 *      BW5:  7
 * Fastlock Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  80.852 Hz
 *   Coefficients:
 *      BW0:  23
 *      BW1:  40
 *      BW2:  12
 *      BW3:  11
 *      BW4:  1
 *      BW5:  7
 * Holdover Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  80.852 Hz
 *   Coefficients:
 *      BW0:  23
 *      BW1:  40
 *      BW2:  12
 *      BW3:  11
 *      BW4:  1
 *      BW5:  7
 * 
 * Dividers listed above show effective values. These values are translated to register settings by ClockBuilder Pro. For the actual register values, see below. Refer to the Family Reference Manual for information on registers related to frequency plan.
 * 
 * Digitally Controlled Oscillator (DCO)
 * =====================================
 * Mode: Register Direct Write
 * 
 * N0: DCO Disabled
 * 
 * N1: DCO Disabled
 * 
 * N2: DCO Disabled
 * 
 * N3: DCO Disabled
 * 
 * N4: DCO Disabled
 * 
 * Estimated Power & Junction Temperature
 * ======================================
 * Assumptions:
 * 
 * Revision: D
 * VDD:      1.8 V
 * Ta:       70 C
 * Airflow:  None
 * 
 * Total Power: 808 mW, On Chip Power: 784 mW, Tj: 87 C
 * 
 *                 Frequency  Format   Voltage   Current     Power
 *         -----------------  ------  --------  --------  --------
 * VDD                                   1.8 V  147.9 mA    266 mW
 * VDDA                                  3.3 V  117.4 mA    387 mW
 * VDDO0              27 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO1              Unused                                      
 * VDDO2           148.5 MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO3              Unused                                      
 * VDDO4              Unused                                      
 * VDDO5          24.576 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO6              Unused                                      
 * VDDO7              Unused                                      
 * VDDO8   148.351648... MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO9              Unused                                      
 *                                              --------  --------
 *                                       Total  327.2 mA    808 mW
 * 
 * Note:
 * 
 * -Total power includes on- and off-chip power. This is a typical value and estimate only.
 * -Use an EVB for a more exact power measurement
 * -On-chip power excludes power dissipated in external terminations.
 * -Tj is junction temperature. Tj must be less than 125 C (on Si5345 Revision D) for device to comply with datasheet specifications.
 * 
 * Settings
 * ========
 * 
 * Location      Setting Name           Decimal Value      Hex Value        
 * ------------  ---------------------  -----------------  -----------------
 * 0x000B[6:0]   I2C_ADDR               100                0x64             
 * 0x0016[1]     LOL_ON_HOLD            1                  0x1              
 * 0x0017[0]     SYSINCAL_INTR_MSK      0                  0x0              
 * 0x0017[1]     LOSXAXB_INTR_MSK       0                  0x0              
 * 0x0017[5]     SMB_TMOUT_INTR_MSK     1                  0x1              
 * 0x0018[3:0]   LOS_INTR_MSK           15                 0xF              
 * 0x0018[7:4]   OOF_INTR_MSK           15                 0xF              
 * 0x0019[1]     LOL_INTR_MSK           1                  0x1              
 * 0x0019[5]     HOLD_INTR_MSK          0                  0x0              
 * 0x001A[5]     CAL_INTR_MSK           0                  0x0              
 * 0x002B[3]     SPI_3WIRE              0                  0x0              
 * 0x002B[5]     AUTO_NDIV_UPDATE       0                  0x0              
 * 0x002C[3:0]   LOS_EN                 1                  0x1              
 * 0x002C[4]     LOSXAXB_DIS            0                  0x0              
 * 0x002D[1:0]   LOS0_VAL_TIME          2                  0x2              
 * 0x002D[3:2]   LOS1_VAL_TIME          0                  0x0              
 * 0x002D[5:4]   LOS2_VAL_TIME          0                  0x0              
 * 0x002D[7:6]   LOS3_VAL_TIME          0                  0x0              
 * 0x002E[15:0]  LOS0_TRG_THR           1215               0x04BF           
 * 0x0030[15:0]  LOS1_TRG_THR           0                  0x0000           
 * 0x0032[15:0]  LOS2_TRG_THR           0                  0x0000           
 * 0x0034[15:0]  LOS3_TRG_THR           0                  0x0000           
 * 0x0036[15:0]  LOS0_CLR_THR           1114               0x045A           
 * 0x0038[15:0]  LOS1_CLR_THR           0                  0x0000           
 * 0x003A[15:0]  LOS2_CLR_THR           0                  0x0000           
 * 0x003C[15:0]  LOS3_CLR_THR           0                  0x0000           
 * 0x003F[3:0]   OOF_EN                 1                  0x1              
 * 0x003F[7:4]   FAST_OOF_EN            0                  0x0              
 * 0x0040[2:0]   OOF_REF_SEL            4                  0x4              
 * 0x0041[4:0]   OOF0_DIV_SEL           2                  0x02             
 * 0x0042[4:0]   OOF1_DIV_SEL           0                  0x00             
 * 0x0043[4:0]   OOF2_DIV_SEL           0                  0x00             
 * 0x0044[4:0]   OOF3_DIV_SEL           0                  0x00             
 * 0x0045[4:0]   OOFXO_DIV_SEL          12                 0x0C             
 * 0x0046[7:0]   OOF0_SET_THR           150                0x96             
 * 0x0047[7:0]   OOF1_SET_THR           0                  0x00             
 * 0x0048[7:0]   OOF2_SET_THR           0                  0x00             
 * 0x0049[7:0]   OOF3_SET_THR           0                  0x00             
 * 0x004A[7:0]   OOF0_CLR_THR           75                 0x4B             
 * 0x004B[7:0]   OOF1_CLR_THR           0                  0x00             
 * 0x004C[7:0]   OOF2_CLR_THR           0                  0x00             
 * 0x004D[7:0]   OOF3_CLR_THR           0                  0x00             
 * 0x004E[2:0]   OOF0_DETWIN_SEL        5                  0x5              
 * 0x004E[6:4]   OOF1_DETWIN_SEL        0                  0x0              
 * 0x004F[2:0]   OOF2_DETWIN_SEL        0                  0x0              
 * 0x004F[6:4]   OOF3_DETWIN_SEL        0                  0x0              
 * 0x0050[3:0]   OOF_ON_LOS             15                 0xF              
 * 0x0051[3:0]   FAST_OOF0_SET_THR      0                  0x0              
 * 0x0052[3:0]   FAST_OOF1_SET_THR      0                  0x0              
 * 0x0053[3:0]   FAST_OOF2_SET_THR      0                  0x0              
 * 0x0054[3:0]   FAST_OOF3_SET_THR      0                  0x0              
 * 0x0055[3:0]   FAST_OOF0_CLR_THR      0                  0x0              
 * 0x0056[3:0]   FAST_OOF1_CLR_THR      0                  0x0              
 * 0x0057[3:0]   FAST_OOF2_CLR_THR      0                  0x0              
 * 0x0058[3:0]   FAST_OOF3_CLR_THR      0                  0x0              
 * 0x0059[1:0]   FAST_OOF0_DETWIN_SEL   1                  0x1              
 * 0x0059[3:2]   FAST_OOF1_DETWIN_SEL   0                  0x0              
 * 0x0059[5:4]   FAST_OOF2_DETWIN_SEL   0                  0x0              
 * 0x0059[7:6]   FAST_OOF3_DETWIN_SEL   0                  0x0              
 * 0x005A[25:0]  OOF0_RATIO_REF         17840633           0x11039F9        
 * 0x005E[25:0]  OOF1_RATIO_REF         0                  0x0000000        
 * 0x0062[25:0]  OOF2_RATIO_REF         0                  0x0000000        
 * 0x0066[25:0]  OOF3_RATIO_REF         0                  0x0000000        
 * 0x0092[1]     LOL_FST_EN             1                  0x1              
 * 0x0093[7:4]   LOL_FST_DETWIN_SEL     10                 0xA              
 * 0x0095[3:2]   LOL_FST_VALWIN_SEL     0                  0x0              
 * 0x0096[7:4]   LOL_FST_SET_THR_SEL    9                  0x9              
 * 0x0098[7:4]   LOL_FST_CLR_THR_SEL    7                  0x7              
 * 0x009A[1]     LOL_SLOW_EN_PLL        1                  0x1              
 * 0x009B[7:4]   LOL_SLW_DETWIN_SEL     5                  0x5              
 * 0x009D[3:2]   LOL_SLW_VALWIN_SEL     1                  0x1              
 * 0x009E[7:4]   LOL_SLW_SET_THR        6                  0x6              
 * 0x00A0[7:4]   LOL_SLW_CLR_THR        3                  0x3              
 * 0x00A2[1]     LOL_TIMER_EN           0                  0x0              
 * 0x00A9[28:0]  LOL_CLR_DELAY_DIV256   307568             0x0004B170       
 * 0x00E5[5]     FASTLOCK_EXTEND_EN     1                  0x1              
 * 0x00EA[28:0]  FASTLOCK_EXTEND        242129             0x0003B1D1       
 * 0x0102[0]     OUTALL_DISABLE_LOW     1                  0x1              
 * 0x0108[0]     OUT0_PDN               0                  0x0              
 * 0x0108[1]     OUT0_OE                1                  0x1              
 * 0x0108[2]     OUT0_RDIV_FORCE2       0                  0x0              
 * 0x0109[2:0]   OUT0_FORMAT            1                  0x1              
 * 0x0109[3]     OUT0_SYNC_EN           1                  0x1              
 * 0x0109[5:4]   OUT0_DIS_STATE         0                  0x0              
 * 0x0109[7:6]   OUT0_CMOS_DRV          0                  0x0              
 * 0x010A[3:0]   OUT0_CM                11                 0xB              
 * 0x010A[6:4]   OUT0_AMPL              3                  0x3              
 * 0x010B[2:0]   OUT0_MUX_SEL           0                  0x0              
 * 0x010B[5:4]   OUT0_VDD_SEL           2                  0x2              
 * 0x010B[3]     OUT0_VDD_SEL_EN        1                  0x1              
 * 0x010B[7:6]   OUT0_INV               0                  0x0              
 * 0x010D[0]     OUT1_PDN               1                  0x1              
 * 0x010D[1]     OUT1_OE                0                  0x0              
 * 0x010D[2]     OUT1_RDIV_FORCE2       0                  0x0              
 * 0x010E[2:0]   OUT1_FORMAT            1                  0x1              
 * 0x010E[3]     OUT1_SYNC_EN           1                  0x1              
 * 0x010E[5:4]   OUT1_DIS_STATE         0                  0x0              
 * 0x010E[7:6]   OUT1_CMOS_DRV          0                  0x0              
 * 0x010F[3:0]   OUT1_CM                11                 0xB              
 * 0x010F[6:4]   OUT1_AMPL              3                  0x3              
 * 0x0110[2:0]   OUT1_MUX_SEL           0                  0x0              
 * 0x0110[5:4]   OUT1_VDD_SEL           2                  0x2              
 * 0x0110[3]     OUT1_VDD_SEL_EN        1                  0x1              
 * 0x0110[7:6]   OUT1_INV               0                  0x0              
 * 0x0112[0]     OUT2_PDN               0                  0x0              
 * 0x0112[1]     OUT2_OE                1                  0x1              
 * 0x0112[2]     OUT2_RDIV_FORCE2       0                  0x0              
 * 0x0113[2:0]   OUT2_FORMAT            1                  0x1              
 * 0x0113[3]     OUT2_SYNC_EN           1                  0x1              
 * 0x0113[5:4]   OUT2_DIS_STATE         0                  0x0              
 * 0x0113[7:6]   OUT2_CMOS_DRV          0                  0x0              
 * 0x0114[3:0]   OUT2_CM                11                 0xB              
 * 0x0114[6:4]   OUT2_AMPL              3                  0x3              
 * 0x0115[2:0]   OUT2_MUX_SEL           0                  0x0              
 * 0x0115[5:4]   OUT2_VDD_SEL           2                  0x2              
 * 0x0115[3]     OUT2_VDD_SEL_EN        1                  0x1              
 * 0x0115[7:6]   OUT2_INV               0                  0x0              
 * 0x0117[0]     OUT3_PDN               1                  0x1              
 * 0x0117[1]     OUT3_OE                0                  0x0              
 * 0x0117[2]     OUT3_RDIV_FORCE2       0                  0x0              
 * 0x0118[2:0]   OUT3_FORMAT            1                  0x1              
 * 0x0118[3]     OUT3_SYNC_EN           1                  0x1              
 * 0x0118[5:4]   OUT3_DIS_STATE         0                  0x0              
 * 0x0118[7:6]   OUT3_CMOS_DRV          0                  0x0              
 * 0x0119[3:0]   OUT3_CM                11                 0xB              
 * 0x0119[6:4]   OUT3_AMPL              3                  0x3              
 * 0x011A[2:0]   OUT3_MUX_SEL           0                  0x0              
 * 0x011A[5:4]   OUT3_VDD_SEL           2                  0x2              
 * 0x011A[3]     OUT3_VDD_SEL_EN        1                  0x1              
 * 0x011A[7:6]   OUT3_INV               0                  0x0              
 * 0x011C[0]     OUT4_PDN               1                  0x1              
 * 0x011C[1]     OUT4_OE                0                  0x0              
 * 0x011C[2]     OUT4_RDIV_FORCE2       0                  0x0              
 * 0x011D[2:0]   OUT4_FORMAT            1                  0x1              
 * 0x011D[3]     OUT4_SYNC_EN           1                  0x1              
 * 0x011D[5:4]   OUT4_DIS_STATE         0                  0x0              
 * 0x011D[7:6]   OUT4_CMOS_DRV          0                  0x0              
 * 0x011E[3:0]   OUT4_CM                11                 0xB              
 * 0x011E[6:4]   OUT4_AMPL              3                  0x3              
 * 0x011F[2:0]   OUT4_MUX_SEL           0                  0x0              
 * 0x011F[5:4]   OUT4_VDD_SEL           2                  0x2              
 * 0x011F[3]     OUT4_VDD_SEL_EN        1                  0x1              
 * 0x011F[7:6]   OUT4_INV               0                  0x0              
 * 0x0121[0]     OUT5_PDN               0                  0x0              
 * 0x0121[1]     OUT5_OE                1                  0x1              
 * 0x0121[2]     OUT5_RDIV_FORCE2       0                  0x0              
 * 0x0122[2:0]   OUT5_FORMAT            1                  0x1              
 * 0x0122[3]     OUT5_SYNC_EN           1                  0x1              
 * 0x0122[5:4]   OUT5_DIS_STATE         0                  0x0              
 * 0x0122[7:6]   OUT5_CMOS_DRV          0                  0x0              
 * 0x0123[3:0]   OUT5_CM                11                 0xB              
 * 0x0123[6:4]   OUT5_AMPL              3                  0x3              
 * 0x0124[2:0]   OUT5_MUX_SEL           1                  0x1              
 * 0x0124[5:4]   OUT5_VDD_SEL           2                  0x2              
 * 0x0124[3]     OUT5_VDD_SEL_EN        1                  0x1              
 * 0x0124[7:6]   OUT5_INV               0                  0x0              
 * 0x0126[0]     OUT6_PDN               1                  0x1              
 * 0x0126[1]     OUT6_OE                0                  0x0              
 * 0x0126[2]     OUT6_RDIV_FORCE2       0                  0x0              
 * 0x0127[2:0]   OUT6_FORMAT            1                  0x1              
 * 0x0127[3]     OUT6_SYNC_EN           1                  0x1              
 * 0x0127[5:4]   OUT6_DIS_STATE         0                  0x0              
 * 0x0127[7:6]   OUT6_CMOS_DRV          0                  0x0              
 * 0x0128[3:0]   OUT6_CM                11                 0xB              
 * 0x0128[6:4]   OUT6_AMPL              3                  0x3              
 * 0x0129[2:0]   OUT6_MUX_SEL           0                  0x0              
 * 0x0129[5:4]   OUT6_VDD_SEL           2                  0x2              
 * 0x0129[3]     OUT6_VDD_SEL_EN        1                  0x1              
 * 0x0129[7:6]   OUT6_INV               0                  0x0              
 * 0x012B[0]     OUT7_PDN               1                  0x1              
 * 0x012B[1]     OUT7_OE                0                  0x0              
 * 0x012B[2]     OUT7_RDIV_FORCE2       0                  0x0              
 * 0x012C[2:0]   OUT7_FORMAT            1                  0x1              
 * 0x012C[3]     OUT7_SYNC_EN           1                  0x1              
 * 0x012C[5:4]   OUT7_DIS_STATE         0                  0x0              
 * 0x012C[7:6]   OUT7_CMOS_DRV          0                  0x0              
 * 0x012D[3:0]   OUT7_CM                11                 0xB              
 * 0x012D[6:4]   OUT7_AMPL              3                  0x3              
 * 0x012E[2:0]   OUT7_MUX_SEL           0                  0x0              
 * 0x012E[5:4]   OUT7_VDD_SEL           2                  0x2              
 * 0x012E[3]     OUT7_VDD_SEL_EN        1                  0x1              
 * 0x012E[7:6]   OUT7_INV               0                  0x0              
 * 0x0130[0]     OUT8_PDN               0                  0x0              
 * 0x0130[1]     OUT8_OE                1                  0x1              
 * 0x0130[2]     OUT8_RDIV_FORCE2       0                  0x0              
 * 0x0131[2:0]   OUT8_FORMAT            1                  0x1              
 * 0x0131[3]     OUT8_SYNC_EN           1                  0x1              
 * 0x0131[5:4]   OUT8_DIS_STATE         0                  0x0              
 * 0x0131[7:6]   OUT8_CMOS_DRV          0                  0x0              
 * 0x0132[3:0]   OUT8_CM                11                 0xB              
 * 0x0132[6:4]   OUT8_AMPL              3                  0x3              
 * 0x0133[2:0]   OUT8_MUX_SEL           2                  0x2              
 * 0x0133[5:4]   OUT8_VDD_SEL           2                  0x2              
 * 0x0133[3]     OUT8_VDD_SEL_EN        1                  0x1              
 * 0x0133[7:6]   OUT8_INV               0                  0x0              
 * 0x013A[0]     OUT9_PDN               1                  0x1              
 * 0x013A[1]     OUT9_OE                0                  0x0              
 * 0x013A[2]     OUT9_RDIV_FORCE2       0                  0x0              
 * 0x013B[2:0]   OUT9_FORMAT            1                  0x1              
 * 0x013B[3]     OUT9_SYNC_EN           1                  0x1              
 * 0x013B[5:4]   OUT9_DIS_STATE         0                  0x0              
 * 0x013B[7:6]   OUT9_CMOS_DRV          0                  0x0              
 * 0x013C[3:0]   OUT9_CM                11                 0xB              
 * 0x013C[6:4]   OUT9_AMPL              3                  0x3              
 * 0x013D[2:0]   OUT9_MUX_SEL           0                  0x0              
 * 0x013D[5:4]   OUT9_VDD_SEL           2                  0x2              
 * 0x013D[3]     OUT9_VDD_SEL_EN        1                  0x1              
 * 0x013D[7:6]   OUT9_INV               0                  0x0              
 * 0x013F[11:0]  OUTX_ALWAYS_ON         0                  0x000            
 * 0x0141[1]     OUT_DIS_MSK            0                  0x0              
 * 0x0141[5]     OUT_DIS_LOL_MSK        0                  0x0              
 * 0x0141[6]     OUT_DIS_LOSXAXB_MSK    1                  0x1              
 * 0x0141[7]     OUT_DIS_MSK_LOS_PFD    0                  0x0              
 * 0x0142[1]     OUT_DIS_MSK_LOL        1                  0x1              
 * 0x0142[5]     OUT_DIS_MSK_HOLD       1                  0x1              
 * 0x0206[1:0]   PXAXB                  0                  0x0              
 * 0x0208[47:0]  P0_NUM                 1                  0x000000000001   
 * 0x020E[31:0]  P0_DEN                 1                  0x00000001       
 * 0x0212[47:0]  P1_NUM                 0                  0x000000000000   
 * 0x0218[31:0]  P1_DEN                 0                  0x00000000       
 * 0x021C[47:0]  P2_NUM                 0                  0x000000000000   
 * 0x0222[31:0]  P2_DEN                 0                  0x00000000       
 * 0x0226[47:0]  P3_NUM                 0                  0x000000000000   
 * 0x022C[31:0]  P3_DEN                 0                  0x00000000       
 * 0x0231[3:0]   P0_FRACN_MODE          11                 0xB              
 * 0x0231[4]     P0_FRACN_EN            0                  0x0              
 * 0x0232[3:0]   P1_FRACN_MODE          11                 0xB              
 * 0x0232[4]     P1_FRACN_EN            0                  0x0              
 * 0x0233[3:0]   P2_FRACN_MODE          11                 0xB              
 * 0x0233[4]     P2_FRACN_EN            0                  0x0              
 * 0x0234[3:0]   P3_FRACN_MODE          11                 0xB              
 * 0x0234[4]     P3_FRACN_EN            0                  0x0              
 * 0x0235[43:0]  MXAXB_NUM              916841299968       0x0D578000000    
 * 0x023B[31:0]  MXAXB_DEN              3489660928         0xD0000000       
 * 0x024A[23:0]  R0_REG                 10                 0x00000A         
 * 0x024D[23:0]  R1_REG                 0                  0x000000         
 * 0x0250[23:0]  R2_REG                 1                  0x000001         
 * 0x0253[23:0]  R3_REG                 0                  0x000000         
 * 0x0256[23:0]  R4_REG                 0                  0x000000         
 * 0x0259[23:0]  R5_REG                 2                  0x000002         
 * 0x025C[23:0]  R6_REG                 0                  0x000000         
 * 0x025F[23:0]  R7_REG                 0                  0x000000         
 * 0x0262[23:0]  R8_REG                 2                  0x000002         
 * 0x0268[23:0]  R9_REG                 0                  0x000000         
 * 0x026B[7:0]   DESIGN_ID0             73                 0x49             
 * 0x026C[7:0]   DESIGN_ID1             79                 0x4F             
 * 0x026D[7:0]   DESIGN_ID2             52                 0x34             
 * 0x026E[7:0]   DESIGN_ID3             75                 0x4B             
 * 0x026F[7:0]   DESIGN_ID4             43                 0x2B             
 * 0x0270[7:0]   DESIGN_ID5             0                  0x00             
 * 0x0271[7:0]   DESIGN_ID6             0                  0x00             
 * 0x0272[7:0]   DESIGN_ID7             0                  0x00             
 * 0x0294[7:4]   FASTLOCK_EXTEND_SCL    8                  0x8              
 * 0x0296[1]     LOL_SLW_VALWIN_SELX    0                  0x0              
 * 0x0297[1]     FASTLOCK_DLY_ONSW_EN   1                  0x1              
 * 0x0299[1]     FASTLOCK_DLY_ONLOL_EN  1                  0x1              
 * 0x029D[19:0]  FASTLOCK_DLY_ONLOL     3829               0x00EF5          
 * 0x02A9[19:0]  FASTLOCK_DLY_ONSW      9830               0x02666          
 * 0x02B7[3:2]   LOL_NOSIG_TIME         3                  0x3              
 * 0x0302[43:0]  N0_NUM                 49392123904        0x00B80000000    
 * 0x0308[31:0]  N0_DEN                 2147483648         0x80000000       
 * 0x030C[0]     N0_UPDATE              0                  0x0              
 * 0x030D[43:0]  N1_NUM                 198967296000       0x02E53600000    
 * 0x0313[31:0]  N1_DEN                 2147483648         0x80000000       
 * 0x0317[0]     N1_UPDATE              0                  0x0              
 * 0x0318[43:0]  N2_NUM                 48282730496        0x00B3DE00000    
 * 0x031E[31:0]  N2_DEN                 3145728000         0xBB800000       
 * 0x0322[0]     N2_UPDATE              0                  0x0              
 * 0x0323[43:0]  N3_NUM                 0                  0x00000000000    
 * 0x0329[31:0]  N3_DEN                 0                  0x00000000       
 * 0x032D[0]     N3_UPDATE              0                  0x0              
 * 0x032E[43:0]  N4_NUM                 0                  0x00000000000    
 * 0x0334[31:0]  N4_DEN                 0                  0x00000000       
 * 0x0338[0]     N4_UPDATE              0                  0x0              
 * 0x0338[1]     N_UPDATE               0                  0x0              
 * 0x0339[4:0]   N_FSTEP_MSK            31                 0x1F             
 * 0x033B[43:0]  N0_FSTEPW              0                  0x00000000000    
 * 0x0341[43:0]  N1_FSTEPW              0                  0x00000000000    
 * 0x0347[43:0]  N2_FSTEPW              0                  0x00000000000    
 * 0x034D[43:0]  N3_FSTEPW              0                  0x00000000000    
 * 0x0353[43:0]  N4_FSTEPW              0                  0x00000000000    
 * 0x0359[15:0]  N0_DELAY               0                  0x0000           
 * 0x035B[15:0]  N1_DELAY               0                  0x0000           
 * 0x035D[15:0]  N2_DELAY               0                  0x0000           
 * 0x035F[15:0]  N3_DELAY               0                  0x0000           
 * 0x0361[15:0]  N4_DELAY               0                  0x0000           
 * 0x0487[0]     ZDM_EN                 0                  0x0              
 * 0x0487[2:1]   ZDM_IN_SEL             0                  0x0              
 * 0x0487[4]     ZDM_AUTOSW_EN          0                  0x0              
 * 0x0502[4]     ADD_DIV256             0                  0x0              
 * 0x0508[5:0]   BW0_PLL                16                 0x10             
 * 0x0509[5:0]   BW1_PLL                24                 0x18             
 * 0x050A[5:0]   BW2_PLL                15                 0x0F             
 * 0x050B[5:0]   BW3_PLL                15                 0x0F             
 * 0x050C[5:0]   BW4_PLL                1                  0x01             
 * 0x050D[5:0]   BW5_PLL                7                  0x07             
 * 0x050E[5:0]   FASTLOCK_BW0_PLL       23                 0x17             
 * 0x050F[5:0]   FASTLOCK_BW1_PLL       40                 0x28             
 * 0x0510[5:0]   FASTLOCK_BW2_PLL       12                 0x0C             
 * 0x0511[5:0]   FASTLOCK_BW3_PLL       11                 0x0B             
 * 0x0512[5:0]   FASTLOCK_BW4_PLL       1                  0x01             
 * 0x0513[5:0]   FASTLOCK_BW5_PLL       7                  0x07             
 * 0x0515[55:0]  M_NUM                  108662672588800    0x0062D400000000 
 * 0x051C[31:0]  M_DEN                  2147483648         0x80000000       
 * 0x0521[3:0]   M_FRAC_MODE            11                 0xB              
 * 0x0521[4]     M_FRAC_EN              0                  0x0              
 * 0x0521[5]     PLL_OUT_RATE_SEL       1                  0x1              
 * 0x052A[0]     IN_SEL_REGCTRL         1                  0x1              
 * 0x052A[3:1]   IN_SEL                 0                  0x0              
 * 0x052B[0]     FASTLOCK_AUTO_EN       1                  0x1              
 * 0x052B[1]     FASTLOCK_MAN           0                  0x0              
 * 0x052C[0]     HOLD_EN                1                  0x1              
 * 0x052C[3]     HOLD_RAMP_BYP          1                  0x1              
 * 0x052C[4]     HOLDEXIT_BW_SEL1       0                  0x0              
 * 0x052C[7:5]   RAMP_STEP_INTERVAL     0                  0x0              
 * 0x052D[1]     HOLD_RAMPBYP_NOHIST    1                  0x1              
 * 0x052E[4:0]   HOLD_HIST_LEN          21                 0x15             
 * 0x052F[4:0]   HOLD_HIST_DELAY        20                 0x14             
 * 0x0531[4:0]   HOLD_REF_COUNT_FRC     0                  0x00             
 * 0x0532[23:0]  HOLD_15M_CYC_COUNT     30865              0x007891         
 * 0x0535[0]     FORCE_HOLD             0                  0x0              
 * 0x0536[1:0]   CLK_SWITCH_MODE        0                  0x0              
 * 0x0536[2]     HSW_EN                 0                  0x0              
 * 0x0537[3:0]   IN_LOS_MSK             0                  0x0              
 * 0x0537[7:4]   IN_OOF_MSK             0                  0x0              
 * 0x0538[2:0]   IN0_PRIORITY           0                  0x0              
 * 0x0538[6:4]   IN1_PRIORITY           0                  0x0              
 * 0x0539[2:0]   IN2_PRIORITY           0                  0x0              
 * 0x0539[6:4]   IN3_PRIORITY           0                  0x0              
 * 0x053A[1:0]   HSW_MODE               2                  0x2              
 * 0x053A[3:2]   HSW_PHMEAS_CTRL        0                  0x0              
 * 0x053B[9:0]   HSW_PHMEAS_THR         3                  0x003            
 * 0x053D[4:0]   HSW_COARSE_PM_LEN      19                 0x13             
 * 0x053E[4:0]   HSW_COARSE_PM_DLY      6                  0x06             
 * 0x0589[12:0]  CAP_SHORT_DELAY        503                0x01F7           
 * 0x059B[4]     HOLD_PRESERVE_HIST     1                  0x1              
 * 0x059B[5]     HOLD_FRZ_WITH_INTONLY  1                  0x1              
 * 0x059B[6]     HOLDEXIT_BW_SEL0       1                  0x1              
 * 0x059B[7]     HOLDEXIT_STD_BO        1                  0x1              
 * 0x059D[5:0]   HOLDEXIT_BW0           23                 0x17             
 * 0x059E[5:0]   HOLDEXIT_BW1           40                 0x28             
 * 0x059F[5:0]   HOLDEXIT_BW2           12                 0x0C             
 * 0x05A0[5:0]   HOLDEXIT_BW3           11                 0x0B             
 * 0x05A1[5:0]   HOLDEXIT_BW4           1                  0x01             
 * 0x05A2[5:0]   HOLDEXIT_BW5           7                  0x07             
 * 0x05A6[2:0]   RAMP_STEP_SIZE         0                  0x0              
 * 0x05A6[3]     RAMP_SWITCH_EN         0                  0x0              
 * 0x0802[15:0]  FIXREGSA0              1333               0x0535           
 * 0x0804[7:0]   FIXREGSD0              0                  0x00             
 * 0x0805[15:0]  FIXREGSA1              0                  0x0000           
 * 0x0807[7:0]   FIXREGSD1              0                  0x00             
 * 0x0808[15:0]  FIXREGSA2              0                  0x0000           
 * 0x080A[7:0]   FIXREGSD2              0                  0x00             
 * 0x080B[15:0]  FIXREGSA3              0                  0x0000           
 * 0x080D[7:0]   FIXREGSD3              0                  0x00             
 * 0x080E[15:0]  FIXREGSA4              0                  0x0000           
 * 0x0810[7:0]   FIXREGSD4              0                  0x00             
 * 0x0811[15:0]  FIXREGSA5              0                  0x0000           
 * 0x0813[7:0]   FIXREGSD5              0                  0x00             
 * 0x0814[15:0]  FIXREGSA6              0                  0x0000           
 * 0x0816[7:0]   FIXREGSD6              0                  0x00             
 * 0x0817[15:0]  FIXREGSA7              0                  0x0000           
 * 0x0819[7:0]   FIXREGSD7              0                  0x00             
 * 0x081A[15:0]  FIXREGSA8              0                  0x0000           
 * 0x081C[7:0]   FIXREGSD8              0                  0x00             
 * 0x081D[15:0]  FIXREGSA9              0                  0x0000           
 * 0x081F[7:0]   FIXREGSD9              0                  0x00             
 * 0x0820[15:0]  FIXREGSA10             0                  0x0000           
 * 0x0822[7:0]   FIXREGSD10             0                  0x00             
 * 0x0823[15:0]  FIXREGSA11             0                  0x0000           
 * 0x0825[7:0]   FIXREGSD11             0                  0x00             
 * 0x0826[15:0]  FIXREGSA12             0                  0x0000           
 * 0x0828[7:0]   FIXREGSD12             0                  0x00             
 * 0x0829[15:0]  FIXREGSA13             0                  0x0000           
 * 0x082B[7:0]   FIXREGSD13             0                  0x00             
 * 0x082C[15:0]  FIXREGSA14             0                  0x0000           
 * 0x082E[7:0]   FIXREGSD14             0                  0x00             
 * 0x082F[15:0]  FIXREGSA15             0                  0x0000           
 * 0x0831[7:0]   FIXREGSD15             0                  0x00             
 * 0x0832[15:0]  FIXREGSA16             0                  0x0000           
 * 0x0834[7:0]   FIXREGSD16             0                  0x00             
 * 0x0835[15:0]  FIXREGSA17             0                  0x0000           
 * 0x0837[7:0]   FIXREGSD17             0                  0x00             
 * 0x0838[15:0]  FIXREGSA18             0                  0x0000           
 * 0x083A[7:0]   FIXREGSD18             0                  0x00             
 * 0x083B[15:0]  FIXREGSA19             0                  0x0000           
 * 0x083D[7:0]   FIXREGSD19             0                  0x00             
 * 0x083E[15:0]  FIXREGSA20             0                  0x0000           
 * 0x0840[7:0]   FIXREGSD20             0                  0x00             
 * 0x0841[15:0]  FIXREGSA21             0                  0x0000           
 * 0x0843[7:0]   FIXREGSD21             0                  0x00             
 * 0x0844[15:0]  FIXREGSA22             0                  0x0000           
 * 0x0846[7:0]   FIXREGSD22             0                  0x00             
 * 0x0847[15:0]  FIXREGSA23             0                  0x0000           
 * 0x0849[7:0]   FIXREGSD23             0                  0x00             
 * 0x084A[15:0]  FIXREGSA24             0                  0x0000           
 * 0x084C[7:0]   FIXREGSD24             0                  0x00             
 * 0x084D[15:0]  FIXREGSA25             0                  0x0000           
 * 0x084F[7:0]   FIXREGSD25             0                  0x00             
 * 0x0850[15:0]  FIXREGSA26             0                  0x0000           
 * 0x0852[7:0]   FIXREGSD26             0                  0x00             
 * 0x0853[15:0]  FIXREGSA27             0                  0x0000           
 * 0x0855[7:0]   FIXREGSD27             0                  0x00             
 * 0x0856[15:0]  FIXREGSA28             0                  0x0000           
 * 0x0858[7:0]   FIXREGSD28             0                  0x00             
 * 0x0859[15:0]  FIXREGSA29             0                  0x0000           
 * 0x085B[7:0]   FIXREGSD29             0                  0x00             
 * 0x085C[15:0]  FIXREGSA30             0                  0x0000           
 * 0x085E[7:0]   FIXREGSD30             0                  0x00             
 * 0x085F[15:0]  FIXREGSA31             0                  0x0000           
 * 0x0861[7:0]   FIXREGSD31             0                  0x00             
 * 0x090E[0]     XAXB_EXTCLK_EN         1                  0x1              
 * 0x0943[0]     IO_VDD_SEL             0                  0x0              
 * 0x0949[3:0]   IN_EN                  1                  0x1              
 * 0x0949[7:4]   IN_PULSED_CMOS_EN      3                  0x3              
 * 0x094A[3:0]   INX_TO_PFD_EN          1                  0x1              
 * 0x094E[11:0]  REFCLK_HYS_SEL         585                0x249            
 * 0x095E[0]     MXAXB_INTEGER          0                  0x0              
 * 0x0A02[4:0]   N_ADD_0P5              0                  0x00             
 * 0x0A03[4:0]   N_CLK_TO_OUTX_EN       7                  0x07             
 * 0x0A04[4:0]   N_PIBYP                1                  0x01             
 * 0x0A05[4:0]   N_PDNB                 7                  0x07             
 * 0x0A14[3]     N0_HIGH_FREQ           0                  0x0              
 * 0x0A1A[3]     N1_HIGH_FREQ           0                  0x0              
 * 0x0A20[3]     N2_HIGH_FREQ           0                  0x0              
 * 0x0A26[3]     N3_HIGH_FREQ           0                  0x0              
 * 0x0A2C[3]     N4_HIGH_FREQ           0                  0x0              
 * 0x0B44[3:0]   PDIV_FRACN_CLK_DIS     15                 0xF              
 * 0x0B44[5]     FRACN_CLK_DIS_PLL      1                  0x1              
 * 0x0B46[3:0]   LOS_CLK_DIS            0                  0x0              
 * 0x0B47[4:0]   OOF_CLK_DIS            14                 0x0E             
 * 0x0B48[4:0]   OOF_DIV_CLK_DIS        14                 0x0E             
 * 0x0B4A[4:0]   N_CLK_DIS              24                 0x18             
 * 0x0B57[11:0]  VCO_RESET_CALCODE      249                0x0F9
 * 
 *
 */


static struct ntv2_genlock_data s_genlock_2250_2500[] =
{
	/* Start configuration preamble */
	{ 0x0B24, 0xC0 },
	{ 0x0B25, 0x00 },
	{ 0x0540, 0x01 },
	/* End configuration preamble */

	/* Delay 300 msec */
	/*    Delay is worst case time for device to complete any calibration */
	/*    that is running due to device state change previous to this script */
	/*    being processed. */
	{ 0x0000, 0x01 },

	/* Start configuration registers */
	{ 0x000B, 0x64 },
	{ 0x0016, 0x02 },
	{ 0x0017, 0xFC },
	{ 0x0018, 0xFF },
	{ 0x0019, 0xDF },
	{ 0x001A, 0xDF },
	{ 0x002B, 0x02 },
	{ 0x002C, 0x01 },
	{ 0x002D, 0x02 },
	{ 0x002E, 0x8E },
	{ 0x002F, 0x04 },
	{ 0x0030, 0x00 },
	{ 0x0031, 0x00 },
	{ 0x0032, 0x00 },
	{ 0x0033, 0x00 },
	{ 0x0034, 0x00 },
	{ 0x0035, 0x00 },
	{ 0x0036, 0x2D },
	{ 0x0037, 0x04 },
	{ 0x0038, 0x00 },
	{ 0x0039, 0x00 },
	{ 0x003A, 0x00 },
	{ 0x003B, 0x00 },
	{ 0x003C, 0x00 },
	{ 0x003D, 0x00 },
	{ 0x003F, 0x01 },
	{ 0x0040, 0x04 },
	{ 0x0041, 0x02 },
	{ 0x0042, 0x00 },
	{ 0x0043, 0x00 },
	{ 0x0044, 0x00 },
	{ 0x0045, 0x0C },
	{ 0x0046, 0x96 },
	{ 0x0047, 0x00 },
	{ 0x0048, 0x00 },
	{ 0x0049, 0x00 },
	{ 0x004A, 0x4B },
	{ 0x004B, 0x00 },
	{ 0x004C, 0x00 },
	{ 0x004D, 0x00 },
	{ 0x004E, 0x05 },
	{ 0x004F, 0x00 },
	{ 0x0050, 0x0F },
	{ 0x0051, 0x00 },
	{ 0x0052, 0x00 },
	{ 0x0053, 0x00 },
	{ 0x0054, 0x00 },
	{ 0x0055, 0x00 },
	{ 0x0056, 0x00 },
	{ 0x0057, 0x00 },
	{ 0x0058, 0x00 },
	{ 0x0059, 0x01 },
	{ 0x005A, 0xB9 },
	{ 0x005B, 0x91 },
	{ 0x005C, 0x1B },
	{ 0x005D, 0x01 },
	{ 0x005E, 0x00 },
	{ 0x005F, 0x00 },
	{ 0x0060, 0x00 },
	{ 0x0061, 0x00 },
	{ 0x0062, 0x00 },
	{ 0x0063, 0x00 },
	{ 0x0064, 0x00 },
	{ 0x0065, 0x00 },
	{ 0x0066, 0x00 },
	{ 0x0067, 0x00 },
	{ 0x0068, 0x00 },
	{ 0x0069, 0x00 },
	{ 0x0092, 0x02 },
	{ 0x0093, 0xA0 },
	{ 0x0095, 0x00 },
	{ 0x0096, 0x90 },
	{ 0x0098, 0x70 },
	{ 0x009A, 0x02 },
	{ 0x009B, 0x50 },
	{ 0x009D, 0x04 },
	{ 0x009E, 0x60 },
	{ 0x00A0, 0x30 },
	{ 0x00A2, 0x00 },
	{ 0x00A9, 0x0E },
	{ 0x00AA, 0xA7 },
	{ 0x00AB, 0x04 },
	{ 0x00AC, 0x00 },
	{ 0x00E5, 0x21 },
	{ 0x00EA, 0xD1 },
	{ 0x00EB, 0xB1 },
	{ 0x00EC, 0x03 },
	{ 0x00ED, 0x00 },
	{ 0x0102, 0x01 },
	{ 0x0108, 0x02 },
	{ 0x0109, 0x09 },
	{ 0x010A, 0x3B },
	{ 0x010B, 0x28 },
	{ 0x010D, 0x01 },
	{ 0x010E, 0x09 },
	{ 0x010F, 0x3B },
	{ 0x0110, 0x28 },
	{ 0x0112, 0x02 },
	{ 0x0113, 0x09 },
	{ 0x0114, 0x3B },
	{ 0x0115, 0x28 },
	{ 0x0117, 0x01 },
	{ 0x0118, 0x09 },
	{ 0x0119, 0x3B },
	{ 0x011A, 0x28 },
	{ 0x011C, 0x01 },
	{ 0x011D, 0x09 },
	{ 0x011E, 0x3B },
	{ 0x011F, 0x28 },
	{ 0x0121, 0x02 },
	{ 0x0122, 0x09 },
	{ 0x0123, 0x3B },
	{ 0x0124, 0x29 },
	{ 0x0126, 0x01 },
	{ 0x0127, 0x09 },
	{ 0x0128, 0x3B },
	{ 0x0129, 0x28 },
	{ 0x012B, 0x01 },
	{ 0x012C, 0x09 },
	{ 0x012D, 0x3B },
	{ 0x012E, 0x28 },
	{ 0x0130, 0x02 },
	{ 0x0131, 0x09 },
	{ 0x0132, 0x3B },
	{ 0x0133, 0x2A },
	{ 0x013A, 0x01 },
	{ 0x013B, 0x09 },
	{ 0x013C, 0x3B },
	{ 0x013D, 0x28 },
	{ 0x013F, 0x00 },
	{ 0x0140, 0x00 },
	{ 0x0141, 0x40 },
	{ 0x0142, 0xFF },
	{ 0x0206, 0x00 },
	{ 0x0208, 0x01 },
	{ 0x0209, 0x00 },
	{ 0x020A, 0x00 },
	{ 0x020B, 0x00 },
	{ 0x020C, 0x00 },
	{ 0x020D, 0x00 },
	{ 0x020E, 0x01 },
	{ 0x020F, 0x00 },
	{ 0x0210, 0x00 },
	{ 0x0211, 0x00 },
	{ 0x0212, 0x00 },
	{ 0x0213, 0x00 },
	{ 0x0214, 0x00 },
	{ 0x0215, 0x00 },
	{ 0x0216, 0x00 },
	{ 0x0217, 0x00 },
	{ 0x0218, 0x00 },
	{ 0x0219, 0x00 },
	{ 0x021A, 0x00 },
	{ 0x021B, 0x00 },
	{ 0x021C, 0x00 },
	{ 0x021D, 0x00 },
	{ 0x021E, 0x00 },
	{ 0x021F, 0x00 },
	{ 0x0220, 0x00 },
	{ 0x0221, 0x00 },
	{ 0x0222, 0x00 },
	{ 0x0223, 0x00 },
	{ 0x0224, 0x00 },
	{ 0x0225, 0x00 },
	{ 0x0226, 0x00 },
	{ 0x0227, 0x00 },
	{ 0x0228, 0x00 },
	{ 0x0229, 0x00 },
	{ 0x022A, 0x00 },
	{ 0x022B, 0x00 },
	{ 0x022C, 0x00 },
	{ 0x022D, 0x00 },
	{ 0x022E, 0x00 },
	{ 0x022F, 0x00 },
	{ 0x0231, 0x0B },
	{ 0x0232, 0x0B },
	{ 0x0233, 0x0B },
	{ 0x0234, 0x0B },
	{ 0x0235, 0x00 },
	{ 0x0236, 0x00 },
	{ 0x0237, 0x00 },
	{ 0x0238, 0x78 },
	{ 0x0239, 0xD5 },
	{ 0x023A, 0x00 },
	{ 0x023B, 0x00 },
	{ 0x023C, 0x00 },
	{ 0x023D, 0x00 },
	{ 0x023E, 0xD0 },
	{ 0x024A, 0x0A },
	{ 0x024B, 0x00 },
	{ 0x024C, 0x00 },
	{ 0x024D, 0x00 },
	{ 0x024E, 0x00 },
	{ 0x024F, 0x00 },
	{ 0x0250, 0x01 },
	{ 0x0251, 0x00 },
	{ 0x0252, 0x00 },
	{ 0x0253, 0x00 },
	{ 0x0254, 0x00 },
	{ 0x0255, 0x00 },
	{ 0x0256, 0x00 },
	{ 0x0257, 0x00 },
	{ 0x0258, 0x00 },
	{ 0x0259, 0x02 },
	{ 0x025A, 0x00 },
	{ 0x025B, 0x00 },
	{ 0x025C, 0x00 },
	{ 0x025D, 0x00 },
	{ 0x025E, 0x00 },
	{ 0x025F, 0x00 },
	{ 0x0260, 0x00 },
	{ 0x0261, 0x00 },
	{ 0x0262, 0x02 },
	{ 0x0263, 0x00 },
	{ 0x0264, 0x00 },
	{ 0x0268, 0x00 },
	{ 0x0269, 0x00 },
	{ 0x026A, 0x00 },
	{ 0x026B, 0x49 },
	{ 0x026C, 0x4F },
	{ 0x026D, 0x34 },
	{ 0x026E, 0x4B },
	{ 0x026F, 0x2B },
	{ 0x0270, 0x00 },
	{ 0x0271, 0x00 },
	{ 0x0272, 0x00 },
	{ 0x0294, 0x80 },
	{ 0x0296, 0x00 },
	{ 0x0297, 0x02 },
	{ 0x0299, 0x02 },
	{ 0x029D, 0xF5 },
	{ 0x029E, 0x0E },
	{ 0x029F, 0x00 },
	{ 0x02A9, 0x66 },
	{ 0x02AA, 0x26 },
	{ 0x02AB, 0x00 },
	{ 0x02B7, 0xFF },
	{ 0x0302, 0x00 },
	{ 0x0303, 0x00 },
	{ 0x0304, 0x00 },
	{ 0x0305, 0x80 },
	{ 0x0306, 0x0B },
	{ 0x0307, 0x00 },
	{ 0x0308, 0x00 },
	{ 0x0309, 0x00 },
	{ 0x030A, 0x00 },
	{ 0x030B, 0x80 },
	{ 0x030C, 0x00 },
	{ 0x030D, 0x00 },
	{ 0x030E, 0x00 },
	{ 0x030F, 0x60 },
	{ 0x0310, 0x53 },
	{ 0x0311, 0x2E },
	{ 0x0312, 0x00 },
	{ 0x0313, 0x00 },
	{ 0x0314, 0x00 },
	{ 0x0315, 0x00 },
	{ 0x0316, 0x80 },
	{ 0x0317, 0x00 },
	{ 0x0318, 0x00 },
	{ 0x0319, 0x00 },
	{ 0x031A, 0xE0 },
	{ 0x031B, 0x3D },
	{ 0x031C, 0x0B },
	{ 0x031D, 0x00 },
	{ 0x031E, 0x00 },
	{ 0x031F, 0x00 },
	{ 0x0320, 0x80 },
	{ 0x0321, 0xBB },
	{ 0x0322, 0x00 },
	{ 0x0323, 0x00 },
	{ 0x0324, 0x00 },
	{ 0x0325, 0x00 },
	{ 0x0326, 0x00 },
	{ 0x0327, 0x00 },
	{ 0x0328, 0x00 },
	{ 0x0329, 0x00 },
	{ 0x032A, 0x00 },
	{ 0x032B, 0x00 },
	{ 0x032C, 0x00 },
	{ 0x032D, 0x00 },
	{ 0x032E, 0x00 },
	{ 0x032F, 0x00 },
	{ 0x0330, 0x00 },
	{ 0x0331, 0x00 },
	{ 0x0332, 0x00 },
	{ 0x0333, 0x00 },
	{ 0x0334, 0x00 },
	{ 0x0335, 0x00 },
	{ 0x0336, 0x00 },
	{ 0x0337, 0x00 },
	{ 0x0338, 0x00 },
	{ 0x0339, 0x1F },
	{ 0x033B, 0x00 },
	{ 0x033C, 0x00 },
	{ 0x033D, 0x00 },
	{ 0x033E, 0x00 },
	{ 0x033F, 0x00 },
	{ 0x0340, 0x00 },
	{ 0x0341, 0x00 },
	{ 0x0342, 0x00 },
	{ 0x0343, 0x00 },
	{ 0x0344, 0x00 },
	{ 0x0345, 0x00 },
	{ 0x0346, 0x00 },
	{ 0x0347, 0x00 },
	{ 0x0348, 0x00 },
	{ 0x0349, 0x00 },
	{ 0x034A, 0x00 },
	{ 0x034B, 0x00 },
	{ 0x034C, 0x00 },
	{ 0x034D, 0x00 },
	{ 0x034E, 0x00 },
	{ 0x034F, 0x00 },
	{ 0x0350, 0x00 },
	{ 0x0351, 0x00 },
	{ 0x0352, 0x00 },
	{ 0x0353, 0x00 },
	{ 0x0354, 0x00 },
	{ 0x0355, 0x00 },
	{ 0x0356, 0x00 },
	{ 0x0357, 0x00 },
	{ 0x0358, 0x00 },
	{ 0x0359, 0x00 },
	{ 0x035A, 0x00 },
	{ 0x035B, 0x00 },
	{ 0x035C, 0x00 },
	{ 0x035D, 0x00 },
	{ 0x035E, 0x00 },
	{ 0x035F, 0x00 },
	{ 0x0360, 0x00 },
	{ 0x0361, 0x00 },
	{ 0x0362, 0x00 },
	{ 0x0487, 0x00 },
	{ 0x0502, 0x01 },
	{ 0x0508, 0x10 },
	{ 0x0509, 0x18 },
	{ 0x050A, 0x0F },
	{ 0x050B, 0x0F },
	{ 0x050C, 0x01 },
	{ 0x050D, 0x07 },
	{ 0x050E, 0x17 },
	{ 0x050F, 0x28 },
	{ 0x0510, 0x0C },
	{ 0x0511, 0x0B },
	{ 0x0512, 0x01 },
	{ 0x0513, 0x07 },
	{ 0x0515, 0x00 },
	{ 0x0516, 0x00 },
	{ 0x0517, 0x00 },
	{ 0x0518, 0x00 },
	{ 0x0519, 0xE0 },
	{ 0x051A, 0x5E },
	{ 0x051B, 0x00 },
	{ 0x051C, 0x00 },
	{ 0x051D, 0x00 },
	{ 0x051E, 0x00 },
	{ 0x051F, 0x80 },
	{ 0x0521, 0x2B },
	{ 0x052A, 0x01 },
	{ 0x052B, 0x01 },
	{ 0x052C, 0x0F },
	{ 0x052D, 0x03 },
	{ 0x052E, 0x15 },
	{ 0x052F, 0x14 },
	{ 0x0531, 0x00 },
	{ 0x0532, 0xBE },
	{ 0x0533, 0x73 },
	{ 0x0534, 0x00 },
	{ 0x0535, 0x00 },
	{ 0x0536, 0x00 },
	{ 0x0537, 0x00 },
	{ 0x0538, 0x00 },
	{ 0x0539, 0x00 },
	{ 0x053A, 0x02 },
	{ 0x053B, 0x03 },
	{ 0x053C, 0x00 },
	{ 0x053D, 0x13 },
	{ 0x053E, 0x06 },
	{ 0x0589, 0xE3 },
	{ 0x058A, 0x01 },
	{ 0x059B, 0xF8 },
	{ 0x059D, 0x17 },
	{ 0x059E, 0x28 },
	{ 0x059F, 0x0C },
	{ 0x05A0, 0x0B },
	{ 0x05A1, 0x01 },
	{ 0x05A2, 0x07 },
	{ 0x05A6, 0x00 },
	{ 0x0802, 0x35 },
	{ 0x0803, 0x05 },
	{ 0x0804, 0x00 },
	{ 0x0805, 0x00 },
	{ 0x0806, 0x00 },
	{ 0x0807, 0x00 },
	{ 0x0808, 0x00 },
	{ 0x0809, 0x00 },
	{ 0x080A, 0x00 },
	{ 0x080B, 0x00 },
	{ 0x080C, 0x00 },
	{ 0x080D, 0x00 },
	{ 0x080E, 0x00 },
	{ 0x080F, 0x00 },
	{ 0x0810, 0x00 },
	{ 0x0811, 0x00 },
	{ 0x0812, 0x00 },
	{ 0x0813, 0x00 },
	{ 0x0814, 0x00 },
	{ 0x0815, 0x00 },
	{ 0x0816, 0x00 },
	{ 0x0817, 0x00 },
	{ 0x0818, 0x00 },
	{ 0x0819, 0x00 },
	{ 0x081A, 0x00 },
	{ 0x081B, 0x00 },
	{ 0x081C, 0x00 },
	{ 0x081D, 0x00 },
	{ 0x081E, 0x00 },
	{ 0x081F, 0x00 },
	{ 0x0820, 0x00 },
	{ 0x0821, 0x00 },
	{ 0x0822, 0x00 },
	{ 0x0823, 0x00 },
	{ 0x0824, 0x00 },
	{ 0x0825, 0x00 },
	{ 0x0826, 0x00 },
	{ 0x0827, 0x00 },
	{ 0x0828, 0x00 },
	{ 0x0829, 0x00 },
	{ 0x082A, 0x00 },
	{ 0x082B, 0x00 },
	{ 0x082C, 0x00 },
	{ 0x082D, 0x00 },
	{ 0x082E, 0x00 },
	{ 0x082F, 0x00 },
	{ 0x0830, 0x00 },
	{ 0x0831, 0x00 },
	{ 0x0832, 0x00 },
	{ 0x0833, 0x00 },
	{ 0x0834, 0x00 },
	{ 0x0835, 0x00 },
	{ 0x0836, 0x00 },
	{ 0x0837, 0x00 },
	{ 0x0838, 0x00 },
	{ 0x0839, 0x00 },
	{ 0x083A, 0x00 },
	{ 0x083B, 0x00 },
	{ 0x083C, 0x00 },
	{ 0x083D, 0x00 },
	{ 0x083E, 0x00 },
	{ 0x083F, 0x00 },
	{ 0x0840, 0x00 },
	{ 0x0841, 0x00 },
	{ 0x0842, 0x00 },
	{ 0x0843, 0x00 },
	{ 0x0844, 0x00 },
	{ 0x0845, 0x00 },
	{ 0x0846, 0x00 },
	{ 0x0847, 0x00 },
	{ 0x0848, 0x00 },
	{ 0x0849, 0x00 },
	{ 0x084A, 0x00 },
	{ 0x084B, 0x00 },
	{ 0x084C, 0x00 },
	{ 0x084D, 0x00 },
	{ 0x084E, 0x00 },
	{ 0x084F, 0x00 },
	{ 0x0850, 0x00 },
	{ 0x0851, 0x00 },
	{ 0x0852, 0x00 },
	{ 0x0853, 0x00 },
	{ 0x0854, 0x00 },
	{ 0x0855, 0x00 },
	{ 0x0856, 0x00 },
	{ 0x0857, 0x00 },
	{ 0x0858, 0x00 },
	{ 0x0859, 0x00 },
	{ 0x085A, 0x00 },
	{ 0x085B, 0x00 },
	{ 0x085C, 0x00 },
	{ 0x085D, 0x00 },
	{ 0x085E, 0x00 },
	{ 0x085F, 0x00 },
	{ 0x0860, 0x00 },
	{ 0x0861, 0x00 },
	{ 0x090E, 0x03 },
	{ 0x0943, 0x00 },
	{ 0x0949, 0x31 },
	{ 0x094A, 0x01 },
	{ 0x094E, 0x49 },
	{ 0x094F, 0x02 },
	{ 0x095E, 0x00 },
	{ 0x0A02, 0x00 },
	{ 0x0A03, 0x07 },
	{ 0x0A04, 0x01 },
	{ 0x0A05, 0x07 },
	{ 0x0A14, 0x00 },
	{ 0x0A1A, 0x00 },
	{ 0x0A20, 0x00 },
	{ 0x0A26, 0x00 },
	{ 0x0A2C, 0x00 },
	{ 0x0B44, 0x2F },
	{ 0x0B46, 0x00 },
	{ 0x0B47, 0x0E },
	{ 0x0B48, 0x0E },
	{ 0x0B4A, 0x18 },
	{ 0x0B57, 0xF9 },
	{ 0x0B58, 0x00 },
	/* End configuration registers */

	/* Start configuration postamble */
	{ 0x0514, 0x01 },
	{ 0x001C, 0x01 },
	{ 0x0540, 0x00 },
	{ 0x0B24, 0xC3 },
	{ 0x0B25, 0x02 },
	/* End configuration postamble */

	{ 0x0000, 0x00 }
};

/*
 * Design Report
 *
 * Overview
 * ========
 * Part:         Si5345 Rev D
 * Project File: C:\XilinxProjects\flint_tr051017\genlock\FormatFiles\IO4K+_1125_5994.slabtimeproj
 * Design ID:    IO4K+
 * Created By:   ClockBuilder Pro v2.16.1 [2017-07-19]
 * Timestamp:    2017-08-24 16:58:32 GMT-07:00
 * 
 * Design Notes
 * ============
 * assumes NTSC HSYNC (pulsed) input = (30/1.001)*525
 * 
 * Design Rule Check
 * =================
 * Errors:
 * - No errors
 * 
 * Warnings:
 * - Pulsed LVCMOS input buffer mode has been selected. This mode has non-standard input voltage logic thresholds: 0.33 V for Vil (max) and 0.49 V for Vih (min). Select this mode only if your input clock has a duty cycle significantly less or more than 50%.  Refer to the device datasheet for the exact threshold voltage specifications and the input attenuator circuit (DC coupled Pulsed LVCMOS) in the Family Reference Manual.
 * 
 * Device Grade
 * ============
 * Maximum Output Frequency: 148.5 MHz
 * Frequency Synthesis Mode: Fractional
 * Minimum Base OPN:         Si5345B
 * Actual Base OPN:          Si5345B
 * 
 * Base       Output Clock         Supported Frequency Synthesis Modes
 * OPN Grade  Frequency Range      (Typical Jitter)
 * ---------  -------------------  --------------------------------------------
 * Si5345A    100 Hz to 1.028 GHz  Integer (< 100 fs) and fractional (< 150 fs)
 * Si5345B    100 Hz to 350 MHz    "
 * Si5345C    100 Hz to 1.028 GHz  Integer only (< 100 fs)
 * Si5345D    100 Hz to 350 MHz    "
 * 
 * Design
 * ======
 * Host Interface:
 *    I/O Power Supply: VDD (Core)
 *    SPI Mode: 4-Wire
 *    I2C Address Range: 100d to 103d / 0x64 to 0x67 (selected via A0/A1 pins)
 * 
 * XA/XB:
 *    52 MHz (XO - External Oscillator)
 * 
 * Inputs:
 *     IN0: 56.25 kHz [ 56 + 1/4 kHz ]
 *          [ (25)*2250 ]
 *          Pulsed LVCMOS
 *     IN1: Unused
 *     IN2: Unused
 *     IN3: Unused
 * 
 * Outputs:
 *    OUT0: 27 MHz
 *          Enabled, LVDS 2.5 V
 *    OUT1: Unused
 *    OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT3: Unused
 *    OUT4: Unused
 *    OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT6: Unused
 *    OUT7: Unused
 *    OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *          [ 148.5/1.001 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT9: Unused
 * 
 * Frequency Plan
 * ==============
 * Priority: maximize the number of low jitter outputs
 * 
 * Fvco = 13.662 GHz [ 13 + 331/500 GHz ]
 * Fpfd = 56.25 kHz [ 56 + 1/4 kHz ]
 * Fms0 = 594 MHz
 * Fms1 = 147.456 MHz [ 147 + 57/125 MHz ]
 * Fms2 = 890.1098901098901098... MHz [ 890 + 10/91 MHz ]
 * 
 * P dividers:
 *    P0  = 1
 *    P1  = Unused
 *    P2  = Unused
 *    P3  = Unused
 *    Pxaxb = 1
 * 
 * MXAXB = 262.7307692307692307... [ 262 + 19/26 ]
 * M = 48576
 * N dividers:
 *    N0:
 *       Value: 23
 *       Skew:  0.000 s
 *       OUT0: 27 MHz
 *       OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *    N1:
 *       Value: 92.6513671875 [ 92 + 667/1024 ]
 *       Skew:  0.000 s
 *       OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *    N2:
 *       Value: 15.3486666666666666... [ 15 + 523/1500 ]
 *       Skew:  0.000 s
 *       OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *    N3:
 *       Unused
 *    N4:
 *       Unused
 * 
 * R dividers:
 *    R0 = 22
 *    R1 = Unused
 *    R2 = 4
 *    R3 = Unused
 *    R4 = Unused
 *    R5 = 6
 *    R6 = Unused
 *    R7 = Unused
 *    R8 = 6
 *    R9 = Unused
 * 
 * Nominal Bandwidth:
 *   Desired: 1.000 Hz
 *   Actual:  541.440 mHz
 *   Coefficients:
 *      BW0:  16
 *      BW1:  24
 *      BW2:  15
 *      BW3:  15
 *      BW4:  1
 *      BW5:  7
 * Fastlock Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  85.050 Hz
 *   Coefficients:
 *      BW0:  23
 *      BW1:  40
 *      BW2:  12
 *      BW3:  11
 *      BW4:  1
 *      BW5:  7
 * Holdover Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  85.050 Hz
 *   Coefficients:
 *      BW0:  23
 *      BW1:  40
 *      BW2:  12
 *      BW3:  11
 *      BW4:  1
 *      BW5:  7
 * 
 * Dividers listed above show effective values. These values are translated to register settings by ClockBuilder Pro. For the actual register values, see below. Refer to the Family Reference Manual for information on registers related to frequency plan.
 * 
 * Digitally Controlled Oscillator (DCO)
 * =====================================
 * Mode: Register Direct Write
 * 
 * N0: DCO Disabled
 * 
 * N1: DCO Disabled
 * 
 * N2: DCO Disabled
 * 
 * N3: DCO Disabled
 * 
 * N4: DCO Disabled
 * 
 * Estimated Power & Junction Temperature
 * ======================================
 * Assumptions:
 * 
 * Revision: D
 * VDD:      1.8 V
 * Ta:       70 C
 * Airflow:  None
 * 
 * Total Power: 808 mW, On Chip Power: 784 mW, Tj: 87 C
 * 
 *                 Frequency  Format   Voltage   Current     Power
 *         -----------------  ------  --------  --------  --------
 * VDD                                   1.8 V  147.9 mA    266 mW
 * VDDA                                  3.3 V  117.4 mA    387 mW
 * VDDO0              27 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO1              Unused                                      
 * VDDO2           148.5 MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO3              Unused                                      
 * VDDO4              Unused                                      
 * VDDO5          24.576 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO6              Unused                                      
 * VDDO7              Unused                                      
 * VDDO8   148.351648... MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO9              Unused                                      
 *                                              --------  --------
 *                                       Total  327.2 mA    808 mW
 * 
 * Note:
 * 
 * -Total power includes on- and off-chip power. This is a typical value and estimate only.
 * -Use an EVB for a more exact power measurement
 * -On-chip power excludes power dissipated in external terminations.
 * -Tj is junction temperature. Tj must be less than 125 C (on Si5345 Revision D) for device to comply with datasheet specifications.
 * 
 * Settings
 * ========
 * 
 * Location      Setting Name           Decimal Value      Hex Value        
 * ------------  ---------------------  -----------------  -----------------
 * 0x000B[6:0]   I2C_ADDR               100                0x64             
 * 0x0016[1]     LOL_ON_HOLD            1                  0x1              
 * 0x0017[0]     SYSINCAL_INTR_MSK      0                  0x0              
 * 0x0017[1]     LOSXAXB_INTR_MSK       0                  0x0              
 * 0x0017[5]     SMB_TMOUT_INTR_MSK     1                  0x1              
 * 0x0018[3:0]   LOS_INTR_MSK           15                 0xF              
 * 0x0018[7:4]   OOF_INTR_MSK           15                 0xF              
 * 0x0019[1]     LOL_INTR_MSK           1                  0x1              
 * 0x0019[5]     HOLD_INTR_MSK          0                  0x0              
 * 0x001A[5]     CAL_INTR_MSK           0                  0x0              
 * 0x002B[3]     SPI_3WIRE              0                  0x0              
 * 0x002B[5]     AUTO_NDIV_UPDATE       0                  0x0              
 * 0x002C[3:0]   LOS_EN                 1                  0x1              
 * 0x002C[4]     LOSXAXB_DIS            0                  0x0              
 * 0x002D[1:0]   LOS0_VAL_TIME          2                  0x2              
 * 0x002D[3:2]   LOS1_VAL_TIME          0                  0x0              
 * 0x002D[5:4]   LOS2_VAL_TIME          0                  0x0              
 * 0x002D[7:6]   LOS3_VAL_TIME          0                  0x0              
 * 0x002E[15:0]  LOS0_TRG_THR           1166               0x048E           
 * 0x0030[15:0]  LOS1_TRG_THR           0                  0x0000           
 * 0x0032[15:0]  LOS2_TRG_THR           0                  0x0000           
 * 0x0034[15:0]  LOS3_TRG_THR           0                  0x0000           
 * 0x0036[15:0]  LOS0_CLR_THR           1069               0x042D           
 * 0x0038[15:0]  LOS1_CLR_THR           0                  0x0000           
 * 0x003A[15:0]  LOS2_CLR_THR           0                  0x0000           
 * 0x003C[15:0]  LOS3_CLR_THR           0                  0x0000           
 * 0x003F[3:0]   OOF_EN                 1                  0x1              
 * 0x003F[7:4]   FAST_OOF_EN            0                  0x0              
 * 0x0040[2:0]   OOF_REF_SEL            4                  0x4              
 * 0x0041[4:0]   OOF0_DIV_SEL           2                  0x02             
 * 0x0042[4:0]   OOF1_DIV_SEL           0                  0x00             
 * 0x0043[4:0]   OOF2_DIV_SEL           0                  0x00             
 * 0x0044[4:0]   OOF3_DIV_SEL           0                  0x00             
 * 0x0045[4:0]   OOFXO_DIV_SEL          12                 0x0C             
 * 0x0046[7:0]   OOF0_SET_THR           150                0x96             
 * 0x0047[7:0]   OOF1_SET_THR           0                  0x00             
 * 0x0048[7:0]   OOF2_SET_THR           0                  0x00             
 * 0x0049[7:0]   OOF3_SET_THR           0                  0x00             
 * 0x004A[7:0]   OOF0_CLR_THR           75                 0x4B             
 * 0x004B[7:0]   OOF1_CLR_THR           0                  0x00             
 * 0x004C[7:0]   OOF2_CLR_THR           0                  0x00             
 * 0x004D[7:0]   OOF3_CLR_THR           0                  0x00             
 * 0x004E[2:0]   OOF0_DETWIN_SEL        5                  0x5              
 * 0x004E[6:4]   OOF1_DETWIN_SEL        0                  0x0              
 * 0x004F[2:0]   OOF2_DETWIN_SEL        0                  0x0              
 * 0x004F[6:4]   OOF3_DETWIN_SEL        0                  0x0              
 * 0x0050[3:0]   OOF_ON_LOS             15                 0xF              
 * 0x0051[3:0]   FAST_OOF0_SET_THR      0                  0x0              
 * 0x0052[3:0]   FAST_OOF1_SET_THR      0                  0x0              
 * 0x0053[3:0]   FAST_OOF2_SET_THR      0                  0x0              
 * 0x0054[3:0]   FAST_OOF3_SET_THR      0                  0x0              
 * 0x0055[3:0]   FAST_OOF0_CLR_THR      0                  0x0              
 * 0x0056[3:0]   FAST_OOF1_CLR_THR      0                  0x0              
 * 0x0057[3:0]   FAST_OOF2_CLR_THR      0                  0x0              
 * 0x0058[3:0]   FAST_OOF3_CLR_THR      0                  0x0              
 * 0x0059[1:0]   FAST_OOF0_DETWIN_SEL   1                  0x1              
 * 0x0059[3:2]   FAST_OOF1_DETWIN_SEL   0                  0x0              
 * 0x0059[5:4]   FAST_OOF2_DETWIN_SEL   0                  0x0              
 * 0x0059[7:6]   FAST_OOF3_DETWIN_SEL   0                  0x0              
 * 0x005A[25:0]  OOF0_RATIO_REF         18583993           0x11B91B9        
 * 0x005E[25:0]  OOF1_RATIO_REF         0                  0x0000000        
 * 0x0062[25:0]  OOF2_RATIO_REF         0                  0x0000000        
 * 0x0066[25:0]  OOF3_RATIO_REF         0                  0x0000000        
 * 0x0092[1]     LOL_FST_EN             1                  0x1              
 * 0x0093[7:4]   LOL_FST_DETWIN_SEL     10                 0xA              
 * 0x0095[3:2]   LOL_FST_VALWIN_SEL     0                  0x0              
 * 0x0096[7:4]   LOL_FST_SET_THR_SEL    9                  0x9              
 * 0x0098[7:4]   LOL_FST_CLR_THR_SEL    7                  0x7              
 * 0x009A[1]     LOL_SLOW_EN_PLL        1                  0x1              
 * 0x009B[7:4]   LOL_SLW_DETWIN_SEL     5                  0x5              
 * 0x009D[3:2]   LOL_SLW_VALWIN_SEL     1                  0x1              
 * 0x009E[7:4]   LOL_SLW_SET_THR        6                  0x6              
 * 0x00A0[7:4]   LOL_SLW_CLR_THR        3                  0x3              
 * 0x00A2[1]     LOL_TIMER_EN           0                  0x0              
 * 0x00A9[28:0]  LOL_CLR_DELAY_DIV256   304910             0x0004A70E       
 * 0x00E5[5]     FASTLOCK_EXTEND_EN     1                  0x1              
 * 0x00EA[28:0]  FASTLOCK_EXTEND        242129             0x0003B1D1       
 * 0x0102[0]     OUTALL_DISABLE_LOW     1                  0x1              
 * 0x0108[0]     OUT0_PDN               0                  0x0              
 * 0x0108[1]     OUT0_OE                1                  0x1              
 * 0x0108[2]     OUT0_RDIV_FORCE2       0                  0x0              
 * 0x0109[2:0]   OUT0_FORMAT            1                  0x1              
 * 0x0109[3]     OUT0_SYNC_EN           1                  0x1              
 * 0x0109[5:4]   OUT0_DIS_STATE         0                  0x0              
 * 0x0109[7:6]   OUT0_CMOS_DRV          0                  0x0              
 * 0x010A[3:0]   OUT0_CM                11                 0xB              
 * 0x010A[6:4]   OUT0_AMPL              3                  0x3              
 * 0x010B[2:0]   OUT0_MUX_SEL           0                  0x0              
 * 0x010B[5:4]   OUT0_VDD_SEL           2                  0x2              
 * 0x010B[3]     OUT0_VDD_SEL_EN        1                  0x1              
 * 0x010B[7:6]   OUT0_INV               0                  0x0              
 * 0x010D[0]     OUT1_PDN               1                  0x1              
 * 0x010D[1]     OUT1_OE                0                  0x0              
 * 0x010D[2]     OUT1_RDIV_FORCE2       0                  0x0              
 * 0x010E[2:0]   OUT1_FORMAT            1                  0x1              
 * 0x010E[3]     OUT1_SYNC_EN           1                  0x1              
 * 0x010E[5:4]   OUT1_DIS_STATE         0                  0x0              
 * 0x010E[7:6]   OUT1_CMOS_DRV          0                  0x0              
 * 0x010F[3:0]   OUT1_CM                11                 0xB              
 * 0x010F[6:4]   OUT1_AMPL              3                  0x3              
 * 0x0110[2:0]   OUT1_MUX_SEL           0                  0x0              
 * 0x0110[5:4]   OUT1_VDD_SEL           2                  0x2              
 * 0x0110[3]     OUT1_VDD_SEL_EN        1                  0x1              
 * 0x0110[7:6]   OUT1_INV               0                  0x0              
 * 0x0112[0]     OUT2_PDN               0                  0x0              
 * 0x0112[1]     OUT2_OE                1                  0x1              
 * 0x0112[2]     OUT2_RDIV_FORCE2       0                  0x0              
 * 0x0113[2:0]   OUT2_FORMAT            1                  0x1              
 * 0x0113[3]     OUT2_SYNC_EN           1                  0x1              
 * 0x0113[5:4]   OUT2_DIS_STATE         0                  0x0              
 * 0x0113[7:6]   OUT2_CMOS_DRV          0                  0x0              
 * 0x0114[3:0]   OUT2_CM                11                 0xB              
 * 0x0114[6:4]   OUT2_AMPL              3                  0x3              
 * 0x0115[2:0]   OUT2_MUX_SEL           0                  0x0              
 * 0x0115[5:4]   OUT2_VDD_SEL           2                  0x2              
 * 0x0115[3]     OUT2_VDD_SEL_EN        1                  0x1              
 * 0x0115[7:6]   OUT2_INV               0                  0x0              
 * 0x0117[0]     OUT3_PDN               1                  0x1              
 * 0x0117[1]     OUT3_OE                0                  0x0              
 * 0x0117[2]     OUT3_RDIV_FORCE2       0                  0x0              
 * 0x0118[2:0]   OUT3_FORMAT            1                  0x1              
 * 0x0118[3]     OUT3_SYNC_EN           1                  0x1              
 * 0x0118[5:4]   OUT3_DIS_STATE         0                  0x0              
 * 0x0118[7:6]   OUT3_CMOS_DRV          0                  0x0              
 * 0x0119[3:0]   OUT3_CM                11                 0xB              
 * 0x0119[6:4]   OUT3_AMPL              3                  0x3              
 * 0x011A[2:0]   OUT3_MUX_SEL           0                  0x0              
 * 0x011A[5:4]   OUT3_VDD_SEL           2                  0x2              
 * 0x011A[3]     OUT3_VDD_SEL_EN        1                  0x1              
 * 0x011A[7:6]   OUT3_INV               0                  0x0              
 * 0x011C[0]     OUT4_PDN               1                  0x1              
 * 0x011C[1]     OUT4_OE                0                  0x0              
 * 0x011C[2]     OUT4_RDIV_FORCE2       0                  0x0              
 * 0x011D[2:0]   OUT4_FORMAT            1                  0x1              
 * 0x011D[3]     OUT4_SYNC_EN           1                  0x1              
 * 0x011D[5:4]   OUT4_DIS_STATE         0                  0x0              
 * 0x011D[7:6]   OUT4_CMOS_DRV          0                  0x0              
 * 0x011E[3:0]   OUT4_CM                11                 0xB              
 * 0x011E[6:4]   OUT4_AMPL              3                  0x3              
 * 0x011F[2:0]   OUT4_MUX_SEL           0                  0x0              
 * 0x011F[5:4]   OUT4_VDD_SEL           2                  0x2              
 * 0x011F[3]     OUT4_VDD_SEL_EN        1                  0x1              
 * 0x011F[7:6]   OUT4_INV               0                  0x0              
 * 0x0121[0]     OUT5_PDN               0                  0x0              
 * 0x0121[1]     OUT5_OE                1                  0x1              
 * 0x0121[2]     OUT5_RDIV_FORCE2       0                  0x0              
 * 0x0122[2:0]   OUT5_FORMAT            1                  0x1              
 * 0x0122[3]     OUT5_SYNC_EN           1                  0x1              
 * 0x0122[5:4]   OUT5_DIS_STATE         0                  0x0              
 * 0x0122[7:6]   OUT5_CMOS_DRV          0                  0x0              
 * 0x0123[3:0]   OUT5_CM                11                 0xB              
 * 0x0123[6:4]   OUT5_AMPL              3                  0x3              
 * 0x0124[2:0]   OUT5_MUX_SEL           1                  0x1              
 * 0x0124[5:4]   OUT5_VDD_SEL           2                  0x2              
 * 0x0124[3]     OUT5_VDD_SEL_EN        1                  0x1              
 * 0x0124[7:6]   OUT5_INV               0                  0x0              
 * 0x0126[0]     OUT6_PDN               1                  0x1              
 * 0x0126[1]     OUT6_OE                0                  0x0              
 * 0x0126[2]     OUT6_RDIV_FORCE2       0                  0x0              
 * 0x0127[2:0]   OUT6_FORMAT            1                  0x1              
 * 0x0127[3]     OUT6_SYNC_EN           1                  0x1              
 * 0x0127[5:4]   OUT6_DIS_STATE         0                  0x0              
 * 0x0127[7:6]   OUT6_CMOS_DRV          0                  0x0              
 * 0x0128[3:0]   OUT6_CM                11                 0xB              
 * 0x0128[6:4]   OUT6_AMPL              3                  0x3              
 * 0x0129[2:0]   OUT6_MUX_SEL           0                  0x0              
 * 0x0129[5:4]   OUT6_VDD_SEL           2                  0x2              
 * 0x0129[3]     OUT6_VDD_SEL_EN        1                  0x1              
 * 0x0129[7:6]   OUT6_INV               0                  0x0              
 * 0x012B[0]     OUT7_PDN               1                  0x1              
 * 0x012B[1]     OUT7_OE                0                  0x0              
 * 0x012B[2]     OUT7_RDIV_FORCE2       0                  0x0              
 * 0x012C[2:0]   OUT7_FORMAT            1                  0x1              
 * 0x012C[3]     OUT7_SYNC_EN           1                  0x1              
 * 0x012C[5:4]   OUT7_DIS_STATE         0                  0x0              
 * 0x012C[7:6]   OUT7_CMOS_DRV          0                  0x0              
 * 0x012D[3:0]   OUT7_CM                11                 0xB              
 * 0x012D[6:4]   OUT7_AMPL              3                  0x3              
 * 0x012E[2:0]   OUT7_MUX_SEL           0                  0x0              
 * 0x012E[5:4]   OUT7_VDD_SEL           2                  0x2              
 * 0x012E[3]     OUT7_VDD_SEL_EN        1                  0x1              
 * 0x012E[7:6]   OUT7_INV               0                  0x0              
 * 0x0130[0]     OUT8_PDN               0                  0x0              
 * 0x0130[1]     OUT8_OE                1                  0x1              
 * 0x0130[2]     OUT8_RDIV_FORCE2       0                  0x0              
 * 0x0131[2:0]   OUT8_FORMAT            1                  0x1              
 * 0x0131[3]     OUT8_SYNC_EN           1                  0x1              
 * 0x0131[5:4]   OUT8_DIS_STATE         0                  0x0              
 * 0x0131[7:6]   OUT8_CMOS_DRV          0                  0x0              
 * 0x0132[3:0]   OUT8_CM                11                 0xB              
 * 0x0132[6:4]   OUT8_AMPL              3                  0x3              
 * 0x0133[2:0]   OUT8_MUX_SEL           2                  0x2              
 * 0x0133[5:4]   OUT8_VDD_SEL           2                  0x2              
 * 0x0133[3]     OUT8_VDD_SEL_EN        1                  0x1              
 * 0x0133[7:6]   OUT8_INV               0                  0x0              
 * 0x013A[0]     OUT9_PDN               1                  0x1              
 * 0x013A[1]     OUT9_OE                0                  0x0              
 * 0x013A[2]     OUT9_RDIV_FORCE2       0                  0x0              
 * 0x013B[2:0]   OUT9_FORMAT            1                  0x1              
 * 0x013B[3]     OUT9_SYNC_EN           1                  0x1              
 * 0x013B[5:4]   OUT9_DIS_STATE         0                  0x0              
 * 0x013B[7:6]   OUT9_CMOS_DRV          0                  0x0              
 * 0x013C[3:0]   OUT9_CM                11                 0xB              
 * 0x013C[6:4]   OUT9_AMPL              3                  0x3              
 * 0x013D[2:0]   OUT9_MUX_SEL           0                  0x0              
 * 0x013D[5:4]   OUT9_VDD_SEL           2                  0x2              
 * 0x013D[3]     OUT9_VDD_SEL_EN        1                  0x1              
 * 0x013D[7:6]   OUT9_INV               0                  0x0              
 * 0x013F[11:0]  OUTX_ALWAYS_ON         0                  0x000            
 * 0x0141[1]     OUT_DIS_MSK            0                  0x0              
 * 0x0141[5]     OUT_DIS_LOL_MSK        0                  0x0              
 * 0x0141[6]     OUT_DIS_LOSXAXB_MSK    1                  0x1              
 * 0x0141[7]     OUT_DIS_MSK_LOS_PFD    0                  0x0              
 * 0x0142[1]     OUT_DIS_MSK_LOL        1                  0x1              
 * 0x0142[5]     OUT_DIS_MSK_HOLD       1                  0x1              
 * 0x0206[1:0]   PXAXB                  0                  0x0              
 * 0x0208[47:0]  P0_NUM                 1                  0x000000000001   
 * 0x020E[31:0]  P0_DEN                 1                  0x00000001       
 * 0x0212[47:0]  P1_NUM                 0                  0x000000000000   
 * 0x0218[31:0]  P1_DEN                 0                  0x00000000       
 * 0x021C[47:0]  P2_NUM                 0                  0x000000000000   
 * 0x0222[31:0]  P2_DEN                 0                  0x00000000       
 * 0x0226[47:0]  P3_NUM                 0                  0x000000000000   
 * 0x022C[31:0]  P3_DEN                 0                  0x00000000       
 * 0x0231[3:0]   P0_FRACN_MODE          11                 0xB              
 * 0x0231[4]     P0_FRACN_EN            0                  0x0              
 * 0x0232[3:0]   P1_FRACN_MODE          11                 0xB              
 * 0x0232[4]     P1_FRACN_EN            0                  0x0              
 * 0x0233[3:0]   P2_FRACN_MODE          11                 0xB              
 * 0x0233[4]     P2_FRACN_EN            0                  0x0              
 * 0x0234[3:0]   P3_FRACN_MODE          11                 0xB              
 * 0x0234[4]     P3_FRACN_EN            0                  0x0              
 * 0x0235[43:0]  MXAXB_NUM              916841299968       0x0D578000000    
 * 0x023B[31:0]  MXAXB_DEN              3489660928         0xD0000000       
 * 0x024A[23:0]  R0_REG                 10                 0x00000A         
 * 0x024D[23:0]  R1_REG                 0                  0x000000         
 * 0x0250[23:0]  R2_REG                 1                  0x000001         
 * 0x0253[23:0]  R3_REG                 0                  0x000000         
 * 0x0256[23:0]  R4_REG                 0                  0x000000         
 * 0x0259[23:0]  R5_REG                 2                  0x000002         
 * 0x025C[23:0]  R6_REG                 0                  0x000000         
 * 0x025F[23:0]  R7_REG                 0                  0x000000         
 * 0x0262[23:0]  R8_REG                 2                  0x000002         
 * 0x0268[23:0]  R9_REG                 0                  0x000000         
 * 0x026B[7:0]   DESIGN_ID0             73                 0x49             
 * 0x026C[7:0]   DESIGN_ID1             79                 0x4F             
 * 0x026D[7:0]   DESIGN_ID2             52                 0x34             
 * 0x026E[7:0]   DESIGN_ID3             75                 0x4B             
 * 0x026F[7:0]   DESIGN_ID4             43                 0x2B             
 * 0x0270[7:0]   DESIGN_ID5             0                  0x00             
 * 0x0271[7:0]   DESIGN_ID6             0                  0x00             
 * 0x0272[7:0]   DESIGN_ID7             0                  0x00             
 * 0x0294[7:4]   FASTLOCK_EXTEND_SCL    8                  0x8              
 * 0x0296[1]     LOL_SLW_VALWIN_SELX    0                  0x0              
 * 0x0297[1]     FASTLOCK_DLY_ONSW_EN   1                  0x1              
 * 0x0299[1]     FASTLOCK_DLY_ONLOL_EN  1                  0x1              
 * 0x029D[19:0]  FASTLOCK_DLY_ONLOL     3829               0x00EF5          
 * 0x02A9[19:0]  FASTLOCK_DLY_ONSW      9830               0x02666          
 * 0x02B7[3:2]   LOL_NOSIG_TIME         3                  0x3              
 * 0x0302[43:0]  N0_NUM                 49392123904        0x00B80000000    
 * 0x0308[31:0]  N0_DEN                 2147483648         0x80000000       
 * 0x030C[0]     N0_UPDATE              0                  0x0              
 * 0x030D[43:0]  N1_NUM                 198967296000       0x02E53600000    
 * 0x0313[31:0]  N1_DEN                 2147483648         0x80000000       
 * 0x0317[0]     N1_UPDATE              0                  0x0              
 * 0x0318[43:0]  N2_NUM                 48282730496        0x00B3DE00000    
 * 0x031E[31:0]  N2_DEN                 3145728000         0xBB800000       
 * 0x0322[0]     N2_UPDATE              0                  0x0              
 * 0x0323[43:0]  N3_NUM                 0                  0x00000000000    
 * 0x0329[31:0]  N3_DEN                 0                  0x00000000       
 * 0x032D[0]     N3_UPDATE              0                  0x0              
 * 0x032E[43:0]  N4_NUM                 0                  0x00000000000    
 * 0x0334[31:0]  N4_DEN                 0                  0x00000000       
 * 0x0338[0]     N4_UPDATE              0                  0x0              
 * 0x0338[1]     N_UPDATE               0                  0x0              
 * 0x0339[4:0]   N_FSTEP_MSK            31                 0x1F             
 * 0x033B[43:0]  N0_FSTEPW              0                  0x00000000000    
 * 0x0341[43:0]  N1_FSTEPW              0                  0x00000000000    
 * 0x0347[43:0]  N2_FSTEPW              0                  0x00000000000    
 * 0x034D[43:0]  N3_FSTEPW              0                  0x00000000000    
 * 0x0353[43:0]  N4_FSTEPW              0                  0x00000000000    
 * 0x0359[15:0]  N0_DELAY               0                  0x0000           
 * 0x035B[15:0]  N1_DELAY               0                  0x0000           
 * 0x035D[15:0]  N2_DELAY               0                  0x0000           
 * 0x035F[15:0]  N3_DELAY               0                  0x0000           
 * 0x0361[15:0]  N4_DELAY               0                  0x0000           
 * 0x0487[0]     ZDM_EN                 0                  0x0              
 * 0x0487[2:1]   ZDM_IN_SEL             0                  0x0              
 * 0x0487[4]     ZDM_AUTOSW_EN          0                  0x0              
 * 0x0502[4]     ADD_DIV256             0                  0x0              
 * 0x0508[5:0]   BW0_PLL                16                 0x10             
 * 0x0509[5:0]   BW1_PLL                24                 0x18             
 * 0x050A[5:0]   BW2_PLL                15                 0x0F             
 * 0x050B[5:0]   BW3_PLL                15                 0x0F             
 * 0x050C[5:0]   BW4_PLL                1                  0x01             
 * 0x050D[5:0]   BW5_PLL                7                  0x07             
 * 0x050E[5:0]   FASTLOCK_BW0_PLL       23                 0x17             
 * 0x050F[5:0]   FASTLOCK_BW1_PLL       40                 0x28             
 * 0x0510[5:0]   FASTLOCK_BW2_PLL       12                 0x0C             
 * 0x0511[5:0]   FASTLOCK_BW3_PLL       11                 0x0B             
 * 0x0512[5:0]   FASTLOCK_BW4_PLL       1                  0x01             
 * 0x0513[5:0]   FASTLOCK_BW5_PLL       7                  0x07             
 * 0x0515[55:0]  M_NUM                  104316165685248    0x005EE000000000 
 * 0x051C[31:0]  M_DEN                  2147483648         0x80000000       
 * 0x0521[3:0]   M_FRAC_MODE            11                 0xB              
 * 0x0521[4]     M_FRAC_EN              0                  0x0              
 * 0x0521[5]     PLL_OUT_RATE_SEL       1                  0x1              
 * 0x052A[0]     IN_SEL_REGCTRL         1                  0x1              
 * 0x052A[3:1]   IN_SEL                 0                  0x0              
 * 0x052B[0]     FASTLOCK_AUTO_EN       1                  0x1              
 * 0x052B[1]     FASTLOCK_MAN           0                  0x0              
 * 0x052C[0]     HOLD_EN                1                  0x1              
 * 0x052C[3]     HOLD_RAMP_BYP          1                  0x1              
 * 0x052C[4]     HOLDEXIT_BW_SEL1       0                  0x0              
 * 0x052C[7:5]   RAMP_STEP_INTERVAL     0                  0x0              
 * 0x052D[1]     HOLD_RAMPBYP_NOHIST    1                  0x1              
 * 0x052E[4:0]   HOLD_HIST_LEN          21                 0x15             
 * 0x052F[4:0]   HOLD_HIST_DELAY        20                 0x14             
 * 0x0531[4:0]   HOLD_REF_COUNT_FRC     0                  0x00             
 * 0x0532[23:0]  HOLD_15M_CYC_COUNT     29630              0x0073BE         
 * 0x0535[0]     FORCE_HOLD             0                  0x0              
 * 0x0536[1:0]   CLK_SWITCH_MODE        0                  0x0              
 * 0x0536[2]     HSW_EN                 0                  0x0              
 * 0x0537[3:0]   IN_LOS_MSK             0                  0x0              
 * 0x0537[7:4]   IN_OOF_MSK             0                  0x0              
 * 0x0538[2:0]   IN0_PRIORITY           0                  0x0              
 * 0x0538[6:4]   IN1_PRIORITY           0                  0x0              
 * 0x0539[2:0]   IN2_PRIORITY           0                  0x0              
 * 0x0539[6:4]   IN3_PRIORITY           0                  0x0              
 * 0x053A[1:0]   HSW_MODE               2                  0x2              
 * 0x053A[3:2]   HSW_PHMEAS_CTRL        0                  0x0              
 * 0x053B[9:0]   HSW_PHMEAS_THR         3                  0x003            
 * 0x053D[4:0]   HSW_COARSE_PM_LEN      19                 0x13             
 * 0x053E[4:0]   HSW_COARSE_PM_DLY      6                  0x06             
 * 0x0589[12:0]  CAP_SHORT_DELAY        483                0x01E3           
 * 0x059B[4]     HOLD_PRESERVE_HIST     1                  0x1              
 * 0x059B[5]     HOLD_FRZ_WITH_INTONLY  1                  0x1              
 * 0x059B[6]     HOLDEXIT_BW_SEL0       1                  0x1              
 * 0x059B[7]     HOLDEXIT_STD_BO        1                  0x1              
 * 0x059D[5:0]   HOLDEXIT_BW0           23                 0x17             
 * 0x059E[5:0]   HOLDEXIT_BW1           40                 0x28             
 * 0x059F[5:0]   HOLDEXIT_BW2           12                 0x0C             
 * 0x05A0[5:0]   HOLDEXIT_BW3           11                 0x0B             
 * 0x05A1[5:0]   HOLDEXIT_BW4           1                  0x01             
 * 0x05A2[5:0]   HOLDEXIT_BW5           7                  0x07             
 * 0x05A6[2:0]   RAMP_STEP_SIZE         0                  0x0              
 * 0x05A6[3]     RAMP_SWITCH_EN         0                  0x0              
 * 0x0802[15:0]  FIXREGSA0              1333               0x0535           
 * 0x0804[7:0]   FIXREGSD0              0                  0x00             
 * 0x0805[15:0]  FIXREGSA1              0                  0x0000           
 * 0x0807[7:0]   FIXREGSD1              0                  0x00             
 * 0x0808[15:0]  FIXREGSA2              0                  0x0000           
 * 0x080A[7:0]   FIXREGSD2              0                  0x00             
 * 0x080B[15:0]  FIXREGSA3              0                  0x0000           
 * 0x080D[7:0]   FIXREGSD3              0                  0x00             
 * 0x080E[15:0]  FIXREGSA4              0                  0x0000           
 * 0x0810[7:0]   FIXREGSD4              0                  0x00             
 * 0x0811[15:0]  FIXREGSA5              0                  0x0000           
 * 0x0813[7:0]   FIXREGSD5              0                  0x00             
 * 0x0814[15:0]  FIXREGSA6              0                  0x0000           
 * 0x0816[7:0]   FIXREGSD6              0                  0x00             
 * 0x0817[15:0]  FIXREGSA7              0                  0x0000           
 * 0x0819[7:0]   FIXREGSD7              0                  0x00             
 * 0x081A[15:0]  FIXREGSA8              0                  0x0000           
 * 0x081C[7:0]   FIXREGSD8              0                  0x00             
 * 0x081D[15:0]  FIXREGSA9              0                  0x0000           
 * 0x081F[7:0]   FIXREGSD9              0                  0x00             
 * 0x0820[15:0]  FIXREGSA10             0                  0x0000           
 * 0x0822[7:0]   FIXREGSD10             0                  0x00             
 * 0x0823[15:0]  FIXREGSA11             0                  0x0000           
 * 0x0825[7:0]   FIXREGSD11             0                  0x00             
 * 0x0826[15:0]  FIXREGSA12             0                  0x0000           
 * 0x0828[7:0]   FIXREGSD12             0                  0x00             
 * 0x0829[15:0]  FIXREGSA13             0                  0x0000           
 * 0x082B[7:0]   FIXREGSD13             0                  0x00             
 * 0x082C[15:0]  FIXREGSA14             0                  0x0000           
 * 0x082E[7:0]   FIXREGSD14             0                  0x00             
 * 0x082F[15:0]  FIXREGSA15             0                  0x0000           
 * 0x0831[7:0]   FIXREGSD15             0                  0x00             
 * 0x0832[15:0]  FIXREGSA16             0                  0x0000           
 * 0x0834[7:0]   FIXREGSD16             0                  0x00             
 * 0x0835[15:0]  FIXREGSA17             0                  0x0000           
 * 0x0837[7:0]   FIXREGSD17             0                  0x00             
 * 0x0838[15:0]  FIXREGSA18             0                  0x0000           
 * 0x083A[7:0]   FIXREGSD18             0                  0x00             
 * 0x083B[15:0]  FIXREGSA19             0                  0x0000           
 * 0x083D[7:0]   FIXREGSD19             0                  0x00             
 * 0x083E[15:0]  FIXREGSA20             0                  0x0000           
 * 0x0840[7:0]   FIXREGSD20             0                  0x00             
 * 0x0841[15:0]  FIXREGSA21             0                  0x0000           
 * 0x0843[7:0]   FIXREGSD21             0                  0x00             
 * 0x0844[15:0]  FIXREGSA22             0                  0x0000           
 * 0x0846[7:0]   FIXREGSD22             0                  0x00             
 * 0x0847[15:0]  FIXREGSA23             0                  0x0000           
 * 0x0849[7:0]   FIXREGSD23             0                  0x00             
 * 0x084A[15:0]  FIXREGSA24             0                  0x0000           
 * 0x084C[7:0]   FIXREGSD24             0                  0x00             
 * 0x084D[15:0]  FIXREGSA25             0                  0x0000           
 * 0x084F[7:0]   FIXREGSD25             0                  0x00             
 * 0x0850[15:0]  FIXREGSA26             0                  0x0000           
 * 0x0852[7:0]   FIXREGSD26             0                  0x00             
 * 0x0853[15:0]  FIXREGSA27             0                  0x0000           
 * 0x0855[7:0]   FIXREGSD27             0                  0x00             
 * 0x0856[15:0]  FIXREGSA28             0                  0x0000           
 * 0x0858[7:0]   FIXREGSD28             0                  0x00             
 * 0x0859[15:0]  FIXREGSA29             0                  0x0000           
 * 0x085B[7:0]   FIXREGSD29             0                  0x00             
 * 0x085C[15:0]  FIXREGSA30             0                  0x0000           
 * 0x085E[7:0]   FIXREGSD30             0                  0x00             
 * 0x085F[15:0]  FIXREGSA31             0                  0x0000           
 * 0x0861[7:0]   FIXREGSD31             0                  0x00             
 * 0x090E[0]     XAXB_EXTCLK_EN         1                  0x1              
 * 0x0943[0]     IO_VDD_SEL             0                  0x0              
 * 0x0949[3:0]   IN_EN                  1                  0x1              
 * 0x0949[7:4]   IN_PULSED_CMOS_EN      3                  0x3              
 * 0x094A[3:0]   INX_TO_PFD_EN          1                  0x1              
 * 0x094E[11:0]  REFCLK_HYS_SEL         585                0x249            
 * 0x095E[0]     MXAXB_INTEGER          0                  0x0              
 * 0x0A02[4:0]   N_ADD_0P5              0                  0x00             
 * 0x0A03[4:0]   N_CLK_TO_OUTX_EN       7                  0x07             
 * 0x0A04[4:0]   N_PIBYP                1                  0x01             
 * 0x0A05[4:0]   N_PDNB                 7                  0x07             
 * 0x0A14[3]     N0_HIGH_FREQ           0                  0x0              
 * 0x0A1A[3]     N1_HIGH_FREQ           0                  0x0              
 * 0x0A20[3]     N2_HIGH_FREQ           0                  0x0              
 * 0x0A26[3]     N3_HIGH_FREQ           0                  0x0              
 * 0x0A2C[3]     N4_HIGH_FREQ           0                  0x0              
 * 0x0B44[3:0]   PDIV_FRACN_CLK_DIS     15                 0xF              
 * 0x0B44[5]     FRACN_CLK_DIS_PLL      1                  0x1              
 * 0x0B46[3:0]   LOS_CLK_DIS            0                  0x0              
 * 0x0B47[4:0]   OOF_CLK_DIS            14                 0x0E             
 * 0x0B48[4:0]   OOF_DIV_CLK_DIS        14                 0x0E             
 * 0x0B4A[4:0]   N_CLK_DIS              24                 0x18             
 * 0x0B57[11:0]  VCO_RESET_CALCODE      249                0x0F9
 * 
 *
 */


static struct ntv2_genlock_data s_genlock_2250_2997[] =
{
	/* Start configuration preamble */
	{ 0x0B24, 0xC0 },
	{ 0x0B25, 0x00 },
	{ 0x0540, 0x01 },
	/* End configuration preamble */

	/* Delay 300 msec */
	/*    Delay is worst case time for device to complete any calibration */
	/*    that is running due to device state change previous to this script */
	/*    being processed. */
	{ 0x0000, 0x01 },

	/* Start configuration registers */
	{ 0x000B, 0x64 },
	{ 0x0016, 0x02 },
	{ 0x0017, 0xFC },
	{ 0x0018, 0xFF },
	{ 0x0019, 0xDF },
	{ 0x001A, 0xDF },
	{ 0x002B, 0x02 },
	{ 0x002C, 0x01 },
	{ 0x002D, 0x02 },
	{ 0x002E, 0xCD },
	{ 0x002F, 0x03 },
	{ 0x0030, 0x00 },
	{ 0x0031, 0x00 },
	{ 0x0032, 0x00 },
	{ 0x0033, 0x00 },
	{ 0x0034, 0x00 },
	{ 0x0035, 0x00 },
	{ 0x0036, 0x7C },
	{ 0x0037, 0x03 },
	{ 0x0038, 0x00 },
	{ 0x0039, 0x00 },
	{ 0x003A, 0x00 },
	{ 0x003B, 0x00 },
	{ 0x003C, 0x00 },
	{ 0x003D, 0x00 },
	{ 0x003F, 0x01 },
	{ 0x0040, 0x04 },
	{ 0x0041, 0x03 },
	{ 0x0042, 0x00 },
	{ 0x0043, 0x00 },
	{ 0x0044, 0x00 },
	{ 0x0045, 0x0C },
	{ 0x0046, 0x96 },
	{ 0x0047, 0x00 },
	{ 0x0048, 0x00 },
	{ 0x0049, 0x00 },
	{ 0x004A, 0x4B },
	{ 0x004B, 0x00 },
	{ 0x004C, 0x00 },
	{ 0x004D, 0x00 },
	{ 0x004E, 0x05 },
	{ 0x004F, 0x00 },
	{ 0x0050, 0x0F },
	{ 0x0051, 0x00 },
	{ 0x0052, 0x00 },
	{ 0x0053, 0x00 },
	{ 0x0054, 0x00 },
	{ 0x0055, 0x00 },
	{ 0x0056, 0x00 },
	{ 0x0057, 0x00 },
	{ 0x0058, 0x00 },
	{ 0x0059, 0x01 },
	{ 0x005A, 0xB8 },
	{ 0x005B, 0xF8 },
	{ 0x005C, 0xA9 },
	{ 0x005D, 0x00 },
	{ 0x005E, 0x00 },
	{ 0x005F, 0x00 },
	{ 0x0060, 0x00 },
	{ 0x0061, 0x00 },
	{ 0x0062, 0x00 },
	{ 0x0063, 0x00 },
	{ 0x0064, 0x00 },
	{ 0x0065, 0x00 },
	{ 0x0066, 0x00 },
	{ 0x0067, 0x00 },
	{ 0x0068, 0x00 },
	{ 0x0069, 0x00 },
	{ 0x0092, 0x02 },
	{ 0x0093, 0xA0 },
	{ 0x0095, 0x00 },
	{ 0x0096, 0x90 },
	{ 0x0098, 0x70 },
	{ 0x009A, 0x02 },
	{ 0x009B, 0x50 },
	{ 0x009D, 0x04 },
	{ 0x009E, 0x60 },
	{ 0x00A0, 0x30 },
	{ 0x00A2, 0x00 },
	{ 0x00A9, 0xB9 },
	{ 0x00AA, 0x7D },
	{ 0x00AB, 0x04 },
	{ 0x00AC, 0x00 },
	{ 0x00E5, 0x21 },
	{ 0x00EA, 0xD1 },
	{ 0x00EB, 0xB1 },
	{ 0x00EC, 0x03 },
	{ 0x00ED, 0x00 },
	{ 0x0102, 0x01 },
	{ 0x0108, 0x02 },
	{ 0x0109, 0x09 },
	{ 0x010A, 0x3B },
	{ 0x010B, 0x28 },
	{ 0x010D, 0x01 },
	{ 0x010E, 0x09 },
	{ 0x010F, 0x3B },
	{ 0x0110, 0x28 },
	{ 0x0112, 0x02 },
	{ 0x0113, 0x09 },
	{ 0x0114, 0x3B },
	{ 0x0115, 0x28 },
	{ 0x0117, 0x01 },
	{ 0x0118, 0x09 },
	{ 0x0119, 0x3B },
	{ 0x011A, 0x28 },
	{ 0x011C, 0x01 },
	{ 0x011D, 0x09 },
	{ 0x011E, 0x3B },
	{ 0x011F, 0x28 },
	{ 0x0121, 0x02 },
	{ 0x0122, 0x09 },
	{ 0x0123, 0x3B },
	{ 0x0124, 0x29 },
	{ 0x0126, 0x01 },
	{ 0x0127, 0x09 },
	{ 0x0128, 0x3B },
	{ 0x0129, 0x28 },
	{ 0x012B, 0x01 },
	{ 0x012C, 0x09 },
	{ 0x012D, 0x3B },
	{ 0x012E, 0x28 },
	{ 0x0130, 0x02 },
	{ 0x0131, 0x09 },
	{ 0x0132, 0x3B },
	{ 0x0133, 0x2A },
	{ 0x013A, 0x01 },
	{ 0x013B, 0x09 },
	{ 0x013C, 0x3B },
	{ 0x013D, 0x28 },
	{ 0x013F, 0x00 },
	{ 0x0140, 0x00 },
	{ 0x0141, 0x40 },
	{ 0x0142, 0xFF },
	{ 0x0206, 0x00 },
	{ 0x0208, 0x01 },
	{ 0x0209, 0x00 },
	{ 0x020A, 0x00 },
	{ 0x020B, 0x00 },
	{ 0x020C, 0x00 },
	{ 0x020D, 0x00 },
	{ 0x020E, 0x01 },
	{ 0x020F, 0x00 },
	{ 0x0210, 0x00 },
	{ 0x0211, 0x00 },
	{ 0x0212, 0x00 },
	{ 0x0213, 0x00 },
	{ 0x0214, 0x00 },
	{ 0x0215, 0x00 },
	{ 0x0216, 0x00 },
	{ 0x0217, 0x00 },
	{ 0x0218, 0x00 },
	{ 0x0219, 0x00 },
	{ 0x021A, 0x00 },
	{ 0x021B, 0x00 },
	{ 0x021C, 0x00 },
	{ 0x021D, 0x00 },
	{ 0x021E, 0x00 },
	{ 0x021F, 0x00 },
	{ 0x0220, 0x00 },
	{ 0x0221, 0x00 },
	{ 0x0222, 0x00 },
	{ 0x0223, 0x00 },
	{ 0x0224, 0x00 },
	{ 0x0225, 0x00 },
	{ 0x0226, 0x00 },
	{ 0x0227, 0x00 },
	{ 0x0228, 0x00 },
	{ 0x0229, 0x00 },
	{ 0x022A, 0x00 },
	{ 0x022B, 0x00 },
	{ 0x022C, 0x00 },
	{ 0x022D, 0x00 },
	{ 0x022E, 0x00 },
	{ 0x022F, 0x00 },
	{ 0x0231, 0x0B },
	{ 0x0232, 0x0B },
	{ 0x0233, 0x0B },
	{ 0x0234, 0x0B },
	{ 0x0235, 0x00 },
	{ 0x0236, 0x00 },
	{ 0x0237, 0x00 },
	{ 0x0238, 0x78 },
	{ 0x0239, 0xD5 },
	{ 0x023A, 0x00 },
	{ 0x023B, 0x00 },
	{ 0x023C, 0x00 },
	{ 0x023D, 0x00 },
	{ 0x023E, 0xD0 },
	{ 0x024A, 0x0A },
	{ 0x024B, 0x00 },
	{ 0x024C, 0x00 },
	{ 0x024D, 0x00 },
	{ 0x024E, 0x00 },
	{ 0x024F, 0x00 },
	{ 0x0250, 0x01 },
	{ 0x0251, 0x00 },
	{ 0x0252, 0x00 },
	{ 0x0253, 0x00 },
	{ 0x0254, 0x00 },
	{ 0x0255, 0x00 },
	{ 0x0256, 0x00 },
	{ 0x0257, 0x00 },
	{ 0x0258, 0x00 },
	{ 0x0259, 0x02 },
	{ 0x025A, 0x00 },
	{ 0x025B, 0x00 },
	{ 0x025C, 0x00 },
	{ 0x025D, 0x00 },
	{ 0x025E, 0x00 },
	{ 0x025F, 0x00 },
	{ 0x0260, 0x00 },
	{ 0x0261, 0x00 },
	{ 0x0262, 0x02 },
	{ 0x0263, 0x00 },
	{ 0x0264, 0x00 },
	{ 0x0268, 0x00 },
	{ 0x0269, 0x00 },
	{ 0x026A, 0x00 },
	{ 0x026B, 0x49 },
	{ 0x026C, 0x4F },
	{ 0x026D, 0x34 },
	{ 0x026E, 0x4B },
	{ 0x026F, 0x2B },
	{ 0x0270, 0x00 },
	{ 0x0271, 0x00 },
	{ 0x0272, 0x00 },
	{ 0x0294, 0x80 },
	{ 0x0296, 0x00 },
	{ 0x0297, 0x02 },
	{ 0x0299, 0x02 },
	{ 0x029D, 0xF5 },
	{ 0x029E, 0x0E },
	{ 0x029F, 0x00 },
	{ 0x02A9, 0x66 },
	{ 0x02AA, 0x26 },
	{ 0x02AB, 0x00 },
	{ 0x02B7, 0xFF },
	{ 0x0302, 0x00 },
	{ 0x0303, 0x00 },
	{ 0x0304, 0x00 },
	{ 0x0305, 0x80 },
	{ 0x0306, 0x0B },
	{ 0x0307, 0x00 },
	{ 0x0308, 0x00 },
	{ 0x0309, 0x00 },
	{ 0x030A, 0x00 },
	{ 0x030B, 0x80 },
	{ 0x030C, 0x00 },
	{ 0x030D, 0x00 },
	{ 0x030E, 0x00 },
	{ 0x030F, 0x60 },
	{ 0x0310, 0x53 },
	{ 0x0311, 0x2E },
	{ 0x0312, 0x00 },
	{ 0x0313, 0x00 },
	{ 0x0314, 0x00 },
	{ 0x0315, 0x00 },
	{ 0x0316, 0x80 },
	{ 0x0317, 0x00 },
	{ 0x0318, 0x00 },
	{ 0x0319, 0x00 },
	{ 0x031A, 0xE0 },
	{ 0x031B, 0x3D },
	{ 0x031C, 0x0B },
	{ 0x031D, 0x00 },
	{ 0x031E, 0x00 },
	{ 0x031F, 0x00 },
	{ 0x0320, 0x80 },
	{ 0x0321, 0xBB },
	{ 0x0322, 0x00 },
	{ 0x0323, 0x00 },
	{ 0x0324, 0x00 },
	{ 0x0325, 0x00 },
	{ 0x0326, 0x00 },
	{ 0x0327, 0x00 },
	{ 0x0328, 0x00 },
	{ 0x0329, 0x00 },
	{ 0x032A, 0x00 },
	{ 0x032B, 0x00 },
	{ 0x032C, 0x00 },
	{ 0x032D, 0x00 },
	{ 0x032E, 0x00 },
	{ 0x032F, 0x00 },
	{ 0x0330, 0x00 },
	{ 0x0331, 0x00 },
	{ 0x0332, 0x00 },
	{ 0x0333, 0x00 },
	{ 0x0334, 0x00 },
	{ 0x0335, 0x00 },
	{ 0x0336, 0x00 },
	{ 0x0337, 0x00 },
	{ 0x0338, 0x00 },
	{ 0x0339, 0x1F },
	{ 0x033B, 0x00 },
	{ 0x033C, 0x00 },
	{ 0x033D, 0x00 },
	{ 0x033E, 0x00 },
	{ 0x033F, 0x00 },
	{ 0x0340, 0x00 },
	{ 0x0341, 0x00 },
	{ 0x0342, 0x00 },
	{ 0x0343, 0x00 },
	{ 0x0344, 0x00 },
	{ 0x0345, 0x00 },
	{ 0x0346, 0x00 },
	{ 0x0347, 0x00 },
	{ 0x0348, 0x00 },
	{ 0x0349, 0x00 },
	{ 0x034A, 0x00 },
	{ 0x034B, 0x00 },
	{ 0x034C, 0x00 },
	{ 0x034D, 0x00 },
	{ 0x034E, 0x00 },
	{ 0x034F, 0x00 },
	{ 0x0350, 0x00 },
	{ 0x0351, 0x00 },
	{ 0x0352, 0x00 },
	{ 0x0353, 0x00 },
	{ 0x0354, 0x00 },
	{ 0x0355, 0x00 },
	{ 0x0356, 0x00 },
	{ 0x0357, 0x00 },
	{ 0x0358, 0x00 },
	{ 0x0359, 0x00 },
	{ 0x035A, 0x00 },
	{ 0x035B, 0x00 },
	{ 0x035C, 0x00 },
	{ 0x035D, 0x00 },
	{ 0x035E, 0x00 },
	{ 0x035F, 0x00 },
	{ 0x0360, 0x00 },
	{ 0x0361, 0x00 },
	{ 0x0362, 0x00 },
	{ 0x0487, 0x00 },
	{ 0x0502, 0x01 },
	{ 0x0508, 0x11 },
	{ 0x0509, 0x19 },
	{ 0x050A, 0x0F },
	{ 0x050B, 0x0F },
	{ 0x050C, 0x01 },
	{ 0x050D, 0x0F },
	{ 0x050E, 0x18 },
	{ 0x050F, 0x29 },
	{ 0x0510, 0x0C },
	{ 0x0511, 0x0B },
	{ 0x0512, 0x01 },
	{ 0x0513, 0x0F },
	{ 0x0515, 0x00 },
	{ 0x0516, 0x00 },
	{ 0x0517, 0x00 },
	{ 0x0518, 0xA0 },
	{ 0x0519, 0xA8 },
	{ 0x051A, 0x7B },
	{ 0x051B, 0x00 },
	{ 0x051C, 0x00 },
	{ 0x051D, 0x00 },
	{ 0x051E, 0x00 },
	{ 0x051F, 0xC8 },
	{ 0x0521, 0x3B },
	{ 0x052A, 0x01 },
	{ 0x052B, 0x01 },
	{ 0x052C, 0x0F },
	{ 0x052D, 0x03 },
	{ 0x052E, 0x15 },
	{ 0x052F, 0x14 },
	{ 0x0531, 0x00 },
	{ 0x0532, 0x8D },
	{ 0x0533, 0x60 },
	{ 0x0534, 0x00 },
	{ 0x0535, 0x00 },
	{ 0x0536, 0x00 },
	{ 0x0537, 0x00 },
	{ 0x0538, 0x00 },
	{ 0x0539, 0x00 },
	{ 0x053A, 0x02 },
	{ 0x053B, 0x03 },
	{ 0x053C, 0x00 },
	{ 0x053D, 0x13 },
	{ 0x053E, 0x06 },
	{ 0x0589, 0x92 },
	{ 0x058A, 0x01 },
	{ 0x059B, 0xF8 },
	{ 0x059D, 0x18 },
	{ 0x059E, 0x29 },
	{ 0x059F, 0x0C },
	{ 0x05A0, 0x0B },
	{ 0x05A1, 0x01 },
	{ 0x05A2, 0x0F },
	{ 0x05A6, 0x00 },
	{ 0x0802, 0x35 },
	{ 0x0803, 0x05 },
	{ 0x0804, 0x00 },
	{ 0x0805, 0x00 },
	{ 0x0806, 0x00 },
	{ 0x0807, 0x00 },
	{ 0x0808, 0x00 },
	{ 0x0809, 0x00 },
	{ 0x080A, 0x00 },
	{ 0x080B, 0x00 },
	{ 0x080C, 0x00 },
	{ 0x080D, 0x00 },
	{ 0x080E, 0x00 },
	{ 0x080F, 0x00 },
	{ 0x0810, 0x00 },
	{ 0x0811, 0x00 },
	{ 0x0812, 0x00 },
	{ 0x0813, 0x00 },
	{ 0x0814, 0x00 },
	{ 0x0815, 0x00 },
	{ 0x0816, 0x00 },
	{ 0x0817, 0x00 },
	{ 0x0818, 0x00 },
	{ 0x0819, 0x00 },
	{ 0x081A, 0x00 },
	{ 0x081B, 0x00 },
	{ 0x081C, 0x00 },
	{ 0x081D, 0x00 },
	{ 0x081E, 0x00 },
	{ 0x081F, 0x00 },
	{ 0x0820, 0x00 },
	{ 0x0821, 0x00 },
	{ 0x0822, 0x00 },
	{ 0x0823, 0x00 },
	{ 0x0824, 0x00 },
	{ 0x0825, 0x00 },
	{ 0x0826, 0x00 },
	{ 0x0827, 0x00 },
	{ 0x0828, 0x00 },
	{ 0x0829, 0x00 },
	{ 0x082A, 0x00 },
	{ 0x082B, 0x00 },
	{ 0x082C, 0x00 },
	{ 0x082D, 0x00 },
	{ 0x082E, 0x00 },
	{ 0x082F, 0x00 },
	{ 0x0830, 0x00 },
	{ 0x0831, 0x00 },
	{ 0x0832, 0x00 },
	{ 0x0833, 0x00 },
	{ 0x0834, 0x00 },
	{ 0x0835, 0x00 },
	{ 0x0836, 0x00 },
	{ 0x0837, 0x00 },
	{ 0x0838, 0x00 },
	{ 0x0839, 0x00 },
	{ 0x083A, 0x00 },
	{ 0x083B, 0x00 },
	{ 0x083C, 0x00 },
	{ 0x083D, 0x00 },
	{ 0x083E, 0x00 },
	{ 0x083F, 0x00 },
	{ 0x0840, 0x00 },
	{ 0x0841, 0x00 },
	{ 0x0842, 0x00 },
	{ 0x0843, 0x00 },
	{ 0x0844, 0x00 },
	{ 0x0845, 0x00 },
	{ 0x0846, 0x00 },
	{ 0x0847, 0x00 },
	{ 0x0848, 0x00 },
	{ 0x0849, 0x00 },
	{ 0x084A, 0x00 },
	{ 0x084B, 0x00 },
	{ 0x084C, 0x00 },
	{ 0x084D, 0x00 },
	{ 0x084E, 0x00 },
	{ 0x084F, 0x00 },
	{ 0x0850, 0x00 },
	{ 0x0851, 0x00 },
	{ 0x0852, 0x00 },
	{ 0x0853, 0x00 },
	{ 0x0854, 0x00 },
	{ 0x0855, 0x00 },
	{ 0x0856, 0x00 },
	{ 0x0857, 0x00 },
	{ 0x0858, 0x00 },
	{ 0x0859, 0x00 },
	{ 0x085A, 0x00 },
	{ 0x085B, 0x00 },
	{ 0x085C, 0x00 },
	{ 0x085D, 0x00 },
	{ 0x085E, 0x00 },
	{ 0x085F, 0x00 },
	{ 0x0860, 0x00 },
	{ 0x0861, 0x00 },
	{ 0x090E, 0x03 },
	{ 0x0943, 0x00 },
	{ 0x0949, 0x31 },
	{ 0x094A, 0x01 },
	{ 0x094E, 0x49 },
	{ 0x094F, 0x02 },
	{ 0x095E, 0x00 },
	{ 0x0A02, 0x00 },
	{ 0x0A03, 0x07 },
	{ 0x0A04, 0x01 },
	{ 0x0A05, 0x07 },
	{ 0x0A14, 0x00 },
	{ 0x0A1A, 0x00 },
	{ 0x0A20, 0x00 },
	{ 0x0A26, 0x00 },
	{ 0x0A2C, 0x00 },
	{ 0x0B44, 0x0F },
	{ 0x0B46, 0x00 },
	{ 0x0B47, 0x0E },
	{ 0x0B48, 0x0E },
	{ 0x0B4A, 0x18 },
	{ 0x0B57, 0xF9 },
	{ 0x0B58, 0x00 },
	/* End configuration registers */

	/* Start configuration postamble */
	{ 0x0514, 0x01 },
	{ 0x001C, 0x01 },
	{ 0x0540, 0x00 },
	{ 0x0B24, 0xC3 },
	{ 0x0B25, 0x02 },
	/* End configuration postamble */

	{ 0x0000, 0x00 }
};

/*
 * Design Report
 *
 * Overview
 * ========
 * Part:         Si5345 Rev D
 * Project File: C:\XilinxProjects\flint_tr051017\genlock\FormatFiles\IO4K+_1125_5994.slabtimeproj
 * Design ID:    IO4K+
 * Created By:   ClockBuilder Pro v2.16.1 [2017-07-19]
 * Timestamp:    2017-08-24 16:53:54 GMT-07:00
 * 
 * Design Notes
 * ============
 * assumes NTSC HSYNC (pulsed) input = (30/1.001)*525
 * 
 * Design Rule Check
 * =================
 * Errors:
 * - No errors
 * 
 * Warnings:
 * - Pulsed LVCMOS input buffer mode has been selected. This mode has non-standard input voltage logic thresholds: 0.33 V for Vil (max) and 0.49 V for Vih (min). Select this mode only if your input clock has a duty cycle significantly less or more than 50%.  Refer to the device datasheet for the exact threshold voltage specifications and the input attenuator circuit (DC coupled Pulsed LVCMOS) in the Family Reference Manual.
 * 
 * Device Grade
 * ============
 * Maximum Output Frequency: 148.5 MHz
 * Frequency Synthesis Mode: Fractional
 * Minimum Base OPN:         Si5345B
 * Actual Base OPN:          Si5345B
 * 
 * Base       Output Clock         Supported Frequency Synthesis Modes
 * OPN Grade  Frequency Range      (Typical Jitter)
 * ---------  -------------------  --------------------------------------------
 * Si5345A    100 Hz to 1.028 GHz  Integer (< 100 fs) and fractional (< 150 fs)
 * Si5345B    100 Hz to 350 MHz    "
 * Si5345C    100 Hz to 1.028 GHz  Integer only (< 100 fs)
 * Si5345D    100 Hz to 350 MHz    "
 * 
 * Design
 * ======
 * Host Interface:
 *    I/O Power Supply: VDD (Core)
 *    SPI Mode: 4-Wire
 *    I2C Address Range: 100d to 103d / 0x64 to 0x67 (selected via A0/A1 pins)
 * 
 * XA/XB:
 *    52 MHz (XO - External Oscillator)
 * 
 * Inputs:
 *     IN0: 67.4325674325674325... kHz [ 67 + 433/1001 kHz ]
 *          [ (30000/1001)*2250 ]
 *          Pulsed LVCMOS
 *     IN1: Unused
 *     IN2: Unused
 *     IN3: Unused
 * 
 * Outputs:
 *    OUT0: 27 MHz
 *          Enabled, LVDS 2.5 V
 *    OUT1: Unused
 *    OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT3: Unused
 *    OUT4: Unused
 *    OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT6: Unused
 *    OUT7: Unused
 *    OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *          [ 148.5/1.001 MHz ]
 *          Enabled, LVDS 2.5 V
 *    OUT9: Unused
 * 
 * Frequency Plan
 * ==============
 * Priority: maximize the number of low jitter outputs
 * 
 * Fvco = 13.662 GHz [ 13 + 331/500 GHz ]
 * Fpfd = 67.4325674325674325... kHz [ 67 + 433/1001 kHz ]
 * Fms0 = 594 MHz
 * Fms1 = 147.456 MHz [ 147 + 57/125 MHz ]
 * Fms2 = 890.1098901098901098... MHz [ 890 + 10/91 MHz ]
 * 
 * P dividers:
 *    P0  = 1
 *    P1  = Unused
 *    P2  = Unused
 *    P3  = Unused
 *    Pxaxb = 1
 * 
 * MXAXB = 262.7307692307692307... [ 262 + 19/26 ]
 * M = 40520.48 [ 40520 + 12/25 ]
 * N dividers:
 *    N0:
 *       Value: 23
 *       Skew:  0.000 s
 *       OUT0: 27 MHz
 *       OUT2: 148.5 MHz [ 148 + 1/2 MHz ]
 *    N1:
 *       Value: 92.6513671875 [ 92 + 667/1024 ]
 *       Skew:  0.000 s
 *       OUT5: 24.576 MHz [ 24 + 72/125 MHz ]
 *    N2:
 *       Value: 15.3486666666666666... [ 15 + 523/1500 ]
 *       Skew:  0.000 s
 *       OUT8: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *    N3:
 *       Unused
 *    N4:
 *       Unused
 * 
 * R dividers:
 *    R0 = 22
 *    R1 = Unused
 *    R2 = 4
 *    R3 = Unused
 *    R4 = Unused
 *    R5 = 6
 *    R6 = Unused
 *    R7 = Unused
 *    R8 = 6
 *    R9 = Unused
 * 
 * Nominal Bandwidth:
 *   Desired: 1.000 Hz
 *   Actual:  651.191 mHz
 *   Coefficients:
 *      BW0:  17
 *      BW1:  25
 *      BW2:  15
 *      BW3:  15
 *      BW4:  1
 *      BW5:  15
 * Fastlock Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  107.233 Hz
 *   Coefficients:
 *      BW0:  24
 *      BW1:  41
 *      BW2:  12
 *      BW3:  11
 *      BW4:  1
 *      BW5:  15
 * Holdover Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  107.233 Hz
 *   Coefficients:
 *      BW0:  24
 *      BW1:  41
 *      BW2:  12
 *      BW3:  11
 *      BW4:  1
 *      BW5:  15
 * 
 * Dividers listed above show effective values. These values are translated to register settings by ClockBuilder Pro. For the actual register values, see below. Refer to the Family Reference Manual for information on registers related to frequency plan.
 * 
 * Digitally Controlled Oscillator (DCO)
 * =====================================
 * Mode: Register Direct Write
 * 
 * N0: DCO Disabled
 * 
 * N1: DCO Disabled
 * 
 * N2: DCO Disabled
 * 
 * N3: DCO Disabled
 * 
 * N4: DCO Disabled
 * 
 * Estimated Power & Junction Temperature
 * ======================================
 * Assumptions:
 * 
 * Revision: D
 * VDD:      1.8 V
 * Ta:       70 C
 * Airflow:  None
 * 
 * Total Power: 808 mW, On Chip Power: 784 mW, Tj: 87 C
 * 
 *                 Frequency  Format   Voltage   Current     Power
 *         -----------------  ------  --------  --------  --------
 * VDD                                   1.8 V  147.9 mA    266 mW
 * VDDA                                  3.3 V  117.4 mA    387 mW
 * VDDO0              27 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO1              Unused                                      
 * VDDO2           148.5 MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO3              Unused                                      
 * VDDO4              Unused                                      
 * VDDO5          24.576 MHz  LVDS       2.5 V   15.1 mA     38 mW
 * VDDO6              Unused                                      
 * VDDO7              Unused                                      
 * VDDO8   148.351648... MHz  LVDS       2.5 V   15.9 mA     40 mW
 * VDDO9              Unused                                      
 *                                              --------  --------
 *                                       Total  327.2 mA    808 mW
 * 
 * Note:
 * 
 * -Total power includes on- and off-chip power. This is a typical value and estimate only.
 * -Use an EVB for a more exact power measurement
 * -On-chip power excludes power dissipated in external terminations.
 * -Tj is junction temperature. Tj must be less than 125 C (on Si5345 Revision D) for device to comply with datasheet specifications.
 * 
 * Settings
 * ========
 * 
 * Location      Setting Name           Decimal Value      Hex Value        
 * ------------  ---------------------  -----------------  -----------------
 * 0x000B[6:0]   I2C_ADDR               100                0x64             
 * 0x0016[1]     LOL_ON_HOLD            1                  0x1              
 * 0x0017[0]     SYSINCAL_INTR_MSK      0                  0x0              
 * 0x0017[1]     LOSXAXB_INTR_MSK       0                  0x0              
 * 0x0017[5]     SMB_TMOUT_INTR_MSK     1                  0x1              
 * 0x0018[3:0]   LOS_INTR_MSK           15                 0xF              
 * 0x0018[7:4]   OOF_INTR_MSK           15                 0xF              
 * 0x0019[1]     LOL_INTR_MSK           1                  0x1              
 * 0x0019[5]     HOLD_INTR_MSK          0                  0x0              
 * 0x001A[5]     CAL_INTR_MSK           0                  0x0              
 * 0x002B[3]     SPI_3WIRE              0                  0x0              
 * 0x002B[5]     AUTO_NDIV_UPDATE       0                  0x0              
 * 0x002C[3:0]   LOS_EN                 1                  0x1              
 * 0x002C[4]     LOSXAXB_DIS            0                  0x0              
 * 0x002D[1:0]   LOS0_VAL_TIME          2                  0x2              
 * 0x002D[3:2]   LOS1_VAL_TIME          0                  0x0              
 * 0x002D[5:4]   LOS2_VAL_TIME          0                  0x0              
 * 0x002D[7:6]   LOS3_VAL_TIME          0                  0x0              
 * 0x002E[15:0]  LOS0_TRG_THR           973                0x03CD           
 * 0x0030[15:0]  LOS1_TRG_THR           0                  0x0000           
 * 0x0032[15:0]  LOS2_TRG_THR           0                  0x0000           
 * 0x0034[15:0]  LOS3_TRG_THR           0                  0x0000           
 * 0x0036[15:0]  LOS0_CLR_THR           892                0x037C           
 * 0x0038[15:0]  LOS1_CLR_THR           0                  0x0000           
 * 0x003A[15:0]  LOS2_CLR_THR           0                  0x0000           
 * 0x003C[15:0]  LOS3_CLR_THR           0                  0x0000           
 * 0x003F[3:0]   OOF_EN                 1                  0x1              
 * 0x003F[7:4]   FAST_OOF_EN            0                  0x0              
 * 0x0040[2:0]   OOF_REF_SEL            4                  0x4              
 * 0x0041[4:0]   OOF0_DIV_SEL           3                  0x03             
 * 0x0042[4:0]   OOF1_DIV_SEL           0                  0x00             
 * 0x0043[4:0]   OOF2_DIV_SEL           0                  0x00             
 * 0x0044[4:0]   OOF3_DIV_SEL           0                  0x00             
 * 0x0045[4:0]   OOFXO_DIV_SEL          12                 0x0C             
 * 0x0046[7:0]   OOF0_SET_THR           150                0x96             
 * 0x0047[7:0]   OOF1_SET_THR           0                  0x00             
 * 0x0048[7:0]   OOF2_SET_THR           0                  0x00             
 * 0x0049[7:0]   OOF3_SET_THR           0                  0x00             
 * 0x004A[7:0]   OOF0_CLR_THR           75                 0x4B             
 * 0x004B[7:0]   OOF1_CLR_THR           0                  0x00             
 * 0x004C[7:0]   OOF2_CLR_THR           0                  0x00             
 * 0x004D[7:0]   OOF3_CLR_THR           0                  0x00             
 * 0x004E[2:0]   OOF0_DETWIN_SEL        5                  0x5              
 * 0x004E[6:4]   OOF1_DETWIN_SEL        0                  0x0              
 * 0x004F[2:0]   OOF2_DETWIN_SEL        0                  0x0              
 * 0x004F[6:4]   OOF3_DETWIN_SEL        0                  0x0              
 * 0x0050[3:0]   OOF_ON_LOS             15                 0xF              
 * 0x0051[3:0]   FAST_OOF0_SET_THR      0                  0x0              
 * 0x0052[3:0]   FAST_OOF1_SET_THR      0                  0x0              
 * 0x0053[3:0]   FAST_OOF2_SET_THR      0                  0x0              
 * 0x0054[3:0]   FAST_OOF3_SET_THR      0                  0x0              
 * 0x0055[3:0]   FAST_OOF0_CLR_THR      0                  0x0              
 * 0x0056[3:0]   FAST_OOF1_CLR_THR      0                  0x0              
 * 0x0057[3:0]   FAST_OOF2_CLR_THR      0                  0x0              
 * 0x0058[3:0]   FAST_OOF3_CLR_THR      0                  0x0              
 * 0x0059[1:0]   FAST_OOF0_DETWIN_SEL   1                  0x1              
 * 0x0059[3:2]   FAST_OOF1_DETWIN_SEL   0                  0x0              
 * 0x0059[5:4]   FAST_OOF2_DETWIN_SEL   0                  0x0              
 * 0x0059[7:6]   FAST_OOF3_DETWIN_SEL   0                  0x0              
 * 0x005A[25:0]  OOF0_RATIO_REF         11139256           0x0A9F8B8        
 * 0x005E[25:0]  OOF1_RATIO_REF         0                  0x0000000        
 * 0x0062[25:0]  OOF2_RATIO_REF         0                  0x0000000        
 * 0x0066[25:0]  OOF3_RATIO_REF         0                  0x0000000        
 * 0x0092[1]     LOL_FST_EN             1                  0x1              
 * 0x0093[7:4]   LOL_FST_DETWIN_SEL     10                 0xA              
 * 0x0095[3:2]   LOL_FST_VALWIN_SEL     0                  0x0              
 * 0x0096[7:4]   LOL_FST_SET_THR_SEL    9                  0x9              
 * 0x0098[7:4]   LOL_FST_CLR_THR_SEL    7                  0x7              
 * 0x009A[1]     LOL_SLOW_EN_PLL        1                  0x1              
 * 0x009B[7:4]   LOL_SLW_DETWIN_SEL     5                  0x5              
 * 0x009D[3:2]   LOL_SLW_VALWIN_SEL     1                  0x1              
 * 0x009E[7:4]   LOL_SLW_SET_THR        6                  0x6              
 * 0x00A0[7:4]   LOL_SLW_CLR_THR        3                  0x3              
 * 0x00A2[1]     LOL_TIMER_EN           0                  0x0              
 * 0x00A9[28:0]  LOL_CLR_DELAY_DIV256   294329             0x00047DB9       
 * 0x00E5[5]     FASTLOCK_EXTEND_EN     1                  0x1              
 * 0x00EA[28:0]  FASTLOCK_EXTEND        242129             0x0003B1D1       
 * 0x0102[0]     OUTALL_DISABLE_LOW     1                  0x1              
 * 0x0108[0]     OUT0_PDN               0                  0x0              
 * 0x0108[1]     OUT0_OE                1                  0x1              
 * 0x0108[2]     OUT0_RDIV_FORCE2       0                  0x0              
 * 0x0109[2:0]   OUT0_FORMAT            1                  0x1              
 * 0x0109[3]     OUT0_SYNC_EN           1                  0x1              
 * 0x0109[5:4]   OUT0_DIS_STATE         0                  0x0              
 * 0x0109[7:6]   OUT0_CMOS_DRV          0                  0x0              
 * 0x010A[3:0]   OUT0_CM                11                 0xB              
 * 0x010A[6:4]   OUT0_AMPL              3                  0x3              
 * 0x010B[2:0]   OUT0_MUX_SEL           0                  0x0              
 * 0x010B[5:4]   OUT0_VDD_SEL           2                  0x2              
 * 0x010B[3]     OUT0_VDD_SEL_EN        1                  0x1              
 * 0x010B[7:6]   OUT0_INV               0                  0x0              
 * 0x010D[0]     OUT1_PDN               1                  0x1              
 * 0x010D[1]     OUT1_OE                0                  0x0              
 * 0x010D[2]     OUT1_RDIV_FORCE2       0                  0x0              
 * 0x010E[2:0]   OUT1_FORMAT            1                  0x1              
 * 0x010E[3]     OUT1_SYNC_EN           1                  0x1              
 * 0x010E[5:4]   OUT1_DIS_STATE         0                  0x0              
 * 0x010E[7:6]   OUT1_CMOS_DRV          0                  0x0              
 * 0x010F[3:0]   OUT1_CM                11                 0xB              
 * 0x010F[6:4]   OUT1_AMPL              3                  0x3              
 * 0x0110[2:0]   OUT1_MUX_SEL           0                  0x0              
 * 0x0110[5:4]   OUT1_VDD_SEL           2                  0x2              
 * 0x0110[3]     OUT1_VDD_SEL_EN        1                  0x1              
 * 0x0110[7:6]   OUT1_INV               0                  0x0              
 * 0x0112[0]     OUT2_PDN               0                  0x0              
 * 0x0112[1]     OUT2_OE                1                  0x1              
 * 0x0112[2]     OUT2_RDIV_FORCE2       0                  0x0              
 * 0x0113[2:0]   OUT2_FORMAT            1                  0x1              
 * 0x0113[3]     OUT2_SYNC_EN           1                  0x1              
 * 0x0113[5:4]   OUT2_DIS_STATE         0                  0x0              
 * 0x0113[7:6]   OUT2_CMOS_DRV          0                  0x0              
 * 0x0114[3:0]   OUT2_CM                11                 0xB              
 * 0x0114[6:4]   OUT2_AMPL              3                  0x3              
 * 0x0115[2:0]   OUT2_MUX_SEL           0                  0x0              
 * 0x0115[5:4]   OUT2_VDD_SEL           2                  0x2              
 * 0x0115[3]     OUT2_VDD_SEL_EN        1                  0x1              
 * 0x0115[7:6]   OUT2_INV               0                  0x0              
 * 0x0117[0]     OUT3_PDN               1                  0x1              
 * 0x0117[1]     OUT3_OE                0                  0x0              
 * 0x0117[2]     OUT3_RDIV_FORCE2       0                  0x0              
 * 0x0118[2:0]   OUT3_FORMAT            1                  0x1              
 * 0x0118[3]     OUT3_SYNC_EN           1                  0x1              
 * 0x0118[5:4]   OUT3_DIS_STATE         0                  0x0              
 * 0x0118[7:6]   OUT3_CMOS_DRV          0                  0x0              
 * 0x0119[3:0]   OUT3_CM                11                 0xB              
 * 0x0119[6:4]   OUT3_AMPL              3                  0x3              
 * 0x011A[2:0]   OUT3_MUX_SEL           0                  0x0              
 * 0x011A[5:4]   OUT3_VDD_SEL           2                  0x2              
 * 0x011A[3]     OUT3_VDD_SEL_EN        1                  0x1              
 * 0x011A[7:6]   OUT3_INV               0                  0x0              
 * 0x011C[0]     OUT4_PDN               1                  0x1              
 * 0x011C[1]     OUT4_OE                0                  0x0              
 * 0x011C[2]     OUT4_RDIV_FORCE2       0                  0x0              
 * 0x011D[2:0]   OUT4_FORMAT            1                  0x1              
 * 0x011D[3]     OUT4_SYNC_EN           1                  0x1              
 * 0x011D[5:4]   OUT4_DIS_STATE         0                  0x0              
 * 0x011D[7:6]   OUT4_CMOS_DRV          0                  0x0              
 * 0x011E[3:0]   OUT4_CM                11                 0xB              
 * 0x011E[6:4]   OUT4_AMPL              3                  0x3              
 * 0x011F[2:0]   OUT4_MUX_SEL           0                  0x0              
 * 0x011F[5:4]   OUT4_VDD_SEL           2                  0x2              
 * 0x011F[3]     OUT4_VDD_SEL_EN        1                  0x1              
 * 0x011F[7:6]   OUT4_INV               0                  0x0              
 * 0x0121[0]     OUT5_PDN               0                  0x0              
 * 0x0121[1]     OUT5_OE                1                  0x1              
 * 0x0121[2]     OUT5_RDIV_FORCE2       0                  0x0              
 * 0x0122[2:0]   OUT5_FORMAT            1                  0x1              
 * 0x0122[3]     OUT5_SYNC_EN           1                  0x1              
 * 0x0122[5:4]   OUT5_DIS_STATE         0                  0x0              
 * 0x0122[7:6]   OUT5_CMOS_DRV          0                  0x0              
 * 0x0123[3:0]   OUT5_CM                11                 0xB              
 * 0x0123[6:4]   OUT5_AMPL              3                  0x3              
 * 0x0124[2:0]   OUT5_MUX_SEL           1                  0x1              
 * 0x0124[5:4]   OUT5_VDD_SEL           2                  0x2              
 * 0x0124[3]     OUT5_VDD_SEL_EN        1                  0x1              
 * 0x0124[7:6]   OUT5_INV               0                  0x0              
 * 0x0126[0]     OUT6_PDN               1                  0x1              
 * 0x0126[1]     OUT6_OE                0                  0x0              
 * 0x0126[2]     OUT6_RDIV_FORCE2       0                  0x0              
 * 0x0127[2:0]   OUT6_FORMAT            1                  0x1              
 * 0x0127[3]     OUT6_SYNC_EN           1                  0x1              
 * 0x0127[5:4]   OUT6_DIS_STATE         0                  0x0              
 * 0x0127[7:6]   OUT6_CMOS_DRV          0                  0x0              
 * 0x0128[3:0]   OUT6_CM                11                 0xB              
 * 0x0128[6:4]   OUT6_AMPL              3                  0x3              
 * 0x0129[2:0]   OUT6_MUX_SEL           0                  0x0              
 * 0x0129[5:4]   OUT6_VDD_SEL           2                  0x2              
 * 0x0129[3]     OUT6_VDD_SEL_EN        1                  0x1              
 * 0x0129[7:6]   OUT6_INV               0                  0x0              
 * 0x012B[0]     OUT7_PDN               1                  0x1              
 * 0x012B[1]     OUT7_OE                0                  0x0              
 * 0x012B[2]     OUT7_RDIV_FORCE2       0                  0x0              
 * 0x012C[2:0]   OUT7_FORMAT            1                  0x1              
 * 0x012C[3]     OUT7_SYNC_EN           1                  0x1              
 * 0x012C[5:4]   OUT7_DIS_STATE         0                  0x0              
 * 0x012C[7:6]   OUT7_CMOS_DRV          0                  0x0              
 * 0x012D[3:0]   OUT7_CM                11                 0xB              
 * 0x012D[6:4]   OUT7_AMPL              3                  0x3              
 * 0x012E[2:0]   OUT7_MUX_SEL           0                  0x0              
 * 0x012E[5:4]   OUT7_VDD_SEL           2                  0x2              
 * 0x012E[3]     OUT7_VDD_SEL_EN        1                  0x1              
 * 0x012E[7:6]   OUT7_INV               0                  0x0              
 * 0x0130[0]     OUT8_PDN               0                  0x0              
 * 0x0130[1]     OUT8_OE                1                  0x1              
 * 0x0130[2]     OUT8_RDIV_FORCE2       0                  0x0              
 * 0x0131[2:0]   OUT8_FORMAT            1                  0x1              
 * 0x0131[3]     OUT8_SYNC_EN           1                  0x1              
 * 0x0131[5:4]   OUT8_DIS_STATE         0                  0x0              
 * 0x0131[7:6]   OUT8_CMOS_DRV          0                  0x0              
 * 0x0132[3:0]   OUT8_CM                11                 0xB              
 * 0x0132[6:4]   OUT8_AMPL              3                  0x3              
 * 0x0133[2:0]   OUT8_MUX_SEL           2                  0x2              
 * 0x0133[5:4]   OUT8_VDD_SEL           2                  0x2              
 * 0x0133[3]     OUT8_VDD_SEL_EN        1                  0x1              
 * 0x0133[7:6]   OUT8_INV               0                  0x0              
 * 0x013A[0]     OUT9_PDN               1                  0x1              
 * 0x013A[1]     OUT9_OE                0                  0x0              
 * 0x013A[2]     OUT9_RDIV_FORCE2       0                  0x0              
 * 0x013B[2:0]   OUT9_FORMAT            1                  0x1              
 * 0x013B[3]     OUT9_SYNC_EN           1                  0x1              
 * 0x013B[5:4]   OUT9_DIS_STATE         0                  0x0              
 * 0x013B[7:6]   OUT9_CMOS_DRV          0                  0x0              
 * 0x013C[3:0]   OUT9_CM                11                 0xB              
 * 0x013C[6:4]   OUT9_AMPL              3                  0x3              
 * 0x013D[2:0]   OUT9_MUX_SEL           0                  0x0              
 * 0x013D[5:4]   OUT9_VDD_SEL           2                  0x2              
 * 0x013D[3]     OUT9_VDD_SEL_EN        1                  0x1              
 * 0x013D[7:6]   OUT9_INV               0                  0x0              
 * 0x013F[11:0]  OUTX_ALWAYS_ON         0                  0x000            
 * 0x0141[1]     OUT_DIS_MSK            0                  0x0              
 * 0x0141[5]     OUT_DIS_LOL_MSK        0                  0x0              
 * 0x0141[6]     OUT_DIS_LOSXAXB_MSK    1                  0x1              
 * 0x0141[7]     OUT_DIS_MSK_LOS_PFD    0                  0x0              
 * 0x0142[1]     OUT_DIS_MSK_LOL        1                  0x1              
 * 0x0142[5]     OUT_DIS_MSK_HOLD       1                  0x1              
 * 0x0206[1:0]   PXAXB                  0                  0x0              
 * 0x0208[47:0]  P0_NUM                 1                  0x000000000001   
 * 0x020E[31:0]  P0_DEN                 1                  0x00000001       
 * 0x0212[47:0]  P1_NUM                 0                  0x000000000000   
 * 0x0218[31:0]  P1_DEN                 0                  0x00000000       
 * 0x021C[47:0]  P2_NUM                 0                  0x000000000000   
 * 0x0222[31:0]  P2_DEN                 0                  0x00000000       
 * 0x0226[47:0]  P3_NUM                 0                  0x000000000000   
 * 0x022C[31:0]  P3_DEN                 0                  0x00000000       
 * 0x0231[3:0]   P0_FRACN_MODE          11                 0xB              
 * 0x0231[4]     P0_FRACN_EN            0                  0x0              
 * 0x0232[3:0]   P1_FRACN_MODE          11                 0xB              
 * 0x0232[4]     P1_FRACN_EN            0                  0x0              
 * 0x0233[3:0]   P2_FRACN_MODE          11                 0xB              
 * 0x0233[4]     P2_FRACN_EN            0                  0x0              
 * 0x0234[3:0]   P3_FRACN_MODE          11                 0xB              
 * 0x0234[4]     P3_FRACN_EN            0                  0x0              
 * 0x0235[43:0]  MXAXB_NUM              916841299968       0x0D578000000    
 * 0x023B[31:0]  MXAXB_DEN              3489660928    