/*****************************************************************************
 * cpp_compat.h
 *****************************************************************************
 * Copyright (C) 2013-2015 L-SMASH Works project
 *
 * Authors: Yusuke Nakamura <muken.the.vfrmaniac@gmail.com>
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *****************************************************************************/

/* This file is available under an ISC license. */

#ifndef LW_CPP_COMPAT_H
#define LW_CPP_COMPAT_H

#ifdef __cplusplus
#   ifndef __STDC_CONSTANT_MACROS
#       define __STDC_CONSTANT_MACROS
#   endif
#   ifndef __STDC_LIMIT_MACROS
#       define __STDC_LIMIT_MACROS
#   endif
#   ifndef __STDC_FORMAT_MACROS
#       define __STDC_FORMAT_MACROS
#   endif
#   ifdef _MSC_VER
#       define _CRT_SECURE_NO_WARNINGS
#       pragma warning( disable:4996 )
#   endif
#endif  /* __cplusplus */

#ifdef __cplusplus
#define CPP_DEFINE_OR_SUBSTITUTE_OPERATOR( ENUM )           \
    inline ENUM operator |= ( ENUM &x, const ENUM y )       \
    {                                                       \
        x = (ENUM)(((unsigned int)x)|((unsigned int)y));    \
        return x;                                           \
    }
#else
#define CPP_DEFINE_OR_SUBSTITUTE_OPERATOR( ENUM )
#endif  /* __cplusplus */

#endif  /* LW_CPP_COMPAT_H */
