/*
 * Decompiled with CFR 0.152.
 */
package com.lipstikLF.delegate;

import com.lipstikLF.LipstikLookAndFeel;
import com.lipstikLF.theme.LipstikColorTheme;
import com.lipstikLF.util.LipstikBorderFactory;
import com.lipstikLF.util.LipstikGradients;
import com.lipstikLF.util.LipstikIconFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class LipstikSliderUI
extends BasicSliderUI {
    private static EmptyBorder emptyBorder = new EmptyBorder(2, 2, 2, 2);
    private static int trackWidth = 8;

    public LipstikSliderUI() {
        super(null);
    }

    public static ComponentUI createUI(JComponent c) {
        return new LipstikSliderUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        c.setBorder(emptyBorder);
    }

    public void paintThumb(Graphics g) {
        LipstikColorTheme theme = LipstikLookAndFeel.getMyCurrentTheme();
        Rectangle knobBounds = this.thumbRect;
        int sx = knobBounds.x;
        int sy = knobBounds.y;
        int sw = knobBounds.width;
        int sh = knobBounds.height;
        if (this.slider.isEnabled()) {
            LipstikGradients.drawGradient(g, theme.getControl(), null, sx + 1, sy + 1, sw - 1, sh - 1, this.slider.getOrientation() != 1);
            LipstikBorderFactory.paintRoundBorder(g, sx, sy, sw, sh, theme, theme.getControl(), 2);
            g.setClip(sx, sy, sw - 2, sh - 2);
            if (this.slider.getOrientation() != 1) {
                g.drawImage(LipstikIconFactory.vicon1.getImage(), knobBounds.x + 6, knobBounds.y + 4, null);
            } else {
                g.drawImage(LipstikIconFactory.hicon1.getImage(), knobBounds.x + 4, knobBounds.y + 6, null);
            }
        } else {
            g.setColor(this.slider.getParent().getBackground());
            g.fillRect(sx, sy, sw, sh);
            LipstikBorderFactory.paintRoundBorder(g, sx, sy, sw, sh, theme, this.slider.getBackground(), 32);
        }
    }

    protected int getThumbOverhang() {
        if (this.slider.getOrientation() == 1) {
            return (int)(this.getThumbSize().getWidth() - (double)trackWidth) / 2;
        }
        return (int)(this.getThumbSize().getHeight() - (double)trackWidth) / 2;
    }

    protected Dimension getThumbSize() {
        Dimension size = new Dimension();
        if (this.slider.getOrientation() == 1) {
            size.width = 16;
            size.height = 15;
        } else {
            size.width = 15;
            size.height = 16;
        }
        return size;
    }

    public void paintTrack(Graphics g) {
        int trackRight;
        int trackBottom;
        LipstikColorTheme theme = LipstikLookAndFeel.getMyCurrentTheme();
        boolean leftToRight = this.slider.getComponentOrientation().isLeftToRight();
        g.translate(this.trackRect.x, this.trackRect.y);
        int trackLeft = 0;
        int trackTop = 0;
        if (this.slider.getOrientation() == 0) {
            trackBottom = 3;
            trackTop = 6;
            trackRight = this.trackRect.width - 1;
        } else {
            trackLeft = leftToRight ? this.trackRect.width - this.getThumbOverhang() - trackWidth : this.getThumbOverhang();
            trackRight = 3;
            trackBottom = this.trackRect.height - 1;
        }
        if (this.slider.isEnabled()) {
            g.setColor(theme.getBorderNormal());
        } else {
            g.setColor(theme.getBorderDisabled());
        }
        g.drawRect(trackLeft + 1, trackTop + 1, trackRight, trackBottom);
        g.translate(-this.trackRect.x, -this.trackRect.y);
    }

    protected void paintMinorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        g.setColor(Color.LIGHT_GRAY);
        g.drawLine(x, 0, x, tickBounds.height / 2 - 1);
    }

    protected void paintMajorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        g.setColor(Color.GRAY);
        g.drawLine(x, 0, x, tickBounds.height - 4);
    }

    protected void paintMinorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        g.setColor(Color.LIGHT_GRAY);
        g.drawLine(0, y, tickBounds.width / 2 - 2, y);
    }

    protected void paintMajorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        g.setColor(Color.GRAY);
        g.drawLine(0, y, tickBounds.width - 7, y);
    }

    public void paintFocus(Graphics g) {
        LipstikBorderFactory.paintFocusBorder(g, 0, 0, this.slider.getWidth(), this.slider.getHeight());
    }
}

