/*
 * Decompiled with CFR 0.152.
 */
package com.lipstikLF.delegate;

import com.lipstikLF.LipstikLookAndFeel;
import com.lipstikLF.theme.LipstikColorTheme;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSeparatorUI;

public class LipstikSeparatorUI
extends BasicSeparatorUI {
    private static final LipstikSeparatorUI _separatorUI = new LipstikSeparatorUI();

    public static ComponentUI createUI(JComponent c) {
        return _separatorUI;
    }

    public void installUI(JComponent c) {
        this.installDefaults((JSeparator)c);
        this.installListeners((JSeparator)c);
    }

    public void uninstallUI(JComponent c) {
        this.uninstallDefaults((JSeparator)c);
        this.uninstallListeners((JSeparator)c);
    }

    public void paint(Graphics g, JComponent c) {
        Dimension s = c.getSize();
        Container p = c.getParent();
        if (p instanceof JPopupMenu) {
            g.setColor(c.getForeground());
            g.drawLine(24, 1, s.width - 21, 1);
            return;
        }
        LipstikColorTheme theme = LipstikLookAndFeel.getMyCurrentTheme();
        g.setColor(theme.getControlDarkShadow());
        if (p instanceof JToolBar) {
            if (((JToolBar)p).getOrientation() == 0) {
                g.drawLine(5, 5, 5, s.height - 6);
            } else {
                g.drawLine(5, 5, s.width - 6, 5);
            }
        } else if (((JSeparator)c).getOrientation() == 1) {
            int x = c.getWidth() >> 1;
            g.drawLine(x + 1, 0, x + 1, s.height);
            g.setColor(c.getBackground());
            g.drawLine(x, 0, x, s.height);
        } else {
            int y = c.getHeight() >> 1;
            g.drawLine(0, y + 1, s.width, y + 1);
            g.setColor(c.getBackground());
            g.drawLine(0, y, s.width, y);
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        if (((JSeparator)c).getOrientation() == 1) {
            return new Dimension(10, 20);
        }
        return new Dimension(20, 3);
    }

    public Dimension getMaximumSize(JComponent c) {
        if (c.getParent() instanceof JToolBar) {
            JToolBar p = (JToolBar)c.getParent();
            if (p.getOrientation() == 0) {
                return new Dimension(10, p.getHeight());
            }
            return new Dimension(p.getHeight(), 10);
        }
        return null;
    }
}

