/*****************************************************************************

        TransOpFilmStream.h
        Author: Laurent de Soras, 2015

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*Tab=3***********************************************************************/



#pragma once
#if ! defined (fmtcl_TransOpFilmStream_HEADER_INCLUDED)
#define	fmtcl_TransOpFilmStream_HEADER_INCLUDED

#if defined (_MSC_VER)
	#pragma warning (4 : 4250)
#endif



/*\\\ INCLUDE FILES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include "fmtcl/TransOpInterface.h"



namespace fmtcl
{



class TransOpFilmStream
:	public TransOpInterface
{

/*\\\ PUBLIC \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:

	explicit       TransOpFilmStream (bool inv_flag);
	virtual        ~TransOpFilmStream () {}

	// TransOpInterface
	virtual double operator () (double x) const;
	virtual double get_max () const { return (1.0); }



/*\\\ PROTECTED \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

protected:



/*\\\ PRIVATE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

		const bool     _inv_flag;



/*\\\ FORBIDDEN MEMBER FUNCTIONS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

	               TransOpFilmStream ()                               = delete;
	               TransOpFilmStream (const TransOpFilmStream &other) = delete;
	TransOpFilmStream &
	               operator = (const TransOpFilmStream &other)        = delete;
	bool           operator == (const TransOpFilmStream &other) const = delete;
	bool           operator != (const TransOpFilmStream &other) const = delete;

};	// class TransOpFilmStream



}	// namespace fmtcl



//#include "fmtcl/TransOpFilmStream.hpp"



#endif	// fmtcl_TransOpFilmStream_HEADER_INCLUDED



/*\\\ EOF \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
