
# :fontawesome-solid-gear:Resources

------------------------------------------------

## :fontawesome-solid-link:Links

 - Github: [github.com/Breakthrough/DVR-Scan](https://github.com/Breakthrough/DVR-Scan)
 - Discord: [discord.gg/69kf6f2Exb](https://discord.gg/69kf6f2Exb)

------------------------------------------------

## :fontawesome-solid-bug:Bug Reports

Bugs and issues with DVR-Scan are handled through [the issue tracker on Github](https://github.com/Breakthrough/DVR-Scan/issues?q=). If you encounter into any bugs while using DVR-Scan, please feel free to [create a new issue](https://github.com/Breakthrough/DVR-Scan/issues/new) describing the problem.

Make sure to set `--verbosity debug` when attaching program logs. Attach examples where possible to demonstrate the problem. Include any information you think is relevant to replicate and resolve the issue.

For technical help, you can try [starting a discussion](https://github.com/Breakthrough/DVR-Scan/discussions) on Github or joining the [DVR-Scan Discord server](https://discord.gg/69kf6f2Exb).

------------------------------------------------

## :fontawesome-solid-envelope:Contributing

DVR-Scan was created by [Brandon Castellano](https://www.bcastell.com/) and is released as completely free software. It is developed in the open on Github, where anyone can contribute to the project. [Issues and bug reports](https://github.com/Breakthrough/DVR-Scan/issues?q=) can be submitted online.  Pull requests are welcome and encouraged.

Note that DVR-Scan is released under [the BSD 2-Clause license], and submitted code must comply with this license.

------------------------------------------------

## :fontawesome-solid-plus-minus:Similar Software

The following is a list of alternative software that shares some of the functionality of DVR-Scan.  Feel free to provide suggestions for software you think should appear on this list by opening a topic in the [issue tracker](https://github.com/Breakthrough/DVR-Scan/issues) (see <a href="../../contributing/">the Contributing page</a> for details).

 - **SafeMotion** by Safeware Technologies ([link](http://www.safeware.ca/support.php)): freeware, closed source, Windows-only. Also requires OpenCV. Has options for object size, movement scale, and masking.

 - **Yawcam** by malun ([link](http://www.yawcam.com/)): freeware, closed source, Windows-only.  Requires Java.  Has options for detection level sensitivity, tolerance, and area masking.

 - **PySceneDetect** ([link](https://github.com/Breakthrough/PySceneDetect)): Program for detecting cuts in video scenes based on content detection or intensity thresholding.  Freeware, open source, cross-platform, also requires OpenCV.

## :fontawesome-regular-copyright:License & Copyright

### DVR-Scan

```md

                DVR-Scan License (BSD 2-Clause)
          < https://github.com/Breakthrough/DVR-Scan >

Copyright (C) 2016, Brandon Castellano.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    1. Redistributions of source code must retain the above copyright
       notice, this list of conditions and the following disclaimer.

    2. Redistributions in binary form must reproduce the above
       copyright notice, this list of conditions and the following
       disclaimer in the documentation and/or other materials
       provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
```

### Third-Party

DVR-Scan uses the following third-party libraries:

 * NumPy [Copyright (C) 2005, Numpy Developers]
 * OpenCV [Copyright (C) 2022, OpenCV Team]
 * FFmpeg [Copyright (C) 2001, Fabrice Bellard]
 * CUDA [Copyright (C) 2020, Nvidia Corporation]

See the `LICENSE-THIRDPARTY` file included with the distribution of DVR-Scan you are using, or run DVR-Scan with the `-L`/`--license` option for the terms under which these components are redistributed.
