/*
 * Decompiled with CFR 0.152.
 */
package bdvm.vm;

import bdvm.vm.BDVM;
import bdvm.vm.common;
import bdvm.vm.constants;
import bdvm.vm.hash_db;
import bdvm.vm.sha1;
import bdvm.vm.slots;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.util.Calendar;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class bdsvm_player_traps {
    private final BDVM vm;
    private final slots slotMemory = new slots();
    private final sha1 sha = new sha1();
    private final hash_db hashDB = new hash_db();
    public byte[] volumeID = new byte[16];
    private byte[] playerName = new byte[512];
    private byte[] playerVersion = new byte[32];
    private byte[] playerInfo = new byte[256];
    private byte[] playerBinary = new byte[65536];
    private byte[] playerUnknownArea02 = new byte[160];
    private byte[] playerUnknownArea03 = new byte[8192];
    private byte[] playerUnknownArea04 = new byte[292];
    private byte[] playerUnknownArea05 = new byte[148];
    private byte[] playerUnknownArea06 = new byte[16384];
    private byte[] playerUnknownArea07 = new byte[520];

    public bdsvm_player_traps(BDVM vm) {
        FileInputStream input1;
        File f1;
        this.vm = vm;
        try {
            File f0 = new File("volume_id.bin");
            FileInputStream input0 = new FileInputStream(f0);
            input0.read(this.volumeID);
            input0.close();
        }
        catch (FileNotFoundException fnf) {
            System.err.format("[W] No 'volume_id.bin' found! Enter VolumeID manually!\n", new Object[0]);
        }
        catch (IOException ex) {
            System.err.format("[W] Error reading 'volume_id.bin'! Enter VolumeID manually!\n", new Object[0]);
        }
        try {
            f1 = new File("player/player_executable.bin");
            input1 = new FileInputStream(f1);
            input1.read(this.playerBinary);
            input1.close();
        }
        catch (FileNotFoundException fnf) {
            System.err.format("[W] No 'player/player_executable.bin' found! TRAP_DiscoveryRAM might give wrong results!\n", new Object[0]);
        }
        catch (IOException ex) {
            System.err.format("[W] Error reading 'player/player_executable.bin'! TRAP_DiscoveryRAM might give wrong results!\n", new Object[0]);
        }
        try {
            f1 = new File("player/mem_area_02.bin");
            input1 = new FileInputStream(f1);
            input1.read(this.playerUnknownArea02);
            input1.close();
        }
        catch (FileNotFoundException fnf) {
            System.err.format("[W] No 'player/mem_area_02.bin' found! TRAP_DiscoveryRAM might give wrong results!\n", new Object[0]);
        }
        catch (IOException ex) {
            System.err.format("[W] Error reading 'player/mem_area_02.bin'! TRAP_DiscoveryRAM might give wrong results!\n", new Object[0]);
        }
        try {
            f1 = new File("player/mem_area_03.bin");
            input1 = new FileInputStream(f1);
            input1.read(this.playerUnknownArea03);
            input1.close();
        }
        catch (FileNotFoundException fnf) {
            System.err.format("[W] No 'player/mem_area_03.bin' found! TRAP_DiscoveryRAM might give wrong results!\n", new Object[0]);
        }
        catch (IOException ex) {
            System.err.format("[W] Error reading 'player/mem_area_03.bin'! TRAP_DiscoveryRAM might give wrong results!\n", new Object[0]);
        }
        try {
            f1 = new File("player/mem_area_04.bin");
            input1 = new FileInputStream(f1);
            input1.read(this.playerUnknownArea04);
            input1.close();
        }
        catch (FileNotFoundException fnf) {
            System.err.format("[W] No 'player/mem_area_04.bin' found! TRAP_DiscoveryRAM might give wrong results!\n", new Object[0]);
        }
        catch (IOException ex) {
            System.err.format("[W] Error reading 'player/mem_area_04.bin'! TRAP_DiscoveryRAM might give wrong results!\n", new Object[0]);
        }
        try {
            f1 = new File("player/mem_area_05.bin");
            input1 = new FileInputStream(f1);
            input1.read(this.playerUnknownArea05);
            input1.close();
        }
        catch (FileNotFoundException fnf) {
            System.err.format("[W] No 'player/mem_area_05.bin' found! TRAP_DiscoveryRAM might give wrong results!\n", new Object[0]);
        }
        catch (IOException ex) {
            System.err.format("[W] Error reading 'player/mem_area_05.bin'! TRAP_DiscoveryRAM might give wrong results!\n", new Object[0]);
        }
        try {
            f1 = new File("player/mem_area_07.bin");
            input1 = new FileInputStream(f1);
            input1.read(this.playerUnknownArea07);
            input1.close();
        }
        catch (FileNotFoundException fnf) {
            System.err.format("[W] No 'player/mem_area_07.bin' found! TRAP_DiscoveryRAM might give wrong results!\n", new Object[0]);
        }
        catch (IOException ex) {
            System.err.format("[W] Error reading 'player/mem_area_07.bin'! TRAP_DiscoveryRAM might give wrong results!\n", new Object[0]);
        }
        try {
            byte[] BA_unicode_playerName = "PowerDVD8".getBytes("UTF-16LE");
            byte[] BA_unicode_playerVersion = "8.0.1730.50".getBytes("UTF-16LE");
            byte[] BA_unicode_playerInfo = "".getBytes("UTF-16LE");
            System.arraycopy(BA_unicode_playerName, 0, this.playerName, 0, BA_unicode_playerName.length);
            System.arraycopy(BA_unicode_playerVersion, 0, this.playerVersion, 0, BA_unicode_playerVersion.length);
            System.arraycopy(BA_unicode_playerInfo, 0, this.playerInfo, 0, BA_unicode_playerInfo.length);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void reset() {
        this.slotMemory.clear();
        this.hashDB.clear();
    }

    public void Finished() {
        this.vm.SetTimer(4000);
        this.vm.SetProgramCounter(this.vm.ReadRegister(28));
    }

    public int getConversionTable(int len, int pTable) {
        return 0;
    }

    private byte[] AES_Encrypt(byte[] data, byte[] bkey) throws Exception {
        byte[] cipherText = new byte[16];
        SecretKeySpec key = new SecretKeySpec(bkey, "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
        cipher.init(1, key);
        cipher.doFinal(data, 0, 16, cipherText, 0);
        return cipherText;
    }

    private byte[] AES_Decrypt(byte[] data, byte[] bkey) throws Exception {
        byte[] plainText = new byte[16];
        SecretKeySpec key = new SecretKeySpec(bkey, "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
        cipher.init(2, key);
        cipher.doFinal(data, 0, 16, plainText, 0);
        return plainText;
    }

    public int AES(int pDst, int pSrc, int len, int pKey, long opOrKeyID) {
        if (opOrKeyID == common.unsigned(-983040L)) {
            try {
                byte[] bkey = this.vm.ReadMemory8(pKey, 16);
                for (int i = 0; i < len; ++i) {
                    byte[] cipherInput = this.vm.ReadMemory8(pSrc + i * 16, 16);
                    byte[] cipherOutput = this.AES_Encrypt(cipherInput, bkey);
                    this.vm.WriteMemory8(cipherOutput, pDst + i * 16, 16);
                }
                return 0;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (opOrKeyID == common.unsigned(-983039L)) {
            try {
                byte[] bkey = this.vm.ReadMemory8(pKey, 16);
                for (int i = 0; i < len; ++i) {
                    byte[] cipherInput = this.vm.ReadMemory8(pSrc + i * 16, 16);
                    byte[] cipherOutput = this.AES_Decrypt(cipherInput, bkey);
                    this.vm.WriteMemory8(cipherOutput, pDst + i * 16, 16);
                }
                return 0;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (opOrKeyID < (long)constants.AES_PLAYER_KEYS.length) {
            try {
                byte[] bkey = this.vm.ReadMemory8(pKey, 16);
                byte[] decryptedKey = this.AES_Decrypt(bkey, constants.AES_PLAYER_KEYS[(int)opOrKeyID]);
                for (int i = 0; i < len; ++i) {
                    byte[] cipherInput = this.vm.ReadMemory8(pSrc + i * 16, 16);
                    byte[] cipherOutput = this.AES_Decrypt(cipherInput, decryptedKey);
                    this.vm.WriteMemory8(cipherOutput, pDst + i * 16, 16);
                }
                return 0;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.printf("[BUG] TRAP_Aes: Decryption with player key failed\n", new Object[0]);
                return -2147483647;
            }
        }
        System.err.printf("[BUG] TRAP_Aes: Invalid key specified\n", new Object[0]);
        return -2147483647;
    }

    public int PrivateKey(int controlWord, int pDst, int pSrc, int srcLen, int keyID) {
        BigInteger pubKey_y;
        BigInteger pubKey_x;
        BigInteger privKey;
        byte[] message = new byte[srcLen + 16];
        message[0] = 66;
        message[1] = 68;
        message[2] = 83;
        message[3] = 86;
        message[4] = 77;
        message[5] = 95;
        message[6] = 80;
        message[7] = 75;
        message[11] = (byte)(controlWord & 0xFF);
        message[10] = (byte)(controlWord >> 8 & 0xFF);
        message[9] = (byte)(controlWord >> 16 & 0xFF);
        message[8] = (byte)(controlWord >> 24 & 0xFF);
        message[15] = (byte)(srcLen & 0xFF);
        message[14] = (byte)(srcLen >> 8 & 0xFF);
        message[13] = (byte)(srcLen >> 16 & 0xFF);
        message[12] = (byte)(srcLen >> 24 & 0xFF);
        byte[] data = this.vm.ReadMemory8(pSrc, srcLen);
        for (int j = 0; j < srcLen; ++j) {
            message[j + 16] = data[j];
        }
        EllipticCurve ec = new EllipticCurve(new ECFieldFp(new BigInteger("96609D9E935E52C683DBFC3A7D783EA942BDE8CB", 16)), new BigInteger("96609D9E935E52C683DBFC3A7D783EA942BDE8C8", 16), new BigInteger("3E567D8DEC27873BCF86F5FBB595DB288C62C721", 16));
        ECPoint basePointP = new ECPoint(new BigInteger("05FC5B0B2360AC50A76E1511BC5C9AF67A004D0D", 16), new BigInteger("09B0D43F319B09A5B679CCF264E1ABA4D56594EA", 16));
        ECParameterSpec ecSpec = new ECParameterSpec(ec, basePointP, new BigInteger("96609d9e935e52c683dafdc49216143f9a24373d", 16), 1);
        if (keyID == 0) {
            privKey = new BigInteger("735E0356EA6356E099AD83152E2D81EA1164A866", 16);
            pubKey_x = new BigInteger("31dbb17fea9d7d0eb8bfbb6b8d29ac938c13b599", 16);
            pubKey_y = new BigInteger("2465dd38f4214edee4da4e7f62b77a41ce962757", 16);
        } else if (keyID == 1) {
            privKey = new BigInteger("87E22D06A699EE311CD73F19B91E67414C44F4F5", 16);
            pubKey_x = new BigInteger("57305D64D1013FFFA4D72355B4C70B27A815A343", 16);
            pubKey_y = new BigInteger("05E22B42F88A5C1AC5E70DF466353BDB0A83228A", 16);
        } else {
            System.err.printf("[B] TRAP_PrivateKey: Invalid key specified\n", new Object[0]);
            return -2147483647;
        }
        ECPrivateKeySpec privKeySpec = new ECPrivateKeySpec(privKey, ecSpec);
        ECPoint PublicKeyP = new ECPoint(pubKey_x, pubKey_y);
        ECPublicKeySpec publKeySpec = new ECPublicKeySpec(PublicKeyP, ecSpec);
        try {
            Signature ecdsa = Signature.getInstance("ECDSA", "BC");
            KeyFactory fact = KeyFactory.getInstance("ECDSA", "BC");
            PrivateKey ecPrivKey = fact.generatePrivate(privKeySpec);
            PublicKey ecPublKey = fact.generatePublic(publKeySpec);
            ecdsa.initSign(ecPrivKey);
            ecdsa.update(message);
            byte[] sig = ecdsa.sign();
            int len = 0;
            int index = 3;
            len = sig[index++] & 0xFF;
            byte[] r = new byte[len];
            System.arraycopy(sig, index, r, 0, r.length);
            index = index + len + 1;
            len = sig[index++] & 0xFF;
            byte[] s = new byte[len];
            System.arraycopy(sig, index, s, 0, s.length);
            byte[] result = new byte[40];
            System.arraycopy(r, r.length > 20 ? 1 : 0, result, r.length > 20 ? 0 : 20 - r.length, r.length > 20 ? 20 : r.length);
            System.arraycopy(s, s.length > 20 ? 1 : 0, result, s.length > 20 ? 20 : 40 - s.length, s.length > 20 ? 20 : s.length);
            this.vm.WriteMemory8(result, pDst, 40);
            ecdsa.initVerify(ecPublKey);
            ecdsa.update(message);
            if (!ecdsa.verify(sig)) {
                System.err.println("[E] TRAP_PrivateKey: Signature self-check failed.");
            }
            return 0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -2147483647;
        }
    }

    public int Random(int pDst, int len) {
        if (len > 2048) {
            len = 2048;
        }
        byte[] RandBytes = new byte[len];
        Random r = new Random();
        r.nextBytes(RandBytes);
        this.vm.WriteMemory8(RandBytes, pDst, len);
        return 0;
    }

    private void SHA_writeHash(byte[] digest, int pDst) {
        this.vm.WriteMemory8(digest, pDst, 20);
    }

    private void SHA_writeContext(byte[] context, int pDst) {
        this.vm.WriteMemory8(context, pDst, 352);
    }

    public int SHA(int pDst, int pSrc, int len, int op) {
        byte[] message = this.vm.ReadMemory8(pSrc, len);
        try {
            switch (op) {
                case 0: {
                    this.sha.update(message, len);
                    this.SHA_writeContext(this.sha.getContext(), pDst);
                    break;
                }
                case 1: {
                    this.sha.init(message, len);
                    this.SHA_writeContext(this.sha.getContext(), pDst);
                    break;
                }
                case 2: {
                    this.sha.finish(message, len);
                    this.SHA_writeHash(this.sha.getHash(), pDst);
                    break;
                }
                case 3: {
                    this.sha.block(message);
                    this.SHA_writeHash(this.sha.getHash(), pDst);
                    break;
                }
                default: {
                    return -2147483647;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -2147483647;
        }
        return 0;
    }

    public int AddWithCarry(int pDst, int pSrc, int len) {
        byte[] buffer;
        byte[] op1;
        BigInteger bigint_op1;
        int length = len << 2;
        byte[] result = new byte[length];
        if (length == 0) {
            return 0;
        }
        byte[] op0 = this.vm.ReadMemory8(pDst, length);
        BigInteger bigint_op0 = new BigInteger(1, op0);
        BigInteger bigint_res = bigint_op0.add(bigint_op1 = new BigInteger(1, op1 = this.vm.ReadMemory8(pSrc, length)));
        System.arraycopy(buffer, (buffer = bigint_res.toByteArray()).length - length > 0 ? 1 : 0, result, buffer.length - length >= 0 ? 0 : length - buffer.length, buffer.length - length > 0 ? length : buffer.length);
        this.vm.WriteMemory8(result, pDst, length);
        if (buffer.length - length == 1 && buffer[0] == 1) {
            return 1;
        }
        return 0;
    }

    public int MultiplyWithRipple(int pDst, int pSrc, int len, int multiplicand) {
        byte[] buffer;
        BigInteger bigint_op1;
        int length = len << 2;
        int lenext = length + 4;
        byte[] result = new byte[length + 4];
        byte[] mult = new byte[]{(byte)(multiplicand >> 24 & 0xFF), (byte)(multiplicand >> 16 & 0xFF), (byte)(multiplicand >> 8 & 0xFF), (byte)(multiplicand & 0xFF)};
        byte[] op0 = this.vm.ReadMemory8(pSrc, length);
        BigInteger bigint_op0 = new BigInteger(1, op0);
        BigInteger bigint_res = bigint_op0.multiply(bigint_op1 = new BigInteger(1, mult));
        System.arraycopy(buffer, (buffer = bigint_res.toByteArray()).length - lenext > 0 ? 1 : 0, result, buffer.length - lenext >= 0 ? 0 : lenext - buffer.length, buffer.length - lenext > 0 ? lenext : buffer.length);
        this.vm.WriteMemory8(result, pDst, length + 4);
        return 0;
    }

    public int XorBlock(int pDst, int pSrc, int len) {
        int[] result = new int[len];
        long[] stream0 = this.vm.ReadMemory32(pSrc, len);
        long[] stream1 = this.vm.ReadMemory32(pDst, len);
        for (int i = 0; i < len; ++i) {
            result[i] = (int)(stream0[i] ^ stream1[i]);
        }
        this.vm.WriteMemory32(result, pDst, len);
        return 0;
    }

    public int MemMove(int pDst, int pSrc, int len) {
        if (pSrc == pDst || len == 0) {
            return 0;
        }
        byte[] buf = this.vm.ReadMemory8(pSrc, len);
        this.vm.WriteMemory8(buf, pDst, len);
        return 0;
    }

    public int MemSearch(int pRegion, long RegionLen, int pSearchdata, long SearchDataLen, int pDst) {
        boolean hit = false;
        byte[] srchdt = new byte[(int)SearchDataLen];
        byte[] region = new byte[(int)RegionLen];
        if (RegionLen < SearchDataLen || RegionLen == 0L || SearchDataLen == 0L) {
            this.vm.WriteMemory32(0, pDst);
            return 0;
        }
        srchdt = this.vm.ReadMemory8(pSearchdata, (int)SearchDataLen);
        region = this.vm.ReadMemory8(pRegion, (int)RegionLen);
        int offset = 0;
        do {
            hit = true;
            int i = 0;
            while ((long)i < SearchDataLen) {
                if (region[offset + i] != srchdt[i]) {
                    hit = false;
                }
                ++i;
            }
            if (hit) continue;
            ++offset;
        } while (!hit && (long)offset <= RegionLen - SearchDataLen);
        if (hit) {
            this.vm.WriteMemory32(pRegion + offset, pDst);
        } else {
            this.vm.WriteMemory32(0, pDst);
        }
        return 0;
    }

    public int MemSet(int pDst, int fillvalue, int len) {
        byte[] buffer = new byte[len];
        for (int i = 0; i < len; ++i) {
            buffer[i] = (byte)(fillvalue & 0xFF);
        }
        this.vm.WriteMemory8(buffer, pDst, len);
        return 0;
    }

    public byte[] SHA1HashBlock(byte[] message) {
        byte[] digest = new byte[20];
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.update(message);
            digest = md.digest();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return digest;
    }

    public void ResetSlotAttachStatus() {
        this.slotMemory.ResetAttachStatus();
    }

    private int allocate_new_slot() {
        this.slotMemory.AllocateNewSlot(this.volumeID);
        return 0;
    }

    public int SlotAttach(long slot, int codeLen) {
        byte[] BA_InstructionFilter = new byte[4];
        byte[] BA_ProgramCounter = new byte[4];
        byte[] digest1 = new byte[20];
        byte[] digest2 = new byte[20];
        if (slot == common.unsigned(-1L)) {
            return this.allocate_new_slot();
        }
        int ProgramCounter = this.vm.GetProgramCounter() - 4;
        int InstructionFilter = this.vm.GetInstructionFilter();
        try {
            common.int32ToByteArray(ProgramCounter, BA_ProgramCounter, 0);
            common.int32ToByteArray(InstructionFilter, BA_InstructionFilter, 0);
            byte[] BA_CodeEntryPoint = this.vm.ReadMemory8(4096, 16);
            byte[] BA_CodeToAuthenticate = this.vm.ReadMemory8(ProgramCounter, 4 * codeLen);
            byte[] buffer = new byte[24 + codeLen * 4];
            System.arraycopy(BA_ProgramCounter, 0, buffer, 0, 4);
            System.arraycopy(BA_InstructionFilter, 0, buffer, 4, 4);
            System.arraycopy(BA_CodeEntryPoint, 0, buffer, 8, 16);
            System.arraycopy(BA_CodeToAuthenticate, 0, buffer, 24, 4 * codeLen);
            digest1 = this.SHA1HashBlock(buffer);
            digest2 = this.SHA1HashBlock(digest1);
            if (this.slotMemory.Authenticate((int)slot, digest2)) {
                return 0;
            }
            return -2147483647;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -2147483647;
        }
    }

    private int GetAttachStatus(int pDst) {
        int[] status = this.slotMemory.GetAttachStatus();
        this.vm.WriteMemory32(status, pDst, 3);
        return 0;
    }

    public int SlotRead(int pDst, long slot) {
        if (slot == common.unsigned(-1L)) {
            return this.GetAttachStatus(pDst);
        }
        byte[] slotContent = this.slotMemory.ReadSlot((int)slot);
        this.vm.WriteMemory8(slotContent, pDst, 256);
        return 0;
    }

    public int SlotWrite(int pNewContents) {
        byte[] LastUpdateSequenceCounter = new byte[4];
        byte[] buffer = new byte[256];
        try {
            byte[] LastUpdateMediaID = this.volumeID;
            byte[] SlotPrivateData = this.vm.ReadMemory8(pNewContents + 32, 16);
            byte[] AttachAuthenticationHash = this.vm.ReadMemory8(pNewContents + 48, 20);
            byte[] DataPayload = this.vm.ReadMemory8(pNewContents + 76, 180);
            byte[] CreatorMediaID = this.slotMemory.ReadCreatorMediaID();
            common.int32ToByteArray(this.slotMemory.ReadUpdateSequenceCounter() + 1, LastUpdateSequenceCounter, 0);
            System.arraycopy(CreatorMediaID, 0, buffer, 0, 16);
            System.arraycopy(LastUpdateMediaID, 0, buffer, 16, 16);
            System.arraycopy(SlotPrivateData, 0, buffer, 32, 16);
            System.arraycopy(AttachAuthenticationHash, 0, buffer, 48, 20);
            System.arraycopy(LastUpdateSequenceCounter, 0, buffer, 72, 4);
            System.arraycopy(DataPayload, 0, buffer, 76, 180);
            this.slotMemory.WriteSlot(buffer);
            return 0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -2147483647;
        }
    }

    public int DeviceAccess(int dev, int opID, int pBuf) {
        System.err.printf("[W] TRAP_DeviceAccess not implemented!\n", new Object[0]);
        return 0;
    }

    public int DeviceDiscovery(int dev, int qID, int pBuf, int pLen) {
        byte[] timestamp = new byte[8];
        long length = this.vm.ReadMemory32(pLen);
        if (dev == 1) {
            switch (qID) {
                case 1: {
                    if (length < 284L) {
                        return -2147483647;
                    }
                    this.vm.WriteMemory8(constants.CERTIFICATE_1, pBuf, 284);
                    this.vm.WriteMemory32(284, pLen);
                    return 0;
                }
                case 2: {
                    if (length < 292L) {
                        return -2147483647;
                    }
                    this.vm.WriteMemory8(constants.CERTIFICATE_2, pBuf, 292);
                    this.vm.WriteMemory32(292, pLen);
                    return 0;
                }
                case 3: {
                    if (length < 60L) {
                        return -2147483647;
                    }
                    this.vm.WriteMemory8(constants.DEV_DISC3, pBuf, 60);
                    this.vm.WriteMemory8(this.volumeID, pBuf + 24, 16);
                    Calendar now = Calendar.getInstance();
                    timestamp[0] = (byte)((now.get(1) & 0xFF00) >> 8);
                    timestamp[1] = (byte)(now.get(1) & 0xFF);
                    timestamp[2] = (byte)(now.get(2) & 0xFF);
                    timestamp[3] = (byte)(now.get(5) & 0xFF);
                    timestamp[4] = (byte)(now.get(11) & 0xFF);
                    timestamp[5] = (byte)(now.get(12) & 0xFF);
                    timestamp[6] = (byte)(now.get(13) & 0xFF);
                    timestamp[7] = (byte)(now.get(14) / 10 & 0xFF);
                    this.vm.WriteMemory8(timestamp, pBuf, 8);
                    this.vm.WriteMemory32(60, pLen);
                    return 0;
                }
            }
            return -2147483647;
        }
        if (dev == 2) {
            switch (qID) {
                case 0: {
                    this.vm.WriteMemory8(constants.DEV_DISC4, pBuf, 128);
                    return 0;
                }
                case 1: {
                    this.vm.WriteMemory8(constants.DEV_DISC5, pBuf, 128);
                    return 0;
                }
            }
            return -2147483647;
        }
        return -2147483647;
    }

    private byte[] BuildVirtualPlayerMemorySection(int src, int len) {
        int address;
        int i;
        byte[] buffer = new byte[len];
        for (i = 0; i < len; ++i) {
            address = src + i & 0xFF;
            buffer[i] = constants.FREESPACE_PATTERN_LUT[address * address & 0xFF];
        }
        for (i = 0; i < len; ++i) {
            address = src + i;
            if (address >= 0 && address <= 511) {
                buffer[i] = this.playerName[address];
            }
            if (address >= 512 && address <= 543) {
                buffer[i] = this.playerVersion[address - 512];
            }
            if (address >= 544 && address <= 799) {
                buffer[i] = this.playerInfo[address - 544];
            }
            if (address >= 65536 && address <= 131071) {
                buffer[i] = this.playerBinary[address - 65536];
            }
            if (address >= 0x100000 && address <= 1048735) {
                buffer[i] = this.playerUnknownArea02[address - 0x100000];
            }
            if (address >= 0x200000 && address <= 2105343) {
                buffer[i] = this.playerUnknownArea03[address - 0x200000];
            }
            if (address >= 0x250000 && address <= 0x28FFFF) {
                int n = i;
                buffer[n] = (byte)(buffer[n] ^ 3 * address * address + 1 & 0xFF);
            }
            if (address >= 0x290000 && address <= 2687267) {
                buffer[i] = this.playerUnknownArea04[address - 0x290000];
            }
            if (address >= 0x290200 && address <= 2687635) {
                buffer[i] = this.playerUnknownArea05[address - 0x290200];
            }
            if (address >= 0x300000 && address <= 0x303FFF) {
                buffer[i] = this.playerUnknownArea06[address - 0x300000];
            }
            if (address < 0x304000 || address > 3162631) continue;
            buffer[i] = this.playerUnknownArea07[address - 0x304000];
        }
        return buffer;
    }

    public int DiscoveryRAM(int src, int pDst, int len) {
        byte[] VirtualPlayerMemorySection = this.BuildVirtualPlayerMemorySection(src, len);
        this.vm.WriteMemory8(VirtualPlayerMemorySection, pDst, len);
        return 0;
    }

    private void load_file(String filename, int len, int seek, int pDst) throws Exception {
        byte[] buffer = new byte[len];
        File f = new File(this.vm.getMountpoint(), new String("BDSVM/") + filename);
        FileInputStream input = new FileInputStream(f);
        input.skip(seek);
        input.read(buffer);
        input.close();
        this.vm.WriteMemory8(buffer, pDst, len);
    }

    public int LoadContentCode(int pFileName, int block, int offset, int pLen, int pDst) {
        byte[] BA_ContentCode = this.vm.ReadMemory8(pFileName, 5);
        String Filename = new String(BA_ContentCode);
        System.err.format("[I] TRAP_LoadContentCode: Loading BDSVM/%s.svm (block %d)\n", Filename, block);
        int length = (int)this.vm.ReadMemory32(pLen);
        try {
            this.load_file(Filename + ".svm", length, block * 0x200000 + 24 + offset, pDst);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return 0;
    }

    public int MediaSHAFileHash(int pFileName, int FileNameLen, long FileOffsetHigh, long FileOffsetLow, int pLen, int pDst) {
        byte[] sbuf = new byte[512];
        byte[] digest = new byte[20];
        String fn = "";
        byte[] BA_FileName = this.vm.ReadMemory8(pFileName, FileNameLen);
        String Filename = new String(BA_FileName);
        System.err.printf("[I] TRAP_MediaSHAFileHash: Hashing %s\n", Filename);
        long offset = FileOffsetHigh << 32 | FileOffsetLow;
        int length = (int)this.vm.ReadMemory32(pLen);
        byte[] readBuffer = new byte[length];
        try {
            File f = new File(this.vm.getMountpoint(), Filename);
            FileInputStream input = new FileInputStream(f);
            input.skip(offset);
            int bytesRead = input.read(readBuffer);
            input.close();
            int bytesHashed = 0;
            for (int i = 0; i < bytesRead / 512; ++i) {
                System.arraycopy(readBuffer, i * 512, sbuf, 0, 512);
                digest = this.SHA1HashBlock(sbuf);
                this.vm.WriteMemory8(digest, pDst + 20 * i, 20);
                bytesHashed += 512;
            }
            this.vm.WriteMemory32(bytesHashed, pLen);
            try {
                int hashArrayLength = bytesHashed / 512 * 20;
                byte[] hashArray = new byte[hashArrayLength];
                hashArray = this.vm.ReadMemory8(pDst, hashArrayLength);
                this.hashDB.Store(BA_FileName, offset, length, bytesHashed, hashArray);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception ex) {
            System.err.printf("[I] Failed to hash file! Using hash database.\n", new Object[0]);
            byte[] hashArray = this.hashDB.Load(BA_FileName, offset, length);
            if (hashArray != null) {
                for (int i = 0; i < hashArray.length; ++i) {
                    System.err.format("%02X ", hashArray[i]);
                }
                System.err.format("\n", new Object[0]);
                this.vm.WriteMemory8(hashArray, pDst, hashArray.length);
                int bytesHashed = hashArray.length / 20 * 512;
                this.vm.WriteMemory32(bytesHashed, pLen);
            }
            System.err.printf("[W] No matching entry in hash database! Return is bad. \n", new Object[0]);
        }
        return 0;
    }

    public int RunNative(int pSignature, int sigLen, int pCode, int codeLen) {
        System.err.printf("[W] TRAP_RunNative not implemented!\n", new Object[0]);
        return -2147483647;
    }

    public int DebugLog(int src, int len) {
        byte[] BA_message = this.vm.ReadMemory8(src, len);
        String message = new String(BA_message);
        System.err.printf("[I] TRAP_DebugLog: %s", message);
        return -2130706433;
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
    }
}

