/*
 * Decompiled with CFR 0.152.
 */
package bdvm.vm;

import bdvm.vm.BDVM;
import bdvm.vm.bdsvm_player_traps;
import bdvm.vm.common;
import bdvm.vm.constants;
import bdvm.vm.conv_tab_main;
import bdvm.vm.decoder;

public class bdsvm_player_interface {
    private final BDVM vm;
    private final bdsvm_player_traps trap;
    private final decoder decode;
    private int NumberOfTrapCalls = 0;
    private int NumberOfInterruptions = 0;

    public bdsvm_player_interface(BDVM vm) {
        this.vm = vm;
        this.trap = new bdsvm_player_traps(vm);
        this.decode = new decoder(vm);
    }

    private int PC_TRAP_GetConversionTable(long P0, long P1) {
        if (P1 >= 0x400000L) {
            return -2147483647;
        }
        if (P0 + P1 > 0x400000L) {
            return -2147483647;
        }
        if ((P1 & 3L) != 0L) {
            return -2147483647;
        }
        if (P0 > 0x100000L) {
            return -2147483646;
        }
        return 0;
    }

    private int PC_TRAP_Aes(long dst, long src, long len, long key, long opOrKeyID) {
        if (dst >= 0x400000L) {
            return -2147483647;
        }
        if (dst + 16L * len > 0x400000L) {
            return -2147483647;
        }
        if (src >= 0x400000L) {
            return -2147483647;
        }
        if (src + 16L * len > 0x400000L) {
            return -2147483647;
        }
        if (key >= 0x400000L) {
            return -2147483647;
        }
        if (key + 16L > 0x400000L) {
            return -2147483647;
        }
        if (dst + 16L * len > src && dst < src + 16L * len && dst != src) {
            return -2147483647;
        }
        if (opOrKeyID > common.unsigned(-983039L)) {
            return -2147483647;
        }
        if (opOrKeyID < common.unsigned(-983040L) && opOrKeyID > 6L) {
            return -2147483647;
        }
        return 0;
    }

    private int PC_TRAP_PrivateKey(long controlWord, long dst, long src, long srcLen, long keyID) {
        if (dst >= 0x400000L) {
            return -2147483647;
        }
        if (dst + 40L >= 0x400000L) {
            return -2147483647;
        }
        if (src >= 0x400000L) {
            return -2147483647;
        }
        if (src + srcLen >= 0x400000L) {
            return -2147483647;
        }
        if (dst < src) {
            return -2147483647;
        }
        if (keyID > 1L) {
            return -2147483647;
        }
        return 0;
    }

    private int PC_TRAP_Random(long dst, long len) {
        if (dst >= 0x400000L) {
            return -2147483647;
        }
        if (dst + len > 0x400000L) {
            return -2147483647;
        }
        return 0;
    }

    private int PC_TRAP_SHA(long dst, long src, long len, long op) {
        if (src >= 0x400000L) {
            return -2147483647;
        }
        if (src + len > 0x400000L) {
            return -2147483647;
        }
        if (dst >= 0x400000L) {
            return -2147483647;
        }
        if (dst + 512L > 0x400000L) {
            return -2147483647;
        }
        if ((dst & 3L) != 0L) {
            return -2147483647;
        }
        if (op > 3L) {
            return -2147483647;
        }
        if (dst + 512L > src && dst < src + len) {
            return -2147483647;
        }
        return 0;
    }

    private int PC_TRAP_AddWithCarry(long dst, long src, long len) {
        if (dst >= 0x400000L) {
            return -2147483647;
        }
        if (dst + 4L * len > 0x400000L) {
            return -2147483647;
        }
        if ((dst & 3L) != 0L) {
            return -2147483647;
        }
        if (src >= 0x400000L) {
            return -2147483647;
        }
        if (src + 4L * len > 0x400000L) {
            return -2147483647;
        }
        if ((src & 3L) != 0L) {
            return -2147483647;
        }
        if (src < dst + 4L * len && src + 4L * len > dst && src != dst) {
            return -2147483647;
        }
        return 0;
    }

    private int PC_TRAP_MultiplyWithRipple(long dst, long src, long len, long multiplicand) {
        if (dst >= 0x400000L) {
            return -2147483647;
        }
        if (dst + 4L * len + 4L > 0x400000L) {
            return -2147483647;
        }
        if ((dst & 3L) != 0L) {
            return -2147483647;
        }
        if (src >= 0x400000L) {
            return -2147483647;
        }
        if (src + 4L * len > 0x400000L) {
            return -2147483647;
        }
        if ((src & 3L) != 0L) {
            return -2147483647;
        }
        if (dst + 4L * len + 4L > src && dst < src + 4L * len) {
            return -2147483647;
        }
        return 0;
    }

    private int PC_TRAP_XorBlock(long dst, long src, long len) {
        if (dst >= 0x400000L) {
            return -2147483647;
        }
        if (dst + 4L * len > 0x400000L) {
            return -2147483647;
        }
        if ((dst & 3L) != 0L) {
            return -2147483647;
        }
        if (src >= 0x400000L) {
            return -2147483647;
        }
        if (src + 4L * len > 0x400000L) {
            return -2147483647;
        }
        if ((src & 3L) != 0L) {
            return -2147483647;
        }
        if (dst + 4L * len > src && dst < src + 4L * len) {
            return -2147483647;
        }
        return 0;
    }

    private int PC_TRAP_MemMove(long dst, long src, long len) {
        if (dst >= 0x400000L) {
            return -2147483647;
        }
        if (dst + len > 0x400000L) {
            return -2147483647;
        }
        if (src >= 0x400000L) {
            return -2147483647;
        }
        if (src + len > 0x400000L) {
            return -2147483647;
        }
        return 0;
    }

    private int PC_TRAP_MemSearch(long region, long RegionLen, long SearchData, long SearchDataLen, long dst) {
        if (region >= 0x400000L) {
            return -2147483647;
        }
        if (region + RegionLen > 0x400000L) {
            return -2147483647;
        }
        if (SearchData >= 0x400000L) {
            return -2147483647;
        }
        if (SearchData + SearchDataLen >= 0x400000L) {
            return -2147483647;
        }
        if (dst >= 0x400000L) {
            return -2147483647;
        }
        if (dst + 4L >= 0x400000L) {
            return -2147483647;
        }
        if ((dst & 3L) != 0L) {
            return -2147483647;
        }
        return 0;
    }

    private int PC_TRAP_MemSet(long dst, long fillvalue, long len) {
        if (dst >= 0x400000L) {
            return -2147483647;
        }
        if (dst + len > 0x400000L) {
            return -2147483647;
        }
        return 0;
    }

    private int PC_TRAP_SlotAttach(long slot, long codeLen) {
        int PC = this.vm.GetProgramCounter();
        if (slot == common.unsigned(-1L)) {
            return 0;
        }
        if (common.unsigned(PC - 4) >= 0x400000L) {
            return -2147483647;
        }
        if (common.unsigned((long)(PC - 4) + 4L * codeLen) >= 0x400000L) {
            return -2147483647;
        }
        if ((PC & 3) != 0) {
            return -2147483647;
        }
        if (slot >= 500L) {
            return -2147483647;
        }
        return 0;
    }

    private int PC_TRAP_SlotRead(long dst, long slot) {
        if (slot == common.unsigned(-1L)) {
            if (dst >= 0x400000L) {
                return -2147483647;
            }
            if (dst + 12L >= 0x400000L) {
                return -2147483647;
            }
            return 0;
        }
        if (dst >= 0x400000L) {
            return -2147483647;
        }
        if (dst + 256L >= 0x400000L) {
            return -2147483647;
        }
        if (slot >= 500L) {
            return -2147483647;
        }
        return 0;
    }

    private int PC_TRAP_SlotWrite(long newContents) {
        if (newContents >= 0x400000L) {
            return -2147483647;
        }
        if (newContents + 256L >= 0x400000L) {
            return -2147483647;
        }
        return 0;
    }

    private int PC_TRAP_DeviceAccess(long dev, long opID, long buf) {
        if (buf >= 0x400000L) {
            return -2147483647;
        }
        if (buf + 4L > 0x400000L) {
            return -2147483647;
        }
        if ((buf & 3L) != 0L) {
            return -2147483647;
        }
        if (dev >= 3L) {
            return -2147483647;
        }
        if (opID > 1L) {
            return -2147483647;
        }
        if (dev == 1L & opID == 1L) {
            return -2147483647;
        }
        return 0;
    }

    private int PC_TRAP_DeviceDiscovery(long dev, long qID, long buf, long len) {
        if (len >= 0x400000L) {
            return -2147483647;
        }
        if (len + 4L > 0x400000L) {
            return -2147483647;
        }
        if ((len & 3L) != 0L) {
            return -2147483647;
        }
        long length = this.vm.ReadMemory32((int)len);
        if (buf >= 0x400000L) {
            return -2147483647;
        }
        if (buf + length > 0x400000L) {
            return -2147483647;
        }
        if ((buf & 3L) != 0L) {
            return -2147483647;
        }
        if (dev != 1L && dev != 2L) {
            return -2147483647;
        }
        if (dev == 1L && qID != 1L && qID != 2L && qID != 3L) {
            return -2147483647;
        }
        if (dev == 2L && qID != 0L && qID != 1L) {
            return -2147483646;
        }
        return 0;
    }

    private int PC_TRAP_DiscoveryRAM(long src, long dst, long len) {
        long x1 = 0L;
        long x2 = 0x400000L;
        if (len > 0x100000L) {
            return -2147483646;
        }
        if (x1 > 0L) {
            return -2147483647;
        }
        if (src >= x2) {
            return -2147483647;
        }
        if (src + len > common.unsigned(-1L)) {
            return -2147483647;
        }
        if (src + len > x2) {
            return -2147483647;
        }
        if (dst >= 0x400000L) {
            return -2147483647;
        }
        if (dst + len > 0x400000L) {
            return -2147483647;
        }
        return 0;
    }

    private int PC_TRAP_LoadContentCode(long ContentCode, long block, long offset, long len, long dst) {
        if (len >= 0x400000L) {
            return -2147483647;
        }
        if (len + 4L > 0x400000L) {
            return -2147483647;
        }
        if ((len & 3L) != 0L) {
            return -2147483647;
        }
        if (ContentCode >= 0x400000L) {
            return -2147483647;
        }
        if (ContentCode + 5L >= 0x400000L) {
            return -2147483647;
        }
        return 0;
    }

    private int PC_TRAP_MediaSHAFileHash(long FileName, long FileNameLen, long FileOffsetHigh, long FileOffsetLow, long len, long dst) {
        long x = 0L;
        if (x != 0L) {
            return -2130706433;
        }
        if (len >= 0x400000L) {
            return -2147483647;
        }
        if (len + 4L > 0x400000L) {
            return -2147483647;
        }
        if ((len & 3L) != 0L) {
            return -2147483647;
        }
        long[] mem = this.vm.ReadMemory32((int)len, 1);
        long length = mem[0];
        if (length > 0x200000L) {
            return -2147483646;
        }
        if (length % 512L != 0L) {
            return -2147483647;
        }
        if (dst >= 0x400000L) {
            return -2147483647;
        }
        if (dst + 20L * (length >> 9) > 0x400000L) {
            return -2147483647;
        }
        if (FileName >= 0x400000L) {
            return -2147483647;
        }
        if (FileName + FileNameLen >= 0x400000L) {
            return -2147483647;
        }
        if (FileNameLen == 0L) {
            return -2147483647;
        }
        if (FileNameLen > 1024L) {
            return -2147483647;
        }
        return 0;
    }

    private int PC_TRAP_RunNative(long signature, long sigLen, long code, long codeLen) {
        long x = 40L;
        if (code >= 0x400000L) {
            return -2147483647;
        }
        if (code + codeLen > 0x400000L) {
            return -2147483647;
        }
        if (signature >= 0x400000L) {
            return -2147483647;
        }
        if (signature + sigLen > 0x400000L) {
            return -2147483647;
        }
        if (sigLen == 0L) {
            return -2147483647;
        }
        if (sigLen > 0x100000L) {
            return -2147483646;
        }
        if (sigLen > x) {
            return -2147483646;
        }
        return 0;
    }

    private int PC_TRAP_DebugLog(long src, long len) {
        if (src >= 0x400000L) {
            return -2147483647;
        }
        if (src + len > 0x400000L) {
            return -2147483647;
        }
        return 0;
    }

    public void TRAP_handler(int trapID) {
        int status = 0;
        int trapReturnValue = 0;
        int TrapParamCount = constants.getTrapParamCount(trapID);
        long[] args = this.vm.ReadMemory32(this.vm.ReadRegister(29), TrapParamCount);
        ++this.NumberOfTrapCalls;
        switch (trapID) {
            case 16: {
                this.decode.ContentCodeFinished();
                this.trap.Finished();
                break;
            }
            case 32: {
                status = this.PC_TRAP_GetConversionTable(args[0], args[1]);
                if (status == 0) {
                    this.decode.getConversionTable((int)args[0], (int)args[1]);
                    trapReturnValue = this.trap.getConversionTable((int)args[0], (int)args[1]);
                    break;
                }
                trapReturnValue = status;
                break;
            }
            case 272: {
                status = this.PC_TRAP_Aes(args[0], args[1], args[2], args[3], args[4]);
                if (status == 0) {
                    trapReturnValue = this.trap.AES((int)args[0], (int)args[1], (int)args[2], (int)args[3], args[4]);
                    break;
                }
                trapReturnValue = status;
                break;
            }
            case 288: {
                status = this.PC_TRAP_PrivateKey(args[0], args[1], args[2], args[3], args[4]);
                if (status == 0) {
                    trapReturnValue = this.trap.PrivateKey((int)args[0], (int)args[1], (int)args[2], (int)args[3], (int)args[4]);
                    break;
                }
                trapReturnValue = status;
                break;
            }
            case 304: {
                status = this.PC_TRAP_Random(args[0], args[1]);
                if (status == 0) {
                    trapReturnValue = this.trap.Random((int)args[0], (int)args[1]);
                    break;
                }
                trapReturnValue = status;
                break;
            }
            case 320: {
                status = this.PC_TRAP_SHA(args[0], args[1], args[2], args[3]);
                if (status == 0) {
                    trapReturnValue = this.trap.SHA((int)args[0], (int)args[1], (int)args[2], (int)args[3]);
                    break;
                }
                trapReturnValue = status;
                break;
            }
            case 528: {
                status = this.PC_TRAP_AddWithCarry(args[0], args[1], args[2]);
                if (status == 0) {
                    trapReturnValue = this.trap.AddWithCarry((int)args[0], (int)args[1], (int)args[2]);
                    break;
                }
                trapReturnValue = status;
                break;
            }
            case 544: {
                status = this.PC_TRAP_MultiplyWithRipple(args[0], args[1], args[2], args[3]);
                if (status == 0) {
                    trapReturnValue = this.trap.MultiplyWithRipple((int)args[0], (int)args[1], (int)args[2], (int)args[3]);
                    break;
                }
                trapReturnValue = status;
                break;
            }
            case 560: {
                status = this.PC_TRAP_XorBlock(args[0], args[1], args[2]);
                if (status == 0) {
                    trapReturnValue = this.trap.XorBlock((int)args[0], (int)args[1], (int)args[2]);
                    break;
                }
                trapReturnValue = status;
                break;
            }
            case 784: {
                status = this.PC_TRAP_MemMove(args[0], args[1], args[2]);
                if (status == 0) {
                    trapReturnValue = this.trap.MemMove((int)args[0], (int)args[1], (int)args[2]);
                    break;
                }
                trapReturnValue = status;
                break;
            }
            case 800: {
                status = this.PC_TRAP_MemSearch(args[0], args[1], args[2], args[3], args[4]);
                if (status == 0) {
                    trapReturnValue = this.trap.MemSearch((int)args[0], args[1], (int)args[2], args[3], (int)args[4]);
                    break;
                }
                trapReturnValue = status;
                break;
            }
            case 816: {
                status = this.PC_TRAP_MemSet(args[0], args[1], args[2]);
                if (status == 0) {
                    trapReturnValue = this.trap.MemSet((int)args[0], (int)args[1], (int)args[2]);
                    break;
                }
                trapReturnValue = status;
                break;
            }
            case 1040: {
                this.trap.ResetSlotAttachStatus();
                status = this.PC_TRAP_SlotAttach(args[0], args[1]);
                if (status == 0) {
                    trapReturnValue = this.trap.SlotAttach(args[0], (int)args[1]);
                    break;
                }
                trapReturnValue = status;
                break;
            }
            case 1056: {
                status = this.PC_TRAP_SlotRead(args[0], args[1]);
                if (status == 0) {
                    trapReturnValue = this.trap.SlotRead((int)args[0], args[1]);
                    break;
                }
                trapReturnValue = status;
                break;
            }
            case 1072: {
                status = this.PC_TRAP_SlotWrite(args[0]);
                if (status == 0) {
                    trapReturnValue = this.trap.SlotWrite((int)args[0]);
                    break;
                }
                trapReturnValue = status;
                break;
            }
            case 1296: {
                status = this.PC_TRAP_DeviceAccess(args[0], args[1], args[2]);
                if (status == 0) {
                    trapReturnValue = this.trap.DeviceAccess((int)args[0], (int)args[1], (int)args[2]);
                    break;
                }
                trapReturnValue = status;
                break;
            }
            case 1312: {
                status = this.PC_TRAP_DeviceDiscovery(args[0], args[1], args[2], args[3]);
                if (status == 0) {
                    trapReturnValue = this.trap.DeviceDiscovery((int)args[0], (int)args[1], (int)args[2], (int)args[3]);
                    break;
                }
                trapReturnValue = status;
                break;
            }
            case 1328: {
                status = this.PC_TRAP_DiscoveryRAM(args[0], args[1], args[2]);
                if (status == 0) {
                    trapReturnValue = this.trap.DiscoveryRAM((int)args[0], (int)args[1], (int)args[2]);
                    break;
                }
                trapReturnValue = status;
                break;
            }
            case 1344: {
                status = this.PC_TRAP_LoadContentCode(args[0], args[1], args[2], args[3], args[4]);
                if (status == 0) {
                    trapReturnValue = this.trap.LoadContentCode((int)args[0], (int)args[1], (int)args[2], (int)args[3], (int)args[4]);
                    break;
                }
                trapReturnValue = status;
                break;
            }
            case 1360: {
                status = this.PC_TRAP_MediaSHAFileHash(args[0], args[1], args[2], args[3], args[4], args[5]);
                if (status == 0) {
                    trapReturnValue = this.trap.MediaSHAFileHash((int)args[0], (int)args[1], args[2], args[3], (int)args[4], (int)args[5]);
                    break;
                }
                trapReturnValue = status;
                break;
            }
            case 1376: {
                status = this.PC_TRAP_RunNative(args[0], args[1], args[2], args[3]);
                if (status == 0) {
                    trapReturnValue = this.trap.RunNative((int)args[0], (int)args[1], (int)args[2], (int)args[3]);
                    break;
                }
                trapReturnValue = status;
                break;
            }
            case 1392: {
                trapReturnValue = -2147483647;
                System.err.printf("[W] Dummy TRAP#%06X called!\n", trapID);
                break;
            }
            case 32784: {
                status = this.PC_TRAP_DebugLog(args[0], args[1]);
                if (status == 0) {
                    trapReturnValue = this.trap.DebugLog((int)args[0], (int)args[1]);
                    break;
                }
                trapReturnValue = status;
                break;
            }
            default: {
                System.err.printf("[W] unknown TRAP#%06X called!\n", trapID);
                trapReturnValue = -2130706433;
            }
        }
        if (trapID != 16) {
            this.vm.setTrapReturnValue(trapReturnValue);
        }
    }

    public void GetEvent() {
        ++this.NumberOfInterruptions;
        this.decode.generateEvent();
    }

    public int getTrapCount() {
        return this.NumberOfTrapCalls;
    }

    public int getEventCount() {
        return this.NumberOfInterruptions;
    }

    public void reset() {
        this.NumberOfTrapCalls = 0;
        this.NumberOfInterruptions = 0;
        this.trap.reset();
        this.decode.reset();
    }

    public void setVolumeId(byte[] vid, int offset) {
        System.arraycopy(vid, offset, this.trap.volumeID, 0, 16);
    }

    public conv_tab_main getConvTab() {
        return this.decode.getConvTab();
    }
}

