/*
 * Decompiled with CFR 0.152.
 */
package deadbeef.SupTools;

import deadbeef.SupTools.Bitmap;
import deadbeef.SupTools.BitmapBounds;
import deadbeef.SupTools.Core;
import deadbeef.SupTools.CoreException;
import deadbeef.SupTools.ImageObjectFragment;
import deadbeef.SupTools.Palette;
import deadbeef.SupTools.SubDVD;
import deadbeef.SupTools.SubPicture;
import deadbeef.SupTools.SubPictureDVD;
import deadbeef.SupTools.Substream;
import deadbeef.SupTools.SubstreamDVD;
import deadbeef.Tools.FileBuffer;
import deadbeef.Tools.FileBufferException;
import deadbeef.Tools.ToolBox;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;

class SupDVD
implements Substream,
SubstreamDVD {
    private final ArrayList<SubPictureDVD> subPictures;
    private Palette srcPalette = new Palette(Core.getDefaultDVDPalette());
    private Palette palette;
    private Bitmap bitmap;
    private int screenWidth = 720;
    private int screenHeight = 576;
    private int ofsXglob = 0;
    private int ofsYglob = 0;
    private int delayGlob = 0;
    private int languageIdx = 0;
    private final FileBuffer buffer;
    private int primaryColorIndex;
    private int numForcedFrames;
    private static int[] lastAlpha;
    private static byte[] IFOheader;
    private static byte[] controlHeader;

    static {
        int[] nArray = new int[4];
        nArray[1] = 15;
        nArray[2] = 15;
        nArray[3] = 15;
        lastAlpha = nArray;
        IFOheader = new byte[]{68, 86, 68, 86, 73, 68, 69, 79, 45, 86, 84, 83};
        byte[] byArray = new byte[29];
        byArray[3] = 1;
        byArray[4] = 3;
        byArray[5] = 50;
        byArray[6] = 16;
        byArray[7] = 4;
        byArray[8] = -1;
        byArray[9] = -1;
        byArray[10] = 5;
        byArray[17] = 6;
        byArray[22] = -1;
        byArray[27] = 2;
        byArray[28] = -1;
        controlHeader = byArray;
    }

    SupDVD(String fnSup, String fnIfo) throws CoreException {
        this.subPictures = new ArrayList();
        this.readIFO(fnIfo);
        try {
            long ofs = 0L;
            this.buffer = new FileBuffer(fnSup);
            long size = this.buffer.getSize();
            Core.setProgressMax((int)size);
            int i = 0;
            do {
                Core.printX("# " + ++i + "\n");
                Core.setProgress((int)ofs);
                Core.print("Ofs: " + ToolBox.hex(ofs, 8) + "\n");
            } while ((ofs = this.readSupFrame(ofs, this.buffer)) < size);
        }
        catch (FileBufferException e) {
            throw new CoreException(e.getMessage());
        }
        Core.printX("\nDetected " + this.numForcedFrames + " forced captions.\n");
    }

    static byte[] createSupFrame(SubPictureDVD pic, Bitmap bm) {
        int controlHeaderLen;
        int forcedOfs;
        byte[] even = SubDVD.encodeLines(bm, true);
        byte[] odd = SubDVD.encodeLines(bm, false);
        if (pic.isforced) {
            forcedOfs = 0;
            SupDVD.controlHeader[2] = 1;
            SupDVD.controlHeader[3] = 0;
            controlHeaderLen = controlHeader.length;
        } else {
            forcedOfs = 1;
            SupDVD.controlHeader[2] = 0;
            SupDVD.controlHeader[3] = 1;
            controlHeaderLen = controlHeader.length - 1;
        }
        int sizeRLE = even.length + odd.length;
        int bufSize = 14 + controlHeaderLen + sizeRLE;
        byte[] buf = new byte[bufSize];
        buf[0] = 83;
        buf[1] = 80;
        int pts = (int)pic.startTime;
        buf[5] = (byte)(pts >> 24);
        buf[4] = (byte)(pts >> 16);
        buf[3] = (byte)(pts >> 8);
        buf[2] = (byte)pts;
        int tmp = controlHeaderLen + sizeRLE + 4;
        buf[10] = (byte)(tmp >> 8);
        buf[11] = (byte)tmp;
        tmp = sizeRLE + 2;
        buf[12] = (byte)(tmp >> 8);
        buf[13] = (byte)tmp;
        int ofs = 14;
        int i = 0;
        while (i < even.length) {
            buf[ofs++] = even[i];
            ++i;
        }
        i = 0;
        while (i < odd.length) {
            buf[ofs++] = odd[i];
            ++i;
        }
        SupDVD.controlHeader[5] = (byte)((pic.pal[3] & 0xF) << 4 | pic.pal[2] & 0xF);
        SupDVD.controlHeader[6] = (byte)((pic.pal[1] & 0xF) << 4 | pic.pal[0] & 0xF);
        SupDVD.controlHeader[8] = (byte)((pic.alpha[3] & 0xF) << 4 | pic.alpha[2] & 0xF);
        SupDVD.controlHeader[9] = (byte)((pic.alpha[1] & 0xF) << 4 | pic.alpha[0] & 0xF);
        SupDVD.controlHeader[11] = (byte)(pic.getOfsX() >> 4 & 0xFF);
        tmp = pic.getOfsX() + bm.getWidth() - 1;
        SupDVD.controlHeader[12] = (byte)((pic.getOfsX() & 0xF) << 4 | tmp >> 8 & 0xF);
        SupDVD.controlHeader[13] = (byte)(tmp & 0xFF);
        int yOfs = pic.getOfsY() - Core.getCropOfsY();
        if (yOfs < 0) {
            yOfs = 0;
        } else {
            int yMax = pic.height - pic.getImageHeight() - 2 * Core.getCropOfsY();
            if (yOfs > yMax) {
                yOfs = yMax;
            }
        }
        SupDVD.controlHeader[14] = (byte)(yOfs >> 4 & 0xFF);
        tmp = yOfs + bm.getHeight() - 1;
        SupDVD.controlHeader[15] = (byte)((yOfs & 0xF) << 4 | tmp >> 8 & 0xF);
        SupDVD.controlHeader[16] = (byte)(tmp & 0xFF);
        SupDVD.controlHeader[18] = 0;
        SupDVD.controlHeader[19] = 4;
        tmp = even.length + controlHeader[19];
        SupDVD.controlHeader[20] = (byte)(tmp >> 8 & 0xFF);
        SupDVD.controlHeader[21] = (byte)(tmp & 0xFF);
        tmp = (int)((pic.endTime - pic.startTime) / 1024L);
        SupDVD.controlHeader[23] = (byte)(tmp >> 8 & 0xFF);
        SupDVD.controlHeader[24] = (byte)(tmp & 0xFF);
        tmp = sizeRLE + 22 + (pic.isforced ? 1 : 0) + 4;
        SupDVD.controlHeader[forcedOfs + 0] = (byte)(tmp >> 8 & 0xFF);
        SupDVD.controlHeader[forcedOfs + 1] = (byte)(tmp & 0xFF);
        SupDVD.controlHeader[25] = (byte)(tmp >> 8 & 0xFF);
        SupDVD.controlHeader[26] = (byte)(tmp & 0xFF);
        int i2 = 0;
        while (i2 < controlHeaderLen) {
            buf[ofs++] = controlHeader[forcedOfs + i2];
            ++i2;
        }
        return buf;
    }

    long readSupFrame(long ofs, FileBuffer buffer) throws CoreException {
        long ctrlOfs = -1L;
        int ctrlOfsRel = 0;
        int rleSize = 0;
        int ctrlSize = -1;
        byte[] ctrlHeader = null;
        try {
            long startOfs = ofs;
            if (buffer.getWord(ofs) != 21328) {
                throw new CoreException("Missing packet identifier at ofs " + ToolBox.hex(ofs, 8));
            }
            SubPictureDVD pic = new SubPictureDVD();
            pic.offset = ofs;
            pic.width = this.screenWidth;
            pic.height = this.screenHeight;
            int pts = buffer.getDWordLE(ofs += 2L);
            pic.startTime = pts + this.delayGlob;
            int length = buffer.getWord(ofs += 8L);
            ctrlOfsRel = buffer.getWord(ofs += 2L);
            rleSize = ctrlOfsRel - 2;
            ctrlSize = length - ctrlOfsRel - 2;
            if (ctrlSize < 0) {
                throw new CoreException("Invalid control buffer size");
            }
            ctrlOfs = (long)ctrlOfsRel + ofs;
            pic.rleFragments = new ArrayList(1);
            ImageObjectFragment rleFrag = new ImageObjectFragment();
            rleFrag.imageBufferOfs = ofs += 2L;
            rleFrag.imagePacketSize = rleSize;
            pic.rleFragments.add(rleFrag);
            pic.rleSize = rleSize;
            pic.pal = new int[4];
            pic.alpha = new int[4];
            int alphaSum = 0;
            int[] alphaUpdate = new int[4];
            int delay = -1;
            boolean ColAlphaUpdate = false;
            Core.print("SP_DCSQT at ofs: " + ToolBox.hex(ctrlOfs, 8) + "\n");
            ctrlHeader = new byte[ctrlSize];
            int i = 0;
            while (i < ctrlSize) {
                ctrlHeader[i] = (byte)buffer.getByte(ctrlOfs + (long)i);
                ++i;
            }
            try {
                int index = 0;
                int endSeqOfs = ToolBox.getWord(ctrlHeader, index) - ctrlOfsRel - 2;
                if (endSeqOfs < 0 || endSeqOfs > ctrlSize) {
                    Core.printWarn("Invalid end sequence offset -> no end time\n");
                    endSeqOfs = ctrlSize;
                }
                index += 2;
                block15: while (index < endSeqOfs) {
                    int cmd = ToolBox.getByte(ctrlHeader, index++);
                    switch (cmd) {
                        case 0: {
                            pic.isforced = true;
                            ++this.numForcedFrames;
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 3: {
                            int b = ToolBox.getByte(ctrlHeader, index++);
                            pic.pal[3] = b >> 4;
                            pic.pal[2] = b & 0xF;
                            b = ToolBox.getByte(ctrlHeader, index++);
                            pic.pal[1] = b >> 4;
                            pic.pal[0] = b & 0xF;
                            Core.print("Palette:   " + pic.pal[0] + ", " + pic.pal[1] + ", " + pic.pal[2] + ", " + pic.pal[3] + "\n");
                            break;
                        }
                        case 4: {
                            int b = ToolBox.getByte(ctrlHeader, index++);
                            pic.alpha[3] = b >> 4;
                            pic.alpha[2] = b & 0xF;
                            b = ToolBox.getByte(ctrlHeader, index++);
                            pic.alpha[1] = b >> 4;
                            pic.alpha[0] = b & 0xF;
                            int i2 = 0;
                            while (i2 < 4) {
                                alphaSum += pic.alpha[i2] & 0xFF;
                                ++i2;
                            }
                            Core.print("Alpha:     " + pic.alpha[0] + ", " + pic.alpha[1] + ", " + pic.alpha[2] + ", " + pic.alpha[3] + "\n");
                            break;
                        }
                        case 5: {
                            int xOfs = ToolBox.getByte(ctrlHeader, index) << 4 | ToolBox.getByte(ctrlHeader, index + 1) >> 4;
                            pic.setOfsX(this.ofsXglob + xOfs);
                            pic.setImageWidth(((ToolBox.getByte(ctrlHeader, index + 1) & 0xF) << 8 | ToolBox.getByte(ctrlHeader, index + 2)) - xOfs + 1);
                            int yOfs = ToolBox.getByte(ctrlHeader, index + 3) << 4 | ToolBox.getByte(ctrlHeader, index + 4) >> 4;
                            pic.setOfsY(this.ofsYglob + yOfs);
                            pic.setImageHeight(((ToolBox.getByte(ctrlHeader, index + 4) & 0xF) << 8 | ToolBox.getByte(ctrlHeader, index + 5)) - yOfs + 1);
                            Core.print("Area info: (" + pic.getOfsX() + ", " + pic.getOfsY() + ") - (" + (pic.getOfsX() + pic.getImageWidth() - 1) + ", " + (pic.getOfsY() + pic.getImageHeight() - 1) + ")\n");
                            index += 6;
                            break;
                        }
                        case 6: {
                            pic.evenOfs = ToolBox.getWord(ctrlHeader, index) - 4;
                            pic.oddOfs = ToolBox.getWord(ctrlHeader, index + 2) - 4;
                            index += 4;
                            Core.print("RLE ofs:   " + ToolBox.hex(pic.evenOfs, 4) + ", " + ToolBox.hex(pic.oddOfs, 4) + "\n");
                            break;
                        }
                        case 7: {
                            ColAlphaUpdate = true;
                            int alphaUpdateSum = 0;
                            int b = ToolBox.getByte(ctrlHeader, index + 10);
                            alphaUpdate[3] = b >> 4;
                            alphaUpdate[2] = b & 0xF;
                            b = ToolBox.getByte(ctrlHeader, index + 11);
                            alphaUpdate[1] = b >> 4;
                            alphaUpdate[0] = b & 0xF;
                            int i3 = 0;
                            while (i3 < 4) {
                                alphaUpdateSum += alphaUpdate[i3] & 0xFF;
                                ++i3;
                            }
                            if (alphaUpdateSum > alphaSum) {
                                alphaSum = alphaUpdateSum;
                                i3 = 0;
                                while (i3 < 4) {
                                    pic.alpha[i3] = alphaUpdate[i3];
                                    ++i3;
                                }
                                b = ToolBox.getByte(ctrlHeader, index + 8);
                                pic.pal[3] = b >> 4;
                                pic.pal[2] = b & 0xF;
                                b = ToolBox.getByte(ctrlHeader, index + 9);
                                pic.pal[1] = b >> 4;
                                pic.pal[0] = b & 0xF;
                            }
                            index = endSeqOfs;
                            delay = ToolBox.getWord(ctrlHeader, index) * 1024;
                            endSeqOfs = ToolBox.getWord(ctrlHeader, index + 2) - ctrlOfsRel - 2;
                            if (endSeqOfs < 0 || endSeqOfs > ctrlSize) {
                                Core.printWarn("Invalid end sequence offset -> no end time\n");
                                endSeqOfs = ctrlSize;
                            }
                            index += 4;
                            break;
                        }
                        case 255: {
                            break block15;
                        }
                        default: {
                            Core.printWarn("Unknown control sequence " + ToolBox.hex(cmd, 2) + " skipped\n");
                        }
                    }
                }
                if (endSeqOfs != ctrlSize) {
                    index = endSeqOfs;
                    delay = ToolBox.getWord(ctrlHeader, index) * 1024;
                    pic.endTime = pic.startTime + (long)delay;
                } else {
                    pic.endTime = pic.startTime;
                }
                pic.setOriginal();
                if (ColAlphaUpdate) {
                    Core.printWarn("Palette update/alpha fading detected - result may be erratic.\n");
                }
                if (alphaSum == 0) {
                    if (Core.getFixZeroAlpha()) {
                        int i4 = 0;
                        while (i4 < 4) {
                            pic.alpha[i4] = lastAlpha[i4];
                            ++i4;
                        }
                        Core.printWarn("Invisible caption due to zero alpha - used alpha info of last caption.\n");
                    } else {
                        Core.printWarn("Invisible caption due to zero alpha (not fixed due to user setting).\n");
                    }
                }
                lastAlpha = pic.alpha;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new CoreException("Index " + ex.getMessage() + " out of bounds in control header.");
            }
            this.subPictures.add(pic);
            return startOfs + (long)length + 10L;
        }
        catch (FileBufferException ex) {
            throw new CoreException(ex.getMessage());
        }
    }

    static void writeIFO(String fname, SubPicture pic, Palette pal) throws CoreException {
        byte[] buf = new byte[6144];
        int index = 0;
        int vidAttr = pic.height == 480 ? 20225 : 24321;
        ToolBox.setString(buf, index, "DVDVIDEO-VTS");
        ToolBox.setDWord(buf, index + 18, 4);
        ToolBox.setDWord(buf, index + 28, 4);
        ToolBox.setDWord(buf, index + 128, 2047);
        ToolBox.setDWord(buf, index + 200, 1);
        ToolBox.setDWord(buf, index + 204, 2);
        ToolBox.setWord(buf, index + 256, vidAttr);
        ToolBox.setWord(buf, index + 512, vidAttr);
        String l = Core.getLanguages()[Core.getLanguageIdx()][1];
        ToolBox.setWord(buf, index + 596, 1);
        ToolBox.setByte(buf, index + 598, 1);
        ToolBox.setByte(buf, index + 600, (byte)l.charAt(0));
        ToolBox.setByte(buf, index + 601, (byte)l.charAt(1));
        index = 2048;
        ToolBox.setWord(buf, index, 1);
        ToolBox.setWord(buf, index + 4, 15);
        ToolBox.setDWord(buf, index + 4, 12);
        ToolBox.setWord(buf, index + 12, 1);
        ToolBox.setWord(buf, index + 14, 1);
        index = 4096;
        ToolBox.setWord(buf, index, 1);
        ToolBox.setDWord(buf, index + 4, 281);
        ToolBox.setDWord(buf, index + 8, -2130706432);
        ToolBox.setDWord(buf, index + 12, 16);
        index = 4112;
        ToolBox.setByte(buf, index + 2, 1);
        ToolBox.setByte(buf, index + 3, 1);
        int i = 0;
        while (i < 16) {
            int[] ycbcr = pal.getYCbCr(i);
            ToolBox.setByte(buf, index + 164 + 4 * i + 1, ycbcr[0]);
            ToolBox.setByte(buf, index + 164 + 4 * i + 2, ycbcr[1]);
            ToolBox.setByte(buf, index + 164 + 4 * i + 3, ycbcr[2]);
            ++i;
        }
        FilterOutputStream out = null;
        try {
            try {
                out = new BufferedOutputStream(new FileOutputStream(fname));
                out.write(buf);
            }
            catch (IOException ex) {
                throw new CoreException(ex.getMessage());
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    void readIFO(String fname) throws CoreException {
        try {
            FileBuffer buf = new FileBuffer(fname);
            byte[] header = new byte[IFOheader.length];
            buf.getBytes(0L, header, IFOheader.length);
            int i = 0;
            while (i < IFOheader.length) {
                if (header[i] != IFOheader[i]) {
                    throw new CoreException("Not a valid IFO file.");
                }
                ++i;
            }
            int vidAttr = buf.getWord(512L);
            if ((vidAttr & 0x3000) != 0) {
                switch (vidAttr >> 2 & 3) {
                    case 0: {
                        this.screenWidth = 720;
                        this.screenHeight = 576;
                        break;
                    }
                    case 1: {
                        this.screenWidth = 704;
                        this.screenHeight = 576;
                        break;
                    }
                    case 2: {
                        this.screenWidth = 352;
                        this.screenHeight = 576;
                        break;
                    }
                    case 3: {
                        this.screenWidth = 352;
                        this.screenHeight = 288;
                    }
                }
            } else {
                switch (vidAttr >> 2 & 3) {
                    case 0: {
                        this.screenWidth = 720;
                        this.screenHeight = 480;
                        break;
                    }
                    case 1: {
                        this.screenWidth = 704;
                        this.screenHeight = 480;
                        break;
                    }
                    case 2: {
                        this.screenWidth = 352;
                        this.screenHeight = 480;
                        break;
                    }
                    case 3: {
                        this.screenWidth = 352;
                        this.screenHeight = 240;
                    }
                }
            }
            Core.print("Resolution: " + this.screenWidth + "x" + this.screenHeight + "\n");
            long VTS_PGCITI_ofs = buf.getDWord(204L) * 2048;
            if (buf.getWord(596L) > 0 && buf.getByte(598L) == 1) {
                StringBuffer langSB = new StringBuffer(2);
                boolean found = false;
                langSB.append((char)buf.getByte(600L));
                langSB.append((char)buf.getByte(601L));
                String lang = langSB.toString();
                int i2 = 0;
                while (i2 < Core.getLanguages().length) {
                    if (lang.equalsIgnoreCase(Core.getLanguages()[i2][1])) {
                        this.languageIdx = i2;
                        found = true;
                        break;
                    }
                    ++i2;
                }
                if (!found) {
                    Core.printWarn("Illegal language id: " + lang + "\n");
                } else {
                    Core.print("Set language to: " + lang + "\n");
                }
            } else {
                Core.printWarn("Missing language id.\n");
            }
            VTS_PGCITI_ofs += (long)buf.getDWord(VTS_PGCITI_ofs + 12L);
            Core.print("Reading palette from offset: " + ToolBox.hex(VTS_PGCITI_ofs, 8) + "\n");
            long index = VTS_PGCITI_ofs;
            int i3 = 0;
            while (i3 < 16) {
                int y = buf.getByte(index + 164L + (long)(4 * i3) + 1L) & 0xFF;
                int cb = buf.getByte(index + 164L + (long)(4 * i3) + 2L) & 0xFF;
                int cr = buf.getByte(index + 164L + (long)(4 * i3) + 3L) & 0xFF;
                this.srcPalette.setYCbCr(i3, y, cb, cr);
                ++i3;
            }
        }
        catch (FileBufferException e) {
            throw new CoreException(e.getMessage());
        }
    }

    private void decode(SubPictureDVD pic) throws CoreException {
        this.palette = SubDVD.decodePalette(pic, this.srcPalette);
        this.bitmap = SubDVD.decodeImage(pic, this.buffer, this.palette.getTransparentIndex());
        BitmapBounds bounds = this.bitmap.getBounds(this.palette, Core.getAlphaCrop());
        if (bounds.yMin > 0 || bounds.xMin > 0 || bounds.xMax < this.bitmap.getWidth() - 1 || bounds.yMax < this.bitmap.getHeight() - 1) {
            int w = bounds.xMax - bounds.xMin + 1;
            int h = bounds.yMax - bounds.yMin + 1;
            if (w < 2) {
                w = 2;
            }
            if (h < 2) {
                h = 2;
            }
            this.bitmap = this.bitmap.crop(bounds.xMin, bounds.yMin, w, h);
            pic.setImageWidth(w);
            pic.setImageHeight(h);
            pic.setOfsX(pic.originalX + bounds.xMin);
            pic.setOfsY(pic.originalY + bounds.yMin);
        }
        this.primaryColorIndex = this.bitmap.getPrimaryColorIndex(this.palette, Core.getAlphaThr());
    }

    @Override
    public void decode(int index) throws CoreException {
        if (index >= this.subPictures.size()) {
            throw new CoreException("Index " + index + " out of bounds\n");
        }
        this.decode(this.subPictures.get(index));
    }

    @Override
    public int[] getFramePal(int index) {
        return this.subPictures.get((int)index).pal;
    }

    @Override
    public int[] getOriginalFramePal(int index) {
        return this.subPictures.get((int)index).originalPal;
    }

    @Override
    public int[] getFrameAlpha(int index) {
        return this.subPictures.get((int)index).alpha;
    }

    @Override
    public int[] getOriginalFrameAlpha(int index) {
        return this.subPictures.get((int)index).originalAlpha;
    }

    @Override
    public BufferedImage getImage(Bitmap bm) {
        return bm.getImage(this.palette);
    }

    @Override
    public Palette getPalette() {
        return this.palette;
    }

    @Override
    public Bitmap getBitmap() {
        return this.bitmap;
    }

    @Override
    public BufferedImage getImage() {
        return this.bitmap.getImage(this.palette);
    }

    @Override
    public int getPrimaryColorIndex() {
        return this.primaryColorIndex;
    }

    @Override
    public SubPicture getSubPicture(int index) {
        return this.subPictures.get(index);
    }

    @Override
    public int getNumFrames() {
        return this.subPictures.size();
    }

    @Override
    public int getNumForcedFrames() {
        return this.numForcedFrames;
    }

    @Override
    public boolean isForced(int index) {
        return this.subPictures.get((int)index).isforced;
    }

    @Override
    public void close() {
        if (this.buffer != null) {
            this.buffer.close();
        }
    }

    @Override
    public long getEndTime(int index) {
        return this.subPictures.get((int)index).endTime;
    }

    @Override
    public long getStartTime(int index) {
        return this.subPictures.get((int)index).startTime;
    }

    @Override
    public long getStartOffset(int index) {
        return this.subPictures.get((int)index).offset;
    }

    @Override
    public int getLanguageIdx() {
        return this.languageIdx;
    }

    @Override
    public Palette getSrcPalette() {
        return this.srcPalette;
    }

    @Override
    public void setSrcPalette(Palette pal) {
        this.srcPalette = pal;
    }
}

