/*
 * Decompiled with CFR 0.152.
 */
package deadbeef.GUI;

import deadbeef.SupTools.Core;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class Progress
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JButton jButtonCancel = null;
    private JProgressBar jProgressBar = null;
    private JLabel jLabelProgress = null;
    private Timer timer;

    public Progress(Frame owner, boolean modal) {
        super(owner, modal);
        this.initialize();
        Point p = owner.getLocation();
        this.setLocation(p.x + owner.getWidth() / 2 - this.getWidth() / 2, p.y + owner.getHeight() / 2 - this.getHeight() / 2);
        this.setResizable(false);
        this.jProgressBar.setMaximum(100);
        this.jProgressBar.setMinimum(0);
        this.jProgressBar.setValue(0);
    }

    @Override
    public void setVisible(boolean b) {
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new progressTimer(), 200L, 200L);
        super.setVisible(b);
    }

    public void setText(String s) {
        this.jLabelProgress.setText(s);
    }

    private void initialize() {
        this.setMinimumSize(new Dimension(224, 139));
        this.setResizable(false);
        this.setBounds(new Rectangle(0, 0, 224, 139));
        this.setMaximumSize(new Dimension(224, 139));
        this.setContentPane(this.getJContentPane());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Core.cancel();
            }
        });
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagBtnCancel = new GridBagConstraints();
            gridBagBtnCancel.insets = new Insets(8, 8, 8, 8);
            gridBagBtnCancel.gridx = 0;
            gridBagBtnCancel.gridy = 2;
            GridBagConstraints gridBagProgressBar = new GridBagConstraints();
            gridBagProgressBar.gridy = 1;
            gridBagProgressBar.fill = 3;
            gridBagProgressBar.insets = new Insets(8, 8, 8, 8);
            gridBagProgressBar.gridx = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 3;
            gridBagConstraints.insets = new Insets(8, 8, 8, 8);
            gridBagConstraints.gridy = 0;
            this.jLabelProgress = new JLabel();
            this.jLabelProgress.setText("Exporting SUB/IDX");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.jLabelProgress, gridBagConstraints);
            this.jContentPane.add((Component)this.getJProgressBar(), gridBagProgressBar);
            this.jContentPane.add((Component)this.getJButtonCancel(), gridBagBtnCancel);
        }
        return this.jContentPane;
    }

    private JButton getJButtonCancel() {
        if (this.jButtonCancel == null) {
            this.jButtonCancel = new JButton();
            this.jButtonCancel.setText("Cancel");
            this.jButtonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Core.cancel();
                }
            });
        }
        return this.jButtonCancel;
    }

    private JProgressBar getJProgressBar() {
        if (this.jProgressBar == null) {
            this.jProgressBar = new JProgressBar();
            this.jProgressBar.setPreferredSize(new Dimension(200, 20));
            this.jProgressBar.setMinimumSize(new Dimension(200, 20));
            this.jProgressBar.setStringPainted(true);
        }
        return this.jProgressBar;
    }

    public void setMinMax(int min, int max) {
        this.jProgressBar.setMinimum(min);
        this.jProgressBar.setMaximum(max);
    }

    public void setProgress(final int val) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Progress.this.jProgressBar.setValue(val);
                    Progress.this.jProgressBar.repaint();
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    class progressTimer
    extends TimerTask {
        progressTimer() {
        }

        @Override
        public void run() {
            if (Core.getStatus() != Core.State.ACTIVE) {
                Progress.this.timer.cancel();
                Progress.this.dispose();
            }
        }
    }
}

