MACRO(checkVpxDec)
		OPTION(VPXDEC "" ON)

		MESSAGE(STATUS "Checking for Vpx (decoding)")
		MESSAGE(STATUS "***************************")

		IF(VPXDEC)
            PKG_CHECK_MODULES(VPX vpx)
            IF(VPX_FOUND)
              PRINT_LIBRARY_INFO("VPX" VPX_FOUND "${VPX_INCLUDEDIR}" "${VPX_LDFLAGS}")
			  ADM_CHECK_FUNCTION_EXISTS(vpx_codec_dec_init_ver "${VPX_LDFLAGS}" VPX_DEC_INIT_FOUND "" "-I${VPX_INCLUDEDIR}")
                        IF(VPX_DEC_INIT_FOUND)
                                SET(USE_VPX_DEC 1)
		                        MESSAGE(STATUS "Linking to vpx decoder library ")
                        ENDIF()
            ENDIF()
		ELSE()
			MESSAGE("${MSG_DISABLE_OPTION}")
		ENDIF()
		MESSAGE("")

		APPEND_SUMMARY_LIST("Video Decoder" "libvpx" "${USE_VPX_DEC}")
ENDMACRO()

MACRO(checkVpxEnc)
    OPTION(VPXENC "" ON)

    MESSAGE(STATUS "Checking for Vpx encoding capability")
    MESSAGE(STATUS "*****************")
    IF(VPXENC)
            PKG_CHECK_MODULES(VPX vpx)
            IF(VPX_FOUND)
              PRINT_LIBRARY_INFO("VPX" VPX_FOUND "${VPX_INCLUDEDIR}" "${VPX_LDFLAGS}")
			  ADM_CHECK_FUNCTION_EXISTS(vpx_codec_enc_init_ver "${VPX_LDFLAGS}" VPX_ENC_INIT_FOUND "" "-I${VPX_INCLUDEDIR}")
                        IF(VPX_ENC_INIT_FOUND)
                                SET(USE_VP9_ENC 1)
                                SET(VPX_ENC_LIBRARY_DIR "${VPX_LDFLAGS}")
                                SET(VPX_ENC_INCLUDE_DIR "${VPX_INCLUDEDIR}")
		                        MESSAGE(STATUS "Linking to vpx encoder library ")
                        ENDIF()
            ENDIF()
     ELSE()
         MESSAGE("${MSG_DISABLE_OPTION}")
     ENDIF()
     MESSAGE("")

    APPEND_SUMMARY_LIST("Video Encoder" "libvpx" "${USE_VP9_ENC}")
ENDMACRO()
